/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalPattern
extends Pattern {
    private Expression[] conditions;
    private Pattern[] patterns;

    public ConditionalPattern(Expression[] conditions, Pattern[] patterns) {
        this.conditions = conditions;
        this.patterns = patterns;
    }

    @Override
    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i] = visitor.simplify(this.conditions[i]);
            this.patterns[i] = this.patterns[i].simplify(visitor);
        }
        return this;
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i] = visitor.typeCheck(this.conditions[i], contextItemType);
            this.patterns[i] = this.patterns[i].analyze(visitor, contextItemType);
        }
        return this;
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i] = this.conditions[i].promote(offer, parent);
            this.patterns[i].promote(offer, parent);
        }
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int i = 0; i < this.conditions.length; ++i) {
            found |= this.conditions[i].replaceOperand(original, replacement);
            found |= this.patterns[i].replaceSubExpression(original, replacement);
        }
        return found;
    }

    @Override
    public void setOriginalText(String pattern) {
        super.setOriginalText(pattern);
        for (int i = 0; i < this.conditions.length; ++i) {
            this.patterns[i].setOriginalText(pattern);
        }
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        for (int i = 0; i < this.conditions.length; ++i) {
            nextFree = ExpressionTool.allocateSlots(this.conditions[i], nextFree, slotManager);
            nextFree = this.patterns[i].allocateSlots(slotManager, nextFree);
        }
        return nextFree;
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean b = this.conditions[i].effectiveBooleanValue(context);
            if (!b) continue;
            return this.patterns[i].matches(item, context);
        }
        return false;
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        XPathContextMajor c2 = context.newContext();
        ManualIterator iter = new ManualIterator(anchor);
        c2.setCurrentIterator(iter);
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean b = this.conditions[i].effectiveBooleanValue(c2);
            if (!b) continue;
            return this.patterns[i].matchesBeneathAnchor(node, anchor, context);
        }
        return false;
    }

    @Override
    public int getNodeKind() {
        int type = this.patterns[0].getNodeKind();
        for (int i = 1; i < this.patterns.length; ++i) {
            int p = this.patterns[i].getNodeKind();
            if (p == type) continue;
            return 0;
        }
        return type;
    }

    @Override
    public int getNodeKindMask() {
        int mask = this.patterns[0].getNodeKindMask();
        for (int i = 1; i < this.patterns.length; ++i) {
            mask |= this.patterns[i].getNodeKindMask();
        }
        return mask;
    }

    @Override
    public ItemType getItemType() {
        int nodeType = this.getNodeKind();
        if (nodeType == 0) {
            return AnyNodeTest.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(nodeType);
    }

    @Override
    public int getDependencies() {
        int d = 0;
        for (int i = 0; i < this.conditions.length; ++i) {
            d |= this.conditions[i].getDependencies();
            d |= this.patterns[i].getDependencies();
        }
        return d;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(this.conditions.length * 2);
        for (int i = 0; i < this.conditions.length; i += 2) {
            for (Operand o : this.conditions[i].operands()) {
                list.add(o.getExpression());
            }
            Iterator<Expression> iter = this.patterns[i].iterateSubExpressions();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list.iterator();
    }

    @Override
    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        for (int i = 0; i < this.conditions.length; i += 2) {
            this.patterns[i].setSystemId(systemId);
        }
    }

    @Override
    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
        for (int i = 0; i < this.conditions.length; i += 2) {
            this.patterns[i].setLineNumber(lineNumber);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ConditionalPattern) {
            return Arrays.equals(this.conditions, ((ConditionalPattern)other).conditions) && Arrays.equals(this.patterns, ((ConditionalPattern)other).patterns);
        }
        return false;
    }

    public int hashCode() {
        int h = -2090102112;
        for (int i = 0; i < this.conditions.length; i += 2) {
            h ^= this.patterns[i].hashCode() ^ this.conditions[i].hashCode();
        }
        return h;
    }
}

