/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaDeclaration;

public class NodeTestPattern
extends Pattern {
    private NodeTest nodeTest;
    private int nodeKindMask;

    public NodeTestPattern(NodeTest test) {
        this.nodeTest = test;
        this.nodeKindMask = this.nodeTest.getNodeKindMask();
        this.setPriority(test.getDefaultPriority());
    }

    public boolean matches(Item item, XPathContext context) {
        return this.nodeTest.matches(item, context);
    }

    public NodeTest getItemType() {
        return this.nodeTest;
    }

    public int getNodeKind() {
        return this.nodeTest.getPrimitiveType();
    }

    public int getNodeKindMask() {
        return this.nodeKindMask;
    }

    public int getFingerprint() {
        return this.nodeTest.getFingerprint();
    }

    public String toString() {
        return this.nodeTest.toString();
    }

    public boolean equals(Object other) {
        return other instanceof NodeTestPattern && ((NodeTestPattern)other).nodeTest.equals(this.nodeTest);
    }

    public int hashCode() {
        return 0x7AEFFEA8 ^ this.nodeTest.hashCode();
    }

    public Pattern convertToTypedPattern(String val) throws XPathException {
        if (this.nodeTest instanceof NameTest && ((NameTest)this.nodeTest).getNodeKind() == 1) {
            SchemaDeclaration decl = this.getPackageData().getConfiguration().getElementDeclaration(this.nodeTest.getFingerprint());
            if (decl == null) {
                if ("lax".equals(val)) {
                    return this;
                }
                throw new XPathException("The mode specifies typed='strict', but there is no schema element declaration named " + this.nodeTest.toString(), "XTSE3105");
            }
            NodeTest schemaNodeTest = decl.makeSchemaNodeTest();
            return new NodeTestPattern(schemaNodeTest);
        }
        return this;
    }
}

