/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ObjectValue;

public class JavaExternalObjectType
extends ExternalObjectType
implements ItemType {
    public static JavaExternalObjectType EXTERNAL_OBJECT_TYPE = new JavaExternalObjectType(Object.class);
    private Class javaClass;

    public JavaExternalObjectType(Class javaClass) {
        this.javaClass = javaClass;
    }

    public JavaExternalObjectType(Class javaClass, Configuration config) {
        this(javaClass);
    }

    public String getName() {
        return this.javaClass.getName();
    }

    public String getTargetNamespace() {
        return "http://saxon.sf.net/java-type";
    }

    public boolean isExternalType() {
        return true;
    }

    public StructuredQName getTypeName() {
        return JavaExternalObjectType.classNameToQName(this.javaClass.getName());
    }

    public ItemType getPrimitiveItemType() {
        return EXTERNAL_OBJECT_TYPE;
    }

    public int getPrimitiveType() {
        return 632;
    }

    public AtomicType getAtomizedItemType() {
        return BuiltInAtomicType.STRING;
    }

    public boolean isAtomizable() {
        return true;
    }

    public int getRelationship(JavaExternalObjectType other) {
        Class j2 = other.javaClass;
        if (this.javaClass.equals(j2)) {
            return 0;
        }
        if (this.javaClass.isAssignableFrom(j2)) {
            return 1;
        }
        if (j2.isAssignableFrom(this.javaClass)) {
            return 2;
        }
        if (this.javaClass.isInterface() || j2.isInterface()) {
            return 3;
        }
        return 4;
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public boolean isAtomicType() {
        return false;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public boolean matches(Item item, XPathContext context) {
        if (item instanceof ObjectValue) {
            Object obj = ((ObjectValue)item).getObject();
            return this.javaClass.isAssignableFrom(obj.getClass());
        }
        return false;
    }

    public boolean matchesItem(Item item, boolean allowURIPromotion, Configuration config) {
        if (item instanceof ObjectValue) {
            Object obj = ((ObjectValue)item).getObject();
            return this.javaClass.isAssignableFrom(obj.getClass());
        }
        return false;
    }

    public ItemType getSuperType(TypeHierarchy th) {
        if (this.javaClass == Object.class) {
            return AnyItemType.getInstance();
        }
        Class javaSuper = this.javaClass.getSuperclass();
        if (javaSuper == null) {
            return EXTERNAL_OBJECT_TYPE;
        }
        return new JavaExternalObjectType(javaSuper);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return "java-type:" + this.javaClass.getName();
    }

    public double getDefaultPriority() {
        return 0.0;
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
    }

    public int hashCode() {
        return this.javaClass.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaExternalObjectType && this.javaClass == ((JavaExternalObjectType)obj).javaClass;
    }

    public static String classNameToLocalName(String className) {
        return className.replace('$', '-').replace("[", "_-");
    }

    public static String localNameToClassName(String className) {
        FastStringBuffer fsb = new FastStringBuffer(className.length());
        boolean atStart = true;
        for (int i = 0; i < className.length(); ++i) {
            char c = className.charAt(i);
            if (atStart) {
                if (c == '_' && i + 1 < className.length() && className.charAt(i + 1) == '-') {
                    fsb.append('[');
                    ++i;
                    continue;
                }
                atStart = false;
                fsb.append(c == '-' ? (char)'$' : (char)c);
                continue;
            }
            fsb.append(c == '-' ? (char)'$' : (char)c);
        }
        return fsb.toString();
    }

    public static StructuredQName classNameToQName(String className) {
        return new StructuredQName("jt", "http://saxon.sf.net/java-type", JavaExternalObjectType.classNameToLocalName(className));
    }
}

