/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.SecureXMLUtil;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureManifestParser;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DigestParser
extends DefaultHandler {
    private SAXParser parser;
    private final List<Feature> features = new ArrayList<Feature>();
    private final FeatureManifestParser featureHandler = new FeatureManifestParser(false);

    public DigestParser() {
        try {
            SAXParserFactory parserFactory = SecureXMLUtil.newSecureSAXParserFactory();
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.featureHandler.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("digest".equals(localName)) {
            return;
        }
        if ("feature".equals(localName)) {
            Feature feature = this.featureHandler.getResult();
            this.features.add(feature);
        } else {
            this.featureHandler.endElement(uri, localName, qName);
        }
    }

    public Feature[] parse(File localFile, URI location) {
        block33: {
            Feature[] featureArray;
            if (!localFile.exists()) {
                return null;
            }
            if (location == null) {
                location = localFile.toURI();
            }
            JarFile jar = null;
            InputStream is = null;
            try {
                jar = new JarFile(localFile);
                JarEntry entry = jar.getJarEntry("digest.xml");
                if (entry == null) {
                    return null;
                }
                is = new BufferedInputStream(jar.getInputStream(entry));
                this.parser.parse(new InputSource(is), (DefaultHandler)this);
                featureArray = this.features.toArray(new Feature[this.features.size()]);
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.ErrorReadingDigest, (Object)location), (Throwable)e));
                break block33;
            }
            catch (SAXException e) {
                LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.ErrorReadingDigest, (Object)location), (Throwable)e));
                break block33;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (jar != null) {
                        jar.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return featureArray;
        }
        return null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("digest".equals(localName)) {
            return;
        }
        this.featureHandler.startElement(uri, localName, qName, attributes);
    }
}

