// Copyright 2019 The Wuffs Authors.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// https://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or https://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.
//
// SPDX-License-Identifier: Apache-2.0 OR MIT

//go:build ignore
// +build ignore

package main

// gen.go generates data.go.
//
// Invoke it via "go generate".

import (
	"bytes"
	"fmt"
	"go/format"
	"os"
)

func main() {
	if err := main1(); err != nil {
		os.Stderr.WriteString(err.Error() + "\n")
		os.Exit(1)
	}
}

func main1() error {
	src, err := os.ReadFile("main.go")
	if err != nil {
		return err
	}

	if i := bytes.Index(src, []byte("ractool manipulates ")); i < 0 {
		return fmt.Errorf(`couldn't find documentation sub-string`)
	} else {
		src = src[i:]
	}
	if j := bytes.Index(src, []byte("*/")); j < 0 {
		return fmt.Errorf(`couldn't find documentation sub-string`)
	} else {
		src = src[:j]
	}

	out := []byte(`
// Code generated by running "go generate". DO NOT EDIT.

// Copyright 2019 The Wuffs Authors.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// https://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or https://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.
//
// SPDX-License-Identifier: Apache-2.0 OR MIT

package main

const usageStr = ` + "`")

	out = append(out, src...)
	out = append(out, '`')

	formatted, err := format.Source(out)
	if err != nil {
		return err
	}
	return os.WriteFile("data.go", formatted, 0644)
}
