/*
    SPDX-FileCopyrightText: 2019 Lars Maier <lars.maier@tefax.net>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_CRC64BYTEARRAYCHECKSUMPARAMETERSETEDIT_HPP
#define KASTEN_CRC64BYTEARRAYCHECKSUMPARAMETERSETEDIT_HPP

// lib
#include "abstractbytearraychecksumparametersetedit.hpp"

class KComboBox;

class Crc64ByteArrayChecksumParameterSetEdit : public AbstractByteArrayChecksumParameterSetEdit
{
    Q_OBJECT

public:
    static constexpr char Id[] = "Crc64";

public:
    explicit Crc64ByteArrayChecksumParameterSetEdit(QWidget* parent = nullptr);
    ~Crc64ByteArrayChecksumParameterSetEdit() override;

public: // AbstractByteArrayFilterParameterSetEdit API
    void setParameterSet(const AbstractByteArrayChecksumParameterSet* parameterSet) override;
    void getParameterSet(AbstractByteArrayChecksumParameterSet* parameterSet) const override;
    [[nodiscard]]
    bool isValid() const override;

private:
    KComboBox* mVariantComboBox;
};

#endif
