/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.SortKey;
import org.apache.harmony.security.asn1.ASN1Boolean;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1OctetString;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.ASN1Type;

public final class SortControl
extends BasicControl {
    static ASN1Sequence ASN1_SORTKEY = new ASN1Sequence(new ASN1Type[]{ASN1OctetString.getInstance(), new ASN1Implicit(0, (ASN1Type)ASN1StringType.UTF8STRING), new ASN1Implicit(1, (ASN1Type)ASN1Boolean.getInstance())}){
        {
            this.setOptional(1);
            this.setDefault(Boolean.FALSE, 2);
        }

        public void getValues(Object object, Object[] values) {
            SortKey sk = (SortKey)object;
            try {
                values[0] = sk.getAttributeID().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                values[0] = sk.getAttributeID().getBytes();
            }
            values[1] = sk.getMatchingRuleID();
            values[2] = !sk.isAscending();
        }
    };
    static ASN1SequenceOf ASN1_SORTKEYLIST = new ASN1SequenceOf((ASN1Type)ASN1_SORTKEY);
    private static final long serialVersionUID = -1965961680233330744L;
    public static final String OID = "1.2.840.113556.1.4.473";

    public SortControl(String sortBy, boolean criticality) throws IOException {
        super(OID, criticality, null);
        ArrayList<SortKey> list = new ArrayList<SortKey>();
        if (sortBy != null) {
            list.add(new SortKey(sortBy, true, null));
        } else {
            list.add(new SortKey("", true, null));
        }
        this.value = ASN1_SORTKEYLIST.encode(list);
    }

    public SortControl(String[] sortBy, boolean criticality) throws IOException {
        super(OID, criticality, null);
        ArrayList<SortKey> list = new ArrayList<SortKey>();
        int i = 0;
        while (i < sortBy.length) {
            if (sortBy[i] != null) {
                list.add(new SortKey(sortBy[i], true, null));
            } else {
                list.add(new SortKey("", true, null));
            }
            ++i;
        }
        this.value = ASN1_SORTKEYLIST.encode(list);
    }

    public SortControl(SortKey[] sortBy, boolean criticality) throws IOException {
        super(OID, criticality, null);
        ArrayList<SortKey> list = new ArrayList<SortKey>();
        int i = 0;
        while (i < sortBy.length) {
            list.add(sortBy[i]);
            ++i;
        }
        this.value = ASN1_SORTKEYLIST.encode(list);
    }
}

