/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.NamingManager;
import org.apache.harmony.jndi.internal.EnvironmentReader;
import org.apache.harmony.jndi.internal.UrlParser;
import org.apache.harmony.jndi.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialContext
implements Context {
    protected Context defaultInitCtx;
    protected boolean gotDefault;
    protected Hashtable<Object, Object> myProps;

    public InitialContext() throws NamingException {
        this(null);
    }

    public InitialContext(Hashtable<?, ?> environment) throws NamingException {
        this.internalInit(environment);
    }

    protected InitialContext(boolean doNotInit) throws NamingException {
        if (!doNotInit) {
            this.internalInit(null);
        }
    }

    private void internalInit(Hashtable<?, ?> env) throws NamingException {
        this.myProps = env == null ? new Hashtable() : (Hashtable)env.clone();
        EnvironmentReader.readAppletParameters(this.myProps.get("java.naming.applet"), this.myProps);
        EnvironmentReader.readSystemProperties(this.myProps);
        EnvironmentReader.readApplicationResourceFiles(this.myProps);
        EnvironmentReader.readLibraryResourceFile(this.myProps);
        if (this.myProps.containsKey("java.naming.factory.initial")) {
            this.getDefaultInitCtx();
        }
    }

    protected void init(Hashtable<?, ?> env) throws NamingException {
        this.internalInit(env);
    }

    private void initializeDefaultInitCtx() throws NamingException {
        if (!this.gotDefault) {
            this.defaultInitCtx = NamingManager.getInitialContext(this.myProps);
            if (this.defaultInitCtx == null) {
                throw new NoInitialContextException("Failed to create an initial context.");
            }
            this.gotDefault = true;
        }
    }

    protected Context getDefaultInitCtx() throws NamingException {
        this.initializeDefaultInitCtx();
        return this.defaultInitCtx;
    }

    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        if (name.size() > 0) {
            return this.getURLOrDefaultInitCtx(name.get(0));
        }
        return this.getDefaultInitCtx();
    }

    protected Context getURLOrDefaultInitCtx(String name) throws NamingException {
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.00"));
        }
        String scheme = UrlParser.getScheme(name);
        Context ctx = null;
        if (scheme != null) {
            ctx = NamingManager.getURLContext(scheme, this.myProps);
        }
        return ctx == null ? this.getDefaultInitCtx() : ctx;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookup(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookup(name);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.getURLOrDefaultInitCtx(oldName).rename(oldName, newName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.getURLOrDefaultInitCtx(oldName).rename(oldName, newName);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (name == null) {
            throw new NullPointerException();
        }
        return (Name)name.clone();
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return name;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        this.myProps.put(propName, propVal);
        return this.getDefaultInitCtx().addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        this.myProps.remove(propName);
        return this.getDefaultInitCtx().removeFromEnvironment(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.getDefaultInitCtx().getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        if (this.gotDefault) {
            this.getDefaultInitCtx().close();
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.getDefaultInitCtx().getNameInNamespace();
    }
}

