/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/coordination/v1"
	coordinationv1 "k8s.io/client-go/applyconfigurations/coordination/v1"
	gentype "k8s.io/client-go/gentype"
	typedcoordinationv1 "k8s.io/client-go/kubernetes/typed/coordination/v1"
)

// fakeLeases implements LeaseInterface
type fakeLeases struct {
	*gentype.FakeClientWithListAndApply[*v1.Lease, *v1.LeaseList, *coordinationv1.LeaseApplyConfiguration]
	Fake *FakeCoordinationV1
}

func newFakeLeases(fake *FakeCoordinationV1, namespace string) typedcoordinationv1.LeaseInterface {
	return &fakeLeases{
		gentype.NewFakeClientWithListAndApply[*v1.Lease, *v1.LeaseList, *coordinationv1.LeaseApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("leases"),
			v1.SchemeGroupVersion.WithKind("Lease"),
			func() *v1.Lease { return &v1.Lease{} },
			func() *v1.LeaseList { return &v1.LeaseList{} },
			func(dst, src *v1.LeaseList) { dst.ListMeta = src.ListMeta },
			func(list *v1.LeaseList) []*v1.Lease { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.LeaseList, items []*v1.Lease) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
