// generated by go run maketables.go; DO NOT EDIT

// Package traditionalchinese provides Traditional Chinese encodings such as Big5.
package traditionalchinese // import "golang.org/x/text/encoding/traditionalchinese"

// decode is the decoding table from Big5 code to Unicode.
// It is defined at http://encoding.spec.whatwg.org/index-big5.txt
var decode = [...]uint32{
	942:   0x000043F0,
	943:   0x00004C32,
	944:   0x00004603,
	945:   0x000045A6,
	946:   0x00004578,
	947:   0x00027267,
	948:   0x00004D77,
	949:   0x000045B3,
	950:   0x00027CB1,
	951:   0x00004CE2,
	952:   0x00027CC5,
	953:   0x00003B95,
	954:   0x00004736,
	955:   0x00004744,
	956:   0x00004C47,
	957:   0x00004C40,
	958:   0x000242BF,
	959:   0x00023617,
	960:   0x00027352,
	961:   0x00026E8B,
	962:   0x000270D2,
	963:   0x00004C57,
	964:   0x0002A351,
	965:   0x0000474F,
	966:   0x000045DA,
	967:   0x00004C85,
	968:   0x00027C6C,
	969:   0x00004D07,
	970:   0x00004AA4,
	971:   0x000046A1,
	972:   0x00026B23,
	973:   0x00007225,
	974:   0x00025A54,
	975:   0x00021A63,
	976:   0x00023E06,
	977:   0x00023F61,
	978:   0x0000664D,
	979:   0x000056FB,
	981:   0x00007D95,
	982:   0x0000591D,
	983:   0x00028BB9,
	984:   0x00003DF4,
	985:   0x00009734,
	986:   0x00027BEF,
	987:   0x00005BDB,
	988:   0x00021D5E,
	989:   0x00005AA4,
	990:   0x00003625,
	991:   0x00029EB0,
	992:   0x00005AD1,
	993:   0x00005BB7,
	994:   0x00005CFC,
	995:   0x0000676E,
	996:   0x00008593,
	997:   0x00029945,
	998:   0x00007461,
	999:   0x0000749D,
	1000:  0x00003875,
	1001:  0x00021D53,
	1002:  0x0002369E,
	1003:  0x00026021,
	1004:  0x00003EEC,
	1005:  0x000258DE,
	1006:  0x00003AF5,
	1007:  0x00007AFC,
	1008:  0x00009F97,
	1009:  0x00024161,
	1010:  0x0002890D,
	1011:  0x000231EA,
	1012:  0x00020A8A,
	1013:  0x0002325E,
	1014:  0x0000430A,
	1015:  0x00008484,
	1016:  0x00009F96,
	1017:  0x0000942F,
	1018:  0x00004930,
	1019:  0x00008613,
	1020:  0x00005896,
	1021:  0x0000974A,
	1022:  0x00009218,
	1023:  0x000079D0,
	1024:  0x00007A32,
	1025:  0x00006660,
	1026:  0x00006A29,
	1027:  0x0000889D,
	1028:  0x0000744C,
	1029:  0x00007BC5,
	1030:  0x00006782,
	1031:  0x00007A2C,
	1032:  0x0000524F,
	1033:  0x00009046,
	1034:  0x000034E6,
	1035:  0x000073C4,
	1036:  0x00025DB9,
	1037:  0x000074C6,
	1038:  0x00009FC7,
	1039:  0x000057B3,
	1040:  0x0000492F,
	1041:  0x0000544C,
	1042:  0x00004131,
	1043:  0x0002368E,
	1044:  0x00005818,
	1045:  0x00007A72,
	1046:  0x00027B65,
	1047:  0x00008B8F,
	1048:  0x000046AE,
	1049:  0x00026E88,
	1050:  0x00004181,
	1051:  0x00025D99,
	1052:  0x00007BAE,
	1053:  0x000224BC,
	1054:  0x00009FC8,
	1055:  0x000224C1,
	1056:  0x000224C9,
	1057:  0x000224CC,
	1058:  0x00009FC9,
	1059:  0x00008504,
	1060:  0x000235BB,
	1061:  0x000040B4,
	1062:  0x00009FCA,
	1063:  0x000044E1,
	1064:  0x0002ADFF,
	1065:  0x000062C1,
	1066:  0x0000706E,
	1067:  0x00009FCB,
	1099:  0x000031C0,
	1100:  0x000031C1,
	1101:  0x000031C2,
	1102:  0x000031C3,
	1103:  0x000031C4,
	1104:  0x0002010C,
	1105:  0x000031C5,
	1106:  0x000200D1,
	1107:  0x000200CD,
	1108:  0x000031C6,
	1109:  0x000031C7,
	1110:  0x000200CB,
	1111:  0x00021FE8,
	1112:  0x000031C8,
	1113:  0x000200CA,
	1114:  0x000031C9,
	1115:  0x000031CA,
	1116:  0x000031CB,
	1117:  0x000031CC,
	1118:  0x0002010E,
	1119:  0x000031CD,
	1120:  0x000031CE,
	1121:  0x00000100,
	1122:  0x000000C1,
	1123:  0x000001CD,
	1124:  0x000000C0,
	1125:  0x00000112,
	1126:  0x000000C9,
	1127:  0x0000011A,
	1128:  0x000000C8,
	1129:  0x0000014C,
	1130:  0x000000D3,
	1131:  0x000001D1,
	1132:  0x000000D2,
	1134:  0x00001EBE,
	1136:  0x00001EC0,
	1137:  0x000000CA,
	1138:  0x00000101,
	1139:  0x000000E1,
	1140:  0x000001CE,
	1141:  0x000000E0,
	1142:  0x00000251,
	1143:  0x00000113,
	1144:  0x000000E9,
	1145:  0x0000011B,
	1146:  0x000000E8,
	1147:  0x0000012B,
	1148:  0x000000ED,
	1149:  0x000001D0,
	1150:  0x000000EC,
	1151:  0x0000014D,
	1152:  0x000000F3,
	1153:  0x000001D2,
	1154:  0x000000F2,
	1155:  0x0000016B,
	1156:  0x000000FA,
	1157:  0x000001D4,
	1158:  0x000000F9,
	1159:  0x000001D6,
	1160:  0x000001D8,
	1161:  0x000001DA,
	1162:  0x000001DC,
	1163:  0x000000FC,
	1165:  0x00001EBF,
	1167:  0x00001EC1,
	1168:  0x000000EA,
	1169:  0x00000261,
	1170:  0x000023DA,
	1171:  0x000023DB,
	1256:  0x0002A3A9,
	1257:  0x00021145,
	1259:  0x0000650A,
	1262:  0x00004E3D,
	1263:  0x00006EDD,
	1264:  0x00009D4E,
	1265:  0x000091DF,
	1268:  0x00027735,
	1269:  0x00006491,
	1270:  0x00004F1A,
	1271:  0x00004F28,
	1272:  0x00004FA8,
	1273:  0x00005156,
	1274:  0x00005174,
	1275:  0x0000519C,
	1276:  0x000051E4,
	1277:  0x000052A1,
	1278:  0x000052A8,
	1279:  0x0000533B,
	1280:  0x0000534E,
	1281:  0x000053D1,
	1282:  0x000053D8,
	1283:  0x000056E2,
	1284:  0x000058F0,
	1285:  0x00005904,
	1286:  0x00005907,
	1287:  0x00005932,
	1288:  0x00005934,
	1289:  0x00005B66,
	1290:  0x00005B9E,
	1291:  0x00005B9F,
	1292:  0x00005C9A,
	1293:  0x00005E86,
	1294:  0x0000603B,
	1295:  0x00006589,
	1296:  0x000067FE,
	1297:  0x00006804,
	1298:  0x00006865,
	1299:  0x00006D4E,
	1300:  0x000070BC,
	1301:  0x00007535,
	1302:  0x00007EA4,
	1303:  0x00007EAC,
	1304:  0x00007EBA,
	1305:  0x00007EC7,
	1306:  0x00007ECF,
	1307:  0x00007EDF,
	1308:  0x00007F06,
	1309:  0x00007F37,
	1310:  0x0000827A,
	1311:  0x000082CF,
	1312:  0x0000836F,
	1313:  0x000089C6,
	1314:  0x00008BBE,
	1315:  0x00008BE2,
	1316:  0x00008F66,
	1317:  0x00008F67,
	1318:  0x00008F6E,
	1319:  0x00007411,
	1320:  0x00007CFC,
	1321:  0x00007DCD,
	1322:  0x00006946,
	1323:  0x00007AC9,
	1324:  0x00005227,
	1329:  0x0000918C,
	1330:  0x000078B8,
	1331:  0x0000915E,
	1332:  0x000080BC,
	1334:  0x00008D0B,
	1335:  0x000080F6,
	1336:  0x000209E7,
	1339:  0x0000809F,
	1340:  0x00009EC7,
	1341:  0x00004CCD,
	1342:  0x00009DC9,
	1343:  0x00009E0C,
	1344:  0x00004C3E,
	1345:  0x00029DF6,
	1346:  0x0002700E,
	1347:  0x00009E0A,
	1348:  0x0002A133,
	1349:  0x000035C1,
	1351:  0x00006E9A,
	1352:  0x0000823E,
	1353:  0x00007519,
	1355:  0x00004911,
	1356:  0x00009A6C,
	1357:  0x00009A8F,
	1358:  0x00009F99,
	1359:  0x00007987,
	1360:  0x0002846C,
	1361:  0x00021DCA,
	1362:  0x000205D0,
	1363:  0x00022AE6,
	1364:  0x00004E24,
	1365:  0x00004E81,
	1366:  0x00004E80,
	1367:  0x00004E87,
	1368:  0x00004EBF,
	1369:  0x00004EEB,
	1370:  0x00004F37,
	1371:  0x0000344C,
	1372:  0x00004FBD,
	1373:  0x00003E48,
	1374:  0x00005003,
	1375:  0x00005088,
	1376:  0x0000347D,
	1377:  0x00003493,
	1378:  0x000034A5,
	1379:  0x00005186,
	1380:  0x00005905,
	1381:  0x000051DB,
	1382:  0x000051FC,
	1383:  0x00005205,
	1384:  0x00004E89,
	1385:  0x00005279,
	1386:  0x00005290,
	1387:  0x00005327,
	1388:  0x000035C7,
	1389:  0x000053A9,
	1390:  0x00003551,
	1391:  0x000053B0,
	1392:  0x00003553,
	1393:  0x000053C2,
	1394:  0x00005423,
	1395:  0x0000356D,
	1396:  0x00003572,
	1397:  0x00003681,
	1398:  0x00005493,
	1399:  0x000054A3,
	1400:  0x000054B4,
	1401:  0x000054B9,
	1402:  0x000054D0,
	1403:  0x000054EF,
	1404:  0x00005518,
	1405:  0x00005523,
	1406:  0x00005528,
	1407:  0x00003598,
	1408:  0x0000553F,
	1409:  0x000035A5,
	1410:  0x000035BF,
	1411:  0x000055D7,
	1412:  0x000035C5,
	1413:  0x00027D84,
	1414:  0x00005525,
	1416:  0x00020C42,
	1417:  0x00020D15,
	1418:  0x0002512B,
	1419:  0x00005590,
	1420:  0x00022CC6,
	1421:  0x000039EC,
	1422:  0x00020341,
	1423:  0x00008E46,
	1424:  0x00024DB8,
	1425:  0x000294E5,
	1426:  0x00004053,
	1427:  0x000280BE,
	1428:  0x0000777A,
	1429:  0x00022C38,
	1430:  0x00003A34,
	1431:  0x000047D5,
	1432:  0x0002815D,
	1433:  0x000269F2,
	1434:  0x00024DEA,
	1435:  0x000064DD,
	1436:  0x00020D7C,
	1437:  0x00020FB4,
	1438:  0x00020CD5,
	1439:  0x000210F4,
	1440:  0x0000648D,
	1441:  0x00008E7E,
	1442:  0x00020E96,
	1443:  0x00020C0B,
	1444:  0x00020F64,
	1445:  0x00022CA9,
	1446:  0x00028256,
	1447:  0x000244D3,
	1449:  0x00020D46,
	1450:  0x00029A4D,
	1451:  0x000280E9,
	1452:  0x000047F4,
	1453:  0x00024EA7,
	1454:  0x00022CC2,
	1455:  0x00009AB2,
	1456:  0x00003A67,
	1457:  0x000295F4,
	1458:  0x00003FED,
	1459:  0x00003506,
	1460:  0x000252C7,
	1461:  0x000297D4,
	1462:  0x000278C8,
	1463:  0x00022D44,
	1464:  0x00009D6E,
	1465:  0x00009815,
	1467:  0x000043D9,
	1468:  0x000260A5,
	1469:  0x000064B4,
	1470:  0x000054E3,
	1471:  0x00022D4C,
	1472:  0x00022BCA,
	1473:  0x00021077,
	1474:  0x000039FB,
	1475:  0x0002106F,
	1476:  0x000266DA,
	1477:  0x00026716,
	1478:  0x000279A0,
	1479:  0x000064EA,
	1480:  0x00025052,
	1481:  0x00020C43,
	1482:  0x00008E68,
	1483:  0x000221A1,
	1484:  0x00028B4C,
	1485:  0x00020731,
	1487:  0x0000480B,
	1488:  0x000201A9,
	1489:  0x00003FFA,
	1490:  0x00005873,
	1491:  0x00022D8D,
	1493:  0x000245C8,
	1494:  0x000204FC,
	1495:  0x00026097,
	1496:  0x00020F4C,
	1497:  0x00020D96,
	1498:  0x00005579,
	1499:  0x000040BB,
	1500:  0x000043BA,
	1502:  0x00004AB4,
	1503:  0x00022A66,
	1504:  0x0002109D,
	1505:  0x000081AA,
	1506:  0x000098F5,
	1507:  0x00020D9C,
	1508:  0x00006379,
	1509:  0x000039FE,
	1510:  0x00022775,
	1511:  0x00008DC0,
	1512:  0x000056A1,
	1513:  0x0000647C,
	1514:  0x00003E43,
	1516:  0x0002A601,
	1517:  0x00020E09,
	1518:  0x00022ACF,
	1519:  0x00022CC9,
	1521:  0x000210C8,
	1522:  0x000239C2,
	1523:  0x00003992,
	1524:  0x00003A06,
	1525:  0x0002829B,
	1526:  0x00003578,
	1527:  0x00025E49,
	1528:  0x000220C7,
	1529:  0x00005652,
	1530:  0x00020F31,
	1531:  0x00022CB2,
	1532:  0x00029720,
	1533:  0x000034BC,
	1534:  0x00006C3D,
	1535:  0x00024E3B,
	1538:  0x00027574,
	1539:  0x00022E8B,
	1540:  0x00022208,
	1541:  0x0002A65B,
	1542:  0x00028CCD,
	1543:  0x00020E7A,
	1544:  0x00020C34,
	1545:  0x0002681C,
	1546:  0x00007F93,
	1547:  0x000210CF,
	1548:  0x00022803,
	1549:  0x00022939,
	1550:  0x000035FB,
	1551:  0x000251E3,
	1552:  0x00020E8C,
	1553:  0x00020F8D,
	1554:  0x00020EAA,
	1555:  0x00003F93,
	1556:  0x00020F30,
	1557:  0x00020D47,
	1558:  0x0002114F,
	1559:  0x00020E4C,
	1561:  0x00020EAB,
	1562:  0x00020BA9,
	1563:  0x00020D48,
	1564:  0x000210C0,
	1565:  0x0002113D,
	1566:  0x00003FF9,
	1567:  0x00022696,
	1568:  0x00006432,
	1569:  0x00020FAD,
	1570:  0x000233F4,
	1571:  0x00027639,
	1572:  0x00022BCE,
	1573:  0x00020D7E,
	1574:  0x00020D7F,
	1575:  0x00022C51,
	1576:  0x00022C55,
	1577:  0x00003A18,
	1578:  0x00020E98,
	1579:  0x000210C7,
	1580:  0x00020F2E,
	1581:  0x0002A632,
	1582:  0x00026B50,
	1583:  0x00028CD2,
	1584:  0x00028D99,
	1585:  0x00028CCA,
	1586:  0x000095AA,
	1587:  0x000054CC,
	1588:  0x000082C4,
	1589:  0x000055B9,
	1591:  0x00029EC3,
	1592:  0x00009C26,
	1593:  0x00009AB6,
	1594:  0x0002775E,
	1595:  0x00022DEE,
	1596:  0x00007140,
	1597:  0x0000816D,
	1598:  0x000080EC,
	1599:  0x00005C1C,
	1600:  0x00026572,
	1601:  0x00008134,
	1602:  0x00003797,
	1603:  0x0000535F,
	1604:  0x000280BD,
	1605:  0x000091B6,
	1606:  0x00020EFA,
	1607:  0x00020E0F,
	1608:  0x00020E77,
	1609:  0x00020EFB,
	1610:  0x000035DD,
	1611:  0x00024DEB,
	1612:  0x00003609,
	1613:  0x00020CD6,
	1614:  0x000056AF,
	1615:  0x000227B5,
	1616:  0x000210C9,
	1617:  0x00020E10,
	1618:  0x00020E78,
	1619:  0x00021078,
	1620:  0x00021148,
	1621:  0x00028207,
	1622:  0x00021455,
	1623:  0x00020E79,
	1624:  0x00024E50,
	1625:  0x00022DA4,
	1626:  0x00005A54,
	1627:  0x0002101D,
	1628:  0x0002101E,
	1629:  0x000210F5,
	1630:  0x000210F6,
	1631:  0x0000579C,
	1632:  0x00020E11,
	1633:  0x00027694,
	1634:  0x000282CD,
	1635:  0x00020FB5,
	1636:  0x00020E7B,
	1637:  0x0002517E,
	1638:  0x00003703,
	1639:  0x00020FB6,
	1640:  0x00021180,
	1641:  0x000252D8,
	1642:  0x0002A2BD,
	1643:  0x000249DA,
	1644:  0x0002183A,
	1645:  0x00024177,
	1646:  0x0002827C,
	1647:  0x00005899,
	1648:  0x00005268,
	1649:  0x0000361A,
	1650:  0x0002573D,
	1651:  0x00007BB2,
	1652:  0x00005B68,
	1653:  0x00004800,
	1654:  0x00004B2C,
	1655:  0x00009F27,
	1656:  0x000049E7,
	1657:  0x00009C1F,
	1658:  0x00009B8D,
	1659:  0x00025B74,
	1660:  0x0002313D,
	1661:  0x000055FB,
	1662:  0x000035F2,
	1663:  0x00005689,
	1664:  0x00004E28,
	1665:  0x00005902,
	1666:  0x00021BC1,
	1667:  0x0002F878,
	1668:  0x00009751,
	1669:  0x00020086,
	1670:  0x00004E5B,
	1671:  0x00004EBB,
	1672:  0x0000353E,
	1673:  0x00005C23,
	1674:  0x00005F51,
	1675:  0x00005FC4,
	1676:  0x000038FA,
	1677:  0x0000624C,
	1678:  0x00006535,
	1679:  0x00006B7A,
	1680:  0x00006C35,
	1681:  0x00006C3A,
	1682:  0x0000706C,
	1683:  0x0000722B,
	1684:  0x00004E2C,
	1685:  0x000072AD,
	1686:  0x000248E9,
	1687:  0x00007F52,
	1688:  0x0000793B,
	1689:  0x00007CF9,
	1690:  0x00007F53,
	1691:  0x0002626A,
	1692:  0x000034C1,
	1694:  0x0002634B,
	1695:  0x00008002,
	1696:  0x00008080,
	1697:  0x00026612,
	1698:  0x00026951,
	1699:  0x0000535D,
	1700:  0x00008864,
	1701:  0x000089C1,
	1702:  0x000278B2,
	1703:  0x00008BA0,
	1704:  0x00008D1D,
	1705:  0x00009485,
	1706:  0x00009578,
	1707:  0x0000957F,
	1708:  0x000095E8,
	1709:  0x00028E0F,
	1710:  0x000097E6,
	1711:  0x00009875,
	1712:  0x000098CE,
	1713:  0x000098DE,
	1714:  0x00009963,
	1715:  0x00029810,
	1716:  0x00009C7C,
	1717:  0x00009E1F,
	1718:  0x00009EC4,
	1719:  0x00006B6F,
	1720:  0x0000F907,
	1721:  0x00004E37,
	1722:  0x00020087,
	1723:  0x0000961D,
	1724:  0x00006237,
	1725:  0x000094A2,
	1727:  0x0000503B,
	1728:  0x00006DFE,
	1729:  0x00029C73,
	1730:  0x00009FA6,
	1731:  0x00003DC9,
	1732:  0x0000888F,
	1733:  0x0002414E,
	1734:  0x00007077,
	1735:  0x00005CF5,
	1736:  0x00004B20,
	1737:  0x000251CD,
	1738:  0x00003559,
	1739:  0x00025D30,
	1740:  0x00006122,
	1741:  0x00028A32,
	1742:  0x00008FA7,
	1743:  0x000091F6,
	1744:  0x00007191,
	1745:  0x00006719,
	1746:  0x000073BA,
	1747:  0x00023281,
	1748:  0x0002A107,
	1749:  0x00003C8B,
	1750:  0x00021980,
	1751:  0x00004B10,
	1752:  0x000078E4,
	1753:  0x00007402,
	1754:  0x000051AE,
	1755:  0x0002870F,
	1756:  0x00004009,
	1757:  0x00006A63,
	1758:  0x0002A2BA,
	1759:  0x00004223,
	1760:  0x0000860F,
	1761:  0x00020A6F,
	1762:  0x00007A2A,
	1763:  0x00029947,
	1764:  0x00028AEA,
	1765:  0x00009755,
	1766:  0x0000704D,
	1767:  0x00005324,
	1768:  0x0002207E,
	1769:  0x000093F4,
	1770:  0x000076D9,
	1771:  0x000289E3,
	1772:  0x00009FA7,
	1773:  0x000077DD,
	1774:  0x00004EA3,
	1775:  0x00004FF0,
	1776:  0x000050BC,
	1777:  0x00004E2F,
	1778:  0x00004F17,
	1779:  0x00009FA8,
	1780:  0x00005434,
	1781:  0x00007D8B,
	1782:  0x00005892,
	1783:  0x000058D0,
	1784:  0x00021DB6,
	1785:  0x00005E92,
	1786:  0x00005E99,
	1787:  0x00005FC2,
	1788:  0x00022712,
	1789:  0x0000658B,
	1790:  0x000233F9,
	1791:  0x00006919,
	1792:  0x00006A43,
	1793:  0x00023C63,
	1794:  0x00006CFF,
	1796:  0x00007200,
	1797:  0x00024505,
	1798:  0x0000738C,
	1799:  0x00003EDB,
	1800:  0x00024A13,
	1801:  0x00005B15,
	1802:  0x000074B9,
	1803:  0x00008B83,
	1804:  0x00025CA4,
	1805:  0x00025695,
	1806:  0x00007A93,
	1807:  0x00007BEC,
	1808:  0x00007CC3,
	1809:  0x00007E6C,
	1810:  0x000082F8,
	1811:  0x00008597,
	1812:  0x00009FA9,
	1813:  0x00008890,
	1814:  0x00009FAA,
	1815:  0x00008EB9,
	1816:  0x00009FAB,
	1817:  0x00008FCF,
	1818:  0x0000855F,
	1819:  0x000099E0,
	1820:  0x00009221,
	1821:  0x00009FAC,
	1822:  0x00028DB9,
	1823:  0x0002143F,
	1824:  0x00004071,
	1825:  0x000042A2,
	1826:  0x00005A1A,
	1830:  0x00009868,
	1831:  0x0000676B,
	1832:  0x00004276,
	1833:  0x0000573D,
	1835:  0x000085D6,
	1836:  0x0002497B,
	1837:  0x000082BF,
	1838:  0x0002710D,
	1839:  0x00004C81,
	1840:  0x00026D74,
	1841:  0x00005D7B,
	1842:  0x00026B15,
	1843:  0x00026FBE,
	1844:  0x00009FAD,
	1845:  0x00009FAE,
	1846:  0x00005B96,
	1847:  0x00009FAF,
	1848:  0x000066E7,
	1849:  0x00007E5B,
	1850:  0x00006E57,
	1851:  0x000079CA,
	1852:  0x00003D88,
	1853:  0x000044C3,
	1854:  0x00023256,
	1855:  0x00022796,
	1856:  0x0000439A,
	1857:  0x00004536,
	1859:  0x00005CD5,
	1860:  0x00023B1A,
	1861:  0x00008AF9,
	1862:  0x00005C78,
	1863:  0x00003D12,
	1864:  0x00023551,
	1865:  0x00005D78,
	1866:  0x00009FB2,
	1867:  0x00007157,
	1868:  0x00004558,
	1869:  0x000240EC,
	1870:  0x00021E23,
	1871:  0x00004C77,
	1872:  0x00003978,
	1873:  0x0000344A,
	1874:  0x000201A4,
	1875:  0x00026C41,
	1876:  0x00008ACC,
	1877:  0x00004FB4,
	1878:  0x00020239,
	1879:  0x000059BF,
	1880:  0x0000816C,
	1881:  0x00009856,
	1882:  0x000298FA,
	1883:  0x00005F3B,
	1884:  0x00020B9F,
	1886:  0x000221C1,
	1887:  0x0002896D,
	1888:  0x00004102,
	1889:  0x000046BB,
	1890:  0x00029079,
	1891:  0x00003F07,
	1892:  0x00009FB3,
	1893:  0x0002A1B5,
	1894:  0x000040F8,
	1895:  0x000037D6,
	1896:  0x000046F7,
	1897:  0x00026C46,
	1898:  0x0000417C,
	1899:  0x000286B2,
	1900:  0x000273FF,
	1901:  0x0000456D,
	1902:  0x000038D4,
	1903:  0x0002549A,
	1904:  0x00004561,
	1905:  0x0000451B,
	1906:  0x00004D89,
	1907:  0x00004C7B,
	1908:  0x00004D76,
	1909:  0x000045EA,
	1910:  0x00003FC8,
	1911:  0x00024B0F,
	1912:  0x00003661,
	1913:  0x000044DE,
	1914:  0x000044BD,
	1915:  0x000041ED,
	1916:  0x00005D3E,
	1917:  0x00005D48,
	1918:  0x00005D56,
	1919:  0x00003DFC,
	1920:  0x0000380F,
	1921:  0x00005DA4,
	1922:  0x00005DB9,
	1923:  0x00003820,
	1924:  0x00003838,
	1925:  0x00005E42,
	1926:  0x00005EBD,
	1927:  0x00005F25,
	1928:  0x00005F83,
	1929:  0x00003908,
	1930:  0x00003914,
	1931:  0x0000393F,
	1932:  0x0000394D,
	1933:  0x000060D7,
	1934:  0x0000613D,
	1935:  0x00005CE5,
	1936:  0x00003989,
	1937:  0x000061B7,
	1938:  0x000061B9,
	1939:  0x000061CF,
	1940:  0x000039B8,
	1941:  0x0000622C,
	1942:  0x00006290,
	1943:  0x000062E5,
	1944:  0x00006318,
	1945:  0x000039F8,
	1946:  0x000056B1,
	1947:  0x00003A03,
	1948:  0x000063E2,
	1949:  0x000063FB,
	1950:  0x00006407,
	1951:  0x0000645A,
	1952:  0x00003A4B,
	1953:  0x000064C0,
	1954:  0x00005D15,
	1955:  0x00005621,
	1956:  0x00009F9F,
	1957:  0x00003A97,
	1958:  0x00006586,
	1959:  0x00003ABD,
	1960:  0x000065FF,
	1961:  0x00006653,
	1962:  0x00003AF2,
	1963:  0x00006692,
	1964:  0x00003B22,
	1965:  0x00006716,
	1966:  0x00003B42,
	1967:  0x000067A4,
	1968:  0x00006800,
	1969:  0x00003B58,
	1970:  0x0000684A,
	1971:  0x00006884,
	1972:  0x00003B72,
	1973:  0x00003B71,
	1974:  0x00003B7B,
	1975:  0x00006909,
	1976:  0x00006943,
	1977:  0x0000725C,
	1978:  0x00006964,
	1979:  0x0000699F,
	1980:  0x00006985,
	1981:  0x00003BBC,
	1982:  0x000069D6,
	1983:  0x00003BDD,
	1984:  0x00006A65,
	1985:  0x00006A74,
	1986:  0x00006A71,
	1987:  0x00006A82,
	1988:  0x00003BEC,
	1989:  0x00006A99,
	1990:  0x00003BF2,
	1991:  0x00006AAB,
	1992:  0x00006AB5,
	1993:  0x00006AD4,
	1994:  0x00006AF6,
	1995:  0x00006B81,
	1996:  0x00006BC1,
	1997:  0x00006BEA,
	1998:  0x00006C75,
	1999:  0x00006CAA,
	2000:  0x00003CCB,
	2001:  0x00006D02,
	2002:  0x00006D06,
	2003:  0x00006D26,
	2004:  0x00006D81,
	2005:  0x00003CEF,
	2006:  0x00006DA4,
	2007:  0x00006DB1,
	2008:  0x00006E15,
	2009:  0x00006E18,
	2010:  0x00006E29,
	2011:  0x00006E86,
	2012:  0x000289C0,
	2013:  0x00006EBB,
	2014:  0x00006EE2,
	2015:  0x00006EDA,
	2016:  0x00009F7F,
	2017:  0x00006EE8,
	2018:  0x00006EE9,
	2019:  0x00006F24,
	2020:  0x00006F34,
	2021:  0x00003D46,
	2022:  0x00023F41,
	2023:  0x00006F81,
	2024:  0x00006FBE,
	2025:  0x00003D6A,
	2026:  0x00003D75,
	2027:  0x000071B7,
	2028:  0x00005C99,
	2029:  0x00003D8A,
	2030:  0x0000702C,
	2031:  0x00003D91,
	2032:  0x00007050,
	2033:  0x00007054,
	2034:  0x0000706F,
	2035:  0x0000707F,
	2036:  0x00007089,
	2037:  0x00020325,
	2038:  0x000043C1,
	2039:  0x000035F1,
	2040:  0x00020ED8,
	2041:  0x00023ED7,
	2042:  0x000057BE,
	2043:  0x00026ED3,
	2044:  0x0000713E,
	2045:  0x000257E0,
	2046:  0x0000364E,
	2047:  0x000069A2,
	2048:  0x00028BE9,
	2049:  0x00005B74,
	2050:  0x00007A49,
	2051:  0x000258E1,
	2052:  0x000294D9,
	2053:  0x00007A65,
	2054:  0x00007A7D,
	2055:  0x000259AC,
	2056:  0x00007ABB,
	2057:  0x00007AB0,
	2058:  0x00007AC2,
	2059:  0x00007AC3,
	2060:  0x000071D1,
	2061:  0x0002648D,
	2062:  0x000041CA,
	2063:  0x00007ADA,
	2064:  0x00007ADD,
	2065:  0x00007AEA,
	2066:  0x000041EF,
	2067:  0x000054B2,
	2068:  0x00025C01,
	2069:  0x00007B0B,
	2070:  0x00007B55,
	2071:  0x00007B29,
	2072:  0x0002530E,
	2073:  0x00025CFE,
	2074:  0x00007BA2,
	2075:  0x00007B6F,
	2076:  0x0000839C,
	2077:  0x00025BB4,
	2078:  0x00026C7F,
	2079:  0x00007BD0,
	2080:  0x00008421,
	2081:  0x00007B92,
	2082:  0x00007BB8,
	2083:  0x00025D20,
	2084:  0x00003DAD,
	2085:  0x00025C65,
	2086:  0x00008492,
	2087:  0x00007BFA,
	2088:  0x00007C06,
	2089:  0x00007C35,
	2090:  0x00025CC1,
	2091:  0x00007C44,
	2092:  0x00007C83,
	2093:  0x00024882,
	2094:  0x00007CA6,
	2095:  0x0000667D,
	2096:  0x00024578,
	2097:  0x00007CC9,
	2098:  0x00007CC7,
	2099:  0x00007CE6,
	2100:  0x00007C74,
	2101:  0x00007CF3,
	2102:  0x00007CF5,
	2103:  0x00007CCE,
	2104:  0x00007E67,
	2105:  0x0000451D,
	2106:  0x00026E44,
	2107:  0x00007D5D,
	2108:  0x00026ED6,
	2109:  0x0000748D,
	2110:  0x00007D89,
	2111:  0x00007DAB,
	2112:  0x00007135,
	2113:  0x00007DB3,
	2114:  0x00007DD2,
	2115:  0x00024057,
	2116:  0x00026029,
	2117:  0x00007DE4,
	2118:  0x00003D13,
	2119:  0x00007DF5,
	2120:  0x000217F9,
	2121:  0x00007DE5,
	2122:  0x0002836D,
	2123:  0x00007E1D,
	2124:  0x00026121,
	2125:  0x0002615A,
	2126:  0x00007E6E,
	2127:  0x00007E92,
	2128:  0x0000432B,
	2129:  0x0000946C,
	2130:  0x00007E27,
	2131:  0x00007F40,
	2132:  0x00007F41,
	2133:  0x00007F47,
	2134:  0x00007936,
	2135:  0x000262D0,
	2136:  0x000099E1,
	2137:  0x00007F97,
	2138:  0x00026351,
	2139:  0x00007FA3,
	2140:  0x00021661,
	2141:  0x00020068,
	2142:  0x0000455C,
	2143:  0x00023766,
	2144:  0x00004503,
	2145:  0x0002833A,
	2146:  0x00007FFA,
	2147:  0x00026489,
	2148:  0x00008005,
	2149:  0x00008008,
	2150:  0x0000801D,
	2151:  0x00008028,
	2152:  0x0000802F,
	2153:  0x0002A087,
	2154:  0x00026CC3,
	2155:  0x0000803B,
	2156:  0x0000803C,
	2157:  0x00008061,
	2158:  0x00022714,
	2159:  0x00004989,
	2160:  0x00026626,
	2161:  0x00023DE3,
	2162:  0x000266E8,
	2163:  0x00006725,
	2164:  0x000080A7,
	2165:  0x00028A48,
	2166:  0x00008107,
	2167:  0x0000811A,
	2168:  0x000058B0,
	2169:  0x000226F6,
	2170:  0x00006C7F,
	2171:  0x00026498,
	2172:  0x00024FB8,
	2173:  0x000064E7,
	2174:  0x0002148A,
	2175:  0x00008218,
	2176:  0x0002185E,
	2177:  0x00006A53,
	2178:  0x00024A65,
	2179:  0x00024A95,
	2180:  0x0000447A,
	2181:  0x00008229,
	2182:  0x00020B0D,
	2183:  0x00026A52,
	2184:  0x00023D7E,
	2185:  0x00004FF9,
	2186:  0x000214FD,
	2187:  0x000084E2,
	2188:  0x00008362,
	2189:  0x00026B0A,
	2190:  0x000249A7,
	2191:  0x00023530,
	2192:  0x00021773,
	2193:  0x00023DF8,
	2194:  0x000082AA,
	2195:  0x0000691B,
	2196:  0x0002F994,
	2197:  0x000041DB,
	2198:  0x0000854B,
	2199:  0x000082D0,
	2200:  0x0000831A,
	2201:  0x00020E16,
	2202:  0x000217B4,
	2203:  0x000036C1,
	2204:  0x0002317D,
	2205:  0x0002355A,
	2206:  0x0000827B,
	2207:  0x000082E2,
	2208:  0x00008318,
	2209:  0x00023E8B,
	2210:  0x00026DA3,
	2211:  0x00026B05,
	2212:  0x00026B97,
	2213:  0x000235CE,
	2214:  0x00003DBF,
	2215:  0x0000831D,
	2216:  0x000055EC,
	2217:  0x00008385,
	2218:  0x0000450B,
	2219:  0x00026DA5,
	2220:  0x000083AC,
	2221:  0x000083C1,
	2222:  0x000083D3,
	2223:  0x0000347E,
	2224:  0x00026ED4,
	2225:  0x00006A57,
	2226:  0x0000855A,
	2227:  0x00003496,
	2228:  0x00026E42,
	2229:  0x00022EEF,
	2230:  0x00008458,
	2231:  0x00025BE4,
	2232:  0x00008471,
	2233:  0x00003DD3,
	2234:  0x000044E4,
	2235:  0x00006AA7,
	2236:  0x0000844A,
	2237:  0x00023CB5,
	2238:  0x00007958,
	2239:  0x000084A8,
	2240:  0x00026B96,
	2241:  0x00026E77,
	2242:  0x00026E43,
	2243:  0x000084DE,
	2244:  0x0000840F,
	2245:  0x00008391,
	2246:  0x000044A0,
	2247:  0x00008493,
	2248:  0x000084E4,
	2249:  0x00025C91,
	2250:  0x00004240,
	2251:  0x00025CC0,
	2252:  0x00004543,
	2253:  0x00008534,
	2254:  0x00005AF2,
	2255:  0x00026E99,
	2256:  0x00004527,
	2257:  0x00008573,
	2258:  0x00004516,
	2259:  0x000067BF,
	2260:  0x00008616,
	2261:  0x00028625,
	2262:  0x0002863B,
	2263:  0x000085C1,
	2264:  0x00027088,
	2265:  0x00008602,
	2266:  0x00021582,
	2267:  0x000270CD,
	2268:  0x0002F9B2,
	2269:  0x0000456A,
	2270:  0x00008628,
	2271:  0x00003648,
	2272:  0x000218A2,
	2273:  0x000053F7,
	2274:  0x0002739A,
	2275:  0x0000867E,
	2276:  0x00008771,
	2277:  0x0002A0F8,
	2278:  0x000087EE,
	2279:  0x00022C27,
	2280:  0x000087B1,
	2281:  0x000087DA,
	2282:  0x0000880F,
	2283:  0x00005661,
	2284:  0x0000866C,
	2285:  0x00006856,
	2286:  0x0000460F,
	2287:  0x00008845,
	2288:  0x00008846,
	2289:  0x000275E0,
	2290:  0x00023DB9,
	2291:  0x000275E4,
	2292:  0x0000885E,
	2293:  0x0000889C,
	2294:  0x0000465B,
	2295:  0x000088B4,
	2296:  0x000088B5,
	2297:  0x000063C1,
	2298:  0x000088C5,
	2299:  0x00007777,
	2300:  0x0002770F,
	2301:  0x00008987,
	2302:  0x0000898A,
	2303:  0x000089A6,
	2304:  0x000089A9,
	2305:  0x000089A7,
	2306:  0x000089BC,
	2307:  0x00028A25,
	2308:  0x000089E7,
	2309:  0x00027924,
	2310:  0x00027ABD,
	2311:  0x00008A9C,
	2312:  0x00007793,
	2313:  0x000091FE,
	2314:  0x00008A90,
	2315:  0x00027A59,
	2316:  0x00007AE9,
	2317:  0x00027B3A,
	2318:  0x00023F8F,
	2319:  0x00004713,
	2320:  0x00027B38,
	2321:  0x0000717C,
	2322:  0x00008B0C,
	2323:  0x00008B1F,
	2324:  0x00025430,
	2325:  0x00025565,
	2326:  0x00008B3F,
	2327:  0x00008B4C,
	2328:  0x00008B4D,
	2329:  0x00008AA9,
	2330:  0x00024A7A,
	2331:  0x00008B90,
	2332:  0x00008B9B,
	2333:  0x00008AAF,
	2334:  0x000216DF,
	2335:  0x00004615,
	2336:  0x0000884F,
	2337:  0x00008C9B,
	2338:  0x00027D54,
	2339:  0x00027D8F,
	2340:  0x0002F9D4,
	2341:  0x00003725,
	2342:  0x00027D53,
	2343:  0x00008CD6,
	2344:  0x00027D98,
	2345:  0x00027DBD,
	2346:  0x00008D12,
	2347:  0x00008D03,
	2348:  0x00021910,
	2349:  0x00008CDB,
	2350:  0x0000705C,
	2351:  0x00008D11,
	2352:  0x00024CC9,
	2353:  0x00003ED0,
	2354:  0x00008D77,
	2355:  0x00008DA9,
	2356:  0x00028002,
	2357:  0x00021014,
	2358:  0x0002498A,
	2359:  0x00003B7C,
	2360:  0x000281BC,
	2361:  0x0002710C,
	2362:  0x00007AE7,
	2363:  0x00008EAD,
	2364:  0x00008EB6,
	2365:  0x00008EC3,
	2366:  0x000092D4,
	2367:  0x00008F19,
	2368:  0x00008F2D,
	2369:  0x00028365,
	2370:  0x00028412,
	2371:  0x00008FA5,
	2372:  0x00009303,
	2373:  0x0002A29F,
	2374:  0x00020A50,
	2375:  0x00008FB3,
	2376:  0x0000492A,
	2377:  0x000289DE,
	2378:  0x0002853D,
	2379:  0x00023DBB,
	2380:  0x00005EF8,
	2381:  0x00023262,
	2382:  0x00008FF9,
	2383:  0x0002A014,
	2384:  0x000286BC,
	2385:  0x00028501,
	2386:  0x00022325,
	2387:  0x00003980,
	2388:  0x00026ED7,
	2389:  0x00009037,
	2390:  0x0002853C,
	2391:  0x00027ABE,
	2392:  0x00009061,
	2393:  0x0002856C,
	2394:  0x0002860B,
	2395:  0x000090A8,
	2396:  0x00028713,
	2397:  0x000090C4,
	2398:  0x000286E6,
	2399:  0x000090AE,
	2400:  0x000090FD,
	2401:  0x00009167,
	2402:  0x00003AF0,
	2403:  0x000091A9,
	2404:  0x000091C4,
	2405:  0x00007CAC,
	2406:  0x00028933,
	2407:  0x00021E89,
	2408:  0x0000920E,
	2409:  0x00006C9F,
	2410:  0x00009241,
	2411:  0x00009262,
	2412:  0x000255B9,
	2413:  0x000092B9,
	2414:  0x00028AC6,
	2415:  0x00023C9B,
	2416:  0x00028B0C,
	2417:  0x000255DB,
	2418:  0x00020D31,
	2419:  0x0000932C,
	2420:  0x0000936B,
	2421:  0x00028AE1,
	2422:  0x00028BEB,
	2423:  0x0000708F,
	2424:  0x00005AC3,
	2425:  0x00028AE2,
	2426:  0x00028AE5,
	2427:  0x00004965,
	2428:  0x00009244,
	2429:  0x00028BEC,
	2430:  0x00028C39,
	2431:  0x00028BFF,
	2432:  0x00009373,
	2433:  0x0000945B,
	2434:  0x00008EBC,
	2435:  0x00009585,
	2436:  0x000095A6,
	2437:  0x00009426,
	2438:  0x000095A0,
	2439:  0x00006FF6,
	2440:  0x000042B9,
	2441:  0x0002267A,
	2442:  0x000286D8,
	2443:  0x0002127C,
	2444:  0x00023E2E,
	2445:  0x000049DF,
	2446:  0x00006C1C,
	2447:  0x0000967B,
	2448:  0x00009696,
	2449:  0x0000416C,
	2450:  0x000096A3,
	2451:  0x00026ED5,
	2452:  0x000061DA,
	2453:  0x000096B6,
	2454:  0x000078F5,
	2455:  0x00028AE0,
	2456:  0x000096BD,
	2457:  0x000053CC,
	2458:  0x000049A1,
	2459:  0x00026CB8,
	2460:  0x00020274,
	2461:  0x00026410,
	2462:  0x000290AF,
	2463:  0x000290E5,
	2464:  0x00024AD1,
	2465:  0x00021915,
	2466:  0x0002330A,
	2467:  0x00009731,
	2468:  0x00008642,
	2469:  0x00009736,
	2470:  0x00004A0F,
	2471:  0x0000453D,
	2472:  0x00004585,
	2473:  0x00024AE9,
	2474:  0x00007075,
	2475:  0x00005B41,
	2476:  0x0000971B,
	2477:  0x0000975C,
	2478:  0x000291D5,
	2479:  0x00009757,
	2480:  0x00005B4A,
	2481:  0x000291EB,
	2482:  0x0000975F,
	2483:  0x00009425,
	2484:  0x000050D0,
	2485:  0x000230B7,
	2486:  0x000230BC,
	2487:  0x00009789,
	2488:  0x0000979F,
	2489:  0x000097B1,
	2490:  0x000097BE,
	2491:  0x000097C0,
	2492:  0x000097D2,
	2493:  0x000097E0,
	2494:  0x0002546C,
	2495:  0x000097EE,
	2496:  0x0000741C,
	2497:  0x00029433,
	2498:  0x000097FF,
	2499:  0x000097F5,
	2500:  0x0002941D,
	2501:  0x0002797A,
	2502:  0x00004AD1,
	2503:  0x00009834,
	2504:  0x00009833,
	2505:  0x0000984B,
	2506:  0x00009866,
	2507:  0x00003B0E,
	2508:  0x00027175,
	2509:  0x00003D51,
	2510:  0x00020630,
	2511:  0x0002415C,
	2512:  0x00025706,
	2513:  0x000098CA,
	2514:  0x000098B7,
	2515:  0x000098C8,
	2516:  0x000098C7,
	2517:  0x00004AFF,
	2518:  0x00026D27,
	2519:  0x000216D3,
	2520:  0x000055B0,
	2521:  0x000098E1,
	2522:  0x000098E6,
	2523:  0x000098EC,
	2524:  0x00009378,
	2525:  0x00009939,
	2526:  0x00024A29,
	2527:  0x00004B72,
	2528:  0x00029857,
	2529:  0x00029905,
	2530:  0x000099F5,
	2531:  0x00009A0C,
	2532:  0x00009A3B,
	2533:  0x00009A10,
	2534:  0x00009A58,
	2535:  0x00025725,
	2536:  0x000036C4,
	2537:  0x000290B1,
	2538:  0x00029BD5,
	2539:  0x00009AE0,
	2540:  0x00009AE2,
	2541:  0x00029B05,
	2542:  0x00009AF4,
	2543:  0x00004C0E,
	2544:  0x00009B14,
	2545:  0x00009B2D,
	2546:  0x00028600,
	2547:  0x00005034,
	2548:  0x00009B34,
	2549:  0x000269A8,
	2550:  0x000038C3,
	2551:  0x0002307D,
	2552:  0x00009B50,
	2553:  0x00009B40,
	2554:  0x00029D3E,
	2555:  0x00005A45,
	2556:  0x00021863,
	2557:  0x00009B8E,
	2558:  0x0002424B,
	2559:  0x00009C02,
	2560:  0x00009BFF,
	2561:  0x00009C0C,
	2562:  0x00029E68,
	2563:  0x00009DD4,
	2564:  0x00029FB7,
	2565:  0x0002A192,
	2566:  0x0002A1AB,
	2567:  0x0002A0E1,
	2568:  0x0002A123,
	2569:  0x0002A1DF,
	2570:  0x00009D7E,
	2571:  0x00009D83,
	2572:  0x0002A134,
	2573:  0x00009E0E,
	2574:  0x00006888,
	2575:  0x00009DC4,
	2576:  0x0002215B,
	2577:  0x0002A193,
	2578:  0x0002A220,
	2579:  0x0002193B,
	2580:  0x0002A233,
	2581:  0x00009D39,
	2582:  0x0002A0B9,
	2583:  0x0002A2B4,
	2584:  0x00009E90,
	2585:  0x00009E95,
	2586:  0x00009E9E,
	2587:  0x00009EA2,
	2588:  0x00004D34,
	2589:  0x00009EAA,
	2590:  0x00009EAF,
	2591:  0x00024364,
	2592:  0x00009EC1,
	2593:  0x00003B60,
	2594:  0x000039E5,
	2595:  0x00003D1D,
	2596:  0x00004F32,
	2597:  0x000037BE,
	2598:  0x00028C2B,
	2599:  0x00009F02,
	2600:  0x00009F08,
	2601:  0x00004B96,
	2602:  0x00009424,
	2603:  0x00026DA2,
	2604:  0x00009F17,
	2605:  0x00009F16,
	2606:  0x00009F39,
	2607:  0x0000569F,
	2608:  0x0000568A,
	2609:  0x00009F45,
	2610:  0x000099B8,
	2611:  0x0002908B,
	2612:  0x000097F2,
	2613:  0x0000847F,
	2614:  0x00009F62,
	2615:  0x00009F69,
	2616:  0x00007ADC,
	2617:  0x00009F8E,
	2618:  0x00007216,
	2619:  0x00004BBE,
	2620:  0x00024975,
	2621:  0x000249BB,
	2622:  0x00007177,
	2623:  0x000249F8,
	2624:  0x00024348,
	2625:  0x00024A51,
	2626:  0x0000739E,
	2627:  0x00028BDA,
	2628:  0x000218FA,
	2629:  0x0000799F,
	2630:  0x0002897E,
	2631:  0x00028E36,
	2632:  0x00009369,
	2633:  0x000093F3,
	2634:  0x00028A44,
	2635:  0x000092EC,
	2636:  0x00009381,
	2637:  0x000093CB,
	2638:  0x0002896C,
	2639:  0x000244B9,
	2640:  0x00007217,
	2641:  0x00003EEB,
	2642:  0x00007772,
	2643:  0x00007A43,
	2644:  0x000070D0,
	2645:  0x00024473,
	2646:  0x000243F8,
	2647:  0x0000717E,
	2648:  0x000217EF,
	2649:  0x000070A3,
	2650:  0x000218BE,
	2651:  0x00023599,
	2652:  0x00003EC7,
	2653:  0x00021885,
	2654:  0x0002542F,
	2655:  0x000217F8,
	2656:  0x00003722,
	2657:  0x000216FB,
	2658:  0x00021839,
	2659:  0x000036E1,
	2660:  0x00021774,
	2661:  0x000218D1,
	2662:  0x00025F4B,
	2663:  0x00003723,
	2664:  0x000216C0,
	2665:  0x0000575B,
	2666:  0x00024A25,
	2667:  0x000213FE,
	2668:  0x000212A8,
	2669:  0x000213C6,
	2670:  0x000214B6,
	2671:  0x00008503,
	2672:  0x000236A6,
	2673:  0x00008503,
	2674:  0x00008455,
	2675:  0x00024994,
	2676:  0x00027165,
	2677:  0x00023E31,
	2678:  0x0002555C,
	2679:  0x00023EFB,
	2680:  0x00027052,
	2681:  0x000044F4,
	2682:  0x000236EE,
	2683:  0x0002999D,
	2684:  0x00026F26,
	2685:  0x000067F9,
	2686:  0x00003733,
	2687:  0x00003C15,
	2688:  0x00003DE7,
	2689:  0x0000586C,
	2690:  0x00021922,
	2691:  0x00006810,
	2692:  0x00004057,
	2693:  0x0002373F,
	2694:  0x000240E1,
	2695:  0x0002408B,
	2696:  0x0002410F,
	2697:  0x00026C21,
	2698:  0x000054CB,
	2699:  0x0000569E,
	2700:  0x000266B1,
	2701:  0x00005692,
	2702:  0x00020FDF,
	2703:  0x00020BA8,
	2704:  0x00020E0D,
	2705:  0x000093C6,
	2706:  0x00028B13,
	2707:  0x0000939C,
	2708:  0x00004EF8,
	2709:  0x0000512B,
	2710:  0x00003819,
	2711:  0x00024436,
	2712:  0x00004EBC,
	2713:  0x00020465,
	2714:  0x0002037F,
	2715:  0x00004F4B,
	2716:  0x00004F8A,
	2717:  0x00025651,
	2718:  0x00005A68,
	2719:  0x000201AB,
	2720:  0x000203CB,
	2721:  0x00003999,
	2722:  0x0002030A,
	2723:  0x00020414,
	2724:  0x00003435,
	2725:  0x00004F29,
	2726:  0x000202C0,
	2727:  0x00028EB3,
	2728:  0x00020275,
	2729:  0x00008ADA,
	2730:  0x0002020C,
	2731:  0x00004E98,
	2732:  0x000050CD,
	2733:  0x0000510D,
	2734:  0x00004FA2,
	2735:  0x00004F03,
	2736:  0x00024A0E,
	2737:  0x00023E8A,
	2738:  0x00004F42,
	2739:  0x0000502E,
	2740:  0x0000506C,
	2741:  0x00005081,
	2742:  0x00004FCC,
	2743:  0x00004FE5,
	2744:  0x00005058,
	2745:  0x000050FC,
	2746:  0x00005159,
	2747:  0x0000515B,
	2748:  0x0000515D,
	2749:  0x0000515E,
	2750:  0x00006E76,
	2751:  0x00023595,
	2752:  0x00023E39,
	2753:  0x00023EBF,
	2754:  0x00006D72,
	2755:  0x00021884,
	2756:  0x00023E89,
	2757:  0x000051A8,
	2758:  0x000051C3,
	2759:  0x000205E0,
	2760:  0x000044DD,
	2761:  0x000204A3,
	2762:  0x00020492,
	2763:  0x00020491,
	2764:  0x00008D7A,
	2765:  0x00028A9C,
	2766:  0x0002070E,
	2767:  0x00005259,
	2768:  0x000052A4,
	2769:  0x00020873,
	2770:  0x000052E1,
	2771:  0x0000936E,
	2772:  0x0000467A,
	2773:  0x0000718C,
	2774:  0x0002438C,
	2775:  0x00020C20,
	2776:  0x000249AC,
	2777:  0x000210E4,
	2778:  0x000069D1,
	2779:  0x00020E1D,
	2780:  0x00007479,
	2781:  0x00003EDE,
	2782:  0x00007499,
	2783:  0x00007414,
	2784:  0x00007456,
	2785:  0x00007398,
	2786:  0x00004B8E,
	2787:  0x00024ABC,
	2788:  0x0002408D,
	2789:  0x000053D0,
	2790:  0x00003584,
	2791:  0x0000720F,
	2792:  0x000240C9,
	2793:  0x000055B4,
	2794:  0x00020345,
	2795:  0x000054CD,
	2796:  0x00020BC6,
	2797:  0x0000571D,
	2798:  0x0000925D,
	2799:  0x000096F4,
	2800:  0x00009366,
	2801:  0x000057DD,
	2802:  0x0000578D,
	2803:  0x0000577F,
	2804:  0x0000363E,
	2805:  0x000058CB,
	2806:  0x00005A99,
	2807:  0x00028A46,
	2808:  0x000216FA,
	2809:  0x0002176F,
	2810:  0x00021710,
	2811:  0x00005A2C,
	2812:  0x000059B8,
	2813:  0x0000928F,
	2814:  0x00005A7E,
	2815:  0x00005ACF,
	2816:  0x00005A12,
	2817:  0x00025946,
	2818:  0x000219F3,
	2819:  0x00021861,
	2820:  0x00024295,
	2821:  0x000036F5,
	2822:  0x00006D05,
	2823:  0x00007443,
	2824:  0x00005A21,
	2825:  0x00025E83,
	2826:  0x00005A81,
	2827:  0x00028BD7,
	2828:  0x00020413,
	2829:  0x000093E0,
	2830:  0x0000748C,
	2831:  0x00021303,
	2832:  0x00007105,
	2833:  0x00004972,
	2834:  0x00009408,
	2835:  0x000289FB,
	2836:  0x000093BD,
	2837:  0x000037A0,
	2838:  0x00005C1E,
	2839:  0x00005C9E,
	2840:  0x00005E5E,
	2841:  0x00005E48,
	2842:  0x00021996,
	2843:  0x0002197C,
	2844:  0x00023AEE,
	2845:  0x00005ECD,
	2846:  0x00005B4F,
	2847:  0x00021903,
	2848:  0x00021904,
	2849:  0x00003701,
	2850:  0x000218A0,
	2851:  0x000036DD,
	2852:  0x000216FE,
	2853:  0x000036D3,
	2854:  0x0000812A,
	2855:  0x00028A47,
	2856:  0x00021DBA,
	2857:  0x00023472,
	2858:  0x000289A8,
	2859:  0x00005F0C,
	2860:  0x00005F0E,
	2861:  0x00021927,
	2862:  0x000217AB,
	2863:  0x00005A6B,
	2864:  0x0002173B,
	2865:  0x00005B44,
	2866:  0x00008614,
	2867:  0x000275FD,
	2868:  0x00008860,
	2869:  0x0000607E,
	2870:  0x00022860,
	2871:  0x0002262B,
	2872:  0x00005FDB,
	2873:  0x00003EB8,
	2874:  0x000225AF,
	2875:  0x000225BE,
	2876:  0x00029088,
	2877:  0x00026F73,
	2878:  0x000061C0,
	2879:  0x0002003E,
	2880:  0x00020046,
	2881:  0x0002261B,
	2882:  0x00006199,
	2883:  0x00006198,
	2884:  0x00006075,
	2885:  0x00022C9B,
	2886:  0x00022D07,
	2887:  0x000246D4,
	2888:  0x0002914D,
	2889:  0x00006471,
	2890:  0x00024665,
	2891:  0x00022B6A,
	2892:  0x00003A29,
	2893:  0x00022B22,
	2894:  0x00023450,
	2895:  0x000298EA,
	2896:  0x00022E78,
	2897:  0x00006337,
	2898:  0x0002A45B,
	2899:  0x000064B6,
	2900:  0x00006331,
	2901:  0x000063D1,
	2902:  0x000249E3,
	2903:  0x00022D67,
	2904:  0x000062A4,
	2905:  0x00022CA1,
	2906:  0x0000643B,
	2907:  0x0000656B,
	2908:  0x00006972,
	2909:  0x00003BF4,
	2910:  0x0002308E,
	2911:  0x000232AD,
	2912:  0x00024989,
	2913:  0x000232AB,
	2914:  0x0000550D,
	2915:  0x000232E0,
	2916:  0x000218D9,
	2917:  0x0002943F,
	2918:  0x000066CE,
	2919:  0x00023289,
	2920:  0x000231B3,
	2921:  0x00003AE0,
	2922:  0x00004190,
	2923:  0x00025584,
	2924:  0x00028B22,
	2925:  0x0002558F,
	2926:  0x000216FC,
	2927:  0x0002555B,
	2928:  0x00025425,
	2929:  0x000078EE,
	2930:  0x00023103,
	2931:  0x0002182A,
	2932:  0x00023234,
	2933:  0x00003464,
	2934:  0x0002320F,
	2935:  0x00023182,
	2936:  0x000242C9,
	2937:  0x0000668E,
	2938:  0x00026D24,
	2939:  0x0000666B,
	2940:  0x00004B93,
	2941:  0x00006630,
	2942:  0x00027870,
	2943:  0x00021DEB,
	2944:  0x00006663,
	2945:  0x000232D2,
	2946:  0x000232E1,
	2947:  0x0000661E,
	2948:  0x00025872,
	2949:  0x000038D1,
	2950:  0x0002383A,
	2951:  0x000237BC,
	2952:  0x00003B99,
	2953:  0x000237A2,
	2954:  0x000233FE,
	2955:  0x000074D0,
	2956:  0x00003B96,
	2957:  0x0000678F,
	2958:  0x0002462A,
	2959:  0x000068B6,
	2960:  0x0000681E,
	2961:  0x00003BC4,
	2962:  0x00006ABE,
	2963:  0x00003863,
	2964:  0x000237D5,
	2965:  0x00024487,
	2966:  0x00006A33,
	2967:  0x00006A52,
	2968:  0x00006AC9,
	2969:  0x00006B05,
	2970:  0x00021912,
	2971:  0x00006511,
	2972:  0x00006898,
	2973:  0x00006A4C,
	2974:  0x00003BD7,
	2975:  0x00006A7A,
	2976:  0x00006B57,
	2977:  0x00023FC0,
	2978:  0x00023C9A,
	2979:  0x000093A0,
	2980:  0x000092F2,
	2981:  0x00028BEA,
	2982:  0x00028ACB,
	2983:  0x00009289,
	2984:  0x0002801E,
	2985:  0x000289DC,
	2986:  0x00009467,
	2987:  0x00006DA5,
	2988:  0x00006F0B,
	2989:  0x000249EC,
	2990:  0x00006D67,
	2991:  0x00023F7F,
	2992:  0x00003D8F,
	2993:  0x00006E04,
	2994:  0x0002403C,
	2995:  0x00005A3D,
	2996:  0x00006E0A,
	2997:  0x00005847,
	2998:  0x00006D24,
	2999:  0x00007842,
	3000:  0x0000713B,
	3001:  0x0002431A,
	3002:  0x00024276,
	3003:  0x000070F1,
	3004:  0x00007250,
	3005:  0x00007287,
	3006:  0x00007294,
	3007:  0x0002478F,
	3008:  0x00024725,
	3009:  0x00005179,
	3010:  0x00024AA4,
	3011:  0x000205EB,
	3012:  0x0000747A,
	3013:  0x00023EF8,
	3014:  0x0002365F,
	3015:  0x00024A4A,
	3016:  0x00024917,
	3017:  0x00025FE1,
	3018:  0x00003F06,
	3019:  0x00003EB1,
	3020:  0x00024ADF,
	3021:  0x00028C23,
	3022:  0x00023F35,
	3023:  0x000060A7,
	3024:  0x00003EF3,
	3025:  0x000074CC,
	3026:  0x0000743C,
	3027:  0x00009387,
	3028:  0x00007437,
	3029:  0x0000449F,
	3030:  0x00026DEA,
	3031:  0x00004551,
	3032:  0x00007583,
	3033:  0x00003F63,
	3034:  0x00024CD9,
	3035:  0x00024D06,
	3036:  0x00003F58,
	3037:  0x00007555,
	3038:  0x00007673,
	3039:  0x0002A5C6,
	3040:  0x00003B19,
	3041:  0x00007468,
	3042:  0x00028ACC,
	3043:  0x000249AB,
	3044:  0x0002498E,
	3045:  0x00003AFB,
	3046:  0x00003DCD,
	3047:  0x00024A4E,
	3048:  0x00003EFF,
	3049:  0x000249C5,
	3050:  0x000248F3,
	3051:  0x000091FA,
	3052:  0x00005732,
	3053:  0x00009342,
	3054:  0x00028AE3,
	3055:  0x00021864,
	3056:  0x000050DF,
	3057:  0x00025221,
	3058:  0x000251E7,
	3059:  0x00007778,
	3060:  0x00023232,
	3061:  0x0000770E,
	3062:  0x0000770F,
	3063:  0x0000777B,
	3064:  0x00024697,
	3065:  0x00023781,
	3066:  0x00003A5E,
	3067:  0x000248F0,
	3068:  0x00007438,
	3069:  0x0000749B,
	3070:  0x00003EBF,
	3071:  0x00024ABA,
	3072:  0x00024AC7,
	3073:  0x000040C8,
	3074:  0x00024A96,
	3075:  0x000261AE,
	3076:  0x00009307,
	3077:  0x00025581,
	3078:  0x0000781E,
	3079:  0x0000788D,
	3080:  0x00007888,
	3081:  0x000078D2,
	3082:  0x000073D0,
	3083:  0x00007959,
	3084:  0x00027741,
	3085:  0x000256E3,
	3086:  0x0000410E,
	3087:  0x0000799B,
	3088:  0x00008496,
	3089:  0x000079A5,
	3090:  0x00006A2D,
	3091:  0x00023EFA,
	3092:  0x00007A3A,
	3093:  0x000079F4,
	3094:  0x0000416E,
	3095:  0x000216E6,
	3096:  0x00004132,
	3097:  0x00009235,
	3098:  0x000079F1,
	3099:  0x00020D4C,
	3100:  0x0002498C,
	3101:  0x00020299,
	3102:  0x00023DBA,
	3103:  0x0002176E,
	3104:  0x00003597,
	3105:  0x0000556B,
	3106:  0x00003570,
	3107:  0x000036AA,
	3108:  0x000201D4,
	3109:  0x00020C0D,
	3110:  0x00007AE2,
	3111:  0x00005A59,
	3112:  0x000226F5,
	3113:  0x00025AAF,
	3114:  0x00025A9C,
	3115:  0x00005A0D,
	3116:  0x0002025B,
	3117:  0x000078F0,
	3118:  0x00005A2A,
	3119:  0x00025BC6,
	3120:  0x00007AFE,
	3121:  0x000041F9,
	3122:  0x00007C5D,
	3123:  0x00007C6D,
	3124:  0x00004211,
	3125:  0x00025BB3,
	3126:  0x00025EBC,
	3127:  0x00025EA6,
	3128:  0x00007CCD,
	3129:  0x000249F9,
	3130:  0x000217B0,
	3131:  0x00007C8E,
	3132:  0x00007C7C,
	3133:  0x00007CAE,
	3134:  0x00006AB2,
	3135:  0x00007DDC,
	3136:  0x00007E07,
	3137:  0x00007DD3,
	3138:  0x00007F4E,
	3139:  0x00026261,
	3140:  0x0002615C,
	3141:  0x00027B48,
	3142:  0x00007D97,
	3143:  0x00025E82,
	3144:  0x0000426A,
	3145:  0x00026B75,
	3146:  0x00020916,
	3147:  0x000067D6,
	3148:  0x0002004E,
	3149:  0x000235CF,
	3150:  0x000057C4,
	3151:  0x00026412,
	3152:  0x000263F8,
	3153:  0x00024962,
	3154:  0x00007FDD,
	3155:  0x00007B27,
	3156:  0x0002082C,
	3157:  0x00025AE9,
	3158:  0x00025D43,
	3159:  0x00007B0C,
	3160:  0x00025E0E,
	3161:  0x000099E6,
	3162:  0x00008645,
	3163:  0x00009A63,
	3164:  0x00006A1C,
	3165:  0x0002343F,
	3166:  0x000039E2,
	3167:  0x000249F7,
	3168:  0x000265AD,
	3169:  0x00009A1F,
	3170:  0x000265A0,
	3171:  0x00008480,
	3172:  0x00027127,
	3173:  0x00026CD1,
	3174:  0x000044EA,
	3175:  0x00008137,
	3176:  0x00004402,
	3177:  0x000080C6,
	3178:  0x00008109,
	3179:  0x00008142,
	3180:  0x000267B4,
	3181:  0x000098C3,
	3182:  0x00026A42,
	3183:  0x00008262,
	3184:  0x00008265,
	3185:  0x00026A51,
	3186:  0x00008453,
	3187:  0x00026DA7,
	3188:  0x00008610,
	3189:  0x0002721B,
	3190:  0x00005A86,
	3191:  0x0000417F,
	3192:  0x00021840,
	3193:  0x00005B2B,
	3194:  0x000218A1,
	3195:  0x00005AE4,
	3196:  0x000218D8,
	3197:  0x000086A0,
	3198:  0x0002F9BC,
	3199:  0x00023D8F,
	3200:  0x0000882D,
	3201:  0x00027422,
	3202:  0x00005A02,
	3203:  0x0000886E,
	3204:  0x00004F45,
	3205:  0x00008887,
	3206:  0x000088BF,
	3207:  0x000088E6,
	3208:  0x00008965,
	3209:  0x0000894D,
	3210:  0x00025683,
	3211:  0x00008954,
	3212:  0x00027785,
	3213:  0x00027784,
	3214:  0x00028BF5,
	3215:  0x00028BD9,
	3216:  0x00028B9C,
	3217:  0x000289F9,
	3218:  0x00003EAD,
	3219:  0x000084A3,
	3220:  0x000046F5,
	3221:  0x000046CF,
	3222:  0x000037F2,
	3223:  0x00008A3D,
	3224:  0x00008A1C,
	3225:  0x00029448,
	3226:  0x00005F4D,
	3227:  0x0000922B,
	3228:  0x00024284,
	3229:  0x000065D4,
	3230:  0x00007129,
	3231:  0x000070C4,
	3232:  0x00021845,
	3233:  0x00009D6D,
	3234:  0x00008C9F,
	3235:  0x00008CE9,
	3236:  0x00027DDC,
	3237:  0x0000599A,
	3238:  0x000077C3,
	3239:  0x000059F0,
	3240:  0x0000436E,
	3241:  0x000036D4,
	3242:  0x00008E2A,
	3243:  0x00008EA7,
	3244:  0x00024C09,
	3245:  0x00008F30,
	3246:  0x00008F4A,
	3247:  0x000042F4,
	3248:  0x00006C58,
	3249:  0x00006FBB,
	3250:  0x00022321,
	3251:  0x0000489B,
	3252:  0x00006F79,
	3253:  0x00006E8B,
	3254:  0x000217DA,
	3255:  0x00009BE9,
	3256:  0x000036B5,
	3257:  0x0002492F,
	3258:  0x000090BB,
	3259:  0x00009097,
	3260:  0x00005571,
	3261:  0x00004906,
	3262:  0x000091BB,
	3263:  0x00009404,
	3264:  0x00028A4B,
	3265:  0x00004062,
	3266:  0x00028AFC,
	3267:  0x00009427,
	3268:  0x00028C1D,
	3269:  0x00028C3B,
	3270:  0x000084E5,
	3271:  0x00008A2B,
	3272:  0x00009599,
	3273:  0x000095A7,
	3274:  0x00009597,
	3275:  0x00009596,
	3276:  0x00028D34,
	3277:  0x00007445,
	3278:  0x00003EC2,
	3279:  0x000248FF,
	3280:  0x00024A42,
	3281:  0x000243EA,
	3282:  0x00003EE7,
	3283:  0x00023225,
	3284:  0x0000968F,
	3285:  0x00028EE7,
	3286:  0x00028E66,
	3287:  0x00028E65,
	3288:  0x00003ECC,
	3289:  0x000249ED,
	3290:  0x00024A78,
	3291:  0x00023FEE,
	3292:  0x00007412,
	3293:  0x0000746B,
	3294:  0x00003EFC,
	3295:  0x00009741,
	3296:  0x000290B0,
	3297:  0x00006847,
	3298:  0x00004A1D,
	3299:  0x00029093,
	3300:  0x000257DF,
	3301:  0x0000975D,
	3302:  0x00009368,
	3303:  0x00028989,
	3304:  0x00028C26,
	3305:  0x00028B2F,
	3306:  0x000263BE,
	3307:  0x000092BA,
	3308:  0x00005B11,
	3309:  0x00008B69,
	3310:  0x0000493C,
	3311:  0x000073F9,
	3312:  0x0002421B,
	3313:  0x0000979B,
	3314:  0x00009771,
	3315:  0x00009938,
	3316:  0x00020F26,
	3317:  0x00005DC1,
	3318:  0x00028BC5,
	3319:  0x00024AB2,
	3320:  0x0000981F,
	3321:  0x000294DA,
	3322:  0x000092F6,
	3323:  0x000295D7,
	3324:  0x000091E5,
	3325:  0x000044C0,
	3326:  0x00028B50,
	3327:  0x00024A67,
	3328:  0x00028B64,
	3329:  0x000098DC,
	3330:  0x00028A45,
	3331:  0x00003F00,
	3332:  0x0000922A,
	3333:  0x00004925,
	3334:  0x00008414,
	3335:  0x0000993B,
	3336:  0x0000994D,
	3337:  0x00027B06,
	3338:  0x00003DFD,
	3339:  0x0000999B,
	3340:  0x00004B6F,
	3341:  0x000099AA,
	3342:  0x00009A5C,
	3343:  0x00028B65,
	3344:  0x000258C8,
	3345:  0x00006A8F,
	3346:  0x00009A21,
	3347:  0x00005AFE,
	3348:  0x00009A2F,
	3349:  0x000298F1,
	3350:  0x00004B90,
	3351:  0x00029948,
	3352:  0x000099BC,
	3353:  0x00004BBD,
	3354:  0x00004B97,
	3355:  0x0000937D,
	3356:  0x00005872,
	3357:  0x00021302,
	3358:  0x00005822,
	3359:  0x000249B8,
	3360:  0x000214E8,
	3361:  0x00007844,
	3362:  0x0002271F,
	3363:  0x00023DB8,
	3364:  0x000068C5,
	3365:  0x00003D7D,
	3366:  0x00009458,
	3367:  0x00003927,
	3368:  0x00006150,
	3369:  0x00022781,
	3370:  0x0002296B,
	3371:  0x00006107,
	3372:  0x00009C4F,
	3373:  0x00009C53,
	3374:  0x00009C7B,
	3375:  0x00009C35,
	3376:  0x00009C10,
	3377:  0x00009B7F,
	3378:  0x00009BCF,
	3379:  0x00029E2D,
	3380:  0x00009B9F,
	3381:  0x0002A1F5,
	3382:  0x0002A0FE,
	3383:  0x00009D21,
	3384:  0x00004CAE,
	3385:  0x00024104,
	3386:  0x00009E18,
	3387:  0x00004CB0,
	3388:  0x00009D0C,
	3389:  0x0002A1B4,
	3390:  0x0002A0ED,
	3391:  0x0002A0F3,
	3392:  0x0002992F,
	3393:  0x00009DA5,
	3394:  0x000084BD,
	3395:  0x00026E12,
	3396:  0x00026FDF,
	3397:  0x00026B82,
	3398:  0x000085FC,
	3399:  0x00004533,
	3400:  0x00026DA4,
	3401:  0x00026E84,
	3402:  0x00026DF0,
	3403:  0x00008420,
	3404:  0x000085EE,
	3405:  0x00026E00,
	3406:  0x000237D7,
	3407:  0x00026064,
	3408:  0x000079E2,
	3409:  0x0002359C,
	3410:  0x00023640,
	3411:  0x0000492D,
	3412:  0x000249DE,
	3413:  0x00003D62,
	3414:  0x000093DB,
	3415:  0x000092BE,
	3416:  0x00009348,
	3417:  0x000202BF,
	3418:  0x000078B9,
	3419:  0x00009277,
	3420:  0x0000944D,
	3421:  0x00004FE4,
	3422:  0x00003440,
	3423:  0x00009064,
	3424:  0x0002555D,
	3425:  0x0000783D,
	3426:  0x00007854,
	3427:  0x000078B6,
	3428:  0x0000784B,
	3429:  0x00021757,
	3430:  0x000231C9,
	3431:  0x00024941,
	3432:  0x0000369A,
	3433:  0x00004F72,
	3434:  0x00006FDA,
	3435:  0x00006FD9,
	3436:  0x0000701E,
	3437:  0x0000701E,
	3438:  0x00005414,
	3439:  0x000241B5,
	3440:  0x000057BB,
	3441:  0x000058F3,
	3442:  0x0000578A,
	3443:  0x00009D16,
	3444:  0x000057D7,
	3445:  0x00007134,
	3446:  0x000034AF,
	3447:  0x000241AC,
	3448:  0x000071EB,
	3449:  0x00026C40,
	3450:  0x00024F97,
	3451:  0x00005B28,
	3452:  0x000217B5,
	3453:  0x00028A49,
	3454:  0x0000610C,
	3455:  0x00005ACE,
	3456:  0x00005A0B,
	3457:  0x000042BC,
	3458:  0x00024488,
	3459:  0x0000372C,
	3460:  0x00004B7B,
	3461:  0x000289FC,
	3462:  0x000093BB,
	3463:  0x000093B8,
	3464:  0x000218D6,
	3465:  0x00020F1D,
	3466:  0x00008472,
	3467:  0x00026CC0,
	3468:  0x00021413,
	3469:  0x000242FA,
	3470:  0x00022C26,
	3471:  0x000243C1,
	3472:  0x00005994,
	3473:  0x00023DB7,
	3474:  0x00026741,
	3475:  0x00007DA8,
	3476:  0x0002615B,
	3477:  0x000260A4,
	3478:  0x000249B9,
	3479:  0x0002498B,
	3480:  0x000289FA,
	3481:  0x000092E5,
	3482:  0x000073E2,
	3483:  0x00003EE9,
	3484:  0x000074B4,
	3485:  0x00028B63,
	3486:  0x0002189F,
	3487:  0x00003EE1,
	3488:  0x00024AB3,
	3489:  0x00006AD8,
	3490:  0x000073F3,
	3491:  0x000073FB,
	3492:  0x00003ED6,
	3493:  0x00024A3E,
	3494:  0x00024A94,
	3495:  0x000217D9,
	3496:  0x00024A66,
	3497:  0x000203A7,
	3498:  0x00021424,
	3499:  0x000249E5,
	3500:  0x00007448,
	3501:  0x00024916,
	3502:  0x000070A5,
	3503:  0x00024976,
	3504:  0x00009284,
	3505:  0x000073E6,
	3506:  0x0000935F,
	3507:  0x000204FE,
	3508:  0x00009331,
	3509:  0x00028ACE,
	3510:  0x00028A16,
	3511:  0x00009386,
	3512:  0x00028BE7,
	3513:  0x000255D5,
	3514:  0x00004935,
	3515:  0x00028A82,
	3516:  0x0000716B,
	3517:  0x00024943,
	3518:  0x00020CFF,
	3519:  0x000056A4,
	3520:  0x0002061A,
	3521:  0x00020BEB,
	3522:  0x00020CB8,
	3523:  0x00005502,
	3524:  0x000079C4,
	3525:  0x000217FA,
	3526:  0x00007DFE,
	3527:  0x000216C2,
	3528:  0x00024A50,
	3529:  0x00021852,
	3530:  0x0000452E,
	3531:  0x00009401,
	3532:  0x0000370A,
	3533:  0x00028AC0,
	3534:  0x000249AD,
	3535:  0x000059B0,
	3536:  0x000218BF,
	3537:  0x00021883,
	3538:  0x00027484,
	3539:  0x00005AA1,
	3540:  0x000036E2,
	3541:  0x00023D5B,
	3542:  0x000036B0,
	3543:  0x0000925F,
	3544:  0x00005A79,
	3545:  0x00028A81,
	3546:  0x00021862,
	3547:  0x00009374,
	3548:  0x00003CCD,
	3549:  0x00020AB4,
	3550:  0x00004A96,
	3551:  0x0000398A,
	3552:  0x000050F4,
	3553:  0x00003D69,
	3554:  0x00003D4C,
	3555:  0x0002139C,
	3556:  0x00007175,
	3557:  0x000042FB,
	3558:  0x00028218,
	3559:  0x00006E0F,
	3560:  0x000290E4,
	3561:  0x000044EB,
	3562:  0x00006D57,
	3563:  0x00027E4F,
	3564:  0x00007067,
	3565:  0x00006CAF,
	3566:  0x00003CD6,
	3567:  0x00023FED,
	3568:  0x00023E2D,
	3569:  0x00006E02,
	3570:  0x00006F0C,
	3571:  0x00003D6F,
	3572:  0x000203F5,
	3573:  0x00007551,
	3574:  0x000036BC,
	3575:  0x000034C8,
	3576:  0x00004680,
	3577:  0x00003EDA,
	3578:  0x00004871,
	3579:  0x000059C4,
	3580:  0x0000926E,
	3581:  0x0000493E,
	3582:  0x00008F41,
	3583:  0x00028C1C,
	3584:  0x00026BC0,
	3585:  0x00005812,
	3586:  0x000057C8,
	3587:  0x000036D6,
	3588:  0x00021452,
	3589:  0x000070FE,
	3590:  0x00024362,
	3591:  0x00024A71,
	3592:  0x00022FE3,
	3593:  0x000212B0,
	3594:  0x000223BD,
	3595:  0x000068B9,
	3596:  0x00006967,
	3597:  0x00021398,
	3598:  0x000234E5,
	3599:  0x00027BF4,
	3600:  0x000236DF,
	3601:  0x00028A83,
	3602:  0x000237D6,
	3603:  0x000233FA,
	3604:  0x00024C9F,
	3605:  0x00006A1A,
	3606:  0x000236AD,
	3607:  0x00026CB7,
	3608:  0x0000843E,
	3609:  0x000044DF,
	3610:  0x000044CE,
	3611:  0x00026D26,
	3612:  0x00026D51,
	3613:  0x00026C82,
	3614:  0x00026FDE,
	3615:  0x00006F17,
	3616:  0x00027109,
	3617:  0x0000833D,
	3618:  0x0002173A,
	3619:  0x000083ED,
	3620:  0x00026C80,
	3621:  0x00027053,
	3622:  0x000217DB,
	3623:  0x00005989,
	3624:  0x00005A82,
	3625:  0x000217B3,
	3626:  0x00005A61,
	3627:  0x00005A71,
	3628:  0x00021905,
	3629:  0x000241FC,
	3630:  0x0000372D,
	3631:  0x000059EF,
	3632:  0x0002173C,
	3633:  0x000036C7,
	3634:  0x0000718E,
	3635:  0x00009390,
	3636:  0x0000669A,
	3637:  0x000242A5,
	3638:  0x00005A6E,
	3639:  0x00005A2B,
	3640:  0x00024293,
	3641:  0x00006A2B,
	3642:  0x00023EF9,
	3643:  0x00027736,
	3644:  0x0002445B,
	3645:  0x000242CA,
	3646:  0x0000711D,
	3647:  0x00024259,
	3648:  0x000289E1,
	3649:  0x00004FB0,
	3650:  0x00026D28,
	3651:  0x00005CC2,
	3652:  0x000244CE,
	3653:  0x00027E4D,
	3654:  0x000243BD,
	3655:  0x00006A0C,
	3656:  0x00024256,
	3657:  0x00021304,
	3658:  0x000070A6,
	3659:  0x00007133,
	3660:  0x000243E9,
	3661:  0x00003DA5,
	3662:  0x00006CDF,
	3663:  0x0002F825,
	3664:  0x00024A4F,
	3665:  0x00007E65,
	3666:  0x000059EB,
	3667:  0x00005D2F,
	3668:  0x00003DF3,
	3669:  0x00005F5C,
	3670:  0x00024A5D,
	3671:  0x000217DF,
	3672:  0x00007DA4,
	3673:  0x00008426,
	3674:  0x00005485,
	3675:  0x00023AFA,
	3676:  0x00023300,
	3677:  0x00020214,
	3678:  0x0000577E,
	3679:  0x000208D5,
	3680:  0x00020619,
	3681:  0x00003FE5,
	3682:  0x00021F9E,
	3683:  0x0002A2B6,
	3684:  0x00007003,
	3685:  0x0002915B,
	3686:  0x00005D70,
	3687:  0x0000738F,
	3688:  0x00007CD3,
	3689:  0x00028A59,
	3690:  0x00029420,
	3691:  0x00004FC8,
	3692:  0x00007FE7,
	3693:  0x000072CD,
	3694:  0x00007310,
	3695:  0x00027AF4,
	3696:  0x00007338,
	3697:  0x00007339,
	3698:  0x000256F6,
	3699:  0x00007341,
	3700:  0x00007348,
	3701:  0x00003EA9,
	3702:  0x00027B18,
	3703:  0x0000906C,
	3704:  0x000071F5,
	3705:  0x000248F2,
	3706:  0x000073E1,
	3707:  0x000081F6,
	3708:  0x00003ECA,
	3709:  0x0000770C,
	3710:  0x00003ED1,
	3711:  0x00006CA2,
	3712:  0x000056FD,
	3713:  0x00007419,
	3714:  0x0000741E,
	3715:  0x0000741F,
	3716:  0x00003EE2,
	3717:  0x00003EF0,
	3718:  0x00003EF4,
	3719:  0x00003EFA,
	3720:  0x000074D3,
	3721:  0x00003F0E,
	3722:  0x00003F53,
	3723:  0x00007542,
	3724:  0x0000756D,
	3725:  0x00007572,
	3726:  0x0000758D,
	3727:  0x00003F7C,
	3728:  0x000075C8,
	3729:  0x000075DC,
	3730:  0x00003FC0,
	3731:  0x0000764D,
	3732:  0x00003FD7,
	3733:  0x00007674,
	3734:  0x00003FDC,
	3735:  0x0000767A,
	3736:  0x00024F5C,
	3737:  0x00007188,
	3738:  0x00005623,
	3739:  0x00008980,
	3740:  0x00005869,
	3741:  0x0000401D,
	3742:  0x00007743,
	3743:  0x00004039,
	3744:  0x00006761,
	3745:  0x00004045,
	3746:  0x000035DB,
	3747:  0x00007798,
	3748:  0x0000406A,
	3749:  0x0000406F,
	3750:  0x00005C5E,
	3751:  0x000077BE,
	3752:  0x000077CB,
	3753:  0x000058F2,
	3754:  0x00007818,
	3755:  0x000070B9,
	3756:  0x0000781C,
	3757:  0x000040A8,
	3758:  0x00007839,
	3759:  0x00007847,
	3760:  0x00007851,
	3761:  0x00007866,
	3762:  0x00008448,
	3763:  0x00025535,
	3764:  0x00007933,
	3765:  0x00006803,
	3766:  0x00007932,
	3767:  0x00004103,
	3768:  0x00004109,
	3769:  0x00007991,
	3770:  0x00007999,
	3771:  0x00008FBB,
	3772:  0x00007A06,
	3773:  0x00008FBC,
	3774:  0x00004167,
	3775:  0x00007A91,
	3776:  0x000041B2,
	3777:  0x00007ABC,
	3778:  0x00008279,
	3779:  0x000041C4,
	3780:  0x00007ACF,
	3781:  0x00007ADB,
	3782:  0x000041CF,
	3783:  0x00004E21,
	3784:  0x00007B62,
	3785:  0x00007B6C,
	3786:  0x00007B7B,
	3787:  0x00007C12,
	3788:  0x00007C1B,
	3789:  0x00004260,
	3790:  0x0000427A,
	3791:  0x00007C7B,
	3792:  0x00007C9C,
	3793:  0x0000428C,
	3794:  0x00007CB8,
	3795:  0x00004294,
	3796:  0x00007CED,
	3797:  0x00008F93,
	3798:  0x000070C0,
	3799:  0x00020CCF,
	3800:  0x00007DCF,
	3801:  0x00007DD4,
	3802:  0x00007DD0,
	3803:  0x00007DFD,
	3804:  0x00007FAE,
	3805:  0x00007FB4,
	3806:  0x0000729F,
	3807:  0x00004397,
	3808:  0x00008020,
	3809:  0x00008025,
	3810:  0x00007B39,
	3811:  0x0000802E,
	3812:  0x00008031,
	3813:  0x00008054,
	3814:  0x00003DCC,
	3815:  0x000057B4,
	3816:  0x000070A0,
	3817:  0x000080B7,
	3818:  0x000080E9,
	3819:  0x000043ED,
	3820:  0x0000810C,
	3821:  0x0000732A,
	3822:  0x0000810E,
	3823:  0x00008112,
	3824:  0x00007560,
	3825:  0x00008114,
	3826:  0x00004401,
	3827:  0x00003B39,
	3828:  0x00008156,
	3829:  0x00008159,
	3830:  0x0000815A,
	3831:  0x00004413,
	3832:  0x0000583A,
	3833:  0x0000817C,
	3834:  0x00008184,
	3835:  0x00004425,
	3836:  0x00008193,
	3837:  0x0000442D,
	3838:  0x000081A5,
	3839:  0x000057EF,
	3840:  0x000081C1,
	3841:  0x000081E4,
	3842:  0x00008254,
	3843:  0x0000448F,
	3844:  0x000082A6,
	3845:  0x00008276,
	3846:  0x000082CA,
	3847:  0x000082D8,
	3848:  0x000082FF,
	3849:  0x000044B0,
	3850:  0x00008357,
	3851:  0x00009669,
	3852:  0x0000698A,
	3853:  0x00008405,
	3854:  0x000070F5,
	3855:  0x00008464,
	3856:  0x000060E3,
	3857:  0x00008488,
	3858:  0x00004504,
	3859:  0x000084BE,
	3860:  0x000084E1,
	3861:  0x000084F8,
	3862:  0x00008510,
	3863:  0x00008538,
	3864:  0x00008552,
	3865:  0x0000453B,
	3866:  0x0000856F,
	3867:  0x00008570,
	3868:  0x000085E0,
	3869:  0x00004577,
	3870:  0x00008672,
	3871:  0x00008692,
	3872:  0x000086B2,
	3873:  0x000086EF,
	3874:  0x00009645,
	3875:  0x0000878B,
	3876:  0x00004606,
	3877:  0x00004617,
	3878:  0x000088AE,
	3879:  0x000088FF,
	3880:  0x00008924,
	3881:  0x00008947,
	3882:  0x00008991,
	3883:  0x00027967,
	3884:  0x00008A29,
	3885:  0x00008A38,
	3886:  0x00008A94,
	3887:  0x00008AB4,
	3888:  0x00008C51,
	3889:  0x00008CD4,
	3890:  0x00008CF2,
	3891:  0x00008D1C,
	3892:  0x00004798,
	3893:  0x0000585F,
	3894:  0x00008DC3,
	3895:  0x000047ED,
	3896:  0x00004EEE,
	3897:  0x00008E3A,
	3898:  0x000055D8,
	3899:  0x00005754,
	3900:  0x00008E71,
	3901:  0x000055F5,
	3902:  0x00008EB0,
	3903:  0x00004837,
	3904:  0x00008ECE,
	3905:  0x00008EE2,
	3906:  0x00008EE4,
	3907:  0x00008EED,
	3908:  0x00008EF2,
	3909:  0x00008FB7,
	3910:  0x00008FC1,
	3911:  0x00008FCA,
	3912:  0x00008FCC,
	3913:  0x00009033,
	3914:  0x000099C4,
	3915:  0x000048AD,
	3916:  0x000098E0,
	3917:  0x00009213,
	3918:  0x0000491E,
	3919:  0x00009228,
	3920:  0x00009258,
	3921:  0x0000926B,
	3922:  0x000092B1,
	3923:  0x000092AE,
	3924:  0x000092BF,
	3925:  0x000092E3,
	3926:  0x000092EB,
	3927:  0x000092F3,
	3928:  0x000092F4,
	3929:  0x000092FD,
	3930:  0x00009343,
	3931:  0x00009384,
	3932:  0x000093AD,
	3933:  0x00004945,
	3934:  0x00004951,
	3935:  0x00009EBF,
	3936:  0x00009417,
	3937:  0x00005301,
	3938:  0x0000941D,
	3939:  0x0000942D,
	3940:  0x0000943E,
	3941:  0x0000496A,
	3942:  0x00009454,
	3943:  0x00009479,
	3944:  0x0000952D,
	3945:  0x000095A2,
	3946:  0x000049A7,
	3947:  0x000095F4,
	3948:  0x00009633,
	3949:  0x000049E5,
	3950:  0x000067A0,
	3951:  0x00004A24,
	3952:  0x00009740,
	3953:  0x00004A35,
	3954:  0x000097B2,
	3955:  0x000097C2,
	3956:  0x00005654,
	3957:  0x00004AE4,
	3958:  0x000060E8,
	3959:  0x000098B9,
	3960:  0x00004B19,
	3961:  0x000098F1,
	3962:  0x00005844,
	3963:  0x0000990E,
	3964:  0x00009919,
	3965:  0x000051B4,
	3966:  0x0000991C,
	3967:  0x00009937,
	3968:  0x00009942,
	3969:  0x0000995D,
	3970:  0x00009962,
	3971:  0x00004B70,
	3972:  0x000099C5,
	3973:  0x00004B9D,
	3974:  0x00009A3C,
	3975:  0x00009B0F,
	3976:  0x00007A83,
	3977:  0x00009B69,
	3978:  0x00009B81,
	3979:  0x00009BDD,
	3980:  0x00009BF1,
	3981:  0x00009BF4,
	3982:  0x00004C6D,
	3983:  0x00009C20,
	3984:  0x0000376F,
	3985:  0x00021BC2,
	3986:  0x00009D49,
	3987:  0x00009C3A,
	3988:  0x00009EFE,
	3989:  0x00005650,
	3990:  0x00009D93,
	3991:  0x00009DBD,
	3992:  0x00009DC0,
	3993:  0x00009DFC,
	3994:  0x000094F6,
	3995:  0x00008FB6,
	3996:  0x00009E7B,
	3997:  0x00009EAC,
	3998:  0x00009EB1,
	3999:  0x00009EBD,
	4000:  0x00009EC6,
	4001:  0x000094DC,
	4002:  0x00009EE2,
	4003:  0x00009EF1,
	4004:  0x00009EF8,
	4005:  0x00007AC8,
	4006:  0x00009F44,
	4007:  0x00020094,
	4008:  0x000202B7,
	4009:  0x000203A0,
	4010:  0x0000691A,
	4011:  0x000094C3,
	4012:  0x000059AC,
	4013:  0x000204D7,
	4014:  0x00005840,
	4015:  0x000094C1,
	4016:  0x000037B9,
	4017:  0x000205D5,
	4018:  0x00020615,
	4019:  0x00020676,
	4020:  0x000216BA,
	4021:  0x00005757,
	4022:  0x00007173,
	4023:  0x00020AC2,
	4024:  0x00020ACD,
	4025:  0x00020BBF,
	4026:  0x0000546A,
	4027:  0x0002F83B,
	4028:  0x00020BCB,
	4029:  0x0000549E,
	4030:  0x00020BFB,
	4031:  0x00020C3B,
	4032:  0x00020C53,
	4033:  0x00020C65,
	4034:  0x00020C7C,
	4035:  0x000060E7,
	4036:  0x00020C8D,
	4037:  0x0000567A,
	4038:  0x00020CB5,
	4039:  0x00020CDD,
	4040:  0x00020CED,
	4041:  0x00020D6F,
	4042:  0x00020DB2,
	4043:  0x00020DC8,
	4044:  0x00006955,
	4045:  0x00009C2F,
	4046:  0x000087A5,
	4047:  0x00020E04,
	4048:  0x00020E0E,
	4049:  0x00020ED7,
	4050:  0x00020F90,
	4051:  0x00020F2D,
	4052:  0x00020E73,
	4053:  0x00005C20,
	4054:  0x00020FBC,
	4055:  0x00005E0B,
	4056:  0x0002105C,
	4057:  0x0002104F,
	4058:  0x00021076,
	4059:  0x0000671E,
	4060:  0x0002107B,
	4061:  0x00021088,
	4062:  0x00021096,
	4063:  0x00003647,
	4064:  0x000210BF,
	4065:  0x000210D3,
	4066:  0x0002112F,
	4067:  0x0002113B,
	4068:  0x00005364,
	4069:  0x000084AD,
	4070:  0x000212E3,
	4071:  0x00021375,
	4072:  0x00021336,
	4073:  0x00008B81,
	4074:  0x00021577,
	4075:  0x00021619,
	4076:  0x000217C3,
	4077:  0x000217C7,
	4078:  0x00004E78,
	4079:  0x000070BB,
	4080:  0x0002182D,
	4081:  0x0002196A,
	4082:  0x00021A2D,
	4083:  0x00021A45,
	4084:  0x00021C2A,
	4085:  0x00021C70,
	4086:  0x00021CAC,
	4087:  0x00021EC8,
	4088:  0x000062C3,
	4089:  0x00021ED5,
	4090:  0x00021F15,
	4091:  0x00007198,
	4092:  0x00006855,
	4093:  0x00022045,
	4094:  0x000069E9,
	4095:  0x000036C8,
	4096:  0x0002227C,
	4097:  0x000223D7,
	4098:  0x000223FA,
	4099:  0x0002272A,
	4100:  0x00022871,
	4101:  0x0002294F,
	4102:  0x000082FD,
	4103:  0x00022967,
	4104:  0x00022993,
	4105:  0x00022AD5,
	4106:  0x000089A5,
	4107:  0x00022AE8,
	4108:  0x00008FA0,
	4109:  0x00022B0E,
	4110:  0x000097B8,
	4111:  0x00022B3F,
	4112:  0x00009847,
	4113:  0x00009ABD,
	4114:  0x00022C4C,
	4116:  0x00022C88,
	4117:  0x00022CB7,
	4118:  0x00025BE8,
	4119:  0x00022D08,
	4120:  0x00022D12,
	4121:  0x00022DB7,
	4122:  0x00022D95,
	4123:  0x00022E42,
	4124:  0x00022F74,
	4125:  0x00022FCC,
	4126:  0x00023033,
	4127:  0x00023066,
	4128:  0x0002331F,
	4129:  0x000233DE,
	4130:  0x00005FB1,
	4131:  0x00006648,
	4132:  0x000066BF,
	4133:  0x00027A79,
	4134:  0x00023567,
	4135:  0x000235F3,
	4136:  0x00007201,
	4137:  0x000249BA,
	4138:  0x000077D7,
	4139:  0x0002361A,
	4140:  0x00023716,
	4141:  0x00007E87,
	4142:  0x00020346,
	4143:  0x000058B5,
	4144:  0x0000670E,
	4145:  0x00006918,
	4146:  0x00023AA7,
	4147:  0x00027657,
	4148:  0x00025FE2,
	4149:  0x00023E11,
	4150:  0x00023EB9,
	4151:  0x000275FE,
	4152:  0x0002209A,
	4153:  0x000048D0,
	4154:  0x00004AB8,
	4155:  0x00024119,
	4156:  0x00028A9A,
	4157:  0x000242EE,
	4158:  0x0002430D,
	4159:  0x0002403B,
	4160:  0x00024334,
	4161:  0x00024396,
	4162:  0x00024A45,
	4163:  0x000205CA,
	4164:  0x000051D2,
	4165:  0x00020611,
	4166:  0x0000599F,
	4167:  0x00021EA8,
	4168:  0x00003BBE,
	4169:  0x00023CFF,
	4170:  0x00024404,
	4171:  0x000244D6,
	4172:  0x00005788,
	4173:  0x00024674,
	4174:  0x0000399B,
	4175:  0x0002472F,
	4176:  0x000285E8,
	4177:  0x000299C9,
	4178:  0x00003762,
	4179:  0x000221C3,
	4180:  0x00008B5E,
	4181:  0x00028B4E,
	4182:  0x000099D6,
	4183:  0x00024812,
	4184:  0x000248FB,
	4185:  0x00024A15,
	4186:  0x00007209,
	4187:  0x00024AC0,
	4188:  0x00020C78,
	4189:  0x00005965,
	4190:  0x00024EA5,
	4191:  0x00024F86,
	4192:  0x00020779,
	4193:  0x00008EDA,
	4194:  0x0002502C,
	4195:  0x0000528F,
	4196:  0x0000573F,
	4197:  0x00007171,
	4198:  0x00025299,
	4199:  0x00025419,
	4200:  0x00023F4A,
	4201:  0x00024AA7,
	4202:  0x000055BC,
	4203:  0x00025446,
	4204:  0x0002546E,
	4205:  0x00026B52,
	4206:  0x000091D4,
	4207:  0x00003473,
	4208:  0x0002553F,
	4209:  0x00027632,
	4210:  0x0002555E,
	4211:  0x00004718,
	4212:  0x00025562,
	4213:  0x00025566,
	4214:  0x000257C7,
	4215:  0x0002493F,
	4216:  0x0002585D,
	4217:  0x00005066,
	4218:  0x000034FB,
	4219:  0x000233CC,
	4220:  0x000060DE,
	4221:  0x00025903,
	4222:  0x0000477C,
	4223:  0x00028948,
	4224:  0x00025AAE,
	4225:  0x00025B89,
	4226:  0x00025C06,
	4227:  0x00021D90,
	4228:  0x000057A1,
	4229:  0x00007151,
	4230:  0x00006FB6,
	4231:  0x00026102,
	4232:  0x00027C12,
	4233:  0x00009056,
	4234:  0x000261B2,
	4235:  0x00024F9A,
	4236:  0x00008B62,
	4237:  0x00026402,
	4238:  0x0002644A,
	4239:  0x00005D5B,
	4240:  0x00026BF7,
	4241:  0x00008F36,
	4242:  0x00026484,
	4243:  0x0002191C,
	4244:  0x00008AEA,
	4245:  0x000249F6,
	4246:  0x00026488,
	4247:  0x00023FEF,
	4248:  0x00026512,
	4249:  0x00004BC0,
	4250:  0x000265BF,
	4251:  0x000266B5,
	4252:  0x0002271B,
	4253:  0x00009465,
	4254:  0x000257E1,
	4255:  0x00006195,
	4256:  0x00005A27,
	4257:  0x0002F8CD,
	4258:  0x00004FBB,
	4259:  0x000056B9,
	4260:  0x00024521,
	4261:  0x000266FC,
	4262:  0x00004E6A,
	4263:  0x00024934,
	4264:  0x00009656,
	4265:  0x00006D8F,
	4266:  0x00026CBD,
	4267:  0x00003618,
	4268:  0x00008977,
	4269:  0x00026799,
	4270:  0x0002686E,
	4271:  0x00026411,
	4272:  0x0002685E,
	4273:  0x000071DF,
	4274:  0x000268C7,
	4275:  0x00007B42,
	4276:  0x000290C0,
	4277:  0x00020A11,
	4278:  0x00026926,
	4279:  0x00009104,
	4280:  0x00026939,
	4281:  0x00007A45,
	4282:  0x00009DF0,
	4283:  0x000269FA,
	4284:  0x00009A26,
	4285:  0x00026A2D,
	4286:  0x0000365F,
	4287:  0x00026469,
	4288:  0x00020021,
	4289:  0x00007983,
	4290:  0x00026A34,
	4291:  0x00026B5B,
	4292:  0x00005D2C,
	4293:  0x00023519,
	4294:  0x000083CF,
	4295:  0x00026B9D,
	4296:  0x000046D0,
	4297:  0x00026CA4,
	4298:  0x0000753B,
	4299:  0x00008865,
	4300:  0x00026DAE,
	4301:  0x000058B6,
	4302:  0x0000371C,
	4303:  0x0002258D,
	4304:  0x0002704B,
	4305:  0x000271CD,
	4306:  0x00003C54,
	4307:  0x00027280,
	4308:  0x00027285,
	4309:  0x00009281,
	4310:  0x0002217A,
	4311:  0x0002728B,
	4312:  0x00009330,
	4313:  0x000272E6,
	4314:  0x000249D0,
	4315:  0x00006C39,
	4316:  0x0000949F,
	4317:  0x00027450,
	4318:  0x00020EF8,
	4319:  0x00008827,
	4320:  0x000088F5,
	4321:  0x00022926,
	4322:  0x00028473,
	4323:  0x000217B1,
	4324:  0x00006EB8,
	4325:  0x00024A2A,
	4326:  0x00021820,
	4327:  0x000039A4,
	4328:  0x000036B9,
	4329:  0x00005C10,
	4330:  0x000079E3,
	4331:  0x0000453F,
	4332:  0x000066B6,
	4333:  0x00029CAD,
	4334:  0x000298A4,
	4335:  0x00008943,
	4336:  0x000277CC,
	4337:  0x00027858,
	4338:  0x000056D6,
	4339:  0x000040DF,
	4340:  0x0002160A,
	4341:  0x000039A1,
	4342:  0x0002372F,
	4343:  0x000280E8,
	4344:  0x000213C5,
	4345:  0x000071AD,
	4346:  0x00008366,
	4347:  0x000279DD,
	4348:  0x000291A8,
	4349:  0x00005A67,
	4350:  0x00004CB7,
	4351:  0x000270AF,
	4352:  0x000289AB,
	4353:  0x000279FD,
	4354:  0x00027A0A,
	4355:  0x00027B0B,
	4356:  0x00027D66,
	4357:  0x0002417A,
	4358:  0x00007B43,
	4359:  0x0000797E,
	4360:  0x00028009,
	4361:  0x00006FB5,
	4362:  0x0002A2DF,
	4363:  0x00006A03,
	4364:  0x00028318,
	4365:  0x000053A2,
	4366:  0x00026E07,
	4367:  0x000093BF,
	4368:  0x00006836,
	4369:  0x0000975D,
	4370:  0x0002816F,
	4371:  0x00028023,
	4372:  0x000269B5,
	4373:  0x000213ED,
	4374:  0x0002322F,
	4375:  0x00028048,
	4376:  0x00005D85,
	4377:  0x00028C30,
	4378:  0x00028083,
	4379:  0x00005715,
	4380:  0x00009823,
	4381:  0x00028949,
	4382:  0x00005DAB,
	4383:  0x00024988,
	4384:  0x000065BE,
	4385:  0x000069D5,
	4386:  0x000053D2,
	4387:  0x00024AA5,
	4388:  0x00023F81,
	4389:  0x00003C11,
	4390:  0x00006736,
	4391:  0x00028090,
	4392:  0x000280F4,
	4393:  0x0002812E,
	4394:  0x00021FA1,
	4395:  0x0002814F,
	4396:  0x00028189,
	4397:  0x000281AF,
	4398:  0x0002821A,
	4399:  0x00028306,
	4400:  0x0002832F,
	4401:  0x0002838A,
	4402:  0x000035CA,
	4403:  0x00028468,
	4404:  0x000286AA,
	4405:  0x000048FA,
	4406:  0x000063E6,
	4407:  0x00028956,
	4408:  0x00007808,
	4409:  0x00009255,
	4410:  0x000289B8,
	4411:  0x000043F2,
	4412:  0x000289E7,
	4413:  0x000043DF,
	4414:  0x000289E8,
	4415:  0x00028B46,
	4416:  0x00028BD4,
	4417:  0x000059F8,
	4418:  0x00028C09,
	4419:  0x00008F0B,
	4420:  0x00028FC5,
	4421:  0x000290EC,
	4422:  0x00007B51,
	4423:  0x00029110,
	4424:  0x0002913C,
	4425:  0x00003DF7,
	4426:  0x0002915E,
	4427:  0x00024ACA,
	4428:  0x00008FD0,
	4429:  0x0000728F,
	4430:  0x0000568B,
	4431:  0x000294E7,
	4432:  0x000295E9,
	4433:  0x000295B0,
	4434:  0x000295B8,
	4435:  0x00029732,
	4436:  0x000298D1,
	4437:  0x00029949,
	4438:  0x0002996A,
	4439:  0x000299C3,
	4440:  0x00029A28,
	4441:  0x00029B0E,
	4442:  0x00029D5A,
	4443:  0x00029D9B,
	4444:  0x00007E9F,
	4445:  0x00029EF8,
	4446:  0x00029F23,
	4447:  0x00004CA4,
	4448:  0x00009547,
	4449:  0x0002A293,
	4450:  0x000071A2,
	4451:  0x0002A2FF,
	4452:  0x00004D91,
	4453:  0x00009012,
	4454:  0x0002A5CB,
	4455:  0x00004D9C,
	4456:  0x00020C9C,
	4457:  0x00008FBE,
	4458:  0x000055C1,
	4459:  0x00008FBA,
	4460:  0x000224B0,
	4461:  0x00008FB9,
	4462:  0x00024A93,
	4463:  0x00004509,
	4464:  0x00007E7F,
	4465:  0x00006F56,
	4466:  0x00006AB1,
	4467:  0x00004EEA,
	4468:  0x000034E4,
	4469:  0x00028B2C,
	4470:  0x0002789D,
	4471:  0x0000373A,
	4472:  0x00008E80,
	4473:  0x000217F5,
	4474:  0x00028024,
	4475:  0x00028B6C,
	4476:  0x00028B99,
	4477:  0x00027A3E,
	4478:  0x000266AF,
	4479:  0x00003DEB,
	4480:  0x00027655,
	4481:  0x00023CB7,
	4482:  0x00025635,
	4483:  0x00025956,
	4484:  0x00004E9A,
	4485:  0x00025E81,
	4486:  0x00026258,
	4487:  0x000056BF,
	4488:  0x00020E6D,
	4489:  0x00008E0E,
	4490:  0x00005B6D,
	4491:  0x00023E88,
	4492:  0x00024C9E,
	4493:  0x000063DE,
	4494:  0x000062D0,
	4495:  0x000217F6,
	4496:  0x0002187B,
	4497:  0x00006530,
	4498:  0x0000562D,
	4499:  0x00025C4A,
	4500:  0x0000541A,
	4501:  0x00025311,
	4502:  0x00003DC6,
	4503:  0x00029D98,
	4504:  0x00004C7D,
	4505:  0x00005622,
	4506:  0x0000561E,
	4507:  0x00007F49,
	4508:  0x00025ED8,
	4509:  0x00005975,
	4510:  0x00023D40,
	4511:  0x00008770,
	4512:  0x00004E1C,
	4513:  0x00020FEA,
	4514:  0x00020D49,
	4515:  0x000236BA,
	4516:  0x00008117,
	4517:  0x00009D5E,
	4518:  0x00008D18,
	4519:  0x0000763B,
	4520:  0x00009C45,
	4521:  0x0000764E,
	4522:  0x000077B9,
	4523:  0x00009345,
	4524:  0x00005432,
	4525:  0x00008148,
	4526:  0x000082F7,
	4527:  0x00005625,
	4528:  0x00008132,
	4529:  0x00008418,
	4530:  0x000080BD,
	4531:  0x000055EA,
	4532:  0x00007962,
	4533:  0x00005643,
	4534:  0x00005416,
	4535:  0x00020E9D,
	4536:  0x000035CE,
	4537:  0x00005605,
	4538:  0x000055F1,
	4539:  0x000066F1,
	4540:  0x000282E2,
	4541:  0x0000362D,
	4542:  0x00007534,
	4543:  0x000055F0,
	4544:  0x000055BA,
	4545:  0x00005497,
	4546:  0x00005572,
	4547:  0x00020C41,
	4548:  0x00020C96,
	4549:  0x00005ED0,
	4550:  0x00025148,
	4551:  0x00020E76,
	4552:  0x00022C62,
	4553:  0x00020EA2,
	4554:  0x00009EAB,
	4555:  0x00007D5A,
	4556:  0x000055DE,
	4557:  0x00021075,
	4558:  0x0000629D,
	4559:  0x0000976D,
	4560:  0x00005494,
	4561:  0x00008CCD,
	4562:  0x000071F6,
	4563:  0x00009176,
	4564:  0x000063FC,
	4565:  0x000063B9,
	4566:  0x000063FE,
	4567:  0x00005569,
	4568:  0x00022B43,
	4569:  0x00009C72,
	4570:  0x00022EB3,
	4571:  0x0000519A,
	4572:  0x000034DF,
	4573:  0x00020DA7,
	4574:  0x000051A7,
	4575:  0x0000544D,
	4576:  0x0000551E,
	4577:  0x00005513,
	4578:  0x00007666,
	4579:  0x00008E2D,
	4580:  0x0002688A,
	4581:  0x000075B1,
	4582:  0x000080B6,
	4583:  0x00008804,
	4584:  0x00008786,
	4585:  0x000088C7,
	4586:  0x000081B6,
	4587:  0x0000841C,
	4588:  0x000210C1,
	4589:  0x000044EC,
	4590:  0x00007304,
	4591:  0x00024706,
	4592:  0x00005B90,
	4593:  0x0000830B,
	4594:  0x00026893,
	4595:  0x0000567B,
	4596:  0x000226F4,
	4597:  0x00027D2F,
	4598:  0x000241A3,
	4599:  0x00027D73,
	4600:  0x00026ED0,
	4601:  0x000272B6,
	4602:  0x00009170,
	4603:  0x000211D9,
	4604:  0x00009208,
	4605:  0x00023CFC,
	4606:  0x0002A6A9,
	4607:  0x00020EAC,
	4608:  0x00020EF9,
	4609:  0x00007266,
	4610:  0x00021CA2,
	4611:  0x0000474E,
	4612:  0x00024FC2,
	4613:  0x00027FF9,
	4614:  0x00020FEB,
	4615:  0x000040FA,
	4616:  0x00009C5D,
	4617:  0x0000651F,
	4618:  0x00022DA0,
	4619:  0x000048F3,
	4620:  0x000247E0,
	4621:  0x00029D7C,
	4622:  0x00020FEC,
	4623:  0x00020E0A,
	4624:  0x00006062,
	4625:  0x000275A3,
	4626:  0x00020FED,
	4628:  0x00026048,
	4629:  0x00021187,
	4630:  0x000071A3,
	4631:  0x00007E8E,
	4632:  0x00009D50,
	4633:  0x00004E1A,
	4634:  0x00004E04,
	4635:  0x00003577,
	4636:  0x00005B0D,
	4637:  0x00006CB2,
	4638:  0x00005367,
	4639:  0x000036AC,
	4640:  0x000039DC,
	4641:  0x0000537D,
	4642:  0x000036A5,
	4643:  0x00024618,
	4644:  0x0000589A,
	4645:  0x00024B6E,
	4646:  0x0000822D,
	4647:  0x0000544B,
	4648:  0x000057AA,
	4649:  0x00025A95,
	4650:  0x00020979,
	4652:  0x00003A52,
	4653:  0x00022465,
	4654:  0x00007374,
	4655:  0x00029EAC,
	4656:  0x00004D09,
	4657:  0x00009BED,
	4658:  0x00023CFE,
	4659:  0x00029F30,
	4660:  0x00004C5B,
	4661:  0x00024FA9,
	4662:  0x0002959E,
	4663:  0x00029FDE,
	4664:  0x0000845C,
	4665:  0x00023DB6,
	4666:  0x000272B2,
	4667:  0x000267B3,
	4668:  0x00023720,
	4669:  0x0000632E,
	4670:  0x00007D25,
	4671:  0x00023EF7,
	4672:  0x00023E2C,
	4673:  0x00003A2A,
	4674:  0x00009008,
	4675:  0x000052CC,
	4676:  0x00003E74,
	4677:  0x0000367A,
	4678:  0x000045E9,
	4679:  0x0002048E,
	4680:  0x00007640,
	4681:  0x00005AF0,
	4682:  0x00020EB6,
	4683:  0x0000787A,
	4684:  0x00027F2E,
	4685:  0x000058A7,
	4686:  0x000040BF,
	4687:  0x0000567C,
	4688:  0x00009B8B,
	4689:  0x00005D74,
	4690:  0x00007654,
	4691:  0x0002A434,
	4692:  0x00009E85,
	4693:  0x00004CE1,
	4694:  0x000075F9,
	4695:  0x000037FB,
	4696:  0x00006119,
	4697:  0x000230DA,
	4698:  0x000243F2,
	4700:  0x0000565D,
	4701:  0x000212A9,
	4702:  0x000057A7,
	4703:  0x00024963,
	4704:  0x00029E06,
	4705:  0x00005234,
	4706:  0x000270AE,
	4707:  0x000035AD,
	4708:  0x00006C4A,
	4709:  0x00009D7C,
	4710:  0x00007C56,
	4711:  0x00009B39,
	4712:  0x000057DE,
	4713:  0x0002176C,
	4714:  0x00005C53,
	4715:  0x000064D3,
	4716:  0x000294D0,
	4717:  0x00026335,
	4718:  0x00027164,
	4719:  0x000086AD,
	4720:  0x00020D28,
	4721:  0x00026D22,
	4722:  0x00024AE2,
	4723:  0x00020D71,
	4725:  0x000051FE,
	4726:  0x00021F0F,
	4727:  0x00005D8E,
	4728:  0x00009703,
	4729:  0x00021DD1,
	4730:  0x00009E81,
	4731:  0x0000904C,
	4732:  0x00007B1F,
	4733:  0x00009B02,
	4734:  0x00005CD1,
	4735:  0x00007BA3,
	4736:  0x00006268,
	4737:  0x00006335,
	4738:  0x00009AFF,
	4739:  0x00007BCF,
	4740:  0x00009B2A,
	4741:  0x00007C7E,
	4742:  0x00009B2E,
	4743:  0x00007C42,
	4744:  0x00007C86,
	4745:  0x00009C15,
	4746:  0x00007BFC,
	4747:  0x00009B09,
	4748:  0x00009F17,
	4749:  0x00009C1B,
	4750:  0x0002493E,
	4751:  0x00009F5A,
	4752:  0x00005573,
	4753:  0x00005BC3,
	4754:  0x00004FFD,
	4755:  0x00009E98,
	4756:  0x00004FF2,
	4757:  0x00005260,
	4758:  0x00003E06,
	4759:  0x000052D1,
	4760:  0x00005767,
	4761:  0x00005056,
	4762:  0x000059B7,
	4763:  0x00005E12,
	4764:  0x000097C8,
	4765:  0x00009DAB,
	4766:  0x00008F5C,
	4767:  0x00005469,
	4768:  0x000097B4,
	4769:  0x00009940,
	4770:  0x000097BA,
	4771:  0x0000532C,
	4772:  0x00006130,
	4773:  0x0000692C,
	4774:  0x000053DA,
	4775:  0x00009C0A,
	4776:  0x00009D02,
	4777:  0x00004C3B,
	4778:  0x00009641,
	4779:  0x00006980,
	4780:  0x000050A6,
	4781:  0x00007546,
	4782:  0x0002176D,
	4783:  0x000099DA,
	4784:  0x00005273,
	4786:  0x00009159,
	4787:  0x00009681,
	4788:  0x0000915C,
	4790:  0x00009151,
	4791:  0x00028E97,
	4792:  0x0000637F,
	4793:  0x00026D23,
	4794:  0x00006ACA,
	4795:  0x00005611,
	4796:  0x0000918E,
	4797:  0x0000757A,
	4798:  0x00006285,
	4799:  0x000203FC,
	4800:  0x0000734F,
	4801:  0x00007C70,
	4802:  0x00025C21,
	4803:  0x00023CFD,
	4805:  0x00024919,
	4806:  0x000076D6,
	4807:  0x00009B9D,
	4808:  0x00004E2A,
	4809:  0x00020CD4,
	4810:  0x000083BE,
	4811:  0x00008842,
	4813:  0x00005C4A,
	4814:  0x000069C0,
	4815:  0x000050ED,
	4816:  0x0000577A,
	4817:  0x0000521F,
	4818:  0x00005DF5,
	4819:  0x00004ECE,
	4820:  0x00006C31,
	4821:  0x000201F2,
	4822:  0x00004F39,
	4823:  0x0000549C,
	4824:  0x000054DA,
	4825:  0x0000529A,
	4826:  0x00008D82,
	4827:  0x000035FE,
	4828:  0x00005F0C,
	4829:  0x000035F3,
	4831:  0x00006B52,
	4832:  0x0000917C,
	4833:  0x00009FA5,
	4834:  0x00009B97,
	4835:  0x0000982E,
	4836:  0x000098B4,
	4837:  0x00009ABA,
	4838:  0x00009EA8,
	4839:  0x00009E84,
	4840:  0x0000717A,
	4841:  0x00007B14,
	4843:  0x00006BFA,
	4844:  0x00008818,
	4845:  0x00007F78,
	4847:  0x00005620,
	4848:  0x0002A64A,
	4849:  0x00008E77,
	4850:  0x00009F53,
	4852:  0x00008DD4,
	4853:  0x00008E4F,
	4854:  0x00009E1C,
	4855:  0x00008E01,
	4856:  0x00006282,
	4857:  0x0002837D,
	4858:  0x00008E28,
	4859:  0x00008E75,
	4860:  0x00007AD3,
	4861:  0x00024A77,
	4862:  0x00007A3E,
	4863:  0x000078D8,
	4864:  0x00006CEA,
	4865:  0x00008A67,
	4866:  0x00007607,
	4867:  0x00028A5A,
	4868:  0x00009F26,
	4869:  0x00006CCE,
	4870:  0x000087D6,
	4871:  0x000075C3,
	4872:  0x0002A2B2,
	4873:  0x00007853,
	4874:  0x0002F840,
	4875:  0x00008D0C,
	4876:  0x000072E2,
	4877:  0x00007371,
	4878:  0x00008B2D,
	4879:  0x00007302,
	4880:  0x000074F1,
	4881:  0x00008CEB,
	4882:  0x00024ABB,
	4883:  0x0000862F,
	4884:  0x00005FBA,
	4885:  0x000088A0,
	4886:  0x000044B7,
	4888:  0x0002183B,
	4889:  0x00026E05,
	4891:  0x00008A7E,
	4892:  0x0002251B,
	4894:  0x000060FD,
	4895:  0x00007667,
	4896:  0x00009AD7,
	4897:  0x00009D44,
	4898:  0x0000936E,
	4899:  0x00009B8F,
	4900:  0x000087F5,
	4902:  0x0000880F,
	4903:  0x00008CF7,
	4904:  0x0000732C,
	4905:  0x00009721,
	4906:  0x00009BB0,
	4907:  0x000035D6,
	4908:  0x000072B2,
	4909:  0x00004C07,
	4910:  0x00007C51,
	4911:  0x0000994A,
	4912:  0x00026159,
	4913:  0x00006159,
	4914:  0x00004C04,
	4915:  0x00009E96,
	4916:  0x0000617D,
	4918:  0x0000575F,
	4919:  0x0000616F,
	4920:  0x000062A6,
	4921:  0x00006239,
	4922:  0x000062CE,
	4923:  0x00003A5C,
	4924:  0x000061E2,
	4925:  0x000053AA,
	4926:  0x000233F5,
	4927:  0x00006364,
	4928:  0x00006802,
	4929:  0x000035D2,
	4930:  0x00005D57,
	4931:  0x00028BC2,
	4932:  0x00008FDA,
	4933:  0x00028E39,
	4935:  0x000050D9,
	4936:  0x00021D46,
	4937:  0x00007906,
	4938:  0x00005332,
	4939:  0x00009638,
	4940:  0x00020F3B,
	4941:  0x00004065,
	4943:  0x000077FE,
	4945:  0x00007CC2,
	4946:  0x00025F1A,
	4947:  0x00007CDA,
	4948:  0x00007A2D,
	4949:  0x00008066,
	4950:  0x00008063,
	4951:  0x00007D4D,
	4952:  0x00007505,
	4953:  0x000074F2,
	4954:  0x00008994,
	4955:  0x0000821A,
	4956:  0x0000670C,
	4957:  0x00008062,
	4958:  0x00027486,
	4959:  0x0000805B,
	4960:  0x000074F0,
	4961:  0x00008103,
	4962:  0x00007724,
	4963:  0x00008989,
	4964:  0x000267CC,
	4965:  0x00007553,
	4966:  0x00026ED1,
	4967:  0x000087A9,
	4968:  0x000087CE,
	4969:  0x000081C8,
	4970:  0x0000878C,
	4971:  0x00008A49,
	4972:  0x00008CAD,
	4973:  0x00008B43,
	4974:  0x0000772B,
	4975:  0x000074F8,
	4976:  0x000084DA,
	4977:  0x00003635,
	4978:  0x000069B2,
	4979:  0x00008DA6,
	4981:  0x000089A9,
	4982:  0x00007468,
	4983:  0x00006DB9,
	4984:  0x000087C1,
	4985:  0x00024011,
	4986:  0x000074E7,
	4987:  0x00003DDB,
	4988:  0x00007176,
	4989:  0x000060A4,
	4990:  0x0000619C,
	4991:  0x00003CD1,
	4992:  0x00007162,
	4993:  0x00006077,
	4995:  0x00007F71,
	4996:  0x00028B2D,
	4997:  0x00007250,
	4998:  0x000060E9,
	4999:  0x00004B7E,
	5000:  0x00005220,
	5001:  0x00003C18,
	5002:  0x00023CC7,
	5003:  0x00025ED7,
	5004:  0x00027656,
	5005:  0x00025531,
	5006:  0x00021944,
	5007:  0x000212FE,
	5008:  0x00029903,
	5009:  0x00026DDC,
	5010:  0x000270AD,
	5011:  0x00005CC1,
	5012:  0x000261AD,
	5013:  0x00028A0F,
	5014:  0x00023677,
	5015:  0x000200EE,
	5016:  0x00026846,
	5017:  0x00024F0E,
	5018:  0x00004562,
	5019:  0x00005B1F,
	5020:  0x0002634C,
	5021:  0x00009F50,
	5022:  0x00009EA6,
	5023:  0x0002626B,
	5024:  0x00003000,
	5025:  0x0000FF0C,
	5026:  0x00003001,
	5027:  0x00003002,
	5028:  0x0000FF0E,
	5029:  0x00002027,
	5030:  0x0000FF1B,
	5031:  0x0000FF1A,
	5032:  0x0000FF1F,
	5033:  0x0000FF01,
	5034:  0x0000FE30,
	5035:  0x00002026,
	5036:  0x00002025,
	5037:  0x0000FE50,
	5038:  0x0000FE51,
	5039:  0x0000FE52,
	5040:  0x000000B7,
	5041:  0x0000FE54,
	5042:  0x0000FE55,
	5043:  0x0000FE56,
	5044:  0x0000FE57,
	5045:  0x0000FF5C,
	5046:  0x00002013,
	5047:  0x0000FE31,
	5048:  0x00002014,
	5049:  0x0000FE33,
	5050:  0x00002574,
	5051:  0x0000FE34,
	5052:  0x0000FE4F,
	5053:  0x0000FF08,
	5054:  0x0000FF09,
	5055:  0x0000FE35,
	5056:  0x0000FE36,
	5057:  0x0000FF5B,
	5058:  0x0000FF5D,
	5059:  0x0000FE37,
	5060:  0x0000FE38,
	5061:  0x00003014,
	5062:  0x00003015,
	5063:  0x0000FE39,
	5064:  0x0000FE3A,
	5065:  0x00003010,
	5066:  0x00003011,
	5067:  0x0000FE3B,
	5068:  0x0000FE3C,
	5069:  0x0000300A,
	5070:  0x0000300B,
	5071:  0x0000FE3D,
	5072:  0x0000FE3E,
	5073:  0x00003008,
	5074:  0x00003009,
	5075:  0x0000FE3F,
	5076:  0x0000FE40,
	5077:  0x0000300C,
	5078:  0x0000300D,
	5079:  0x0000FE41,
	5080:  0x0000FE42,
	5081:  0x0000300E,
	5082:  0x0000300F,
	5083:  0x0000FE43,
	5084:  0x0000FE44,
	5085:  0x0000FE59,
	5086:  0x0000FE5A,
	5087:  0x0000FE5B,
	5088:  0x0000FE5C,
	5089:  0x0000FE5D,
	5090:  0x0000FE5E,
	5091:  0x00002018,
	5092:  0x00002019,
	5093:  0x0000201C,
	5094:  0x0000201D,
	5095:  0x0000301D,
	5096:  0x0000301E,
	5097:  0x00002035,
	5098:  0x00002032,
	5099:  0x0000FF03,
	5100:  0x0000FF06,
	5101:  0x0000FF0A,
	5102:  0x0000203B,
	5103:  0x000000A7,
	5104:  0x00003003,
	5105:  0x000025CB,
	5106:  0x000025CF,
	5107:  0x000025B3,
	5108:  0x000025B2,
	5109:  0x000025CE,
	5110:  0x00002606,
	5111:  0x00002605,
	5112:  0x000025C7,
	5113:  0x000025C6,
	5114:  0x000025A1,
	5115:  0x000025A0,
	5116:  0x000025BD,
	5117:  0x000025BC,
	5118:  0x000032A3,
	5119:  0x00002105,
	5120:  0x000000AF,
	5121:  0x0000FFE3,
	5122:  0x0000FF3F,
	5123:  0x000002CD,
	5124:  0x0000FE49,
	5125:  0x0000FE4A,
	5126:  0x0000FE4D,
	5127:  0x0000FE4E,
	5128:  0x0000FE4B,
	5129:  0x0000FE4C,
	5130:  0x0000FE5F,
	5131:  0x0000FE60,
	5132:  0x0000FE61,
	5133:  0x0000FF0B,
	5134:  0x0000FF0D,
	5135:  0x000000D7,
	5136:  0x000000F7,
	5137:  0x000000B1,
	5138:  0x0000221A,
	5139:  0x0000FF1C,
	5140:  0x0000FF1E,
	5141:  0x0000FF1D,
	5142:  0x00002266,
	5143:  0x00002267,
	5144:  0x00002260,
	5145:  0x0000221E,
	5146:  0x00002252,
	5147:  0x00002261,
	5148:  0x0000FE62,
	5149:  0x0000FE63,
	5150:  0x0000FE64,
	5151:  0x0000FE65,
	5152:  0x0000FE66,
	5153:  0x0000FF5E,
	5154:  0x00002229,
	5155:  0x0000222A,
	5156:  0x000022A5,
	5157:  0x00002220,
	5158:  0x0000221F,
	5159:  0x000022BF,
	5160:  0x000033D2,
	5161:  0x000033D1,
	5162:  0x0000222B,
	5163:  0x0000222E,
	5164:  0x00002235,
	5165:  0x00002234,
	5166:  0x00002640,
	5167:  0x00002642,
	5168:  0x00002295,
	5169:  0x00002299,
	5170:  0x00002191,
	5171:  0x00002193,
	5172:  0x00002190,
	5173:  0x00002192,
	5174:  0x00002196,
	5175:  0x00002197,
	5176:  0x00002199,
	5177:  0x00002198,
	5178:  0x00002225,
	5179:  0x00002223,
	5180:  0x0000FF0F,
	5181:  0x0000FF3C,
	5182:  0x00002215,
	5183:  0x0000FE68,
	5184:  0x0000FF04,
	5185:  0x0000FFE5,
	5186:  0x00003012,
	5187:  0x0000FFE0,
	5188:  0x0000FFE1,
	5189:  0x0000FF05,
	5190:  0x0000FF20,
	5191:  0x00002103,
	5192:  0x00002109,
	5193:  0x0000FE69,
	5194:  0x0000FE6A,
	5195:  0x0000FE6B,
	5196:  0x000033D5,
	5197:  0x0000339C,
	5198:  0x0000339D,
	5199:  0x0000339E,
	5200:  0x000033CE,
	5201:  0x000033A1,
	5202:  0x0000338E,
	5203:  0x0000338F,
	5204:  0x000033C4,
	5205:  0x000000B0,
	5206:  0x00005159,
	5207:  0x0000515B,
	5208:  0x0000515E,
	5209:  0x0000515D,
	5210:  0x00005161,
	5211:  0x00005163,
	5212:  0x000055E7,
	5213:  0x000074E9,
	5214:  0x00007CCE,
	5215:  0x00002581,
	5216:  0x00002582,
	5217:  0x00002583,
	5218:  0x00002584,
	5219:  0x00002585,
	5220:  0x00002586,
	5221:  0x00002587,
	5222:  0x00002588,
	5223:  0x0000258F,
	5224:  0x0000258E,
	5225:  0x0000258D,
	5226:  0x0000258C,
	5227:  0x0000258B,
	5228:  0x0000258A,
	5229:  0x00002589,
	5230:  0x0000253C,
	5231:  0x00002534,
	5232:  0x0000252C,
	5233:  0x00002524,
	5234:  0x0000251C,
	5235:  0x00002594,
	5236:  0x00002500,
	5237:  0x00002502,
	5238:  0x00002595,
	5239:  0x0000250C,
	5240:  0x00002510,
	5241:  0x00002514,
	5242:  0x00002518,
	5243:  0x0000256D,
	5244:  0x0000256E,
	5245:  0x00002570,
	5246:  0x0000256F,
	5247:  0x00002550,
	5248:  0x0000255E,
	5249:  0x0000256A,
	5250:  0x00002561,
	5251:  0x000025E2,
	5252:  0x000025E3,
	5253:  0x000025E5,
	5254:  0x000025E4,
	5255:  0x00002571,
	5256:  0x00002572,
	5257:  0x00002573,
	5258:  0x0000FF10,
	5259:  0x0000FF11,
	5260:  0x0000FF12,
	5261:  0x0000FF13,
	5262:  0x0000FF14,
	5263:  0x0000FF15,
	5264:  0x0000FF16,
	5265:  0x0000FF17,
	5266:  0x0000FF18,
	5267:  0x0000FF19,
	5268:  0x00002160,
	5269:  0x00002161,
	5270:  0x00002162,
	5271:  0x00002163,
	5272:  0x00002164,
	5273:  0x00002165,
	5274:  0x00002166,
	5275:  0x00002167,
	5276:  0x00002168,
	5277:  0x00002169,
	5278:  0x00003021,
	5279:  0x00003022,
	5280:  0x00003023,
	5281:  0x00003024,
	5282:  0x00003025,
	5283:  0x00003026,
	5284:  0x00003027,
	5285:  0x00003028,
	5286:  0x00003029,
	5287:  0x00005341,
	5288:  0x00005344,
	5289:  0x00005345,
	5290:  0x0000FF21,
	5291:  0x0000FF22,
	5292:  0x0000FF23,
	5293:  0x0000FF24,
	5294:  0x0000FF25,
	5295:  0x0000FF26,
	5296:  0x0000FF27,
	5297:  0x0000FF28,
	5298:  0x0000FF29,
	5299:  0x0000FF2A,
	5300:  0x0000FF2B,
	5301:  0x0000FF2C,
	5302:  0x0000FF2D,
	5303:  0x0000FF2E,
	5304:  0x0000FF2F,
	5305:  0x0000FF30,
	5306:  0x0000FF31,
	5307:  0x0000FF32,
	5308:  0x0000FF33,
	5309:  0x0000FF34,
	5310:  0x0000FF35,
	5311:  0x0000FF36,
	5312:  0x0000FF37,
	5313:  0x0000FF38,
	5314:  0x0000FF39,
	5315:  0x0000FF3A,
	5316:  0x0000FF41,
	5317:  0x0000FF42,
	5318:  0x0000FF43,
	5319:  0x0000FF44,
	5320:  0x0000FF45,
	5321:  0x0000FF46,
	5322:  0x0000FF47,
	5323:  0x0000FF48,
	5324:  0x0000FF49,
	5325:  0x0000FF4A,
	5326:  0x0000FF4B,
	5327:  0x0000FF4C,
	5328:  0x0000FF4D,
	5329:  0x0000FF4E,
	5330:  0x0000FF4F,
	5331:  0x0000FF50,
	5332:  0x0000FF51,
	5333:  0x0000FF52,
	5334:  0x0000FF53,
	5335:  0x0000FF54,
	5336:  0x0000FF55,
	5337:  0x0000FF56,
	5338:  0x0000FF57,
	5339:  0x0000FF58,
	5340:  0x0000FF59,
	5341:  0x0000FF5A,
	5342:  0x00000391,
	5343:  0x00000392,
	5344:  0x00000393,
	5345:  0x00000394,
	5346:  0x00000395,
	5347:  0x00000396,
	5348:  0x00000397,
	5349:  0x00000398,
	5350:  0x00000399,
	5351:  0x0000039A,
	5352:  0x0000039B,
	5353:  0x0000039C,
	5354:  0x0000039D,
	5355:  0x0000039E,
	5356:  0x0000039F,
	5357:  0x000003A0,
	5358:  0x000003A1,
	5359:  0x000003A3,
	5360:  0x000003A4,
	5361:  0x000003A5,
	5362:  0x000003A6,
	5363:  0x000003A7,
	5364:  0x000003A8,
	5365:  0x000003A9,
	5366:  0x000003B1,
	5367:  0x000003B2,
	5368:  0x000003B3,
	5369:  0x000003B4,
	5370:  0x000003B5,
	5371:  0x000003B6,
	5372:  0x000003B7,
	5373:  0x000003B8,
	5374:  0x000003B9,
	5375:  0x000003BA,
	5376:  0x000003BB,
	5377:  0x000003BC,
	5378:  0x000003BD,
	5379:  0x000003BE,
	5380:  0x000003BF,
	5381:  0x000003C0,
	5382:  0x000003C1,
	5383:  0x000003C3,
	5384:  0x000003C4,
	5385:  0x000003C5,
	5386:  0x000003C6,
	5387:  0x000003C7,
	5388:  0x000003C8,
	5389:  0x000003C9,
	5390:  0x00003105,
	5391:  0x00003106,
	5392:  0x00003107,
	5393:  0x00003108,
	5394:  0x00003109,
	5395:  0x0000310A,
	5396:  0x0000310B,
	5397:  0x0000310C,
	5398:  0x0000310D,
	5399:  0x0000310E,
	5400:  0x0000310F,
	5401:  0x00003110,
	5402:  0x00003111,
	5403:  0x00003112,
	5404:  0x00003113,
	5405:  0x00003114,
	5406:  0x00003115,
	5407:  0x00003116,
	5408:  0x00003117,
	5409:  0x00003118,
	5410:  0x00003119,
	5411:  0x0000311A,
	5412:  0x0000311B,
	5413:  0x0000311C,
	5414:  0x0000311D,
	5415:  0x0000311E,
	5416:  0x0000311F,
	5417:  0x00003120,
	5418:  0x00003121,
	5419:  0x00003122,
	5420:  0x00003123,
	5421:  0x00003124,
	5422:  0x00003125,
	5423:  0x00003126,
	5424:  0x00003127,
	5425:  0x00003128,
	5426:  0x00003129,
	5427:  0x000002D9,
	5428:  0x000002C9,
	5429:  0x000002CA,
	5430:  0x000002C7,
	5431:  0x000002CB,
	5432:  0x00002400,
	5433:  0x00002401,
	5434:  0x00002402,
	5435:  0x00002403,
	5436:  0x00002404,
	5437:  0x00002405,
	5438:  0x00002406,
	5439:  0x00002407,
	5440:  0x00002408,
	5441:  0x00002409,
	5442:  0x0000240A,
	5443:  0x0000240B,
	5444:  0x0000240C,
	5445:  0x0000240D,
	5446:  0x0000240E,
	5447:  0x0000240F,
	5448:  0x00002410,
	5449:  0x00002411,
	5450:  0x00002412,
	5451:  0x00002413,
	5452:  0x00002414,
	5453:  0x00002415,
	5454:  0x00002416,
	5455:  0x00002417,
	5456:  0x00002418,
	5457:  0x00002419,
	5458:  0x0000241A,
	5459:  0x0000241B,
	5460:  0x0000241C,
	5461:  0x0000241D,
	5462:  0x0000241E,
	5463:  0x0000241F,
	5464:  0x00002421,
	5465:  0x000020AC,
	5495:  0x00004E00,
	5496:  0x00004E59,
	5497:  0x00004E01,
	5498:  0x00004E03,
	5499:  0x00004E43,
	5500:  0x00004E5D,
	5501:  0x00004E86,
	5502:  0x00004E8C,
	5503:  0x00004EBA,
	5504:  0x0000513F,
	5505:  0x00005165,
	5506:  0x0000516B,
	5507:  0x000051E0,
	5508:  0x00005200,
	5509:  0x00005201,
	5510:  0x0000529B,
	5511:  0x00005315,
	5512:  0x00005341,
	5513:  0x0000535C,
	5514:  0x000053C8,
	5515:  0x00004E09,
	5516:  0x00004E0B,
	5517:  0x00004E08,
	5518:  0x00004E0A,
	5519:  0x00004E2B,
	5520:  0x00004E38,
	5521:  0x000051E1,
	5522:  0x00004E45,
	5523:  0x00004E48,
	5524:  0x00004E5F,
	5525:  0x00004E5E,
	5526:  0x00004E8E,
	5527:  0x00004EA1,
	5528:  0x00005140,
	5529:  0x00005203,
	5530:  0x000052FA,
	5531:  0x00005343,
	5532:  0x000053C9,
	5533:  0x000053E3,
	5534:  0x0000571F,
	5535:  0x000058EB,
	5536:  0x00005915,
	5537:  0x00005927,
	5538:  0x00005973,
	5539:  0x00005B50,
	5540:  0x00005B51,
	5541:  0x00005B53,
	5542:  0x00005BF8,
	5543:  0x00005C0F,
	5544:  0x00005C22,
	5545:  0x00005C38,
	5546:  0x00005C71,
	5547:  0x00005DDD,
	5548:  0x00005DE5,
	5549:  0x00005DF1,
	5550:  0x00005DF2,
	5551:  0x00005DF3,
	5552:  0x00005DFE,
	5553:  0x00005E72,
	5554:  0x00005EFE,
	5555:  0x00005F0B,
	5556:  0x00005F13,
	5557:  0x0000624D,
	5558:  0x00004E11,
	5559:  0x00004E10,
	5560:  0x00004E0D,
	5561:  0x00004E2D,
	5562:  0x00004E30,
	5563:  0x00004E39,
	5564:  0x00004E4B,
	5565:  0x00005C39,
	5566:  0x00004E88,
	5567:  0x00004E91,
	5568:  0x00004E95,
	5569:  0x00004E92,
	5570:  0x00004E94,
	5571:  0x00004EA2,
	5572:  0x00004EC1,
	5573:  0x00004EC0,
	5574:  0x00004EC3,
	5575:  0x00004EC6,
	5576:  0x00004EC7,
	5577:  0x00004ECD,
	5578:  0x00004ECA,
	5579:  0x00004ECB,
	5580:  0x00004EC4,
	5581:  0x00005143,
	5582:  0x00005141,
	5583:  0x00005167,
	5584:  0x0000516D,
	5585:  0x0000516E,
	5586:  0x0000516C,
	5587:  0x00005197,
	5588:  0x000051F6,
	5589:  0x00005206,
	5590:  0x00005207,
	5591:  0x00005208,
	5592:  0x000052FB,
	5593:  0x000052FE,
	5594:  0x000052FF,
	5595:  0x00005316,
	5596:  0x00005339,
	5597:  0x00005348,
	5598:  0x00005347,
	5599:  0x00005345,
	5600:  0x0000535E,
	5601:  0x00005384,
	5602:  0x000053CB,
	5603:  0x000053CA,
	5604:  0x000053CD,
	5605:  0x000058EC,
	5606:  0x00005929,
	5607:  0x0000592B,
	5608:  0x0000592A,
	5609:  0x0000592D,
	5610:  0x00005B54,
	5611:  0x00005C11,
	5612:  0x00005C24,
	5613:  0x00005C3A,
	5614:  0x00005C6F,
	5615:  0x00005DF4,
	5616:  0x00005E7B,
	5617:  0x00005EFF,
	5618:  0x00005F14,
	5619:  0x00005F15,
	5620:  0x00005FC3,
	5621:  0x00006208,
	5622:  0x00006236,
	5623:  0x0000624B,
	5624:  0x0000624E,
	5625:  0x0000652F,
	5626:  0x00006587,
	5627:  0x00006597,
	5628:  0x000065A4,
	5629:  0x000065B9,
	5630:  0x000065E5,
	5631:  0x000066F0,
	5632:  0x00006708,
	5633:  0x00006728,
	5634:  0x00006B20,
	5635:  0x00006B62,
	5636:  0x00006B79,
	5637:  0x00006BCB,
	5638:  0x00006BD4,
	5639:  0x00006BDB,
	5640:  0x00006C0F,
	5641:  0x00006C34,
	5642:  0x0000706B,
	5643:  0x0000722A,
	5644:  0x00007236,
	5645:  0x0000723B,
	5646:  0x00007247,
	5647:  0x00007259,
	5648:  0x0000725B,
	5649:  0x000072AC,
	5650:  0x0000738B,
	5651:  0x00004E19,
	5652:  0x00004E16,
	5653:  0x00004E15,
	5654:  0x00004E14,
	5655:  0x00004E18,
	5656:  0x00004E3B,
	5657:  0x00004E4D,
	5658:  0x00004E4F,
	5659:  0x00004E4E,
	5660:  0x00004EE5,
	5661:  0x00004ED8,
	5662:  0x00004ED4,
	5663:  0x00004ED5,
	5664:  0x00004ED6,
	5665:  0x00004ED7,
	5666:  0x00004EE3,
	5667:  0x00004EE4,
	5668:  0x00004ED9,
	5669:  0x00004EDE,
	5670:  0x00005145,
	5671:  0x00005144,
	5672:  0x00005189,
	5673:  0x0000518A,
	5674:  0x000051AC,
	5675:  0x000051F9,
	5676:  0x000051FA,
	5677:  0x000051F8,
	5678:  0x0000520A,
	5679:  0x000052A0,
	5680:  0x0000529F,
	5681:  0x00005305,
	5682:  0x00005306,
	5683:  0x00005317,
	5684:  0x0000531D,
	5685:  0x00004EDF,
	5686:  0x0000534A,
	5687:  0x00005349,
	5688:  0x00005361,
	5689:  0x00005360,
	5690:  0x0000536F,
	5691:  0x0000536E,
	5692:  0x000053BB,
	5693:  0x000053EF,
	5694:  0x000053E4,
	5695:  0x000053F3,
	5696:  0x000053EC,
	5697:  0x000053EE,
	5698:  0x000053E9,
	5699:  0x000053E8,
	5700:  0x000053FC,
	5701:  0x000053F8,
	5702:  0x000053F5,
	5703:  0x000053EB,
	5704:  0x000053E6,
	5705:  0x000053EA,
	5706:  0x000053F2,
	5707:  0x000053F1,
	5708:  0x000053F0,
	5709:  0x000053E5,
	5710:  0x000053ED,
	5711:  0x000053FB,
	5712:  0x000056DB,
	5713:  0x000056DA,
	5714:  0x00005916,
	5715:  0x0000592E,
	5716:  0x00005931,
	5717:  0x00005974,
	5718:  0x00005976,
	5719:  0x00005B55,
	5720:  0x00005B83,
	5721:  0x00005C3C,
	5722:  0x00005DE8,
	5723:  0x00005DE7,
	5724:  0x00005DE6,
	5725:  0x00005E02,
	5726:  0x00005E03,
	5727:  0x00005E73,
	5728:  0x00005E7C,
	5729:  0x00005F01,
	5730:  0x00005F18,
	5731:  0x00005F17,
	5732:  0x00005FC5,
	5733:  0x0000620A,
	5734:  0x00006253,
	5735:  0x00006254,
	5736:  0x00006252,
	5737:  0x00006251,
	5738:  0x000065A5,
	5739:  0x000065E6,
	5740:  0x0000672E,
	5741:  0x0000672C,
	5742:  0x0000672A,
	5743:  0x0000672B,
	5744:  0x0000672D,
	5745:  0x00006B63,
	5746:  0x00006BCD,
	5747:  0x00006C11,
	5748:  0x00006C10,
	5749:  0x00006C38,
	5750:  0x00006C41,
	5751:  0x00006C40,
	5752:  0x00006C3E,
	5753:  0x000072AF,
	5754:  0x00007384,
	5755:  0x00007389,
	5756:  0x000074DC,
	5757:  0x000074E6,
	5758:  0x00007518,
	5759:  0x0000751F,
	5760:  0x00007528,
	5761:  0x00007529,
	5762:  0x00007530,
	5763:  0x00007531,
	5764:  0x00007532,
	5765:  0x00007533,
	5766:  0x0000758B,
	5767:  0x0000767D,
	5768:  0x000076AE,
	5769:  0x000076BF,
	5770:  0x000076EE,
	5771:  0x000077DB,
	5772:  0x000077E2,
	5773:  0x000077F3,
	5774:  0x0000793A,
	5775:  0x000079BE,
	5776:  0x00007A74,
	5777:  0x00007ACB,
	5778:  0x00004E1E,
	5779:  0x00004E1F,
	5780:  0x00004E52,
	5781:  0x00004E53,
	5782:  0x00004E69,
	5783:  0x00004E99,
	5784:  0x00004EA4,
	5785:  0x00004EA6,
	5786:  0x00004EA5,
	5787:  0x00004EFF,
	5788:  0x00004F09,
	5789:  0x00004F19,
	5790:  0x00004F0A,
	5791:  0x00004F15,
	5792:  0x00004F0D,
	5793:  0x00004F10,
	5794:  0x00004F11,
	5795:  0x00004F0F,
	5796:  0x00004EF2,
	5797:  0x00004EF6,
	5798:  0x00004EFB,
	5799:  0x00004EF0,
	5800:  0x00004EF3,
	5801:  0x00004EFD,
	5802:  0x00004F01,
	5803:  0x00004F0B,
	5804:  0x00005149,
	5805:  0x00005147,
	5806:  0x00005146,
	5807:  0x00005148,
	5808:  0x00005168,
	5809:  0x00005171,
	5810:  0x0000518D,
	5811:  0x000051B0,
	5812:  0x00005217,
	5813:  0x00005211,
	5814:  0x00005212,
	5815:  0x0000520E,
	5816:  0x00005216,
	5817:  0x000052A3,
	5818:  0x00005308,
	5819:  0x00005321,
	5820:  0x00005320,
	5821:  0x00005370,
	5822:  0x00005371,
	5823:  0x00005409,
	5824:  0x0000540F,
	5825:  0x0000540C,
	5826:  0x0000540A,
	5827:  0x00005410,
	5828:  0x00005401,
	5829:  0x0000540B,
	5830:  0x00005404,
	5831:  0x00005411,
	5832:  0x0000540D,
	5833:  0x00005408,
	5834:  0x00005403,
	5835:  0x0000540E,
	5836:  0x00005406,
	5837:  0x00005412,
	5838:  0x000056E0,
	5839:  0x000056DE,
	5840:  0x000056DD,
	5841:  0x00005733,
	5842:  0x00005730,
	5843:  0x00005728,
	5844:  0x0000572D,
	5845:  0x0000572C,
	5846:  0x0000572F,
	5847:  0x00005729,
	5848:  0x00005919,
	5849:  0x0000591A,
	5850:  0x00005937,
	5851:  0x00005938,
	5852:  0x00005984,
	5853:  0x00005978,
	5854:  0x00005983,
	5855:  0x0000597D,
	5856:  0x00005979,
	5857:  0x00005982,
	5858:  0x00005981,
	5859:  0x00005B57,
	5860:  0x00005B58,
	5861:  0x00005B87,
	5862:  0x00005B88,
	5863:  0x00005B85,
	5864:  0x00005B89,
	5865:  0x00005BFA,
	5866:  0x00005C16,
	5867:  0x00005C79,
	5868:  0x00005DDE,
	5869:  0x00005E06,
	5870:  0x00005E76,
	5871:  0x00005E74,
	5872:  0x00005F0F,
	5873:  0x00005F1B,
	5874:  0x00005FD9,
	5875:  0x00005FD6,
	5876:  0x0000620E,
	5877:  0x0000620C,
	5878:  0x0000620D,
	5879:  0x00006210,
	5880:  0x00006263,
	5881:  0x0000625B,
	5882:  0x00006258,
	5883:  0x00006536,
	5884:  0x000065E9,
	5885:  0x000065E8,
	5886:  0x000065EC,
	5887:  0x000065ED,
	5888:  0x000066F2,
	5889:  0x000066F3,
	5890:  0x00006709,
	5891:  0x0000673D,
	5892:  0x00006734,
	5893:  0x00006731,
	5894:  0x00006735,
	5895:  0x00006B21,
	5896:  0x00006B64,
	5897:  0x00006B7B,
	5898:  0x00006C16,
	5899:  0x00006C5D,
	5900:  0x00006C57,
	5901:  0x00006C59,
	5902:  0x00006C5F,
	5903:  0x00006C60,
	5904:  0x00006C50,
	5905:  0x00006C55,
	5906:  0x00006C61,
	5907:  0x00006C5B,
	5908:  0x00006C4D,
	5909:  0x00006C4E,
	5910:  0x00007070,
	5911:  0x0000725F,
	5912:  0x0000725D,
	5913:  0x0000767E,
	5914:  0x00007AF9,
	5915:  0x00007C73,
	5916:  0x00007CF8,
	5917:  0x00007F36,
	5918:  0x00007F8A,
	5919:  0x00007FBD,
	5920:  0x00008001,
	5921:  0x00008003,
	5922:  0x0000800C,
	5923:  0x00008012,
	5924:  0x00008033,
	5925:  0x0000807F,
	5926:  0x00008089,
	5927:  0x0000808B,
	5928:  0x0000808C,
	5929:  0x000081E3,
	5930:  0x000081EA,
	5931:  0x000081F3,
	5932:  0x000081FC,
	5933:  0x0000820C,
	5934:  0x0000821B,
	5935:  0x0000821F,
	5936:  0x0000826E,
	5937:  0x00008272,
	5938:  0x0000827E,
	5939:  0x0000866B,
	5940:  0x00008840,
	5941:  0x0000884C,
	5942:  0x00008863,
	5943:  0x0000897F,
	5944:  0x00009621,
	5945:  0x00004E32,
	5946:  0x00004EA8,
	5947:  0x00004F4D,
	5948:  0x00004F4F,
	5949:  0x00004F47,
	5950:  0x00004F57,
	5951:  0x00004F5E,
	5952:  0x00004F34,
	5953:  0x00004F5B,
	5954:  0x00004F55,
	5955:  0x00004F30,
	5956:  0x00004F50,
	5957:  0x00004F51,
	5958:  0x00004F3D,
	5959:  0x00004F3A,
	5960:  0x00004F38,
	5961:  0x00004F43,
	5962:  0x00004F54,
	5963:  0x00004F3C,
	5964:  0x00004F46,
	5965:  0x00004F63,
	5966:  0x00004F5C,
	5967:  0x00004F60,
	5968:  0x00004F2F,
	5969:  0x00004F4E,
	5970:  0x00004F36,
	5971:  0x00004F59,
	5972:  0x00004F5D,
	5973:  0x00004F48,
	5974:  0x00004F5A,
	5975:  0x0000514C,
	5976:  0x0000514B,
	5977:  0x0000514D,
	5978:  0x00005175,
	5979:  0x000051B6,
	5980:  0x000051B7,
	5981:  0x00005225,
	5982:  0x00005224,
	5983:  0x00005229,
	5984:  0x0000522A,
	5985:  0x00005228,
	5986:  0x000052AB,
	5987:  0x000052A9,
	5988:  0x000052AA,
	5989:  0x000052AC,
	5990:  0x00005323,
	5991:  0x00005373,
	5992:  0x00005375,
	5993:  0x0000541D,
	5994:  0x0000542D,
	5995:  0x0000541E,
	5996:  0x0000543E,
	5997:  0x00005426,
	5998:  0x0000544E,
	5999:  0x00005427,
	6000:  0x00005446,
	6001:  0x00005443,
	6002:  0x00005433,
	6003:  0x00005448,
	6004:  0x00005442,
	6005:  0x0000541B,
	6006:  0x00005429,
	6007:  0x0000544A,
	6008:  0x00005439,
	6009:  0x0000543B,
	6010:  0x00005438,
	6011:  0x0000542E,
	6012:  0x00005435,
	6013:  0x00005436,
	6014:  0x00005420,
	6015:  0x0000543C,
	6016:  0x00005440,
	6017:  0x00005431,
	6018:  0x0000542B,
	6019:  0x0000541F,
	6020:  0x0000542C,
	6021:  0x000056EA,
	6022:  0x000056F0,
	6023:  0x000056E4,
	6024:  0x000056EB,
	6025:  0x0000574A,
	6026:  0x00005751,
	6027:  0x00005740,
	6028:  0x0000574D,
	6029:  0x00005747,
	6030:  0x0000574E,
	6031:  0x0000573E,
	6032:  0x00005750,
	6033:  0x0000574F,
	6034:  0x0000573B,
	6035:  0x000058EF,
	6036:  0x0000593E,
	6037:  0x0000599D,
	6038:  0x00005992,
	6039:  0x000059A8,
	6040:  0x0000599E,
	6041:  0x000059A3,
	6042:  0x00005999,
	6043:  0x00005996,
	6044:  0x0000598D,
	6045:  0x000059A4,
	6046:  0x00005993,
	6047:  0x0000598A,
	6048:  0x000059A5,
	6049:  0x00005B5D,
	6050:  0x00005B5C,
	6051:  0x00005B5A,
	6052:  0x00005B5B,
	6053:  0x00005B8C,
	6054:  0x00005B8B,
	6055:  0x00005B8F,
	6056:  0x00005C2C,
	6057:  0x00005C40,
	6058:  0x00005C41,
	6059:  0x00005C3F,
	6060:  0x00005C3E,
	6061:  0x00005C90,
	6062:  0x00005C91,
	6063:  0x00005C94,
	6064:  0x00005C8C,
	6065:  0x00005DEB,
	6066:  0x00005E0C,
	6067:  0x00005E8F,
	6068:  0x00005E87,
	6069:  0x00005E8A,
	6070:  0x00005EF7,
	6071:  0x00005F04,
	6072:  0x00005F1F,
	6073:  0x00005F64,
	6074:  0x00005F62,
	6075:  0x00005F77,
	6076:  0x00005F79,
	6077:  0x00005FD8,
	6078:  0x00005FCC,
	6079:  0x00005FD7,
	6080:  0x00005FCD,
	6081:  0x00005FF1,
	6082:  0x00005FEB,
	6083:  0x00005FF8,
	6084:  0x00005FEA,
	6085:  0x00006212,
	6086:  0x00006211,
	6087:  0x00006284,
	6088:  0x00006297,
	6089:  0x00006296,
	6090:  0x00006280,
	6091:  0x00006276,
	6092:  0x00006289,
	6093:  0x0000626D,
	6094:  0x0000628A,
	6095:  0x0000627C,
	6096:  0x0000627E,
	6097:  0x00006279,
	6098:  0x00006273,
	6099:  0x00006292,
	6100:  0x0000626F,
	6101:  0x00006298,
	6102:  0x0000626E,
	6103:  0x00006295,
	6104:  0x00006293,
	6105:  0x00006291,
	6106:  0x00006286,
	6107:  0x00006539,
	6108:  0x0000653B,
	6109:  0x00006538,
	6110:  0x000065F1,
	6111:  0x000066F4,
	6112:  0x0000675F,
	6113:  0x0000674E,
	6114:  0x0000674F,
	6115:  0x00006750,
	6116:  0x00006751,
	6117:  0x0000675C,
	6118:  0x00006756,
	6119:  0x0000675E,
	6120:  0x00006749,
	6121:  0x00006746,
	6122:  0x00006760,
	6123:  0x00006753,
	6124:  0x00006757,
	6125:  0x00006B65,
	6126:  0x00006BCF,
	6127:  0x00006C42,
	6128:  0x00006C5E,
	6129:  0x00006C99,
	6130:  0x00006C81,
	6131:  0x00006C88,
	6132:  0x00006C89,
	6133:  0x00006C85,
	6134:  0x00006C9B,
	6135:  0x00006C6A,
	6136:  0x00006C7A,
	6137:  0x00006C90,
	6138:  0x00006C70,
	6139:  0x00006C8C,
	6140:  0x00006C68,
	6141:  0x00006C96,
	6142:  0x00006C92,
	6143:  0x00006C7D,
	6144:  0x00006C83,
	6145:  0x00006C72,
	6146:  0x00006C7E,
	6147:  0x00006C74,
	6148:  0x00006C86,
	6149:  0x00006C76,
	6150:  0x00006C8D,
	6151:  0x00006C94,
	6152:  0x00006C98,
	6153:  0x00006C82,
	6154:  0x00007076,
	6155:  0x0000707C,
	6156:  0x0000707D,
	6157:  0x00007078,
	6158:  0x00007262,
	6159:  0x00007261,
	6160:  0x00007260,
	6161:  0x000072C4,
	6162:  0x000072C2,
	6163:  0x00007396,
	6164:  0x0000752C,
	6165:  0x0000752B,
	6166:  0x00007537,
	6167:  0x00007538,
	6168:  0x00007682,
	6169:  0x000076EF,
	6170:  0x000077E3,
	6171:  0x000079C1,
	6172:  0x000079C0,
	6173:  0x000079BF,
	6174:  0x00007A76,
	6175:  0x00007CFB,
	6176:  0x00007F55,
	6177:  0x00008096,
	6178:  0x00008093,
	6179:  0x0000809D,
	6180:  0x00008098,
	6181:  0x0000809B,
	6182:  0x0000809A,
	6183:  0x000080B2,
	6184:  0x0000826F,
	6185:  0x00008292,
	6186:  0x0000828B,
	6187:  0x0000828D,
	6188:  0x0000898B,
	6189:  0x000089D2,
	6190:  0x00008A00,
	6191:  0x00008C37,
	6192:  0x00008C46,
	6193:  0x00008C55,
	6194:  0x00008C9D,
	6195:  0x00008D64,
	6196:  0x00008D70,
	6197:  0x00008DB3,
	6198:  0x00008EAB,
	6199:  0x00008ECA,
	6200:  0x00008F9B,
	6201:  0x00008FB0,
	6202:  0x00008FC2,
	6203:  0x00008FC6,
	6204:  0x00008FC5,
	6205:  0x00008FC4,
	6206:  0x00005DE1,
	6207:  0x00009091,
	6208:  0x000090A2,
	6209:  0x000090AA,
	6210:  0x000090A6,
	6211:  0x000090A3,
	6212:  0x00009149,
	6213:  0x000091C6,
	6214:  0x000091CC,
	6215:  0x00009632,
	6216:  0x0000962E,
	6217:  0x00009631,
	6218:  0x0000962A,
	6219:  0x0000962C,
	6220:  0x00004E26,
	6221:  0x00004E56,
	6222:  0x00004E73,
	6223:  0x00004E8B,
	6224:  0x00004E9B,
	6225:  0x00004E9E,
	6226:  0x00004EAB,
	6227:  0x00004EAC,
	6228:  0x00004F6F,
	6229:  0x00004F9D,
	6230:  0x00004F8D,
	6231:  0x00004F73,
	6232:  0x00004F7F,
	6233:  0x00004F6C,
	6234:  0x00004F9B,
	6235:  0x00004F8B,
	6236:  0x00004F86,
	6237:  0x00004F83,
	6238:  0x00004F70,
	6239:  0x00004F75,
	6240:  0x00004F88,
	6241:  0x00004F69,
	6242:  0x00004F7B,
	6243:  0x00004F96,
	6244:  0x00004F7E,
	6245:  0x00004F8F,
	6246:  0x00004F91,
	6247:  0x00004F7A,
	6248:  0x00005154,
	6249:  0x00005152,
	6250:  0x00005155,
	6251:  0x00005169,
	6252:  0x00005177,
	6253:  0x00005176,
	6254:  0x00005178,
	6255:  0x000051BD,
	6256:  0x000051FD,
	6257:  0x0000523B,
	6258:  0x00005238,
	6259:  0x00005237,
	6260:  0x0000523A,
	6261:  0x00005230,
	6262:  0x0000522E,
	6263:  0x00005236,
	6264:  0x00005241,
	6265:  0x000052BE,
	6266:  0x000052BB,
	6267:  0x00005352,
	6268:  0x00005354,
	6269:  0x00005353,
	6270:  0x00005351,
	6271:  0x00005366,
	6272:  0x00005377,
	6273:  0x00005378,
	6274:  0x00005379,
	6275:  0x000053D6,
	6276:  0x000053D4,
	6277:  0x000053D7,
	6278:  0x00005473,
	6279:  0x00005475,
	6280:  0x00005496,
	6281:  0x00005478,
	6282:  0x00005495,
	6283:  0x00005480,
	6284:  0x0000547B,
	6285:  0x00005477,
	6286:  0x00005484,
	6287:  0x00005492,
	6288:  0x00005486,
	6289:  0x0000547C,
	6290:  0x00005490,
	6291:  0x00005471,
	6292:  0x00005476,
	6293:  0x0000548C,
	6294:  0x0000549A,
	6295:  0x00005462,
	6296:  0x00005468,
	6297:  0x0000548B,
	6298:  0x0000547D,
	6299:  0x0000548E,
	6300:  0x000056FA,
	6301:  0x00005783,
	6302:  0x00005777,
	6303:  0x0000576A,
	6304:  0x00005769,
	6305:  0x00005761,
	6306:  0x00005766,
	6307:  0x00005764,
	6308:  0x0000577C,
	6309:  0x0000591C,
	6310:  0x00005949,
	6311:  0x00005947,
	6312:  0x00005948,
	6313:  0x00005944,
	6314:  0x00005954,
	6315:  0x000059BE,
	6316:  0x000059BB,
	6317:  0x000059D4,
	6318:  0x000059B9,
	6319:  0x000059AE,
	6320:  0x000059D1,
	6321:  0x000059C6,
	6322:  0x000059D0,
	6323:  0x000059CD,
	6324:  0x000059CB,
	6325:  0x000059D3,
	6326:  0x000059CA,
	6327:  0x000059AF,
	6328:  0x000059B3,
	6329:  0x000059D2,
	6330:  0x000059C5,
	6331:  0x00005B5F,
	6332:  0x00005B64,
	6333:  0x00005B63,
	6334:  0x00005B97,
	6335:  0x00005B9A,
	6336:  0x00005B98,
	6337:  0x00005B9C,
	6338:  0x00005B99,
	6339:  0x00005B9B,
	6340:  0x00005C1A,
	6341:  0x00005C48,
	6342:  0x00005C45,
	6343:  0x00005C46,
	6344:  0x00005CB7,
	6345:  0x00005CA1,
	6346:  0x00005CB8,
	6347:  0x00005CA9,
	6348:  0x00005CAB,
	6349:  0x00005CB1,
	6350:  0x00005CB3,
	6351:  0x00005E18,
	6352:  0x00005E1A,
	6353:  0x00005E16,
	6354:  0x00005E15,
	6355:  0x00005E1B,
	6356:  0x00005E11,
	6357:  0x00005E78,
	6358:  0x00005E9A,
	6359:  0x00005E97,
	6360:  0x00005E9C,
	6361:  0x00005E95,
	6362:  0x00005E96,
	6363:  0x00005EF6,
	6364:  0x00005F26,
	6365:  0x00005F27,
	6366:  0x00005F29,
	6367:  0x00005F80,
	6368:  0x00005F81,
	6369:  0x00005F7F,
	6370:  0x00005F7C,
	6371:  0x00005FDD,
	6372:  0x00005FE0,
	6373:  0x00005FFD,
	6374:  0x00005FF5,
	6375:  0x00005FFF,
	6376:  0x0000600F,
	6377:  0x00006014,
	6378:  0x0000602F,
	6379:  0x00006035,
	6380:  0x00006016,
	6381:  0x0000602A,
	6382:  0x00006015,
	6383:  0x00006021,
	6384:  0x00006027,
	6385:  0x00006029,
	6386:  0x0000602B,
	6387:  0x0000601B,
	6388:  0x00006216,
	6389:  0x00006215,
	6390:  0x0000623F,
	6391:  0x0000623E,
	6392:  0x00006240,
	6393:  0x0000627F,
	6394:  0x000062C9,
	6395:  0x000062CC,
	6396:  0x000062C4,
	6397:  0x000062BF,
	6398:  0x000062C2,
	6399:  0x000062B9,
	6400:  0x000062D2,
	6401:  0x000062DB,
	6402:  0x000062AB,
	6403:  0x000062D3,
	6404:  0x000062D4,
	6405:  0x000062CB,
	6406:  0x000062C8,
	6407:  0x000062A8,
	6408:  0x000062BD,
	6409:  0x000062BC,
	6410:  0x000062D0,
	6411:  0x000062D9,
	6412:  0x000062C7,
	6413:  0x000062CD,
	6414:  0x000062B5,
	6415:  0x000062DA,
	6416:  0x000062B1,
	6417:  0x000062D8,
	6418:  0x000062D6,
	6419:  0x000062D7,
	6420:  0x000062C6,
	6421:  0x000062AC,
	6422:  0x000062CE,
	6423:  0x0000653E,
	6424:  0x000065A7,
	6425:  0x000065BC,
	6426:  0x000065FA,
	6427:  0x00006614,
	6428:  0x00006613,
	6429:  0x0000660C,
	6430:  0x00006606,
	6431:  0x00006602,
	6432:  0x0000660E,
	6433:  0x00006600,
	6434:  0x0000660F,
	6435:  0x00006615,
	6436:  0x0000660A,
	6437:  0x00006607,
	6438:  0x0000670D,
	6439:  0x0000670B,
	6440:  0x0000676D,
	6441:  0x0000678B,
	6442:  0x00006795,
	6443:  0x00006771,
	6444:  0x0000679C,
	6445:  0x00006773,
	6446:  0x00006777,
	6447:  0x00006787,
	6448:  0x0000679D,
	6449:  0x00006797,
	6450:  0x0000676F,
	6451:  0x00006770,
	6452:  0x0000677F,
	6453:  0x00006789,
	6454:  0x0000677E,
	6455:  0x00006790,
	6456:  0x00006775,
	6457:  0x0000679A,
	6458:  0x00006793,
	6459:  0x0000677C,
	6460:  0x0000676A,
	6461:  0x00006772,
	6462:  0x00006B23,
	6463:  0x00006B66,
	6464:  0x00006B67,
	6465:  0x00006B7F,
	6466:  0x00006C13,
	6467:  0x00006C1B,
	6468:  0x00006CE3,
	6469:  0x00006CE8,
	6470:  0x00006CF3,
	6471:  0x00006CB1,
	6472:  0x00006CCC,
	6473:  0x00006CE5,
	6474:  0x00006CB3,
	6475:  0x00006CBD,
	6476:  0x00006CBE,
	6477:  0x00006CBC,
	6478:  0x00006CE2,
	6479:  0x00006CAB,
	6480:  0x00006CD5,
	6481:  0x00006CD3,
	6482:  0x00006CB8,
	6483:  0x00006CC4,
	6484:  0x00006CB9,
	6485:  0x00006CC1,
	6486:  0x00006CAE,
	6487:  0x00006CD7,
	6488:  0x00006CC5,
	6489:  0x00006CF1,
	6490:  0x00006CBF,
	6491:  0x00006CBB,
	6492:  0x00006CE1,
	6493:  0x00006CDB,
	6494:  0x00006CCA,
	6495:  0x00006CAC,
	6496:  0x00006CEF,
	6497:  0x00006CDC,
	6498:  0x00006CD6,
	6499:  0x00006CE0,
	6500:  0x00007095,
	6501:  0x0000708E,
	6502:  0x00007092,
	6503:  0x0000708A,
	6504:  0x00007099,
	6505:  0x0000722C,
	6506:  0x0000722D,
	6507:  0x00007238,
	6508:  0x00007248,
	6509:  0x00007267,
	6510:  0x00007269,
	6511:  0x000072C0,
	6512:  0x000072CE,
	6513:  0x000072D9,
	6514:  0x000072D7,
	6515:  0x000072D0,
	6516:  0x000073A9,
	6517:  0x000073A8,
	6518:  0x0000739F,
	6519:  0x000073AB,
	6520:  0x000073A5,
	6521:  0x0000753D,
	6522:  0x0000759D,
	6523:  0x00007599,
	6524:  0x0000759A,
	6525:  0x00007684,
	6526:  0x000076C2,
	6527:  0x000076F2,
	6528:  0x000076F4,
	6529:  0x000077E5,
	6530:  0x000077FD,
	6531:  0x0000793E,
	6532:  0x00007940,
	6533:  0x00007941,
	6534:  0x000079C9,
	6535:  0x000079C8,
	6536:  0x00007A7A,
	6537:  0x00007A79,
	6538:  0x00007AFA,
	6539:  0x00007CFE,
	6540:  0x00007F54,
	6541:  0x00007F8C,
	6542:  0x00007F8B,
	6543:  0x00008005,
	6544:  0x000080BA,
	6545:  0x000080A5,
	6546:  0x000080A2,
	6547:  0x000080B1,
	6548:  0x000080A1,
	6549:  0x000080AB,
	6550:  0x000080A9,
	6551:  0x000080B4,
	6552:  0x000080AA,
	6553:  0x000080AF,
	6554:  0x000081E5,
	6555:  0x000081FE,
	6556:  0x0000820D,
	6557:  0x000082B3,
	6558:  0x0000829D,
	6559:  0x00008299,
	6560:  0x000082AD,
	6561:  0x000082BD,
	6562:  0x0000829F,
	6563:  0x000082B9,
	6564:  0x000082B1,
	6565:  0x000082AC,
	6566:  0x000082A5,
	6567:  0x000082AF,
	6568:  0x000082B8,
	6569:  0x000082A3,
	6570:  0x000082B0,
	6571:  0x000082BE,
	6572:  0x000082B7,
	6573:  0x0000864E,
	6574:  0x00008671,
	6575:  0x0000521D,
	6576:  0x00008868,
	6577:  0x00008ECB,
	6578:  0x00008FCE,
	6579:  0x00008FD4,
	6580:  0x00008FD1,
	6581:  0x000090B5,
	6582:  0x000090B8,
	6583:  0x000090B1,
	6584:  0x000090B6,
	6585:  0x000091C7,
	6586:  0x000091D1,
	6587:  0x00009577,
	6588:  0x00009580,
	6589:  0x0000961C,
	6590:  0x00009640,
	6591:  0x0000963F,
	6592:  0x0000963B,
	6593:  0x00009644,
	6594:  0x00009642,
	6595:  0x000096B9,
	6596:  0x000096E8,
	6597:  0x00009752,
	6598:  0x0000975E,
	6599:  0x00004E9F,
	6600:  0x00004EAD,
	6601:  0x00004EAE,
	6602:  0x00004FE1,
	6603:  0x00004FB5,
	6604:  0x00004FAF,
	6605:  0x00004FBF,
	6606:  0x00004FE0,
	6607:  0x00004FD1,
	6608:  0x00004FCF,
	6609:  0x00004FDD,
	6610:  0x00004FC3,
	6611:  0x00004FB6,
	6612:  0x00004FD8,
	6613:  0x00004FDF,
	6614:  0x00004FCA,
	6615:  0x00004FD7,
	6616:  0x00004FAE,
	6617:  0x00004FD0,
	6618:  0x00004FC4,
	6619:  0x00004FC2,
	6620:  0x00004FDA,
	6621:  0x00004FCE,
	6622:  0x00004FDE,
	6623:  0x00004FB7,
	6624:  0x00005157,
	6625:  0x00005192,
	6626:  0x00005191,
	6627:  0x000051A0,
	6628:  0x0000524E,
	6629:  0x00005243,
	6630:  0x0000524A,
	6631:  0x0000524D,
	6632:  0x0000524C,
	6633:  0x0000524B,
	6634:  0x00005247,
	6635:  0x000052C7,
	6636:  0x000052C9,
	6637:  0x000052C3,
	6638:  0x000052C1,
	6639:  0x0000530D,
	6640:  0x00005357,
	6641:  0x0000537B,
	6642:  0x0000539A,
	6643:  0x000053DB,
	6644:  0x000054AC,
	6645:  0x000054C0,
	6646:  0x000054A8,
	6647:  0x000054CE,
	6648:  0x000054C9,
	6649:  0x000054B8,
	6650:  0x000054A6,
	6651:  0x000054B3,
	6652:  0x000054C7,
	6653:  0x000054C2,
	6654:  0x000054BD,
	6655:  0x000054AA,
	6656:  0x000054C1,
	6657:  0x000054C4,
	6658:  0x000054C8,
	6659:  0x000054AF,
	6660:  0x000054AB,
	6661:  0x000054B1,
	6662:  0x000054BB,
	6663:  0x000054A9,
	6664:  0x000054A7,
	6665:  0x000054BF,
	6666:  0x000056FF,
	6667:  0x00005782,
	6668:  0x0000578B,
	6669:  0x000057A0,
	6670:  0x000057A3,
	6671:  0x000057A2,
	6672:  0x000057CE,
	6673:  0x000057AE,
	6674:  0x00005793,
	6675:  0x00005955,
	6676:  0x00005951,
	6677:  0x0000594F,
	6678:  0x0000594E,
	6679:  0x00005950,
	6680:  0x000059DC,
	6681:  0x000059D8,
	6682:  0x000059FF,
	6683:  0x000059E3,
	6684:  0x000059E8,
	6685:  0x00005A03,
	6686:  0x000059E5,
	6687:  0x000059EA,
	6688:  0x000059DA,
	6689:  0x000059E6,
	6690:  0x00005A01,
	6691:  0x000059FB,
	6692:  0x00005B69,
	6693:  0x00005BA3,
	6694:  0x00005BA6,
	6695:  0x00005BA4,
	6696:  0x00005BA2,
	6697:  0x00005BA5,
	6698:  0x00005C01,
	6699:  0x00005C4E,
	6700:  0x00005C4F,
	6701:  0x00005C4D,
	6702:  0x00005C4B,
	6703:  0x00005CD9,
	6704:  0x00005CD2,
	6705:  0x00005DF7,
	6706:  0x00005E1D,
	6707:  0x00005E25,
	6708:  0x00005E1F,
	6709:  0x00005E7D,
	6710:  0x00005EA0,
	6711:  0x00005EA6,
	6712:  0x00005EFA,
	6713:  0x00005F08,
	6714:  0x00005F2D,
	6715:  0x00005F65,
	6716:  0x00005F88,
	6717:  0x00005F85,
	6718:  0x00005F8A,
	6719:  0x00005F8B,
	6720:  0x00005F87,
	6721:  0x00005F8C,
	6722:  0x00005F89,
	6723:  0x00006012,
	6724:  0x0000601D,
	6725:  0x00006020,
	6726:  0x00006025,
	6727:  0x0000600E,
	6728:  0x00006028,
	6729:  0x0000604D,
	6730:  0x00006070,
	6731:  0x00006068,
	6732:  0x00006062,
	6733:  0x00006046,
	6734:  0x00006043,
	6735:  0x0000606C,
	6736:  0x0000606B,
	6737:  0x0000606A,
	6738:  0x00006064,
	6739:  0x00006241,
	6740:  0x000062DC,
	6741:  0x00006316,
	6742:  0x00006309,
	6743:  0x000062FC,
	6744:  0x000062ED,
	6745:  0x00006301,
	6746:  0x000062EE,
	6747:  0x000062FD,
	6748:  0x00006307,
	6749:  0x000062F1,
	6750:  0x000062F7,
	6751:  0x000062EF,
	6752:  0x000062EC,
	6753:  0x000062FE,
	6754:  0x000062F4,
	6755:  0x00006311,
	6756:  0x00006302,
	6757:  0x0000653F,
	6758:  0x00006545,
	6759:  0x000065AB,
	6760:  0x000065BD,
	6761:  0x000065E2,
	6762:  0x00006625,
	6763:  0x0000662D,
	6764:  0x00006620,
	6765:  0x00006627,
	6766:  0x0000662F,
	6767:  0x0000661F,
	6768:  0x00006628,
	6769:  0x00006631,
	6770:  0x00006624,
	6771:  0x000066F7,
	6772:  0x000067FF,
	6773:  0x000067D3,
	6774:  0x000067F1,
	6775:  0x000067D4,
	6776:  0x000067D0,
	6777:  0x000067EC,
	6778:  0x000067B6,
	6779:  0x000067AF,
	6780:  0x000067F5,
	6781:  0x000067E9,
	6782:  0x000067EF,
	6783:  0x000067C4,
	6784:  0x000067D1,
	6785:  0x000067B4,
	6786:  0x000067DA,
	6787:  0x000067E5,
	6788:  0x000067B8,
	6789:  0x000067CF,
	6790:  0x000067DE,
	6791:  0x000067F3,
	6792:  0x000067B0,
	6793:  0x000067D9,
	6794:  0x000067E2,
	6795:  0x000067DD,
	6796:  0x000067D2,
	6797:  0x00006B6A,
	6798:  0x00006B83,
	6799:  0x00006B86,
	6800:  0x00006BB5,
	6801:  0x00006BD2,
	6802:  0x00006BD7,
	6803:  0x00006C1F,
	6804:  0x00006CC9,
	6805:  0x00006D0B,
	6806:  0x00006D32,
	6807:  0x00006D2A,
	6808:  0x00006D41,
	6809:  0x00006D25,
	6810:  0x00006D0C,
	6811:  0x00006D31,
	6812:  0x00006D1E,
	6813:  0x00006D17,
	6814:  0x00006D3B,
	6815:  0x00006D3D,
	6816:  0x00006D3E,
	6817:  0x00006D36,
	6818:  0x00006D1B,
	6819:  0x00006CF5,
	6820:  0x00006D39,
	6821:  0x00006D27,
	6822:  0x00006D38,
	6823:  0x00006D29,
	6824:  0x00006D2E,
	6825:  0x00006D35,
	6826:  0x00006D0E,
	6827:  0x00006D2B,
	6828:  0x000070AB,
	6829:  0x000070BA,
	6830:  0x000070B3,
	6831:  0x000070AC,
	6832:  0x000070AF,
	6833:  0x000070AD,
	6834:  0x000070B8,
	6835:  0x000070AE,
	6836:  0x000070A4,
	6837:  0x00007230,
	6838:  0x00007272,
	6839:  0x0000726F,
	6840:  0x00007274,
	6841:  0x000072E9,
	6842:  0x000072E0,
	6843:  0x000072E1,
	6844:  0x000073B7,
	6845:  0x000073CA,
	6846:  0x000073BB,
	6847:  0x000073B2,
	6848:  0x000073CD,
	6849:  0x000073C0,
	6850:  0x000073B3,
	6851:  0x0000751A,
	6852:  0x0000752D,
	6853:  0x0000754F,
	6854:  0x0000754C,
	6855:  0x0000754E,
	6856:  0x0000754B,
	6857:  0x000075AB,
	6858:  0x000075A4,
	6859:  0x000075A5,
	6860:  0x000075A2,
	6861:  0x000075A3,
	6862:  0x00007678,
	6863:  0x00007686,
	6864:  0x00007687,
	6865:  0x00007688,
	6866:  0x000076C8,
	6867:  0x000076C6,
	6868:  0x000076C3,
	6869:  0x000076C5,
	6870:  0x00007701,
	6871:  0x000076F9,
	6872:  0x000076F8,
	6873:  0x00007709,
	6874:  0x0000770B,
	6875:  0x000076FE,
	6876:  0x000076FC,
	6877:  0x00007707,
	6878:  0x000077DC,
	6879:  0x00007802,
	6880:  0x00007814,
	6881:  0x0000780C,
	6882:  0x0000780D,
	6883:  0x00007946,
	6884:  0x00007949,
	6885:  0x00007948,
	6886:  0x00007947,
	6887:  0x000079B9,
	6888:  0x000079BA,
	6889:  0x000079D1,
	6890:  0x000079D2,
	6891:  0x000079CB,
	6892:  0x00007A7F,
	6893:  0x00007A81,
	6894:  0x00007AFF,
	6895:  0x00007AFD,
	6896:  0x00007C7D,
	6897:  0x00007D02,
	6898:  0x00007D05,
	6899:  0x00007D00,
	6900:  0x00007D09,
	6901:  0x00007D07,
	6902:  0x00007D04,
	6903:  0x00007D06,
	6904:  0x00007F38,
	6905:  0x00007F8E,
	6906:  0x00007FBF,
	6907:  0x00008004,
	6908:  0x00008010,
	6909:  0x0000800D,
	6910:  0x00008011,
	6911:  0x00008036,
	6912:  0x000080D6,
	6913:  0x000080E5,
	6914:  0x000080DA,
	6915:  0x000080C3,
	6916:  0x000080C4,
	6917:  0x000080CC,
	6918:  0x000080E1,
	6919:  0x000080DB,
	6920:  0x000080CE,
	6921:  0x000080DE,
	6922:  0x000080E4,
	6923:  0x000080DD,
	6924:  0x000081F4,
	6925:  0x00008222,
	6926:  0x000082E7,
	6927:  0x00008303,
	6928:  0x00008305,
	6929:  0x000082E3,
	6930:  0x000082DB,
	6931:  0x000082E6,
	6932:  0x00008304,
	6933:  0x000082E5,
	6934:  0x00008302,
	6935:  0x00008309,
	6936:  0x000082D2,
	6937:  0x000082D7,
	6938:  0x000082F1,
	6939:  0x00008301,
	6940:  0x000082DC,
	6941:  0x000082D4,
	6942:  0x000082D1,
	6943:  0x000082DE,
	6944:  0x000082D3,
	6945:  0x000082DF,
	6946:  0x000082EF,
	6947:  0x00008306,
	6948:  0x00008650,
	6949:  0x00008679,
	6950:  0x0000867B,
	6951:  0x0000867A,
	6952:  0x0000884D,
	6953:  0x0000886B,
	6954:  0x00008981,
	6955:  0x000089D4,
	6956:  0x00008A08,
	6957:  0x00008A02,
	6958:  0x00008A03,
	6959:  0x00008C9E,
	6960:  0x00008CA0,
	6961:  0x00008D74,
	6962:  0x00008D73,
	6963:  0x00008DB4,
	6964:  0x00008ECD,
	6965:  0x00008ECC,
	6966:  0x00008FF0,
	6967:  0x00008FE6,
	6968:  0x00008FE2,
	6969:  0x00008FEA,
	6970:  0x00008FE5,
	6971:  0x00008FED,
	6972:  0x00008FEB,
	6973:  0x00008FE4,
	6974:  0x00008FE8,
	6975:  0x000090CA,
	6976:  0x000090CE,
	6977:  0x000090C1,
	6978:  0x000090C3,
	6979:  0x0000914B,
	6980:  0x0000914A,
	6981:  0x000091CD,
	6982:  0x00009582,
	6983:  0x00009650,
	6984:  0x0000964B,
	6985:  0x0000964C,
	6986:  0x0000964D,
	6987:  0x00009762,
	6988:  0x00009769,
	6989:  0x000097CB,
	6990:  0x000097ED,
	6991:  0x000097F3,
	6992:  0x00009801,
	6993:  0x000098A8,
	6994:  0x000098DB,
	6995:  0x000098DF,
	6996:  0x00009996,
	6997:  0x00009999,
	6998:  0x00004E58,
	6999:  0x00004EB3,
	7000:  0x0000500C,
	7001:  0x0000500D,
	7002:  0x00005023,
	7003:  0x00004FEF,
	7004:  0x00005026,
	7005:  0x00005025,
	7006:  0x00004FF8,
	7007:  0x00005029,
	7008:  0x00005016,
	7009:  0x00005006,
	7010:  0x0000503C,
	7011:  0x0000501F,
	7012:  0x0000501A,
	7013:  0x00005012,
	7014:  0x00005011,
	7015:  0x00004FFA,
	7016:  0x00005000,
	7017:  0x00005014,
	7018:  0x00005028,
	7019:  0x00004FF1,
	7020:  0x00005021,
	7021:  0x0000500B,
	7022:  0x00005019,
	7023:  0x00005018,
	7024:  0x00004FF3,
	7025:  0x00004FEE,
	7026:  0x0000502D,
	7027:  0x0000502A,
	7028:  0x00004FFE,
	7029:  0x0000502B,
	7030:  0x00005009,
	7031:  0x0000517C,
	7032:  0x000051A4,
	7033:  0x000051A5,
	7034:  0x000051A2,
	7035:  0x000051CD,
	7036:  0x000051CC,
	7037:  0x000051C6,
	7038:  0x000051CB,
	7039:  0x00005256,
	7040:  0x0000525C,
	7041:  0x00005254,
	7042:  0x0000525B,
	7043:  0x0000525D,
	7044:  0x0000532A,
	7045:  0x0000537F,
	7046:  0x0000539F,
	7047:  0x0000539D,
	7048:  0x000053DF,
	7049:  0x000054E8,
	7050:  0x00005510,
	7051:  0x00005501,
	7052:  0x00005537,
	7053:  0x000054FC,
	7054:  0x000054E5,
	7055:  0x000054F2,
	7056:  0x00005506,
	7057:  0x000054FA,
	7058:  0x00005514,
	7059:  0x000054E9,
	7060:  0x000054ED,
	7061:  0x000054E1,
	7062:  0x00005509,
	7063:  0x000054EE,
	7064:  0x000054EA,
	7065:  0x000054E6,
	7066:  0x00005527,
	7067:  0x00005507,
	7068:  0x000054FD,
	7069:  0x0000550F,
	7070:  0x00005703,
	7071:  0x00005704,
	7072:  0x000057C2,
	7073:  0x000057D4,
	7074:  0x000057CB,
	7075:  0x000057C3,
	7076:  0x00005809,
	7077:  0x0000590F,
	7078:  0x00005957,
	7079:  0x00005958,
	7080:  0x0000595A,
	7081:  0x00005A11,
	7082:  0x00005A18,
	7083:  0x00005A1C,
	7084:  0x00005A1F,
	7085:  0x00005A1B,
	7086:  0x00005A13,
	7087:  0x000059EC,
	7088:  0x00005A20,
	7089:  0x00005A23,
	7090:  0x00005A29,
	7091:  0x00005A25,
	7092:  0x00005A0C,
	7093:  0x00005A09,
	7094:  0x00005B6B,
	7095:  0x00005C58,
	7096:  0x00005BB0,
	7097:  0x00005BB3,
	7098:  0x00005BB6,
	7099:  0x00005BB4,
	7100:  0x00005BAE,
	7101:  0x00005BB5,
	7102:  0x00005BB9,
	7103:  0x00005BB8,
	7104:  0x00005C04,
	7105:  0x00005C51,
	7106:  0x00005C55,
	7107:  0x00005C50,
	7108:  0x00005CED,
	7109:  0x00005CFD,
	7110:  0x00005CFB,
	7111:  0x00005CEA,
	7112:  0x00005CE8,
	7113:  0x00005CF0,
	7114:  0x00005CF6,
	7115:  0x00005D01,
	7116:  0x00005CF4,
	7117:  0x00005DEE,
	7118:  0x00005E2D,
	7119:  0x00005E2B,
	7120:  0x00005EAB,
	7121:  0x00005EAD,
	7122:  0x00005EA7,
	7123:  0x00005F31,
	7124:  0x00005F92,
	7125:  0x00005F91,
	7126:  0x00005F90,
	7127:  0x00006059,
	7128:  0x00006063,
	7129:  0x00006065,
	7130:  0x00006050,
	7131:  0x00006055,
	7132:  0x0000606D,
	7133:  0x00006069,
	7134:  0x0000606F,
	7135:  0x00006084,
	7136:  0x0000609F,
	7137:  0x0000609A,
	7138:  0x0000608D,
	7139:  0x00006094,
	7140:  0x0000608C,
	7141:  0x00006085,
	7142:  0x00006096,
	7143:  0x00006247,
	7144:  0x000062F3,
	7145:  0x00006308,
	7146:  0x000062FF,
	7147:  0x0000634E,
	7148:  0x0000633E,
	7149:  0x0000632F,
	7150:  0x00006355,
	7151:  0x00006342,
	7152:  0x00006346,
	7153:  0x0000634F,
	7154:  0x00006349,
	7155:  0x0000633A,
	7156:  0x00006350,
	7157:  0x0000633D,
	7158:  0x0000632A,
	7159:  0x0000632B,
	7160:  0x00006328,
	7161:  0x0000634D,
	7162:  0x0000634C,
	7163:  0x00006548,
	7164:  0x00006549,
	7165:  0x00006599,
	7166:  0x000065C1,
	7167:  0x000065C5,
	7168:  0x00006642,
	7169:  0x00006649,
	7170:  0x0000664F,
	7171:  0x00006643,
	7172:  0x00006652,
	7173:  0x0000664C,
	7174:  0x00006645,
	7175:  0x00006641,
	7176:  0x000066F8,
	7177:  0x00006714,
	7178:  0x00006715,
	7179:  0x00006717,
	7180:  0x00006821,
	7181:  0x00006838,
	7182:  0x00006848,
	7183:  0x00006846,
	7184:  0x00006853,
	7185:  0x00006839,
	7186:  0x00006842,
	7187:  0x00006854,
	7188:  0x00006829,
	7189:  0x000068B3,
	7190:  0x00006817,
	7191:  0x0000684C,
	7192:  0x00006851,
	7193:  0x0000683D,
	7194:  0x000067F4,
	7195:  0x00006850,
	7196:  0x00006840,
	7197:  0x0000683C,
	7198:  0x00006843,
	7199:  0x0000682A,
	7200:  0x00006845,
	7201:  0x00006813,
	7202:  0x00006818,
	7203:  0x00006841,
	7204:  0x00006B8A,
	7205:  0x00006B89,
	7206:  0x00006BB7,
	7207:  0x00006C23,
	7208:  0x00006C27,
	7209:  0x00006C28,
	7210:  0x00006C26,
	7211:  0x00006C24,
	7212:  0x00006CF0,
	7213:  0x00006D6A,
	7214:  0x00006D95,
	7215:  0x00006D88,
	7216:  0x00006D87,
	7217:  0x00006D66,
	7218:  0x00006D78,
	7219:  0x00006D77,
	7220:  0x00006D59,
	7221:  0x00006D93,
	7222:  0x00006D6C,
	7223:  0x00006D89,
	7224:  0x00006D6E,
	7225:  0x00006D5A,
	7226:  0x00006D74,
	7227:  0x00006D69,
	7228:  0x00006D8C,
	7229:  0x00006D8A,
	7230:  0x00006D79,
	7231:  0x00006D85,
	7232:  0x00006D65,
	7233:  0x00006D94,
	7234:  0x000070CA,
	7235:  0x000070D8,
	7236:  0x000070E4,
	7237:  0x000070D9,
	7238:  0x000070C8,
	7239:  0x000070CF,
	7240:  0x00007239,
	7241:  0x00007279,
	7242:  0x000072FC,
	7243:  0x000072F9,
	7244:  0x000072FD,
	7245:  0x000072F8,
	7246:  0x000072F7,
	7247:  0x00007386,
	7248:  0x000073ED,
	7249:  0x00007409,
	7250:  0x000073EE,
	7251:  0x000073E0,
	7252:  0x000073EA,
	7253:  0x000073DE,
	7254:  0x00007554,
	7255:  0x0000755D,
	7256:  0x0000755C,
	7257:  0x0000755A,
	7258:  0x00007559,
	7259:  0x000075BE,
	7260:  0x000075C5,
	7261:  0x000075C7,
	7262:  0x000075B2,
	7263:  0x000075B3,
	7264:  0x000075BD,
	7265:  0x000075BC,
	7266:  0x000075B9,
	7267:  0x000075C2,
	7268:  0x000075B8,
	7269:  0x0000768B,
	7270:  0x000076B0,
	7271:  0x000076CA,
	7272:  0x000076CD,
	7273:  0x000076CE,
	7274:  0x00007729,
	7275:  0x0000771F,
	7276:  0x00007720,
	7277:  0x00007728,
	7278:  0x000077E9,
	7279:  0x00007830,
	7280:  0x00007827,
	7281:  0x00007838,
	7282:  0x0000781D,
	7283:  0x00007834,
	7284:  0x00007837,
	7285:  0x00007825,
	7286:  0x0000782D,
	7287:  0x00007820,
	7288:  0x0000781F,
	7289:  0x00007832,
	7290:  0x00007955,
	7291:  0x00007950,
	7292:  0x00007960,
	7293:  0x0000795F,
	7294:  0x00007956,
	7295:  0x0000795E,
	7296:  0x0000795D,
	7297:  0x00007957,
	7298:  0x0000795A,
	7299:  0x000079E4,
	7300:  0x000079E3,
	7301:  0x000079E7,
	7302:  0x000079DF,
	7303:  0x000079E6,
	7304:  0x000079E9,
	7305:  0x000079D8,
	7306:  0x00007A84,
	7307:  0x00007A88,
	7308:  0x00007AD9,
	7309:  0x00007B06,
	7310:  0x00007B11,
	7311:  0x00007C89,
	7312:  0x00007D21,
	7313:  0x00007D17,
	7314:  0x00007D0B,
	7315:  0x00007D0A,
	7316:  0x00007D20,
	7317:  0x00007D22,
	7318:  0x00007D14,
	7319:  0x00007D10,
	7320:  0x00007D15,
	7321:  0x00007D1A,
	7322:  0x00007D1C,
	7323:  0x00007D0D,
	7324:  0x00007D19,
	7325:  0x00007D1B,
	7326:  0x00007F3A,
	7327:  0x00007F5F,
	7328:  0x00007F94,
	7329:  0x00007FC5,
	7330:  0x00007FC1,
	7331:  0x00008006,
	7332:  0x00008018,
	7333:  0x00008015,
	7334:  0x00008019,
	7335:  0x00008017,
	7336:  0x0000803D,
	7337:  0x0000803F,
	7338:  0x000080F1,
	7339:  0x00008102,
	7340:  0x000080F0,
	7341:  0x00008105,
	7342:  0x000080ED,
	7343:  0x000080F4,
	7344:  0x00008106,
	7345:  0x000080F8,
	7346:  0x000080F3,
	7347:  0x00008108,
	7348:  0x000080FD,
	7349:  0x0000810A,
	7350:  0x000080FC,
	7351:  0x000080EF,
	7352:  0x000081ED,
	7353:  0x000081EC,
	7354:  0x00008200,
	7355:  0x00008210,
	7356:  0x0000822A,
	7357:  0x0000822B,
	7358:  0x00008228,
	7359:  0x0000822C,
	7360:  0x000082BB,
	7361:  0x0000832B,
	7362:  0x00008352,
	7363:  0x00008354,
	7364:  0x0000834A,
	7365:  0x00008338,
	7366:  0x00008350,
	7367:  0x00008349,
	7368:  0x00008335,
	7369:  0x00008334,
	7370:  0x0000834F,
	7371:  0x00008332,
	7372:  0x00008339,
	7373:  0x00008336,
	7374:  0x00008317,
	7375:  0x00008340,
	7376:  0x00008331,
	7377:  0x00008328,
	7378:  0x00008343,
	7379:  0x00008654,
	7380:  0x0000868A,
	7381:  0x000086AA,
	7382:  0x00008693,
	7383:  0x000086A4,
	7384:  0x000086A9,
	7385:  0x0000868C,
	7386:  0x000086A3,
	7387:  0x0000869C,
	7388:  0x00008870,
	7389:  0x00008877,
	7390:  0x00008881,
	7391:  0x00008882,
	7392:  0x0000887D,
	7393:  0x00008879,
	7394:  0x00008A18,
	7395:  0x00008A10,
	7396:  0x00008A0E,
	7397:  0x00008A0C,
	7398:  0x00008A15,
	7399:  0x00008A0A,
	7400:  0x00008A17,
	7401:  0x00008A13,
	7402:  0x00008A16,
	7403:  0x00008A0F,
	7404:  0x00008A11,
	7405:  0x00008C48,
	7406:  0x00008C7A,
	7407:  0x00008C79,
	7408:  0x00008CA1,
	7409:  0x00008CA2,
	7410:  0x00008D77,
	7411:  0x00008EAC,
	7412:  0x00008ED2,
	7413:  0x00008ED4,
	7414:  0x00008ECF,
	7415:  0x00008FB1,
	7416:  0x00009001,
	7417:  0x00009006,
	7418:  0x00008FF7,
	7419:  0x00009000,
	7420:  0x00008FFA,
	7421:  0x00008FF4,
	7422:  0x00009003,
	7423:  0x00008FFD,
	7424:  0x00009005,
	7425:  0x00008FF8,
	7426:  0x00009095,
	7427:  0x000090E1,
	7428:  0x000090DD,
	7429:  0x000090E2,
	7430:  0x00009152,
	7431:  0x0000914D,
	7432:  0x0000914C,
	7433:  0x000091D8,
	7434:  0x000091DD,
	7435:  0x000091D7,
	7436:  0x000091DC,
	7437:  0x000091D9,
	7438:  0x00009583,
	7439:  0x00009662,
	7440:  0x00009663,
	7441:  0x00009661,
	7442:  0x0000965B,
	7443:  0x0000965D,
	7444:  0x00009664,
	7445:  0x00009658,
	7446:  0x0000965E,
	7447:  0x000096BB,
	7448:  0x000098E2,
	7449:  0x000099AC,
	7450:  0x00009AA8,
	7451:  0x00009AD8,
	7452:  0x00009B25,
	7453:  0x00009B32,
	7454:  0x00009B3C,
	7455:  0x00004E7E,
	7456:  0x0000507A,
	7457:  0x0000507D,
	7458:  0x0000505C,
	7459:  0x00005047,
	7460:  0x00005043,
	7461:  0x0000504C,
	7462:  0x0000505A,
	7463:  0x00005049,
	7464:  0x00005065,
	7465:  0x00005076,
	7466:  0x0000504E,
	7467:  0x00005055,
	7468:  0x00005075,
	7469:  0x00005074,
	7470:  0x00005077,
	7471:  0x0000504F,
	7472:  0x0000500F,
	7473:  0x0000506F,
	7474:  0x0000506D,
	7475:  0x0000515C,
	7476:  0x00005195,
	7477:  0x000051F0,
	7478:  0x0000526A,
	7479:  0x0000526F,
	7480:  0x000052D2,
	7481:  0x000052D9,
	7482:  0x000052D8,
	7483:  0x000052D5,
	7484:  0x00005310,
	7485:  0x0000530F,
	7486:  0x00005319,
	7487:  0x0000533F,
	7488:  0x00005340,
	7489:  0x0000533E,
	7490:  0x000053C3,
	7491:  0x000066FC,
	7492:  0x00005546,
	7493:  0x0000556A,
	7494:  0x00005566,
	7495:  0x00005544,
	7496:  0x0000555E,
	7497:  0x00005561,
	7498:  0x00005543,
	7499:  0x0000554A,
	7500:  0x00005531,
	7501:  0x00005556,
	7502:  0x0000554F,
	7503:  0x00005555,
	7504:  0x0000552F,
	7505:  0x00005564,
	7506:  0x00005538,
	7507:  0x0000552E,
	7508:  0x0000555C,
	7509:  0x0000552C,
	7510:  0x00005563,
	7511:  0x00005533,
	7512:  0x00005541,
	7513:  0x00005557,
	7514:  0x00005708,
	7515:  0x0000570B,
	7516:  0x00005709,
	7517:  0x000057DF,
	7518:  0x00005805,
	7519:  0x0000580A,
	7520:  0x00005806,
	7521:  0x000057E0,
	7522:  0x000057E4,
	7523:  0x000057FA,
	7524:  0x00005802,
	7525:  0x00005835,
	7526:  0x000057F7,
	7527:  0x000057F9,
	7528:  0x00005920,
	7529:  0x00005962,
	7530:  0x00005A36,
	7531:  0x00005A41,
	7532:  0x00005A49,
	7533:  0x00005A66,
	7534:  0x00005A6A,
	7535:  0x00005A40,
	7536:  0x00005A3C,
	7537:  0x00005A62,
	7538:  0x00005A5A,
	7539:  0x00005A46,
	7540:  0x00005A4A,
	7541:  0x00005B70,
	7542:  0x00005BC7,
	7543:  0x00005BC5,
	7544:  0x00005BC4,
	7545:  0x00005BC2,
	7546:  0x00005BBF,
	7547:  0x00005BC6,
	7548:  0x00005C09,
	7549:  0x00005C08,
	7550:  0x00005C07,
	7551:  0x00005C60,
	7552:  0x00005C5C,
	7553:  0x00005C5D,
	7554:  0x00005D07,
	7555:  0x00005D06,
	7556:  0x00005D0E,
	7557:  0x00005D1B,
	7558:  0x00005D16,
	7559:  0x00005D22,
	7560:  0x00005D11,
	7561:  0x00005D29,
	7562:  0x00005D14,
	7563:  0x00005D19,
	7564:  0x00005D24,
	7565:  0x00005D27,
	7566:  0x00005D17,
	7567:  0x00005DE2,
	7568:  0x00005E38,
	7569:  0x00005E36,
	7570:  0x00005E33,
	7571:  0x00005E37,
	7572:  0x00005EB7,
	7573:  0x00005EB8,
	7574:  0x00005EB6,
	7575:  0x00005EB5,
	7576:  0x00005EBE,
	7577:  0x00005F35,
	7578:  0x00005F37,
	7579:  0x00005F57,
	7580:  0x00005F6C,
	7581:  0x00005F69,
	7582:  0x00005F6B,
	7583:  0x00005F97,
	7584:  0x00005F99,
	7585:  0x00005F9E,
	7586:  0x00005F98,
	7587:  0x00005FA1,
	7588:  0x00005FA0,
	7589:  0x00005F9C,
	7590:  0x0000607F,
	7591:  0x000060A3,
	7592:  0x00006089,
	7593:  0x000060A0,
	7594:  0x000060A8,
	7595:  0x000060CB,
	7596:  0x000060B4,
	7597:  0x000060E6,
	7598:  0x000060BD,
	7599:  0x000060C5,
	7600:  0x000060BB,
	7601:  0x000060B5,
	7602:  0x000060DC,
	7603:  0x000060BC,
	7604:  0x000060D8,
	7605:  0x000060D5,
	7606:  0x000060C6,
	7607:  0x000060DF,
	7608:  0x000060B8,
	7609:  0x000060DA,
	7610:  0x000060C7,
	7611:  0x0000621A,
	7612:  0x0000621B,
	7613:  0x00006248,
	7614:  0x000063A0,
	7615:  0x000063A7,
	7616:  0x00006372,
	7617:  0x00006396,
	7618:  0x000063A2,
	7619:  0x000063A5,
	7620:  0x00006377,
	7621:  0x00006367,
	7622:  0x00006398,
	7623:  0x000063AA,
	7624:  0x00006371,
	7625:  0x000063A9,
	7626:  0x00006389,
	7627:  0x00006383,
	7628:  0x0000639B,
	7629:  0x0000636B,
	7630:  0x000063A8,
	7631:  0x00006384,
	7632:  0x00006388,
	7633:  0x00006399,
	7634:  0x000063A1,
	7635:  0x000063AC,
	7636:  0x00006392,
	7637:  0x0000638F,
	7638:  0x00006380,
	7639:  0x0000637B,
	7640:  0x00006369,
	7641:  0x00006368,
	7642:  0x0000637A,
	7643:  0x0000655D,
	7644:  0x00006556,
	7645:  0x00006551,
	7646:  0x00006559,
	7647:  0x00006557,
	7648:  0x0000555F,
	7649:  0x0000654F,
	7650:  0x00006558,
	7651:  0x00006555,
	7652:  0x00006554,
	7653:  0x0000659C,
	7654:  0x0000659B,
	7655:  0x000065AC,
	7656:  0x000065CF,
	7657:  0x000065CB,
	7658:  0x000065CC,
	7659:  0x000065CE,
	7660:  0x0000665D,
	7661:  0x0000665A,
	7662:  0x00006664,
	7663:  0x00006668,
	7664:  0x00006666,
	7665:  0x0000665E,
	7666:  0x000066F9,
	7667:  0x000052D7,
	7668:  0x0000671B,
	7669:  0x00006881,
	7670:  0x000068AF,
	7671:  0x000068A2,
	7672:  0x00006893,
	7673:  0x000068B5,
	7674:  0x0000687F,
	7675:  0x00006876,
	7676:  0x000068B1,
	7677:  0x000068A7,
	7678:  0x00006897,
	7679:  0x000068B0,
	7680:  0x00006883,
	7681:  0x000068C4,
	7682:  0x000068AD,
	7683:  0x00006886,
	7684:  0x00006885,
	7685:  0x00006894,
	7686:  0x0000689D,
	7687:  0x000068A8,
	7688:  0x0000689F,
	7689:  0x000068A1,
	7690:  0x00006882,
	7691:  0x00006B32,
	7692:  0x00006BBA,
	7693:  0x00006BEB,
	7694:  0x00006BEC,
	7695:  0x00006C2B,
	7696:  0x00006D8E,
	7697:  0x00006DBC,
	7698:  0x00006DF3,
	7699:  0x00006DD9,
	7700:  0x00006DB2,
	7701:  0x00006DE1,
	7702:  0x00006DCC,
	7703:  0x00006DE4,
	7704:  0x00006DFB,
	7705:  0x00006DFA,
	7706:  0x00006E05,
	7707:  0x00006DC7,
	7708:  0x00006DCB,
	7709:  0x00006DAF,
	7710:  0x00006DD1,
	7711:  0x00006DAE,
	7712:  0x00006DDE,
	7713:  0x00006DF9,
	7714:  0x00006DB8,
	7715:  0x00006DF7,
	7716:  0x00006DF5,
	7717:  0x00006DC5,
	7718:  0x00006DD2,
	7719:  0x00006E1A,
	7720:  0x00006DB5,
	7721:  0x00006DDA,
	7722:  0x00006DEB,
	7723:  0x00006DD8,
	7724:  0x00006DEA,
	7725:  0x00006DF1,
	7726:  0x00006DEE,
	7727:  0x00006DE8,
	7728:  0x00006DC6,
	7729:  0x00006DC4,
	7730:  0x00006DAA,
	7731:  0x00006DEC,
	7732:  0x00006DBF,
	7733:  0x00006DE6,
	7734:  0x000070F9,
	7735:  0x00007109,
	7736:  0x0000710A,
	7737:  0x000070FD,
	7738:  0x000070EF,
	7739:  0x0000723D,
	7740:  0x0000727D,
	7741:  0x00007281,
	7742:  0x0000731C,
	7743:  0x0000731B,
	7744:  0x00007316,
	7745:  0x00007313,
	7746:  0x00007319,
	7747:  0x00007387,
	7748:  0x00007405,
	7749:  0x0000740A,
	7750:  0x00007403,
	7751:  0x00007406,
	7752:  0x000073FE,
	7753:  0x0000740D,
	7754:  0x000074E0,
	7755:  0x000074F6,
	7756:  0x000074F7,
	7757:  0x0000751C,
	7758:  0x00007522,
	7759:  0x00007565,
	7760:  0x00007566,
	7761:  0x00007562,
	7762:  0x00007570,
	7763:  0x0000758F,
	7764:  0x000075D4,
	7765:  0x000075D5,
	7766:  0x000075B5,
	7767:  0x000075CA,
	7768:  0x000075CD,
	7769:  0x0000768E,
	7770:  0x000076D4,
	7771:  0x000076D2,
	7772:  0x000076DB,
	7773:  0x00007737,
	7774:  0x0000773E,
	7775:  0x0000773C,
	7776:  0x00007736,
	7777:  0x00007738,
	7778:  0x0000773A,
	7779:  0x0000786B,
	7780:  0x00007843,
	7781:  0x0000784E,
	7782:  0x00007965,
	7783:  0x00007968,
	7784:  0x0000796D,
	7785:  0x000079FB,
	7786:  0x00007A92,
	7787:  0x00007A95,
	7788:  0x00007B20,
	7789:  0x00007B28,
	7790:  0x00007B1B,
	7791:  0x00007B2C,
	7792:  0x00007B26,
	7793:  0x00007B19,
	7794:  0x00007B1E,
	7795:  0x00007B2E,
	7796:  0x00007C92,
	7797:  0x00007C97,
	7798:  0x00007C95,
	7799:  0x00007D46,
	7800:  0x00007D43,
	7801:  0x00007D71,
	7802:  0x00007D2E,
	7803:  0x00007D39,
	7804:  0x00007D3C,
	7805:  0x00007D40,
	7806:  0x00007D30,
	7807:  0x00007D33,
	7808:  0x00007D44,
	7809:  0x00007D2F,
	7810:  0x00007D42,
	7811:  0x00007D32,
	7812:  0x00007D31,
	7813:  0x00007F3D,
	7814:  0x00007F9E,
	7815:  0x00007F9A,
	7816:  0x00007FCC,
	7817:  0x00007FCE,
	7818:  0x00007FD2,
	7819:  0x0000801C,
	7820:  0x0000804A,
	7821:  0x00008046,
	7822:  0x0000812F,
	7823:  0x00008116,
	7824:  0x00008123,
	7825:  0x0000812B,
	7826:  0x00008129,
	7827:  0x00008130,
	7828:  0x00008124,
	7829:  0x00008202,
	7830:  0x00008235,
	7831:  0x00008237,
	7832:  0x00008236,
	7833:  0x00008239,
	7834:  0x0000838E,
	7835:  0x0000839E,
	7836:  0x00008398,
	7837:  0x00008378,
	7838:  0x000083A2,
	7839:  0x00008396,
	7840:  0x000083BD,
	7841:  0x000083AB,
	7842:  0x00008392,
	7843:  0x0000838A,
	7844:  0x00008393,
	7845:  0x00008389,
	7846:  0x000083A0,
	7847:  0x00008377,
	7848:  0x0000837B,
	7849:  0x0000837C,
	7850:  0x00008386,
	7851:  0x000083A7,
	7852:  0x00008655,
	7853:  0x00005F6A,
	7854:  0x000086C7,
	7855:  0x000086C0,
	7856:  0x000086B6,
	7857:  0x000086C4,
	7858:  0x000086B5,
	7859:  0x000086C6,
	7860:  0x000086CB,
	7861:  0x000086B1,
	7862:  0x000086AF,
	7863:  0x000086C9,
	7864:  0x00008853,
	7865:  0x0000889E,
	7866:  0x00008888,
	7867:  0x000088AB,
	7868:  0x00008892,
	7869:  0x00008896,
	7870:  0x0000888D,
	7871:  0x0000888B,
	7872:  0x00008993,
	7873:  0x0000898F,
	7874:  0x00008A2A,
	7875:  0x00008A1D,
	7876:  0x00008A23,
	7877:  0x00008A25,
	7878:  0x00008A31,
	7879:  0x00008A2D,
	7880:  0x00008A1F,
	7881:  0x00008A1B,
	7882:  0x00008A22,
	7883:  0x00008C49,
	7884:  0x00008C5A,
	7885:  0x00008CA9,
	7886:  0x00008CAC,
	7887:  0x00008CAB,
	7888:  0x00008CA8,
	7889:  0x00008CAA,
	7890:  0x00008CA7,
	7891:  0x00008D67,
	7892:  0x00008D66,
	7893:  0x00008DBE,
	7894:  0x00008DBA,
	7895:  0x00008EDB,
	7896:  0x00008EDF,
	7897:  0x00009019,
	7898:  0x0000900D,
	7899:  0x0000901A,
	7900:  0x00009017,
	7901:  0x00009023,
	7902:  0x0000901F,
	7903:  0x0000901D,
	7904:  0x00009010,
	7905:  0x00009015,
	7906:  0x0000901E,
	7907:  0x00009020,
	7908:  0x0000900F,
	7909:  0x00009022,
	7910:  0x00009016,
	7911:  0x0000901B,
	7912:  0x00009014,
	7913:  0x000090E8,
	7914:  0x000090ED,
	7915:  0x000090FD,
	7916:  0x00009157,
	7917:  0x000091CE,
	7918:  0x000091F5,
	7919:  0x000091E6,
	7920:  0x000091E3,
	7921:  0x000091E7,
	7922:  0x000091ED,
	7923:  0x000091E9,
	7924:  0x00009589,
	7925:  0x0000966A,
	7926:  0x00009675,
	7927:  0x00009673,
	7928:  0x00009678,
	7929:  0x00009670,
	7930:  0x00009674,
	7931:  0x00009676,
	7932:  0x00009677,
	7933:  0x0000966C,
	7934:  0x000096C0,
	7935:  0x000096EA,
	7936:  0x000096E9,
	7937:  0x00007AE0,
	7938:  0x00007ADF,
	7939:  0x00009802,
	7940:  0x00009803,
	7941:  0x00009B5A,
	7942:  0x00009CE5,
	7943:  0x00009E75,
	7944:  0x00009E7F,
	7945:  0x00009EA5,
	7946:  0x00009EBB,
	7947:  0x000050A2,
	7948:  0x0000508D,
	7949:  0x00005085,
	7950:  0x00005099,
	7951:  0x00005091,
	7952:  0x00005080,
	7953:  0x00005096,
	7954:  0x00005098,
	7955:  0x0000509A,
	7956:  0x00006700,
	7957:  0x000051F1,
	7958:  0x00005272,
	7959:  0x00005274,
	7960:  0x00005275,
	7961:  0x00005269,
	7962:  0x000052DE,
	7963:  0x000052DD,
	7964:  0x000052DB,
	7965:  0x0000535A,
	7966:  0x000053A5,
	7967:  0x0000557B,
	7968:  0x00005580,
	7969:  0x000055A7,
	7970:  0x0000557C,
	7971:  0x0000558A,
	7972:  0x0000559D,
	7973:  0x00005598,
	7974:  0x00005582,
	7975:  0x0000559C,
	7976:  0x000055AA,
	7977:  0x00005594,
	7978:  0x00005587,
	7979:  0x0000558B,
	7980:  0x00005583,
	7981:  0x000055B3,
	7982:  0x000055AE,
	7983:  0x0000559F,
	7984:  0x0000553E,
	7985:  0x000055B2,
	7986:  0x0000559A,
	7987:  0x000055BB,
	7988:  0x000055AC,
	7989:  0x000055B1,
	7990:  0x0000557E,
	7991:  0x00005589,
	7992:  0x000055AB,
	7993:  0x00005599,
	7994:  0x0000570D,
	7995:  0x0000582F,
	7996:  0x0000582A,
	7997:  0x00005834,
	7998:  0x00005824,
	7999:  0x00005830,
	8000:  0x00005831,
	8001:  0x00005821,
	8002:  0x0000581D,
	8003:  0x00005820,
	8004:  0x000058F9,
	8005:  0x000058FA,
	8006:  0x00005960,
	8007:  0x00005A77,
	8008:  0x00005A9A,
	8009:  0x00005A7F,
	8010:  0x00005A92,
	8011:  0x00005A9B,
	8012:  0x00005AA7,
	8013:  0x00005B73,
	8014:  0x00005B71,
	8015:  0x00005BD2,
	8016:  0x00005BCC,
	8017:  0x00005BD3,
	8018:  0x00005BD0,
	8019:  0x00005C0A,
	8020:  0x00005C0B,
	8021:  0x00005C31,
	8022:  0x00005D4C,
	8023:  0x00005D50,
	8024:  0x00005D34,
	8025:  0x00005D47,
	8026:  0x00005DFD,
	8027:  0x00005E45,
	8028:  0x00005E3D,
	8029:  0x00005E40,
	8030:  0x00005E43,
	8031:  0x00005E7E,
	8032:  0x00005ECA,
	8033:  0x00005EC1,
	8034:  0x00005EC2,
	8035:  0x00005EC4,
	8036:  0x00005F3C,
	8037:  0x00005F6D,
	8038:  0x00005FA9,
	8039:  0x00005FAA,
	8040:  0x00005FA8,
	8041:  0x000060D1,
	8042:  0x000060E1,
	8043:  0x000060B2,
	8044:  0x000060B6,
	8045:  0x000060E0,
	8046:  0x0000611C,
	8047:  0x00006123,
	8048:  0x000060FA,
	8049:  0x00006115,
	8050:  0x000060F0,
	8051:  0x000060FB,
	8052:  0x000060F4,
	8053:  0x00006168,
	8054:  0x000060F1,
	8055:  0x0000610E,
	8056:  0x000060F6,
	8057:  0x00006109,
	8058:  0x00006100,
	8059:  0x00006112,
	8060:  0x0000621F,
	8061:  0x00006249,
	8062:  0x000063A3,
	8063:  0x0000638C,
	8064:  0x000063CF,
	8065:  0x000063C0,
	8066:  0x000063E9,
	8067:  0x000063C9,
	8068:  0x000063C6,
	8069:  0x000063CD,
	8070:  0x000063D2,
	8071:  0x000063E3,
	8072:  0x000063D0,
	8073:  0x000063E1,
	8074:  0x000063D6,
	8075:  0x000063ED,
	8076:  0x000063EE,
	8077:  0x00006376,
	8078:  0x000063F4,
	8079:  0x000063EA,
	8080:  0x000063DB,
	8081:  0x00006452,
	8082:  0x000063DA,
	8083:  0x000063F9,
	8084:  0x0000655E,
	8085:  0x00006566,
	8086:  0x00006562,
	8087:  0x00006563,
	8088:  0x00006591,
	8089:  0x00006590,
	8090:  0x000065AF,
	8091:  0x0000666E,
	8092:  0x00006670,
	8093:  0x00006674,
	8094:  0x00006676,
	8095:  0x0000666F,
	8096:  0x00006691,
	8097:  0x0000667A,
	8098:  0x0000667E,
	8099:  0x00006677,
	8100:  0x000066FE,
	8101:  0x000066FF,
	8102:  0x0000671F,
	8103:  0x0000671D,
	8104:  0x000068FA,
	8105:  0x000068D5,
	8106:  0x000068E0,
	8107:  0x000068D8,
	8108:  0x000068D7,
	8109:  0x00006905,
	8110:  0x000068DF,
	8111:  0x000068F5,
	8112:  0x000068EE,
	8113:  0x000068E7,
	8114:  0x000068F9,
	8115:  0x000068D2,
	8116:  0x000068F2,
	8117:  0x000068E3,
	8118:  0x000068CB,
	8119:  0x000068CD,
	8120:  0x0000690D,
	8121:  0x00006912,
	8122:  0x0000690E,
	8123:  0x000068C9,
	8124:  0x000068DA,
	8125:  0x0000696E,
	8126:  0x000068FB,
	8127:  0x00006B3E,
	8128:  0x00006B3A,
	8129:  0x00006B3D,
	8130:  0x00006B98,
	8131:  0x00006B96,
	8132:  0x00006BBC,
	8133:  0x00006BEF,
	8134:  0x00006C2E,
	8135:  0x00006C2F,
	8136:  0x00006C2C,
	8137:  0x00006E2F,
	8138:  0x00006E38,
	8139:  0x00006E54,
	8140:  0x00006E21,
	8141:  0x00006E32,
	8142:  0x00006E67,
	8143:  0x00006E4A,
	8144:  0x00006E20,
	8145:  0x00006E25,
	8146:  0x00006E23,
	8147:  0x00006E1B,
	8148:  0x00006E5B,
	8149:  0x00006E58,
	8150:  0x00006E24,
	8151:  0x00006E56,
	8152:  0x00006E6E,
	8153:  0x00006E2D,
	8154:  0x00006E26,
	8155:  0x00006E6F,
	8156:  0x00006E34,
	8157:  0x00006E4D,
	8158:  0x00006E3A,
	8159:  0x00006E2C,
	8160:  0x00006E43,
	8161:  0x00006E1D,
	8162:  0x00006E3E,
	8163:  0x00006ECB,
	8164:  0x00006E89,
	8165:  0x00006E19,
	8166:  0x00006E4E,
	8167:  0x00006E63,
	8168:  0x00006E44,
	8169:  0x00006E72,
	8170:  0x00006E69,
	8171:  0x00006E5F,
	8172:  0x00007119,
	8173:  0x0000711A,
	8174:  0x00007126,
	8175:  0x00007130,
	8176:  0x00007121,
	8177:  0x00007136,
	8178:  0x0000716E,
	8179:  0x0000711C,
	8180:  0x0000724C,
	8181:  0x00007284,
	8182:  0x00007280,
	8183:  0x00007336,
	8184:  0x00007325,
	8185:  0x00007334,
	8186:  0x00007329,
	8187:  0x0000743A,
	8188:  0x0000742A,
	8189:  0x00007433,
	8190:  0x00007422,
	8191:  0x00007425,
	8192:  0x00007435,
	8193:  0x00007436,
	8194:  0x00007434,
	8195:  0x0000742F,
	8196:  0x0000741B,
	8197:  0x00007426,
	8198:  0x00007428,
	8199:  0x00007525,
	8200:  0x00007526,
	8201:  0x0000756B,
	8202:  0x0000756A,
	8203:  0x000075E2,
	8204:  0x000075DB,
	8205:  0x000075E3,
	8206:  0x000075D9,
	8207:  0x000075D8,
	8208:  0x000075DE,
	8209:  0x000075E0,
	8210:  0x0000767B,
	8211:  0x0000767C,
	8212:  0x00007696,
	8213:  0x00007693,
	8214:  0x000076B4,
	8215:  0x000076DC,
	8216:  0x0000774F,
	8217:  0x000077ED,
	8218:  0x0000785D,
	8219:  0x0000786C,
	8220:  0x0000786F,
	8221:  0x00007A0D,
	8222:  0x00007A08,
	8223:  0x00007A0B,
	8224:  0x00007A05,
	8225:  0x00007A00,
	8226:  0x00007A98,
	8227:  0x00007A97,
	8228:  0x00007A96,
	8229:  0x00007AE5,
	8230:  0x00007AE3,
	8231:  0x00007B49,
	8232:  0x00007B56,
	8233:  0x00007B46,
	8234:  0x00007B50,
	8235:  0x00007B52,
	8236:  0x00007B54,
	8237:  0x00007B4D,
	8238:  0x00007B4B,
	8239:  0x00007B4F,
	8240:  0x00007B51,
	8241:  0x00007C9F,
	8242:  0x00007CA5,
	8243:  0x00007D5E,
	8244:  0x00007D50,
	8245:  0x00007D68,
	8246:  0x00007D55,
	8247:  0x00007D2B,
	8248:  0x00007D6E,
	8249:  0x00007D72,
	8250:  0x00007D61,
	8251:  0x00007D66,
	8252:  0x00007D62,
	8253:  0x00007D70,
	8254:  0x00007D73,
	8255:  0x00005584,
	8256:  0x00007FD4,
	8257:  0x00007FD5,
	8258:  0x0000800B,
	8259:  0x00008052,
	8260:  0x00008085,
	8261:  0x00008155,
	8262:  0x00008154,
	8263:  0x0000814B,
	8264:  0x00008151,
	8265:  0x0000814E,
	8266:  0x00008139,
	8267:  0x00008146,
	8268:  0x0000813E,
	8269:  0x0000814C,
	8270:  0x00008153,
	8271:  0x00008174,
	8272:  0x00008212,
	8273:  0x0000821C,
	8274:  0x000083E9,
	8275:  0x00008403,
	8276:  0x000083F8,
	8277:  0x0000840D,
	8278:  0x000083E0,
	8279:  0x000083C5,
	8280:  0x0000840B,
	8281:  0x000083C1,
	8282:  0x000083EF,
	8283:  0x000083F1,
	8284:  0x000083F4,
	8285:  0x00008457,
	8286:  0x0000840A,
	8287:  0x000083F0,
	8288:  0x0000840C,
	8289:  0x000083CC,
	8290:  0x000083FD,
	8291:  0x000083F2,
	8292:  0x000083CA,
	8293:  0x00008438,
	8294:  0x0000840E,
	8295:  0x00008404,
	8296:  0x000083DC,
	8297:  0x00008407,
	8298:  0x000083D4,
	8299:  0x000083DF,
	8300:  0x0000865B,
	8301:  0x000086DF,
	8302:  0x000086D9,
	8303:  0x000086ED,
	8304:  0x000086D4,
	8305:  0x000086DB,
	8306:  0x000086E4,
	8307:  0x000086D0,
	8308:  0x000086DE,
	8309:  0x00008857,
	8310:  0x000088C1,
	8311:  0x000088C2,
	8312:  0x000088B1,
	8313:  0x00008983,
	8314:  0x00008996,
	8315:  0x00008A3B,
	8316:  0x00008A60,
	8317:  0x00008A55,
	8318:  0x00008A5E,
	8319:  0x00008A3C,
	8320:  0x00008A41,
	8321:  0x00008A54,
	8322:  0x00008A5B,
	8323:  0x00008A50,
	8324:  0x00008A46,
	8325:  0x00008A34,
	8326:  0x00008A3A,
	8327:  0x00008A36,
	8328:  0x00008A56,
	8329:  0x00008C61,
	8330:  0x00008C82,
	8331:  0x00008CAF,
	8332:  0x00008CBC,
	8333:  0x00008CB3,
	8334:  0x00008CBD,
	8335:  0x00008CC1,
	8336:  0x00008CBB,
	8337:  0x00008CC0,
	8338:  0x00008CB4,
	8339:  0x00008CB7,
	8340:  0x00008CB6,
	8341:  0x00008CBF,
	8342:  0x00008CB8,
	8343:  0x00008D8A,
	8344:  0x00008D85,
	8345:  0x00008D81,
	8346:  0x00008DCE,
	8347:  0x00008DDD,
	8348:  0x00008DCB,
	8349:  0x00008DDA,
	8350:  0x00008DD1,
	8351:  0x00008DCC,
	8352:  0x00008DDB,
	8353:  0x00008DC6,
	8354:  0x00008EFB,
	8355:  0x00008EF8,
	8356:  0x00008EFC,
	8357:  0x00008F9C,
	8358:  0x0000902E,
	8359:  0x00009035,
	8360:  0x00009031,
	8361:  0x00009038,
	8362:  0x00009032,
	8363:  0x00009036,
	8364:  0x00009102,
	8365:  0x000090F5,
	8366:  0x00009109,
	8367:  0x000090FE,
	8368:  0x00009163,
	8369:  0x00009165,
	8370:  0x000091CF,
	8371:  0x00009214,
	8372:  0x00009215,
	8373:  0x00009223,
	8374:  0x00009209,
	8375:  0x0000921E,
	8376:  0x0000920D,
	8377:  0x00009210,
	8378:  0x00009207,
	8379:  0x00009211,
	8380:  0x00009594,
	8381:  0x0000958F,
	8382:  0x0000958B,
	8383:  0x00009591,
	8384:  0x00009593,
	8385:  0x00009592,
	8386:  0x0000958E,
	8387:  0x0000968A,
	8388:  0x0000968E,
	8389:  0x0000968B,
	8390:  0x0000967D,
	8391:  0x00009685,
	8392:  0x00009686,
	8393:  0x0000968D,
	8394:  0x00009672,
	8395:  0x00009684,
	8396:  0x000096C1,
	8397:  0x000096C5,
	8398:  0x000096C4,
	8399:  0x000096C6,
	8400:  0x000096C7,
	8401:  0x000096EF,
	8402:  0x000096F2,
	8403:  0x000097CC,
	8404:  0x00009805,
	8405:  0x00009806,
	8406:  0x00009808,
	8407:  0x000098E7,
	8408:  0x000098EA,
	8409:  0x000098EF,
	8410:  0x000098E9,
	8411:  0x000098F2,
	8412:  0x000098ED,
	8413:  0x000099AE,
	8414:  0x000099AD,
	8415:  0x00009EC3,
	8416:  0x00009ECD,
	8417:  0x00009ED1,
	8418:  0x00004E82,
	8419:  0x000050AD,
	8420:  0x000050B5,
	8421:  0x000050B2,
	8422:  0x000050B3,
	8423:  0x000050C5,
	8424:  0x000050BE,
	8425:  0x000050AC,
	8426:  0x000050B7,
	8427:  0x000050BB,
	8428:  0x000050AF,
	8429:  0x000050C7,
	8430:  0x0000527F,
	8431:  0x00005277,
	8432:  0x0000527D,
	8433:  0x000052DF,
	8434:  0x000052E6,
	8435:  0x000052E4,
	8436:  0x000052E2,
	8437:  0x000052E3,
	8438:  0x0000532F,
	8439:  0x000055DF,
	8440:  0x000055E8,
	8441:  0x000055D3,
	8442:  0x000055E6,
	8443:  0x000055CE,
	8444:  0x000055DC,
	8445:  0x000055C7,
	8446:  0x000055D1,
	8447:  0x000055E3,
	8448:  0x000055E4,
	8449:  0x000055EF,
	8450:  0x000055DA,
	8451:  0x000055E1,
	8452:  0x000055C5,
	8453:  0x000055C6,
	8454:  0x000055E5,
	8455:  0x000055C9,
	8456:  0x00005712,
	8457:  0x00005713,
	8458:  0x0000585E,
	8459:  0x00005851,
	8460:  0x00005858,
	8461:  0x00005857,
	8462:  0x0000585A,
	8463:  0x00005854,
	8464:  0x0000586B,
	8465:  0x0000584C,
	8466:  0x0000586D,
	8467:  0x0000584A,
	8468:  0x00005862,
	8469:  0x00005852,
	8470:  0x0000584B,
	8471:  0x00005967,
	8472:  0x00005AC1,
	8473:  0x00005AC9,
	8474:  0x00005ACC,
	8475:  0x00005ABE,
	8476:  0x00005ABD,
	8477:  0x00005ABC,
	8478:  0x00005AB3,
	8479:  0x00005AC2,
	8480:  0x00005AB2,
	8481:  0x00005D69,
	8482:  0x00005D6F,
	8483:  0x00005E4C,
	8484:  0x00005E79,
	8485:  0x00005EC9,
	8486:  0x00005EC8,
	8487:  0x00005F12,
	8488:  0x00005F59,
	8489:  0x00005FAC,
	8490:  0x00005FAE,
	8491:  0x0000611A,
	8492:  0x0000610F,
	8493:  0x00006148,
	8494:  0x0000611F,
	8495:  0x000060F3,
	8496:  0x0000611B,
	8497:  0x000060F9,
	8498:  0x00006101,
	8499:  0x00006108,
	8500:  0x0000614E,
	8501:  0x0000614C,
	8502:  0x00006144,
	8503:  0x0000614D,
	8504:  0x0000613E,
	8505:  0x00006134,
	8506:  0x00006127,
	8507:  0x0000610D,
	8508:  0x00006106,
	8509:  0x00006137,
	8510:  0x00006221,
	8511:  0x00006222,
	8512:  0x00006413,
	8513:  0x0000643E,
	8514:  0x0000641E,
	8515:  0x0000642A,
	8516:  0x0000642D,
	8517:  0x0000643D,
	8518:  0x0000642C,
	8519:  0x0000640F,
	8520:  0x0000641C,
	8521:  0x00006414,
	8522:  0x0000640D,
	8523:  0x00006436,
	8524:  0x00006416,
	8525:  0x00006417,
	8526:  0x00006406,
	8527:  0x0000656C,
	8528:  0x0000659F,
	8529:  0x000065B0,
	8530:  0x00006697,
	8531:  0x00006689,
	8532:  0x00006687,
	8533:  0x00006688,
	8534:  0x00006696,
	8535:  0x00006684,
	8536:  0x00006698,
	8537:  0x0000668D,
	8538:  0x00006703,
	8539:  0x00006994,
	8540:  0x0000696D,
	8541:  0x0000695A,
	8542:  0x00006977,
	8543:  0x00006960,
	8544:  0x00006954,
	8545:  0x00006975,
	8546:  0x00006930,
	8547:  0x00006982,
	8548:  0x0000694A,
	8549:  0x00006968,
	8550:  0x0000696B,
	8551:  0x0000695E,
	8552:  0x00006953,
	8553:  0x00006979,
	8554:  0x00006986,
	8555:  0x0000695D,
	8556:  0x00006963,
	8557:  0x0000695B,
	8558:  0x00006B47,
	8559:  0x00006B72,
	8560:  0x00006BC0,
	8561:  0x00006BBF,
	8562:  0x00006BD3,
	8563:  0x00006BFD,
	8564:  0x00006EA2,
	8565:  0x00006EAF,
	8566:  0x00006ED3,
	8567:  0x00006EB6,
	8568:  0x00006EC2,
	8569:  0x00006E90,
	8570:  0x00006E9D,
	8571:  0x00006EC7,
	8572:  0x00006EC5,
	8573:  0x00006EA5,
	8574:  0x00006E98,
	8575:  0x00006EBC,
	8576:  0x00006EBA,
	8577:  0x00006EAB,
	8578:  0x00006ED1,
	8579:  0x00006E96,
	8580:  0x00006E9C,
	8581:  0x00006EC4,
	8582:  0x00006ED4,
	8583:  0x00006EAA,
	8584:  0x00006EA7,
	8585:  0x00006EB4,
	8586:  0x0000714E,
	8587:  0x00007159,
	8588:  0x00007169,
	8589:  0x00007164,
	8590:  0x00007149,
	8591:  0x00007167,
	8592:  0x0000715C,
	8593:  0x0000716C,
	8594:  0x00007166,
	8595:  0x0000714C,
	8596:  0x00007165,
	8597:  0x0000715E,
	8598:  0x00007146,
	8599:  0x00007168,
	8600:  0x00007156,
	8601:  0x0000723A,
	8602:  0x00007252,
	8603:  0x00007337,
	8604:  0x00007345,
	8605:  0x0000733F,
	8606:  0x0000733E,
	8607:  0x0000746F,
	8608:  0x0000745A,
	8609:  0x00007455,
	8610:  0x0000745F,
	8611:  0x0000745E,
	8612:  0x00007441,
	8613:  0x0000743F,
	8614:  0x00007459,
	8615:  0x0000745B,
	8616:  0x0000745C,
	8617:  0x00007576,
	8618:  0x00007578,
	8619:  0x00007600,
	8620:  0x000075F0,
	8621:  0x00007601,
	8622:  0x000075F2,
	8623:  0x000075F1,
	8624:  0x000075FA,
	8625:  0x000075FF,
	8626:  0x000075F4,
	8627:  0x000075F3,
	8628:  0x000076DE,
	8629:  0x000076DF,
	8630:  0x0000775B,
	8631:  0x0000776B,
	8632:  0x00007766,
	8633:  0x0000775E,
	8634:  0x00007763,
	8635:  0x00007779,
	8636:  0x0000776A,
	8637:  0x0000776C,
	8638:  0x0000775C,
	8639:  0x00007765,
	8640:  0x00007768,
	8641:  0x00007762,
	8642:  0x000077EE,
	8643:  0x0000788E,
	8644:  0x000078B0,
	8645:  0x00007897,
	8646:  0x00007898,
	8647:  0x0000788C,
	8648:  0x00007889,
	8649:  0x0000787C,
	8650:  0x00007891,
	8651:  0x00007893,
	8652:  0x0000787F,
	8653:  0x0000797A,
	8654:  0x0000797F,
	8655:  0x00007981,
	8656:  0x0000842C,
	8657:  0x000079BD,
	8658:  0x00007A1C,
	8659:  0x00007A1A,
	8660:  0x00007A20,
	8661:  0x00007A14,
	8662:  0x00007A1F,
	8663:  0x00007A1E,
	8664:  0x00007A9F,
	8665:  0x00007AA0,
	8666:  0x00007B77,
	8667:  0x00007BC0,
	8668:  0x00007B60,
	8669:  0x00007B6E,
	8670:  0x00007B67,
	8671:  0x00007CB1,
	8672:  0x00007CB3,
	8673:  0x00007CB5,
	8674:  0x00007D93,
	8675:  0x00007D79,
	8676:  0x00007D91,
	8677:  0x00007D81,
	8678:  0x00007D8F,
	8679:  0x00007D5B,
	8680:  0x00007F6E,
	8681:  0x00007F69,
	8682:  0x00007F6A,
	8683:  0x00007F72,
	8684:  0x00007FA9,
	8685:  0x00007FA8,
	8686:  0x00007FA4,
	8687:  0x00008056,
	8688:  0x00008058,
	8689:  0x00008086,
	8690:  0x00008084,
	8691:  0x00008171,
	8692:  0x00008170,
	8693:  0x00008178,
	8694:  0x00008165,
	8695:  0x0000816E,
	8696:  0x00008173,
	8697:  0x0000816B,
	8698:  0x00008179,
	8699:  0x0000817A,
	8700:  0x00008166,
	8701:  0x00008205,
	8702:  0x00008247,
	8703:  0x00008482,
	8704:  0x00008477,
	8705:  0x0000843D,
	8706:  0x00008431,
	8707:  0x00008475,
	8708:  0x00008466,
	8709:  0x0000846B,
	8710:  0x00008449,
	8711:  0x0000846C,
	8712:  0x0000845B,
	8713:  0x0000843C,
	8714:  0x00008435,
	8715:  0x00008461,
	8716:  0x00008463,
	8717:  0x00008469,
	8718:  0x0000846D,
	8719:  0x00008446,
	8720:  0x0000865E,
	8721:  0x0000865C,
	8722:  0x0000865F,
	8723:  0x000086F9,
	8724:  0x00008713,
	8725:  0x00008708,
	8726:  0x00008707,
	8727:  0x00008700,
	8728:  0x000086FE,
	8729:  0x000086FB,
	8730:  0x00008702,
	8731:  0x00008703,
	8732:  0x00008706,
	8733:  0x0000870A,
	8734:  0x00008859,
	8735:  0x000088DF,
	8736:  0x000088D4,
	8737:  0x000088D9,
	8738:  0x000088DC,
	8739:  0x000088D8,
	8740:  0x000088DD,
	8741:  0x000088E1,
	8742:  0x000088CA,
	8743:  0x000088D5,
	8744:  0x000088D2,
	8745:  0x0000899C,
	8746:  0x000089E3,
	8747:  0x00008A6B,
	8748:  0x00008A72,
	8749:  0x00008A73,
	8750:  0x00008A66,
	8751:  0x00008A69,
	8752:  0x00008A70,
	8753:  0x00008A87,
	8754:  0x00008A7C,
	8755:  0x00008A63,
	8756:  0x00008AA0,
	8757:  0x00008A71,
	8758:  0x00008A85,
	8759:  0x00008A6D,
	8760:  0x00008A62,
	8761:  0x00008A6E,
	8762:  0x00008A6C,
	8763:  0x00008A79,
	8764:  0x00008A7B,
	8765:  0x00008A3E,
	8766:  0x00008A68,
	8767:  0x00008C62,
	8768:  0x00008C8A,
	8769:  0x00008C89,
	8770:  0x00008CCA,
	8771:  0x00008CC7,
	8772:  0x00008CC8,
	8773:  0x00008CC4,
	8774:  0x00008CB2,
	8775:  0x00008CC3,
	8776:  0x00008CC2,
	8777:  0x00008CC5,
	8778:  0x00008DE1,
	8779:  0x00008DDF,
	8780:  0x00008DE8,
	8781:  0x00008DEF,
	8782:  0x00008DF3,
	8783:  0x00008DFA,
	8784:  0x00008DEA,
	8785:  0x00008DE4,
	8786:  0x00008DE6,
	8787:  0x00008EB2,
	8788:  0x00008F03,
	8789:  0x00008F09,
	8790:  0x00008EFE,
	8791:  0x00008F0A,
	8792:  0x00008F9F,
	8793:  0x00008FB2,
	8794:  0x0000904B,
	8795:  0x0000904A,
	8796:  0x00009053,
	8797:  0x00009042,
	8798:  0x00009054,
	8799:  0x0000903C,
	8800:  0x00009055,
	8801:  0x00009050,
	8802:  0x00009047,
	8803:  0x0000904F,
	8804:  0x0000904E,
	8805:  0x0000904D,
	8806:  0x00009051,
	8807:  0x0000903E,
	8808:  0x00009041,
	8809:  0x00009112,
	8810:  0x00009117,
	8811:  0x0000916C,
	8812:  0x0000916A,
	8813:  0x00009169,
	8814:  0x000091C9,
	8815:  0x00009237,
	8816:  0x00009257,
	8817:  0x00009238,
	8818:  0x0000923D,
	8819:  0x00009240,
	8820:  0x0000923E,
	8821:  0x0000925B,
	8822:  0x0000924B,
	8823:  0x00009264,
	8824:  0x00009251,
	8825:  0x00009234,
	8826:  0x00009249,
	8827:  0x0000924D,
	8828:  0x00009245,
	8829:  0x00009239,
	8830:  0x0000923F,
	8831:  0x0000925A,
	8832:  0x00009598,
	8833:  0x00009698,
	8834:  0x00009694,
	8835:  0x00009695,
	8836:  0x000096CD,
	8837:  0x000096CB,
	8838:  0x000096C9,
	8839:  0x000096CA,
	8840:  0x000096F7,
	8841:  0x000096FB,
	8842:  0x000096F9,
	8843:  0x000096F6,
	8844:  0x00009756,
	8845:  0x00009774,
	8846:  0x00009776,
	8847:  0x00009810,
	8848:  0x00009811,
	8849:  0x00009813,
	8850:  0x0000980A,
	8851:  0x00009812,
	8852:  0x0000980C,
	8853:  0x000098FC,
	8854:  0x000098F4,
	8855:  0x000098FD,
	8856:  0x000098FE,
	8857:  0x000099B3,
	8858:  0x000099B1,
	8859:  0x000099B4,
	8860:  0x00009AE1,
	8861:  0x00009CE9,
	8862:  0x00009E82,
	8863:  0x00009F0E,
	8864:  0x00009F13,
	8865:  0x00009F20,
	8866:  0x000050E7,
	8867:  0x000050EE,
	8868:  0x000050E5,
	8869:  0x000050D6,
	8870:  0x000050ED,
	8871:  0x000050DA,
	8872:  0x000050D5,
	8873:  0x000050CF,
	8874:  0x000050D1,
	8875:  0x000050F1,
	8876:  0x000050CE,
	8877:  0x000050E9,
	8878:  0x00005162,
	8879:  0x000051F3,
	8880:  0x00005283,
	8881:  0x00005282,
	8882:  0x00005331,
	8883:  0x000053AD,
	8884:  0x000055FE,
	8885:  0x00005600,
	8886:  0x0000561B,
	8887:  0x00005617,
	8888:  0x000055FD,
	8889:  0x00005614,
	8890:  0x00005606,
	8891:  0x00005609,
	8892:  0x0000560D,
	8893:  0x0000560E,
	8894:  0x000055F7,
	8895:  0x00005616,
	8896:  0x0000561F,
	8897:  0x00005608,
	8898:  0x00005610,
	8899:  0x000055F6,
	8900:  0x00005718,
	8901:  0x00005716,
	8902:  0x00005875,
	8903:  0x0000587E,
	8904:  0x00005883,
	8905:  0x00005893,
	8906:  0x0000588A,
	8907:  0x00005879,
	8908:  0x00005885,
	8909:  0x0000587D,
	8910:  0x000058FD,
	8911:  0x00005925,
	8912:  0x00005922,
	8913:  0x00005924,
	8914:  0x0000596A,
	8915:  0x00005969,
	8916:  0x00005AE1,
	8917:  0x00005AE6,
	8918:  0x00005AE9,
	8919:  0x00005AD7,
	8920:  0x00005AD6,
	8921:  0x00005AD8,
	8922:  0x00005AE3,
	8923:  0x00005B75,
	8924:  0x00005BDE,
	8925:  0x00005BE7,
	8926:  0x00005BE1,
	8927:  0x00005BE5,
	8928:  0x00005BE6,
	8929:  0x00005BE8,
	8930:  0x00005BE2,
	8931:  0x00005BE4,
	8932:  0x00005BDF,
	8933:  0x00005C0D,
	8934:  0x00005C62,
	8935:  0x00005D84,
	8936:  0x00005D87,
	8937:  0x00005E5B,
	8938:  0x00005E63,
	8939:  0x00005E55,
	8940:  0x00005E57,
	8941:  0x00005E54,
	8942:  0x00005ED3,
	8943:  0x00005ED6,
	8944:  0x00005F0A,
	8945:  0x00005F46,
	8946:  0x00005F70,
	8947:  0x00005FB9,
	8948:  0x00006147,
	8949:  0x0000613F,
	8950:  0x0000614B,
	8951:  0x00006177,
	8952:  0x00006162,
	8953:  0x00006163,
	8954:  0x0000615F,
	8955:  0x0000615A,
	8956:  0x00006158,
	8957:  0x00006175,
	8958:  0x0000622A,
	8959:  0x00006487,
	8960:  0x00006458,
	8961:  0x00006454,
	8962:  0x000064A4,
	8963:  0x00006478,
	8964:  0x0000645F,
	8965:  0x0000647A,
	8966:  0x00006451,
	8967:  0x00006467,
	8968:  0x00006434,
	8969:  0x0000646D,
	8970:  0x0000647B,
	8971:  0x00006572,
	8972:  0x000065A1,
	8973:  0x000065D7,
	8974:  0x000065D6,
	8975:  0x000066A2,
	8976:  0x000066A8,
	8977:  0x0000669D,
	8978:  0x0000699C,
	8979:  0x000069A8,
	8980:  0x00006995,
	8981:  0x000069C1,
	8982:  0x000069AE,
	8983:  0x000069D3,
	8984:  0x000069CB,
	8985:  0x0000699B,
	8986:  0x000069B7,
	8987:  0x000069BB,
	8988:  0x000069AB,
	8989:  0x000069B4,
	8990:  0x000069D0,
	8991:  0x000069CD,
	8992:  0x000069AD,
	8993:  0x000069CC,
	8994:  0x000069A6,
	8995:  0x000069C3,
	8996:  0x000069A3,
	8997:  0x00006B49,
	8998:  0x00006B4C,
	8999:  0x00006C33,
	9000:  0x00006F33,
	9001:  0x00006F14,
	9002:  0x00006EFE,
	9003:  0x00006F13,
	9004:  0x00006EF4,
	9005:  0x00006F29,
	9006:  0x00006F3E,
	9007:  0x00006F20,
	9008:  0x00006F2C,
	9009:  0x00006F0F,
	9010:  0x00006F02,
	9011:  0x00006F22,
	9012:  0x00006EFF,
	9013:  0x00006EEF,
	9014:  0x00006F06,
	9015:  0x00006F31,
	9016:  0x00006F38,
	9017:  0x00006F32,
	9018:  0x00006F23,
	9019:  0x00006F15,
	9020:  0x00006F2B,
	9021:  0x00006F2F,
	9022:  0x00006F88,
	9023:  0x00006F2A,
	9024:  0x00006EEC,
	9025:  0x00006F01,
	9026:  0x00006EF2,
	9027:  0x00006ECC,
	9028:  0x00006EF7,
	9029:  0x00007194,
	9030:  0x00007199,
	9031:  0x0000717D,
	9032:  0x0000718A,
	9033:  0x00007184,
	9034:  0x00007192,
	9035:  0x0000723E,
	9036:  0x00007292,
	9037:  0x00007296,
	9038:  0x00007344,
	9039:  0x00007350,
	9040:  0x00007464,
	9041:  0x00007463,
	9042:  0x0000746A,
	9043:  0x00007470,
	9044:  0x0000746D,
	9045:  0x00007504,
	9046:  0x00007591,
	9047:  0x00007627,
	9048:  0x0000760D,
	9049:  0x0000760B,
	9050:  0x00007609,
	9051:  0x00007613,
	9052:  0x000076E1,
	9053:  0x000076E3,
	9054:  0x00007784,
	9055:  0x0000777D,
	9056:  0x0000777F,
	9057:  0x00007761,
	9058:  0x000078C1,
	9059:  0x0000789F,
	9060:  0x000078A7,
	9061:  0x000078B3,
	9062:  0x000078A9,
	9063:  0x000078A3,
	9064:  0x0000798E,
	9065:  0x0000798F,
	9066:  0x0000798D,
	9067:  0x00007A2E,
	9068:  0x00007A31,
	9069:  0x00007AAA,
	9070:  0x00007AA9,
	9071:  0x00007AED,
	9072:  0x00007AEF,
	9073:  0x00007BA1,
	9074:  0x00007B95,
	9075:  0x00007B8B,
	9076:  0x00007B75,
	9077:  0x00007B97,
	9078:  0x00007B9D,
	9079:  0x00007B94,
	9080:  0x00007B8F,
	9081:  0x00007BB8,
	9082:  0x00007B87,
	9083:  0x00007B84,
	9084:  0x00007CB9,
	9085:  0x00007CBD,
	9086:  0x00007CBE,
	9087:  0x00007DBB,
	9088:  0x00007DB0,
	9089:  0x00007D9C,
	9090:  0x00007DBD,
	9091:  0x00007DBE,
	9092:  0x00007DA0,
	9093:  0x00007DCA,
	9094:  0x00007DB4,
	9095:  0x00007DB2,
	9096:  0x00007DB1,
	9097:  0x00007DBA,
	9098:  0x00007DA2,
	9099:  0x00007DBF,
	9100:  0x00007DB5,
	9101:  0x00007DB8,
	9102:  0x00007DAD,
	9103:  0x00007DD2,
	9104:  0x00007DC7,
	9105:  0x00007DAC,
	9106:  0x00007F70,
	9107:  0x00007FE0,
	9108:  0x00007FE1,
	9109:  0x00007FDF,
	9110:  0x0000805E,
	9111:  0x0000805A,
	9112:  0x00008087,
	9113:  0x00008150,
	9114:  0x00008180,
	9115:  0x0000818F,
	9116:  0x00008188,
	9117:  0x0000818A,
	9118:  0x0000817F,
	9119:  0x00008182,
	9120:  0x000081E7,
	9121:  0x000081FA,
	9122:  0x00008207,
	9123:  0x00008214,
	9124:  0x0000821E,
	9125:  0x0000824B,
	9126:  0x000084C9,
	9127:  0x000084BF,
	9128:  0x000084C6,
	9129:  0x000084C4,
	9130:  0x00008499,
	9131:  0x0000849E,
	9132:  0x000084B2,
	9133:  0x0000849C,
	9134:  0x000084CB,
	9135:  0x000084B8,
	9136:  0x000084C0,
	9137:  0x000084D3,
	9138:  0x00008490,
	9139:  0x000084BC,
	9140:  0x000084D1,
	9141:  0x000084CA,
	9142:  0x0000873F,
	9143:  0x0000871C,
	9144:  0x0000873B,
	9145:  0x00008722,
	9146:  0x00008725,
	9147:  0x00008734,
	9148:  0x00008718,
	9149:  0x00008755,
	9150:  0x00008737,
	9151:  0x00008729,
	9152:  0x000088F3,
	9153:  0x00008902,
	9154:  0x000088F4,
	9155:  0x000088F9,
	9156:  0x000088F8,
	9157:  0x000088FD,
	9158:  0x000088E8,
	9159:  0x0000891A,
	9160:  0x000088EF,
	9161:  0x00008AA6,
	9162:  0x00008A8C,
	9163:  0x00008A9E,
	9164:  0x00008AA3,
	9165:  0x00008A8D,
	9166:  0x00008AA1,
	9167:  0x00008A93,
	9168:  0x00008AA4,
	9169:  0x00008AAA,
	9170:  0x00008AA5,
	9171:  0x00008AA8,
	9172:  0x00008A98,
	9173:  0x00008A91,
	9174:  0x00008A9A,
	9175:  0x00008AA7,
	9176:  0x00008C6A,
	9177:  0x00008C8D,
	9178:  0x00008C8C,
	9179:  0x00008CD3,
	9180:  0x00008CD1,
	9181:  0x00008CD2,
	9182:  0x00008D6B,
	9183:  0x00008D99,
	9184:  0x00008D95,
	9185:  0x00008DFC,
	9186:  0x00008F14,
	9187:  0x00008F12,
	9188:  0x00008F15,
	9189:  0x00008F13,
	9190:  0x00008FA3,
	9191:  0x00009060,
	9192:  0x00009058,
	9193:  0x0000905C,
	9194:  0x00009063,
	9195:  0x00009059,
	9196:  0x0000905E,
	9197:  0x00009062,
	9198:  0x0000905D,
	9199:  0x0000905B,
	9200:  0x00009119,
	9201:  0x00009118,
	9202:  0x0000911E,
	9203:  0x00009175,
	9204:  0x00009178,
	9205:  0x00009177,
	9206:  0x00009174,
	9207:  0x00009278,
	9208:  0x00009280,
	9209:  0x00009285,
	9210:  0x00009298,
	9211:  0x00009296,
	9212:  0x0000927B,
	9213:  0x00009293,
	9214:  0x0000929C,
	9215:  0x000092A8,
	9216:  0x0000927C,
	9217:  0x00009291,
	9218:  0x000095A1,
	9219:  0x000095A8,
	9220:  0x000095A9,
	9221:  0x000095A3,
	9222:  0x000095A5,
	9223:  0x000095A4,
	9224:  0x00009699,
	9225:  0x0000969C,
	9226:  0x0000969B,
	9227:  0x000096CC,
	9228:  0x000096D2,
	9229:  0x00009700,
	9230:  0x0000977C,
	9231:  0x00009785,
	9232:  0x000097F6,
	9233:  0x00009817,
	9234:  0x00009818,
	9235:  0x000098AF,
	9236:  0x000098B1,
	9237:  0x00009903,
	9238:  0x00009905,
	9239:  0x0000990C,
	9240:  0x00009909,
	9241:  0x000099C1,
	9242:  0x00009AAF,
	9243:  0x00009AB0,
	9244:  0x00009AE6,
	9245:  0x00009B41,
	9246:  0x00009B42,
	9247:  0x00009CF4,
	9248:  0x00009CF6,
	9249:  0x00009CF3,
	9250:  0x00009EBC,
	9251:  0x00009F3B,
	9252:  0x00009F4A,
	9253:  0x00005104,
	9254:  0x00005100,
	9255:  0x000050FB,
	9256:  0x000050F5,
	9257:  0x000050F9,
	9258:  0x00005102,
	9259:  0x00005108,
	9260:  0x00005109,
	9261:  0x00005105,
	9262:  0x000051DC,
	9263:  0x00005287,
	9264:  0x00005288,
	9265:  0x00005289,
	9266:  0x0000528D,
	9267:  0x0000528A,
	9268:  0x000052F0,
	9269:  0x000053B2,
	9270:  0x0000562E,
	9271:  0x0000563B,
	9272:  0x00005639,
	9273:  0x00005632,
	9274:  0x0000563F,
	9275:  0x00005634,
	9276:  0x00005629,
	9277:  0x00005653,
	9278:  0x0000564E,
	9279:  0x00005657,
	9280:  0x00005674,
	9281:  0x00005636,
	9282:  0x0000562F,
	9283:  0x00005630,
	9284:  0x00005880,
	9285:  0x0000589F,
	9286:  0x0000589E,
	9287:  0x000058B3,
	9288:  0x0000589C,
	9289:  0x000058AE,
	9290:  0x000058A9,
	9291:  0x000058A6,
	9292:  0x0000596D,
	9293:  0x00005B09,
	9294:  0x00005AFB,
	9295:  0x00005B0B,
	9296:  0x00005AF5,
	9297:  0x00005B0C,
	9298:  0x00005B08,
	9299:  0x00005BEE,
	9300:  0x00005BEC,
	9301:  0x00005BE9,
	9302:  0x00005BEB,
	9303:  0x00005C64,
	9304:  0x00005C65,
	9305:  0x00005D9D,
	9306:  0x00005D94,
	9307:  0x00005E62,
	9308:  0x00005E5F,
	9309:  0x00005E61,
	9310:  0x00005EE2,
	9311:  0x00005EDA,
	9312:  0x00005EDF,
	9313:  0x00005EDD,
	9314:  0x00005EE3,
	9315:  0x00005EE0,
	9316:  0x00005F48,
	9317:  0x00005F71,
	9318:  0x00005FB7,
	9319:  0x00005FB5,
	9320:  0x00006176,
	9321:  0x00006167,
	9322:  0x0000616E,
	9323:  0x0000615D,
	9324:  0x00006155,
	9325:  0x00006182,
	9326:  0x0000617C,
	9327:  0x00006170,
	9328:  0x0000616B,
	9329:  0x0000617E,
	9330:  0x000061A7,
	9331:  0x00006190,
	9332:  0x000061AB,
	9333:  0x0000618E,
	9334:  0x000061AC,
	9335:  0x0000619A,
	9336:  0x000061A4,
	9337:  0x00006194,
	9338:  0x000061AE,
	9339:  0x0000622E,
	9340:  0x00006469,
	9341:  0x0000646F,
	9342:  0x00006479,
	9343:  0x0000649E,
	9344:  0x000064B2,
	9345:  0x00006488,
	9346:  0x00006490,
	9347:  0x000064B0,
	9348:  0x000064A5,
	9349:  0x00006493,
	9350:  0x00006495,
	9351:  0x000064A9,
	9352:  0x00006492,
	9353:  0x000064AE,
	9354:  0x000064AD,
	9355:  0x000064AB,
	9356:  0x0000649A,
	9357:  0x000064AC,
	9358:  0x00006499,
	9359:  0x000064A2,
	9360:  0x000064B3,
	9361:  0x00006575,
	9362:  0x00006577,
	9363:  0x00006578,
	9364:  0x000066AE,
	9365:  0x000066AB,
	9366:  0x000066B4,
	9367:  0x000066B1,
	9368:  0x00006A23,
	9369:  0x00006A1F,
	9370:  0x000069E8,
	9371:  0x00006A01,
	9372:  0x00006A1E,
	9373:  0x00006A19,
	9374:  0x000069FD,
	9375:  0x00006A21,
	9376:  0x00006A13,
	9377:  0x00006A0A,
	9378:  0x000069F3,
	9379:  0x00006A02,
	9380:  0x00006A05,
	9381:  0x000069ED,
	9382:  0x00006A11,
	9383:  0x00006B50,
	9384:  0x00006B4E,
	9385:  0x00006BA4,
	9386:  0x00006BC5,
	9387:  0x00006BC6,
	9388:  0x00006F3F,
	9389:  0x00006F7C,
	9390:  0x00006F84,
	9391:  0x00006F51,
	9392:  0x00006F66,
	9393:  0x00006F54,
	9394:  0x00006F86,
	9395:  0x00006F6D,
	9396:  0x00006F5B,
	9397:  0x00006F78,
	9398:  0x00006F6E,
	9399:  0x00006F8E,
	9400:  0x00006F7A,
	9401:  0x00006F70,
	9402:  0x00006F64,
	9403:  0x00006F97,
	9404:  0x00006F58,
	9405:  0x00006ED5,
	9406:  0x00006F6F,
	9407:  0x00006F60,
	9408:  0x00006F5F,
	9409:  0x0000719F,
	9410:  0x000071AC,
	9411:  0x000071B1,
	9412:  0x000071A8,
	9413:  0x00007256,
	9414:  0x0000729B,
	9415:  0x0000734E,
	9416:  0x00007357,
	9417:  0x00007469,
	9418:  0x0000748B,
	9419:  0x00007483,
	9420:  0x0000747E,
	9421:  0x00007480,
	9422:  0x0000757F,
	9423:  0x00007620,
	9424:  0x00007629,
	9425:  0x0000761F,
	9426:  0x00007624,
	9427:  0x00007626,
	9428:  0x00007621,
	9429:  0x00007622,
	9430:  0x0000769A,
	9431:  0x000076BA,
	9432:  0x000076E4,
	9433:  0x0000778E,
	9434:  0x00007787,
	9435:  0x0000778C,
	9436:  0x00007791,
	9437:  0x0000778B,
	9438:  0x000078CB,
	9439:  0x000078C5,
	9440:  0x000078BA,
	9441:  0x000078CA,
	9442:  0x000078BE,
	9443:  0x000078D5,
	9444:  0x000078BC,
	9445:  0x000078D0,
	9446:  0x00007A3F,
	9447:  0x00007A3C,
	9448:  0x00007A40,
	9449:  0x00007A3D,
	9450:  0x00007A37,
	9451:  0x00007A3B,
	9452:  0x00007AAF,
	9453:  0x00007AAE,
	9454:  0x00007BAD,
	9455:  0x00007BB1,
	9456:  0x00007BC4,
	9457:  0x00007BB4,
	9458:  0x00007BC6,
	9459:  0x00007BC7,
	9460:  0x00007BC1,
	9461:  0x00007BA0,
	9462:  0x00007BCC,
	9463:  0x00007CCA,
	9464:  0x00007DE0,
	9465:  0x00007DF4,
	9466:  0x00007DEF,
	9467:  0x00007DFB,
	9468:  0x00007DD8,
	9469:  0x00007DEC,
	9470:  0x00007DDD,
	9471:  0x00007DE8,
	9472:  0x00007DE3,
	9473:  0x00007DDA,
	9474:  0x00007DDE,
	9475:  0x00007DE9,
	9476:  0x00007D9E,
	9477:  0x00007DD9,
	9478:  0x00007DF2,
	9479:  0x00007DF9,
	9480:  0x00007F75,
	9481:  0x00007F77,
	9482:  0x00007FAF,
	9483:  0x00007FE9,
	9484:  0x00008026,
	9485:  0x0000819B,
	9486:  0x0000819C,
	9487:  0x0000819D,
	9488:  0x000081A0,
	9489:  0x0000819A,
	9490:  0x00008198,
	9491:  0x00008517,
	9492:  0x0000853D,
	9493:  0x0000851A,
	9494:  0x000084EE,
	9495:  0x0000852C,
	9496:  0x0000852D,
	9497:  0x00008513,
	9498:  0x00008511,
	9499:  0x00008523,
	9500:  0x00008521,
	9501:  0x00008514,
	9502:  0x000084EC,
	9503:  0x00008525,
	9504:  0x000084FF,
	9505:  0x00008506,
	9506:  0x00008782,
	9507:  0x00008774,
	9508:  0x00008776,
	9509:  0x00008760,
	9510:  0x00008766,
	9511:  0x00008778,
	9512:  0x00008768,
	9513:  0x00008759,
	9514:  0x00008757,
	9515:  0x0000874C,
	9516:  0x00008753,
	9517:  0x0000885B,
	9518:  0x0000885D,
	9519:  0x00008910,
	9520:  0x00008907,
	9521:  0x00008912,
	9522:  0x00008913,
	9523:  0x00008915,
	9524:  0x0000890A,
	9525:  0x00008ABC,
	9526:  0x00008AD2,
	9527:  0x00008AC7,
	9528:  0x00008AC4,
	9529:  0x00008A95,
	9530:  0x00008ACB,
	9531:  0x00008AF8,
	9532:  0x00008AB2,
	9533:  0x00008AC9,
	9534:  0x00008AC2,
	9535:  0x00008ABF,
	9536:  0x00008AB0,
	9537:  0x00008AD6,
	9538:  0x00008ACD,
	9539:  0x00008AB6,
	9540:  0x00008AB9,
	9541:  0x00008ADB,
	9542:  0x00008C4C,
	9543:  0x00008C4E,
	9544:  0x00008C6C,
	9545:  0x00008CE0,
	9546:  0x00008CDE,
	9547:  0x00008CE6,
	9548:  0x00008CE4,
	9549:  0x00008CEC,
	9550:  0x00008CED,
	9551:  0x00008CE2,
	9552:  0x00008CE3,
	9553:  0x00008CDC,
	9554:  0x00008CEA,
	9555:  0x00008CE1,
	9556:  0x00008D6D,
	9557:  0x00008D9F,
	9558:  0x00008DA3,
	9559:  0x00008E2B,
	9560:  0x00008E10,
	9561:  0x00008E1D,
	9562:  0x00008E22,
	9563:  0x00008E0F,
	9564:  0x00008E29,
	9565:  0x00008E1F,
	9566:  0x00008E21,
	9567:  0x00008E1E,
	9568:  0x00008EBA,
	9569:  0x00008F1D,
	9570:  0x00008F1B,
	9571:  0x00008F1F,
	9572:  0x00008F29,
	9573:  0x00008F26,
	9574:  0x00008F2A,
	9575:  0x00008F1C,
	9576:  0x00008F1E,
	9577:  0x00008F25,
	9578:  0x00009069,
	9579:  0x0000906E,
	9580:  0x00009068,
	9581:  0x0000906D,
	9582:  0x00009077,
	9583:  0x00009130,
	9584:  0x0000912D,
	9585:  0x00009127,
	9586:  0x00009131,
	9587:  0x00009187,
	9588:  0x00009189,
	9589:  0x0000918B,
	9590:  0x00009183,
	9591:  0x000092C5,
	9592:  0x000092BB,
	9593:  0x000092B7,
	9594:  0x000092EA,
	9595:  0x000092AC,
	9596:  0x000092E4,
	9597:  0x000092C1,
	9598:  0x000092B3,
	9599:  0x000092BC,
	9600:  0x000092D2,
	9601:  0x000092C7,
	9602:  0x000092F0,
	9603:  0x000092B2,
	9604:  0x000095AD,
	9605:  0x000095B1,
	9606:  0x00009704,
	9607:  0x00009706,
	9608:  0x00009707,
	9609:  0x00009709,
	9610:  0x00009760,
	9611:  0x0000978D,
	9612:  0x0000978B,
	9613:  0x0000978F,
	9614:  0x00009821,
	9615:  0x0000982B,
	9616:  0x0000981C,
	9617:  0x000098B3,
	9618:  0x0000990A,
	9619:  0x00009913,
	9620:  0x00009912,
	9621:  0x00009918,
	9622:  0x000099DD,
	9623:  0x000099D0,
	9624:  0x000099DF,
	9625:  0x000099DB,
	9626:  0x000099D1,
	9627:  0x000099D5,
	9628:  0x000099D2,
	9629:  0x000099D9,
	9630:  0x00009AB7,
	9631:  0x00009AEE,
	9632:  0x00009AEF,
	9633:  0x00009B27,
	9634:  0x00009B45,
	9635:  0x00009B44,
	9636:  0x00009B77,
	9637:  0x00009B6F,
	9638:  0x00009D06,
	9639:  0x00009D09,
	9640:  0x00009D03,
	9641:  0x00009EA9,
	9642:  0x00009EBE,
	9643:  0x00009ECE,
	9644:  0x000058A8,
	9645:  0x00009F52,
	9646:  0x00005112,
	9647:  0x00005118,
	9648:  0x00005114,
	9649:  0x00005110,
	9650:  0x00005115,
	9651:  0x00005180,
	9652:  0x000051AA,
	9653:  0x000051DD,
	9654:  0x00005291,
	9655:  0x00005293,
	9656:  0x000052F3,
	9657:  0x00005659,
	9658:  0x0000566B,
	9659:  0x00005679,
	9660:  0x00005669,
	9661:  0x00005664,
	9662:  0x00005678,
	9663:  0x0000566A,
	9664:  0x00005668,
	9665:  0x00005665,
	9666:  0x00005671,
	9667:  0x0000566F,
	9668:  0x0000566C,
	9669:  0x00005662,
	9670:  0x00005676,
	9671:  0x000058C1,
	9672:  0x000058BE,
	9673:  0x000058C7,
	9674:  0x000058C5,
	9675:  0x0000596E,
	9676:  0x00005B1D,
	9677:  0x00005B34,
	9678:  0x00005B78,
	9679:  0x00005BF0,
	9680:  0x00005C0E,
	9681:  0x00005F4A,
	9682:  0x000061B2,
	9683:  0x00006191,
	9684:  0x000061A9,
	9685:  0x0000618A,
	9686:  0x000061CD,
	9687:  0x000061B6,
	9688:  0x000061BE,
	9689:  0x000061CA,
	9690:  0x000061C8,
	9691:  0x00006230,
	9692:  0x000064C5,
	9693:  0x000064C1,
	9694:  0x000064CB,
	9695:  0x000064BB,
	9696:  0x000064BC,
	9697:  0x000064DA,
	9698:  0x000064C4,
	9699:  0x000064C7,
	9700:  0x000064C2,
	9701:  0x000064CD,
	9702:  0x000064BF,
	9703:  0x000064D2,
	9704:  0x000064D4,
	9705:  0x000064BE,
	9706:  0x00006574,
	9707:  0x000066C6,
	9708:  0x000066C9,
	9709:  0x000066B9,
	9710:  0x000066C4,
	9711:  0x000066C7,
	9712:  0x000066B8,
	9713:  0x00006A3D,
	9714:  0x00006A38,
	9715:  0x00006A3A,
	9716:  0x00006A59,
	9717:  0x00006A6B,
	9718:  0x00006A58,
	9719:  0x00006A39,
	9720:  0x00006A44,
	9721:  0x00006A62,
	9722:  0x00006A61,
	9723:  0x00006A4B,
	9724:  0x00006A47,
	9725:  0x00006A35,
	9726:  0x00006A5F,
	9727:  0x00006A48,
	9728:  0x00006B59,
	9729:  0x00006B77,
	9730:  0x00006C05,
	9731:  0x00006FC2,
	9732:  0x00006FB1,
	9733:  0x00006FA1,
	9734:  0x00006FC3,
	9735:  0x00006FA4,
	9736:  0x00006FC1,
	9737:  0x00006FA7,
	9738:  0x00006FB3,
	9739:  0x00006FC0,
	9740:  0x00006FB9,
	9741:  0x00006FB6,
	9742:  0x00006FA6,
	9743:  0x00006FA0,
	9744:  0x00006FB4,
	9745:  0x000071BE,
	9746:  0x000071C9,
	9747:  0x000071D0,
	9748:  0x000071D2,
	9749:  0x000071C8,
	9750:  0x000071D5,
	9751:  0x000071B9,
	9752:  0x000071CE,
	9753:  0x000071D9,
	9754:  0x000071DC,
	9755:  0x000071C3,
	9756:  0x000071C4,
	9757:  0x00007368,
	9758:  0x0000749C,
	9759:  0x000074A3,
	9760:  0x00007498,
	9761:  0x0000749F,
	9762:  0x0000749E,
	9763:  0x000074E2,
	9764:  0x0000750C,
	9765:  0x0000750D,
	9766:  0x00007634,
	9767:  0x00007638,
	9768:  0x0000763A,
	9769:  0x000076E7,
	9770:  0x000076E5,
	9771:  0x000077A0,
	9772:  0x0000779E,
	9773:  0x0000779F,
	9774:  0x000077A5,
	9775:  0x000078E8,
	9776:  0x000078DA,
	9777:  0x000078EC,
	9778:  0x000078E7,
	9779:  0x000079A6,
	9780:  0x00007A4D,
	9781:  0x00007A4E,
	9782:  0x00007A46,
	9783:  0x00007A4C,
	9784:  0x00007A4B,
	9785:  0x00007ABA,
	9786:  0x00007BD9,
	9787:  0x00007C11,
	9788:  0x00007BC9,
	9789:  0x00007BE4,
	9790:  0x00007BDB,
	9791:  0x00007BE1,
	9792:  0x00007BE9,
	9793:  0x00007BE6,
	9794:  0x00007CD5,
	9795:  0x00007CD6,
	9796:  0x00007E0A,
	9797:  0x00007E11,
	9798:  0x00007E08,
	9799:  0x00007E1B,
	9800:  0x00007E23,
	9801:  0x00007E1E,
	9802:  0x00007E1D,
	9803:  0x00007E09,
	9804:  0x00007E10,
	9805:  0x00007F79,
	9806:  0x00007FB2,
	9807:  0x00007FF0,
	9808:  0x00007FF1,
	9809:  0x00007FEE,
	9810:  0x00008028,
	9811:  0x000081B3,
	9812:  0x000081A9,
	9813:  0x000081A8,
	9814:  0x000081FB,
	9815:  0x00008208,
	9816:  0x00008258,
	9817:  0x00008259,
	9818:  0x0000854A,
	9819:  0x00008559,
	9820:  0x00008548,
	9821:  0x00008568,
	9822:  0x00008569,
	9823:  0x00008543,
	9824:  0x00008549,
	9825:  0x0000856D,
	9826:  0x0000856A,
	9827:  0x0000855E,
	9828:  0x00008783,
	9829:  0x0000879F,
	9830:  0x0000879E,
	9831:  0x000087A2,
	9832:  0x0000878D,
	9833:  0x00008861,
	9834:  0x0000892A,
	9835:  0x00008932,
	9836:  0x00008925,
	9837:  0x0000892B,
	9838:  0x00008921,
	9839:  0x000089AA,
	9840:  0x000089A6,
	9841:  0x00008AE6,
	9842:  0x00008AFA,
	9843:  0x00008AEB,
	9844:  0x00008AF1,
	9845:  0x00008B00,
	9846:  0x00008ADC,
	9847:  0x00008AE7,
	9848:  0x00008AEE,
	9849:  0x00008AFE,
	9850:  0x00008B01,
	9851:  0x00008B02,
	9852:  0x00008AF7,
	9853:  0x00008AED,
	9854:  0x00008AF3,
	9855:  0x00008AF6,
	9856:  0x00008AFC,
	9857:  0x00008C6B,
	9858:  0x00008C6D,
	9859:  0x00008C93,
	9860:  0x00008CF4,
	9861:  0x00008E44,
	9862:  0x00008E31,
	9863:  0x00008E34,
	9864:  0x00008E42,
	9865:  0x00008E39,
	9866:  0x00008E35,
	9867:  0x00008F3B,
	9868:  0x00008F2F,
	9869:  0x00008F38,
	9870:  0x00008F33,
	9871:  0x00008FA8,
	9872:  0x00008FA6,
	9873:  0x00009075,
	9874:  0x00009074,
	9875:  0x00009078,
	9876:  0x00009072,
	9877:  0x0000907C,
	9878:  0x0000907A,
	9879:  0x00009134,
	9880:  0x00009192,
	9881:  0x00009320,
	9882:  0x00009336,
	9883:  0x000092F8,
	9884:  0x00009333,
	9885:  0x0000932F,
	9886:  0x00009322,
	9887:  0x000092FC,
	9888:  0x0000932B,
	9889:  0x00009304,
	9890:  0x0000931A,
	9891:  0x00009310,
	9892:  0x00009326,
	9893:  0x00009321,
	9894:  0x00009315,
	9895:  0x0000932E,
	9896:  0x00009319,
	9897:  0x000095BB,
	9898:  0x000096A7,
	9899:  0x000096A8,
	9900:  0x000096AA,
	9901:  0x000096D5,
	9902:  0x0000970E,
	9903:  0x00009711,
	9904:  0x00009716,
	9905:  0x0000970D,
	9906:  0x00009713,
	9907:  0x0000970F,
	9908:  0x0000975B,
	9909:  0x0000975C,
	9910:  0x00009766,
	9911:  0x00009798,
	9912:  0x00009830,
	9913:  0x00009838,
	9914:  0x0000983B,
	9915:  0x00009837,
	9916:  0x0000982D,
	9917:  0x00009839,
	9918:  0x00009824,
	9919:  0x00009910,
	9920:  0x00009928,
	9921:  0x0000991E,
	9922:  0x0000991B,
	9923:  0x00009921,
	9924:  0x0000991A,
	9925:  0x000099ED,
	9926:  0x000099E2,
	9927:  0x000099F1,
	9928:  0x00009AB8,
	9929:  0x00009ABC,
	9930:  0x00009AFB,
	9931:  0x00009AED,
	9932:  0x00009B28,
	9933:  0x00009B91,
	9934:  0x00009D15,
	9935:  0x00009D23,
	9936:  0x00009D26,
	9937:  0x00009D28,
	9938:  0x00009D12,
	9939:  0x00009D1B,
	9940:  0x00009ED8,
	9941:  0x00009ED4,
	9942:  0x00009F8D,
	9943:  0x00009F9C,
	9944:  0x0000512A,
	9945:  0x0000511F,
	9946:  0x00005121,
	9947:  0x00005132,
	9948:  0x000052F5,
	9949:  0x0000568E,
	9950:  0x00005680,
	9951:  0x00005690,
	9952:  0x00005685,
	9953:  0x00005687,
	9954:  0x0000568F,
	9955:  0x000058D5,
	9956:  0x000058D3,
	9957:  0x000058D1,
	9958:  0x000058CE,
	9959:  0x00005B30,
	9960:  0x00005B2A,
	9961:  0x00005B24,
	9962:  0x00005B7A,
	9963:  0x00005C37,
	9964:  0x00005C68,
	9965:  0x00005DBC,
	9966:  0x00005DBA,
	9967:  0x00005DBD,
	9968:  0x00005DB8,
	9969:  0x00005E6B,
	9970:  0x00005F4C,
	9971:  0x00005FBD,
	9972:  0x000061C9,
	9973:  0x000061C2,
	9974:  0x000061C7,
	9975:  0x000061E6,
	9976:  0x000061CB,
	9977:  0x00006232,
	9978:  0x00006234,
	9979:  0x000064CE,
	9980:  0x000064CA,
	9981:  0x000064D8,
	9982:  0x000064E0,
	9983:  0x000064F0,
	9984:  0x000064E6,
	9985:  0x000064EC,
	9986:  0x000064F1,
	9987:  0x000064E2,
	9988:  0x000064ED,
	9989:  0x00006582,
	9990:  0x00006583,
	9991:  0x000066D9,
	9992:  0x000066D6,
	9993:  0x00006A80,
	9994:  0x00006A94,
	9995:  0x00006A84,
	9996:  0x00006AA2,
	9997:  0x00006A9C,
	9998:  0x00006ADB,
	9999:  0x00006AA3,
	10000: 0x00006A7E,
	10001: 0x00006A97,
	10002: 0x00006A90,
	10003: 0x00006AA0,
	10004: 0x00006B5C,
	10005: 0x00006BAE,
	10006: 0x00006BDA,
	10007: 0x00006C08,
	10008: 0x00006FD8,
	10009: 0x00006FF1,
	10010: 0x00006FDF,
	10011: 0x00006FE0,
	10012: 0x00006FDB,
	10013: 0x00006FE4,
	10014: 0x00006FEB,
	10015: 0x00006FEF,
	10016: 0x00006F80,
	10017: 0x00006FEC,
	10018: 0x00006FE1,
	10019: 0x00006FE9,
	10020: 0x00006FD5,
	10021: 0x00006FEE,
	10022: 0x00006FF0,
	10023: 0x000071E7,
	10024: 0x000071DF,
	10025: 0x000071EE,
	10026: 0x000071E6,
	10027: 0x000071E5,
	10028: 0x000071ED,
	10029: 0x000071EC,
	10030: 0x000071F4,
	10031: 0x000071E0,
	10032: 0x00007235,
	10033: 0x00007246,
	10034: 0x00007370,
	10035: 0x00007372,
	10036: 0x000074A9,
	10037: 0x000074B0,
	10038: 0x000074A6,
	10039: 0x000074A8,
	10040: 0x00007646,
	10041: 0x00007642,
	10042: 0x0000764C,
	10043: 0x000076EA,
	10044: 0x000077B3,
	10045: 0x000077AA,
	10046: 0x000077B0,
	10047: 0x000077AC,
	10048: 0x000077A7,
	10049: 0x000077AD,
	10050: 0x000077EF,
	10051: 0x000078F7,
	10052: 0x000078FA,
	10053: 0x000078F4,
	10054: 0x000078EF,
	10055: 0x00007901,
	10056: 0x000079A7,
	10057: 0x000079AA,
	10058: 0x00007A57,
	10059: 0x00007ABF,
	10060: 0x00007C07,
	10061: 0x00007C0D,
	10062: 0x00007BFE,
	10063: 0x00007BF7,
	10064: 0x00007C0C,
	10065: 0x00007BE0,
	10066: 0x00007CE0,
	10067: 0x00007CDC,
	10068: 0x00007CDE,
	10069: 0x00007CE2,
	10070: 0x00007CDF,
	10071: 0x00007CD9,
	10072: 0x00007CDD,
	10073: 0x00007E2E,
	10074: 0x00007E3E,
	10075: 0x00007E46,
	10076: 0x00007E37,
	10077: 0x00007E32,
	10078: 0x00007E43,
	10079: 0x00007E2B,
	10080: 0x00007E3D,
	10081: 0x00007E31,
	10082: 0x00007E45,
	10083: 0x00007E41,
	10084: 0x00007E34,
	10085: 0x00007E39,
	10086: 0x00007E48,
	10087: 0x00007E35,
	10088: 0x00007E3F,
	10089: 0x00007E2F,
	10090: 0x00007F44,
	10091: 0x00007FF3,
	10092: 0x00007FFC,
	10093: 0x00008071,
	10094: 0x00008072,
	10095: 0x00008070,
	10096: 0x0000806F,
	10097: 0x00008073,
	10098: 0x000081C6,
	10099: 0x000081C3,
	10100: 0x000081BA,
	10101: 0x000081C2,
	10102: 0x000081C0,
	10103: 0x000081BF,
	10104: 0x000081BD,
	10105: 0x000081C9,
	10106: 0x000081BE,
	10107: 0x000081E8,
	10108: 0x00008209,
	10109: 0x00008271,
	10110: 0x000085AA,
	10111: 0x00008584,
	10112: 0x0000857E,
	10113: 0x0000859C,
	10114: 0x00008591,
	10115: 0x00008594,
	10116: 0x000085AF,
	10117: 0x0000859B,
	10118: 0x00008587,
	10119: 0x000085A8,
	10120: 0x0000858A,
	10121: 0x00008667,
	10122: 0x000087C0,
	10123: 0x000087D1,
	10124: 0x000087B3,
	10125: 0x000087D2,
	10126: 0x000087C6,
	10127: 0x000087AB,
	10128: 0x000087BB,
	10129: 0x000087BA,
	10130: 0x000087C8,
	10131: 0x000087CB,
	10132: 0x0000893B,
	10133: 0x00008936,
	10134: 0x00008944,
	10135: 0x00008938,
	10136: 0x0000893D,
	10137: 0x000089AC,
	10138: 0x00008B0E,
	10139: 0x00008B17,
	10140: 0x00008B19,
	10141: 0x00008B1B,
	10142: 0x00008B0A,
	10143: 0x00008B20,
	10144: 0x00008B1D,
	10145: 0x00008B04,
	10146: 0x00008B10,
	10147: 0x00008C41,
	10148: 0x00008C3F,
	10149: 0x00008C73,
	10150: 0x00008CFA,
	10151: 0x00008CFD,
	10152: 0x00008CFC,
	10153: 0x00008CF8,
	10154: 0x00008CFB,
	10155: 0x00008DA8,
	10156: 0x00008E49,
	10157: 0x00008E4B,
	10158: 0x00008E48,
	10159: 0x00008E4A,
	10160: 0x00008F44,
	10161: 0x00008F3E,
	10162: 0x00008F42,
	10163: 0x00008F45,
	10164: 0x00008F3F,
	10165: 0x0000907F,
	10166: 0x0000907D,
	10167: 0x00009084,
	10168: 0x00009081,
	10169: 0x00009082,
	10170: 0x00009080,
	10171: 0x00009139,
	10172: 0x000091A3,
	10173: 0x0000919E,
	10174: 0x0000919C,
	10175: 0x0000934D,
	10176: 0x00009382,
	10177: 0x00009328,
	10178: 0x00009375,
	10179: 0x0000934A,
	10180: 0x00009365,
	10181: 0x0000934B,
	10182: 0x00009318,
	10183: 0x0000937E,
	10184: 0x0000936C,
	10185: 0x0000935B,
	10186: 0x00009370,
	10187: 0x0000935A,
	10188: 0x00009354,
	10189: 0x000095CA,
	10190: 0x000095CB,
	10191: 0x000095CC,
	10192: 0x000095C8,
	10193: 0x000095C6,
	10194: 0x000096B1,
	10195: 0x000096B8,
	10196: 0x000096D6,
	10197: 0x0000971C,
	10198: 0x0000971E,
	10199: 0x000097A0,
	10200: 0x000097D3,
	10201: 0x00009846,
	10202: 0x000098B6,
	10203: 0x00009935,
	10204: 0x00009A01,
	10205: 0x000099FF,
	10206: 0x00009BAE,
	10207: 0x00009BAB,
	10208: 0x00009BAA,
	10209: 0x00009BAD,
	10210: 0x00009D3B,
	10211: 0x00009D3F,
	10212: 0x00009E8B,
	10213: 0x00009ECF,
	10214: 0x00009EDE,
	10215: 0x00009EDC,
	10216: 0x00009EDD,
	10217: 0x00009EDB,
	10218: 0x00009F3E,
	10219: 0x00009F4B,
	10220: 0x000053E2,
	10221: 0x00005695,
	10222: 0x000056AE,
	10223: 0x000058D9,
	10224: 0x000058D8,
	10225: 0x00005B38,
	10226: 0x00005F5D,
	10227: 0x000061E3,
	10228: 0x00006233,
	10229: 0x000064F4,
	10230: 0x000064F2,
	10231: 0x000064FE,
	10232: 0x00006506,
	10233: 0x000064FA,
	10234: 0x000064FB,
	10235: 0x000064F7,
	10236: 0x000065B7,
	10237: 0x000066DC,
	10238: 0x00006726,
	10239: 0x00006AB3,
	10240: 0x00006AAC,
	10241: 0x00006AC3,
	10242: 0x00006ABB,
	10243: 0x00006AB8,
	10244: 0x00006AC2,
	10245: 0x00006AAE,
	10246: 0x00006AAF,
	10247: 0x00006B5F,
	10248: 0x00006B78,
	10249: 0x00006BAF,
	10250: 0x00007009,
	10251: 0x0000700B,
	10252: 0x00006FFE,
	10253: 0x00007006,
	10254: 0x00006FFA,
	10255: 0x00007011,
	10256: 0x0000700F,
	10257: 0x000071FB,
	10258: 0x000071FC,
	10259: 0x000071FE,
	10260: 0x000071F8,
	10261: 0x00007377,
	10262: 0x00007375,
	10263: 0x000074A7,
	10264: 0x000074BF,
	10265: 0x00007515,
	10266: 0x00007656,
	10267: 0x00007658,
	10268: 0x00007652,
	10269: 0x000077BD,
	10270: 0x000077BF,
	10271: 0x000077BB,
	10272: 0x000077BC,
	10273: 0x0000790E,
	10274: 0x000079AE,
	10275: 0x00007A61,
	10276: 0x00007A62,
	10277: 0x00007A60,
	10278: 0x00007AC4,
	10279: 0x00007AC5,
	10280: 0x00007C2B,
	10281: 0x00007C27,
	10282: 0x00007C2A,
	10283: 0x00007C1E,
	10284: 0x00007C23,
	10285: 0x00007C21,
	10286: 0x00007CE7,
	10287: 0x00007E54,
	10288: 0x00007E55,
	10289: 0x00007E5E,
	10290: 0x00007E5A,
	10291: 0x00007E61,
	10292: 0x00007E52,
	10293: 0x00007E59,
	10294: 0x00007F48,
	10295: 0x00007FF9,
	10296: 0x00007FFB,
	10297: 0x00008077,
	10298: 0x00008076,
	10299: 0x000081CD,
	10300: 0x000081CF,
	10301: 0x0000820A,
	10302: 0x000085CF,
	10303: 0x000085A9,
	10304: 0x000085CD,
	10305: 0x000085D0,
	10306: 0x000085C9,
	10307: 0x000085B0,
	10308: 0x000085BA,
	10309: 0x000085B9,
	10310: 0x000085A6,
	10311: 0x000087EF,
	10312: 0x000087EC,
	10313: 0x000087F2,
	10314: 0x000087E0,
	10315: 0x00008986,
	10316: 0x000089B2,
	10317: 0x000089F4,
	10318: 0x00008B28,
	10319: 0x00008B39,
	10320: 0x00008B2C,
	10321: 0x00008B2B,
	10322: 0x00008C50,
	10323: 0x00008D05,
	10324: 0x00008E59,
	10325: 0x00008E63,
	10326: 0x00008E66,
	10327: 0x00008E64,
	10328: 0x00008E5F,
	10329: 0x00008E55,
	10330: 0x00008EC0,
	10331: 0x00008F49,
	10332: 0x00008F4D,
	10333: 0x00009087,
	10334: 0x00009083,
	10335: 0x00009088,
	10336: 0x000091AB,
	10337: 0x000091AC,
	10338: 0x000091D0,
	10339: 0x00009394,
	10340: 0x0000938A,
	10341: 0x00009396,
	10342: 0x000093A2,
	10343: 0x000093B3,
	10344: 0x000093AE,
	10345: 0x000093AC,
	10346: 0x000093B0,
	10347: 0x00009398,
	10348: 0x0000939A,
	10349: 0x00009397,
	10350: 0x000095D4,
	10351: 0x000095D6,
	10352: 0x000095D0,
	10353: 0x000095D5,
	10354: 0x000096E2,
	10355: 0x000096DC,
	10356: 0x000096D9,
	10357: 0x000096DB,
	10358: 0x000096DE,
	10359: 0x00009724,
	10360: 0x000097A3,
	10361: 0x000097A6,
	10362: 0x000097AD,
	10363: 0x000097F9,
	10364: 0x0000984D,
	10365: 0x0000984F,
	10366: 0x0000984C,
	10367: 0x0000984E,
	10368: 0x00009853,
	10369: 0x000098BA,
	10370: 0x0000993E,
	10371: 0x0000993F,
	10372: 0x0000993D,
	10373: 0x0000992E,
	10374: 0x000099A5,
	10375: 0x00009A0E,
	10376: 0x00009AC1,
	10377: 0x00009B03,
	10378: 0x00009B06,
	10379: 0x00009B4F,
	10380: 0x00009B4E,
	10381: 0x00009B4D,
	10382: 0x00009BCA,
	10383: 0x00009BC9,
	10384: 0x00009BFD,
	10385: 0x00009BC8,
	10386: 0x00009BC0,
	10387: 0x00009D51,
	10388: 0x00009D5D,
	10389: 0x00009D60,
	10390: 0x00009EE0,
	10391: 0x00009F15,
	10392: 0x00009F2C,
	10393: 0x00005133,
	10394: 0x000056A5,
	10395: 0x000058DE,
	10396: 0x000058DF,
	10397: 0x000058E2,
	10398: 0x00005BF5,
	10399: 0x00009F90,
	10400: 0x00005EEC,
	10401: 0x000061F2,
	10402: 0x000061F7,
	10403: 0x000061F6,
	10404: 0x000061F5,
	10405: 0x00006500,
	10406: 0x0000650F,
	10407: 0x000066E0,
	10408: 0x000066DD,
	10409: 0x00006AE5,
	10410: 0x00006ADD,
	10411: 0x00006ADA,
	10412: 0x00006AD3,
	10413: 0x0000701B,
	10414: 0x0000701F,
	10415: 0x00007028,
	10416: 0x0000701A,
	10417: 0x0000701D,
	10418: 0x00007015,
	10419: 0x00007018,
	10420: 0x00007206,
	10421: 0x0000720D,
	10422: 0x00007258,
	10423: 0x000072A2,
	10424: 0x00007378,
	10425: 0x0000737A,
	10426: 0x000074BD,
	10427: 0x000074CA,
	10428: 0x000074E3,
	10429: 0x00007587,
	10430: 0x00007586,
	10431: 0x0000765F,
	10432: 0x00007661,
	10433: 0x000077C7,
	10434: 0x00007919,
	10435: 0x000079B1,
	10436: 0x00007A6B,
	10437: 0x00007A69,
	10438: 0x00007C3E,
	10439: 0x00007C3F,
	10440: 0x00007C38,
	10441: 0x00007C3D,
	10442: 0x00007C37,
	10443: 0x00007C40,
	10444: 0x00007E6B,
	10445: 0x00007E6D,
	10446: 0x00007E79,
	10447: 0x00007E69,
	10448: 0x00007E6A,
	10449: 0x00007F85,
	10450: 0x00007E73,
	10451: 0x00007FB6,
	10452: 0x00007FB9,
	10453: 0x00007FB8,
	10454: 0x000081D8,
	10455: 0x000085E9,
	10456: 0x000085DD,
	10457: 0x000085EA,
	10458: 0x000085D5,
	10459: 0x000085E4,
	10460: 0x000085E5,
	10461: 0x000085F7,
	10462: 0x000087FB,
	10463: 0x00008805,
	10464: 0x0000880D,
	10465: 0x000087F9,
	10466: 0x000087FE,
	10467: 0x00008960,
	10468: 0x0000895F,
	10469: 0x00008956,
	10470: 0x0000895E,
	10471: 0x00008B41,
	10472: 0x00008B5C,
	10473: 0x00008B58,
	10474: 0x00008B49,
	10475: 0x00008B5A,
	10476: 0x00008B4E,
	10477: 0x00008B4F,
	10478: 0x00008B46,
	10479: 0x00008B59,
	10480: 0x00008D08,
	10481: 0x00008D0A,
	10482: 0x00008E7C,
	10483: 0x00008E72,
	10484: 0x00008E87,
	10485: 0x00008E76,
	10486: 0x00008E6C,
	10487: 0x00008E7A,
	10488: 0x00008E74,
	10489: 0x00008F54,
	10490: 0x00008F4E,
	10491: 0x00008FAD,
	10492: 0x0000908A,
	10493: 0x0000908B,
	10494: 0x000091B1,
	10495: 0x000091AE,
	10496: 0x000093E1,
	10497: 0x000093D1,
	10498: 0x000093DF,
	10499: 0x000093C3,
	10500: 0x000093C8,
	10501: 0x000093DC,
	10502: 0x000093DD,
	10503: 0x000093D6,
	10504: 0x000093E2,
	10505: 0x000093CD,
	10506: 0x000093D8,
	10507: 0x000093E4,
	10508: 0x000093D7,
	10509: 0x000093E8,
	10510: 0x000095DC,
	10511: 0x000096B4,
	10512: 0x000096E3,
	10513: 0x0000972A,
	10514: 0x00009727,
	10515: 0x00009761,
	10516: 0x000097DC,
	10517: 0x000097FB,
	10518: 0x0000985E,
	10519: 0x00009858,
	10520: 0x0000985B,
	10521: 0x000098BC,
	10522: 0x00009945,
	10523: 0x00009949,
	10524: 0x00009A16,
	10525: 0x00009A19,
	10526: 0x00009B0D,
	10527: 0x00009BE8,
	10528: 0x00009BE7,
	10529: 0x00009BD6,
	10530: 0x00009BDB,
	10531: 0x00009D89,
	10532: 0x00009D61,
	10533: 0x00009D72,
	10534: 0x00009D6A,
	10535: 0x00009D6C,
	10536: 0x00009E92,
	10537: 0x00009E97,
	10538: 0x00009E93,
	10539: 0x00009EB4,
	10540: 0x000052F8,
	10541: 0x000056A8,
	10542: 0x000056B7,
	10543: 0x000056B6,
	10544: 0x000056B4,
	10545: 0x000056BC,
	10546: 0x000058E4,
	10547: 0x00005B40,
	10548: 0x00005B43,
	10549: 0x00005B7D,
	10550: 0x00005BF6,
	10551: 0x00005DC9,
	10552: 0x000061F8,
	10553: 0x000061FA,
	10554: 0x00006518,
	10555: 0x00006514,
	10556: 0x00006519,
	10557: 0x000066E6,
	10558: 0x00006727,
	10559: 0x00006AEC,
	10560: 0x0000703E,
	10561: 0x00007030,
	10562: 0x00007032,
	10563: 0x00007210,
	10564: 0x0000737B,
	10565: 0x000074CF,
	10566: 0x00007662,
	10567: 0x00007665,
	10568: 0x00007926,
	10569: 0x0000792A,
	10570: 0x0000792C,
	10571: 0x0000792B,
	10572: 0x00007AC7,
	10573: 0x00007AF6,
	10574: 0x00007C4C,
	10575: 0x00007C43,
	10576: 0x00007C4D,
	10577: 0x00007CEF,
	10578: 0x00007CF0,
	10579: 0x00008FAE,
	10580: 0x00007E7D,
	10581: 0x00007E7C,
	10582: 0x00007E82,
	10583: 0x00007F4C,
	10584: 0x00008000,
	10585: 0x000081DA,
	10586: 0x00008266,
	10587: 0x000085FB,
	10588: 0x000085F9,
	10589: 0x00008611,
	10590: 0x000085FA,
	10591: 0x00008606,
	10592: 0x0000860B,
	10593: 0x00008607,
	10594: 0x0000860A,
	10595: 0x00008814,
	10596: 0x00008815,
	10597: 0x00008964,
	10598: 0x000089BA,
	10599: 0x000089F8,
	10600: 0x00008B70,
	10601: 0x00008B6C,
	10602: 0x00008B66,
	10603: 0x00008B6F,
	10604: 0x00008B5F,
	10605: 0x00008B6B,
	10606: 0x00008D0F,
	10607: 0x00008D0D,
	10608: 0x00008E89,
	10609: 0x00008E81,
	10610: 0x00008E85,
	10611: 0x00008E82,
	10612: 0x000091B4,
	10613: 0x000091CB,
	10614: 0x00009418,
	10615: 0x00009403,
	10616: 0x000093FD,
	10617: 0x000095E1,
	10618: 0x00009730,
	10619: 0x000098C4,
	10620: 0x00009952,
	10621: 0x00009951,
	10622: 0x000099A8,
	10623: 0x00009A2B,
	10624: 0x00009A30,
	10625: 0x00009A37,
	10626: 0x00009A35,
	10627: 0x00009C13,
	10628: 0x00009C0D,
	10629: 0x00009E79,
	10630: 0x00009EB5,
	10631: 0x00009EE8,
	10632: 0x00009F2F,
	10633: 0x00009F5F,
	10634: 0x00009F63,
	10635: 0x00009F61,
	10636: 0x00005137,
	10637: 0x00005138,
	10638: 0x000056C1,
	10639: 0x000056C0,
	10640: 0x000056C2,
	10641: 0x00005914,
	10642: 0x00005C6C,
	10643: 0x00005DCD,
	10644: 0x000061FC,
	10645: 0x000061FE,
	10646: 0x0000651D,
	10647: 0x0000651C,
	10648: 0x00006595,
	10649: 0x000066E9,
	10650: 0x00006AFB,
	10651: 0x00006B04,
	10652: 0x00006AFA,
	10653: 0x00006BB2,
	10654: 0x0000704C,
	10655: 0x0000721B,
	10656: 0x000072A7,
	10657: 0x000074D6,
	10658: 0x000074D4,
	10659: 0x00007669,
	10660: 0x000077D3,
	10661: 0x00007C50,
	10662: 0x00007E8F,
	10663: 0x00007E8C,
	10664: 0x00007FBC,
	10665: 0x00008617,
	10666: 0x0000862D,
	10667: 0x0000861A,
	10668: 0x00008823,
	10669: 0x00008822,
	10670: 0x00008821,
	10671: 0x0000881F,
	10672: 0x0000896A,
	10673: 0x0000896C,
	10674: 0x000089BD,
	10675: 0x00008B74,
	10676: 0x00008B77,
	10677: 0x00008B7D,
	10678: 0x00008D13,
	10679: 0x00008E8A,
	10680: 0x00008E8D,
	10681: 0x00008E8B,
	10682: 0x00008F5F,
	10683: 0x00008FAF,
	10684: 0x000091BA,
	10685: 0x0000942E,
	10686: 0x00009433,
	10687: 0x00009435,
	10688: 0x0000943A,
	10689: 0x00009438,
	10690: 0x00009432,
	10691: 0x0000942B,
	10692: 0x000095E2,
	10693: 0x00009738,
	10694: 0x00009739,
	10695: 0x00009732,
	10696: 0x000097FF,
	10697: 0x00009867,
	10698: 0x00009865,
	10699: 0x00009957,
	10700: 0x00009A45,
	10701: 0x00009A43,
	10702: 0x00009A40,
	10703: 0x00009A3E,
	10704: 0x00009ACF,
	10705: 0x00009B54,
	10706: 0x00009B51,
	10707: 0x00009C2D,
	10708: 0x00009C25,
	10709: 0x00009DAF,
	10710: 0x00009DB4,
	10711: 0x00009DC2,
	10712: 0x00009DB8,
	10713: 0x00009E9D,
	10714: 0x00009EEF,
	10715: 0x00009F19,
	10716: 0x00009F5C,
	10717: 0x00009F66,
	10718: 0x00009F67,
	10719: 0x0000513C,
	10720: 0x0000513B,
	10721: 0x000056C8,
	10722: 0x000056CA,
	10723: 0x000056C9,
	10724: 0x00005B7F,
	10725: 0x00005DD4,
	10726: 0x00005DD2,
	10727: 0x00005F4E,
	10728: 0x000061FF,
	10729: 0x00006524,
	10730: 0x00006B0A,
	10731: 0x00006B61,
	10732: 0x00007051,
	10733: 0x00007058,
	10734: 0x00007380,
	10735: 0x000074E4,
	10736: 0x0000758A,
	10737: 0x0000766E,
	10738: 0x0000766C,
	10739: 0x000079B3,
	10740: 0x00007C60,
	10741: 0x00007C5F,
	10742: 0x0000807E,
	10743: 0x0000807D,
	10744: 0x000081DF,
	10745: 0x00008972,
	10746: 0x0000896F,
	10747: 0x000089FC,
	10748: 0x00008B80,
	10749: 0x00008D16,
	10750: 0x00008D17,
	10751: 0x00008E91,
	10752: 0x00008E93,
	10753: 0x00008F61,
	10754: 0x00009148,
	10755: 0x00009444,
	10756: 0x00009451,
	10757: 0x00009452,
	10758: 0x0000973D,
	10759: 0x0000973E,
	10760: 0x000097C3,
	10761: 0x000097C1,
	10762: 0x0000986B,
	10763: 0x00009955,
	10764: 0x00009A55,
	10765: 0x00009A4D,
	10766: 0x00009AD2,
	10767: 0x00009B1A,
	10768: 0x00009C49,
	10769: 0x00009C31,
	10770: 0x00009C3E,
	10771: 0x00009C3B,
	10772: 0x00009DD3,
	10773: 0x00009DD7,
	10774: 0x00009F34,
	10775: 0x00009F6C,
	10776: 0x00009F6A,
	10777: 0x00009F94,
	10778: 0x000056CC,
	10779: 0x00005DD6,
	10780: 0x00006200,
	10781: 0x00006523,
	10782: 0x0000652B,
	10783: 0x0000652A,
	10784: 0x000066EC,
	10785: 0x00006B10,
	10786: 0x000074DA,
	10787: 0x00007ACA,
	10788: 0x00007C64,
	10789: 0x00007C63,
	10790: 0x00007C65,
	10791: 0x00007E93,
	10792: 0x00007E96,
	10793: 0x00007E94,
	10794: 0x000081E2,
	10795: 0x00008638,
	10796: 0x0000863F,
	10797: 0x00008831,
	10798: 0x00008B8A,
	10799: 0x00009090,
	10800: 0x0000908F,
	10801: 0x00009463,
	10802: 0x00009460,
	10803: 0x00009464,
	10804: 0x00009768,
	10805: 0x0000986F,
	10806: 0x0000995C,
	10807: 0x00009A5A,
	10808: 0x00009A5B,
	10809: 0x00009A57,
	10810: 0x00009AD3,
	10811: 0x00009AD4,
	10812: 0x00009AD1,
	10813: 0x00009C54,
	10814: 0x00009C57,
	10815: 0x00009C56,
	10816: 0x00009DE5,
	10817: 0x00009E9F,
	10818: 0x00009EF4,
	10819: 0x000056D1,
	10820: 0x000058E9,
	10821: 0x0000652C,
	10822: 0x0000705E,
	10823: 0x00007671,
	10824: 0x00007672,
	10825: 0x000077D7,
	10826: 0x00007F50,
	10827: 0x00007F88,
	10828: 0x00008836,
	10829: 0x00008839,
	10830: 0x00008862,
	10831: 0x00008B93,
	10832: 0x00008B92,
	10833: 0x00008B96,
	10834: 0x00008277,
	10835: 0x00008D1B,
	10836: 0x000091C0,
	10837: 0x0000946A,
	10838: 0x00009742,
	10839: 0x00009748,
	10840: 0x00009744,
	10841: 0x000097C6,
	10842: 0x00009870,
	10843: 0x00009A5F,
	10844: 0x00009B22,
	10845: 0x00009B58,
	10846: 0x00009C5F,
	10847: 0x00009DF9,
	10848: 0x00009DFA,
	10849: 0x00009E7C,
	10850: 0x00009E7D,
	10851: 0x00009F07,
	10852: 0x00009F77,
	10853: 0x00009F72,
	10854: 0x00005EF3,
	10855: 0x00006B16,
	10856: 0x00007063,
	10857: 0x00007C6C,
	10858: 0x00007C6E,
	10859: 0x0000883B,
	10860: 0x000089C0,
	10861: 0x00008EA1,
	10862: 0x000091C1,
	10863: 0x00009472,
	10864: 0x00009470,
	10865: 0x00009871,
	10866: 0x0000995E,
	10867: 0x00009AD6,
	10868: 0x00009B23,
	10869: 0x00009ECC,
	10870: 0x00007064,
	10871: 0x000077DA,
	10872: 0x00008B9A,
	10873: 0x00009477,
	10874: 0x000097C9,
	10875: 0x00009A62,
	10876: 0x00009A65,
	10877: 0x00007E9C,
	10878: 0x00008B9C,
	10879: 0x00008EAA,
	10880: 0x000091C5,
	10881: 0x0000947D,
	10882: 0x0000947E,
	10883: 0x0000947C,
	10884: 0x00009C77,
	10885: 0x00009C78,
	10886: 0x00009EF7,
	10887: 0x00008C54,
	10888: 0x0000947F,
	10889: 0x00009E1A,
	10890: 0x00007228,
	10891: 0x00009A6A,
	10892: 0x00009B31,
	10893: 0x00009E1B,
	10894: 0x00009E1E,
	10895: 0x00007C72,
	10896: 0x00002460,
	10897: 0x00002461,
	10898: 0x00002462,
	10899: 0x00002463,
	10900: 0x00002464,
	10901: 0x00002465,
	10902: 0x00002466,
	10903: 0x00002467,
	10904: 0x00002468,
	10905: 0x00002469,
	10906: 0x00002474,
	10907: 0x00002475,
	10908: 0x00002476,
	10909: 0x00002477,
	10910: 0x00002478,
	10911: 0x00002479,
	10912: 0x0000247A,
	10913: 0x0000247B,
	10914: 0x0000247C,
	10915: 0x0000247D,
	10916: 0x00002170,
	10917: 0x00002171,
	10918: 0x00002172,
	10919: 0x00002173,
	10920: 0x00002174,
	10921: 0x00002175,
	10922: 0x00002176,
	10923: 0x00002177,
	10924: 0x00002178,
	10925: 0x00002179,
	10926: 0x00004E36,
	10927: 0x00004E3F,
	10928: 0x00004E85,
	10929: 0x00004EA0,
	10930: 0x00005182,
	10931: 0x00005196,
	10932: 0x000051AB,
	10933: 0x000052F9,
	10934: 0x00005338,
	10935: 0x00005369,
	10936: 0x000053B6,
	10937: 0x0000590A,
	10938: 0x00005B80,
	10939: 0x00005DDB,
	10940: 0x00002F33,
	10941: 0x00005E7F,
	10942: 0x00005EF4,
	10943: 0x00005F50,
	10944: 0x00005F61,
	10945: 0x00006534,
	10946: 0x000065E0,
	10947: 0x00007592,
	10948: 0x00007676,
	10949: 0x00008FB5,
	10950: 0x000096B6,
	10951: 0x000000A8,
	10952: 0x000002C6,
	10953: 0x000030FD,
	10954: 0x000030FE,
	10955: 0x0000309D,
	10956: 0x0000309E,
	10957: 0x00003003,
	10958: 0x00004EDD,
	10959: 0x00003005,
	10960: 0x00003006,
	10961: 0x00003007,
	10962: 0x000030FC,
	10963: 0x0000FF3B,
	10964: 0x0000FF3D,
	10965: 0x0000273D,
	10966: 0x00003041,
	10967: 0x00003042,
	10968: 0x00003043,
	10969: 0x00003044,
	10970: 0x00003045,
	10971: 0x00003046,
	10972: 0x00003047,
	10973: 0x00003048,
	10974: 0x00003049,
	10975: 0x0000304A,
	10976: 0x0000304B,
	10977: 0x0000304C,
	10978: 0x0000304D,
	10979: 0x0000304E,
	10980: 0x0000304F,
	10981: 0x00003050,
	10982: 0x00003051,
	10983: 0x00003052,
	10984: 0x00003053,
	10985: 0x00003054,
	10986: 0x00003055,
	10987: 0x00003056,
	10988: 0x00003057,
	10989: 0x00003058,
	10990: 0x00003059,
	10991: 0x0000305A,
	10992: 0x0000305B,
	10993: 0x0000305C,
	10994: 0x0000305D,
	10995: 0x0000305E,
	10996: 0x0000305F,
	10997: 0x00003060,
	10998: 0x00003061,
	10999: 0x00003062,
	11000: 0x00003063,
	11001: 0x00003064,
	11002: 0x00003065,
	11003: 0x00003066,
	11004: 0x00003067,
	11005: 0x00003068,
	11006: 0x00003069,
	11007: 0x0000306A,
	11008: 0x0000306B,
	11009: 0x0000306C,
	11010: 0x0000306D,
	11011: 0x0000306E,
	11012: 0x0000306F,
	11013: 0x00003070,
	11014: 0x00003071,
	11015: 0x00003072,
	11016: 0x00003073,
	11017: 0x00003074,
	11018: 0x00003075,
	11019: 0x00003076,
	11020: 0x00003077,
	11021: 0x00003078,
	11022: 0x00003079,
	11023: 0x0000307A,
	11024: 0x0000307B,
	11025: 0x0000307C,
	11026: 0x0000307D,
	11027: 0x0000307E,
	11028: 0x0000307F,
	11029: 0x00003080,
	11030: 0x00003081,
	11031: 0x00003082,
	11032: 0x00003083,
	11033: 0x00003084,
	11034: 0x00003085,
	11035: 0x00003086,
	11036: 0x00003087,
	11037: 0x00003088,
	11038: 0x00003089,
	11039: 0x0000308A,
	11040: 0x0000308B,
	11041: 0x0000308C,
	11042: 0x0000308D,
	11043: 0x0000308E,
	11044: 0x0000308F,
	11045: 0x00003090,
	11046: 0x00003091,
	11047: 0x00003092,
	11048: 0x00003093,
	11049: 0x000030A1,
	11050: 0x000030A2,
	11051: 0x000030A3,
	11052: 0x000030A4,
	11053: 0x000030A5,
	11054: 0x000030A6,
	11055: 0x000030A7,
	11056: 0x000030A8,
	11057: 0x000030A9,
	11058: 0x000030AA,
	11059: 0x000030AB,
	11060: 0x000030AC,
	11061: 0x000030AD,
	11062: 0x000030AE,
	11063: 0x000030AF,
	11064: 0x000030B0,
	11065: 0x000030B1,
	11066: 0x000030B2,
	11067: 0x000030B3,
	11068: 0x000030B4,
	11069: 0x000030B5,
	11070: 0x000030B6,
	11071: 0x000030B7,
	11072: 0x000030B8,
	11073: 0x000030B9,
	11074: 0x000030BA,
	11075: 0x000030BB,
	11076: 0x000030BC,
	11077: 0x000030BD,
	11078: 0x000030BE,
	11079: 0x000030BF,
	11080: 0x000030C0,
	11081: 0x000030C1,
	11082: 0x000030C2,
	11083: 0x000030C3,
	11084: 0x000030C4,
	11085: 0x000030C5,
	11086: 0x000030C6,
	11087: 0x000030C7,
	11088: 0x000030C8,
	11089: 0x000030C9,
	11090: 0x000030CA,
	11091: 0x000030CB,
	11092: 0x000030CC,
	11093: 0x000030CD,
	11094: 0x000030CE,
	11095: 0x000030CF,
	11096: 0x000030D0,
	11097: 0x000030D1,
	11098: 0x000030D2,
	11099: 0x000030D3,
	11100: 0x000030D4,
	11101: 0x000030D5,
	11102: 0x000030D6,
	11103: 0x000030D7,
	11104: 0x000030D8,
	11105: 0x000030D9,
	11106: 0x000030DA,
	11107: 0x000030DB,
	11108: 0x000030DC,
	11109: 0x000030DD,
	11110: 0x000030DE,
	11111: 0x000030DF,
	11112: 0x000030E0,
	11113: 0x000030E1,
	11114: 0x000030E2,
	11115: 0x000030E3,
	11116: 0x000030E4,
	11117: 0x000030E5,
	11118: 0x000030E6,
	11119: 0x000030E7,
	11120: 0x000030E8,
	11121: 0x000030E9,
	11122: 0x000030EA,
	11123: 0x000030EB,
	11124: 0x000030EC,
	11125: 0x000030ED,
	11126: 0x000030EE,
	11127: 0x000030EF,
	11128: 0x000030F0,
	11129: 0x000030F1,
	11130: 0x000030F2,
	11131: 0x000030F3,
	11132: 0x000030F4,
	11133: 0x000030F5,
	11134: 0x000030F6,
	11135: 0x00000410,
	11136: 0x00000411,
	11137: 0x00000412,
	11138: 0x00000413,
	11139: 0x00000414,
	11140: 0x00000415,
	11141: 0x00000401,
	11142: 0x00000416,
	11143: 0x00000417,
	11144: 0x00000418,
	11145: 0x00000419,
	11146: 0x0000041A,
	11147: 0x0000041B,
	11148: 0x0000041C,
	11149: 0x0000041D,
	11150: 0x0000041E,
	11151: 0x0000041F,
	11152: 0x00000420,
	11153: 0x00000421,
	11154: 0x00000422,
	11155: 0x00000423,
	11156: 0x00000424,
	11157: 0x00000425,
	11158: 0x00000426,
	11159: 0x00000427,
	11160: 0x00000428,
	11161: 0x00000429,
	11162: 0x0000042A,
	11163: 0x0000042B,
	11164: 0x0000042C,
	11165: 0x0000042D,
	11166: 0x0000042E,
	11167: 0x0000042F,
	11168: 0x00000430,
	11169: 0x00000431,
	11170: 0x00000432,
	11171: 0x00000433,
	11172: 0x00000434,
	11173: 0x00000435,
	11174: 0x00000451,
	11175: 0x00000436,
	11176: 0x00000437,
	11177: 0x00000438,
	11178: 0x00000439,
	11179: 0x0000043A,
	11180: 0x0000043B,
	11181: 0x0000043C,
	11182: 0x0000043D,
	11183: 0x0000043E,
	11184: 0x0000043F,
	11185: 0x00000440,
	11186: 0x00000441,
	11187: 0x00000442,
	11188: 0x00000443,
	11189: 0x00000444,
	11190: 0x00000445,
	11191: 0x00000446,
	11192: 0x00000447,
	11193: 0x00000448,
	11194: 0x00000449,
	11195: 0x0000044A,
	11196: 0x0000044B,
	11197: 0x0000044C,
	11198: 0x0000044D,
	11199: 0x0000044E,
	11200: 0x0000044F,
	11201: 0x000021E7,
	11202: 0x000021B8,
	11203: 0x000021B9,
	11204: 0x000031CF,
	11205: 0x000200CC,
	11206: 0x00004E5A,
	11207: 0x0002008A,
	11208: 0x00005202,
	11209: 0x00004491,
	11210: 0x00009FB0,
	11211: 0x00005188,
	11212: 0x00009FB1,
	11213: 0x00027607,
	11254: 0x0000FFE2,
	11255: 0x0000FFE4,
	11256: 0x0000FF07,
	11257: 0x0000FF02,
	11258: 0x00003231,
	11259: 0x00002116,
	11260: 0x00002121,
	11261: 0x0000309B,
	11262: 0x0000309C,
	11263: 0x00002E80,
	11264: 0x00002E84,
	11265: 0x00002E86,
	11266: 0x00002E87,
	11267: 0x00002E88,
	11268: 0x00002E8A,
	11269: 0x00002E8C,
	11270: 0x00002E8D,
	11271: 0x00002E95,
	11272: 0x00002E9C,
	11273: 0x00002E9D,
	11274: 0x00002EA5,
	11275: 0x00002EA7,
	11276: 0x00002EAA,
	11277: 0x00002EAC,
	11278: 0x00002EAE,
	11279: 0x00002EB6,
	11280: 0x00002EBC,
	11281: 0x00002EBE,
	11282: 0x00002EC6,
	11283: 0x00002ECA,
	11284: 0x00002ECC,
	11285: 0x00002ECD,
	11286: 0x00002ECF,
	11287: 0x00002ED6,
	11288: 0x00002ED7,
	11289: 0x00002EDE,
	11290: 0x00002EE3,
	11294: 0x00000283,
	11295: 0x00000250,
	11296: 0x0000025B,
	11297: 0x00000254,
	11298: 0x00000275,
	11299: 0x00000153,
	11300: 0x000000F8,
	11301: 0x0000014B,
	11302: 0x0000028A,
	11303: 0x0000026A,
	11304: 0x00004E42,
	11305: 0x00004E5C,
	11306: 0x000051F5,
	11307: 0x0000531A,
	11308: 0x00005382,
	11309: 0x00004E07,
	11310: 0x00004E0C,
	11311: 0x00004E47,
	11312: 0x00004E8D,
	11313: 0x000056D7,
	11314: 0x0000FA0C,
	11315: 0x00005C6E,
	11316: 0x00005F73,
	11317: 0x00004E0F,
	11318: 0x00005187,
	11319: 0x00004E0E,
	11320: 0x00004E2E,
	11321: 0x00004E93,
	11322: 0x00004EC2,
	11323: 0x00004EC9,
	11324: 0x00004EC8,
	11325: 0x00005198,
	11326: 0x000052FC,
	11327: 0x0000536C,
	11328: 0x000053B9,
	11329: 0x00005720,
	11330: 0x00005903,
	11331: 0x0000592C,
	11332: 0x00005C10,
	11333: 0x00005DFF,
	11334: 0x000065E1,
	11335: 0x00006BB3,
	11336: 0x00006BCC,
	11337: 0x00006C14,
	11338: 0x0000723F,
	11339: 0x00004E31,
	11340: 0x00004E3C,
	11341: 0x00004EE8,
	11342: 0x00004EDC,
	11343: 0x00004EE9,
	11344: 0x00004EE1,
	11345: 0x00004EDD,
	11346: 0x00004EDA,
	11347: 0x0000520C,
	11348: 0x0000531C,
	11349: 0x0000534C,
	11350: 0x00005722,
	11351: 0x00005723,
	11352: 0x00005917,
	11353: 0x0000592F,
	11354: 0x00005B81,
	11355: 0x00005B84,
	11356: 0x00005C12,
	11357: 0x00005C3B,
	11358: 0x00005C74,
	11359: 0x00005C73,
	11360: 0x00005E04,
	11361: 0x00005E80,
	11362: 0x00005E82,
	11363: 0x00005FC9,
	11364: 0x00006209,
	11365: 0x00006250,
	11366: 0x00006C15,
	11367: 0x00006C36,
	11368: 0x00006C43,
	11369: 0x00006C3F,
	11370: 0x00006C3B,
	11371: 0x000072AE,
	11372: 0x000072B0,
	11373: 0x0000738A,
	11374: 0x000079B8,
	11375: 0x0000808A,
	11376: 0x0000961E,
	11377: 0x00004F0E,
	11378: 0x00004F18,
	11379: 0x00004F2C,
	11380: 0x00004EF5,
	11381: 0x00004F14,
	11382: 0x00004EF1,
	11383: 0x00004F00,
	11384: 0x00004EF7,
	11385: 0x00004F08,
	11386: 0x00004F1D,
	11387: 0x00004F02,
	11388: 0x00004F05,
	11389: 0x00004F22,
	11390: 0x00004F13,
	11391: 0x00004F04,
	11392: 0x00004EF4,
	11393: 0x00004F12,
	11394: 0x000051B1,
	11395: 0x00005213,
	11396: 0x00005209,
	11397: 0x00005210,
	11398: 0x000052A6,
	11399: 0x00005322,
	11400: 0x0000531F,
	11401: 0x0000534D,
	11402: 0x0000538A,
	11403: 0x00005407,
	11404: 0x000056E1,
	11405: 0x000056DF,
	11406: 0x0000572E,
	11407: 0x0000572A,
	11408: 0x00005734,
	11409: 0x0000593C,
	11410: 0x00005980,
	11411: 0x0000597C,
	11412: 0x00005985,
	11413: 0x0000597B,
	11414: 0x0000597E,
	11415: 0x00005977,
	11416: 0x0000597F,
	11417: 0x00005B56,
	11418: 0x00005C15,
	11419: 0x00005C25,
	11420: 0x00005C7C,
	11421: 0x00005C7A,
	11422: 0x00005C7B,
	11423: 0x00005C7E,
	11424: 0x00005DDF,
	11425: 0x00005E75,
	11426: 0x00005E84,
	11427: 0x00005F02,
	11428: 0x00005F1A,
	11429: 0x00005F74,
	11430: 0x00005FD5,
	11431: 0x00005FD4,
	11432: 0x00005FCF,
	11433: 0x0000625C,
	11434: 0x0000625E,
	11435: 0x00006264,
	11436: 0x00006261,
	11437: 0x00006266,
	11438: 0x00006262,
	11439: 0x00006259,
	11440: 0x00006260,
	11441: 0x0000625A,
	11442: 0x00006265,
	11443: 0x000065EF,
	11444: 0x000065EE,
	11445: 0x0000673E,
	11446: 0x00006739,
	11447: 0x00006738,
	11448: 0x0000673B,
	11449: 0x0000673A,
	11450: 0x0000673F,
	11451: 0x0000673C,
	11452: 0x00006733,
	11453: 0x00006C18,
	11454: 0x00006C46,
	11455: 0x00006C52,
	11456: 0x00006C5C,
	11457: 0x00006C4F,
	11458: 0x00006C4A,
	11459: 0x00006C54,
	11460: 0x00006C4B,
	11461: 0x00006C4C,
	11462: 0x00007071,
	11463: 0x0000725E,
	11464: 0x000072B4,
	11465: 0x000072B5,
	11466: 0x0000738E,
	11467: 0x0000752A,
	11468: 0x0000767F,
	11469: 0x00007A75,
	11470: 0x00007F51,
	11471: 0x00008278,
	11472: 0x0000827C,
	11473: 0x00008280,
	11474: 0x0000827D,
	11475: 0x0000827F,
	11476: 0x0000864D,
	11477: 0x0000897E,
	11478: 0x00009099,
	11479: 0x00009097,
	11480: 0x00009098,
	11481: 0x0000909B,
	11482: 0x00009094,
	11483: 0x00009622,
	11484: 0x00009624,
	11485: 0x00009620,
	11486: 0x00009623,
	11487: 0x00004F56,
	11488: 0x00004F3B,
	11489: 0x00004F62,
	11490: 0x00004F49,
	11491: 0x00004F53,
	11492: 0x00004F64,
	11493: 0x00004F3E,
	11494: 0x00004F67,
	11495: 0x00004F52,
	11496: 0x00004F5F,
	11497: 0x00004F41,
	11498: 0x00004F58,
	11499: 0x00004F2D,
	11500: 0x00004F33,
	11501: 0x00004F3F,
	11502: 0x00004F61,
	11503: 0x0000518F,
	11504: 0x000051B9,
	11505: 0x0000521C,
	11506: 0x0000521E,
	11507: 0x00005221,
	11508: 0x000052AD,
	11509: 0x000052AE,
	11510: 0x00005309,
	11511: 0x00005363,
	11512: 0x00005372,
	11513: 0x0000538E,
	11514: 0x0000538F,
	11515: 0x00005430,
	11516: 0x00005437,
	11517: 0x0000542A,
	11518: 0x00005454,
	11519: 0x00005445,
	11520: 0x00005419,
	11521: 0x0000541C,
	11522: 0x00005425,
	11523: 0x00005418,
	11524: 0x0000543D,
	11525: 0x0000544F,
	11526: 0x00005441,
	11527: 0x00005428,
	11528: 0x00005424,
	11529: 0x00005447,
	11530: 0x000056EE,
	11531: 0x000056E7,
	11532: 0x000056E5,
	11533: 0x00005741,
	11534: 0x00005745,
	11535: 0x0000574C,
	11536: 0x00005749,
	11537: 0x0000574B,
	11538: 0x00005752,
	11539: 0x00005906,
	11540: 0x00005940,
	11541: 0x000059A6,
	11542: 0x00005998,
	11543: 0x000059A0,
	11544: 0x00005997,
	11545: 0x0000598E,
	11546: 0x000059A2,
	11547: 0x00005990,
	11548: 0x0000598F,
	11549: 0x000059A7,
	11550: 0x000059A1,
	11551: 0x00005B8E,
	11552: 0x00005B92,
	11553: 0x00005C28,
	11554: 0x00005C2A,
	11555: 0x00005C8D,
	11556: 0x00005C8F,
	11557: 0x00005C88,
	11558: 0x00005C8B,
	11559: 0x00005C89,
	11560: 0x00005C92,
	11561: 0x00005C8A,
	11562: 0x00005C86,
	11563: 0x00005C93,
	11564: 0x00005C95,
	11565: 0x00005DE0,
	11566: 0x00005E0A,
	11567: 0x00005E0E,
	11568: 0x00005E8B,
	11569: 0x00005E89,
	11570: 0x00005E8C,
	11571: 0x00005E88,
	11572: 0x00005E8D,
	11573: 0x00005F05,
	11574: 0x00005F1D,
	11575: 0x00005F78,
	11576: 0x00005F76,
	11577: 0x00005FD2,
	11578: 0x00005FD1,
	11579: 0x00005FD0,
	11580: 0x00005FED,
	11581: 0x00005FE8,
	11582: 0x00005FEE,
	11583: 0x00005FF3,
	11584: 0x00005FE1,
	11585: 0x00005FE4,
	11586: 0x00005FE3,
	11587: 0x00005FFA,
	11588: 0x00005FEF,
	11589: 0x00005FF7,
	11590: 0x00005FFB,
	11591: 0x00006000,
	11592: 0x00005FF4,
	11593: 0x0000623A,
	11594: 0x00006283,
	11595: 0x0000628C,
	11596: 0x0000628E,
	11597: 0x0000628F,
	11598: 0x00006294,
	11599: 0x00006287,
	11600: 0x00006271,
	11601: 0x0000627B,
	11602: 0x0000627A,
	11603: 0x00006270,
	11604: 0x00006281,
	11605: 0x00006288,
	11606: 0x00006277,
	11607: 0x0000627D,
	11608: 0x00006272,
	11609: 0x00006274,
	11610: 0x00006537,
	11611: 0x000065F0,
	11612: 0x000065F4,
	11613: 0x000065F3,
	11614: 0x000065F2,
	11615: 0x000065F5,
	11616: 0x00006745,
	11617: 0x00006747,
	11618: 0x00006759,
	11619: 0x00006755,
	11620: 0x0000674C,
	11621: 0x00006748,
	11622: 0x0000675D,
	11623: 0x0000674D,
	11624: 0x0000675A,
	11625: 0x0000674B,
	11626: 0x00006BD0,
	11627: 0x00006C19,
	11628: 0x00006C1A,
	11629: 0x00006C78,
	11630: 0x00006C67,
	11631: 0x00006C6B,
	11632: 0x00006C84,
	11633: 0x00006C8B,
	11634: 0x00006C8F,
	11635: 0x00006C71,
	11636: 0x00006C6F,
	11637: 0x00006C69,
	11638: 0x00006C9A,
	11639: 0x00006C6D,
	11640: 0x00006C87,
	11641: 0x00006C95,
	11642: 0x00006C9C,
	11643: 0x00006C66,
	11644: 0x00006C73,
	11645: 0x00006C65,
	11646: 0x00006C7B,
	11647: 0x00006C8E,
	11648: 0x00007074,
	11649: 0x0000707A,
	11650: 0x00007263,
	11651: 0x000072BF,
	11652: 0x000072BD,
	11653: 0x000072C3,
	11654: 0x000072C6,
	11655: 0x000072C1,
	11656: 0x000072BA,
	11657: 0x000072C5,
	11658: 0x00007395,
	11659: 0x00007397,
	11660: 0x00007393,
	11661: 0x00007394,
	11662: 0x00007392,
	11663: 0x0000753A,
	11664: 0x00007539,
	11665: 0x00007594,
	11666: 0x00007595,
	11667: 0x00007681,
	11668: 0x0000793D,
	11669: 0x00008034,
	11670: 0x00008095,
	11671: 0x00008099,
	11672: 0x00008090,
	11673: 0x00008092,
	11674: 0x0000809C,
	11675: 0x00008290,
	11676: 0x0000828F,
	11677: 0x00008285,
	11678: 0x0000828E,
	11679: 0x00008291,
	11680: 0x00008293,
	11681: 0x0000828A,
	11682: 0x00008283,
	11683: 0x00008284,
	11684: 0x00008C78,
	11685: 0x00008FC9,
	11686: 0x00008FBF,
	11687: 0x0000909F,
	11688: 0x000090A1,
	11689: 0x000090A5,
	11690: 0x0000909E,
	11691: 0x000090A7,
	11692: 0x000090A0,
	11693: 0x00009630,
	11694: 0x00009628,
	11695: 0x0000962F,
	11696: 0x0000962D,
	11697: 0x00004E33,
	11698: 0x00004F98,
	11699: 0x00004F7C,
	11700: 0x00004F85,
	11701: 0x00004F7D,
	11702: 0x00004F80,
	11703: 0x00004F87,
	11704: 0x00004F76,
	11705: 0x00004F74,
	11706: 0x00004F89,
	11707: 0x00004F84,
	11708: 0x00004F77,
	11709: 0x00004F4C,
	11710: 0x00004F97,
	11711: 0x00004F6A,
	11712: 0x00004F9A,
	11713: 0x00004F79,
	11714: 0x00004F81,
	11715: 0x00004F78,
	11716: 0x00004F90,
	11717: 0x00004F9C,
	11718: 0x00004F94,
	11719: 0x00004F9E,
	11720: 0x00004F92,
	11721: 0x00004F82,
	11722: 0x00004F95,
	11723: 0x00004F6B,
	11724: 0x00004F6E,
	11725: 0x0000519E,
	11726: 0x000051BC,
	11727: 0x000051BE,
	11728: 0x00005235,
	11729: 0x00005232,
	11730: 0x00005233,
	11731: 0x00005246,
	11732: 0x00005231,
	11733: 0x000052BC,
	11734: 0x0000530A,
	11735: 0x0000530B,
	11736: 0x0000533C,
	11737: 0x00005392,
	11738: 0x00005394,
	11739: 0x00005487,
	11740: 0x0000547F,
	11741: 0x00005481,
	11742: 0x00005491,
	11743: 0x00005482,
	11744: 0x00005488,
	11745: 0x0000546B,
	11746: 0x0000547A,
	11747: 0x0000547E,
	11748: 0x00005465,
	11749: 0x0000546C,
	11750: 0x00005474,
	11751: 0x00005466,
	11752: 0x0000548D,
	11753: 0x0000546F,
	11754: 0x00005461,
	11755: 0x00005460,
	11756: 0x00005498,
	11757: 0x00005463,
	11758: 0x00005467,
	11759: 0x00005464,
	11760: 0x000056F7,
	11761: 0x000056F9,
	11762: 0x0000576F,
	11763: 0x00005772,
	11764: 0x0000576D,
	11765: 0x0000576B,
	11766: 0x00005771,
	11767: 0x00005770,
	11768: 0x00005776,
	11769: 0x00005780,
	11770: 0x00005775,
	11771: 0x0000577B,
	11772: 0x00005773,
	11773: 0x00005774,
	11774: 0x00005762,
	11775: 0x00005768,
	11776: 0x0000577D,
	11777: 0x0000590C,
	11778: 0x00005945,
	11779: 0x000059B5,
	11780: 0x000059BA,
	11781: 0x000059CF,
	11782: 0x000059CE,
	11783: 0x000059B2,
	11784: 0x000059CC,
	11785: 0x000059C1,
	11786: 0x000059B6,
	11787: 0x000059BC,
	11788: 0x000059C3,
	11789: 0x000059D6,
	11790: 0x000059B1,
	11791: 0x000059BD,
	11792: 0x000059C0,
	11793: 0x000059C8,
	11794: 0x000059B4,
	11795: 0x000059C7,
	11796: 0x00005B62,
	11797: 0x00005B65,
	11798: 0x00005B93,
	11799: 0x00005B95,
	11800: 0x00005C44,
	11801: 0x00005C47,
	11802: 0x00005CAE,
	11803: 0x00005CA4,
	11804: 0x00005CA0,
	11805: 0x00005CB5,
	11806: 0x00005CAF,
	11807: 0x00005CA8,
	11808: 0x00005CAC,
	11809: 0x00005C9F,
	11810: 0x00005CA3,
	11811: 0x00005CAD,
	11812: 0x00005CA2,
	11813: 0x00005CAA,
	11814: 0x00005CA7,
	11815: 0x00005C9D,
	11816: 0x00005CA5,
	11817: 0x00005CB6,
	11818: 0x00005CB0,
	11819: 0x00005CA6,
	11820: 0x00005E17,
	11821: 0x00005E14,
	11822: 0x00005E19,
	11823: 0x00005F28,
	11824: 0x00005F22,
	11825: 0x00005F23,
	11826: 0x00005F24,
	11827: 0x00005F54,
	11828: 0x00005F82,
	11829: 0x00005F7E,
	11830: 0x00005F7D,
	11831: 0x00005FDE,
	11832: 0x00005FE5,
	11833: 0x0000602D,
	11834: 0x00006026,
	11835: 0x00006019,
	11836: 0x00006032,
	11837: 0x0000600B,
	11838: 0x00006034,
	11839: 0x0000600A,
	11840: 0x00006017,
	11841: 0x00006033,
	11842: 0x0000601A,
	11843: 0x0000601E,
	11844: 0x0000602C,
	11845: 0x00006022,
	11846: 0x0000600D,
	11847: 0x00006010,
	11848: 0x0000602E,
	11849: 0x00006013,
	11850: 0x00006011,
	11851: 0x0000600C,
	11852: 0x00006009,
	11853: 0x0000601C,
	11854: 0x00006214,
	11855: 0x0000623D,
	11856: 0x000062AD,
	11857: 0x000062B4,
	11858: 0x000062D1,
	11859: 0x000062BE,
	11860: 0x000062AA,
	11861: 0x000062B6,
	11862: 0x000062CA,
	11863: 0x000062AE,
	11864: 0x000062B3,
	11865: 0x000062AF,
	11866: 0x000062BB,
	11867: 0x000062A9,
	11868: 0x000062B0,
	11869: 0x000062B8,
	11870: 0x0000653D,
	11871: 0x000065A8,
	11872: 0x000065BB,
	11873: 0x00006609,
	11874: 0x000065FC,
	11875: 0x00006604,
	11876: 0x00006612,
	11877: 0x00006608,
	11878: 0x000065FB,
	11879: 0x00006603,
	11880: 0x0000660B,
	11881: 0x0000660D,
	11882: 0x00006605,
	11883: 0x000065FD,
	11884: 0x00006611,
	11885: 0x00006610,
	11886: 0x000066F6,
	11887: 0x0000670A,
	11888: 0x00006785,
	11889: 0x0000676C,
	11890: 0x0000678E,
	11891: 0x00006792,
	11892: 0x00006776,
	11893: 0x0000677B,
	11894: 0x00006798,
	11895: 0x00006786,
	11896: 0x00006784,
	11897: 0x00006774,
	11898: 0x0000678D,
	11899: 0x0000678C,
	11900: 0x0000677A,
	11901: 0x0000679F,
	11902: 0x00006791,
	11903: 0x00006799,
	11904: 0x00006783,
	11905: 0x0000677D,
	11906: 0x00006781,
	11907: 0x00006778,
	11908: 0x00006779,
	11909: 0x00006794,
	11910: 0x00006B25,
	11911: 0x00006B80,
	11912: 0x00006B7E,
	11913: 0x00006BDE,
	11914: 0x00006C1D,
	11915: 0x00006C93,
	11916: 0x00006CEC,
	11917: 0x00006CEB,
	11918: 0x00006CEE,
	11919: 0x00006CD9,
	11920: 0x00006CB6,
	11921: 0x00006CD4,
	11922: 0x00006CAD,
	11923: 0x00006CE7,
	11924: 0x00006CB7,
	11925: 0x00006CD0,
	11926: 0x00006CC2,
	11927: 0x00006CBA,
	11928: 0x00006CC3,
	11929: 0x00006CC6,
	11930: 0x00006CED,
	11931: 0x00006CF2,
	11932: 0x00006CD2,
	11933: 0x00006CDD,
	11934: 0x00006CB4,
	11935: 0x00006C8A,
	11936: 0x00006C9D,
	11937: 0x00006C80,
	11938: 0x00006CDE,
	11939: 0x00006CC0,
	11940: 0x00006D30,
	11941: 0x00006CCD,
	11942: 0x00006CC7,
	11943: 0x00006CB0,
	11944: 0x00006CF9,
	11945: 0x00006CCF,
	11946: 0x00006CE9,
	11947: 0x00006CD1,
	11948: 0x00007094,
	11949: 0x00007098,
	11950: 0x00007085,
	11951: 0x00007093,
	11952: 0x00007086,
	11953: 0x00007084,
	11954: 0x00007091,
	11955: 0x00007096,
	11956: 0x00007082,
	11957: 0x0000709A,
	11958: 0x00007083,
	11959: 0x0000726A,
	11960: 0x000072D6,
	11961: 0x000072CB,
	11962: 0x000072D8,
	11963: 0x000072C9,
	11964: 0x000072DC,
	11965: 0x000072D2,
	11966: 0x000072D4,
	11967: 0x000072DA,
	11968: 0x000072CC,
	11969: 0x000072D1,
	11970: 0x000073A4,
	11971: 0x000073A1,
	11972: 0x000073AD,
	11973: 0x000073A6,
	11974: 0x000073A2,
	11975: 0x000073A0,
	11976: 0x000073AC,
	11977: 0x0000739D,
	11978: 0x000074DD,
	11979: 0x000074E8,
	11980: 0x0000753F,
	11981: 0x00007540,
	11982: 0x0000753E,
	11983: 0x0000758C,
	11984: 0x00007598,
	11985: 0x000076AF,
	11986: 0x000076F3,
	11987: 0x000076F1,
	11988: 0x000076F0,
	11989: 0x000076F5,
	11990: 0x000077F8,
	11991: 0x000077FC,
	11992: 0x000077F9,
	11993: 0x000077FB,
	11994: 0x000077FA,
	11995: 0x000077F7,
	11996: 0x00007942,
	11997: 0x0000793F,
	11998: 0x000079C5,
	11999: 0x00007A78,
	12000: 0x00007A7B,
	12001: 0x00007AFB,
	12002: 0x00007C75,
	12003: 0x00007CFD,
	12004: 0x00008035,
	12005: 0x0000808F,
	12006: 0x000080AE,
	12007: 0x000080A3,
	12008: 0x000080B8,
	12009: 0x000080B5,
	12010: 0x000080AD,
	12011: 0x00008220,
	12012: 0x000082A0,
	12013: 0x000082C0,
	12014: 0x000082AB,
	12015: 0x0000829A,
	12016: 0x00008298,
	12017: 0x0000829B,
	12018: 0x000082B5,
	12019: 0x000082A7,
	12020: 0x000082AE,
	12021: 0x000082BC,
	12022: 0x0000829E,
	12023: 0x000082BA,
	12024: 0x000082B4,
	12025: 0x000082A8,
	12026: 0x000082A1,
	12027: 0x000082A9,
	12028: 0x000082C2,
	12029: 0x000082A4,
	12030: 0x000082C3,
	12031: 0x000082B6,
	12032: 0x000082A2,
	12033: 0x00008670,
	12034: 0x0000866F,
	12035: 0x0000866D,
	12036: 0x0000866E,
	12037: 0x00008C56,
	12038: 0x00008FD2,
	12039: 0x00008FCB,
	12040: 0x00008FD3,
	12041: 0x00008FCD,
	12042: 0x00008FD6,
	12043: 0x00008FD5,
	12044: 0x00008FD7,
	12045: 0x000090B2,
	12046: 0x000090B4,
	12047: 0x000090AF,
	12048: 0x000090B3,
	12049: 0x000090B0,
	12050: 0x00009639,
	12051: 0x0000963D,
	12052: 0x0000963C,
	12053: 0x0000963A,
	12054: 0x00009643,
	12055: 0x00004FCD,
	12056: 0x00004FC5,
	12057: 0x00004FD3,
	12058: 0x00004FB2,
	12059: 0x00004FC9,
	12060: 0x00004FCB,
	12061: 0x00004FC1,
	12062: 0x00004FD4,
	12063: 0x00004FDC,
	12064: 0x00004FD9,
	12065: 0x00004FBB,
	12066: 0x00004FB3,
	12067: 0x00004FDB,
	12068: 0x00004FC7,
	12069: 0x00004FD6,
	12070: 0x00004FBA,
	12071: 0x00004FC0,
	12072: 0x00004FB9,
	12073: 0x00004FEC,
	12074: 0x00005244,
	12075: 0x00005249,
	12076: 0x000052C0,
	12077: 0x000052C2,
	12078: 0x0000533D,
	12079: 0x0000537C,
	12080: 0x00005397,
	12081: 0x00005396,
	12082: 0x00005399,
	12083: 0x00005398,
	12084: 0x000054BA,
	12085: 0x000054A1,
	12086: 0x000054AD,
	12087: 0x000054A5,
	12088: 0x000054CF,
	12089: 0x000054C3,
	12090: 0x0000830D,
	12091: 0x000054B7,
	12092: 0x000054AE,
	12093: 0x000054D6,
	12094: 0x000054B6,
	12095: 0x000054C5,
	12096: 0x000054C6,
	12097: 0x000054A0,
	12098: 0x00005470,
	12099: 0x000054BC,
	12100: 0x000054A2,
	12101: 0x000054BE,
	12102: 0x00005472,
	12103: 0x000054DE,
	12104: 0x000054B0,
	12105: 0x000057B5,
	12106: 0x0000579E,
	12107: 0x0000579F,
	12108: 0x000057A4,
	12109: 0x0000578C,
	12110: 0x00005797,
	12111: 0x0000579D,
	12112: 0x0000579B,
	12113: 0x00005794,
	12114: 0x00005798,
	12115: 0x0000578F,
	12116: 0x00005799,
	12117: 0x000057A5,
	12118: 0x0000579A,
	12119: 0x00005795,
	12120: 0x000058F4,
	12121: 0x0000590D,
	12122: 0x00005953,
	12123: 0x000059E1,
	12124: 0x000059DE,
	12125: 0x000059EE,
	12126: 0x00005A00,
	12127: 0x000059F1,
	12128: 0x000059DD,
	12129: 0x000059FA,
	12130: 0x000059FD,
	12131: 0x000059FC,
	12132: 0x000059F6,
	12133: 0x000059E4,
	12134: 0x000059F2,
	12135: 0x000059F7,
	12136: 0x000059DB,
	12137: 0x000059E9,
	12138: 0x000059F3,
	12139: 0x000059F5,
	12140: 0x000059E0,
	12141: 0x000059FE,
	12142: 0x000059F4,
	12143: 0x000059ED,
	12144: 0x00005BA8,
	12145: 0x00005C4C,
	12146: 0x00005CD0,
	12147: 0x00005CD8,
	12148: 0x00005CCC,
	12149: 0x00005CD7,
	12150: 0x00005CCB,
	12151: 0x00005CDB,
	12152: 0x00005CDE,
	12153: 0x00005CDA,
	12154: 0x00005CC9,
	12155: 0x00005CC7,
	12156: 0x00005CCA,
	12157: 0x00005CD6,
	12158: 0x00005CD3,
	12159: 0x00005CD4,
	12160: 0x00005CCF,
	12161: 0x00005CC8,
	12162: 0x00005CC6,
	12163: 0x00005CCE,
	12164: 0x00005CDF,
	12165: 0x00005CF8,
	12166: 0x00005DF9,
	12167: 0x00005E21,
	12168: 0x00005E22,
	12169: 0x00005E23,
	12170: 0x00005E20,
	12171: 0x00005E24,
	12172: 0x00005EB0,
	12173: 0x00005EA4,
	12174: 0x00005EA2,
	12175: 0x00005E9B,
	12176: 0x00005EA3,
	12177: 0x00005EA5,
	12178: 0x00005F07,
	12179: 0x00005F2E,
	12180: 0x00005F56,
	12181: 0x00005F86,
	12182: 0x00006037,
	12183: 0x00006039,
	12184: 0x00006054,
	12185: 0x00006072,
	12186: 0x0000605E,
	12187: 0x00006045,
	12188: 0x00006053,
	12189: 0x00006047,
	12190: 0x00006049,
	12191: 0x0000605B,
	12192: 0x0000604C,
	12193: 0x00006040,
	12194: 0x00006042,
	12195: 0x0000605F,
	12196: 0x00006024,
	12197: 0x00006044,
	12198: 0x00006058,
	12199: 0x00006066,
	12200: 0x0000606E,
	12201: 0x00006242,
	12202: 0x00006243,
	12203: 0x000062CF,
	12204: 0x0000630D,
	12205: 0x0000630B,
	12206: 0x000062F5,
	12207: 0x0000630E,
	12208: 0x00006303,
	12209: 0x000062EB,
	12210: 0x000062F9,
	12211: 0x0000630F,
	12212: 0x0000630C,
	12213: 0x000062F8,
	12214: 0x000062F6,
	12215: 0x00006300,
	12216: 0x00006313,
	12217: 0x00006314,
	12218: 0x000062FA,
	12219: 0x00006315,
	12220: 0x000062FB,
	12221: 0x000062F0,
	12222: 0x00006541,
	12223: 0x00006543,
	12224: 0x000065AA,
	12225: 0x000065BF,
	12226: 0x00006636,
	12227: 0x00006621,
	12228: 0x00006632,
	12229: 0x00006635,
	12230: 0x0000661C,
	12231: 0x00006626,
	12232: 0x00006622,
	12233: 0x00006633,
	12234: 0x0000662B,
	12235: 0x0000663A,
	12236: 0x0000661D,
	12237: 0x00006634,
	12238: 0x00006639,
	12239: 0x0000662E,
	12240: 0x0000670F,
	12241: 0x00006710,
	12242: 0x000067C1,
	12243: 0x000067F2,
	12244: 0x000067C8,
	12245: 0x000067BA,
	12246: 0x000067DC,
	12247: 0x000067BB,
	12248: 0x000067F8,
	12249: 0x000067D8,
	12250: 0x000067C0,
	12251: 0x000067B7,
	12252: 0x000067C5,
	12253: 0x000067EB,
	12254: 0x000067E4,
	12255: 0x000067DF,
	12256: 0x000067B5,
	12257: 0x000067CD,
	12258: 0x000067B3,
	12259: 0x000067F7,
	12260: 0x000067F6,
	12261: 0x000067EE,
	12262: 0x000067E3,
	12263: 0x000067C2,
	12264: 0x000067B9,
	12265: 0x000067CE,
	12266: 0x000067E7,
	12267: 0x000067F0,
	12268: 0x000067B2,
	12269: 0x000067FC,
	12270: 0x000067C6,
	12271: 0x000067ED,
	12272: 0x000067CC,
	12273: 0x000067AE,
	12274: 0x000067E6,
	12275: 0x000067DB,
	12276: 0x000067FA,
	12277: 0x000067C9,
	12278: 0x000067CA,
	12279: 0x000067C3,
	12280: 0x000067EA,
	12281: 0x000067CB,
	12282: 0x00006B28,
	12283: 0x00006B82,
	12284: 0x00006B84,
	12285: 0x00006BB6,
	12286: 0x00006BD6,
	12287: 0x00006BD8,
	12288: 0x00006BE0,
	12289: 0x00006C20,
	12290: 0x00006C21,
	12291: 0x00006D28,
	12292: 0x00006D34,
	12293: 0x00006D2D,
	12294: 0x00006D1F,
	12295: 0x00006D3C,
	12296: 0x00006D3F,
	12297: 0x00006D12,
	12298: 0x00006D0A,
	12299: 0x00006CDA,
	12300: 0x00006D33,
	12301: 0x00006D04,
	12302: 0x00006D19,
	12303: 0x00006D3A,
	12304: 0x00006D1A,
	12305: 0x00006D11,
	12306: 0x00006D00,
	12307: 0x00006D1D,
	12308: 0x00006D42,
	12309: 0x00006D01,
	12310: 0x00006D18,
	12311: 0x00006D37,
	12312: 0x00006D03,
	12313: 0x00006D0F,
	12314: 0x00006D40,
	12315: 0x00006D07,
	12316: 0x00006D20,
	12317: 0x00006D2C,
	12318: 0x00006D08,
	12319: 0x00006D22,
	12320: 0x00006D09,
	12321: 0x00006D10,
	12322: 0x000070B7,
	12323: 0x0000709F,
	12324: 0x000070BE,
	12325: 0x000070B1,
	12326: 0x000070B0,
	12327: 0x000070A1,
	12328: 0x000070B4,
	12329: 0x000070B5,
	12330: 0x000070A9,
	12331: 0x00007241,
	12332: 0x00007249,
	12333: 0x0000724A,
	12334: 0x0000726C,
	12335: 0x00007270,
	12336: 0x00007273,
	12337: 0x0000726E,
	12338: 0x000072CA,
	12339: 0x000072E4,
	12340: 0x000072E8,
	12341: 0x000072EB,
	12342: 0x000072DF,
	12343: 0x000072EA,
	12344: 0x000072E6,
	12345: 0x000072E3,
	12346: 0x00007385,
	12347: 0x000073CC,
	12348: 0x000073C2,
	12349: 0x000073C8,
	12350: 0x000073C5,
	12351: 0x000073B9,
	12352: 0x000073B6,
	12353: 0x000073B5,
	12354: 0x000073B4,
	12355: 0x000073EB,
	12356: 0x000073BF,
	12357: 0x000073C7,
	12358: 0x000073BE,
	12359: 0x000073C3,
	12360: 0x000073C6,
	12361: 0x000073B8,
	12362: 0x000073CB,
	12363: 0x000074EC,
	12364: 0x000074EE,
	12365: 0x0000752E,
	12366: 0x00007547,
	12367: 0x00007548,
	12368: 0x000075A7,
	12369: 0x000075AA,
	12370: 0x00007679,
	12371: 0x000076C4,
	12372: 0x00007708,
	12373: 0x00007703,
	12374: 0x00007704,
	12375: 0x00007705,
	12376: 0x0000770A,
	12377: 0x000076F7,
	12378: 0x000076FB,
	12379: 0x000076FA,
	12380: 0x000077E7,
	12381: 0x000077E8,
	12382: 0x00007806,
	12383: 0x00007811,
	12384: 0x00007812,
	12385: 0x00007805,
	12386: 0x00007810,
	12387: 0x0000780F,
	12388: 0x0000780E,
	12389: 0x00007809,
	12390: 0x00007803,
	12391: 0x00007813,
	12392: 0x0000794A,
	12393: 0x0000794C,
	12394: 0x0000794B,
	12395: 0x00007945,
	12396: 0x00007944,
	12397: 0x000079D5,
	12398: 0x000079CD,
	12399: 0x000079CF,
	12400: 0x000079D6,
	12401: 0x000079CE,
	12402: 0x00007A80,
	12403: 0x00007A7E,
	12404: 0x00007AD1,
	12405: 0x00007B00,
	12406: 0x00007B01,
	12407: 0x00007C7A,
	12408: 0x00007C78,
	12409: 0x00007C79,
	12410: 0x00007C7F,
	12411: 0x00007C80,
	12412: 0x00007C81,
	12413: 0x00007D03,
	12414: 0x00007D08,
	12415: 0x00007D01,
	12416: 0x00007F58,
	12417: 0x00007F91,
	12418: 0x00007F8D,
	12419: 0x00007FBE,
	12420: 0x00008007,
	12421: 0x0000800E,
	12422: 0x0000800F,
	12423: 0x00008014,
	12424: 0x00008037,
	12425: 0x000080D8,
	12426: 0x000080C7,
	12427: 0x000080E0,
	12428: 0x000080D1,
	12429: 0x000080C8,
	12430: 0x000080C2,
	12431: 0x000080D0,
	12432: 0x000080C5,
	12433: 0x000080E3,
	12434: 0x000080D9,
	12435: 0x000080DC,
	12436: 0x000080CA,
	12437: 0x000080D5,
	12438: 0x000080C9,
	12439: 0x000080CF,
	12440: 0x000080D7,
	12441: 0x000080E6,
	12442: 0x000080CD,
	12443: 0x000081FF,
	12444: 0x00008221,
	12445: 0x00008294,
	12446: 0x000082D9,
	12447: 0x000082FE,
	12448: 0x000082F9,
	12449: 0x00008307,
	12450: 0x000082E8,
	12451: 0x00008300,
	12452: 0x000082D5,
	12453: 0x0000833A,
	12454: 0x000082EB,
	12455: 0x000082D6,
	12456: 0x000082F4,
	12457: 0x000082EC,
	12458: 0x000082E1,
	12459: 0x000082F2,
	12460: 0x000082F5,
	12461: 0x0000830C,
	12462: 0x000082FB,
	12463: 0x000082F6,
	12464: 0x000082F0,
	12465: 0x000082EA,
	12466: 0x000082E4,
	12467: 0x000082E0,
	12468: 0x000082FA,
	12469: 0x000082F3,
	12470: 0x000082ED,
	12471: 0x00008677,
	12472: 0x00008674,
	12473: 0x0000867C,
	12474: 0x00008673,
	12475: 0x00008841,
	12476: 0x0000884E,
	12477: 0x00008867,
	12478: 0x0000886A,
	12479: 0x00008869,
	12480: 0x000089D3,
	12481: 0x00008A04,
	12482: 0x00008A07,
	12483: 0x00008D72,
	12484: 0x00008FE3,
	12485: 0x00008FE1,
	12486: 0x00008FEE,
	12487: 0x00008FE0,
	12488: 0x000090F1,
	12489: 0x000090BD,
	12490: 0x000090BF,
	12491: 0x000090D5,
	12492: 0x000090C5,
	12493: 0x000090BE,
	12494: 0x000090C7,
	12495: 0x000090CB,
	12496: 0x000090C8,
	12497: 0x000091D4,
	12498: 0x000091D3,
	12499: 0x00009654,
	12500: 0x0000964F,
	12501: 0x00009651,
	12502: 0x00009653,
	12503: 0x0000964A,
	12504: 0x0000964E,
	12505: 0x0000501E,
	12506: 0x00005005,
	12507: 0x00005007,
	12508: 0x00005013,
	12509: 0x00005022,
	12510: 0x00005030,
	12511: 0x0000501B,
	12512: 0x00004FF5,
	12513: 0x00004FF4,
	12514: 0x00005033,
	12515: 0x00005037,
	12516: 0x0000502C,
	12517: 0x00004FF6,
	12518: 0x00004FF7,
	12519: 0x00005017,
	12520: 0x0000501C,
	12521: 0x00005020,
	12522: 0x00005027,
	12523: 0x00005035,
	12524: 0x0000502F,
	12525: 0x00005031,
	12526: 0x0000500E,
	12527: 0x0000515A,
	12528: 0x00005194,
	12529: 0x00005193,
	12530: 0x000051CA,
	12531: 0x000051C4,
	12532: 0x000051C5,
	12533: 0x000051C8,
	12534: 0x000051CE,
	12535: 0x00005261,
	12536: 0x0000525A,
	12537: 0x00005252,
	12538: 0x0000525E,
	12539: 0x0000525F,
	12540: 0x00005255,
	12541: 0x00005262,
	12542: 0x000052CD,
	12543: 0x0000530E,
	12544: 0x0000539E,
	12545: 0x00005526,
	12546: 0x000054E2,
	12547: 0x00005517,
	12548: 0x00005512,
	12549: 0x000054E7,
	12550: 0x000054F3,
	12551: 0x000054E4,
	12552: 0x0000551A,
	12553: 0x000054FF,
	12554: 0x00005504,
	12555: 0x00005508,
	12556: 0x000054EB,
	12557: 0x00005511,
	12558: 0x00005505,
	12559: 0x000054F1,
	12560: 0x0000550A,
	12561: 0x000054FB,
	12562: 0x000054F7,
	12563: 0x000054F8,
	12564: 0x000054E0,
	12565: 0x0000550E,
	12566: 0x00005503,
	12567: 0x0000550B,
	12568: 0x00005701,
	12569: 0x00005702,
	12570: 0x000057CC,
	12571: 0x00005832,
	12572: 0x000057D5,
	12573: 0x000057D2,
	12574: 0x000057BA,
	12575: 0x000057C6,
	12576: 0x000057BD,
	12577: 0x000057BC,
	12578: 0x000057B8,
	12579: 0x000057B6,
	12580: 0x000057BF,
	12581: 0x000057C7,
	12582: 0x000057D0,
	12583: 0x000057B9,
	12584: 0x000057C1,
	12585: 0x0000590E,
	12586: 0x0000594A,
	12587: 0x00005A19,
	12588: 0x00005A16,
	12589: 0x00005A2D,
	12590: 0x00005A2E,
	12591: 0x00005A15,
	12592: 0x00005A0F,
	12593: 0x00005A17,
	12594: 0x00005A0A,
	12595: 0x00005A1E,
	12596: 0x00005A33,
	12597: 0x00005B6C,
	12598: 0x00005BA7,
	12599: 0x00005BAD,
	12600: 0x00005BAC,
	12601: 0x00005C03,
	12602: 0x00005C56,
	12603: 0x00005C54,
	12604: 0x00005CEC,
	12605: 0x00005CFF,
	12606: 0x00005CEE,
	12607: 0x00005CF1,
	12608: 0x00005CF7,
	12609: 0x00005D00,
	12610: 0x00005CF9,
	12611: 0x00005E29,
	12612: 0x00005E28,
	12613: 0x00005EA8,
	12614: 0x00005EAE,
	12615: 0x00005EAA,
	12616: 0x00005EAC,
	12617: 0x00005F33,
	12618: 0x00005F30,
	12619: 0x00005F67,
	12620: 0x0000605D,
	12621: 0x0000605A,
	12622: 0x00006067,
	12623: 0x00006041,
	12624: 0x000060A2,
	12625: 0x00006088,
	12626: 0x00006080,
	12627: 0x00006092,
	12628: 0x00006081,
	12629: 0x0000609D,
	12630: 0x00006083,
	12631: 0x00006095,
	12632: 0x0000609B,
	12633: 0x00006097,
	12634: 0x00006087,
	12635: 0x0000609C,
	12636: 0x0000608E,
	12637: 0x00006219,
	12638: 0x00006246,
	12639: 0x000062F2,
	12640: 0x00006310,
	12641: 0x00006356,
	12642: 0x0000632C,
	12643: 0x00006344,
	12644: 0x00006345,
	12645: 0x00006336,
	12646: 0x00006343,
	12647: 0x000063E4,
	12648: 0x00006339,
	12649: 0x0000634B,
	12650: 0x0000634A,
	12651: 0x0000633C,
	12652: 0x00006329,
	12653: 0x00006341,
	12654: 0x00006334,
	12655: 0x00006358,
	12656: 0x00006354,
	12657: 0x00006359,
	12658: 0x0000632D,
	12659: 0x00006347,
	12660: 0x00006333,
	12661: 0x0000635A,
	12662: 0x00006351,
	12663: 0x00006338,
	12664: 0x00006357,
	12665: 0x00006340,
	12666: 0x00006348,
	12667: 0x0000654A,
	12668: 0x00006546,
	12669: 0x000065C6,
	12670: 0x000065C3,
	12671: 0x000065C4,
	12672: 0x000065C2,
	12673: 0x0000664A,
	12674: 0x0000665F,
	12675: 0x00006647,
	12676: 0x00006651,
	12677: 0x00006712,
	12678: 0x00006713,
	12679: 0x0000681F,
	12680: 0x0000681A,
	12681: 0x00006849,
	12682: 0x00006832,
	12683: 0x00006833,
	12684: 0x0000683B,
	12685: 0x0000684B,
	12686: 0x0000684F,
	12687: 0x00006816,
	12688: 0x00006831,
	12689: 0x0000681C,
	12690: 0x00006835,
	12691: 0x0000682B,
	12692: 0x0000682D,
	12693: 0x0000682F,
	12694: 0x0000684E,
	12695: 0x00006844,
	12696: 0x00006834,
	12697: 0x0000681D,
	12698: 0x00006812,
	12699: 0x00006814,
	12700: 0x00006826,
	12701: 0x00006828,
	12702: 0x0000682E,
	12703: 0x0000684D,
	12704: 0x0000683A,
	12705: 0x00006825,
	12706: 0x00006820,
	12707: 0x00006B2C,
	12708: 0x00006B2F,
	12709: 0x00006B2D,
	12710: 0x00006B31,
	12711: 0x00006B34,
	12712: 0x00006B6D,
	12713: 0x00008082,
	12714: 0x00006B88,
	12715: 0x00006BE6,
	12716: 0x00006BE4,
	12717: 0x00006BE8,
	12718: 0x00006BE3,
	12719: 0x00006BE2,
	12720: 0x00006BE7,
	12721: 0x00006C25,
	12722: 0x00006D7A,
	12723: 0x00006D63,
	12724: 0x00006D64,
	12725: 0x00006D76,
	12726: 0x00006D0D,
	12727: 0x00006D61,
	12728: 0x00006D92,
	12729: 0x00006D58,
	12730: 0x00006D62,
	12731: 0x00006D6D,
	12732: 0x00006D6F,
	12733: 0x00006D91,
	12734: 0x00006D8D,
	12735: 0x00006DEF,
	12736: 0x00006D7F,
	12737: 0x00006D86,
	12738: 0x00006D5E,
	12739: 0x00006D67,
	12740: 0x00006D60,
	12741: 0x00006D97,
	12742: 0x00006D70,
	12743: 0x00006D7C,
	12744: 0x00006D5F,
	12745: 0x00006D82,
	12746: 0x00006D98,
	12747: 0x00006D2F,
	12748: 0x00006D68,
	12749: 0x00006D8B,
	12750: 0x00006D7E,
	12751: 0x00006D80,
	12752: 0x00006D84,
	12753: 0x00006D16,
	12754: 0x00006D83,
	12755: 0x00006D7B,
	12756: 0x00006D7D,
	12757: 0x00006D75,
	12758: 0x00006D90,
	12759: 0x000070DC,
	12760: 0x000070D3,
	12761: 0x000070D1,
	12762: 0x000070DD,
	12763: 0x000070CB,
	12764: 0x00007F39,
	12765: 0x000070E2,
	12766: 0x000070D7,
	12767: 0x000070D2,
	12768: 0x000070DE,
	12769: 0x000070E0,
	12770: 0x000070D4,
	12771: 0x000070CD,
	12772: 0x000070C5,
	12773: 0x000070C6,
	12774: 0x000070C7,
	12775: 0x000070DA,
	12776: 0x000070CE,
	12777: 0x000070E1,
	12778: 0x00007242,
	12779: 0x00007278,
	12780: 0x00007277,
	12781: 0x00007276,
	12782: 0x00007300,
	12783: 0x000072FA,
	12784: 0x000072F4,
	12785: 0x000072FE,
	12786: 0x000072F6,
	12787: 0x000072F3,
	12788: 0x000072FB,
	12789: 0x00007301,
	12790: 0x000073D3,
	12791: 0x000073D9,
	12792: 0x000073E5,
	12793: 0x000073D6,
	12794: 0x000073BC,
	12795: 0x000073E7,
	12796: 0x000073E3,
	12797: 0x000073E9,
	12798: 0x000073DC,
	12799: 0x000073D2,
	12800: 0x000073DB,
	12801: 0x000073D4,
	12802: 0x000073DD,
	12803: 0x000073DA,
	12804: 0x000073D7,
	12805: 0x000073D8,
	12806: 0x000073E8,
	12807: 0x000074DE,
	12808: 0x000074DF,
	12809: 0x000074F4,
	12810: 0x000074F5,
	12811: 0x00007521,
	12812: 0x0000755B,
	12813: 0x0000755F,
	12814: 0x000075B0,
	12815: 0x000075C1,
	12816: 0x000075BB,
	12817: 0x000075C4,
	12818: 0x000075C0,
	12819: 0x000075BF,
	12820: 0x000075B6,
	12821: 0x000075BA,
	12822: 0x0000768A,
	12823: 0x000076C9,
	12824: 0x0000771D,
	12825: 0x0000771B,
	12826: 0x00007710,
	12827: 0x00007713,
	12828: 0x00007712,
	12829: 0x00007723,
	12830: 0x00007711,
	12831: 0x00007715,
	12832: 0x00007719,
	12833: 0x0000771A,
	12834: 0x00007722,
	12835: 0x00007727,
	12836: 0x00007823,
	12837: 0x0000782C,
	12838: 0x00007822,
	12839: 0x00007835,
	12840: 0x0000782F,
	12841: 0x00007828,
	12842: 0x0000782E,
	12843: 0x0000782B,
	12844: 0x00007821,
	12845: 0x00007829,
	12846: 0x00007833,
	12847: 0x0000782A,
	12848: 0x00007831,
	12849: 0x00007954,
	12850: 0x0000795B,
	12851: 0x0000794F,
	12852: 0x0000795C,
	12853: 0x00007953,
	12854: 0x00007952,
	12855: 0x00007951,
	12856: 0x000079EB,
	12857: 0x000079EC,
	12858: 0x000079E0,
	12859: 0x000079EE,
	12860: 0x000079ED,
	12861: 0x000079EA,
	12862: 0x000079DC,
	12863: 0x000079DE,
	12864: 0x000079DD,
	12865: 0x00007A86,
	12866: 0x00007A89,
	12867: 0x00007A85,
	12868: 0x00007A8B,
	12869: 0x00007A8C,
	12870: 0x00007A8A,
	12871: 0x00007A87,
	12872: 0x00007AD8,
	12873: 0x00007B10,
	12874: 0x00007B04,
	12875: 0x00007B13,
	12876: 0x00007B05,
	12877: 0x00007B0F,
	12878: 0x00007B08,
	12879: 0x00007B0A,
	12880: 0x00007B0E,
	12881: 0x00007B09,
	12882: 0x00007B12,
	12883: 0x00007C84,
	12884: 0x00007C91,
	12885: 0x00007C8A,
	12886: 0x00007C8C,
	12887: 0x00007C88,
	12888: 0x00007C8D,
	12889: 0x00007C85,
	12890: 0x00007D1E,
	12891: 0x00007D1D,
	12892: 0x00007D11,
	12893: 0x00007D0E,
	12894: 0x00007D18,
	12895: 0x00007D16,
	12896: 0x00007D13,
	12897: 0x00007D1F,
	12898: 0x00007D12,
	12899: 0x00007D0F,
	12900: 0x00007D0C,
	12901: 0x00007F5C,
	12902: 0x00007F61,
	12903: 0x00007F5E,
	12904: 0x00007F60,
	12905: 0x00007F5D,
	12906: 0x00007F5B,
	12907: 0x00007F96,
	12908: 0x00007F92,
	12909: 0x00007FC3,
	12910: 0x00007FC2,
	12911: 0x00007FC0,
	12912: 0x00008016,
	12913: 0x0000803E,
	12914: 0x00008039,
	12915: 0x000080FA,
	12916: 0x000080F2,
	12917: 0x000080F9,
	12918: 0x000080F5,
	12919: 0x00008101,
	12920: 0x000080FB,
	12921: 0x00008100,
	12922: 0x00008201,
	12923: 0x0000822F,
	12924: 0x00008225,
	12925: 0x00008333,
	12926: 0x0000832D,
	12927: 0x00008344,
	12928: 0x00008319,
	12929: 0x00008351,
	12930: 0x00008325,
	12931: 0x00008356,
	12932: 0x0000833F,
	12933: 0x00008341,
	12934: 0x00008326,
	12935: 0x0000831C,
	12936: 0x00008322,
	12937: 0x00008342,
	12938: 0x0000834E,
	12939: 0x0000831B,
	12940: 0x0000832A,
	12941: 0x00008308,
	12942: 0x0000833C,
	12943: 0x0000834D,
	12944: 0x00008316,
	12945: 0x00008324,
	12946: 0x00008320,
	12947: 0x00008337,
	12948: 0x0000832F,
	12949: 0x00008329,
	12950: 0x00008347,
	12951: 0x00008345,
	12952: 0x0000834C,
	12953: 0x00008353,
	12954: 0x0000831E,
	12955: 0x0000832C,
	12956: 0x0000834B,
	12957: 0x00008327,
	12958: 0x00008348,
	12959: 0x00008653,
	12960: 0x00008652,
	12961: 0x000086A2,
	12962: 0x000086A8,
	12963: 0x00008696,
	12964: 0x0000868D,
	12965: 0x00008691,
	12966: 0x0000869E,
	12967: 0x00008687,
	12968: 0x00008697,
	12969: 0x00008686,
	12970: 0x0000868B,
	12971: 0x0000869A,
	12972: 0x00008685,
	12973: 0x000086A5,
	12974: 0x00008699,
	12975: 0x000086A1,
	12976: 0x000086A7,
	12977: 0x00008695,
	12978: 0x00008698,
	12979: 0x0000868E,
	12980: 0x0000869D,
	12981: 0x00008690,
	12982: 0x00008694,
	12983: 0x00008843,
	12984: 0x00008844,
	12985: 0x0000886D,
	12986: 0x00008875,
	12987: 0x00008876,
	12988: 0x00008872,
	12989: 0x00008880,
	12990: 0x00008871,
	12991: 0x0000887F,
	12992: 0x0000886F,
	12993: 0x00008883,
	12994: 0x0000887E,
	12995: 0x00008874,
	12996: 0x0000887C,
	12997: 0x00008A12,
	12998: 0x00008C47,
	12999: 0x00008C57,
	13000: 0x00008C7B,
	13001: 0x00008CA4,
	13002: 0x00008CA3,
	13003: 0x00008D76,
	13004: 0x00008D78,
	13005: 0x00008DB5,
	13006: 0x00008DB7,
	13007: 0x00008DB6,
	13008: 0x00008ED1,
	13009: 0x00008ED3,
	13010: 0x00008FFE,
	13011: 0x00008FF5,
	13012: 0x00009002,
	13013: 0x00008FFF,
	13014: 0x00008FFB,
	13015: 0x00009004,
	13016: 0x00008FFC,
	13017: 0x00008FF6,
	13018: 0x000090D6,
	13019: 0x000090E0,
	13020: 0x000090D9,
	13021: 0x000090DA,
	13022: 0x000090E3,
	13023: 0x000090DF,
	13024: 0x000090E5,
	13025: 0x000090D8,
	13026: 0x000090DB,
	13027: 0x000090D7,
	13028: 0x000090DC,
	13029: 0x000090E4,
	13030: 0x00009150,
	13031: 0x0000914E,
	13032: 0x0000914F,
	13033: 0x000091D5,
	13034: 0x000091E2,
	13035: 0x000091DA,
	13036: 0x0000965C,
	13037: 0x0000965F,
	13038: 0x000096BC,
	13039: 0x000098E3,
	13040: 0x00009ADF,
	13041: 0x00009B2F,
	13042: 0x00004E7F,
	13043: 0x00005070,
	13044: 0x0000506A,
	13045: 0x00005061,
	13046: 0x0000505E,
	13047: 0x00005060,
	13048: 0x00005053,
	13049: 0x0000504B,
	13050: 0x0000505D,
	13051: 0x00005072,
	13052: 0x00005048,
	13053: 0x0000504D,
	13054: 0x00005041,
	13055: 0x0000505B,
	13056: 0x0000504A,
	13057: 0x00005062,
	13058: 0x00005015,
	13059: 0x00005045,
	13060: 0x0000505F,
	13061: 0x00005069,
	13062: 0x0000506B,
	13063: 0x00005063,
	13064: 0x00005064,
	13065: 0x00005046,
	13066: 0x00005040,
	13067: 0x0000506E,
	13068: 0x00005073,
	13069: 0x00005057,
	13070: 0x00005051,
	13071: 0x000051D0,
	13072: 0x0000526B,
	13073: 0x0000526D,
	13074: 0x0000526C,
	13075: 0x0000526E,
	13076: 0x000052D6,
	13077: 0x000052D3,
	13078: 0x0000532D,
	13079: 0x0000539C,
	13080: 0x00005575,
	13081: 0x00005576,
	13082: 0x0000553C,
	13083: 0x0000554D,
	13084: 0x00005550,
	13085: 0x00005534,
	13086: 0x0000552A,
	13087: 0x00005551,
	13088: 0x00005562,
	13089: 0x00005536,
	13090: 0x00005535,
	13091: 0x00005530,
	13092: 0x00005552,
	13093: 0x00005545,
	13094: 0x0000550C,
	13095: 0x00005532,
	13096: 0x00005565,
	13097: 0x0000554E,
	13098: 0x00005539,
	13099: 0x00005548,
	13100: 0x0000552D,
	13101: 0x0000553B,
	13102: 0x00005540,
	13103: 0x0000554B,
	13104: 0x0000570A,
	13105: 0x00005707,
	13106: 0x000057FB,
	13107: 0x00005814,
	13108: 0x000057E2,
	13109: 0x000057F6,
	13110: 0x000057DC,
	13111: 0x000057F4,
	13112: 0x00005800,
	13113: 0x000057ED,
	13114: 0x000057FD,
	13115: 0x00005808,
	13116: 0x000057F8,
	13117: 0x0000580B,
	13118: 0x000057F3,
	13119: 0x000057CF,
	13120: 0x00005807,
	13121: 0x000057EE,
	13122: 0x000057E3,
	13123: 0x000057F2,
	13124: 0x000057E5,
	13125: 0x000057EC,
	13126: 0x000057E1,
	13127: 0x0000580E,
	13128: 0x000057FC,
	13129: 0x00005810,
	13130: 0x000057E7,
	13131: 0x00005801,
	13132: 0x0000580C,
	13133: 0x000057F1,
	13134: 0x000057E9,
	13135: 0x000057F0,
	13136: 0x0000580D,
	13137: 0x00005804,
	13138: 0x0000595C,
	13139: 0x00005A60,
	13140: 0x00005A58,
	13141: 0x00005A55,
	13142: 0x00005A67,
	13143: 0x00005A5E,
	13144: 0x00005A38,
	13145: 0x00005A35,
	13146: 0x00005A6D,
	13147: 0x00005A50,
	13148: 0x00005A5F,
	13149: 0x00005A65,
	13150: 0x00005A6C,
	13151: 0x00005A53,
	13152: 0x00005A64,
	13153: 0x00005A57,
	13154: 0x00005A43,
	13155: 0x00005A5D,
	13156: 0x00005A52,
	13157: 0x00005A44,
	13158: 0x00005A5B,
	13159: 0x00005A48,
	13160: 0x00005A8E,
	13161: 0x00005A3E,
	13162: 0x00005A4D,
	13163: 0x00005A39,
	13164: 0x00005A4C,
	13165: 0x00005A70,
	13166: 0x00005A69,
	13167: 0x00005A47,
	13168: 0x00005A51,
	13169: 0x00005A56,
	13170: 0x00005A42,
	13171: 0x00005A5C,
	13172: 0x00005B72,
	13173: 0x00005B6E,
	13174: 0x00005BC1,
	13175: 0x00005BC0,
	13176: 0x00005C59,
	13177: 0x00005D1E,
	13178: 0x00005D0B,
	13179: 0x00005D1D,
	13180: 0x00005D1A,
	13181: 0x00005D20,
	13182: 0x00005D0C,
	13183: 0x00005D28,
	13184: 0x00005D0D,
	13185: 0x00005D26,
	13186: 0x00005D25,
	13187: 0x00005D0F,
	13188: 0x00005D30,
	13189: 0x00005D12,
	13190: 0x00005D23,
	13191: 0x00005D1F,
	13192: 0x00005D2E,
	13193: 0x00005E3E,
	13194: 0x00005E34,
	13195: 0x00005EB1,
	13196: 0x00005EB4,
	13197: 0x00005EB9,
	13198: 0x00005EB2,
	13199: 0x00005EB3,
	13200: 0x00005F36,
	13201: 0x00005F38,
	13202: 0x00005F9B,
	13203: 0x00005F96,
	13204: 0x00005F9F,
	13205: 0x0000608A,
	13206: 0x00006090,
	13207: 0x00006086,
	13208: 0x000060BE,
	13209: 0x000060B0,
	13210: 0x000060BA,
	13211: 0x000060D3,
	13212: 0x000060D4,
	13213: 0x000060CF,
	13214: 0x000060E4,
	13215: 0x000060D9,
	13216: 0x000060DD,
	13217: 0x000060C8,
	13218: 0x000060B1,
	13219: 0x000060DB,
	13220: 0x000060B7,
	13221: 0x000060CA,
	13222: 0x000060BF,
	13223: 0x000060C3,
	13224: 0x000060CD,
	13225: 0x000060C0,
	13226: 0x00006332,
	13227: 0x00006365,
	13228: 0x0000638A,
	13229: 0x00006382,
	13230: 0x0000637D,
	13231: 0x000063BD,
	13232: 0x0000639E,
	13233: 0x000063AD,
	13234: 0x0000639D,
	13235: 0x00006397,
	13236: 0x000063AB,
	13237: 0x0000638E,
	13238: 0x0000636F,
	13239: 0x00006387,
	13240: 0x00006390,
	13241: 0x0000636E,
	13242: 0x000063AF,
	13243: 0x00006375,
	13244: 0x0000639C,
	13245: 0x0000636D,
	13246: 0x000063AE,
	13247: 0x0000637C,
	13248: 0x000063A4,
	13249: 0x0000633B,
	13250: 0x0000639F,
	13251: 0x00006378,
	13252: 0x00006385,
	13253: 0x00006381,
	13254: 0x00006391,
	13255: 0x0000638D,
	13256: 0x00006370,
	13257: 0x00006553,
	13258: 0x000065CD,
	13259: 0x00006665,
	13260: 0x00006661,
	13261: 0x0000665B,
	13262: 0x00006659,
	13263: 0x0000665C,
	13264: 0x00006662,
	13265: 0x00006718,
	13266: 0x00006879,
	13267: 0x00006887,
	13268: 0x00006890,
	13269: 0x0000689C,
	13270: 0x0000686D,
	13271: 0x0000686E,
	13272: 0x000068AE,
	13273: 0x000068AB,
	13274: 0x00006956,
	13275: 0x0000686F,
	13276: 0x000068A3,
	13277: 0x000068AC,
	13278: 0x000068A9,
	13279: 0x00006875,
	13280: 0x00006874,
	13281: 0x000068B2,
	13282: 0x0000688F,
	13283: 0x00006877,
	13284: 0x00006892,
	13285: 0x0000687C,
	13286: 0x0000686B,
	13287: 0x00006872,
	13288: 0x000068AA,
	13289: 0x00006880,
	13290: 0x00006871,
	13291: 0x0000687E,
	13292: 0x0000689B,
	13293: 0x00006896,
	13294: 0x0000688B,
	13295: 0x000068A0,
	13296: 0x00006889,
	13297: 0x000068A4,
	13298: 0x00006878,
	13299: 0x0000687B,
	13300: 0x00006891,
	13301: 0x0000688C,
	13302: 0x0000688A,
	13303: 0x0000687D,
	13304: 0x00006B36,
	13305: 0x00006B33,
	13306: 0x00006B37,
	13307: 0x00006B38,
	13308: 0x00006B91,
	13309: 0x00006B8F,
	13310: 0x00006B8D,
	13311: 0x00006B8E,
	13312: 0x00006B8C,
	13313: 0x00006C2A,
	13314: 0x00006DC0,
	13315: 0x00006DAB,
	13316: 0x00006DB4,
	13317: 0x00006DB3,
	13318: 0x00006E74,
	13319: 0x00006DAC,
	13320: 0x00006DE9,
	13321: 0x00006DE2,
	13322: 0x00006DB7,
	13323: 0x00006DF6,
	13324: 0x00006DD4,
	13325: 0x00006E00,
	13326: 0x00006DC8,
	13327: 0x00006DE0,
	13328: 0x00006DDF,
	13329: 0x00006DD6,
	13330: 0x00006DBE,
	13331: 0x00006DE5,
	13332: 0x00006DDC,
	13333: 0x00006DDD,
	13334: 0x00006DDB,
	13335: 0x00006DF4,
	13336: 0x00006DCA,
	13337: 0x00006DBD,
	13338: 0x00006DED,
	13339: 0x00006DF0,
	13340: 0x00006DBA,
	13341: 0x00006DD5,
	13342: 0x00006DC2,
	13343: 0x00006DCF,
	13344: 0x00006DC9,
	13345: 0x00006DD0,
	13346: 0x00006DF2,
	13347: 0x00006DD3,
	13348: 0x00006DFD,
	13349: 0x00006DD7,
	13350: 0x00006DCD,
	13351: 0x00006DE3,
	13352: 0x00006DBB,
	13353: 0x000070FA,
	13354: 0x0000710D,
	13355: 0x000070F7,
	13356: 0x00007117,
	13357: 0x000070F4,
	13358: 0x0000710C,
	13359: 0x000070F0,
	13360: 0x00007104,
	13361: 0x000070F3,
	13362: 0x00007110,
	13363: 0x000070FC,
	13364: 0x000070FF,
	13365: 0x00007106,
	13366: 0x00007113,
	13367: 0x00007100,
	13368: 0x000070F8,
	13369: 0x000070F6,
	13370: 0x0000710B,
	13371: 0x00007102,
	13372: 0x0000710E,
	13373: 0x0000727E,
	13374: 0x0000727B,
	13375: 0x0000727C,
	13376: 0x0000727F,
	13377: 0x0000731D,
	13378: 0x00007317,
	13379: 0x00007307,
	13380: 0x00007311,
	13381: 0x00007318,
	13382: 0x0000730A,
	13383: 0x00007308,
	13384: 0x000072FF,
	13385: 0x0000730F,
	13386: 0x0000731E,
	13387: 0x00007388,
	13388: 0x000073F6,
	13389: 0x000073F8,
	13390: 0x000073F5,
	13391: 0x00007404,
	13392: 0x00007401,
	13393: 0x000073FD,
	13394: 0x00007407,
	13395: 0x00007400,
	13396: 0x000073FA,
	13397: 0x000073FC,
	13398: 0x000073FF,
	13399: 0x0000740C,
	13400: 0x0000740B,
	13401: 0x000073F4,
	13402: 0x00007408,
	13403: 0x00007564,
	13404: 0x00007563,
	13405: 0x000075CE,
	13406: 0x000075D2,
	13407: 0x000075CF,
	13408: 0x000075CB,
	13409: 0x000075CC,
	13410: 0x000075D1,
	13411: 0x000075D0,
	13412: 0x0000768F,
	13413: 0x00007689,
	13414: 0x000076D3,
	13415: 0x00007739,
	13416: 0x0000772F,
	13417: 0x0000772D,
	13418: 0x00007731,
	13419: 0x00007732,
	13420: 0x00007734,
	13421: 0x00007733,
	13422: 0x0000773D,
	13423: 0x00007725,
	13424: 0x0000773B,
	13425: 0x00007735,
	13426: 0x00007848,
	13427: 0x00007852,
	13428: 0x00007849,
	13429: 0x0000784D,
	13430: 0x0000784A,
	13431: 0x0000784C,
	13432: 0x00007826,
	13433: 0x00007845,
	13434: 0x00007850,
	13435: 0x00007964,
	13436: 0x00007967,
	13437: 0x00007969,
	13438: 0x0000796A,
	13439: 0x00007963,
	13440: 0x0000796B,
	13441: 0x00007961,
	13442: 0x000079BB,
	13443: 0x000079FA,
	13444: 0x000079F8,
	13445: 0x000079F6,
	13446: 0x000079F7,
	13447: 0x00007A8F,
	13448: 0x00007A94,
	13449: 0x00007A90,
	13450: 0x00007B35,
	13451: 0x00007B47,
	13452: 0x00007B34,
	13453: 0x00007B25,
	13454: 0x00007B30,
	13455: 0x00007B22,
	13456: 0x00007B24,
	13457: 0x00007B33,
	13458: 0x00007B18,
	13459: 0x00007B2A,
	13460: 0x00007B1D,
	13461: 0x00007B31,
	13462: 0x00007B2B,
	13463: 0x00007B2D,
	13464: 0x00007B2F,
	13465: 0x00007B32,
	13466: 0x00007B38,
	13467: 0x00007B1A,
	13468: 0x00007B23,
	13469: 0x00007C94,
	13470: 0x00007C98,
	13471: 0x00007C96,
	13472: 0x00007CA3,
	13473: 0x00007D35,
	13474: 0x00007D3D,
	13475: 0x00007D38,
	13476: 0x00007D36,
	13477: 0x00007D3A,
	13478: 0x00007D45,
	13479: 0x00007D2C,
	13480: 0x00007D29,
	13481: 0x00007D41,
	13482: 0x00007D47,
	13483: 0x00007D3E,
	13484: 0x00007D3F,
	13485: 0x00007D4A,
	13486: 0x00007D3B,
	13487: 0x00007D28,
	13488: 0x00007F63,
	13489: 0x00007F95,
	13490: 0x00007F9C,
	13491: 0x00007F9D,
	13492: 0x00007F9B,
	13493: 0x00007FCA,
	13494: 0x00007FCB,
	13495: 0x00007FCD,
	13496: 0x00007FD0,
	13497: 0x00007FD1,
	13498: 0x00007FC7,
	13499: 0x00007FCF,
	13500: 0x00007FC9,
	13501: 0x0000801F,
	13502: 0x0000801E,
	13503: 0x0000801B,
	13504: 0x00008047,
	13505: 0x00008043,
	13506: 0x00008048,
	13507: 0x00008118,
	13508: 0x00008125,
	13509: 0x00008119,
	13510: 0x0000811B,
	13511: 0x0000812D,
	13512: 0x0000811F,
	13513: 0x0000812C,
	13514: 0x0000811E,
	13515: 0x00008121,
	13516: 0x00008115,
	13517: 0x00008127,
	13518: 0x0000811D,
	13519: 0x00008122,
	13520: 0x00008211,
	13521: 0x00008238,
	13522: 0x00008233,
	13523: 0x0000823A,
	13524: 0x00008234,
	13525: 0x00008232,
	13526: 0x00008274,
	13527: 0x00008390,
	13528: 0x000083A3,
	13529: 0x000083A8,
	13530: 0x0000838D,
	13531: 0x0000837A,
	13532: 0x00008373,
	13533: 0x000083A4,
	13534: 0x00008374,
	13535: 0x0000838F,
	13536: 0x00008381,
	13537: 0x00008395,
	13538: 0x00008399,
	13539: 0x00008375,
	13540: 0x00008394,
	13541: 0x000083A9,
	13542: 0x0000837D,
	13543: 0x00008383,
	13544: 0x0000838C,
	13545: 0x0000839D,
	13546: 0x0000839B,
	13547: 0x000083AA,
	13548: 0x0000838B,
	13549: 0x0000837E,
	13550: 0x000083A5,
	13551: 0x000083AF,
	13552: 0x00008388,
	13553: 0x00008397,
	13554: 0x000083B0,
	13555: 0x0000837F,
	13556: 0x000083A6,
	13557: 0x00008387,
	13558: 0x000083AE,
	13559: 0x00008376,
	13560: 0x0000839A,
	13561: 0x00008659,
	13562: 0x00008656,
	13563: 0x000086BF,
	13564: 0x000086B7,
	13565: 0x000086C2,
	13566: 0x000086C1,
	13567: 0x000086C5,
	13568: 0x000086BA,
	13569: 0x000086B0,
	13570: 0x000086C8,
	13571: 0x000086B9,
	13572: 0x000086B3,
	13573: 0x000086B8,
	13574: 0x000086CC,
	13575: 0x000086B4,
	13576: 0x000086BB,
	13577: 0x000086BC,
	13578: 0x000086C3,
	13579: 0x000086BD,
	13580: 0x000086BE,
	13581: 0x00008852,
	13582: 0x00008889,
	13583: 0x00008895,
	13584: 0x000088A8,
	13585: 0x000088A2,
	13586: 0x000088AA,
	13587: 0x0000889A,
	13588: 0x00008891,
	13589: 0x000088A1,
	13590: 0x0000889F,
	13591: 0x00008898,
	13592: 0x000088A7,
	13593: 0x00008899,
	13594: 0x0000889B,
	13595: 0x00008897,
	13596: 0x000088A4,
	13597: 0x000088AC,
	13598: 0x0000888C,
	13599: 0x00008893,
	13600: 0x0000888E,
	13601: 0x00008982,
	13602: 0x000089D6,
	13603: 0x000089D9,
	13604: 0x000089D5,
	13605: 0x00008A30,
	13606: 0x00008A27,
	13607: 0x00008A2C,
	13608: 0x00008A1E,
	13609: 0x00008C39,
	13610: 0x00008C3B,
	13611: 0x00008C5C,
	13612: 0x00008C5D,
	13613: 0x00008C7D,
	13614: 0x00008CA5,
	13615: 0x00008D7D,
	13616: 0x00008D7B,
	13617: 0x00008D79,
	13618: 0x00008DBC,
	13619: 0x00008DC2,
	13620: 0x00008DB9,
	13621: 0x00008DBF,
	13622: 0x00008DC1,
	13623: 0x00008ED8,
	13624: 0x00008EDE,
	13625: 0x00008EDD,
	13626: 0x00008EDC,
	13627: 0x00008ED7,
	13628: 0x00008EE0,
	13629: 0x00008EE1,
	13630: 0x00009024,
	13631: 0x0000900B,
	13632: 0x00009011,
	13633: 0x0000901C,
	13634: 0x0000900C,
	13635: 0x00009021,
	13636: 0x000090EF,
	13637: 0x000090EA,
	13638: 0x000090F0,
	13639: 0x000090F4,
	13640: 0x000090F2,
	13641: 0x000090F3,
	13642: 0x000090D4,
	13643: 0x000090EB,
	13644: 0x000090EC,
	13645: 0x000090E9,
	13646: 0x00009156,
	13647: 0x00009158,
	13648: 0x0000915A,
	13649: 0x00009153,
	13650: 0x00009155,
	13651: 0x000091EC,
	13652: 0x000091F4,
	13653: 0x000091F1,
	13654: 0x000091F3,
	13655: 0x000091F8,
	13656: 0x000091E4,
	13657: 0x000091F9,
	13658: 0x000091EA,
	13659: 0x000091EB,
	13660: 0x000091F7,
	13661: 0x000091E8,
	13662: 0x000091EE,
	13663: 0x0000957A,
	13664: 0x00009586,
	13665: 0x00009588,
	13666: 0x0000967C,
	13667: 0x0000966D,
	13668: 0x0000966B,
	13669: 0x00009671,
	13670: 0x0000966F,
	13671: 0x000096BF,
	13672: 0x0000976A,
	13673: 0x00009804,
	13674: 0x000098E5,
	13675: 0x00009997,
	13676: 0x0000509B,
	13677: 0x00005095,
	13678: 0x00005094,
	13679: 0x0000509E,
	13680: 0x0000508B,
	13681: 0x000050A3,
	13682: 0x00005083,
	13683: 0x0000508C,
	13684: 0x0000508E,
	13685: 0x0000509D,
	13686: 0x00005068,
	13687: 0x0000509C,
	13688: 0x00005092,
	13689: 0x00005082,
	13690: 0x00005087,
	13691: 0x0000515F,
	13692: 0x000051D4,
	13693: 0x00005312,
	13694: 0x00005311,
	13695: 0x000053A4,
	13696: 0x000053A7,
	13697: 0x00005591,
	13698: 0x000055A8,
	13699: 0x000055A5,
	13700: 0x000055AD,
	13701: 0x00005577,
	13702: 0x00005645,
	13703: 0x000055A2,
	13704: 0x00005593,
	13705: 0x00005588,
	13706: 0x0000558F,
	13707: 0x000055B5,
	13708: 0x00005581,
	13709: 0x000055A3,
	13710: 0x00005592,
	13711: 0x000055A4,
	13712: 0x0000557D,
	13713: 0x0000558C,
	13714: 0x000055A6,
	13715: 0x0000557F,
	13716: 0x00005595,
	13717: 0x000055A1,
	13718: 0x0000558E,
	13719: 0x0000570C,
	13720: 0x00005829,
	13721: 0x00005837,
	13722: 0x00005819,
	13723: 0x0000581E,
	13724: 0x00005827,
	13725: 0x00005823,
	13726: 0x00005828,
	13727: 0x000057F5,
	13728: 0x00005848,
	13729: 0x00005825,
	13730: 0x0000581C,
	13731: 0x0000581B,
	13732: 0x00005833,
	13733: 0x0000583F,
	13734: 0x00005836,
	13735: 0x0000582E,
	13736: 0x00005839,
	13737: 0x00005838,
	13738: 0x0000582D,
	13739: 0x0000582C,
	13740: 0x0000583B,
	13741: 0x00005961,
	13742: 0x00005AAF,
	13743: 0x00005A94,
	13744: 0x00005A9F,
	13745: 0x00005A7A,
	13746: 0x00005AA2,
	13747: 0x00005A9E,
	13748: 0x00005A78,
	13749: 0x00005AA6,
	13750: 0x00005A7C,
	13751: 0x00005AA5,
	13752: 0x00005AAC,
	13753: 0x00005A95,
	13754: 0x00005AAE,
	13755: 0x00005A37,
	13756: 0x00005A84,
	13757: 0x00005A8A,
	13758: 0x00005A97,
	13759: 0x00005A83,
	13760: 0x00005A8B,
	13761: 0x00005AA9,
	13762: 0x00005A7B,
	13763: 0x00005A7D,
	13764: 0x00005A8C,
	13765: 0x00005A9C,
	13766: 0x00005A8F,
	13767: 0x00005A93,
	13768: 0x00005A9D,
	13769: 0x00005BEA,
	13770: 0x00005BCD,
	13771: 0x00005BCB,
	13772: 0x00005BD4,
	13773: 0x00005BD1,
	13774: 0x00005BCA,
	13775: 0x00005BCE,
	13776: 0x00005C0C,
	13777: 0x00005C30,
	13778: 0x00005D37,
	13779: 0x00005D43,
	13780: 0x00005D6B,
	13781: 0x00005D41,
	13782: 0x00005D4B,
	13783: 0x00005D3F,
	13784: 0x00005D35,
	13785: 0x00005D51,
	13786: 0x00005D4E,
	13787: 0x00005D55,
	13788: 0x00005D33,
	13789: 0x00005D3A,
	13790: 0x00005D52,
	13791: 0x00005D3D,
	13792: 0x00005D31,
	13793: 0x00005D59,
	13794: 0x00005D42,
	13795: 0x00005D39,
	13796: 0x00005D49,
	13797: 0x00005D38,
	13798: 0x00005D3C,
	13799: 0x00005D32,
	13800: 0x00005D36,
	13801: 0x00005D40,
	13802: 0x00005D45,
	13803: 0x00005E44,
	13804: 0x00005E41,
	13805: 0x00005F58,
	13806: 0x00005FA6,
	13807: 0x00005FA5,
	13808: 0x00005FAB,
	13809: 0x000060C9,
	13810: 0x000060B9,
	13811: 0x000060CC,
	13812: 0x000060E2,
	13813: 0x000060CE,
	13814: 0x000060C4,
	13815: 0x00006114,
	13816: 0x000060F2,
	13817: 0x0000610A,
	13818: 0x00006116,
	13819: 0x00006105,
	13820: 0x000060F5,
	13821: 0x00006113,
	13822: 0x000060F8,
	13823: 0x000060FC,
	13824: 0x000060FE,
	13825: 0x000060C1,
	13826: 0x00006103,
	13827: 0x00006118,
	13828: 0x0000611D,
	13829: 0x00006110,
	13830: 0x000060FF,
	13831: 0x00006104,
	13832: 0x0000610B,
	13833: 0x0000624A,
	13834: 0x00006394,
	13835: 0x000063B1,
	13836: 0x000063B0,
	13837: 0x000063CE,
	13838: 0x000063E5,
	13839: 0x000063E8,
	13840: 0x000063EF,
	13841: 0x000063C3,
	13842: 0x0000649D,
	13843: 0x000063F3,
	13844: 0x000063CA,
	13845: 0x000063E0,
	13846: 0x000063F6,
	13847: 0x000063D5,
	13848: 0x000063F2,
	13849: 0x000063F5,
	13850: 0x00006461,
	13851: 0x000063DF,
	13852: 0x000063BE,
	13853: 0x000063DD,
	13854: 0x000063DC,
	13855: 0x000063C4,
	13856: 0x000063D8,
	13857: 0x000063D3,
	13858: 0x000063C2,
	13859: 0x000063C7,
	13860: 0x000063CC,
	13861: 0x000063CB,
	13862: 0x000063C8,
	13863: 0x000063F0,
	13864: 0x000063D7,
	13865: 0x000063D9,
	13866: 0x00006532,
	13867: 0x00006567,
	13868: 0x0000656A,
	13869: 0x00006564,
	13870: 0x0000655C,
	13871: 0x00006568,
	13872: 0x00006565,
	13873: 0x0000658C,
	13874: 0x0000659D,
	13875: 0x0000659E,
	13876: 0x000065AE,
	13877: 0x000065D0,
	13878: 0x000065D2,
	13879: 0x0000667C,
	13880: 0x0000666C,
	13881: 0x0000667B,
	13882: 0x00006680,
	13883: 0x00006671,
	13884: 0x00006679,
	13885: 0x0000666A,
	13886: 0x00006672,
	13887: 0x00006701,
	13888: 0x0000690C,
	13889: 0x000068D3,
	13890: 0x00006904,
	13891: 0x000068DC,
	13892: 0x0000692A,
	13893: 0x000068EC,
	13894: 0x000068EA,
	13895: 0x000068F1,
	13896: 0x0000690F,
	13897: 0x000068D6,
	13898: 0x000068F7,
	13899: 0x000068EB,
	13900: 0x000068E4,
	13901: 0x000068F6,
	13902: 0x00006913,
	13903: 0x00006910,
	13904: 0x000068F3,
	13905: 0x000068E1,
	13906: 0x00006907,
	13907: 0x000068CC,
	13908: 0x00006908,
	13909: 0x00006970,
	13910: 0x000068B4,
	13911: 0x00006911,
	13912: 0x000068EF,
	13913: 0x000068C6,
	13914: 0x00006914,
	13915: 0x000068F8,
	13916: 0x000068D0,
	13917: 0x000068FD,
	13918: 0x000068FC,
	13919: 0x000068E8,
	13920: 0x0000690B,
	13921: 0x0000690A,
	13922: 0x00006917,
	13923: 0x000068CE,
	13924: 0x000068C8,
	13925: 0x000068DD,
	13926: 0x000068DE,
	13927: 0x000068E6,
	13928: 0x000068F4,
	13929: 0x000068D1,
	13930: 0x00006906,
	13931: 0x000068D4,
	13932: 0x000068E9,
	13933: 0x00006915,
	13934: 0x00006925,
	13935: 0x000068C7,
	13936: 0x00006B39,
	13937: 0x00006B3B,
	13938: 0x00006B3F,
	13939: 0x00006B3C,
	13940: 0x00006B94,
	13941: 0x00006B97,
	13942: 0x00006B99,
	13943: 0x00006B95,
	13944: 0x00006BBD,
	13945: 0x00006BF0,
	13946: 0x00006BF2,
	13947: 0x00006BF3,
	13948: 0x00006C30,
	13949: 0x00006DFC,
	13950: 0x00006E46,
	13951: 0x00006E47,
	13952: 0x00006E1F,
	13953: 0x00006E49,
	13954: 0x00006E88,
	13955: 0x00006E3C,
	13956: 0x00006E3D,
	13957: 0x00006E45,
	13958: 0x00006E62,
	13959: 0x00006E2B,
	13960: 0x00006E3F,
	13961: 0x00006E41,
	13962: 0x00006E5D,
	13963: 0x00006E73,
	13964: 0x00006E1C,
	13965: 0x00006E33,
	13966: 0x00006E4B,
	13967: 0x00006E40,
	13968: 0x00006E51,
	13969: 0x00006E3B,
	13970: 0x00006E03,
	13971: 0x00006E2E,
	13972: 0x00006E5E,
	13973: 0x00006E68,
	13974: 0x00006E5C,
	13975: 0x00006E61,
	13976: 0x00006E31,
	13977: 0x00006E28,
	13978: 0x00006E60,
	13979: 0x00006E71,
	13980: 0x00006E6B,
	13981: 0x00006E39,
	13982: 0x00006E22,
	13983: 0x00006E30,
	13984: 0x00006E53,
	13985: 0x00006E65,
	13986: 0x00006E27,
	13987: 0x00006E78,
	13988: 0x00006E64,
	13989: 0x00006E77,
	13990: 0x00006E55,
	13991: 0x00006E79,
	13992: 0x00006E52,
	13993: 0x00006E66,
	13994: 0x00006E35,
	13995: 0x00006E36,
	13996: 0x00006E5A,
	13997: 0x00007120,
	13998: 0x0000711E,
	13999: 0x0000712F,
	14000: 0x000070FB,
	14001: 0x0000712E,
	14002: 0x00007131,
	14003: 0x00007123,
	14004: 0x00007125,
	14005: 0x00007122,
	14006: 0x00007132,
	14007: 0x0000711F,
	14008: 0x00007128,
	14009: 0x0000713A,
	14010: 0x0000711B,
	14011: 0x0000724B,
	14012: 0x0000725A,
	14013: 0x00007288,
	14014: 0x00007289,
	14015: 0x00007286,
	14016: 0x00007285,
	14017: 0x0000728B,
	14018: 0x00007312,
	14019: 0x0000730B,
	14020: 0x00007330,
	14021: 0x00007322,
	14022: 0x00007331,
	14023: 0x00007333,
	14024: 0x00007327,
	14025: 0x00007332,
	14026: 0x0000732D,
	14027: 0x00007326,
	14028: 0x00007323,
	14029: 0x00007335,
	14030: 0x0000730C,
	14031: 0x0000742E,
	14032: 0x0000742C,
	14033: 0x00007430,
	14034: 0x0000742B,
	14035: 0x00007416,
	14036: 0x0000741A,
	14037: 0x00007421,
	14038: 0x0000742D,
	14039: 0x00007431,
	14040: 0x00007424,
	14041: 0x00007423,
	14042: 0x0000741D,
	14043: 0x00007429,
	14044: 0x00007420,
	14045: 0x00007432,
	14046: 0x000074FB,
	14047: 0x0000752F,
	14048: 0x0000756F,
	14049: 0x0000756C,
	14050: 0x000075E7,
	14051: 0x000075DA,
	14052: 0x000075E1,
	14053: 0x000075E6,
	14054: 0x000075DD,
	14055: 0x000075DF,
	14056: 0x000075E4,
	14057: 0x000075D7,
	14058: 0x00007695,
	14059: 0x00007692,
	14060: 0x000076DA,
	14061: 0x00007746,
	14062: 0x00007747,
	14063: 0x00007744,
	14064: 0x0000774D,
	14065: 0x00007745,
	14066: 0x0000774A,
	14067: 0x0000774E,
	14068: 0x0000774B,
	14069: 0x0000774C,
	14070: 0x000077DE,
	14071: 0x000077EC,
	14072: 0x00007860,
	14073: 0x00007864,
	14074: 0x00007865,
	14075: 0x0000785C,
	14076: 0x0000786D,
	14077: 0x00007871,
	14078: 0x0000786A,
	14079: 0x0000786E,
	14080: 0x00007870,
	14081: 0x00007869,
	14082: 0x00007868,
	14083: 0x0000785E,
	14084: 0x00007862,
	14085: 0x00007974,
	14086: 0x00007973,
	14087: 0x00007972,
	14088: 0x00007970,
	14089: 0x00007A02,
	14090: 0x00007A0A,
	14091: 0x00007A03,
	14092: 0x00007A0C,
	14093: 0x00007A04,
	14094: 0x00007A99,
	14095: 0x00007AE6,
	14096: 0x00007AE4,
	14097: 0x00007B4A,
	14098: 0x00007B3B,
	14099: 0x00007B44,
	14100: 0x00007B48,
	14101: 0x00007B4C,
	14102: 0x00007B4E,
	14103: 0x00007B40,
	14104: 0x00007B58,
	14105: 0x00007B45,
	14106: 0x00007CA2,
	14107: 0x00007C9E,
	14108: 0x00007CA8,
	14109: 0x00007CA1,
	14110: 0x00007D58,
	14111: 0x00007D6F,
	14112: 0x00007D63,
	14113: 0x00007D53,
	14114: 0x00007D56,
	14115: 0x00007D67,
	14116: 0x00007D6A,
	14117: 0x00007D4F,
	14118: 0x00007D6D,
	14119: 0x00007D5C,
	14120: 0x00007D6B,
	14121: 0x00007D52,
	14122: 0x00007D54,
	14123: 0x00007D69,
	14124: 0x00007D51,
	14125: 0x00007D5F,
	14126: 0x00007D4E,
	14127: 0x00007F3E,
	14128: 0x00007F3F,
	14129: 0x00007F65,
	14130: 0x00007F66,
	14131: 0x00007FA2,
	14132: 0x00007FA0,
	14133: 0x00007FA1,
	14134: 0x00007FD7,
	14135: 0x00008051,
	14136: 0x0000804F,
	14137: 0x00008050,
	14138: 0x000080FE,
	14139: 0x000080D4,
	14140: 0x00008143,
	14141: 0x0000814A,
	14142: 0x00008152,
	14143: 0x0000814F,
	14144: 0x00008147,
	14145: 0x0000813D,
	14146: 0x0000814D,
	14147: 0x0000813A,
	14148: 0x000081E6,
	14149: 0x000081EE,
	14150: 0x000081F7,
	14151: 0x000081F8,
	14152: 0x000081F9,
	14153: 0x00008204,
	14154: 0x0000823C,
	14155: 0x0000823D,
	14156: 0x0000823F,
	14157: 0x00008275,
	14158: 0x0000833B,
	14159: 0x000083CF,
	14160: 0x000083F9,
	14161: 0x00008423,
	14162: 0x000083C0,
	14163: 0x000083E8,
	14164: 0x00008412,
	14165: 0x000083E7,
	14166: 0x000083E4,
	14167: 0x000083FC,
	14168: 0x000083F6,
	14169: 0x00008410,
	14170: 0x000083C6,
	14171: 0x000083C8,
	14172: 0x000083EB,
	14173: 0x000083E3,
	14174: 0x000083BF,
	14175: 0x00008401,
	14176: 0x000083DD,
	14177: 0x000083E5,
	14178: 0x000083D8,
	14179: 0x000083FF,
	14180: 0x000083E1,
	14181: 0x000083CB,
	14182: 0x000083CE,
	14183: 0x000083D6,
	14184: 0x000083F5,
	14185: 0x000083C9,
	14186: 0x00008409,
	14187: 0x0000840F,
	14188: 0x000083DE,
	14189: 0x00008411,
	14190: 0x00008406,
	14191: 0x000083C2,
	14192: 0x000083F3,
	14193: 0x000083D5,
	14194: 0x000083FA,
	14195: 0x000083C7,
	14196: 0x000083D1,
	14197: 0x000083EA,
	14198: 0x00008413,
	14199: 0x000083C3,
	14200: 0x000083EC,
	14201: 0x000083EE,
	14202: 0x000083C4,
	14203: 0x000083FB,
	14204: 0x000083D7,
	14205: 0x000083E2,
	14206: 0x0000841B,
	14207: 0x000083DB,
	14208: 0x000083FE,
	14209: 0x000086D8,
	14210: 0x000086E2,
	14211: 0x000086E6,
	14212: 0x000086D3,
	14213: 0x000086E3,
	14214: 0x000086DA,
	14215: 0x000086EA,
	14216: 0x000086DD,
	14217: 0x000086EB,
	14218: 0x000086DC,
	14219: 0x000086EC,
	14220: 0x000086E9,
	14221: 0x000086D7,
	14222: 0x000086E8,
	14223: 0x000086D1,
	14224: 0x00008848,
	14225: 0x00008856,
	14226: 0x00008855,
	14227: 0x000088BA,
	14228: 0x000088D7,
	14229: 0x000088B9,
	14230: 0x000088B8,
	14231: 0x000088C0,
	14232: 0x000088BE,
	14233: 0x000088B6,
	14234: 0x000088BC,
	14235: 0x000088B7,
	14236: 0x000088BD,
	14237: 0x000088B2,
	14238: 0x00008901,
	14239: 0x000088C9,
	14240: 0x00008995,
	14241: 0x00008998,
	14242: 0x00008997,
	14243: 0x000089DD,
	14244: 0x000089DA,
	14245: 0x000089DB,
	14246: 0x00008A4E,
	14247: 0x00008A4D,
	14248: 0x00008A39,
	14249: 0x00008A59,
	14250: 0x00008A40,
	14251: 0x00008A57,
	14252: 0x00008A58,
	14253: 0x00008A44,
	14254: 0x00008A45,
	14255: 0x00008A52,
	14256: 0x00008A48,
	14257: 0x00008A51,
	14258: 0x00008A4A,
	14259: 0x00008A4C,
	14260: 0x00008A4F,
	14261: 0x00008C5F,
	14262: 0x00008C81,
	14263: 0x00008C80,
	14264: 0x00008CBA,
	14265: 0x00008CBE,
	14266: 0x00008CB0,
	14267: 0x00008CB9,
	14268: 0x00008CB5,
	14269: 0x00008D84,
	14270: 0x00008D80,
	14271: 0x00008D89,
	14272: 0x00008DD8,
	14273: 0x00008DD3,
	14274: 0x00008DCD,
	14275: 0x00008DC7,
	14276: 0x00008DD6,
	14277: 0x00008DDC,
	14278: 0x00008DCF,
	14279: 0x00008DD5,
	14280: 0x00008DD9,
	14281: 0x00008DC8,
	14282: 0x00008DD7,
	14283: 0x00008DC5,
	14284: 0x00008EEF,
	14285: 0x00008EF7,
	14286: 0x00008EFA,
	14287: 0x00008EF9,
	14288: 0x00008EE6,
	14289: 0x00008EEE,
	14290: 0x00008EE5,
	14291: 0x00008EF5,
	14292: 0x00008EE7,
	14293: 0x00008EE8,
	14294: 0x00008EF6,
	14295: 0x00008EEB,
	14296: 0x00008EF1,
	14297: 0x00008EEC,
	14298: 0x00008EF4,
	14299: 0x00008EE9,
	14300: 0x0000902D,
	14301: 0x00009034,
	14302: 0x0000902F,
	14303: 0x00009106,
	14304: 0x0000912C,
	14305: 0x00009104,
	14306: 0x000090FF,
	14307: 0x000090FC,
	14308: 0x00009108,
	14309: 0x000090F9,
	14310: 0x000090FB,
	14311: 0x00009101,
	14312: 0x00009100,
	14313: 0x00009107,
	14314: 0x00009105,
	14315: 0x00009103,
	14316: 0x00009161,
	14317: 0x00009164,
	14318: 0x0000915F,
	14319: 0x00009162,
	14320: 0x00009160,
	14321: 0x00009201,
	14322: 0x0000920A,
	14323: 0x00009225,
	14324: 0x00009203,
	14325: 0x0000921A,
	14326: 0x00009226,
	14327: 0x0000920F,
	14328: 0x0000920C,
	14329: 0x00009200,
	14330: 0x00009212,
	14331: 0x000091FF,
	14332: 0x000091FD,
	14333: 0x00009206,
	14334: 0x00009204,
	14335: 0x00009227,
	14336: 0x00009202,
	14337: 0x0000921C,
	14338: 0x00009224,
	14339: 0x00009219,
	14340: 0x00009217,
	14341: 0x00009205,
	14342: 0x00009216,
	14343: 0x0000957B,
	14344: 0x0000958D,
	14345: 0x0000958C,
	14346: 0x00009590,
	14347: 0x00009687,
	14348: 0x0000967E,
	14349: 0x00009688,
	14350: 0x00009689,
	14351: 0x00009683,
	14352: 0x00009680,
	14353: 0x000096C2,
	14354: 0x000096C8,
	14355: 0x000096C3,
	14356: 0x000096F1,
	14357: 0x000096F0,
	14358: 0x0000976C,
	14359: 0x00009770,
	14360: 0x0000976E,
	14361: 0x00009807,
	14362: 0x000098A9,
	14363: 0x000098EB,
	14364: 0x00009CE6,
	14365: 0x00009EF9,
	14366: 0x00004E83,
	14367: 0x00004E84,
	14368: 0x00004EB6,
	14369: 0x000050BD,
	14370: 0x000050BF,
	14371: 0x000050C6,
	14372: 0x000050AE,
	14373: 0x000050C4,
	14374: 0x000050CA,
	14375: 0x000050B4,
	14376: 0x000050C8,
	14377: 0x000050C2,
	14378: 0x000050B0,
	14379: 0x000050C1,
	14380: 0x000050BA,
	14381: 0x000050B1,
	14382: 0x000050CB,
	14383: 0x000050C9,
	14384: 0x000050B6,
	14385: 0x000050B8,
	14386: 0x000051D7,
	14387: 0x0000527A,
	14388: 0x00005278,
	14389: 0x0000527B,
	14390: 0x0000527C,
	14391: 0x000055C3,
	14392: 0x000055DB,
	14393: 0x000055CC,
	14394: 0x000055D0,
	14395: 0x000055CB,
	14396: 0x000055CA,
	14397: 0x000055DD,
	14398: 0x000055C0,
	14399: 0x000055D4,
	14400: 0x000055C4,
	14401: 0x000055E9,
	14402: 0x000055BF,
	14403: 0x000055D2,
	14404: 0x0000558D,
	14405: 0x000055CF,
	14406: 0x000055D5,
	14407: 0x000055E2,
	14408: 0x000055D6,
	14409: 0x000055C8,
	14410: 0x000055F2,
	14411: 0x000055CD,
	14412: 0x000055D9,
	14413: 0x000055C2,
	14414: 0x00005714,
	14415: 0x00005853,
	14416: 0x00005868,
	14417: 0x00005864,
	14418: 0x0000584F,
	14419: 0x0000584D,
	14420: 0x00005849,
	14421: 0x0000586F,
	14422: 0x00005855,
	14423: 0x0000584E,
	14424: 0x0000585D,
	14425: 0x00005859,
	14426: 0x00005865,
	14427: 0x0000585B,
	14428: 0x0000583D,
	14429: 0x00005863,
	14430: 0x00005871,
	14431: 0x000058FC,
	14432: 0x00005AC7,
	14433: 0x00005AC4,
	14434: 0x00005ACB,
	14435: 0x00005ABA,
	14436: 0x00005AB8,
	14437: 0x00005AB1,
	14438: 0x00005AB5,
	14439: 0x00005AB0,
	14440: 0x00005ABF,
	14441: 0x00005AC8,
	14442: 0x00005ABB,
	14443: 0x00005AC6,
	14444: 0x00005AB7,
	14445: 0x00005AC0,
	14446: 0x00005ACA,
	14447: 0x00005AB4,
	14448: 0x00005AB6,
	14449: 0x00005ACD,
	14450: 0x00005AB9,
	14451: 0x00005A90,
	14452: 0x00005BD6,
	14453: 0x00005BD8,
	14454: 0x00005BD9,
	14455: 0x00005C1F,
	14456: 0x00005C33,
	14457: 0x00005D71,
	14458: 0x00005D63,
	14459: 0x00005D4A,
	14460: 0x00005D65,
	14461: 0x00005D72,
	14462: 0x00005D6C,
	14463: 0x00005D5E,
	14464: 0x00005D68,
	14465: 0x00005D67,
	14466: 0x00005D62,
	14467: 0x00005DF0,
	14468: 0x00005E4F,
	14469: 0x00005E4E,
	14470: 0x00005E4A,
	14471: 0x00005E4D,
	14472: 0x00005E4B,
	14473: 0x00005EC5,
	14474: 0x00005ECC,
	14475: 0x00005EC6,
	14476: 0x00005ECB,
	14477: 0x00005EC7,
	14478: 0x00005F40,
	14479: 0x00005FAF,
	14480: 0x00005FAD,
	14481: 0x000060F7,
	14482: 0x00006149,
	14483: 0x0000614A,
	14484: 0x0000612B,
	14485: 0x00006145,
	14486: 0x00006136,
	14487: 0x00006132,
	14488: 0x0000612E,
	14489: 0x00006146,
	14490: 0x0000612F,
	14491: 0x0000614F,
	14492: 0x00006129,
	14493: 0x00006140,
	14494: 0x00006220,
	14495: 0x00009168,
	14496: 0x00006223,
	14497: 0x00006225,
	14498: 0x00006224,
	14499: 0x000063C5,
	14500: 0x000063F1,
	14501: 0x000063EB,
	14502: 0x00006410,
	14503: 0x00006412,
	14504: 0x00006409,
	14505: 0x00006420,
	14506: 0x00006424,
	14507: 0x00006433,
	14508: 0x00006443,
	14509: 0x0000641F,
	14510: 0x00006415,
	14511: 0x00006418,
	14512: 0x00006439,
	14513: 0x00006437,
	14514: 0x00006422,
	14515: 0x00006423,
	14516: 0x0000640C,
	14517: 0x00006426,
	14518: 0x00006430,
	14519: 0x00006428,
	14520: 0x00006441,
	14521: 0x00006435,
	14522: 0x0000642F,
	14523: 0x0000640A,
	14524: 0x0000641A,
	14525: 0x00006440,
	14526: 0x00006425,
	14527: 0x00006427,
	14528: 0x0000640B,
	14529: 0x000063E7,
	14530: 0x0000641B,
	14531: 0x0000642E,
	14532: 0x00006421,
	14533: 0x0000640E,
	14534: 0x0000656F,
	14535: 0x00006592,
	14536: 0x000065D3,
	14537: 0x00006686,
	14538: 0x0000668C,
	14539: 0x00006695,
	14540: 0x00006690,
	14541: 0x0000668B,
	14542: 0x0000668A,
	14543: 0x00006699,
	14544: 0x00006694,
	14545: 0x00006678,
	14546: 0x00006720,
	14547: 0x00006966,
	14548: 0x0000695F,
	14549: 0x00006938,
	14550: 0x0000694E,
	14551: 0x00006962,
	14552: 0x00006971,
	14553: 0x0000693F,
	14554: 0x00006945,
	14555: 0x0000696A,
	14556: 0x00006939,
	14557: 0x00006942,
	14558: 0x00006957,
	14559: 0x00006959,
	14560: 0x0000697A,
	14561: 0x00006948,
	14562: 0x00006949,
	14563: 0x00006935,
	14564: 0x0000696C,
	14565: 0x00006933,
	14566: 0x0000693D,
	14567: 0x00006965,
	14568: 0x000068F0,
	14569: 0x00006978,
	14570: 0x00006934,
	14571: 0x00006969,
	14572: 0x00006940,
	14573: 0x0000696F,
	14574: 0x00006944,
	14575: 0x00006976,
	14576: 0x00006958,
	14577: 0x00006941,
	14578: 0x00006974,
	14579: 0x0000694C,
	14580: 0x0000693B,
	14581: 0x0000694B,
	14582: 0x00006937,
	14583: 0x0000695C,
	14584: 0x0000694F,
	14585: 0x00006951,
	14586: 0x00006932,
	14587: 0x00006952,
	14588: 0x0000692F,
	14589: 0x0000697B,
	14590: 0x0000693C,
	14591: 0x00006B46,
	14592: 0x00006B45,
	14593: 0x00006B43,
	14594: 0x00006B42,
	14595: 0x00006B48,
	14596: 0x00006B41,
	14597: 0x00006B9B,
	14598: 0x0000FA0D,
	14599: 0x00006BFB,
	14600: 0x00006BFC,
	14601: 0x00006BF9,
	14602: 0x00006BF7,
	14603: 0x00006BF8,
	14604: 0x00006E9B,
	14605: 0x00006ED6,
	14606: 0x00006EC8,
	14607: 0x00006E8F,
	14608: 0x00006EC0,
	14609: 0x00006E9F,
	14610: 0x00006E93,
	14611: 0x00006E94,
	14612: 0x00006EA0,
	14613: 0x00006EB1,
	14614: 0x00006EB9,
	14615: 0x00006EC6,
	14616: 0x00006ED2,
	14617: 0x00006EBD,
	14618: 0x00006EC1,
	14619: 0x00006E9E,
	14620: 0x00006EC9,
	14621: 0x00006EB7,
	14622: 0x00006EB0,
	14623: 0x00006ECD,
	14624: 0x00006EA6,
	14625: 0x00006ECF,
	14626: 0x00006EB2,
	14627: 0x00006EBE,
	14628: 0x00006EC3,
	14629: 0x00006EDC,
	14630: 0x00006ED8,
	14631: 0x00006E99,
	14632: 0x00006E92,
	14633: 0x00006E8E,
	14634: 0x00006E8D,
	14635: 0x00006EA4,
	14636: 0x00006EA1,
	14637: 0x00006EBF,
	14638: 0x00006EB3,
	14639: 0x00006ED0,
	14640: 0x00006ECA,
	14641: 0x00006E97,
	14642: 0x00006EAE,
	14643: 0x00006EA3,
	14644: 0x00007147,
	14645: 0x00007154,
	14646: 0x00007152,
	14647: 0x00007163,
	14648: 0x00007160,
	14649: 0x00007141,
	14650: 0x0000715D,
	14651: 0x00007162,
	14652: 0x00007172,
	14653: 0x00007178,
	14654: 0x0000716A,
	14655: 0x00007161,
	14656: 0x00007142,
	14657: 0x00007158,
	14658: 0x00007143,
	14659: 0x0000714B,
	14660: 0x00007170,
	14661: 0x0000715F,
	14662: 0x00007150,
	14663: 0x00007153,
	14664: 0x00007144,
	14665: 0x0000714D,
	14666: 0x0000715A,
	14667: 0x0000724F,
	14668: 0x0000728D,
	14669: 0x0000728C,
	14670: 0x00007291,
	14671: 0x00007290,
	14672: 0x0000728E,
	14673: 0x0000733C,
	14674: 0x00007342,
	14675: 0x0000733B,
	14676: 0x0000733A,
	14677: 0x00007340,
	14678: 0x0000734A,
	14679: 0x00007349,
	14680: 0x00007444,
	14681: 0x0000744A,
	14682: 0x0000744B,
	14683: 0x00007452,
	14684: 0x00007451,
	14685: 0x00007457,
	14686: 0x00007440,
	14687: 0x0000744F,
	14688: 0x00007450,
	14689: 0x0000744E,
	14690: 0x00007442,
	14691: 0x00007446,
	14692: 0x0000744D,
	14693: 0x00007454,
	14694: 0x000074E1,
	14695: 0x000074FF,
	14696: 0x000074FE,
	14697: 0x000074FD,
	14698: 0x0000751D,
	14699: 0x00007579,
	14700: 0x00007577,
	14701: 0x00006983,
	14702: 0x000075EF,
	14703: 0x0000760F,
	14704: 0x00007603,
	14705: 0x000075F7,
	14706: 0x000075FE,
	14707: 0x000075FC,
	14708: 0x000075F9,
	14709: 0x000075F8,
	14710: 0x00007610,
	14711: 0x000075FB,
	14712: 0x000075F6,
	14713: 0x000075ED,
	14714: 0x000075F5,
	14715: 0x000075FD,
	14716: 0x00007699,
	14717: 0x000076B5,
	14718: 0x000076DD,
	14719: 0x00007755,
	14720: 0x0000775F,
	14721: 0x00007760,
	14722: 0x00007752,
	14723: 0x00007756,
	14724: 0x0000775A,
	14725: 0x00007769,
	14726: 0x00007767,
	14727: 0x00007754,
	14728: 0x00007759,
	14729: 0x0000776D,
	14730: 0x000077E0,
	14731: 0x00007887,
	14732: 0x0000789A,
	14733: 0x00007894,
	14734: 0x0000788F,
	14735: 0x00007884,
	14736: 0x00007895,
	14737: 0x00007885,
	14738: 0x00007886,
	14739: 0x000078A1,
	14740: 0x00007883,
	14741: 0x00007879,
	14742: 0x00007899,
	14743: 0x00007880,
	14744: 0x00007896,
	14745: 0x0000787B,
	14746: 0x0000797C,
	14747: 0x00007982,
	14748: 0x0000797D,
	14749: 0x00007979,
	14750: 0x00007A11,
	14751: 0x00007A18,
	14752: 0x00007A19,
	14753: 0x00007A12,
	14754: 0x00007A17,
	14755: 0x00007A15,
	14756: 0x00007A22,
	14757: 0x00007A13,
	14758: 0x00007A1B,
	14759: 0x00007A10,
	14760: 0x00007AA3,
	14761: 0x00007AA2,
	14762: 0x00007A9E,
	14763: 0x00007AEB,
	14764: 0x00007B66,
	14765: 0x00007B64,
	14766: 0x00007B6D,
	14767: 0x00007B74,
	14768: 0x00007B69,
	14769: 0x00007B72,
	14770: 0x00007B65,
	14771: 0x00007B73,
	14772: 0x00007B71,
	14773: 0x00007B70,
	14774: 0x00007B61,
	14775: 0x00007B78,
	14776: 0x00007B76,
	14777: 0x00007B63,
	14778: 0x00007CB2,
	14779: 0x00007CB4,
	14780: 0x00007CAF,
	14781: 0x00007D88,
	14782: 0x00007D86,
	14783: 0x00007D80,
	14784: 0x00007D8D,
	14785: 0x00007D7F,
	14786: 0x00007D85,
	14787: 0x00007D7A,
	14788: 0x00007D8E,
	14789: 0x00007D7B,
	14790: 0x00007D83,
	14791: 0x00007D7C,
	14792: 0x00007D8C,
	14793: 0x00007D94,
	14794: 0x00007D84,
	14795: 0x00007D7D,
	14796: 0x00007D92,
	14797: 0x00007F6D,
	14798: 0x00007F6B,
	14799: 0x00007F67,
	14800: 0x00007F68,
	14801: 0x00007F6C,
	14802: 0x00007FA6,
	14803: 0x00007FA5,
	14804: 0x00007FA7,
	14805: 0x00007FDB,
	14806: 0x00007FDC,
	14807: 0x00008021,
	14808: 0x00008164,
	14809: 0x00008160,
	14810: 0x00008177,
	14811: 0x0000815C,
	14812: 0x00008169,
	14813: 0x0000815B,
	14814: 0x00008162,
	14815: 0x00008172,
	14816: 0x00006721,
	14817: 0x0000815E,
	14818: 0x00008176,
	14819: 0x00008167,
	14820: 0x0000816F,
	14821: 0x00008144,
	14822: 0x00008161,
	14823: 0x0000821D,
	14824: 0x00008249,
	14825: 0x00008244,
	14826: 0x00008240,
	14827: 0x00008242,
	14828: 0x00008245,
	14829: 0x000084F1,
	14830: 0x0000843F,
	14831: 0x00008456,
	14832: 0x00008476,
	14833: 0x00008479,
	14834: 0x0000848F,
	14835: 0x0000848D,
	14836: 0x00008465,
	14837: 0x00008451,
	14838: 0x00008440,
	14839: 0x00008486,
	14840: 0x00008467,
	14841: 0x00008430,
	14842: 0x0000844D,
	14843: 0x0000847D,
	14844: 0x0000845A,
	14845: 0x00008459,
	14846: 0x00008474,
	14847: 0x00008473,
	14848: 0x0000845D,
	14849: 0x00008507,
	14850: 0x0000845E,
	14851: 0x00008437,
	14852: 0x0000843A,
	14853: 0x00008434,
	14854: 0x0000847A,
	14855: 0x00008443,
	14856: 0x00008478,
	14857: 0x00008432,
	14858: 0x00008445,
	14859: 0x00008429,
	14860: 0x000083D9,
	14861: 0x0000844B,
	14862: 0x0000842F,
	14863: 0x00008442,
	14864: 0x0000842D,
	14865: 0x0000845F,
	14866: 0x00008470,
	14867: 0x00008439,
	14868: 0x0000844E,
	14869: 0x0000844C,
	14870: 0x00008452,
	14871: 0x0000846F,
	14872: 0x000084C5,
	14873: 0x0000848E,
	14874: 0x0000843B,
	14875: 0x00008447,
	14876: 0x00008436,
	14877: 0x00008433,
	14878: 0x00008468,
	14879: 0x0000847E,
	14880: 0x00008444,
	14881: 0x0000842B,
	14882: 0x00008460,
	14883: 0x00008454,
	14884: 0x0000846E,
	14885: 0x00008450,
	14886: 0x0000870B,
	14887: 0x00008704,
	14888: 0x000086F7,
	14889: 0x0000870C,
	14890: 0x000086FA,
	14891: 0x000086D6,
	14892: 0x000086F5,
	14893: 0x0000874D,
	14894: 0x000086F8,
	14895: 0x0000870E,
	14896: 0x00008709,
	14897: 0x00008701,
	14898: 0x000086F6,
	14899: 0x0000870D,
	14900: 0x00008705,
	14901: 0x000088D6,
	14902: 0x000088CB,
	14903: 0x000088CD,
	14904: 0x000088CE,
	14905: 0x000088DE,
	14906: 0x000088DB,
	14907: 0x000088DA,
	14908: 0x000088CC,
	14909: 0x000088D0,
	14910: 0x00008985,
	14911: 0x0000899B,
	14912: 0x000089DF,
	14913: 0x000089E5,
	14914: 0x000089E4,
	14915: 0x000089E1,
	14916: 0x000089E0,
	14917: 0x000089E2,
	14918: 0x000089DC,
	14919: 0x000089E6,
	14920: 0x00008A76,
	14921: 0x00008A86,
	14922: 0x00008A7F,
	14923: 0x00008A61,
	14924: 0x00008A3F,
	14925: 0x00008A77,
	14926: 0x00008A82,
	14927: 0x00008A84,
	14928: 0x00008A75,
	14929: 0x00008A83,
	14930: 0x00008A81,
	14931: 0x00008A74,
	14932: 0x00008A7A,
	14933: 0x00008C3C,
	14934: 0x00008C4B,
	14935: 0x00008C4A,
	14936: 0x00008C65,
	14937: 0x00008C64,
	14938: 0x00008C66,
	14939: 0x00008C86,
	14940: 0x00008C84,
	14941: 0x00008C85,
	14942: 0x00008CCC,
	14943: 0x00008D68,
	14944: 0x00008D69,
	14945: 0x00008D91,
	14946: 0x00008D8C,
	14947: 0x00008D8E,
	14948: 0x00008D8F,
	14949: 0x00008D8D,
	14950: 0x00008D93,
	14951: 0x00008D94,
	14952: 0x00008D90,
	14953: 0x00008D92,
	14954: 0x00008DF0,
	14955: 0x00008DE0,
	14956: 0x00008DEC,
	14957: 0x00008DF1,
	14958: 0x00008DEE,
	14959: 0x00008DD0,
	14960: 0x00008DE9,
	14961: 0x00008DE3,
	14962: 0x00008DE2,
	14963: 0x00008DE7,
	14964: 0x00008DF2,
	14965: 0x00008DEB,
	14966: 0x00008DF4,
	14967: 0x00008F06,
	14968: 0x00008EFF,
	14969: 0x00008F01,
	14970: 0x00008F00,
	14971: 0x00008F05,
	14972: 0x00008F07,
	14973: 0x00008F08,
	14974: 0x00008F02,
	14975: 0x00008F0B,
	14976: 0x00009052,
	14977: 0x0000903F,
	14978: 0x00009044,
	14979: 0x00009049,
	14980: 0x0000903D,
	14981: 0x00009110,
	14982: 0x0000910D,
	14983: 0x0000910F,
	14984: 0x00009111,
	14985: 0x00009116,
	14986: 0x00009114,
	14987: 0x0000910B,
	14988: 0x0000910E,
	14989: 0x0000916E,
	14990: 0x0000916F,
	14991: 0x00009248,
	14992: 0x00009252,
	14993: 0x00009230,
	14994: 0x0000923A,
	14995: 0x00009266,
	14996: 0x00009233,
	14997: 0x00009265,
	14998: 0x0000925E,
	14999: 0x00009283,
	15000: 0x0000922E,
	15001: 0x0000924A,
	15002: 0x00009246,
	15003: 0x0000926D,
	15004: 0x0000926C,
	15005: 0x0000924F,
	15006: 0x00009260,
	15007: 0x00009267,
	15008: 0x0000926F,
	15009: 0x00009236,
	15010: 0x00009261,
	15011: 0x00009270,
	15012: 0x00009231,
	15013: 0x00009254,
	15014: 0x00009263,
	15015: 0x00009250,
	15016: 0x00009272,
	15017: 0x0000924E,
	15018: 0x00009253,
	15019: 0x0000924C,
	15020: 0x00009256,
	15021: 0x00009232,
	15022: 0x0000959F,
	15023: 0x0000959C,
	15024: 0x0000959E,
	15025: 0x0000959B,
	15026: 0x00009692,
	15027: 0x00009693,
	15028: 0x00009691,
	15029: 0x00009697,
	15030: 0x000096CE,
	15031: 0x000096FA,
	15032: 0x000096FD,
	15033: 0x000096F8,
	15034: 0x000096F5,
	15035: 0x00009773,
	15036: 0x00009777,
	15037: 0x00009778,
	15038: 0x00009772,
	15039: 0x0000980F,
	15040: 0x0000980D,
	15041: 0x0000980E,
	15042: 0x000098AC,
	15043: 0x000098F6,
	15044: 0x000098F9,
	15045: 0x000099AF,
	15046: 0x000099B2,
	15047: 0x000099B0,
	15048: 0x000099B5,
	15049: 0x00009AAD,
	15050: 0x00009AAB,
	15051: 0x00009B5B,
	15052: 0x00009CEA,
	15053: 0x00009CED,
	15054: 0x00009CE7,
	15055: 0x00009E80,
	15056: 0x00009EFD,
	15057: 0x000050E6,
	15058: 0x000050D4,
	15059: 0x000050D7,
	15060: 0x000050E8,
	15061: 0x000050F3,
	15062: 0x000050DB,
	15063: 0x000050EA,
	15064: 0x000050DD,
	15065: 0x000050E4,
	15066: 0x000050D3,
	15067: 0x000050EC,
	15068: 0x000050F0,
	15069: 0x000050EF,
	15070: 0x000050E3,
	15071: 0x000050E0,
	15072: 0x000051D8,
	15073: 0x00005280,
	15074: 0x00005281,
	15075: 0x000052E9,
	15076: 0x000052EB,
	15077: 0x00005330,
	15078: 0x000053AC,
	15079: 0x00005627,
	15080: 0x00005615,
	15081: 0x0000560C,
	15082: 0x00005612,
	15083: 0x000055FC,
	15084: 0x0000560F,
	15085: 0x0000561C,
	15086: 0x00005601,
	15087: 0x00005613,
	15088: 0x00005602,
	15089: 0x000055FA,
	15090: 0x0000561D,
	15091: 0x00005604,
	15092: 0x000055FF,
	15093: 0x000055F9,
	15094: 0x00005889,
	15095: 0x0000587C,
	15096: 0x00005890,
	15097: 0x00005898,
	15098: 0x00005886,
	15099: 0x00005881,
	15100: 0x0000587F,
	15101: 0x00005874,
	15102: 0x0000588B,
	15103: 0x0000587A,
	15104: 0x00005887,
	15105: 0x00005891,
	15106: 0x0000588E,
	15107: 0x00005876,
	15108: 0x00005882,
	15109: 0x00005888,
	15110: 0x0000587B,
	15111: 0x00005894,
	15112: 0x0000588F,
	15113: 0x000058FE,
	15114: 0x0000596B,
	15115: 0x00005ADC,
	15116: 0x00005AEE,
	15117: 0x00005AE5,
	15118: 0x00005AD5,
	15119: 0x00005AEA,
	15120: 0x00005ADA,
	15121: 0x00005AED,
	15122: 0x00005AEB,
	15123: 0x00005AF3,
	15124: 0x00005AE2,
	15125: 0x00005AE0,
	15126: 0x00005ADB,
	15127: 0x00005AEC,
	15128: 0x00005ADE,
	15129: 0x00005ADD,
	15130: 0x00005AD9,
	15131: 0x00005AE8,
	15132: 0x00005ADF,
	15133: 0x00005B77,
	15134: 0x00005BE0,
	15135: 0x00005BE3,
	15136: 0x00005C63,
	15137: 0x00005D82,
	15138: 0x00005D80,
	15139: 0x00005D7D,
	15140: 0x00005D86,
	15141: 0x00005D7A,
	15142: 0x00005D81,
	15143: 0x00005D77,
	15144: 0x00005D8A,
	15145: 0x00005D89,
	15146: 0x00005D88,
	15147: 0x00005D7E,
	15148: 0x00005D7C,
	15149: 0x00005D8D,
	15150: 0x00005D79,
	15151: 0x00005D7F,
	15152: 0x00005E58,
	15153: 0x00005E59,
	15154: 0x00005E53,
	15155: 0x00005ED8,
	15156: 0x00005ED1,
	15157: 0x00005ED7,
	15158: 0x00005ECE,
	15159: 0x00005EDC,
	15160: 0x00005ED5,
	15161: 0x00005ED9,
	15162: 0x00005ED2,
	15163: 0x00005ED4,
	15164: 0x00005F44,
	15165: 0x00005F43,
	15166: 0x00005F6F,
	15167: 0x00005FB6,
	15168: 0x0000612C,
	15169: 0x00006128,
	15170: 0x00006141,
	15171: 0x0000615E,
	15172: 0x00006171,
	15173: 0x00006173,
	15174: 0x00006152,
	15175: 0x00006153,
	15176: 0x00006172,
	15177: 0x0000616C,
	15178: 0x00006180,
	15179: 0x00006174,
	15180: 0x00006154,
	15181: 0x0000617A,
	15182: 0x0000615B,
	15183: 0x00006165,
	15184: 0x0000613B,
	15185: 0x0000616A,
	15186: 0x00006161,
	15187: 0x00006156,
	15188: 0x00006229,
	15189: 0x00006227,
	15190: 0x0000622B,
	15191: 0x0000642B,
	15192: 0x0000644D,
	15193: 0x0000645B,
	15194: 0x0000645D,
	15195: 0x00006474,
	15196: 0x00006476,
	15197: 0x00006472,
	15198: 0x00006473,
	15199: 0x0000647D,
	15200: 0x00006475,
	15201: 0x00006466,
	15202: 0x000064A6,
	15203: 0x0000644E,
	15204: 0x00006482,
	15205: 0x0000645E,
	15206: 0x0000645C,
	15207: 0x0000644B,
	15208: 0x00006453,
	15209: 0x00006460,
	15210: 0x00006450,
	15211: 0x0000647F,
	15212: 0x0000643F,
	15213: 0x0000646C,
	15214: 0x0000646B,
	15215: 0x00006459,
	15216: 0x00006465,
	15217: 0x00006477,
	15218: 0x00006573,
	15219: 0x000065A0,
	15220: 0x000066A1,
	15221: 0x000066A0,
	15222: 0x0000669F,
	15223: 0x00006705,
	15224: 0x00006704,
	15225: 0x00006722,
	15226: 0x000069B1,
	15227: 0x000069B6,
	15228: 0x000069C9,
	15229: 0x000069A0,
	15230: 0x000069CE,
	15231: 0x00006996,
	15232: 0x000069B0,
	15233: 0x000069AC,
	15234: 0x000069BC,
	15235: 0x00006991,
	15236: 0x00006999,
	15237: 0x0000698E,
	15238: 0x000069A7,
	15239: 0x0000698D,
	15240: 0x000069A9,
	15241: 0x000069BE,
	15242: 0x000069AF,
	15243: 0x000069BF,
	15244: 0x000069C4,
	15245: 0x000069BD,
	15246: 0x000069A4,
	15247: 0x000069D4,
	15248: 0x000069B9,
	15249: 0x000069CA,
	15250: 0x0000699A,
	15251: 0x000069CF,
	15252: 0x000069B3,
	15253: 0x00006993,
	15254: 0x000069AA,
	15255: 0x000069A1,
	15256: 0x0000699E,
	15257: 0x000069D9,
	15258: 0x00006997,
	15259: 0x00006990,
	15260: 0x000069C2,
	15261: 0x000069B5,
	15262: 0x000069A5,
	15263: 0x000069C6,
	15264: 0x00006B4A,
	15265: 0x00006B4D,
	15266: 0x00006B4B,
	15267: 0x00006B9E,
	15268: 0x00006B9F,
	15269: 0x00006BA0,
	15270: 0x00006BC3,
	15271: 0x00006BC4,
	15272: 0x00006BFE,
	15273: 0x00006ECE,
	15274: 0x00006EF5,
	15275: 0x00006EF1,
	15276: 0x00006F03,
	15277: 0x00006F25,
	15278: 0x00006EF8,
	15279: 0x00006F37,
	15280: 0x00006EFB,
	15281: 0x00006F2E,
	15282: 0x00006F09,
	15283: 0x00006F4E,
	15284: 0x00006F19,
	15285: 0x00006F1A,
	15286: 0x00006F27,
	15287: 0x00006F18,
	15288: 0x00006F3B,
	15289: 0x00006F12,
	15290: 0x00006EED,
	15291: 0x00006F0A,
	15292: 0x00006F36,
	15293: 0x00006F73,
	15294: 0x00006EF9,
	15295: 0x00006EEE,
	15296: 0x00006F2D,
	15297: 0x00006F40,
	15298: 0x00006F30,
	15299: 0x00006F3C,
	15300: 0x00006F35,
	15301: 0x00006EEB,
	15302: 0x00006F07,
	15303: 0x00006F0E,
	15304: 0x00006F43,
	15305: 0x00006F05,
	15306: 0x00006EFD,
	15307: 0x00006EF6,
	15308: 0x00006F39,
	15309: 0x00006F1C,
	15310: 0x00006EFC,
	15311: 0x00006F3A,
	15312: 0x00006F1F,
	15313: 0x00006F0D,
	15314: 0x00006F1E,
	15315: 0x00006F08,
	15316: 0x00006F21,
	15317: 0x00007187,
	15318: 0x00007190,
	15319: 0x00007189,
	15320: 0x00007180,
	15321: 0x00007185,
	15322: 0x00007182,
	15323: 0x0000718F,
	15324: 0x0000717B,
	15325: 0x00007186,
	15326: 0x00007181,
	15327: 0x00007197,
	15328: 0x00007244,
	15329: 0x00007253,
	15330: 0x00007297,
	15331: 0x00007295,
	15332: 0x00007293,
	15333: 0x00007343,
	15334: 0x0000734D,
	15335: 0x00007351,
	15336: 0x0000734C,
	15337: 0x00007462,
	15338: 0x00007473,
	15339: 0x00007471,
	15340: 0x00007475,
	15341: 0x00007472,
	15342: 0x00007467,
	15343: 0x0000746E,
	15344: 0x00007500,
	15345: 0x00007502,
	15346: 0x00007503,
	15347: 0x0000757D,
	15348: 0x00007590,
	15349: 0x00007616,
	15350: 0x00007608,
	15351: 0x0000760C,
	15352: 0x00007615,
	15353: 0x00007611,
	15354: 0x0000760A,
	15355: 0x00007614,
	15356: 0x000076B8,
	15357: 0x00007781,
	15358: 0x0000777C,
	15359: 0x00007785,
	15360: 0x00007782,
	15361: 0x0000776E,
	15362: 0x00007780,
	15363: 0x0000776F,
	15364: 0x0000777E,
	15365: 0x00007783,
	15366: 0x000078B2,
	15367: 0x000078AA,
	15368: 0x000078B4,
	15369: 0x000078AD,
	15370: 0x000078A8,
	15371: 0x0000787E,
	15372: 0x000078AB,
	15373: 0x0000789E,
	15374: 0x000078A5,
	15375: 0x000078A0,
	15376: 0x000078AC,
	15377: 0x000078A2,
	15378: 0x000078A4,
	15379: 0x00007998,
	15380: 0x0000798A,
	15381: 0x0000798B,
	15382: 0x00007996,
	15383: 0x00007995,
	15384: 0x00007994,
	15385: 0x00007993,
	15386: 0x00007997,
	15387: 0x00007988,
	15388: 0x00007992,
	15389: 0x00007990,
	15390: 0x00007A2B,
	15391: 0x00007A4A,
	15392: 0x00007A30,
	15393: 0x00007A2F,
	15394: 0x00007A28,
	15395: 0x00007A26,
	15396: 0x00007AA8,
	15397: 0x00007AAB,
	15398: 0x00007AAC,
	15399: 0x00007AEE,
	15400: 0x00007B88,
	15401: 0x00007B9C,
	15402: 0x00007B8A,
	15403: 0x00007B91,
	15404: 0x00007B90,
	15405: 0x00007B96,
	15406: 0x00007B8D,
	15407: 0x00007B8C,
	15408: 0x00007B9B,
	15409: 0x00007B8E,
	15410: 0x00007B85,
	15411: 0x00007B98,
	15412: 0x00005284,
	15413: 0x00007B99,
	15414: 0x00007BA4,
	15415: 0x00007B82,
	15416: 0x00007CBB,
	15417: 0x00007CBF,
	15418: 0x00007CBC,
	15419: 0x00007CBA,
	15420: 0x00007DA7,
	15421: 0x00007DB7,
	15422: 0x00007DC2,
	15423: 0x00007DA3,
	15424: 0x00007DAA,
	15425: 0x00007DC1,
	15426: 0x00007DC0,
	15427: 0x00007DC5,
	15428: 0x00007D9D,
	15429: 0x00007DCE,
	15430: 0x00007DC4,
	15431: 0x00007DC6,
	15432: 0x00007DCB,
	15433: 0x00007DCC,
	15434: 0x00007DAF,
	15435: 0x00007DB9,
	15436: 0x00007D96,
	15437: 0x00007DBC,
	15438: 0x00007D9F,
	15439: 0x00007DA6,
	15440: 0x00007DAE,
	15441: 0x00007DA9,
	15442: 0x00007DA1,
	15443: 0x00007DC9,
	15444: 0x00007F73,
	15445: 0x00007FE2,
	15446: 0x00007FE3,
	15447: 0x00007FE5,
	15448: 0x00007FDE,
	15449: 0x00008024,
	15450: 0x0000805D,
	15451: 0x0000805C,
	15452: 0x00008189,
	15453: 0x00008186,
	15454: 0x00008183,
	15455: 0x00008187,
	15456: 0x0000818D,
	15457: 0x0000818C,
	15458: 0x0000818B,
	15459: 0x00008215,
	15460: 0x00008497,
	15461: 0x000084A4,
	15462: 0x000084A1,
	15463: 0x0000849F,
	15464: 0x000084BA,
	15465: 0x000084CE,
	15466: 0x000084C2,
	15467: 0x000084AC,
	15468: 0x000084AE,
	15469: 0x000084AB,
	15470: 0x000084B9,
	15471: 0x000084B4,
	15472: 0x000084C1,
	15473: 0x000084CD,
	15474: 0x000084AA,
	15475: 0x0000849A,
	15476: 0x000084B1,
	15477: 0x000084D0,
	15478: 0x0000849D,
	15479: 0x000084A7,
	15480: 0x000084BB,
	15481: 0x000084A2,
	15482: 0x00008494,
	15483: 0x000084C7,
	15484: 0x000084CC,
	15485: 0x0000849B,
	15486: 0x000084A9,
	15487: 0x000084AF,
	15488: 0x000084A8,
	15489: 0x000084D6,
	15490: 0x00008498,
	15491: 0x000084B6,
	15492: 0x000084CF,
	15493: 0x000084A0,
	15494: 0x000084D7,
	15495: 0x000084D4,
	15496: 0x000084D2,
	15497: 0x000084DB,
	15498: 0x000084B0,
	15499: 0x00008491,
	15500: 0x00008661,
	15501: 0x00008733,
	15502: 0x00008723,
	15503: 0x00008728,
	15504: 0x0000876B,
	15505: 0x00008740,
	15506: 0x0000872E,
	15507: 0x0000871E,
	15508: 0x00008721,
	15509: 0x00008719,
	15510: 0x0000871B,
	15511: 0x00008743,
	15512: 0x0000872C,
	15513: 0x00008741,
	15514: 0x0000873E,
	15515: 0x00008746,
	15516: 0x00008720,
	15517: 0x00008732,
	15518: 0x0000872A,
	15519: 0x0000872D,
	15520: 0x0000873C,
	15521: 0x00008712,
	15522: 0x0000873A,
	15523: 0x00008731,
	15524: 0x00008735,
	15525: 0x00008742,
	15526: 0x00008726,
	15527: 0x00008727,
	15528: 0x00008738,
	15529: 0x00008724,
	15530: 0x0000871A,
	15531: 0x00008730,
	15532: 0x00008711,
	15533: 0x000088F7,
	15534: 0x000088E7,
	15535: 0x000088F1,
	15536: 0x000088F2,
	15537: 0x000088FA,
	15538: 0x000088FE,
	15539: 0x000088EE,
	15540: 0x000088FC,
	15541: 0x000088F6,
	15542: 0x000088FB,
	15543: 0x000088F0,
	15544: 0x000088EC,
	15545: 0x000088EB,
	15546: 0x0000899D,
	15547: 0x000089A1,
	15548: 0x0000899F,
	15549: 0x0000899E,
	15550: 0x000089E9,
	15551: 0x000089EB,
	15552: 0x000089E8,
	15553: 0x00008AAB,
	15554: 0x00008A99,
	15555: 0x00008A8B,
	15556: 0x00008A92,
	15557: 0x00008A8F,
	15558: 0x00008A96,
	15559: 0x00008C3D,
	15560: 0x00008C68,
	15561: 0x00008C69,
	15562: 0x00008CD5,
	15563: 0x00008CCF,
	15564: 0x00008CD7,
	15565: 0x00008D96,
	15566: 0x00008E09,
	15567: 0x00008E02,
	15568: 0x00008DFF,
	15569: 0x00008E0D,
	15570: 0x00008DFD,
	15571: 0x00008E0A,
	15572: 0x00008E03,
	15573: 0x00008E07,
	15574: 0x00008E06,
	15575: 0x00008E05,
	15576: 0x00008DFE,
	15577: 0x00008E00,
	15578: 0x00008E04,
	15579: 0x00008F10,
	15580: 0x00008F11,
	15581: 0x00008F0E,
	15582: 0x00008F0D,
	15583: 0x00009123,
	15584: 0x0000911C,
	15585: 0x00009120,
	15586: 0x00009122,
	15587: 0x0000911F,
	15588: 0x0000911D,
	15589: 0x0000911A,
	15590: 0x00009124,
	15591: 0x00009121,
	15592: 0x0000911B,
	15593: 0x0000917A,
	15594: 0x00009172,
	15595: 0x00009179,
	15596: 0x00009173,
	15597: 0x000092A5,
	15598: 0x000092A4,
	15599: 0x00009276,
	15600: 0x0000929B,
	15601: 0x0000927A,
	15602: 0x000092A0,
	15603: 0x00009294,
	15604: 0x000092AA,
	15605: 0x0000928D,
	15606: 0x000092A6,
	15607: 0x0000929A,
	15608: 0x000092AB,
	15609: 0x00009279,
	15610: 0x00009297,
	15611: 0x0000927F,
	15612: 0x000092A3,
	15613: 0x000092EE,
	15614: 0x0000928E,
	15615: 0x00009282,
	15616: 0x00009295,
	15617: 0x000092A2,
	15618: 0x0000927D,
	15619: 0x00009288,
	15620: 0x000092A1,
	15621: 0x0000928A,
	15622: 0x00009286,
	15623: 0x0000928C,
	15624: 0x00009299,
	15625: 0x000092A7,
	15626: 0x0000927E,
	15627: 0x00009287,
	15628: 0x000092A9,
	15629: 0x0000929D,
	15630: 0x0000928B,
	15631: 0x0000922D,
	15632: 0x0000969E,
	15633: 0x000096A1,
	15634: 0x000096FF,
	15635: 0x00009758,
	15636: 0x0000977D,
	15637: 0x0000977A,
	15638: 0x0000977E,
	15639: 0x00009783,
	15640: 0x00009780,
	15641: 0x00009782,
	15642: 0x0000977B,
	15643: 0x00009784,
	15644: 0x00009781,
	15645: 0x0000977F,
	15646: 0x000097CE,
	15647: 0x000097CD,
	15648: 0x00009816,
	15649: 0x000098AD,
	15650: 0x000098AE,
	15651: 0x00009902,
	15652: 0x00009900,
	15653: 0x00009907,
	15654: 0x0000999D,
	15655: 0x0000999C,
	15656: 0x000099C3,
	15657: 0x000099B9,
	15658: 0x000099BB,
	15659: 0x000099BA,
	15660: 0x000099C2,
	15661: 0x000099BD,
	15662: 0x000099C7,
	15663: 0x00009AB1,
	15664: 0x00009AE3,
	15665: 0x00009AE7,
	15666: 0x00009B3E,
	15667: 0x00009B3F,
	15668: 0x00009B60,
	15669: 0x00009B61,
	15670: 0x00009B5F,
	15671: 0x00009CF1,
	15672: 0x00009CF2,
	15673: 0x00009CF5,
	15674: 0x00009EA7,
	15675: 0x000050FF,
	15676: 0x00005103,
	15677: 0x00005130,
	15678: 0x000050F8,
	15679: 0x00005106,
	15680: 0x00005107,
	15681: 0x000050F6,
	15682: 0x000050FE,
	15683: 0x0000510B,
	15684: 0x0000510C,
	15685: 0x000050FD,
	15686: 0x0000510A,
	15687: 0x0000528B,
	15688: 0x0000528C,
	15689: 0x000052F1,
	15690: 0x000052EF,
	15691: 0x00005648,
	15692: 0x00005642,
	15693: 0x0000564C,
	15694: 0x00005635,
	15695: 0x00005641,
	15696: 0x0000564A,
	15697: 0x00005649,
	15698: 0x00005646,
	15699: 0x00005658,
	15700: 0x0000565A,
	15701: 0x00005640,
	15702: 0x00005633,
	15703: 0x0000563D,
	15704: 0x0000562C,
	15705: 0x0000563E,
	15706: 0x00005638,
	15707: 0x0000562A,
	15708: 0x0000563A,
	15709: 0x0000571A,
	15710: 0x000058AB,
	15711: 0x0000589D,
	15712: 0x000058B1,
	15713: 0x000058A0,
	15714: 0x000058A3,
	15715: 0x000058AF,
	15716: 0x000058AC,
	15717: 0x000058A5,
	15718: 0x000058A1,
	15719: 0x000058FF,
	15720: 0x00005AFF,
	15721: 0x00005AF4,
	15722: 0x00005AFD,
	15723: 0x00005AF7,
	15724: 0x00005AF6,
	15725: 0x00005B03,
	15726: 0x00005AF8,
	15727: 0x00005B02,
	15728: 0x00005AF9,
	15729: 0x00005B01,
	15730: 0x00005B07,
	15731: 0x00005B05,
	15732: 0x00005B0F,
	15733: 0x00005C67,
	15734: 0x00005D99,
	15735: 0x00005D97,
	15736: 0x00005D9F,
	15737: 0x00005D92,
	15738: 0x00005DA2,
	15739: 0x00005D93,
	15740: 0x00005D95,
	15741: 0x00005DA0,
	15742: 0x00005D9C,
	15743: 0x00005DA1,
	15744: 0x00005D9A,
	15745: 0x00005D9E,
	15746: 0x00005E69,
	15747: 0x00005E5D,
	15748: 0x00005E60,
	15749: 0x00005E5C,
	15750: 0x00007DF3,
	15751: 0x00005EDB,
	15752: 0x00005EDE,
	15753: 0x00005EE1,
	15754: 0x00005F49,
	15755: 0x00005FB2,
	15756: 0x0000618B,
	15757: 0x00006183,
	15758: 0x00006179,
	15759: 0x000061B1,
	15760: 0x000061B0,
	15761: 0x000061A2,
	15762: 0x00006189,
	15763: 0x0000619B,
	15764: 0x00006193,
	15765: 0x000061AF,
	15766: 0x000061AD,
	15767: 0x0000619F,
	15768: 0x00006192,
	15769: 0x000061AA,
	15770: 0x000061A1,
	15771: 0x0000618D,
	15772: 0x00006166,
	15773: 0x000061B3,
	15774: 0x0000622D,
	15775: 0x0000646E,
	15776: 0x00006470,
	15777: 0x00006496,
	15778: 0x000064A0,
	15779: 0x00006485,
	15780: 0x00006497,
	15781: 0x0000649C,
	15782: 0x0000648F,
	15783: 0x0000648B,
	15784: 0x0000648A,
	15785: 0x0000648C,
	15786: 0x000064A3,
	15787: 0x0000649F,
	15788: 0x00006468,
	15789: 0x000064B1,
	15790: 0x00006498,
	15791: 0x00006576,
	15792: 0x0000657A,
	15793: 0x00006579,
	15794: 0x0000657B,
	15795: 0x000065B2,
	15796: 0x000065B3,
	15797: 0x000066B5,
	15798: 0x000066B0,
	15799: 0x000066A9,
	15800: 0x000066B2,
	15801: 0x000066B7,
	15802: 0x000066AA,
	15803: 0x000066AF,
	15804: 0x00006A00,
	15805: 0x00006A06,
	15806: 0x00006A17,
	15807: 0x000069E5,
	15808: 0x000069F8,
	15809: 0x00006A15,
	15810: 0x000069F1,
	15811: 0x000069E4,
	15812: 0x00006A20,
	15813: 0x000069FF,
	15814: 0x000069EC,
	15815: 0x000069E2,
	15816: 0x00006A1B,
	15817: 0x00006A1D,
	15818: 0x000069FE,
	15819: 0x00006A27,
	15820: 0x000069F2,
	15821: 0x000069EE,
	15822: 0x00006A14,
	15823: 0x000069F7,
	15824: 0x000069E7,
	15825: 0x00006A40,
	15826: 0x00006A08,
	15827: 0x000069E6,
	15828: 0x000069FB,
	15829: 0x00006A0D,
	15830: 0x000069FC,
	15831: 0x000069EB,
	15832: 0x00006A09,
	15833: 0x00006A04,
	15834: 0x00006A18,
	15835: 0x00006A25,
	15836: 0x00006A0F,
	15837: 0x000069F6,
	15838: 0x00006A26,
	15839: 0x00006A07,
	15840: 0x000069F4,
	15841: 0x00006A16,
	15842: 0x00006B51,
	15843: 0x00006BA5,
	15844: 0x00006BA3,
	15845: 0x00006BA2,
	15846: 0x00006BA6,
	15847: 0x00006C01,
	15848: 0x00006C00,
	15849: 0x00006BFF,
	15850: 0x00006C02,
	15851: 0x00006F41,
	15852: 0x00006F26,
	15853: 0x00006F7E,
	15854: 0x00006F87,
	15855: 0x00006FC6,
	15856: 0x00006F92,
	15857: 0x00006F8D,
	15858: 0x00006F89,
	15859: 0x00006F8C,
	15860: 0x00006F62,
	15861: 0x00006F4F,
	15862: 0x00006F85,
	15863: 0x00006F5A,
	15864: 0x00006F96,
	15865: 0x00006F76,
	15866: 0x00006F6C,
	15867: 0x00006F82,
	15868: 0x00006F55,
	15869: 0x00006F72,
	15870: 0x00006F52,
	15871: 0x00006F50,
	15872: 0x00006F57,
	15873: 0x00006F94,
	15874: 0x00006F93,
	15875: 0x00006F5D,
	15876: 0x00006F00,
	15877: 0x00006F61,
	15878: 0x00006F6B,
	15879: 0x00006F7D,
	15880: 0x00006F67,
	15881: 0x00006F90,
	15882: 0x00006F53,
	15883: 0x00006F8B,
	15884: 0x00006F69,
	15885: 0x00006F7F,
	15886: 0x00006F95,
	15887: 0x00006F63,
	15888: 0x00006F77,
	15889: 0x00006F6A,
	15890: 0x00006F7B,
	15891: 0x000071B2,
	15892: 0x000071AF,
	15893: 0x0000719B,
	15894: 0x000071B0,
	15895: 0x000071A0,
	15896: 0x0000719A,
	15897: 0x000071A9,
	15898: 0x000071B5,
	15899: 0x0000719D,
	15900: 0x000071A5,
	15901: 0x0000719E,
	15902: 0x000071A4,
	15903: 0x000071A1,
	15904: 0x000071AA,
	15905: 0x0000719C,
	15906: 0x000071A7,
	15907: 0x000071B3,
	15908: 0x00007298,
	15909: 0x0000729A,
	15910: 0x00007358,
	15911: 0x00007352,
	15912: 0x0000735E,
	15913: 0x0000735F,
	15914: 0x00007360,
	15915: 0x0000735D,
	15916: 0x0000735B,
	15917: 0x00007361,
	15918: 0x0000735A,
	15919: 0x00007359,
	15920: 0x00007362,
	15921: 0x00007487,
	15922: 0x00007489,
	15923: 0x0000748A,
	15924: 0x00007486,
	15925: 0x00007481,
	15926: 0x0000747D,
	15927: 0x00007485,
	15928: 0x00007488,
	15929: 0x0000747C,
	15930: 0x00007479,
	15931: 0x00007508,
	15932: 0x00007507,
	15933: 0x0000757E,
	15934: 0x00007625,
	15935: 0x0000761E,
	15936: 0x00007619,
	15937: 0x0000761D,
	15938: 0x0000761C,
	15939: 0x00007623,
	15940: 0x0000761A,
	15941: 0x00007628,
	15942: 0x0000761B,
	15943: 0x0000769C,
	15944: 0x0000769D,
	15945: 0x0000769E,
	15946: 0x0000769B,
	15947: 0x0000778D,
	15948: 0x0000778F,
	15949: 0x00007789,
	15950: 0x00007788,
	15951: 0x000078CD,
	15952: 0x000078BB,
	15953: 0x000078CF,
	15954: 0x000078CC,
	15955: 0x000078D1,
	15956: 0x000078CE,
	15957: 0x000078D4,
	15958: 0x000078C8,
	15959: 0x000078C3,
	15960: 0x000078C4,
	15961: 0x000078C9,
	15962: 0x0000799A,
	15963: 0x000079A1,
	15964: 0x000079A0,
	15965: 0x0000799C,
	15966: 0x000079A2,
	15967: 0x0000799B,
	15968: 0x00006B76,
	15969: 0x00007A39,
	15970: 0x00007AB2,
	15971: 0x00007AB4,
	15972: 0x00007AB3,
	15973: 0x00007BB7,
	15974: 0x00007BCB,
	15975: 0x00007BBE,
	15976: 0x00007BAC,
	15977: 0x00007BCE,
	15978: 0x00007BAF,
	15979: 0x00007BB9,
	15980: 0x00007BCA,
	15981: 0x00007BB5,
	15982: 0x00007CC5,
	15983: 0x00007CC8,
	15984: 0x00007CCC,
	15985: 0x00007CCB,
	15986: 0x00007DF7,
	15987: 0x00007DDB,
	15988: 0x00007DEA,
	15989: 0x00007DE7,
	15990: 0x00007DD7,
	15991: 0x00007DE1,
	15992: 0x00007E03,
	15993: 0x00007DFA,
	15994: 0x00007DE6,
	15995: 0x00007DF6,
	15996: 0x00007DF1,
	15997: 0x00007DF0,
	15998: 0x00007DEE,
	15999: 0x00007DDF,
	16000: 0x00007F76,
	16001: 0x00007FAC,
	16002: 0x00007FB0,
	16003: 0x00007FAD,
	16004: 0x00007FED,
	16005: 0x00007FEB,
	16006: 0x00007FEA,
	16007: 0x00007FEC,
	16008: 0x00007FE6,
	16009: 0x00007FE8,
	16010: 0x00008064,
	16011: 0x00008067,
	16012: 0x000081A3,
	16013: 0x0000819F,
	16014: 0x0000819E,
	16015: 0x00008195,
	16016: 0x000081A2,
	16017: 0x00008199,
	16018: 0x00008197,
	16019: 0x00008216,
	16020: 0x0000824F,
	16021: 0x00008253,
	16022: 0x00008252,
	16023: 0x00008250,
	16024: 0x0000824E,
	16025: 0x00008251,
	16026: 0x00008524,
	16027: 0x0000853B,
	16028: 0x0000850F,
	16029: 0x00008500,
	16030: 0x00008529,
	16031: 0x0000850E,
	16032: 0x00008509,
	16033: 0x0000850D,
	16034: 0x0000851F,
	16035: 0x0000850A,
	16036: 0x00008527,
	16037: 0x0000851C,
	16038: 0x000084FB,
	16039: 0x0000852B,
	16040: 0x000084FA,
	16041: 0x00008508,
	16042: 0x0000850C,
	16043: 0x000084F4,
	16044: 0x0000852A,
	16045: 0x000084F2,
	16046: 0x00008515,
	16047: 0x000084F7,
	16048: 0x000084EB,
	16049: 0x000084F3,
	16050: 0x000084FC,
	16051: 0x00008512,
	16052: 0x000084EA,
	16053: 0x000084E9,
	16054: 0x00008516,
	16055: 0x000084FE,
	16056: 0x00008528,
	16057: 0x0000851D,
	16058: 0x0000852E,
	16059: 0x00008502,
	16060: 0x000084FD,
	16061: 0x0000851E,
	16062: 0x000084F6,
	16063: 0x00008531,
	16064: 0x00008526,
	16065: 0x000084E7,
	16066: 0x000084E8,
	16067: 0x000084F0,
	16068: 0x000084EF,
	16069: 0x000084F9,
	16070: 0x00008518,
	16071: 0x00008520,
	16072: 0x00008530,
	16073: 0x0000850B,
	16074: 0x00008519,
	16075: 0x0000852F,
	16076: 0x00008662,
	16077: 0x00008756,
	16078: 0x00008763,
	16079: 0x00008764,
	16080: 0x00008777,
	16081: 0x000087E1,
	16082: 0x00008773,
	16083: 0x00008758,
	16084: 0x00008754,
	16085: 0x0000875B,
	16086: 0x00008752,
	16087: 0x00008761,
	16088: 0x0000875A,
	16089: 0x00008751,
	16090: 0x0000875E,
	16091: 0x0000876D,
	16092: 0x0000876A,
	16093: 0x00008750,
	16094: 0x0000874E,
	16095: 0x0000875F,
	16096: 0x0000875D,
	16097: 0x0000876F,
	16098: 0x0000876C,
	16099: 0x0000877A,
	16100: 0x0000876E,
	16101: 0x0000875C,
	16102: 0x00008765,
	16103: 0x0000874F,
	16104: 0x0000877B,
	16105: 0x00008775,
	16106: 0x00008762,
	16107: 0x00008767,
	16108: 0x00008769,
	16109: 0x0000885A,
	16110: 0x00008905,
	16111: 0x0000890C,
	16112: 0x00008914,
	16113: 0x0000890B,
	16114: 0x00008917,
	16115: 0x00008918,
	16116: 0x00008919,
	16117: 0x00008906,
	16118: 0x00008916,
	16119: 0x00008911,
	16120: 0x0000890E,
	16121: 0x00008909,
	16122: 0x000089A2,
	16123: 0x000089A4,
	16124: 0x000089A3,
	16125: 0x000089ED,
	16126: 0x000089F0,
	16127: 0x000089EC,
	16128: 0x00008ACF,
	16129: 0x00008AC6,
	16130: 0x00008AB8,
	16131: 0x00008AD3,
	16132: 0x00008AD1,
	16133: 0x00008AD4,
	16134: 0x00008AD5,
	16135: 0x00008ABB,
	16136: 0x00008AD7,
	16137: 0x00008ABE,
	16138: 0x00008AC0,
	16139: 0x00008AC5,
	16140: 0x00008AD8,
	16141: 0x00008AC3,
	16142: 0x00008ABA,
	16143: 0x00008ABD,
	16144: 0x00008AD9,
	16145: 0x00008C3E,
	16146: 0x00008C4D,
	16147: 0x00008C8F,
	16148: 0x00008CE5,
	16149: 0x00008CDF,
	16150: 0x00008CD9,
	16151: 0x00008CE8,
	16152: 0x00008CDA,
	16153: 0x00008CDD,
	16154: 0x00008CE7,
	16155: 0x00008DA0,
	16156: 0x00008D9C,
	16157: 0x00008DA1,
	16158: 0x00008D9B,
	16159: 0x00008E20,
	16160: 0x00008E23,
	16161: 0x00008E25,
	16162: 0x00008E24,
	16163: 0x00008E2E,
	16164: 0x00008E15,
	16165: 0x00008E1B,
	16166: 0x00008E16,
	16167: 0x00008E11,
	16168: 0x00008E19,
	16169: 0x00008E26,
	16170: 0x00008E27,
	16171: 0x00008E14,
	16172: 0x00008E12,
	16173: 0x00008E18,
	16174: 0x00008E13,
	16175: 0x00008E1C,
	16176: 0x00008E17,
	16177: 0x00008E1A,
	16178: 0x00008F2C,
	16179: 0x00008F24,
	16180: 0x00008F18,
	16181: 0x00008F1A,
	16182: 0x00008F20,
	16183: 0x00008F23,
	16184: 0x00008F16,
	16185: 0x00008F17,
	16186: 0x00009073,
	16187: 0x00009070,
	16188: 0x0000906F,
	16189: 0x00009067,
	16190: 0x0000906B,
	16191: 0x0000912F,
	16192: 0x0000912B,
	16193: 0x00009129,
	16194: 0x0000912A,
	16195: 0x00009132,
	16196: 0x00009126,
	16197: 0x0000912E,
	16198: 0x00009185,
	16199: 0x00009186,
	16200: 0x0000918A,
	16201: 0x00009181,
	16202: 0x00009182,
	16203: 0x00009184,
	16204: 0x00009180,
	16205: 0x000092D0,
	16206: 0x000092C3,
	16207: 0x000092C4,
	16208: 0x000092C0,
	16209: 0x000092D9,
	16210: 0x000092B6,
	16211: 0x000092CF,
	16212: 0x000092F1,
	16213: 0x000092DF,
	16214: 0x000092D8,
	16215: 0x000092E9,
	16216: 0x000092D7,
	16217: 0x000092DD,
	16218: 0x000092CC,
	16219: 0x000092EF,
	16220: 0x000092C2,
	16221: 0x000092E8,
	16222: 0x000092CA,
	16223: 0x000092C8,
	16224: 0x000092CE,
	16225: 0x000092E6,
	16226: 0x000092CD,
	16227: 0x000092D5,
	16228: 0x000092C9,
	16229: 0x000092E0,
	16230: 0x000092DE,
	16231: 0x000092E7,
	16232: 0x000092D1,
	16233: 0x000092D3,
	16234: 0x000092B5,
	16235: 0x000092E1,
	16236: 0x000092C6,
	16237: 0x000092B4,
	16238: 0x0000957C,
	16239: 0x000095AC,
	16240: 0x000095AB,
	16241: 0x000095AE,
	16242: 0x000095B0,
	16243: 0x000096A4,
	16244: 0x000096A2,
	16245: 0x000096D3,
	16246: 0x00009705,
	16247: 0x00009708,
	16248: 0x00009702,
	16249: 0x0000975A,
	16250: 0x0000978A,
	16251: 0x0000978E,
	16252: 0x00009788,
	16253: 0x000097D0,
	16254: 0x000097CF,
	16255: 0x0000981E,
	16256: 0x0000981D,
	16257: 0x00009826,
	16258: 0x00009829,
	16259: 0x00009828,
	16260: 0x00009820,
	16261: 0x0000981B,
	16262: 0x00009827,
	16263: 0x000098B2,
	16264: 0x00009908,
	16265: 0x000098FA,
	16266: 0x00009911,
	16267: 0x00009914,
	16268: 0x00009916,
	16269: 0x00009917,
	16270: 0x00009915,
	16271: 0x000099DC,
	16272: 0x000099CD,
	16273: 0x000099CF,
	16274: 0x000099D3,
	16275: 0x000099D4,
	16276: 0x000099CE,
	16277: 0x000099C9,
	16278: 0x000099D6,
	16279: 0x000099D8,
	16280: 0x000099CB,
	16281: 0x000099D7,
	16282: 0x000099CC,
	16283: 0x00009AB3,
	16284: 0x00009AEC,
	16285: 0x00009AEB,
	16286: 0x00009AF3,
	16287: 0x00009AF2,
	16288: 0x00009AF1,
	16289: 0x00009B46,
	16290: 0x00009B43,
	16291: 0x00009B67,
	16292: 0x00009B74,
	16293: 0x00009B71,
	16294: 0x00009B66,
	16295: 0x00009B76,
	16296: 0x00009B75,
	16297: 0x00009B70,
	16298: 0x00009B68,
	16299: 0x00009B64,
	16300: 0x00009B6C,
	16301: 0x00009CFC,
	16302: 0x00009CFA,
	16303: 0x00009CFD,
	16304: 0x00009CFF,
	16305: 0x00009CF7,
	16306: 0x00009D07,
	16307: 0x00009D00,
	16308: 0x00009CF9,
	16309: 0x00009CFB,
	16310: 0x00009D08,
	16311: 0x00009D05,
	16312: 0x00009D04,
	16313: 0x00009E83,
	16314: 0x00009ED3,
	16315: 0x00009F0F,
	16316: 0x00009F10,
	16317: 0x0000511C,
	16318: 0x00005113,
	16319: 0x00005117,
	16320: 0x0000511A,
	16321: 0x00005111,
	16322: 0x000051DE,
	16323: 0x00005334,
	16324: 0x000053E1,
	16325: 0x00005670,
	16326: 0x00005660,
	16327: 0x0000566E,
	16328: 0x00005673,
	16329: 0x00005666,
	16330: 0x00005663,
	16331: 0x0000566D,
	16332: 0x00005672,
	16333: 0x0000565E,
	16334: 0x00005677,
	16335: 0x0000571C,
	16336: 0x0000571B,
	16337: 0x000058C8,
	16338: 0x000058BD,
	16339: 0x000058C9,
	16340: 0x000058BF,
	16341: 0x000058BA,
	16342: 0x000058C2,
	16343: 0x000058BC,
	16344: 0x000058C6,
	16345: 0x00005B17,
	16346: 0x00005B19,
	16347: 0x00005B1B,
	16348: 0x00005B21,
	16349: 0x00005B14,
	16350: 0x00005B13,
	16351: 0x00005B10,
	16352: 0x00005B16,
	16353: 0x00005B28,
	16354: 0x00005B1A,
	16355: 0x00005B20,
	16356: 0x00005B1E,
	16357: 0x00005BEF,
	16358: 0x00005DAC,
	16359: 0x00005DB1,
	16360: 0x00005DA9,
	16361: 0x00005DA7,
	16362: 0x00005DB5,
	16363: 0x00005DB0,
	16364: 0x00005DAE,
	16365: 0x00005DAA,
	16366: 0x00005DA8,
	16367: 0x00005DB2,
	16368: 0x00005DAD,
	16369: 0x00005DAF,
	16370: 0x00005DB4,
	16371: 0x00005E67,
	16372: 0x00005E68,
	16373: 0x00005E66,
	16374: 0x00005E6F,
	16375: 0x00005EE9,
	16376: 0x00005EE7,
	16377: 0x00005EE6,
	16378: 0x00005EE8,
	16379: 0x00005EE5,
	16380: 0x00005F4B,
	16381: 0x00005FBC,
	16382: 0x0000619D,
	16383: 0x000061A8,
	16384: 0x00006196,
	16385: 0x000061C5,
	16386: 0x000061B4,
	16387: 0x000061C6,
	16388: 0x000061C1,
	16389: 0x000061CC,
	16390: 0x000061BA,
	16391: 0x000061BF,
	16392: 0x000061B8,
	16393: 0x0000618C,
	16394: 0x000064D7,
	16395: 0x000064D6,
	16396: 0x000064D0,
	16397: 0x000064CF,
	16398: 0x000064C9,
	16399: 0x000064BD,
	16400: 0x00006489,
	16401: 0x000064C3,
	16402: 0x000064DB,
	16403: 0x000064F3,
	16404: 0x000064D9,
	16405: 0x00006533,
	16406: 0x0000657F,
	16407: 0x0000657C,
	16408: 0x000065A2,
	16409: 0x000066C8,
	16410: 0x000066BE,
	16411: 0x000066C0,
	16412: 0x000066CA,
	16413: 0x000066CB,
	16414: 0x000066CF,
	16415: 0x000066BD,
	16416: 0x000066BB,
	16417: 0x000066BA,
	16418: 0x000066CC,
	16419: 0x00006723,
	16420: 0x00006A34,
	16421: 0x00006A66,
	16422: 0x00006A49,
	16423: 0x00006A67,
	16424: 0x00006A32,
	16425: 0x00006A68,
	16426: 0x00006A3E,
	16427: 0x00006A5D,
	16428: 0x00006A6D,
	16429: 0x00006A76,
	16430: 0x00006A5B,
	16431: 0x00006A51,
	16432: 0x00006A28,
	16433: 0x00006A5A,
	16434: 0x00006A3B,
	16435: 0x00006A3F,
	16436: 0x00006A41,
	16437: 0x00006A6A,
	16438: 0x00006A64,
	16439: 0x00006A50,
	16440: 0x00006A4F,
	16441: 0x00006A54,
	16442: 0x00006A6F,
	16443: 0x00006A69,
	16444: 0x00006A60,
	16445: 0x00006A3C,
	16446: 0x00006A5E,
	16447: 0x00006A56,
	16448: 0x00006A55,
	16449: 0x00006A4D,
	16450: 0x00006A4E,
	16451: 0x00006A46,
	16452: 0x00006B55,
	16453: 0x00006B54,
	16454: 0x00006B56,
	16455: 0x00006BA7,
	16456: 0x00006BAA,
	16457: 0x00006BAB,
	16458: 0x00006BC8,
	16459: 0x00006BC7,
	16460: 0x00006C04,
	16461: 0x00006C03,
	16462: 0x00006C06,
	16463: 0x00006FAD,
	16464: 0x00006FCB,
	16465: 0x00006FA3,
	16466: 0x00006FC7,
	16467: 0x00006FBC,
	16468: 0x00006FCE,
	16469: 0x00006FC8,
	16470: 0x00006F5E,
	16471: 0x00006FC4,
	16472: 0x00006FBD,
	16473: 0x00006F9E,
	16474: 0x00006FCA,
	16475: 0x00006FA8,
	16476: 0x00007004,
	16477: 0x00006FA5,
	16478: 0x00006FAE,
	16479: 0x00006FBA,
	16480: 0x00006FAC,
	16481: 0x00006FAA,
	16482: 0x00006FCF,
	16483: 0x00006FBF,
	16484: 0x00006FB8,
	16485: 0x00006FA2,
	16486: 0x00006FC9,
	16487: 0x00006FAB,
	16488: 0x00006FCD,
	16489: 0x00006FAF,
	16490: 0x00006FB2,
	16491: 0x00006FB0,
	16492: 0x000071C5,
	16493: 0x000071C2,
	16494: 0x000071BF,
	16495: 0x000071B8,
	16496: 0x000071D6,
	16497: 0x000071C0,
	16498: 0x000071C1,
	16499: 0x000071CB,
	16500: 0x000071D4,
	16501: 0x000071CA,
	16502: 0x000071C7,
	16503: 0x000071CF,
	16504: 0x000071BD,
	16505: 0x000071D8,
	16506: 0x000071BC,
	16507: 0x000071C6,
	16508: 0x000071DA,
	16509: 0x000071DB,
	16510: 0x0000729D,
	16511: 0x0000729E,
	16512: 0x00007369,
	16513: 0x00007366,
	16514: 0x00007367,
	16515: 0x0000736C,
	16516: 0x00007365,
	16517: 0x0000736B,
	16518: 0x0000736A,
	16519: 0x0000747F,
	16520: 0x0000749A,
	16521: 0x000074A0,
	16522: 0x00007494,
	16523: 0x00007492,
	16524: 0x00007495,
	16525: 0x000074A1,
	16526: 0x0000750B,
	16527: 0x00007580,
	16528: 0x0000762F,
	16529: 0x0000762D,
	16530: 0x00007631,
	16531: 0x0000763D,
	16532: 0x00007633,
	16533: 0x0000763C,
	16534: 0x00007635,
	16535: 0x00007632,
	16536: 0x00007630,
	16537: 0x000076BB,
	16538: 0x000076E6,
	16539: 0x0000779A,
	16540: 0x0000779D,
	16541: 0x000077A1,
	16542: 0x0000779C,
	16543: 0x0000779B,
	16544: 0x000077A2,
	16545: 0x000077A3,
	16546: 0x00007795,
	16547: 0x00007799,
	16548: 0x00007797,
	16549: 0x000078DD,
	16550: 0x000078E9,
	16551: 0x000078E5,
	16552: 0x000078EA,
	16553: 0x000078DE,
	16554: 0x000078E3,
	16555: 0x000078DB,
	16556: 0x000078E1,
	16557: 0x000078E2,
	16558: 0x000078ED,
	16559: 0x000078DF,
	16560: 0x000078E0,
	16561: 0x000079A4,
	16562: 0x00007A44,
	16563: 0x00007A48,
	16564: 0x00007A47,
	16565: 0x00007AB6,
	16566: 0x00007AB8,
	16567: 0x00007AB5,
	16568: 0x00007AB1,
	16569: 0x00007AB7,
	16570: 0x00007BDE,
	16571: 0x00007BE3,
	16572: 0x00007BE7,
	16573: 0x00007BDD,
	16574: 0x00007BD5,
	16575: 0x00007BE5,
	16576: 0x00007BDA,
	16577: 0x00007BE8,
	16578: 0x00007BF9,
	16579: 0x00007BD4,
	16580: 0x00007BEA,
	16581: 0x00007BE2,
	16582: 0x00007BDC,
	16583: 0x00007BEB,
	16584: 0x00007BD8,
	16585: 0x00007BDF,
	16586: 0x00007CD2,
	16587: 0x00007CD4,
	16588: 0x00007CD7,
	16589: 0x00007CD0,
	16590: 0x00007CD1,
	16591: 0x00007E12,
	16592: 0x00007E21,
	16593: 0x00007E17,
	16594: 0x00007E0C,
	16595: 0x00007E1F,
	16596: 0x00007E20,
	16597: 0x00007E13,
	16598: 0x00007E0E,
	16599: 0x00007E1C,
	16600: 0x00007E15,
	16601: 0x00007E1A,
	16602: 0x00007E22,
	16603: 0x00007E0B,
	16604: 0x00007E0F,
	16605: 0x00007E16,
	16606: 0x00007E0D,
	16607: 0x00007E14,
	16608: 0x00007E25,
	16609: 0x00007E24,
	16610: 0x00007F43,
	16611: 0x00007F7B,
	16612: 0x00007F7C,
	16613: 0x00007F7A,
	16614: 0x00007FB1,
	16615: 0x00007FEF,
	16616: 0x0000802A,
	16617: 0x00008029,
	16618: 0x0000806C,
	16619: 0x000081B1,
	16620: 0x000081A6,
	16621: 0x000081AE,
	16622: 0x000081B9,
	16623: 0x000081B5,
	16624: 0x000081AB,
	16625: 0x000081B0,
	16626: 0x000081AC,
	16627: 0x000081B4,
	16628: 0x000081B2,
	16629: 0x000081B7,
	16630: 0x000081A7,
	16631: 0x000081F2,
	16632: 0x00008255,
	16633: 0x00008256,
	16634: 0x00008257,
	16635: 0x00008556,
	16636: 0x00008545,
	16637: 0x0000856B,
	16638: 0x0000854D,
	16639: 0x00008553,
	16640: 0x00008561,
	16641: 0x00008558,
	16642: 0x00008540,
	16643: 0x00008546,
	16644: 0x00008564,
	16645: 0x00008541,
	16646: 0x00008562,
	16647: 0x00008544,
	16648: 0x00008551,
	16649: 0x00008547,
	16650: 0x00008563,
	16651: 0x0000853E,
	16652: 0x0000855B,
	16653: 0x00008571,
	16654: 0x0000854E,
	16655: 0x0000856E,
	16656: 0x00008575,
	16657: 0x00008555,
	16658: 0x00008567,
	16659: 0x00008560,
	16660: 0x0000858C,
	16661: 0x00008566,
	16662: 0x0000855D,
	16663: 0x00008554,
	16664: 0x00008565,
	16665: 0x0000856C,
	16666: 0x00008663,
	16667: 0x00008665,
	16668: 0x00008664,
	16669: 0x0000879B,
	16670: 0x0000878F,
	16671: 0x00008797,
	16672: 0x00008793,
	16673: 0x00008792,
	16674: 0x00008788,
	16675: 0x00008781,
	16676: 0x00008796,
	16677: 0x00008798,
	16678: 0x00008779,
	16679: 0x00008787,
	16680: 0x000087A3,
	16681: 0x00008785,
	16682: 0x00008790,
	16683: 0x00008791,
	16684: 0x0000879D,
	16685: 0x00008784,
	16686: 0x00008794,
	16687: 0x0000879C,
	16688: 0x0000879A,
	16689: 0x00008789,
	16690: 0x0000891E,
	16691: 0x00008926,
	16692: 0x00008930,
	16693: 0x0000892D,
	16694: 0x0000892E,
	16695: 0x00008927,
	16696: 0x00008931,
	16697: 0x00008922,
	16698: 0x00008929,
	16699: 0x00008923,
	16700: 0x0000892F,
	16701: 0x0000892C,
	16702: 0x0000891F,
	16703: 0x000089F1,
	16704: 0x00008AE0,
	16705: 0x00008AE2,
	16706: 0x00008AF2,
	16707: 0x00008AF4,
	16708: 0x00008AF5,
	16709: 0x00008ADD,
	16710: 0x00008B14,
	16711: 0x00008AE4,
	16712: 0x00008ADF,
	16713: 0x00008AF0,
	16714: 0x00008AC8,
	16715: 0x00008ADE,
	16716: 0x00008AE1,
	16717: 0x00008AE8,
	16718: 0x00008AFF,
	16719: 0x00008AEF,
	16720: 0x00008AFB,
	16721: 0x00008C91,
	16722: 0x00008C92,
	16723: 0x00008C90,
	16724: 0x00008CF5,
	16725: 0x00008CEE,
	16726: 0x00008CF1,
	16727: 0x00008CF0,
	16728: 0x00008CF3,
	16729: 0x00008D6C,
	16730: 0x00008D6E,
	16731: 0x00008DA5,
	16732: 0x00008DA7,
	16733: 0x00008E33,
	16734: 0x00008E3E,
	16735: 0x00008E38,
	16736: 0x00008E40,
	16737: 0x00008E45,
	16738: 0x00008E36,
	16739: 0x00008E3C,
	16740: 0x00008E3D,
	16741: 0x00008E41,
	16742: 0x00008E30,
	16743: 0x00008E3F,
	16744: 0x00008EBD,
	16745: 0x00008F36,
	16746: 0x00008F2E,
	16747: 0x00008F35,
	16748: 0x00008F32,
	16749: 0x00008F39,
	16750: 0x00008F37,
	16751: 0x00008F34,
	16752: 0x00009076,
	16753: 0x00009079,
	16754: 0x0000907B,
	16755: 0x00009086,
	16756: 0x000090FA,
	16757: 0x00009133,
	16758: 0x00009135,
	16759: 0x00009136,
	16760: 0x00009193,
	16761: 0x00009190,
	16762: 0x00009191,
	16763: 0x0000918D,
	16764: 0x0000918F,
	16765: 0x00009327,
	16766: 0x0000931E,
	16767: 0x00009308,
	16768: 0x0000931F,
	16769: 0x00009306,
	16770: 0x0000930F,
	16771: 0x0000937A,
	16772: 0x00009338,
	16773: 0x0000933C,
	16774: 0x0000931B,
	16775: 0x00009323,
	16776: 0x00009312,
	16777: 0x00009301,
	16778: 0x00009346,
	16779: 0x0000932D,
	16780: 0x0000930E,
	16781: 0x0000930D,
	16782: 0x000092CB,
	16783: 0x0000931D,
	16784: 0x000092FA,
	16785: 0x00009325,
	16786: 0x00009313,
	16787: 0x000092F9,
	16788: 0x000092F7,
	16789: 0x00009334,
	16790: 0x00009302,
	16791: 0x00009324,
	16792: 0x000092FF,
	16793: 0x00009329,
	16794: 0x00009339,
	16795: 0x00009335,
	16796: 0x0000932A,
	16797: 0x00009314,
	16798: 0x0000930C,
	16799: 0x0000930B,
	16800: 0x000092FE,
	16801: 0x00009309,
	16802: 0x00009300,
	16803: 0x000092FB,
	16804: 0x00009316,
	16805: 0x000095BC,
	16806: 0x000095CD,
	16807: 0x000095BE,
	16808: 0x000095B9,
	16809: 0x000095BA,
	16810: 0x000095B6,
	16811: 0x000095BF,
	16812: 0x000095B5,
	16813: 0x000095BD,
	16814: 0x000096A9,
	16815: 0x000096D4,
	16816: 0x0000970B,
	16817: 0x00009712,
	16818: 0x00009710,
	16819: 0x00009799,
	16820: 0x00009797,
	16821: 0x00009794,
	16822: 0x000097F0,
	16823: 0x000097F8,
	16824: 0x00009835,
	16825: 0x0000982F,
	16826: 0x00009832,
	16827: 0x00009924,
	16828: 0x0000991F,
	16829: 0x00009927,
	16830: 0x00009929,
	16831: 0x0000999E,
	16832: 0x000099EE,
	16833: 0x000099EC,
	16834: 0x000099E5,
	16835: 0x000099E4,
	16836: 0x000099F0,
	16837: 0x000099E3,
	16838: 0x000099EA,
	16839: 0x000099E9,
	16840: 0x000099E7,
	16841: 0x00009AB9,
	16842: 0x00009ABF,
	16843: 0x00009AB4,
	16844: 0x00009ABB,
	16845: 0x00009AF6,
	16846: 0x00009AFA,
	16847: 0x00009AF9,
	16848: 0x00009AF7,
	16849: 0x00009B33,
	16850: 0x00009B80,
	16851: 0x00009B85,
	16852: 0x00009B87,
	16853: 0x00009B7C,
	16854: 0x00009B7E,
	16855: 0x00009B7B,
	16856: 0x00009B82,
	16857: 0x00009B93,
	16858: 0x00009B92,
	16859: 0x00009B90,
	16860: 0x00009B7A,
	16861: 0x00009B95,
	16862: 0x00009B7D,
	16863: 0x00009B88,
	16864: 0x00009D25,
	16865: 0x00009D17,
	16866: 0x00009D20,
	16867: 0x00009D1E,
	16868: 0x00009D14,
	16869: 0x00009D29,
	16870: 0x00009D1D,
	16871: 0x00009D18,
	16872: 0x00009D22,
	16873: 0x00009D10,
	16874: 0x00009D19,
	16875: 0x00009D1F,
	16876: 0x00009E88,
	16877: 0x00009E86,
	16878: 0x00009E87,
	16879: 0x00009EAE,
	16880: 0x00009EAD,
	16881: 0x00009ED5,
	16882: 0x00009ED6,
	16883: 0x00009EFA,
	16884: 0x00009F12,
	16885: 0x00009F3D,
	16886: 0x00005126,
	16887: 0x00005125,
	16888: 0x00005122,
	16889: 0x00005124,
	16890: 0x00005120,
	16891: 0x00005129,
	16892: 0x000052F4,
	16893: 0x00005693,
	16894: 0x0000568C,
	16895: 0x0000568D,
	16896: 0x00005686,
	16897: 0x00005684,
	16898: 0x00005683,
	16899: 0x0000567E,
	16900: 0x00005682,
	16901: 0x0000567F,
	16902: 0x00005681,
	16903: 0x000058D6,
	16904: 0x000058D4,
	16905: 0x000058CF,
	16906: 0x000058D2,
	16907: 0x00005B2D,
	16908: 0x00005B25,
	16909: 0x00005B32,
	16910: 0x00005B23,
	16911: 0x00005B2C,
	16912: 0x00005B27,
	16913: 0x00005B26,
	16914: 0x00005B2F,
	16915: 0x00005B2E,
	16916: 0x00005B7B,
	16917: 0x00005BF1,
	16918: 0x00005BF2,
	16919: 0x00005DB7,
	16920: 0x00005E6C,
	16921: 0x00005E6A,
	16922: 0x00005FBE,
	16923: 0x00005FBB,
	16924: 0x000061C3,
	16925: 0x000061B5,
	16926: 0x000061BC,
	16927: 0x000061E7,
	16928: 0x000061E0,
	16929: 0x000061E5,
	16930: 0x000061E4,
	16931: 0x000061E8,
	16932: 0x000061DE,
	16933: 0x000064EF,
	16934: 0x000064E9,
	16935: 0x000064E3,
	16936: 0x000064EB,
	16937: 0x000064E4,
	16938: 0x000064E8,
	16939: 0x00006581,
	16940: 0x00006580,
	16941: 0x000065B6,
	16942: 0x000065DA,
	16943: 0x000066D2,
	16944: 0x00006A8D,
	16945: 0x00006A96,
	16946: 0x00006A81,
	16947: 0x00006AA5,
	16948: 0x00006A89,
	16949: 0x00006A9F,
	16950: 0x00006A9B,
	16951: 0x00006AA1,
	16952: 0x00006A9E,
	16953: 0x00006A87,
	16954: 0x00006A93,
	16955: 0x00006A8E,
	16956: 0x00006A95,
	16957: 0x00006A83,
	16958: 0x00006AA8,
	16959: 0x00006AA4,
	16960: 0x00006A91,
	16961: 0x00006A7F,
	16962: 0x00006AA6,
	16963: 0x00006A9A,
	16964: 0x00006A85,
	16965: 0x00006A8C,
	16966: 0x00006A92,
	16967: 0x00006B5B,
	16968: 0x00006BAD,
	16969: 0x00006C09,
	16970: 0x00006FCC,
	16971: 0x00006FA9,
	16972: 0x00006FF4,
	16973: 0x00006FD4,
	16974: 0x00006FE3,
	16975: 0x00006FDC,
	16976: 0x00006FED,
	16977: 0x00006FE7,
	16978: 0x00006FE6,
	16979: 0x00006FDE,
	16980: 0x00006FF2,
	16981: 0x00006FDD,
	16982: 0x00006FE2,
	16983: 0x00006FE8,
	16984: 0x000071E1,
	16985: 0x000071F1,
	16986: 0x000071E8,
	16987: 0x000071F2,
	16988: 0x000071E4,
	16989: 0x000071F0,
	16990: 0x000071E2,
	16991: 0x00007373,
	16992: 0x0000736E,
	16993: 0x0000736F,
	16994: 0x00007497,
	16995: 0x000074B2,
	16996: 0x000074AB,
	16997: 0x00007490,
	16998: 0x000074AA,
	16999: 0x000074AD,
	17000: 0x000074B1,
	17001: 0x000074A5,
	17002: 0x000074AF,
	17003: 0x00007510,
	17004: 0x00007511,
	17005: 0x00007512,
	17006: 0x0000750F,
	17007: 0x00007584,
	17008: 0x00007643,
	17009: 0x00007648,
	17010: 0x00007649,
	17011: 0x00007647,
	17012: 0x000076A4,
	17013: 0x000076E9,
	17014: 0x000077B5,
	17015: 0x000077AB,
	17016: 0x000077B2,
	17017: 0x000077B7,
	17018: 0x000077B6,
	17019: 0x000077B4,
	17020: 0x000077B1,
	17021: 0x000077A8,
	17022: 0x000077F0,
	17023: 0x000078F3,
	17024: 0x000078FD,
	17025: 0x00007902,
	17026: 0x000078FB,
	17027: 0x000078FC,
	17028: 0x000078F2,
	17029: 0x00007905,
	17030: 0x000078F9,
	17031: 0x000078FE,
	17032: 0x00007904,
	17033: 0x000079AB,
	17034: 0x000079A8,
	17035: 0x00007A5C,
	17036: 0x00007A5B,
	17037: 0x00007A56,
	17038: 0x00007A58,
	17039: 0x00007A54,
	17040: 0x00007A5A,
	17041: 0x00007ABE,
	17042: 0x00007AC0,
	17043: 0x00007AC1,
	17044: 0x00007C05,
	17045: 0x00007C0F,
	17046: 0x00007BF2,
	17047: 0x00007C00,
	17048: 0x00007BFF,
	17049: 0x00007BFB,
	17050: 0x00007C0E,
	17051: 0x00007BF4,
	17052: 0x00007C0B,
	17053: 0x00007BF3,
	17054: 0x00007C02,
	17055: 0x00007C09,
	17056: 0x00007C03,
	17057: 0x00007C01,
	17058: 0x00007BF8,
	17059: 0x00007BFD,
	17060: 0x00007C06,
	17061: 0x00007BF0,
	17062: 0x00007BF1,
	17063: 0x00007C10,
	17064: 0x00007C0A,
	17065: 0x00007CE8,
	17066: 0x00007E2D,
	17067: 0x00007E3C,
	17068: 0x00007E42,
	17069: 0x00007E33,
	17070: 0x00009848,
	17071: 0x00007E38,
	17072: 0x00007E2A,
	17073: 0x00007E49,
	17074: 0x00007E40,
	17075: 0x00007E47,
	17076: 0x00007E29,
	17077: 0x00007E4C,
	17078: 0x00007E30,
	17079: 0x00007E3B,
	17080: 0x00007E36,
	17081: 0x00007E44,
	17082: 0x00007E3A,
	17083: 0x00007F45,
	17084: 0x00007F7F,
	17085: 0x00007F7E,
	17086: 0x00007F7D,
	17087: 0x00007FF4,
	17088: 0x00007FF2,
	17089: 0x0000802C,
	17090: 0x000081BB,
	17091: 0x000081C4,
	17092: 0x000081CC,
	17093: 0x000081CA,
	17094: 0x000081C5,
	17095: 0x000081C7,
	17096: 0x000081BC,
	17097: 0x000081E9,
	17098: 0x0000825B,
	17099: 0x0000825A,
	17100: 0x0000825C,
	17101: 0x00008583,
	17102: 0x00008580,
	17103: 0x0000858F,
	17104: 0x000085A7,
	17105: 0x00008595,
	17106: 0x000085A0,
	17107: 0x0000858B,
	17108: 0x000085A3,
	17109: 0x0000857B,
	17110: 0x000085A4,
	17111: 0x0000859A,
	17112: 0x0000859E,
	17113: 0x00008577,
	17114: 0x0000857C,
	17115: 0x00008589,
	17116: 0x000085A1,
	17117: 0x0000857A,
	17118: 0x00008578,
	17119: 0x00008557,
	17120: 0x0000858E,
	17121: 0x00008596,
	17122: 0x00008586,
	17123: 0x0000858D,
	17124: 0x00008599,
	17125: 0x0000859D,
	17126: 0x00008581,
	17127: 0x000085A2,
	17128: 0x00008582,
	17129: 0x00008588,
	17130: 0x00008585,
	17131: 0x00008579,
	17132: 0x00008576,
	17133: 0x00008598,
	17134: 0x00008590,
	17135: 0x0000859F,
	17136: 0x00008668,
	17137: 0x000087BE,
	17138: 0x000087AA,
	17139: 0x000087AD,
	17140: 0x000087C5,
	17141: 0x000087B0,
	17142: 0x000087AC,
	17143: 0x000087B9,
	17144: 0x000087B5,
	17145: 0x000087BC,
	17146: 0x000087AE,
	17147: 0x000087C9,
	17148: 0x000087C3,
	17149: 0x000087C2,
	17150: 0x000087CC,
	17151: 0x000087B7,
	17152: 0x000087AF,
	17153: 0x000087C4,
	17154: 0x000087CA,
	17155: 0x000087B4,
	17156: 0x000087B6,
	17157: 0x000087BF,
	17158: 0x000087B8,
	17159: 0x000087BD,
	17160: 0x000087DE,
	17161: 0x000087B2,
	17162: 0x00008935,
	17163: 0x00008933,
	17164: 0x0000893C,
	17165: 0x0000893E,
	17166: 0x00008941,
	17167: 0x00008952,
	17168: 0x00008937,
	17169: 0x00008942,
	17170: 0x000089AD,
	17171: 0x000089AF,
	17172: 0x000089AE,
	17173: 0x000089F2,
	17174: 0x000089F3,
	17175: 0x00008B1E,
	17176: 0x00008B18,
	17177: 0x00008B16,
	17178: 0x00008B11,
	17179: 0x00008B05,
	17180: 0x00008B0B,
	17181: 0x00008B22,
	17182: 0x00008B0F,
	17183: 0x00008B12,
	17184: 0x00008B15,
	17185: 0x00008B07,
	17186: 0x00008B0D,
	17187: 0x00008B08,
	17188: 0x00008B06,
	17189: 0x00008B1C,
	17190: 0x00008B13,
	17191: 0x00008B1A,
	17192: 0x00008C4F,
	17193: 0x00008C70,
	17194: 0x00008C72,
	17195: 0x00008C71,
	17196: 0x00008C6F,
	17197: 0x00008C95,
	17198: 0x00008C94,
	17199: 0x00008CF9,
	17200: 0x00008D6F,
	17201: 0x00008E4E,
	17202: 0x00008E4D,
	17203: 0x00008E53,
	17204: 0x00008E50,
	17205: 0x00008E4C,
	17206: 0x00008E47,
	17207: 0x00008F43,
	17208: 0x00008F40,
	17209: 0x00009085,
	17210: 0x0000907E,
	17211: 0x00009138,
	17212: 0x0000919A,
	17213: 0x000091A2,
	17214: 0x0000919B,
	17215: 0x00009199,
	17216: 0x0000919F,
	17217: 0x000091A1,
	17218: 0x0000919D,
	17219: 0x000091A0,
	17220: 0x000093A1,
	17221: 0x00009383,
	17222: 0x000093AF,
	17223: 0x00009364,
	17224: 0x00009356,
	17225: 0x00009347,
	17226: 0x0000937C,
	17227: 0x00009358,
	17228: 0x0000935C,
	17229: 0x00009376,
	17230: 0x00009349,
	17231: 0x00009350,
	17232: 0x00009351,
	17233: 0x00009360,
	17234: 0x0000936D,
	17235: 0x0000938F,
	17236: 0x0000934C,
	17237: 0x0000936A,
	17238: 0x00009379,
	17239: 0x00009357,
	17240: 0x00009355,
	17241: 0x00009352,
	17242: 0x0000934F,
	17243: 0x00009371,
	17244: 0x00009377,
	17245: 0x0000937B,
	17246: 0x00009361,
	17247: 0x0000935E,
	17248: 0x00009363,
	17249: 0x00009367,
	17250: 0x00009380,
	17251: 0x0000934E,
	17252: 0x00009359,
	17253: 0x000095C7,
	17254: 0x000095C0,
	17255: 0x000095C9,
	17256: 0x000095C3,
	17257: 0x000095C5,
	17258: 0x000095B7,
	17259: 0x000096AE,
	17260: 0x000096B0,
	17261: 0x000096AC,
	17262: 0x00009720,
	17263: 0x0000971F,
	17264: 0x00009718,
	17265: 0x0000971D,
	17266: 0x00009719,
	17267: 0x0000979A,
	17268: 0x000097A1,
	17269: 0x0000979C,
	17270: 0x0000979E,
	17271: 0x0000979D,
	17272: 0x000097D5,
	17273: 0x000097D4,
	17274: 0x000097F1,
	17275: 0x00009841,
	17276: 0x00009844,
	17277: 0x0000984A,
	17278: 0x00009849,
	17279: 0x00009845,
	17280: 0x00009843,
	17281: 0x00009925,
	17282: 0x0000992B,
	17283: 0x0000992C,
	17284: 0x0000992A,
	17285: 0x00009933,
	17286: 0x00009932,
	17287: 0x0000992F,
	17288: 0x0000992D,
	17289: 0x00009931,
	17290: 0x00009930,
	17291: 0x00009998,
	17292: 0x000099A3,
	17293: 0x000099A1,
	17294: 0x00009A02,
	17295: 0x000099FA,
	17296: 0x000099F4,
	17297: 0x000099F7,
	17298: 0x000099F9,
	17299: 0x000099F8,
	17300: 0x000099F6,
	17301: 0x000099FB,
	17302: 0x000099FD,
	17303: 0x000099FE,
	17304: 0x000099FC,
	17305: 0x00009A03,
	17306: 0x00009ABE,
	17307: 0x00009AFE,
	17308: 0x00009AFD,
	17309: 0x00009B01,
	17310: 0x00009AFC,
	17311: 0x00009B48,
	17312: 0x00009B9A,
	17313: 0x00009BA8,
	17314: 0x00009B9E,
	17315: 0x00009B9B,
	17316: 0x00009BA6,
	17317: 0x00009BA1,
	17318: 0x00009BA5,
	17319: 0x00009BA4,
	17320: 0x00009B86,
	17321: 0x00009BA2,
	17322: 0x00009BA0,
	17323: 0x00009BAF,
	17324: 0x00009D33,
	17325: 0x00009D41,
	17326: 0x00009D67,
	17327: 0x00009D36,
	17328: 0x00009D2E,
	17329: 0x00009D2F,
	17330: 0x00009D31,
	17331: 0x00009D38,
	17332: 0x00009D30,
	17333: 0x00009D45,
	17334: 0x00009D42,
	17335: 0x00009D43,
	17336: 0x00009D3E,
	17337: 0x00009D37,
	17338: 0x00009D40,
	17339: 0x00009D3D,
	17340: 0x00007FF5,
	17341: 0x00009D2D,
	17342: 0x00009E8A,
	17343: 0x00009E89,
	17344: 0x00009E8D,
	17345: 0x00009EB0,
	17346: 0x00009EC8,
	17347: 0x00009EDA,
	17348: 0x00009EFB,
	17349: 0x00009EFF,
	17350: 0x00009F24,
	17351: 0x00009F23,
	17352: 0x00009F22,
	17353: 0x00009F54,
	17354: 0x00009FA0,
	17355: 0x00005131,
	17356: 0x0000512D,
	17357: 0x0000512E,
	17358: 0x00005698,
	17359: 0x0000569C,
	17360: 0x00005697,
	17361: 0x0000569A,
	17362: 0x0000569D,
	17363: 0x00005699,
	17364: 0x00005970,
	17365: 0x00005B3C,
	17366: 0x00005C69,
	17367: 0x00005C6A,
	17368: 0x00005DC0,
	17369: 0x00005E6D,
	17370: 0x00005E6E,
	17371: 0x000061D8,
	17372: 0x000061DF,
	17373: 0x000061ED,
	17374: 0x000061EE,
	17375: 0x000061F1,
	17376: 0x000061EA,
	17377: 0x000061F0,
	17378: 0x000061EB,
	17379: 0x000061D6,
	17380: 0x000061E9,
	17381: 0x000064FF,
	17382: 0x00006504,
	17383: 0x000064FD,
	17384: 0x000064F8,
	17385: 0x00006501,
	17386: 0x00006503,
	17387: 0x000064FC,
	17388: 0x00006594,
	17389: 0x000065DB,
	17390: 0x000066DA,
	17391: 0x000066DB,
	17392: 0x000066D8,
	17393: 0x00006AC5,
	17394: 0x00006AB9,
	17395: 0x00006ABD,
	17396: 0x00006AE1,
	17397: 0x00006AC6,
	17398: 0x00006ABA,
	17399: 0x00006AB6,
	17400: 0x00006AB7,
	17401: 0x00006AC7,
	17402: 0x00006AB4,
	17403: 0x00006AAD,
	17404: 0x00006B5E,
	17405: 0x00006BC9,
	17406: 0x00006C0B,
	17407: 0x00007007,
	17408: 0x0000700C,
	17409: 0x0000700D,
	17410: 0x00007001,
	17411: 0x00007005,
	17412: 0x00007014,
	17413: 0x0000700E,
	17414: 0x00006FFF,
	17415: 0x00007000,
	17416: 0x00006FFB,
	17417: 0x00007026,
	17418: 0x00006FFC,
	17419: 0x00006FF7,
	17420: 0x0000700A,
	17421: 0x00007201,
	17422: 0x000071FF,
	17423: 0x000071F9,
	17424: 0x00007203,
	17425: 0x000071FD,
	17426: 0x00007376,
	17427: 0x000074B8,
	17428: 0x000074C0,
	17429: 0x000074B5,
	17430: 0x000074C1,
	17431: 0x000074BE,
	17432: 0x000074B6,
	17433: 0x000074BB,
	17434: 0x000074C2,
	17435: 0x00007514,
	17436: 0x00007513,
	17437: 0x0000765C,
	17438: 0x00007664,
	17439: 0x00007659,
	17440: 0x00007650,
	17441: 0x00007653,
	17442: 0x00007657,
	17443: 0x0000765A,
	17444: 0x000076A6,
	17445: 0x000076BD,
	17446: 0x000076EC,
	17447: 0x000077C2,
	17448: 0x000077BA,
	17449: 0x000078FF,
	17450: 0x0000790C,
	17451: 0x00007913,
	17452: 0x00007914,
	17453: 0x00007909,
	17454: 0x00007910,
	17455: 0x00007912,
	17456: 0x00007911,
	17457: 0x000079AD,
	17458: 0x000079AC,
	17459: 0x00007A5F,
	17460: 0x00007C1C,
	17461: 0x00007C29,
	17462: 0x00007C19,
	17463: 0x00007C20,
	17464: 0x00007C1F,
	17465: 0x00007C2D,
	17466: 0x00007C1D,
	17467: 0x00007C26,
	17468: 0x00007C28,
	17469: 0x00007C22,
	17470: 0x00007C25,
	17471: 0x00007C30,
	17472: 0x00007E5C,
	17473: 0x00007E50,
	17474: 0x00007E56,
	17475: 0x00007E63,
	17476: 0x00007E58,
	17477: 0x00007E62,
	17478: 0x00007E5F,
	17479: 0x00007E51,
	17480: 0x00007E60,
	17481: 0x00007E57,
	17482: 0x00007E53,
	17483: 0x00007FB5,
	17484: 0x00007FB3,
	17485: 0x00007FF7,
	17486: 0x00007FF8,
	17487: 0x00008075,
	17488: 0x000081D1,
	17489: 0x000081D2,
	17490: 0x000081D0,
	17491: 0x0000825F,
	17492: 0x0000825E,
	17493: 0x000085B4,
	17494: 0x000085C6,
	17495: 0x000085C0,
	17496: 0x000085C3,
	17497: 0x000085C2,
	17498: 0x000085B3,
	17499: 0x000085B5,
	17500: 0x000085BD,
	17501: 0x000085C7,
	17502: 0x000085C4,
	17503: 0x000085BF,
	17504: 0x000085CB,
	17505: 0x000085CE,
	17506: 0x000085C8,
	17507: 0x000085C5,
	17508: 0x000085B1,
	17509: 0x000085B6,
	17510: 0x000085D2,
	17511: 0x00008624,
	17512: 0x000085B8,
	17513: 0x000085B7,
	17514: 0x000085BE,
	17515: 0x00008669,
	17516: 0x000087E7,
	17517: 0x000087E6,
	17518: 0x000087E2,
	17519: 0x000087DB,
	17520: 0x000087EB,
	17521: 0x000087EA,
	17522: 0x000087E5,
	17523: 0x000087DF,
	17524: 0x000087F3,
	17525: 0x000087E4,
	17526: 0x000087D4,
	17527: 0x000087DC,
	17528: 0x000087D3,
	17529: 0x000087ED,
	17530: 0x000087D8,
	17531: 0x000087E3,
	17532: 0x000087A4,
	17533: 0x000087D7,
	17534: 0x000087D9,
	17535: 0x00008801,
	17536: 0x000087F4,
	17537: 0x000087E8,
	17538: 0x000087DD,
	17539: 0x00008953,
	17540: 0x0000894B,
	17541: 0x0000894F,
	17542: 0x0000894C,
	17543: 0x00008946,
	17544: 0x00008950,
	17545: 0x00008951,
	17546: 0x00008949,
	17547: 0x00008B2A,
	17548: 0x00008B27,
	17549: 0x00008B23,
	17550: 0x00008B33,
	17551: 0x00008B30,
	17552: 0x00008B35,
	17553: 0x00008B47,
	17554: 0x00008B2F,
	17555: 0x00008B3C,
	17556: 0x00008B3E,
	17557: 0x00008B31,
	17558: 0x00008B25,
	17559: 0x00008B37,
	17560: 0x00008B26,
	17561: 0x00008B36,
	17562: 0x00008B2E,
	17563: 0x00008B24,
	17564: 0x00008B3B,
	17565: 0x00008B3D,
	17566: 0x00008B3A,
	17567: 0x00008C42,
	17568: 0x00008C75,
	17569: 0x00008C99,
	17570: 0x00008C98,
	17571: 0x00008C97,
	17572: 0x00008CFE,
	17573: 0x00008D04,
	17574: 0x00008D02,
	17575: 0x00008D00,
	17576: 0x00008E5C,
	17577: 0x00008E62,
	17578: 0x00008E60,
	17579: 0x00008E57,
	17580: 0x00008E56,
	17581: 0x00008E5E,
	17582: 0x00008E65,
	17583: 0x00008E67,
	17584: 0x00008E5B,
	17585: 0x00008E5A,
	17586: 0x00008E61,
	17587: 0x00008E5D,
	17588: 0x00008E69,
	17589: 0x00008E54,
	17590: 0x00008F46,
	17591: 0x00008F47,
	17592: 0x00008F48,
	17593: 0x00008F4B,
	17594: 0x00009128,
	17595: 0x0000913A,
	17596: 0x0000913B,
	17597: 0x0000913E,
	17598: 0x000091A8,
	17599: 0x000091A5,
	17600: 0x000091A7,
	17601: 0x000091AF,
	17602: 0x000091AA,
	17603: 0x000093B5,
	17604: 0x0000938C,
	17605: 0x00009392,
	17606: 0x000093B7,
	17607: 0x0000939B,
	17608: 0x0000939D,
	17609: 0x00009389,
	17610: 0x000093A7,
	17611: 0x0000938E,
	17612: 0x000093AA,
	17613: 0x0000939E,
	17614: 0x000093A6,
	17615: 0x00009395,
	17616: 0x00009388,
	17617: 0x00009399,
	17618: 0x0000939F,
	17619: 0x0000938D,
	17620: 0x000093B1,
	17621: 0x00009391,
	17622: 0x000093B2,
	17623: 0x000093A4,
	17624: 0x000093A8,
	17625: 0x000093B4,
	17626: 0x000093A3,
	17627: 0x000093A5,
	17628: 0x000095D2,
	17629: 0x000095D3,
	17630: 0x000095D1,
	17631: 0x000096B3,
	17632: 0x000096D7,
	17633: 0x000096DA,
	17634: 0x00005DC2,
	17635: 0x000096DF,
	17636: 0x000096D8,
	17637: 0x000096DD,
	17638: 0x00009723,
	17639: 0x00009722,
	17640: 0x00009725,
	17641: 0x000097AC,
	17642: 0x000097AE,
	17643: 0x000097A8,
	17644: 0x000097AB,
	17645: 0x000097A4,
	17646: 0x000097AA,
	17647: 0x000097A2,
	17648: 0x000097A5,
	17649: 0x000097D7,
	17650: 0x000097D9,
	17651: 0x000097D6,
	17652: 0x000097D8,
	17653: 0x000097FA,
	17654: 0x00009850,
	17655: 0x00009851,
	17656: 0x00009852,
	17657: 0x000098B8,
	17658: 0x00009941,
	17659: 0x0000993C,
	17660: 0x0000993A,
	17661: 0x00009A0F,
	17662: 0x00009A0B,
	17663: 0x00009A09,
	17664: 0x00009A0D,
	17665: 0x00009A04,
	17666: 0x00009A11,
	17667: 0x00009A0A,
	17668: 0x00009A05,
	17669: 0x00009A07,
	17670: 0x00009A06,
	17671: 0x00009AC0,
	17672: 0x00009ADC,
	17673: 0x00009B08,
	17674: 0x00009B04,
	17675: 0x00009B05,
	17676: 0x00009B29,
	17677: 0x00009B35,
	17678: 0x00009B4A,
	17679: 0x00009B4C,
	17680: 0x00009B4B,
	17681: 0x00009BC7,
	17682: 0x00009BC6,
	17683: 0x00009BC3,
	17684: 0x00009BBF,
	17685: 0x00009BC1,
	17686: 0x00009BB5,
	17687: 0x00009BB8,
	17688: 0x00009BD3,
	17689: 0x00009BB6,
	17690: 0x00009BC4,
	17691: 0x00009BB9,
	17692: 0x00009BBD,
	17693: 0x00009D5C,
	17694: 0x00009D53,
	17695: 0x00009D4F,
	17696: 0x00009D4A,
	17697: 0x00009D5B,
	17698: 0x00009D4B,
	17699: 0x00009D59,
	17700: 0x00009D56,
	17701: 0x00009D4C,
	17702: 0x00009D57,
	17703: 0x00009D52,
	17704: 0x00009D54,
	17705: 0x00009D5F,
	17706: 0x00009D58,
	17707: 0x00009D5A,
	17708: 0x00009E8E,
	17709: 0x00009E8C,
	17710: 0x00009EDF,
	17711: 0x00009F01,
	17712: 0x00009F00,
	17713: 0x00009F16,
	17714: 0x00009F25,
	17715: 0x00009F2B,
	17716: 0x00009F2A,
	17717: 0x00009F29,
	17718: 0x00009F28,
	17719: 0x00009F4C,
	17720: 0x00009F55,
	17721: 0x00005134,
	17722: 0x00005135,
	17723: 0x00005296,
	17724: 0x000052F7,
	17725: 0x000053B4,
	17726: 0x000056AB,
	17727: 0x000056AD,
	17728: 0x000056A6,
	17729: 0x000056A7,
	17730: 0x000056AA,
	17731: 0x000056AC,
	17732: 0x000058DA,
	17733: 0x000058DD,
	17734: 0x000058DB,
	17735: 0x00005912,
	17736: 0x00005B3D,
	17737: 0x00005B3E,
	17738: 0x00005B3F,
	17739: 0x00005DC3,
	17740: 0x00005E70,
	17741: 0x00005FBF,
	17742: 0x000061FB,
	17743: 0x00006507,
	17744: 0x00006510,
	17745: 0x0000650D,
	17746: 0x00006509,
	17747: 0x0000650C,
	17748: 0x0000650E,
	17749: 0x00006584,
	17750: 0x000065DE,
	17751: 0x000065DD,
	17752: 0x000066DE,
	17753: 0x00006AE7,
	17754: 0x00006AE0,
	17755: 0x00006ACC,
	17756: 0x00006AD1,
	17757: 0x00006AD9,
	17758: 0x00006ACB,
	17759: 0x00006ADF,
	17760: 0x00006ADC,
	17761: 0x00006AD0,
	17762: 0x00006AEB,
	17763: 0x00006ACF,
	17764: 0x00006ACD,
	17765: 0x00006ADE,
	17766: 0x00006B60,
	17767: 0x00006BB0,
	17768: 0x00006C0C,
	17769: 0x00007019,
	17770: 0x00007027,
	17771: 0x00007020,
	17772: 0x00007016,
	17773: 0x0000702B,
	17774: 0x00007021,
	17775: 0x00007022,
	17776: 0x00007023,
	17777: 0x00007029,
	17778: 0x00007017,
	17779: 0x00007024,
	17780: 0x0000701C,
	17781: 0x0000702A,
	17782: 0x0000720C,
	17783: 0x0000720A,
	17784: 0x00007207,
	17785: 0x00007202,
	17786: 0x00007205,
	17787: 0x000072A5,
	17788: 0x000072A6,
	17789: 0x000072A4,
	17790: 0x000072A3,
	17791: 0x000072A1,
	17792: 0x000074CB,
	17793: 0x000074C5,
	17794: 0x000074B7,
	17795: 0x000074C3,
	17796: 0x00007516,
	17797: 0x00007660,
	17798: 0x000077C9,
	17799: 0x000077CA,
	17800: 0x000077C4,
	17801: 0x000077F1,
	17802: 0x0000791D,
	17803: 0x0000791B,
	17804: 0x00007921,
	17805: 0x0000791C,
	17806: 0x00007917,
	17807: 0x0000791E,
	17808: 0x000079B0,
	17809: 0x00007A67,
	17810: 0x00007A68,
	17811: 0x00007C33,
	17812: 0x00007C3C,
	17813: 0x00007C39,
	17814: 0x00007C2C,
	17815: 0x00007C3B,
	17816: 0x00007CEC,
	17817: 0x00007CEA,
	17818: 0x00007E76,
	17819: 0x00007E75,
	17820: 0x00007E78,
	17821: 0x00007E70,
	17822: 0x00007E77,
	17823: 0x00007E6F,
	17824: 0x00007E7A,
	17825: 0x00007E72,
	17826: 0x00007E74,
	17827: 0x00007E68,
	17828: 0x00007F4B,
	17829: 0x00007F4A,
	17830: 0x00007F83,
	17831: 0x00007F86,
	17832: 0x00007FB7,
	17833: 0x00007FFD,
	17834: 0x00007FFE,
	17835: 0x00008078,
	17836: 0x000081D7,
	17837: 0x000081D5,
	17838: 0x00008264,
	17839: 0x00008261,
	17840: 0x00008263,
	17841: 0x000085EB,
	17842: 0x000085F1,
	17843: 0x000085ED,
	17844: 0x000085D9,
	17845: 0x000085E1,
	17846: 0x000085E8,
	17847: 0x000085DA,
	17848: 0x000085D7,
	17849: 0x000085EC,
	17850: 0x000085F2,
	17851: 0x000085F8,
	17852: 0x000085D8,
	17853: 0x000085DF,
	17854: 0x000085E3,
	17855: 0x000085DC,
	17856: 0x000085D1,
	17857: 0x000085F0,
	17858: 0x000085E6,
	17859: 0x000085EF,
	17860: 0x000085DE,
	17861: 0x000085E2,
	17862: 0x00008800,
	17863: 0x000087FA,
	17864: 0x00008803,
	17865: 0x000087F6,
	17866: 0x000087F7,
	17867: 0x00008809,
	17868: 0x0000880C,
	17869: 0x0000880B,
	17870: 0x00008806,
	17871: 0x000087FC,
	17872: 0x00008808,
	17873: 0x000087FF,
	17874: 0x0000880A,
	17875: 0x00008802,
	17876: 0x00008962,
	17877: 0x0000895A,
	17878: 0x0000895B,
	17879: 0x00008957,
	17880: 0x00008961,
	17881: 0x0000895C,
	17882: 0x00008958,
	17883: 0x0000895D,
	17884: 0x00008959,
	17885: 0x00008988,
	17886: 0x000089B7,
	17887: 0x000089B6,
	17888: 0x000089F6,
	17889: 0x00008B50,
	17890: 0x00008B48,
	17891: 0x00008B4A,
	17892: 0x00008B40,
	17893: 0x00008B53,
	17894: 0x00008B56,
	17895: 0x00008B54,
	17896: 0x00008B4B,
	17897: 0x00008B55,
	17898: 0x00008B51,
	17899: 0x00008B42,
	17900: 0x00008B52,
	17901: 0x00008B57,
	17902: 0x00008C43,
	17903: 0x00008C77,
	17904: 0x00008C76,
	17905: 0x00008C9A,
	17906: 0x00008D06,
	17907: 0x00008D07,
	17908: 0x00008D09,
	17909: 0x00008DAC,
	17910: 0x00008DAA,
	17911: 0x00008DAD,
	17912: 0x00008DAB,
	17913: 0x00008E6D,
	17914: 0x00008E78,
	17915: 0x00008E73,
	17916: 0x00008E6A,
	17917: 0x00008E6F,
	17918: 0x00008E7B,
	17919: 0x00008EC2,
	17920: 0x00008F52,
	17921: 0x00008F51,
	17922: 0x00008F4F,
	17923: 0x00008F50,
	17924: 0x00008F53,
	17925: 0x00008FB4,
	17926: 0x00009140,
	17927: 0x0000913F,
	17928: 0x000091B0,
	17929: 0x000091AD,
	17930: 0x000093DE,
	17931: 0x000093C7,
	17932: 0x000093CF,
	17933: 0x000093C2,
	17934: 0x000093DA,
	17935: 0x000093D0,
	17936: 0x000093F9,
	17937: 0x000093EC,
	17938: 0x000093CC,
	17939: 0x000093D9,
	17940: 0x000093A9,
	17941: 0x000093E6,
	17942: 0x000093CA,
	17943: 0x000093D4,
	17944: 0x000093EE,
	17945: 0x000093E3,
	17946: 0x000093D5,
	17947: 0x000093C4,
	17948: 0x000093CE,
	17949: 0x000093C0,
	17950: 0x000093D2,
	17951: 0x000093E7,
	17952: 0x0000957D,
	17953: 0x000095DA,
	17954: 0x000095DB,
	17955: 0x000096E1,
	17956: 0x00009729,
	17957: 0x0000972B,
	17958: 0x0000972C,
	17959: 0x00009728,
	17960: 0x00009726,
	17961: 0x000097B3,
	17962: 0x000097B7,
	17963: 0x000097B6,
	17964: 0x000097DD,
	17965: 0x000097DE,
	17966: 0x000097DF,
	17967: 0x0000985C,
	17968: 0x00009859,
	17969: 0x0000985D,
	17970: 0x00009857,
	17971: 0x000098BF,
	17972: 0x000098BD,
	17973: 0x000098BB,
	17974: 0x000098BE,
	17975: 0x00009948,
	17976: 0x00009947,
	17977: 0x00009943,
	17978: 0x000099A6,
	17979: 0x000099A7,
	17980: 0x00009A1A,
	17981: 0x00009A15,
	17982: 0x00009A25,
	17983: 0x00009A1D,
	17984: 0x00009A24,
	17985: 0x00009A1B,
	17986: 0x00009A22,
	17987: 0x00009A20,
	17988: 0x00009A27,
	17989: 0x00009A23,
	17990: 0x00009A1E,
	17991: 0x00009A1C,
	17992: 0x00009A14,
	17993: 0x00009AC2,
	17994: 0x00009B0B,
	17995: 0x00009B0A,
	17996: 0x00009B0E,
	17997: 0x00009B0C,
	17998: 0x00009B37,
	17999: 0x00009BEA,
	18000: 0x00009BEB,
	18001: 0x00009BE0,
	18002: 0x00009BDE,
	18003: 0x00009BE4,
	18004: 0x00009BE6,
	18005: 0x00009BE2,
	18006: 0x00009BF0,
	18007: 0x00009BD4,
	18008: 0x00009BD7,
	18009: 0x00009BEC,
	18010: 0x00009BDC,
	18011: 0x00009BD9,
	18012: 0x00009BE5,
	18013: 0x00009BD5,
	18014: 0x00009BE1,
	18015: 0x00009BDA,
	18016: 0x00009D77,
	18017: 0x00009D81,
	18018: 0x00009D8A,
	18019: 0x00009D84,
	18020: 0x00009D88,
	18021: 0x00009D71,
	18022: 0x00009D80,
	18023: 0x00009D78,
	18024: 0x00009D86,
	18025: 0x00009D8B,
	18026: 0x00009D8C,
	18027: 0x00009D7D,
	18028: 0x00009D6B,
	18029: 0x00009D74,
	18030: 0x00009D75,
	18031: 0x00009D70,
	18032: 0x00009D69,
	18033: 0x00009D85,
	18034: 0x00009D73,
	18035: 0x00009D7B,
	18036: 0x00009D82,
	18037: 0x00009D6F,
	18038: 0x00009D79,
	18039: 0x00009D7F,
	18040: 0x00009D87,
	18041: 0x00009D68,
	18042: 0x00009E94,
	18043: 0x00009E91,
	18044: 0x00009EC0,
	18045: 0x00009EFC,
	18046: 0x00009F2D,
	18047: 0x00009F40,
	18048: 0x00009F41,
	18049: 0x00009F4D,
	18050: 0x00009F56,
	18051: 0x00009F57,
	18052: 0x00009F58,
	18053: 0x00005337,
	18054: 0x000056B2,
	18055: 0x000056B5,
	18056: 0x000056B3,
	18057: 0x000058E3,
	18058: 0x00005B45,
	18059: 0x00005DC6,
	18060: 0x00005DC7,
	18061: 0x00005EEE,
	18062: 0x00005EEF,
	18063: 0x00005FC0,
	18064: 0x00005FC1,
	18065: 0x000061F9,
	18066: 0x00006517,
	18067: 0x00006516,
	18068: 0x00006515,
	18069: 0x00006513,
	18070: 0x000065DF,
	18071: 0x000066E8,
	18072: 0x000066E3,
	18073: 0x000066E4,
	18074: 0x00006AF3,
	18075: 0x00006AF0,
	18076: 0x00006AEA,
	18077: 0x00006AE8,
	18078: 0x00006AF9,
	18079: 0x00006AF1,
	18080: 0x00006AEE,
	18081: 0x00006AEF,
	18082: 0x0000703C,
	18083: 0x00007035,
	18084: 0x0000702F,
	18085: 0x00007037,
	18086: 0x00007034,
	18087: 0x00007031,
	18088: 0x00007042,
	18089: 0x00007038,
	18090: 0x0000703F,
	18091: 0x0000703A,
	18092: 0x00007039,
	18093: 0x00007040,
	18094: 0x0000703B,
	18095: 0x00007033,
	18096: 0x00007041,
	18097: 0x00007213,
	18098: 0x00007214,
	18099: 0x000072A8,
	18100: 0x0000737D,
	18101: 0x0000737C,
	18102: 0x000074BA,
	18103: 0x000076AB,
	18104: 0x000076AA,
	18105: 0x000076BE,
	18106: 0x000076ED,
	18107: 0x000077CC,
	18108: 0x000077CE,
	18109: 0x000077CF,
	18110: 0x000077CD,
	18111: 0x000077F2,
	18112: 0x00007925,
	18113: 0x00007923,
	18114: 0x00007927,
	18115: 0x00007928,
	18116: 0x00007924,
	18117: 0x00007929,
	18118: 0x000079B2,
	18119: 0x00007A6E,
	18120: 0x00007A6C,
	18121: 0x00007A6D,
	18122: 0x00007AF7,
	18123: 0x00007C49,
	18124: 0x00007C48,
	18125: 0x00007C4A,
	18126: 0x00007C47,
	18127: 0x00007C45,
	18128: 0x00007CEE,
	18129: 0x00007E7B,
	18130: 0x00007E7E,
	18131: 0x00007E81,
	18132: 0x00007E80,
	18133: 0x00007FBA,
	18134: 0x00007FFF,
	18135: 0x00008079,
	18136: 0x000081DB,
	18137: 0x000081D9,
	18138: 0x0000820B,
	18139: 0x00008268,
	18140: 0x00008269,
	18141: 0x00008622,
	18142: 0x000085FF,
	18143: 0x00008601,
	18144: 0x000085FE,
	18145: 0x0000861B,
	18146: 0x00008600,
	18147: 0x000085F6,
	18148: 0x00008604,
	18149: 0x00008609,
	18150: 0x00008605,
	18151: 0x0000860C,
	18152: 0x000085FD,
	18153: 0x00008819,
	18154: 0x00008810,
	18155: 0x00008811,
	18156: 0x00008817,
	18157: 0x00008813,
	18158: 0x00008816,
	18159: 0x00008963,
	18160: 0x00008966,
	18161: 0x000089B9,
	18162: 0x000089F7,
	18163: 0x00008B60,
	18164: 0x00008B6A,
	18165: 0x00008B5D,
	18166: 0x00008B68,
	18167: 0x00008B63,
	18168: 0x00008B65,
	18169: 0x00008B67,
	18170: 0x00008B6D,
	18171: 0x00008DAE,
	18172: 0x00008E86,
	18173: 0x00008E88,
	18174: 0x00008E84,
	18175: 0x00008F59,
	18176: 0x00008F56,
	18177: 0x00008F57,
	18178: 0x00008F55,
	18179: 0x00008F58,
	18180: 0x00008F5A,
	18181: 0x0000908D,
	18182: 0x00009143,
	18183: 0x00009141,
	18184: 0x000091B7,
	18185: 0x000091B5,
	18186: 0x000091B2,
	18187: 0x000091B3,
	18188: 0x0000940B,
	18189: 0x00009413,
	18190: 0x000093FB,
	18191: 0x00009420,
	18192: 0x0000940F,
	18193: 0x00009414,
	18194: 0x000093FE,
	18195: 0x00009415,
	18196: 0x00009410,
	18197: 0x00009428,
	18198: 0x00009419,
	18199: 0x0000940D,
	18200: 0x000093F5,
	18201: 0x00009400,
	18202: 0x000093F7,
	18203: 0x00009407,
	18204: 0x0000940E,
	18205: 0x00009416,
	18206: 0x00009412,
	18207: 0x000093FA,
	18208: 0x00009409,
	18209: 0x000093F8,
	18210: 0x0000940A,
	18211: 0x000093FF,
	18212: 0x000093FC,
	18213: 0x0000940C,
	18214: 0x000093F6,
	18215: 0x00009411,
	18216: 0x00009406,
	18217: 0x000095DE,
	18218: 0x000095E0,
	18219: 0x000095DF,
	18220: 0x0000972E,
	18221: 0x0000972F,
	18222: 0x000097B9,
	18223: 0x000097BB,
	18224: 0x000097FD,
	18225: 0x000097FE,
	18226: 0x00009860,
	18227: 0x00009862,
	18228: 0x00009863,
	18229: 0x0000985F,
	18230: 0x000098C1,
	18231: 0x000098C2,
	18232: 0x00009950,
	18233: 0x0000994E,
	18234: 0x00009959,
	18235: 0x0000994C,
	18236: 0x0000994B,
	18237: 0x00009953,
	18238: 0x00009A32,
	18239: 0x00009A34,
	18240: 0x00009A31,
	18241: 0x00009A2C,
	18242: 0x00009A2A,
	18243: 0x00009A36,
	18244: 0x00009A29,
	18245: 0x00009A2E,
	18246: 0x00009A38,
	18247: 0x00009A2D,
	18248: 0x00009AC7,
	18249: 0x00009ACA,
	18250: 0x00009AC6,
	18251: 0x00009B10,
	18252: 0x00009B12,
	18253: 0x00009B11,
	18254: 0x00009C0B,
	18255: 0x00009C08,
	18256: 0x00009BF7,
	18257: 0x00009C05,
	18258: 0x00009C12,
	18259: 0x00009BF8,
	18260: 0x00009C40,
	18261: 0x00009C07,
	18262: 0x00009C0E,
	18263: 0x00009C06,
	18264: 0x00009C17,
	18265: 0x00009C14,
	18266: 0x00009C09,
	18267: 0x00009D9F,
	18268: 0x00009D99,
	18269: 0x00009DA4,
	18270: 0x00009D9D,
	18271: 0x00009D92,
	18272: 0x00009D98,
	18273: 0x00009D90,
	18274: 0x00009D9B,
	18275: 0x00009DA0,
	18276: 0x00009D94,
	18277: 0x00009D9C,
	18278: 0x00009DAA,
	18279: 0x00009D97,
	18280: 0x00009DA1,
	18281: 0x00009D9A,
	18282: 0x00009DA2,
	18283: 0x00009DA8,
	18284: 0x00009D9E,
	18285: 0x00009DA3,
	18286: 0x00009DBF,
	18287: 0x00009DA9,
	18288: 0x00009D96,
	18289: 0x00009DA6,
	18290: 0x00009DA7,
	18291: 0x00009E99,
	18292: 0x00009E9B,
	18293: 0x00009E9A,
	18294: 0x00009EE5,
	18295: 0x00009EE4,
	18296: 0x00009EE7,
	18297: 0x00009EE6,
	18298: 0x00009F30,
	18299: 0x00009F2E,
	18300: 0x00009F5B,
	18301: 0x00009F60,
	18302: 0x00009F5E,
	18303: 0x00009F5D,
	18304: 0x00009F59,
	18305: 0x00009F91,
	18306: 0x0000513A,
	18307: 0x00005139,
	18308: 0x00005298,
	18309: 0x00005297,
	18310: 0x000056C3,
	18311: 0x000056BD,
	18312: 0x000056BE,
	18313: 0x00005B48,
	18314: 0x00005B47,
	18315: 0x00005DCB,
	18316: 0x00005DCF,
	18317: 0x00005EF1,
	18318: 0x000061FD,
	18319: 0x0000651B,
	18320: 0x00006B02,
	18321: 0x00006AFC,
	18322: 0x00006B03,
	18323: 0x00006AF8,
	18324: 0x00006B00,
	18325: 0x00007043,
	18326: 0x00007044,
	18327: 0x0000704A,
	18328: 0x00007048,
	18329: 0x00007049,
	18330: 0x00007045,
	18331: 0x00007046,
	18332: 0x0000721D,
	18333: 0x0000721A,
	18334: 0x00007219,
	18335: 0x0000737E,
	18336: 0x00007517,
	18337: 0x0000766A,
	18338: 0x000077D0,
	18339: 0x0000792D,
	18340: 0x00007931,
	18341: 0x0000792F,
	18342: 0x00007C54,
	18343: 0x00007C53,
	18344: 0x00007CF2,
	18345: 0x00007E8A,
	18346: 0x00007E87,
	18347: 0x00007E88,
	18348: 0x00007E8B,
	18349: 0x00007E86,
	18350: 0x00007E8D,
	18351: 0x00007F4D,
	18352: 0x00007FBB,
	18353: 0x00008030,
	18354: 0x000081DD,
	18355: 0x00008618,
	18356: 0x0000862A,
	18357: 0x00008626,
	18358: 0x0000861F,
	18359: 0x00008623,
	18360: 0x0000861C,
	18361: 0x00008619,
	18362: 0x00008627,
	18363: 0x0000862E,
	18364: 0x00008621,
	18365: 0x00008620,
	18366: 0x00008629,
	18367: 0x0000861E,
	18368: 0x00008625,
	18369: 0x00008829,
	18370: 0x0000881D,
	18371: 0x0000881B,
	18372: 0x00008820,
	18373: 0x00008824,
	18374: 0x0000881C,
	18375: 0x0000882B,
	18376: 0x0000884A,
	18377: 0x0000896D,
	18378: 0x00008969,
	18379: 0x0000896E,
	18380: 0x0000896B,
	18381: 0x000089FA,
	18382: 0x00008B79,
	18383: 0x00008B78,
	18384: 0x00008B45,
	18385: 0x00008B7A,
	18386: 0x00008B7B,
	18387: 0x00008D10,
	18388: 0x00008D14,
	18389: 0x00008DAF,
	18390: 0x00008E8E,
	18391: 0x00008E8C,
	18392: 0x00008F5E,
	18393: 0x00008F5B,
	18394: 0x00008F5D,
	18395: 0x00009146,
	18396: 0x00009144,
	18397: 0x00009145,
	18398: 0x000091B9,
	18399: 0x0000943F,
	18400: 0x0000943B,
	18401: 0x00009436,
	18402: 0x00009429,
	18403: 0x0000943D,
	18404: 0x0000943C,
	18405: 0x00009430,
	18406: 0x00009439,
	18407: 0x0000942A,
	18408: 0x00009437,
	18409: 0x0000942C,
	18410: 0x00009440,
	18411: 0x00009431,
	18412: 0x000095E5,
	18413: 0x000095E4,
	18414: 0x000095E3,
	18415: 0x00009735,
	18416: 0x0000973A,
	18417: 0x000097BF,
	18418: 0x000097E1,
	18419: 0x00009864,
	18420: 0x000098C9,
	18421: 0x000098C6,
	18422: 0x000098C0,
	18423: 0x00009958,
	18424: 0x00009956,
	18425: 0x00009A39,
	18426: 0x00009A3D,
	18427: 0x00009A46,
	18428: 0x00009A44,
	18429: 0x00009A42,
	18430: 0x00009A41,
	18431: 0x00009A3A,
	18432: 0x00009A3F,
	18433: 0x00009ACD,
	18434: 0x00009B15,
	18435: 0x00009B17,
	18436: 0x00009B18,
	18437: 0x00009B16,
	18438: 0x00009B3A,
	18439: 0x00009B52,
	18440: 0x00009C2B,
	18441: 0x00009C1D,
	18442: 0x00009C1C,
	18443: 0x00009C2C,
	18444: 0x00009C23,
	18445: 0x00009C28,
	18446: 0x00009C29,
	18447: 0x00009C24,
	18448: 0x00009C21,
	18449: 0x00009DB7,
	18450: 0x00009DB6,
	18451: 0x00009DBC,
	18452: 0x00009DC1,
	18453: 0x00009DC7,
	18454: 0x00009DCA,
	18455: 0x00009DCF,
	18456: 0x00009DBE,
	18457: 0x00009DC5,
	18458: 0x00009DC3,
	18459: 0x00009DBB,
	18460: 0x00009DB5,
	18461: 0x00009DCE,
	18462: 0x00009DB9,
	18463: 0x00009DBA,
	18464: 0x00009DAC,
	18465: 0x00009DC8,
	18466: 0x00009DB1,
	18467: 0x00009DAD,
	18468: 0x00009DCC,
	18469: 0x00009DB3,
	18470: 0x00009DCD,
	18471: 0x00009DB2,
	18472: 0x00009E7A,
	18473: 0x00009E9C,
	18474: 0x00009EEB,
	18475: 0x00009EEE,
	18476: 0x00009EED,
	18477: 0x00009F1B,
	18478: 0x00009F18,
	18479: 0x00009F1A,
	18480: 0x00009F31,
	18481: 0x00009F4E,
	18482: 0x00009F65,
	18483: 0x00009F64,
	18484: 0x00009F92,
	18485: 0x00004EB9,
	18486: 0x000056C6,
	18487: 0x000056C5,
	18488: 0x000056CB,
	18489: 0x00005971,
	18490: 0x00005B4B,
	18491: 0x00005B4C,
	18492: 0x00005DD5,
	18493: 0x00005DD1,
	18494: 0x00005EF2,
	18495: 0x00006521,
	18496: 0x00006520,
	18497: 0x00006526,
	18498: 0x00006522,
	18499: 0x00006B0B,
	18500: 0x00006B08,
	18501: 0x00006B09,
	18502: 0x00006C0D,
	18503: 0x00007055,
	18504: 0x00007056,
	18505: 0x00007057,
	18506: 0x00007052,
	18507: 0x0000721E,
	18508: 0x0000721F,
	18509: 0x000072A9,
	18510: 0x0000737F,
	18511: 0x000074D8,
	18512: 0x000074D5,
	18513: 0x000074D9,
	18514: 0x000074D7,
	18515: 0x0000766D,
	18516: 0x000076AD,
	18517: 0x00007935,
	18518: 0x000079B4,
	18519: 0x00007A70,
	18520: 0x00007A71,
	18521: 0x00007C57,
	18522: 0x00007C5C,
	18523: 0x00007C59,
	18524: 0x00007C5B,
	18525: 0x00007C5A,
	18526: 0x00007CF4,
	18527: 0x00007CF1,
	18528: 0x00007E91,
	18529: 0x00007F4F,
	18530: 0x00007F87,
	18531: 0x000081DE,
	18532: 0x0000826B,
	18533: 0x00008634,
	18534: 0x00008635,
	18535: 0x00008633,
	18536: 0x0000862C,
	18537: 0x00008632,
	18538: 0x00008636,
	18539: 0x0000882C,
	18540: 0x00008828,
	18541: 0x00008826,
	18542: 0x0000882A,
	18543: 0x00008825,
	18544: 0x00008971,
	18545: 0x000089BF,
	18546: 0x000089BE,
	18547: 0x000089FB,
	18548: 0x00008B7E,
	18549: 0x00008B84,
	18550: 0x00008B82,
	18551: 0x00008B86,
	18552: 0x00008B85,
	18553: 0x00008B7F,
	18554: 0x00008D15,
	18555: 0x00008E95,
	18556: 0x00008E94,
	18557: 0x00008E9A,
	18558: 0x00008E92,
	18559: 0x00008E90,
	18560: 0x00008E96,
	18561: 0x00008E97,
	18562: 0x00008F60,
	18563: 0x00008F62,
	18564: 0x00009147,
	18565: 0x0000944C,
	18566: 0x00009450,
	18567: 0x0000944A,
	18568: 0x0000944B,
	18569: 0x0000944F,
	18570: 0x00009447,
	18571: 0x00009445,
	18572: 0x00009448,
	18573: 0x00009449,
	18574: 0x00009446,
	18575: 0x0000973F,
	18576: 0x000097E3,
	18577: 0x0000986A,
	18578: 0x00009869,
	18579: 0x000098CB,
	18580: 0x00009954,
	18581: 0x0000995B,
	18582: 0x00009A4E,
	18583: 0x00009A53,
	18584: 0x00009A54,
	18585: 0x00009A4C,
	18586: 0x00009A4F,
	18587: 0x00009A48,
	18588: 0x00009A4A,
	18589: 0x00009A49,
	18590: 0x00009A52,
	18591: 0x00009A50,
	18592: 0x00009AD0,
	18593: 0x00009B19,
	18594: 0x00009B2B,
	18595: 0x00009B3B,
	18596: 0x00009B56,
	18597: 0x00009B55,
	18598: 0x00009C46,
	18599: 0x00009C48,
	18600: 0x00009C3F,
	18601: 0x00009C44,
	18602: 0x00009C39,
	18603: 0x00009C33,
	18604: 0x00009C41,
	18605: 0x00009C3C,
	18606: 0x00009C37,
	18607: 0x00009C34,
	18608: 0x00009C32,
	18609: 0x00009C3D,
	18610: 0x00009C36,
	18611: 0x00009DDB,
	18612: 0x00009DD2,
	18613: 0x00009DDE,
	18614: 0x00009DDA,
	18615: 0x00009DCB,
	18616: 0x00009DD0,
	18617: 0x00009DDC,
	18618: 0x00009DD1,
	18619: 0x00009DDF,
	18620: 0x00009DE9,
	18621: 0x00009DD9,
	18622: 0x00009DD8,
	18623: 0x00009DD6,
	18624: 0x00009DF5,
	18625: 0x00009DD5,
	18626: 0x00009DDD,
	18627: 0x00009EB6,
	18628: 0x00009EF0,
	18629: 0x00009F35,
	18630: 0x00009F33,
	18631: 0x00009F32,
	18632: 0x00009F42,
	18633: 0x00009F6B,
	18634: 0x00009F95,
	18635: 0x00009FA2,
	18636: 0x0000513D,
	18637: 0x00005299,
	18638: 0x000058E8,
	18639: 0x000058E7,
	18640: 0x00005972,
	18641: 0x00005B4D,
	18642: 0x00005DD8,
	18643: 0x0000882F,
	18644: 0x00005F4F,
	18645: 0x00006201,
	18646: 0x00006203,
	18647: 0x00006204,
	18648: 0x00006529,
	18649: 0x00006525,
	18650: 0x00006596,
	18651: 0x000066EB,
	18652: 0x00006B11,
	18653: 0x00006B12,
	18654: 0x00006B0F,
	18655: 0x00006BCA,
	18656: 0x0000705B,
	18657: 0x0000705A,
	18658: 0x00007222,
	18659: 0x00007382,
	18660: 0x00007381,
	18661: 0x00007383,
	18662: 0x00007670,
	18663: 0x000077D4,
	18664: 0x00007C67,
	18665: 0x00007C66,
	18666: 0x00007E95,
	18667: 0x0000826C,
	18668: 0x0000863A,
	18669: 0x00008640,
	18670: 0x00008639,
	18671: 0x0000863C,
	18672: 0x00008631,
	18673: 0x0000863B,
	18674: 0x0000863E,
	18675: 0x00008830,
	18676: 0x00008832,
	18677: 0x0000882E,
	18678: 0x00008833,
	18679: 0x00008976,
	18680: 0x00008974,
	18681: 0x00008973,
	18682: 0x000089FE,
	18683: 0x00008B8C,
	18684: 0x00008B8E,
	18685: 0x00008B8B,
	18686: 0x00008B88,
	18687: 0x00008C45,
	18688: 0x00008D19,
	18689: 0x00008E98,
	18690: 0x00008F64,
	18691: 0x00008F63,
	18692: 0x000091BC,
	18693: 0x00009462,
	18694: 0x00009455,
	18695: 0x0000945D,
	18696: 0x00009457,
	18697: 0x0000945E,
	18698: 0x000097C4,
	18699: 0x000097C5,
	18700: 0x00009800,
	18701: 0x00009A56,
	18702: 0x00009A59,
	18703: 0x00009B1E,
	18704: 0x00009B1F,
	18705: 0x00009B20,
	18706: 0x00009C52,
	18707: 0x00009C58,
	18708: 0x00009C50,
	18709: 0x00009C4A,
	18710: 0x00009C4D,
	18711: 0x00009C4B,
	18712: 0x00009C55,
	18713: 0x00009C59,
	18714: 0x00009C4C,
	18715: 0x00009C4E,
	18716: 0x00009DFB,
	18717: 0x00009DF7,
	18718: 0x00009DEF,
	18719: 0x00009DE3,
	18720: 0x00009DEB,
	18721: 0x00009DF8,
	18722: 0x00009DE4,
	18723: 0x00009DF6,
	18724: 0x00009DE1,
	18725: 0x00009DEE,
	18726: 0x00009DE6,
	18727: 0x00009DF2,
	18728: 0x00009DF0,
	18729: 0x00009DE2,
	18730: 0x00009DEC,
	18731: 0x00009DF4,
	18732: 0x00009DF3,
	18733: 0x00009DE8,
	18734: 0x00009DED,
	18735: 0x00009EC2,
	18736: 0x00009ED0,
	18737: 0x00009EF2,
	18738: 0x00009EF3,
	18739: 0x00009F06,
	18740: 0x00009F1C,
	18741: 0x00009F38,
	18742: 0x00009F37,
	18743: 0x00009F36,
	18744: 0x00009F43,
	18745: 0x00009F4F,
	18746: 0x00009F71,
	18747: 0x00009F70,
	18748: 0x00009F6E,
	18749: 0x00009F6F,
	18750: 0x000056D3,
	18751: 0x000056CD,
	18752: 0x00005B4E,
	18753: 0x00005C6D,
	18754: 0x0000652D,
	18755: 0x000066ED,
	18756: 0x000066EE,
	18757: 0x00006B13,
	18758: 0x0000705F,
	18759: 0x00007061,
	18760: 0x0000705D,
	18761: 0x00007060,
	18762: 0x00007223,
	18763: 0x000074DB,
	18764: 0x000074E5,
	18765: 0x000077D5,
	18766: 0x00007938,
	18767: 0x000079B7,
	18768: 0x000079B6,
	18769: 0x00007C6A,
	18770: 0x00007E97,
	18771: 0x00007F89,
	18772: 0x0000826D,
	18773: 0x00008643,
	18774: 0x00008838,
	18775: 0x00008837,
	18776: 0x00008835,
	18777: 0x0000884B,
	18778: 0x00008B94,
	18779: 0x00008B95,
	18780: 0x00008E9E,
	18781: 0x00008E9F,
	18782: 0x00008EA0,
	18783: 0x00008E9D,
	18784: 0x000091BE,
	18785: 0x000091BD,
	18786: 0x000091C2,
	18787: 0x0000946B,
	18788: 0x00009468,
	18789: 0x00009469,
	18790: 0x000096E5,
	18791: 0x00009746,
	18792: 0x00009743,
	18793: 0x00009747,
	18794: 0x000097C7,
	18795: 0x000097E5,
	18796: 0x00009A5E,
	18797: 0x00009AD5,
	18798: 0x00009B59,
	18799: 0x00009C63,
	18800: 0x00009C67,
	18801: 0x00009C66,
	18802: 0x00009C62,
	18803: 0x00009C5E,
	18804: 0x00009C60,
	18805: 0x00009E02,
	18806: 0x00009DFE,
	18807: 0x00009E07,
	18808: 0x00009E03,
	18809: 0x00009E06,
	18810: 0x00009E05,
	18811: 0x00009E00,
	18812: 0x00009E01,
	18813: 0x00009E09,
	18814: 0x00009DFF,
	18815: 0x00009DFD,
	18816: 0x00009E04,
	18817: 0x00009EA0,
	18818: 0x00009F1E,
	18819: 0x00009F46,
	18820: 0x00009F74,
	18821: 0x00009F75,
	18822: 0x00009F76,
	18823: 0x000056D4,
	18824: 0x0000652E,
	18825: 0x000065B8,
	18826: 0x00006B18,
	18827: 0x00006B19,
	18828: 0x00006B17,
	18829: 0x00006B1A,
	18830: 0x00007062,
	18831: 0x00007226,
	18832: 0x000072AA,
	18833: 0x000077D8,
	18834: 0x000077D9,
	18835: 0x00007939,
	18836: 0x00007C69,
	18837: 0x00007C6B,
	18838: 0x00007CF6,
	18839: 0x00007E9A,
	18840: 0x00007E98,
	18841: 0x00007E9B,
	18842: 0x00007E99,
	18843: 0x000081E0,
	18844: 0x000081E1,
	18845: 0x00008646,
	18846: 0x00008647,
	18847: 0x00008648,
	18848: 0x00008979,
	18849: 0x0000897A,
	18850: 0x0000897C,
	18851: 0x0000897B,
	18852: 0x000089FF,
	18853: 0x00008B98,
	18854: 0x00008B99,
	18855: 0x00008EA5,
	18856: 0x00008EA4,
	18857: 0x00008EA3,
	18858: 0x0000946E,
	18859: 0x0000946D,
	18860: 0x0000946F,
	18861: 0x00009471,
	18862: 0x00009473,
	18863: 0x00009749,
	18864: 0x00009872,
	18865: 0x0000995F,
	18866: 0x00009C68,
	18867: 0x00009C6E,
	18868: 0x00009C6D,
	18869: 0x00009E0B,
	18870: 0x00009E0D,
	18871: 0x00009E10,
	18872: 0x00009E0F,
	18873: 0x00009E12,
	18874: 0x00009E11,
	18875: 0x00009EA1,
	18876: 0x00009EF5,
	18877: 0x00009F09,
	18878: 0x00009F47,
	18879: 0x00009F78,
	18880: 0x00009F7B,
	18881: 0x00009F7A,
	18882: 0x00009F79,
	18883: 0x0000571E,
	18884: 0x00007066,
	18885: 0x00007C6F,
	18886: 0x0000883C,
	18887: 0x00008DB2,
	18888: 0x00008EA6,
	18889: 0x000091C3,
	18890: 0x00009474,
	18891: 0x00009478,
	18892: 0x00009476,
	18893: 0x00009475,
	18894: 0x00009A60,
	18895: 0x00009C74,
	18896: 0x00009C73,
	18897: 0x00009C71,
	18898: 0x00009C75,
	18899: 0x00009E14,
	18900: 0x00009E13,
	18901: 0x00009EF6,
	18902: 0x00009F0A,
	18903: 0x00009FA4,
	18904: 0x00007068,
	18905: 0x00007065,
	18906: 0x00007CF7,
	18907: 0x0000866A,
	18908: 0x0000883E,
	18909: 0x0000883D,
	18910: 0x0000883F,
	18911: 0x00008B9E,
	18912: 0x00008C9C,
	18913: 0x00008EA9,
	18914: 0x00008EC9,
	18915: 0x0000974B,
	18916: 0x00009873,
	18917: 0x00009874,
	18918: 0x000098CC,
	18919: 0x00009961,
	18920: 0x000099AB,
	18921: 0x00009A64,
	18922: 0x00009A66,
	18923: 0x00009A67,
	18924: 0x00009B24,
	18925: 0x00009E15,
	18926: 0x00009E17,
	18927: 0x00009F48,
	18928: 0x00006207,
	18929: 0x00006B1E,
	18930: 0x00007227,
	18931: 0x0000864C,
	18932: 0x00008EA8,
	18933: 0x00009482,
	18934: 0x00009480,
	18935: 0x00009481,
	18936: 0x00009A69,
	18937: 0x00009A68,
	18938: 0x00009B2E,
	18939: 0x00009E19,
	18940: 0x00007229,
	18941: 0x0000864B,
	18942: 0x00008B9F,
	18943: 0x00009483,
	18944: 0x00009C79,
	18945: 0x00009EB7,
	18946: 0x00007675,
	18947: 0x00009A6B,
	18948: 0x00009C7A,
	18949: 0x00009E1D,
	18950: 0x00007069,
	18951: 0x0000706A,
	18952: 0x00009EA4,
	18953: 0x00009F7E,
	18954: 0x00009F49,
	18955: 0x00009F98,
	18956: 0x00007881,
	18957: 0x000092B9,
	18958: 0x000088CF,
	18959: 0x000058BB,
	18960: 0x00006052,
	18961: 0x00007CA7,
	18962: 0x00005AFA,
	18963: 0x00002554,
	18964: 0x00002566,
	18965: 0x00002557,
	18966: 0x00002560,
	18967: 0x0000256C,
	18968: 0x00002563,
	18969: 0x0000255A,
	18970: 0x00002569,
	18971: 0x0000255D,
	18972: 0x00002552,
	18973: 0x00002564,
	18974: 0x00002555,
	18975: 0x0000255E,
	18976: 0x0000256A,
	18977: 0x00002561,
	18978: 0x00002558,
	18979: 0x00002567,
	18980: 0x0000255B,
	18981: 0x00002553,
	18982: 0x00002565,
	18983: 0x00002556,
	18984: 0x0000255F,
	18985: 0x0000256B,
	18986: 0x00002562,
	18987: 0x00002559,
	18988: 0x00002568,
	18989: 0x0000255C,
	18990: 0x00002551,
	18991: 0x00002550,
	18992: 0x0000256D,
	18993: 0x0000256E,
	18994: 0x00002570,
	18995: 0x0000256F,
	18996: 0x0000FFED,
	18997: 0x00020547,
	18998: 0x000092DB,
	18999: 0x000205DF,
	19000: 0x00023FC5,
	19001: 0x0000854C,
	19002: 0x000042B5,
	19003: 0x000073EF,
	19004: 0x000051B5,
	19005: 0x00003649,
	19006: 0x00024942,
	19007: 0x000289E4,
	19008: 0x00009344,
	19009: 0x000219DB,
	19010: 0x000082EE,
	19011: 0x00023CC8,
	19012: 0x0000783C,
	19013: 0x00006744,
	19014: 0x000062DF,
	19015: 0x00024933,
	19016: 0x000289AA,
	19017: 0x000202A0,
	19018: 0x00026BB3,
	19019: 0x00021305,
	19020: 0x00004FAB,
	19021: 0x000224ED,
	19022: 0x00005008,
	19023: 0x00026D29,
	19024: 0x00027A84,
	19025: 0x00023600,
	19026: 0x00024AB1,
	19027: 0x00022513,
	19028: 0x00005029,
	19029: 0x0002037E,
	19030: 0x00005FA4,
	19031: 0x00020380,
	19032: 0x00020347,
	19033: 0x00006EDB,
	19034: 0x0002041F,
	19035: 0x0000507D,
	19036: 0x00005101,
	19037: 0x0000347A,
	19038: 0x0000510E,
	19039: 0x0000986C,
	19040: 0x00003743,
	19041: 0x00008416,
	19042: 0x000249A4,
	19043: 0x00020487,
	19044: 0x00005160,
	19045: 0x000233B4,
	19046: 0x0000516A,
	19047: 0x00020BFF,
	19048: 0x000220FC,
	19049: 0x000202E5,
	19050: 0x00022530,
	19051: 0x0002058E,
	19052: 0x00023233,
	19053: 0x00021983,
	19054: 0x00005B82,
	19055: 0x0000877D,
	19056: 0x000205B3,
	19057: 0x00023C99,
	19058: 0x000051B2,
	19059: 0x000051B8,
	19060: 0x00009D34,
	19061: 0x000051C9,
	19062: 0x000051CF,
	19063: 0x000051D1,
	19064: 0x00003CDC,
	19065: 0x000051D3,
	19066: 0x00024AA6,
	19067: 0x000051B3,
	19068: 0x000051E2,
	19069: 0x00005342,
	19070: 0x000051ED,
	19071: 0x000083CD,
	19072: 0x0000693E,
	19073: 0x0002372D,
	19074: 0x00005F7B,
	19075: 0x0000520B,
	19076: 0x00005226,
	19077: 0x0000523C,
	19078: 0x000052B5,
	19079: 0x00005257,
	19080: 0x00005294,
	19081: 0x000052B9,
	19082: 0x000052C5,
	19083: 0x00007C15,
	19084: 0x00008542,
	19085: 0x000052E0,
	19086: 0x0000860D,
	19087: 0x00026B13,
	19088: 0x00005305,
	19089: 0x00028ADE,
	19090: 0x00005549,
	19091: 0x00006ED9,
	19092: 0x00023F80,
	19093: 0x00020954,
	19094: 0x00023FEC,
	19095: 0x00005333,
	19096: 0x00005344,
	19097: 0x00020BE2,
	19098: 0x00006CCB,
	19099: 0x00021726,
	19100: 0x0000681B,
	19101: 0x000073D5,
	19102: 0x0000604A,
	19103: 0x00003EAA,
	19104: 0x000038CC,
	19105: 0x000216E8,
	19106: 0x000071DD,
	19107: 0x000044A2,
	19108: 0x0000536D,
	19109: 0x00005374,
	19110: 0x000286AB,
	19111: 0x0000537E,
	19112: 0x0000537F,
	19113: 0x00021596,
	19114: 0x00021613,
	19115: 0x000077E6,
	19116: 0x00005393,
	19117: 0x00028A9B,
	19118: 0x000053A0,
	19119: 0x000053AB,
	19120: 0x000053AE,
	19121: 0x000073A7,
	19122: 0x00025772,
	19123: 0x00003F59,
	19124: 0x0000739C,
	19125: 0x000053C1,
	19126: 0x000053C5,
	19127: 0x00006C49,
	19128: 0x00004E49,
	19129: 0x000057FE,
	19130: 0x000053D9,
	19131: 0x00003AAB,
	19132: 0x00020B8F,
	19133: 0x000053E0,
	19134: 0x00023FEB,
	19135: 0x00022DA3,
	19136: 0x000053F6,
	19137: 0x00020C77,
	19138: 0x00005413,
	19139: 0x00007079,
	19140: 0x0000552B,
	19141: 0x00006657,
	19142: 0x00006D5B,
	19143: 0x0000546D,
	19144: 0x00026B53,
	19145: 0x00020D74,
	19146: 0x0000555D,
	19147: 0x0000548F,
	19148: 0x000054A4,
	19149: 0x000047A6,
	19150: 0x0002170D,
	19151: 0x00020EDD,
	19152: 0x00003DB4,
	19153: 0x00020D4D,
	19154: 0x000289BC,
	19155: 0x00022698,
	19156: 0x00005547,
	19157: 0x00004CED,
	19158: 0x0000542F,
	19159: 0x00007417,
	19160: 0x00005586,
	19161: 0x000055A9,
	19162: 0x00005605,
	19163: 0x000218D7,
	19164: 0x0002403A,
	19165: 0x00004552,
	19166: 0x00024435,
	19167: 0x000066B3,
	19168: 0x000210B4,
	19169: 0x00005637,
	19170: 0x000066CD,
	19171: 0x0002328A,
	19172: 0x000066A4,
	19173: 0x000066AD,
	19174: 0x0000564D,
	19175: 0x0000564F,
	19176: 0x000078F1,
	19177: 0x000056F1,
	19178: 0x00009787,
	19179: 0x000053FE,
	19180: 0x00005700,
	19181: 0x000056EF,
	19182: 0x000056ED,
	19183: 0x00028B66,
	19184: 0x00003623,
	19185: 0x0002124F,
	19186: 0x00005746,
	19187: 0x000241A5,
	19188: 0x00006C6E,
	19189: 0x0000708B,
	19190: 0x00005742,
	19191: 0x000036B1,
	19192: 0x00026C7E,
	19193: 0x000057E6,
	19194: 0x00021416,
	19195: 0x00005803,
	19196: 0x00021454,
	19197: 0x00024363,
	19198: 0x00005826,
	19199: 0x00024BF5,
	19200: 0x0000585C,
	19201: 0x000058AA,
	19202: 0x00003561,
	19203: 0x000058E0,
	19204: 0x000058DC,
	19205: 0x0002123C,
	19206: 0x000058FB,
	19207: 0x00005BFF,
	19208: 0x00005743,
	19209: 0x0002A150,
	19210: 0x00024278,
	19211: 0x000093D3,
	19212: 0x000035A1,
	19213: 0x0000591F,
	19214: 0x000068A6,
	19215: 0x000036C3,
	19216: 0x00006E59,
	19217: 0x0002163E,
	19218: 0x00005A24,
	19219: 0x00005553,
	19220: 0x00021692,
	19221: 0x00008505,
	19222: 0x000059C9,
	19223: 0x00020D4E,
	19224: 0x00026C81,
	19225: 0x00026D2A,
	19226: 0x000217DC,
	19227: 0x000059D9,
	19228: 0x000217FB,
	19229: 0x000217B2,
	19230: 0x00026DA6,
	19231: 0x00006D71,
	19232: 0x00021828,
	19233: 0x000216D5,
	19234: 0x000059F9,
	19235: 0x00026E45,
	19236: 0x00005AAB,
	19237: 0x00005A63,
	19238: 0x000036E6,
	19239: 0x000249A9,
	19240: 0x00005A77,
	19241: 0x00003708,
	19242: 0x00005A96,
	19243: 0x00007465,
	19244: 0x00005AD3,
	19245: 0x00026FA1,
	19246: 0x00022554,
	19247: 0x00003D85,
	19248: 0x00021911,
	19249: 0x00003732,
	19250: 0x000216B8,
	19251: 0x00005E83,
	19252: 0x000052D0,
	19253: 0x00005B76,
	19254: 0x00006588,
	19255: 0x00005B7C,
	19256: 0x00027A0E,
	19257: 0x00004004,
	19258: 0x0000485D,
	19259: 0x00020204,
	19260: 0x00005BD5,
	19261: 0x00006160,
	19262: 0x00021A34,
	19263: 0x000259CC,
	19264: 0x000205A5,
	19265: 0x00005BF3,
	19266: 0x00005B9D,
	19267: 0x00004D10,
	19268: 0x00005C05,
	19269: 0x00021B44,
	19270: 0x00005C13,
	19271: 0x000073CE,
	19272: 0x00005C14,
	19273: 0x00021CA5,
	19274: 0x00026B28,
	19275: 0x00005C49,
	19276: 0x000048DD,
	19277: 0x00005C85,
	19278: 0x00005CE9,
	19279: 0x00005CEF,
	19280: 0x00005D8B,
	19281: 0x00021DF9,
	19282: 0x00021E37,
	19283: 0x00005D10,
	19284: 0x00005D18,
	19285: 0x00005D46,
	19286: 0x00021EA4,
	19287: 0x00005CBA,
	19288: 0x00005DD7,
	19289: 0x000082FC,
	19290: 0x0000382D,
	19291: 0x00024901,
	19292: 0x00022049,
	19293: 0x00022173,
	19294: 0x00008287,
	19295: 0x00003836,
	19296: 0x00003BC2,
	19297: 0x00005E2E,
	19298: 0x00006A8A,
	19299: 0x00005E75,
	19300: 0x00005E7A,
	19301: 0x000244BC,
	19302: 0x00020CD3,
	19303: 0x000053A6,
	19304: 0x00004EB7,
	19305: 0x00005ED0,
	19306: 0x000053A8,
	19307: 0x00021771,
	19308: 0x00005E09,
	19309: 0x00005EF4,
	19310: 0x00028482,
	19311: 0x00005EF9,
	19312: 0x00005EFB,
	19313: 0x000038A0,
	19314: 0x00005EFC,
	19315: 0x0000683E,
	19316: 0x0000941B,
	19317: 0x00005F0D,
	19318: 0x000201C1,
	19319: 0x0002F894,
	19320: 0x00003ADE,
	19321: 0x000048AE,
	19322: 0x0002133A,
	19323: 0x00005F3A,
	19324: 0x00026888,
	19325: 0x000223D0,
	19326: 0x00005F58,
	19327: 0x00022471,
	19328: 0x00005F63,
	19329: 0x000097BD,
	19330: 0x00026E6E,
	19331: 0x00005F72,
	19332: 0x00009340,
	19333: 0x00028A36,
	19334: 0x00005FA7,
	19335: 0x00005DB6,
	19336: 0x00003D5F,
	19337: 0x00025250,
	19338: 0x00021F6A,
	19339: 0x000270F8,
	19340: 0x00022668,
	19341: 0x000091D6,
	19342: 0x0002029E,
	19343: 0x00028A29,
	19344: 0x00006031,
	19345: 0x00006685,
	19346: 0x00021877,
	19347: 0x00003963,
	19348: 0x00003DC7,
	19349: 0x00003639,
	19350: 0x00005790,
	19351: 0x000227B4,
	19352: 0x00007971,
	19353: 0x00003E40,
	19354: 0x0000609E,
	19355: 0x000060A4,
	19356: 0x000060B3,
	19357: 0x00024982,
	19358: 0x0002498F,
	19359: 0x00027A53,
	19360: 0x000074A4,
	19361: 0x000050E1,
	19362: 0x00005AA0,
	19363: 0x00006164,
	19364: 0x00008424,
	19365: 0x00006142,
	19366: 0x0002F8A6,
	19367: 0x00026ED2,
	19368: 0x00006181,
	19369: 0x000051F4,
	19370: 0x00020656,
	19371: 0x00006187,
	19372: 0x00005BAA,
	19373: 0x00023FB7,
	19374: 0x0002285F,
	19375: 0x000061D3,
	19376: 0x00028B9D,
	19377: 0x0002995D,
	19378: 0x000061D0,
	19379: 0x00003932,
	19380: 0x00022980,
	19381: 0x000228C1,
	19382: 0x00006023,
	19383: 0x0000615C,
	19384: 0x0000651E,
	19385: 0x0000638B,
	19386: 0x00020118,
	19387: 0x000062C5,
	19388: 0x00021770,
	19389: 0x000062D5,
	19390: 0x00022E0D,
	19391: 0x0000636C,
	19392: 0x000249DF,
	19393: 0x00003A17,
	19394: 0x00006438,
	19395: 0x000063F8,
	19396: 0x0002138E,
	19397: 0x000217FC,
	19398: 0x00006490,
	19399: 0x00006F8A,
	19400: 0x00022E36,
	19401: 0x00009814,
	19402: 0x0002408C,
	19403: 0x0002571D,
	19404: 0x000064E1,
	19405: 0x000064E5,
	19406: 0x0000947B,
	19407: 0x00003A66,
	19408: 0x0000643A,
	19409: 0x00003A57,
	19410: 0x0000654D,
	19411: 0x00006F16,
	19412: 0x00024A28,
	19413: 0x00024A23,
	19414: 0x00006585,
	19415: 0x0000656D,
	19416: 0x0000655F,
	19417: 0x0002307E,
	19418: 0x000065B5,
	19419: 0x00024940,
	19420: 0x00004B37,
	19421: 0x000065D1,
	19422: 0x000040D8,
	19423: 0x00021829,
	19424: 0x000065E0,
	19425: 0x000065E3,
	19426: 0x00005FDF,
	19427: 0x00023400,
	19428: 0x00006618,
	19429: 0x000231F7,
	19430: 0x000231F8,
	19431: 0x00006644,
	19432: 0x000231A4,
	19433: 0x000231A5,
	19434: 0x0000664B,
	19435: 0x00020E75,
	19436: 0x00006667,
	19437: 0x000251E6,
	19438: 0x00006673,
	19439: 0x00006674,
	19440: 0x00021E3D,
	19441: 0x00023231,
	19442: 0x000285F4,
	19443: 0x000231C8,
	19444: 0x00025313,
	19445: 0x000077C5,
	19446: 0x000228F7,
	19447: 0x000099A4,
	19448: 0x00006702,
	19449: 0x0002439C,
	19450: 0x00024A21,
	19451: 0x00003B2B,
	19452: 0x000069FA,
	19453: 0x000237C2,
	19454: 0x0000675E,
	19455: 0x00006767,
	19456: 0x00006762,
	19457: 0x000241CD,
	19458: 0x000290ED,
	19459: 0x000067D7,
	19460: 0x000044E9,
	19461: 0x00006822,
	19462: 0x00006E50,
	19463: 0x0000923C,
	19464: 0x00006801,
	19465: 0x000233E6,
	19466: 0x00026DA0,
	19467: 0x0000685D,
	19468: 0x0002346F,
	19469: 0x000069E1,
	19470: 0x00006A0B,
	19471: 0x00028ADF,
	19472: 0x00006973,
	19473: 0x000068C3,
	19474: 0x000235CD,
	19475: 0x00006901,
	19476: 0x00006900,
	19477: 0x00003D32,
	19478: 0x00003A01,
	19479: 0x0002363C,
	19480: 0x00003B80,
	19481: 0x000067AC,
	19482: 0x00006961,
	19483: 0x00028A4A,
	19484: 0x000042FC,
	19485: 0x00006936,
	19486: 0x00006998,
	19487: 0x00003BA1,
	19488: 0x000203C9,
	19489: 0x00008363,
	19490: 0x00005090,
	19491: 0x000069F9,
	19492: 0x00023659,
	19493: 0x0002212A,
	19494: 0x00006A45,
	19495: 0x00023703,
	19496: 0x00006A9D,
	19497: 0x00003BF3,
	19498: 0x000067B1,
	19499: 0x00006AC8,
	19500: 0x0002919C,
	19501: 0x00003C0D,
	19502: 0x00006B1D,
	19503: 0x00020923,
	19504: 0x000060DE,
	19505: 0x00006B35,
	19506: 0x00006B74,
	19507: 0x000227CD,
	19508: 0x00006EB5,
	19509: 0x00023ADB,
	19510: 0x000203B5,
	19511: 0x00021958,
	19512: 0x00003740,
	19513: 0x00005421,
	19514: 0x00023B5A,
	19515: 0x00006BE1,
	19516: 0x00023EFC,
	19517: 0x00006BDC,
	19518: 0x00006C37,
	19519: 0x0002248B,
	19520: 0x000248F1,
	19521: 0x00026B51,
	19522: 0x00006C5A,
	19523: 0x00008226,
	19524: 0x00006C79,
	19525: 0x00023DBC,
	19526: 0x000044C5,
	19527: 0x00023DBD,
	19528: 0x000241A4,
	19529: 0x0002490C,
	19530: 0x00024900,
	19531: 0x00023CC9,
	19532: 0x000036E5,
	19533: 0x00003CEB,
	19534: 0x00020D32,
	19535: 0x00009B83,
	19536: 0x000231F9,
	19537: 0x00022491,
	19538: 0x00007F8F,
	19539: 0x00006837,
	19540: 0x00026D25,
	19541: 0x00026DA1,
	19542: 0x00026DEB,
	19543: 0x00006D96,
	19544: 0x00006D5C,
	19545: 0x00006E7C,
	19546: 0x00006F04,
	19547: 0x0002497F,
	19548: 0x00024085,
	19549: 0x00026E72,
	19550: 0x00008533,
	19551: 0x00026F74,
	19552: 0x000051C7,
	19553: 0x00006C9C,
	19554: 0x00006E1D,
	19555: 0x0000842E,
	19556: 0x00028B21,
	19557: 0x00006E2F,
	19558: 0x00023E2F,
	19559: 0x00007453,
	19560: 0x00023F82,
	19561: 0x000079CC,
	19562: 0x00006E4F,
	19563: 0x00005A91,
	19564: 0x0002304B,
	19565: 0x00006FF8,
	19566: 0x0000370D,
	19567: 0x00006F9D,
	19568: 0x00023E30,
	19569: 0x00006EFA,
	19570: 0x00021497,
	19571: 0x0002403D,
	19572: 0x00004555,
	19573: 0x000093F0,
	19574: 0x00006F44,
	19575: 0x00006F5C,
	19576: 0x00003D4E,
	19577: 0x00006F74,
	19578: 0x00029170,
	19579: 0x00003D3B,
	19580: 0x00006F9F,
	19581: 0x00024144,
	19582: 0x00006FD3,
	19583: 0x00024091,
	19584: 0x00024155,
	19585: 0x00024039,
	19586: 0x00023FF0,
	19587: 0x00023FB4,
	19588: 0x0002413F,
	19589: 0x000051DF,
	19590: 0x00024156,
	19591: 0x00024157,
	19592: 0x00024140,
	19593: 0x000261DD,
	19594: 0x0000704B,
	19595: 0x0000707E,
	19596: 0x000070A7,
	19597: 0x00007081,
	19598: 0x000070CC,
	19599: 0x000070D5,
	19600: 0x000070D6,
	19601: 0x000070DF,
	19602: 0x00004104,
	19603: 0x00003DE8,
	19604: 0x000071B4,
	19605: 0x00007196,
	19606: 0x00024277,
	19607: 0x0000712B,
	19608: 0x00007145,
	19609: 0x00005A88,
	19610: 0x0000714A,
	19611: 0x0000716E,
	19612: 0x00005C9C,
	19613: 0x00024365,
	19614: 0x0000714F,
	19615: 0x00009362,
	19616: 0x000242C1,
	19617: 0x0000712C,
	19618: 0x0002445A,
	19619: 0x00024A27,
	19620: 0x00024A22,
	19621: 0x000071BA,
	19622: 0x00028BE8,
	19623: 0x000070BD,
	19624: 0x0000720E,
	19625: 0x00009442,
	19626: 0x00007215,
	19627: 0x00005911,
	19628: 0x00009443,
	19629: 0x00007224,
	19630: 0x00009341,
	19631: 0x00025605,
	19632: 0x0000722E,
	19633: 0x00007240,
	19634: 0x00024974,
	19635: 0x000068BD,
	19636: 0x00007255,
	19637: 0x00007257,
	19638: 0x00003E55,
	19639: 0x00023044,
	19640: 0x0000680D,
	19641: 0x00006F3D,
	19642: 0x00007282,
	19643: 0x0000732A,
	19644: 0x0000732B,
	19645: 0x00024823,
	19646: 0x0002882B,
	19647: 0x000048ED,
	19648: 0x00028804,
	19649: 0x00007328,
	19650: 0x0000732E,
	19651: 0x000073CF,
	19652: 0x000073AA,
	19653: 0x00020C3A,
	19654: 0x00026A2E,
	19655: 0x000073C9,
	19656: 0x00007449,
	19657: 0x000241E2,
	19658: 0x000216E7,
	19659: 0x00024A24,
	19660: 0x00006623,
	19661: 0x000036C5,
	19662: 0x000249B7,
	19663: 0x0002498D,
	19664: 0x000249FB,
	19665: 0x000073F7,
	19666: 0x00007415,
	19667: 0x00006903,
	19668: 0x00024A26,
	19669: 0x00007439,
	19670: 0x000205C3,
	19671: 0x00003ED7,
	19672: 0x0000745C,
	19673: 0x000228AD,
	19674: 0x00007460,
	19675: 0x00028EB2,
	19676: 0x00007447,
	19677: 0x000073E4,
	19678: 0x00007476,
	19679: 0x000083B9,
	19680: 0x0000746C,
	19681: 0x00003730,
	19682: 0x00007474,
	19683: 0x000093F1,
	19684: 0x00006A2C,
	19685: 0x00007482,
	19686: 0x00004953,
	19687: 0x00024A8C,
	19688: 0x0002415F,
	19689: 0x00024A79,
	19690: 0x00028B8F,
	19691: 0x00005B46,
	19692: 0x00028C03,
	19693: 0x0002189E,
	19694: 0x000074C8,
	19695: 0x00021988,
	19696: 0x0000750E,
	19697: 0x000074E9,
	19698: 0x0000751E,
	19699: 0x00028ED9,
	19700: 0x00021A4B,
	19701: 0x00005BD7,
	19702: 0x00028EAC,
	19703: 0x00009385,
	19704: 0x0000754D,
	19705: 0x0000754A,
	19706: 0x00007567,
	19707: 0x0000756E,
	19708: 0x00024F82,
	19709: 0x00003F04,
	19710: 0x00024D13,
	19711: 0x0000758E,
	19712: 0x0000745D,
	19713: 0x0000759E,
	19714: 0x000075B4,
	19715: 0x00007602,
	19716: 0x0000762C,
	19717: 0x00007651,
	19718: 0x0000764F,
	19719: 0x0000766F,
	19720: 0x00007676,
	19721: 0x000263F5,
	19722: 0x00007690,
	19723: 0x000081EF,
	19724: 0x000037F8,
	19725: 0x00026911,
	19726: 0x0002690E,
	19727: 0x000076A1,
	19728: 0x000076A5,
	19729: 0x000076B7,
	19730: 0x000076CC,
	19731: 0x00026F9F,
	19732: 0x00008462,
	19733: 0x0002509D,
	19734: 0x0002517D,
	19735: 0x00021E1C,
	19736: 0x0000771E,
	19737: 0x00007726,
	19738: 0x00007740,
	19739: 0x000064AF,
	19740: 0x00025220,
	19741: 0x00007758,
	19742: 0x000232AC,
	19743: 0x000077AF,
	19744: 0x00028964,
	19745: 0x00028968,
	19746: 0x000216C1,
	19747: 0x000077F4,
	19748: 0x00007809,
	19749: 0x00021376,
	19750: 0x00024A12,
	19751: 0x000068CA,
	19752: 0x000078AF,
	19753: 0x000078C7,
	19754: 0x000078D3,
	19755: 0x000096A5,
	19756: 0x0000792E,
	19757: 0x000255E0,
	19758: 0x000078D7,
	19759: 0x00007934,
	19760: 0x000078B1,
	19761: 0x0002760C,
	19762: 0x00008FB8,
	19763: 0x00008884,
	19764: 0x00028B2B,
	19765: 0x00026083,
	19766: 0x0002261C,
	19767: 0x00007986,
	19768: 0x00008900,
	19769: 0x00006902,
	19770: 0x00007980,
	19771: 0x00025857,
	19772: 0x0000799D,
	19773: 0x00027B39,
	19774: 0x0000793C,
	19775: 0x000079A9,
	19776: 0x00006E2A,
	19777: 0x00027126,
	19778: 0x00003EA8,
	19779: 0x000079C6,
	19780: 0x0002910D,
	19781: 0x000079D4,
}

const numEncodeTables = 8

// encodeX are the encoding tables from Unicode to Big5 code,
// sorted by decreasing length.
// encode0: 42633 entries for runes in [131105, 173738).
// encode1: 29004 entries for runes in [ 11904,  40908).
// encode2:  2176 entries for runes in [  7870,  10046).
// encode3:   939 entries for runes in [   167,   1106).
// encode4:   446 entries for runes in [ 65072,  65518).
// encode5:   432 entries for runes in [194597, 195029).
// encode6:   263 entries for runes in [ 63751,  64014).
// encode7:     1 entries for runes in [175615, 175616).

const encode0Low, encode0High = 131105, 173738

var encode0 = [...]uint16{
	131105 - 131105: 0x9C71,
	131134 - 131105: 0x9375,
	131142 - 131105: 0x9376,
	131150 - 131105: 0x9548,
	131176 - 131105: 0x8EC6,
	131206 - 131105: 0x8BC5,
	131207 - 131105: 0x8BFA,
	131210 - 131105: 0xC87C,
	131220 - 131105: 0x9AB4,
	131274 - 131105: 0x884E,
	131275 - 131105: 0x884B,
	131276 - 131105: 0xC87A,
	131277 - 131105: 0x8848,
	131281 - 131105: 0x8847,
	131310 - 131105: 0xA0F6,
	131340 - 131105: 0x8845,
	131342 - 131105: 0x8853,
	131352 - 131105: 0xFCAD,
	131492 - 131105: 0x8CF5,
	131497 - 131105: 0x8AAD,
	131499 - 131105: 0x9272,
	131521 - 131105: 0xFC47,
	131540 - 131105: 0x94DF,
	131570 - 131105: 0x9FD1,
	131588 - 131105: 0xFBCB,
	131596 - 131105: 0x927D,
	131604 - 131105: 0x98A4,
	131641 - 131105: 0x8CF9,
	131675 - 131105: 0x94E7,
	131700 - 131105: 0x90CB,
	131701 - 131105: 0x927B,
	131737 - 131105: 0x94D8,
	131742 - 131105: 0xFC5F,
	131744 - 131105: 0xFA54,
	131767 - 131105: 0x9AB5,
	131775 - 131105: 0x96DA,
	131776 - 131105: 0x9279,
	131813 - 131105: 0xFA74,
	131850 - 131105: 0x9275,
	131877 - 131105: 0x8DFB,
	131905 - 131105: 0x8A49,
	131909 - 131105: 0x92DF,
	131910 - 131105: 0x9B7C,
	131911 - 131105: 0xFA63,
	131966 - 131105: 0xFA60,
	131967 - 131105: 0x926D,
	131968 - 131105: 0xFA62,
	132000 - 131105: 0x9AB6,
	132007 - 131105: 0x976B,
	132021 - 131105: 0xFD6A,
	132041 - 131105: 0xFD54,
	132043 - 131105: 0x9273,
	132085 - 131105: 0x97D8,
	132092 - 131105: 0x9FBB,
	132115 - 131105: 0x9342,
	132116 - 131105: 0x9276,
	132127 - 131105: 0xFA65,
	132197 - 131105: 0x926C,
	132231 - 131105: 0xFA6E,
	132238 - 131105: 0x9EE0,
	132241 - 131105: 0x92C0,
	132242 - 131105: 0x92BF,
	132259 - 131105: 0x92BE,
	132311 - 131105: 0x9ABA,
	132348 - 131105: 0x8AB3,
	132350 - 131105: 0x9775,
	132423 - 131105: 0xFA40,
	132494 - 131105: 0xFA76,
	132517 - 131105: 0xFBD0,
	132531 - 131105: 0xFA7B,
	132547 - 131105: 0xFE6D,
	132554 - 131105: 0x9BB3,
	132560 - 131105: 0x89CC,
	132565 - 131105: 0x9ABE,
	132575 - 131105: 0xFA42,
	132576 - 131105: 0x92BC,
	132587 - 131105: 0x945C,
	132625 - 131105: 0x9BB5,
	132629 - 131105: 0x9ABF,
	132633 - 131105: 0x98A7,
	132634 - 131105: 0x97A4,
	132656 - 131105: 0x90FD,
	132694 - 131105: 0xFC7B,
	132726 - 131105: 0x9AC0,
	132878 - 131105: 0x92C3,
	132913 - 131105: 0x8AAA,
	132985 - 131105: 0x9BD0,
	133164 - 131105: 0x9550,
	133235 - 131105: 0x92C6,
	133333 - 131105: 0x98A6,
	133398 - 131105: 0x9546,
	133411 - 131105: 0xFD63,
	133460 - 131105: 0xFAC2,
	133497 - 131105: 0x9EC3,
	133607 - 131105: 0x89B2,
	133649 - 131105: 0x9C66,
	133712 - 131105: 0x9053,
	133743 - 131105: 0x8C62,
	133770 - 131105: 0x87A8,
	133812 - 131105: 0x97C1,
	133826 - 131105: 0x9AC4,
	133837 - 131105: 0x9AC5,
	133901 - 131105: 0x8EEF,
	134031 - 131105: 0xFAE9,
	134047 - 131105: 0x8D40,
	134056 - 131105: 0x9262,
	134057 - 131105: 0x8AF7,
	134079 - 131105: 0x9AC6,
	134086 - 131105: 0x92E1,
	134091 - 131105: 0x9AC9,
	134114 - 131105: 0xFAC6,
	134123 - 131105: 0x97A5,
	134139 - 131105: 0x9ACB,
	134143 - 131105: 0xFA72,
	134155 - 131105: 0x8A5E,
	134157 - 131105: 0x94E0,
	134176 - 131105: 0x92CC,
	134196 - 131105: 0x8AE5,
	134202 - 131105: 0xFE5C,
	134203 - 131105: 0x9ACC,
	134209 - 131105: 0x9DF9,
	134210 - 131105: 0x8A43,
	134211 - 131105: 0x8AA6,
	134227 - 131105: 0x9ACD,
	134245 - 131105: 0x9ACE,
	134263 - 131105: 0xFAEE,
	134264 - 131105: 0x9BCC,
	134268 - 131105: 0x9ACF,
	134285 - 131105: 0x9AD1,
	134294 - 131105: 0x9DFA,
	134300 - 131105: 0x9D7C,
	134325 - 131105: 0x9AD3,
	134328 - 131105: 0x97A6,
	134351 - 131105: 0x995F,
	134355 - 131105: 0xFBF6,
	134356 - 131105: 0x9FC5,
	134357 - 131105: 0x8A59,
	134358 - 131105: 0x8B6B,
	134365 - 131105: 0x9AD4,
	134381 - 131105: 0x9AD5,
	134399 - 131105: 0x97A2,
	134421 - 131105: 0x8A44,
	134440 - 131105: 0x9F4A,
	134449 - 131105: 0x90A1,
	134450 - 131105: 0xFDA4,
	134470 - 131105: 0x8A64,
	134471 - 131105: 0x8AF2,
	134472 - 131105: 0x8AF8,
	134473 - 131105: 0x9DD8,
	134476 - 131105: 0x94D6,
	134477 - 131105: 0xFAFE,
	134478 - 131105: 0xFBA7,
	134511 - 131105: 0x9AD6,
	134513 - 131105: 0x9F4D,
	134516 - 131105: 0xFAF6,
	134524 - 131105: 0x8A57,
	134526 - 131105: 0x8B43,
	134527 - 131105: 0x8B44,
	134550 - 131105: 0x8AB6,
	134556 - 131105: 0x8AC0,
	134567 - 131105: 0x9E54,
	134578 - 131105: 0x9AD7,
	134600 - 131105: 0x9AD8,
	134660 - 131105: 0x9ADC,
	134665 - 131105: 0x8ACA,
	134666 - 131105: 0x9EA8,
	134669 - 131105: 0x9263,
	134670 - 131105: 0x9ADD,
	134671 - 131105: 0x8B65,
	134672 - 131105: 0x8B6F,
	134673 - 131105: 0x8B7E,
	134678 - 131105: 0x8F43,
	134685 - 131105: 0x92D0,
	134732 - 131105: 0x8AF4,
	134765 - 131105: 0x9DBE,
	134771 - 131105: 0x9AE1,
	134773 - 131105: 0xFCDE,
	134774 - 131105: 0x9DFD,
	134775 - 131105: 0x8B66,
	134776 - 131105: 0x8B70,
	134777 - 131105: 0x8B75,
	134778 - 131105: 0x8AE4,
	134779 - 131105: 0x8BA4,
	134796 - 131105: 0x8AED,
	134806 - 131105: 0x8A5D,
	134808 - 131105: 0x8B48,
	134813 - 131105: 0x9DED,
	134818 - 131105: 0x9E40,
	134826 - 131105: 0x8AEF,
	134827 - 131105: 0x8AF6,
	134828 - 131105: 0x9E76,
	134838 - 131105: 0x9EE3,
	134871 - 131105: 0x9ADE,
	134872 - 131105: 0x8DFE,
	134877 - 131105: 0xFAFC,
	134904 - 131105: 0x9CB1,
	134905 - 131105: 0x9E77,
	134906 - 131105: 0x8B64,
	134907 - 131105: 0x8B67,
	134941 - 131105: 0x974B,
	134950 - 131105: 0x9653,
	134957 - 131105: 0x9AE0,
	134958 - 131105: 0x8B4A,
	134960 - 131105: 0x8AF1,
	134961 - 131105: 0x8AD7,
	134971 - 131105: 0xA0AB,
	134988 - 131105: 0x8AB5,
	135012 - 131105: 0x8A5F,
	135053 - 131105: 0x8AEE,
	135056 - 131105: 0x9ADF,
	135085 - 131105: 0x8AFE,
	135092 - 131105: 0x8A58,
	135093 - 131105: 0x8BA3,
	135094 - 131105: 0x8BA7,
	135100 - 131105: 0x9AE3,
	135135 - 131105: 0x9261,
	135146 - 131105: 0x9DD7,
	135147 - 131105: 0x9E7D,
	135148 - 131105: 0x9EA7,
	135149 - 131105: 0x9EAB,
	135188 - 131105: 0x9042,
	135197 - 131105: 0x8B79,
	135198 - 131105: 0x8B7A,
	135247 - 131105: 0x9AE6,
	135260 - 131105: 0x9AE5,
	135279 - 131105: 0x8A7E,
	135285 - 131105: 0x9E44,
	135286 - 131105: 0x9AE7,
	135287 - 131105: 0x8A7C,
	135288 - 131105: 0x8B71,
	135291 - 131105: 0x9AE9,
	135304 - 131105: 0x9AEA,
	135318 - 131105: 0x9AEB,
	135325 - 131105: 0x8ABD,
	135348 - 131105: 0xFB4E,
	135359 - 131105: 0x9AED,
	135360 - 131105: 0x8AF9,
	135361 - 131105: 0x9E63,
	135367 - 131105: 0x8B49,
	135368 - 131105: 0x8ACE,
	135369 - 131105: 0x8B6E,
	135375 - 131105: 0x8AE8,
	135379 - 131105: 0x9AEE,
	135396 - 131105: 0x92CE,
	135412 - 131105: 0x8A5A,
	135413 - 131105: 0x8B7B,
	135414 - 131105: 0x8B7C,
	135471 - 131105: 0x9AEF,
	135483 - 131105: 0x9AF0,
	135485 - 131105: 0x8AFA,
	135493 - 131105: 0x8941,
	135496 - 131105: 0x8B72,
	135503 - 131105: 0x8AF3,
	135552 - 131105: 0x8BA8,
	135559 - 131105: 0x9EAE,
	135641 - 131105: 0x9E72,
	135740 - 131105: 0xFB73,
	135759 - 131105: 0xFB5F,
	135804 - 131105: 0x90BA,
	135848 - 131105: 0x91FE,
	135849 - 131105: 0x9EF6,
	135856 - 131105: 0x97ED,
	135907 - 131105: 0x9AF3,
	135934 - 131105: 0xA0EE,
	135938 - 131105: 0x967C,
	135939 - 131105: 0x9345,
	135940 - 131105: 0x986E,
	135941 - 131105: 0xFA56,
	135990 - 131105: 0x9AF5,
	135994 - 131105: 0xFC4B,
	136053 - 131105: 0x9AF4,
	136054 - 131105: 0xFEDE,
	136078 - 131105: 0xFCB7,
	136088 - 131105: 0x97F1,
	136092 - 131105: 0x97C7,
	136133 - 131105: 0x9CCB,
	136134 - 131105: 0x9240,
	136173 - 131105: 0x9CE8,
	136190 - 131105: 0x91FD,
	136211 - 131105: 0x974E,
	136214 - 131105: 0xFB68,
	136228 - 131105: 0x976C,
	136255 - 131105: 0x8CC2,
	136274 - 131105: 0x97E8,
	136276 - 131105: 0xFB6A,
	136277 - 131105: 0x8B74,
	136330 - 131105: 0x8EE7,
	136343 - 131105: 0xFDC8,
	136374 - 131105: 0x9241,
	136424 - 131105: 0x96A1,
	136445 - 131105: 0x8EF3,
	136567 - 131105: 0x9AF7,
	136578 - 131105: 0x8FA6,
	136598 - 131105: 0xFAD6,
	136714 - 131105: 0x9CC7,
	136723 - 131105: 0xFAD7,
	136729 - 131105: 0x9AF8,
	136766 - 131105: 0xFBA1,
	136801 - 131105: 0x8EC5,
	136850 - 131105: 0xFBA4,
	136888 - 131105: 0xFBC2,
	136890 - 131105: 0x9AC1,
	136896 - 131105: 0x91FA,
	136897 - 131105: 0xFEDB,
	136898 - 131105: 0x97AB,
	136915 - 131105: 0x9147,
	136917 - 131105: 0xFBB1,
	136927 - 131105: 0x8FEA,
	136934 - 131105: 0x94D2,
	136935 - 131105: 0xFE61,
	136936 - 131105: 0xFACE,
	136954 - 131105: 0x92ED,
	136955 - 131105: 0x91F3,
	136956 - 131105: 0x93C6,
	136958 - 131105: 0x935A,
	136973 - 131105: 0xFAFB,
	136976 - 131105: 0x92EF,
	136998 - 131105: 0xFAC8,
	137018 - 131105: 0x9847,
	137019 - 131105: 0x9366,
	137020 - 131105: 0x9855,
	137047 - 131105: 0x96E6,
	137068 - 131105: 0x9F43,
	137069 - 131105: 0x9FAA,
	137070 - 131105: 0x94DA,
	137071 - 131105: 0x92EE,
	137072 - 131105: 0xFCAF,
	137073 - 131105: 0xFBFB,
	137075 - 131105: 0x8EF9,
	137076 - 131105: 0x91F6,
	137131 - 131105: 0x9364,
	137136 - 131105: 0x94F5,
	137137 - 131105: 0x9CB6,
	137138 - 131105: 0xFBAD,
	137139 - 131105: 0x984E,
	137140 - 131105: 0x8F44,
	137141 - 131105: 0x96FD,
	137155 - 131105: 0x9AF9,
	137159 - 131105: 0x9AFA,
	137177 - 131105: 0x9769,
	137178 - 131105: 0x95D4,
	137179 - 131105: 0x984B,
	137180 - 131105: 0xFBAA,
	137183 - 131105: 0x987C,
	137199 - 131105: 0x91EA,
	137205 - 131105: 0x9DAF,
	137206 - 131105: 0x9DC5,
	137208 - 131105: 0x91F1,
	137209 - 131105: 0x8EB1,
	137210 - 131105: 0x97A9,
	137211 - 131105: 0xFBAC,
	137212 - 131105: 0xFCB8,
	137248 - 131105: 0x9CB9,
	137256 - 131105: 0xFBB0,
	137257 - 131105: 0xFCD2,
	137258 - 131105: 0x93CB,
	137261 - 131105: 0x9AFD,
	137273 - 131105: 0x91F4,
	137274 - 131105: 0x8BAC,
	137275 - 131105: 0xA055,
	137280 - 131105: 0x9574,
	137285 - 131105: 0x95BE,
	137298 - 131105: 0x97AD,
	137310 - 131105: 0x8EE9,
	137313 - 131105: 0x92F8,
	137314 - 131105: 0x97BE,
	137315 - 131105: 0x916C,
	137316 - 131105: 0x94AA,
	137335 - 131105: 0xFC63,
	137339 - 131105: 0x9DC6,
	137347 - 131105: 0x97B5,
	137348 - 131105: 0x92B8,
	137349 - 131105: 0x91EF,
	137374 - 131105: 0xFEA6,
	137375 - 131105: 0x9760,
	137376 - 131105: 0x9358,
	137377 - 131105: 0x9576,
	137378 - 131105: 0x8FAC,
	137406 - 131105: 0x91EC,
	137407 - 131105: 0x97B4,
	137425 - 131105: 0x91F7,
	137430 - 131105: 0x974A,
	137431 - 131105: 0xFB49,
	137432 - 131105: 0x9578,
	137433 - 131105: 0x93BC,
	137466 - 131105: 0x91D6,
	137475 - 131105: 0x9355,
	137476 - 131105: 0x9356,
	137477 - 131105: 0x9851,
	137488 - 131105: 0x8FF8,
	137489 - 131105: 0xFBC0,
	137490 - 131105: 0x93F2,
	137493 - 131105: 0x90D0,
	137500 - 131105: 0x9C44,
	137506 - 131105: 0x9255,
	137511 - 131105: 0x9363,
	137531 - 131105: 0x91A5,
	137540 - 131105: 0xA0ED,
	137560 - 131105: 0xFD6B,
	137578 - 131105: 0x9AFE,
	137596 - 131105: 0x9351,
	137600 - 131105: 0x8C57,
	137603 - 131105: 0xFA78,
	137608 - 131105: 0xFEA8,
	137622 - 131105: 0x9350,
	137691 - 131105: 0xFA4C,
	137715 - 131105: 0x92F7,
	137773 - 131105: 0x9B40,
	137780 - 131105: 0xFBCE,
	137797 - 131105: 0x9B41,
	137803 - 131105: 0xFEAD,
	137827 - 131105: 0x8761,
	138052 - 131105: 0xFBD5,
	138177 - 131105: 0x8BC2,
	138178 - 131105: 0x9A7C,
	138282 - 131105: 0x9B42,
	138352 - 131105: 0x9B43,
	138402 - 131105: 0x9E79,
	138405 - 131105: 0xFBD9,
	138412 - 131105: 0x9B44,
	138566 - 131105: 0xA0A7,
	138579 - 131105: 0x877B,
	138590 - 131105: 0x876E,
	138640 - 131105: 0x9BF3,
	138678 - 131105: 0x8C79,
	138682 - 131105: 0x935E,
	138698 - 131105: 0x89CB,
	138705 - 131105: 0x9F53,
	138731 - 131105: 0x93D7,
	138745 - 131105: 0xFBE1,
	138780 - 131105: 0xFED0,
	138787 - 131105: 0x8CF1,
	138807 - 131105: 0xFBE2,
	138813 - 131105: 0xFCE3,
	138889 - 131105: 0x9074,
	138916 - 131105: 0xFBE6,
	138920 - 131105: 0x9BB7,
	138952 - 131105: 0x9B45,
	138965 - 131105: 0x9B47,
	139023 - 131105: 0x9F50,
	139029 - 131105: 0x9B48,
	139114 - 131105: 0xFC5B,
	139166 - 131105: 0x98A9,
	139169 - 131105: 0x9CFD,
	139240 - 131105: 0x884C,
	139333 - 131105: 0x9B4B,
	139337 - 131105: 0xFBEC,
	139390 - 131105: 0x8C69,
	139418 - 131105: 0x9BA8,
	139463 - 131105: 0x8AD5,
	139516 - 131105: 0xFA73,
	139562 - 131105: 0xFD59,
	139611 - 131105: 0x91A2,
	139635 - 131105: 0xFBED,
	139642 - 131105: 0x9CA9,
	139681 - 131105: 0x8AA8,
	139713 - 131105: 0x8D42,
	139715 - 131105: 0x9BC3,
	139784 - 131105: 0x8AE1,
	139900 - 131105: 0x9B4E,
	140065 - 131105: 0x95D0,
	140069 - 131105: 0x905F,
	140221 - 131105: 0x97EE,
	140240 - 131105: 0xFC4E,
	140247 - 131105: 0x9B4F,
	140282 - 131105: 0x9B50,
	140389 - 131105: 0x9EC6,
	140401 - 131105: 0xFC50,
	140427 - 131105: 0xFD73,
	140433 - 131105: 0xFDA7,
	140464 - 131105: 0x9DA2,
	140476 - 131105: 0x87D1,
	140481 - 131105: 0x87D3,
	140489 - 131105: 0x87D4,
	140492 - 131105: 0x87D5,
	140525 - 131105: 0xFA58,
	140563 - 131105: 0xFA5E,
	140571 - 131105: 0xA059,
	140592 - 131105: 0xFA75,
	140628 - 131105: 0xFBBE,
	140685 - 131105: 0x9CA2,
	140719 - 131105: 0x9370,
	140734 - 131105: 0x9371,
	140827 - 131105: 0x9377,
	140828 - 131105: 0xFEEF,
	140843 - 131105: 0x936D,
	140904 - 131105: 0xFC5D,
	140922 - 131105: 0x90B8,
	140950 - 131105: 0x8AFC,
	140952 - 131105: 0xFB41,
	141044 - 131105: 0x9E6B,
	141045 - 131105: 0x94E3,
	141046 - 131105: 0x8EE2,
	141074 - 131105: 0x8C7D,
	141076 - 131105: 0x8ED7,
	141083 - 131105: 0x9C4D,
	141087 - 131105: 0x96A3,
	141098 - 131105: 0x9B51,
	141173 - 131105: 0x8AC3,
	141185 - 131105: 0x96AA,
	141206 - 131105: 0x8CE2,
	141236 - 131105: 0xFC68,
	141237 - 131105: 0x8B6D,
	141261 - 131105: 0xFD67,
	141315 - 131105: 0x8AE9,
	141407 - 131105: 0xFCA1,
	141408 - 131105: 0x936C,
	141425 - 131105: 0x9B52,
	141485 - 131105: 0xFE70,
	141505 - 131105: 0xFCA8,
	141559 - 131105: 0xFCE9,
	141606 - 131105: 0x9CB4,
	141625 - 131105: 0x8AEA,
	141647 - 131105: 0x9B53,
	141671 - 131105: 0x9B55,
	141675 - 131105: 0x96AB,
	141696 - 131105: 0xFCA7,
	141715 - 131105: 0x9B56,
	141926 - 131105: 0x8ABC,
	142031 - 131105: 0x8ACB,
	142037 - 131105: 0x9B57,
	142054 - 131105: 0x89CD,
	142056 - 131105: 0x9B59,
	142094 - 131105: 0x9B5B,
	142114 - 131105: 0x93A5,
	142143 - 131105: 0x9B5D,
	142147 - 131105: 0x9E4F,
	142186 - 131105: 0x93A3,
	142282 - 131105: 0x8A7B,
	142286 - 131105: 0x8B42,
	142374 - 131105: 0x9750,
	142375 - 131105: 0x8FB3,
	142392 - 131105: 0x8A50,
	142412 - 131105: 0x9B60,
	142417 - 131105: 0x8B45,
	142421 - 131105: 0x8B46,
	142434 - 131105: 0x9DFE,
	142472 - 131105: 0x9B62,
	142491 - 131105: 0x937B,
	142497 - 131105: 0x93B1,
	142505 - 131105: 0x8A60,
	142514 - 131105: 0x8AD8,
	142519 - 131105: 0x9B63,
	142530 - 131105: 0x8A69,
	142534 - 131105: 0x8A47,
	142537 - 131105: 0x8ACC,
	142599 - 131105: 0x937C,
	142600 - 131105: 0x9B65,
	142610 - 131105: 0x9B66,
	142660 - 131105: 0x8A72,
	142668 - 131105: 0x8A7A,
	142695 - 131105: 0x93AF,
	142733 - 131105: 0x8AB0,
	142741 - 131105: 0x9B68,
	142752 - 131105: 0x9EA3,
	142755 - 131105: 0xFAEC,
	142756 - 131105: 0x8B77,
	142775 - 131105: 0x9B67,
	142830 - 131105: 0x8B59,
	142861 - 131105: 0xFCB1,
	142902 - 131105: 0xFCBB,
	142914 - 131105: 0x9B69,
	142968 - 131105: 0x93A8,
	142987 - 131105: 0x8AE0,
	143027 - 131105: 0x9E51,
	143087 - 131105: 0x8F5F,
	143220 - 131105: 0x9B6A,
	143308 - 131105: 0x9B6B,
	143331 - 131105: 0x97EC,
	143411 - 131105: 0x9B6C,
	143428 - 131105: 0xFE4E,
	143435 - 131105: 0xFDC2,
	143462 - 131105: 0x9B6D,
	143485 - 131105: 0x9167,
	143486 - 131105: 0xFCCC,
	143502 - 131105: 0x93B6,
	143543 - 131105: 0x90E4,
	143548 - 131105: 0x90E5,
	143578 - 131105: 0x9EF2,
	143619 - 131105: 0x93CA,
	143677 - 131105: 0x8BBC,
	143741 - 131105: 0x8F46,
	143746 - 131105: 0x93CF,
	143780 - 131105: 0xFCDB,
	143781 - 131105: 0xFCDC,
	143795 - 131105: 0x93C0,
	143816 - 131105: 0xFCE6,
	143817 - 131105: 0x96E7,
	143850 - 131105: 0x87A7,
	143863 - 131105: 0xFCD8,
	143864 - 131105: 0xFCD9,
	143865 - 131105: 0xFDA6,
	143887 - 131105: 0x93CE,
	143909 - 131105: 0x95F1,
	143919 - 131105: 0x9CE9,
	143921 - 131105: 0xFCE4,
	143922 - 131105: 0x94AF,
	143923 - 131105: 0xFA77,
	143924 - 131105: 0x93CC,
	143958 - 131105: 0x8CE1,
	143966 - 131105: 0x87A9,
	143970 - 131105: 0x905A,
	144001 - 131105: 0x8C54,
	144009 - 131105: 0x93BF,
	144010 - 131105: 0xFB51,
	144043 - 131105: 0x93B9,
	144044 - 131105: 0xFED7,
	144045 - 131105: 0x93B7,
	144082 - 131105: 0x93D9,
	144096 - 131105: 0x93BB,
	144097 - 131105: 0x93DA,
	144128 - 131105: 0x98A3,
	144138 - 131105: 0x90D1,
	144159 - 131105: 0x9B6E,
	144308 - 131105: 0xFA70,
	144332 - 131105: 0x9BEB,
	144350 - 131105: 0x9B6F,
	144358 - 131105: 0xFCFC,
	144372 - 131105: 0x8B40,
	144373 - 131105: 0xA07B,
	144377 - 131105: 0x8CA1,
	144378 - 131105: 0x97F7,
	144382 - 131105: 0x93E2,
	144384 - 131105: 0xFCD6,
	144447 - 131105: 0x9559,
	144464 - 131105: 0x93A6,
	144495 - 131105: 0xFD40,
	144498 - 131105: 0x935F,
	144613 - 131105: 0x97F2,
	144665 - 131105: 0x9C76,
	144688 - 131105: 0x8EF8,
	144721 - 131105: 0x8CEB,
	144730 - 131105: 0x8F47,
	144743 - 131105: 0x9B74,
	144789 - 131105: 0x92B4,
	144793 - 131105: 0x91ED,
	144796 - 131105: 0x96D2,
	144827 - 131105: 0x87D8,
	144845 - 131105: 0xFD46,
	144846 - 131105: 0x8F4F,
	144847 - 131105: 0x9549,
	144883 - 131105: 0x9B75,
	144896 - 131105: 0xFA5C,
	144919 - 131105: 0x8751,
	144922 - 131105: 0x9B79,
	144956 - 131105: 0xFD4B,
	144960 - 131105: 0x96D3,
	144985 - 131105: 0xFD58,
	144991 - 131105: 0x945F,
	145015 - 131105: 0xA0F5,
	145038 - 131105: 0x87C7,
	145054 - 131105: 0x877C,
	145062 - 131105: 0x9243,
	145069 - 131105: 0x97FA,
	145082 - 131105: 0x9DD9,
	145119 - 131105: 0x97F4,
	145134 - 131105: 0x924D,
	145155 - 131105: 0xFD5B,
	145174 - 131105: 0x9B7A,
	145184 - 131105: 0x9ED5,
	145197 - 131105: 0xFAAE,
	145199 - 131105: 0x9CC9,
	145215 - 131105: 0x9258,
	145254 - 131105: 0x8EC8,
	145281 - 131105: 0x94B4,
	145314 - 131105: 0x93E1,
	145340 - 131105: 0x93DF,
	145346 - 131105: 0xFCF0,
	145365 - 131105: 0x93EC,
	145366 - 131105: 0x97F6,
	145367 - 131105: 0x96CF,
	145466 - 131105: 0x93DE,
	145858 - 131105: 0x8ACF,
	146087 - 131105: 0x9BA2,
	146139 - 131105: 0xFD69,
	146158 - 131105: 0x9352,
	146170 - 131105: 0x98A2,
	146202 - 131105: 0x8CE7,
	146266 - 131105: 0xFD6E,
	146531 - 131105: 0x8CA4,
	146585 - 131105: 0xFA7C,
	146586 - 131105: 0x93FA,
	146587 - 131105: 0x907C,
	146613 - 131105: 0x8F67,
	146615 - 131105: 0x9DB7,
	146631 - 131105: 0xA0E9,
	146632 - 131105: 0xFA4E,
	146633 - 131105: 0xFDA1,
	146684 - 131105: 0x9E74,
	146685 - 131105: 0x9FBF,
	146686 - 131105: 0x9ECB,
	146687 - 131105: 0x9BB9,
	146752 - 131105: 0x9DD4,
	146779 - 131105: 0x97B9,
	146814 - 131105: 0x8EF1,
	146831 - 131105: 0x957B,
	146870 - 131105: 0x9ED2,
	146871 - 131105: 0x9753,
	146872 - 131105: 0x96A4,
	146873 - 131105: 0x8FBE,
	146874 - 131105: 0x94D9,
	146875 - 131105: 0x9058,
	146876 - 131105: 0xFD79,
	146877 - 131105: 0xFD7B,
	146915 - 131105: 0x8EDA,
	146936 - 131105: 0x8EFA,
	146950 - 131105: 0x8762,
	146961 - 131105: 0x9BA5,
	146988 - 131105: 0x9ED9,
	146989 - 131105: 0x97D4,
	146990 - 131105: 0x90BB,
	146991 - 131105: 0xFDBC,
	146992 - 131105: 0xFDC6,
	146993 - 131105: 0x9248,
	147001 - 131105: 0x92B5,
	147080 - 131105: 0x9DC1,
	147081 - 131105: 0x92B9,
	147082 - 131105: 0x92A6,
	147083 - 131105: 0x8F4B,
	147129 - 131105: 0x9BA6,
	147135 - 131105: 0x92B6,
	147159 - 131105: 0x8E40,
	147191 - 131105: 0x9ED8,
	147192 - 131105: 0x945E,
	147193 - 131105: 0x985F,
	147194 - 131105: 0x94CE,
	147195 - 131105: 0x924A,
	147196 - 131105: 0xFD70,
	147253 - 131105: 0x9467,
	147265 - 131105: 0x8DEC,
	147274 - 131105: 0x9BD8,
	147297 - 131105: 0x8763,
	147327 - 131105: 0x9448,
	147328 - 131105: 0xFAC1,
	147329 - 131105: 0x9CF7,
	147330 - 131105: 0xFDBE,
	147343 - 131105: 0x8FDA,
	147380 - 131105: 0xFDD9,
	147383 - 131105: 0xFC7E,
	147392 - 131105: 0x93F9,
	147397 - 131105: 0xFA43,
	147435 - 131105: 0xFAEB,
	147436 - 131105: 0xFAC3,
	147437 - 131105: 0x97D3,
	147438 - 131105: 0x95F9,
	147439 - 131105: 0x9C48,
	147440 - 131105: 0xFDD8,
	147473 - 131105: 0xA0D8,
	147513 - 131105: 0xFDD7,
	147514 - 131105: 0xFB4A,
	147515 - 131105: 0x9BAF,
	147516 - 131105: 0x944B,
	147517 - 131105: 0xFDC9,
	147543 - 131105: 0x8EAC,
	147589 - 131105: 0xFDB2,
	147595 - 131105: 0x925A,
	147596 - 131105: 0xFCBD,
	147597 - 131105: 0x92D9,
	147601 - 131105: 0xFDD5,
	147657 - 131105: 0x92DD,
	147681 - 131105: 0x9259,
	147692 - 131105: 0x8CF0,
	147716 - 131105: 0x96BA,
	147727 - 131105: 0x925B,
	147737 - 131105: 0x9BAB,
	147775 - 131105: 0xFDDA,
	147776 - 131105: 0xFDDE,
	147780 - 131105: 0xFDD3,
	147790 - 131105: 0x8C46,
	147797 - 131105: 0xFDD6,
	147798 - 131105: 0xFDDC,
	147799 - 131105: 0xFDDD,
	147804 - 131105: 0x90FE,
	147807 - 131105: 0xFEA1,
	147809 - 131105: 0x87A5,
	147831 - 131105: 0x8BAD,
	147834 - 131105: 0x9CD8,
	147875 - 131105: 0x9E6D,
	147876 - 131105: 0xFD7C,
	147877 - 131105: 0xFB61,
	147884 - 131105: 0x96F8,
	147893 - 131105: 0x96F0,
	147917 - 131105: 0xFCF4,
	147938 - 131105: 0xFE60,
	147964 - 131105: 0x9852,
	147995 - 131105: 0x964F,
	148043 - 131105: 0x916E,
	148054 - 131105: 0x986D,
	148057 - 131105: 0x9864,
	148086 - 131105: 0x9453,
	148087 - 131105: 0xFDEC,
	148088 - 131105: 0xFB78,
	148100 - 131105: 0x95BA,
	148115 - 131105: 0x985D,
	148117 - 131105: 0x92F9,
	148133 - 131105: 0x985A,
	148159 - 131105: 0x8750,
	148161 - 131105: 0xFDF6,
	148169 - 131105: 0x93D0,
	148170 - 131105: 0x9862,
	148206 - 131105: 0x9BAD,
	148218 - 131105: 0x974F,
	148237 - 131105: 0x9BAE,
	148250 - 131105: 0x9452,
	148276 - 131105: 0x9BB0,
	148296 - 131105: 0x91D2,
	148322 - 131105: 0x97EA,
	148323 - 131105: 0xFB6B,
	148324 - 131105: 0x91B1,
	148325 - 131105: 0xFDF3,
	148364 - 131105: 0x92CB,
	148374 - 131105: 0x9BB1,
	148380 - 131105: 0xFCEC,
	148413 - 131105: 0x986B,
	148417 - 131105: 0x9751,
	148457 - 131105: 0x9871,
	148458 - 131105: 0x95EF,
	148466 - 131105: 0x9EF3,
	148472 - 131105: 0x91E8,
	148484 - 131105: 0x9BBA,
	148533 - 131105: 0xFB4C,
	148534 - 131105: 0x926A,
	148570 - 131105: 0xFDF8,
	148571 - 131105: 0x9861,
	148595 - 131105: 0x91E7,
	148615 - 131105: 0x93ED,
	148616 - 131105: 0x9744,
	148665 - 131105: 0x91E1,
	148668 - 131105: 0xFBF5,
	148686 - 131105: 0x9869,
	148691 - 131105: 0x8A62,
	148694 - 131105: 0x9BBB,
	148741 - 131105: 0x8CA8,
	148769 - 131105: 0x9C55,
	148856 - 131105: 0x8E77,
	148936 - 131105: 0x8AB2,
	149016 - 131105: 0x9EBC,
	149034 - 131105: 0x93E6,
	149093 - 131105: 0x93A2,
	149108 - 131105: 0x9BBD,
	149143 - 131105: 0x94B3,
	149204 - 131105: 0x937D,
	149254 - 131105: 0x9E66,
	149285 - 131105: 0x9459,
	149295 - 131105: 0x9BBF,
	149391 - 131105: 0x9458,
	149472 - 131105: 0x9EA5,
	149522 - 131105: 0x9BC7,
	149539 - 131105: 0xFE54,
	149634 - 131105: 0x8E74,
	149737 - 131105: 0x8BD6,
	149744 - 131105: 0x94B6,
	149745 - 131105: 0xFD74,
	149746 - 131105: 0x98C0,
	149747 - 131105: 0x94A5,
	149755 - 131105: 0x9BC8,
	149759 - 131105: 0x95ED,
	149760 - 131105: 0xFD7E,
	149761 - 131105: 0xFBEB,
	149772 - 131105: 0xFD7D,
	149782 - 131105: 0x976F,
	149783 - 131105: 0x9461,
	149785 - 131105: 0x9FC1,
	149807 - 131105: 0x95D7,
	149811 - 131105: 0xFA52,
	149812 - 131105: 0x9C58,
	149822 - 131105: 0x9F68,
	149823 - 131105: 0x9BE7,
	149824 - 131105: 0xFCCE,
	149825 - 131105: 0x96E8,
	149826 - 131105: 0xFA49,
	149827 - 131105: 0x97A1,
	149858 - 131105: 0x954D,
	149859 - 131105: 0x9EF8,
	149876 - 131105: 0xFE49,
	149877 - 131105: 0x91CE,
	149878 - 131105: 0x9771,
	149883 - 131105: 0x8CCF,
	149887 - 131105: 0xFDB1,
	149890 - 131105: 0xFC6E,
	149896 - 131105: 0x9CF2,
	149897 - 131105: 0x93B8,
	149898 - 131105: 0x9043,
	149899 - 131105: 0x9759,
	149900 - 131105: 0x94D7,
	149901 - 131105: 0xFE66,
	149902 - 131105: 0x947D,
	149903 - 131105: 0xFC6F,
	149908 - 131105: 0x9246,
	149924 - 131105: 0xFA6D,
	149927 - 131105: 0x8EF7,
	149929 - 131105: 0xFBB7,
	149931 - 131105: 0x947C,
	149932 - 131105: 0x92CD,
	149933 - 131105: 0x97B2,
	149943 - 131105: 0xFE65,
	149944 - 131105: 0x967E,
	149945 - 131105: 0x9758,
	149946 - 131105: 0x9B77,
	149947 - 131105: 0x91CF,
	149957 - 131105: 0x94A4,
	149968 - 131105: 0x9CAD,
	149978 - 131105: 0x8BAB,
	149982 - 131105: 0x96D5,
	149983 - 131105: 0xFCB3,
	149987 - 131105: 0x93AE,
	149989 - 131105: 0x976D,
	149996 - 131105: 0x9446,
	149997 - 131105: 0x95F7,
	150006 - 131105: 0x9C46,
	150007 - 131105: 0x955B,
	150008 - 131105: 0x91D1,
	150009 - 131105: 0x94F4,
	150011 - 131105: 0xFE67,
	150030 - 131105: 0x92A5,
	150034 - 131105: 0xFEDF,
	150035 - 131105: 0x8CAB,
	150037 - 131105: 0x9BC9,
	150049 - 131105: 0xFCED,
	150050 - 131105: 0xFDFA,
	150051 - 131105: 0xFCC8,
	150052 - 131105: 0xFE62,
	150053 - 131105: 0x91FC,
	150054 - 131105: 0xFE6B,
	150055 - 131105: 0xFDF9,
	150056 - 131105: 0xFCC7,
	150057 - 131105: 0x914E,
	150058 - 131105: 0x9CB8,
	150078 - 131105: 0x9767,
	150082 - 131105: 0x95EE,
	150085 - 131105: 0x9BB2,
	150090 - 131105: 0x9460,
	150094 - 131105: 0x94A2,
	150095 - 131105: 0x9875,
	150096 - 131105: 0x97AC,
	150097 - 131105: 0x91D3,
	150109 - 131105: 0x987B,
	150117 - 131105: 0x8EEB,
	150118 - 131105: 0x976A,
	150119 - 131105: 0x965E,
	150129 - 131105: 0x97EB,
	150135 - 131105: 0x9FF9,
	150136 - 131105: 0x95F8,
	150137 - 131105: 0xFEA2,
	150138 - 131105: 0x8FE6,
	150156 - 131105: 0xFE7E,
	150163 - 131105: 0x9DA4,
	150164 - 131105: 0x9768,
	150165 - 131105: 0x8EEC,
	150166 - 131105: 0x94BD,
	150180 - 131105: 0x945B,
	150181 - 131105: 0x9CF6,
	150182 - 131105: 0xFAA7,
	150183 - 131105: 0x9BD9,
	150193 - 131105: 0xFA5D,
	150194 - 131105: 0x9656,
	150195 - 131105: 0x9762,
	150202 - 131105: 0x94BA,
	150203 - 131105: 0xA04F,
	150204 - 131105: 0x92D8,
	150208 - 131105: 0x9BCB,
	150215 - 131105: 0x94BB,
	150218 - 131105: 0x9D5F,
	150225 - 131105: 0x90CF,
	150239 - 131105: 0x9465,
	150242 - 131105: 0x9F4C,
	150249 - 131105: 0x90D8,
	150287 - 131105: 0x8D5B,
	150382 - 131105: 0x9EBE,
	150517 - 131105: 0xFB6D,
	150537 - 131105: 0x95CA,
	150686 - 131105: 0x9DC2,
	150687 - 131105: 0x97F8,
	150729 - 131105: 0x8FFC,
	150745 - 131105: 0x9473,
	150790 - 131105: 0x9474,
	150803 - 131105: 0xFEB7,
	150968 - 131105: 0x8A4B,
	151018 - 131105: 0x8A55,
	151019 - 131105: 0x8B69,
	151099 - 131105: 0x8ADC,
	151120 - 131105: 0x8B76,
	151205 - 131105: 0x9BCE,
	151207 - 131105: 0x8A68,
	151310 - 131105: 0xA0F8,
	151388 - 131105: 0x98DF,
	151426 - 131105: 0xFEB5,
	151430 - 131105: 0x9BCF,
	151447 - 131105: 0x96FB,
	151450 - 131105: 0x9BFB,
	151465 - 131105: 0x9ECE,
	151480 - 131105: 0x8EE5,
	151490 - 131105: 0x9E7B,
	151596 - 131105: 0x9BD2,
	151634 - 131105: 0x8AA5,
	151709 - 131105: 0xFECE,
	151851 - 131105: 0x8A45,
	151880 - 131105: 0x9DFC,
	151933 - 131105: 0xFECF,
	151934 - 131105: 0x8BA5,
	152013 - 131105: 0x8C4A,
	152035 - 131105: 0x8AEC,
	152038 - 131105: 0xFCE0,
	152039 - 131105: 0x94AD,
	152096 - 131105: 0xFED5,
	152097 - 131105: 0x94AC,
	152144 - 131105: 0xFC5A,
	152217 - 131105: 0x9BD6,
	152263 - 131105: 0x8A6F,
	152280 - 131105: 0x8BA9,
	152334 - 131105: 0x8E5F,
	152337 - 131105: 0x9DCB,
	152339 - 131105: 0xFCE7,
	152601 - 131105: 0x9BD7,
	152613 - 131105: 0x93C8,
	152623 - 131105: 0x91F0,
	152624 - 131105: 0x8FE0,
	152646 - 131105: 0x9BDB,
	152684 - 131105: 0x90ED,
	152686 - 131105: 0x9BDC,
	152730 - 131105: 0x8D53,
	152881 - 131105: 0xA0EC,
	152885 - 131105: 0x98FA,
	152895 - 131105: 0x9BE0,
	152923 - 131105: 0x93C7,
	152924 - 131105: 0x9249,
	152925 - 131105: 0x96E1,
	152926 - 131105: 0x9BE2,
	152930 - 131105: 0x9BE4,
	152933 - 131105: 0x8FE1,
	152934 - 131105: 0x9BE5,
	152961 - 131105: 0x94C0,
	152964 - 131105: 0x93C3,
	152975 - 131105: 0x93C5,
	153017 - 131105: 0x9079,
	153045 - 131105: 0x977B,
	153051 - 131105: 0x907E,
	153056 - 131105: 0xFEE6,
	153093 - 131105: 0xFE46,
	153141 - 131105: 0x9DB8,
	153169 - 131105: 0x9270,
	153219 - 131105: 0x95A8,
	153237 - 131105: 0x8CB0,
	153315 - 131105: 0x94C8,
	153334 - 131105: 0x98B9,
	153350 - 131105: 0x9140,
	153373 - 131105: 0xFCBE,
	153381 - 131105: 0x9157,
	153405 - 131105: 0x8BB2,
	153458 - 131105: 0xFADF,
	153543 - 131105: 0x9BE6,
	153567 - 131105: 0x9643,
	153568 - 131105: 0x8E44,
	153569 - 131105: 0x9C4F,
	153687 - 131105: 0xFEF4,
	153693 - 131105: 0x9BE8,
	153714 - 131105: 0x93DC,
	153800 - 131105: 0x966F,
	153822 - 131105: 0x87A1,
	153825 - 131105: 0x8E4A,
	153859 - 131105: 0x9BED,
	153926 - 131105: 0x92F6,
	153942 - 131105: 0x9DB9,
	154028 - 131105: 0x8E4E,
	154060 - 131105: 0xFBCF,
	154196 - 131105: 0x8760,
	154261 - 131105: 0x9EC2,
	154268 - 131105: 0x94E5,
	154286 - 131105: 0x9BF0,
	154287 - 131105: 0x94E4,
	154345 - 131105: 0x9551,
	154484 - 131105: 0x8BBB,
	154505 - 131105: 0x9BF1,
	154547 - 131105: 0x94F0,
	154548 - 131105: 0x8E64,
	154566 - 131105: 0x94EA,
	154596 - 131105: 0x8F61,
	154600 - 131105: 0x9B64,
	154625 - 131105: 0x8E5B,
	154630 - 131105: 0x9BF2,
	154657 - 131105: 0x9FBE,
	154698 - 131105: 0x9DC9,
	154725 - 131105: 0x8E6C,
	154769 - 131105: 0x8F73,
	154788 - 131105: 0x8CAF,
	154816 - 131105: 0x8F75,
	154817 - 131105: 0x8E71,
	154878 - 131105: 0x8E60,
	154912 - 131105: 0x8E6A,
	154928 - 131105: 0x8C4C,
	154947 - 131105: 0x9552,
	155033 - 131105: 0x87CF,
	155065 - 131105: 0x87C0,
	155150 - 131105: 0x9554,
	155209 - 131105: 0x8AD4,
	155265 - 131105: 0x9DBB,
	155266 - 131105: 0x9543,
	155267 - 131105: 0x92FE,
	155302 - 131105: 0x94F2,
	155324 - 131105: 0x94F1,
	155351 - 131105: 0xA0EA,
	155352 - 131105: 0x9DD2,
	155418 - 131105: 0xA0B1,
	155467 - 131105: 0x91F8,
	155617 - 131105: 0x9462,
	155618 - 131105: 0x9BA4,
	155681 - 131105: 0x877D,
	155689 - 131105: 0x8EAD,
	155720 - 131105: 0x9EAD,
	155748 - 131105: 0x96D0,
	155779 - 131105: 0xFEEE,
	155799 - 131105: 0x8AB4,
	155812 - 131105: 0x9757,
	155813 - 131105: 0x8A77,
	155906 - 131105: 0x9BF7,
	155937 - 131105: 0x8EB5,
	155993 - 131105: 0xA06D,
	155994 - 131105: 0x8EB6,
	155995 - 131105: 0x9756,
	155996 - 131105: 0x9540,
	156077 - 131105: 0xA0F3,
	156078 - 131105: 0x94BE,
	156082 - 131105: 0x9BFA,
	156125 - 131105: 0xFDDF,
	156248 - 131105: 0x9DBC,
	156257 - 131105: 0x94FE,
	156266 - 131105: 0x8BDB,
	156267 - 131105: 0xA0FE,
	156368 - 131105: 0x8EC0,
	156469 - 131105: 0x9F47,
	156491 - 131105: 0x8BDE,
	156492 - 131105: 0xA0FB,
	156497 - 131105: 0x8EC3,
	156606 - 131105: 0x9649,
	156661 - 131105: 0xFEC2,
	156664 - 131105: 0x954C,
	156674 - 131105: 0x9BFD,
	156688 - 131105: 0x90CC,
	156689 - 131105: 0x9C60,
	156690 - 131105: 0x954B,
	156746 - 131105: 0x9BFE,
	156777 - 131105: 0x9C70,
	156804 - 131105: 0x9C43,
	156808 - 131105: 0x9C47,
	156809 - 131105: 0x8ECC,
	156813 - 131105: 0x8E54,
	156824 - 131105: 0x8EE4,
	156946 - 131105: 0x9C49,
	157042 - 131105: 0x8B5E,
	157088 - 131105: 0x955E,
	157101 - 131105: 0x955C,
	157119 - 131105: 0x9C4B,
	157202 - 131105: 0x8BE1,
	157222 - 131105: 0x8ED9,
	157359 - 131105: 0x9DB4,
	157361 - 131105: 0x925F,
	157365 - 131105: 0x9C4C,
	157402 - 131105: 0x8AA1,
	157416 - 131105: 0x8EDB,
	157436 - 131105: 0x9C56,
	157462 - 131105: 0x8AA2,
	157505 - 131105: 0x9754,
	157593 - 131105: 0x9C5E,
	157619 - 131105: 0x9ED4,
	157620 - 131105: 0x9568,
	157644 - 131105: 0xA0C3,
	157724 - 131105: 0x8AE6,
	157766 - 131105: 0xA0F7,
	157790 - 131105: 0x9C61,
	157806 - 131105: 0x9C5F,
	157832 - 131105: 0xFC4D,
	157834 - 131105: 0x9E5B,
	157843 - 131105: 0x9E69,
	157895 - 131105: 0x9C63,
	157966 - 131105: 0xFEC7,
	157969 - 131105: 0xFEC6,
	157990 - 131105: 0x9C67,
	158009 - 131105: 0x9C69,
	158033 - 131105: 0x8BE2,
	158120 - 131105: 0x9165,
	158133 - 131105: 0x9CE7,
	158194 - 131105: 0x8A54,
	158202 - 131105: 0x9C6C,
	158253 - 131105: 0x9C6E,
	158254 - 131105: 0xFE5D,
	158260 - 131105: 0x9C73,
	158274 - 131105: 0x956A,
	158289 - 131105: 0x956D,
	158290 - 131105: 0x8EF0,
	158469 - 131105: 0x8F4D,
	158474 - 131105: 0x8EF6,
	158483 - 131105: 0xFABC,
	158485 - 131105: 0x8CD5,
	158499 - 131105: 0x875E,
	158504 - 131105: 0xFBDA,
	158544 - 131105: 0x8B4C,
	158545 - 131105: 0xFD75,
	158546 - 131105: 0x9BDD,
	158547 - 131105: 0xFAF5,
	158555 - 131105: 0x9C74,
	158581 - 131105: 0x9545,
	158594 - 131105: 0x96C6,
	158614 - 131105: 0x8F6A,
	158615 - 131105: 0x8F4E,
	158621 - 131105: 0x9C78,
	158643 - 131105: 0xFA55,
	158656 - 131105: 0x97E4,
	158711 - 131105: 0x9C41,
	158753 - 131105: 0x925C,
	158784 - 131105: 0x96FA,
	158785 - 131105: 0x8CF6,
	158790 - 131105: 0x8D4D,
	158846 - 131105: 0xFB66,
	158847 - 131105: 0x8E65,
	158848 - 131105: 0x9849,
	158849 - 131105: 0xFBA8,
	158850 - 131105: 0x9842,
	158884 - 131105: 0x9C7A,
	158903 - 131105: 0x97FB,
	158904 - 131105: 0x90CA,
	158909 - 131105: 0x9C5B,
	158912 - 131105: 0x974D,
	158915 - 131105: 0x8ED3,
	158929 - 131105: 0x9561,
	159010 - 131105: 0x9F4B,
	159011 - 131105: 0x9FB5,
	159012 - 131105: 0x93D2,
	159013 - 131105: 0xFDAA,
	159014 - 131105: 0x9840,
	159015 - 131105: 0x9146,
	159016 - 131105: 0x9867,
	159017 - 131105: 0xFA5A,
	159018 - 131105: 0xFBA9,
	159057 - 131105: 0x9841,
	159092 - 131105: 0x8CD3,
	159136 - 131105: 0xFCFD,
	159137 - 131105: 0xFDAB,
	159138 - 131105: 0x91BD,
	159139 - 131105: 0x8F4C,
	159140 - 131105: 0x96C9,
	159141 - 131105: 0x8F55,
	159142 - 131105: 0xFBAE,
	159143 - 131105: 0x956F,
	159150 - 131105: 0x9C7D,
	159196 - 131105: 0xA0F0,
	159210 - 131105: 0x946F,
	159211 - 131105: 0xFDAC,
	159216 - 131105: 0x96CB,
	159232 - 131105: 0x96CE,
	159237 - 131105: 0xA056,
	159239 - 131105: 0x9CE1,
	159250 - 131105: 0x96C4,
	159298 - 131105: 0x8F5E,
	159299 - 131105: 0x8F6C,
	159300 - 131105: 0x8EA3,
	159301 - 131105: 0xFBB3,
	159342 - 131105: 0xFC53,
	159346 - 131105: 0xFDB3,
	159351 - 131105: 0x8F6B,
	159364 - 131105: 0x96CA,
	159368 - 131105: 0x87CD,
	159371 - 131105: 0x8753,
	159385 - 131105: 0x8F79,
	159440 - 131105: 0x9E6F,
	159441 - 131105: 0xA0C5,
	159442 - 131105: 0xFC78,
	159443 - 131105: 0x8E42,
	159444 - 131105: 0x8F5A,
	159445 - 131105: 0x90C2,
	159446 - 131105: 0x8EA5,
	159447 - 131105: 0x9061,
	159526 - 131105: 0x924F,
	159603 - 131105: 0x9373,
	159604 - 131105: 0xFDB5,
	159647 - 131105: 0xFECC,
	159649 - 131105: 0xFBBD,
	159678 - 131105: 0x8CD6,
	159710 - 131105: 0x9843,
	159711 - 131105: 0x96C5,
	159758 - 131105: 0x89BC,
	159819 - 131105: 0x9CA3,
	159826 - 131105: 0x924B,
	159827 - 131105: 0x984A,
	159880 - 131105: 0x8FA4,
	159917 - 131105: 0xA0F1,
	159918 - 131105: 0x9EFB,
	159919 - 131105: 0x9CD2,
	159949 - 131105: 0x8FA7,
	159954 - 131105: 0x8754,
	159992 - 131105: 0xFC5C,
	160009 - 131105: 0x9845,
	160012 - 131105: 0x9046,
	160013 - 131105: 0x8CD1,
	160038 - 131105: 0xFEFA,
	160039 - 131105: 0x9560,
	160100 - 131105: 0x9F48,
	160101 - 131105: 0x9247,
	160117 - 131105: 0x90FB,
	160205 - 131105: 0x9CA4,
	160283 - 131105: 0x9571,
	160359 - 131105: 0x8745,
	160384 - 131105: 0x9CA6,
	160389 - 131105: 0x9CA7,
	160395 - 131105: 0x9CAA,
	160434 - 131105: 0x9ED3,
	160438 - 131105: 0x9E70,
	160486 - 131105: 0x9CAC,
	160594 - 131105: 0x8752,
	160666 - 131105: 0x8FAE,
	160767 - 131105: 0x8D50,
	160802 - 131105: 0x957D,
	160848 - 131105: 0x9CB0,
	160900 - 131105: 0x97B6,
	160902 - 131105: 0xA0BD,
	161140 - 131105: 0x8ADF,
	161187 - 131105: 0x9EAA,
	161248 - 131105: 0x8FBD,
	161252 - 131105: 0x8FBF,
	161277 - 131105: 0x9369,
	161278 - 131105: 0x9BA7,
	161287 - 131105: 0xC8A4,
	161292 - 131105: 0xFEEA,
	161330 - 131105: 0x9BE1,
	161337 - 131105: 0x8B41,
	161365 - 131105: 0x9DB6,
	161366 - 131105: 0xA0EB,
	161367 - 131105: 0x9BA3,
	161428 - 131105: 0x8BA1,
	161551 - 131105: 0x8FC8,
	161589 - 131105: 0x894C,
	161590 - 131105: 0x9860,
	161601 - 131105: 0x94C7,
	161630 - 131105: 0x8B58,
	161668 - 131105: 0x95AB,
	161669 - 131105: 0x95AA,
	161740 - 131105: 0x9CC3,
	161880 - 131105: 0x9CC4,
	161904 - 131105: 0x93D6,
	161949 - 131105: 0x9DAC,
	161970 - 131105: 0x8BE6,
	161992 - 131105: 0x8A71,
	162084 - 131105: 0x8FD1,
	162151 - 131105: 0x99D5,
	162170 - 131105: 0x90F4,
	162208 - 131105: 0x8AA3,
	162269 - 131105: 0x9CCE,
	162301 - 131105: 0x9CD4,
	162314 - 131105: 0x9CD5,
	162318 - 131105: 0xFBC8,
	162366 - 131105: 0x9DB3,
	162387 - 131105: 0xFC70,
	162393 - 131105: 0x8FD7,
	162425 - 131105: 0x9B73,
	162436 - 131105: 0xFA5B,
	162493 - 131105: 0x8FD2,
	162494 - 131105: 0x9064,
	162548 - 131105: 0x98B6,
	162566 - 131105: 0x9668,
	162571 - 131105: 0x9CD6,
	162584 - 131105: 0x98BD,
	162616 - 131105: 0x8FDC,
	162617 - 131105: 0xFEF6,
	162618 - 131105: 0x8FD9,
	162632 - 131105: 0x9541,
	162661 - 131105: 0x87CA,
	162799 - 131105: 0x876C,
	162804 - 131105: 0x97F3,
	162834 - 131105: 0x9BF8,
	162924 - 131105: 0x875A,
	162993 - 131105: 0x8748,
	163013 - 131105: 0x874A,
	163119 - 131105: 0x9E6C,
	163155 - 131105: 0x8FF2,
	163156 - 131105: 0x8FEE,
	163174 - 131105: 0x9CD7,
	163187 - 131105: 0x9E6E,
	163204 - 131105: 0x8A40,
	163215 - 131105: 0x8FEF,
	163224 - 131105: 0x8FF4,
	163261 - 131105: 0x8FF5,
	163292 - 131105: 0x95C2,
	163405 - 131105: 0x986A,
	163407 - 131105: 0x97CF,
	163630 - 131105: 0x9EE5,
	163833 - 131105: 0x9E7C,
	163842 - 131105: 0x9041,
	163849 - 131105: 0x9CDB,
	163870 - 131105: 0x9441,
	163875 - 131105: 0x9CE6,
	163876 - 131105: 0x9DB0,
	163912 - 131105: 0x9CEA,
	163971 - 131105: 0x9CED,
	163984 - 131105: 0x9CFA,
	164029 - 131105: 0x8B62,
	164030 - 131105: 0x8A4E,
	164072 - 131105: 0x9CCA,
	164073 - 131105: 0x8A66,
	164084 - 131105: 0x9CFB,
	164142 - 131105: 0x9CFC,
	164175 - 131105: 0x9CFE,
	164189 - 131105: 0x8A53,
	164207 - 131105: 0x9CE5,
	164233 - 131105: 0x9D40,
	164271 - 131105: 0x9D41,
	164284 - 131105: 0x9045,
	164359 - 131105: 0x8B73,
	164376 - 131105: 0x97CA,
	164378 - 131105: 0x9D42,
	164438 - 131105: 0x8A61,
	164476 - 131105: 0x8BAE,
	164507 - 131105: 0x8AD2,
	164557 - 131105: 0x8BA2,
	164578 - 131105: 0x9DF2,
	164614 - 131105: 0x9D43,
	164632 - 131105: 0x9CDF,
	164655 - 131105: 0x9D44,
	164666 - 131105: 0x8ECA,
	164709 - 131105: 0x904E,
	164717 - 131105: 0x8EB3,
	164733 - 131105: 0x9FF5,
	164746 - 131105: 0x9D45,
	164882 - 131105: 0x904F,
	164968 - 131105: 0x9D47,
	164972 - 131105: 0x89CA,
	164979 - 131105: 0x9CB5,
	164994 - 131105: 0xFBFE,
	165121 - 131105: 0x905E,
	165180 - 131105: 0x9063,
	165181 - 131105: 0x9057,
	165228 - 131105: 0x9066,
	165352 - 131105: 0x9BC0,
	165364 - 131105: 0xFCE5,
	165376 - 131105: 0x9162,
	165387 - 131105: 0x9067,
	165413 - 131105: 0x8FA1,
	165435 - 131105: 0x8FA2,
	165546 - 131105: 0x9D48,
	165547 - 131105: 0xFAD3,
	165554 - 131105: 0x8D4F,
	165564 - 131105: 0x905D,
	165592 - 131105: 0x90B9,
	165606 - 131105: 0x906B,
	165647 - 131105: 0x8C5C,
	165651 - 131105: 0x9069,
	165892 - 131105: 0xFE57,
	165931 - 131105: 0xFE55,
	166157 - 131105: 0x87A6,
	166195 - 131105: 0x9073,
	166216 - 131105: 0x9BEF,
	166217 - 131105: 0x9CF0,
	166230 - 131105: 0x9D4B,
	166244 - 131105: 0xFED9,
	166248 - 131105: 0xFEDA,
	166252 - 131105: 0x91E0,
	166253 - 131105: 0x8D43,
	166270 - 131105: 0x91D8,
	166281 - 131105: 0x9646,
	166312 - 131105: 0x9360,
	166314 - 131105: 0xFA53,
	166315 - 131105: 0x9CD3,
	166328 - 131105: 0x9D4E,
	166332 - 131105: 0xFB40,
	166336 - 131105: 0x8DE2,
	166364 - 131105: 0x9442,
	166366 - 131105: 0x9056,
	166369 - 131105: 0x9865,
	166371 - 131105: 0x8C6C,
	166372 - 131105: 0xFA4A,
	166375 - 131105: 0x9D50,
	166376 - 131105: 0x9D52,
	166393 - 131105: 0x95AF,
	166394 - 131105: 0x975A,
	166395 - 131105: 0x9349,
	166396 - 131105: 0x9747,
	166415 - 131105: 0xA0F4,
	166422 - 131105: 0x9778,
	166437 - 131105: 0x8FCF,
	166441 - 131105: 0xFC60,
	166450 - 131105: 0x8C4E,
	166454 - 131105: 0xFC56,
	166468 - 131105: 0x91DC,
	166469 - 131105: 0x9661,
	166470 - 131105: 0x92EC,
	166471 - 131105: 0x935D,
	166472 - 131105: 0x8EDE,
	166473 - 131105: 0x96FE,
	166474 - 131105: 0xFD4F,
	166475 - 131105: 0x95DE,
	166489 - 131105: 0x98B0,
	166490 - 131105: 0xA040,
	166529 - 131105: 0x97BD,
	166530 - 131105: 0x977D,
	166531 - 131105: 0x97F5,
	166554 - 131105: 0x9BAC,
	166555 - 131105: 0xFADA,
	166556 - 131105: 0x92C2,
	166592 - 131105: 0x97B1,
	166598 - 131105: 0x907B,
	166603 - 131105: 0x93FE,
	166604 - 131105: 0x947B,
	166606 - 131105: 0x9777,
	166622 - 131105: 0xFABE,
	166623 - 131105: 0xFD43,
	166624 - 131105: 0x90C6,
	166625 - 131105: 0x90A4,
	166626 - 131105: 0x90A8,
	166627 - 131105: 0x94A9,
	166629 - 131105: 0x90A9,
	166634 - 131105: 0x8C65,
	166652 - 131105: 0x95E0,
	166668 - 131105: 0x907D,
	166675 - 131105: 0x9265,
	166689 - 131105: 0xFDBA,
	166690 - 131105: 0x93C4,
	166699 - 131105: 0xFEED,
	166700 - 131105: 0x9DAB,
	166701 - 131105: 0xA0E3,
	166703 - 131105: 0x9648,
	166726 - 131105: 0x9D53,
	166732 - 131105: 0x8AA9,
	166734 - 131105: 0x9BC5,
	166736 - 131105: 0x965D,
	166755 - 131105: 0x975F,
	166756 - 131105: 0x965F,
	166757 - 131105: 0x966E,
	166758 - 131105: 0xFB5D,
	166764 - 131105: 0x9DB1,
	166799 - 131105: 0xFEA3,
	166809 - 131105: 0x9DB2,
	166812 - 131105: 0x95AE,
	166813 - 131105: 0xFCA3,
	166841 - 131105: 0x8769,
	166850 - 131105: 0xA0A2,
	166853 - 131105: 0x9655,
	166868 - 131105: 0x9D54,
	166871 - 131105: 0x9341,
	166873 - 131105: 0x95AD,
	166874 - 131105: 0x91D5,
	166887 - 131105: 0x977A,
	166888 - 131105: 0xFDFC,
	166889 - 131105: 0x8E47,
	166890 - 131105: 0x93FD,
	166891 - 131105: 0x90A5,
	166892 - 131105: 0x90AC,
	166901 - 131105: 0x95AC,
	166911 - 131105: 0x90AE,
	166915 - 131105: 0xFEA5,
	166921 - 131105: 0x9D56,
	166940 - 131105: 0x97E3,
	166941 - 131105: 0x95E2,
	166947 - 131105: 0x9466,
	166950 - 131105: 0x9647,
	166955 - 131105: 0x91B8,
	166960 - 131105: 0x9CEC,
	166969 - 131105: 0x90AD,
	166971 - 131105: 0x95E3,
	167114 - 131105: 0x8B4F,
	167117 - 131105: 0x8AE3,
	167122 - 131105: 0x8B4D,
	167220 - 131105: 0x95EA,
	167321 - 131105: 0x8B4E,
	167353 - 131105: 0x8CC1,
	167439 - 131105: 0x8BED,
	167478 - 131105: 0x91D9,
	167481 - 131105: 0xA0A4,
	167525 - 131105: 0x95F5,
	167526 - 131105: 0x95F4,
	167575 - 131105: 0x9FB3,
	167596 - 131105: 0xFEAF,
	167602 - 131105: 0xFE72,
	167603 - 131105: 0x927A,
	167641 - 131105: 0xFEAC,
	167655 - 131105: 0x95F3,
	167877 - 131105: 0x9D58,
	168057 - 131105: 0x8D46,
	168072 - 131105: 0x9372,
	168075 - 131105: 0x91C5,
	168083 - 131105: 0x9642,
	168111 - 131105: 0x90CD,
	168112 - 131105: 0x95FE,
	168113 - 131105: 0x9159,
	168128 - 131105: 0x9C65,
	168164 - 131105: 0x97CC,
	168165 - 131105: 0x90CE,
	168172 - 131105: 0x9D59,
	168173 - 131105: 0xFCF5,
	168205 - 131105: 0xFEFD,
	168208 - 131105: 0x9D5B,
	168252 - 131105: 0x9D5C,
	168269 - 131105: 0x937E,
	168283 - 131105: 0x98AC,
	168286 - 131105: 0x9D5E,
	168304 - 131105: 0xFDD0,
	168348 - 131105: 0xFD60,
	168360 - 131105: 0x9CCF,
	168405 - 131105: 0x90DD,
	168427 - 131105: 0x90E0,
	168989 - 131105: 0x90F3,
	168992 - 131105: 0x98B1,
	169011 - 131105: 0x90F0,
	169023 - 131105: 0x93BD,
	169032 - 131105: 0x95B7,
	169168 - 131105: 0x9F46,
	169177 - 131105: 0x8E4B,
	169178 - 131105: 0x9658,
	169189 - 131105: 0x8A4C,
	169191 - 131105: 0x9D63,
	169374 - 131105: 0x9ECF,
	169392 - 131105: 0x9D65,
	169400 - 131105: 0x9D66,
	169431 - 131105: 0x965A,
	169449 - 131105: 0x9D64,
	169460 - 131105: 0x8A6C,
	169760 - 131105: 0x8AD9,
	169778 - 131105: 0x9D67,
	169940 - 131105: 0x8A70,
	170000 - 131105: 0x8BF3,
	170071 - 131105: 0x9150,
	170148 - 131105: 0x9CC1,
	170193 - 131105: 0x9D68,
	170218 - 131105: 0x93A7,
	170225 - 131105: 0x9674,
	170234 - 131105: 0x8CFD,
	170243 - 131105: 0xA0EF,
	170245 - 131105: 0x9151,
	170287 - 131105: 0x96C1,
	170309 - 131105: 0x8777,
	170311 - 131105: 0x8C64,
	170312 - 131105: 0x9676,
	170313 - 131105: 0x9D69,
	170333 - 131105: 0xFCA4,
	170346 - 131105: 0x9D6A,
	170397 - 131105: 0x924E,
	170435 - 131105: 0x9D6B,
	170441 - 131105: 0x9BC1,
	170536 - 131105: 0x9D6C,
	170573 - 131105: 0x8A65,
	170757 - 131105: 0x915D,
	170766 - 131105: 0x9D6D,
	170965 - 131105: 0x915A,
	171123 - 131105: 0x8C42,
	171181 - 131105: 0x9CC0,
	171326 - 131105: 0x916A,
	171354 - 131105: 0x9D6E,
	171388 - 131105: 0x9EA6,
	171416 - 131105: 0x9DCD,
	171419 - 131105: 0x9D6F,
	171510 - 131105: 0x89BB,
	171526 - 131105: 0x9EF9,
	171565 - 131105: 0x96B4,
	171624 - 131105: 0x9172,
	171692 - 131105: 0x9EC8,
	171696 - 131105: 0x8771,
	171715 - 131105: 0x8B55,
	171768 - 131105: 0x9D71,
	171811 - 131105: 0x9D72,
	171824 - 131105: 0x9ECC,
	171959 - 131105: 0x9174,
	171998 - 131105: 0x9ED0,
	172052 - 131105: 0x905C,
	172167 - 131105: 0x8ED2,
	172217 - 131105: 0x91A8,
	172257 - 131105: 0x9177,
	172269 - 131105: 0x96BF,
	172275 - 131105: 0x96C0,
	172280 - 131105: 0x8FB1,
	172286 - 131105: 0x96B7,
	172295 - 131105: 0x8C55,
	172323 - 131105: 0x9178,
	172339 - 131105: 0x89BE,
	172340 - 131105: 0x917C,
	172368 - 131105: 0xFB77,
	172434 - 131105: 0x9175,
	172435 - 131105: 0x91A3,
	172459 - 131105: 0x9176,
	172468 - 131105: 0x96BE,
	172469 - 131105: 0x8D49,
	172511 - 131105: 0x9179,
	172533 - 131105: 0x96B6,
	172576 - 131105: 0x91A4,
	172595 - 131105: 0x91A6,
	172691 - 131105: 0x9D75,
	172703 - 131105: 0x9052,
	172722 - 131105: 0xA045,
	172724 - 131105: 0x91A9,
	172726 - 131105: 0x98AA,
	172730 - 131105: 0x8C5F,
	172733 - 131105: 0x8BAA,
	172767 - 131105: 0x9CDD,
	172799 - 131105: 0x9D77,
	172881 - 131105: 0x8756,
	172969 - 131105: 0x8940,
	173108 - 131105: 0x9EEC,
	173147 - 131105: 0x93AA,
	173510 - 131105: 0x9478,
	173515 - 131105: 0x9D7A,
	173569 - 131105: 0x8AC9,
	173618 - 131105: 0x8B4B,
	173642 - 131105: 0x9FEC,
	173659 - 131105: 0x8AE2,
	173737 - 131105: 0x9E75,
}

const encode1Low, encode1High = 11904, 40908

var encode1 = [...]uint16{
	11904 - 11904: 0xC8D6,
	11908 - 11904: 0xC8D7,
	11910 - 11904: 0xC8D8,
	11911 - 11904: 0xC8D9,
	11912 - 11904: 0xC8DA,
	11914 - 11904: 0xC8DB,
	11916 - 11904: 0xC8DC,
	11917 - 11904: 0xC8DD,
	11925 - 11904: 0xC8DE,
	11932 - 11904: 0xC8DF,
	11933 - 11904: 0xC8E0,
	11941 - 11904: 0xC8E1,
	11943 - 11904: 0xC8E2,
	11946 - 11904: 0xC8E3,
	11948 - 11904: 0xC8E4,
	11950 - 11904: 0xC8E5,
	11958 - 11904: 0xC8E6,
	11964 - 11904: 0xC8E7,
	11966 - 11904: 0xC8E8,
	11974 - 11904: 0xC8E9,
	11978 - 11904: 0xC8EA,
	11980 - 11904: 0xC8EB,
	11981 - 11904: 0xC8EC,
	11983 - 11904: 0xC8ED,
	11990 - 11904: 0xC8EE,
	11991 - 11904: 0xC8EF,
	11998 - 11904: 0xC8F0,
	12003 - 11904: 0xC8F1,
	12083 - 11904: 0xC6CD,
	12288 - 11904: 0xA140,
	12289 - 11904: 0xA142,
	12290 - 11904: 0xA143,
	12291 - 11904: 0xC6DE,
	12293 - 11904: 0xC6E0,
	12294 - 11904: 0xC6E1,
	12295 - 11904: 0xC6E2,
	12296 - 11904: 0xA171,
	12297 - 11904: 0xA172,
	12298 - 11904: 0xA16D,
	12299 - 11904: 0xA16E,
	12300 - 11904: 0xA175,
	12301 - 11904: 0xA176,
	12302 - 11904: 0xA179,
	12303 - 11904: 0xA17A,
	12304 - 11904: 0xA169,
	12305 - 11904: 0xA16A,
	12306 - 11904: 0xA245,
	12308 - 11904: 0xA165,
	12309 - 11904: 0xA166,
	12317 - 11904: 0xA1A9,
	12318 - 11904: 0xA1AA,
	12321 - 11904: 0xA2C3,
	12322 - 11904: 0xA2C4,
	12323 - 11904: 0xA2C5,
	12324 - 11904: 0xA2C6,
	12325 - 11904: 0xA2C7,
	12326 - 11904: 0xA2C8,
	12327 - 11904: 0xA2C9,
	12328 - 11904: 0xA2CA,
	12329 - 11904: 0xA2CB,
	12353 - 11904: 0xC6E7,
	12354 - 11904: 0xC6E8,
	12355 - 11904: 0xC6E9,
	12356 - 11904: 0xC6EA,
	12357 - 11904: 0xC6EB,
	12358 - 11904: 0xC6EC,
	12359 - 11904: 0xC6ED,
	12360 - 11904: 0xC6EE,
	12361 - 11904: 0xC6EF,
	12362 - 11904: 0xC6F0,
	12363 - 11904: 0xC6F1,
	12364 - 11904: 0xC6F2,
	12365 - 11904: 0xC6F3,
	12366 - 11904: 0xC6F4,
	12367 - 11904: 0xC6F5,
	12368 - 11904: 0xC6F6,
	12369 - 11904: 0xC6F7,
	12370 - 11904: 0xC6F8,
	12371 - 11904: 0xC6F9,
	12372 - 11904: 0xC6FA,
	12373 - 11904: 0xC6FB,
	12374 - 11904: 0xC6FC,
	12375 - 11904: 0xC6FD,
	12376 - 11904: 0xC6FE,
	12377 - 11904: 0xC740,
	12378 - 11904: 0xC741,
	12379 - 11904: 0xC742,
	12380 - 11904: 0xC743,
	12381 - 11904: 0xC744,
	12382 - 11904: 0xC745,
	12383 - 11904: 0xC746,
	12384 - 11904: 0xC747,
	12385 - 11904: 0xC748,
	12386 - 11904: 0xC749,
	12387 - 11904: 0xC74A,
	12388 - 11904: 0xC74B,
	12389 - 11904: 0xC74C,
	12390 - 11904: 0xC74D,
	12391 - 11904: 0xC74E,
	12392 - 11904: 0xC74F,
	12393 - 11904: 0xC750,
	12394 - 11904: 0xC751,
	12395 - 11904: 0xC752,
	12396 - 11904: 0xC753,
	12397 - 11904: 0xC754,
	12398 - 11904: 0xC755,
	12399 - 11904: 0xC756,
	12400 - 11904: 0xC757,
	12401 - 11904: 0xC758,
	12402 - 11904: 0xC759,
	12403 - 11904: 0xC75A,
	12404 - 11904: 0xC75B,
	12405 - 11904: 0xC75C,
	12406 - 11904: 0xC75D,
	12407 - 11904: 0xC75E,
	12408 - 11904: 0xC75F,
	12409 - 11904: 0xC760,
	12410 - 11904: 0xC761,
	12411 - 11904: 0xC762,
	12412 - 11904: 0xC763,
	12413 - 11904: 0xC764,
	12414 - 11904: 0xC765,
	12415 - 11904: 0xC766,
	12416 - 11904: 0xC767,
	12417 - 11904: 0xC768,
	12418 - 11904: 0xC769,
	12419 - 11904: 0xC76A,
	12420 - 11904: 0xC76B,
	12421 - 11904: 0xC76C,
	12422 - 11904: 0xC76D,
	12423 - 11904: 0xC76E,
	12424 - 11904: 0xC76F,
	12425 - 11904: 0xC770,
	12426 - 11904: 0xC771,
	12427 - 11904: 0xC772,
	12428 - 11904: 0xC773,
	12429 - 11904: 0xC774,
	12430 - 11904: 0xC775,
	12431 - 11904: 0xC776,
	12432 - 11904: 0xC777,
	12433 - 11904: 0xC778,
	12434 - 11904: 0xC779,
	12435 - 11904: 0xC77A,
	12443 - 11904: 0xC8D4,
	12444 - 11904: 0xC8D5,
	12445 - 11904: 0xC6DC,
	12446 - 11904: 0xC6DD,
	12449 - 11904: 0xC77B,
	12450 - 11904: 0xC77C,
	12451 - 11904: 0xC77D,
	12452 - 11904: 0xC77E,
	12453 - 11904: 0xC7A1,
	12454 - 11904: 0xC7A2,
	12455 - 11904: 0xC7A3,
	12456 - 11904: 0xC7A4,
	12457 - 11904: 0xC7A5,
	12458 - 11904: 0xC7A6,
	12459 - 11904: 0xC7A7,
	12460 - 11904: 0xC7A8,
	12461 - 11904: 0xC7A9,
	12462 - 11904: 0xC7AA,
	12463 - 11904: 0xC7AB,
	12464 - 11904: 0xC7AC,
	12465 - 11904: 0xC7AD,
	12466 - 11904: 0xC7AE,
	12467 - 11904: 0xC7AF,
	12468 - 11904: 0xC7B0,
	12469 - 11904: 0xC7B1,
	12470 - 11904: 0xC7B2,
	12471 - 11904: 0xC7B3,
	12472 - 11904: 0xC7B4,
	12473 - 11904: 0xC7B5,
	12474 - 11904: 0xC7B6,
	12475 - 11904: 0xC7B7,
	12476 - 11904: 0xC7B8,
	12477 - 11904: 0xC7B9,
	12478 - 11904: 0xC7BA,
	12479 - 11904: 0xC7BB,
	12480 - 11904: 0xC7BC,
	12481 - 11904: 0xC7BD,
	12482 - 11904: 0xC7BE,
	12483 - 11904: 0xC7BF,
	12484 - 11904: 0xC7C0,
	12485 - 11904: 0xC7C1,
	12486 - 11904: 0xC7C2,
	12487 - 11904: 0xC7C3,
	12488 - 11904: 0xC7C4,
	12489 - 11904: 0xC7C5,
	12490 - 11904: 0xC7C6,
	12491 - 11904: 0xC7C7,
	12492 - 11904: 0xC7C8,
	12493 - 11904: 0xC7C9,
	12494 - 11904: 0xC7CA,
	12495 - 11904: 0xC7CB,
	12496 - 11904: 0xC7CC,
	12497 - 11904: 0xC7CD,
	12498 - 11904: 0xC7CE,
	12499 - 11904: 0xC7CF,
	12500 - 11904: 0xC7D0,
	12501 - 11904: 0xC7D1,
	12502 - 11904: 0xC7D2,
	12503 - 11904: 0xC7D3,
	12504 - 11904: 0xC7D4,
	12505 - 11904: 0xC7D5,
	12506 - 11904: 0xC7D6,
	12507 - 11904: 0xC7D7,
	12508 - 11904: 0xC7D8,
	12509 - 11904: 0xC7D9,
	12510 - 11904: 0xC7DA,
	12511 - 11904: 0xC7DB,
	12512 - 11904: 0xC7DC,
	12513 - 11904: 0xC7DD,
	12514 - 11904: 0xC7DE,
	12515 - 11904: 0xC7DF,
	12516 - 11904: 0xC7E0,
	12517 - 11904: 0xC7E1,
	12518 - 11904: 0xC7E2,
	12519 - 11904: 0xC7E3,
	12520 - 11904: 0xC7E4,
	12521 - 11904: 0xC7E5,
	12522 - 11904: 0xC7E6,
	12523 - 11904: 0xC7E7,
	12524 - 11904: 0xC7E8,
	12525 - 11904: 0xC7E9,
	12526 - 11904: 0xC7EA,
	12527 - 11904: 0xC7EB,
	12528 - 11904: 0xC7EC,
	12529 - 11904: 0xC7ED,
	12530 - 11904: 0xC7EE,
	12531 - 11904: 0xC7EF,
	12532 - 11904: 0xC7F0,
	12533 - 11904: 0xC7F1,
	12534 - 11904: 0xC7F2,
	12540 - 11904: 0xC6E3,
	12541 - 11904: 0xC6DA,
	12542 - 11904: 0xC6DB,
	12549 - 11904: 0xA374,
	12550 - 11904: 0xA375,
	12551 - 11904: 0xA376,
	12552 - 11904: 0xA377,
	12553 - 11904: 0xA378,
	12554 - 11904: 0xA379,
	12555 - 11904: 0xA37A,
	12556 - 11904: 0xA37B,
	12557 - 11904: 0xA37C,
	12558 - 11904: 0xA37D,
	12559 - 11904: 0xA37E,
	12560 - 11904: 0xA3A1,
	12561 - 11904: 0xA3A2,
	12562 - 11904: 0xA3A3,
	12563 - 11904: 0xA3A4,
	12564 - 11904: 0xA3A5,
	12565 - 11904: 0xA3A6,
	12566 - 11904: 0xA3A7,
	12567 - 11904: 0xA3A8,
	12568 - 11904: 0xA3A9,
	12569 - 11904: 0xA3AA,
	12570 - 11904: 0xA3AB,
	12571 - 11904: 0xA3AC,
	12572 - 11904: 0xA3AD,
	12573 - 11904: 0xA3AE,
	12574 - 11904: 0xA3AF,
	12575 - 11904: 0xA3B0,
	12576 - 11904: 0xA3B1,
	12577 - 11904: 0xA3B2,
	12578 - 11904: 0xA3B3,
	12579 - 11904: 0xA3B4,
	12580 - 11904: 0xA3B5,
	12581 - 11904: 0xA3B6,
	12582 - 11904: 0xA3B7,
	12583 - 11904: 0xA3B8,
	12584 - 11904: 0xA3B9,
	12585 - 11904: 0xA3BA,
	12736 - 11904: 0x8840,
	12737 - 11904: 0x8841,
	12738 - 11904: 0x8842,
	12739 - 11904: 0x8843,
	12740 - 11904: 0x8844,
	12741 - 11904: 0x8846,
	12742 - 11904: 0x8849,
	12743 - 11904: 0x884A,
	12744 - 11904: 0x884D,
	12745 - 11904: 0x884F,
	12746 - 11904: 0x8850,
	12747 - 11904: 0x8851,
	12748 - 11904: 0x8852,
	12749 - 11904: 0x8854,
	12750 - 11904: 0x8855,
	12751 - 11904: 0xC879,
	12849 - 11904: 0xC8D1,
	12963 - 11904: 0xA1C0,
	13198 - 11904: 0xA255,
	13199 - 11904: 0xA256,
	13212 - 11904: 0xA250,
	13213 - 11904: 0xA251,
	13214 - 11904: 0xA252,
	13217 - 11904: 0xA254,
	13252 - 11904: 0xA257,
	13262 - 11904: 0xA253,
	13265 - 11904: 0xA1EB,
	13266 - 11904: 0xA1EA,
	13269 - 11904: 0xA24F,
	13365 - 11904: 0x9277,
	13376 - 11904: 0x96DF,
	13386 - 11904: 0x8CF4,
	13388 - 11904: 0x89D5,
	13412 - 11904: 0x93CD,
	13427 - 11904: 0x9BDF,
	13434 - 11904: 0xFA68,
	13437 - 11904: 0x89DA,
	13438 - 11904: 0x8F59,
	13459 - 11904: 0x89DB,
	13462 - 11904: 0x8F5D,
	13477 - 11904: 0x89DC,
	13487 - 11904: 0x96F7,
	13500 - 11904: 0x8ADA,
	13505 - 11904: 0x8BDC,
	13512 - 11904: 0x97DB,
	13535 - 11904: 0x9E53,
	13540 - 11904: 0x9DAA,
	13542 - 11904: 0x87BE,
	13563 - 11904: 0x9BEA,
	13574 - 11904: 0x8A6E,
	13630 - 11904: 0x8BC8,
	13649 - 11904: 0x89E8,
	13651 - 11904: 0x89EA,
	13657 - 11904: 0x8C4B,
	13665 - 11904: 0xFB70,
	13677 - 11904: 0x89ED,
	13680 - 11904: 0x94DD,
	13682 - 11904: 0x89EE,
	13687 - 11904: 0x9EB4,
	13688 - 11904: 0x8AD3,
	13700 - 11904: 0x92DB,
	13719 - 11904: 0x94DB,
	13720 - 11904: 0x89F9,
	13729 - 11904: 0xFB7A,
	13733 - 11904: 0x89FB,
	13741 - 11904: 0x9EFC,
	13759 - 11904: 0x89FC,
	13761 - 11904: 0x89BF,
	13765 - 11904: 0x89FE,
	13767 - 11904: 0x89E6,
	13770 - 11904: 0x9D46,
	13774 - 11904: 0x9DEE,
	13778 - 11904: 0xA07E,
	13782 - 11904: 0xA068,
	13787 - 11904: 0x98E9,
	13789 - 11904: 0x8B68,
	13809 - 11904: 0x8DFD,
	13810 - 11904: 0x8BBE,
	13811 - 11904: 0x9FD9,
	13819 - 11904: 0x8AEB,
	13822 - 11904: 0x9FD7,
	13833 - 11904: 0x8B6A,
	13848 - 11904: 0x9C5C,
	13850 - 11904: 0x8BB1,
	13859 - 11904: 0xFB5E,
	13861 - 11904: 0x8770,
	13869 - 11904: 0x9DF3,
	13877 - 11904: 0xA0D0,
	13881 - 11904: 0xFC66,
	13886 - 11904: 0x92E9,
	13895 - 11904: 0x9AEC,
	13896 - 11904: 0x8FAB,
	13897 - 11904: 0xFA48,
	13902 - 11904: 0x8E45,
	13919 - 11904: 0x9C6F,
	13921 - 11904: 0x8D5C,
	13946 - 11904: 0x9EDE,
	13953 - 11904: 0x89EF,
	13978 - 11904: 0x96E9,
	13989 - 11904: 0x9EBB,
	13994 - 11904: 0x94DE,
	13996 - 11904: 0x9EB8,
	14000 - 11904: 0x97BA,
	14001 - 11904: 0xFB65,
	14005 - 11904: 0x95D6,
	14009 - 11904: 0x9CBB,
	14012 - 11904: 0x97DA,
	14017 - 11904: 0x8F45,
	14019 - 11904: 0xFB7D,
	14020 - 11904: 0x9158,
	14021 - 11904: 0xFE64,
	14023 - 11904: 0x9856,
	14024 - 11904: 0x9B4D,
	14035 - 11904: 0x935B,
	14036 - 11904: 0x95C7,
	14038 - 11904: 0x97E7,
	14045 - 11904: 0x9359,
	14049 - 11904: 0x91F5,
	14050 - 11904: 0x97B8,
	14053 - 11904: 0xFDA2,
	14054 - 11904: 0xFBB6,
	14069 - 11904: 0x92FA,
	14081 - 11904: 0x9357,
	14083 - 11904: 0x8BA6,
	14088 - 11904: 0xFBB9,
	14090 - 11904: 0x97B0,
	14093 - 11904: 0xFDC4,
	14108 - 11904: 0x9CA1,
	14114 - 11904: 0x91F2,
	14115 - 11904: 0x91F9,
	14117 - 11904: 0x8FF1,
	14124 - 11904: 0x9745,
	14125 - 11904: 0x9853,
	14128 - 11904: 0xFE78,
	14130 - 11904: 0xFBC1,
	14131 - 11904: 0x9251,
	14138 - 11904: 0x9DAD,
	14144 - 11904: 0xFD6C,
	14147 - 11904: 0xFA6B,
	14178 - 11904: 0x9BC2,
	14191 - 11904: 0x9A7B,
	14231 - 11904: 0x8B60,
	14240 - 11904: 0x934B,
	14265 - 11904: 0x9ABD,
	14270 - 11904: 0x91B7,
	14294 - 11904: 0x8D4B,
	14322 - 11904: 0x95B4,
	14328 - 11904: 0xFEC5,
	14331 - 11904: 0x9EF0,
	14351 - 11904: 0x8D64,
	14361 - 11904: 0x9269,
	14368 - 11904: 0x8D67,
	14381 - 11904: 0xFBEA,
	14390 - 11904: 0xFBEF,
	14392 - 11904: 0x8D68,
	14435 - 11904: 0x93EB,
	14453 - 11904: 0x877A,
	14496 - 11904: 0xFC42,
	14531 - 11904: 0x9166,
	14540 - 11904: 0xFACD,
	14545 - 11904: 0x93DD,
	14548 - 11904: 0x8D52,
	14586 - 11904: 0x8BCC,
	14600 - 11904: 0x8D6D,
	14612 - 11904: 0x8D6E,
	14631 - 11904: 0x96A8,
	14642 - 11904: 0xFCA6,
	14655 - 11904: 0x8D6F,
	14669 - 11904: 0x8D70,
	14691 - 11904: 0xFC64,
	14712 - 11904: 0x8CF3,
	14720 - 11904: 0x9060,
	14729 - 11904: 0x8D74,
	14730 - 11904: 0x97C3,
	14738 - 11904: 0x8AD0,
	14745 - 11904: 0x9274,
	14747 - 11904: 0x9BBE,
	14753 - 11904: 0x9CC8,
	14756 - 11904: 0x9CBA,
	14776 - 11904: 0x8D78,
	14812 - 11904: 0x9EB9,
	14818 - 11904: 0x955A,
	14821 - 11904: 0x91B4,
	14828 - 11904: 0x8A48,
	14840 - 11904: 0x8D7D,
	14843 - 11904: 0x8A7D,
	14846 - 11904: 0x8AC2,
	14849 - 11904: 0xFD4A,
	14851 - 11904: 0x8DA1,
	14854 - 11904: 0x8AD1,
	14871 - 11904: 0xFCB4,
	14872 - 11904: 0x8B47,
	14889 - 11904: 0x93A4,
	14890 - 11904: 0x9EDA,
	14900 - 11904: 0x8A51,
	14923 - 11904: 0x8DA6,
	14930 - 11904: 0x9EC5,
	14935 - 11904: 0xFCC4,
	14940 - 11904: 0xA078,
	14942 - 11904: 0x94B5,
	14950 - 11904: 0xFCC2,
	14951 - 11904: 0x8A6B,
	14999 - 11904: 0x8DAB,
	15019 - 11904: 0xFAE8,
	15037 - 11904: 0x8DAD,
	15070 - 11904: 0xFC49,
	15072 - 11904: 0x93C1,
	15088 - 11904: 0x906F,
	15090 - 11904: 0x8DB0,
	15093 - 11904: 0x87A2,
	15099 - 11904: 0x947E,
	15118 - 11904: 0x90FA,
	15129 - 11904: 0x9479,
	15138 - 11904: 0x8DB2,
	15147 - 11904: 0xFCEE,
	15161 - 11904: 0x997B,
	15170 - 11904: 0x8DB4,
	15192 - 11904: 0x8DB7,
	15200 - 11904: 0x91B3,
	15217 - 11904: 0x8DBB,
	15218 - 11904: 0x8DBA,
	15227 - 11904: 0x8DBC,
	15228 - 11904: 0x9044,
	15232 - 11904: 0xFD4C,
	15253 - 11904: 0x874B,
	15254 - 11904: 0x93E4,
	15257 - 11904: 0x93E0,
	15265 - 11904: 0xFD53,
	15292 - 11904: 0x8DC3,
	15294 - 11904: 0x9BB8,
	15298 - 11904: 0xFBF0,
	15300 - 11904: 0x93E9,
	15319 - 11904: 0x93F6,
	15325 - 11904: 0x8DC5,
	15340 - 11904: 0x8DCA,
	15346 - 11904: 0x8DCC,
	15347 - 11904: 0xFD5D,
	15348 - 11904: 0x93B5,
	15373 - 11904: 0xFD61,
	15377 - 11904: 0x9CF8,
	15381 - 11904: 0x9252,
	15384 - 11904: 0xA0E8,
	15444 - 11904: 0x9CA5,
	15499 - 11904: 0x8C56,
	15563 - 11904: 0x8DD6,
	15565 - 11904: 0x97C0,
	15569 - 11904: 0xA0DE,
	15574 - 11904: 0x97D2,
	15580 - 11904: 0xFAA5,
	15595 - 11904: 0xFDA3,
	15599 - 11904: 0x8DDB,
	15634 - 11904: 0x8CEA,
	15635 - 11904: 0x8EAF,
	15645 - 11904: 0x91B5,
	15666 - 11904: 0xFD49,
	15675 - 11904: 0xFDD1,
	15686 - 11904: 0x8DEB,
	15692 - 11904: 0x97C6,
	15694 - 11904: 0xFDCE,
	15697 - 11904: 0x90FC,
	15711 - 11904: 0xFC59,
	15714 - 11904: 0x96D6,
	15721 - 11904: 0x97C5,
	15722 - 11904: 0x8DEF,
	15727 - 11904: 0x97D7,
	15733 - 11904: 0x8DF0,
	15741 - 11904: 0x96A6,
	15749 - 11904: 0xFBBF,
	15752 - 11904: 0x8CDF,
	15754 - 11904: 0x8DF3,
	15759 - 11904: 0x9449,
	15761 - 11904: 0x8DF5,
	15781 - 11904: 0x9872,
	15789 - 11904: 0x8E6B,
	15796 - 11904: 0xFAFD,
	15807 - 11904: 0x8F50,
	15814 - 11904: 0x9DCC,
	15815 - 11904: 0xFC65,
	15817 - 11904: 0x8C44,
	15820 - 11904: 0x996E,
	15821 - 11904: 0x94A1,
	15827 - 11904: 0x8F63,
	15835 - 11904: 0xA0DA,
	15847 - 11904: 0x9253,
	15848 - 11904: 0xFDE9,
	15851 - 11904: 0x9DB5,
	15859 - 11904: 0x9879,
	15860 - 11904: 0x876A,
	15863 - 11904: 0x9D5D,
	15868 - 11904: 0x8D63,
	15869 - 11904: 0x9669,
	15878 - 11904: 0x9F70,
	15936 - 11904: 0xFC6A,
	15939 - 11904: 0x8AC7,
	15944 - 11904: 0x89D7,
	15957 - 11904: 0xFE4D,
	15988 - 11904: 0x9EDD,
	16040 - 11904: 0xFEFB,
	16041 - 11904: 0x98BC,
	16042 - 11904: 0xFACC,
	16045 - 11904: 0x95B0,
	16049 - 11904: 0x9464,
	16056 - 11904: 0x936F,
	16063 - 11904: 0x94B9,
	16066 - 11904: 0x95EC,
	16071 - 11904: 0x91EE,
	16074 - 11904: 0x98C3,
	16076 - 11904: 0x95F6,
	16080 - 11904: 0x8FFD,
	16081 - 11904: 0x98C5,
	16086 - 11904: 0x9766,
	16087 - 11904: 0xFE6E,
	16090 - 11904: 0x97DD,
	16091 - 11904: 0x8CAA,
	16094 - 11904: 0x92D2,
	16097 - 11904: 0x9761,
	16098 - 11904: 0x98CB,
	16103 - 11904: 0x95F0,
	16105 - 11904: 0x975D,
	16107 - 11904: 0x91E3,
	16108 - 11904: 0x877E,
	16112 - 11904: 0x98CC,
	16115 - 11904: 0x9469,
	16116 - 11904: 0x98CD,
	16122 - 11904: 0x98CE,
	16124 - 11904: 0x95FC,
	16127 - 11904: 0x94A3,
	16128 - 11904: 0x9662,
	16132 - 11904: 0xFEB6,
	16134 - 11904: 0x9463,
	16135 - 11904: 0x8D47,
	16142 - 11904: 0x98D0,
	16211 - 11904: 0x98D1,
	16216 - 11904: 0x9475,
	16217 - 11904: 0xFAE0,
	16227 - 11904: 0x9472,
	16252 - 11904: 0x98D6,
	16275 - 11904: 0x8AF0,
	16320 - 11904: 0x98D9,
	16328 - 11904: 0x8D5A,
	16343 - 11904: 0x98DB,
	16348 - 11904: 0x98DD,
	16357 - 11904: 0x98A8,
	16365 - 11904: 0x8A6D,
	16377 - 11904: 0x8AFB,
	16378 - 11904: 0x8AAE,
	16388 - 11904: 0xFBC9,
	16393 - 11904: 0x8C5D,
	16413 - 11904: 0x98E4,
	16441 - 11904: 0x98E6,
	16453 - 11904: 0x98E8,
	16467 - 11904: 0x8A4D,
	16471 - 11904: 0x9257,
	16482 - 11904: 0x95DF,
	16485 - 11904: 0xA0AC,
	16490 - 11904: 0x98EB,
	16495 - 11904: 0x98EC,
	16497 - 11904: 0x8CC3,
	16552 - 11904: 0x98F4,
	16564 - 11904: 0x87D9,
	16571 - 11904: 0x8AB8,
	16575 - 11904: 0x9EE7,
	16584 - 11904: 0x94BC,
	16600 - 11904: 0xFCD1,
	16607 - 11904: 0x9CC6,
	16632 - 11904: 0x8D4A,
	16634 - 11904: 0x9E7E,
	16642 - 11904: 0x8D44,
	16643 - 11904: 0x98FE,
	16644 - 11904: 0xFDE8,
	16649 - 11904: 0x9940,
	16654 - 11904: 0x94C9,
	16689 - 11904: 0x87C6,
	16690 - 11904: 0x94D3,
	16743 - 11904: 0x9946,
	16748 - 11904: 0x90C0,
	16750 - 11904: 0x94D1,
	16764 - 11904: 0x8D4E,
	16767 - 11904: 0x9573,
	16769 - 11904: 0x87CE,
	16784 - 11904: 0x93C2,
	16818 - 11904: 0x9948,
	16836 - 11904: 0x994B,
	16842 - 11904: 0x8E55,
	16847 - 11904: 0x994E,
	16859 - 11904: 0x8EFE,
	16877 - 11904: 0x8D5F,
	16879 - 11904: 0x8E59,
	16889 - 11904: 0x94EC,
	16913 - 11904: 0x94EF,
	16931 - 11904: 0x8C60,
	16960 - 11904: 0x8F74,
	16992 - 11904: 0x9955,
	17002 - 11904: 0x9544,
	17014 - 11904: 0x8CCB,
	17018 - 11904: 0x9956,
	17036 - 11904: 0x9959,
	17044 - 11904: 0x995B,
	17058 - 11904: 0x8CC4,
	17077 - 11904: 0xFA45,
	17081 - 11904: 0x90B7,
	17084 - 11904: 0x9743,
	17140 - 11904: 0x95CD,
	17147 - 11904: 0x97C9,
	17148 - 11904: 0xFD50,
	17162 - 11904: 0x87AA,
	17195 - 11904: 0x8EB9,
	17262 - 11904: 0x95C6,
	17303 - 11904: 0x9967,
	17306 - 11904: 0x8CE3,
	17338 - 11904: 0x8AB9,
	17345 - 11904: 0x8DFC,
	17369 - 11904: 0x8A76,
	17375 - 11904: 0x9D51,
	17389 - 11904: 0x9973,
	17392 - 11904: 0x8740,
	17394 - 11904: 0x9D4F,
	17409 - 11904: 0x997A,
	17410 - 11904: 0x9564,
	17427 - 11904: 0x99A1,
	17445 - 11904: 0x99A5,
	17453 - 11904: 0x99A7,
	17530 - 11904: 0x8EED,
	17551 - 11904: 0x99AD,
	17553 - 11904: 0xC87E,
	17567 - 11904: 0x946E,
	17568 - 11904: 0x8F70,
	17570 - 11904: 0xFAD0,
	17584 - 11904: 0x99B3,
	17591 - 11904: 0xA053,
	17597 - 11904: 0x8D5E,
	17600 - 11904: 0x965C,
	17603 - 11904: 0x8CE0,
	17605 - 11904: 0xFD7A,
	17614 - 11904: 0x97FE,
	17629 - 11904: 0x92BD,
	17630 - 11904: 0x8D5D,
	17631 - 11904: 0x97FD,
	17633 - 11904: 0x87DB,
	17636 - 11904: 0x8F64,
	17641 - 11904: 0xFCF7,
	17642 - 11904: 0x9562,
	17643 - 11904: 0x97CD,
	17644 - 11904: 0x9E64,
	17652 - 11904: 0x924C,
	17667 - 11904: 0x8EC9,
	17668 - 11904: 0x99BC,
	17673 - 11904: 0x9DA5,
	17675 - 11904: 0x8F54,
	17686 - 11904: 0x8F7C,
	17691 - 11904: 0x8D55,
	17693 - 11904: 0x8EA2,
	17703 - 11904: 0x8F7A,
	17710 - 11904: 0x97AE,
	17715 - 11904: 0x96C8,
	17718 - 11904: 0x8CE4,
	17723 - 11904: 0x99C3,
	17725 - 11904: 0x90D6,
	17727 - 11904: 0x9CBE,
	17731 - 11904: 0x8F76,
	17745 - 11904: 0x9470,
	17746 - 11904: 0xFB4B,
	17749 - 11904: 0xFDCA,
	17752 - 11904: 0x8CEF,
	17756 - 11904: 0x8EC7,
	17761 - 11904: 0x8D54,
	17762 - 11904: 0xA0F9,
	17770 - 11904: 0x8FA9,
	17773 - 11904: 0x8D51,
	17783 - 11904: 0x99C7,
	17784 - 11904: 0x8744,
	17797 - 11904: 0x90D7,
	17830 - 11904: 0x8743,
	17843 - 11904: 0x8747,
	17882 - 11904: 0x8758,
	17897 - 11904: 0x9EDF,
	17898 - 11904: 0x8D59,
	17923 - 11904: 0x8742,
	17926 - 11904: 0x99CE,
	17935 - 11904: 0x8FBA,
	17941 - 11904: 0x8FEB,
	17943 - 11904: 0x99CF,
	18011 - 11904: 0x8FC2,
	18042 - 11904: 0x92C9,
	18048 - 11904: 0x97DC,
	18081 - 11904: 0x875D,
	18094 - 11904: 0x87CC,
	18107 - 11904: 0x8D45,
	18127 - 11904: 0x95B3,
	18128 - 11904: 0x9C79,
	18165 - 11904: 0x95B2,
	18167 - 11904: 0x8D4C,
	18195 - 11904: 0x8FDB,
	18200 - 11904: 0x9BE3,
	18230 - 11904: 0x874C,
	18244 - 11904: 0x874D,
	18254 - 11904: 0x9E7A,
	18255 - 11904: 0x8757,
	18300 - 11904: 0x9BEE,
	18328 - 11904: 0x99DE,
	18342 - 11904: 0xFAFA,
	18389 - 11904: 0x8A52,
	18413 - 11904: 0x99E1,
	18420 - 11904: 0x8A67,
	18432 - 11904: 0x8BB5,
	18443 - 11904: 0x8AAC,
	18487 - 11904: 0x99E9,
	18525 - 11904: 0xFBCA,
	18545 - 11904: 0x97DE,
	18587 - 11904: 0x95D1,
	18605 - 11904: 0x99F5,
	18606 - 11904: 0xFC4A,
	18640 - 11904: 0x9BA9,
	18653 - 11904: 0xFBDC,
	18669 - 11904: 0xFE56,
	18675 - 11904: 0x9EA4,
	18682 - 11904: 0x9D49,
	18694 - 11904: 0x95DB,
	18705 - 11904: 0x89C5,
	18718 - 11904: 0x99F8,
	18725 - 11904: 0x9664,
	18730 - 11904: 0x9055,
	18733 - 11904: 0x96D4,
	18735 - 11904: 0x87C4,
	18736 - 11904: 0x87AE,
	18741 - 11904: 0x977C,
	18748 - 11904: 0x964D,
	18750 - 11904: 0x97E1,
	18757 - 11904: 0x9A48,
	18769 - 11904: 0x9A49,
	18771 - 11904: 0xFE7D,
	18789 - 11904: 0x90AA,
	18794 - 11904: 0x9A50,
	18802 - 11904: 0x9347,
	18825 - 11904: 0x8ED8,
	18849 - 11904: 0x90C9,
	18855 - 11904: 0x9A55,
	18911 - 11904: 0x90BC,
	18917 - 11904: 0x9A58,
	18919 - 11904: 0x8BB8,
	18959 - 11904: 0x90D5,
	18973 - 11904: 0x9641,
	18980 - 11904: 0x9A5A,
	18997 - 11904: 0x9A5C,
	19094 - 11904: 0x97C2,
	19108 - 11904: 0x875C,
	19124 - 11904: 0x8ABB,
	19128 - 11904: 0x9BAA,
	19153 - 11904: 0x90F5,
	19172 - 11904: 0x9A60,
	19199 - 11904: 0x9145,
	19216 - 11904: 0x8C58,
	19225 - 11904: 0x9A63,
	19232 - 11904: 0x8C49,
	19244 - 11904: 0x8BB6,
	19255 - 11904: 0xFCCF,
	19311 - 11904: 0x966B,
	19312 - 11904: 0x9A6E,
	19314 - 11904: 0x914F,
	19323 - 11904: 0x9746,
	19326 - 11904: 0xA0E6,
	19342 - 11904: 0x92D7,
	19344 - 11904: 0x9675,
	19347 - 11904: 0x93D4,
	19350 - 11904: 0x91BB,
	19351 - 11904: 0x9679,
	19357 - 11904: 0x9A70,
	19389 - 11904: 0x9678,
	19390 - 11904: 0x91CD,
	19392 - 11904: 0x9C4A,
	19460 - 11904: 0xA06F,
	19463 - 11904: 0xA06A,
	19470 - 11904: 0x915F,
	19506 - 11904: 0x8741,
	19515 - 11904: 0x9FA5,
	19518 - 11904: 0x89BA,
	19520 - 11904: 0x874F,
	19527 - 11904: 0x874E,
	19543 - 11904: 0x8755,
	19547 - 11904: 0x9ECD,
	19565 - 11904: 0x9A79,
	19575 - 11904: 0x8CF2,
	19579 - 11904: 0x8D57,
	19581 - 11904: 0x9DCE,
	19585 - 11904: 0x8CD2,
	19589 - 11904: 0x8759,
	19620 - 11904: 0x9D73,
	19630 - 11904: 0x96B9,
	19632 - 11904: 0x96BC,
	19639 - 11904: 0x9CD1,
	19661 - 11904: 0x89B7,
	19681 - 11904: 0x9EEE,
	19682 - 11904: 0x8749,
	19693 - 11904: 0xFB43,
	19719 - 11904: 0x875B,
	19721 - 11904: 0x9EC9,
	19728 - 11904: 0xFBD3,
	19764 - 11904: 0x91AE,
	19830 - 11904: 0x8D58,
	19831 - 11904: 0x8746,
	19849 - 11904: 0x8D56,
	19857 - 11904: 0x9D78,
	19868 - 11904: 0x9D7B,
	19968 - 11904: 0xA440,
	19969 - 11904: 0xA442,
	19971 - 11904: 0xA443,
	19972 - 11904: 0x9EB3,
	19975 - 11904: 0xC945,
	19976 - 11904: 0xA456,
	19977 - 11904: 0xA454,
	19978 - 11904: 0xA457,
	19979 - 11904: 0xA455,
	19980 - 11904: 0xC946,
	19981 - 11904: 0xA4A3,
	19982 - 11904: 0xC94F,
	19983 - 11904: 0xC94D,
	19984 - 11904: 0xA4A2,
	19985 - 11904: 0xA4A1,
	19988 - 11904: 0xA542,
	19989 - 11904: 0xA541,
	19990 - 11904: 0xA540,
	19992 - 11904: 0xA543,
	19993 - 11904: 0xA4FE,
	19994 - 11904: 0x9EB2,
	19996 - 11904: 0x9DD6,
	19998 - 11904: 0xA5E0,
	19999 - 11904: 0xA5E1,
	20001 - 11904: 0x994F,
	20004 - 11904: 0x89CE,
	20006 - 11904: 0xA8C3,
	20008 - 11904: 0x8BC0,
	20010 - 11904: 0x9FC4,
	20011 - 11904: 0xA458,
	20012 - 11904: 0x8BD4,
	20013 - 11904: 0xA4A4,
	20014 - 11904: 0xC950,
	20015 - 11904: 0x8C72,
	20016 - 11904: 0xA4A5,
	20017 - 11904: 0xC963,
	20018 - 11904: 0xA6EA,
	20019 - 11904: 0xCBB1,
	20022 - 11904: 0xC6BF,
	20023 - 11904: 0x8BF9,
	20024 - 11904: 0xA459,
	20025 - 11904: 0xA4A6,
	20027 - 11904: 0xA544,
	20028 - 11904: 0xC964,
	20029 - 11904: 0x8946,
	20031 - 11904: 0xC6C0,
	20034 - 11904: 0xC940,
	20035 - 11904: 0xA444,
	20037 - 11904: 0xA45B,
	20039 - 11904: 0xC947,
	20040 - 11904: 0xA45C,
	20041 - 11904: 0xFAE5,
	20043 - 11904: 0xA4A7,
	20045 - 11904: 0xA545,
	20046 - 11904: 0xA547,
	20047 - 11904: 0xA546,
	20050 - 11904: 0xA5E2,
	20051 - 11904: 0xA5E3,
	20054 - 11904: 0xA8C4,
	20056 - 11904: 0xADBC,
	20057 - 11904: 0xA441,
	20058 - 11904: 0xC87B,
	20059 - 11904: 0x8BC6,
	20060 - 11904: 0xC941,
	20061 - 11904: 0xA445,
	20062 - 11904: 0xA45E,
	20063 - 11904: 0xA45D,
	20073 - 11904: 0xA5E4,
	20074 - 11904: 0x9C57,
	20083 - 11904: 0xA8C5,
	20088 - 11904: 0x9AFB,
	20094 - 11904: 0xB0AE,
	20095 - 11904: 0xD44B,
	20096 - 11904: 0x89D0,
	20097 - 11904: 0x89CF,
	20098 - 11904: 0xB6C3,
	20099 - 11904: 0xDCB1,
	20100 - 11904: 0xDCB2,
	20101 - 11904: 0xC6C1,
	20102 - 11904: 0xA446,
	20103 - 11904: 0x89D1,
	20104 - 11904: 0xA4A9,
	20105 - 11904: 0x89E2,
	20107 - 11904: 0xA8C6,
	20108 - 11904: 0xA447,
	20109 - 11904: 0xC948,
	20110 - 11904: 0xA45F,
	20113 - 11904: 0xA4AA,
	20114 - 11904: 0xA4AC,
	20115 - 11904: 0xC951,
	20116 - 11904: 0xA4AD,
	20117 - 11904: 0xA4AB,
	20120 - 11904: 0x927E,
	20121 - 11904: 0xA5E5,
	20122 - 11904: 0x9DBA,
	20123 - 11904: 0xA8C7,
	20126 - 11904: 0xA8C8,
	20127 - 11904: 0xAB45,
	20128 - 11904: 0xC6C2,
	20129 - 11904: 0xA460,
	20130 - 11904: 0xA4AE,
	20131 - 11904: 0x8C6F,
	20132 - 11904: 0xA5E6,
	20133 - 11904: 0xA5E8,
	20134 - 11904: 0xA5E7,
	20136 - 11904: 0xA6EB,
	20139 - 11904: 0xA8C9,
	20140 - 11904: 0xA8CA,
	20141 - 11904: 0xAB46,
	20142 - 11904: 0xAB47,
	20147 - 11904: 0xADBD,
	20150 - 11904: 0xDCB3,
	20151 - 11904: 0xFBF8,
	20153 - 11904: 0xF6D6,
	20154 - 11904: 0xA448,
	20155 - 11904: 0x8BC7,
	20156 - 11904: 0x926B,
	20159 - 11904: 0x89D2,
	20160 - 11904: 0xA4B0,
	20161 - 11904: 0xA4AF,
	20162 - 11904: 0xC952,
	20163 - 11904: 0xA4B1,
	20164 - 11904: 0xA4B7,
	20166 - 11904: 0xA4B2,
	20167 - 11904: 0xA4B3,
	20168 - 11904: 0xC954,
	20169 - 11904: 0xC953,
	20170 - 11904: 0xA4B5,
	20171 - 11904: 0xA4B6,
	20173 - 11904: 0xA4B4,
	20174 - 11904: 0x9FCF,
	20180 - 11904: 0xA54A,
	20181 - 11904: 0xA54B,
	20182 - 11904: 0xA54C,
	20183 - 11904: 0xA54D,
	20184 - 11904: 0xA549,
	20185 - 11904: 0xA550,
	20186 - 11904: 0xC96A,
	20188 - 11904: 0xC966,
	20189 - 11904: 0xC969,
	20190 - 11904: 0xA551,
	20191 - 11904: 0xA561,
	20193 - 11904: 0xC968,
	20195 - 11904: 0xA54E,
	20196 - 11904: 0xA54F,
	20197 - 11904: 0xA548,
	20200 - 11904: 0xC965,
	20201 - 11904: 0xC967,
	20202 - 11904: 0x9DA9,
	20203 - 11904: 0x89D3,
	20206 - 11904: 0x99E2,
	20208 - 11904: 0xA5F5,
	20209 - 11904: 0xC9B0,
	20210 - 11904: 0xA5F2,
	20211 - 11904: 0xA5F6,
	20212 - 11904: 0xC9BA,
	20213 - 11904: 0xC9AE,
	20214 - 11904: 0xA5F3,
	20215 - 11904: 0xC9B2,
	20216 - 11904: 0x9267,
	20219 - 11904: 0xA5F4,
	20221 - 11904: 0xA5F7,
	20223 - 11904: 0xA5E9,
	20224 - 11904: 0xC9B1,
	20225 - 11904: 0xA5F8,
	20226 - 11904: 0xC9B5,
	20227 - 11904: 0x92A4,
	20228 - 11904: 0xC9B9,
	20229 - 11904: 0xC9B6,
	20232 - 11904: 0xC9B3,
	20233 - 11904: 0xA5EA,
	20234 - 11904: 0xA5EC,
	20235 - 11904: 0xA5F9,
	20237 - 11904: 0xA5EE,
	20238 - 11904: 0xC9AB,
	20239 - 11904: 0xA5F1,
	20240 - 11904: 0xA5EF,
	20241 - 11904: 0xA5F0,
	20242 - 11904: 0xC9BB,
	20243 - 11904: 0xC9B8,
	20244 - 11904: 0xC9AF,
	20245 - 11904: 0xA5ED,
	20247 - 11904: 0x8C73,
	20248 - 11904: 0xC9AC,
	20249 - 11904: 0xA5EB,
	20250 - 11904: 0x894E,
	20253 - 11904: 0xC9B4,
	20258 - 11904: 0xC9B7,
	20264 - 11904: 0x894F,
	20265 - 11904: 0x9278,
	20268 - 11904: 0xC9AD,
	20269 - 11904: 0xCA66,
	20271 - 11904: 0xA742,
	20272 - 11904: 0xA6F4,
	20274 - 11904: 0x91B6,
	20275 - 11904: 0xCA67,
	20276 - 11904: 0xA6F1,
	20278 - 11904: 0xA744,
	20279 - 11904: 0x89D4,
	20280 - 11904: 0xA6F9,
	20281 - 11904: 0x9FD2,
	20282 - 11904: 0xA6F8,
	20283 - 11904: 0xCA5B,
	20284 - 11904: 0xA6FC,
	20285 - 11904: 0xA6F7,
	20286 - 11904: 0xCA60,
	20287 - 11904: 0xCA68,
	20289 - 11904: 0xCA64,
	20290 - 11904: 0x92A7,
	20291 - 11904: 0xA6FA,
	20293 - 11904: 0x95A2,
	20294 - 11904: 0xA6FD,
	20295 - 11904: 0xA6EE,
	20296 - 11904: 0xA747,
	20297 - 11904: 0xCA5D,
	20299 - 11904: 0x926E,
	20300 - 11904: 0xCBBD,
	20301 - 11904: 0xA6EC,
	20302 - 11904: 0xA743,
	20303 - 11904: 0xA6ED,
	20304 - 11904: 0xA6F5,
	20305 - 11904: 0xA6F6,
	20306 - 11904: 0xCA62,
	20307 - 11904: 0xCA5E,
	20308 - 11904: 0xA6FB,
	20309 - 11904: 0xA6F3,
	20310 - 11904: 0xCA5A,
	20311 - 11904: 0xA6EF,
	20312 - 11904: 0xCA65,
	20313 - 11904: 0xA745,
	20314 - 11904: 0xA748,
	20315 - 11904: 0xA6F2,
	20316 - 11904: 0xA740,
	20317 - 11904: 0xA746,
	20318 - 11904: 0xA6F0,
	20319 - 11904: 0xCA63,
	20320 - 11904: 0xA741,
	20321 - 11904: 0xCA69,
	20322 - 11904: 0xCA5C,
	20323 - 11904: 0xA6FE,
	20324 - 11904: 0xCA5F,
	20327 - 11904: 0xCA61,
	20329 - 11904: 0xA8D8,
	20330 - 11904: 0xCBBF,
	20331 - 11904: 0xCBCB,
	20332 - 11904: 0xA8D0,
	20334 - 11904: 0xCBCC,
	20335 - 11904: 0xA8CB,
	20336 - 11904: 0xA8D5,
	20338 - 11904: 0x96EA,
	20339 - 11904: 0xA8CE,
	20340 - 11904: 0xCBB9,
	20341 - 11904: 0xA8D6,
	20342 - 11904: 0xCBB8,
	20343 - 11904: 0xCBBC,
	20344 - 11904: 0xCBC3,
	20345 - 11904: 0xCBC1,
	20346 - 11904: 0xA8DE,
	20347 - 11904: 0xA8D9,
	20348 - 11904: 0xCBB3,
	20349 - 11904: 0xCBB5,
	20350 - 11904: 0xA8DB,
	20351 - 11904: 0xA8CF,
	20352 - 11904: 0xCBB6,
	20353 - 11904: 0xCBC2,
	20354 - 11904: 0xCBC9,
	20355 - 11904: 0xA8D4,
	20356 - 11904: 0xCBBB,
	20357 - 11904: 0xCBB4,
	20358 - 11904: 0xA8D3,
	20359 - 11904: 0xCBB7,
	20360 - 11904: 0xA8D7,
	20361 - 11904: 0xCBBA,
	20362 - 11904: 0x926F,
	20363 - 11904: 0xA8D2,
	20365 - 11904: 0xA8CD,
	20367 - 11904: 0xA8DC,
	20368 - 11904: 0xCBC4,
	20369 - 11904: 0xA8DD,
	20370 - 11904: 0xCBC8,
	20372 - 11904: 0xCBC6,
	20373 - 11904: 0xCBCA,
	20374 - 11904: 0xA8DA,
	20375 - 11904: 0xCBBE,
	20376 - 11904: 0xCBB2,
	20378 - 11904: 0xCBC0,
	20379 - 11904: 0xA8D1,
	20380 - 11904: 0xCBC5,
	20381 - 11904: 0xA8CC,
	20382 - 11904: 0xCBC7,
	20386 - 11904: 0x92A3,
	20392 - 11904: 0x8950,
	20395 - 11904: 0xFA57,
	20398 - 11904: 0xAB56,
	20399 - 11904: 0xAB4A,
	20400 - 11904: 0x9866,
	20402 - 11904: 0xCDE0,
	20403 - 11904: 0xCDE8,
	20404 - 11904: 0x8CF8,
	20405 - 11904: 0xAB49,
	20406 - 11904: 0xAB51,
	20407 - 11904: 0xAB5D,
	20409 - 11904: 0xCDEE,
	20410 - 11904: 0xCDEC,
	20411 - 11904: 0xCDE7,
	20413 - 11904: 0x89D6,
	20415 - 11904: 0xAB4B,
	20416 - 11904: 0xCDED,
	20417 - 11904: 0xCDE3,
	20418 - 11904: 0xAB59,
	20419 - 11904: 0xAB50,
	20420 - 11904: 0xAB58,
	20421 - 11904: 0xCDDE,
	20423 - 11904: 0xCDEA,
	20424 - 11904: 0x98B2,
	20425 - 11904: 0xCDE1,
	20426 - 11904: 0xAB54,
	20427 - 11904: 0xCDE2,
	20428 - 11904: 0x92AB,
	20429 - 11904: 0xCDDD,
	20430 - 11904: 0xAB5B,
	20431 - 11904: 0xAB4E,
	20432 - 11904: 0xAB57,
	20433 - 11904: 0xAB4D,
	20435 - 11904: 0xCDDF,
	20436 - 11904: 0xCDE4,
	20438 - 11904: 0xCDEB,
	20439 - 11904: 0xAB55,
	20440 - 11904: 0xAB52,
	20441 - 11904: 0xCDE6,
	20442 - 11904: 0xAB5A,
	20443 - 11904: 0xCDE9,
	20444 - 11904: 0xCDE5,
	20445 - 11904: 0xAB4F,
	20446 - 11904: 0xAB5C,
	20447 - 11904: 0xAB53,
	20448 - 11904: 0xAB4C,
	20449 - 11904: 0xAB48,
	20452 - 11904: 0x96DE,
	20453 - 11904: 0x92AC,
	20460 - 11904: 0xCDEF,
	20462 - 11904: 0xADD7,
	20463 - 11904: 0xADC1,
	20464 - 11904: 0x8C70,
	20465 - 11904: 0xADD1,
	20466 - 11904: 0x9F6E,
	20467 - 11904: 0xADD6,
	20468 - 11904: 0xD0D0,
	20469 - 11904: 0xD0CF,
	20470 - 11904: 0xD0D4,
	20471 - 11904: 0xD0D5,
	20472 - 11904: 0xADC4,
	20473 - 11904: 0x8EF2,
	20474 - 11904: 0xADCD,
	20477 - 11904: 0x9F6C,
	20478 - 11904: 0xADDA,
	20480 - 11904: 0xADCE,
	20483 - 11904: 0x89D8,
	20485 - 11904: 0xD0C9,
	20486 - 11904: 0xADC7,
	20487 - 11904: 0xD0CA,
	20488 - 11904: 0xFA59,
	20489 - 11904: 0xADDC,
	20491 - 11904: 0xADD3,
	20492 - 11904: 0xADBE,
	20493 - 11904: 0xADBF,
	20494 - 11904: 0xD0DD,
	20495 - 11904: 0xB0BF,
	20497 - 11904: 0xADCC,
	20498 - 11904: 0xADCB,
	20499 - 11904: 0xD0CB,
	20500 - 11904: 0xADCF,
	20501 - 11904: 0xD45B,
	20502 - 11904: 0xADC6,
	20503 - 11904: 0xD0D6,
	20504 - 11904: 0xADD5,
	20505 - 11904: 0xADD4,
	20506 - 11904: 0xADCA,
	20507 - 11904: 0xD0CE,
	20508 - 11904: 0xD0D7,
	20510 - 11904: 0xD0C8,
	20511 - 11904: 0xADC9,
	20512 - 11904: 0xD0D8,
	20513 - 11904: 0xADD2,
	20514 - 11904: 0xD0CC,
	20515 - 11904: 0xADC0,
	20517 - 11904: 0xADC3,
	20518 - 11904: 0xADC2,
	20519 - 11904: 0xD0D9,
	20520 - 11904: 0xADD0,
	20521 - 11904: 0xFA5F,
	20522 - 11904: 0xADD9,
	20523 - 11904: 0xADDB,
	20524 - 11904: 0xD0D3,
	20525 - 11904: 0xADD8,
	20526 - 11904: 0x92A8,
	20527 - 11904: 0xD0DB,
	20528 - 11904: 0xD0CD,
	20529 - 11904: 0xD0DC,
	20531 - 11904: 0xD0D1,
	20532 - 11904: 0x9163,
	20533 - 11904: 0xD0DA,
	20535 - 11904: 0xD0D2,
	20539 - 11904: 0x8C40,
	20540 - 11904: 0xADC8,
	20544 - 11904: 0xD463,
	20545 - 11904: 0xD457,
	20547 - 11904: 0xB0B3,
	20549 - 11904: 0xD45C,
	20550 - 11904: 0xD462,
	20551 - 11904: 0xB0B2,
	20552 - 11904: 0xD455,
	20553 - 11904: 0xB0B6,
	20554 - 11904: 0xD459,
	20555 - 11904: 0xD452,
	20556 - 11904: 0xB0B4,
	20557 - 11904: 0xD456,
	20558 - 11904: 0xB0B9,
	20559 - 11904: 0xB0BE,
	20561 - 11904: 0xD467,
	20563 - 11904: 0xD451,
	20565 - 11904: 0xB0BA,
	20566 - 11904: 0x9F73,
	20567 - 11904: 0xD466,
	20568 - 11904: 0x92AD,
	20570 - 11904: 0xB0B5,
	20571 - 11904: 0xD458,
	20572 - 11904: 0xB0B1,
	20573 - 11904: 0xD453,
	20574 - 11904: 0xD44F,
	20575 - 11904: 0xD45D,
	20576 - 11904: 0xD450,
	20577 - 11904: 0xD44E,
	20578 - 11904: 0xD45A,
	20579 - 11904: 0xD460,
	20580 - 11904: 0xD461,
	20581 - 11904: 0xB0B7,
	20582 - 11904: 0x9BE9,
	20584 - 11904: 0xD85B,
	20585 - 11904: 0xD45E,
	20586 - 11904: 0xD44D,
	20587 - 11904: 0xD45F,
	20588 - 11904: 0x92A9,
	20589 - 11904: 0xB0C1,
	20590 - 11904: 0xD464,
	20591 - 11904: 0xB0C0,
	20592 - 11904: 0xD44C,
	20594 - 11904: 0xD454,
	20595 - 11904: 0xD465,
	20596 - 11904: 0xB0BC,
	20597 - 11904: 0xB0BB,
	20598 - 11904: 0xB0B8,
	20599 - 11904: 0xB0BD,
	20602 - 11904: 0xB0AF,
	20605 - 11904: 0xFA66,
	20608 - 11904: 0xB3C8,
	20609 - 11904: 0x92AA,
	20610 - 11904: 0xD85E,
	20611 - 11904: 0xD857,
	20613 - 11904: 0xB3C5,
	20615 - 11904: 0xD85F,
	20616 - 11904: 0x89D9,
	20619 - 11904: 0xD855,
	20620 - 11904: 0xD858,
	20621 - 11904: 0xB3C4,
	20622 - 11904: 0xD859,
	20624 - 11904: 0xFD56,
	20625 - 11904: 0xB3C7,
	20626 - 11904: 0xD85D,
	20628 - 11904: 0xD853,
	20629 - 11904: 0xD852,
	20630 - 11904: 0xB3C9,
	20632 - 11904: 0xB3CA,
	20633 - 11904: 0xB3C6,
	20634 - 11904: 0xB3CB,
	20635 - 11904: 0xD851,
	20636 - 11904: 0xD85C,
	20637 - 11904: 0xD85A,
	20638 - 11904: 0xD854,
	20642 - 11904: 0xB3C3,
	20643 - 11904: 0xD856,
	20646 - 11904: 0x9FA8,
	20652 - 11904: 0xB6CA,
	20653 - 11904: 0xB6C4,
	20654 - 11904: 0xDCB7,
	20655 - 11904: 0xB6CD,
	20656 - 11904: 0xDCBD,
	20657 - 11904: 0xDCC0,
	20658 - 11904: 0xB6C6,
	20659 - 11904: 0xB6C7,
	20660 - 11904: 0xDCBA,
	20661 - 11904: 0xB6C5,
	20662 - 11904: 0xDCC3,
	20663 - 11904: 0xB6CB,
	20664 - 11904: 0xDCC4,
	20666 - 11904: 0xDCBF,
	20667 - 11904: 0xB6CC,
	20668 - 11904: 0x8C71,
	20669 - 11904: 0xDCB4,
	20670 - 11904: 0xB6C9,
	20671 - 11904: 0xDCB5,
	20673 - 11904: 0xDCBE,
	20674 - 11904: 0xDCBC,
	20676 - 11904: 0xDCB8,
	20677 - 11904: 0xB6C8,
	20678 - 11904: 0xDCB6,
	20679 - 11904: 0xB6CE,
	20680 - 11904: 0xDCBB,
	20681 - 11904: 0xDCC2,
	20682 - 11904: 0xDCB9,
	20683 - 11904: 0xDCC1,
	20685 - 11904: 0x92A1,
	20686 - 11904: 0xB9B6,
	20687 - 11904: 0xB9B3,
	20688 - 11904: 0x90E3,
	20689 - 11904: 0xB9B4,
	20691 - 11904: 0xE0F9,
	20692 - 11904: 0xE0F1,
	20693 - 11904: 0xB9B2,
	20694 - 11904: 0xB9AF,
	20695 - 11904: 0xE0F2,
	20697 - 11904: 0xA0A6,
	20698 - 11904: 0xB9B1,
	20699 - 11904: 0xE0F5,
	20701 - 11904: 0xE0F7,
	20703 - 11904: 0x94AB,
	20704 - 11904: 0xE0FE,
	20705 - 11904: 0xFC72,
	20707 - 11904: 0xE0FD,
	20708 - 11904: 0xE0F8,
	20709 - 11904: 0xB9AE,
	20710 - 11904: 0xE0F0,
	20711 - 11904: 0xB9AC,
	20712 - 11904: 0xE0F3,
	20713 - 11904: 0xB9B7,
	20714 - 11904: 0xE0F6,
	20716 - 11904: 0xE0FA,
	20717 - 11904: 0xB9B0,
	20718 - 11904: 0xB9AD,
	20719 - 11904: 0xE0FC,
	20720 - 11904: 0xE0FB,
	20721 - 11904: 0xB9B5,
	20723 - 11904: 0xE0F4,
	20724 - 11904: 0x97C4,
	20725 - 11904: 0xBBF8,
	20726 - 11904: 0xE4EC,
	20728 - 11904: 0xE4E9,
	20729 - 11904: 0xBBF9,
	20731 - 11904: 0xBBF7,
	20732 - 11904: 0x92AE,
	20733 - 11904: 0xE4F0,
	20734 - 11904: 0xE4ED,
	20735 - 11904: 0xE4E6,
	20736 - 11904: 0xBBF6,
	20737 - 11904: 0xFA67,
	20738 - 11904: 0xBBFA,
	20739 - 11904: 0xE4E7,
	20740 - 11904: 0xBBF5,
	20741 - 11904: 0xBBFD,
	20742 - 11904: 0xE4EA,
	20743 - 11904: 0xE4EB,
	20744 - 11904: 0xBBFB,
	20745 - 11904: 0xBBFC,
	20746 - 11904: 0xE4F1,
	20747 - 11904: 0xE4EE,
	20748 - 11904: 0xE4EF,
	20749 - 11904: 0x92A2,
	20750 - 11904: 0xFA69,
	20752 - 11904: 0xBEAA,
	20753 - 11904: 0xE8F8,
	20754 - 11904: 0xBEA7,
	20755 - 11904: 0xE8F5,
	20756 - 11904: 0xBEA9,
	20757 - 11904: 0xBEAB,
	20759 - 11904: 0xE8F6,
	20760 - 11904: 0xBEA8,
	20762 - 11904: 0xE8F7,
	20764 - 11904: 0xE8F4,
	20767 - 11904: 0xC076,
	20768 - 11904: 0xECBD,
	20769 - 11904: 0xC077,
	20770 - 11904: 0xECBB,
	20772 - 11904: 0xECBC,
	20773 - 11904: 0xECBA,
	20774 - 11904: 0xECB9,
	20777 - 11904: 0xECBE,
	20778 - 11904: 0xC075,
	20779 - 11904: 0x9268,
	20781 - 11904: 0xEFB8,
	20782 - 11904: 0xEFB9,
	20784 - 11904: 0xE4E8,
	20785 - 11904: 0xEFB7,
	20786 - 11904: 0xC078,
	20787 - 11904: 0xC35F,
	20788 - 11904: 0xF1EB,
	20789 - 11904: 0xF1EC,
	20791 - 11904: 0xC4D7,
	20792 - 11904: 0xC4D8,
	20793 - 11904: 0xF5C1,
	20794 - 11904: 0xF5C0,
	20795 - 11904: 0xC56C,
	20796 - 11904: 0xC56B,
	20797 - 11904: 0xF7D0,
	20799 - 11904: 0xA449,
	20800 - 11904: 0xA461,
	20801 - 11904: 0xA4B9,
	20803 - 11904: 0xA4B8,
	20804 - 11904: 0xA553,
	20805 - 11904: 0xA552,
	20806 - 11904: 0xA5FC,
	20807 - 11904: 0xA5FB,
	20808 - 11904: 0xA5FD,
	20809 - 11904: 0xA5FA,
	20811 - 11904: 0xA74A,
	20812 - 11904: 0xA749,
	20813 - 11904: 0xA74B,
	20818 - 11904: 0xA8E0,
	20820 - 11904: 0xA8DF,
	20821 - 11904: 0xA8E1,
	20822 - 11904: 0x8951,
	20823 - 11904: 0xAB5E,
	20825 - 11904: 0xA259,
	20826 - 11904: 0xD0DE,
	20827 - 11904: 0xA25A,
	20828 - 11904: 0xB0C2,
	20829 - 11904: 0xA25C,
	20830 - 11904: 0xA25B,
	20831 - 11904: 0xD860,
	20832 - 11904: 0xFA6F,
	20833 - 11904: 0xA25D,
	20834 - 11904: 0xB9B8,
	20835 - 11904: 0xA25E,
	20837 - 11904: 0xA44A,
	20839 - 11904: 0xA4BA,
	20840 - 11904: 0xA5FE,
	20841 - 11904: 0xA8E2,
	20842 - 11904: 0xFA71,
	20843 - 11904: 0xA44B,
	20844 - 11904: 0xA4BD,
	20845 - 11904: 0xA4BB,
	20846 - 11904: 0xA4BC,
	20849 - 11904: 0xA640,
	20852 - 11904: 0x8952,
	20853 - 11904: 0xA74C,
	20854 - 11904: 0xA8E4,
	20855 - 11904: 0xA8E3,
	20856 - 11904: 0xA8E5,
	20857 - 11904: 0x945A,
	20860 - 11904: 0xADDD,
	20864 - 11904: 0xBEAC,
	20866 - 11904: 0xC6C3,
	20870 - 11904: 0x89DD,
	20871 - 11904: 0xC94E,
	20872 - 11904: 0xC8A2,
	20873 - 11904: 0xA554,
	20874 - 11904: 0xA555,
	20877 - 11904: 0xA641,
	20879 - 11904: 0xCA6A,
	20881 - 11904: 0xAB60,
	20882 - 11904: 0xAB5F,
	20883 - 11904: 0xD0E0,
	20884 - 11904: 0xD0DF,
	20885 - 11904: 0xB0C3,
	20886 - 11904: 0xC6C4,
	20887 - 11904: 0xA4BE,
	20888 - 11904: 0xC955,
	20890 - 11904: 0x9E52,
	20892 - 11904: 0x8953,
	20894 - 11904: 0xCBCD,
	20896 - 11904: 0xAB61,
	20898 - 11904: 0xADE0,
	20900 - 11904: 0xADDE,
	20901 - 11904: 0xADDF,
	20903 - 11904: 0x9E55,
	20904 - 11904: 0x92BA,
	20906 - 11904: 0xBEAD,
	20907 - 11904: 0xC6C5,
	20908 - 11904: 0xA556,
	20910 - 11904: 0x8C5B,
	20912 - 11904: 0xA642,
	20913 - 11904: 0xC9BC,
	20914 - 11904: 0xFA7D,
	20915 - 11904: 0xFAA8,
	20916 - 11904: 0x9A68,
	20917 - 11904: 0xFA47,
	20918 - 11904: 0xA74D,
	20919 - 11904: 0xA74E,
	20920 - 11904: 0xFA7E,
	20921 - 11904: 0xCA6B,
	20924 - 11904: 0xCBCE,
	20925 - 11904: 0xA8E6,
	20926 - 11904: 0xCBCF,
	20931 - 11904: 0x92BB,
	20932 - 11904: 0xD0E2,
	20933 - 11904: 0xD0E3,
	20934 - 11904: 0xADE3,
	20935 - 11904: 0xFDB6,
	20936 - 11904: 0xD0E4,
	20937 - 11904: 0xFAA2,
	20938 - 11904: 0xD0E1,
	20939 - 11904: 0xADE4,
	20940 - 11904: 0xADE2,
	20941 - 11904: 0xADE1,
	20942 - 11904: 0xD0E5,
	20943 - 11904: 0xFAA3,
	20944 - 11904: 0xD468,
	20945 - 11904: 0xFAA4,
	20946 - 11904: 0x9BB4,
	20947 - 11904: 0xFAA6,
	20948 - 11904: 0xD861,
	20951 - 11904: 0xDCC5,
	20952 - 11904: 0xE140,
	20955 - 11904: 0x89DF,
	20956 - 11904: 0xBBFE,
	20957 - 11904: 0xBEAE,
	20958 - 11904: 0xE8F9,
	20959 - 11904: 0xFDDB,
	20960 - 11904: 0xA44C,
	20961 - 11904: 0xA45A,
	20962 - 11904: 0xFAA9,
	20964 - 11904: 0x8954,
	20973 - 11904: 0xFAAB,
	20976 - 11904: 0xB0C4,
	20977 - 11904: 0xB3CD,
	20979 - 11904: 0xB9B9,
	20980 - 11904: 0xFC7A,
	20981 - 11904: 0xC942,
	20982 - 11904: 0xA4BF,
	20984 - 11904: 0xA559,
	20985 - 11904: 0xA557,
	20986 - 11904: 0xA558,
	20988 - 11904: 0x89E0,
	20989 - 11904: 0xA8E7,
	20990 - 11904: 0x9F4F,
	20992 - 11904: 0xA44D,
	20993 - 11904: 0xA44E,
	20994 - 11904: 0xC87D,
	20995 - 11904: 0xA462,
	20997 - 11904: 0x89E1,
	20998 - 11904: 0xA4C0,
	20999 - 11904: 0xA4C1,
	21000 - 11904: 0xA4C2,
	21001 - 11904: 0xC9BE,
	21002 - 11904: 0xA55A,
	21003 - 11904: 0xFAB0,
	21004 - 11904: 0xC96B,
	21006 - 11904: 0xA646,
	21008 - 11904: 0xC9BF,
	21009 - 11904: 0xA644,
	21010 - 11904: 0xA645,
	21011 - 11904: 0xC9BD,
	21014 - 11904: 0xA647,
	21015 - 11904: 0xA643,
	21020 - 11904: 0xCA6C,
	21021 - 11904: 0xAAEC,
	21022 - 11904: 0xCA6D,
	21023 - 11904: 0x9FCD,
	21024 - 11904: 0xA0E7,
	21025 - 11904: 0xCA6E,
	21028 - 11904: 0xA750,
	21029 - 11904: 0xA74F,
	21030 - 11904: 0xFAB1,
	21031 - 11904: 0x89A6,
	21032 - 11904: 0xA753,
	21033 - 11904: 0xA751,
	21034 - 11904: 0xA752,
	21038 - 11904: 0xA8ED,
	21040 - 11904: 0xA8EC,
	21041 - 11904: 0xCBD4,
	21042 - 11904: 0xCBD1,
	21043 - 11904: 0xCBD2,
	21044 - 11904: 0x9EFA,
	21045 - 11904: 0xCBD0,
	21046 - 11904: 0xA8EE,
	21047 - 11904: 0xA8EA,
	21048 - 11904: 0xA8E9,
	21050 - 11904: 0xA8EB,
	21051 - 11904: 0xA8E8,
	21052 - 11904: 0xFAB2,
	21057 - 11904: 0xA8EF,
	21059 - 11904: 0xAB63,
	21060 - 11904: 0xCDF0,
	21062 - 11904: 0xCBD3,
	21063 - 11904: 0xAB68,
	21065 - 11904: 0xCDF1,
	21066 - 11904: 0xAB64,
	21067 - 11904: 0xAB67,
	21068 - 11904: 0xAB66,
	21069 - 11904: 0xAB65,
	21070 - 11904: 0xAB62,
	21071 - 11904: 0x87BC,
	21074 - 11904: 0xD0E8,
	21076 - 11904: 0xADE7,
	21077 - 11904: 0xD0EB,
	21078 - 11904: 0xADE5,
	21079 - 11904: 0xFAB4,
	21081 - 11904: 0x92C4,
	21082 - 11904: 0xD0E7,
	21083 - 11904: 0xADE8,
	21084 - 11904: 0xADE6,
	21085 - 11904: 0xADE9,
	21086 - 11904: 0xD0E9,
	21087 - 11904: 0xD0EA,
	21088 - 11904: 0x9F6F,
	21089 - 11904: 0xD0E6,
	21090 - 11904: 0xD0EC,
	21096 - 11904: 0x8BB0,
	21097 - 11904: 0xB3D1,
	21098 - 11904: 0xB0C5,
	21099 - 11904: 0xD469,
	21100 - 11904: 0xD46B,
	21101 - 11904: 0xD46A,
	21102 - 11904: 0xD46C,
	21103 - 11904: 0xB0C6,
	21106 - 11904: 0xB3CE,
	21107 - 11904: 0x9FAC,
	21108 - 11904: 0xB3CF,
	21109 - 11904: 0xB3D0,
	21111 - 11904: 0xB6D0,
	21112 - 11904: 0xDCC7,
	21113 - 11904: 0x89E3,
	21114 - 11904: 0xDCC6,
	21115 - 11904: 0xDCC8,
	21116 - 11904: 0xDCC9,
	21117 - 11904: 0xB6D1,
	21119 - 11904: 0xB6CF,
	21120 - 11904: 0xE141,
	21121 - 11904: 0xE142,
	21122 - 11904: 0xB9BB,
	21123 - 11904: 0xB9BA,
	21124 - 11904: 0xE35A,
	21127 - 11904: 0xBC40,
	21128 - 11904: 0xBC41,
	21129 - 11904: 0xBC42,
	21130 - 11904: 0xBC44,
	21131 - 11904: 0xE4F2,
	21132 - 11904: 0xE4F3,
	21133 - 11904: 0xBC43,
	21135 - 11904: 0x9BD3,
	21136 - 11904: 0x89E4,
	21137 - 11904: 0xBEAF,
	21139 - 11904: 0xBEB0,
	21140 - 11904: 0xFAB5,
	21142 - 11904: 0xF1ED,
	21143 - 11904: 0xF5C3,
	21144 - 11904: 0xF5C2,
	21145 - 11904: 0xF7D1,
	21146 - 11904: 0x9FD5,
	21147 - 11904: 0xA44F,
	21151 - 11904: 0xA55C,
	21152 - 11904: 0xA55B,
	21153 - 11904: 0x8955,
	21155 - 11904: 0xA648,
	21156 - 11904: 0x92C5,
	21158 - 11904: 0xC9C0,
	21160 - 11904: 0x8956,
	21161 - 11904: 0xA755,
	21162 - 11904: 0xA756,
	21163 - 11904: 0xA754,
	21164 - 11904: 0xA757,
	21165 - 11904: 0xCA6F,
	21166 - 11904: 0xCA70,
	21173 - 11904: 0xFAB3,
	21177 - 11904: 0xFAB6,
	21179 - 11904: 0xA8F1,
	21180 - 11904: 0xCBD5,
	21182 - 11904: 0xA8F0,
	21184 - 11904: 0xCDF2,
	21185 - 11904: 0xAB6C,
	21186 - 11904: 0xCDF3,
	21187 - 11904: 0xAB6B,
	21189 - 11904: 0xFAB7,
	21191 - 11904: 0xAB69,
	21193 - 11904: 0xAB6A,
	21196 - 11904: 0x9EDC,
	21197 - 11904: 0xD0ED,
	21200 - 11904: 0xFBC4,
	21201 - 11904: 0x9F71,
	21202 - 11904: 0xB0C7,
	21203 - 11904: 0xD46E,
	21205 - 11904: 0xB0CA,
	21206 - 11904: 0xD46D,
	21207 - 11904: 0xB1E5,
	21208 - 11904: 0xB0C9,
	21209 - 11904: 0xB0C8,
	21211 - 11904: 0xB3D4,
	21213 - 11904: 0xB3D3,
	21214 - 11904: 0xB3D2,
	21215 - 11904: 0xB6D2,
	21216 - 11904: 0xFABA,
	21217 - 11904: 0x92C7,
	21218 - 11904: 0xB6D5,
	21219 - 11904: 0xB6D6,
	21220 - 11904: 0xB6D4,
	21222 - 11904: 0xB6D3,
	21225 - 11904: 0xE143,
	21227 - 11904: 0xE144,
	21231 - 11904: 0xE4F5,
	21232 - 11904: 0xBC45,
	21233 - 11904: 0xE4F4,
	21235 - 11904: 0xBEB1,
	21236 - 11904: 0xECBF,
	21237 - 11904: 0xC079,
	21239 - 11904: 0xF1EE,
	21240 - 11904: 0xC455,
	21241 - 11904: 0xC6C6,
	21242 - 11904: 0xA463,
	21243 - 11904: 0xA4C3,
	21244 - 11904: 0xC956,
	21246 - 11904: 0xA4C4,
	21247 - 11904: 0xA4C5,
	21249 - 11904: 0x9A4C,
	21253 - 11904: 0xFABD,
	21254 - 11904: 0xA55E,
	21256 - 11904: 0xA649,
	21257 - 11904: 0xCA71,
	21258 - 11904: 0xCBD6,
	21259 - 11904: 0xCBD7,
	21261 - 11904: 0xAB6D,
	21262 - 11904: 0xD0EE,
	21263 - 11904: 0xB0CC,
	21264 - 11904: 0xB0CB,
	21265 - 11904: 0xD863,
	21266 - 11904: 0xD862,
	21269 - 11904: 0xA450,
	21270 - 11904: 0xA4C6,
	21271 - 11904: 0xA55F,
	21273 - 11904: 0xB0CD,
	21274 - 11904: 0xC943,
	21276 - 11904: 0xC96C,
	21277 - 11904: 0xA560,
	21279 - 11904: 0xC9C2,
	21280 - 11904: 0xA64B,
	21281 - 11904: 0xA64A,
	21282 - 11904: 0xC9C1,
	21283 - 11904: 0xA758,
	21284 - 11904: 0x8C68,
	21287 - 11904: 0x89E5,
	21290 - 11904: 0xADEA,
	21292 - 11904: 0x9F7D,
	21293 - 11904: 0xD46F,
	21295 - 11904: 0xB6D7,
	21296 - 11904: 0xE145,
	21297 - 11904: 0xB9BC,
	21298 - 11904: 0xA0A9,
	21299 - 11904: 0xFAC4,
	21300 - 11904: 0xE8FA,
	21303 - 11904: 0xF3FD,
	21304 - 11904: 0xC6C7,
	21305 - 11904: 0xA4C7,
	21307 - 11904: 0x8957,
	21308 - 11904: 0xCBD8,
	21309 - 11904: 0xCDF4,
	21310 - 11904: 0xB0D0,
	21311 - 11904: 0xB0CE,
	21312 - 11904: 0xB0CF,
	21313 - 11904: 0xA451,
	21314 - 11904: 0xFAAA,
	21315 - 11904: 0xA464,
	21316 - 11904: 0xFAC5,
	21317 - 11904: 0xA4CA,
	21319 - 11904: 0xA4C9,
	21320 - 11904: 0xA4C8,
	21321 - 11904: 0xA563,
	21322 - 11904: 0xA562,
	21324 - 11904: 0xC96D,
	21325 - 11904: 0xC9C3,
	21326 - 11904: 0x8958,
	21329 - 11904: 0xA8F5,
	21330 - 11904: 0xA8F2,
	21331 - 11904: 0xA8F4,
	21332 - 11904: 0xA8F3,
	21335 - 11904: 0xAB6E,
	21338 - 11904: 0xB3D5,
	21340 - 11904: 0xA452,
	21341 - 11904: 0x8BE3,
	21342 - 11904: 0xA4CB,
	21343 - 11904: 0x8B61,
	21344 - 11904: 0xA565,
	21345 - 11904: 0xA564,
	21347 - 11904: 0xCA72,
	21348 - 11904: 0x9AF1,
	21350 - 11904: 0xA8F6,
	21351 - 11904: 0x9EB7,
	21353 - 11904: 0xC6C8,
	21356 - 11904: 0xC957,
	21357 - 11904: 0xFAD1,
	21358 - 11904: 0xA567,
	21359 - 11904: 0xA566,
	21360 - 11904: 0xA64C,
	21361 - 11904: 0xA64D,
	21362 - 11904: 0xCA73,
	21363 - 11904: 0xA759,
	21364 - 11904: 0xFAD2,
	21365 - 11904: 0xA75A,
	21367 - 11904: 0xA8F7,
	21368 - 11904: 0xA8F8,
	21369 - 11904: 0xA8F9,
	21371 - 11904: 0xAB6F,
	21372 - 11904: 0xCDF5,
	21373 - 11904: 0x9EBA,
	21374 - 11904: 0xFAD4,
	21375 - 11904: 0xFAD5,
	21378 - 11904: 0xC944,
	21380 - 11904: 0xA4CC,
	21386 - 11904: 0xC9C4,
	21390 - 11904: 0xCA74,
	21391 - 11904: 0xCA75,
	21394 - 11904: 0xCBD9,
	21395 - 11904: 0xFAD9,
	21396 - 11904: 0xCBDA,
	21398 - 11904: 0xCDF7,
	21399 - 11904: 0xCDF6,
	21400 - 11904: 0xCDF9,
	21401 - 11904: 0xCDF8,
	21402 - 11904: 0xAB70,
	21404 - 11904: 0xD470,
	21405 - 11904: 0xADED,
	21406 - 11904: 0xD0EF,
	21407 - 11904: 0xADEC,
	21408 - 11904: 0xFADB,
	21410 - 11904: 0x9CE0,
	21412 - 11904: 0xD864,
	21413 - 11904: 0xB3D6,
	21414 - 11904: 0xFBF7,
	21415 - 11904: 0xD865,
	21416 - 11904: 0xFBFA,
	21417 - 11904: 0x89E7,
	21418 - 11904: 0xA07A,
	21419 - 11904: 0xFADC,
	21420 - 11904: 0xE146,
	21421 - 11904: 0xB9BD,
	21422 - 11904: 0xFADD,
	21424 - 11904: 0x89E9,
	21426 - 11904: 0xBC46,
	21428 - 11904: 0xF1EF,
	21430 - 11904: 0xC6C9,
	21433 - 11904: 0xC958,
	21435 - 11904: 0xA568,
	21441 - 11904: 0xFAE2,
	21442 - 11904: 0x89EB,
	21443 - 11904: 0xB0D1,
	21445 - 11904: 0xFAE3,
	21448 - 11904: 0xA453,
	21449 - 11904: 0xA465,
	21450 - 11904: 0xA4CE,
	21451 - 11904: 0xA4CD,
	21452 - 11904: 0x90C8,
	21453 - 11904: 0xA4CF,
	21456 - 11904: 0x92DA,
	21457 - 11904: 0x8959,
	21458 - 11904: 0x9CF5,
	21460 - 11904: 0xA8FB,
	21462 - 11904: 0xA8FA,
	21463 - 11904: 0xA8FC,
	21464 - 11904: 0x895A,
	21465 - 11904: 0xFAE7,
	21466 - 11904: 0x9FA2,
	21467 - 11904: 0xAB71,
	21471 - 11904: 0xADEE,
	21472 - 11904: 0xFAEA,
	21473 - 11904: 0xE8FB,
	21474 - 11904: 0xC24F,
	21475 - 11904: 0xA466,
	21476 - 11904: 0xA56A,
	21477 - 11904: 0xA579,
	21478 - 11904: 0xA574,
	21480 - 11904: 0xA56F,
	21481 - 11904: 0xA56E,
	21482 - 11904: 0xA575,
	21483 - 11904: 0xA573,
	21484 - 11904: 0xA56C,
	21485 - 11904: 0xA57A,
	21486 - 11904: 0xA56D,
	21487 - 11904: 0xA569,
	21488 - 11904: 0xA578,
	21489 - 11904: 0xA577,
	21490 - 11904: 0xA576,
	21491 - 11904: 0xA56B,
	21493 - 11904: 0xA572,
	21494 - 11904: 0xFAED,
	21495 - 11904: 0x8FAD,
	21496 - 11904: 0xA571,
	21499 - 11904: 0xA57B,
	21500 - 11904: 0xA570,
	21502 - 11904: 0xFB59,
	21505 - 11904: 0xA653,
	21507 - 11904: 0xA659,
	21508 - 11904: 0xA655,
	21510 - 11904: 0xA65B,
	21511 - 11904: 0xC9C5,
	21512 - 11904: 0xA658,
	21513 - 11904: 0xA64E,
	21514 - 11904: 0xA651,
	21515 - 11904: 0xA654,
	21516 - 11904: 0xA650,
	21517 - 11904: 0xA657,
	21518 - 11904: 0xA65A,
	21519 - 11904: 0xA64F,
	21520 - 11904: 0xA652,
	21521 - 11904: 0xA656,
	21522 - 11904: 0xA65C,
	21523 - 11904: 0xFAEF,
	21524 - 11904: 0x96EF,
	21526 - 11904: 0x9DEC,
	21528 - 11904: 0xCA7E,
	21529 - 11904: 0xCA7B,
	21530 - 11904: 0x9DCA,
	21531 - 11904: 0xA767,
	21532 - 11904: 0xCA7C,
	21533 - 11904: 0xA75B,
	21534 - 11904: 0xA75D,
	21535 - 11904: 0xA775,
	21536 - 11904: 0xA770,
	21537 - 11904: 0xFD6D,
	21539 - 11904: 0x89EC,
	21540 - 11904: 0xCAA5,
	21541 - 11904: 0xCA7D,
	21542 - 11904: 0xA75F,
	21543 - 11904: 0xA761,
	21544 - 11904: 0xCAA4,
	21545 - 11904: 0xA768,
	21546 - 11904: 0xCA78,
	21547 - 11904: 0xA774,
	21548 - 11904: 0xA776,
	21549 - 11904: 0xA75C,
	21550 - 11904: 0xA76D,
	21551 - 11904: 0xFB44,
	21552 - 11904: 0xCA76,
	21553 - 11904: 0xA773,
	21554 - 11904: 0x9DE2,
	21555 - 11904: 0xA764,
	21556 - 11904: 0x8C75,
	21557 - 11904: 0xA76E,
	21558 - 11904: 0xA76F,
	21559 - 11904: 0xCA77,
	21560 - 11904: 0xA76C,
	21561 - 11904: 0xA76A,
	21563 - 11904: 0xA76B,
	21564 - 11904: 0xA771,
	21565 - 11904: 0xCAA1,
	21566 - 11904: 0xA75E,
	21568 - 11904: 0xA772,
	21569 - 11904: 0xCAA3,
	21570 - 11904: 0xA766,
	21571 - 11904: 0xA763,
	21573 - 11904: 0xCA7A,
	21574 - 11904: 0xA762,
	21575 - 11904: 0xCAA6,
	21576 - 11904: 0xA765,
	21578 - 11904: 0xA769,
	21579 - 11904: 0x9EC0,
	21580 - 11904: 0x87C5,
	21581 - 11904: 0x9E56,
	21582 - 11904: 0xA760,
	21583 - 11904: 0xCAA2,
	21588 - 11904: 0xCA79,
	21600 - 11904: 0xCBEB,
	21601 - 11904: 0xCBEA,
	21602 - 11904: 0xA94F,
	21603 - 11904: 0xCBED,
	21604 - 11904: 0xCBEF,
	21605 - 11904: 0xCBE4,
	21606 - 11904: 0xCBE7,
	21607 - 11904: 0xCBEE,
	21608 - 11904: 0xA950,
	21609 - 11904: 0x9F79,
	21610 - 11904: 0x9AC7,
	21611 - 11904: 0xCBE1,
	21612 - 11904: 0xCBE5,
	21613 - 11904: 0xFAF4,
	21615 - 11904: 0xCBE9,
	21616 - 11904: 0xCE49,
	21617 - 11904: 0xA94B,
	21618 - 11904: 0xCE4D,
	21619 - 11904: 0xA8FD,
	21620 - 11904: 0xCBE6,
	21621 - 11904: 0xA8FE,
	21622 - 11904: 0xA94C,
	21623 - 11904: 0xA945,
	21624 - 11904: 0xA941,
	21626 - 11904: 0xCBE2,
	21627 - 11904: 0xA944,
	21628 - 11904: 0xA949,
	21629 - 11904: 0xA952,
	21630 - 11904: 0xCBE3,
	21631 - 11904: 0xCBDC,
	21632 - 11904: 0xA943,
	21633 - 11904: 0xCBDD,
	21634 - 11904: 0xCBDF,
	21636 - 11904: 0xA946,
	21637 - 11904: 0x98A1,
	21638 - 11904: 0xA948,
	21639 - 11904: 0xCBDB,
	21640 - 11904: 0xCBE0,
	21643 - 11904: 0xA951,
	21644 - 11904: 0xA94D,
	21645 - 11904: 0xCBE8,
	21646 - 11904: 0xA953,
	21647 - 11904: 0xFAF8,
	21648 - 11904: 0xA94A,
	21649 - 11904: 0xCBDE,
	21650 - 11904: 0xA947,
	21651 - 11904: 0x89F0,
	21652 - 11904: 0x9E47,
	21653 - 11904: 0xA942,
	21654 - 11904: 0xA940,
	21655 - 11904: 0x9DF7,
	21656 - 11904: 0xCBEC,
	21658 - 11904: 0xA94E,
	21660 - 11904: 0x9FD3,
	21662 - 11904: 0x9ACA,
	21664 - 11904: 0xCE48,
	21665 - 11904: 0xCDFB,
	21666 - 11904: 0xCE4B,
	21667 - 11904: 0x89F1,
	21668 - 11904: 0xFAF9,
	21669 - 11904: 0xCDFD,
	21670 - 11904: 0xAB78,
	21671 - 11904: 0xABA8,
	21672 - 11904: 0xAB74,
	21673 - 11904: 0xABA7,
	21674 - 11904: 0xAB7D,
	21675 - 11904: 0xABA4,
	21676 - 11904: 0xAB72,
	21677 - 11904: 0xCDFC,
	21678 - 11904: 0xCE43,
	21679 - 11904: 0xABA3,
	21680 - 11904: 0xCE4F,
	21681 - 11904: 0xABA5,
	21682 - 11904: 0x8E5A,
	21683 - 11904: 0xAB79,
	21684 - 11904: 0x89F2,
	21686 - 11904: 0xCE45,
	21687 - 11904: 0xCE42,
	21688 - 11904: 0xAB77,
	21689 - 11904: 0x89F3,
	21690 - 11904: 0xCDFA,
	21691 - 11904: 0xABA6,
	21692 - 11904: 0xCE4A,
	21693 - 11904: 0xAB7C,
	21694 - 11904: 0xCE4C,
	21695 - 11904: 0xABA9,
	21696 - 11904: 0xAB73,
	21697 - 11904: 0xAB7E,
	21698 - 11904: 0xAB7B,
	21699 - 11904: 0xCE40,
	21700 - 11904: 0xABA1,
	21701 - 11904: 0xCE46,
	21702 - 11904: 0xCE47,
	21703 - 11904: 0xAB7A,
	21704 - 11904: 0xABA2,
	21705 - 11904: 0xAB76,
	21707 - 11904: 0x925D,
	21708 - 11904: 0x8B51,
	21709 - 11904: 0x92E0,
	21710 - 11904: 0xAB75,
	21711 - 11904: 0xCDFE,
	21712 - 11904: 0x89F4,
	21718 - 11904: 0xCE44,
	21722 - 11904: 0x9FD4,
	21726 - 11904: 0xCE4E,
	21728 - 11904: 0xD144,
	21729 - 11904: 0xADFB,
	21730 - 11904: 0xD0F1,
	21731 - 11904: 0x8A79,
	21732 - 11904: 0xD0F6,
	21733 - 11904: 0xADF4,
	21734 - 11904: 0xAE40,
	21735 - 11904: 0xD0F4,
	21736 - 11904: 0xADEF,
	21737 - 11904: 0xADF9,
	21738 - 11904: 0xADFE,
	21739 - 11904: 0xD0FB,
	21741 - 11904: 0xADFA,
	21742 - 11904: 0xADFD,
	21743 - 11904: 0x89F5,
	21745 - 11904: 0xD0FE,
	21746 - 11904: 0xADF5,
	21747 - 11904: 0xD0F5,
	21751 - 11904: 0xD142,
	21752 - 11904: 0xD143,
	21754 - 11904: 0xADF7,
	21755 - 11904: 0xD141,
	21756 - 11904: 0xADF3,
	21757 - 11904: 0xAE43,
	21759 - 11904: 0xD0F8,
	21761 - 11904: 0xADF1,
	21762 - 11904: 0x97A7,
	21763 - 11904: 0xD146,
	21764 - 11904: 0xD0F9,
	21765 - 11904: 0xD0FD,
	21766 - 11904: 0xADF6,
	21767 - 11904: 0xAE42,
	21768 - 11904: 0xD0FA,
	21769 - 11904: 0xADFC,
	21770 - 11904: 0xD140,
	21771 - 11904: 0xD147,
	21772 - 11904: 0xD4A1,
	21773 - 11904: 0x93BA,
	21774 - 11904: 0xD145,
	21775 - 11904: 0xAE44,
	21776 - 11904: 0xADF0,
	21777 - 11904: 0xD0FC,
	21778 - 11904: 0xD0F3,
	21779 - 11904: 0x9E58,
	21780 - 11904: 0xADF8,
	21783 - 11904: 0xD0F2,
	21784 - 11904: 0x89F6,
	21786 - 11904: 0xD0F7,
	21790 - 11904: 0x9E57,
	21795 - 11904: 0x89F7,
	21797 - 11904: 0x8A41,
	21798 - 11904: 0xD0F0,
	21799 - 11904: 0xAE41,
	21800 - 11904: 0x89F8,
	21802 - 11904: 0xD477,
	21803 - 11904: 0xFAF1,
	21804 - 11904: 0xB0E4,
	21805 - 11904: 0xD4A7,
	21806 - 11904: 0xB0E2,
	21807 - 11904: 0xB0DF,
	21808 - 11904: 0xD47C,
	21809 - 11904: 0xB0DB,
	21810 - 11904: 0xD4A2,
	21811 - 11904: 0xB0E6,
	21812 - 11904: 0xD476,
	21813 - 11904: 0xD47B,
	21814 - 11904: 0xD47A,
	21815 - 11904: 0xADF2,
	21816 - 11904: 0xB0E1,
	21817 - 11904: 0xD4A5,
	21819 - 11904: 0xD4A8,
	21820 - 11904: 0xD473,
	21822 - 11904: 0xB3E8,
	21823 - 11904: 0x89FA,
	21824 - 11904: 0xD4A9,
	21825 - 11904: 0xB0E7,
	21827 - 11904: 0xB0D9,
	21828 - 11904: 0xB0D6,
	21829 - 11904: 0xD47E,
	21830 - 11904: 0xB0D3,
	21831 - 11904: 0xFB42,
	21832 - 11904: 0xD4A6,
	21833 - 11904: 0xFABF,
	21834 - 11904: 0xB0DA,
	21835 - 11904: 0xD4AA,
	21837 - 11904: 0xD474,
	21838 - 11904: 0xD4A4,
	21839 - 11904: 0xB0DD,
	21840 - 11904: 0xD475,
	21841 - 11904: 0xD478,
	21842 - 11904: 0xD47D,
	21843 - 11904: 0xFBA3,
	21845 - 11904: 0xB0DE,
	21846 - 11904: 0xB0DC,
	21847 - 11904: 0xB0E8,
	21852 - 11904: 0xB0E3,
	21853 - 11904: 0xFAF7,
	21854 - 11904: 0xB0D7,
	21855 - 11904: 0xB1D2,
	21857 - 11904: 0xB0D8,
	21858 - 11904: 0xD479,
	21859 - 11904: 0xB0E5,
	21860 - 11904: 0xB0E0,
	21861 - 11904: 0xD4A3,
	21862 - 11904: 0xB0D5,
	21865 - 11904: 0x9E4E,
	21866 - 11904: 0xB0D4,
	21867 - 11904: 0x94DC,
	21873 - 11904: 0x95DA,
	21874 - 11904: 0x9DF8,
	21875 - 11904: 0x9F6A,
	21877 - 11904: 0xD471,
	21878 - 11904: 0xD472,
	21879 - 11904: 0xD86A,
	21881 - 11904: 0x8AB7,
	21883 - 11904: 0xB3D7,
	21884 - 11904: 0xB3DA,
	21885 - 11904: 0xD875,
	21886 - 11904: 0xB3EE,
	21887 - 11904: 0xD878,
	21888 - 11904: 0xB3D8,
	21889 - 11904: 0xD871,
	21890 - 11904: 0xB3DE,
	21891 - 11904: 0xB3E4,
	21892 - 11904: 0xB5BD,
	21894 - 11904: 0xFB46,
	21895 - 11904: 0xB3E2,
	21896 - 11904: 0xD86E,
	21897 - 11904: 0xB3EF,
	21898 - 11904: 0xB3DB,
	21899 - 11904: 0xB3E3,
	21900 - 11904: 0xD876,
	21901 - 11904: 0xDCD7,
	21902 - 11904: 0xD87B,
	21903 - 11904: 0xD86F,
	21904 - 11904: 0x8A46,
	21905 - 11904: 0xD866,
	21906 - 11904: 0xD873,
	21907 - 11904: 0xD86D,
	21908 - 11904: 0xB3E1,
	21909 - 11904: 0xD879,
	21912 - 11904: 0xB3DD,
	21913 - 11904: 0xB3F1,
	21914 - 11904: 0xB3EA,
	21916 - 11904: 0xB3DF,
	21917 - 11904: 0xB3DC,
	21919 - 11904: 0xB3E7,
	21921 - 11904: 0xD87A,
	21922 - 11904: 0xD86C,
	21923 - 11904: 0xD872,
	21924 - 11904: 0xD874,
	21925 - 11904: 0xD868,
	21926 - 11904: 0xD877,
	21927 - 11904: 0xB3D9,
	21928 - 11904: 0xD867,
	21929 - 11904: 0xFB47,
	21930 - 11904: 0xB3E0,
	21931 - 11904: 0xB3F0,
	21932 - 11904: 0xB3EC,
	21933 - 11904: 0xD869,
	21934 - 11904: 0xB3E6,
	21936 - 11904: 0x9148,
	21937 - 11904: 0xB3ED,
	21938 - 11904: 0xB3E9,
	21939 - 11904: 0xB3E5,
	21940 - 11904: 0x92DE,
	21941 - 11904: 0xD870,
	21945 - 11904: 0x8B53,
	21946 - 11904: 0x9DF6,
	21947 - 11904: 0xB3EB,
	21948 - 11904: 0x9BDA,
	21951 - 11904: 0xDCD5,
	21952 - 11904: 0xDCD1,
	21953 - 11904: 0x9D7E,
	21954 - 11904: 0xDCE0,
	21955 - 11904: 0xDCCA,
	21956 - 11904: 0xDCD3,
	21957 - 11904: 0xB6E5,
	21958 - 11904: 0xB6E6,
	21959 - 11904: 0xB6DE,
	21960 - 11904: 0xDCDC,
	21961 - 11904: 0xB6E8,
	21962 - 11904: 0xDCCF,
	21963 - 11904: 0xDCCE,
	21964 - 11904: 0xDCCC,
	21965 - 11904: 0xDCDE,
	21966 - 11904: 0xB6DC,
	21967 - 11904: 0xDCD8,
	21968 - 11904: 0xDCCD,
	21969 - 11904: 0xB6DF,
	21970 - 11904: 0xDCD6,
	21971 - 11904: 0xB6DA,
	21972 - 11904: 0xDCD2,
	21973 - 11904: 0xDCD9,
	21974 - 11904: 0xDCDB,
	21975 - 11904: 0x89FD,
	21976 - 11904: 0x99E4,
	21977 - 11904: 0xDCDF,
	21978 - 11904: 0xB6E3,
	21979 - 11904: 0xDCCB,
	21980 - 11904: 0xB6DD,
	21981 - 11904: 0xDCD0,
	21982 - 11904: 0x9E43,
	21983 - 11904: 0xB6D8,
	21985 - 11904: 0xB6E4,
	21986 - 11904: 0xDCDA,
	21987 - 11904: 0xB6E0,
	21988 - 11904: 0xB6E1,
	21989 - 11904: 0xB6E7,
	21990 - 11904: 0xB6DB,
	21991 - 11904: 0xA25F,
	21992 - 11904: 0xB6D9,
	21993 - 11904: 0xDCD4,
	21994 - 11904: 0x9DE9,
	21996 - 11904: 0x8F52,
	21999 - 11904: 0xB6E2,
	22000 - 11904: 0x9DF5,
	22001 - 11904: 0x9DF0,
	22002 - 11904: 0xDCDD,
	22005 - 11904: 0x99E7,
	22006 - 11904: 0xB9CD,
	22007 - 11904: 0xB9C8,
	22009 - 11904: 0xE155,
	22010 - 11904: 0xE151,
	22011 - 11904: 0x8BBD,
	22012 - 11904: 0xE14B,
	22013 - 11904: 0xB9C2,
	22014 - 11904: 0xB9BE,
	22015 - 11904: 0xE154,
	22016 - 11904: 0xB9BF,
	22017 - 11904: 0xE14E,
	22018 - 11904: 0xE150,
	22020 - 11904: 0xE153,
	22021 - 11904: 0xFB48,
	22022 - 11904: 0xB9C4,
	22024 - 11904: 0xB9CB,
	22025 - 11904: 0xB9C5,
	22028 - 11904: 0xE149,
	22029 - 11904: 0xB9C6,
	22030 - 11904: 0xB9C7,
	22031 - 11904: 0xE14C,
	22032 - 11904: 0xB9CC,
	22033 - 11904: 0x9FB7,
	22034 - 11904: 0xE14A,
	22035 - 11904: 0xE14F,
	22036 - 11904: 0xB9C3,
	22037 - 11904: 0xE148,
	22038 - 11904: 0xB9C9,
	22039 - 11904: 0xB9C1,
	22043 - 11904: 0xB9C0,
	22044 - 11904: 0xE14D,
	22045 - 11904: 0xE152,
	22046 - 11904: 0x9DD0,
	22047 - 11904: 0xB9CA,
	22048 - 11904: 0x9FEB,
	22049 - 11904: 0x8DA9,
	22050 - 11904: 0x9DCF,
	22051 - 11904: 0x98E1,
	22053 - 11904: 0x9DE5,
	22055 - 11904: 0xE147,
	22057 - 11904: 0xBC4D,
	22058 - 11904: 0xE547,
	22060 - 11904: 0xE544,
	22061 - 11904: 0x9DC8,
	22062 - 11904: 0xBC47,
	22063 - 11904: 0xBC53,
	22064 - 11904: 0xBC54,
	22066 - 11904: 0xBC4A,
	22067 - 11904: 0xE542,
	22068 - 11904: 0xBC4C,
	22069 - 11904: 0xE4F9,
	22070 - 11904: 0xBC52,
	22071 - 11904: 0xFB4F,
	22072 - 11904: 0xE546,
	22073 - 11904: 0xBC49,
	22074 - 11904: 0xE548,
	22075 - 11904: 0xBC48,
	22077 - 11904: 0xE543,
	22078 - 11904: 0xE545,
	22079 - 11904: 0xBC4B,
	22080 - 11904: 0xE541,
	22081 - 11904: 0xE4FA,
	22082 - 11904: 0xE4F7,
	22083 - 11904: 0x9DEB,
	22085 - 11904: 0xD86B,
	22086 - 11904: 0xE4FD,
	22088 - 11904: 0xE4F6,
	22089 - 11904: 0xE4FC,
	22090 - 11904: 0xE4FB,
	22092 - 11904: 0xE4F8,
	22093 - 11904: 0xFB54,
	22094 - 11904: 0xBC4F,
	22095 - 11904: 0xFB55,
	22096 - 11904: 0x9AA2,
	22098 - 11904: 0x8AD6,
	22099 - 11904: 0xBC4E,
	22100 - 11904: 0x9A5F,
	22103 - 11904: 0xBC50,
	22104 - 11904: 0xE4FE,
	22105 - 11904: 0xBEB2,
	22106 - 11904: 0xE540,
	22109 - 11904: 0x9EF5,
	22110 - 11904: 0xE945,
	22112 - 11904: 0xE8FD,
	22113 - 11904: 0x8FB7,
	22114 - 11904: 0xBEBE,
	22115 - 11904: 0xE942,
	22116 - 11904: 0xBEB6,
	22117 - 11904: 0xBEBA,
	22118 - 11904: 0xE941,
	22120 - 11904: 0xBEB9,
	22121 - 11904: 0xBEB5,
	22122 - 11904: 0xBEB8,
	22123 - 11904: 0xBEB3,
	22124 - 11904: 0xBEBD,
	22125 - 11904: 0xE943,
	22126 - 11904: 0xE8FE,
	22127 - 11904: 0xBEBC,
	22128 - 11904: 0xE8FC,
	22129 - 11904: 0xBEBB,
	22130 - 11904: 0xE944,
	22131 - 11904: 0xE940,
	22132 - 11904: 0xBC51,
	22134 - 11904: 0xBEBF,
	22135 - 11904: 0xE946,
	22136 - 11904: 0xBEB7,
	22137 - 11904: 0xBEB4,
	22138 - 11904: 0x9AD2,
	22139 - 11904: 0x9E6A,
	22140 - 11904: 0x9EE8,
	22142 - 11904: 0xECC6,
	22143 - 11904: 0xECC8,
	22144 - 11904: 0xC07B,
	22145 - 11904: 0xECC9,
	22146 - 11904: 0xECC7,
	22147 - 11904: 0xECC5,
	22148 - 11904: 0xECC4,
	22149 - 11904: 0xC07D,
	22150 - 11904: 0xECC3,
	22151 - 11904: 0xC07E,
	22153 - 11904: 0x8BBF,
	22154 - 11904: 0x91C2,
	22155 - 11904: 0x9D62,
	22156 - 11904: 0xECC1,
	22157 - 11904: 0xECC2,
	22158 - 11904: 0xC07A,
	22159 - 11904: 0xC0A1,
	22160 - 11904: 0xC07C,
	22162 - 11904: 0x9260,
	22163 - 11904: 0xECC0,
	22165 - 11904: 0xC250,
	22167 - 11904: 0xEFBC,
	22168 - 11904: 0xEFBA,
	22169 - 11904: 0xEFBF,
	22170 - 11904: 0xEFBD,
	22172 - 11904: 0xEFBB,
	22173 - 11904: 0xEFBE,
	22174 - 11904: 0x925E,
	22175 - 11904: 0x91C1,
	22177 - 11904: 0x8AC5,
	22180 - 11904: 0x97A3,
	22181 - 11904: 0xC360,
	22182 - 11904: 0xF1F2,
	22183 - 11904: 0xF1F3,
	22184 - 11904: 0xC456,
	22186 - 11904: 0xF1F4,
	22187 - 11904: 0xF1F0,
	22188 - 11904: 0xF1F5,
	22189 - 11904: 0xF1F1,
	22190 - 11904: 0xC251,
	22191 - 11904: 0x8B6C,
	22193 - 11904: 0x8D7E,
	22194 - 11904: 0xF3FE,
	22195 - 11904: 0xF441,
	22196 - 11904: 0xC459,
	22197 - 11904: 0xF440,
	22198 - 11904: 0xC458,
	22199 - 11904: 0xC457,
	22201 - 11904: 0x9C54,
	22204 - 11904: 0xC45A,
	22205 - 11904: 0xF5C5,
	22206 - 11904: 0xF5C6,
	22207 - 11904: 0x9DBD,
	22208 - 11904: 0xC4DA,
	22209 - 11904: 0xC4D9,
	22210 - 11904: 0xC4DB,
	22211 - 11904: 0xF5C4,
	22213 - 11904: 0xF6D8,
	22214 - 11904: 0xF6D7,
	22216 - 11904: 0xC56D,
	22217 - 11904: 0xC56F,
	22218 - 11904: 0xC56E,
	22219 - 11904: 0xF6D9,
	22220 - 11904: 0xC5C8,
	22221 - 11904: 0xF8A6,
	22225 - 11904: 0xC5F1,
	22227 - 11904: 0xF8A5,
	22228 - 11904: 0xF8EE,
	22230 - 11904: 0x9CC5,
	22231 - 11904: 0xC949,
	22234 - 11904: 0xA57D,
	22235 - 11904: 0xA57C,
	22237 - 11904: 0xA65F,
	22238 - 11904: 0xA65E,
	22239 - 11904: 0xC9C7,
	22240 - 11904: 0xA65D,
	22241 - 11904: 0xC9C6,
	22242 - 11904: 0x895B,
	22244 - 11904: 0xA779,
	22245 - 11904: 0xCAA9,
	22247 - 11904: 0xCAA8,
	22250 - 11904: 0xA777,
	22251 - 11904: 0xA77A,
	22253 - 11904: 0xFB5C,
	22254 - 11904: 0xCAA7,
	22255 - 11904: 0xFB5B,
	22256 - 11904: 0xA778,
	22257 - 11904: 0xFB57,
	22263 - 11904: 0xCBF0,
	22265 - 11904: 0xCBF1,
	22266 - 11904: 0xA954,
	22267 - 11904: 0x8765,
	22269 - 11904: 0x98C7,
	22271 - 11904: 0xABAA,
	22272 - 11904: 0xFB5A,
	22273 - 11904: 0xD148,
	22274 - 11904: 0xD149,
	22275 - 11904: 0xAE45,
	22276 - 11904: 0xAE46,
	22279 - 11904: 0xD4AC,
	22280 - 11904: 0xB0E9,
	22281 - 11904: 0xB0EB,
	22282 - 11904: 0xD4AB,
	22283 - 11904: 0xB0EA,
	22284 - 11904: 0xD87C,
	22285 - 11904: 0xB3F2,
	22290 - 11904: 0xB6E9,
	22291 - 11904: 0xB6EA,
	22292 - 11904: 0xDCE1,
	22293 - 11904: 0x9CEE,
	22294 - 11904: 0xB9CF,
	22296 - 11904: 0xB9CE,
	22298 - 11904: 0xE549,
	22299 - 11904: 0xE948,
	22300 - 11904: 0xE947,
	22301 - 11904: 0x92E2,
	22302 - 11904: 0xF96B,
	22303 - 11904: 0xA467,
	22304 - 11904: 0xC959,
	22306 - 11904: 0xC96E,
	22307 - 11904: 0xC96F,
	22312 - 11904: 0xA662,
	22313 - 11904: 0xA666,
	22314 - 11904: 0xC9C9,
	22316 - 11904: 0xA664,
	22317 - 11904: 0xA663,
	22318 - 11904: 0xC9C8,
	22319 - 11904: 0xA665,
	22320 - 11904: 0xA661,
	22322 - 11904: 0x94A7,
	22323 - 11904: 0xA660,
	22324 - 11904: 0xC9CA,
	22331 - 11904: 0xA7A6,
	22333 - 11904: 0x8CCC,
	22334 - 11904: 0xA7A3,
	22335 - 11904: 0x9BD4,
	22336 - 11904: 0xA77D,
	22337 - 11904: 0xCAAA,
	22338 - 11904: 0xFB64,
	22339 - 11904: 0xFB76,
	22341 - 11904: 0xCAAB,
	22342 - 11904: 0xFB60,
	22343 - 11904: 0xA7A1,
	22345 - 11904: 0xCAAD,
	22346 - 11904: 0xA77B,
	22347 - 11904: 0xCAAE,
	22348 - 11904: 0xCAAC,
	22349 - 11904: 0xA77E,
	22350 - 11904: 0xA7A2,
	22351 - 11904: 0xA7A5,
	22352 - 11904: 0xA7A4,
	22353 - 11904: 0xA77C,
	22354 - 11904: 0xCAAF,
	22356 - 11904: 0x99E5,
	22359 - 11904: 0x9AC2,
	22363 - 11904: 0x91FB,
	22367 - 11904: 0xA073,
	22369 - 11904: 0xA959,
	22370 - 11904: 0xCBFE,
	22372 - 11904: 0xA95B,
	22374 - 11904: 0xA95A,
	22375 - 11904: 0x9F72,
	22376 - 11904: 0xCC40,
	22377 - 11904: 0xA958,
	22378 - 11904: 0xA957,
	22379 - 11904: 0xCBF5,
	22381 - 11904: 0xCBF4,
	22383 - 11904: 0xCBF2,
	22384 - 11904: 0xCBF7,
	22385 - 11904: 0xCBF6,
	22386 - 11904: 0xCBF3,
	22387 - 11904: 0xCBFC,
	22388 - 11904: 0xCBFD,
	22389 - 11904: 0xCBFA,
	22390 - 11904: 0xCBF8,
	22391 - 11904: 0xA956,
	22394 - 11904: 0x9FCC,
	22395 - 11904: 0xCBFB,
	22396 - 11904: 0xA95C,
	22397 - 11904: 0xCC41,
	22398 - 11904: 0x98A5,
	22399 - 11904: 0x92E8,
	22400 - 11904: 0xCBF9,
	22402 - 11904: 0xABAB,
	22403 - 11904: 0xA955,
	22408 - 11904: 0x9BBC,
	22410 - 11904: 0x96F3,
	22411 - 11904: 0xABAC,
	22412 - 11904: 0xCE54,
	22413 - 11904: 0x92E7,
	22415 - 11904: 0xCE5A,
	22416 - 11904: 0xFC67,
	22419 - 11904: 0xABB2,
	22420 - 11904: 0xCE58,
	22421 - 11904: 0xCE5E,
	22423 - 11904: 0xCE55,
	22424 - 11904: 0xCE59,
	22425 - 11904: 0xCE5B,
	22426 - 11904: 0xCE5D,
	22427 - 11904: 0xCE57,
	22428 - 11904: 0x8B7D,
	22429 - 11904: 0xCE56,
	22430 - 11904: 0xCE51,
	22431 - 11904: 0xCE52,
	22432 - 11904: 0xABAD,
	22433 - 11904: 0x9BF4,
	22434 - 11904: 0xABAF,
	22435 - 11904: 0xABAE,
	22436 - 11904: 0xCE53,
	22437 - 11904: 0xCE5C,
	22439 - 11904: 0x9EF7,
	22442 - 11904: 0x9EC1,
	22446 - 11904: 0xABB1,
	22451 - 11904: 0x87C3,
	22452 - 11904: 0x996F,
	22453 - 11904: 0xCE50,
	22454 - 11904: 0xD153,
	22456 - 11904: 0xD152,
	22457 - 11904: 0xD157,
	22458 - 11904: 0xD14E,
	22459 - 11904: 0x96F1,
	22460 - 11904: 0xD151,
	22461 - 11904: 0xD150,
	22462 - 11904: 0x8E41,
	22463 - 11904: 0xD154,
	22465 - 11904: 0xD158,
	22466 - 11904: 0xAE47,
	22467 - 11904: 0xAE4A,
	22468 - 11904: 0x954A,
	22470 - 11904: 0xD14F,
	22471 - 11904: 0xD155,
	22472 - 11904: 0x97E6,
	22475 - 11904: 0xAE49,
	22476 - 11904: 0xD14A,
	22478 - 11904: 0xABB0,
	22479 - 11904: 0xD4BA,
	22480 - 11904: 0xD156,
	22482 - 11904: 0xD14D,
	22484 - 11904: 0xAE48,
	22485 - 11904: 0xD14C,
	22487 - 11904: 0x96F5,
	22492 - 11904: 0xD4B1,
	22493 - 11904: 0x92E6,
	22494 - 11904: 0x9F42,
	22495 - 11904: 0xB0EC,
	22496 - 11904: 0xB0F0,
	22497 - 11904: 0xD4C1,
	22498 - 11904: 0xD4AF,
	22499 - 11904: 0xD4BD,
	22500 - 11904: 0xB0F1,
	22501 - 11904: 0xD4BF,
	22502 - 11904: 0xFB67,
	22503 - 11904: 0xD4C5,
	22505 - 11904: 0xD4C9,
	22508 - 11904: 0xD4C0,
	22509 - 11904: 0xD4B4,
	22510 - 11904: 0xD4BC,
	22511 - 11904: 0x99A9,
	22512 - 11904: 0xD4CA,
	22513 - 11904: 0xD4C8,
	22514 - 11904: 0xD4BE,
	22515 - 11904: 0xD4B9,
	22516 - 11904: 0xD4B2,
	22517 - 11904: 0xD8A6,
	22518 - 11904: 0xD4B0,
	22519 - 11904: 0xB0F5,
	22520 - 11904: 0xD4B7,
	22521 - 11904: 0xB0F6,
	22522 - 11904: 0xB0F2,
	22523 - 11904: 0xD4AD,
	22524 - 11904: 0xD4C3,
	22525 - 11904: 0xD4B5,
	22526 - 11904: 0xFAE6,
	22528 - 11904: 0xD4B3,
	22529 - 11904: 0xD4C6,
	22530 - 11904: 0xB0F3,
	22531 - 11904: 0xFB69,
	22532 - 11904: 0xD4CC,
	22533 - 11904: 0xB0ED,
	22534 - 11904: 0xB0EF,
	22535 - 11904: 0xD4BB,
	22536 - 11904: 0xD4B6,
	22537 - 11904: 0xAE4B,
	22538 - 11904: 0xB0EE,
	22539 - 11904: 0xD4B8,
	22540 - 11904: 0xD4C7,
	22541 - 11904: 0xD4CB,
	22542 - 11904: 0xD4C2,
	22544 - 11904: 0xD4C4,
	22546 - 11904: 0x97E5,
	22548 - 11904: 0xD4AE,
	22552 - 11904: 0x87C8,
	22553 - 11904: 0xD8A1,
	22555 - 11904: 0xD8AA,
	22556 - 11904: 0xD8A9,
	22557 - 11904: 0xB3FA,
	22558 - 11904: 0xD8A2,
	22560 - 11904: 0xB3FB,
	22561 - 11904: 0xB3F9,
	22562 - 11904: 0x967D,
	22563 - 11904: 0xD8A4,
	22564 - 11904: 0xB3F6,
	22565 - 11904: 0xD8A8,
	22566 - 11904: 0xFB6C,
	22567 - 11904: 0xD8A3,
	22568 - 11904: 0xD8A5,
	22569 - 11904: 0xD87D,
	22570 - 11904: 0xB3F4,
	22572 - 11904: 0xD8B2,
	22573 - 11904: 0xD8B1,
	22574 - 11904: 0xD8AE,
	22575 - 11904: 0xB3F3,
	22576 - 11904: 0xB3F7,
	22577 - 11904: 0xB3F8,
	22578 - 11904: 0xD14B,
	22579 - 11904: 0xD8AB,
	22580 - 11904: 0xB3F5,
	22581 - 11904: 0xB0F4,
	22582 - 11904: 0xD8AD,
	22583 - 11904: 0xD87E,
	22584 - 11904: 0xD8B0,
	22585 - 11904: 0xD8AF,
	22586 - 11904: 0x99A2,
	22587 - 11904: 0xD8B3,
	22589 - 11904: 0xDCEF,
	22591 - 11904: 0xD8AC,
	22592 - 11904: 0x9ABB,
	22596 - 11904: 0x9A65,
	22599 - 11904: 0x944E,
	22600 - 11904: 0xD8A7,
	22601 - 11904: 0xDCE7,
	22602 - 11904: 0xB6F4,
	22603 - 11904: 0xB6F7,
	22604 - 11904: 0xB6F2,
	22605 - 11904: 0xDCE6,
	22606 - 11904: 0xDCEA,
	22607 - 11904: 0xDCE5,
	22609 - 11904: 0xB6EC,
	22610 - 11904: 0xB6F6,
	22611 - 11904: 0xDCE2,
	22612 - 11904: 0xB6F0,
	22613 - 11904: 0xDCE9,
	22615 - 11904: 0xB6EE,
	22616 - 11904: 0xB6ED,
	22617 - 11904: 0xDCEC,
	22618 - 11904: 0xB6EF,
	22619 - 11904: 0xDCEE,
	22620 - 11904: 0xFB6E,
	22621 - 11904: 0xDCEB,
	22622 - 11904: 0xB6EB,
	22623 - 11904: 0x99DF,
	22626 - 11904: 0xB6F5,
	22627 - 11904: 0xDCF0,
	22628 - 11904: 0xDCE4,
	22629 - 11904: 0xDCED,
	22632 - 11904: 0xDCE3,
	22633 - 11904: 0x98E3,
	22635 - 11904: 0xB6F1,
	22636 - 11904: 0x9254,
	22637 - 11904: 0xB6F3,
	22639 - 11904: 0xDCE8,
	22641 - 11904: 0xDCF1,
	22642 - 11904: 0x967B,
	22643 - 11904: 0x8AAF,
	22644 - 11904: 0xE15D,
	22645 - 11904: 0xB9D0,
	22646 - 11904: 0xE163,
	22649 - 11904: 0xB9D5,
	22650 - 11904: 0xE15F,
	22651 - 11904: 0xE166,
	22652 - 11904: 0xE157,
	22653 - 11904: 0xB9D7,
	22654 - 11904: 0xB9D1,
	22655 - 11904: 0xE15C,
	22656 - 11904: 0xBC55,
	22657 - 11904: 0xE15B,
	22658 - 11904: 0xE164,
	22659 - 11904: 0xB9D2,
	22661 - 11904: 0xB9D6,
	22662 - 11904: 0xE15A,
	22663 - 11904: 0xE160,
	22664 - 11904: 0xE165,
	22665 - 11904: 0xE156,
	22666 - 11904: 0xB9D4,
	22667 - 11904: 0xE15E,
	22670 - 11904: 0xE162,
	22671 - 11904: 0xE168,
	22672 - 11904: 0xE158,
	22673 - 11904: 0xE161,
	22674 - 11904: 0x8C77,
	22675 - 11904: 0xB9D3,
	22676 - 11904: 0xE167,
	22678 - 11904: 0x87B0,
	22680 - 11904: 0xE159,
	22681 - 11904: 0x8BAF,
	22682 - 11904: 0x9EBD,
	22684 - 11904: 0xBC59,
	22685 - 11904: 0xE54B,
	22686 - 11904: 0xBC57,
	22687 - 11904: 0xBC56,
	22688 - 11904: 0xE54D,
	22689 - 11904: 0xE552,
	22691 - 11904: 0xE54E,
	22693 - 11904: 0xE551,
	22694 - 11904: 0xBC5C,
	22695 - 11904: 0x9EE6,
	22696 - 11904: 0xBEA5,
	22697 - 11904: 0xBC5B,
	22698 - 11904: 0xFB6F,
	22699 - 11904: 0xE54A,
	22700 - 11904: 0xE550,
	22702 - 11904: 0xBC5A,
	22703 - 11904: 0xE54F,
	22704 - 11904: 0x8EE1,
	22705 - 11904: 0xE54C,
	22707 - 11904: 0xBC58,
	22709 - 11904: 0x9B7D,
	22710 - 11904: 0x9C7E,
	22714 - 11904: 0xE94D,
	22715 - 11904: 0xF9D9,
	22716 - 11904: 0xE94F,
	22717 - 11904: 0xE94A,
	22718 - 11904: 0xBEC1,
	22719 - 11904: 0xE94C,
	22721 - 11904: 0xBEC0,
	22722 - 11904: 0xE94E,
	22725 - 11904: 0xBEC3,
	22726 - 11904: 0xE950,
	22727 - 11904: 0xBEC2,
	22728 - 11904: 0xE949,
	22729 - 11904: 0xE94B,
	22731 - 11904: 0x92EA,
	22734 - 11904: 0xC0A5,
	22735 - 11904: 0xECCC,
	22736 - 11904: 0x8C78,
	22737 - 11904: 0xC0A4,
	22738 - 11904: 0xECCD,
	22739 - 11904: 0xC0A3,
	22740 - 11904: 0xECCB,
	22741 - 11904: 0xC0A2,
	22742 - 11904: 0xECCA,
	22744 - 11904: 0xC253,
	22745 - 11904: 0xC252,
	22746 - 11904: 0xF1F6,
	22747 - 11904: 0xF1F8,
	22748 - 11904: 0xFB72,
	22749 - 11904: 0xF1F7,
	22750 - 11904: 0xC361,
	22751 - 11904: 0xC362,
	22752 - 11904: 0xFB71,
	22754 - 11904: 0xC363,
	22755 - 11904: 0xF442,
	22756 - 11904: 0xC45B,
	22759 - 11904: 0xF7D3,
	22760 - 11904: 0xF7D2,
	22761 - 11904: 0xC5F2,
	22763 - 11904: 0xA468,
	22764 - 11904: 0xA4D0,
	22767 - 11904: 0xA7A7,
	22768 - 11904: 0x895C,
	22770 - 11904: 0x98F0,
	22771 - 11904: 0x96F2,
	22772 - 11904: 0xCE5F,
	22777 - 11904: 0xB3FC,
	22778 - 11904: 0xB3FD,
	22779 - 11904: 0xFB74,
	22780 - 11904: 0xDCF2,
	22781 - 11904: 0xB9D8,
	22782 - 11904: 0xE169,
	22783 - 11904: 0xE553,
	22786 - 11904: 0x8BC1,
	22787 - 11904: 0xC95A,
	22788 - 11904: 0x895D,
	22789 - 11904: 0x89DE,
	22790 - 11904: 0xCAB0,
	22791 - 11904: 0x895E,
	22794 - 11904: 0xC6CA,
	22796 - 11904: 0xCC42,
	22797 - 11904: 0xCE60,
	22798 - 11904: 0xD159,
	22799 - 11904: 0xAE4C,
	22801 - 11904: 0xFE42,
	22802 - 11904: 0xF1F9,
	22804 - 11904: 0xC4DC,
	22805 - 11904: 0xA469,
	22806 - 11904: 0xA57E,
	22807 - 11904: 0xC970,
	22809 - 11904: 0xA667,
	22810 - 11904: 0xA668,
	22812 - 11904: 0xA95D,
	22813 - 11904: 0x8768,
	22815 - 11904: 0xFB7B,
	22816 - 11904: 0xB0F7,
	22818 - 11904: 0xB9DA,
	22820 - 11904: 0xB9DB,
	22821 - 11904: 0xB9D9,
	22823 - 11904: 0xA46A,
	22825 - 11904: 0xA4D1,
	22826 - 11904: 0xA4D3,
	22827 - 11904: 0xA4D2,
	22828 - 11904: 0xC95B,
	22829 - 11904: 0xA4D4,
	22830 - 11904: 0xA5A1,
	22831 - 11904: 0xC971,
	22833 - 11904: 0xA5A2,
	22834 - 11904: 0x895F,
	22836 - 11904: 0x8960,
	22839 - 11904: 0xA669,
	22840 - 11904: 0xA66A,
	22844 - 11904: 0xC9CB,
	22846 - 11904: 0xA7A8,
	22848 - 11904: 0xCAB1,
	22852 - 11904: 0xA961,
	22853 - 11904: 0xCC43,
	22855 - 11904: 0xA95F,
	22856 - 11904: 0xA960,
	22857 - 11904: 0xA95E,
	22858 - 11904: 0xD15A,
	22862 - 11904: 0xABB6,
	22863 - 11904: 0xABB5,
	22864 - 11904: 0xABB7,
	22865 - 11904: 0xABB4,
	22867 - 11904: 0xCE61,
	22868 - 11904: 0xA962,
	22869 - 11904: 0xABB3,
	22871 - 11904: 0xAE4D,
	22872 - 11904: 0xAE4E,
	22874 - 11904: 0xAE4F,
	22876 - 11904: 0xD4CD,
	22880 - 11904: 0xB3FE,
	22881 - 11904: 0xD8B4,
	22882 - 11904: 0xB0F8,
	22885 - 11904: 0x9BCD,
	22887 - 11904: 0xB6F8,
	22889 - 11904: 0xB9DD,
	22890 - 11904: 0xB9DC,
	22891 - 11904: 0xE16A,
	22893 - 11904: 0xBC5D,
	22894 - 11904: 0xBEC4,
	22896 - 11904: 0xEFC0,
	22897 - 11904: 0xF6DA,
	22898 - 11904: 0xF7D4,
	22899 - 11904: 0xA46B,
	22900 - 11904: 0xA5A3,
	22901 - 11904: 0x9DD3,
	22902 - 11904: 0xA5A4,
	22903 - 11904: 0xC9D1,
	22904 - 11904: 0xA66C,
	22905 - 11904: 0xA66F,
	22907 - 11904: 0xC9CF,
	22908 - 11904: 0xC9CD,
	22909 - 11904: 0xA66E,
	22910 - 11904: 0xC9D0,
	22911 - 11904: 0xC9D2,
	22912 - 11904: 0xC9CC,
	22913 - 11904: 0xA671,
	22914 - 11904: 0xA670,
	22915 - 11904: 0xA66D,
	22916 - 11904: 0xA66B,
	22917 - 11904: 0xC9CE,
	22921 - 11904: 0x984C,
	22922 - 11904: 0xA7B3,
	22925 - 11904: 0xA7B0,
	22926 - 11904: 0xCAB6,
	22927 - 11904: 0xCAB9,
	22928 - 11904: 0xCAB8,
	22930 - 11904: 0xA7AA,
	22931 - 11904: 0xA7B2,
	22932 - 11904: 0x9752,
	22934 - 11904: 0xA7AF,
	22935 - 11904: 0xCAB5,
	22936 - 11904: 0xCAB3,
	22937 - 11904: 0xA7AE,
	22938 - 11904: 0x95C3,
	22941 - 11904: 0xA7A9,
	22942 - 11904: 0xA7AC,
	22943 - 11904: 0x9BB6,
	22944 - 11904: 0xCAB4,
	22945 - 11904: 0xCABB,
	22946 - 11904: 0xCAB7,
	22947 - 11904: 0xA7AD,
	22948 - 11904: 0xA7B1,
	22949 - 11904: 0xA7B4,
	22950 - 11904: 0xCAB2,
	22951 - 11904: 0xCABA,
	22952 - 11904: 0xA7AB,
	22956 - 11904: 0x9AB9,
	22958 - 11904: 0xA967,
	22959 - 11904: 0xA96F,
	22960 - 11904: 0x97B3,
	22961 - 11904: 0xCC4F,
	22962 - 11904: 0xCC48,
	22963 - 11904: 0xA970,
	22964 - 11904: 0xCC53,
	22965 - 11904: 0xCC44,
	22966 - 11904: 0xCC4B,
	22967 - 11904: 0x9F74,
	22968 - 11904: 0x92F1,
	22969 - 11904: 0xA966,
	22970 - 11904: 0xCC45,
	22971 - 11904: 0xA964,
	22972 - 11904: 0xCC4C,
	22973 - 11904: 0xCC50,
	22974 - 11904: 0xA963,
	22975 - 11904: 0x8CFA,
	22976 - 11904: 0xCC51,
	22977 - 11904: 0xCC4A,
	22979 - 11904: 0xCC4D,
	22980 - 11904: 0x97DF,
	22981 - 11904: 0xA972,
	22982 - 11904: 0xA969,
	22983 - 11904: 0xCC54,
	22984 - 11904: 0xCC52,
	22985 - 11904: 0xFBA6,
	22986 - 11904: 0xA96E,
	22987 - 11904: 0xA96C,
	22988 - 11904: 0xCC49,
	22989 - 11904: 0xA96B,
	22990 - 11904: 0xCC47,
	22991 - 11904: 0xCC46,
	22992 - 11904: 0xA96A,
	22993 - 11904: 0xA968,
	22994 - 11904: 0xA971,
	22995 - 11904: 0xA96D,
	22996 - 11904: 0xA965,
	22998 - 11904: 0xCC4E,
	23000 - 11904: 0xABB9,
	23001 - 11904: 0xFBAB,
	23002 - 11904: 0xABC0,
	23003 - 11904: 0xCE6F,
	23004 - 11904: 0xABB8,
	23005 - 11904: 0xCE67,
	23006 - 11904: 0xCE63,
	23008 - 11904: 0xCE73,
	23009 - 11904: 0xCE62,
	23011 - 11904: 0xABBB,
	23012 - 11904: 0xCE6C,
	23013 - 11904: 0xABBE,
	23014 - 11904: 0xABC1,
	23016 - 11904: 0xABBC,
	23017 - 11904: 0xCE70,
	23018 - 11904: 0xABBF,
	23019 - 11904: 0x9877,
	23020 - 11904: 0xAE56,
	23021 - 11904: 0xCE76,
	23022 - 11904: 0xCE64,
	23023 - 11904: 0x9854,
	23024 - 11904: 0x95C5,
	23025 - 11904: 0xCE66,
	23026 - 11904: 0xCE6D,
	23027 - 11904: 0xCE71,
	23028 - 11904: 0xCE75,
	23029 - 11904: 0xCE72,
	23030 - 11904: 0xCE6B,
	23031 - 11904: 0xCE6E,
	23032 - 11904: 0x9D55,
	23033 - 11904: 0xFBB2,
	23034 - 11904: 0xCE68,
	23035 - 11904: 0xABC3,
	23036 - 11904: 0xCE6A,
	23037 - 11904: 0xCE69,
	23038 - 11904: 0xCE74,
	23039 - 11904: 0xABBA,
	23040 - 11904: 0xCE65,
	23041 - 11904: 0xABC2,
	23042 - 11904: 0x957E,
	23043 - 11904: 0xABBD,
	23049 - 11904: 0xAE5C,
	23050 - 11904: 0xD162,
	23051 - 11904: 0x9742,
	23052 - 11904: 0xAE5B,
	23053 - 11904: 0x94E6,
	23055 - 11904: 0xD160,
	23057 - 11904: 0xAE50,
	23058 - 11904: 0x92F5,
	23059 - 11904: 0xAE55,
	23061 - 11904: 0xD15F,
	23062 - 11904: 0xD15C,
	23063 - 11904: 0xD161,
	23064 - 11904: 0xAE51,
	23065 - 11904: 0xD15B,
	23066 - 11904: 0x8CC5,
	23067 - 11904: 0xAE54,
	23068 - 11904: 0xAE52,
	23070 - 11904: 0xD163,
	23071 - 11904: 0xAE53,
	23072 - 11904: 0xAE57,
	23073 - 11904: 0x92FD,
	23075 - 11904: 0xAE58,
	23076 - 11904: 0xFBA2,
	23077 - 11904: 0xAE5A,
	23079 - 11904: 0x9C51,
	23081 - 11904: 0xAE59,
	23082 - 11904: 0x94E9,
	23083 - 11904: 0x985C,
	23084 - 11904: 0x92F0,
	23085 - 11904: 0xD15D,
	23086 - 11904: 0xD15E,
	23091 - 11904: 0xD164,
	23093 - 11904: 0xD4D4,
	23094 - 11904: 0xB0F9,
	23095 - 11904: 0xD8C2,
	23096 - 11904: 0xD4D3,
	23097 - 11904: 0xD4E6,
	23100 - 11904: 0xB140,
	23101 - 11904: 0x944C,
	23102 - 11904: 0xD4E4,
	23104 - 11904: 0xB0FE,
	23105 - 11904: 0xB0FA,
	23106 - 11904: 0xD4ED,
	23107 - 11904: 0xD4DD,
	23108 - 11904: 0xD4E0,
	23109 - 11904: 0x916B,
	23110 - 11904: 0xB143,
	23111 - 11904: 0xD4EA,
	23112 - 11904: 0xD4E2,
	23113 - 11904: 0xB0FB,
	23114 - 11904: 0xB144,
	23116 - 11904: 0xD4E7,
	23117 - 11904: 0xD4E5,
	23120 - 11904: 0xD4D6,
	23121 - 11904: 0xD4EB,
	23122 - 11904: 0xD4DF,
	23123 - 11904: 0xD4DA,
	23124 - 11904: 0x8B78,
	23125 - 11904: 0xD4D0,
	23126 - 11904: 0xD4EC,
	23127 - 11904: 0xD4DC,
	23128 - 11904: 0xD4CF,
	23129 - 11904: 0x94E2,
	23130 - 11904: 0xB142,
	23131 - 11904: 0xD4E1,
	23132 - 11904: 0xD4EE,
	23133 - 11904: 0xD4DE,
	23134 - 11904: 0xD4D2,
	23135 - 11904: 0xD4D7,
	23136 - 11904: 0xD4CE,
	23137 - 11904: 0x984F,
	23138 - 11904: 0xB141,
	23139 - 11904: 0xFBB5,
	23140 - 11904: 0xD4DB,
	23141 - 11904: 0xD4D8,
	23142 - 11904: 0xB0FC,
	23143 - 11904: 0xD4D1,
	23144 - 11904: 0x9271,
	23145 - 11904: 0xD4E9,
	23146 - 11904: 0xB0FD,
	23147 - 11904: 0x9365,
	23148 - 11904: 0xD4D9,
	23149 - 11904: 0xD4D5,
	23150 - 11904: 0x985B,
	23152 - 11904: 0xD4E8,
	23153 - 11904: 0x9850,
	23159 - 11904: 0xFBB8,
	23160 - 11904: 0xD8BB,
	23161 - 11904: 0x97BC,
	23162 - 11904: 0xD8B8,
	23163 - 11904: 0xD8C9,
	23164 - 11904: 0xD8BD,
	23165 - 11904: 0xD8CA,
	23166 - 11904: 0x92F3,
	23167 - 11904: 0xB442,
	23169 - 11904: 0x9340,
	23170 - 11904: 0x984D,
	23171 - 11904: 0xD8C6,
	23172 - 11904: 0xD8C3,
	23174 - 11904: 0x9572,
	23176 - 11904: 0xFDEF,
	23178 - 11904: 0xD8C4,
	23179 - 11904: 0xD8C7,
	23180 - 11904: 0xD8CB,
	23182 - 11904: 0xD4E3,
	23183 - 11904: 0xD8CD,
	23184 - 11904: 0xDD47,
	23185 - 11904: 0xFDC1,
	23186 - 11904: 0xB443,
	23187 - 11904: 0xD8CE,
	23188 - 11904: 0xD8B6,
	23189 - 11904: 0xD8C0,
	23190 - 11904: 0xFBBA,
	23191 - 11904: 0xD8C5,
	23193 - 11904: 0x92EB,
	23194 - 11904: 0xB441,
	23195 - 11904: 0xB444,
	23196 - 11904: 0xD8CC,
	23197 - 11904: 0xD8CF,
	23198 - 11904: 0xD8BA,
	23199 - 11904: 0xD8B7,
	23200 - 11904: 0xFC73,
	23201 - 11904: 0x97B7,
	23202 - 11904: 0xD8B9,
	23204 - 11904: 0x876F,
	23205 - 11904: 0xD8BE,
	23206 - 11904: 0xD8BC,
	23207 - 11904: 0xB445,
	23209 - 11904: 0xD8C8,
	23211 - 11904: 0xFBB4,
	23212 - 11904: 0xD8BF,
	23214 - 11904: 0xD8C1,
	23215 - 11904: 0xD8B5,
	23216 - 11904: 0xDCFA,
	23217 - 11904: 0xDCF8,
	23218 - 11904: 0xB742,
	23219 - 11904: 0xB740,
	23220 - 11904: 0xDD43,
	23221 - 11904: 0xDCF9,
	23222 - 11904: 0xDD44,
	23223 - 11904: 0xDD40,
	23224 - 11904: 0xDCF7,
	23225 - 11904: 0xDD46,
	23226 - 11904: 0xDCF6,
	23227 - 11904: 0xDCFD,
	23228 - 11904: 0xB6FE,
	23229 - 11904: 0xB6FD,
	23230 - 11904: 0xB6FC,
	23231 - 11904: 0xDCFB,
	23232 - 11904: 0xDD41,
	23233 - 11904: 0xB6F9,
	23234 - 11904: 0xB741,
	23235 - 11904: 0x90A7,
	23236 - 11904: 0xDCF4,
	23238 - 11904: 0xDCFE,
	23239 - 11904: 0xDCF3,
	23240 - 11904: 0xDCFC,
	23241 - 11904: 0xB6FA,
	23242 - 11904: 0xDD42,
	23243 - 11904: 0xDCF5,
	23244 - 11904: 0xB6FB,
	23245 - 11904: 0xDD45,
	23246 - 11904: 0x9741,
	23247 - 11904: 0x92F4,
	23249 - 11904: 0x8772,
	23251 - 11904: 0xFBBC,
	23253 - 11904: 0xE16E,
	23254 - 11904: 0xB9E2,
	23255 - 11904: 0xB9E1,
	23256 - 11904: 0xB9E3,
	23257 - 11904: 0xE17A,
	23258 - 11904: 0xE170,
	23259 - 11904: 0xE176,
	23260 - 11904: 0xE16B,
	23261 - 11904: 0xE179,
	23262 - 11904: 0xE178,
	23263 - 11904: 0xE17C,
	23264 - 11904: 0xE175,
	23265 - 11904: 0xB9DE,
	23266 - 11904: 0xE174,
	23267 - 11904: 0xB9E4,
	23268 - 11904: 0x9577,
	23269 - 11904: 0xE16D,
	23270 - 11904: 0xB9DF,
	23272 - 11904: 0xE17B,
	23273 - 11904: 0xB9E0,
	23274 - 11904: 0xE16F,
	23275 - 11904: 0xE172,
	23276 - 11904: 0xE177,
	23277 - 11904: 0xE171,
	23278 - 11904: 0xE16C,
	23280 - 11904: 0x9EE2,
	23282 - 11904: 0x8F78,
	23283 - 11904: 0xE173,
	23284 - 11904: 0xE555,
	23285 - 11904: 0xBC61,
	23286 - 11904: 0xE558,
	23287 - 11904: 0xE557,
	23288 - 11904: 0xE55A,
	23289 - 11904: 0xE55C,
	23290 - 11904: 0xF9DC,
	23291 - 11904: 0xBC5F,
	23293 - 11904: 0xE556,
	23294 - 11904: 0x9672,
	23295 - 11904: 0xE554,
	23297 - 11904: 0xE55D,
	23298 - 11904: 0xE55B,
	23299 - 11904: 0xE559,
	23301 - 11904: 0xE55F,
	23303 - 11904: 0xE55E,
	23304 - 11904: 0xBC63,
	23305 - 11904: 0xBC5E,
	23307 - 11904: 0xBC60,
	23308 - 11904: 0xBC62,
	23309 - 11904: 0x9EB5,
	23311 - 11904: 0xE560,
	23312 - 11904: 0xE957,
	23313 - 11904: 0x964B,
	23315 - 11904: 0xE956,
	23316 - 11904: 0xE955,
	23317 - 11904: 0x8CAC,
	23318 - 11904: 0xE958,
	23319 - 11904: 0xE951,
	23321 - 11904: 0xE952,
	23322 - 11904: 0xE95A,
	23323 - 11904: 0xE953,
	23325 - 11904: 0xBEC5,
	23326 - 11904: 0xE95C,
	23327 - 11904: 0xA0FA,
	23328 - 11904: 0xE95B,
	23329 - 11904: 0xE954,
	23331 - 11904: 0xECD1,
	23332 - 11904: 0xC0A8,
	23333 - 11904: 0xECCF,
	23334 - 11904: 0xECD4,
	23335 - 11904: 0xECD3,
	23336 - 11904: 0xE959,
	23338 - 11904: 0xC0A7,
	23339 - 11904: 0x9575,
	23340 - 11904: 0xECD2,
	23341 - 11904: 0xECCE,
	23342 - 11904: 0xECD6,
	23343 - 11904: 0xECD5,
	23344 - 11904: 0xC0A6,
	23346 - 11904: 0xECD0,
	23348 - 11904: 0xBEC6,
	23352 - 11904: 0xC254,
	23356 - 11904: 0xEFC1,
	23357 - 11904: 0xF1FA,
	23358 - 11904: 0xF1FB,
	23359 - 11904: 0xF1FC,
	23360 - 11904: 0xC45C,
	23361 - 11904: 0x90DA,
	23363 - 11904: 0xC45D,
	23364 - 11904: 0x9367,
	23365 - 11904: 0xF443,
	23366 - 11904: 0xFEA4,
	23367 - 11904: 0xF5C8,
	23368 - 11904: 0xF5C7,
	23370 - 11904: 0x90DF,
	23371 - 11904: 0xF6DB,
	23372 - 11904: 0xF6DC,
	23373 - 11904: 0xF7D5,
	23374 - 11904: 0xF8A7,
	23375 - 11904: 0x9354,
	23376 - 11904: 0xA46C,
	23377 - 11904: 0xA46D,
	23379 - 11904: 0xA46E,
	23380 - 11904: 0xA4D5,
	23381 - 11904: 0xA5A5,
	23382 - 11904: 0xC9D3,
	23383 - 11904: 0xA672,
	23384 - 11904: 0xA673,
	23386 - 11904: 0xA7B7,
	23387 - 11904: 0xA7B8,
	23388 - 11904: 0xA7B6,
	23389 - 11904: 0xA7B5,
	23391 - 11904: 0xA973,
	23394 - 11904: 0xCC55,
	23395 - 11904: 0xA975,
	23396 - 11904: 0xA974,
	23397 - 11904: 0xCC56,
	23398 - 11904: 0x8961,
	23400 - 11904: 0x8BB4,
	23401 - 11904: 0xABC4,
	23403 - 11904: 0xAE5D,
	23404 - 11904: 0xD165,
	23405 - 11904: 0x9DC0,
	23406 - 11904: 0xD4F0,
	23408 - 11904: 0xB145,
	23409 - 11904: 0xB447,
	23410 - 11904: 0xD4EF,
	23411 - 11904: 0xB446,
	23412 - 11904: 0x8E48,
	23413 - 11904: 0xB9E5,
	23414 - 11904: 0xFBC5,
	23415 - 11904: 0xE17D,
	23416 - 11904: 0xBEC7,
	23418 - 11904: 0xC0A9,
	23419 - 11904: 0xECD7,
	23420 - 11904: 0xFBC7,
	23421 - 11904: 0xC45E,
	23423 - 11904: 0xC570,
	23424 - 11904: 0xC6CB,
	23425 - 11904: 0xC972,
	23426 - 11904: 0xFA79,
	23427 - 11904: 0xA5A6,
	23428 - 11904: 0xC973,
	23429 - 11904: 0xA676,
	23431 - 11904: 0xA674,
	23432 - 11904: 0xA675,
	23433 - 11904: 0xA677,
	23435 - 11904: 0xA7BA,
	23436 - 11904: 0xA7B9,
	23438 - 11904: 0xCABC,
	23439 - 11904: 0xA7BB,
	23440 - 11904: 0x9E67,
	23442 - 11904: 0xCABD,
	23443 - 11904: 0xCC57,
	23445 - 11904: 0xCC58,
	23446 - 11904: 0x8CD9,
	23447 - 11904: 0xA976,
	23448 - 11904: 0xA978,
	23449 - 11904: 0xA97A,
	23450 - 11904: 0xA977,
	23451 - 11904: 0xA97B,
	23452 - 11904: 0xA979,
	23453 - 11904: 0xFBD2,
	23454 - 11904: 0x8962,
	23455 - 11904: 0x8963,
	23458 - 11904: 0xABC8,
	23459 - 11904: 0xABC5,
	23460 - 11904: 0xABC7,
	23461 - 11904: 0xABC9,
	23462 - 11904: 0xABC6,
	23463 - 11904: 0xD166,
	23464 - 11904: 0xCE77,
	23466 - 11904: 0xFC7D,
	23468 - 11904: 0xD168,
	23469 - 11904: 0xD167,
	23470 - 11904: 0xAE63,
	23472 - 11904: 0xAE5F,
	23475 - 11904: 0xAE60,
	23476 - 11904: 0xAE62,
	23477 - 11904: 0xAE64,
	23478 - 11904: 0xAE61,
	23479 - 11904: 0x8773,
	23480 - 11904: 0xAE66,
	23481 - 11904: 0xAE65,
	23487 - 11904: 0xB14A,
	23488 - 11904: 0xD4F2,
	23489 - 11904: 0xD4F1,
	23490 - 11904: 0xB149,
	23491 - 11904: 0x9F6B,
	23492 - 11904: 0xB148,
	23493 - 11904: 0xB147,
	23494 - 11904: 0xB14B,
	23495 - 11904: 0xB146,
	23498 - 11904: 0xD8D5,
	23499 - 11904: 0xD8D2,
	23500 - 11904: 0xB449,
	23501 - 11904: 0xD8D1,
	23502 - 11904: 0xD8D6,
	23504 - 11904: 0xB44B,
	23505 - 11904: 0xD8D4,
	23506 - 11904: 0xB448,
	23507 - 11904: 0xB44A,
	23508 - 11904: 0xD8D3,
	23509 - 11904: 0xFBCC,
	23510 - 11904: 0xDD48,
	23511 - 11904: 0xFEAE,
	23512 - 11904: 0xDD49,
	23513 - 11904: 0xDD4A,
	23515 - 11904: 0x876D,
	23518 - 11904: 0xB9E6,
	23519 - 11904: 0xB9EE,
	23520 - 11904: 0xE17E,
	23521 - 11904: 0xB9E8,
	23522 - 11904: 0xB9EC,
	23523 - 11904: 0xE1A1,
	23524 - 11904: 0xB9ED,
	23525 - 11904: 0xB9E9,
	23526 - 11904: 0xB9EA,
	23527 - 11904: 0xB9E7,
	23528 - 11904: 0xB9EB,
	23529 - 11904: 0xBC66,
	23530 - 11904: 0xD8D0,
	23531 - 11904: 0xBC67,
	23532 - 11904: 0xBC65,
	23534 - 11904: 0xBC64,
	23535 - 11904: 0xE95D,
	23536 - 11904: 0xBEC8,
	23537 - 11904: 0xECD8,
	23538 - 11904: 0xECD9,
	23539 - 11904: 0xFBD1,
	23541 - 11904: 0xC364,
	23542 - 11904: 0xC45F,
	23544 - 11904: 0xA46F,
	23546 - 11904: 0xA678,
	23551 - 11904: 0xFB75,
	23553 - 11904: 0xABCA,
	23555 - 11904: 0xD169,
	23556 - 11904: 0xAE67,
	23557 - 11904: 0xFBD4,
	23559 - 11904: 0xB14E,
	23560 - 11904: 0xB14D,
	23561 - 11904: 0xB14C,
	23562 - 11904: 0xB44C,
	23563 - 11904: 0xB44D,
	23564 - 11904: 0xD8D7,
	23565 - 11904: 0xB9EF,
	23566 - 11904: 0xBEC9,
	23567 - 11904: 0xA470,
	23568 - 11904: 0xC95C,
	23569 - 11904: 0xA4D6,
	23570 - 11904: 0xC974,
	23571 - 11904: 0xFBD6,
	23572 - 11904: 0xFBD8,
	23573 - 11904: 0xC9D4,
	23574 - 11904: 0xA679,
	23578 - 11904: 0xA97C,
	23580 - 11904: 0x8B5D,
	23582 - 11904: 0x934C,
	23583 - 11904: 0xDD4B,
	23584 - 11904: 0x9AE2,
	23586 - 11904: 0xA471,
	23587 - 11904: 0x8BC9,
	23588 - 11904: 0xA4D7,
	23589 - 11904: 0xC9D5,
	23592 - 11904: 0xCABE,
	23594 - 11904: 0xCABF,
	23596 - 11904: 0xA7BC,
	23600 - 11904: 0xD8D8,
	23601 - 11904: 0xB44E,
	23603 - 11904: 0xDD4C,
	23607 - 11904: 0xC0AA,
	23608 - 11904: 0xA472,
	23609 - 11904: 0xA4A8,
	23610 - 11904: 0xA4D8,
	23611 - 11904: 0xC975,
	23612 - 11904: 0xA5A7,
	23614 - 11904: 0xA7C0,
	23615 - 11904: 0xA7BF,
	23616 - 11904: 0xA7BD,
	23617 - 11904: 0xA7BE,
	23620 - 11904: 0xCC59,
	23621 - 11904: 0xA97E,
	23622 - 11904: 0xA9A1,
	23623 - 11904: 0xCC5A,
	23624 - 11904: 0xA97D,
	23625 - 11904: 0xFBDB,
	23626 - 11904: 0x9FC9,
	23627 - 11904: 0xABCE,
	23628 - 11904: 0xCE78,
	23629 - 11904: 0xABCD,
	23630 - 11904: 0xABCB,
	23631 - 11904: 0xABCC,
	23632 - 11904: 0xAE6A,
	23633 - 11904: 0xAE68,
	23635 - 11904: 0x9F44,
	23636 - 11904: 0xD16B,
	23637 - 11904: 0xAE69,
	23638 - 11904: 0xD16A,
	23640 - 11904: 0xAE5E,
	23641 - 11904: 0xD4F3,
	23644 - 11904: 0xB150,
	23645 - 11904: 0xB151,
	23646 - 11904: 0x98ED,
	23648 - 11904: 0xB14F,
	23650 - 11904: 0xB9F0,
	23651 - 11904: 0xE1A2,
	23652 - 11904: 0xBC68,
	23653 - 11904: 0xBC69,
	23655 - 11904: 0xE561,
	23656 - 11904: 0xC0AB,
	23657 - 11904: 0xEFC2,
	23658 - 11904: 0xEFC3,
	23660 - 11904: 0xC4DD,
	23661 - 11904: 0xF8A8,
	23662 - 11904: 0xC94B,
	23663 - 11904: 0xA4D9,
	23665 - 11904: 0xA473,
	23667 - 11904: 0xC977,
	23668 - 11904: 0xC976,
	23672 - 11904: 0x8CE9,
	23673 - 11904: 0xA67A,
	23674 - 11904: 0xC9D7,
	23675 - 11904: 0xC9D8,
	23676 - 11904: 0xC9D6,
	23678 - 11904: 0xC9D9,
	23685 - 11904: 0xFBDD,
	23686 - 11904: 0xCAC7,
	23688 - 11904: 0xCAC2,
	23689 - 11904: 0xCAC4,
	23690 - 11904: 0xCAC6,
	23691 - 11904: 0xCAC3,
	23692 - 11904: 0xA7C4,
	23693 - 11904: 0xCAC0,
	23695 - 11904: 0xCAC1,
	23696 - 11904: 0xA7C1,
	23697 - 11904: 0xA7C2,
	23698 - 11904: 0xCAC5,
	23699 - 11904: 0xCAC8,
	23700 - 11904: 0xA7C3,
	23701 - 11904: 0xCAC9,
	23705 - 11904: 0x8DF2,
	23706 - 11904: 0x8964,
	23708 - 11904: 0xFDF2,
	23709 - 11904: 0xCC68,
	23710 - 11904: 0x934D,
	23711 - 11904: 0xCC62,
	23712 - 11904: 0xCC5D,
	23713 - 11904: 0xA9A3,
	23714 - 11904: 0xCC65,
	23715 - 11904: 0xCC63,
	23716 - 11904: 0xCC5C,
	23717 - 11904: 0xCC69,
	23718 - 11904: 0xCC6C,
	23719 - 11904: 0xCC67,
	23720 - 11904: 0xCC60,
	23721 - 11904: 0xA9A5,
	23722 - 11904: 0xCC66,
	23723 - 11904: 0xA9A6,
	23724 - 11904: 0xCC61,
	23725 - 11904: 0xCC64,
	23726 - 11904: 0xCC5B,
	23727 - 11904: 0xCC5F,
	23728 - 11904: 0xCC6B,
	23729 - 11904: 0xA9A7,
	23731 - 11904: 0xA9A8,
	23733 - 11904: 0xCC5E,
	23734 - 11904: 0xCC6A,
	23735 - 11904: 0xA9A2,
	23736 - 11904: 0xA9A4,
	23738 - 11904: 0xFBE7,
	23745 - 11904: 0xA0F2,
	23746 - 11904: 0x9868,
	23750 - 11904: 0xCEAB,
	23751 - 11904: 0xCEA4,
	23752 - 11904: 0xCEAA,
	23753 - 11904: 0xCEA3,
	23754 - 11904: 0xCEA5,
	23755 - 11904: 0xCE7D,
	23756 - 11904: 0xCE7B,
	23758 - 11904: 0xCEAC,
	23759 - 11904: 0xCEA9,
	23760 - 11904: 0xCE79,
	23761 - 11904: 0x9F58,
	23762 - 11904: 0xABD0,
	23763 - 11904: 0xCEA7,
	23764 - 11904: 0xCEA8,
	23765 - 11904: 0x8CE6,
	23766 - 11904: 0xCEA6,
	23767 - 11904: 0xCE7C,
	23768 - 11904: 0xCE7A,
	23769 - 11904: 0xABCF,
	23770 - 11904: 0xCEA2,
	23771 - 11904: 0xCE7E,
	23774 - 11904: 0xCEA1,
	23775 - 11904: 0xCEAD,
	23781 - 11904: 0x8D73,
	23784 - 11904: 0xAE6F,
	23785 - 11904: 0xFBDE,
	23786 - 11904: 0xAE6E,
	23788 - 11904: 0xD16C,
	23789 - 11904: 0xAE6B,
	23790 - 11904: 0xD16E,
	23791 - 11904: 0xFBDF,
	23792 - 11904: 0xAE70,
	23793 - 11904: 0xD16F,
	23796 - 11904: 0xAE73,
	23797 - 11904: 0x8C48,
	23798 - 11904: 0xAE71,
	23799 - 11904: 0xD170,
	23800 - 11904: 0xCEAE,
	23801 - 11904: 0xD172,
	23803 - 11904: 0xAE6D,
	23804 - 11904: 0x8774,
	23805 - 11904: 0xAE6C,
	23807 - 11904: 0xD16D,
	23808 - 11904: 0xD171,
	23809 - 11904: 0xAE72,
	23814 - 11904: 0xB153,
	23815 - 11904: 0xB152,
	23819 - 11904: 0xD4F5,
	23820 - 11904: 0xD4F9,
	23821 - 11904: 0xD4FB,
	23822 - 11904: 0xB154,
	23823 - 11904: 0xD4FE,
	23824 - 11904: 0xFBE3,
	23825 - 11904: 0xB158,
	23826 - 11904: 0xD541,
	23828 - 11904: 0xB15A,
	23829 - 11904: 0x8DA8,
	23830 - 11904: 0xB156,
	23831 - 11904: 0xB15E,
	23832 - 11904: 0xFBE4,
	23833 - 11904: 0xB15B,
	23834 - 11904: 0xD4F7,
	23835 - 11904: 0xB155,
	23837 - 11904: 0xD4F6,
	23838 - 11904: 0xD4F4,
	23839 - 11904: 0xD543,
	23840 - 11904: 0xD4F8,
	23842 - 11904: 0xB157,
	23843 - 11904: 0xD542,
	23844 - 11904: 0xB15C,
	23845 - 11904: 0xD4FD,
	23846 - 11904: 0xD4FC,
	23847 - 11904: 0xB15D,
	23848 - 11904: 0xD4FA,
	23849 - 11904: 0xB159,
	23852 - 11904: 0x9C75,
	23854 - 11904: 0xD544,
	23855 - 11904: 0x9878,
	23856 - 11904: 0xD540,
	23857 - 11904: 0xD8E7,
	23858 - 11904: 0xD8EE,
	23859 - 11904: 0xD8E3,
	23860 - 11904: 0xB451,
	23861 - 11904: 0xD8DF,
	23862 - 11904: 0xD8EF,
	23863 - 11904: 0xD8D9,
	23864 - 11904: 0xD8EC,
	23865 - 11904: 0xD8EA,
	23866 - 11904: 0xD8E4,
	23868 - 11904: 0xD8ED,
	23869 - 11904: 0xD8E6,
	23870 - 11904: 0x8D60,
	23871 - 11904: 0xD8DE,
	23872 - 11904: 0xD8F0,
	23873 - 11904: 0xD8DC,
	23874 - 11904: 0xD8E9,
	23875 - 11904: 0xD8DA,
	23877 - 11904: 0xD8F1,
	23878 - 11904: 0xFBE5,
	23879 - 11904: 0xB452,
	23880 - 11904: 0x8D61,
	23881 - 11904: 0xD8EB,
	23882 - 11904: 0xDD4F,
	23883 - 11904: 0xD8DD,
	23884 - 11904: 0xB44F,
	23886 - 11904: 0xD8E1,
	23888 - 11904: 0xB450,
	23889 - 11904: 0xD8E0,
	23890 - 11904: 0xD8E5,
	23893 - 11904: 0xD8E2,
	23894 - 11904: 0x8D62,
	23895 - 11904: 0xA0A1,
	23897 - 11904: 0xD8E8,
	23899 - 11904: 0x9C40,
	23902 - 11904: 0xDD53,
	23906 - 11904: 0xDD56,
	23907 - 11904: 0xDD4E,
	23909 - 11904: 0xDD50,
	23911 - 11904: 0xDD55,
	23912 - 11904: 0xDD54,
	23913 - 11904: 0xB743,
	23915 - 11904: 0xD8DB,
	23916 - 11904: 0xDD52,
	23919 - 11904: 0xB744,
	23920 - 11904: 0x98AD,
	23921 - 11904: 0xDD4D,
	23922 - 11904: 0xDD51,
	23924 - 11904: 0x9EEA,
	23927 - 11904: 0xE1A9,
	23928 - 11904: 0x8CEC,
	23929 - 11904: 0xE1B0,
	23930 - 11904: 0xE1A7,
	23931 - 11904: 0x8CD4,
	23932 - 11904: 0xE1AE,
	23933 - 11904: 0xE1A5,
	23934 - 11904: 0xE1AD,
	23935 - 11904: 0xE1B1,
	23936 - 11904: 0xE1A4,
	23937 - 11904: 0xE1A8,
	23938 - 11904: 0xE1A3,
	23940 - 11904: 0xB9F1,
	23941 - 11904: 0x9CEB,
	23942 - 11904: 0xE1A6,
	23943 - 11904: 0xB9F2,
	23944 - 11904: 0xE1AC,
	23945 - 11904: 0xE1AB,
	23946 - 11904: 0xE1AA,
	23947 - 11904: 0xFBE0,
	23949 - 11904: 0xE1AF,
	23950 - 11904: 0x9F51,
	23954 - 11904: 0xE565,
	23955 - 11904: 0xE567,
	23956 - 11904: 0xBC6B,
	23957 - 11904: 0xE568,
	23959 - 11904: 0xE563,
	23961 - 11904: 0xE562,
	23962 - 11904: 0xE56C,
	23964 - 11904: 0xE56A,
	23965 - 11904: 0xBC6A,
	23966 - 11904: 0xE56D,
	23967 - 11904: 0xE564,
	23968 - 11904: 0xE569,
	23969 - 11904: 0xE56B,
	23970 - 11904: 0xE566,
	23972 - 11904: 0x8D65,
	23975 - 11904: 0xE961,
	23976 - 11904: 0xE966,
	23977 - 11904: 0xE960,
	23978 - 11904: 0xE965,
	23979 - 11904: 0x9CF1,
	23980 - 11904: 0xE95E,
	23981 - 11904: 0xE968,
	23982 - 11904: 0xE964,
	23983 - 11904: 0xE969,
	23984 - 11904: 0xE963,
	23985 - 11904: 0xE95F,
	23986 - 11904: 0xE967,
	23988 - 11904: 0xE96A,
	23989 - 11904: 0xE962,
	23990 - 11904: 0xFC58,
	23991 - 11904: 0xECDA,
	23992 - 11904: 0xC0AF,
	23993 - 11904: 0x8D66,
	23994 - 11904: 0xC0AD,
	23996 - 11904: 0xC0AC,
	23997 - 11904: 0xC0AE,
	24000 - 11904: 0xEFC4,
	24001 - 11904: 0x9654,
	24002 - 11904: 0xF172,
	24003 - 11904: 0xF1FD,
	24006 - 11904: 0xF444,
	24007 - 11904: 0xF445,
	24009 - 11904: 0xC460,
	24011 - 11904: 0xF5C9,
	24013 - 11904: 0xC4DE,
	24015 - 11904: 0xF5CA,
	24017 - 11904: 0xF6DE,
	24018 - 11904: 0xC572,
	24020 - 11904: 0xC571,
	24021 - 11904: 0xF6DD,
	24022 - 11904: 0xC5C9,
	24023 - 11904: 0xFBE8,
	24024 - 11904: 0xF7D6,
	24027 - 11904: 0xC6CC,
	24029 - 11904: 0xA474,
	24030 - 11904: 0xA67B,
	24031 - 11904: 0xC9DA,
	24032 - 11904: 0xCACA,
	24033 - 11904: 0xA8B5,
	24034 - 11904: 0xB15F,
	24037 - 11904: 0xA475,
	24038 - 11904: 0xA5AA,
	24039 - 11904: 0xA5A9,
	24040 - 11904: 0xA5A8,
	24043 - 11904: 0xA7C5,
	24046 - 11904: 0xAE74,
	24048 - 11904: 0xDD57,
	24049 - 11904: 0xA476,
	24050 - 11904: 0xA477,
	24051 - 11904: 0xA478,
	24052 - 11904: 0xA4DA,
	24053 - 11904: 0x9FCE,
	24055 - 11904: 0xABD1,
	24057 - 11904: 0xCEAF,
	24061 - 11904: 0xB453,
	24062 - 11904: 0xA479,
	24063 - 11904: 0xC95D,
	24066 - 11904: 0xA5AB,
	24067 - 11904: 0xA5AC,
	24068 - 11904: 0xC978,
	24070 - 11904: 0xA67C,
	24073 - 11904: 0xFBFC,
	24074 - 11904: 0xCACB,
	24075 - 11904: 0x9AE4,
	24076 - 11904: 0xA7C6,
	24078 - 11904: 0xCACC,
	24081 - 11904: 0xA9AE,
	24082 - 11904: 0x9F75,
	24084 - 11904: 0xCC6E,
	24085 - 11904: 0xA9AC,
	24086 - 11904: 0xA9AB,
	24087 - 11904: 0xCC6D,
	24088 - 11904: 0xA9A9,
	24089 - 11904: 0xCC6F,
	24090 - 11904: 0xA9AA,
	24091 - 11904: 0xA9AD,
	24093 - 11904: 0xABD2,
	24095 - 11904: 0xABD4,
	24096 - 11904: 0xCEB3,
	24097 - 11904: 0xCEB0,
	24098 - 11904: 0xCEB1,
	24099 - 11904: 0xCEB2,
	24100 - 11904: 0xCEB4,
	24101 - 11904: 0xABD3,
	24104 - 11904: 0xD174,
	24105 - 11904: 0xD173,
	24107 - 11904: 0xAE76,
	24109 - 11904: 0xAE75,
	24110 - 11904: 0xFBF1,
	24115 - 11904: 0xB162,
	24116 - 11904: 0xD546,
	24118 - 11904: 0xB161,
	24119 - 11904: 0xB163,
	24120 - 11904: 0xB160,
	24125 - 11904: 0xB455,
	24126 - 11904: 0xD545,
	24128 - 11904: 0xB456,
	24129 - 11904: 0xD8F3,
	24130 - 11904: 0x8D69,
	24131 - 11904: 0xB457,
	24132 - 11904: 0xD8F2,
	24133 - 11904: 0xB454,
	24136 - 11904: 0x934F,
	24138 - 11904: 0xDD5A,
	24139 - 11904: 0xDD5C,
	24140 - 11904: 0xB745,
	24141 - 11904: 0xDD5B,
	24142 - 11904: 0xDD59,
	24143 - 11904: 0xDD58,
	24147 - 11904: 0xE1B4,
	24148 - 11904: 0xB9F7,
	24149 - 11904: 0xB9F5,
	24151 - 11904: 0xB9F6,
	24152 - 11904: 0xE1B2,
	24153 - 11904: 0xE1B3,
	24155 - 11904: 0xB9F3,
	24156 - 11904: 0xE571,
	24157 - 11904: 0xE56F,
	24158 - 11904: 0x934E,
	24159 - 11904: 0xBC6D,
	24160 - 11904: 0xE570,
	24161 - 11904: 0xBC6E,
	24162 - 11904: 0xBC6C,
	24163 - 11904: 0xB9F4,
	24166 - 11904: 0xE96D,
	24167 - 11904: 0xE96B,
	24168 - 11904: 0xE96C,
	24169 - 11904: 0xE56E,
	24170 - 11904: 0xECDC,
	24171 - 11904: 0xC0B0,
	24172 - 11904: 0xECDB,
	24173 - 11904: 0xEFC5,
	24174 - 11904: 0xEFC6,
	24175 - 11904: 0xE96E,
	24176 - 11904: 0xF1FE,
	24178 - 11904: 0xA47A,
	24179 - 11904: 0xA5AD,
	24180 - 11904: 0xA67E,
	24181 - 11904: 0xFBF3,
	24182 - 11904: 0xA67D,
	24184 - 11904: 0xA9AF,
	24185 - 11904: 0xB746,
	24186 - 11904: 0xFBF4,
	24187 - 11904: 0xA4DB,
	24188 - 11904: 0xA5AE,
	24189 - 11904: 0xABD5,
	24190 - 11904: 0xB458,
	24191 - 11904: 0xC6CE,
	24192 - 11904: 0xC979,
	24194 - 11904: 0xC97A,
	24195 - 11904: 0xFBC3,
	24196 - 11904: 0xC9DC,
	24198 - 11904: 0x8965,
	24199 - 11904: 0xA7C8,
	24200 - 11904: 0xCAD0,
	24201 - 11904: 0xCACE,
	24202 - 11904: 0xA7C9,
	24203 - 11904: 0xCACD,
	24204 - 11904: 0xCACF,
	24205 - 11904: 0xCAD1,
	24207 - 11904: 0xA7C7,
	24210 - 11904: 0x8C7A,
	24213 - 11904: 0xA9B3,
	24214 - 11904: 0xA9B4,
	24215 - 11904: 0xA9B1,
	24217 - 11904: 0x8C7B,
	24218 - 11904: 0xA9B0,
	24219 - 11904: 0xCEB8,
	24220 - 11904: 0xA9B2,
	24224 - 11904: 0xABD6,
	24226 - 11904: 0xCEB7,
	24227 - 11904: 0xCEB9,
	24228 - 11904: 0xCEB6,
	24229 - 11904: 0xCEBA,
	24230 - 11904: 0xABD7,
	24231 - 11904: 0xAE79,
	24232 - 11904: 0xD175,
	24234 - 11904: 0xD177,
	24235 - 11904: 0xAE77,
	24236 - 11904: 0xD178,
	24237 - 11904: 0xAE78,
	24238 - 11904: 0xD176,
	24240 - 11904: 0xCEB5,
	24241 - 11904: 0xD547,
	24242 - 11904: 0xD54A,
	24243 - 11904: 0xD54B,
	24244 - 11904: 0xD548,
	24245 - 11904: 0xB167,
	24246 - 11904: 0xB166,
	24247 - 11904: 0xB164,
	24248 - 11904: 0xB165,
	24249 - 11904: 0xD549,
	24253 - 11904: 0x8D6A,
	24254 - 11904: 0xB168,
	24257 - 11904: 0xB45A,
	24258 - 11904: 0xB45B,
	24260 - 11904: 0xB45C,
	24261 - 11904: 0xDD5D,
	24262 - 11904: 0xDD5F,
	24263 - 11904: 0xDD61,
	24264 - 11904: 0xB748,
	24265 - 11904: 0xB747,
	24266 - 11904: 0xB459,
	24267 - 11904: 0xDD60,
	24268 - 11904: 0xDD5E,
	24269 - 11904: 0x9353,
	24270 - 11904: 0xE1B8,
	24272 - 11904: 0xFBF9,
	24273 - 11904: 0xE1B6,
	24274 - 11904: 0xE1BC,
	24275 - 11904: 0xB9F8,
	24276 - 11904: 0xE1BD,
	24277 - 11904: 0xE1BA,
	24278 - 11904: 0xB9F9,
	24279 - 11904: 0xE1B7,
	24280 - 11904: 0xE1B5,
	24281 - 11904: 0xE1BB,
	24282 - 11904: 0xBC70,
	24283 - 11904: 0xE573,
	24284 - 11904: 0xE1B9,
	24285 - 11904: 0xBC72,
	24286 - 11904: 0xE574,
	24287 - 11904: 0xBC71,
	24288 - 11904: 0xBC74,
	24289 - 11904: 0xE575,
	24290 - 11904: 0xBC6F,
	24291 - 11904: 0xBC73,
	24293 - 11904: 0xE973,
	24294 - 11904: 0xE971,
	24295 - 11904: 0xE970,
	24296 - 11904: 0xE972,
	24297 - 11904: 0xE96F,
	24300 - 11904: 0xC366,
	24302 - 11904: 0xF446,
	24303 - 11904: 0xF447,
	24305 - 11904: 0xF5CB,
	24306 - 11904: 0xF6DF,
	24307 - 11904: 0xC655,
	24308 - 11904: 0xFBFD,
	24310 - 11904: 0xA9B5,
	24311 - 11904: 0xA7CA,
	24312 - 11904: 0x9059,
	24313 - 11904: 0xFC40,
	24314 - 11904: 0xABD8,
	24315 - 11904: 0xFC41,
	24316 - 11904: 0xFC43,
	24318 - 11904: 0xA47B,
	24319 - 11904: 0xA4DC,
	24321 - 11904: 0xA5AF,
	24322 - 11904: 0xC9DD,
	24324 - 11904: 0xA7CB,
	24325 - 11904: 0xCAD2,
	24327 - 11904: 0xCEBB,
	24328 - 11904: 0xABD9,
	24330 - 11904: 0xB9FA,
	24331 - 11904: 0xA47C,
	24332 - 11904: 0x9FD8,
	24333 - 11904: 0xFC46,
	24334 - 11904: 0x9362,
	24335 - 11904: 0xA6A1,
	24338 - 11904: 0xB749,
	24339 - 11904: 0xA47D,
	24340 - 11904: 0xA4DD,
	24341 - 11904: 0xA4DE,
	24343 - 11904: 0xA5B1,
	24344 - 11904: 0xA5B0,
	24346 - 11904: 0xC9DE,
	24347 - 11904: 0xA6A2,
	24349 - 11904: 0xCAD3,
	24351 - 11904: 0xA7CC,
	24354 - 11904: 0xCC71,
	24355 - 11904: 0xCC72,
	24356 - 11904: 0xCC73,
	24357 - 11904: 0x8D6B,
	24358 - 11904: 0xA9B6,
	24359 - 11904: 0xA9B7,
	24360 - 11904: 0xCC70,
	24361 - 11904: 0xA9B8,
	24365 - 11904: 0xABDA,
	24366 - 11904: 0xCEBC,
	24368 - 11904: 0xD17A,
	24369 - 11904: 0xAE7A,
	24371 - 11904: 0xD179,
	24373 - 11904: 0xB169,
	24374 - 11904: 0xD54C,
	24375 - 11904: 0xB16A,
	24376 - 11904: 0xD54D,
	24378 - 11904: 0xFC4C,
	24379 - 11904: 0x8CFE,
	24380 - 11904: 0xB45D,
	24384 - 11904: 0xDD62,
	24387 - 11904: 0xE1BF,
	24388 - 11904: 0xE1BE,
	24390 - 11904: 0xB9FB,
	24392 - 11904: 0xBC75,
	24393 - 11904: 0xE576,
	24394 - 11904: 0xBECA,
	24395 - 11904: 0xE974,
	24396 - 11904: 0xC0B1,
	24397 - 11904: 0x95B8,
	24398 - 11904: 0xC573,
	24399 - 11904: 0xF7D8,
	24400 - 11904: 0xC6D0,
	24401 - 11904: 0x8BCA,
	24404 - 11904: 0xCC74,
	24406 - 11904: 0xCEBD,
	24407 - 11904: 0xB16B,
	24408 - 11904: 0xFC4F,
	24409 - 11904: 0xB74A,
	24412 - 11904: 0x987A,
	24413 - 11904: 0xC255,
	24417 - 11904: 0xC6D1,
	24418 - 11904: 0xA7CE,
	24419 - 11904: 0xFC51,
	24420 - 11904: 0xA7CD,
	24421 - 11904: 0xABDB,
	24423 - 11904: 0xD17B,
	24425 - 11904: 0xB16D,
	24426 - 11904: 0xB343,
	24427 - 11904: 0xB16E,
	24428 - 11904: 0xB16C,
	24429 - 11904: 0xB45E,
	24431 - 11904: 0xE1C0,
	24432 - 11904: 0xB9FC,
	24433 - 11904: 0xBC76,
	24434 - 11904: 0xFC54,
	24435 - 11904: 0xC94C,
	24436 - 11904: 0xC9DF,
	24438 - 11904: 0xCAD5,
	24439 - 11904: 0xA7CF,
	24440 - 11904: 0xCAD4,
	24441 - 11904: 0xA7D0,
	24443 - 11904: 0xFAAF,
	24444 - 11904: 0xA9BC,
	24445 - 11904: 0xCC77,
	24446 - 11904: 0xCC76,
	24447 - 11904: 0xA9BB,
	24448 - 11904: 0xA9B9,
	24449 - 11904: 0xA9BA,
	24450 - 11904: 0xCC75,
	24451 - 11904: 0x8D6C,
	24453 - 11904: 0xABDD,
	24454 - 11904: 0xCEBE,
	24455 - 11904: 0xABE0,
	24456 - 11904: 0xABDC,
	24457 - 11904: 0xABE2,
	24458 - 11904: 0xABDE,
	24459 - 11904: 0xABDF,
	24460 - 11904: 0xABE1,
	24464 - 11904: 0xAE7D,
	24465 - 11904: 0xAE7C,
	24466 - 11904: 0xAE7B,
	24470 - 11904: 0xD54F,
	24471 - 11904: 0xB16F,
	24472 - 11904: 0xB172,
	24473 - 11904: 0xB170,
	24475 - 11904: 0xD54E,
	24476 - 11904: 0xB175,
	24478 - 11904: 0xB171,
	24479 - 11904: 0xD550,
	24480 - 11904: 0xB174,
	24481 - 11904: 0xB173,
	24484 - 11904: 0xFA61,
	24485 - 11904: 0xD8F6,
	24486 - 11904: 0xD8F5,
	24487 - 11904: 0xFC57,
	24488 - 11904: 0xB461,
	24489 - 11904: 0xB45F,
	24490 - 11904: 0xB460,
	24491 - 11904: 0xD8F7,
	24492 - 11904: 0xB74B,
	24493 - 11904: 0xDD64,
	24494 - 11904: 0xB74C,
	24495 - 11904: 0xDD63,
	24497 - 11904: 0x9B70,
	24498 - 11904: 0xE577,
	24501 - 11904: 0xBC78,
	24502 - 11904: 0xE1C1,
	24503 - 11904: 0xBC77,
	24505 - 11904: 0xB9FD,
	24506 - 11904: 0xA051,
	24507 - 11904: 0xECDE,
	24508 - 11904: 0xE975,
	24509 - 11904: 0xC0B2,
	24510 - 11904: 0xECDD,
	24511 - 11904: 0xF240,
	24512 - 11904: 0xF448,
	24513 - 11904: 0xF449,
	24514 - 11904: 0x8C7C,
	24515 - 11904: 0xA4DF,
	24516 - 11904: 0x8BCB,
	24517 - 11904: 0xA5B2,
	24521 - 11904: 0xC97B,
	24524 - 11904: 0xA7D2,
	24525 - 11904: 0xA7D4,
	24527 - 11904: 0xC9E2,
	24528 - 11904: 0xCAD8,
	24529 - 11904: 0xCAD7,
	24530 - 11904: 0xCAD6,
	24532 - 11904: 0xC9E1,
	24533 - 11904: 0xC9E0,
	24534 - 11904: 0xA6A4,
	24535 - 11904: 0xA7D3,
	24536 - 11904: 0xA7D1,
	24537 - 11904: 0xA6A3,
	24539 - 11904: 0x936E,
	24541 - 11904: 0xA9BD,
	24542 - 11904: 0xCC78,
	24543 - 11904: 0xFCD5,
	24544 - 11904: 0xA9BE,
	24545 - 11904: 0xCADD,
	24547 - 11904: 0xCADF,
	24548 - 11904: 0xCADE,
	24549 - 11904: 0xCC79,
	24552 - 11904: 0xCADA,
	24554 - 11904: 0xA7D8,
	24555 - 11904: 0xA7D6,
	24557 - 11904: 0xCAD9,
	24558 - 11904: 0xCADB,
	24559 - 11904: 0xCAE1,
	24561 - 11904: 0xA7D5,
	24563 - 11904: 0xCADC,
	24564 - 11904: 0xCAE5,
	24565 - 11904: 0xA9C0,
	24567 - 11904: 0xCAE2,
	24568 - 11904: 0xA7D7,
	24570 - 11904: 0xCAE0,
	24571 - 11904: 0xCAE3,
	24573 - 11904: 0xA9BF,
	24575 - 11904: 0xA9C1,
	24576 - 11904: 0xCAE4,
	24585 - 11904: 0xCCAF,
	24586 - 11904: 0xCCA2,
	24587 - 11904: 0xCC7E,
	24588 - 11904: 0xCCAE,
	24589 - 11904: 0xCCA9,
	24590 - 11904: 0xABE7,
	24591 - 11904: 0xA9C2,
	24592 - 11904: 0xCCAA,
	24593 - 11904: 0xCCAD,
	24594 - 11904: 0xABE3,
	24595 - 11904: 0xCCAC,
	24596 - 11904: 0xA9C3,
	24597 - 11904: 0xA9C8,
	24598 - 11904: 0xA9C6,
	24599 - 11904: 0xCCA3,
	24601 - 11904: 0xCC7C,
	24602 - 11904: 0xCCA5,
	24603 - 11904: 0xA9CD,
	24604 - 11904: 0xCCB0,
	24605 - 11904: 0xABE4,
	24606 - 11904: 0xCCA6,
	24608 - 11904: 0xABE5,
	24609 - 11904: 0xA9C9,
	24610 - 11904: 0xCCA8,
	24611 - 11904: 0xFCA9,
	24612 - 11904: 0xCECD,
	24613 - 11904: 0xABE6,
	24614 - 11904: 0xCC7B,
	24615 - 11904: 0xA9CA,
	24616 - 11904: 0xABE8,
	24617 - 11904: 0xA9CB,
	24618 - 11904: 0xA9C7,
	24619 - 11904: 0xA9CC,
	24620 - 11904: 0xCCA7,
	24621 - 11904: 0xCC7A,
	24622 - 11904: 0xCCAB,
	24623 - 11904: 0xA9C4,
	24625 - 11904: 0xFC61,
	24626 - 11904: 0xCC7D,
	24627 - 11904: 0xCCA4,
	24628 - 11904: 0xCCA1,
	24629 - 11904: 0xA9C5,
	24631 - 11904: 0xCEBF,
	24633 - 11904: 0xCEC0,
	24635 - 11904: 0x8966,
	24640 - 11904: 0xCECA,
	24641 - 11904: 0xD1A1,
	24642 - 11904: 0xCECB,
	24643 - 11904: 0xABEE,
	24644 - 11904: 0xCECE,
	24645 - 11904: 0xCEC4,
	24646 - 11904: 0xABED,
	24647 - 11904: 0xCEC6,
	24649 - 11904: 0xCEC7,
	24650 - 11904: 0xFACB,
	24652 - 11904: 0xCEC9,
	24653 - 11904: 0xABE9,
	24656 - 11904: 0xAEA3,
	24658 - 11904: 0xF9DA,
	24659 - 11904: 0xCEC5,
	24660 - 11904: 0xCEC1,
	24661 - 11904: 0xAEA4,
	24664 - 11904: 0xCECF,
	24665 - 11904: 0xAE7E,
	24666 - 11904: 0xD17D,
	24667 - 11904: 0xCEC8,
	24669 - 11904: 0xD17C,
	24670 - 11904: 0xCEC3,
	24671 - 11904: 0xCECC,
	24674 - 11904: 0xABEC,
	24675 - 11904: 0xAEA1,
	24676 - 11904: 0xABF2,
	24677 - 11904: 0xAEA2,
	24678 - 11904: 0xCED0,
	24679 - 11904: 0xD17E,
	24680 - 11904: 0xABEB,
	24681 - 11904: 0xAEA6,
	24682 - 11904: 0xABF1,
	24683 - 11904: 0xABF0,
	24684 - 11904: 0xABEF,
	24685 - 11904: 0xAEA5,
	24686 - 11904: 0xCED1,
	24687 - 11904: 0xAEA7,
	24688 - 11904: 0xABEA,
	24690 - 11904: 0xCEC2,
	24693 - 11904: 0x937A,
	24695 - 11904: 0xA0E0,
	24702 - 11904: 0x936B,
	24703 - 11904: 0xB176,
	24704 - 11904: 0xD1A4,
	24705 - 11904: 0xD1A6,
	24707 - 11904: 0xD1A8,
	24708 - 11904: 0xAEA8,
	24709 - 11904: 0xAEAE,
	24710 - 11904: 0xD553,
	24711 - 11904: 0xD1AC,
	24712 - 11904: 0xD1A3,
	24713 - 11904: 0xB178,
	24714 - 11904: 0xD551,
	24716 - 11904: 0xAEAD,
	24717 - 11904: 0xAEAB,
	24718 - 11904: 0xD1AE,
	24720 - 11904: 0xD552,
	24722 - 11904: 0xD1A5,
	24724 - 11904: 0xAEAC,
	24725 - 11904: 0xD1A9,
	24726 - 11904: 0xAEAF,
	24727 - 11904: 0xD1AB,
	24730 - 11904: 0xAEAA,
	24731 - 11904: 0xD1AA,
	24732 - 11904: 0xD1AD,
	24733 - 11904: 0xD1A7,
	24734 - 11904: 0xFC6B,
	24735 - 11904: 0xAEA9,
	24736 - 11904: 0xB179,
	24738 - 11904: 0xD1A2,
	24739 - 11904: 0xB177,
	24740 - 11904: 0xFC6C,
	24743 - 11904: 0x9468,
	24744 - 11904: 0xB17A,
	24752 - 11904: 0xD555,
	24753 - 11904: 0xD55E,
	24754 - 11904: 0xB464,
	24755 - 11904: 0xFC6D,
	24756 - 11904: 0xB17C,
	24757 - 11904: 0xB1A3,
	24758 - 11904: 0xB465,
	24759 - 11904: 0xD560,
	24760 - 11904: 0xB1AA,
	24761 - 11904: 0xD8F9,
	24762 - 11904: 0xD556,
	24763 - 11904: 0xB1A2,
	24764 - 11904: 0xB1A5,
	24765 - 11904: 0xB17E,
	24766 - 11904: 0xD554,
	24767 - 11904: 0xD562,
	24768 - 11904: 0xD565,
	24769 - 11904: 0xD949,
	24771 - 11904: 0xD563,
	24772 - 11904: 0xD8FD,
	24773 - 11904: 0xB1A1,
	24774 - 11904: 0xB1A8,
	24775 - 11904: 0xB1AC,
	24776 - 11904: 0xD55D,
	24777 - 11904: 0xD8F8,
	24778 - 11904: 0xD561,
	24779 - 11904: 0xB17B,
	24780 - 11904: 0xD8FA,
	24781 - 11904: 0xD564,
	24782 - 11904: 0xD8FC,
	24783 - 11904: 0xD559,
	24785 - 11904: 0xB462,
	24787 - 11904: 0xD557,
	24788 - 11904: 0xD558,
	24789 - 11904: 0xB1A7,
	24791 - 11904: 0x8D71,
	24792 - 11904: 0xB1A6,
	24793 - 11904: 0xD55B,
	24794 - 11904: 0xB1AB,
	24795 - 11904: 0xD55F,
	24796 - 11904: 0xB1A4,
	24797 - 11904: 0xD55C,
	24798 - 11904: 0xFD64,
	24799 - 11904: 0xB1A9,
	24800 - 11904: 0xB466,
	24801 - 11904: 0xB463,
	24802 - 11904: 0xD8FB,
	24803 - 11904: 0x99BA,
	24804 - 11904: 0xD55A,
	24806 - 11904: 0xB17D,
	24807 - 11904: 0x9AD0,
	24808 - 11904: 0x9A61,
	24809 - 11904: 0xA0E5,
	24816 - 11904: 0xB46B,
	24817 - 11904: 0xB46F,
	24818 - 11904: 0xD940,
	24819 - 11904: 0xB751,
	24820 - 11904: 0xB46D,
	24821 - 11904: 0xD944,
	24822 - 11904: 0xB471,
	24823 - 11904: 0xDD65,
	24824 - 11904: 0xD946,
	24825 - 11904: 0xB753,
	24826 - 11904: 0xB469,
	24827 - 11904: 0xB46C,
	24828 - 11904: 0xD947,
	24829 - 11904: 0xA05B,
	24830 - 11904: 0xD948,
	24831 - 11904: 0xD94E,
	24832 - 11904: 0xB473,
	24833 - 11904: 0xB754,
	24835 - 11904: 0xD94A,
	24836 - 11904: 0xD94F,
	24837 - 11904: 0xD943,
	24838 - 11904: 0xB75E,
	24839 - 11904: 0x96AC,
	24840 - 11904: 0xB755,
	24841 - 11904: 0xB472,
	24842 - 11904: 0xD941,
	24843 - 11904: 0xD950,
	24844 - 11904: 0x9740,
	24845 - 11904: 0xB75D,
	24846 - 11904: 0xB470,
	24847 - 11904: 0xB74E,
	24848 - 11904: 0xD94D,
	24850 - 11904: 0xB474,
	24851 - 11904: 0xD945,
	24852 - 11904: 0xD8FE,
	24853 - 11904: 0xB46A,
	24854 - 11904: 0xD942,
	24856 - 11904: 0xD94B,
	24857 - 11904: 0x9EF1,
	24858 - 11904: 0xB74D,
	24859 - 11904: 0xB752,
	24860 - 11904: 0xB467,
	24861 - 11904: 0xD94C,
	24863 - 11904: 0xB750,
	24866 - 11904: 0x8C4D,
	24867 - 11904: 0xB468,
	24871 - 11904: 0xB75C,
	24872 - 11904: 0xE1C3,
	24873 - 11904: 0xDD70,
	24875 - 11904: 0xDD68,
	24876 - 11904: 0xE1C2,
	24878 - 11904: 0xDD6C,
	24879 - 11904: 0xDD6E,
	24880 - 11904: 0x9F7E,
	24882 - 11904: 0xDD6B,
	24884 - 11904: 0xB75B,
	24886 - 11904: 0xDD6A,
	24887 - 11904: 0xB75F,
	24891 - 11904: 0xE1D2,
	24893 - 11904: 0x8D72,
	24894 - 11904: 0xB75A,
	24895 - 11904: 0xBA40,
	24896 - 11904: 0xDD71,
	24897 - 11904: 0xE1C4,
	24898 - 11904: 0xFC76,
	24900 - 11904: 0xB758,
	24901 - 11904: 0xDD69,
	24902 - 11904: 0xDD6D,
	24903 - 11904: 0xB9FE,
	24904 - 11904: 0xB74F,
	24905 - 11904: 0xDD66,
	24906 - 11904: 0xDD67,
	24907 - 11904: 0xBA41,
	24908 - 11904: 0xB757,
	24909 - 11904: 0xB759,
	24910 - 11904: 0xB756,
	24911 - 11904: 0xDD6F,
	24912 - 11904: 0x96A9,
	24914 - 11904: 0xE1C8,
	24915 - 11904: 0xE1C9,
	24916 - 11904: 0xE1CE,
	24917 - 11904: 0xBC7D,
	24918 - 11904: 0xE1D5,
	24920 - 11904: 0xBA47,
	24921 - 11904: 0xA06E,
	24922 - 11904: 0xBA46,
	24923 - 11904: 0xE1D0,
	24924 - 11904: 0xFCAA,
	24925 - 11904: 0xBC7C,
	24926 - 11904: 0xE1C5,
	24927 - 11904: 0xBA45,
	24928 - 11904: 0xFBCD,
	24929 - 11904: 0xE1D4,
	24930 - 11904: 0xBA43,
	24931 - 11904: 0xBA44,
	24932 - 11904: 0xFC74,
	24933 - 11904: 0xE1D1,
	24934 - 11904: 0xE5AA,
	24935 - 11904: 0xBC7A,
	24936 - 11904: 0xB46E,
	24938 - 11904: 0xE1D3,
	24939 - 11904: 0xBCA3,
	24940 - 11904: 0xE1CB,
	24942 - 11904: 0xBC7B,
	24943 - 11904: 0xA074,
	24944 - 11904: 0xBCA2,
	24945 - 11904: 0xE1C6,
	24946 - 11904: 0xE1CA,
	24947 - 11904: 0xE1C7,
	24948 - 11904: 0xE1CD,
	24949 - 11904: 0xBA48,
	24950 - 11904: 0xBC79,
	24951 - 11904: 0xBA42,
	24953 - 11904: 0xE57A,
	24954 - 11904: 0xE1CF,
	24956 - 11904: 0xBCA1,
	24957 - 11904: 0xA071,
	24958 - 11904: 0xBCA4,
	24960 - 11904: 0xE1CC,
	24961 - 11904: 0xFC79,
	24962 - 11904: 0xBC7E,
	24963 - 11904: 0xE579,
	24967 - 11904: 0xFC7C,
	24969 - 11904: 0xE57E,
	24970 - 11904: 0xBECE,
	24971 - 11904: 0xE578,
	24972 - 11904: 0xE9A3,
	24973 - 11904: 0xE5A9,
	24974 - 11904: 0xBCA8,
	24976 - 11904: 0xBCA6,
	24977 - 11904: 0xBECC,
	24978 - 11904: 0xE5A6,
	24979 - 11904: 0xE5A2,
	24980 - 11904: 0xBCAC,
	24981 - 11904: 0x9C50,
	24982 - 11904: 0xE978,
	24984 - 11904: 0x9379,
	24985 - 11904: 0x9378,
	24986 - 11904: 0xBCAA,
	24987 - 11904: 0xE5A1,
	24988 - 11904: 0xA0DD,
	24989 - 11904: 0xE976,
	24991 - 11904: 0xE5A5,
	24993 - 11904: 0xE5A8,
	24994 - 11904: 0xE57D,
	24996 - 11904: 0xBCAB,
	24999 - 11904: 0xBCA5,
	25000 - 11904: 0xE977,
	25001 - 11904: 0xBECD,
	25002 - 11904: 0xE5A7,
	25003 - 11904: 0xBCA7,
	25004 - 11904: 0xBCA9,
	25005 - 11904: 0xE5A4,
	25006 - 11904: 0xBCAD,
	25007 - 11904: 0xE5A3,
	25008 - 11904: 0xE57C,
	25009 - 11904: 0xE57B,
	25010 - 11904: 0xBECB,
	25011 - 11904: 0xE5AB,
	25012 - 11904: 0xE97A,
	25013 - 11904: 0xECE0,
	25014 - 11904: 0xBED0,
	25015 - 11904: 0x8D75,
	25016 - 11904: 0xE9A2,
	25017 - 11904: 0x8D76,
	25018 - 11904: 0xE97E,
	25020 - 11904: 0xECE1,
	25022 - 11904: 0xBED1,
	25023 - 11904: 0xE9A1,
	25024 - 11904: 0x9374,
	25025 - 11904: 0xE97C,
	25026 - 11904: 0xC0B4,
	25027 - 11904: 0xECDF,
	25029 - 11904: 0xE979,
	25030 - 11904: 0xE97B,
	25031 - 11904: 0xC0B5,
	25032 - 11904: 0xBED3,
	25033 - 11904: 0xC0B3,
	25034 - 11904: 0xBED2,
	25035 - 11904: 0xC0B7,
	25036 - 11904: 0xE97D,
	25037 - 11904: 0xBECF,
	25039 - 11904: 0x8D77,
	25040 - 11904: 0xFCA5,
	25043 - 11904: 0xFCA2,
	25046 - 11904: 0xEFCF,
	25048 - 11904: 0xEFC7,
	25050 - 11904: 0x90C3,
	25054 - 11904: 0xECE7,
	25055 - 11904: 0xEFC8,
	25056 - 11904: 0xECE3,
	25058 - 11904: 0xA079,
	25059 - 11904: 0xC256,
	25060 - 11904: 0xECE5,
	25061 - 11904: 0xECE4,
	25062 - 11904: 0xC0B6,
	25063 - 11904: 0xECE2,
	25064 - 11904: 0xECE6,
	25065 - 11904: 0xEFD0,
	25066 - 11904: 0xEFCC,
	25067 - 11904: 0xEFCE,
	25069 - 11904: 0xEFC9,
	25070 - 11904: 0xEFCA,
	25072 - 11904: 0xEFCD,
	25073 - 11904: 0xEFCB,
	25074 - 11904: 0xC367,
	25077 - 11904: 0xC36A,
	25078 - 11904: 0xC369,
	25079 - 11904: 0xC368,
	25080 - 11904: 0xC461,
	25081 - 11904: 0xF44A,
	25082 - 11904: 0xC462,
	25083 - 11904: 0xF241,
	25084 - 11904: 0xC4DF,
	25085 - 11904: 0xF5CC,
	25086 - 11904: 0xC4E0,
	25087 - 11904: 0xC574,
	25088 - 11904: 0xC5CA,
	25089 - 11904: 0xF7D9,
	25091 - 11904: 0xF7DA,
	25092 - 11904: 0xF7DB,
	25095 - 11904: 0xF9BA,
	25096 - 11904: 0xA4E0,
	25097 - 11904: 0xC97C,
	25098 - 11904: 0xA5B3,
	25100 - 11904: 0xA6A6,
	25101 - 11904: 0xA6A7,
	25102 - 11904: 0xA6A5,
	25104 - 11904: 0xA6A8,
	25105 - 11904: 0xA7DA,
	25106 - 11904: 0xA7D9,
	25108 - 11904: 0xCCB1,
	25109 - 11904: 0xA9CF,
	25110 - 11904: 0xA9CE,
	25113 - 11904: 0xD1AF,
	25114 - 11904: 0xB1AD,
	25115 - 11904: 0xB1AE,
	25119 - 11904: 0xB475,
	25120 - 11904: 0xDD72,
	25121 - 11904: 0xB760,
	25122 - 11904: 0xB761,
	25123 - 11904: 0xDD74,
	25124 - 11904: 0xDD76,
	25125 - 11904: 0xDD75,
	25127 - 11904: 0xE1D7,
	25129 - 11904: 0xE1D6,
	25130 - 11904: 0xBA49,
	25131 - 11904: 0xE1D8,
	25132 - 11904: 0x8D79,
	25133 - 11904: 0xE5AC,
	25134 - 11904: 0xBCAE,
	25136 - 11904: 0xBED4,
	25138 - 11904: 0xC0B8,
	25139 - 11904: 0xC257,
	25140 - 11904: 0xC0B9,
	25142 - 11904: 0xA4E1,
	25143 - 11904: 0x8BFC,
	25145 - 11904: 0xA076,
	25146 - 11904: 0xCAE6,
	25149 - 11904: 0xCCB2,
	25150 - 11904: 0xA9D1,
	25151 - 11904: 0xA9D0,
	25152 - 11904: 0xA9D2,
	25153 - 11904: 0xABF3,
	25154 - 11904: 0xCED2,
	25155 - 11904: 0xCED3,
	25158 - 11904: 0xD1B0,
	25159 - 11904: 0xAEB0,
	25160 - 11904: 0xB1AF,
	25161 - 11904: 0xB476,
	25162 - 11904: 0xD951,
	25163 - 11904: 0xA4E2,
	25164 - 11904: 0x8BCD,
	25165 - 11904: 0xA47E,
	25166 - 11904: 0xA4E3,
	25168 - 11904: 0xC97D,
	25169 - 11904: 0xA5B7,
	25170 - 11904: 0xA5B6,
	25171 - 11904: 0xA5B4,
	25172 - 11904: 0xA5B5,
	25176 - 11904: 0xA6AB,
	25177 - 11904: 0xC9E9,
	25178 - 11904: 0xC9EB,
	25179 - 11904: 0xA6AA,
	25180 - 11904: 0xC9E3,
	25182 - 11904: 0xC9E4,
	25184 - 11904: 0xC9EA,
	25185 - 11904: 0xC9E6,
	25186 - 11904: 0xC9E8,
	25187 - 11904: 0xA6A9,
	25188 - 11904: 0xC9E5,
	25189 - 11904: 0xC9EC,
	25190 - 11904: 0xC9E7,
	25192 - 11904: 0x9F5A,
	25197 - 11904: 0xA7E1,
	25198 - 11904: 0xA7EA,
	25199 - 11904: 0xA7E8,
	25200 - 11904: 0xCAF0,
	25201 - 11904: 0xCAED,
	25202 - 11904: 0xCAF5,
	25203 - 11904: 0xA7E6,
	25204 - 11904: 0xCAF6,
	25206 - 11904: 0xA7DF,
	25207 - 11904: 0xCAF3,
	25209 - 11904: 0xA7E5,
	25210 - 11904: 0xCAEF,
	25211 - 11904: 0xCAEE,
	25212 - 11904: 0xA7E3,
	25213 - 11904: 0xCAF4,
	25214 - 11904: 0xA7E4,
	25215 - 11904: 0xA9D3,
	25216 - 11904: 0xA7DE,
	25217 - 11904: 0xCAF1,
	25218 - 11904: 0x9FF4,
	25219 - 11904: 0xCAE7,
	25220 - 11904: 0xA7DB,
	25221 - 11904: 0x9FBA,
	25222 - 11904: 0xA7EE,
	25223 - 11904: 0xCAEC,
	25224 - 11904: 0xCAF2,
	25225 - 11904: 0xA7E0,
	25226 - 11904: 0xA7E2,
	25228 - 11904: 0xCAE8,
	25230 - 11904: 0xCAE9,
	25231 - 11904: 0xCAEA,
	25232 - 11904: 0x8D7A,
	25233 - 11904: 0xA7ED,
	25234 - 11904: 0xA7E7,
	25235 - 11904: 0xA7EC,
	25236 - 11904: 0xCAEB,
	25237 - 11904: 0xA7EB,
	25238 - 11904: 0xA7DD,
	25239 - 11904: 0xA7DC,
	25240 - 11904: 0xA7E9,
	25245 - 11904: 0x9E45,
	25252 - 11904: 0x93B0,
	25254 - 11904: 0xA075,
	25256 - 11904: 0xA9E1,
	25257 - 11904: 0xCCBE,
	25258 - 11904: 0xCCB7,
	25259 - 11904: 0xA9DC,
	25260 - 11904: 0xA9EF,
	25261 - 11904: 0xCCB3,
	25262 - 11904: 0xCCBA,
	25263 - 11904: 0xCCBC,
	25264 - 11904: 0xCCBF,
	25265 - 11904: 0xA9EA,
	25267 - 11904: 0xCCBB,
	25268 - 11904: 0xCCB4,
	25269 - 11904: 0xA9E8,
	25270 - 11904: 0xCCB8,
	25272 - 11904: 0xCCC0,
	25273 - 11904: 0xA9D9,
	25275 - 11904: 0xCCBD,
	25276 - 11904: 0xA9E3,
	25277 - 11904: 0xA9E2,
	25278 - 11904: 0xCCB6,
	25279 - 11904: 0xA9D7,
	25281 - 11904: 0x87DD,
	25282 - 11904: 0xA9D8,
	25283 - 11904: 0x9B46,
	25284 - 11904: 0xA9D6,
	25285 - 11904: 0xFCAE,
	25286 - 11904: 0xA9EE,
	25287 - 11904: 0xA9E6,
	25288 - 11904: 0xA9E0,
	25289 - 11904: 0xA9D4,
	25290 - 11904: 0xCCB9,
	25291 - 11904: 0xA9DF,
	25292 - 11904: 0xA9D5,
	25293 - 11904: 0xA9E7,
	25294 - 11904: 0xA9F0,
	25295 - 11904: 0xCED4,
	25296 - 11904: 0xA9E4,
	25297 - 11904: 0xCCB5,
	25298 - 11904: 0xA9DA,
	25299 - 11904: 0xA9DD,
	25300 - 11904: 0xA9DE,
	25301 - 11904: 0xFCB0,
	25302 - 11904: 0xA9EC,
	25303 - 11904: 0xA9ED,
	25304 - 11904: 0xA9EB,
	25305 - 11904: 0xA9E5,
	25306 - 11904: 0xA9E9,
	25307 - 11904: 0xA9DB,
	25308 - 11904: 0xABF4,
	25311 - 11904: 0xFA51,
	25317 - 11904: 0x8D7B,
	25323 - 11904: 0xCEDA,
	25324 - 11904: 0xAC41,
	25325 - 11904: 0xABF8,
	25326 - 11904: 0xABFA,
	25327 - 11904: 0xAC40,
	25328 - 11904: 0xCEE6,
	25329 - 11904: 0xABFD,
	25330 - 11904: 0xD1B1,
	25331 - 11904: 0xAEB1,
	25332 - 11904: 0xAC43,
	25333 - 11904: 0xCED7,
	25334 - 11904: 0xCEDF,
	25335 - 11904: 0xABFE,
	25336 - 11904: 0xCEDE,
	25337 - 11904: 0xCEDB,
	25338 - 11904: 0xCEE3,
	25339 - 11904: 0xCEE5,
	25340 - 11904: 0xABF7,
	25341 - 11904: 0xABFB,
	25342 - 11904: 0xAC42,
	25343 - 11904: 0xAEB3,
	25344 - 11904: 0xCEE0,
	25345 - 11904: 0xABF9,
	25346 - 11904: 0xAC45,
	25347 - 11904: 0xCED9,
	25351 - 11904: 0xABFC,
	25352 - 11904: 0xAEB2,
	25353 - 11904: 0xABF6,
	25355 - 11904: 0xCED6,
	25356 - 11904: 0xCEDD,
	25357 - 11904: 0xCED5,
	25358 - 11904: 0xCED8,
	25359 - 11904: 0xCEDC,
	25360 - 11904: 0xD1B2,
	25361 - 11904: 0xAC44,
	25363 - 11904: 0xCEE1,
	25364 - 11904: 0xCEE2,
	25365 - 11904: 0xCEE4,
	25366 - 11904: 0xABF5,
	25368 - 11904: 0x8D7C,
	25384 - 11904: 0xAEC1,
	25385 - 11904: 0xD1BE,
	25386 - 11904: 0xAEBF,
	25387 - 11904: 0xAEC0,
	25388 - 11904: 0xD1B4,
	25389 - 11904: 0xD1C4,
	25390 - 11904: 0x9ED6,
	25391 - 11904: 0xAEB6,
	25393 - 11904: 0x93AC,
	25394 - 11904: 0xD566,
	25395 - 11904: 0xD1C6,
	25396 - 11904: 0xD1C0,
	25397 - 11904: 0x9F5B,
	25398 - 11904: 0xD1B7,
	25399 - 11904: 0x93A9,
	25400 - 11904: 0xD1C9,
	25401 - 11904: 0xD1BA,
	25402 - 11904: 0xAEBC,
	25403 - 11904: 0xD57D,
	25404 - 11904: 0xD1BD,
	25405 - 11904: 0xAEBE,
	25406 - 11904: 0xAEB5,
	25408 - 11904: 0xD1CB,
	25409 - 11904: 0xD1BF,
	25410 - 11904: 0xAEB8,
	25411 - 11904: 0xD1B8,
	25412 - 11904: 0xD1B5,
	25413 - 11904: 0xD1B6,
	25414 - 11904: 0xAEB9,
	25415 - 11904: 0xD1C5,
	25416 - 11904: 0xD1CC,
	25417 - 11904: 0xAEBB,
	25418 - 11904: 0xD1BC,
	25419 - 11904: 0xD1BB,
	25420 - 11904: 0xAEC3,
	25421 - 11904: 0xAEC2,
	25422 - 11904: 0xAEB4,
	25423 - 11904: 0xAEBA,
	25424 - 11904: 0xAEBD,
	25425 - 11904: 0xD1C8,
	25428 - 11904: 0xD1C2,
	25429 - 11904: 0xAEB7,
	25430 - 11904: 0xD1B3,
	25431 - 11904: 0xD1CA,
	25432 - 11904: 0xD1C1,
	25433 - 11904: 0xD1C3,
	25434 - 11904: 0xD1C7,
	25444 - 11904: 0xA07C,
	25445 - 11904: 0xD567,
	25447 - 11904: 0xB1B7,
	25448 - 11904: 0xB1CB,
	25449 - 11904: 0xB1CA,
	25451 - 11904: 0xB1BF,
	25452 - 11904: 0xFCB2,
	25453 - 11904: 0xD579,
	25454 - 11904: 0xD575,
	25455 - 11904: 0xD572,
	25456 - 11904: 0xD5A6,
	25457 - 11904: 0xB1BA,
	25458 - 11904: 0xB1B2,
	25461 - 11904: 0xD577,
	25462 - 11904: 0xB4A8,
	25463 - 11904: 0xB1B6,
	25464 - 11904: 0xD5A1,
	25465 - 11904: 0x8AC1,
	25466 - 11904: 0xB1CC,
	25467 - 11904: 0xB1C9,
	25468 - 11904: 0xD57B,
	25469 - 11904: 0xD56A,
	25471 - 11904: 0x9FB4,
	25472 - 11904: 0xB1C8,
	25473 - 11904: 0xD5A3,
	25474 - 11904: 0xD569,
	25475 - 11904: 0xB1BD,
	25476 - 11904: 0xB1C1,
	25477 - 11904: 0xD5A2,
	25479 - 11904: 0xD573,
	25480 - 11904: 0xB1C2,
	25481 - 11904: 0xB1BC,
	25482 - 11904: 0xD568,
	25483 - 11904: 0xFCAC,
	25484 - 11904: 0xB478,
	25485 - 11904: 0xD5A5,
	25486 - 11904: 0xD571,
	25487 - 11904: 0xB1C7,
	25488 - 11904: 0xD574,
	25489 - 11904: 0xD5A4,
	25490 - 11904: 0xB1C6,
	25492 - 11904: 0xD952,
	25494 - 11904: 0xB1B3,
	25495 - 11904: 0xD56F,
	25496 - 11904: 0xB1B8,
	25497 - 11904: 0xB1C3,
	25499 - 11904: 0xB1BE,
	25500 - 11904: 0xD578,
	25501 - 11904: 0xD56E,
	25502 - 11904: 0xD56C,
	25503 - 11904: 0xD57E,
	25504 - 11904: 0xB1B0,
	25505 - 11904: 0xB1C4,
	25506 - 11904: 0xB1B4,
	25507 - 11904: 0xB477,
	25508 - 11904: 0xD57C,
	25509 - 11904: 0xB1B5,
	25511 - 11904: 0xB1B1,
	25512 - 11904: 0xB1C0,
	25513 - 11904: 0xB1BB,
	25514 - 11904: 0xB1B9,
	25515 - 11904: 0xD570,
	25516 - 11904: 0xB1C5,
	25517 - 11904: 0xD56D,
	25518 - 11904: 0xD57A,
	25519 - 11904: 0xD576,
	25520 - 11904: 0xD954,
	25521 - 11904: 0xD953,
	25529 - 11904: 0x9E4C,
	25533 - 11904: 0xD56B,
	25534 - 11904: 0xD964,
	25536 - 11904: 0xB47A,
	25537 - 11904: 0x8FC5,
	25538 - 11904: 0xD96A,
	25539 - 11904: 0xD959,
	25540 - 11904: 0xD967,
	25541 - 11904: 0xDD77,
	25542 - 11904: 0xB47D,
	25543 - 11904: 0xD96B,
	25544 - 11904: 0xD96E,
	25545 - 11904: 0xB47C,
	25546 - 11904: 0xD95C,
	25547 - 11904: 0xD96D,
	25548 - 11904: 0xD96C,
	25549 - 11904: 0xB47E,
	25550 - 11904: 0xD955,
	25551 - 11904: 0xB479,
	25552 - 11904: 0xB4A3,
	25553 - 11904: 0x93AD,
	25554 - 11904: 0xB4A1,
	25555 - 11904: 0xD969,
	25557 - 11904: 0xD95F,
	25558 - 11904: 0xB4A5,
	25559 - 11904: 0xD970,
	25560 - 11904: 0xD968,
	25561 - 11904: 0xD971,
	25562 - 11904: 0xB4AD,
	25563 - 11904: 0xB4AB,
	25564 - 11904: 0xD966,
	25565 - 11904: 0xD965,
	25566 - 11904: 0x9DC3,
	25567 - 11904: 0xD963,
	25568 - 11904: 0xD95D,
	25569 - 11904: 0xB4A4,
	25570 - 11904: 0x8DA2,
	25571 - 11904: 0xB4A2,
	25572 - 11904: 0xD1B9,
	25573 - 11904: 0xD956,
	25574 - 11904: 0x9D4A,
	25575 - 11904: 0xDDB7,
	25576 - 11904: 0xD957,
	25577 - 11904: 0xB47B,
	25578 - 11904: 0xB4AA,
	25579 - 11904: 0xDD79,
	25581 - 11904: 0xB4A6,
	25582 - 11904: 0xB4A7,
	25583 - 11904: 0xD958,
	25584 - 11904: 0xD96F,
	25585 - 11904: 0xDD78,
	25586 - 11904: 0xD960,
	25587 - 11904: 0xD95B,
	25588 - 11904: 0xB4A9,
	25589 - 11904: 0xD961,
	25590 - 11904: 0xD95E,
	25592 - 11904: 0xFCB6,
	25593 - 11904: 0xB4AE,
	25595 - 11904: 0x8DA3,
	25596 - 11904: 0x9E4B,
	25598 - 11904: 0x9E4D,
	25606 - 11904: 0xB770,
	25607 - 11904: 0x8DA4,
	25609 - 11904: 0xDD7C,
	25610 - 11904: 0xDDB1,
	25611 - 11904: 0xDDB6,
	25612 - 11904: 0xDDAA,
	25613 - 11904: 0xB76C,
	25614 - 11904: 0xDDBB,
	25615 - 11904: 0xB769,
	25616 - 11904: 0xDD7A,
	25618 - 11904: 0xDD7B,
	25619 - 11904: 0xB762,
	25620 - 11904: 0xB76B,
	25621 - 11904: 0xDDA4,
	25622 - 11904: 0xB76E,
	25623 - 11904: 0xB76F,
	25624 - 11904: 0xDDA5,
	25626 - 11904: 0xDDB2,
	25627 - 11904: 0xDDB8,
	25628 - 11904: 0xB76A,
	25630 - 11904: 0xB764,
	25631 - 11904: 0xDDA3,
	25632 - 11904: 0xDD7D,
	25633 - 11904: 0xDDBA,
	25634 - 11904: 0xDDA8,
	25635 - 11904: 0xDDA9,
	25636 - 11904: 0xDD7E,
	25637 - 11904: 0xDDB4,
	25638 - 11904: 0xDDAB,
	25639 - 11904: 0xDDB5,
	25640 - 11904: 0xDDAD,
	25642 - 11904: 0xB765,
	25643 - 11904: 0xE1D9,
	25644 - 11904: 0xB768,
	25645 - 11904: 0xB766,
	25646 - 11904: 0xDDB9,
	25647 - 11904: 0xDDB0,
	25648 - 11904: 0xDDAC,
	25650 - 11904: 0x8AFD,
	25651 - 11904: 0xDDA1,
	25652 - 11904: 0xBA53,
	25653 - 11904: 0xDDAF,
	25654 - 11904: 0xB76D,
	25655 - 11904: 0xDDA7,
	25656 - 11904: 0xFCB5,
	25657 - 11904: 0xDDA6,
	25658 - 11904: 0xFCC3,
	25659 - 11904: 0x93B2,
	25661 - 11904: 0xB767,
	25662 - 11904: 0xB763,
	25663 - 11904: 0xE1EE,
	25664 - 11904: 0xDDB3,
	25665 - 11904: 0xDDAE,
	25667 - 11904: 0xDDA2,
	25675 - 11904: 0xE1E9,
	25677 - 11904: 0xE1DA,
	25678 - 11904: 0xE1E5,
	25680 - 11904: 0xE1EC,
	25681 - 11904: 0xBA51,
	25682 - 11904: 0xB4AC,
	25683 - 11904: 0xE1EA,
	25684 - 11904: 0xBA4C,
	25688 - 11904: 0xBA4B,
	25689 - 11904: 0xE1F1,
	25690 - 11904: 0x8DA5,
	25691 - 11904: 0xE1DB,
	25692 - 11904: 0xE1E8,
	25693 - 11904: 0xE1DC,
	25694 - 11904: 0xE1E7,
	25695 - 11904: 0xBA4F,
	25696 - 11904: 0xE1EB,
	25697 - 11904: 0xD962,
	25701 - 11904: 0xE1F2,
	25702 - 11904: 0xE1E3,
	25703 - 11904: 0xBA52,
	25704 - 11904: 0xE5BA,
	25705 - 11904: 0xBCAF,
	25707 - 11904: 0xE1F0,
	25708 - 11904: 0xE1EF,
	25709 - 11904: 0xBA54,
	25710 - 11904: 0xE5AD,
	25711 - 11904: 0xBCB0,
	25712 - 11904: 0xE5AE,
	25713 - 11904: 0x93A1,
	25714 - 11904: 0xE1DF,
	25715 - 11904: 0xE1E0,
	25716 - 11904: 0xE1DD,
	25717 - 11904: 0xE1E2,
	25718 - 11904: 0xE1DE,
	25719 - 11904: 0xE1F3,
	25720 - 11904: 0xBA4E,
	25721 - 11904: 0xBCB1,
	25722 - 11904: 0xBA50,
	25723 - 11904: 0xBA55,
	25724 - 11904: 0x8AC6,
	25725 - 11904: 0xE1E1,
	25727 - 11904: 0xE1ED,
	25730 - 11904: 0xE1E6,
	25733 - 11904: 0xE5B1,
	25735 - 11904: 0xBA4A,
	25736 - 11904: 0xBCB4,
	25737 - 11904: 0xE9AA,
	25738 - 11904: 0xE5B6,
	25739 - 11904: 0xE5B5,
	25740 - 11904: 0xE5B7,
	25741 - 11904: 0x8A5B,
	25743 - 11904: 0xE5B4,
	25744 - 11904: 0xFCB9,
	25745 - 11904: 0x894D,
	25746 - 11904: 0xBCBB,
	25747 - 11904: 0xBCB8,
	25749 - 11904: 0xBCB9,
	25750 - 11904: 0xE5AF,
	25751 - 11904: 0xE5B2,
	25752 - 11904: 0xE5BC,
	25753 - 11904: 0xBCC1,
	25754 - 11904: 0xBCBF,
	25756 - 11904: 0xE5B3,
	25757 - 11904: 0xD95A,
	25758 - 11904: 0xBCB2,
	25759 - 11904: 0xE5B9,
	25760 - 11904: 0xE5B0,
	25762 - 11904: 0xBCC2,
	25763 - 11904: 0xE5B8,
	25764 - 11904: 0xBA4D,
	25765 - 11904: 0xBCB7,
	25766 - 11904: 0xE1E4,
	25769 - 11904: 0xBCBA,
	25771 - 11904: 0xBCBE,
	25772 - 11904: 0xBCC0,
	25773 - 11904: 0xBCBD,
	25774 - 11904: 0xBCBC,
	25775 - 11904: 0xFED4,
	25776 - 11904: 0xBCB6,
	25777 - 11904: 0xE5BB,
	25778 - 11904: 0xBCB3,
	25779 - 11904: 0xBCC3,
	25780 - 11904: 0x8A78,
	25782 - 11904: 0x93AB,
	25787 - 11904: 0xBED8,
	25788 - 11904: 0xBED9,
	25789 - 11904: 0xE9A9,
	25790 - 11904: 0xBEE2,
	25791 - 11904: 0xBEDF,
	25792 - 11904: 0x8DA7,
	25793 - 11904: 0xBED6,
	25794 - 11904: 0xBEDD,
	25795 - 11904: 0xE9AB,
	25796 - 11904: 0xBEDB,
	25797 - 11904: 0xBED5,
	25799 - 11904: 0xBEDC,
	25801 - 11904: 0xE9A8,
	25802 - 11904: 0xC0BB,
	25803 - 11904: 0xBED7,
	25805 - 11904: 0xBEDE,
	25806 - 11904: 0xC0BA,
	25807 - 11904: 0xE9A7,
	25808 - 11904: 0xE9A6,
	25810 - 11904: 0xBEE0,
	25811 - 11904: 0x9F45,
	25812 - 11904: 0xBEE1,
	25814 - 11904: 0xE9A5,
	25815 - 11904: 0xE9A4,
	25816 - 11904: 0xC0BC,
	25817 - 11904: 0xE9AE,
	25818 - 11904: 0xBEDA,
	25819 - 11904: 0xE9AC,
	25821 - 11904: 0x8A56,
	25824 - 11904: 0xC0BD,
	25825 - 11904: 0xFCBF,
	25826 - 11904: 0xC0C2,
	25827 - 11904: 0xECEA,
	25828 - 11904: 0xECEC,
	25829 - 11904: 0xFCC0,
	25830 - 11904: 0xC0BF,
	25831 - 11904: 0x8EE6,
	25832 - 11904: 0xECED,
	25833 - 11904: 0xECE9,
	25834 - 11904: 0x8AA4,
	25835 - 11904: 0xECEB,
	25836 - 11904: 0xC0C0,
	25837 - 11904: 0xC0C3,
	25839 - 11904: 0xECE8,
	25840 - 11904: 0xC0BE,
	25841 - 11904: 0xC0C1,
	25842 - 11904: 0xC259,
	25843 - 11904: 0xE9AD,
	25844 - 11904: 0xC258,
	25847 - 11904: 0xC25E,
	25848 - 11904: 0xEFD4,
	25850 - 11904: 0xC25C,
	25851 - 11904: 0xC25D,
	25852 - 11904: 0xEFD7,
	25853 - 11904: 0xEFD3,
	25854 - 11904: 0xC25A,
	25855 - 11904: 0xEFD1,
	25856 - 11904: 0xC36B,
	25857 - 11904: 0xEFD5,
	25859 - 11904: 0xEFD6,
	25860 - 11904: 0xEFD2,
	25862 - 11904: 0xC25B,
	25863 - 11904: 0xF242,
	25865 - 11904: 0xF245,
	25866 - 11904: 0x8943,
	25868 - 11904: 0xF246,
	25869 - 11904: 0xF244,
	25870 - 11904: 0xF247,
	25871 - 11904: 0xC36C,
	25872 - 11904: 0xF243,
	25873 - 11904: 0x93F3,
	25875 - 11904: 0xF44E,
	25876 - 11904: 0xC464,
	25877 - 11904: 0xF44D,
	25878 - 11904: 0xF44C,
	25879 - 11904: 0xF44B,
	25880 - 11904: 0xC463,
	25881 - 11904: 0xC465,
	25883 - 11904: 0xF5CD,
	25884 - 11904: 0xC4E2,
	25885 - 11904: 0xC4E1,
	25886 - 11904: 0xFCAB,
	25887 - 11904: 0x9EA2,
	25888 - 11904: 0xF6E1,
	25889 - 11904: 0xF6E0,
	25890 - 11904: 0xF6E3,
	25891 - 11904: 0xC5CB,
	25892 - 11904: 0xC575,
	25893 - 11904: 0xF7DD,
	25894 - 11904: 0xF6E2,
	25897 - 11904: 0xF7DC,
	25898 - 11904: 0xC5CD,
	25899 - 11904: 0xC5CC,
	25900 - 11904: 0xC5F3,
	25901 - 11904: 0xF8A9,
	25902 - 11904: 0xF8EF,
	25903 - 11904: 0xA4E4,
	25904 - 11904: 0x9DC7,
	25906 - 11904: 0xD972,
	25907 - 11904: 0xE9AF,
	25908 - 11904: 0xC6D2,
	25909 - 11904: 0x8BCE,
	25910 - 11904: 0xA6AC,
	25911 - 11904: 0xCAF7,
	25912 - 11904: 0xA7F1,
	25913 - 11904: 0xA7EF,
	25915 - 11904: 0xA7F0,
	25917 - 11904: 0xCCC1,
	25918 - 11904: 0xA9F1,
	25919 - 11904: 0xAC46,
	25921 - 11904: 0xCEE7,
	25923 - 11904: 0xCEE8,
	25925 - 11904: 0xAC47,
	25926 - 11904: 0xD1CE,
	25928 - 11904: 0xAEC4,
	25929 - 11904: 0xAEC5,
	25930 - 11904: 0xD1CD,
	25933 - 11904: 0xFCC5,
	25935 - 11904: 0xB1D3,
	25937 - 11904: 0xB1CF,
	25939 - 11904: 0xD5A7,
	25940 - 11904: 0xB1D6,
	25941 - 11904: 0xB1D5,
	25942 - 11904: 0xB1CE,
	25943 - 11904: 0xB1D1,
	25944 - 11904: 0xB1D4,
	25945 - 11904: 0xB1D0,
	25948 - 11904: 0xD976,
	25949 - 11904: 0xB1CD,
	25950 - 11904: 0xB4AF,
	25951 - 11904: 0xFCCB,
	25954 - 11904: 0xB4B1,
	25955 - 11904: 0xB4B2,
	25956 - 11904: 0xD975,
	25957 - 11904: 0xD978,
	25958 - 11904: 0xB4B0,
	25959 - 11904: 0xD973,
	25960 - 11904: 0xD977,
	25962 - 11904: 0xD974,
	25963 - 11904: 0x93B3,
	25964 - 11904: 0xB771,
	25965 - 11904: 0xFCCA,
	25967 - 11904: 0xDDBC,
	25970 - 11904: 0xBA56,
	25971 - 11904: 0xE1F4,
	25972 - 11904: 0xBEE3,
	25973 - 11904: 0xBCC4,
	25974 - 11904: 0xE5BD,
	25975 - 11904: 0xBCC5,
	25976 - 11904: 0xBCC6,
	25977 - 11904: 0xE5BF,
	25978 - 11904: 0xE5BE,
	25979 - 11904: 0xE5C0,
	25980 - 11904: 0xE9B1,
	25983 - 11904: 0xE9B0,
	25984 - 11904: 0xECEF,
	25985 - 11904: 0xECEE,
	25986 - 11904: 0xC0C4,
	25987 - 11904: 0xC0C5,
	25988 - 11904: 0xF248,
	25989 - 11904: 0xFCC9,
	25990 - 11904: 0x8DAC,
	25991 - 11904: 0xA4E5,
	25992 - 11904: 0xFBC6,
	25993 - 11904: 0x8967,
	25995 - 11904: 0x8C7E,
	25996 - 11904: 0xD979,
	26000 - 11904: 0xB4B4,
	26001 - 11904: 0xB4B3,
	26002 - 11904: 0xDDBD,
	26004 - 11904: 0xEFD8,
	26005 - 11904: 0xC4E3,
	26006 - 11904: 0xF7DE,
	26007 - 11904: 0xA4E6,
	26009 - 11904: 0xAEC6,
	26011 - 11904: 0xB1D8,
	26012 - 11904: 0xB1D7,
	26013 - 11904: 0xD97A,
	26014 - 11904: 0xD97B,
	26015 - 11904: 0xB772,
	26016 - 11904: 0xE1F5,
	26017 - 11904: 0xBA57,
	26018 - 11904: 0xE9B2,
	26020 - 11904: 0xA4E7,
	26021 - 11904: 0xA5B8,
	26023 - 11904: 0xA9F2,
	26024 - 11904: 0xCCC2,
	26026 - 11904: 0xCEE9,
	26027 - 11904: 0xAC48,
	26028 - 11904: 0xB1D9,
	26030 - 11904: 0xD97C,
	26031 - 11904: 0xB4B5,
	26032 - 11904: 0xB773,
	26034 - 11904: 0xE5C1,
	26035 - 11904: 0xE5C2,
	26037 - 11904: 0xFCCD,
	26038 - 11904: 0xECF0,
	26039 - 11904: 0xC25F,
	26040 - 11904: 0xF8F0,
	26041 - 11904: 0xA4E8,
	26043 - 11904: 0xCCC3,
	26044 - 11904: 0xA9F3,
	26045 - 11904: 0xAC49,
	26046 - 11904: 0x9CF3,
	26047 - 11904: 0xCEEA,
	26049 - 11904: 0xAEC7,
	26050 - 11904: 0xD1D2,
	26051 - 11904: 0xD1D0,
	26052 - 11904: 0xD1D1,
	26053 - 11904: 0xAEC8,
	26054 - 11904: 0xD1CF,
	26059 - 11904: 0xB1DB,
	26060 - 11904: 0xB1DC,
	26061 - 11904: 0xD5A8,
	26062 - 11904: 0xB1DD,
	26063 - 11904: 0xB1DA,
	26064 - 11904: 0xD97D,
	26065 - 11904: 0xFCD0,
	26066 - 11904: 0xD97E,
	26067 - 11904: 0xDDBE,
	26068 - 11904: 0x95BB,
	26070 - 11904: 0xBA59,
	26071 - 11904: 0xBA58,
	26074 - 11904: 0xECF1,
	26075 - 11904: 0xEFD9,
	26077 - 11904: 0xF24A,
	26078 - 11904: 0xF249,
	26079 - 11904: 0xF44F,
	26080 - 11904: 0xFCD3,
	26081 - 11904: 0xC95E,
	26082 - 11904: 0xAC4A,
	26083 - 11904: 0xFCD4,
	26085 - 11904: 0xA4E9,
	26086 - 11904: 0xA5B9,
	26088 - 11904: 0xA6AE,
	26089 - 11904: 0xA6AD,
	26092 - 11904: 0xA6AF,
	26093 - 11904: 0xA6B0,
	26094 - 11904: 0xC9EE,
	26095 - 11904: 0xC9ED,
	26096 - 11904: 0xCAF8,
	26097 - 11904: 0xA7F2,
	26098 - 11904: 0xCAFB,
	26099 - 11904: 0xCAFA,
	26100 - 11904: 0xCAF9,
	26101 - 11904: 0xCAFC,
	26106 - 11904: 0xA9F4,
	26107 - 11904: 0xCCC9,
	26108 - 11904: 0xCCC5,
	26109 - 11904: 0xCCCE,
	26111 - 11904: 0x8DAE,
	26112 - 11904: 0xA9FB,
	26114 - 11904: 0xA9F9,
	26115 - 11904: 0xCCCA,
	26116 - 11904: 0xCCC6,
	26117 - 11904: 0xCCCD,
	26118 - 11904: 0xA9F8,
	26119 - 11904: 0xAA40,
	26120 - 11904: 0xCCC8,
	26121 - 11904: 0xCCC4,
	26122 - 11904: 0xA9FE,
	26123 - 11904: 0xCCCB,
	26124 - 11904: 0xA9F7,
	26125 - 11904: 0xCCCC,
	26126 - 11904: 0xA9FA,
	26127 - 11904: 0xA9FC,
	26128 - 11904: 0xCCD0,
	26129 - 11904: 0xCCCF,
	26130 - 11904: 0xCCC7,
	26131 - 11904: 0xA9F6,
	26132 - 11904: 0xA9F5,
	26133 - 11904: 0xA9FD,
	26136 - 11904: 0xFCD7,
	26140 - 11904: 0xCEEF,
	26141 - 11904: 0xCEF5,
	26142 - 11904: 0x93DB,
	26143 - 11904: 0xAC50,
	26144 - 11904: 0xAC4D,
	26145 - 11904: 0xCEEC,
	26146 - 11904: 0xCEF1,
	26147 - 11904: 0xFE63,
	26148 - 11904: 0xAC53,
	26149 - 11904: 0xAC4B,
	26150 - 11904: 0xCEF0,
	26151 - 11904: 0xAC4E,
	26152 - 11904: 0xAC51,
	26155 - 11904: 0xCEF3,
	26157 - 11904: 0xAC4C,
	26158 - 11904: 0xCEF8,
	26159 - 11904: 0xAC4F,
	26160 - 11904: 0x93D5,
	26161 - 11904: 0xAC52,
	26162 - 11904: 0xCEED,
	26163 - 11904: 0xCEF2,
	26164 - 11904: 0xCEF6,
	26165 - 11904: 0xCEEE,
	26166 - 11904: 0xCEEB,
	26169 - 11904: 0xCEF7,
	26170 - 11904: 0xCEF4,
	26177 - 11904: 0xAED0,
	26178 - 11904: 0xAEC9,
	26179 - 11904: 0xAECC,
	26180 - 11904: 0xFCDA,
	26181 - 11904: 0xAECF,
	26183 - 11904: 0xD1D5,
	26184 - 11904: 0x9B71,
	26185 - 11904: 0xAECA,
	26186 - 11904: 0xD1D3,
	26187 - 11904: 0xFCDD,
	26188 - 11904: 0xAECE,
	26189 - 11904: 0x8764,
	26191 - 11904: 0xAECB,
	26193 - 11904: 0xD1D6,
	26194 - 11904: 0xAECD,
	26195 - 11904: 0x8DAF,
	26199 - 11904: 0xFAF2,
	26201 - 11904: 0xD5AC,
	26202 - 11904: 0xB1DF,
	26203 - 11904: 0xD5AB,
	26204 - 11904: 0xD5AD,
	26205 - 11904: 0xB1DE,
	26206 - 11904: 0xB1E3,
	26207 - 11904: 0xD1D4,
	26208 - 11904: 0x87B5,
	26209 - 11904: 0xD5AA,
	26210 - 11904: 0xD5AE,
	26211 - 11904: 0x93D8,
	26212 - 11904: 0xB1E0,
	26213 - 11904: 0xD5A9,
	26214 - 11904: 0xB1E2,
	26215 - 11904: 0xFCDF,
	26216 - 11904: 0xB1E1,
	26218 - 11904: 0xD9A7,
	26219 - 11904: 0x93D3,
	26220 - 11904: 0xD9A2,
	26222 - 11904: 0xB4B6,
	26223 - 11904: 0xB4BA,
	26224 - 11904: 0xB4B7,
	26225 - 11904: 0xD9A5,
	26226 - 11904: 0xD9A8,
	26227 - 11904: 0xFCE1,
	26228 - 11904: 0xFCE2,
	26230 - 11904: 0xB4B9,
	26231 - 11904: 0xB4BE,
	26232 - 11904: 0xDDC7,
	26233 - 11904: 0xD9A6,
	26234 - 11904: 0xB4BC,
	26235 - 11904: 0xD9A3,
	26236 - 11904: 0xD9A1,
	26237 - 11904: 0x8E76,
	26238 - 11904: 0xB4BD,
	26240 - 11904: 0xD9A4,
	26244 - 11904: 0xB779,
	26245 - 11904: 0xFC62,
	26246 - 11904: 0xDDBF,
	26247 - 11904: 0xB776,
	26248 - 11904: 0xB777,
	26249 - 11904: 0xB775,
	26250 - 11904: 0xDDC4,
	26251 - 11904: 0xDDC3,
	26252 - 11904: 0xDDC0,
	26253 - 11904: 0xB77B,
	26254 - 11904: 0x93D1,
	26256 - 11904: 0xDDC2,
	26257 - 11904: 0xB4BB,
	26258 - 11904: 0x8DB1,
	26260 - 11904: 0xDDC6,
	26261 - 11904: 0xDDC1,
	26262 - 11904: 0xB778,
	26263 - 11904: 0xB774,
	26264 - 11904: 0xB77A,
	26265 - 11904: 0xDDC5,
	26266 - 11904: 0x9859,
	26269 - 11904: 0xBA5C,
	26271 - 11904: 0xE1F8,
	26272 - 11904: 0xE1F7,
	26273 - 11904: 0xE1F6,
	26274 - 11904: 0xBA5A,
	26276 - 11904: 0xFB52,
	26280 - 11904: 0xBA5B,
	26281 - 11904: 0xE5C5,
	26282 - 11904: 0xE5C8,
	26283 - 11904: 0xBCC8,
	26285 - 11904: 0xFB53,
	26286 - 11904: 0xBCC7,
	26287 - 11904: 0xE5C9,
	26288 - 11904: 0xE5C4,
	26289 - 11904: 0xBCCA,
	26290 - 11904: 0xE5C6,
	26291 - 11904: 0xFB4D,
	26292 - 11904: 0xBCC9,
	26293 - 11904: 0xE5C3,
	26294 - 11904: 0x9CBF,
	26295 - 11904: 0xE5C7,
	26296 - 11904: 0xBEE9,
	26297 - 11904: 0xBEE6,
	26298 - 11904: 0xE9BB,
	26299 - 11904: 0xE9BA,
	26301 - 11904: 0xE9B9,
	26302 - 11904: 0xE9B4,
	26303 - 11904: 0x9B72,
	26304 - 11904: 0xE9B5,
	26308 - 11904: 0xBEE7,
	26310 - 11904: 0xBEE4,
	26311 - 11904: 0xBEE8,
	26312 - 11904: 0xE9B3,
	26313 - 11904: 0xBEE5,
	26314 - 11904: 0xE9B6,
	26315 - 11904: 0xE9B7,
	26316 - 11904: 0xE9BC,
	26317 - 11904: 0xFB50,
	26318 - 11904: 0x93BE,
	26319 - 11904: 0xE9B8,
	26322 - 11904: 0xECF2,
	26326 - 11904: 0xC0C7,
	26328 - 11904: 0xEFDC,
	26329 - 11904: 0xC0C6,
	26330 - 11904: 0xEFDA,
	26331 - 11904: 0xEFDB,
	26332 - 11904: 0xC260,
	26333 - 11904: 0xC36E,
	26334 - 11904: 0xF24B,
	26336 - 11904: 0xC36D,
	26339 - 11904: 0xF451,
	26340 - 11904: 0xF452,
	26342 - 11904: 0xC466,
	26343 - 11904: 0x8CDB,
	26344 - 11904: 0xF450,
	26345 - 11904: 0xC4E4,
	26347 - 11904: 0xF7DF,
	26348 - 11904: 0xC5CE,
	26349 - 11904: 0xF8AA,
	26350 - 11904: 0xF8AB,
	26352 - 11904: 0xA4EA,
	26353 - 11904: 0x9DF1,
	26354 - 11904: 0xA6B1,
	26355 - 11904: 0xA6B2,
	26356 - 11904: 0xA7F3,
	26358 - 11904: 0xCCD1,
	26359 - 11904: 0xAC54,
	26360 - 11904: 0xAED1,
	26361 - 11904: 0xB1E4,
	26364 - 11904: 0xB0D2,
	26366 - 11904: 0xB4BF,
	26367 - 11904: 0xB4C0,
	26368 - 11904: 0xB3CC,
	26369 - 11904: 0xD9A9,
	26370 - 11904: 0xFCEB,
	26371 - 11904: 0xB77C,
	26372 - 11904: 0xE1FA,
	26373 - 11904: 0xE1F9,
	26376 - 11904: 0xA4EB,
	26377 - 11904: 0xA6B3,
	26378 - 11904: 0xCCD2,
	26379 - 11904: 0xAA42,
	26380 - 11904: 0xA0BB,
	26381 - 11904: 0xAA41,
	26382 - 11904: 0x9B7E,
	26383 - 11904: 0xCEF9,
	26384 - 11904: 0xCEFA,
	26386 - 11904: 0xD1D7,
	26387 - 11904: 0xD1D8,
	26388 - 11904: 0xAED2,
	26389 - 11904: 0xAED3,
	26390 - 11904: 0x8DB3,
	26391 - 11904: 0xAED4,
	26392 - 11904: 0xD5AF,
	26393 - 11904: 0x8C52,
	26395 - 11904: 0xB1E6,
	26397 - 11904: 0xB4C2,
	26398 - 11904: 0x9AE8,
	26399 - 11904: 0xB4C1,
	26400 - 11904: 0xDDC8,
	26401 - 11904: 0xDF7A,
	26402 - 11904: 0xE1FB,
	26403 - 11904: 0xE9BD,
	26405 - 11904: 0x8EDC,
	26406 - 11904: 0xC261,
	26407 - 11904: 0xC467,
	26408 - 11904: 0xA4EC,
	26410 - 11904: 0xA5BC,
	26411 - 11904: 0xA5BD,
	26412 - 11904: 0xA5BB,
	26413 - 11904: 0xA5BE,
	26414 - 11904: 0xA5BA,
	26417 - 11904: 0xA6B6,
	26419 - 11904: 0xC9F6,
	26420 - 11904: 0xA6B5,
	26421 - 11904: 0xA6B7,
	26422 - 11904: 0x9CF9,
	26424 - 11904: 0xC9F1,
	26425 - 11904: 0xC9F0,
	26426 - 11904: 0xC9F3,
	26427 - 11904: 0xC9F2,
	26428 - 11904: 0xC9F5,
	26429 - 11904: 0xA6B4,
	26430 - 11904: 0xC9EF,
	26431 - 11904: 0xC9F4,
	26436 - 11904: 0xFA50,
	26437 - 11904: 0xCAFD,
	26438 - 11904: 0xA7FD,
	26439 - 11904: 0xCAFE,
	26440 - 11904: 0xCB43,
	26441 - 11904: 0xA7FC,
	26443 - 11904: 0xCB47,
	26444 - 11904: 0xCB42,
	26445 - 11904: 0xCB45,
	26446 - 11904: 0xA7F5,
	26447 - 11904: 0xA7F6,
	26448 - 11904: 0xA7F7,
	26449 - 11904: 0xA7F8,
	26451 - 11904: 0xA840,
	26453 - 11904: 0xCB41,
	26454 - 11904: 0xA7FA,
	26455 - 11904: 0xA841,
	26457 - 11904: 0xCB40,
	26458 - 11904: 0xCB46,
	26460 - 11904: 0xA7F9,
	26461 - 11904: 0xCB44,
	26462 - 11904: 0xFCF1,
	26463 - 11904: 0xA7F4,
	26464 - 11904: 0xA7FE,
	26465 - 11904: 0x98E7,
	26466 - 11904: 0xFCF3,
	26471 - 11904: 0xFCF2,
	26474 - 11904: 0xAA57,
	26475 - 11904: 0x8CCA,
	26476 - 11904: 0xCCD4,
	26477 - 11904: 0xAA43,
	26478 - 11904: 0x8775,
	26479 - 11904: 0xAA4D,
	26480 - 11904: 0xAA4E,
	26481 - 11904: 0xAA46,
	26482 - 11904: 0xAA58,
	26483 - 11904: 0xAA48,
	26484 - 11904: 0xCCDC,
	26485 - 11904: 0xAA53,
	26486 - 11904: 0xCCD7,
	26487 - 11904: 0xAA49,
	26488 - 11904: 0xCCE6,
	26489 - 11904: 0xCCE7,
	26490 - 11904: 0xCCDF,
	26491 - 11904: 0xCCD8,
	26492 - 11904: 0xAA56,
	26493 - 11904: 0xCCE4,
	26494 - 11904: 0xAA51,
	26495 - 11904: 0xAA4F,
	26497 - 11904: 0xCCE5,
	26498 - 11904: 0x87BA,
	26499 - 11904: 0xCCE3,
	26500 - 11904: 0xCCDB,
	26501 - 11904: 0xCCD3,
	26502 - 11904: 0xCCDA,
	26503 - 11904: 0xAA4A,
	26505 - 11904: 0xAA50,
	26507 - 11904: 0xAA44,
	26508 - 11904: 0xCCDE,
	26509 - 11904: 0xCCDD,
	26510 - 11904: 0xCCD5,
	26511 - 11904: 0x93E5,
	26512 - 11904: 0xAA52,
	26513 - 11904: 0xCCE1,
	26514 - 11904: 0xCCD6,
	26515 - 11904: 0xAA55,
	26516 - 11904: 0xCCE8,
	26517 - 11904: 0xAA45,
	26519 - 11904: 0xAA4C,
	26520 - 11904: 0xCCD9,
	26521 - 11904: 0xCCE2,
	26522 - 11904: 0xAA54,
	26524 - 11904: 0xAA47,
	26525 - 11904: 0xAA4B,
	26527 - 11904: 0xCCE0,
	26528 - 11904: 0x9A59,
	26532 - 11904: 0x8DB5,
	26540 - 11904: 0xFD4D,
	26542 - 11904: 0xCF5B,
	26543 - 11904: 0xAC5C,
	26544 - 11904: 0xAC69,
	26545 - 11904: 0xFD5E,
	26546 - 11904: 0xCF56,
	26547 - 11904: 0xCF4C,
	26548 - 11904: 0xAC62,
	26549 - 11904: 0xCF4A,
	26550 - 11904: 0xAC5B,
	26551 - 11904: 0xCF45,
	26552 - 11904: 0xAC65,
	26553 - 11904: 0xCF52,
	26554 - 11904: 0xCEFE,
	26555 - 11904: 0xCF41,
	26559 - 11904: 0x8F7D,
	26560 - 11904: 0xCF44,
	26561 - 11904: 0xCEFB,
	26562 - 11904: 0xCF51,
	26563 - 11904: 0xCF61,
	26564 - 11904: 0xAC60,
	26565 - 11904: 0xCF46,
	26566 - 11904: 0xCF58,
	26568 - 11904: 0xCEFD,
	26569 - 11904: 0xCF5F,
	26570 - 11904: 0xCF60,
	26571 - 11904: 0xCF63,
	26572 - 11904: 0xCF5A,
	26573 - 11904: 0xCF4B,
	26574 - 11904: 0xCF53,
	26575 - 11904: 0xAC66,
	26576 - 11904: 0xAC59,
	26577 - 11904: 0xAC61,
	26578 - 11904: 0xAC6D,
	26579 - 11904: 0xAC56,
	26580 - 11904: 0xAC58,
	26582 - 11904: 0x9547,
	26583 - 11904: 0xFCF6,
	26584 - 11904: 0xCF43,
	26585 - 11904: 0xAC6A,
	26586 - 11904: 0xAC63,
	26587 - 11904: 0xCF5D,
	26588 - 11904: 0xCF40,
	26589 - 11904: 0xAC6C,
	26590 - 11904: 0xAC67,
	26591 - 11904: 0xCF49,
	26594 - 11904: 0xAC6B,
	26595 - 11904: 0xCF50,
	26596 - 11904: 0xCF48,
	26597 - 11904: 0xAC64,
	26598 - 11904: 0xCF5C,
	26599 - 11904: 0xCF54,
	26601 - 11904: 0xAC5E,
	26602 - 11904: 0xCF62,
	26603 - 11904: 0xCF47,
	26604 - 11904: 0xAC5A,
	26605 - 11904: 0xCF59,
	26606 - 11904: 0xCF4F,
	26607 - 11904: 0xAC5F,
	26608 - 11904: 0xCF55,
	26609 - 11904: 0xAC57,
	26610 - 11904: 0xCEFC,
	26611 - 11904: 0xAC68,
	26612 - 11904: 0xAEE3,
	26613 - 11904: 0xAC5D,
	26614 - 11904: 0xCF4E,
	26615 - 11904: 0xCF4D,
	26616 - 11904: 0xCF42,
	26617 - 11904: 0x9250,
	26618 - 11904: 0xCF5E,
	26620 - 11904: 0xCF57,
	26622 - 11904: 0x8968,
	26623 - 11904: 0xAC55,
	26624 - 11904: 0x8DB6,
	26625 - 11904: 0xFCFB,
	26626 - 11904: 0xA07D,
	26627 - 11904: 0x98FC,
	26628 - 11904: 0x8969,
	26637 - 11904: 0xFE4F,
	26640 - 11904: 0x9256,
	26642 - 11904: 0xD1EC,
	26643 - 11904: 0xAEEA,
	26644 - 11904: 0xD1ED,
	26646 - 11904: 0xD1E1,
	26647 - 11904: 0xAEDF,
	26648 - 11904: 0xAEEB,
	26650 - 11904: 0xD1DA,
	26651 - 11904: 0xFAC9,
	26652 - 11904: 0xD1E3,
	26653 - 11904: 0xD1EB,
	26654 - 11904: 0x93E8,
	26655 - 11904: 0xD1D9,
	26656 - 11904: 0xD1F4,
	26657 - 11904: 0xAED5,
	26658 - 11904: 0xFCF8,
	26661 - 11904: 0xD1F3,
	26662 - 11904: 0xD1EE,
	26664 - 11904: 0xD1EF,
	26665 - 11904: 0xAEDD,
	26666 - 11904: 0xAEE8,
	26667 - 11904: 0xD1E5,
	26669 - 11904: 0xD1E6,
	26670 - 11904: 0xD1F0,
	26671 - 11904: 0xD1E7,
	26673 - 11904: 0xD1E2,
	26674 - 11904: 0xD1DC,
	26675 - 11904: 0xD1DD,
	26676 - 11904: 0xD1EA,
	26677 - 11904: 0xD1E4,
	26678 - 11904: 0x9CE3,
	26679 - 11904: 0xFDA9,
	26680 - 11904: 0xAED6,
	26681 - 11904: 0xAEDA,
	26682 - 11904: 0xD1F2,
	26683 - 11904: 0xD1DE,
	26684 - 11904: 0xAEE6,
	26685 - 11904: 0xAEE2,
	26686 - 11904: 0xFC44,
	26688 - 11904: 0xAEE5,
	26689 - 11904: 0xAEEC,
	26690 - 11904: 0xAEDB,
	26691 - 11904: 0xAEE7,
	26692 - 11904: 0xD1E9,
	26693 - 11904: 0xAEE9,
	26694 - 11904: 0xAED8,
	26695 - 11904: 0x9640,
	26696 - 11904: 0xAED7,
	26697 - 11904: 0xD1DB,
	26698 - 11904: 0x8DB8,
	26699 - 11904: 0xD1DF,
	26700 - 11904: 0xAEE0,
	26701 - 11904: 0xD1F1,
	26702 - 11904: 0xD1E8,
	26703 - 11904: 0xD1E0,
	26704 - 11904: 0xAEE4,
	26705 - 11904: 0xAEE1,
	26707 - 11904: 0xAED9,
	26708 - 11904: 0xAEDC,
	26709 - 11904: 0x9B4A,
	26710 - 11904: 0x8FB9,
	26717 - 11904: 0xFCFE,
	26725 - 11904: 0x896A,
	26731 - 11904: 0xD5C4,
	26733 - 11904: 0xD5B4,
	26734 - 11904: 0xD5B5,
	26735 - 11904: 0xD5B9,
	26737 - 11904: 0xD5C8,
	26738 - 11904: 0xD5C5,
	26740 - 11904: 0xD5BE,
	26741 - 11904: 0xD5BD,
	26742 - 11904: 0xB1ED,
	26743 - 11904: 0xD5C1,
	26744 - 11904: 0xD5D0,
	26745 - 11904: 0xD5B0,
	26747 - 11904: 0xD5D1,
	26748 - 11904: 0xD5C3,
	26749 - 11904: 0xD5D5,
	26750 - 11904: 0xD5C9,
	26751 - 11904: 0xB1EC,
	26752 - 11904: 0xD5C7,
	26753 - 11904: 0xB1E7,
	26754 - 11904: 0xB1FC,
	26755 - 11904: 0xB1F2,
	26756 - 11904: 0x8DB9,
	26757 - 11904: 0xB1F6,
	26758 - 11904: 0xB1F5,
	26759 - 11904: 0xD5B1,
	26760 - 11904: 0x917E,
	26761 - 11904: 0xD5CE,
	26762 - 11904: 0xD5D4,
	26763 - 11904: 0xD5CC,
	26764 - 11904: 0xD5D3,
	26767 - 11904: 0xD5C0,
	26768 - 11904: 0xD5B2,
	26769 - 11904: 0xD5D2,
	26770 - 11904: 0xD5C2,
	26771 - 11904: 0xB1EA,
	26772 - 11904: 0xB1F7,
	26774 - 11904: 0xD5CB,
	26775 - 11904: 0xB1F0,
	26776 - 11904: 0x93F4,
	26779 - 11904: 0xD5CA,
	26780 - 11904: 0xD5B3,
	26781 - 11904: 0xB1F8,
	26783 - 11904: 0xB1FA,
	26784 - 11904: 0xD5CD,
	26785 - 11904: 0xB1FB,
	26786 - 11904: 0xB1E9,
	26787 - 11904: 0xD5BA,
	26788 - 11904: 0xD5CF,
	26790 - 11904: 0xFB7C,
	26791 - 11904: 0xB1EF,
	26792 - 11904: 0xB1F9,
	26793 - 11904: 0xD5BC,
	26794 - 11904: 0xD5C6,
	26795 - 11904: 0xD5B7,
	26796 - 11904: 0xD5BB,
	26797 - 11904: 0xB1F4,
	26798 - 11904: 0xD5B6,
	26799 - 11904: 0xB1E8,
	26800 - 11904: 0xB1F1,
	26801 - 11904: 0xB1EE,
	26802 - 11904: 0xD5BF,
	26803 - 11904: 0xAEDE,
	26804 - 11904: 0xD9C0,
	26805 - 11904: 0xB1EB,
	26806 - 11904: 0x93E7,
	26809 - 11904: 0x97EF,
	26813 - 11904: 0xFE4A,
	26819 - 11904: 0xFD45,
	26820 - 11904: 0xB1F3,
	26821 - 11904: 0x96A5,
	26822 - 11904: 0xD9C3,
	26823 - 11904: 0xD9D9,
	26824 - 11904: 0xD9CE,
	26825 - 11904: 0xB4D6,
	26826 - 11904: 0xFEE0,
	26827 - 11904: 0xB4D1,
	26828 - 11904: 0xD9BD,
	26829 - 11904: 0xB4D2,
	26830 - 11904: 0xD9CD,
	26832 - 11904: 0xD9C6,
	26833 - 11904: 0xD9D3,
	26834 - 11904: 0xB4CE,
	26835 - 11904: 0xD9AB,
	26836 - 11904: 0xD9D5,
	26837 - 11904: 0xB4C4,
	26838 - 11904: 0xD9B3,
	26839 - 11904: 0xB4C7,
	26840 - 11904: 0xB4C6,
	26842 - 11904: 0xB4D7,
	26844 - 11904: 0xD9AD,
	26845 - 11904: 0xD9CF,
	26846 - 11904: 0xD9D0,
	26847 - 11904: 0xB4C9,
	26848 - 11904: 0xB4C5,
	26849 - 11904: 0xD9BB,
	26851 - 11904: 0xB4D0,
	26852 - 11904: 0xD9B6,
	26854 - 11904: 0xD9D1,
	26855 - 11904: 0xB4CC,
	26856 - 11904: 0xD9C9,
	26857 - 11904: 0xD9D6,
	26858 - 11904: 0xD9B0,
	26859 - 11904: 0xD9B5,
	26860 - 11904: 0xD9AF,
	26862 - 11904: 0xB4CB,
	26863 - 11904: 0xD9C2,
	26864 - 11904: 0xDDDE,
	26865 - 11904: 0xD9B1,
	26866 - 11904: 0xB4CF,
	26867 - 11904: 0xD9BA,
	26868 - 11904: 0xD9D2,
	26869 - 11904: 0xB4CA,
	26870 - 11904: 0xD9B7,
	26871 - 11904: 0xD9B4,
	26872 - 11904: 0xD9C5,
	26873 - 11904: 0xB4CD,
	26874 - 11904: 0xB4C3,
	26875 - 11904: 0xB4D9,
	26876 - 11904: 0xD9C8,
	26877 - 11904: 0xD9C7,
	26880 - 11904: 0xFD48,
	26881 - 11904: 0xFD47,
	26882 - 11904: 0xFEF2,
	26883 - 11904: 0xFE6A,
	26884 - 11904: 0xD9AC,
	26885 - 11904: 0xB4C8,
	26886 - 11904: 0xD9D4,
	26887 - 11904: 0xD9BC,
	26888 - 11904: 0xD9BE,
	26889 - 11904: 0x8DBD,
	26890 - 11904: 0xD9CB,
	26891 - 11904: 0xD9CA,
	26892 - 11904: 0xD9AA,
	26893 - 11904: 0xB4D3,
	26894 - 11904: 0xB4D5,
	26895 - 11904: 0xD9B2,
	26896 - 11904: 0xD9B9,
	26897 - 11904: 0xD9C1,
	26898 - 11904: 0xB4D4,
	26899 - 11904: 0xD9B8,
	26900 - 11904: 0xD9C4,
	26901 - 11904: 0xD9D7,
	26903 - 11904: 0xD9CC,
	26904 - 11904: 0x9BA1,
	26905 - 11904: 0x8CA2,
	26906 - 11904: 0x9AB7,
	26907 - 11904: 0x8EFC,
	26917 - 11904: 0xD9D8,
	26922 - 11904: 0xD9AE,
	26924 - 11904: 0x9FA1,
	26927 - 11904: 0xDDF2,
	26928 - 11904: 0xB7A6,
	26930 - 11904: 0xDDF0,
	26931 - 11904: 0xDDDB,
	26932 - 11904: 0xDDE0,
	26933 - 11904: 0xDDD9,
	26934 - 11904: 0xFD51,
	26935 - 11904: 0xDDEC,
	26936 - 11904: 0xDDCB,
	26937 - 11904: 0xDDD2,
	26939 - 11904: 0xDDEA,
	26940 - 11904: 0xDDF4,
	26941 - 11904: 0xDDDC,
	26942 - 11904: 0xFAAD,
	26943 - 11904: 0xDDCF,
	26944 - 11904: 0xDDE2,
	26945 - 11904: 0xDDE7,
	26946 - 11904: 0xDDD3,
	26947 - 11904: 0x8DBE,
	26948 - 11904: 0xDDE4,
	26949 - 11904: 0xDDD0,
	26950 - 11904: 0x89A4,
	26952 - 11904: 0xDDD7,
	26953 - 11904: 0xDDD8,
	26954 - 11904: 0xB7A8,
	26955 - 11904: 0xDDEB,
	26956 - 11904: 0xDDE9,
	26958 - 11904: 0xDDCC,
	26959 - 11904: 0xDDEE,
	26961 - 11904: 0xDDEF,
	26962 - 11904: 0xDDF1,
	26963 - 11904: 0xB7AC,
	26964 - 11904: 0xB7A4,
	26965 - 11904: 0x9AD9,
	26966 - 11904: 0xD5B8,
	26967 - 11904: 0xDDD4,
	26968 - 11904: 0xDDE6,
	26969 - 11904: 0xDDD5,
	26970 - 11904: 0xB7A1,
	26971 - 11904: 0xB7B1,
	26972 - 11904: 0xDDED,
	26973 - 11904: 0xB7AF,
	26974 - 11904: 0xB7AB,
	26975 - 11904: 0xDDCA,
	26976 - 11904: 0xB7A3,
	26977 - 11904: 0xFD4E,
	26978 - 11904: 0xDDCD,
	26979 - 11904: 0xB7B0,
	26980 - 11904: 0x8DC0,
	26981 - 11904: 0xDDDD,
	26982 - 11904: 0xDDC9,
	26983 - 11904: 0x97F0,
	26984 - 11904: 0xB7A9,
	26985 - 11904: 0xDDE1,
	26986 - 11904: 0xDDD1,
	26987 - 11904: 0xB7AA,
	26988 - 11904: 0xDDDA,
	26989 - 11904: 0xB77E,
	26990 - 11904: 0xB4D8,
	26991 - 11904: 0xDDE3,
	26992 - 11904: 0xD9BF,
	26993 - 11904: 0xDDCE,
	26994 - 11904: 0x93B4,
	26995 - 11904: 0xFD44,
	26996 - 11904: 0xDDE8,
	26997 - 11904: 0xB7A5,
	26998 - 11904: 0xDDE5,
	26999 - 11904: 0xB7A2,
	27000 - 11904: 0xDDDF,
	27001 - 11904: 0xB7AD,
	27002 - 11904: 0xDDD6,
	27003 - 11904: 0xDDF3,
	27008 - 11904: 0x9FA7,
	27010 - 11904: 0xB7A7,
	27011 - 11904: 0xDEC6,
	27013 - 11904: 0x8DC2,
	27014 - 11904: 0xB7AE,
	27018 - 11904: 0x99B6,
	27021 - 11904: 0xE24A,
	27022 - 11904: 0xE248,
	27024 - 11904: 0xE25E,
	27025 - 11904: 0xE246,
	27027 - 11904: 0xE258,
	27028 - 11904: 0xB77D,
	27029 - 11904: 0xBA5F,
	27030 - 11904: 0xE242,
	27031 - 11904: 0xE25D,
	27032 - 11904: 0xFD52,
	27033 - 11904: 0xE247,
	27034 - 11904: 0xE255,
	27035 - 11904: 0xBA64,
	27036 - 11904: 0xBA5D,
	27038 - 11904: 0xE25B,
	27039 - 11904: 0x8DC1,
	27040 - 11904: 0xE240,
	27041 - 11904: 0xE25A,
	27042 - 11904: 0x8E46,
	27043 - 11904: 0xBA6F,
	27044 - 11904: 0xE251,
	27045 - 11904: 0xE261,
	27046 - 11904: 0xBA6D,
	27047 - 11904: 0xE249,
	27048 - 11904: 0xBA5E,
	27049 - 11904: 0xE24B,
	27050 - 11904: 0xE259,
	27051 - 11904: 0xBA67,
	27052 - 11904: 0xE244,
	27053 - 11904: 0xBA6B,
	27054 - 11904: 0xBA61,
	27055 - 11904: 0xE24D,
	27056 - 11904: 0xE243,
	27057 - 11904: 0xE1FC,
	27058 - 11904: 0xA0D1,
	27059 - 11904: 0xE257,
	27060 - 11904: 0xBA68,
	27061 - 11904: 0xE260,
	27062 - 11904: 0xE1FD,
	27063 - 11904: 0xBA65,
	27065 - 11904: 0xE253,
	27067 - 11904: 0xBA66,
	27068 - 11904: 0xE245,
	27069 - 11904: 0xE250,
	27070 - 11904: 0xE24C,
	27071 - 11904: 0xE24E,
	27072 - 11904: 0x9FCA,
	27073 - 11904: 0xBA60,
	27074 - 11904: 0xE25F,
	27075 - 11904: 0xBA6E,
	27076 - 11904: 0xE24F,
	27078 - 11904: 0xE262,
	27081 - 11904: 0xE1FE,
	27082 - 11904: 0xE254,
	27083 - 11904: 0xBA63,
	27084 - 11904: 0xBA6C,
	27085 - 11904: 0xBA6A,
	27086 - 11904: 0xE241,
	27087 - 11904: 0xE256,
	27088 - 11904: 0xBA69,
	27089 - 11904: 0x92CF,
	27091 - 11904: 0xBA62,
	27092 - 11904: 0xE252,
	27093 - 11904: 0x9CF4,
	27094 - 11904: 0x8DC4,
	27097 - 11904: 0xE25C,
	27105 - 11904: 0xFD41,
	27106 - 11904: 0xE5D5,
	27108 - 11904: 0xE5D1,
	27109 - 11904: 0xE5CD,
	27110 - 11904: 0xE5E1,
	27111 - 11904: 0xE5DE,
	27112 - 11904: 0xBCCD,
	27113 - 11904: 0x9B4C,
	27115 - 11904: 0xE5E5,
	27116 - 11904: 0xE5D4,
	27117 - 11904: 0xBCD8,
	27118 - 11904: 0xE5DB,
	27121 - 11904: 0xE5D0,
	27122 - 11904: 0xE5DA,
	27123 - 11904: 0xBCD5,
	27124 - 11904: 0xE5EE,
	27126 - 11904: 0xE5EB,
	27127 - 11904: 0xE5DD,
	27128 - 11904: 0xE5CE,
	27129 - 11904: 0xFD57,
	27130 - 11904: 0xFCEF,
	27131 - 11904: 0xE5E2,
	27132 - 11904: 0xE5E4,
	27133 - 11904: 0xBCD1,
	27134 - 11904: 0xE5D8,
	27135 - 11904: 0xE5D3,
	27136 - 11904: 0xE5CA,
	27137 - 11904: 0xBCCE,
	27138 - 11904: 0xBCD6,
	27139 - 11904: 0x9CDE,
	27140 - 11904: 0xE5E7,
	27141 - 11904: 0xBCD7,
	27142 - 11904: 0xE5CB,
	27143 - 11904: 0xE5ED,
	27144 - 11904: 0xE5E0,
	27145 - 11904: 0xE5E6,
	27146 - 11904: 0xBCD4,
	27147 - 11904: 0xFD42,
	27148 - 11904: 0x986C,
	27149 - 11904: 0xE5E3,
	27151 - 11904: 0xE5EA,
	27153 - 11904: 0xBCD9,
	27155 - 11904: 0xBCD3,
	27156 - 11904: 0xE5DC,
	27157 - 11904: 0xE5CF,
	27158 - 11904: 0xE5EF,
	27159 - 11904: 0xE5CC,
	27160 - 11904: 0xE5E8,
	27161 - 11904: 0xBCD0,
	27162 - 11904: 0x97F9,
	27163 - 11904: 0xE5D6,
	27164 - 11904: 0x9558,
	27165 - 11904: 0xE5D7,
	27166 - 11904: 0xBCCF,
	27167 - 11904: 0xBCCC,
	27168 - 11904: 0xE5D2,
	27169 - 11904: 0xBCD2,
	27171 - 11904: 0xBCCB,
	27173 - 11904: 0xE5E9,
	27174 - 11904: 0xE5EC,
	27175 - 11904: 0xE5D9,
	27176 - 11904: 0xE9CA,
	27177 - 11904: 0x87B6,
	27179 - 11904: 0x985E,
	27180 - 11904: 0xFE7B,
	27181 - 11904: 0x94CD,
	27186 - 11904: 0xE9C2,
	27187 - 11904: 0x93EE,
	27188 - 11904: 0xE9BE,
	27189 - 11904: 0xBEF6,
	27192 - 11904: 0xBEEB,
	27193 - 11904: 0xBEF0,
	27194 - 11904: 0xBEEC,
	27195 - 11904: 0xE9CC,
	27196 - 11904: 0xE9D7,
	27197 - 11904: 0xBEEA,
	27198 - 11904: 0xE9C4,
	27199 - 11904: 0xE9CD,
	27200 - 11904: 0xE5DF,
	27201 - 11904: 0xE9CE,
	27203 - 11904: 0x8CA3,
	27204 - 11904: 0xBEF1,
	27205 - 11904: 0xFD5A,
	27206 - 11904: 0xE9DD,
	27207 - 11904: 0xBEF5,
	27208 - 11904: 0xBEF8,
	27209 - 11904: 0xE9C0,
	27211 - 11904: 0xBEF4,
	27212 - 11904: 0x93F5,
	27213 - 11904: 0xE9DB,
	27214 - 11904: 0xE9DC,
	27215 - 11904: 0xE9D2,
	27216 - 11904: 0xE9D1,
	27217 - 11904: 0xE9C9,
	27218 - 11904: 0x93EF,
	27219 - 11904: 0x8EEA,
	27220 - 11904: 0xE9D3,
	27221 - 11904: 0xE9DA,
	27222 - 11904: 0xE9D9,
	27223 - 11904: 0x8F5B,
	27224 - 11904: 0xBEEF,
	27225 - 11904: 0xBEED,
	27226 - 11904: 0xE9CB,
	27227 - 11904: 0xE9C8,
	27229 - 11904: 0xE9C5,
	27230 - 11904: 0xE9D8,
	27231 - 11904: 0xBEF7,
	27232 - 11904: 0xE9D6,
	27233 - 11904: 0xBEF3,
	27234 - 11904: 0xBEF2,
	27235 - 11904: 0x8C5E,
	27236 - 11904: 0xE9D0,
	27237 - 11904: 0x8DC6,
	27238 - 11904: 0xE9BF,
	27239 - 11904: 0xE9C1,
	27240 - 11904: 0xE9C3,
	27241 - 11904: 0xE9D5,
	27242 - 11904: 0xE9CF,
	27243 - 11904: 0xBEEE,
	27245 - 11904: 0xE9C6,
	27247 - 11904: 0xE9D4,
	27249 - 11904: 0x8DC8,
	27252 - 11904: 0x8DC7,
	27254 - 11904: 0xE9C7,
	27258 - 11904: 0x93F7,
	27262 - 11904: 0xC0CF,
	27263 - 11904: 0xED45,
	27264 - 11904: 0xC0C8,
	27265 - 11904: 0xECF5,
	27266 - 11904: 0x8DC9,
	27267 - 11904: 0xED41,
	27268 - 11904: 0xC0CA,
	27269 - 11904: 0xED48,
	27271 - 11904: 0xECFC,
	27273 - 11904: 0xECF7,
	27274 - 11904: 0xFBF2,
	27276 - 11904: 0xED49,
	27277 - 11904: 0xECF3,
	27278 - 11904: 0xECFE,
	27279 - 11904: 0x9670,
	27280 - 11904: 0xC0D1,
	27281 - 11904: 0xED44,
	27282 - 11904: 0xED4A,
	27283 - 11904: 0xECFD,
	27284 - 11904: 0xC0C9,
	27285 - 11904: 0xED40,
	27286 - 11904: 0xECF4,
	27287 - 11904: 0xC0D0,
	27289 - 11904: 0x8DCB,
	27290 - 11904: 0xED47,
	27291 - 11904: 0xECF9,
	27292 - 11904: 0xC0CC,
	27293 - 11904: 0xFD5C,
	27294 - 11904: 0xECFB,
	27295 - 11904: 0xECF8,
	27296 - 11904: 0xC0D2,
	27297 - 11904: 0xECFA,
	27298 - 11904: 0xC0CB,
	27299 - 11904: 0xC0CE,
	27300 - 11904: 0xED43,
	27301 - 11904: 0xECF6,
	27302 - 11904: 0xED46,
	27303 - 11904: 0x8F65,
	27304 - 11904: 0xED42,
	27307 - 11904: 0x8DCD,
	27308 - 11904: 0xC263,
	27309 - 11904: 0xEFE7,
	27310 - 11904: 0xC268,
	27311 - 11904: 0xC269,
	27313 - 11904: 0x9DA8,
	27314 - 11904: 0x94F9,
	27315 - 11904: 0xC262,
	27316 - 11904: 0xEFE6,
	27317 - 11904: 0x8DCE,
	27318 - 11904: 0xEFE3,
	27319 - 11904: 0xEFE4,
	27320 - 11904: 0xC266,
	27321 - 11904: 0xEFDE,
	27322 - 11904: 0xEFE2,
	27323 - 11904: 0xC265,
	27325 - 11904: 0xEFDF,
	27326 - 11904: 0x93EA,
	27330 - 11904: 0xC267,
	27331 - 11904: 0xC264,
	27333 - 11904: 0xEFDD,
	27334 - 11904: 0xEFE1,
	27335 - 11904: 0xEFE5,
	27336 - 11904: 0xFD5F,
	27337 - 11904: 0x93F0,
	27338 - 11904: 0x9FB6,
	27339 - 11904: 0xF251,
	27340 - 11904: 0xF24E,
	27341 - 11904: 0xF257,
	27343 - 11904: 0xF256,
	27344 - 11904: 0xF254,
	27345 - 11904: 0xF24F,
	27347 - 11904: 0xC372,
	27348 - 11904: 0x8DCF,
	27352 - 11904: 0x9763,
	27353 - 11904: 0xF250,
	27354 - 11904: 0xC371,
	27355 - 11904: 0xC0CD,
	27356 - 11904: 0xF253,
	27357 - 11904: 0xC370,
	27358 - 11904: 0xF258,
	27359 - 11904: 0xF252,
	27360 - 11904: 0xF24D,
	27361 - 11904: 0xEFE0,
	27365 - 11904: 0xC36F,
	27367 - 11904: 0xF24C,
	27368 - 11904: 0xF456,
	27370 - 11904: 0xF455,
	27371 - 11904: 0xF255,
	27372 - 11904: 0xC468,
	27374 - 11904: 0xF459,
	27375 - 11904: 0xF45A,
	27376 - 11904: 0xF454,
	27377 - 11904: 0xF458,
	27379 - 11904: 0xF453,
	27382 - 11904: 0x8DD0,
	27384 - 11904: 0xF5D1,
	27385 - 11904: 0xF457,
	27386 - 11904: 0xC4E7,
	27387 - 11904: 0xC4E5,
	27388 - 11904: 0xF5CF,
	27392 - 11904: 0xF5D2,
	27394 - 11904: 0xF5CE,
	27395 - 11904: 0xF5D0,
	27396 - 11904: 0xC4E6,
	27397 - 11904: 0x93F1,
	27400 - 11904: 0xF6E5,
	27401 - 11904: 0xF6E6,
	27402 - 11904: 0xC576,
	27403 - 11904: 0xF6E4,
	27407 - 11904: 0xF7E2,
	27408 - 11904: 0xC5CF,
	27409 - 11904: 0xF7E0,
	27410 - 11904: 0xF7E1,
	27411 - 11904: 0xF8AC,
	27414 - 11904: 0xC656,
	27415 - 11904: 0xF8F3,
	27416 - 11904: 0xF8F1,
	27417 - 11904: 0xF8F2,
	27418 - 11904: 0xF8F4,
	27421 - 11904: 0xFD62,
	27422 - 11904: 0xF9BB,
	27424 - 11904: 0xA4ED,
	27425 - 11904: 0xA6B8,
	27427 - 11904: 0xAA59,
	27429 - 11904: 0xCCE9,
	27432 - 11904: 0xCF64,
	27436 - 11904: 0xD1F5,
	27437 - 11904: 0xD1F7,
	27439 - 11904: 0xD1F6,
	27441 - 11904: 0xD1F8,
	27442 - 11904: 0xB1FD,
	27443 - 11904: 0xD5D7,
	27444 - 11904: 0xD1F9,
	27445 - 11904: 0xFD65,
	27446 - 11904: 0xD5D6,
	27447 - 11904: 0xD5D8,
	27448 - 11904: 0xD5D9,
	27449 - 11904: 0xD9DA,
	27450 - 11904: 0xB4DB,
	27451 - 11904: 0xD9DB,
	27452 - 11904: 0xD9DD,
	27453 - 11904: 0xB4DC,
	27454 - 11904: 0xB4DA,
	27455 - 11904: 0xD9DC,
	27457 - 11904: 0xDDFA,
	27458 - 11904: 0xDDF8,
	27459 - 11904: 0xDDF7,
	27461 - 11904: 0xDDF6,
	27462 - 11904: 0xDDF5,
	27463 - 11904: 0xB7B2,
	27464 - 11904: 0xDDF9,
	27465 - 11904: 0xBA70,
	27466 - 11904: 0xE263,
	27467 - 11904: 0xE265,
	27468 - 11904: 0xBA71,
	27469 - 11904: 0xE264,
	27470 - 11904: 0xBCDB,
	27472 - 11904: 0xBCDA,
	27473 - 11904: 0xE5F0,
	27474 - 11904: 0x9FDB,
	27476 - 11904: 0xE9DF,
	27477 - 11904: 0xE9DE,
	27478 - 11904: 0xE9E0,
	27479 - 11904: 0x93F8,
	27481 - 11904: 0xBEF9,
	27483 - 11904: 0xED4B,
	27484 - 11904: 0xC0D3,
	27486 - 11904: 0xEFE8,
	27487 - 11904: 0xC26A,
	27488 - 11904: 0xF259,
	27489 - 11904: 0xC577,
	27490 - 11904: 0xA4EE,
	27491 - 11904: 0xA5BF,
	27492 - 11904: 0xA6B9,
	27493 - 11904: 0xA842,
	27494 - 11904: 0xAA5A,
	27495 - 11904: 0xAA5B,
	27498 - 11904: 0xAC6E,
	27501 - 11904: 0xD1FA,
	27503 - 11904: 0x8BF7,
	27506 - 11904: 0xB7B3,
	27508 - 11904: 0xFD66,
	27510 - 11904: 0xE6D1,
	27511 - 11904: 0xBEFA,
	27512 - 11904: 0xC26B,
	27513 - 11904: 0xA4EF,
	27514 - 11904: 0x8BCF,
	27515 - 11904: 0xA6BA,
	27518 - 11904: 0xCCEB,
	27519 - 11904: 0xAA5C,
	27520 - 11904: 0xCCEA,
	27521 - 11904: 0x8DD1,
	27522 - 11904: 0xCF65,
	27523 - 11904: 0xAC6F,
	27524 - 11904: 0xCF66,
	27526 - 11904: 0xAC70,
	27528 - 11904: 0xD1FC,
	27529 - 11904: 0xAEEE,
	27530 - 11904: 0xAEED,
	27532 - 11904: 0xD5DE,
	27533 - 11904: 0xD5DC,
	27534 - 11904: 0xD5DD,
	27535 - 11904: 0xD5DB,
	27537 - 11904: 0xD5DA,
	27540 - 11904: 0xD9DE,
	27541 - 11904: 0xD9E1,
	27542 - 11904: 0xB4DE,
	27543 - 11904: 0xD9DF,
	27544 - 11904: 0xB4DD,
	27545 - 11904: 0xD9E0,
	27547 - 11904: 0xDDFB,
	27550 - 11904: 0xE266,
	27551 - 11904: 0xE267,
	27552 - 11904: 0xE268,
	27554 - 11904: 0xE5F3,
	27555 - 11904: 0xE5F2,
	27556 - 11904: 0xBCDC,
	27557 - 11904: 0xE5F1,
	27558 - 11904: 0xE5F4,
	27559 - 11904: 0xE9E1,
	27562 - 11904: 0xE9E2,
	27563 - 11904: 0xE9E3,
	27565 - 11904: 0xED4C,
	27566 - 11904: 0xC0D4,
	27567 - 11904: 0xC26C,
	27568 - 11904: 0xF25A,
	27570 - 11904: 0xC4E8,
	27571 - 11904: 0xC95F,
	27573 - 11904: 0xAC71,
	27574 - 11904: 0xCF67,
	27575 - 11904: 0xAEEF,
	27578 - 11904: 0xB1FE,
	27580 - 11904: 0xB4DF,
	27581 - 11904: 0xD9E2,
	27583 - 11904: 0xB7B5,
	27584 - 11904: 0xB7B4,
	27585 - 11904: 0x8DD2,
	27587 - 11904: 0xE269,
	27588 - 11904: 0xE26A,
	27589 - 11904: 0xBCDD,
	27590 - 11904: 0xBCDE,
	27591 - 11904: 0xE9E5,
	27592 - 11904: 0xE9E4,
	27593 - 11904: 0xEFE9,
	27594 - 11904: 0xF7E3,
	27595 - 11904: 0xA4F0,
	27596 - 11904: 0xC960,
	27597 - 11904: 0xA5C0,
	27599 - 11904: 0xA843,
	27600 - 11904: 0xCB48,
	27602 - 11904: 0xAC72,
	27603 - 11904: 0xB7B6,
	27604 - 11904: 0xA4F1,
	27606 - 11904: 0xCF68,
	27607 - 11904: 0xAC73,
	27608 - 11904: 0xCF69,
	27610 - 11904: 0xC0D5,
	27611 - 11904: 0xA4F2,
	27612 - 11904: 0xFD71,
	27614 - 11904: 0xCCEC,
	27616 - 11904: 0xCF6A,
	27617 - 11904: 0xFD6F,
	27618 - 11904: 0xD242,
	27619 - 11904: 0xD241,
	27620 - 11904: 0xD1FE,
	27622 - 11904: 0xD1FD,
	27623 - 11904: 0xD243,
	27624 - 11904: 0xD240,
	27626 - 11904: 0x8DD3,
	27627 - 11904: 0xB240,
	27628 - 11904: 0xB241,
	27631 - 11904: 0xB4E0,
	27632 - 11904: 0xD9E3,
	27634 - 11904: 0xD9E4,
	27635 - 11904: 0xD9E5,
	27639 - 11904: 0xDE41,
	27640 - 11904: 0xDE42,
	27641 - 11904: 0xDE40,
	27642 - 11904: 0x9FE7,
	27643 - 11904: 0xDDFD,
	27644 - 11904: 0xDDFE,
	27645 - 11904: 0xB7B7,
	27646 - 11904: 0xE26B,
	27647 - 11904: 0xE5F7,
	27648 - 11904: 0xE5F6,
	27649 - 11904: 0xE5F5,
	27650 - 11904: 0xE5F8,
	27651 - 11904: 0xE9E7,
	27652 - 11904: 0xE9E6,
	27653 - 11904: 0xBEFB,
	27654 - 11904: 0xE9E8,
	27656 - 11904: 0xC0D6,
	27657 - 11904: 0xED4D,
	27659 - 11904: 0xEFEA,
	27660 - 11904: 0xF25B,
	27661 - 11904: 0xF6E7,
	27663 - 11904: 0xA4F3,
	27664 - 11904: 0xA5C2,
	27665 - 11904: 0xA5C1,
	27667 - 11904: 0xAA5D,
	27668 - 11904: 0xC961,
	27669 - 11904: 0xC97E,
	27670 - 11904: 0xA6BB,
	27672 - 11904: 0xC9F7,
	27673 - 11904: 0xCB49,
	27674 - 11904: 0xCB4A,
	27675 - 11904: 0xAA5E,
	27676 - 11904: 0x90BD,
	27677 - 11904: 0xCCED,
	27679 - 11904: 0xAC74,
	27680 - 11904: 0xCF6B,
	27681 - 11904: 0xCF6C,
	27683 - 11904: 0xAEF0,
	27684 - 11904: 0xAEF4,
	27685 - 11904: 0xD244,
	27686 - 11904: 0xAEF3,
	27687 - 11904: 0xAEF1,
	27688 - 11904: 0xAEF2,
	27690 - 11904: 0xD5DF,
	27691 - 11904: 0xB242,
	27692 - 11904: 0xB4E3,
	27694 - 11904: 0xB4E1,
	27695 - 11904: 0xB4E2,
	27696 - 11904: 0xD9E6,
	27697 - 11904: 0x9FD0,
	27699 - 11904: 0xBA72,
	27700 - 11904: 0xA4F4,
	27701 - 11904: 0x8BD0,
	27702 - 11904: 0xC9A1,
	27703 - 11904: 0xFD72,
	27704 - 11904: 0xA5C3,
	27705 - 11904: 0x9CAE,
	27706 - 11904: 0x8BD1,
	27707 - 11904: 0xC9A4,
	27709 - 11904: 0x8ADB,
	27710 - 11904: 0xA5C6,
	27711 - 11904: 0xC9A3,
	27712 - 11904: 0xA5C5,
	27713 - 11904: 0xA5C4,
	27714 - 11904: 0xA844,
	27715 - 11904: 0xC9A2,
	27718 - 11904: 0xC9F8,
	27721 - 11904: 0xFAE4,
	27722 - 11904: 0xC9FC,
	27723 - 11904: 0xC9FE,
	27724 - 11904: 0xCA40,
	27725 - 11904: 0xA6C5,
	27726 - 11904: 0xA6C6,
	27727 - 11904: 0xC9FB,
	27728 - 11904: 0xA6C1,
	27730 - 11904: 0xC9F9,
	27732 - 11904: 0xC9FD,
	27733 - 11904: 0xA6C2,
	27735 - 11904: 0xA6BD,
	27736 - 11904: 0x95CE,
	27737 - 11904: 0xA6BE,
	27738 - 11904: 0xFD76,
	27739 - 11904: 0xA6C4,
	27740 - 11904: 0xC9FA,
	27741 - 11904: 0xA6BC,
	27742 - 11904: 0xA845,
	27743 - 11904: 0xA6BF,
	27744 - 11904: 0xA6C0,
	27745 - 11904: 0xA6C3,
	27749 - 11904: 0xCB5B,
	27750 - 11904: 0xCB59,
	27751 - 11904: 0xCB4C,
	27752 - 11904: 0xA851,
	27753 - 11904: 0xCB53,
	27754 - 11904: 0xA84C,
	27755 - 11904: 0xCB4D,
	27757 - 11904: 0xCB55,
	27758 - 11904: 0xFB62,
	27759 - 11904: 0xCB52,
	27760 - 11904: 0xA84F,
	27761 - 11904: 0xCB51,
	27762 - 11904: 0xA856,
	27763 - 11904: 0xCB5A,
	27764 - 11904: 0xA858,
	27765 - 11904: 0x8DD4,
	27766 - 11904: 0xA85A,
	27768 - 11904: 0xCB4B,
	27769 - 11904: 0xFD78,
	27770 - 11904: 0xA84D,
	27771 - 11904: 0xCB5C,
	27773 - 11904: 0xA854,
	27774 - 11904: 0xA857,
	27775 - 11904: 0x8EE3,
	27776 - 11904: 0xCD45,
	27777 - 11904: 0xA847,
	27778 - 11904: 0xA85E,
	27779 - 11904: 0xA855,
	27780 - 11904: 0xCB4E,
	27781 - 11904: 0xA84A,
	27782 - 11904: 0xA859,
	27783 - 11904: 0xCB56,
	27784 - 11904: 0xA848,
	27785 - 11904: 0xA849,
	27786 - 11904: 0xCD43,
	27787 - 11904: 0xCB4F,
	27788 - 11904: 0xA850,
	27789 - 11904: 0xA85B,
	27790 - 11904: 0xCB5D,
	27791 - 11904: 0xCB50,
	27792 - 11904: 0xA84E,
	27794 - 11904: 0xA853,
	27795 - 11904: 0xCCEE,
	27796 - 11904: 0xA85C,
	27797 - 11904: 0xCB57,
	27798 - 11904: 0xA852,
	27800 - 11904: 0xA85D,
	27801 - 11904: 0xA846,
	27802 - 11904: 0xCB54,
	27803 - 11904: 0xA84B,
	27804 - 11904: 0xFDB7,
	27805 - 11904: 0xCD44,
	27807 - 11904: 0x9076,
	27810 - 11904: 0x98C6,
	27818 - 11904: 0x8DD5,
	27819 - 11904: 0xAA6A,
	27820 - 11904: 0xAA7A,
	27821 - 11904: 0xCCF5,
	27822 - 11904: 0xAA71,
	27823 - 11904: 0x97D1,
	27824 - 11904: 0xCD4B,
	27825 - 11904: 0xAA62,
	27826 - 11904: 0x9EB6,
	27827 - 11904: 0xAA65,
	27828 - 11904: 0xCD42,
	27830 - 11904: 0xCCF3,
	27831 - 11904: 0xCCF7,
	27832 - 11904: 0xAA6D,
	27833 - 11904: 0xAA6F,
	27834 - 11904: 0xCCFA,
	27835 - 11904: 0xAA76,
	27836 - 11904: 0xAA68,
	27837 - 11904: 0xAA66,
	27838 - 11904: 0xAA67,
	27839 - 11904: 0xAA75,
	27840 - 11904: 0xCD47,
	27841 - 11904: 0xAA70,
	27842 - 11904: 0xCCF9,
	27843 - 11904: 0xCCFB,
	27844 - 11904: 0xAA6E,
	27845 - 11904: 0xAA73,
	27846 - 11904: 0xCCFC,
	27847 - 11904: 0xCD4A,
	27849 - 11904: 0xAC75,
	27850 - 11904: 0xAA79,
	27851 - 11904: 0xFAC7,
	27852 - 11904: 0xAA63,
	27853 - 11904: 0xCD49,
	27854 - 11904: 0xA042,
	27855 - 11904: 0xCD4D,
	27856 - 11904: 0xCCF8,
	27857 - 11904: 0xCD4F,
	27858 - 11904: 0xCD40,
	27859 - 11904: 0xAA6C,
	27860 - 11904: 0xCCF4,
	27861 - 11904: 0xAA6B,
	27862 - 11904: 0xAA7D,
	27863 - 11904: 0xAA72,
	27865 - 11904: 0xCCF2,
	27866 - 11904: 0xCF75,
	27867 - 11904: 0xAA78,
	27868 - 11904: 0xAA7C,
	27869 - 11904: 0xCD41,
	27870 - 11904: 0xCD46,
	27871 - 11904: 0x9873,
	27872 - 11904: 0xAA7E,
	27873 - 11904: 0xAA77,
	27874 - 11904: 0xAA69,
	27875 - 11904: 0xAA5F,
	27877 - 11904: 0xAA64,
	27879 - 11904: 0xCCF6,
	27880 - 11904: 0xAA60,
	27881 - 11904: 0xCD4E,
	27882 - 11904: 0x9FFC,
	27883 - 11904: 0xCCF0,
	27884 - 11904: 0xCCEF,
	27885 - 11904: 0xCCFD,
	27886 - 11904: 0xCCF1,
	27887 - 11904: 0xAA7B,
	27888 - 11904: 0xAEF5,
	27889 - 11904: 0xAA74,
	27890 - 11904: 0xCCFE,
	27891 - 11904: 0xAA61,
	27893 - 11904: 0xACA6,
	27897 - 11904: 0xCD4C,
	27903 - 11904: 0x8CA5,
	27904 - 11904: 0xCF7C,
	27905 - 11904: 0xCFA1,
	27906 - 11904: 0x8DD7,
	27907 - 11904: 0xCFA4,
	27908 - 11904: 0xCF77,
	27909 - 11904: 0x92FB,
	27910 - 11904: 0x8DD8,
	27911 - 11904: 0xCFA7,
	27912 - 11904: 0xCFAA,
	27913 - 11904: 0xCFAC,
	27914 - 11904: 0xCF74,
	27915 - 11904: 0xAC76,
	27916 - 11904: 0xAC7B,
	27917 - 11904: 0xD249,
	27918 - 11904: 0xACAD,
	27919 - 11904: 0xCFA5,
	27920 - 11904: 0xCFAD,
	27921 - 11904: 0xCF7B,
	27922 - 11904: 0xCF73,
	27926 - 11904: 0xD264,
	27927 - 11904: 0xAC7E,
	27928 - 11904: 0xCFA2,
	27929 - 11904: 0xCF78,
	27930 - 11904: 0xCF7A,
	27931 - 11904: 0xACA5,
	27933 - 11904: 0xCF7D,
	27934 - 11904: 0xAC7D,
	27935 - 11904: 0xCF70,
	27936 - 11904: 0xCFA8,
	27938 - 11904: 0xCFAB,
	27940 - 11904: 0x944F,
	27941 - 11904: 0xAC7A,
	27942 - 11904: 0x8DD9,
	27943 - 11904: 0xACA8,
	27944 - 11904: 0xCF6D,
	27945 - 11904: 0xACAA,
	27946 - 11904: 0xAC78,
	27947 - 11904: 0xACAE,
	27948 - 11904: 0xCFA9,
	27949 - 11904: 0xCF6F,
	27950 - 11904: 0xACAB,
	27951 - 11904: 0xD25E,
	27952 - 11904: 0xCD48,
	27953 - 11904: 0xAC7C,
	27954 - 11904: 0xAC77,
	27955 - 11904: 0xCF76,
	27956 - 11904: 0xCF6E,
	27957 - 11904: 0xACAC,
	27958 - 11904: 0xACA4,
	27959 - 11904: 0xCFA3,
	27960 - 11904: 0xACA9,
	27961 - 11904: 0xACA7,
	27962 - 11904: 0xCF79,
	27963 - 11904: 0xACA1,
	27964 - 11904: 0xCF71,
	27965 - 11904: 0xACA2,
	27966 - 11904: 0xACA3,
	27967 - 11904: 0xCF72,
	27968 - 11904: 0xCFA6,
	27969 - 11904: 0xAC79,
	27970 - 11904: 0xCF7E,
	27982 - 11904: 0x896B,
	27991 - 11904: 0x97CE,
	27992 - 11904: 0xD24C,
	27993 - 11904: 0xAEFD,
	27994 - 11904: 0xAF43,
	27995 - 11904: 0xFAF3,
	27996 - 11904: 0xFDAE,
	27998 - 11904: 0xD255,
	27999 - 11904: 0xD25B,
	28000 - 11904: 0xD257,
	28001 - 11904: 0xD24A,
	28002 - 11904: 0xD24D,
	28003 - 11904: 0xD246,
	28004 - 11904: 0xD247,
	28005 - 11904: 0xAF4A,
	28006 - 11904: 0xAEFA,
	28007 - 11904: 0xD256,
	28008 - 11904: 0xD25F,
	28009 - 11904: 0xAF45,
	28010 - 11904: 0xAEF6,
	28012 - 11904: 0xAF40,
	28013 - 11904: 0xD24E,
	28014 - 11904: 0xAF42,
	28015 - 11904: 0xD24F,
	28016 - 11904: 0xD259,
	28017 - 11904: 0xFBAF,
	28018 - 11904: 0x92B7,
	28020 - 11904: 0xAF44,
	28021 - 11904: 0xD268,
	28022 - 11904: 0xD248,
	28023 - 11904: 0xAEFC,
	28024 - 11904: 0xAEFB,
	28025 - 11904: 0xAF48,
	28026 - 11904: 0xD245,
	28027 - 11904: 0xD266,
	28028 - 11904: 0xD25A,
	28029 - 11904: 0xD267,
	28030 - 11904: 0xD261,
	28031 - 11904: 0xD253,
	28032 - 11904: 0xD262,
	28033 - 11904: 0x8DDA,
	28034 - 11904: 0xD25C,
	28035 - 11904: 0xD265,
	28036 - 11904: 0xD263,
	28037 - 11904: 0xAF49,
	28038 - 11904: 0xD254,
	28039 - 11904: 0xAEF9,
	28040 - 11904: 0xAEF8,
	28041 - 11904: 0xAF41,
	28042 - 11904: 0xAF47,
	28043 - 11904: 0xD260,
	28044 - 11904: 0xAF46,
	28045 - 11904: 0xD251,
	28046 - 11904: 0xB243,
	28047 - 11904: 0x9C5A,
	28048 - 11904: 0xD269,
	28049 - 11904: 0xD250,
	28050 - 11904: 0xD24B,
	28051 - 11904: 0xAEFE,
	28052 - 11904: 0xAF4B,
	28053 - 11904: 0xAEF7,
	28054 - 11904: 0xFDAD,
	28055 - 11904: 0xD258,
	28056 - 11904: 0xD25D,
	28068 - 11904: 0x8DDC,
	28069 - 11904: 0x9444,
	28074 - 11904: 0xB265,
	28075 - 11904: 0xD5E1,
	28076 - 11904: 0xD5E5,
	28078 - 11904: 0xB252,
	28079 - 11904: 0xB250,
	28081 - 11904: 0x8DDD,
	28082 - 11904: 0xB247,
	28083 - 11904: 0xD5E3,
	28084 - 11904: 0xD5E2,
	28085 - 11904: 0xB25B,
	28087 - 11904: 0xD5E8,
	28088 - 11904: 0xB255,
	28089 - 11904: 0xA0D6,
	28090 - 11904: 0xD5FA,
	28091 - 11904: 0xD647,
	28092 - 11904: 0xB244,
	28093 - 11904: 0xD5F7,
	28094 - 11904: 0xD5F0,
	28095 - 11904: 0xB267,
	28096 - 11904: 0xD5E0,
	28098 - 11904: 0xD5FC,
	28100 - 11904: 0xB264,
	28101 - 11904: 0xB258,
	28102 - 11904: 0xB263,
	28103 - 11904: 0xB24E,
	28104 - 11904: 0xD5EC,
	28105 - 11904: 0xD5FE,
	28106 - 11904: 0xD5F6,
	28107 - 11904: 0xB24F,
	28108 - 11904: 0xB249,
	28109 - 11904: 0xD645,
	28111 - 11904: 0xD5FD,
	28112 - 11904: 0xD640,
	28113 - 11904: 0xB251,
	28114 - 11904: 0xB259,
	28115 - 11904: 0xD642,
	28116 - 11904: 0xD5EA,
	28117 - 11904: 0xD5FB,
	28118 - 11904: 0xD5EF,
	28119 - 11904: 0xD644,
	28120 - 11904: 0xB25E,
	28121 - 11904: 0xB246,
	28122 - 11904: 0xB25C,
	28123 - 11904: 0xD5F4,
	28124 - 11904: 0xD5F2,
	28125 - 11904: 0xD5F3,
	28126 - 11904: 0xB253,
	28127 - 11904: 0xD5EE,
	28128 - 11904: 0xD5ED,
	28129 - 11904: 0xB248,
	28130 - 11904: 0xD5E7,
	28131 - 11904: 0xD646,
	28132 - 11904: 0xB24A,
	28133 - 11904: 0xD5F1,
	28134 - 11904: 0xB268,
	28136 - 11904: 0xB262,
	28137 - 11904: 0xD5E6,
	28138 - 11904: 0xB25F,
	28139 - 11904: 0xB25D,
	28140 - 11904: 0xB266,
	28141 - 11904: 0xD5F8,
	28142 - 11904: 0xB261,
	28143 - 11904: 0xD252,
	28144 - 11904: 0xD5F9,
	28145 - 11904: 0xB260,
	28146 - 11904: 0xD641,
	28147 - 11904: 0xB245,
	28148 - 11904: 0xD5F5,
	28149 - 11904: 0xB257,
	28150 - 11904: 0xD5E9,
	28151 - 11904: 0xB256,
	28153 - 11904: 0xB254,
	28154 - 11904: 0xB24C,
	28155 - 11904: 0xB24B,
	28156 - 11904: 0xD9E7,
	28157 - 11904: 0xD643,
	28158 - 11904: 0x8C41,
	28160 - 11904: 0xD5EB,
	28162 - 11904: 0x97D5,
	28163 - 11904: 0xD9FC,
	28164 - 11904: 0x944A,
	28165 - 11904: 0xB24D,
	28170 - 11904: 0x944D,
	28175 - 11904: 0x97CB,
	28181 - 11904: 0x8DDE,
	28184 - 11904: 0x8DDF,
	28185 - 11904: 0xB541,
	28186 - 11904: 0xB25A,
	28187 - 11904: 0xB4EE,
	28188 - 11904: 0xD9F6,
	28189 - 11904: 0xFDB8,
	28191 - 11904: 0xD9EA,
	28192 - 11904: 0xB4EB,
	28193 - 11904: 0xB4E7,
	28194 - 11904: 0xDA49,
	28195 - 11904: 0xB4ED,
	28196 - 11904: 0xB4F1,
	28197 - 11904: 0xB4EC,
	28198 - 11904: 0xB4F5,
	28199 - 11904: 0xDA4D,
	28200 - 11904: 0xDA44,
	28201 - 11904: 0x8DE0,
	28202 - 11904: 0xFEF9,
	28203 - 11904: 0xD9F1,
	28204 - 11904: 0xB4FA,
	28205 - 11904: 0xB4F4,
	28206 - 11904: 0xD9FD,
	28207 - 11904: 0xFDBB,
	28208 - 11904: 0xDA4A,
	28209 - 11904: 0xDA43,
	28210 - 11904: 0xB4E8,
	28211 - 11904: 0xD9F7,
	28212 - 11904: 0xB4F7,
	28213 - 11904: 0xDA55,
	28214 - 11904: 0xDA56,
	28216 - 11904: 0xB4E5,
	28217 - 11904: 0xDA48,
	28218 - 11904: 0xB4F9,
	28219 - 11904: 0xD9FB,
	28220 - 11904: 0xD9ED,
	28221 - 11904: 0xD9EE,
	28222 - 11904: 0xB4FD,
	28223 - 11904: 0xD9F2,
	28224 - 11904: 0xD9F9,
	28225 - 11904: 0xD9F3,
	28227 - 11904: 0xB4FB,
	28228 - 11904: 0xB544,
	28229 - 11904: 0xD9EF,
	28230 - 11904: 0xD9E8,
	28231 - 11904: 0xD9E9,
	28233 - 11904: 0xD9EB,
	28234 - 11904: 0xB4EA,
	28235 - 11904: 0xD9F8,
	28237 - 11904: 0xB4F8,
	28238 - 11904: 0xB542,
	28239 - 11904: 0xFDC0,
	28240 - 11904: 0xFCF9,
	28241 - 11904: 0xD9FA,
	28242 - 11904: 0xDA53,
	28243 - 11904: 0xDA4B,
	28244 - 11904: 0xB4E6,
	28245 - 11904: 0xDA51,
	28246 - 11904: 0xB4F2,
	28247 - 11904: 0x8CDD,
	28248 - 11904: 0xB4F0,
	28249 - 11904: 0xFB7E,
	28250 - 11904: 0xDA57,
	28251 - 11904: 0xB4EF,
	28252 - 11904: 0xDA41,
	28253 - 11904: 0xD9F4,
	28254 - 11904: 0xD9FE,
	28255 - 11904: 0xB547,
	28256 - 11904: 0xDA45,
	28257 - 11904: 0xDA42,
	28258 - 11904: 0xD9F0,
	28259 - 11904: 0xB543,
	28260 - 11904: 0xDA4F,
	28261 - 11904: 0xDA4C,
	28262 - 11904: 0xDA54,
	28263 - 11904: 0xB4E9,
	28264 - 11904: 0xDA40,
	28265 - 11904: 0xB546,
	28267 - 11904: 0xDA47,
	28270 - 11904: 0xB4F3,
	28271 - 11904: 0xB4F6,
	28273 - 11904: 0xDA46,
	28274 - 11904: 0xB545,
	28275 - 11904: 0xD9F5,
	28276 - 11904: 0xD5E4,
	28278 - 11904: 0x92B3,
	28279 - 11904: 0xDA50,
	28280 - 11904: 0xDA4E,
	28281 - 11904: 0xDA52,
	28284 - 11904: 0xFDAF,
	28294 - 11904: 0x8DE1,
	28296 - 11904: 0xD9EC,
	28297 - 11904: 0xB540,
	28299 - 11904: 0x95D3,
	28301 - 11904: 0xDE61,
	28302 - 11904: 0xDE60,
	28303 - 11904: 0xDE46,
	28304 - 11904: 0xB7BD,
	28306 - 11904: 0xDE5F,
	28307 - 11904: 0xDE49,
	28308 - 11904: 0xDE4A,
	28310 - 11904: 0xB7C7,
	28311 - 11904: 0xDE68,
	28312 - 11904: 0xB7C2,
	28313 - 11904: 0xDE5E,
	28314 - 11904: 0x89C1,
	28315 - 11904: 0xDE43,
	28316 - 11904: 0xB7C8,
	28317 - 11904: 0xB7BE,
	28318 - 11904: 0xDE52,
	28319 - 11904: 0xDE48,
	28320 - 11904: 0xDE4B,
	28321 - 11904: 0xDE63,
	28322 - 11904: 0xB7B8,
	28323 - 11904: 0xDE6A,
	28324 - 11904: 0xDE62,
	28325 - 11904: 0xB7C1,
	28326 - 11904: 0xDE57,
	28327 - 11904: 0xB7CC,
	28330 - 11904: 0xB7CB,
	28331 - 11904: 0xB7C5,
	28334 - 11904: 0xDE69,
	28335 - 11904: 0xB7B9,
	28336 - 11904: 0xDE55,
	28337 - 11904: 0xDE4C,
	28338 - 11904: 0xDE59,
	28339 - 11904: 0xDE65,
	28340 - 11904: 0xB7CD,
	28341 - 11904: 0xFD68,
	28342 - 11904: 0xB7BB,
	28343 - 11904: 0xDE54,
	28344 - 11904: 0x9CB7,
	28345 - 11904: 0xDE4D,
	28346 - 11904: 0xB7C4,
	28347 - 11904: 0x8DE3,
	28348 - 11904: 0xB7C3,
	28349 - 11904: 0xDE50,
	28350 - 11904: 0xDE5A,
	28351 - 11904: 0xDE64,
	28352 - 11904: 0xDE47,
	28353 - 11904: 0xDE51,
	28354 - 11904: 0xB7BC,
	28355 - 11904: 0xDE5B,
	28356 - 11904: 0xB7C9,
	28357 - 11904: 0xB7C0,
	28358 - 11904: 0xDE4E,
	28359 - 11904: 0xB7BF,
	28360 - 11904: 0xDE45,
	28361 - 11904: 0xDE53,
	28362 - 11904: 0xDE67,
	28363 - 11904: 0xB4FE,
	28364 - 11904: 0xBAB0,
	28365 - 11904: 0xDE56,
	28366 - 11904: 0xE26C,
	28367 - 11904: 0xDE58,
	28368 - 11904: 0xDE66,
	28369 - 11904: 0xB7C6,
	28370 - 11904: 0xDE4F,
	28371 - 11904: 0xB7BA,
	28372 - 11904: 0xB7CA,
	28373 - 11904: 0xBCF0,
	28374 - 11904: 0xDE44,
	28376 - 11904: 0xDE5D,
	28377 - 11904: 0xFAC0,
	28378 - 11904: 0x8DE5,
	28379 - 11904: 0xFA64,
	28380 - 11904: 0xDE5C,
	28381 - 11904: 0x8947,
	28386 - 11904: 0x8DE4,
	28392 - 11904: 0x8DE7,
	28393 - 11904: 0x8DE8,
	28395 - 11904: 0xE2AA,
	28396 - 11904: 0xBAAD,
	28397 - 11904: 0xE27D,
	28398 - 11904: 0xE2A4,
	28399 - 11904: 0xBAA2,
	28401 - 11904: 0xE26E,
	28402 - 11904: 0xBAAF,
	28404 - 11904: 0xBA77,
	28405 - 11904: 0xE26D,
	28406 - 11904: 0xE2B0,
	28407 - 11904: 0xBAB1,
	28408 - 11904: 0xE271,
	28409 - 11904: 0xE2A3,
	28410 - 11904: 0xFDC7,
	28411 - 11904: 0xE273,
	28412 - 11904: 0xE2B3,
	28413 - 11904: 0xE2AF,
	28414 - 11904: 0xBA75,
	28415 - 11904: 0xBAA1,
	28416 - 11904: 0xE653,
	28417 - 11904: 0xBAAE,
	28418 - 11904: 0xBA7D,
	28419 - 11904: 0xE26F,
	28420 - 11904: 0xFDB0,
	28421 - 11904: 0xE2AE,
	28422 - 11904: 0xBAA3,
	28423 - 11904: 0xE2AB,
	28424 - 11904: 0xE2B8,
	28425 - 11904: 0xE275,
	28426 - 11904: 0xE27E,
	28427 - 11904: 0x9445,
	28428 - 11904: 0x97D6,
	28429 - 11904: 0xE2B6,
	28430 - 11904: 0xE2AC,
	28431 - 11904: 0xBA7C,
	28434 - 11904: 0xE27C,
	28435 - 11904: 0xBA76,
	28436 - 11904: 0xBA74,
	28437 - 11904: 0xBAA8,
	28438 - 11904: 0xFCC6,
	28439 - 11904: 0x9844,
	28440 - 11904: 0xE27A,
	28441 - 11904: 0xE277,
	28442 - 11904: 0xE278,
	28444 - 11904: 0xE2B2,
	28446 - 11904: 0xE2B7,
	28447 - 11904: 0xE2B5,
	28448 - 11904: 0xBA7A,
	28449 - 11904: 0xE2B9,
	28450 - 11904: 0xBA7E,
	28451 - 11904: 0xBAA7,
	28452 - 11904: 0x8DE9,
	28453 - 11904: 0xE270,
	28454 - 11904: 0xE5FA,
	28455 - 11904: 0xE279,
	28457 - 11904: 0xBA78,
	28458 - 11904: 0xBAAC,
	28459 - 11904: 0xBAA9,
	28460 - 11904: 0xBA7B,
	28461 - 11904: 0xE2A5,
	28462 - 11904: 0xE274,
	28463 - 11904: 0xBAAA,
	28464 - 11904: 0xE2A7,
	28465 - 11904: 0xBAA4,
	28466 - 11904: 0xBAA6,
	28467 - 11904: 0xBA73,
	28468 - 11904: 0x8DEA,
	28469 - 11904: 0xE2A9,
	28470 - 11904: 0xE2A1,
	28471 - 11904: 0xE272,
	28472 - 11904: 0xBAA5,
	28473 - 11904: 0xE2B1,
	28474 - 11904: 0xE2B4,
	28475 - 11904: 0xE27B,
	28476 - 11904: 0xE2A8,
	28477 - 11904: 0xFE50,
	28478 - 11904: 0xBA79,
	28479 - 11904: 0xBCDF,
	28480 - 11904: 0xE2A6,
	28481 - 11904: 0xE5F9,
	28483 - 11904: 0xE2AD,
	28484 - 11904: 0xFDCC,
	28494 - 11904: 0xE276,
	28495 - 11904: 0xE644,
	28496 - 11904: 0xE64E,
	28497 - 11904: 0xBCE2,
	28498 - 11904: 0xE64D,
	28499 - 11904: 0xE659,
	28500 - 11904: 0xBCE4,
	28501 - 11904: 0xE64B,
	28502 - 11904: 0x9DA7,
	28503 - 11904: 0xE64F,
	28504 - 11904: 0xBCEF,
	28506 - 11904: 0xE646,
	28507 - 11904: 0xBCE7,
	28508 - 11904: 0xFDCD,
	28509 - 11904: 0xE652,
	28510 - 11904: 0xE9F0,
	28511 - 11904: 0xBCF3,
	28512 - 11904: 0xBCF2,
	28513 - 11904: 0xE654,
	28514 - 11904: 0xE643,
	28515 - 11904: 0xE65E,
	28516 - 11904: 0xBCED,
	28518 - 11904: 0xBCE3,
	28519 - 11904: 0xE657,
	28521 - 11904: 0xE65B,
	28522 - 11904: 0xE660,
	28523 - 11904: 0xE655,
	28524 - 11904: 0xE649,
	28525 - 11904: 0xBCE6,
	28526 - 11904: 0xBCE9,
	28527 - 11904: 0xBCF1,
	28528 - 11904: 0xBCEC,
	28530 - 11904: 0xE64C,
	28531 - 11904: 0xE2A2,
	28532 - 11904: 0xFDCF,
	28534 - 11904: 0xE648,
	28535 - 11904: 0xE65F,
	28536 - 11904: 0xBCE8,
	28537 - 11904: 0x95D2,
	28538 - 11904: 0xBCEB,
	28539 - 11904: 0xE661,
	28540 - 11904: 0xBCE0,
	28541 - 11904: 0xE656,
	28542 - 11904: 0xE5FB,
	28543 - 11904: 0xE65C,
	28544 - 11904: 0xC0DF,
	28545 - 11904: 0x8DED,
	28546 - 11904: 0xE64A,
	28548 - 11904: 0xBCE1,
	28549 - 11904: 0xE645,
	28550 - 11904: 0xBCE5,
	28551 - 11904: 0xE5FC,
	28552 - 11904: 0xBAAB,
	28553 - 11904: 0xE641,
	28554 - 11904: 0xFCBA,
	28555 - 11904: 0xE65A,
	28556 - 11904: 0xE642,
	28557 - 11904: 0xE640,
	28558 - 11904: 0xBCEA,
	28560 - 11904: 0xE658,
	28562 - 11904: 0xE5FE,
	28563 - 11904: 0xE651,
	28564 - 11904: 0xE650,
	28565 - 11904: 0xE65D,
	28566 - 11904: 0xE647,
	28567 - 11904: 0xBCEE,
	28573 - 11904: 0xFDC5,
	28574 - 11904: 0xE9F3,
	28575 - 11904: 0xFDD2,
	28576 - 11904: 0xBF49,
	28577 - 11904: 0xBEFE,
	28578 - 11904: 0xEA40,
	28579 - 11904: 0xE9EB,
	28580 - 11904: 0xBF41,
	28581 - 11904: 0xE9F7,
	28582 - 11904: 0xBF48,
	28583 - 11904: 0xBF43,
	28584 - 11904: 0xE9F5,
	28585 - 11904: 0xED4F,
	28586 - 11904: 0xE9FB,
	28587 - 11904: 0xEA42,
	28588 - 11904: 0xE9FA,
	28589 - 11904: 0xE9E9,
	28590 - 11904: 0xE9F8,
	28591 - 11904: 0xEA44,
	28592 - 11904: 0xEA46,
	28593 - 11904: 0xBEFD,
	28594 - 11904: 0xEA45,
	28595 - 11904: 0xBF44,
	28596 - 11904: 0xBF4A,
	28597 - 11904: 0x9CDC,
	28598 - 11904: 0xBF47,
	28600 - 11904: 0xE9FE,
	28601 - 11904: 0xBF46,
	28602 - 11904: 0xE9F9,
	28603 - 11904: 0x95CF,
	28604 - 11904: 0xE9ED,
	28605 - 11904: 0xE9F2,
	28606 - 11904: 0x8DEE,
	28607 - 11904: 0xE9FD,
	28608 - 11904: 0xBF45,
	28609 - 11904: 0xBF42,
	28610 - 11904: 0xBEFC,
	28611 - 11904: 0xBF40,
	28612 - 11904: 0xE9F1,
	28614 - 11904: 0xE5FD,
	28615 - 11904: 0xE9EC,
	28616 - 11904: 0xE9EF,
	28617 - 11904: 0xEA41,
	28618 - 11904: 0xE9F4,
	28619 - 11904: 0xE9EA,
	28620 - 11904: 0xED4E,
	28621 - 11904: 0xEA43,
	28622 - 11904: 0xE9EE,
	28623 - 11904: 0xE9FC,
	28627 - 11904: 0xFDD4,
	28628 - 11904: 0xED51,
	28629 - 11904: 0xC0E3,
	28632 - 11904: 0xC0D7,
	28633 - 11904: 0x96EC,
	28634 - 11904: 0x96EB,
	28635 - 11904: 0xC0DB,
	28636 - 11904: 0xED53,
	28637 - 11904: 0xED59,
	28638 - 11904: 0xED57,
	28639 - 11904: 0xC0D9,
	28640 - 11904: 0xC0DA,
	28641 - 11904: 0xC0E1,
	28642 - 11904: 0xED5A,
	28643 - 11904: 0xED52,
	28644 - 11904: 0xC0DC,
	28646 - 11904: 0xED56,
	28647 - 11904: 0xED55,
	28648 - 11904: 0xED5B,
	28649 - 11904: 0xC0E2,
	28651 - 11904: 0xC0DD,
	28652 - 11904: 0xC0E0,
	28653 - 11904: 0xED54,
	28654 - 11904: 0xC0E4,
	28655 - 11904: 0xC0DE,
	28656 - 11904: 0xC0E5,
	28657 - 11904: 0xC0D8,
	28658 - 11904: 0xED58,
	28660 - 11904: 0xED50,
	28662 - 11904: 0x90B6,
	28663 - 11904: 0xEFF7,
	28664 - 11904: 0xFDC3,
	28666 - 11904: 0xC271,
	28667 - 11904: 0xEFF4,
	28668 - 11904: 0xEFF6,
	28670 - 11904: 0xC26F,
	28671 - 11904: 0xEFF2,
	28672 - 11904: 0xEFF3,
	28673 - 11904: 0xEFEE,
	28675 - 11904: 0x98AB,
	28676 - 11904: 0xE9F6,
	28677 - 11904: 0xEFEF,
	28678 - 11904: 0xC270,
	28679 - 11904: 0xEFEB,
	28681 - 11904: 0xC26D,
	28682 - 11904: 0xEFF8,
	28683 - 11904: 0xC26E,
	28684 - 11904: 0xEFEC,
	28685 - 11904: 0xEFED,
	28686 - 11904: 0xEFF1,
	28687 - 11904: 0xC273,
	28689 - 11904: 0xC272,
	28692 - 11904: 0xEFF0,
	28693 - 11904: 0xC378,
	28694 - 11904: 0xF25F,
	28695 - 11904: 0xF265,
	28696 - 11904: 0xC379,
	28697 - 11904: 0xF25C,
	28698 - 11904: 0xC376,
	28699 - 11904: 0xC373,
	28700 - 11904: 0xF267,
	28701 - 11904: 0xC377,
	28702 - 11904: 0x96EE,
	28703 - 11904: 0xC374,
	28704 - 11904: 0xF25E,
	28705 - 11904: 0xF261,
	28706 - 11904: 0xF262,
	28707 - 11904: 0xF263,
	28708 - 11904: 0xF266,
	28710 - 11904: 0xEFF5,
	28711 - 11904: 0xF25D,
	28712 - 11904: 0xC375,
	28713 - 11904: 0xF264,
	28714 - 11904: 0xF268,
	28715 - 11904: 0xF260,
	28716 - 11904: 0x8DF4,
	28719 - 11904: 0xF45D,
	28720 - 11904: 0xC46A,
	28721 - 11904: 0xF460,
	28722 - 11904: 0xC46B,
	28723 - 11904: 0xF468,
	28724 - 11904: 0xF45F,
	28725 - 11904: 0xF45C,
	28727 - 11904: 0xF45E,
	28728 - 11904: 0xF462,
	28729 - 11904: 0xF465,
	28730 - 11904: 0xF464,
	28731 - 11904: 0xF467,
	28732 - 11904: 0xF45B,
	28734 - 11904: 0xC469,
	28735 - 11904: 0xF463,
	28736 - 11904: 0xF466,
	28737 - 11904: 0xF469,
	28738 - 11904: 0xF461,
	28739 - 11904: 0xF5D3,
	28740 - 11904: 0xF5D4,
	28741 - 11904: 0xF5D8,
	28742 - 11904: 0xF5D9,
	28744 - 11904: 0xF5D6,
	28745 - 11904: 0xF5D7,
	28746 - 11904: 0xF5D5,
	28747 - 11904: 0xFDE0,
	28748 - 11904: 0xC4E9,
	28749 - 11904: 0x8C67,
	28752 - 11904: 0x8DF6,
	28753 - 11904: 0xC578,
	28754 - 11904: 0xF6EB,
	28756 - 11904: 0x8DF7,
	28757 - 11904: 0xF6E8,
	28758 - 11904: 0xF6E9,
	28759 - 11904: 0xF6EA,
	28760 - 11904: 0xC579,
	28762 - 11904: 0xF7E5,
	28763 - 11904: 0xF7E4,
	28764 - 11904: 0x8FFA,
	28765 - 11904: 0xF8AF,
	28766 - 11904: 0xC5F4,
	28767 - 11904: 0xF8AD,
	28768 - 11904: 0xF8B0,
	28769 - 11904: 0xF8AE,
	28770 - 11904: 0xF8F5,
	28771 - 11904: 0xC657,
	28772 - 11904: 0xC665,
	28773 - 11904: 0xF9A3,
	28774 - 11904: 0xF96C,
	28775 - 11904: 0x97D0,
	28776 - 11904: 0xF9A2,
	28777 - 11904: 0xF9D0,
	28778 - 11904: 0xF9D1,
	28779 - 11904: 0xA4F5,
	28780 - 11904: 0x8BD2,
	28782 - 11904: 0x87DE,
	28783 - 11904: 0x8DF8,
	28784 - 11904: 0xA6C7,
	28785 - 11904: 0xCA41,
	28788 - 11904: 0xCB5E,
	28789 - 11904: 0x90D9,
	28790 - 11904: 0xA85F,
	28791 - 11904: 0x8C47,
	28792 - 11904: 0xA862,
	28793 - 11904: 0xFAF0,
	28794 - 11904: 0xCB5F,
	28796 - 11904: 0xA860,
	28797 - 11904: 0xA861,
	28798 - 11904: 0xFDE1,
	28799 - 11904: 0x8DF9,
	28801 - 11904: 0xFDE3,
	28802 - 11904: 0xCD58,
	28803 - 11904: 0xCD5A,
	28804 - 11904: 0xCD55,
	28805 - 11904: 0xCD52,
	28806 - 11904: 0xCD54,
	28809 - 11904: 0x8DFA,
	28810 - 11904: 0xAAA4,
	28811 - 11904: 0xFB63,
	28814 - 11904: 0xAAA2,
	28815 - 11904: 0x90A6,
	28817 - 11904: 0xCD56,
	28818 - 11904: 0xAAA3,
	28819 - 11904: 0xCD53,
	28820 - 11904: 0xCD50,
	28821 - 11904: 0xAAA1,
	28822 - 11904: 0xCD57,
	28824 - 11904: 0xCD51,
	28825 - 11904: 0xAAA5,
	28826 - 11904: 0xCD59,
	28831 - 11904: 0xCFAF,
	28832 - 11904: 0x9970,
	28833 - 11904: 0xCFB3,
	28835 - 11904: 0x91EB,
	28836 - 11904: 0xACB7,
	28837 - 11904: 0x9770,
	28838 - 11904: 0x986F,
	28839 - 11904: 0xFDE2,
	28841 - 11904: 0xCFB6,
	28843 - 11904: 0xACAF,
	28844 - 11904: 0xACB2,
	28845 - 11904: 0xACB4,
	28846 - 11904: 0xACB6,
	28847 - 11904: 0xACB3,
	28848 - 11904: 0xCFB2,
	28849 - 11904: 0xCFB1,
	28851 - 11904: 0xACB1,
	28852 - 11904: 0xCFB4,
	28853 - 11904: 0xCFB5,
	28855 - 11904: 0xCFAE,
	28856 - 11904: 0xACB5,
	28857 - 11904: 0x98F2,
	28858 - 11904: 0xACB0,
	28859 - 11904: 0x9AFC,
	28860 - 11904: 0x896C,
	28861 - 11904: 0xFDFD,
	28862 - 11904: 0xCFB0,
	28864 - 11904: 0x995E,
	28868 - 11904: 0x95BD,
	28869 - 11904: 0xD277,
	28870 - 11904: 0xD278,
	28871 - 11904: 0xD279,
	28872 - 11904: 0xAF50,
	28874 - 11904: 0xAF4C,
	28875 - 11904: 0xD26E,
	28876 - 11904: 0xFDE4,
	28877 - 11904: 0xD276,
	28878 - 11904: 0xD27B,
	28879 - 11904: 0xAF51,
	28880 - 11904: 0x91E6,
	28881 - 11904: 0xD26C,
	28882 - 11904: 0xD272,
	28883 - 11904: 0xD26B,
	28884 - 11904: 0xD275,
	28885 - 11904: 0xFDE5,
	28886 - 11904: 0xFDE6,
	28887 - 11904: 0xD271,
	28888 - 11904: 0xAF4D,
	28889 - 11904: 0xAF4F,
	28890 - 11904: 0xD27A,
	28892 - 11904: 0xD26A,
	28893 - 11904: 0xD26D,
	28894 - 11904: 0xD273,
	28895 - 11904: 0xFDE7,
	28896 - 11904: 0xD274,
	28897 - 11904: 0xD27C,
	28898 - 11904: 0xD270,
	28900 - 11904: 0xAF4E,
	28911 - 11904: 0xB26D,
	28912 - 11904: 0xD64E,
	28913 - 11904: 0x9454,
	28915 - 11904: 0xD650,
	28916 - 11904: 0xD64C,
	28917 - 11904: 0x99B8,
	28918 - 11904: 0xD658,
	28919 - 11904: 0xD64A,
	28920 - 11904: 0xD657,
	28921 - 11904: 0xB269,
	28922 - 11904: 0xD648,
	28923 - 11904: 0xDA5B,
	28924 - 11904: 0xD652,
	28925 - 11904: 0xB26C,
	28926 - 11904: 0x97E9,
	28927 - 11904: 0xD653,
	28928 - 11904: 0xD656,
	28930 - 11904: 0xD65A,
	28932 - 11904: 0xD64F,
	28933 - 11904: 0x9346,
	28934 - 11904: 0xD654,
	28937 - 11904: 0xB26A,
	28938 - 11904: 0xB26B,
	28939 - 11904: 0xD659,
	28940 - 11904: 0xD64D,
	28941 - 11904: 0xD649,
	28942 - 11904: 0xD65B,
	28944 - 11904: 0xD651,
	28947 - 11904: 0xD655,
	28951 - 11904: 0xD64B,
	28953 - 11904: 0xB548,
	28954 - 11904: 0xB549,
	28955 - 11904: 0xDA65,
	28956 - 11904: 0xB54F,
	28957 - 11904: 0x9863,
	28958 - 11904: 0xDA59,
	28959 - 11904: 0xDA62,
	28960 - 11904: 0xDA58,
	28961 - 11904: 0xB54C,
	28962 - 11904: 0xDA60,
	28963 - 11904: 0xDA5E,
	28965 - 11904: 0xDA5F,
	28966 - 11904: 0xB54A,
	28968 - 11904: 0xDA63,
	28969 - 11904: 0x95BC,
	28971 - 11904: 0xFDED,
	28972 - 11904: 0xFDF7,
	28974 - 11904: 0xDA5C,
	28975 - 11904: 0xDA5A,
	28976 - 11904: 0xB54B,
	28977 - 11904: 0xDA5D,
	28978 - 11904: 0xDA61,
	28979 - 11904: 0x9870,
	28980 - 11904: 0x96F6,
	28981 - 11904: 0x8EA9,
	28982 - 11904: 0xB54D,
	28986 - 11904: 0xDA64,
	28987 - 11904: 0x9451,
	28990 - 11904: 0x8E43,
	28992 - 11904: 0x8B5A,
	28993 - 11904: 0xDE70,
	28994 - 11904: 0xDE77,
	28995 - 11904: 0xDE79,
	28996 - 11904: 0xDEA1,
	28997 - 11904: 0xFDEE,
	28998 - 11904: 0xB7DA,
	28999 - 11904: 0xDE6B,
	29001 - 11904: 0xB7D2,
	29002 - 11904: 0xFDF0,
	29003 - 11904: 0xDE7A,
	29004 - 11904: 0xB7D7,
	29005 - 11904: 0xDEA2,
	29006 - 11904: 0xB7CE,
	29007 - 11904: 0xFDF4,
	29008 - 11904: 0xDE7D,
	29009 - 11904: 0x9BF5,
	29010 - 11904: 0xDE6D,
	29011 - 11904: 0xDE7E,
	29012 - 11904: 0xDE6C,
	29014 - 11904: 0xB7DC,
	29015 - 11904: 0x8CEE,
	29016 - 11904: 0xDE78,
	29017 - 11904: 0xB7CF,
	29018 - 11904: 0xDEA3,
	29020 - 11904: 0xB7D4,
	29021 - 11904: 0xDE71,
	29022 - 11904: 0xB7D9,
	29023 - 11904: 0xDE7C,
	29024 - 11904: 0xDE6F,
	29025 - 11904: 0xDE76,
	29026 - 11904: 0xDE72,
	29027 - 11904: 0xDE6E,
	29028 - 11904: 0xB7D1,
	29029 - 11904: 0xB7D8,
	29030 - 11904: 0xB7D6,
	29031 - 11904: 0xB7D3,
	29032 - 11904: 0xB7DB,
	29033 - 11904: 0xB7D0,
	29034 - 11904: 0xDE75,
	29035 - 11904: 0x977E,
	29036 - 11904: 0xB7D5,
	29038 - 11904: 0xFDF1,
	29040 - 11904: 0xDE7B,
	29041 - 11904: 0x9BD5,
	29042 - 11904: 0xDE73,
	29043 - 11904: 0x9AC3,
	29045 - 11904: 0x97C8,
	29046 - 11904: 0xA0DB,
	29047 - 11904: 0x91D0,
	29048 - 11904: 0xDE74,
	29050 - 11904: 0x9FE4,
	29051 - 11904: 0xE2C1,
	29052 - 11904: 0x8FDD,
	29053 - 11904: 0xBAB4,
	29054 - 11904: 0x91E9,
	29056 - 11904: 0xE2BD,
	29057 - 11904: 0xE2C3,
	29058 - 11904: 0xE2BF,
	29060 - 11904: 0xBAB6,
	29061 - 11904: 0xE2BE,
	29062 - 11904: 0xE2C2,
	29063 - 11904: 0xE2BA,
	29064 - 11904: 0x98E0,
	29065 - 11904: 0xE2BC,
	29066 - 11904: 0xBAB5,
	29068 - 11904: 0x92CA,
	29070 - 11904: 0x9857,
	29071 - 11904: 0xE2C0,
	29072 - 11904: 0xE2BB,
	29073 - 11904: 0x8C51,
	29074 - 11904: 0xBAB7,
	29076 - 11904: 0xBAB2,
	29078 - 11904: 0xFDEB,
	29079 - 11904: 0xE2C4,
	29080 - 11904: 0x9B49,
	29081 - 11904: 0xBAB3,
	29082 - 11904: 0xE667,
	29083 - 11904: 0xE664,
	29084 - 11904: 0xE670,
	29085 - 11904: 0xE66A,
	29086 - 11904: 0xE66C,
	29087 - 11904: 0xBCF4,
	29088 - 11904: 0xE666,
	29089 - 11904: 0xE66E,
	29090 - 11904: 0x9D76,
	29091 - 11904: 0x9EAF,
	29092 - 11904: 0xE66D,
	29093 - 11904: 0xE66B,
	29095 - 11904: 0xE671,
	29096 - 11904: 0xBCF7,
	29097 - 11904: 0xE668,
	29098 - 11904: 0xE66F,
	29100 - 11904: 0xBCF5,
	29101 - 11904: 0x9CCC,
	29103 - 11904: 0xE663,
	29104 - 11904: 0xE665,
	29105 - 11904: 0xBCF6,
	29106 - 11904: 0xE662,
	29107 - 11904: 0xE672,
	29108 - 11904: 0xFDEA,
	29109 - 11904: 0xE669,
	29111 - 11904: 0x8DF1,
	29112 - 11904: 0xEA4A,
	29113 - 11904: 0xBF51,
	29114 - 11904: 0xFDFB,
	29116 - 11904: 0xEA55,
	29117 - 11904: 0xEA53,
	29118 - 11904: 0xBF4B,
	29119 - 11904: 0xEA49,
	29120 - 11904: 0xEA4C,
	29121 - 11904: 0xEA4D,
	29122 - 11904: 0xEA48,
	29123 - 11904: 0xBF55,
	29124 - 11904: 0xBF56,
	29125 - 11904: 0xEA47,
	29126 - 11904: 0xEA56,
	29127 - 11904: 0xEA51,
	29128 - 11904: 0xBF4F,
	29129 - 11904: 0xBF4C,
	29130 - 11904: 0xEA50,
	29131 - 11904: 0xEA4E,
	29134 - 11904: 0xBF52,
	29135 - 11904: 0xEA52,
	29136 - 11904: 0xBF4D,
	29137 - 11904: 0x8E53,
	29138 - 11904: 0xBF4E,
	29140 - 11904: 0xEA4F,
	29141 - 11904: 0xBF50,
	29142 - 11904: 0xEA4B,
	29144 - 11904: 0xEA54,
	29145 - 11904: 0xBF53,
	29146 - 11904: 0xEA57,
	29147 - 11904: 0xEA58,
	29148 - 11904: 0xBF54,
	29149 - 11904: 0xFACF,
	29151 - 11904: 0xC0E7,
	29152 - 11904: 0xC0EE,
	29153 - 11904: 0xED5C,
	29154 - 11904: 0xED62,
	29156 - 11904: 0xED60,
	29157 - 11904: 0xC0EA,
	29158 - 11904: 0xC0E9,
	29159 - 11904: 0xC0E6,
	29160 - 11904: 0xED5E,
	29163 - 11904: 0x96F9,
	29164 - 11904: 0xC0EC,
	29165 - 11904: 0xC0EB,
	29166 - 11904: 0xC0E8,
	29168 - 11904: 0xED61,
	29169 - 11904: 0xED5D,
	29170 - 11904: 0xED5F,
	29172 - 11904: 0xC0ED,
	29173 - 11904: 0x98BF,
	29174 - 11904: 0x9E49,
	29176 - 11904: 0xC277,
	29177 - 11904: 0xEFFB,
	29179 - 11904: 0xC274,
	29180 - 11904: 0xC275,
	29181 - 11904: 0xEFFD,
	29182 - 11904: 0xC276,
	29183 - 11904: 0xEFFA,
	29184 - 11904: 0x8CA7,
	29185 - 11904: 0xEFF9,
	29186 - 11904: 0xF26C,
	29187 - 11904: 0xEFFC,
	29189 - 11904: 0xF26D,
	29190 - 11904: 0xC37A,
	29191 - 11904: 0xF26B,
	29193 - 11904: 0x9BCA,
	29194 - 11904: 0xF26A,
	29196 - 11904: 0xF269,
	29197 - 11904: 0xC37B,
	29198 - 11904: 0xFDFE,
	29199 - 11904: 0x92DC,
	29200 - 11904: 0xC46C,
	29203 - 11904: 0xF46A,
	29204 - 11904: 0xF46B,
	29205 - 11904: 0xFE41,
	29206 - 11904: 0x91CC,
	29207 - 11904: 0x91E2,
	29209 - 11904: 0xF5DC,
	29210 - 11904: 0xF5DB,
	29211 - 11904: 0xC4EA,
	29213 - 11904: 0xF5DA,
	29214 - 11904: 0xF6EC,
	29215 - 11904: 0xF6ED,
	29218 - 11904: 0xF7E6,
	29219 - 11904: 0xF8B1,
	29220 - 11904: 0xFE44,
	29221 - 11904: 0x875F,
	29222 - 11904: 0xF8F6,
	29223 - 11904: 0xF9BC,
	29224 - 11904: 0xC679,
	29225 - 11904: 0xF9C6,
	29226 - 11904: 0xA4F6,
	29227 - 11904: 0x8BD3,
	29228 - 11904: 0xAAA6,
	29229 - 11904: 0xAAA7,
	29230 - 11904: 0xFE47,
	29232 - 11904: 0xACB8,
	29237 - 11904: 0xC0EF,
	29238 - 11904: 0xA4F7,
	29240 - 11904: 0xAAA8,
	29241 - 11904: 0xAF52,
	29242 - 11904: 0xB7DD,
	29243 - 11904: 0xA4F8,
	29245 - 11904: 0xB26E,
	29246 - 11904: 0xBAB8,
	29247 - 11904: 0xC962,
	29248 - 11904: 0xFE48,
	29249 - 11904: 0xCFB7,
	29250 - 11904: 0xD27D,
	29252 - 11904: 0xE2C5,
	29254 - 11904: 0xC0F0,
	29255 - 11904: 0xA4F9,
	29256 - 11904: 0xAAA9,
	29257 - 11904: 0xCFB8,
	29258 - 11904: 0xCFB9,
	29259 - 11904: 0xDA66,
	29260 - 11904: 0xB550,
	29263 - 11904: 0xDEA4,
	29264 - 11904: 0xA0E4,
	29266 - 11904: 0xB7DE,
	29267 - 11904: 0xE2C6,
	29269 - 11904: 0xFE4B,
	29270 - 11904: 0xBCF8,
	29271 - 11904: 0xFE4C,
	29272 - 11904: 0xC37C,
	29273 - 11904: 0xA4FA,
	29274 - 11904: 0xDA67,
	29275 - 11904: 0xA4FB,
	29276 - 11904: 0x8DBF,
	29277 - 11904: 0xA6C9,
	29278 - 11904: 0xCA42,
	29279 - 11904: 0xA6C8,
	29280 - 11904: 0xA865,
	29281 - 11904: 0xA864,
	29282 - 11904: 0xA863,
	29283 - 11904: 0xCB60,
	29286 - 11904: 0x9E78,
	29287 - 11904: 0xAAAA,
	29289 - 11904: 0xAAAB,
	29290 - 11904: 0xCD5B,
	29292 - 11904: 0xCFBA,
	29294 - 11904: 0xCFBD,
	29295 - 11904: 0xACBA,
	29296 - 11904: 0xCFBB,
	29298 - 11904: 0xACB9,
	29299 - 11904: 0xCFBC,
	29300 - 11904: 0xACBB,
	29302 - 11904: 0xD2A2,
	29303 - 11904: 0xD2A1,
	29304 - 11904: 0xD27E,
	29305 - 11904: 0xAF53,
	29307 - 11904: 0xD65D,
	29308 - 11904: 0xD65E,
	29309 - 11904: 0xB26F,
	29310 - 11904: 0xD65C,
	29311 - 11904: 0xD65F,
	29312 - 11904: 0xB552,
	29313 - 11904: 0xB270,
	29314 - 11904: 0xFE51,
	29316 - 11904: 0xB551,
	29317 - 11904: 0xDA6B,
	29318 - 11904: 0xDA6A,
	29319 - 11904: 0x9456,
	29320 - 11904: 0xDA68,
	29321 - 11904: 0xDA69,
	29323 - 11904: 0xDA6C,
	29324 - 11904: 0xDEA6,
	29325 - 11904: 0xDEA5,
	29326 - 11904: 0xDEA9,
	29327 - 11904: 0x9D61,
	29328 - 11904: 0xDEA8,
	29329 - 11904: 0xDEA7,
	29330 - 11904: 0xBAB9,
	29331 - 11904: 0xE2C9,
	29332 - 11904: 0x9457,
	29333 - 11904: 0xE2C8,
	29334 - 11904: 0xBABA,
	29335 - 11904: 0xE2C7,
	29336 - 11904: 0xE673,
	29338 - 11904: 0xE674,
	29339 - 11904: 0xBCF9,
	29341 - 11904: 0xEA59,
	29342 - 11904: 0xEA5A,
	29343 - 11904: 0x9966,
	29345 - 11904: 0xF272,
	29346 - 11904: 0xC37D,
	29347 - 11904: 0xF271,
	29348 - 11904: 0xF270,
	29349 - 11904: 0xF26E,
	29350 - 11904: 0xF26F,
	29351 - 11904: 0xC4EB,
	29352 - 11904: 0xF46C,
	29353 - 11904: 0xF6EE,
	29354 - 11904: 0xF8F7,
	29356 - 11904: 0xA4FC,
	29357 - 11904: 0x8BD5,
	29358 - 11904: 0xC9A5,
	29359 - 11904: 0xA5C7,
	29360 - 11904: 0xC9A6,
	29362 - 11904: 0xA069,
	29364 - 11904: 0xCA43,
	29365 - 11904: 0xCA44,
	29370 - 11904: 0xCB66,
	29373 - 11904: 0xCB62,
	29375 - 11904: 0xCB61,
	29376 - 11904: 0xAAAC,
	29377 - 11904: 0xCB65,
	29378 - 11904: 0xA867,
	29379 - 11904: 0xCB63,
	29380 - 11904: 0xA866,
	29381 - 11904: 0xCB67,
	29382 - 11904: 0xCB64,
	29385 - 11904: 0xCD5F,
	29386 - 11904: 0xCFBE,
	29387 - 11904: 0xCD5D,
	29388 - 11904: 0xCD64,
	29389 - 11904: 0x98B4,
	29390 - 11904: 0xAAAD,
	29392 - 11904: 0xAAB0,
	29393 - 11904: 0xCD65,
	29394 - 11904: 0xCD61,
	29396 - 11904: 0xCD62,
	29398 - 11904: 0xCD5C,
	29399 - 11904: 0xAAAF,
	29400 - 11904: 0xCD5E,
	29401 - 11904: 0xAAAE,
	29402 - 11904: 0xCD63,
	29404 - 11904: 0xCD60,
	29407 - 11904: 0xCFC2,
	29408 - 11904: 0xACBD,
	29409 - 11904: 0xACBE,
	29410 - 11904: 0xA049,
	29411 - 11904: 0xCFC5,
	29412 - 11904: 0xCFBF,
	29414 - 11904: 0xCFC4,
	29416 - 11904: 0xCFC0,
	29417 - 11904: 0xACBC,
	29418 - 11904: 0xCFC3,
	29419 - 11904: 0xCFC1,
	29427 - 11904: 0xD2A8,
	29428 - 11904: 0xD2A5,
	29430 - 11904: 0xD2A7,
	29431 - 11904: 0xAF58,
	29432 - 11904: 0xAF57,
	29433 - 11904: 0xAF55,
	29434 - 11904: 0xD2A4,
	29435 - 11904: 0xD2A9,
	29436 - 11904: 0xAF54,
	29437 - 11904: 0xAF56,
	29438 - 11904: 0xD2A6,
	29439 - 11904: 0xD667,
	29440 - 11904: 0xD2A3,
	29441 - 11904: 0xD2AA,
	29442 - 11904: 0xA04C,
	29444 - 11904: 0x9E65,
	29447 - 11904: 0xD662,
	29448 - 11904: 0xD666,
	29450 - 11904: 0xD665,
	29451 - 11904: 0xDA6E,
	29452 - 11904: 0xDA79,
	29455 - 11904: 0xD668,
	29456 - 11904: 0x98B5,
	29457 - 11904: 0xD663,
	29458 - 11904: 0xDA6D,
	29459 - 11904: 0xB274,
	29462 - 11904: 0xB273,
	29463 - 11904: 0xD661,
	29464 - 11904: 0xD664,
	29465 - 11904: 0xB275,
	29467 - 11904: 0xB272,
	29468 - 11904: 0xB271,
	29469 - 11904: 0xD660,
	29470 - 11904: 0xD669,
	29474 - 11904: 0xDA70,
	29475 - 11904: 0xDA77,
	29477 - 11904: 0xB554,
	29478 - 11904: 0xDA76,
	29479 - 11904: 0xDA73,
	29480 - 11904: 0xFE58,
	29481 - 11904: 0xB556,
	29482 - 11904: 0xFE52,
	29483 - 11904: 0xFE53,
	29484 - 11904: 0xA065,
	29485 - 11904: 0xDA75,
	29486 - 11904: 0xFE59,
	29488 - 11904: 0xDA6F,
	29489 - 11904: 0xDA71,
	29490 - 11904: 0xDA74,
	29491 - 11904: 0xDA72,
	29492 - 11904: 0xB555,
	29493 - 11904: 0xDA78,
	29494 - 11904: 0xB553,
	29495 - 11904: 0xB7DF,
	29496 - 11904: 0x98B7,
	29497 - 11904: 0x98B8,
	29498 - 11904: 0xDEAD,
	29499 - 11904: 0xDEAC,
	29500 - 11904: 0xDEAA,
	29502 - 11904: 0xB7E2,
	29503 - 11904: 0xB7E1,
	29504 - 11904: 0xDEAE,
	29505 - 11904: 0x98BA,
	29506 - 11904: 0xDEAB,
	29507 - 11904: 0xE2CA,
	29508 - 11904: 0xBABB,
	29509 - 11904: 0xB7E0,
	29512 - 11904: 0x98BB,
	29513 - 11904: 0xDEB0,
	29514 - 11904: 0xDEAF,
	29516 - 11904: 0xE2CD,
	29517 - 11904: 0xE2CB,
	29518 - 11904: 0xBCFA,
	29519 - 11904: 0x9FBC,
	29520 - 11904: 0xBABC,
	29521 - 11904: 0xE2CC,
	29522 - 11904: 0xE676,
	29527 - 11904: 0xBCFB,
	29528 - 11904: 0xE675,
	29529 - 11904: 0xE67E,
	29530 - 11904: 0xE67D,
	29531 - 11904: 0xE67B,
	29533 - 11904: 0xE67A,
	29534 - 11904: 0xE677,
	29535 - 11904: 0xE678,
	29536 - 11904: 0xE679,
	29537 - 11904: 0xE67C,
	29538 - 11904: 0xE6A1,
	29541 - 11904: 0xEA5F,
	29542 - 11904: 0xEA5C,
	29543 - 11904: 0xEA5D,
	29544 - 11904: 0xBF57,
	29545 - 11904: 0xEA5B,
	29546 - 11904: 0xEA61,
	29547 - 11904: 0xEA60,
	29548 - 11904: 0xEA5E,
	29550 - 11904: 0xED64,
	29551 - 11904: 0xED65,
	29552 - 11904: 0xC0F1,
	29553 - 11904: 0xA04A,
	29554 - 11904: 0xC0F2,
	29555 - 11904: 0xED63,
	29556 - 11904: 0x9EC7,
	29557 - 11904: 0xC279,
	29558 - 11904: 0xEFFE,
	29559 - 11904: 0xC278,
	29560 - 11904: 0xC37E,
	29562 - 11904: 0xC3A1,
	29563 - 11904: 0xC46D,
	29564 - 11904: 0xF46E,
	29565 - 11904: 0xF46D,
	29566 - 11904: 0xF5DD,
	29567 - 11904: 0xF6EF,
	29568 - 11904: 0xC57A,
	29569 - 11904: 0xF7E8,
	29570 - 11904: 0xF7E7,
	29571 - 11904: 0xF7E9,
	29572 - 11904: 0xA5C8,
	29573 - 11904: 0xCFC6,
	29574 - 11904: 0xAF59,
	29575 - 11904: 0xB276,
	29576 - 11904: 0xD66A,
	29577 - 11904: 0xA5C9,
	29578 - 11904: 0xC9A7,
	29579 - 11904: 0xA4FD,
	29580 - 11904: 0x8CA9,
	29582 - 11904: 0xCA45,
	29583 - 11904: 0x98AE,
	29586 - 11904: 0xCB6C,
	29587 - 11904: 0xCB6A,
	29588 - 11904: 0xCB6B,
	29589 - 11904: 0xCB68,
	29590 - 11904: 0xA868,
	29591 - 11904: 0xCB69,
	29592 - 11904: 0x92D6,
	29596 - 11904: 0xFAE1,
	29597 - 11904: 0xCD6D,
	29598 - 11904: 0x91D4,
	29599 - 11904: 0xAAB3,
	29600 - 11904: 0xCD6B,
	29601 - 11904: 0xCD67,
	29602 - 11904: 0xCD6A,
	29604 - 11904: 0xCD66,
	29605 - 11904: 0xAAB5,
	29606 - 11904: 0xCD69,
	29607 - 11904: 0xFADE,
	29608 - 11904: 0xAAB2,
	29609 - 11904: 0xAAB1,
	29610 - 11904: 0xFE5B,
	29611 - 11904: 0xAAB4,
	29612 - 11904: 0xCD6C,
	29613 - 11904: 0xCD68,
	29618 - 11904: 0xACC2,
	29619 - 11904: 0xACC5,
	29620 - 11904: 0xCFCE,
	29621 - 11904: 0xCFCD,
	29622 - 11904: 0xCFCC,
	29623 - 11904: 0xACBF,
	29624 - 11904: 0xCFD5,
	29625 - 11904: 0xCFCB,
	29626 - 11904: 0x8C53,
	29627 - 11904: 0xACC1,
	29628 - 11904: 0xD2AF,
	29630 - 11904: 0xCFD2,
	29631 - 11904: 0xCFD0,
	29632 - 11904: 0xACC4,
	29634 - 11904: 0xCFC8,
	29635 - 11904: 0xCFD3,
	29636 - 11904: 0x87BF,
	29637 - 11904: 0xCFCA,
	29638 - 11904: 0xCFD4,
	29639 - 11904: 0xCFD1,
	29640 - 11904: 0xCFC9,
	29641 - 11904: 0xFE5E,
	29642 - 11904: 0xACC0,
	29643 - 11904: 0xCFD6,
	29644 - 11904: 0xCFC7,
	29645 - 11904: 0xACC3,
	29646 - 11904: 0xFBD7,
	29647 - 11904: 0xFE5A,
	29648 - 11904: 0x94C5,
	29650 - 11904: 0xD2B4,
	29651 - 11904: 0xD2AB,
	29652 - 11904: 0xD2B6,
	29653 - 11904: 0xFACA,
	29654 - 11904: 0xD2AE,
	29655 - 11904: 0xD2B9,
	29656 - 11904: 0xD2BA,
	29657 - 11904: 0xD2AC,
	29658 - 11904: 0xD2B8,
	29659 - 11904: 0xD2B5,
	29660 - 11904: 0xD2B3,
	29661 - 11904: 0xD2B7,
	29662 - 11904: 0xAF5F,
	29664 - 11904: 0xAF5D,
	29665 - 11904: 0x98C1,
	29666 - 11904: 0x975C,
	29667 - 11904: 0xD2B1,
	29668 - 11904: 0xFE74,
	29669 - 11904: 0xD2AD,
	29670 - 11904: 0x9773,
	29671 - 11904: 0xD2B0,
	29672 - 11904: 0xD2BB,
	29673 - 11904: 0xD2B2,
	29674 - 11904: 0xAF5E,
	29675 - 11904: 0xCFCF,
	29677 - 11904: 0xAF5A,
	29678 - 11904: 0xAF5C,
	29679 - 11904: 0xFA46,
	29683 - 11904: 0x9764,
	29684 - 11904: 0xD678,
	29685 - 11904: 0xD66D,
	29686 - 11904: 0xD66B,
	29687 - 11904: 0xFE68,
	29688 - 11904: 0xD66C,
	29689 - 11904: 0x964E,
	29690 - 11904: 0xD673,
	29691 - 11904: 0x9765,
	29692 - 11904: 0xD674,
	29693 - 11904: 0xD670,
	29694 - 11904: 0xB27B,
	29695 - 11904: 0xD675,
	29696 - 11904: 0xD672,
	29697 - 11904: 0xD66F,
	29698 - 11904: 0x8C5A,
	29699 - 11904: 0xB279,
	29700 - 11904: 0xD66E,
	29701 - 11904: 0xB277,
	29702 - 11904: 0xB27A,
	29703 - 11904: 0xD671,
	29704 - 11904: 0xD679,
	29705 - 11904: 0xAF5B,
	29706 - 11904: 0xB278,
	29707 - 11904: 0xD677,
	29708 - 11904: 0xD676,
	29709 - 11904: 0xB27C,
	29713 - 11904: 0x89A1,
	29714 - 11904: 0x95FA,
	29716 - 11904: 0x92D4,
	29717 - 11904: 0xFE69,
	29718 - 11904: 0xDA7E,
	29719 - 11904: 0xFB45,
	29721 - 11904: 0x98C8,
	29722 - 11904: 0xDAA1,
	29723 - 11904: 0xB560,
	29724 - 11904: 0x90EF,
	29725 - 11904: 0xDAA7,
	29726 - 11904: 0x98C9,
	29727 - 11904: 0x98CA,
	29728 - 11904: 0xDAA9,
	29729 - 11904: 0xDAA2,
	29730 - 11904: 0xB55A,
	29731 - 11904: 0xDAA6,
	29732 - 11904: 0xDAA5,
	29733 - 11904: 0xB55B,
	29734 - 11904: 0xB561,
	29736 - 11904: 0xB562,
	29737 - 11904: 0xDAA8,
	29738 - 11904: 0xB558,
	29739 - 11904: 0xDA7D,
	29740 - 11904: 0xDA7B,
	29741 - 11904: 0xDAA3,
	29742 - 11904: 0xDA7A,
	29743 - 11904: 0xB55F,
	29744 - 11904: 0xDA7C,
	29745 - 11904: 0xDAA4,
	29746 - 11904: 0xDAAA,
	29747 - 11904: 0xB559,
	29748 - 11904: 0xB55E,
	29749 - 11904: 0xB55C,
	29750 - 11904: 0xB55D,
	29751 - 11904: 0x946D,
	29752 - 11904: 0x94B7,
	29753 - 11904: 0xFE6C,
	29754 - 11904: 0xB557,
	29756 - 11904: 0x946B,
	29759 - 11904: 0xB7E9,
	29760 - 11904: 0xDEB7,
	29761 - 11904: 0xB7E8,
	29762 - 11904: 0xDEBB,
	29763 - 11904: 0x92FC,
	29764 - 11904: 0xDEB1,
	29765 - 11904: 0x95EB,
	29766 - 11904: 0xDEBC,
	29767 - 11904: 0xFE73,
	29768 - 11904: 0x976E,
	29769 - 11904: 0xFE5F,
	29770 - 11904: 0xDEB2,
	29771 - 11904: 0xDEB3,
	29772 - 11904: 0x87B8,
	29773 - 11904: 0xDEBD,
	29774 - 11904: 0xDEBA,
	29775 - 11904: 0xDEB8,
	29776 - 11904: 0xDEB9,
	29777 - 11904: 0xDEB5,
	29778 - 11904: 0xDEB4,
	29779 - 11904: 0xFDBD,
	29780 - 11904: 0xDEBE,
	29781 - 11904: 0xB7E5,
	29782 - 11904: 0x92D5,
	29783 - 11904: 0xDEB6,
	29785 - 11904: 0xB7EA,
	29786 - 11904: 0xB7E4,
	29787 - 11904: 0xB7EB,
	29788 - 11904: 0xFE6F,
	29789 - 11904: 0xFEB9,
	29790 - 11904: 0xB7E7,
	29791 - 11904: 0xB7E6,
	29792 - 11904: 0xFE71,
	29793 - 11904: 0x8778,
	29794 - 11904: 0xE2CE,
	29795 - 11904: 0xBABE,
	29796 - 11904: 0xBABD,
	29797 - 11904: 0xFBBB,
	29799 - 11904: 0xE2D3,
	29800 - 11904: 0xA0D5,
	29801 - 11904: 0xBCFC,
	29802 - 11904: 0xBABF,
	29803 - 11904: 0x95FB,
	29804 - 11904: 0xFE77,
	29805 - 11904: 0xBAC1,
	29806 - 11904: 0xE2D4,
	29807 - 11904: 0xB7E3,
	29808 - 11904: 0xBAC0,
	29809 - 11904: 0xE2D0,
	29810 - 11904: 0xE2D2,
	29811 - 11904: 0xE2CF,
	29812 - 11904: 0xFE79,
	29813 - 11904: 0xE2D1,
	29814 - 11904: 0xFE75,
	29817 - 11904: 0xE6AB,
	29818 - 11904: 0x945D,
	29820 - 11904: 0xE6AA,
	29821 - 11904: 0xE6A7,
	29822 - 11904: 0xBD40,
	29823 - 11904: 0xEA62,
	29824 - 11904: 0xBD41,
	29825 - 11904: 0xE6A6,
	29826 - 11904: 0xFE7C,
	29827 - 11904: 0xBCFE,
	29829 - 11904: 0xE6A8,
	29830 - 11904: 0xE6A5,
	29831 - 11904: 0xE6A2,
	29832 - 11904: 0xE6A9,
	29833 - 11904: 0xE6A3,
	29834 - 11904: 0xE6A4,
	29835 - 11904: 0xBCFD,
	29836 - 11904: 0x9344,
	29837 - 11904: 0x8EA6,
	29840 - 11904: 0xED69,
	29842 - 11904: 0xEA66,
	29844 - 11904: 0xEA65,
	29845 - 11904: 0xEA67,
	29847 - 11904: 0xED66,
	29848 - 11904: 0xBF5A,
	29849 - 11904: 0x92D3,
	29850 - 11904: 0xEA63,
	29851 - 11904: 0x94B8,
	29852 - 11904: 0xBF58,
	29853 - 11904: 0x8779,
	29854 - 11904: 0xBF5C,
	29855 - 11904: 0xBF5B,
	29856 - 11904: 0xEA64,
	29857 - 11904: 0xEA68,
	29859 - 11904: 0xBF59,
	29860 - 11904: 0xFC71,
	29861 - 11904: 0xED6D,
	29862 - 11904: 0xC0F5,
	29863 - 11904: 0xC27A,
	29864 - 11904: 0xC0F6,
	29865 - 11904: 0xC0F3,
	29866 - 11904: 0xED6A,
	29867 - 11904: 0xED68,
	29869 - 11904: 0xED6B,
	29871 - 11904: 0xED6E,
	29872 - 11904: 0xC0F4,
	29873 - 11904: 0xED6C,
	29874 - 11904: 0xED67,
	29876 - 11904: 0x975E,
	29877 - 11904: 0xF042,
	29878 - 11904: 0xF045,
	29879 - 11904: 0xF275,
	29880 - 11904: 0xF040,
	29881 - 11904: 0x8CAD,
	29882 - 11904: 0xF46F,
	29883 - 11904: 0xF046,
	29885 - 11904: 0xC3A2,
	29886 - 11904: 0xF044,
	29887 - 11904: 0xC27B,
	29888 - 11904: 0xF041,
	29889 - 11904: 0xF043,
	29890 - 11904: 0xF047,
	29891 - 11904: 0xF276,
	29893 - 11904: 0xF274,
	29894 - 11904: 0x87C1,
	29896 - 11904: 0xFEA7,
	29898 - 11904: 0xC3A3,
	29899 - 11904: 0xF273,
	29900 - 11904: 0x946A,
	29903 - 11904: 0xC46E,
	29904 - 11904: 0x93E3,
	29907 - 11904: 0x98CF,
	29908 - 11904: 0xC4ED,
	29909 - 11904: 0xF6F1,
	29910 - 11904: 0xC4EC,
	29911 - 11904: 0xF6F3,
	29912 - 11904: 0xF6F0,
	29913 - 11904: 0xF6F2,
	29914 - 11904: 0xC5D0,
	29915 - 11904: 0xF8B2,
	29916 - 11904: 0xA5CA,
	29917 - 11904: 0xCD6E,
	29918 - 11904: 0xD2BC,
	29919 - 11904: 0xD2BD,
	29920 - 11904: 0xB27D,
	29921 - 11904: 0xDEBF,
	29922 - 11904: 0xBF5D,
	29923 - 11904: 0xC3A4,
	29924 - 11904: 0xC57B,
	29925 - 11904: 0xF8B3,
	29926 - 11904: 0xA5CB,
	29927 - 11904: 0xA0D9,
	29928 - 11904: 0xCD6F,
	29929 - 11904: 0xFEAA,
	29932 - 11904: 0xCFD7,
	29934 - 11904: 0xCFD8,
	29936 - 11904: 0xA0BF,
	29937 - 11904: 0xA04D,
	29938 - 11904: 0xA0B8,
	29940 - 11904: 0xD2BE,
	29941 - 11904: 0xD2BF,
	29942 - 11904: 0xB27E,
	29943 - 11904: 0xB2A1,
	29944 - 11904: 0xA0CE,
	29947 - 11904: 0xDAAB,
	29949 - 11904: 0xDEC2,
	29950 - 11904: 0xDEC1,
	29951 - 11904: 0xDEC0,
	29952 - 11904: 0xE2D5,
	29954 - 11904: 0xE2D6,
	29955 - 11904: 0xE2D7,
	29956 - 11904: 0xBAC2,
	29957 - 11904: 0xA0B7,
	29959 - 11904: 0xE6AD,
	29960 - 11904: 0xE6AC,
	29963 - 11904: 0xEA69,
	29964 - 11904: 0xBF5E,
	29965 - 11904: 0xBF5F,
	29966 - 11904: 0xFEA9,
	29967 - 11904: 0xED72,
	29968 - 11904: 0xED6F,
	29969 - 11904: 0xED70,
	29970 - 11904: 0xED71,
	29971 - 11904: 0xF049,
	29972 - 11904: 0xF048,
	29973 - 11904: 0xC27C,
	29974 - 11904: 0xF277,
	29975 - 11904: 0xF5DE,
	29976 - 11904: 0xA5CC,
	29977 - 11904: 0x89C3,
	29978 - 11904: 0xACC6,
	29980 - 11904: 0xB2A2,
	29981 - 11904: 0xDEC3,
	29982 - 11904: 0xFEAB,
	29983 - 11904: 0xA5CD,
	29985 - 11904: 0xD2C0,
	29986 - 11904: 0xB2A3,
	29989 - 11904: 0xB563,
	29990 - 11904: 0xB564,
	29992 - 11904: 0xA5CE,
	29993 - 11904: 0xA5CF,
	29994 - 11904: 0xCA46,
	29995 - 11904: 0xA86A,
	29996 - 11904: 0xA869,
	29997 - 11904: 0xACC7,
	29998 - 11904: 0xCFD9,
	29999 - 11904: 0xDAAC,
	30000 - 11904: 0xA5D0,
	30001 - 11904: 0xA5D1,
	30002 - 11904: 0xA5D2,
	30003 - 11904: 0xA5D3,
	30004 - 11904: 0x9DF4,
	30005 - 11904: 0x896D,
	30007 - 11904: 0xA86B,
	30008 - 11904: 0xA86C,
	30009 - 11904: 0xCB6E,
	30010 - 11904: 0xCB6D,
	30011 - 11904: 0x9C7B,
	30013 - 11904: 0xAAB6,
	30014 - 11904: 0xCD72,
	30015 - 11904: 0xCD70,
	30016 - 11904: 0xCD71,
	30018 - 11904: 0x98D2,
	30022 - 11904: 0x9FA9,
	30023 - 11904: 0xCFDA,
	30024 - 11904: 0xCFDB,
	30026 - 11904: 0xFEB2,
	30027 - 11904: 0xACCB,
	30028 - 11904: 0xACC9,
	30029 - 11904: 0xFEB1,
	30030 - 11904: 0xACCA,
	30031 - 11904: 0xACC8,
	30033 - 11904: 0x97D9,
	30035 - 11904: 0xA0C4,
	30036 - 11904: 0xAF60,
	30037 - 11904: 0x9476,
	30041 - 11904: 0xAF64,
	30042 - 11904: 0xAF63,
	30043 - 11904: 0xD2C1,
	30044 - 11904: 0xAF62,
	30045 - 11904: 0xAF61,
	30047 - 11904: 0xD2C2,
	30048 - 11904: 0x9978,
	30050 - 11904: 0xB2A6,
	30051 - 11904: 0xD67B,
	30052 - 11904: 0xD67A,
	30053 - 11904: 0xB2A4,
	30054 - 11904: 0xB2A5,
	30055 - 11904: 0xFEB3,
	30058 - 11904: 0xB566,
	30059 - 11904: 0xB565,
	30060 - 11904: 0xDAAE,
	30061 - 11904: 0x98D3,
	30062 - 11904: 0xFEB4,
	30063 - 11904: 0xDAAD,
	30064 - 11904: 0xB2A7,
	30066 - 11904: 0x98D4,
	30070 - 11904: 0xB7ED,
	30071 - 11904: 0xDEC5,
	30072 - 11904: 0xB7EE,
	30073 - 11904: 0xDEC4,
	30074 - 11904: 0x9FB9,
	30077 - 11904: 0xE2D8,
	30078 - 11904: 0xE6AE,
	30079 - 11904: 0xBD42,
	30080 - 11904: 0xEA6A,
	30083 - 11904: 0x9471,
	30084 - 11904: 0xED73,
	30086 - 11904: 0xC3A6,
	30087 - 11904: 0xC3A5,
	30090 - 11904: 0xC57C,
	30091 - 11904: 0xA5D4,
	30092 - 11904: 0xCD73,
	30093 - 11904: 0x98D5,
	30094 - 11904: 0xFEB8,
	30095 - 11904: 0xB2A8,
	30096 - 11904: 0xE2D9,
	30097 - 11904: 0xBAC3,
	30098 - 11904: 0xC6D4,
	30100 - 11904: 0xCB6F,
	30101 - 11904: 0xCB70,
	30104 - 11904: 0xCD74,
	30105 - 11904: 0xAAB8,
	30106 - 11904: 0xAAB9,
	30109 - 11904: 0xAAB7,
	30110 - 11904: 0xFEBA,
	30114 - 11904: 0xACCF,
	30115 - 11904: 0xACD0,
	30116 - 11904: 0xACCD,
	30117 - 11904: 0xACCE,
	30119 - 11904: 0xCFDC,
	30122 - 11904: 0xCFDD,
	30123 - 11904: 0xACCC,
	30128 - 11904: 0xD2C3,
	30129 - 11904: 0x9E5C,
	30130 - 11904: 0xAF68,
	30131 - 11904: 0xAF69,
	30132 - 11904: 0xFEBB,
	30133 - 11904: 0xB2AB,
	30134 - 11904: 0xD2C9,
	30136 - 11904: 0xAF6E,
	30137 - 11904: 0xAF6C,
	30138 - 11904: 0xD2CA,
	30139 - 11904: 0xD2C5,
	30140 - 11904: 0xAF6B,
	30141 - 11904: 0xAF6A,
	30142 - 11904: 0xAF65,
	30143 - 11904: 0xD2C8,
	30144 - 11904: 0xD2C7,
	30145 - 11904: 0xD2C4,
	30146 - 11904: 0xAF6D,
	30147 - 11904: 0xA044,
	30148 - 11904: 0xD2C6,
	30149 - 11904: 0xAF66,
	30151 - 11904: 0xAF67,
	30152 - 11904: 0x98D7,
	30154 - 11904: 0xB2AC,
	30155 - 11904: 0xD6A1,
	30156 - 11904: 0xD6A2,
	30157 - 11904: 0xB2AD,
	30158 - 11904: 0xD67C,
	30159 - 11904: 0xD67E,
	30160 - 11904: 0xD6A4,
	30161 - 11904: 0xD6A3,
	30162 - 11904: 0xD67D,
	30164 - 11904: 0xB2A9,
	30165 - 11904: 0xB2AA,
	30167 - 11904: 0xDAB6,
	30168 - 11904: 0xB56B,
	30169 - 11904: 0xB56A,
	30170 - 11904: 0xDAB0,
	30171 - 11904: 0xB568,
	30172 - 11904: 0x98D8,
	30173 - 11904: 0xDAB3,
	30174 - 11904: 0xB56C,
	30175 - 11904: 0xDAB4,
	30176 - 11904: 0xB56D,
	30177 - 11904: 0xDAB1,
	30178 - 11904: 0xB567,
	30179 - 11904: 0xB569,
	30180 - 11904: 0xDAB5,
	30182 - 11904: 0xDAB2,
	30183 - 11904: 0xDAAF,
	30189 - 11904: 0xDED2,
	30191 - 11904: 0xDEC7,
	30192 - 11904: 0xB7F0,
	30193 - 11904: 0xB7F3,
	30194 - 11904: 0xB7F2,
	30195 - 11904: 0xB7F7,
	30196 - 11904: 0xB7F6,
	30197 - 11904: 0xDED3,
	30198 - 11904: 0xDED1,
	30199 - 11904: 0xDECA,
	30200 - 11904: 0xDECE,
	30201 - 11904: 0xDECD,
	30202 - 11904: 0xB7F4,
	30203 - 11904: 0xDED0,
	30204 - 11904: 0xDECC,
	30205 - 11904: 0xDED4,
	30206 - 11904: 0xDECB,
	30207 - 11904: 0xB7F5,
	30208 - 11904: 0xB7EF,
	30209 - 11904: 0xB7F1,
	30210 - 11904: 0xFEBC,
	30211 - 11904: 0xDEC9,
	30215 - 11904: 0x9FFE,
	30216 - 11904: 0xE2DB,
	30217 - 11904: 0xBAC7,
	30218 - 11904: 0xE2DF,
	30219 - 11904: 0xBAC6,
	30220 - 11904: 0xE2DC,
	30221 - 11904: 0xBAC5,
	30223 - 11904: 0xDEC8,
	30224 - 11904: 0xDECF,
	30225 - 11904: 0xE2DE,
	30227 - 11904: 0xBAC8,
	30228 - 11904: 0xE2E0,
	30229 - 11904: 0xE2DD,
	30230 - 11904: 0xE2DA,
	30233 - 11904: 0xE6B1,
	30234 - 11904: 0xE6B5,
	30235 - 11904: 0xE6B7,
	30236 - 11904: 0xE6B3,
	30237 - 11904: 0xE6B2,
	30238 - 11904: 0xE6B0,
	30239 - 11904: 0xBD45,
	30240 - 11904: 0xBD43,
	30241 - 11904: 0xBD48,
	30242 - 11904: 0xBD49,
	30243 - 11904: 0xE6B4,
	30244 - 11904: 0xBD46,
	30245 - 11904: 0xE6AF,
	30246 - 11904: 0xBD47,
	30247 - 11904: 0xBAC4,
	30248 - 11904: 0xE6B6,
	30249 - 11904: 0xBD44,
	30252 - 11904: 0xFEBD,
	30253 - 11904: 0xEA6C,
	30255 - 11904: 0xEA6B,
	30256 - 11904: 0xEA73,
	30257 - 11904: 0xEA6D,
	30258 - 11904: 0xEA72,
	30259 - 11904: 0xEA6F,
	30260 - 11904: 0xBF60,
	30261 - 11904: 0xEA71,
	30264 - 11904: 0xBF61,
	30266 - 11904: 0xBF62,
	30267 - 11904: 0x9DDD,
	30268 - 11904: 0xEA70,
	30269 - 11904: 0xEA6E,
	30272 - 11904: 0x9EE1,
	30274 - 11904: 0xC0F8,
	30275 - 11904: 0xED74,
	30278 - 11904: 0xC0F7,
	30279 - 11904: 0xED77,
	30280 - 11904: 0xED75,
	30281 - 11904: 0xED76,
	30284 - 11904: 0xC0F9,
	30285 - 11904: 0x98DA,
	30286 - 11904: 0x9DDF,
	30287 - 11904: 0xFEBF,
	30288 - 11904: 0xF04D,
	30289 - 11904: 0xFEBE,
	30290 - 11904: 0xC2A1,
	30291 - 11904: 0xF04E,
	30292 - 11904: 0x9EEB,
	30294 - 11904: 0xC27D,
	30295 - 11904: 0xF04F,
	30296 - 11904: 0xC27E,
	30297 - 11904: 0xF04C,
	30298 - 11904: 0xF050,
	30300 - 11904: 0xF04A,
	30303 - 11904: 0xC3A7,
	30304 - 11904: 0xF278,
	30305 - 11904: 0xC3A8,
	30306 - 11904: 0xC46F,
	30308 - 11904: 0xF04B,
	30309 - 11904: 0xC470,
	30310 - 11904: 0x9E59,
	30311 - 11904: 0xA05C,
	30313 - 11904: 0xC4EE,
	30314 - 11904: 0xF5DF,
	30316 - 11904: 0xC57E,
	30317 - 11904: 0xF6F4,
	30318 - 11904: 0xC57D,
	30319 - 11904: 0xFEC0,
	30320 - 11904: 0xF7EA,
	30321 - 11904: 0xC5F5,
	30322 - 11904: 0xC5F6,
	30323 - 11904: 0x9477,
	30324 - 11904: 0x98DC,
	30325 - 11904: 0xF9CC,
	30326 - 11904: 0xFEC1,
	30328 - 11904: 0xACD1,
	30329 - 11904: 0xCFDE,
	30330 - 11904: 0x98DE,
	30331 - 11904: 0xB56E,
	30332 - 11904: 0xB56F,
	30333 - 11904: 0xA5D5,
	30334 - 11904: 0xA6CA,
	30335 - 11904: 0xCA47,
	30337 - 11904: 0xCB71,
	30338 - 11904: 0xA86D,
	30340 - 11904: 0xAABA,
	30342 - 11904: 0xACD2,
	30343 - 11904: 0xACD3,
	30344 - 11904: 0xACD4,
	30345 - 11904: 0xD6A6,
	30346 - 11904: 0xD2CB,
	30347 - 11904: 0xAF6F,
	30350 - 11904: 0xB2AE,
	30351 - 11904: 0xD6A5,
	30352 - 11904: 0xFEC3,
	30354 - 11904: 0xDAB8,
	30355 - 11904: 0xB571,
	30357 - 11904: 0xDAB7,
	30358 - 11904: 0xB570,
	30361 - 11904: 0xDED5,
	30362 - 11904: 0xBD4A,
	30363 - 11904: 0xE6BB,
	30364 - 11904: 0xE6B8,
	30365 - 11904: 0xE6B9,
	30366 - 11904: 0xE6BA,
	30369 - 11904: 0xFEC8,
	30372 - 11904: 0xED78,
	30373 - 11904: 0xFEC9,
	30374 - 11904: 0xF051,
	30378 - 11904: 0xF471,
	30379 - 11904: 0xF470,
	30381 - 11904: 0xF6F5,
	30382 - 11904: 0xA5D6,
	30383 - 11904: 0xCD75,
	30384 - 11904: 0xAF70,
	30388 - 11904: 0xB572,
	30389 - 11904: 0xDED6,
	30391 - 11904: 0xFECA,
	30392 - 11904: 0xE2E1,
	30394 - 11904: 0xBD4B,
	30395 - 11904: 0xEA74,
	30397 - 11904: 0xF052,
	30398 - 11904: 0xF472,
	30399 - 11904: 0xA5D7,
	30402 - 11904: 0xAABB,
	30403 - 11904: 0xACD7,
	30404 - 11904: 0xCFDF,
	30405 - 11904: 0xACD8,
	30406 - 11904: 0xACD6,
	30408 - 11904: 0xACD5,
	30409 - 11904: 0xD2CC,
	30410 - 11904: 0xAF71,
	30412 - 11904: 0xFECB,
	30413 - 11904: 0xAF72,
	30414 - 11904: 0xAF73,
	30418 - 11904: 0xB2B0,
	30419 - 11904: 0xD6A7,
	30420 - 11904: 0xB2AF,
	30422 - 11904: 0x9FC2,
	30425 - 11904: 0x8C6B,
	30426 - 11904: 0xDAB9,
	30427 - 11904: 0xB2B1,
	30428 - 11904: 0xB573,
	30429 - 11904: 0xDED7,
	30430 - 11904: 0xB7F8,
	30431 - 11904: 0xB7F9,
	30433 - 11904: 0xBAC9,
	30435 - 11904: 0xBACA,
	30436 - 11904: 0xBD4C,
	30437 - 11904: 0xBF64,
	30438 - 11904: 0xEA75,
	30439 - 11904: 0xBF63,
	30441 - 11904: 0xED79,
	30442 - 11904: 0xC0FA,
	30444 - 11904: 0xF053,
	30445 - 11904: 0xF473,
	30446 - 11904: 0xA5D8,
	30447 - 11904: 0xA86E,
	30448 - 11904: 0xCD78,
	30449 - 11904: 0xCD77,
	30450 - 11904: 0xAABC,
	30451 - 11904: 0xCD76,
	30452 - 11904: 0xAABD,
	30453 - 11904: 0xCD79,
	30455 - 11904: 0xCFE5,
	30456 - 11904: 0xACDB,
	30457 - 11904: 0xACDA,
	30458 - 11904: 0xCFE7,
	30459 - 11904: 0xCFE6,
	30460 - 11904: 0xACDF,
	30462 - 11904: 0xACDE,
	30465 - 11904: 0xACD9,
	30467 - 11904: 0xCFE1,
	30468 - 11904: 0xCFE2,
	30469 - 11904: 0xCFE3,
	30471 - 11904: 0xACE0,
	30472 - 11904: 0xCFE0,
	30473 - 11904: 0xACDC,
	30474 - 11904: 0xCFE4,
	30475 - 11904: 0xACDD,
	30476 - 11904: 0x98C4,
	30478 - 11904: 0x94B0,
	30479 - 11904: 0x94B1,
	30480 - 11904: 0xD2CF,
	30481 - 11904: 0xD2D3,
	30482 - 11904: 0xD2D1,
	30483 - 11904: 0xD2D0,
	30485 - 11904: 0xD2D4,
	30489 - 11904: 0xD2D5,
	30490 - 11904: 0xD2D6,
	30491 - 11904: 0xD2CE,
	30493 - 11904: 0xD2CD,
	30494 - 11904: 0xFED1,
	30495 - 11904: 0xAF75,
	30496 - 11904: 0xAF76,
	30498 - 11904: 0xD2D7,
	30499 - 11904: 0xD2D2,
	30500 - 11904: 0xA0C1,
	30501 - 11904: 0xD6B0,
	30502 - 11904: 0xFED2,
	30503 - 11904: 0xD2D8,
	30504 - 11904: 0xAF77,
	30505 - 11904: 0xAF74,
	30507 - 11904: 0xA0CD,
	30509 - 11904: 0xD6AA,
	30511 - 11904: 0xD6A9,
	30513 - 11904: 0xD6AB,
	30514 - 11904: 0xD6AC,
	30515 - 11904: 0xD6AE,
	30516 - 11904: 0xD6AD,
	30517 - 11904: 0xD6B2,
	30518 - 11904: 0xB2B5,
	30519 - 11904: 0xB2B2,
	30520 - 11904: 0xB2B6,
	30521 - 11904: 0xD6A8,
	30522 - 11904: 0xB2B7,
	30523 - 11904: 0xD6B1,
	30524 - 11904: 0xB2B4,
	30525 - 11904: 0xD6AF,
	30526 - 11904: 0xB2B3,
	30528 - 11904: 0xFED3,
	30531 - 11904: 0x98E5,
	30532 - 11904: 0xDABC,
	30533 - 11904: 0xDABE,
	30534 - 11904: 0xDABA,
	30535 - 11904: 0xDABB,
	30538 - 11904: 0xDABF,
	30539 - 11904: 0xDAC1,
	30540 - 11904: 0xDAC2,
	30541 - 11904: 0xDABD,
	30542 - 11904: 0xDAC0,
	30543 - 11904: 0xB574,
	30546 - 11904: 0xDEDB,
	30548 - 11904: 0xDEE0,
	30549 - 11904: 0xDED8,
	30550 - 11904: 0xDEDC,
	30552 - 11904: 0xFED6,
	30553 - 11904: 0xDEE1,
	30554 - 11904: 0xDEDD,
	30555 - 11904: 0xB7FA,
	30556 - 11904: 0xB843,
	30558 - 11904: 0xB7FD,
	30559 - 11904: 0xDED9,
	30560 - 11904: 0xDEDA,
	30561 - 11904: 0xBACE,
	30562 - 11904: 0xB846,
	30563 - 11904: 0xB7FE,
	30565 - 11904: 0xB844,
	30566 - 11904: 0xB7FC,
	30567 - 11904: 0xDEDF,
	30568 - 11904: 0xB845,
	30569 - 11904: 0xDEDE,
	30570 - 11904: 0xB841,
	30571 - 11904: 0xB7FB,
	30572 - 11904: 0xB842,
	30573 - 11904: 0xDEE2,
	30574 - 11904: 0xE2E6,
	30575 - 11904: 0xE2E8,
	30578 - 11904: 0x91E4,
	30583 - 11904: 0x8FC7,
	30584 - 11904: 0x94AE,
	30585 - 11904: 0xB840,
	30586 - 11904: 0x8A4F,
	30587 - 11904: 0x94B2,
	30588 - 11904: 0xE2E3,
	30589 - 11904: 0xBACC,
	30590 - 11904: 0xE2E9,
	30591 - 11904: 0xBACD,
	30592 - 11904: 0xE2E7,
	30593 - 11904: 0xE2E2,
	30594 - 11904: 0xE2E5,
	30595 - 11904: 0xE2EA,
	30596 - 11904: 0xBACB,
	30597 - 11904: 0xE2E4,
	30599 - 11904: 0xBD4E,
	30600 - 11904: 0xE6BF,
	30601 - 11904: 0xE6BE,
	30603 - 11904: 0xBD51,
	30604 - 11904: 0xBD4F,
	30605 - 11904: 0xE6BC,
	30606 - 11904: 0xBD4D,
	30607 - 11904: 0xE6BD,
	30609 - 11904: 0xBD50,
	30611 - 11904: 0x8FD4,
	30613 - 11904: 0xEA7D,
	30615 - 11904: 0xEAA1,
	30616 - 11904: 0x98EA,
	30617 - 11904: 0xEA7E,
	30618 - 11904: 0xEA76,
	30619 - 11904: 0xEA7A,
	30620 - 11904: 0xEA79,
	30621 - 11904: 0xEA77,
	30622 - 11904: 0xBF66,
	30623 - 11904: 0xBF67,
	30624 - 11904: 0xBF65,
	30625 - 11904: 0xEA78,
	30626 - 11904: 0xEA7B,
	30627 - 11904: 0xEA7C,
	30629 - 11904: 0xBF68,
	30631 - 11904: 0xC140,
	30632 - 11904: 0xEDA3,
	30634 - 11904: 0xC0FC,
	30635 - 11904: 0xED7B,
	30636 - 11904: 0xC0FE,
	30637 - 11904: 0xC141,
	30639 - 11904: 0xFED8,
	30640 - 11904: 0xC0FD,
	30641 - 11904: 0xEDA2,
	30642 - 11904: 0xED7C,
	30643 - 11904: 0xC0FB,
	30644 - 11904: 0xEDA1,
	30645 - 11904: 0xED7A,
	30646 - 11904: 0xED7E,
	30647 - 11904: 0xED7D,
	30649 - 11904: 0x9DE0,
	30650 - 11904: 0xF055,
	30651 - 11904: 0xC2A4,
	30652 - 11904: 0xC2A5,
	30653 - 11904: 0xC2A2,
	30654 - 11904: 0x98EE,
	30655 - 11904: 0xC2A3,
	30658 - 11904: 0xF054,
	30659 - 11904: 0x95C4,
	30660 - 11904: 0xF27B,
	30661 - 11904: 0xFCE8,
	30663 - 11904: 0xC3A9,
	30665 - 11904: 0xF279,
	30666 - 11904: 0xF27A,
	30667 - 11904: 0x98EF,
	30668 - 11904: 0xF474,
	30669 - 11904: 0xF477,
	30670 - 11904: 0xF475,
	30671 - 11904: 0xF476,
	30672 - 11904: 0xF5E0,
	30675 - 11904: 0xC4EF,
	30676 - 11904: 0xF7EB,
	30677 - 11904: 0xF8B4,
	30679 - 11904: 0xC5F7,
	30680 - 11904: 0xF8F8,
	30681 - 11904: 0xF8F9,
	30682 - 11904: 0xC666,
	30683 - 11904: 0xA5D9,
	30684 - 11904: 0xACE1,
	30685 - 11904: 0x8C6E,
	30686 - 11904: 0xDAC3,
	30688 - 11904: 0xDEE3,
	30690 - 11904: 0xA5DA,
	30691 - 11904: 0xA86F,
	30693 - 11904: 0xAABE,
	30694 - 11904: 0xFAD8,
	30695 - 11904: 0xCFE8,
	30696 - 11904: 0xCFE9,
	30697 - 11904: 0xAF78,
	30700 - 11904: 0xDAC4,
	30701 - 11904: 0xB575,
	30702 - 11904: 0xB847,
	30703 - 11904: 0xC142,
	30704 - 11904: 0xEDA4,
	30705 - 11904: 0xF27C,
	30706 - 11904: 0xF478,
	30707 - 11904: 0xA5DB,
	30708 - 11904: 0xFEDC,
	30711 - 11904: 0xCDA1,
	30712 - 11904: 0xCD7A,
	30713 - 11904: 0xCD7C,
	30714 - 11904: 0xCD7E,
	30715 - 11904: 0xCD7D,
	30716 - 11904: 0xCD7B,
	30717 - 11904: 0xAABF,
	30718 - 11904: 0xA0AE,
	30722 - 11904: 0xACE2,
	30723 - 11904: 0xCFF2,
	30725 - 11904: 0xCFED,
	30726 - 11904: 0xCFEA,
	30728 - 11904: 0x9D4C,
	30729 - 11904: 0xFEDD,
	30732 - 11904: 0xACE4,
	30733 - 11904: 0xACE5,
	30734 - 11904: 0xCFF0,
	30735 - 11904: 0xCFEF,
	30736 - 11904: 0xCFEE,
	30737 - 11904: 0xCFEB,
	30738 - 11904: 0xCFEC,
	30739 - 11904: 0xCFF3,
	30740 - 11904: 0xACE3,
	30744 - 11904: 0x98F1,
	30748 - 11904: 0x98F3,
	30749 - 11904: 0xAF7C,
	30750 - 11904: 0x94C1,
	30751 - 11904: 0xAFA4,
	30752 - 11904: 0xAFA3,
	30753 - 11904: 0xD2E1,
	30754 - 11904: 0xD2DB,
	30755 - 11904: 0xD2D9,
	30757 - 11904: 0xAFA1,
	30758 - 11904: 0xD6B9,
	30759 - 11904: 0xAF7A,
	30760 - 11904: 0xD2DE,
	30761 - 11904: 0xD2E2,
	30762 - 11904: 0xD2E4,
	30763 - 11904: 0xD2E0,
	30764 - 11904: 0xD2DA,
	30765 - 11904: 0xAFA2,
	30766 - 11904: 0xD2DF,
	30767 - 11904: 0xD2DD,
	30768 - 11904: 0xAF79,
	30769 - 11904: 0xD2E5,
	30770 - 11904: 0xAFA5,
	30771 - 11904: 0xD2E3,
	30772 - 11904: 0xAF7D,
	30773 - 11904: 0xD2DC,
	30775 - 11904: 0xAF7E,
	30776 - 11904: 0xAF7B,
	30777 - 11904: 0x98F5,
	30780 - 11904: 0xFA4F,
	30781 - 11904: 0x96E2,
	30786 - 11904: 0x9450,
	30787 - 11904: 0xB2B9,
	30788 - 11904: 0x96A2,
	30789 - 11904: 0xD6BA,
	30791 - 11904: 0x98F6,
	30792 - 11904: 0xD6B3,
	30793 - 11904: 0xD6B5,
	30794 - 11904: 0xD6B7,
	30795 - 11904: 0x96E5,
	30796 - 11904: 0xD6B8,
	30797 - 11904: 0xD6B6,
	30798 - 11904: 0xB2BA,
	30800 - 11904: 0xD6BB,
	30801 - 11904: 0x98F7,
	30802 - 11904: 0xD6B4,
	30803 - 11904: 0xA046,
	30804 - 11904: 0x96E3,
	30812 - 11904: 0xDAC8,
	30813 - 11904: 0xB576,
	30814 - 11904: 0xDAD0,
	30816 - 11904: 0xDAC5,
	30818 - 11904: 0xDAD1,
	30820 - 11904: 0xDAC6,
	30821 - 11904: 0xDAC7,
	30822 - 11904: 0x98F8,
	30824 - 11904: 0xDACF,
	30825 - 11904: 0xDACE,
	30826 - 11904: 0xDACB,
	30827 - 11904: 0xB2B8,
	30828 - 11904: 0xB577,
	30829 - 11904: 0xDAC9,
	30830 - 11904: 0xDACC,
	30831 - 11904: 0xB578,
	30832 - 11904: 0xDACD,
	30833 - 11904: 0xDACA,
	30841 - 11904: 0xDEEE,
	30842 - 11904: 0x9EE4,
	30843 - 11904: 0xDEF2,
	30844 - 11904: 0xB84E,
	30846 - 11904: 0xE2F0,
	30847 - 11904: 0xB851,
	30848 - 11904: 0xDEF0,
	30849 - 11904: 0xF9D6,
	30851 - 11904: 0xDEED,
	30852 - 11904: 0xDEE8,
	30853 - 11904: 0xDEEA,
	30854 - 11904: 0xDEEB,
	30855 - 11904: 0xDEE4,
	30856 - 11904: 0x94C3,
	30857 - 11904: 0xB84D,
	30860 - 11904: 0xB84C,
	30861 - 11904: 0x94C2,
	30862 - 11904: 0xB848,
	30863 - 11904: 0xDEE7,
	30865 - 11904: 0xB84F,
	30867 - 11904: 0xB850,
	30868 - 11904: 0xDEE6,
	30869 - 11904: 0xDEE9,
	30870 - 11904: 0xDEF1,
	30871 - 11904: 0xB84A,
	30872 - 11904: 0xB84B,
	30873 - 11904: 0xDEEF,
	30874 - 11904: 0xDEE5,
	30878 - 11904: 0xE2F2,
	30879 - 11904: 0xBAD0,
	30880 - 11904: 0xE2F4,
	30881 - 11904: 0xDEEC,
	30882 - 11904: 0xE2F6,
	30883 - 11904: 0xBAD4,
	30884 - 11904: 0xE2F7,
	30885 - 11904: 0xE2F3,
	30887 - 11904: 0xBAD1,
	30888 - 11904: 0xE2EF,
	30889 - 11904: 0xBAD3,
	30890 - 11904: 0xE2EC,
	30891 - 11904: 0xE2F1,
	30892 - 11904: 0xE2F5,
	30893 - 11904: 0xE2EE,
	30895 - 11904: 0xFEE1,
	30896 - 11904: 0xB849,
	30897 - 11904: 0xFEE9,
	30898 - 11904: 0xE2EB,
	30899 - 11904: 0xBAD2,
	30900 - 11904: 0xE2ED,
	30902 - 11904: 0x96E4,
	30904 - 11904: 0x89AC,
	30905 - 11904: 0x96DB,
	30906 - 11904: 0xBD54,
	30907 - 11904: 0xE6C1,
	30908 - 11904: 0xBD58,
	30910 - 11904: 0xBD56,
	30913 - 11904: 0xBACF,
	30915 - 11904: 0xE6C8,
	30916 - 11904: 0xE6C9,
	30917 - 11904: 0xBD53,
	30919 - 11904: 0xFEE2,
	30920 - 11904: 0xE6C7,
	30921 - 11904: 0xE6CA,
	30922 - 11904: 0xBD55,
	30923 - 11904: 0xBD52,
	30924 - 11904: 0xE6C3,
	30925 - 11904: 0xE6C0,
	30926 - 11904: 0xE6C5,
	30927 - 11904: 0xE6C2,
	30928 - 11904: 0xBD59,
	30929 - 11904: 0xE6C4,
	30930 - 11904: 0x94C4,
	30931 - 11904: 0xFEE3,
	30932 - 11904: 0xE6C6,
	30933 - 11904: 0xBD57,
	30935 - 11904: 0xFEE7,
	30936 - 11904: 0x9FFB,
	30938 - 11904: 0xBF6A,
	30939 - 11904: 0xEAA8,
	30941 - 11904: 0xEAA2,
	30942 - 11904: 0xEAA6,
	30943 - 11904: 0xEAAC,
	30944 - 11904: 0xEAAD,
	30945 - 11904: 0xEAA9,
	30946 - 11904: 0xEAAA,
	30947 - 11904: 0xEAA7,
	30948 - 11904: 0x8C59,
	30949 - 11904: 0xEAA4,
	30951 - 11904: 0xBF6C,
	30952 - 11904: 0xBF69,
	30953 - 11904: 0xEAA3,
	30954 - 11904: 0xEAA5,
	30956 - 11904: 0xBF6B,
	30957 - 11904: 0xEAAB,
	30958 - 11904: 0x93C9,
	30959 - 11904: 0xC146,
	30960 - 11904: 0x94E8,
	30961 - 11904: 0xFB56,
	30962 - 11904: 0xEDAA,
	30963 - 11904: 0xEDA5,
	30964 - 11904: 0xC145,
	30965 - 11904: 0x90C5,
	30967 - 11904: 0xC143,
	30969 - 11904: 0xEDAC,
	30970 - 11904: 0xC144,
	30971 - 11904: 0xEDA8,
	30972 - 11904: 0xEDA9,
	30973 - 11904: 0xEDA6,
	30974 - 11904: 0xEDAD,
	30975 - 11904: 0xF056,
	30977 - 11904: 0xC147,
	30978 - 11904: 0xEDA7,
	30980 - 11904: 0xEDAE,
	30981 - 11904: 0xEDAB,
	30982 - 11904: 0xA0A8,
	30985 - 11904: 0xF05A,
	30988 - 11904: 0xF057,
	30990 - 11904: 0xC2A6,
	30992 - 11904: 0xF05B,
	30993 - 11904: 0xF05D,
	30994 - 11904: 0xF05C,
	30995 - 11904: 0xF058,
	30996 - 11904: 0xF059,
	30999 - 11904: 0xF2A3,
	31001 - 11904: 0xC3AA,
	31003 - 11904: 0xF27E,
	31004 - 11904: 0xF2A2,
	31005 - 11904: 0xF27D,
	31006 - 11904: 0xF2A4,
	31009 - 11904: 0xF2A1,
	31011 - 11904: 0xF47A,
	31012 - 11904: 0xF47D,
	31013 - 11904: 0xF479,
	31014 - 11904: 0xC471,
	31015 - 11904: 0xF47B,
	31016 - 11904: 0xF47C,
	31017 - 11904: 0xF47E,
	31018 - 11904: 0xC472,
	31019 - 11904: 0xC474,
	31020 - 11904: 0xC473,
	31021 - 11904: 0xF5E1,
	31022 - 11904: 0xFEE5,
	31023 - 11904: 0xF5E3,
	31025 - 11904: 0xF5E2,
	31026 - 11904: 0x98FD,
	31027 - 11904: 0x98FB,
	31028 - 11904: 0xFEE8,
	31029 - 11904: 0xF6F6,
	31030 - 11904: 0x8EBF,
	31032 - 11904: 0xF8B5,
	31033 - 11904: 0xF8FA,
	31034 - 11904: 0xA5DC,
	31035 - 11904: 0x8BD8,
	31036 - 11904: 0xFEF7,
	31037 - 11904: 0xCB72,
	31038 - 11904: 0xAAC0,
	31039 - 11904: 0xCDA3,
	31040 - 11904: 0xAAC1,
	31041 - 11904: 0xAAC2,
	31042 - 11904: 0xCDA2,
	31044 - 11904: 0xCFF8,
	31045 - 11904: 0xCFF7,
	31046 - 11904: 0xACE6,
	31047 - 11904: 0xACE9,
	31048 - 11904: 0xACE8,
	31049 - 11904: 0xACE7,
	31050 - 11904: 0xCFF4,
	31051 - 11904: 0xCFF6,
	31052 - 11904: 0xCFF5,
	31055 - 11904: 0xD2E8,
	31056 - 11904: 0xAFA7,
	31057 - 11904: 0xD2EC,
	31058 - 11904: 0xD2EB,
	31059 - 11904: 0xD2EA,
	31060 - 11904: 0xD2E6,
	31061 - 11904: 0xAFA6,
	31062 - 11904: 0xAFAA,
	31063 - 11904: 0xAFAD,
	31064 - 11904: 0x8F68,
	31065 - 11904: 0x94C6,
	31066 - 11904: 0xAFAE,
	31067 - 11904: 0xD2E7,
	31068 - 11904: 0xD2E9,
	31069 - 11904: 0xAFAC,
	31070 - 11904: 0xAFAB,
	31071 - 11904: 0xAFA9,
	31072 - 11904: 0xAFA8,
	31073 - 11904: 0xD6C2,
	31074 - 11904: 0x9DEA,
	31075 - 11904: 0xD6C0,
	31076 - 11904: 0xD6BC,
	31077 - 11904: 0xB2BB,
	31079 - 11904: 0xD6BD,
	31080 - 11904: 0xB2BC,
	31081 - 11904: 0xD6BE,
	31082 - 11904: 0xD6BF,
	31083 - 11904: 0xD6C1,
	31085 - 11904: 0xB2BD,
	31088 - 11904: 0xDAD5,
	31089 - 11904: 0xFC69,
	31090 - 11904: 0xDAD4,
	31091 - 11904: 0xDAD3,
	31092 - 11904: 0xDAD2,
	31097 - 11904: 0xDEF6,
	31098 - 11904: 0xB852,
	31100 - 11904: 0xDEF3,
	31101 - 11904: 0xDEF5,
	31102 - 11904: 0x9CDA,
	31103 - 11904: 0xB853,
	31104 - 11904: 0xFEF3,
	31105 - 11904: 0xB854,
	31106 - 11904: 0xDEF4,
	31107 - 11904: 0x9C72,
	31110 - 11904: 0xFEF0,
	31111 - 11904: 0x89C9,
	31112 - 11904: 0xE341,
	31114 - 11904: 0xE2F9,
	31115 - 11904: 0xE2FA,
	31117 - 11904: 0xBAD7,
	31118 - 11904: 0xBAD5,
	31119 - 11904: 0xBAD6,
	31120 - 11904: 0xE343,
	31121 - 11904: 0x9941,
	31122 - 11904: 0xE342,
	31123 - 11904: 0xE2FE,
	31124 - 11904: 0xE2FD,
	31125 - 11904: 0xE2FC,
	31126 - 11904: 0xE2FB,
	31127 - 11904: 0xE340,
	31128 - 11904: 0xE2F8,
	31129 - 11904: 0x9942,
	31130 - 11904: 0xE6CB,
	31131 - 11904: 0xE6D0,
	31132 - 11904: 0xE6CE,
	31133 - 11904: 0xFEF5,
	31135 - 11904: 0x91D7,
	31136 - 11904: 0xE6CD,
	31137 - 11904: 0xE6CC,
	31138 - 11904: 0xE6CF,
	31140 - 11904: 0xEAAE,
	31141 - 11904: 0x94CC,
	31142 - 11904: 0xBF6D,
	31143 - 11904: 0xC148,
	31144 - 11904: 0xEDB0,
	31145 - 11904: 0xFEF8,
	31146 - 11904: 0xC149,
	31147 - 11904: 0xEDAF,
	31148 - 11904: 0xF05F,
	31149 - 11904: 0xF05E,
	31150 - 11904: 0xC2A7,
	31152 - 11904: 0xF2A5,
	31153 - 11904: 0xC3AB,
	31154 - 11904: 0xF4A1,
	31155 - 11904: 0xC5A1,
	31156 - 11904: 0xF6F7,
	31158 - 11904: 0xF8B7,
	31159 - 11904: 0xF8B6,
	31160 - 11904: 0xC9A8,
	31161 - 11904: 0xACEA,
	31162 - 11904: 0xACEB,
	31163 - 11904: 0xD6C3,
	31165 - 11904: 0xB856,
	31166 - 11904: 0xA5DD,
	31167 - 11904: 0xA872,
	31168 - 11904: 0xA871,
	31169 - 11904: 0xA870,
	31172 - 11904: 0x97A8,
	31173 - 11904: 0xCDA4,
	31174 - 11904: 0xFEFC,
	31176 - 11904: 0xAAC4,
	31177 - 11904: 0xAAC3,
	31178 - 11904: 0x8CDE,
	31179 - 11904: 0xACEE,
	31180 - 11904: 0xFDBF,
	31181 - 11904: 0xCFFA,
	31182 - 11904: 0xCFFD,
	31183 - 11904: 0xCFFB,
	31184 - 11904: 0x87B3,
	31185 - 11904: 0xACEC,
	31186 - 11904: 0xACED,
	31188 - 11904: 0xFEFE,
	31189 - 11904: 0xCFF9,
	31190 - 11904: 0xCFFC,
	31192 - 11904: 0xAFB5,
	31196 - 11904: 0xD2F3,
	31197 - 11904: 0xD2F5,
	31198 - 11904: 0xD2F4,
	31199 - 11904: 0xAFB2,
	31200 - 11904: 0xD2EF,
	31202 - 11904: 0x96D1,
	31203 - 11904: 0xAFB0,
	31204 - 11904: 0xAFAF,
	31206 - 11904: 0xAFB3,
	31207 - 11904: 0xAFB1,
	31209 - 11904: 0xAFB4,
	31210 - 11904: 0xD2F2,
	31211 - 11904: 0xD2ED,
	31212 - 11904: 0xD2EE,
	31213 - 11904: 0xD2F1,
	31214 - 11904: 0xD2F0,
	31217 - 11904: 0x94D5,
	31220 - 11904: 0x94D0,
	31222 - 11904: 0xD6C6,
	31223 - 11904: 0xD6C7,
	31224 - 11904: 0xD6C5,
	31226 - 11904: 0xD6C4,
	31227 - 11904: 0xB2BE,
	31232 - 11904: 0xB57D,
	31234 - 11904: 0xDAD6,
	31235 - 11904: 0xDAD8,
	31236 - 11904: 0xDADA,
	31237 - 11904: 0xB57C,
	31238 - 11904: 0x9944,
	31240 - 11904: 0xB57A,
	31242 - 11904: 0xDAD7,
	31243 - 11904: 0xB57B,
	31244 - 11904: 0xDAD9,
	31245 - 11904: 0xB579,
	31248 - 11904: 0xDF41,
	31249 - 11904: 0xDEF7,
	31250 - 11904: 0xDEFA,
	31251 - 11904: 0xDEFE,
	31252 - 11904: 0xB85A,
	31253 - 11904: 0xDEFC,
	31255 - 11904: 0xDEFB,
	31256 - 11904: 0xDEF8,
	31257 - 11904: 0xDEF9,
	31258 - 11904: 0xB858,
	31259 - 11904: 0xDF40,
	31260 - 11904: 0xB857,
	31262 - 11904: 0xB85C,
	31263 - 11904: 0xB85B,
	31264 - 11904: 0xB859,
	31266 - 11904: 0xDEFD,
	31270 - 11904: 0xE349,
	31272 - 11904: 0xE348,
	31274 - 11904: 0x8C63,
	31275 - 11904: 0xE344,
	31276 - 11904: 0x87BB,
	31277 - 11904: 0xA0B3,
	31278 - 11904: 0xBAD8,
	31279 - 11904: 0xE347,
	31280 - 11904: 0xE346,
	31281 - 11904: 0xBAD9,
	31282 - 11904: 0x87B4,
	31287 - 11904: 0xBD5E,
	31289 - 11904: 0xE6D2,
	31290 - 11904: 0x94CF,
	31291 - 11904: 0xBD5F,
	31292 - 11904: 0xBD5B,
	31293 - 11904: 0xBD5D,
	31294 - 11904: 0x9FFA,
	31295 - 11904: 0xBD5A,
	31296 - 11904: 0xBD5C,
	31299 - 11904: 0x91E5,
	31300 - 11904: 0xEAAF,
	31301 - 11904: 0x9C6A,
	31302 - 11904: 0xBF70,
	31303 - 11904: 0xEAB1,
	31304 - 11904: 0xEAB0,
	31305 - 11904: 0x8E49,
	31306 - 11904: 0xE345,
	31307 - 11904: 0xBF72,
	31308 - 11904: 0xBF71,
	31309 - 11904: 0xBF6E,
	31310 - 11904: 0xBF6F,
	31316 - 11904: 0xEDB5,
	31318 - 11904: 0xEDB3,
	31319 - 11904: 0xC14A,
	31320 - 11904: 0xEDB4,
	31322 - 11904: 0xEDB6,
	31323 - 11904: 0xEDB2,
	31324 - 11904: 0xEDB1,
	31327 - 11904: 0xF060,
	31328 - 11904: 0xC2AA,
	31329 - 11904: 0xC2A8,
	31330 - 11904: 0xC2A9,
	31333 - 11904: 0x8E4C,
	31335 - 11904: 0xF2A6,
	31336 - 11904: 0xF2A7,
	31337 - 11904: 0xC3AD,
	31339 - 11904: 0xC3AC,
	31340 - 11904: 0xF4A3,
	31341 - 11904: 0xF4A4,
	31342 - 11904: 0xF4A2,
	31344 - 11904: 0xF6F8,
	31345 - 11904: 0xF6F9,
	31346 - 11904: 0x87C9,
	31348 - 11904: 0xA5DE,
	31349 - 11904: 0xCA48,
	31350 - 11904: 0xA873,
	31352 - 11904: 0xCDA5,
	31353 - 11904: 0xAAC6,
	31354 - 11904: 0xAAC5,
	31355 - 11904: 0xCDA6,
	31357 - 11904: 0x8E4D,
	31358 - 11904: 0xD040,
	31359 - 11904: 0xACEF,
	31360 - 11904: 0xCFFE,
	31361 - 11904: 0xACF0,
	31363 - 11904: 0x9A73,
	31364 - 11904: 0xAFB6,
	31365 - 11904: 0xD2F8,
	31366 - 11904: 0xD2F6,
	31367 - 11904: 0xD2FC,
	31368 - 11904: 0xAFB7,
	31369 - 11904: 0xD2F7,
	31370 - 11904: 0xD2FB,
	31371 - 11904: 0xD2F9,
	31372 - 11904: 0xD2FA,
	31375 - 11904: 0xD6C8,
	31376 - 11904: 0xD6CA,
	31377 - 11904: 0x9947,
	31378 - 11904: 0xB2BF,
	31379 - 11904: 0x8CB1,
	31380 - 11904: 0xD6C9,
	31381 - 11904: 0xB2C0,
	31382 - 11904: 0xB5A2,
	31383 - 11904: 0xB5A1,
	31384 - 11904: 0xB57E,
	31385 - 11904: 0xDADB,
	31390 - 11904: 0xDF44,
	31391 - 11904: 0xB85D,
	31392 - 11904: 0xB85E,
	31394 - 11904: 0xDF43,
	31395 - 11904: 0xDF42,
	31400 - 11904: 0xE34A,
	31401 - 11904: 0xBADB,
	31402 - 11904: 0xBADA,
	31403 - 11904: 0xE34B,
	31404 - 11904: 0xE34C,
	31406 - 11904: 0xBD61,
	31407 - 11904: 0xBD60,
	31408 - 11904: 0x8E50,
	31409 - 11904: 0xEAB5,
	31410 - 11904: 0xE6D3,
	31411 - 11904: 0xE6D5,
	31412 - 11904: 0xE6D4,
	31413 - 11904: 0xEAB4,
	31414 - 11904: 0xEAB2,
	31415 - 11904: 0xEAB6,
	31416 - 11904: 0xEAB3,
	31418 - 11904: 0xBF73,
	31419 - 11904: 0x8E4F,
	31420 - 11904: 0x9949,
	31422 - 11904: 0xEDB7,
	31423 - 11904: 0xC14B,
	31424 - 11904: 0xEDB8,
	31425 - 11904: 0xEDB9,
	31426 - 11904: 0x8E51,
	31427 - 11904: 0x8E52,
	31428 - 11904: 0xC2AB,
	31429 - 11904: 0xC2AC,
	31431 - 11904: 0xC475,
	31432 - 11904: 0x9AB2,
	31433 - 11904: 0x89A5,
	31434 - 11904: 0xC5D1,
	31435 - 11904: 0xA5DF,
	31439 - 11904: 0x994C,
	31441 - 11904: 0xD041,
	31443 - 11904: 0x9FF8,
	31448 - 11904: 0xD2FD,
	31449 - 11904: 0xAFB8,
	31450 - 11904: 0x8E56,
	31451 - 11904: 0x994D,
	31452 - 11904: 0x91CA,
	31453 - 11904: 0x8E57,
	31455 - 11904: 0xB3BA,
	31456 - 11904: 0xB3B9,
	31458 - 11904: 0x94E1,
	31459 - 11904: 0xB5A4,
	31460 - 11904: 0xDADD,
	31461 - 11904: 0xB5A3,
	31462 - 11904: 0xDADC,
	31463 - 11904: 0x9047,
	31465 - 11904: 0x8FD8,
	31466 - 11904: 0x8E58,
	31467 - 11904: 0xDF45,
	31469 - 11904: 0xBADC,
	31470 - 11904: 0xE34D,
	31471 - 11904: 0xBADD,
	31478 - 11904: 0xC476,
	31479 - 11904: 0xF4A5,
	31481 - 11904: 0xA6CB,
	31482 - 11904: 0xAAC7,
	31483 - 11904: 0xCDA7,
	31484 - 11904: 0x87A3,
	31485 - 11904: 0xACF2,
	31486 - 11904: 0x94EB,
	31487 - 11904: 0xACF1,
	31488 - 11904: 0xD042,
	31489 - 11904: 0xD043,
	31492 - 11904: 0xD340,
	31493 - 11904: 0xD342,
	31494 - 11904: 0xAFB9,
	31496 - 11904: 0xD344,
	31497 - 11904: 0xD347,
	31498 - 11904: 0xD345,
	31499 - 11904: 0x8E5C,
	31500 - 11904: 0x9553,
	31502 - 11904: 0xD346,
	31503 - 11904: 0xD343,
	31504 - 11904: 0xD2FE,
	31505 - 11904: 0xAFBA,
	31506 - 11904: 0xD348,
	31507 - 11904: 0xD341,
	31508 - 11904: 0x9FE5,
	31512 - 11904: 0xD6D3,
	31513 - 11904: 0xB2C6,
	31514 - 11904: 0xD6DC,
	31515 - 11904: 0xB2C3,
	31517 - 11904: 0xD6D5,
	31518 - 11904: 0xB2C7,
	31519 - 11904: 0x9F56,
	31520 - 11904: 0xB2C1,
	31522 - 11904: 0xD6D0,
	31523 - 11904: 0xD6DD,
	31524 - 11904: 0xD6D1,
	31525 - 11904: 0xD6CE,
	31526 - 11904: 0xB2C5,
	31527 - 11904: 0x954F,
	31528 - 11904: 0xB2C2,
	31529 - 11904: 0x8E5E,
	31530 - 11904: 0xD6D4,
	31531 - 11904: 0xD6D7,
	31532 - 11904: 0xB2C4,
	31533 - 11904: 0xD6D8,
	31534 - 11904: 0xB2C8,
	31535 - 11904: 0xD6D9,
	31536 - 11904: 0xD6CF,
	31537 - 11904: 0xD6D6,
	31538 - 11904: 0xD6DA,
	31539 - 11904: 0xD6D2,
	31540 - 11904: 0xD6CD,
	31541 - 11904: 0xD6CB,
	31544 - 11904: 0xD6DB,
	31545 - 11904: 0x996A,
	31547 - 11904: 0xDADF,
	31552 - 11904: 0xDAE4,
	31554 - 11904: 0x9C64,
	31555 - 11904: 0x9CD9,
	31556 - 11904: 0xDAE0,
	31557 - 11904: 0xDAE6,
	31558 - 11904: 0xB5A7,
	31559 - 11904: 0xD6CC,
	31560 - 11904: 0xDAE1,
	31561 - 11904: 0xB5A5,
	31562 - 11904: 0xDADE,
	31563 - 11904: 0xB5AC,
	31564 - 11904: 0xDAE2,
	31565 - 11904: 0xB5AB,
	31566 - 11904: 0xDAE3,
	31567 - 11904: 0xB5AD,
	31568 - 11904: 0xB5A8,
	31569 - 11904: 0xB5AE,
	31570 - 11904: 0xB5A9,
	31572 - 11904: 0xB5AA,
	31573 - 11904: 0x8E5D,
	31574 - 11904: 0xB5A6,
	31576 - 11904: 0xDAE5,
	31584 - 11904: 0xB861,
	31585 - 11904: 0xDF50,
	31586 - 11904: 0x9950,
	31587 - 11904: 0xDF53,
	31588 - 11904: 0xDF47,
	31589 - 11904: 0xDF4C,
	31590 - 11904: 0xDF46,
	31591 - 11904: 0xB863,
	31593 - 11904: 0xDF4A,
	31596 - 11904: 0x9951,
	31597 - 11904: 0xDF48,
	31598 - 11904: 0xB862,
	31599 - 11904: 0x8E62,
	31600 - 11904: 0xDF4F,
	31601 - 11904: 0xDF4E,
	31602 - 11904: 0xDF4B,
	31603 - 11904: 0xDF4D,
	31604 - 11904: 0xDF49,
	31605 - 11904: 0xBAE1,
	31606 - 11904: 0xDF52,
	31607 - 11904: 0xB85F,
	31608 - 11904: 0xDF51,
	31611 - 11904: 0x9952,
	31618 - 11904: 0xE35D,
	31620 - 11904: 0xBAE8,
	31621 - 11904: 0xE358,
	31623 - 11904: 0xBAE7,
	31624 - 11904: 0xE34E,
	31626 - 11904: 0xE350,
	31627 - 11904: 0xBAE0,
	31628 - 11904: 0xE355,
	31629 - 11904: 0xE354,
	31630 - 11904: 0xE357,
	31631 - 11904: 0xBAE5,
	31632 - 11904: 0xE352,
	31633 - 11904: 0xE351,
	31634 - 11904: 0x8E68,
	31636 - 11904: 0xBAE4,
	31637 - 11904: 0xBADF,
	31638 - 11904: 0xE353,
	31639 - 11904: 0xBAE2,
	31640 - 11904: 0xE359,
	31641 - 11904: 0xE35B,
	31643 - 11904: 0xE356,
	31644 - 11904: 0xE34F,
	31645 - 11904: 0xBAE3,
	31648 - 11904: 0xBD69,
	31649 - 11904: 0xBADE,
	31650 - 11904: 0x8E61,
	31651 - 11904: 0x9F59,
	31652 - 11904: 0xE35C,
	31660 - 11904: 0xE6D9,
	31661 - 11904: 0xBD62,
	31662 - 11904: 0x87D0,
	31663 - 11904: 0xE6DB,
	31665 - 11904: 0xBD63,
	31666 - 11904: 0x8BB3,
	31668 - 11904: 0xBD65,
	31669 - 11904: 0xE6DE,
	31671 - 11904: 0xE6D6,
	31672 - 11904: 0xBAE6,
	31673 - 11904: 0xE6DC,
	31678 - 11904: 0xE6D8,
	31680 - 11904: 0xB860,
	31681 - 11904: 0xBD68,
	31684 - 11904: 0xBD64,
	31685 - 11904: 0x87B9,
	31686 - 11904: 0xBD66,
	31687 - 11904: 0xBD67,
	31689 - 11904: 0xBF76,
	31690 - 11904: 0xE6DD,
	31691 - 11904: 0xE6D7,
	31692 - 11904: 0xBD6A,
	31694 - 11904: 0xE6DA,
	31695 - 11904: 0x9F5D,
	31696 - 11904: 0x8E66,
	31700 - 11904: 0xEAC0,
	31701 - 11904: 0xEABB,
	31704 - 11904: 0xEAC5,
	31705 - 11904: 0xBF74,
	31706 - 11904: 0xEABD,
	31707 - 11904: 0xBF78,
	31708 - 11904: 0xEAC3,
	31709 - 11904: 0xEABA,
	31710 - 11904: 0xEAB7,
	31711 - 11904: 0xEAC6,
	31712 - 11904: 0xC151,
	31713 - 11904: 0xBF79,
	31714 - 11904: 0xEAC2,
	31715 - 11904: 0xEAB8,
	31716 - 11904: 0xBF77,
	31717 - 11904: 0xEABC,
	31718 - 11904: 0xBF7B,
	31719 - 11904: 0xEAB9,
	31720 - 11904: 0xEABE,
	31721 - 11904: 0xBF7A,
	31722 - 11904: 0xEAC1,
	31723 - 11904: 0xEAC4,
	31724 - 11904: 0x8CB2,
	31728 - 11904: 0xEDCB,
	31729 - 11904: 0xEDCC,
	31730 - 11904: 0xEDBC,
	31731 - 11904: 0xEDC3,
	31732 - 11904: 0xEDC1,
	31735 - 11904: 0xC14F,
	31736 - 11904: 0xEDC8,
	31737 - 11904: 0xEABF,
	31738 - 11904: 0x8E6E,
	31739 - 11904: 0xEDBF,
	31740 - 11904: 0x9F64,
	31741 - 11904: 0xEDC9,
	31742 - 11904: 0xC14E,
	31743 - 11904: 0xEDBE,
	31744 - 11904: 0xEDBD,
	31745 - 11904: 0xEDC7,
	31746 - 11904: 0xEDC4,
	31747 - 11904: 0xEDC6,
	31749 - 11904: 0xEDBA,
	31750 - 11904: 0xEDCA,
	31751 - 11904: 0xC14C,
	31753 - 11904: 0xEDC5,
	31754 - 11904: 0xEDCE,
	31755 - 11904: 0xEDC2,
	31756 - 11904: 0xC150,
	31757 - 11904: 0xC14D,
	31758 - 11904: 0xEDC0,
	31759 - 11904: 0xEDBB,
	31760 - 11904: 0xEDCD,
	31761 - 11904: 0xBF75,
	31762 - 11904: 0x9953,
	31765 - 11904: 0xFAB8,
	31769 - 11904: 0xF063,
	31771 - 11904: 0x9954,
	31772 - 11904: 0xF061,
	31773 - 11904: 0xF067,
	31774 - 11904: 0xC2B0,
	31775 - 11904: 0xF065,
	31776 - 11904: 0xF064,
	31777 - 11904: 0xC2B2,
	31778 - 11904: 0xF06A,
	31779 - 11904: 0xC2B1,
	31781 - 11904: 0xF06B,
	31782 - 11904: 0xF068,
	31783 - 11904: 0xC2AE,
	31784 - 11904: 0xF069,
	31785 - 11904: 0xF062,
	31786 - 11904: 0xC2AF,
	31787 - 11904: 0xC2AD,
	31788 - 11904: 0xF2AB,
	31789 - 11904: 0xF066,
	31792 - 11904: 0xF06C,
	31795 - 11904: 0xF2A8,
	31797 - 11904: 0x8E70,
	31799 - 11904: 0xC3B2,
	31800 - 11904: 0xC3B0,
	31801 - 11904: 0xF2AA,
	31803 - 11904: 0xF2AC,
	31804 - 11904: 0xF2A9,
	31805 - 11904: 0xC3B1,
	31806 - 11904: 0xC3AE,
	31807 - 11904: 0xC3AF,
	31808 - 11904: 0xC3B3,
	31810 - 11904: 0x9F61,
	31811 - 11904: 0xC478,
	31812 - 11904: 0x8E72,
	31813 - 11904: 0xF4AA,
	31815 - 11904: 0xF4A9,
	31816 - 11904: 0xF4A7,
	31817 - 11904: 0xF4A6,
	31818 - 11904: 0xF4A8,
	31820 - 11904: 0xC477,
	31821 - 11904: 0xC479,
	31824 - 11904: 0xC4F0,
	31825 - 11904: 0xA06B,
	31827 - 11904: 0xF5E5,
	31828 - 11904: 0xF5E4,
	31830 - 11904: 0x9F40,
	31831 - 11904: 0xF6FA,
	31833 - 11904: 0xF6FC,
	31834 - 11904: 0xF6FE,
	31835 - 11904: 0xF6FD,
	31836 - 11904: 0xF6FB,
	31837 - 11904: 0x94ED,
	31839 - 11904: 0xC5A3,
	31840 - 11904: 0xC5A2,
	31843 - 11904: 0xC5D3,
	31844 - 11904: 0xC5D2,
	31845 - 11904: 0xC5D4,
	31846 - 11904: 0xF7ED,
	31847 - 11904: 0xF7EC,
	31849 - 11904: 0xF8FB,
	31850 - 11904: 0xF8B8,
	31851 - 11904: 0xF8FC,
	31852 - 11904: 0xC658,
	31853 - 11904: 0x94EE,
	31854 - 11904: 0xC659,
	31855 - 11904: 0xF96D,
	31856 - 11904: 0x9FBD,
	31858 - 11904: 0xC67E,
	31859 - 11904: 0xA6CC,
	31860 - 11904: 0x8E7B,
	31861 - 11904: 0xCDA8,
	31864 - 11904: 0xD045,
	31865 - 11904: 0xD046,
	31866 - 11904: 0xD044,
	31867 - 11904: 0x9957,
	31868 - 11904: 0x94F7,
	31869 - 11904: 0xACF3,
	31870 - 11904: 0x9F5F,
	31871 - 11904: 0xD047,
	31872 - 11904: 0xD048,
	31873 - 11904: 0xD049,
	31875 - 11904: 0x8E73,
	31876 - 11904: 0xD349,
	31877 - 11904: 0xD34F,
	31878 - 11904: 0x9F62,
	31880 - 11904: 0xD34D,
	31881 - 11904: 0xAFBB,
	31882 - 11904: 0xD34B,
	31884 - 11904: 0xD34C,
	31885 - 11904: 0xD34E,
	31886 - 11904: 0x94F6,
	31889 - 11904: 0xD34A,
	31890 - 11904: 0xB2C9,
	31892 - 11904: 0xD6DE,
	31893 - 11904: 0xB2CB,
	31894 - 11904: 0xD6E0,
	31895 - 11904: 0xB2CA,
	31896 - 11904: 0xD6DF,
	31900 - 11904: 0x9958,
	31902 - 11904: 0xDAE8,
	31903 - 11904: 0xB5AF,
	31905 - 11904: 0xDAEA,
	31906 - 11904: 0xDAE7,
	31907 - 11904: 0xD6E1,
	31909 - 11904: 0xB5B0,
	31910 - 11904: 0x8E75,
	31911 - 11904: 0xF9DB,
	31912 - 11904: 0xDAE9,
	31916 - 11904: 0x9072,
	31918 - 11904: 0x94F8,
	31919 - 11904: 0xDF56,
	31921 - 11904: 0xB864,
	31922 - 11904: 0xDF54,
	31923 - 11904: 0xB865,
	31924 - 11904: 0xDF55,
	31925 - 11904: 0xB866,
	31928 - 11904: 0x995A,
	31929 - 11904: 0xBAE9,
	31930 - 11904: 0xE361,
	31931 - 11904: 0xE35E,
	31932 - 11904: 0xE360,
	31933 - 11904: 0xBAEA,
	31934 - 11904: 0xBAEB,
	31935 - 11904: 0xE35F,
	31938 - 11904: 0xA0B0,
	31939 - 11904: 0x8CB3,
	31941 - 11904: 0xE6DF,
	31943 - 11904: 0x8E79,
	31944 - 11904: 0xE6E0,
	31945 - 11904: 0x8E78,
	31946 - 11904: 0xBD6B,
	31947 - 11904: 0xE6E2,
	31948 - 11904: 0xE6E1,
	31949 - 11904: 0x94F3,
	31950 - 11904: 0xA261,
	31952 - 11904: 0xEACA,
	31953 - 11904: 0xEACB,
	31954 - 11904: 0xEAC7,
	31955 - 11904: 0x98AF,
	31956 - 11904: 0xEAC8,
	31957 - 11904: 0xBF7C,
	31958 - 11904: 0xBF7D,
	31959 - 11904: 0xEAC9,
	31961 - 11904: 0xC157,
	31962 - 11904: 0xA0B2,
	31964 - 11904: 0xC153,
	31965 - 11904: 0xC158,
	31966 - 11904: 0xC154,
	31967 - 11904: 0xC156,
	31968 - 11904: 0xC152,
	31970 - 11904: 0xC155,
	31974 - 11904: 0x8E7A,
	31975 - 11904: 0xC2B3,
	31976 - 11904: 0xEDCF,
	31978 - 11904: 0xF2AE,
	31980 - 11904: 0xF2AD,
	31981 - 11904: 0x995C,
	31982 - 11904: 0xF4AB,
	31983 - 11904: 0xC47A,
	31984 - 11904: 0xC47B,
	31985 - 11904: 0xF741,
	31986 - 11904: 0xF5E6,
	31987 - 11904: 0x8E7C,
	31988 - 11904: 0xF740,
	31989 - 11904: 0x8E7D,
	31990 - 11904: 0xF8FD,
	31991 - 11904: 0xF9A4,
	31992 - 11904: 0xA6CD,
	31993 - 11904: 0x8BD9,
	31995 - 11904: 0xA874,
	31996 - 11904: 0x89A2,
	31997 - 11904: 0xCDA9,
	31998 - 11904: 0xAAC8,
	32000 - 11904: 0xACF6,
	32001 - 11904: 0xD04C,
	32002 - 11904: 0xACF4,
	32003 - 11904: 0xD04A,
	32004 - 11904: 0xACF9,
	32005 - 11904: 0xACF5,
	32006 - 11904: 0xACFA,
	32007 - 11904: 0xACF8,
	32008 - 11904: 0xD04B,
	32009 - 11904: 0xACF7,
	32010 - 11904: 0xAFBF,
	32011 - 11904: 0xAFBE,
	32012 - 11904: 0xD35A,
	32013 - 11904: 0xAFC7,
	32014 - 11904: 0xD353,
	32015 - 11904: 0xD359,
	32016 - 11904: 0xAFC3,
	32017 - 11904: 0xD352,
	32018 - 11904: 0xD358,
	32019 - 11904: 0xD356,
	32020 - 11904: 0xAFC2,
	32021 - 11904: 0xAFC4,
	32022 - 11904: 0xD355,
	32023 - 11904: 0xAFBD,
	32024 - 11904: 0xD354,
	32025 - 11904: 0xAFC8,
	32026 - 11904: 0xAFC5,
	32027 - 11904: 0xAFC9,
	32028 - 11904: 0xAFC6,
	32029 - 11904: 0xD351,
	32030 - 11904: 0xD350,
	32031 - 11904: 0xD357,
	32032 - 11904: 0xAFC0,
	32033 - 11904: 0xAFBC,
	32034 - 11904: 0xAFC1,
	32037 - 11904: 0x9ED7,
	32040 - 11904: 0xD6F0,
	32041 - 11904: 0xD6E9,
	32043 - 11904: 0xB5B5,
	32044 - 11904: 0xD6E8,
	32046 - 11904: 0xB2CF,
	32047 - 11904: 0xB2D6,
	32048 - 11904: 0xB2D3,
	32049 - 11904: 0xB2D9,
	32050 - 11904: 0xB2D8,
	32051 - 11904: 0xB2D4,
	32053 - 11904: 0xD6E2,
	32054 - 11904: 0xD6E5,
	32056 - 11904: 0xD6E4,
	32057 - 11904: 0xB2D0,
	32058 - 11904: 0xD6E6,
	32059 - 11904: 0xD6EF,
	32060 - 11904: 0xB2D1,
	32061 - 11904: 0xD6E3,
	32062 - 11904: 0xD6EC,
	32063 - 11904: 0xD6ED,
	32064 - 11904: 0xB2D2,
	32065 - 11904: 0xD6EA,
	32066 - 11904: 0xB2D7,
	32067 - 11904: 0xB2CD,
	32068 - 11904: 0xB2D5,
	32069 - 11904: 0xD6E7,
	32070 - 11904: 0xB2CC,
	32071 - 11904: 0xD6EB,
	32074 - 11904: 0xD6EE,
	32077 - 11904: 0xA0B6,
	32078 - 11904: 0xDAFB,
	32079 - 11904: 0xDAF2,
	32080 - 11904: 0xB5B2,
	32081 - 11904: 0xDAF9,
	32082 - 11904: 0xDAF6,
	32083 - 11904: 0xDAEE,
	32084 - 11904: 0xDAF7,
	32085 - 11904: 0xB5B4,
	32086 - 11904: 0xDAEF,
	32088 - 11904: 0xDAEB,
	32090 - 11904: 0x9E42,
	32091 - 11904: 0xB86C,
	32092 - 11904: 0xDAF4,
	32093 - 11904: 0x8EA4,
	32094 - 11904: 0xB5B1,
	32095 - 11904: 0xDAFA,
	32097 - 11904: 0xB5B8,
	32098 - 11904: 0xB5BA,
	32099 - 11904: 0xDAED,
	32102 - 11904: 0xB5B9,
	32103 - 11904: 0xDAF0,
	32104 - 11904: 0xB5B3,
	32105 - 11904: 0xDAF8,
	32106 - 11904: 0xDAF1,
	32107 - 11904: 0xDAF5,
	32109 - 11904: 0xDAF3,
	32110 - 11904: 0xB5B6,
	32111 - 11904: 0xDAEC,
	32112 - 11904: 0xB5BB,
	32113 - 11904: 0xB2CE,
	32114 - 11904: 0xB5B7,
	32115 - 11904: 0xB5BC,
	32121 - 11904: 0xB868,
	32122 - 11904: 0xDF5D,
	32123 - 11904: 0xDF5F,
	32124 - 11904: 0xDF61,
	32125 - 11904: 0xDF65,
	32127 - 11904: 0xDF5B,
	32128 - 11904: 0xDF59,
	32129 - 11904: 0xB86A,
	32131 - 11904: 0xDF60,
	32132 - 11904: 0xDF64,
	32133 - 11904: 0xDF5C,
	32134 - 11904: 0xDF58,
	32136 - 11904: 0xDF57,
	32137 - 11904: 0x8EA7,
	32139 - 11904: 0x8C76,
	32140 - 11904: 0xDF62,
	32141 - 11904: 0xDF5A,
	32142 - 11904: 0xDF5E,
	32143 - 11904: 0xB86B,
	32145 - 11904: 0xB869,
	32146 - 11904: 0xDF66,
	32147 - 11904: 0xB867,
	32148 - 11904: 0xDF63,
	32149 - 11904: 0x8767,
	32150 - 11904: 0xE372,
	32151 - 11904: 0x9542,
	32156 - 11904: 0xBAEE,
	32157 - 11904: 0xE36A,
	32158 - 11904: 0xBD78,
	32159 - 11904: 0xE374,
	32160 - 11904: 0xBAF1,
	32161 - 11904: 0xE378,
	32162 - 11904: 0xBAF7,
	32163 - 11904: 0xE365,
	32164 - 11904: 0x987D,
	32166 - 11904: 0xE375,
	32167 - 11904: 0xE362,
	32168 - 11904: 0x9755,
	32169 - 11904: 0xE377,
	32170 - 11904: 0xE366,
	32171 - 11904: 0x8EA8,
	32172 - 11904: 0xBAFE,
	32173 - 11904: 0xBAFB,
	32174 - 11904: 0xE376,
	32175 - 11904: 0xE370,
	32176 - 11904: 0xBAED,
	32177 - 11904: 0xBAF5,
	32178 - 11904: 0xBAF4,
	32179 - 11904: 0x8EAA,
	32180 - 11904: 0xBAF3,
	32181 - 11904: 0xBAF9,
	32183 - 11904: 0xE363,
	32184 - 11904: 0xBAFA,
	32185 - 11904: 0xE371,
	32186 - 11904: 0xBAF6,
	32187 - 11904: 0xBAEC,
	32188 - 11904: 0xE373,
	32189 - 11904: 0xBAEF,
	32190 - 11904: 0xBAF0,
	32191 - 11904: 0xBAF8,
	32192 - 11904: 0xE368,
	32193 - 11904: 0xE367,
	32194 - 11904: 0xE364,
	32196 - 11904: 0xE36C,
	32197 - 11904: 0xE369,
	32198 - 11904: 0xE36D,
	32199 - 11904: 0xBAFD,
	32201 - 11904: 0xE379,
	32202 - 11904: 0xBAF2,
	32203 - 11904: 0xE36E,
	32204 - 11904: 0xE36F,
	32205 - 11904: 0x89A3,
	32206 - 11904: 0xE36B,
	32207 - 11904: 0x9960,
	32208 - 11904: 0x9962,
	32210 - 11904: 0xBAFC,
	32211 - 11904: 0x94FC,
	32212 - 11904: 0x9961,
	32215 - 11904: 0xE6E7,
	32216 - 11904: 0xBD70,
	32217 - 11904: 0xBD79,
	32218 - 11904: 0xBD75,
	32219 - 11904: 0xE6E4,
	32220 - 11904: 0x94FA,
	32221 - 11904: 0xBD72,
	32222 - 11904: 0xBD76,
	32223 - 11904: 0xE6F0,
	32224 - 11904: 0xBD6C,
	32225 - 11904: 0xE6E8,
	32227 - 11904: 0xBD74,
	32228 - 11904: 0x8EAE,
	32229 - 11904: 0x8EB2,
	32230 - 11904: 0xE6EB,
	32231 - 11904: 0xE6E6,
	32232 - 11904: 0xBD73,
	32233 - 11904: 0xBD77,
	32234 - 11904: 0xE6E5,
	32236 - 11904: 0xBD71,
	32238 - 11904: 0xE6EF,
	32239 - 11904: 0xBD6E,
	32240 - 11904: 0xE6EE,
	32241 - 11904: 0xE6ED,
	32242 - 11904: 0xBD7A,
	32243 - 11904: 0xE572,
	32244 - 11904: 0xBD6D,
	32245 - 11904: 0x8EB0,
	32246 - 11904: 0xE6EC,
	32247 - 11904: 0xE6E3,
	32249 - 11904: 0xBD7B,
	32250 - 11904: 0xE6EA,
	32251 - 11904: 0xBD6F,
	32253 - 11904: 0x9963,
	32254 - 11904: 0x97AA,
	32259 - 11904: 0xE6E9,
	32263 - 11904: 0x94FB,
	32264 - 11904: 0xBFA2,
	32265 - 11904: 0xBFA7,
	32266 - 11904: 0xBF7E,
	32267 - 11904: 0xEAD8,
	32268 - 11904: 0xEACF,
	32269 - 11904: 0xEADB,
	32270 - 11904: 0xEAD3,
	32271 - 11904: 0xEAD9,
	32272 - 11904: 0xBFA8,
	32273 - 11904: 0xBFA1,
	32274 - 11904: 0xEACC,
	32275 - 11904: 0xEAD2,
	32276 - 11904: 0xEADC,
	32277 - 11904: 0xEAD5,
	32278 - 11904: 0xEADA,
	32279 - 11904: 0xEACE,
	32282 - 11904: 0xEAD6,
	32283 - 11904: 0xBFA3,
	32284 - 11904: 0xEAD4,
	32285 - 11904: 0xBFA6,
	32286 - 11904: 0xBFA5,
	32287 - 11904: 0xEAD0,
	32288 - 11904: 0xEAD1,
	32289 - 11904: 0xEACD,
	32290 - 11904: 0xEAD7,
	32291 - 11904: 0xBFA4,
	32292 - 11904: 0xEADE,
	32293 - 11904: 0xEADD,
	32295 - 11904: 0x8EBB,
	32297 - 11904: 0xEDDA,
	32298 - 11904: 0xEDD6,
	32299 - 11904: 0xC15F,
	32301 - 11904: 0xEDD0,
	32302 - 11904: 0xC159,
	32303 - 11904: 0xC169,
	32304 - 11904: 0xEDDC,
	32305 - 11904: 0xC161,
	32306 - 11904: 0xC15D,
	32307 - 11904: 0xEDD3,
	32308 - 11904: 0xC164,
	32309 - 11904: 0xC167,
	32310 - 11904: 0xEDDE,
	32311 - 11904: 0xC15C,
	32312 - 11904: 0xEDD5,
	32313 - 11904: 0xC165,
	32314 - 11904: 0xEDE0,
	32315 - 11904: 0xEDDD,
	32316 - 11904: 0xEDD1,
	32317 - 11904: 0xC160,
	32318 - 11904: 0xC15A,
	32319 - 11904: 0xC168,
	32320 - 11904: 0xEDD8,
	32321 - 11904: 0xC163,
	32322 - 11904: 0xEDD2,
	32323 - 11904: 0xC15E,
	32324 - 11904: 0xEDDF,
	32325 - 11904: 0xC162,
	32326 - 11904: 0xC15B,
	32327 - 11904: 0xEDD9,
	32328 - 11904: 0xC166,
	32329 - 11904: 0xEDD7,
	32332 - 11904: 0xEDDB,
	32336 - 11904: 0xF06E,
	32337 - 11904: 0xF074,
	32338 - 11904: 0xC2B9,
	32339 - 11904: 0xF077,
	32340 - 11904: 0xC2B4,
	32341 - 11904: 0xC2B5,
	32342 - 11904: 0xF06F,
	32343 - 11904: 0xF076,
	32344 - 11904: 0xF071,
	32345 - 11904: 0xC2BA,
	32346 - 11904: 0xC2B7,
	32347 - 11904: 0x8CDC,
	32348 - 11904: 0xF06D,
	32350 - 11904: 0xC2B6,
	32351 - 11904: 0xF073,
	32352 - 11904: 0xF075,
	32353 - 11904: 0xC2B8,
	32354 - 11904: 0xF072,
	32355 - 11904: 0xF070,
	32357 - 11904: 0x9876,
	32359 - 11904: 0x8EA1,
	32360 - 11904: 0xF2B8,
	32361 - 11904: 0xC3B7,
	32362 - 11904: 0xC3B8,
	32363 - 11904: 0xC3B4,
	32364 - 11904: 0x8CB4,
	32365 - 11904: 0xC3B5,
	32366 - 11904: 0x8EB7,
	32367 - 11904: 0xF2B4,
	32368 - 11904: 0xF2B2,
	32370 - 11904: 0xF2B6,
	32371 - 11904: 0xC3BA,
	32372 - 11904: 0xF2B7,
	32373 - 11904: 0xF2B0,
	32374 - 11904: 0xF2AF,
	32375 - 11904: 0xF2B3,
	32376 - 11904: 0xF2B1,
	32377 - 11904: 0xC3B6,
	32378 - 11904: 0xF2B5,
	32379 - 11904: 0xF4AC,
	32380 - 11904: 0xC47E,
	32381 - 11904: 0xC47D,
	32382 - 11904: 0xF4AD,
	32383 - 11904: 0x9DA6,
	32384 - 11904: 0xF4AF,
	32385 - 11904: 0xF4AE,
	32386 - 11904: 0xC4A1,
	32390 - 11904: 0xF5EB,
	32391 - 11904: 0xF5E8,
	32392 - 11904: 0xF5E9,
	32394 - 11904: 0xF5E7,
	32395 - 11904: 0xF5EA,
	32396 - 11904: 0xC4F2,
	32397 - 11904: 0xF5EC,
	32398 - 11904: 0x9EB0,
	32399 - 11904: 0xC4F1,
	32401 - 11904: 0xF742,
	32402 - 11904: 0x8EB8,
	32403 - 11904: 0xC5D5,
	32404 - 11904: 0xC5D7,
	32405 - 11904: 0xF7EE,
	32406 - 11904: 0xC5D6,
	32407 - 11904: 0xF8B9,
	32408 - 11904: 0xF940,
	32409 - 11904: 0xF942,
	32410 - 11904: 0xF8FE,
	32411 - 11904: 0xF941,
	32412 - 11904: 0xC66C,
	32415 - 11904: 0x9D70,
	32420 - 11904: 0x896E,
	32428 - 11904: 0x896F,
	32442 - 11904: 0x8970,
	32455 - 11904: 0x8971,
	32463 - 11904: 0x8972,
	32479 - 11904: 0x8973,
	32518 - 11904: 0x8974,
	32566 - 11904: 0xA6CE,
	32567 - 11904: 0x8975,
	32568 - 11904: 0xACFB,
	32569 - 11904: 0xD26F,
	32570 - 11904: 0xAFCA,
	32573 - 11904: 0xB2DA,
	32574 - 11904: 0xDAFC,
	32575 - 11904: 0xDAFD,
	32576 - 11904: 0x8EBC,
	32577 - 11904: 0x8EBD,
	32579 - 11904: 0xEADF,
	32580 - 11904: 0xC16A,
	32581 - 11904: 0xEDE1,
	32583 - 11904: 0x8EBE,
	32584 - 11904: 0xC2BB,
	32585 - 11904: 0x9DD1,
	32586 - 11904: 0xF2BA,
	32587 - 11904: 0xF2B9,
	32588 - 11904: 0xC4A2,
	32589 - 11904: 0xF5ED,
	32590 - 11904: 0x94FD,
	32591 - 11904: 0xF743,
	32592 - 11904: 0xC5F8,
	32593 - 11904: 0xCA49,
	32594 - 11904: 0x8BD7,
	32595 - 11904: 0x8BDA,
	32596 - 11904: 0xAAC9,
	32597 - 11904: 0xA875,
	32600 - 11904: 0xD04D,
	32603 - 11904: 0xD360,
	32604 - 11904: 0xD35B,
	32605 - 11904: 0xD35F,
	32606 - 11904: 0xD35D,
	32607 - 11904: 0xAFCB,
	32608 - 11904: 0xD35E,
	32609 - 11904: 0xD35C,
	32611 - 11904: 0xD6F1,
	32613 - 11904: 0xDAFE,
	32614 - 11904: 0xDB40,
	32615 - 11904: 0xDF69,
	32616 - 11904: 0xDF6A,
	32617 - 11904: 0xB86E,
	32618 - 11904: 0xB86F,
	32619 - 11904: 0xDF68,
	32620 - 11904: 0xDF6B,
	32621 - 11904: 0xDF67,
	32622 - 11904: 0xB86D,
	32624 - 11904: 0xBB40,
	32625 - 11904: 0xA0E2,
	32626 - 11904: 0xB870,
	32627 - 11904: 0xE37A,
	32629 - 11904: 0xBD7C,
	32630 - 11904: 0xE6F1,
	32631 - 11904: 0xBD7D,
	32632 - 11904: 0x9FE9,
	32633 - 11904: 0xBFA9,
	32634 - 11904: 0xEAE2,
	32635 - 11904: 0xEAE0,
	32636 - 11904: 0xEAE1,
	32637 - 11904: 0xEDE4,
	32638 - 11904: 0xEDE3,
	32639 - 11904: 0xEDE2,
	32643 - 11904: 0xF2BB,
	32645 - 11904: 0xC3B9,
	32646 - 11904: 0xF2BC,
	32647 - 11904: 0xF744,
	32648 - 11904: 0xC5F9,
	32649 - 11904: 0xF8BA,
	32650 - 11904: 0xA6CF,
	32651 - 11904: 0xAACB,
	32652 - 11904: 0xAACA,
	32653 - 11904: 0xD04F,
	32654 - 11904: 0xACFC,
	32655 - 11904: 0xFDA8,
	32657 - 11904: 0xD04E,
	32658 - 11904: 0xD362,
	32659 - 11904: 0x8AE7,
	32660 - 11904: 0xAFCC,
	32661 - 11904: 0xD6F2,
	32662 - 11904: 0xD361,
	32663 - 11904: 0x8EC2,
	32666 - 11904: 0xB2DC,
	32667 - 11904: 0xD6F5,
	32668 - 11904: 0xD6F3,
	32669 - 11904: 0xD6F4,
	32670 - 11904: 0xB2DB,
	32672 - 11904: 0xDB42,
	32673 - 11904: 0xDB43,
	32674 - 11904: 0xDB41,
	32675 - 11904: 0x8EC4,
	32676 - 11904: 0xB873,
	32677 - 11904: 0xDF6D,
	32678 - 11904: 0xDF6C,
	32679 - 11904: 0xDF6E,
	32680 - 11904: 0xB872,
	32681 - 11904: 0xB871,
	32684 - 11904: 0xE6F2,
	32685 - 11904: 0xE6F4,
	32686 - 11904: 0x9964,
	32687 - 11904: 0xBD7E,
	32688 - 11904: 0xE6F3,
	32689 - 11904: 0xEAE3,
	32690 - 11904: 0xBFAA,
	32691 - 11904: 0xF079,
	32692 - 11904: 0x9965,
	32693 - 11904: 0xF078,
	32694 - 11904: 0xC3BB,
	32695 - 11904: 0xF2BD,
	32696 - 11904: 0xC3BD,
	32697 - 11904: 0xC3BC,
	32698 - 11904: 0xF4B0,
	32699 - 11904: 0xF5EE,
	32700 - 11904: 0xC4F3,
	32701 - 11904: 0xA6D0,
	32702 - 11904: 0xD050,
	32703 - 11904: 0xACFD,
	32704 - 11904: 0xD365,
	32705 - 11904: 0xAFCE,
	32706 - 11904: 0xD364,
	32707 - 11904: 0xD363,
	32709 - 11904: 0xAFCD,
	32711 - 11904: 0xD6FB,
	32713 - 11904: 0xD6FD,
	32714 - 11904: 0xD6F6,
	32715 - 11904: 0xD6F7,
	32716 - 11904: 0xB2DD,
	32717 - 11904: 0xD6F8,
	32718 - 11904: 0xB2DE,
	32719 - 11904: 0xD6FC,
	32720 - 11904: 0xD6F9,
	32721 - 11904: 0xD6FA,
	32722 - 11904: 0xB2DF,
	32724 - 11904: 0xB5BE,
	32725 - 11904: 0xB5BF,
	32727 - 11904: 0xDB44,
	32731 - 11904: 0xDF6F,
	32732 - 11904: 0xDF70,
	32733 - 11904: 0x954E,
	32734 - 11904: 0xE37E,
	32735 - 11904: 0xBB43,
	32736 - 11904: 0xBB41,
	32737 - 11904: 0xBB42,
	32738 - 11904: 0xE37B,
	32739 - 11904: 0xE37C,
	32741 - 11904: 0xE37D,
	32742 - 11904: 0xE6F9,
	32743 - 11904: 0x98B3,
	32744 - 11904: 0xE6FA,
	32745 - 11904: 0xBDA1,
	32746 - 11904: 0xE6F7,
	32747 - 11904: 0xE6F6,
	32748 - 11904: 0xE6F8,
	32749 - 11904: 0xE6F5,
	32750 - 11904: 0xBFAD,
	32751 - 11904: 0xEAE4,
	32752 - 11904: 0xBFAB,
	32753 - 11904: 0xBFAC,
	32754 - 11904: 0xEDE6,
	32755 - 11904: 0xC16B,
	32756 - 11904: 0xEDE5,
	32757 - 11904: 0xEFA8,
	32759 - 11904: 0xF07A,
	32760 - 11904: 0xF07B,
	32761 - 11904: 0xC2BC,
	32762 - 11904: 0x8ECB,
	32763 - 11904: 0xC2BD,
	32764 - 11904: 0xC16C,
	32765 - 11904: 0xF2BE,
	32766 - 11904: 0xF2BF,
	32767 - 11904: 0xF4B1,
	32768 - 11904: 0xC4A3,
	32769 - 11904: 0xA6D1,
	32770 - 11904: 0x8BDF,
	32771 - 11904: 0xA6D2,
	32772 - 11904: 0xACFE,
	32773 - 11904: 0xAACC,
	32774 - 11904: 0xAFCF,
	32775 - 11904: 0xD051,
	32776 - 11904: 0x8ECE,
	32779 - 11904: 0xB5C0,
	32780 - 11904: 0xA6D3,
	32781 - 11904: 0xAD41,
	32782 - 11904: 0xD052,
	32783 - 11904: 0xD053,
	32784 - 11904: 0xAD40,
	32785 - 11904: 0xAD42,
	32786 - 11904: 0xA6D4,
	32788 - 11904: 0xD054,
	32789 - 11904: 0xAFD1,
	32790 - 11904: 0xD366,
	32791 - 11904: 0xAFD3,
	32792 - 11904: 0xAFD0,
	32793 - 11904: 0xAFD2,
	32795 - 11904: 0xD741,
	32796 - 11904: 0xB2E0,
	32797 - 11904: 0x8ECF,
	32798 - 11904: 0xD740,
	32799 - 11904: 0xD6FE,
	32800 - 11904: 0x9968,
	32801 - 11904: 0xDF71,
	32804 - 11904: 0xE3A1,
	32805 - 11904: 0x9969,
	32806 - 11904: 0xBDA2,
	32808 - 11904: 0xBFAE,
	32809 - 11904: 0xEAE6,
	32810 - 11904: 0xEAE5,
	32812 - 11904: 0xEDE7,
	32814 - 11904: 0x996B,
	32815 - 11904: 0x8ED1,
	32816 - 11904: 0xF5EF,
	32817 - 11904: 0x996C,
	32819 - 11904: 0xA6D5,
	32820 - 11904: 0xCB73,
	32821 - 11904: 0xCDAA,
	32822 - 11904: 0xAD43,
	32823 - 11904: 0xD055,
	32825 - 11904: 0xD368,
	32827 - 11904: 0x8ED4,
	32828 - 11904: 0x8ED5,
	32829 - 11904: 0xAFD4,
	32830 - 11904: 0xD367,
	32831 - 11904: 0xAFD5,
	32835 - 11904: 0xD743,
	32838 - 11904: 0xB2E2,
	32839 - 11904: 0xD742,
	32840 - 11904: 0xD744,
	32842 - 11904: 0xB2E1,
	32847 - 11904: 0xDB46,
	32848 - 11904: 0xDB47,
	32849 - 11904: 0xDB45,
	32850 - 11904: 0xB5C1,
	32852 - 11904: 0x996D,
	32854 - 11904: 0xB874,
	32856 - 11904: 0xB875,
	32858 - 11904: 0xBB45,
	32859 - 11904: 0xA0BE,
	32860 - 11904: 0xE3A3,
	32861 - 11904: 0xE3A2,
	32862 - 11904: 0xBB44,
	32865 - 11904: 0x8ED6,
	32866 - 11904: 0xA0BC,
	32867 - 11904: 0xA0B5,
	32868 - 11904: 0xE6FB,
	32870 - 11904: 0xA0B4,
	32871 - 11904: 0xE6FC,
	32876 - 11904: 0xEAE7,
	32879 - 11904: 0xC170,
	32880 - 11904: 0xC16F,
	32881 - 11904: 0xC16D,
	32882 - 11904: 0xC16E,
	32883 - 11904: 0xC171,
	32885 - 11904: 0xF07C,
	32886 - 11904: 0xC2BF,
	32887 - 11904: 0xC2BE,
	32888 - 11904: 0xF2C0,
	32889 - 11904: 0xF4B2,
	32893 - 11904: 0xC5A5,
	32894 - 11904: 0xC5A4,
	32895 - 11904: 0xA6D6,
	32896 - 11904: 0x8BE0,
	32898 - 11904: 0xD1FB,
	32900 - 11904: 0xB877,
	32901 - 11904: 0xB5C2,
	32902 - 11904: 0xB876,
	32903 - 11904: 0xBB46,
	32905 - 11904: 0xA6D7,
	32906 - 11904: 0xC9A9,
	32907 - 11904: 0xA6D8,
	32908 - 11904: 0xA6D9,
	32911 - 11904: 0xCDAB,
	32912 - 11904: 0xCB76,
	32914 - 11904: 0xCB77,
	32915 - 11904: 0xA877,
	32917 - 11904: 0xCB74,
	32918 - 11904: 0xA876,
	32920 - 11904: 0xA879,
	32921 - 11904: 0xCB75,
	32922 - 11904: 0xA87B,
	32923 - 11904: 0xA87A,
	32924 - 11904: 0xCB78,
	32925 - 11904: 0xA878,
	32927 - 11904: 0x89B5,
	32929 - 11904: 0xAAD1,
	32930 - 11904: 0xAACF,
	32931 - 11904: 0xCDAD,
	32933 - 11904: 0xAACE,
	32935 - 11904: 0x8EDD,
	32937 - 11904: 0xAAD3,
	32938 - 11904: 0xAAD5,
	32939 - 11904: 0xAAD2,
	32941 - 11904: 0xCDB0,
	32942 - 11904: 0xCDAC,
	32943 - 11904: 0xAAD6,
	32945 - 11904: 0xAAD0,
	32946 - 11904: 0xA87C,
	32948 - 11904: 0xAAD4,
	32949 - 11904: 0xCDAF,
	32950 - 11904: 0x9E5D,
	32951 - 11904: 0x9971,
	32952 - 11904: 0xCDAE,
	32954 - 11904: 0xAACD,
	32956 - 11904: 0x89AE,
	32957 - 11904: 0x9DE8,
	32962 - 11904: 0xD05B,
	32963 - 11904: 0xAD47,
	32964 - 11904: 0xAD48,
	32965 - 11904: 0xD05D,
	32966 - 11904: 0x9565,
	32967 - 11904: 0xD057,
	32968 - 11904: 0xD05A,
	32969 - 11904: 0xD063,
	32970 - 11904: 0xD061,
	32972 - 11904: 0xAD49,
	32973 - 11904: 0xD067,
	32974 - 11904: 0xAD4C,
	32975 - 11904: 0xD064,
	32976 - 11904: 0xD05C,
	32977 - 11904: 0xD059,
	32980 - 11904: 0xDB49,
	32981 - 11904: 0xD062,
	32982 - 11904: 0xAD44,
	32983 - 11904: 0xD065,
	32984 - 11904: 0xD056,
	32985 - 11904: 0xD05F,
	32986 - 11904: 0xAD46,
	32987 - 11904: 0xAD4B,
	32988 - 11904: 0xD060,
	32989 - 11904: 0xAD4F,
	32990 - 11904: 0xAD4D,
	32992 - 11904: 0xD058,
	32993 - 11904: 0xAD4A,
	32995 - 11904: 0xD05E,
	32996 - 11904: 0xAD4E,
	32997 - 11904: 0xAD45,
	32998 - 11904: 0xD066,
	33001 - 11904: 0x9972,
	33004 - 11904: 0x8B5C,
	33005 - 11904: 0xAFDA,
	33007 - 11904: 0xAFE3,
	33008 - 11904: 0xAFD8,
	33009 - 11904: 0xAFD6,
	33010 - 11904: 0xD36A,
	33011 - 11904: 0xAFDE,
	33012 - 11904: 0xAFDB,
	33013 - 11904: 0xD36C,
	33014 - 11904: 0x89B1,
	33016 - 11904: 0xAFDD,
	33017 - 11904: 0xD36B,
	33018 - 11904: 0xD369,
	33019 - 11904: 0xD36E,
	33020 - 11904: 0xAFE2,
	33021 - 11904: 0xAFE0,
	33022 - 11904: 0xDB48,
	33024 - 11904: 0xD36F,
	33025 - 11904: 0xD36D,
	33026 - 11904: 0xAFD7,
	33027 - 11904: 0xA0C0,
	33029 - 11904: 0xAFD9,
	33030 - 11904: 0xAFDC,
	33031 - 11904: 0x8EDF,
	33032 - 11904: 0xAFDF,
	33033 - 11904: 0x9566,
	33034 - 11904: 0xAFE1,
	33036 - 11904: 0x9974,
	33038 - 11904: 0x9976,
	33042 - 11904: 0x9977,
	33044 - 11904: 0x9979,
	33045 - 11904: 0xD74E,
	33046 - 11904: 0xB2E4,
	33047 - 11904: 0x9DDA,
	33048 - 11904: 0xD745,
	33049 - 11904: 0xD747,
	33050 - 11904: 0x8EE0,
	33051 - 11904: 0xD748,
	33053 - 11904: 0xD750,
	33054 - 11904: 0xD74C,
	33055 - 11904: 0xD74A,
	33057 - 11904: 0xD74D,
	33058 - 11904: 0xD751,
	33059 - 11904: 0xB2E5,
	33060 - 11904: 0xB2E9,
	33061 - 11904: 0xD746,
	33063 - 11904: 0xD74F,
	33065 - 11904: 0xB2E7,
	33066 - 11904: 0x935C,
	33067 - 11904: 0xB2E6,
	33068 - 11904: 0xD74B,
	33069 - 11904: 0xD749,
	33071 - 11904: 0xB2E3,
	33072 - 11904: 0xB2E8,
	33074 - 11904: 0x9DE6,
	33076 - 11904: 0x8B5F,
	33079 - 11904: 0x9563,
	33081 - 11904: 0xB5C8,
	33082 - 11904: 0xDB51,
	33085 - 11904: 0xDB4F,
	33086 - 11904: 0xB5CA,
	33090 - 11904: 0x9567,
	33091 - 11904: 0xDB4A,
	33092 - 11904: 0xDFA1,
	33094 - 11904: 0xB5C9,
	33095 - 11904: 0xDB4E,
	33096 - 11904: 0x9DE3,
	33098 - 11904: 0xDB4B,
	33099 - 11904: 0xB5C5,
	33100 - 11904: 0xB5CB,
	33101 - 11904: 0xDB50,
	33102 - 11904: 0xB5C7,
	33103 - 11904: 0xDB4D,
	33104 - 11904: 0xBB47,
	33105 - 11904: 0xB5C6,
	33106 - 11904: 0xDB4C,
	33107 - 11904: 0xB5CC,
	33108 - 11904: 0xB5C4,
	33109 - 11904: 0xB5C3,
	33110 - 11904: 0x997C,
	33113 - 11904: 0x997D,
	33114 - 11904: 0x997E,
	33115 - 11904: 0xDF77,
	33116 - 11904: 0xDF75,
	33118 - 11904: 0xDF7B,
	33120 - 11904: 0xDF73,
	33121 - 11904: 0xDFA2,
	33122 - 11904: 0xDF78,
	33124 - 11904: 0xDF72,
	33125 - 11904: 0xB87B,
	33126 - 11904: 0xB8A3,
	33127 - 11904: 0xDF7D,
	33129 - 11904: 0xDF76,
	33131 - 11904: 0xB87E,
	33132 - 11904: 0x8CFB,
	33133 - 11904: 0x8B5B,
	33134 - 11904: 0xB87C,
	33135 - 11904: 0xDF7E,
	33136 - 11904: 0xB879,
	33137 - 11904: 0xB878,
	33138 - 11904: 0xDF79,
	33139 - 11904: 0xB87D,
	33140 - 11904: 0xB5CD,
	33142 - 11904: 0xDF7C,
	33143 - 11904: 0xDF74,
	33144 - 11904: 0xB87A,
	33145 - 11904: 0xB8A1,
	33146 - 11904: 0xB8A2,
	33148 - 11904: 0x99A3,
	33151 - 11904: 0xBB4C,
	33152 - 11904: 0xBB48,
	33154 - 11904: 0xBB4D,
	33155 - 11904: 0xE3A6,
	33156 - 11904: 0x99A4,
	33158 - 11904: 0xE3A5,
	33159 - 11904: 0xE3A7,
	33160 - 11904: 0xBB4A,
	33161 - 11904: 0xE3A4,
	33162 - 11904: 0xBB4B,
	33163 - 11904: 0xE3AA,
	33164 - 11904: 0xE3A9,
	33165 - 11904: 0xE3A8,
	33167 - 11904: 0xBB49,
	33171 - 11904: 0x99A6,
	33173 - 11904: 0xE741,
	33175 - 11904: 0xE744,
	33176 - 11904: 0xBDA8,
	33177 - 11904: 0xE743,
	33178 - 11904: 0xBDA7,
	33179 - 11904: 0xBDA3,
	33180 - 11904: 0xBDA4,
	33181 - 11904: 0xBDA5,
	33182 - 11904: 0xE740,
	33183 - 11904: 0xE6FE,
	33184 - 11904: 0xBDA6,
	33186 - 11904: 0xE742,
	33187 - 11904: 0xE6FD,
	33189 - 11904: 0x99A8,
	33190 - 11904: 0xEAE9,
	33191 - 11904: 0xEAF3,
	33192 - 11904: 0xBFB1,
	33193 - 11904: 0xBFB0,
	33194 - 11904: 0x8ABE,
	33195 - 11904: 0xEAED,
	33196 - 11904: 0xEAEF,
	33198 - 11904: 0xEAEA,
	33200 - 11904: 0xEAEE,
	33201 - 11904: 0xEAE8,
	33202 - 11904: 0xEAF1,
	33203 - 11904: 0xBFAF,
	33204 - 11904: 0xEAF0,
	33205 - 11904: 0xEAEC,
	33206 - 11904: 0x9E61,
	33207 - 11904: 0xEAF2,
	33209 - 11904: 0xEAEB,
	33210 - 11904: 0xC174,
	33211 - 11904: 0xEDE8,
	33212 - 11904: 0xEDEE,
	33213 - 11904: 0xC178,
	33214 - 11904: 0xC17A,
	33215 - 11904: 0xC177,
	33216 - 11904: 0xC176,
	33217 - 11904: 0x99AA,
	33218 - 11904: 0xC175,
	33219 - 11904: 0xC173,
	33220 - 11904: 0xEDE9,
	33221 - 11904: 0xEDEC,
	33222 - 11904: 0xC172,
	33223 - 11904: 0xEDED,
	33224 - 11904: 0xA0C8,
	33225 - 11904: 0xC179,
	33226 - 11904: 0xEDEB,
	33228 - 11904: 0xEDEA,
	33229 - 11904: 0xC2C0,
	33231 - 11904: 0xC2C1,
	33232 - 11904: 0xF0A1,
	33233 - 11904: 0xF07D,
	33234 - 11904: 0xF07E,
	33237 - 11904: 0xF2C2,
	33239 - 11904: 0xF2C1,
	33240 - 11904: 0xC3BE,
	33241 - 11904: 0xF4B4,
	33242 - 11904: 0xC4A4,
	33243 - 11904: 0xF4B3,
	33245 - 11904: 0xF5F0,
	33246 - 11904: 0xF745,
	33247 - 11904: 0xC5A6,
	33248 - 11904: 0xF943,
	33249 - 11904: 0xF944,
	33250 - 11904: 0xC5D8,
	33251 - 11904: 0xA6DA,
	33252 - 11904: 0x99AB,
	33253 - 11904: 0xAAD7,
	33254 - 11904: 0xDB52,
	33255 - 11904: 0xBB4E,
	33256 - 11904: 0xC17B,
	33257 - 11904: 0xEDEF,
	33258 - 11904: 0xA6DB,
	33260 - 11904: 0xAFE5,
	33261 - 11904: 0xAFE4,
	33262 - 11904: 0xDB53,
	33263 - 11904: 0xFEC4,
	33266 - 11904: 0xEAF4,
	33267 - 11904: 0xA6DC,
	33268 - 11904: 0xAD50,
	33270 - 11904: 0x98C2,
	33271 - 11904: 0xDB54,
	33272 - 11904: 0xDB55,
	33273 - 11904: 0xDB56,
	33274 - 11904: 0xBB4F,
	33275 - 11904: 0xBFB2,
	33276 - 11904: 0xA6DD,
	33278 - 11904: 0xAAD8,
	33279 - 11904: 0xD068,
	33280 - 11904: 0xAFE6,
	33281 - 11904: 0xD370,
	33282 - 11904: 0xB2EA,
	33284 - 11904: 0xDB57,
	33285 - 11904: 0xB8A4,
	33287 - 11904: 0xBB50,
	33288 - 11904: 0xBFB3,
	33289 - 11904: 0xC17C,
	33290 - 11904: 0xC2C2,
	33291 - 11904: 0xF4B5,
	33292 - 11904: 0xA6DE,
	33293 - 11904: 0xAAD9,
	33296 - 11904: 0xAFE7,
	33297 - 11904: 0xD752,
	33298 - 11904: 0xB5CE,
	33300 - 11904: 0xBB51,
	33301 - 11904: 0xE3AB,
	33302 - 11904: 0xE745,
	33304 - 11904: 0x8EE8,
	33306 - 11904: 0xA0BA,
	33307 - 11904: 0xA6DF,
	33308 - 11904: 0xB5CF,
	33309 - 11904: 0xDFA3,
	33310 - 11904: 0xBB52,
	33311 - 11904: 0xA6E0,
	33312 - 11904: 0xCDB1,
	33313 - 11904: 0xD069,
	33314 - 11904: 0xAD51,
	33317 - 11904: 0xD372,
	33318 - 11904: 0xFD77,
	33320 - 11904: 0xAFEA,
	33321 - 11904: 0x8EEE,
	33322 - 11904: 0xAFE8,
	33323 - 11904: 0xAFE9,
	33324 - 11904: 0xAFEB,
	33325 - 11904: 0x9EBF,
	33327 - 11904: 0xD371,
	33330 - 11904: 0xD757,
	33331 - 11904: 0xD754,
	33332 - 11904: 0xD756,
	33333 - 11904: 0xB2EB,
	33334 - 11904: 0xB2ED,
	33335 - 11904: 0xB2EC,
	33336 - 11904: 0xD753,
	33337 - 11904: 0xB2EE,
	33338 - 11904: 0xD755,
	33340 - 11904: 0xDB58,
	33341 - 11904: 0xDB59,
	33342 - 11904: 0x89C2,
	33343 - 11904: 0xDB5A,
	33344 - 11904: 0xDFA6,
	33346 - 11904: 0xDFA7,
	33348 - 11904: 0xDFA5,
	33349 - 11904: 0xDFA8,
	33351 - 11904: 0xB8A5,
	33353 - 11904: 0xDFA4,
	33355 - 11904: 0xBB53,
	33358 - 11904: 0xE74A,
	33359 - 11904: 0xE746,
	33360 - 11904: 0xE749,
	33361 - 11904: 0xE74B,
	33362 - 11904: 0xE748,
	33363 - 11904: 0xE747,
	33364 - 11904: 0x99AC,
	33365 - 11904: 0xEAF5,
	33366 - 11904: 0xEAF6,
	33367 - 11904: 0xEAF7,
	33368 - 11904: 0xBFB4,
	33369 - 11904: 0xBFB5,
	33370 - 11904: 0xEDF1,
	33371 - 11904: 0xEDF0,
	33372 - 11904: 0xEDF2,
	33374 - 11904: 0xF0A3,
	33375 - 11904: 0xF0A2,
	33377 - 11904: 0xF2C4,
	33378 - 11904: 0x956B,
	33379 - 11904: 0xF2C5,
	33380 - 11904: 0xF2C3,
	33381 - 11904: 0x956C,
	33382 - 11904: 0xC4A5,
	33384 - 11904: 0xF4B6,
	33385 - 11904: 0xF4B7,
	33387 - 11904: 0xF746,
	33388 - 11904: 0xF7EF,
	33389 - 11904: 0xF8BB,
	33390 - 11904: 0xA6E1,
	33391 - 11904: 0xA87D,
	33393 - 11904: 0xC17D,
	33394 - 11904: 0xA6E2,
	33396 - 11904: 0xD758,
	33397 - 11904: 0xDB5B,
	33398 - 11904: 0x99AF,
	33399 - 11904: 0xC641,
	33400 - 11904: 0xCA4A,
	33401 - 11904: 0x994A,
	33402 - 11904: 0x8976,
	33403 - 11904: 0x8F48,
	33404 - 11904: 0xCA4B,
	33405 - 11904: 0xCA4D,
	33406 - 11904: 0xA6E3,
	33407 - 11904: 0xCA4E,
	33408 - 11904: 0xCA4C,
	33411 - 11904: 0xCBA2,
	33412 - 11904: 0xCBA3,
	33413 - 11904: 0xCB7B,
	33415 - 11904: 0xFBEE,
	33418 - 11904: 0xCBA1,
	33419 - 11904: 0xA8A1,
	33421 - 11904: 0xA8A2,
	33422 - 11904: 0xCB7C,
	33423 - 11904: 0xCB7A,
	33424 - 11904: 0xCB79,
	33425 - 11904: 0xCB7D,
	33426 - 11904: 0xA87E,
	33427 - 11904: 0xCB7E,
	33428 - 11904: 0xD06A,
	33432 - 11904: 0xCDB6,
	33433 - 11904: 0xAADC,
	33434 - 11904: 0xCDB5,
	33435 - 11904: 0xCDB7,
	33437 - 11904: 0xAADB,
	33438 - 11904: 0xCDBC,
	33439 - 11904: 0xAADF,
	33440 - 11904: 0xCDB2,
	33441 - 11904: 0xCDC0,
	33442 - 11904: 0xCDC6,
	33443 - 11904: 0xAAE6,
	33444 - 11904: 0xCDC3,
	33445 - 11904: 0xAAE3,
	33446 - 11904: 0x99AE,
	33447 - 11904: 0xCDB9,
	33448 - 11904: 0xCDBF,
	33449 - 11904: 0xCDC1,
	33450 - 11904: 0x8EFB,
	33451 - 11904: 0xCDB4,
	33452 - 11904: 0xAAE2,
	33453 - 11904: 0xAADD,
	33454 - 11904: 0xCDBA,
	33455 - 11904: 0xAAE4,
	33456 - 11904: 0xAAE7,
	33457 - 11904: 0xAAE1,
	33459 - 11904: 0xAADA,
	33460 - 11904: 0xCDBE,
	33461 - 11904: 0xCDB8,
	33462 - 11904: 0xCDC5,
	33463 - 11904: 0xAAE9,
	33464 - 11904: 0xAAE5,
	33465 - 11904: 0xAAE0,
	33466 - 11904: 0xCDBD,
	33467 - 11904: 0xAFEC,
	33468 - 11904: 0xCDBB,
	33469 - 11904: 0xAADE,
	33470 - 11904: 0xAAE8,
	33471 - 11904: 0x8CD0,
	33472 - 11904: 0xCDB3,
	33474 - 11904: 0xCDC2,
	33475 - 11904: 0xCDC4,
	33476 - 11904: 0x8B52,
	33482 - 11904: 0x99B0,
	33487 - 11904: 0x8977,
	33488 - 11904: 0x8F41,
	33489 - 11904: 0xAD62,
	33490 - 11904: 0xAD5C,
	33491 - 11904: 0xAD64,
	33492 - 11904: 0xAD61,
	33493 - 11904: 0xD071,
	33494 - 11904: 0xD074,
	33495 - 11904: 0xAD5D,
	33496 - 11904: 0x99B1,
	33497 - 11904: 0xD06B,
	33499 - 11904: 0xAD56,
	33500 - 11904: 0xAD60,
	33502 - 11904: 0xAD63,
	33503 - 11904: 0xAD65,
	33504 - 11904: 0xD0A2,
	33505 - 11904: 0xD077,
	33506 - 11904: 0x8F49,
	33507 - 11904: 0xAD55,
	33508 - 11904: 0xD0A1,
	33509 - 11904: 0xAD59,
	33510 - 11904: 0xAD57,
	33511 - 11904: 0xAD52,
	33512 - 11904: 0xD06F,
	33514 - 11904: 0xD07E,
	33515 - 11904: 0xD073,
	33516 - 11904: 0xD076,
	33517 - 11904: 0xD0A5,
	33518 - 11904: 0xFA4D,
	33519 - 11904: 0xAD66,
	33520 - 11904: 0xD07D,
	33521 - 11904: 0xAD5E,
	33522 - 11904: 0xD078,
	33523 - 11904: 0xD0A4,
	33524 - 11904: 0xD075,
	33525 - 11904: 0xD079,
	33526 - 11904: 0xD07C,
	33527 - 11904: 0x9DE4,
	33528 - 11904: 0x8CB5,
	33529 - 11904: 0xD06D,
	33530 - 11904: 0xD0A3,
	33531 - 11904: 0xD07B,
	33532 - 11904: 0xFBE9,
	33533 - 11904: 0x9B54,
	33534 - 11904: 0xD06C,
	33535 - 11904: 0x99B2,
	33536 - 11904: 0xD070,
	33537 - 11904: 0xAD5F,
	33538 - 11904: 0xAD5A,
	33539 - 11904: 0xAD53,
	33540 - 11904: 0xAD58,
	33541 - 11904: 0xAD54,
	33542 - 11904: 0xAD67,
	33543 - 11904: 0xD06E,
	33544 - 11904: 0xD3A5,
	33545 - 11904: 0xAD5B,
	33547 - 11904: 0x9E68,
	33548 - 11904: 0xD07A,
	33549 - 11904: 0xCE41,
	33558 - 11904: 0xD3A8,
	33559 - 11904: 0xAFFA,
	33560 - 11904: 0x8F4A,
	33561 - 11904: 0xD376,
	33562 - 11904: 0x8F42,
	33563 - 11904: 0xD3A3,
	33564 - 11904: 0xD37D,
	33565 - 11904: 0x8F51,
	33566 - 11904: 0xD3B2,
	33568 - 11904: 0xD3AA,
	33570 - 11904: 0xD37E,
	33572 - 11904: 0xD3A9,
	33573 - 11904: 0xD378,
	33574 - 11904: 0xD37C,
	33575 - 11904: 0xD3B5,
	33576 - 11904: 0xAFFD,
	33577 - 11904: 0xD3AD,
	33578 - 11904: 0xD3A4,
	33579 - 11904: 0xAFED,
	33580 - 11904: 0xD3B3,
	33581 - 11904: 0xD374,
	33583 - 11904: 0xD3AC,
	33585 - 11904: 0xAFFC,
	33586 - 11904: 0xAFF7,
	33587 - 11904: 0xD373,
	33588 - 11904: 0xAFF5,
	33589 - 11904: 0xAFF4,
	33590 - 11904: 0xAFF9,
	33591 - 11904: 0xD3AB,
	33592 - 11904: 0xAFF1,
	33593 - 11904: 0xAFF8,
	33594 - 11904: 0xD072,
	33595 - 11904: 0xDB5C,
	33596 - 11904: 0xD3A6,
	33597 - 11904: 0x9846,
	33599 - 11904: 0xD37A,
	33600 - 11904: 0xAFFB,
	33601 - 11904: 0xD37B,
	33602 - 11904: 0xD3A1,
	33603 - 11904: 0xAFFE,
	33604 - 11904: 0xD375,
	33605 - 11904: 0xD3AF,
	33607 - 11904: 0xD3AE,
	33608 - 11904: 0xD3B6,
	33609 - 11904: 0xAFF3,
	33610 - 11904: 0xAFF0,
	33611 - 11904: 0xD3B4,
	33612 - 11904: 0xD3B0,
	33613 - 11904: 0xD3A7,
	33614 - 11904: 0xD3A2,
	33615 - 11904: 0xAFF6,
	33616 - 11904: 0xAFF2,
	33617 - 11904: 0xD377,
	33618 - 11904: 0xAFEE,
	33619 - 11904: 0xD3B1,
	33620 - 11904: 0xAFEF,
	33622 - 11904: 0xD379,
	33623 - 11904: 0x99B4,
	33634 - 11904: 0x8EF5,
	33635 - 11904: 0xFD55,
	33638 - 11904: 0x9CCD,
	33647 - 11904: 0x8978,
	33651 - 11904: 0xD75E,
	33652 - 11904: 0xD760,
	33653 - 11904: 0xD765,
	33654 - 11904: 0xD779,
	33655 - 11904: 0xB2FC,
	33656 - 11904: 0xB2F2,
	33658 - 11904: 0xD75D,
	33659 - 11904: 0xB2FD,
	33660 - 11904: 0xB2FE,
	33661 - 11904: 0xD768,
	33662 - 11904: 0xD76F,
	33663 - 11904: 0xD775,
	33665 - 11904: 0xD762,
	33667 - 11904: 0xD769,
	33669 - 11904: 0x8F53,
	33670 - 11904: 0xB340,
	33671 - 11904: 0xD777,
	33672 - 11904: 0xD772,
	33673 - 11904: 0xB2FA,
	33674 - 11904: 0xB2F8,
	33675 - 11904: 0xD76E,
	33676 - 11904: 0xD76A,
	33677 - 11904: 0xD75C,
	33678 - 11904: 0xB2EF,
	33679 - 11904: 0xD761,
	33680 - 11904: 0xD759,
	33681 - 11904: 0x8F6F,
	33682 - 11904: 0xB2F7,
	33683 - 11904: 0xB2F9,
	33684 - 11904: 0xD766,
	33685 - 11904: 0xD763,
	33686 - 11904: 0xB2F4,
	33687 - 11904: 0xD773,
	33688 - 11904: 0xB2F1,
	33689 - 11904: 0xD764,
	33690 - 11904: 0xD77A,
	33691 - 11904: 0xD76C,
	33692 - 11904: 0x8E63,
	33693 - 11904: 0xD76B,
	33694 - 11904: 0xB2F0,
	33696 - 11904: 0xB2FB,
	33698 - 11904: 0xB2F3,
	33699 - 11904: 0xD75A,
	33700 - 11904: 0xD75F,
	33701 - 11904: 0xD770,
	33702 - 11904: 0xD776,
	33703 - 11904: 0xB341,
	33704 - 11904: 0xD75B,
	33705 - 11904: 0xD767,
	33706 - 11904: 0xD76D,
	33707 - 11904: 0xB2F6,
	33708 - 11904: 0x8F56,
	33710 - 11904: 0xD778,
	33711 - 11904: 0xD771,
	33712 - 11904: 0xD774,
	33721 - 11904: 0xFE76,
	33725 - 11904: 0xB2F5,
	33726 - 11904: 0x9FC6,
	33727 - 11904: 0xDB6C,
	33728 - 11904: 0xDB60,
	33729 - 11904: 0xB5D7,
	33730 - 11904: 0xDB7D,
	33731 - 11904: 0xDBA7,
	33732 - 11904: 0xDBAA,
	33733 - 11904: 0xB5D5,
	33734 - 11904: 0xDB68,
	33735 - 11904: 0xDBA3,
	33736 - 11904: 0xDB69,
	33737 - 11904: 0xDB77,
	33738 - 11904: 0xB5E2,
	33739 - 11904: 0xDB73,
	33740 - 11904: 0xB5DF,
	33741 - 11904: 0xFAAC,
	33742 - 11904: 0xDB74,
	33743 - 11904: 0xDB5D,
	33745 - 11904: 0xDBA4,
	33747 - 11904: 0x8F58,
	33748 - 11904: 0xB5E8,
	33749 - 11904: 0xDBA1,
	33750 - 11904: 0xDB75,
	33751 - 11904: 0xDBAC,
	33752 - 11904: 0xDB70,
	33753 - 11904: 0xDFC8,
	33755 - 11904: 0xDBAF,
	33756 - 11904: 0xB5E6,
	33757 - 11904: 0xDB6E,
	33758 - 11904: 0xDB7A,
	33759 - 11904: 0xB5E9,
	33760 - 11904: 0xB5D4,
	33761 - 11904: 0xDB72,
	33762 - 11904: 0xDBAD,
	33763 - 11904: 0xDB6B,
	33764 - 11904: 0xDB64,
	33765 - 11904: 0xDB6F,
	33767 - 11904: 0xDB63,
	33768 - 11904: 0xDB61,
	33769 - 11904: 0xB5D0,
	33770 - 11904: 0xDBA5,
	33771 - 11904: 0xDB6A,
	33772 - 11904: 0xDBA8,
	33773 - 11904: 0x9848,
	33774 - 11904: 0xDBA9,
	33775 - 11904: 0xB5D8,
	33776 - 11904: 0xB5DD,
	33777 - 11904: 0xB5D9,
	33778 - 11904: 0xB5E1,
	33779 - 11904: 0xDB7E,
	33780 - 11904: 0xB5DA,
	33781 - 11904: 0xDB76,
	33782 - 11904: 0xDB66,
	33784 - 11904: 0xB5D2,
	33785 - 11904: 0xDB5E,
	33786 - 11904: 0xDBA2,
	33787 - 11904: 0xDBAB,
	33788 - 11904: 0xDB65,
	33789 - 11904: 0xB5E0,
	33790 - 11904: 0xDBB0,
	33791 - 11904: 0xDB71,
	33793 - 11904: 0xDB6D,
	33795 - 11904: 0xB5D1,
	33796 - 11904: 0xB5E5,
	33797 - 11904: 0x99B7,
	33798 - 11904: 0xDB7C,
	33799 - 11904: 0xB5E7,
	33801 - 11904: 0xDB78,
	33802 - 11904: 0xB5DC,
	33803 - 11904: 0xB5D6,
	33804 - 11904: 0xB5DE,
	33805 - 11904: 0xB5D3,
	33806 - 11904: 0xB5E4,
	33807 - 11904: 0xDB79,
	33808 - 11904: 0xDB67,
	33809 - 11904: 0xDB7B,
	33810 - 11904: 0xDB62,
	33811 - 11904: 0xDBA6,
	33812 - 11904: 0x9665,
	33814 - 11904: 0xFA6C,
	33816 - 11904: 0x9DE7,
	33819 - 11904: 0xDBAE,
	33820 - 11904: 0x9E62,
	33824 - 11904: 0x96CC,
	33825 - 11904: 0x8E67,
	33827 - 11904: 0xDB5F,
	33828 - 11904: 0xFC75,
	33830 - 11904: 0x987E,
	33833 - 11904: 0xDFC7,
	33835 - 11904: 0xDFDD,
	33836 - 11904: 0xB855,
	33837 - 11904: 0xDFCC,
	33838 - 11904: 0xFDB9,
	33839 - 11904: 0xDFCA,
	33840 - 11904: 0xDFB5,
	33841 - 11904: 0xB8A9,
	33842 - 11904: 0xDFC5,
	33843 - 11904: 0xDFD9,
	33844 - 11904: 0xDFC1,
	33845 - 11904: 0xB8B1,
	33846 - 11904: 0xDFD8,
	33847 - 11904: 0xDFBF,
	33848 - 11904: 0xB5E3,
	33849 - 11904: 0xDFCF,
	33850 - 11904: 0xDFC0,
	33851 - 11904: 0xDFD6,
	33852 - 11904: 0xB8B0,
	33853 - 11904: 0xB8A8,
	33854 - 11904: 0x97FC,
	33855 - 11904: 0xDFAA,
	33856 - 11904: 0xDFB2,
	33858 - 11904: 0xDFCB,
	33859 - 11904: 0xDFC3,
	33860 - 11904: 0xDFDC,
	33861 - 11904: 0xDFC6,
	33862 - 11904: 0xB8B6,
	33863 - 11904: 0xDFD7,
	33864 - 11904: 0x98F9,
	33865 - 11904: 0xB8AD,
	33866 - 11904: 0x8F66,
	33867 - 11904: 0xDFC9,
	33868 - 11904: 0xDFD1,
	33869 - 11904: 0xDFB6,
	33870 - 11904: 0xDFD0,
	33872 - 11904: 0xDFE1,
	33873 - 11904: 0xDFB1,
	33874 - 11904: 0xDFD2,
	33875 - 11904: 0x956E,
	33876 - 11904: 0xDFDF,
	33877 - 11904: 0x9245,
	33878 - 11904: 0xDFAB,
	33879 - 11904: 0xB5DB,
	33880 - 11904: 0x8F60,
	33881 - 11904: 0xDFB9,
	33882 - 11904: 0xDFB8,
	33883 - 11904: 0xB8AF,
	33884 - 11904: 0x9ED1,
	33885 - 11904: 0xDFBC,
	33886 - 11904: 0xDFBE,
	33887 - 11904: 0xDFCD,
	33888 - 11904: 0xDFDE,
	33889 - 11904: 0xB8B2,
	33890 - 11904: 0xFECD,
	33891 - 11904: 0xB8B3,
	33892 - 11904: 0x99B9,
	33893 - 11904: 0xDFB0,
	33894 - 11904: 0xB8AB,
	33895 - 11904: 0xDFB4,
	33896 - 11904: 0xDFDA,
	33897 - 11904: 0xB8B4,
	33899 - 11904: 0xB8AC,
	33900 - 11904: 0xB8AE,
	33901 - 11904: 0xB8B5,
	33902 - 11904: 0xDFE0,
	33903 - 11904: 0xDFD3,
	33904 - 11904: 0xDFCE,
	33905 - 11904: 0x8F62,
	33906 - 11904: 0x974C,
	33907 - 11904: 0xDFBB,
	33908 - 11904: 0xDFBA,
	33909 - 11904: 0xB8AA,
	33910 - 11904: 0xDFAC,
	33911 - 11904: 0xB8A7,
	33912 - 11904: 0xDFC4,
	33913 - 11904: 0xDFAD,
	33914 - 11904: 0xDFC2,
	33917 - 11904: 0xDFB7,
	33918 - 11904: 0xDFDB,
	33919 - 11904: 0x91C7,
	33920 - 11904: 0x955F,
	33922 - 11904: 0xB8A6,
	33924 - 11904: 0x87AB,
	33926 - 11904: 0xDFB3,
	33928 - 11904: 0x99BB,
	33933 - 11904: 0xDFAF,
	33934 - 11904: 0xDFD5,
	33935 - 11904: 0xDFAE,
	33936 - 11904: 0xBB60,
	33937 - 11904: 0xE3D3,
	33938 - 11904: 0x8E6D,
	33939 - 11904: 0x8F71,
	33940 - 11904: 0xE3C2,
	33942 - 11904: 0x94CB,
	33943 - 11904: 0xE3AC,
	33944 - 11904: 0xE3CA,
	33945 - 11904: 0xBB58,
	33946 - 11904: 0xE3BB,
	33947 - 11904: 0xE3C5,
	33948 - 11904: 0xBB5B,
	33949 - 11904: 0xE3BE,
	33950 - 11904: 0xBB59,
	33951 - 11904: 0xE3AF,
	33952 - 11904: 0xE3CD,
	33953 - 11904: 0xE3AE,
	33954 - 11904: 0xE3C1,
	33955 - 11904: 0x95B1,
	33956 - 11904: 0xE3AD,
	33959 - 11904: 0xE3BF,
	33960 - 11904: 0xE3C8,
	33961 - 11904: 0xE3C6,
	33962 - 11904: 0xE3BA,
	33963 - 11904: 0xE3B5,
	33964 - 11904: 0xE3B3,
	33965 - 11904: 0x9AF2,
	33966 - 11904: 0xE3B4,
	33967 - 11904: 0xE3C7,
	33968 - 11904: 0xE3D2,
	33969 - 11904: 0xE3BC,
	33970 - 11904: 0xBB5A,
	33972 - 11904: 0xE3B7,
	33974 - 11904: 0xE3CB,
	33976 - 11904: 0xBB5D,
	33977 - 11904: 0xE3B6,
	33978 - 11904: 0xE3B0,
	33979 - 11904: 0xE3C0,
	33980 - 11904: 0xBB61,
	33981 - 11904: 0x96C3,
	33982 - 11904: 0x99BD,
	33983 - 11904: 0xBB55,
	33984 - 11904: 0xBB5E,
	33985 - 11904: 0xE3B8,
	33986 - 11904: 0xE3B2,
	33988 - 11904: 0xBB57,
	33989 - 11904: 0xDFD4,
	33990 - 11904: 0xBB56,
	33991 - 11904: 0xE3C3,
	33993 - 11904: 0xBB54,
	33994 - 11904: 0xBB63,
	33995 - 11904: 0xBB5C,
	33996 - 11904: 0xE3C4,
	33997 - 11904: 0xE3B9,
	33998 - 11904: 0xE3B1,
	33999 - 11904: 0xE3CC,
	34000 - 11904: 0xE3BD,
	34001 - 11904: 0xBB62,
	34002 - 11904: 0xE3D0,
	34003 - 11904: 0xBB5F,
	34004 - 11904: 0xE3CF,
	34006 - 11904: 0xE3C9,
	34007 - 11904: 0xE3CE,
	34010 - 11904: 0xA0CF,
	34011 - 11904: 0xE3D1,
	34014 - 11904: 0x8F6D,
	34017 - 11904: 0x99BE,
	34018 - 11904: 0x8EF4,
	34020 - 11904: 0x8F72,
	34021 - 11904: 0x95E4,
	34023 - 11904: 0xE773,
	34024 - 11904: 0xE774,
	34025 - 11904: 0xE767,
	34026 - 11904: 0xE766,
	34027 - 11904: 0xE762,
	34028 - 11904: 0xBDB4,
	34030 - 11904: 0xBDAC,
	34031 - 11904: 0xE776,
	34032 - 11904: 0xE775,
	34033 - 11904: 0xDFA9,
	34034 - 11904: 0xE75F,
	34035 - 11904: 0xE763,
	34036 - 11904: 0xE75D,
	34038 - 11904: 0xE770,
	34039 - 11904: 0xE761,
	34040 - 11904: 0x99BF,
	34041 - 11904: 0xE777,
	34042 - 11904: 0xE75A,
	34043 - 11904: 0xE758,
	34044 - 11904: 0xE764,
	34045 - 11904: 0xE76E,
	34046 - 11904: 0xE769,
	34047 - 11904: 0xBDB6,
	34048 - 11904: 0xE74F,
	34050 - 11904: 0xE76D,
	34051 - 11904: 0x9244,
	34052 - 11904: 0x87D7,
	34053 - 11904: 0xFBA5,
	34054 - 11904: 0xBDB7,
	34055 - 11904: 0xDFBD,
	34056 - 11904: 0xE75B,
	34057 - 11904: 0xE752,
	34058 - 11904: 0xE755,
	34059 - 11904: 0xE77B,
	34060 - 11904: 0xE75C,
	34061 - 11904: 0xE753,
	34062 - 11904: 0xE751,
	34063 - 11904: 0xE74E,
	34064 - 11904: 0x99C0,
	34065 - 11904: 0xBDB0,
	34066 - 11904: 0xE765,
	34067 - 11904: 0xBDAF,
	34068 - 11904: 0xBDB3,
	34069 - 11904: 0xE760,
	34070 - 11904: 0xE768,
	34071 - 11904: 0xBDA9,
	34072 - 11904: 0xE778,
	34073 - 11904: 0xE77C,
	34074 - 11904: 0xBDAB,
	34076 - 11904: 0xE757,
	34077 - 11904: 0xE76B,
	34078 - 11904: 0xE76F,
	34079 - 11904: 0xE754,
	34080 - 11904: 0xE779,
	34081 - 11904: 0xBDB2,
	34083 - 11904: 0xBDB1,
	34084 - 11904: 0xE74C,
	34085 - 11904: 0xBDB5,
	34086 - 11904: 0xE772,
	34087 - 11904: 0xE756,
	34088 - 11904: 0xE76A,
	34089 - 11904: 0xE750,
	34090 - 11904: 0xE75E,
	34091 - 11904: 0xE759,
	34092 - 11904: 0xBDAD,
	34093 - 11904: 0xBDAE,
	34094 - 11904: 0xE76C,
	34095 - 11904: 0xE77D,
	34096 - 11904: 0xE77A,
	34097 - 11904: 0xE771,
	34099 - 11904: 0xFDB4,
	34100 - 11904: 0x8F77,
	34104 - 11904: 0x99C1,
	34107 - 11904: 0xE74D,
	34109 - 11904: 0xBDAA,
	34110 - 11904: 0xEB49,
	34112 - 11904: 0xEB40,
	34113 - 11904: 0xEB43,
	34114 - 11904: 0xFAB9,
	34115 - 11904: 0xBFBB,
	34116 - 11904: 0xEB45,
	34117 - 11904: 0xEAF9,
	34118 - 11904: 0xEB41,
	34119 - 11904: 0xEB47,
	34120 - 11904: 0xBFB8,
	34121 - 11904: 0xBFBC,
	34122 - 11904: 0xBFB6,
	34123 - 11904: 0x8F40,
	34124 - 11904: 0xFA44,
	34125 - 11904: 0xEAFB,
	34126 - 11904: 0xEB4C,
	34129 - 11904: 0xEB46,
	34130 - 11904: 0x99C2,
	34131 - 11904: 0xEAFC,
	34132 - 11904: 0xEB55,
	34133 - 11904: 0xEB4F,
	34134 - 11904: 0xEAF8,
	34135 - 11904: 0xEE46,
	34136 - 11904: 0xEAFE,
	34137 - 11904: 0xBFB7,
	34138 - 11904: 0x8F5C,
	34139 - 11904: 0xEB4A,
	34141 - 11904: 0xEB54,
	34142 - 11904: 0xBFBF,
	34143 - 11904: 0x8CBD,
	34144 - 11904: 0xEB51,
	34145 - 11904: 0xEAFD,
	34146 - 11904: 0xEB44,
	34147 - 11904: 0xEB48,
	34148 - 11904: 0xEB42,
	34149 - 11904: 0xEB56,
	34150 - 11904: 0xEB53,
	34151 - 11904: 0xEB50,
	34152 - 11904: 0xBFB9,
	34153 - 11904: 0xBFBA,
	34154 - 11904: 0xBFBE,
	34155 - 11904: 0xEAFA,
	34156 - 11904: 0xEB57,
	34157 - 11904: 0xBFBD,
	34158 - 11904: 0xEB4D,
	34159 - 11904: 0x99C4,
	34160 - 11904: 0x99C5,
	34161 - 11904: 0xEB4B,
	34163 - 11904: 0x8F7B,
	34165 - 11904: 0xEB4E,
	34166 - 11904: 0xEE53,
	34167 - 11904: 0xEE40,
	34168 - 11904: 0xEE45,
	34169 - 11904: 0xEE52,
	34170 - 11904: 0xEE44,
	34171 - 11904: 0xEDFB,
	34172 - 11904: 0xEE41,
	34174 - 11904: 0xC1A2,
	34176 - 11904: 0xEDF4,
	34177 - 11904: 0xEE4D,
	34178 - 11904: 0xEE4F,
	34179 - 11904: 0xEDF3,
	34180 - 11904: 0xC1A1,
	34181 - 11904: 0xEE51,
	34182 - 11904: 0xEE49,
	34183 - 11904: 0xC1A8,
	34184 - 11904: 0xEE50,
	34185 - 11904: 0xEE42,
	34186 - 11904: 0xC1AA,
	34187 - 11904: 0xEDF9,
	34188 - 11904: 0xEB52,
	34189 - 11904: 0xEE4A,
	34190 - 11904: 0xEE47,
	34191 - 11904: 0xEDF5,
	34192 - 11904: 0xEE55,
	34193 - 11904: 0xC1A4,
	34195 - 11904: 0x8776,
	34196 - 11904: 0xC1A5,
	34197 - 11904: 0xEDF7,
	34198 - 11904: 0xEE48,
	34199 - 11904: 0x8CB6,
	34200 - 11904: 0xEE54,
	34201 - 11904: 0xEE4B,
	34202 - 11904: 0xEDFD,
	34203 - 11904: 0xC1A7,
	34204 - 11904: 0xC1A3,
	34205 - 11904: 0xEE4C,
	34206 - 11904: 0xEDFE,
	34207 - 11904: 0xEE56,
	34208 - 11904: 0xEDF8,
	34209 - 11904: 0xEE43,
	34210 - 11904: 0xEE4E,
	34211 - 11904: 0xEDFA,
	34212 - 11904: 0xEDFC,
	34214 - 11904: 0xC2CB,
	34215 - 11904: 0xEDF6,
	34216 - 11904: 0xC1A9,
	34217 - 11904: 0xC2C4,
	34218 - 11904: 0xC17E,
	34223 - 11904: 0xC1A6,
	34224 - 11904: 0xC2C8,
	34225 - 11904: 0xF0B3,
	34227 - 11904: 0xF0A9,
	34228 - 11904: 0xF0A4,
	34229 - 11904: 0xF0AA,
	34230 - 11904: 0xF0B4,
	34231 - 11904: 0xF0B8,
	34232 - 11904: 0xF0B7,
	34233 - 11904: 0xC2CA,
	34234 - 11904: 0xC2C9,
	34237 - 11904: 0xF0AB,
	34238 - 11904: 0xF0B9,
	34239 - 11904: 0xF0AE,
	34240 - 11904: 0xF0A6,
	34241 - 11904: 0x8FA3,
	34242 - 11904: 0xF0A8,
	34243 - 11904: 0xF0A7,
	34244 - 11904: 0xF0AD,
	34245 - 11904: 0xF0B2,
	34246 - 11904: 0xF0A5,
	34247 - 11904: 0xF0AC,
	34248 - 11904: 0xF0B1,
	34249 - 11904: 0xC2C7,
	34251 - 11904: 0xF0AF,
	34253 - 11904: 0xC2C5,
	34254 - 11904: 0xF0B0,
	34255 - 11904: 0xC2C3,
	34256 - 11904: 0xC2C6,
	34257 - 11904: 0xF2D5,
	34258 - 11904: 0xF0B5,
	34261 - 11904: 0xC3C2,
	34262 - 11904: 0x8CCE,
	34263 - 11904: 0xF2CD,
	34264 - 11904: 0xF2D1,
	34265 - 11904: 0xF2C9,
	34266 - 11904: 0xF2CC,
	34268 - 11904: 0xF2D4,
	34269 - 11904: 0xC3C0,
	34270 - 11904: 0xF2D9,
	34271 - 11904: 0xF2D2,
	34272 - 11904: 0x99C6,
	34273 - 11904: 0xF2CA,
	34274 - 11904: 0xF2DA,
	34275 - 11904: 0xF2D3,
	34276 - 11904: 0xC3C3,
	34277 - 11904: 0xC3C4,
	34278 - 11904: 0xF2D7,
	34280 - 11904: 0xF2CB,
	34281 - 11904: 0xC3BF,
	34282 - 11904: 0xC3C1,
	34283 - 11904: 0xF2C6,
	34284 - 11904: 0xF2CE,
	34285 - 11904: 0xF2C8,
	34286 - 11904: 0x96CD,
	34287 - 11904: 0xF2D8,
	34288 - 11904: 0xF2D6,
	34289 - 11904: 0xF2C7,
	34290 - 11904: 0xF2CF,
	34294 - 11904: 0xF4BE,
	34295 - 11904: 0xC3C5,
	34296 - 11904: 0xF2D0,
	34297 - 11904: 0xC4A7,
	34298 - 11904: 0xC4A9,
	34299 - 11904: 0xC4A6,
	34300 - 11904: 0x96C7,
	34301 - 11904: 0xF4C3,
	34302 - 11904: 0xF4BB,
	34303 - 11904: 0xF4B9,
	34304 - 11904: 0xF4BD,
	34305 - 11904: 0xF4BA,
	34306 - 11904: 0x8FA5,
	34308 - 11904: 0xF4BF,
	34309 - 11904: 0xF4C1,
	34310 - 11904: 0xC4AA,
	34311 - 11904: 0xC4AC,
	34313 - 11904: 0xF4C0,
	34314 - 11904: 0xC4AD,
	34315 - 11904: 0xC4AB,
	34316 - 11904: 0xF4C2,
	34317 - 11904: 0xFABB,
	34319 - 11904: 0x8C61,
	34320 - 11904: 0x9570,
	34321 - 11904: 0xC4A8,
	34323 - 11904: 0x87AF,
	34324 - 11904: 0x9368,
	34326 - 11904: 0x8F7E,
	34327 - 11904: 0xC4F4,
	34328 - 11904: 0xF5F1,
	34329 - 11904: 0xF5F7,
	34330 - 11904: 0xC4F6,
	34331 - 11904: 0xF4BC,
	34332 - 11904: 0xF5F6,
	34334 - 11904: 0xF5FD,
	34335 - 11904: 0xF5F4,
	34336 - 11904: 0xF5FB,
	34337 - 11904: 0xF5FA,
	34338 - 11904: 0xF4B8,
	34339 - 11904: 0xF5F5,
	34340 - 11904: 0xF0B6,
	34341 - 11904: 0xF5FE,
	34342 - 11904: 0xF5F3,
	34343 - 11904: 0xF5F8,
	34344 - 11904: 0x8FAA,
	34345 - 11904: 0xF5FC,
	34346 - 11904: 0xF5F2,
	34348 - 11904: 0xF74A,
	34349 - 11904: 0xC4F5,
	34350 - 11904: 0xF5F9,
	34351 - 11904: 0xA050,
	34353 - 11904: 0xF7F4,
	34354 - 11904: 0xF74B,
	34355 - 11904: 0xF749,
	34356 - 11904: 0xF747,
	34357 - 11904: 0xF748,
	34358 - 11904: 0xF74C,
	34360 - 11904: 0xC5D9,
	34361 - 11904: 0xF7F2,
	34362 - 11904: 0xF7F0,
	34363 - 11904: 0xF7F5,
	34364 - 11904: 0xF7F3,
	34366 - 11904: 0xF7F6,
	34367 - 11904: 0xC5DA,
	34368 - 11904: 0xF7F1,
	34370 - 11904: 0x90D3,
	34371 - 11904: 0xF8BC,
	34373 - 11904: 0x9556,
	34374 - 11904: 0xF945,
	34375 - 11904: 0xF946,
	34376 - 11904: 0xF947,
	34379 - 11904: 0xF9C7,
	34380 - 11904: 0xF9BD,
	34381 - 11904: 0xCA4F,
	34382 - 11904: 0xAAEA,
	34384 - 11904: 0xAD68,
	34386 - 11904: 0xD3B8,
	34387 - 11904: 0xD3B7,
	34388 - 11904: 0xB040,
	34389 - 11904: 0xB342,
	34390 - 11904: 0xD77C,
	34393 - 11904: 0xD77B,
	34395 - 11904: 0xB5EA,
	34396 - 11904: 0xB8B8,
	34398 - 11904: 0xB8B7,
	34399 - 11904: 0xB8B9,
	34401 - 11904: 0xE3D4,
	34402 - 11904: 0xE77E,
	34403 - 11904: 0xEB58,
	34404 - 11904: 0xEB5A,
	34405 - 11904: 0xEB59,
	34407 - 11904: 0xC1AB,
	34408 - 11904: 0xEE57,
	34409 - 11904: 0xF0BA,
	34410 - 11904: 0xF9A5,
	34411 - 11904: 0xA6E4,
	34412 - 11904: 0x8FB8,
	34413 - 11904: 0xCDC9,
	34414 - 11904: 0xCDCA,
	34415 - 11904: 0xCDC8,
	34416 - 11904: 0xCDC7,
	34417 - 11904: 0xAAEB,
	34418 - 11904: 0x99C8,
	34419 - 11904: 0xD0A9,
	34420 - 11904: 0xD0A7,
	34423 - 11904: 0xD0A6,
	34425 - 11904: 0xAD69,
	34426 - 11904: 0xAD6B,
	34427 - 11904: 0xAD6A,
	34428 - 11904: 0xD0A8,
	34430 - 11904: 0x8FAF,
	34437 - 11904: 0xD3C4,
	34438 - 11904: 0xD3C1,
	34439 - 11904: 0xD3BF,
	34442 - 11904: 0xB041,
	34443 - 11904: 0xD3C2,
	34444 - 11904: 0xB046,
	34445 - 11904: 0xD3BC,
	34446 - 11904: 0xD3CB,
	34448 - 11904: 0xD3CD,
	34449 - 11904: 0xD3BD,
	34450 - 11904: 0x99C9,
	34451 - 11904: 0xB043,
	34452 - 11904: 0xD3CE,
	34453 - 11904: 0xD3C9,
	34454 - 11904: 0xD3BB,
	34455 - 11904: 0xD3C0,
	34456 - 11904: 0xD3CA,
	34457 - 11904: 0xD3C6,
	34458 - 11904: 0xD3C3,
	34460 - 11904: 0xB048,
	34461 - 11904: 0xD3CC,
	34462 - 11904: 0xD3BE,
	34464 - 11904: 0x9579,
	34465 - 11904: 0xD3C7,
	34466 - 11904: 0xD3B9,
	34467 - 11904: 0xB047,
	34468 - 11904: 0xB044,
	34469 - 11904: 0xD3C5,
	34471 - 11904: 0xD3C8,
	34472 - 11904: 0xD3BA,
	34473 - 11904: 0xB045,
	34474 - 11904: 0xB042,
	34477 - 11904: 0x9F49,
	34479 - 11904: 0xB34C,
	34480 - 11904: 0xD7A5,
	34481 - 11904: 0xB34B,
	34482 - 11904: 0x99CA,
	34483 - 11904: 0xD7A8,
	34484 - 11904: 0xD7AB,
	34485 - 11904: 0xB348,
	34486 - 11904: 0xB346,
	34487 - 11904: 0xD77E,
	34488 - 11904: 0xD7A9,
	34489 - 11904: 0xD7A7,
	34490 - 11904: 0xD7A4,
	34491 - 11904: 0xD7AC,
	34492 - 11904: 0xD7AD,
	34493 - 11904: 0xD7AF,
	34494 - 11904: 0xD7B0,
	34495 - 11904: 0xD77D,
	34496 - 11904: 0xB345,
	34497 - 11904: 0xD7A2,
	34498 - 11904: 0xD7A1,
	34499 - 11904: 0xD7AE,
	34500 - 11904: 0xB347,
	34501 - 11904: 0xD7A3,
	34502 - 11904: 0xB349,
	34503 - 11904: 0xB344,
	34504 - 11904: 0xD7A6,
	34505 - 11904: 0xB34D,
	34507 - 11904: 0xB34A,
	34508 - 11904: 0xD7AA,
	34512 - 11904: 0xB5F1,
	34513 - 11904: 0xDBBF,
	34515 - 11904: 0xDBB4,
	34516 - 11904: 0xB5EE,
	34518 - 11904: 0xDFE7,
	34519 - 11904: 0xDBBD,
	34520 - 11904: 0xDBB1,
	34521 - 11904: 0xB5EC,
	34522 - 11904: 0xDBB6,
	34523 - 11904: 0xB5EF,
	34524 - 11904: 0xDBBA,
	34525 - 11904: 0xDBB8,
	34526 - 11904: 0xB5F2,
	34527 - 11904: 0xB5EB,
	34530 - 11904: 0xDBB2,
	34531 - 11904: 0xDBB5,
	34532 - 11904: 0xB5F0,
	34534 - 11904: 0xDBB3,
	34536 - 11904: 0xDBBE,
	34537 - 11904: 0xDBBC,
	34538 - 11904: 0xDBB7,
	34539 - 11904: 0xDBB9,
	34540 - 11904: 0xDBBB,
	34541 - 11904: 0xB5ED,
	34543 - 11904: 0x99CB,
	34549 - 11904: 0xDFE8,
	34550 - 11904: 0xDFEE,
	34551 - 11904: 0xDFE4,
	34552 - 11904: 0xDFEA,
	34553 - 11904: 0xB8BA,
	34554 - 11904: 0xDFE6,
	34555 - 11904: 0xB8C0,
	34558 - 11904: 0xB8BF,
	34560 - 11904: 0xB8BE,
	34561 - 11904: 0xDFED,
	34562 - 11904: 0xB8C1,
	34563 - 11904: 0xB8C2,
	34564 - 11904: 0xDFE3,
	34565 - 11904: 0xDFF0,
	34566 - 11904: 0xB8C3,
	34567 - 11904: 0xB8BD,
	34568 - 11904: 0xB8BC,
	34569 - 11904: 0xDFEC,
	34570 - 11904: 0xB8C4,
	34571 - 11904: 0xDFE2,
	34572 - 11904: 0xDFE5,
	34573 - 11904: 0xDFEF,
	34574 - 11904: 0xDFEB,
	34577 - 11904: 0xE3F4,
	34578 - 11904: 0xE3E9,
	34579 - 11904: 0xB8BB,
	34584 - 11904: 0xBB6A,
	34585 - 11904: 0xE3DD,
	34586 - 11904: 0xE3F2,
	34587 - 11904: 0xE3DE,
	34588 - 11904: 0xBB65,
	34590 - 11904: 0xE3DB,
	34592 - 11904: 0xE3E4,
	34593 - 11904: 0xE3DC,
	34594 - 11904: 0xBB67,
	34595 - 11904: 0xE3D6,
	34596 - 11904: 0xE3F1,
	34597 - 11904: 0xBB68,
	34598 - 11904: 0xE3EE,
	34599 - 11904: 0xE3EF,
	34600 - 11904: 0xE3D7,
	34601 - 11904: 0xBB6D,
	34602 - 11904: 0xE3E6,
	34604 - 11904: 0xE3E0,
	34605 - 11904: 0xE3E7,
	34606 - 11904: 0xE3DA,
	34608 - 11904: 0xE3F3,
	34609 - 11904: 0xE3EB,
	34610 - 11904: 0xE3E5,
	34611 - 11904: 0xE3D5,
	34612 - 11904: 0xBB69,
	34613 - 11904: 0xE3EC,
	34615 - 11904: 0xBB6C,
	34616 - 11904: 0xE3F0,
	34618 - 11904: 0xE3EA,
	34619 - 11904: 0xBB66,
	34620 - 11904: 0xE3E8,
	34622 - 11904: 0xE3E2,
	34623 - 11904: 0xBB64,
	34624 - 11904: 0xE3D9,
	34625 - 11904: 0xE3E1,
	34626 - 11904: 0xE3ED,
	34627 - 11904: 0xE3DF,
	34630 - 11904: 0xE3E3,
	34636 - 11904: 0xBDC1,
	34637 - 11904: 0xDFE9,
	34638 - 11904: 0xE7B2,
	34639 - 11904: 0xE7BB,
	34640 - 11904: 0xE7B1,
	34641 - 11904: 0xE7AD,
	34642 - 11904: 0xE7AA,
	34643 - 11904: 0xBDC2,
	34644 - 11904: 0xE7A8,
	34645 - 11904: 0xBB6B,
	34646 - 11904: 0xE7A1,
	34647 - 11904: 0xBDC0,
	34648 - 11904: 0xE7A7,
	34649 - 11904: 0xBDBF,
	34650 - 11904: 0xE7AC,
	34651 - 11904: 0xE7A9,
	34652 - 11904: 0xE7B9,
	34653 - 11904: 0xE7B4,
	34654 - 11904: 0xE7AE,
	34655 - 11904: 0xE7B3,
	34656 - 11904: 0xBDBB,
	34657 - 11904: 0xE7AB,
	34658 - 11904: 0xE7BE,
	34659 - 11904: 0xE7A2,
	34660 - 11904: 0xE7A3,
	34661 - 11904: 0xE7BA,
	34662 - 11904: 0xBDBC,
	34663 - 11904: 0xE7BF,
	34664 - 11904: 0xBDBE,
	34665 - 11904: 0xE7C0,
	34666 - 11904: 0xE7B0,
	34667 - 11904: 0xE3D8,
	34668 - 11904: 0xE7B6,
	34669 - 11904: 0xE7AF,
	34670 - 11904: 0xE7B8,
	34671 - 11904: 0xE7B5,
	34672 - 11904: 0x9DD5,
	34673 - 11904: 0x8FB0,
	34675 - 11904: 0xE7A6,
	34676 - 11904: 0xBDB9,
	34677 - 11904: 0xE7BD,
	34678 - 11904: 0xBDBA,
	34679 - 11904: 0xE7A4,
	34680 - 11904: 0xBDBD,
	34681 - 11904: 0xEB64,
	34682 - 11904: 0xE7B7,
	34683 - 11904: 0xE7BC,
	34685 - 11904: 0xFA7A,
	34689 - 11904: 0xEB61,
	34690 - 11904: 0xBDB8,
	34691 - 11904: 0xBFC0,
	34692 - 11904: 0xEB6B,
	34693 - 11904: 0xEB67,
	34694 - 11904: 0x9E5F,
	34695 - 11904: 0xEB65,
	34696 - 11904: 0xEB60,
	34697 - 11904: 0xEB6F,
	34699 - 11904: 0x99CD,
	34700 - 11904: 0xA0C9,
	34701 - 11904: 0xBFC4,
	34703 - 11904: 0xEB5C,
	34704 - 11904: 0xEB68,
	34705 - 11904: 0xEB69,
	34706 - 11904: 0xEB5F,
	34707 - 11904: 0xEB5E,
	34708 - 11904: 0xEB6C,
	34710 - 11904: 0xEB62,
	34711 - 11904: 0xEB5D,
	34712 - 11904: 0xEB63,
	34714 - 11904: 0xEB6E,
	34715 - 11904: 0xEB5B,
	34716 - 11904: 0xEB6D,
	34717 - 11904: 0xEB6A,
	34718 - 11904: 0xBFC2,
	34719 - 11904: 0xBFC1,
	34722 - 11904: 0xBFC3,
	34723 - 11904: 0xEB66,
	34724 - 11904: 0xF0CB,
	34725 - 11904: 0x9ADB,
	34729 - 11904: 0xA0C6,
	34730 - 11904: 0xEE59,
	34731 - 11904: 0xC1B1,
	34732 - 11904: 0xEE5D,
	34733 - 11904: 0xEE5A,
	34734 - 11904: 0xEE61,
	34735 - 11904: 0xEE67,
	34736 - 11904: 0xEE5C,
	34737 - 11904: 0x8FB4,
	34738 - 11904: 0xEE70,
	34739 - 11904: 0xC1AE,
	34740 - 11904: 0xEE6A,
	34741 - 11904: 0xEE5F,
	34742 - 11904: 0xEE6B,
	34743 - 11904: 0xEE66,
	34744 - 11904: 0xEE6D,
	34745 - 11904: 0xEE5E,
	34746 - 11904: 0xC1B3,
	34747 - 11904: 0xC1B2,
	34748 - 11904: 0xEE60,
	34749 - 11904: 0xEE6E,
	34750 - 11904: 0xEE58,
	34751 - 11904: 0xEE6C,
	34752 - 11904: 0xC1AC,
	34753 - 11904: 0xA0D7,
	34754 - 11904: 0xEE64,
	34755 - 11904: 0xEE63,
	34756 - 11904: 0xEE68,
	34757 - 11904: 0xEE5B,
	34758 - 11904: 0xC1B0,
	34760 - 11904: 0xC1B4,
	34761 - 11904: 0xEE62,
	34762 - 11904: 0xEE69,
	34763 - 11904: 0xC1B5,
	34764 - 11904: 0xEE65,
	34766 - 11904: 0xA0C7,
	34769 - 11904: 0xC1AD,
	34770 - 11904: 0xC1AF,
	34771 - 11904: 0xF0C7,
	34772 - 11904: 0xF0C5,
	34774 - 11904: 0xA043,
	34775 - 11904: 0xF0CC,
	34776 - 11904: 0xF0C9,
	34777 - 11904: 0xF0CD,
	34778 - 11904: 0x8FB5,
	34779 - 11904: 0xF0BE,
	34780 - 11904: 0xF0C6,
	34781 - 11904: 0xF0D1,
	34782 - 11904: 0xEE6F,
	34783 - 11904: 0xF0C2,
	34784 - 11904: 0xC2CF,
	34785 - 11904: 0xE7A5,
	34786 - 11904: 0xF0BD,
	34787 - 11904: 0xF0CA,
	34788 - 11904: 0xF0C4,
	34789 - 11904: 0xF0C1,
	34790 - 11904: 0xF0BC,
	34791 - 11904: 0xF0BB,
	34792 - 11904: 0xF0D0,
	34794 - 11904: 0xF0C0,
	34795 - 11904: 0xF0BF,
	34796 - 11904: 0xC2CD,
	34797 - 11904: 0xF0C8,
	34798 - 11904: 0x8FB2,
	34799 - 11904: 0xC2CC,
	34802 - 11904: 0xC2CE,
	34803 - 11904: 0xF0C3,
	34804 - 11904: 0xF0CF,
	34805 - 11904: 0xA061,
	34806 - 11904: 0xF2DE,
	34807 - 11904: 0xF2DF,
	34809 - 11904: 0xC3C9,
	34810 - 11904: 0xF2DC,
	34811 - 11904: 0xC3C6,
	34812 - 11904: 0xF2E4,
	34814 - 11904: 0xC3CA,
	34815 - 11904: 0xF2E6,
	34816 - 11904: 0xF2DB,
	34817 - 11904: 0xF0CE,
	34818 - 11904: 0xF2E8,
	34819 - 11904: 0xF2DD,
	34820 - 11904: 0x9E5E,
	34821 - 11904: 0xC3C7,
	34822 - 11904: 0xF2E3,
	34824 - 11904: 0xF2E5,
	34825 - 11904: 0xF2E0,
	34826 - 11904: 0xF2E7,
	34827 - 11904: 0xF2E2,
	34828 - 11904: 0xF2E1,
	34829 - 11904: 0xC3C8,
	34831 - 11904: 0xA063,
	34832 - 11904: 0xF4C5,
	34833 - 11904: 0xF4C6,
	34835 - 11904: 0xF4C8,
	34836 - 11904: 0xC4AE,
	34837 - 11904: 0xC4AF,
	34838 - 11904: 0xF4C9,
	34839 - 11904: 0xF4C7,
	34840 - 11904: 0x9FE8,
	34841 - 11904: 0xF4C4,
	34843 - 11904: 0xF642,
	34844 - 11904: 0xF645,
	34845 - 11904: 0xF641,
	34847 - 11904: 0xC4FA,
	34848 - 11904: 0xF643,
	34849 - 11904: 0xC4F9,
	34850 - 11904: 0xC4F8,
	34851 - 11904: 0xC4F7,
	34852 - 11904: 0xF644,
	34853 - 11904: 0xF751,
	34854 - 11904: 0xF74F,
	34855 - 11904: 0x9CB2,
	34856 - 11904: 0xF74E,
	34857 - 11904: 0xF640,
	34858 - 11904: 0xF750,
	34859 - 11904: 0xF646,
	34860 - 11904: 0xF74D,
	34861 - 11904: 0x957C,
	34862 - 11904: 0xF7F9,
	34863 - 11904: 0xF7D7,
	34864 - 11904: 0xF7F7,
	34865 - 11904: 0xC5DB,
	34866 - 11904: 0xF7F8,
	34867 - 11904: 0xF7FA,
	34869 - 11904: 0xF8BF,
	34870 - 11904: 0xC5FA,
	34871 - 11904: 0xF8BE,
	34872 - 11904: 0xF8BD,
	34873 - 11904: 0xC5FB,
	34875 - 11904: 0xC65A,
	34876 - 11904: 0xF96E,
	34877 - 11904: 0xF9A7,
	34878 - 11904: 0xF9A6,
	34879 - 11904: 0xF9A8,
	34880 - 11904: 0xA6E5,
	34881 - 11904: 0xD0AA,
	34882 - 11904: 0x9FC7,
	34883 - 11904: 0xD3CF,
	34884 - 11904: 0xD3D0,
	34885 - 11904: 0x8FBB,
	34886 - 11904: 0x8FBC,
	34888 - 11904: 0xDBC0,
	34890 - 11904: 0xF647,
	34891 - 11904: 0xF8C0,
	34892 - 11904: 0xA6E6,
	34893 - 11904: 0xAD6C,
	34894 - 11904: 0xD0AB,
	34895 - 11904: 0x8FEC,
	34898 - 11904: 0xD7B1,
	34899 - 11904: 0xB34E,
	34901 - 11904: 0xDBC2,
	34902 - 11904: 0xDBC1,
	34903 - 11904: 0xB5F3,
	34905 - 11904: 0xB8C5,
	34906 - 11904: 0xE7C1,
	34907 - 11904: 0xBDC3,
	34909 - 11904: 0xBDC4,
	34910 - 11904: 0x8FC0,
	34912 - 11904: 0x936A,
	34913 - 11904: 0xBFC5,
	34914 - 11904: 0xC5FC,
	34915 - 11904: 0xA6E7,
	34916 - 11904: 0x8BE4,
	34917 - 11904: 0x9C7C,
	34919 - 11904: 0xD0AC,
	34920 - 11904: 0xAAED,
	34921 - 11904: 0xD0AE,
	34922 - 11904: 0xD0AD,
	34923 - 11904: 0xAD6D,
	34925 - 11904: 0xD3D1,
	34926 - 11904: 0x95A1,
	34927 - 11904: 0xD3D8,
	34928 - 11904: 0xB049,
	34929 - 11904: 0xD3D6,
	34930 - 11904: 0xD3D4,
	34932 - 11904: 0xD3DB,
	34933 - 11904: 0xD3D2,
	34934 - 11904: 0xD3D3,
	34935 - 11904: 0xB04A,
	34937 - 11904: 0xB04E,
	34940 - 11904: 0xD3DC,
	34941 - 11904: 0xB04D,
	34942 - 11904: 0xD3DA,
	34943 - 11904: 0xD3D7,
	34944 - 11904: 0xD3D5,
	34945 - 11904: 0xB04B,
	34946 - 11904: 0xB04C,
	34947 - 11904: 0xD3D9,
	34948 - 11904: 0xFEEC,
	34951 - 11904: 0x95A3,
	34952 - 11904: 0xB350,
	34953 - 11904: 0xD7B2,
	34955 - 11904: 0xB355,
	34956 - 11904: 0xD7C2,
	34957 - 11904: 0xB354,
	34958 - 11904: 0xD7C4,
	34959 - 11904: 0x8C45,
	34960 - 11904: 0x8CB8,
	34961 - 11904: 0xD7B8,
	34962 - 11904: 0xB352,
	34963 - 11904: 0xD7C3,
	34965 - 11904: 0xD7B3,
	34966 - 11904: 0xB353,
	34967 - 11904: 0xD7BF,
	34968 - 11904: 0xD7BB,
	34969 - 11904: 0xD7BD,
	34970 - 11904: 0xD7B7,
	34971 - 11904: 0xD7BE,
	34972 - 11904: 0x8FC1,
	34973 - 11904: 0x87B7,
	34974 - 11904: 0xB34F,
	34975 - 11904: 0xD7BA,
	34976 - 11904: 0xA052,
	34977 - 11904: 0xD7B9,
	34978 - 11904: 0xD7B5,
	34980 - 11904: 0xD7C0,
	34983 - 11904: 0xD7BC,
	34984 - 11904: 0xD7B4,
	34986 - 11904: 0xD7B6,
	34987 - 11904: 0xB351,
	34988 - 11904: 0xD7C1,
	34990 - 11904: 0x99D0,
	34993 - 11904: 0xB5F6,
	34994 - 11904: 0xDBCD,
	34996 - 11904: 0x8FC3,
	34997 - 11904: 0x8FC4,
	34998 - 11904: 0xDBC9,
	34999 - 11904: 0xDBCB,
	35000 - 11904: 0xDBC6,
	35001 - 11904: 0xDBC5,
	35002 - 11904: 0xDBC3,
	35004 - 11904: 0xDBCA,
	35005 - 11904: 0xDBCC,
	35006 - 11904: 0xDBC8,
	35007 - 11904: 0x95A4,
	35008 - 11904: 0xDBC7,
	35009 - 11904: 0xB5F4,
	35010 - 11904: 0xB5F5,
	35013 - 11904: 0x8FC6,
	35015 - 11904: 0x9E60,
	35017 - 11904: 0xDBCF,
	35018 - 11904: 0xB8CD,
	35019 - 11904: 0xDFF2,
	35020 - 11904: 0xDFF8,
	35021 - 11904: 0xDFF3,
	35022 - 11904: 0xDFF4,
	35023 - 11904: 0xF9D8,
	35024 - 11904: 0xDFF9,
	35026 - 11904: 0xB8CF,
	35028 - 11904: 0xB8C7,
	35029 - 11904: 0xB8CE,
	35030 - 11904: 0xDFF1,
	35031 - 11904: 0xDBC4,
	35032 - 11904: 0xB8CA,
	35033 - 11904: 0xB8C8,
	35034 - 11904: 0xDFF7,
	35035 - 11904: 0xDFF6,
	35036 - 11904: 0xB8C9,
	35037 - 11904: 0xB8CB,
	35038 - 11904: 0xDFF5,
	35039 - 11904: 0xB8C6,
	35041 - 11904: 0xB8CC,
	35046 - 11904: 0x95A5,
	35047 - 11904: 0xE3F6,
	35048 - 11904: 0xBB74,
	35051 - 11904: 0xE442,
	35052 - 11904: 0xE441,
	35054 - 11904: 0xE3FB,
	35055 - 11904: 0xBB76,
	35056 - 11904: 0xE440,
	35057 - 11904: 0xE3F7,
	35058 - 11904: 0xE3F8,
	35059 - 11904: 0xBB6E,
	35060 - 11904: 0xBB70,
	35061 - 11904: 0x9CB3,
	35062 - 11904: 0xE3FD,
	35063 - 11904: 0xE3F5,
	35064 - 11904: 0xBB72,
	35065 - 11904: 0xBB71,
	35066 - 11904: 0xE3F9,
	35067 - 11904: 0xE3FE,
	35068 - 11904: 0xE3FC,
	35069 - 11904: 0xBB73,
	35070 - 11904: 0xE3FA,
	35071 - 11904: 0x99D1,
	35072 - 11904: 0xFEF1,
	35073 - 11904: 0xDBCE,
	35074 - 11904: 0xBB6F,
	35077 - 11904: 0xE7C2,
	35078 - 11904: 0xE7C9,
	35079 - 11904: 0xBDC6,
	35081 - 11904: 0xE7CD,
	35082 - 11904: 0xBDCA,
	35083 - 11904: 0xE7C5,
	35084 - 11904: 0xE7C3,
	35086 - 11904: 0xE7CC,
	35088 - 11904: 0xBDC5,
	35089 - 11904: 0xE7CB,
	35090 - 11904: 0xBDC7,
	35091 - 11904: 0xBDC8,
	35092 - 11904: 0xE7C4,
	35093 - 11904: 0xBDC9,
	35094 - 11904: 0xE7CA,
	35095 - 11904: 0xE7C6,
	35096 - 11904: 0xE7C7,
	35097 - 11904: 0xE7C8,
	35098 - 11904: 0xBB75,
	35102 - 11904: 0xEB70,
	35103 - 11904: 0xEB7C,
	35105 - 11904: 0xBFCA,
	35106 - 11904: 0xEB77,
	35107 - 11904: 0xEB79,
	35108 - 11904: 0x99D2,
	35109 - 11904: 0xBFC8,
	35110 - 11904: 0xEB71,
	35111 - 11904: 0xEB75,
	35113 - 11904: 0xEB78,
	35114 - 11904: 0xBFC6,
	35115 - 11904: 0xBFC9,
	35116 - 11904: 0xEB7B,
	35117 - 11904: 0xEB73,
	35118 - 11904: 0xEB74,
	35119 - 11904: 0xEB7A,
	35120 - 11904: 0xEB72,
	35121 - 11904: 0xEB76,
	35122 - 11904: 0xBFC7,
	35123 - 11904: 0xEE72,
	35125 - 11904: 0xEE71,
	35126 - 11904: 0xC1B7,
	35127 - 11904: 0xEE77,
	35128 - 11904: 0xC1B9,
	35131 - 11904: 0xC1B6,
	35132 - 11904: 0xEE73,
	35133 - 11904: 0xC1BA,
	35134 - 11904: 0xEE74,
	35137 - 11904: 0xEE75,
	35138 - 11904: 0xEE78,
	35139 - 11904: 0x9CC2,
	35140 - 11904: 0xC1B8,
	35142 - 11904: 0xF0D6,
	35143 - 11904: 0x99D3,
	35145 - 11904: 0xF0D9,
	35147 - 11904: 0xF0D3,
	35148 - 11904: 0xF0D5,
	35149 - 11904: 0x95A7,
	35151 - 11904: 0xF0D4,
	35152 - 11904: 0xF0D7,
	35153 - 11904: 0xF0D8,
	35154 - 11904: 0xEE76,
	35155 - 11904: 0xF0D2,
	35156 - 11904: 0x95A9,
	35158 - 11904: 0xC3CD,
	35159 - 11904: 0xF2EC,
	35160 - 11904: 0xF2EF,
	35161 - 11904: 0xF2F1,
	35162 - 11904: 0xF2EA,
	35163 - 11904: 0xF2EB,
	35164 - 11904: 0xF2EE,
	35165 - 11904: 0xF2F0,
	35166 - 11904: 0xC3CE,
	35167 - 11904: 0xC3CC,
	35168 - 11904: 0xC3CB,
	35169 - 11904: 0xF2ED,
	35170 - 11904: 0xF2E9,
	35171 - 11904: 0xF4CA,
	35172 - 11904: 0xC4B0,
	35173 - 11904: 0x95A6,
	35174 - 11904: 0xF4CB,
	35177 - 11904: 0xF649,
	35178 - 11904: 0xC4FB,
	35179 - 11904: 0xF64B,
	35180 - 11904: 0xC4FC,
	35181 - 11904: 0xF648,
	35182 - 11904: 0xF64A,
	35183 - 11904: 0xC5A8,
	35185 - 11904: 0xF752,
	35186 - 11904: 0xC5A7,
	35187 - 11904: 0xF7FD,
	35188 - 11904: 0xF7FC,
	35190 - 11904: 0xF7FB,
	35191 - 11904: 0x9C5D,
	35193 - 11904: 0xF948,
	35194 - 11904: 0xF949,
	35195 - 11904: 0xF94B,
	35196 - 11904: 0xF94A,
	35198 - 11904: 0xCA50,
	35199 - 11904: 0xA6E8,
	35200 - 11904: 0x98E2,
	35201 - 11904: 0xAD6E,
	35202 - 11904: 0xD7C5,
	35203 - 11904: 0xB5F7,
	35205 - 11904: 0xDFFA,
	35206 - 11904: 0xC2D0,
	35207 - 11904: 0x8FC9,
	35208 - 11904: 0xF2F2,
	35209 - 11904: 0xA0C2,
	35210 - 11904: 0x8FCA,
	35211 - 11904: 0xA8A3,
	35215 - 11904: 0xB357,
	35217 - 11904: 0x99D4,
	35219 - 11904: 0xB356,
	35220 - 11904: 0xA0B9,
	35221 - 11904: 0xDBD0,
	35222 - 11904: 0xB5F8,
	35223 - 11904: 0xDBD2,
	35224 - 11904: 0xDBD1,
	35227 - 11904: 0xDFFB,
	35228 - 11904: 0xB8D0,
	35229 - 11904: 0xE443,
	35230 - 11904: 0xE446,
	35231 - 11904: 0xE445,
	35233 - 11904: 0xE444,
	35234 - 11904: 0xE7CE,
	35235 - 11904: 0xE7D0,
	35236 - 11904: 0xE7CF,
	35237 - 11904: 0x9B58,
	35238 - 11904: 0xBFCC,
	35239 - 11904: 0x8FCD,
	35241 - 11904: 0xA0D4,
	35242 - 11904: 0xBFCB,
	35244 - 11904: 0xC1BB,
	35245 - 11904: 0xEE79,
	35246 - 11904: 0xEE7B,
	35247 - 11904: 0xEE7A,
	35250 - 11904: 0xC2D1,
	35254 - 11904: 0xF2F4,
	35255 - 11904: 0xF2F3,
	35257 - 11904: 0xF4CC,
	35258 - 11904: 0xC4B1,
	35260 - 11904: 0x8FCE,
	35261 - 11904: 0xC4FD,
	35262 - 11904: 0xF754,
	35263 - 11904: 0xF753,
	35264 - 11904: 0xC65B,
	35265 - 11904: 0x8BE5,
	35270 - 11904: 0x8979,
	35282 - 11904: 0xA8A4,
	35283 - 11904: 0xD0AF,
	35284 - 11904: 0xAD6F,
	35285 - 11904: 0xD7C8,
	35286 - 11904: 0xD7C6,
	35289 - 11904: 0xD7C7,
	35290 - 11904: 0xDBD4,
	35291 - 11904: 0xDBD5,
	35292 - 11904: 0xE043,
	35293 - 11904: 0xDBD3,
	35295 - 11904: 0xDFFC,
	35296 - 11904: 0xE041,
	35297 - 11904: 0xE040,
	35298 - 11904: 0xE042,
	35299 - 11904: 0xB8D1,
	35300 - 11904: 0xDFFE,
	35301 - 11904: 0xDFFD,
	35302 - 11904: 0xE044,
	35303 - 11904: 0x8FD0,
	35304 - 11904: 0xE449,
	35305 - 11904: 0xE447,
	35307 - 11904: 0xE448,
	35308 - 11904: 0xE7D3,
	35309 - 11904: 0xE7D1,
	35312 - 11904: 0xE7D2,
	35313 - 11904: 0xEB7D,
	35314 - 11904: 0xEE7C,
	35315 - 11904: 0xEE7D,
	35316 - 11904: 0xC2D2,
	35318 - 11904: 0xF2F5,
	35319 - 11904: 0xF4CD,
	35320 - 11904: 0xC4B2,
	35322 - 11904: 0xF64C,
	35323 - 11904: 0xF755,
	35324 - 11904: 0xC5A9,
	35326 - 11904: 0xF7FE,
	35327 - 11904: 0xF94C,
	35328 - 11904: 0xA8A5,
	35330 - 11904: 0xAD71,
	35331 - 11904: 0xAD72,
	35332 - 11904: 0xD0B0,
	35335 - 11904: 0xD0B1,
	35336 - 11904: 0xAD70,
	35338 - 11904: 0xB054,
	35340 - 11904: 0xB052,
	35342 - 11904: 0xB051,
	35343 - 11904: 0xB058,
	35344 - 11904: 0xB050,
	35345 - 11904: 0xB059,
	35346 - 11904: 0xD3DD,
	35347 - 11904: 0xB056,
	35349 - 11904: 0xB053,
	35350 - 11904: 0xB057,
	35351 - 11904: 0xB055,
	35352 - 11904: 0xB04F,
	35355 - 11904: 0xB35F,
	35356 - 11904: 0x95B6,
	35357 - 11904: 0xB359,
	35358 - 11904: 0xD7CC,
	35359 - 11904: 0xB35E,
	35362 - 11904: 0xB360,
	35363 - 11904: 0xB35A,
	35365 - 11904: 0xB35B,
	35367 - 11904: 0xD7CA,
	35369 - 11904: 0x99D6,
	35370 - 11904: 0xB358,
	35371 - 11904: 0x95E5,
	35372 - 11904: 0xD7CB,
	35373 - 11904: 0xB35D,
	35376 - 11904: 0xD7C9,
	35377 - 11904: 0xB35C,
	35380 - 11904: 0xB644,
	35382 - 11904: 0xB646,
	35384 - 11904: 0x99D7,
	35385 - 11904: 0xDBD8,
	35386 - 11904: 0xB645,
	35387 - 11904: 0xB5F9,
	35388 - 11904: 0xB5FD,
	35389 - 11904: 0x95B5,
	35390 - 11904: 0xB8E4,
	35391 - 11904: 0xE049,
	35392 - 11904: 0xDBDA,
	35393 - 11904: 0xB5FE,
	35396 - 11904: 0xDBDD,
	35397 - 11904: 0xDBDE,
	35398 - 11904: 0xB643,
	35400 - 11904: 0xDBE0,
	35401 - 11904: 0xA0CA,
	35402 - 11904: 0xDBE2,
	35404 - 11904: 0xDBE3,
	35405 - 11904: 0xDBD7,
	35406 - 11904: 0xDBD6,
	35407 - 11904: 0xDBE4,
	35408 - 11904: 0xB642,
	35409 - 11904: 0xDBE1,
	35410 - 11904: 0xDBDF,
	35412 - 11904: 0xB640,
	35413 - 11904: 0xB5FB,
	35414 - 11904: 0xB647,
	35415 - 11904: 0xDBDB,
	35416 - 11904: 0xDBDC,
	35417 - 11904: 0xDBD9,
	35419 - 11904: 0xB641,
	35422 - 11904: 0xB5FC,
	35424 - 11904: 0xB5FA,
	35425 - 11904: 0xE048,
	35426 - 11904: 0xB8DF,
	35427 - 11904: 0xB8DA,
	35430 - 11904: 0xB8D5,
	35431 - 11904: 0x9FFD,
	35432 - 11904: 0xB8E5,
	35433 - 11904: 0xB8D6,
	35435 - 11904: 0xB8D2,
	35436 - 11904: 0xB8E1,
	35437 - 11904: 0xB8DE,
	35438 - 11904: 0xB8E0,
	35440 - 11904: 0xB8D7,
	35441 - 11904: 0xB8DC,
	35442 - 11904: 0xB8D3,
	35443 - 11904: 0xB8D4,
	35444 - 11904: 0xE050,
	35445 - 11904: 0xE04D,
	35446 - 11904: 0xE045,
	35447 - 11904: 0xE04A,
	35449 - 11904: 0xB8E2,
	35450 - 11904: 0xE051,
	35451 - 11904: 0xB8E3,
	35452 - 11904: 0xB8D9,
	35454 - 11904: 0xA058,
	35455 - 11904: 0xE047,
	35457 - 11904: 0xE04F,
	35458 - 11904: 0xE04B,
	35459 - 11904: 0xE04E,
	35460 - 11904: 0xE04C,
	35461 - 11904: 0xB8DD,
	35462 - 11904: 0xE046,
	35463 - 11904: 0xB8D8,
	35467 - 11904: 0xE44C,
	35468 - 11904: 0xBB78,
	35469 - 11904: 0xBB7B,
	35471 - 11904: 0xE44E,
	35472 - 11904: 0x8FD6,
	35473 - 11904: 0xBBA5,
	35474 - 11904: 0xE44D,
	35475 - 11904: 0xBB7D,
	35476 - 11904: 0x99D8,
	35477 - 11904: 0xBDCF,
	35478 - 11904: 0xE44F,
	35480 - 11904: 0xBBA4,
	35481 - 11904: 0xE44B,
	35482 - 11904: 0xBBA6,
	35484 - 11904: 0x8FD3,
	35486 - 11904: 0xBB79,
	35488 - 11904: 0xB8DB,
	35489 - 11904: 0xBB7C,
	35491 - 11904: 0xBB7A,
	35492 - 11904: 0xBB7E,
	35493 - 11904: 0xBBA2,
	35494 - 11904: 0xBB77,
	35495 - 11904: 0xBBA7,
	35496 - 11904: 0xBBA3,
	35497 - 11904: 0x8FE5,
	35498 - 11904: 0xBBA1,
	35499 - 11904: 0xE44A,
	35503 - 11904: 0x8FE9,
	35504 - 11904: 0xBDD6,
	35506 - 11904: 0xBDD2,
	35508 - 11904: 0x99D9,
	35510 - 11904: 0xBDD9,
	35512 - 11904: 0xE7D6,
	35513 - 11904: 0xBDDA,
	35514 - 11904: 0xE7E2,
	35515 - 11904: 0xE7DB,
	35516 - 11904: 0xBDCB,
	35517 - 11904: 0xE7E3,
	35518 - 11904: 0xE7DD,
	35519 - 11904: 0xBDD5,
	35520 - 11904: 0xE7DE,
	35522 - 11904: 0xBDD4,
	35523 - 11904: 0xE7E1,
	35524 - 11904: 0xBDCE,
	35525 - 11904: 0xE7DF,
	35526 - 11904: 0xE7D5,
	35527 - 11904: 0xBDCD,
	35528 - 11904: 0xEBAA,
	35529 - 11904: 0xBDD3,
	35531 - 11904: 0xBDD0,
	35532 - 11904: 0x8CF7,
	35533 - 11904: 0xBDD8,
	35535 - 11904: 0xE7D4,
	35537 - 11904: 0xE7D8,
	35538 - 11904: 0xBDCC,
	35539 - 11904: 0xE7D7,
	35540 - 11904: 0xE7D9,
	35541 - 11904: 0xE7DA,
	35542 - 11904: 0xBDD7,
	35543 - 11904: 0xE7DC,
	35544 - 11904: 0xE7E0,
	35545 - 11904: 0xE7E4,
	35546 - 11904: 0x927C,
	35547 - 11904: 0xBDDB,
	35548 - 11904: 0xBFD2,
	35549 - 11904: 0xEBA5,
	35550 - 11904: 0xEBAB,
	35551 - 11904: 0xEBA8,
	35552 - 11904: 0xEB7E,
	35553 - 11904: 0xEBAC,
	35554 - 11904: 0xEBA1,
	35556 - 11904: 0xEBA7,
	35558 - 11904: 0xBFCD,
	35559 - 11904: 0xBFD3,
	35560 - 11904: 0xEBAD,
	35562 - 11904: 0x9C45,
	35563 - 11904: 0xBFCF,
	35565 - 11904: 0xBFD9,
	35566 - 11904: 0xBFD4,
	35567 - 11904: 0xEBAF,
	35568 - 11904: 0xEBA9,
	35569 - 11904: 0xBFD0,
	35570 - 11904: 0xEBA2,
	35571 - 11904: 0xBFDA,
	35572 - 11904: 0xEBA3,
	35573 - 11904: 0xEBA4,
	35574 - 11904: 0xBFDB,
	35575 - 11904: 0xBFD8,
	35576 - 11904: 0xBDD1,
	35577 - 11904: 0x8CE8,
	35578 - 11904: 0xBFCE,
	35579 - 11904: 0xEBB0,
	35580 - 11904: 0xBFDC,
	35582 - 11904: 0xBFD5,
	35583 - 11904: 0xEBAE,
	35584 - 11904: 0xBFD1,
	35585 - 11904: 0xBFD6,
	35586 - 11904: 0xBFD7,
	35588 - 11904: 0xC1C3,
	35589 - 11904: 0xEEA4,
	35590 - 11904: 0xEEAD,
	35591 - 11904: 0xEEAA,
	35592 - 11904: 0xEEAC,
	35594 - 11904: 0xC1C0,
	35595 - 11904: 0xEEA5,
	35596 - 11904: 0x8FDE,
	35597 - 11904: 0xEEAB,
	35598 - 11904: 0xC1BC,
	35599 - 11904: 0xEEA7,
	35600 - 11904: 0xC1C4,
	35601 - 11904: 0xEEA3,
	35602 - 11904: 0xEEA8,
	35603 - 11904: 0xEEAF,
	35604 - 11904: 0xEBA6,
	35605 - 11904: 0xEEA9,
	35606 - 11904: 0xEEA2,
	35607 - 11904: 0xC1BD,
	35608 - 11904: 0xEEA1,
	35609 - 11904: 0xC1BE,
	35610 - 11904: 0xEEB0,
	35611 - 11904: 0xC1BF,
	35612 - 11904: 0xEEAE,
	35613 - 11904: 0xC1C2,
	35614 - 11904: 0xEE7E,
	35615 - 11904: 0x8FDF,
	35616 - 11904: 0xC1C1,
	35618 - 11904: 0xEEA6,
	35619 - 11904: 0xF0DC,
	35620 - 11904: 0xF0EA,
	35621 - 11904: 0xF0E5,
	35622 - 11904: 0xF0E7,
	35623 - 11904: 0xF0DB,
	35624 - 11904: 0xC2D3,
	35626 - 11904: 0xF0DA,
	35627 - 11904: 0xC2D6,
	35628 - 11904: 0xC2D5,
	35629 - 11904: 0xA04B,
	35630 - 11904: 0xF0E9,
	35631 - 11904: 0xF0E1,
	35632 - 11904: 0xF0DE,
	35633 - 11904: 0xF0E4,
	35635 - 11904: 0xF0DD,
	35637 - 11904: 0xF0DF,
	35638 - 11904: 0xF0E8,
	35639 - 11904: 0xF0E6,
	35641 - 11904: 0xC2D4,
	35642 - 11904: 0xF0ED,
	35643 - 11904: 0xF0EB,
	35644 - 11904: 0xF0E2,
	35645 - 11904: 0xF0EC,
	35646 - 11904: 0xF0E3,
	35647 - 11904: 0x8FE2,
	35648 - 11904: 0xF2F9,
	35649 - 11904: 0xC3CF,
	35650 - 11904: 0xF341,
	35651 - 11904: 0xA0CC,
	35653 - 11904: 0xF64F,
	35654 - 11904: 0xC3D6,
	35655 - 11904: 0xF0E0,
	35656 - 11904: 0xF2F7,
	35657 - 11904: 0xC3D2,
	35658 - 11904: 0xF2F8,
	35659 - 11904: 0xF2FD,
	35660 - 11904: 0x8FE3,
	35661 - 11904: 0x8FE4,
	35662 - 11904: 0xC3D4,
	35663 - 11904: 0xC3D5,
	35664 - 11904: 0xF2F6,
	35665 - 11904: 0xF340,
	35666 - 11904: 0xF342,
	35667 - 11904: 0xF2FA,
	35668 - 11904: 0xF2FC,
	35669 - 11904: 0xF2FE,
	35670 - 11904: 0xF2FB,
	35671 - 11904: 0xF343,
	35672 - 11904: 0xC3D1,
	35673 - 11904: 0xC3D7,
	35674 - 11904: 0xC3D3,
	35676 - 11904: 0xC3D0,
	35677 - 11904: 0xF4D0,
	35678 - 11904: 0x9BC4,
	35679 - 11904: 0xC4B7,
	35680 - 11904: 0xF4CE,
	35682 - 11904: 0x9BFC,
	35683 - 11904: 0xF4D2,
	35685 - 11904: 0xF4D3,
	35686 - 11904: 0xC4B5,
	35687 - 11904: 0xF4D4,
	35688 - 11904: 0xF4D1,
	35689 - 11904: 0x964C,
	35690 - 11904: 0xF4CF,
	35691 - 11904: 0xC4B8,
	35692 - 11904: 0xC4B4,
	35693 - 11904: 0xF4D5,
	35695 - 11904: 0xC4B6,
	35696 - 11904: 0xC4B3,
	35700 - 11904: 0xC4FE,
	35703 - 11904: 0xC540,
	35704 - 11904: 0xF64E,
	35705 - 11904: 0xF64D,
	35706 - 11904: 0xF650,
	35707 - 11904: 0xF651,
	35709 - 11904: 0xC541,
	35710 - 11904: 0xF756,
	35711 - 11904: 0xF75B,
	35712 - 11904: 0xC5AA,
	35713 - 11904: 0x9AF6,
	35714 - 11904: 0xF758,
	35715 - 11904: 0x8CAE,
	35716 - 11904: 0xF757,
	35717 - 11904: 0xF75A,
	35718 - 11904: 0xF759,
	35720 - 11904: 0xF843,
	35722 - 11904: 0xC5DC,
	35723 - 11904: 0xF842,
	35724 - 11904: 0xF840,
	35726 - 11904: 0xF841,
	35727 - 11904: 0x87CB,
	35728 - 11904: 0x8FE7,
	35730 - 11904: 0xC5FE,
	35731 - 11904: 0xC5FD,
	35732 - 11904: 0xF8C1,
	35733 - 11904: 0xF8C2,
	35734 - 11904: 0xC640,
	35736 - 11904: 0xF94D,
	35737 - 11904: 0xF94E,
	35738 - 11904: 0xC667,
	35739 - 11904: 0x8FE8,
	35740 - 11904: 0xC66D,
	35742 - 11904: 0xF9A9,
	35743 - 11904: 0xF9C8,
	35744 - 11904: 0x8BE7,
	35774 - 11904: 0x897A,
	35810 - 11904: 0x897B,
	35895 - 11904: 0xA8A6,
	35897 - 11904: 0xD7CD,
	35899 - 11904: 0xD7CE,
	35900 - 11904: 0xE052,
	35901 - 11904: 0xE450,
	35902 - 11904: 0xE7E5,
	35903 - 11904: 0xC1C6,
	35905 - 11904: 0xC1C5,
	35906 - 11904: 0xF0EE,
	35907 - 11904: 0xF344,
	35909 - 11904: 0xF844,
	35910 - 11904: 0xA8A7,
	35911 - 11904: 0xD3DE,
	35912 - 11904: 0xB05A,
	35913 - 11904: 0xB361,
	35914 - 11904: 0xE054,
	35915 - 11904: 0xE053,
	35916 - 11904: 0xBDDC,
	35917 - 11904: 0xE7E6,
	35918 - 11904: 0xBDDD,
	35919 - 11904: 0xEEB1,
	35920 - 11904: 0xC2D7,
	35921 - 11904: 0x99DA,
	35924 - 11904: 0xC676,
	35925 - 11904: 0xA8A8,
	35926 - 11904: 0xCDCB,
	35927 - 11904: 0xD3DF,
	35930 - 11904: 0xB362,
	35932 - 11904: 0xD7CF,
	35933 - 11904: 0xD7D0,
	35935 - 11904: 0xDBE5,
	35937 - 11904: 0xB648,
	35938 - 11904: 0xB8E6,
	35940 - 11904: 0xE056,
	35941 - 11904: 0xE055,
	35942 - 11904: 0xE057,
	35944 - 11904: 0xE451,
	35945 - 11904: 0xE452,
	35946 - 11904: 0xBBA8,
	35947 - 11904: 0xBFDD,
	35948 - 11904: 0xBDDE,
	35949 - 11904: 0xBFDE,
	35951 - 11904: 0xEEB5,
	35952 - 11904: 0xEEB2,
	35953 - 11904: 0xEEB4,
	35954 - 11904: 0xEEB3,
	35955 - 11904: 0xC1C7,
	35957 - 11904: 0xF0EF,
	35958 - 11904: 0xF346,
	35959 - 11904: 0xF345,
	35960 - 11904: 0xCBA4,
	35961 - 11904: 0xB05C,
	35962 - 11904: 0xB05B,
	35963 - 11904: 0xD3E0,
	35965 - 11904: 0xD7D1,
	35968 - 11904: 0xDBE7,
	35969 - 11904: 0xDBE6,
	35970 - 11904: 0xB649,
	35972 - 11904: 0xE059,
	35973 - 11904: 0xE05A,
	35974 - 11904: 0xE058,
	35977 - 11904: 0xB8E8,
	35978 - 11904: 0xB8E7,
	35980 - 11904: 0xBBAA,
	35981 - 11904: 0xBBA9,
	35983 - 11904: 0xE7E7,
	35984 - 11904: 0xEBB3,
	35985 - 11904: 0xEBB1,
	35986 - 11904: 0xEBB2,
	35987 - 11904: 0xBFDF,
	35988 - 11904: 0xEEB7,
	35989 - 11904: 0xEEB6,
	35991 - 11904: 0xF0F2,
	35992 - 11904: 0xF0F1,
	35993 - 11904: 0xF0F0,
	35994 - 11904: 0xF347,
	35995 - 11904: 0x8FED,
	35996 - 11904: 0xF9AA,
	35997 - 11904: 0xA8A9,
	35998 - 11904: 0xAD73,
	35999 - 11904: 0x95C0,
	36000 - 11904: 0xAD74,
	36001 - 11904: 0xB05D,
	36002 - 11904: 0xB05E,
	36003 - 11904: 0xD3E2,
	36004 - 11904: 0xD3E1,
	36005 - 11904: 0xD7D2,
	36007 - 11904: 0xB368,
	36008 - 11904: 0xB366,
	36009 - 11904: 0xB363,
	36010 - 11904: 0xB367,
	36011 - 11904: 0xB365,
	36012 - 11904: 0xB364,
	36013 - 11904: 0xA0CB,
	36015 - 11904: 0xB64A,
	36016 - 11904: 0xDBEA,
	36018 - 11904: 0xB8ED,
	36019 - 11904: 0xB64C,
	36020 - 11904: 0xB651,
	36021 - 11904: 0xDBEC,
	36022 - 11904: 0xB653,
	36023 - 11904: 0xB652,
	36024 - 11904: 0xB655,
	36025 - 11904: 0xDBEB,
	36026 - 11904: 0xDBE8,
	36027 - 11904: 0xB64F,
	36028 - 11904: 0xB64B,
	36029 - 11904: 0xB64D,
	36030 - 11904: 0xDBE9,
	36031 - 11904: 0xB654,
	36032 - 11904: 0xB650,
	36033 - 11904: 0xB64E,
	36034 - 11904: 0xB8EF,
	36035 - 11904: 0xB8EE,
	36036 - 11904: 0xB8EC,
	36037 - 11904: 0xB8F0,
	36039 - 11904: 0xB8EA,
	36040 - 11904: 0xB8EB,
	36042 - 11904: 0xB8E9,
	36044 - 11904: 0xE05B,
	36045 - 11904: 0x9E48,
	36047 - 11904: 0xE454,
	36049 - 11904: 0xBBAC,
	36050 - 11904: 0xBBAD,
	36051 - 11904: 0xBBAB,
	36052 - 11904: 0x99DB,
	36053 - 11904: 0xE453,
	36054 - 11904: 0x8FF3,
	36055 - 11904: 0xE455,
	36057 - 11904: 0xE7EA,
	36058 - 11904: 0xE7EC,
	36059 - 11904: 0x8FF9,
	36060 - 11904: 0xBDE7,
	36061 - 11904: 0xE7ED,
	36062 - 11904: 0xBDE0,
	36063 - 11904: 0xE7E9,
	36064 - 11904: 0xBDDF,
	36065 - 11904: 0xBDE9,
	36066 - 11904: 0xBDE5,
	36067 - 11904: 0xBDE6,
	36068 - 11904: 0xBDE2,
	36069 - 11904: 0xE7E8,
	36070 - 11904: 0xBDE1,
	36071 - 11904: 0xE7EE,
	36072 - 11904: 0xE7EB,
	36073 - 11904: 0x95C1,
	36074 - 11904: 0xBDE8,
	36075 - 11904: 0xA04E,
	36076 - 11904: 0xBDE3,
	36077 - 11904: 0xBDE4,
	36078 - 11904: 0xEBB5,
	36080 - 11904: 0xEBB7,
	36081 - 11904: 0xEBB6,
	36082 - 11904: 0x99DC,
	36083 - 11904: 0xEBB8,
	36084 - 11904: 0xBFE0,
	36085 - 11904: 0xEBB4,
	36087 - 11904: 0xA064,
	36088 - 11904: 0xC1CB,
	36089 - 11904: 0xEEB8,
	36090 - 11904: 0xC1C8,
	36091 - 11904: 0xC1CC,
	36092 - 11904: 0xC1CA,
	36093 - 11904: 0xC1C9,
	36094 - 11904: 0xF0F3,
	36096 - 11904: 0xF0F6,
	36098 - 11904: 0xF0F5,
	36099 - 11904: 0x8FF7,
	36100 - 11904: 0xF0F4,
	36101 - 11904: 0xC2D8,
	36102 - 11904: 0xF348,
	36103 - 11904: 0xF349,
	36104 - 11904: 0xC3D8,
	36105 - 11904: 0xF34A,
	36106 - 11904: 0xC3D9,
	36107 - 11904: 0x89B0,
	36108 - 11904: 0xA048,
	36109 - 11904: 0xC4BA,
	36111 - 11904: 0xC4B9,
	36112 - 11904: 0xF652,
	36113 - 11904: 0x8FFB,
	36114 - 11904: 0x8FF6,
	36115 - 11904: 0xC542,
	36116 - 11904: 0xF653,
	36117 - 11904: 0xF75C,
	36118 - 11904: 0xC5AB,
	36119 - 11904: 0xC5AC,
	36120 - 11904: 0x9DDC,
	36121 - 11904: 0xF845,
	36123 - 11904: 0xC642,
	36124 - 11904: 0x99DD,
	36125 - 11904: 0x8BE8,
	36196 - 11904: 0xA8AA,
	36198 - 11904: 0xB36A,
	36199 - 11904: 0xB369,
	36200 - 11904: 0xE05C,
	36201 - 11904: 0xE05D,
	36203 - 11904: 0xBBAE,
	36204 - 11904: 0xEBB9,
	36205 - 11904: 0xBDEA,
	36206 - 11904: 0xEBBA,
	36207 - 11904: 0xEEB9,
	36208 - 11904: 0xA8AB,
	36210 - 11904: 0xD0B2,
	36211 - 11904: 0xAD76,
	36212 - 11904: 0xAD75,
	36214 - 11904: 0xD3E3,
	36215 - 11904: 0xB05F,
	36216 - 11904: 0xD3E4,
	36217 - 11904: 0xD7D5,
	36218 - 11904: 0x92C1,
	36219 - 11904: 0xD7D4,
	36221 - 11904: 0xD7D3,
	36224 - 11904: 0xDBEE,
	36225 - 11904: 0xB658,
	36226 - 11904: 0x9FD6,
	36228 - 11904: 0xDBED,
	36229 - 11904: 0xB657,
	36233 - 11904: 0xDBEF,
	36234 - 11904: 0xB656,
	36236 - 11904: 0xE05F,
	36237 - 11904: 0xE062,
	36238 - 11904: 0xE060,
	36239 - 11904: 0xE061,
	36240 - 11904: 0xE065,
	36241 - 11904: 0xE05E,
	36242 - 11904: 0xE066,
	36243 - 11904: 0xE063,
	36244 - 11904: 0xE064,
	36245 - 11904: 0xBBB0,
	36246 - 11904: 0xE456,
	36249 - 11904: 0xBBAF,
	36251 - 11904: 0xE7F2,
	36252 - 11904: 0xE7F0,
	36255 - 11904: 0xBDEB,
	36256 - 11904: 0xE7EF,
	36257 - 11904: 0xE7F1,
	36259 - 11904: 0xBDEC,
	36261 - 11904: 0xEBBB,
	36262 - 11904: 0xA0D2,
	36263 - 11904: 0xEBBC,
	36264 - 11904: 0xC1CD,
	36265 - 11904: 0x9040,
	36266 - 11904: 0xF34C,
	36267 - 11904: 0xF34E,
	36268 - 11904: 0xF34B,
	36269 - 11904: 0xF34D,
	36270 - 11904: 0xF4D6,
	36271 - 11904: 0xF654,
	36274 - 11904: 0xF96F,
	36275 - 11904: 0xA8AC,
	36276 - 11904: 0xAD77,
	36277 - 11904: 0xD3E5,
	36278 - 11904: 0xD3E7,
	36279 - 11904: 0xD3E6,
	36281 - 11904: 0xD7D8,
	36282 - 11904: 0xB36C,
	36284 - 11904: 0xD7D6,
	36286 - 11904: 0xB36B,
	36287 - 11904: 0xD7D9,
	36288 - 11904: 0x8AC4,
	36289 - 11904: 0xD7DA,
	36290 - 11904: 0xD7D7,
	36291 - 11904: 0x99E0,
	36293 - 11904: 0xDBFB,
	36294 - 11904: 0xB660,
	36295 - 11904: 0xDBF3,
	36296 - 11904: 0xDBF9,
	36299 - 11904: 0xB65B,
	36300 - 11904: 0xB65E,
	36301 - 11904: 0xDBF2,
	36302 - 11904: 0xB659,
	36303 - 11904: 0xDBF6,
	36304 - 11904: 0xE06C,
	36305 - 11904: 0xB65D,
	36307 - 11904: 0xDBF1,
	36308 - 11904: 0x9FF0,
	36309 - 11904: 0xDBF7,
	36310 - 11904: 0xDBF4,
	36311 - 11904: 0xDBFA,
	36312 - 11904: 0xDBF0,
	36313 - 11904: 0xDBF8,
	36314 - 11904: 0xB65C,
	36315 - 11904: 0xB65F,
	36316 - 11904: 0xDBF5,
	36317 - 11904: 0xB65A,
	36319 - 11904: 0xB8F2,
	36320 - 11904: 0xE068,
	36321 - 11904: 0xB8F1,
	36322 - 11904: 0xE06F,
	36323 - 11904: 0xE06E,
	36324 - 11904: 0xB8F8,
	36326 - 11904: 0xB8F9,
	36327 - 11904: 0xE070,
	36328 - 11904: 0xB8F3,
	36329 - 11904: 0xE06D,
	36330 - 11904: 0xB8F7,
	36331 - 11904: 0xE072,
	36332 - 11904: 0xE069,
	36334 - 11904: 0xE06B,
	36335 - 11904: 0xB8F4,
	36336 - 11904: 0xE067,
	36337 - 11904: 0xE06A,
	36338 - 11904: 0xE071,
	36339 - 11904: 0xB8F5,
	36340 - 11904: 0xE073,
	36346 - 11904: 0xB8F6,
	36348 - 11904: 0xBBB1,
	36349 - 11904: 0xE45B,
	36350 - 11904: 0xE461,
	36351 - 11904: 0xE459,
	36352 - 11904: 0xE462,
	36353 - 11904: 0x9FF3,
	36354 - 11904: 0xE458,
	36355 - 11904: 0xE45D,
	36356 - 11904: 0xE463,
	36357 - 11904: 0xE460,
	36358 - 11904: 0xE45F,
	36359 - 11904: 0xE45E,
	36361 - 11904: 0xE457,
	36362 - 11904: 0xE45C,
	36365 - 11904: 0xE45A,
	36366 - 11904: 0x9DBF,
	36367 - 11904: 0xBDF1,
	36368 - 11904: 0xBDEE,
	36369 - 11904: 0xE7FB,
	36370 - 11904: 0xE841,
	36371 - 11904: 0xE843,
	36372 - 11904: 0xE840,
	36373 - 11904: 0xE7F8,
	36374 - 11904: 0xE7FA,
	36375 - 11904: 0xE845,
	36376 - 11904: 0xE842,
	36377 - 11904: 0xE7FC,
	36378 - 11904: 0xE846,
	36379 - 11904: 0xE7F9,
	36380 - 11904: 0xE844,
	36381 - 11904: 0xBDEF,
	36382 - 11904: 0xBDF5,
	36383 - 11904: 0xBDF3,
	36384 - 11904: 0xE7F3,
	36385 - 11904: 0xBDF4,
	36386 - 11904: 0xBDF0,
	36387 - 11904: 0xE7F4,
	36388 - 11904: 0xE7F6,
	36389 - 11904: 0xE7F5,
	36390 - 11904: 0xE7FD,
	36391 - 11904: 0xE7FE,
	36392 - 11904: 0x9FF6,
	36393 - 11904: 0xBDF2,
	36394 - 11904: 0x95C8,
	36395 - 11904: 0xBDED,
	36397 - 11904: 0x9E5A,
	36398 - 11904: 0xE7F7,
	36400 - 11904: 0xEBC6,
	36401 - 11904: 0xBFE2,
	36403 - 11904: 0xEBBD,
	36404 - 11904: 0xBFE3,
	36405 - 11904: 0xBFE6,
	36406 - 11904: 0xEBC2,
	36408 - 11904: 0xEBBF,
	36409 - 11904: 0xBFE5,
	36410 - 11904: 0x99E3,
	36412 - 11904: 0xEBC3,
	36413 - 11904: 0xEBC4,
	36414 - 11904: 0xEBBE,
	36415 - 11904: 0xEBC7,
	36416 - 11904: 0xEBC0,
	36417 - 11904: 0xEBC5,
	36418 - 11904: 0xBFE4,
	36420 - 11904: 0xBFE1,
	36421 - 11904: 0xEBC1,
	36422 - 11904: 0x8A4A,
	36423 - 11904: 0xEEBF,
	36424 - 11904: 0xC1D0,
	36425 - 11904: 0xC1CE,
	36426 - 11904: 0xC1D1,
	36427 - 11904: 0xC1CF,
	36428 - 11904: 0xEEBE,
	36429 - 11904: 0xEEBB,
	36430 - 11904: 0xEEBA,
	36431 - 11904: 0x9FF1,
	36432 - 11904: 0xEEBD,
	36435 - 11904: 0xEEBC,
	36436 - 11904: 0xF145,
	36437 - 11904: 0xC2DE,
	36438 - 11904: 0xF0FB,
	36439 - 11904: 0xF0FA,
	36441 - 11904: 0xC2D9,
	36442 - 11904: 0xF141,
	36443 - 11904: 0xF140,
	36444 - 11904: 0xF0F7,
	36445 - 11904: 0xF143,
	36446 - 11904: 0xF0FC,
	36447 - 11904: 0xC2DD,
	36448 - 11904: 0xF0F9,
	36449 - 11904: 0xF142,
	36450 - 11904: 0xF0F8,
	36451 - 11904: 0xC2DA,
	36452 - 11904: 0xC2DC,
	36453 - 11904: 0xF0FD,
	36454 - 11904: 0xC2DB,
	36455 - 11904: 0xF0FE,
	36456 - 11904: 0x8AA7,
	36457 - 11904: 0xF144,
	36458 - 11904: 0xF352,
	36460 - 11904: 0xC3DE,
	36461 - 11904: 0xF34F,
	36463 - 11904: 0xF353,
	36465 - 11904: 0x99E6,
	36466 - 11904: 0xC3DB,
	36467 - 11904: 0xF351,
	36468 - 11904: 0xC3E0,
	36469 - 11904: 0x9FF7,
	36470 - 11904: 0xC3DD,
	36471 - 11904: 0x9FED,
	36472 - 11904: 0xF350,
	36474 - 11904: 0xC3DF,
	36475 - 11904: 0xF354,
	36476 - 11904: 0xC3DA,
	36478 - 11904: 0x8A5C,
	36480 - 11904: 0x9DAE,
	36481 - 11904: 0xC4BC,
	36482 - 11904: 0xC4BE,
	36484 - 11904: 0xF4D9,
	36485 - 11904: 0xC4BD,
	36486 - 11904: 0xF4D7,
	36487 - 11904: 0xC3DC,
	36488 - 11904: 0xF4D8,
	36489 - 11904: 0xC4BB,
	36490 - 11904: 0xC543,
	36491 - 11904: 0xC545,
	36492 - 11904: 0xF656,
	36493 - 11904: 0xC544,
	36494 - 11904: 0xF655,
	36496 - 11904: 0xF761,
	36497 - 11904: 0xC5AD,
	36498 - 11904: 0xF760,
	36499 - 11904: 0xC5AE,
	36500 - 11904: 0xF75E,
	36501 - 11904: 0xF75D,
	36502 - 11904: 0xF762,
	36503 - 11904: 0xF763,
	36504 - 11904: 0xF846,
	36506 - 11904: 0xF75F,
	36509 - 11904: 0xF8C6,
	36510 - 11904: 0xF8C3,
	36511 - 11904: 0xF8C4,
	36512 - 11904: 0xF8C5,
	36513 - 11904: 0xC65C,
	36515 - 11904: 0xF951,
	36516 - 11904: 0xF950,
	36517 - 11904: 0xF94F,
	36518 - 11904: 0xF970,
	36519 - 11904: 0x95C9,
	36520 - 11904: 0xF9BE,
	36521 - 11904: 0xF9AB,
	36522 - 11904: 0xC66E,
	36523 - 11904: 0xA8AD,
	36524 - 11904: 0xB060,
	36525 - 11904: 0x9048,
	36528 - 11904: 0x99E8,
	36530 - 11904: 0xB8FA,
	36534 - 11904: 0x9049,
	36537 - 11904: 0x8CBA,
	36538 - 11904: 0xBDF6,
	36540 - 11904: 0x90B1,
	36541 - 11904: 0xEBC8,
	36544 - 11904: 0xC2DF,
	36546 - 11904: 0xF355,
	36547 - 11904: 0x904A,
	36553 - 11904: 0xF9AC,
	36554 - 11904: 0xA8AE,
	36555 - 11904: 0xAAEE,
	36556 - 11904: 0xAD79,
	36557 - 11904: 0xAD78,
	36558 - 11904: 0x99EA,
	36559 - 11904: 0xB063,
	36561 - 11904: 0xD3E8,
	36562 - 11904: 0xB061,
	36563 - 11904: 0xD3E9,
	36564 - 11904: 0xB062,
	36567 - 11904: 0xD7DF,
	36568 - 11904: 0xD7DB,
	36570 - 11904: 0x9BD1,
	36571 - 11904: 0xB36D,
	36572 - 11904: 0xD7DE,
	36573 - 11904: 0xD7DD,
	36574 - 11904: 0xD7DC,
	36575 - 11904: 0xB36E,
	36576 - 11904: 0xD7E0,
	36577 - 11904: 0xD7E1,
	36578 - 11904: 0x99EB,
	36580 - 11904: 0x99EC,
	36581 - 11904: 0xDC43,
	36582 - 11904: 0xDC41,
	36583 - 11904: 0xDC45,
	36584 - 11904: 0xDC46,
	36585 - 11904: 0xDC4C,
	36587 - 11904: 0xDC48,
	36588 - 11904: 0xDC4A,
	36589 - 11904: 0x99ED,
	36590 - 11904: 0xDC42,
	36591 - 11904: 0xDBFC,
	36593 - 11904: 0xDC49,
	36594 - 11904: 0x99EE,
	36596 - 11904: 0xDC4B,
	36597 - 11904: 0xDC44,
	36598 - 11904: 0xDC47,
	36599 - 11904: 0xDBFD,
	36600 - 11904: 0xB662,
	36601 - 11904: 0xDC40,
	36602 - 11904: 0xDBFE,
	36603 - 11904: 0xB661,
	36604 - 11904: 0xB663,
	36606 - 11904: 0xB8FD,
	36607 - 11904: 0xE075,
	36608 - 11904: 0xE077,
	36609 - 11904: 0xE076,
	36610 - 11904: 0xE07B,
	36611 - 11904: 0xB8FB,
	36613 - 11904: 0xE078,
	36614 - 11904: 0xE074,
	36615 - 11904: 0xE079,
	36616 - 11904: 0xE07A,
	36617 - 11904: 0xB8FC,
	36618 - 11904: 0xB8FE,
	36619 - 11904: 0xE07C,
	36621 - 11904: 0xE467,
	36622 - 11904: 0xE466,
	36624 - 11904: 0xE464,
	36625 - 11904: 0xE465,
	36626 - 11904: 0xBBB3,
	36627 - 11904: 0xBBB5,
	36628 - 11904: 0xBBB2,
	36629 - 11904: 0xBBB4,
	36630 - 11904: 0xE84D,
	36631 - 11904: 0xE84E,
	36632 - 11904: 0xE849,
	36633 - 11904: 0x904C,
	36634 - 11904: 0xE84A,
	36635 - 11904: 0xBDF8,
	36636 - 11904: 0xBDFD,
	36637 - 11904: 0xBDF7,
	36638 - 11904: 0xBDFE,
	36639 - 11904: 0xBDF9,
	36640 - 11904: 0xE84B,
	36643 - 11904: 0xE84C,
	36644 - 11904: 0xE848,
	36645 - 11904: 0xBE40,
	36646 - 11904: 0xBDFB,
	36649 - 11904: 0xBDFA,
	36650 - 11904: 0xBDFC,
	36652 - 11904: 0xE847,
	36653 - 11904: 0x904D,
	36654 - 11904: 0xEBCA,
	36655 - 11904: 0xBFE8,
	36656 - 11904: 0x95CB,
	36658 - 11904: 0xEBCC,
	36659 - 11904: 0xBFEA,
	36660 - 11904: 0xEBCF,
	36661 - 11904: 0xEBCB,
	36662 - 11904: 0xEBC9,
	36663 - 11904: 0xEBCE,
	36664 - 11904: 0xBFE9,
	36665 - 11904: 0xEBCD,
	36667 - 11904: 0xBFE7,
	36670 - 11904: 0xC1D3,
	36671 - 11904: 0xC1D6,
	36672 - 11904: 0xEEC1,
	36673 - 11904: 0x97E2,
	36674 - 11904: 0xC1D4,
	36675 - 11904: 0xEEC0,
	36676 - 11904: 0xC1D2,
	36677 - 11904: 0xC1D5,
	36678 - 11904: 0xF146,
	36679 - 11904: 0xF147,
	36680 - 11904: 0xF148,
	36681 - 11904: 0xC2E0,
	36682 - 11904: 0x95CC,
	36683 - 11904: 0xF149,
	36685 - 11904: 0xC2E1,
	36686 - 11904: 0xC3E2,
	36687 - 11904: 0xF358,
	36688 - 11904: 0xF359,
	36689 - 11904: 0xF357,
	36690 - 11904: 0xF356,
	36691 - 11904: 0xF35A,
	36692 - 11904: 0xC3E1,
	36693 - 11904: 0xF4DD,
	36694 - 11904: 0xF4DB,
	36695 - 11904: 0xF4DC,
	36696 - 11904: 0xF4DE,
	36697 - 11904: 0xF4DA,
	36698 - 11904: 0xF4DF,
	36699 - 11904: 0xF658,
	36700 - 11904: 0x9F78,
	36701 - 11904: 0xF659,
	36702 - 11904: 0xF657,
	36703 - 11904: 0xC546,
	36704 - 11904: 0xF764,
	36705 - 11904: 0xC5AF,
	36706 - 11904: 0xF765,
	36707 - 11904: 0xF848,
	36708 - 11904: 0xF847,
	36710 - 11904: 0x897C,
	36711 - 11904: 0x897D,
	36718 - 11904: 0x897E,
	36755 - 11904: 0x995D,
	36763 - 11904: 0xA8AF,
	36764 - 11904: 0xB664,
	36767 - 11904: 0xB940,
	36768 - 11904: 0x9B5A,
	36771 - 11904: 0xBBB6,
	36773 - 11904: 0x9050,
	36774 - 11904: 0xBFEC,
	36775 - 11904: 0x8C4F,
	36776 - 11904: 0xBFEB,
	36781 - 11904: 0xC3E3,
	36782 - 11904: 0xC47C,
	36783 - 11904: 0xC547,
	36784 - 11904: 0xA8B0,
	36785 - 11904: 0xB064,
	36786 - 11904: 0xB941,
	36787 - 11904: 0x9054,
	36788 - 11904: 0xF35B,
	36789 - 11904: 0xC6D6,
	36790 - 11904: 0x9AA8,
	36791 - 11904: 0x99EF,
	36792 - 11904: 0xFEEB,
	36793 - 11904: 0x9DA3,
	36794 - 11904: 0x9DA1,
	36795 - 11904: 0x9943,
	36796 - 11904: 0x9945,
	36798 - 11904: 0x9D7D,
	36799 - 11904: 0xCBA6,
	36801 - 11904: 0x99F0,
	36802 - 11904: 0xA8B1,
	36804 - 11904: 0xA8B4,
	36805 - 11904: 0xA8B3,
	36806 - 11904: 0xA8B2,
	36809 - 11904: 0xCBA5,
	36810 - 11904: 0x99F1,
	36811 - 11904: 0xCDCD,
	36812 - 11904: 0x99F2,
	36813 - 11904: 0xCDCF,
	36814 - 11904: 0xAAEF,
	36815 - 11904: 0x8CBC,
	36816 - 11904: 0x9D60,
	36817 - 11904: 0xAAF1,
	36818 - 11904: 0xCDCC,
	36819 - 11904: 0xCDCE,
	36820 - 11904: 0xAAF0,
	36821 - 11904: 0xCDD1,
	36822 - 11904: 0xCDD0,
	36823 - 11904: 0xCDD2,
	36826 - 11904: 0xA0A3,
	36832 - 11904: 0xD0B6,
	36833 - 11904: 0xD0B4,
	36834 - 11904: 0xAD7C,
	36835 - 11904: 0xD0B3,
	36836 - 11904: 0xADA3,
	36837 - 11904: 0xAD7E,
	36838 - 11904: 0xAD7B,
	36840 - 11904: 0xADA4,
	36842 - 11904: 0xAD7D,
	36843 - 11904: 0xADA2,
	36845 - 11904: 0xADA1,
	36846 - 11904: 0xD0B5,
	36848 - 11904: 0xAD7A,
	36852 - 11904: 0xB06A,
	36853 - 11904: 0xD3EB,
	36854 - 11904: 0xD3F1,
	36855 - 11904: 0xB067,
	36856 - 11904: 0xB06E,
	36857 - 11904: 0x905B,
	36858 - 11904: 0xB069,
	36859 - 11904: 0xD3EE,
	36860 - 11904: 0xD3F0,
	36861 - 11904: 0xB06C,
	36862 - 11904: 0xD3EA,
	36863 - 11904: 0xD3ED,
	36864 - 11904: 0xB068,
	36865 - 11904: 0xB065,
	36866 - 11904: 0xD3EC,
	36867 - 11904: 0xB06B,
	36868 - 11904: 0xD3EF,
	36869 - 11904: 0xB06D,
	36870 - 11904: 0xB066,
	36872 - 11904: 0x9EDB,
	36875 - 11904: 0xD7E3,
	36876 - 11904: 0xD7E6,
	36877 - 11904: 0xB370,
	36879 - 11904: 0xB37A,
	36880 - 11904: 0xB376,
	36881 - 11904: 0xD7E4,
	36882 - 11904: 0x9D79,
	36884 - 11904: 0xB37E,
	36885 - 11904: 0xB377,
	36886 - 11904: 0xB37C,
	36887 - 11904: 0xB372,
	36889 - 11904: 0xB36F,
	36890 - 11904: 0xB371,
	36891 - 11904: 0xB37D,
	36892 - 11904: 0xD7E5,
	36893 - 11904: 0xB375,
	36894 - 11904: 0xB378,
	36895 - 11904: 0xB374,
	36896 - 11904: 0xB379,
	36897 - 11904: 0xD7E7,
	36898 - 11904: 0xB37B,
	36899 - 11904: 0xB373,
	36900 - 11904: 0xD7E2,
	36909 - 11904: 0xDC4D,
	36910 - 11904: 0xB665,
	36911 - 11904: 0xDC4F,
	36913 - 11904: 0xB667,
	36914 - 11904: 0xB669,
	36915 - 11904: 0x99F3,
	36916 - 11904: 0xDC4E,
	36917 - 11904: 0xB666,
	36918 - 11904: 0xB66A,
	36919 - 11904: 0x9062,
	36920 - 11904: 0xB668,
	36924 - 11904: 0xB947,
	36925 - 11904: 0xE0A3,
	36926 - 11904: 0xB94F,
	36927 - 11904: 0xE07E,
	36929 - 11904: 0xB950,
	36930 - 11904: 0xB945,
	36932 - 11904: 0xE0A1,
	36934 - 11904: 0x87BD,
	36935 - 11904: 0xB94A,
	36937 - 11904: 0xE0A2,
	36938 - 11904: 0xB943,
	36939 - 11904: 0xB942,
	36940 - 11904: 0x9F55,
	36941 - 11904: 0xB94D,
	36942 - 11904: 0xB94C,
	36943 - 11904: 0xB94B,
	36944 - 11904: 0xB949,
	36945 - 11904: 0xB94E,
	36946 - 11904: 0xE07D,
	36947 - 11904: 0xB944,
	36948 - 11904: 0xB946,
	36949 - 11904: 0xB948,
	36950 - 11904: 0x9BF9,
	36952 - 11904: 0xBBB8,
	36953 - 11904: 0xBBBB,
	36955 - 11904: 0xBBBF,
	36956 - 11904: 0xBBB9,
	36957 - 11904: 0xBBBE,
	36958 - 11904: 0xBBBC,
	36960 - 11904: 0xBBB7,
	36961 - 11904: 0x9065,
	36962 - 11904: 0xBBBD,
	36963 - 11904: 0xBBBA,
	36964 - 11904: 0x96E0,
	36967 - 11904: 0xE852,
	36968 - 11904: 0xBE43,
	36969 - 11904: 0xBE41,
	36971 - 11904: 0xE853,
	36972 - 11904: 0x98BE,
	36973 - 11904: 0xBE44,
	36974 - 11904: 0xBE42,
	36975 - 11904: 0xE851,
	36976 - 11904: 0xE850,
	36978 - 11904: 0xBFF0,
	36979 - 11904: 0xE84F,
	36980 - 11904: 0xBFEE,
	36981 - 11904: 0xBFED,
	36982 - 11904: 0xEBD0,
	36983 - 11904: 0xBE45,
	36984 - 11904: 0xBFEF,
	36985 - 11904: 0xEBD1,
	36986 - 11904: 0xBFF2,
	36987 - 11904: 0xEBD2,
	36988 - 11904: 0xBFF1,
	36989 - 11904: 0xC1D8,
	36990 - 11904: 0xEEC3,
	36991 - 11904: 0xC1D7,
	36992 - 11904: 0xC1DC,
	36993 - 11904: 0xC1DA,
	36994 - 11904: 0xC1DB,
	36995 - 11904: 0xC2E3,
	36996 - 11904: 0xC1D9,
	36997 - 11904: 0xEEC2,
	36998 - 11904: 0xEBD3,
	36999 - 11904: 0xC2E2,
	37000 - 11904: 0xC2E4,
	37002 - 11904: 0xC3E4,
	37003 - 11904: 0xC3E5,
	37005 - 11904: 0xF4E0,
	37007 - 11904: 0xC5DE,
	37008 - 11904: 0xC5DD,
	37009 - 11904: 0xA8B6,
	37012 - 11904: 0xCA55,
	37013 - 11904: 0xB06F,
	37015 - 11904: 0xCA52,
	37016 - 11904: 0xCA53,
	37017 - 11904: 0xCA51,
	37019 - 11904: 0xCA54,
	37022 - 11904: 0xCBAA,
	37023 - 11904: 0xCBA7,
	37024 - 11904: 0xCBAC,
	37025 - 11904: 0xCBA8,
	37026 - 11904: 0xA8B7,
	37027 - 11904: 0xA8BA,
	37029 - 11904: 0xCBA9,
	37030 - 11904: 0xA8B9,
	37031 - 11904: 0xCBAB,
	37032 - 11904: 0x9068,
	37034 - 11904: 0xA8B8,
	37038 - 11904: 0x906C,
	37039 - 11904: 0xCDD5,
	37040 - 11904: 0xCDD7,
	37041 - 11904: 0xAAF4,
	37042 - 11904: 0xCDD3,
	37043 - 11904: 0xCDD6,
	37044 - 11904: 0xCDD4,
	37045 - 11904: 0xAAF2,
	37046 - 11904: 0xAAF5,
	37048 - 11904: 0xAAF3,
	37051 - 11904: 0x95D8,
	37053 - 11904: 0xD0B8,
	37054 - 11904: 0xD0BC,
	37055 - 11904: 0xD0B9,
	37057 - 11904: 0xADA7,
	37059 - 11904: 0xADA8,
	37060 - 11904: 0x906A,
	37061 - 11904: 0xD0BB,
	37063 - 11904: 0xD0BD,
	37064 - 11904: 0xD0BF,
	37066 - 11904: 0xADA5,
	37067 - 11904: 0xD0BE,
	37070 - 11904: 0xADA6,
	37076 - 11904: 0xD7EE,
	37077 - 11904: 0xD0BA,
	37078 - 11904: 0xD3F2,
	37079 - 11904: 0xD3FB,
	37080 - 11904: 0xD3F9,
	37081 - 11904: 0xD3F4,
	37082 - 11904: 0xD3F5,
	37083 - 11904: 0xD3FA,
	37084 - 11904: 0xD3FC,
	37085 - 11904: 0xB071,
	37087 - 11904: 0xD3F7,
	37088 - 11904: 0xD3F3,
	37089 - 11904: 0xB070,
	37090 - 11904: 0xB072,
	37091 - 11904: 0xD3F6,
	37092 - 11904: 0xD3FD,
	37093 - 11904: 0xD3F8,
	37096 - 11904: 0xB3A1,
	37097 - 11904: 0xD7F1,
	37098 - 11904: 0xD7E9,
	37099 - 11904: 0xD7EF,
	37100 - 11904: 0xD7F0,
	37101 - 11904: 0xB3A2,
	37103 - 11904: 0xD7E8,
	37104 - 11904: 0xD7EA,
	37105 - 11904: 0xD0B7,
	37106 - 11904: 0xD7EC,
	37107 - 11904: 0xD7ED,
	37108 - 11904: 0xD7EB,
	37109 - 11904: 0xB66C,
	37113 - 11904: 0xDC56,
	37114 - 11904: 0xEBD4,
	37115 - 11904: 0xDC57,
	37116 - 11904: 0xDC54,
	37117 - 11904: 0xB3A3,
	37118 - 11904: 0xB66E,
	37119 - 11904: 0xDC53,
	37120 - 11904: 0xDC59,
	37121 - 11904: 0xDC58,
	37122 - 11904: 0xB66B,
	37123 - 11904: 0xDC5C,
	37124 - 11904: 0xDC52,
	37125 - 11904: 0xDC5B,
	37126 - 11904: 0xDC50,
	37127 - 11904: 0xDC5A,
	37128 - 11904: 0xDC55,
	37129 - 11904: 0xB66D,
	37131 - 11904: 0xE0AA,
	37133 - 11904: 0xE0A5,
	37134 - 11904: 0xE0AB,
	37135 - 11904: 0xE0A6,
	37136 - 11904: 0xE0A4,
	37137 - 11904: 0xE0A7,
	37138 - 11904: 0xB951,
	37140 - 11904: 0xE0A9,
	37142 - 11904: 0xE0A8,
	37143 - 11904: 0xB952,
	37144 - 11904: 0xBBC1,
	37145 - 11904: 0xBBC0,
	37146 - 11904: 0xE46E,
	37147 - 11904: 0xE471,
	37148 - 11904: 0xE469,
	37149 - 11904: 0xE46D,
	37150 - 11904: 0xBBC2,
	37151 - 11904: 0xE46C,
	37152 - 11904: 0xE46A,
	37153 - 11904: 0xE470,
	37154 - 11904: 0xE46B,
	37155 - 11904: 0xE468,
	37156 - 11904: 0xE46F,
	37158 - 11904: 0xE859,
	37159 - 11904: 0xBE48,
	37160 - 11904: 0xF14A,
	37161 - 11904: 0xE856,
	37162 - 11904: 0xE857,
	37163 - 11904: 0xE855,
	37164 - 11904: 0xDC51,
	37165 - 11904: 0xBE47,
	37166 - 11904: 0xE85A,
	37167 - 11904: 0xE854,
	37168 - 11904: 0xBE46,
	37169 - 11904: 0xBE49,
	37170 - 11904: 0xE858,
	37171 - 11904: 0xEBD5,
	37172 - 11904: 0xBFF3,
	37173 - 11904: 0xEBD6,
	37174 - 11904: 0xEBD7,
	37176 - 11904: 0xEEC4,
	37177 - 11904: 0xC1DD,
	37178 - 11904: 0xF14B,
	37179 - 11904: 0xF14C,
	37182 - 11904: 0xF14D,
	37183 - 11904: 0xF35D,
	37184 - 11904: 0xF35C,
	37185 - 11904: 0xF4E2,
	37187 - 11904: 0xF4E1,
	37188 - 11904: 0xF65B,
	37189 - 11904: 0xF65C,
	37190 - 11904: 0xF65A,
	37191 - 11904: 0xF766,
	37192 - 11904: 0xC5B0,
	37193 - 11904: 0xA8BB,
	37194 - 11904: 0xADAA,
	37195 - 11904: 0xADA9,
	37196 - 11904: 0xB075,
	37197 - 11904: 0xB074,
	37198 - 11904: 0xD440,
	37199 - 11904: 0xD441,
	37200 - 11904: 0xD3FE,
	37201 - 11904: 0x9FB2,
	37202 - 11904: 0xB073,
	37203 - 11904: 0xD7F5,
	37205 - 11904: 0xD7F6,
	37206 - 11904: 0xD7F2,
	37207 - 11904: 0xB3A4,
	37208 - 11904: 0xD7F3,
	37209 - 11904: 0x9FAE,
	37210 - 11904: 0xD7F4,
	37212 - 11904: 0x9FB0,
	37214 - 11904: 0x89AD,
	37215 - 11904: 0xDC5F,
	37216 - 11904: 0xDC61,
	37217 - 11904: 0xDC5D,
	37218 - 11904: 0xDC60,
	37219 - 11904: 0xB66F,
	37220 - 11904: 0xDC5E,
	37221 - 11904: 0xB670,
	37223 - 11904: 0x906E,
	37224 - 11904: 0xDD73,
	37225 - 11904: 0xB955,
	37226 - 11904: 0xB954,
	37228 - 11904: 0xB953,
	37230 - 11904: 0xE0AC,
	37231 - 11904: 0xE0AD,
	37232 - 11904: 0x9E71,
	37234 - 11904: 0xE473,
	37235 - 11904: 0xE475,
	37236 - 11904: 0xBBC6,
	37237 - 11904: 0xBBC3,
	37238 - 11904: 0x9E4A,
	37239 - 11904: 0xBBC5,
	37240 - 11904: 0xBBC4,
	37241 - 11904: 0xE474,
	37242 - 11904: 0xE472,
	37244 - 11904: 0x9FDC,
	37248 - 11904: 0xE861,
	37249 - 11904: 0xE85E,
	37250 - 11904: 0xE85F,
	37251 - 11904: 0xBE4D,
	37252 - 11904: 0xE860,
	37253 - 11904: 0xE85B,
	37254 - 11904: 0xE85C,
	37255 - 11904: 0xBE4A,
	37257 - 11904: 0xBE4B,
	37258 - 11904: 0xE85D,
	37259 - 11904: 0xBE4C,
	37260 - 11904: 0x89AB,
	37261 - 11904: 0xEBDB,
	37262 - 11904: 0x9FB8,
	37263 - 11904: 0xEBDC,
	37264 - 11904: 0xEBD9,
	37265 - 11904: 0xEBDA,
	37266 - 11904: 0xBFF4,
	37267 - 11904: 0xEBD8,
	37273 - 11904: 0xEEC8,
	37274 - 11904: 0xEEC5,
	37275 - 11904: 0xEEC7,
	37276 - 11904: 0xC1E0,
	37277 - 11904: 0xEECB,
	37278 - 11904: 0xC1DF,
	37279 - 11904: 0xEEC9,
	37280 - 11904: 0xEECC,
	37281 - 11904: 0xEECA,
	37282 - 11904: 0xEEC6,
	37283 - 11904: 0xC1DE,
	37285 - 11904: 0xF14F,
	37287 - 11904: 0xF150,
	37288 - 11904: 0xF14E,
	37289 - 11904: 0x9070,
	37290 - 11904: 0xF152,
	37291 - 11904: 0xC2E5,
	37292 - 11904: 0xC2E6,
	37293 - 11904: 0xF35F,
	37294 - 11904: 0xC3E7,
	37295 - 11904: 0xF151,
	37296 - 11904: 0xF35E,
	37297 - 11904: 0xC3E6,
	37298 - 11904: 0xF4E5,
	37299 - 11904: 0xF4E6,
	37300 - 11904: 0xC4BF,
	37301 - 11904: 0xF4E4,
	37302 - 11904: 0x8B63,
	37303 - 11904: 0xF4E3,
	37305 - 11904: 0xF65D,
	37306 - 11904: 0xC548,
	37307 - 11904: 0x95DC,
	37308 - 11904: 0xF849,
	37309 - 11904: 0xF8C8,
	37310 - 11904: 0xF8C7,
	37312 - 11904: 0xC643,
	37313 - 11904: 0xC65D,
	37314 - 11904: 0xF8C9,
	37315 - 11904: 0xF971,
	37316 - 11904: 0x9071,
	37317 - 11904: 0xC66F,
	37318 - 11904: 0xA8BC,
	37319 - 11904: 0xAAF6,
	37321 - 11904: 0xB956,
	37323 - 11904: 0xC4C0,
	37324 - 11904: 0xA8BD,
	37325 - 11904: 0xADAB,
	37326 - 11904: 0xB3A5,
	37327 - 11904: 0xB671,
	37328 - 11904: 0xC2E7,
	37329 - 11904: 0xAAF7,
	37331 - 11904: 0xD0C1,
	37332 - 11904: 0xD0C0,
	37333 - 11904: 0xD442,
	37334 - 11904: 0xFC5E,
	37335 - 11904: 0xB078,
	37336 - 11904: 0xB076,
	37337 - 11904: 0xB07A,
	37338 - 11904: 0xD444,
	37340 - 11904: 0xB079,
	37341 - 11904: 0xB077,
	37343 - 11904: 0x8949,
	37346 - 11904: 0xD443,
	37347 - 11904: 0xB3A8,
	37348 - 11904: 0xD7FC,
	37349 - 11904: 0x965B,
	37350 - 11904: 0xB3A7,
	37351 - 11904: 0xB3A9,
	37352 - 11904: 0xD842,
	37353 - 11904: 0xB3AB,
	37354 - 11904: 0xD7FE,
	37355 - 11904: 0xD840,
	37356 - 11904: 0xD7F7,
	37357 - 11904: 0xB3AA,
	37358 - 11904: 0xD843,
	37361 - 11904: 0xD7F9,
	37363 - 11904: 0xD7FA,
	37364 - 11904: 0xD7F8,
	37365 - 11904: 0xB3A6,
	37366 - 11904: 0x8C50,
	37367 - 11904: 0xD841,
	37368 - 11904: 0xD7FB,
	37369 - 11904: 0xD7FD,
	37370 - 11904: 0x94A6,
	37373 - 11904: 0xDC6D,
	37374 - 11904: 0x8FD5,
	37375 - 11904: 0xDC6C,
	37376 - 11904: 0xDC6A,
	37377 - 11904: 0xDC62,
	37378 - 11904: 0xDC71,
	37379 - 11904: 0xDC65,
	37380 - 11904: 0xDC6F,
	37381 - 11904: 0xDC76,
	37382 - 11904: 0xDC6E,
	37383 - 11904: 0xB679,
	37384 - 11904: 0x9E73,
	37385 - 11904: 0xB675,
	37386 - 11904: 0xDC63,
	37388 - 11904: 0xDC69,
	37389 - 11904: 0xB677,
	37390 - 11904: 0x9075,
	37391 - 11904: 0xDC68,
	37392 - 11904: 0xB678,
	37393 - 11904: 0xB67A,
	37394 - 11904: 0xDC6B,
	37395 - 11904: 0x99F7,
	37396 - 11904: 0xB672,
	37397 - 11904: 0xB673,
	37398 - 11904: 0xDC77,
	37399 - 11904: 0xDC75,
	37400 - 11904: 0x87B2,
	37401 - 11904: 0xDC74,
	37402 - 11904: 0xDC66,
	37404 - 11904: 0xDC72,
	37406 - 11904: 0xB676,
	37409 - 11904: 0x8CBF,
	37411 - 11904: 0xB674,
	37412 - 11904: 0xDC73,
	37413 - 11904: 0xDC64,
	37414 - 11904: 0xDC67,
	37415 - 11904: 0xDC70,
	37416 - 11904: 0x99F9,
	37418 - 11904: 0x9663,
	37419 - 11904: 0x95B9,
	37421 - 11904: 0xE4BA,
	37422 - 11904: 0xE0B7,
	37424 - 11904: 0xE0B0,
	37425 - 11904: 0xE0C3,
	37426 - 11904: 0xE0CC,
	37427 - 11904: 0xE0B3,
	37428 - 11904: 0xB961,
	37429 - 11904: 0x94D4,
	37430 - 11904: 0xE0C0,
	37431 - 11904: 0xB957,
	37432 - 11904: 0xB959,
	37433 - 11904: 0xB965,
	37434 - 11904: 0xE0B1,
	37436 - 11904: 0xFCFA,
	37437 - 11904: 0xB95A,
	37438 - 11904: 0xB95C,
	37439 - 11904: 0xB966,
	37440 - 11904: 0xB95B,
	37441 - 11904: 0x9077,
	37444 - 11904: 0x90AB,
	37445 - 11904: 0xB964,
	37446 - 11904: 0xE0B9,
	37448 - 11904: 0xE0AE,
	37449 - 11904: 0xB962,
	37450 - 11904: 0xE0B8,
	37451 - 11904: 0xB95E,
	37452 - 11904: 0xE0CA,
	37453 - 11904: 0xB963,
	37454 - 11904: 0xE0C8,
	37455 - 11904: 0xE0BC,
	37456 - 11904: 0xE0C6,
	37457 - 11904: 0xB960,
	37458 - 11904: 0xE0AF,
	37459 - 11904: 0xE0C9,
	37460 - 11904: 0xE0C4,
	37461 - 11904: 0x9D4D,
	37462 - 11904: 0xE0CB,
	37463 - 11904: 0xB958,
	37464 - 11904: 0x99FA,
	37466 - 11904: 0xB967,
	37467 - 11904: 0xB95D,
	37469 - 11904: 0x92E3,
	37470 - 11904: 0xE0B5,
	37471 - 11904: 0x97BB,
	37472 - 11904: 0xE0BD,
	37473 - 11904: 0xE0C1,
	37474 - 11904: 0x9078,
	37475 - 11904: 0xE0C5,
	37476 - 11904: 0xB95F,
	37477 - 11904: 0xE0B4,
	37478 - 11904: 0xE0B2,
	37479 - 11904: 0xE0BE,
	37483 - 11904: 0x99FB,
	37484 - 11904: 0xE0BB,
	37485 - 11904: 0xE0BA,
	37486 - 11904: 0x97E0,
	37487 - 11904: 0xE0BF,
	37488 - 11904: 0xE0C2,
	37490 - 11904: 0xE0C7,
	37494 - 11904: 0xE478,
	37495 - 11904: 0x96DC,
	37496 - 11904: 0xBBC7,
	37497 - 11904: 0xE4A4,
	37498 - 11904: 0xE47A,
	37499 - 11904: 0xBBCC,
	37500 - 11904: 0xBBD0,
	37501 - 11904: 0xE4AD,
	37502 - 11904: 0xE4B5,
	37503 - 11904: 0xE4A6,
	37504 - 11904: 0xBBC8,
	37505 - 11904: 0x9CA8,
	37506 - 11904: 0xE4AA,
	37507 - 11904: 0xE0B6,
	37508 - 11904: 0x9772,
	37509 - 11904: 0xBBC9,
	37510 - 11904: 0xE4B1,
	37511 - 11904: 0xE4B6,
	37512 - 11904: 0xE4AE,
	37513 - 11904: 0x9440,
	37514 - 11904: 0xE4B0,
	37515 - 11904: 0xE4B9,
	37516 - 11904: 0xE4B2,
	37517 - 11904: 0xE47E,
	37518 - 11904: 0xE4A9,
	37519 - 11904: 0x92F2,
	37521 - 11904: 0xBBD1,
	37523 - 11904: 0xBBCD,
	37524 - 11904: 0xE47C,
	37525 - 11904: 0xE4AB,
	37526 - 11904: 0xBBCB,
	37527 - 11904: 0xE4A5,
	37528 - 11904: 0xBBCA,
	37529 - 11904: 0xE4B3,
	37530 - 11904: 0xE4A2,
	37531 - 11904: 0xE479,
	37532 - 11904: 0xBBCE,
	37533 - 11904: 0xE4B8,
	37536 - 11904: 0xE47B,
	37537 - 11904: 0xE4AF,
	37538 - 11904: 0xE4AC,
	37539 - 11904: 0xE4A7,
	37540 - 11904: 0xE477,
	37541 - 11904: 0xE476,
	37542 - 11904: 0xE4A1,
	37543 - 11904: 0xE4B4,
	37544 - 11904: 0xBBCF,
	37545 - 11904: 0xE4B7,
	37546 - 11904: 0xE47D,
	37547 - 11904: 0xE4A3,
	37548 - 11904: 0xBE52,
	37550 - 11904: 0x99FD,
	37553 - 11904: 0x99FC,
	37554 - 11904: 0xBE5A,
	37555 - 11904: 0xBE55,
	37556 - 11904: 0xE8A4,
	37557 - 11904: 0xE8A1,
	37558 - 11904: 0xE867,
	37559 - 11904: 0xBE50,
	37561 - 11904: 0xF9D7,
	37562 - 11904: 0x964A,
	37563 - 11904: 0xBE4F,
	37564 - 11904: 0xBE56,
	37566 - 11904: 0x96D8,
	37567 - 11904: 0x99FE,
	37568 - 11904: 0xE865,
	37569 - 11904: 0xBE54,
	37570 - 11904: 0xE871,
	37571 - 11904: 0xE863,
	37572 - 11904: 0xE864,
	37573 - 11904: 0xBE4E,
	37574 - 11904: 0xE8A3,
	37575 - 11904: 0xBE58,
	37576 - 11904: 0xE874,
	37577 - 11904: 0xE879,
	37578 - 11904: 0xE873,
	37579 - 11904: 0xEBEE,
	37580 - 11904: 0xE86F,
	37581 - 11904: 0xE877,
	37582 - 11904: 0xE875,
	37583 - 11904: 0xE868,
	37584 - 11904: 0xE862,
	37585 - 11904: 0xE87D,
	37586 - 11904: 0xBE57,
	37587 - 11904: 0xE87E,
	37588 - 11904: 0x904B,
	37589 - 11904: 0xE878,
	37591 - 11904: 0xE86D,
	37592 - 11904: 0xE86B,
	37593 - 11904: 0xE866,
	37595 - 11904: 0xFA41,
	37597 - 11904: 0xE86E,
	37598 - 11904: 0xE87B,
	37599 - 11904: 0xE86A,
	37600 - 11904: 0xE87A,
	37601 - 11904: 0xE8A2,
	37603 - 11904: 0x9A40,
	37604 - 11904: 0xBE53,
	37605 - 11904: 0x975B,
	37606 - 11904: 0xE876,
	37607 - 11904: 0xE87C,
	37608 - 11904: 0xE872,
	37609 - 11904: 0xE86C,
	37610 - 11904: 0xBE51,
	37611 - 11904: 0x9A41,
	37612 - 11904: 0x91DD,
	37614 - 11904: 0xE4A8,
	37615 - 11904: 0xE870,
	37616 - 11904: 0xBE59,
	37617 - 11904: 0xE869,
	37618 - 11904: 0x93FC,
	37619 - 11904: 0x9A42,
	37620 - 11904: 0x9A43,
	37622 - 11904: 0x9659,
	37623 - 11904: 0xEBF4,
	37624 - 11904: 0xBFF7,
	37625 - 11904: 0xEBF3,
	37626 - 11904: 0xEBF0,
	37627 - 11904: 0xEC44,
	37628 - 11904: 0xBFFB,
	37629 - 11904: 0x9A44,
	37630 - 11904: 0xEC41,
	37631 - 11904: 0xEBF8,
	37632 - 11904: 0xEC43,
	37633 - 11904: 0xEBE9,
	37634 - 11904: 0xEBF6,
	37635 - 11904: 0x9051,
	37636 - 11904: 0xBFFD,
	37638 - 11904: 0xEBE1,
	37639 - 11904: 0x94BF,
	37640 - 11904: 0xEBDF,
	37641 - 11904: 0xEC42,
	37643 - 11904: 0xEC40,
	37644 - 11904: 0xEBFE,
	37645 - 11904: 0xEBED,
	37646 - 11904: 0xEBEC,
	37647 - 11904: 0xEBE2,
	37648 - 11904: 0xC040,
	37650 - 11904: 0xEBE8,
	37651 - 11904: 0xEBF2,
	37652 - 11904: 0xEBFD,
	37653 - 11904: 0xC043,
	37654 - 11904: 0xEC45,
	37656 - 11904: 0xC1E8,
	37657 - 11904: 0xC045,
	37658 - 11904: 0xBFFE,
	37659 - 11904: 0xEBE6,
	37661 - 11904: 0xEBEF,
	37662 - 11904: 0xEBDE,
	37663 - 11904: 0xEBE0,
	37664 - 11904: 0xBFF5,
	37665 - 11904: 0xC042,
	37666 - 11904: 0xBFFA,
	37667 - 11904: 0xEBE7,
	37668 - 11904: 0xEBF7,
	37669 - 11904: 0xEBF1,
	37670 - 11904: 0xC041,
	37671 - 11904: 0xEBDD,
	37672 - 11904: 0xC1E3,
	37673 - 11904: 0xEBF9,
	37674 - 11904: 0xEBFC,
	37675 - 11904: 0xBFFC,
	37676 - 11904: 0x90A2,
	37677 - 11904: 0xEBEB,
	37678 - 11904: 0xC044,
	37679 - 11904: 0xBFF9,
	37680 - 11904: 0x9CAB,
	37681 - 11904: 0x9776,
	37683 - 11904: 0xBFF8,
	37684 - 11904: 0xEBF5,
	37685 - 11904: 0xEBFB,
	37686 - 11904: 0xBFF6,
	37688 - 11904: 0xEBE4,
	37689 - 11904: 0xEBFA,
	37692 - 11904: 0xEBE5,
	37696 - 11904: 0xFC55,
	37697 - 11904: 0xFE45,
	37698 - 11904: 0x94A8,
	37699 - 11904: 0x9A45,
	37700 - 11904: 0xFA4B,
	37701 - 11904: 0x9DE1,
	37702 - 11904: 0xEBEA,
	37703 - 11904: 0xEED2,
	37704 - 11904: 0x96D9,
	37705 - 11904: 0xEED7,
	37706 - 11904: 0xC1E5,
	37707 - 11904: 0xC1E7,
	37708 - 11904: 0xEEDD,
	37709 - 11904: 0xC1E1,
	37710 - 11904: 0xEEEC,
	37711 - 11904: 0xEEE3,
	37712 - 11904: 0xEED8,
	37713 - 11904: 0xEED9,
	37714 - 11904: 0xEEE2,
	37716 - 11904: 0xC1EE,
	37717 - 11904: 0xEEE1,
	37718 - 11904: 0xEED1,
	37719 - 11904: 0xEEE0,
	37720 - 11904: 0xEED4,
	37721 - 11904: 0xEEED,
	37722 - 11904: 0xC1ED,
	37723 - 11904: 0xC1EB,
	37724 - 11904: 0xEED5,
	37726 - 11904: 0xEEE8,
	37727 - 11904: 0x9774,
	37728 - 11904: 0xEEDA,
	37729 - 11904: 0xEEE7,
	37730 - 11904: 0xFDF5,
	37731 - 11904: 0xEEE9,
	37732 - 11904: 0xEED0,
	37733 - 11904: 0xC1E6,
	37734 - 11904: 0x92E5,
	37735 - 11904: 0xEEEA,
	37736 - 11904: 0x9645,
	37737 - 11904: 0x91DA,
	37738 - 11904: 0xEEDE,
	37739 - 11904: 0x90A3,
	37740 - 11904: 0xC1EA,
	37741 - 11904: 0xEEDB,
	37742 - 11904: 0xA05F,
	37744 - 11904: 0xC1EC,
	37745 - 11904: 0xEEE4,
	37747 - 11904: 0x90AF,
	37748 - 11904: 0x97BF,
	37749 - 11904: 0xC1E4,
	37750 - 11904: 0xEED6,
	37751 - 11904: 0xEEE5,
	37752 - 11904: 0x914C,
	37753 - 11904: 0xEEDF,
	37754 - 11904: 0xEBE3,
	37755 - 11904: 0xEEE6,
	37756 - 11904: 0xEED3,
	37757 - 11904: 0x967A,
	37758 - 11904: 0xC1E9,
	37760 - 11904: 0xEEEB,
	37761 - 11904: 0x91DE,
	37762 - 11904: 0xC1E2,
	37763 - 11904: 0xEECE,
	37764 - 11904: 0x9A46,
	37765 - 11904: 0xFEB0,
	37766 - 11904: 0x9779,
	37767 - 11904: 0x946C,
	37768 - 11904: 0xF160,
	37769 - 11904: 0xF159,
	37770 - 11904: 0xC2E9,
	37772 - 11904: 0xF154,
	37773 - 11904: 0xF163,
	37774 - 11904: 0xF15B,
	37775 - 11904: 0xEEDC,
	37776 - 11904: 0x9858,
	37777 - 11904: 0xF165,
	37778 - 11904: 0xF155,
	37780 - 11904: 0xC2E8,
	37781 - 11904: 0xF15F,
	37782 - 11904: 0xC2EA,
	37783 - 11904: 0xC2F2,
	37784 - 11904: 0xC2F0,
	37785 - 11904: 0xF161,
	37786 - 11904: 0xC2F1,
	37787 - 11904: 0xF157,
	37788 - 11904: 0x9266,
	37789 - 11904: 0xF158,
	37790 - 11904: 0xF15D,
	37791 - 11904: 0xF162,
	37792 - 11904: 0x93FB,
	37793 - 11904: 0xEECD,
	37794 - 11904: 0xC2EB,
	37795 - 11904: 0xF16A,
	37796 - 11904: 0xF167,
	37797 - 11904: 0xF16B,
	37798 - 11904: 0xF15E,
	37799 - 11904: 0xF15A,
	37800 - 11904: 0xF168,
	37801 - 11904: 0xF36A,
	37802 - 11904: 0xF15C,
	37804 - 11904: 0xC2EE,
	37805 - 11904: 0x9A47,
	37806 - 11904: 0xC2ED,
	37807 - 11904: 0xEECF,
	37808 - 11904: 0xC2EF,
	37809 - 11904: 0xF164,
	37810 - 11904: 0xF166,
	37811 - 11904: 0xC2EC,
	37812 - 11904: 0xF169,
	37813 - 11904: 0xF153,
	37815 - 11904: 0xF156,
	37816 - 11904: 0x9749,
	37819 - 11904: 0x9748,
	37821 - 11904: 0x934A,
	37823 - 11904: 0x9CE2,
	37824 - 11904: 0xF373,
	37826 - 11904: 0xF363,
	37827 - 11904: 0xC3EB,
	37828 - 11904: 0xF371,
	37830 - 11904: 0x9264,
	37831 - 11904: 0xF361,
	37832 - 11904: 0xC3EC,
	37834 - 11904: 0xF36C,
	37835 - 11904: 0x91DF,
	37836 - 11904: 0xF368,
	37837 - 11904: 0xC3F1,
	37838 - 11904: 0xF372,
	37839 - 11904: 0xF362,
	37840 - 11904: 0xF365,
	37841 - 11904: 0xC3E9,
	37842 - 11904: 0xF374,
	37843 - 11904: 0xFB79,
	37844 - 11904: 0xF36D,
	37845 - 11904: 0xF370,
	37846 - 11904: 0xC3EF,
	37847 - 11904: 0xC3F4,
	37848 - 11904: 0xC3F2,
	37849 - 11904: 0xF369,
	37850 - 11904: 0xF364,
	37851 - 11904: 0x96D7,
	37852 - 11904: 0xC3ED,
	37853 - 11904: 0xC3EE,
	37854 - 11904: 0xF360,
	37855 - 11904: 0xC3EA,
	37856 - 11904: 0x9343,
	37857 - 11904: 0xC3E8,
	37858 - 11904: 0xC3F0,
	37859 - 11904: 0xF36F,
	37860 - 11904: 0xC3F3,
	37862 - 11904: 0xF36B,
	37863 - 11904: 0xF375,
	37864 - 11904: 0xC3F5,
	37868 - 11904: 0xF367,
	37870 - 11904: 0xF36E,
	37872 - 11904: 0xFDCB,
	37873 - 11904: 0xFE7A,
	37875 - 11904: 0x91DB,
	37876 - 11904: 0x8C6A,
	37877 - 11904: 0xF4F3,
	37878 - 11904: 0xF542,
	37879 - 11904: 0xF4F5,
	37880 - 11904: 0xF4FC,
	37881 - 11904: 0xF366,
	37882 - 11904: 0xF4FA,
	37883 - 11904: 0xF4E9,
	37884 - 11904: 0xF540,
	37885 - 11904: 0xC4C3,
	37886 - 11904: 0xF4ED,
	37887 - 11904: 0xF4FE,
	37888 - 11904: 0xF4F4,
	37889 - 11904: 0x97AF,
	37891 - 11904: 0xC4C2,
	37892 - 11904: 0x95DD,
	37894 - 11904: 0xF544,
	37895 - 11904: 0xF4F6,
	37896 - 11904: 0x9348,
	37897 - 11904: 0xF4FB,
	37898 - 11904: 0xF4FD,
	37899 - 11904: 0xF4E7,
	37900 - 11904: 0xF541,
	37901 - 11904: 0xF4F2,
	37902 - 11904: 0xF4F7,
	37903 - 11904: 0xF4EB,
	37904 - 11904: 0xF4EF,
	37905 - 11904: 0xF543,
	37906 - 11904: 0xF4F9,
	37907 - 11904: 0xF4E8,
	37908 - 11904: 0xF4EC,
	37909 - 11904: 0xF4EE,
	37910 - 11904: 0xF4F8,
	37911 - 11904: 0x9A4B,
	37912 - 11904: 0xC4C1,
	37913 - 11904: 0xF4F1,
	37915 - 11904: 0xFC45,
	37917 - 11904: 0x9A4D,
	37920 - 11904: 0xF4EA,
	37924 - 11904: 0x91BC,
	37925 - 11904: 0x90E2,
	37926 - 11904: 0x90B4,
	37927 - 11904: 0x95E1,
	37928 - 11904: 0xF4F0,
	37929 - 11904: 0xF661,
	37930 - 11904: 0xF666,
	37931 - 11904: 0xC54F,
	37932 - 11904: 0xF668,
	37933 - 11904: 0x9A4E,
	37934 - 11904: 0xC549,
	37935 - 11904: 0x87AD,
	37936 - 11904: 0xF664,
	37937 - 11904: 0xF66A,
	37938 - 11904: 0xC54E,
	37939 - 11904: 0xC54A,
	37941 - 11904: 0xC54B,
	37942 - 11904: 0xF660,
	37943 - 11904: 0xF667,
	37944 - 11904: 0xC54D,
	37945 - 11904: 0xF665,
	37946 - 11904: 0xC54C,
	37947 - 11904: 0xF65F,
	37948 - 11904: 0xF663,
	37949 - 11904: 0xF662,
	37950 - 11904: 0x9A4F,
	37951 - 11904: 0xF65E,
	37952 - 11904: 0xF669,
	37954 - 11904: 0xFE40,
	37955 - 11904: 0xFE43,
	37956 - 11904: 0xC5B1,
	37957 - 11904: 0xF76D,
	37958 - 11904: 0xF770,
	37959 - 11904: 0xF76C,
	37960 - 11904: 0xF76E,
	37961 - 11904: 0xF76F,
	37962 - 11904: 0xF769,
	37963 - 11904: 0xF76A,
	37964 - 11904: 0xF767,
	37965 - 11904: 0x96DD,
	37967 - 11904: 0xF76B,
	37968 - 11904: 0xF768,
	37969 - 11904: 0xC5B2,
	37970 - 11904: 0xC5B3,
	37972 - 11904: 0x9A51,
	37973 - 11904: 0xF84B,
	37975 - 11904: 0xF84D,
	37976 - 11904: 0x96A7,
	37979 - 11904: 0x90B0,
	37981 - 11904: 0xF84C,
	37982 - 11904: 0xF84E,
	37984 - 11904: 0xC5E0,
	37986 - 11904: 0xF84A,
	37987 - 11904: 0xC5DF,
	37988 - 11904: 0xC5E1,
	37989 - 11904: 0x9C4E,
	37991 - 11904: 0x9443,
	37992 - 11904: 0xF8CB,
	37993 - 11904: 0xF8CC,
	37994 - 11904: 0xC644,
	37995 - 11904: 0xF8CA,
	37996 - 11904: 0x8EBA,
	37997 - 11904: 0xF953,
	37998 - 11904: 0xF952,
	37999 - 11904: 0xF954,
	38000 - 11904: 0xC65F,
	38001 - 11904: 0xF955,
	38002 - 11904: 0xC65E,
	38003 - 11904: 0xF956,
	38004 - 11904: 0xF972,
	38005 - 11904: 0xF975,
	38006 - 11904: 0xF974,
	38007 - 11904: 0xC668,
	38008 - 11904: 0xF973,
	38009 - 11904: 0x9A52,
	38011 - 11904: 0xFCC1,
	38012 - 11904: 0xC672,
	38013 - 11904: 0xC670,
	38014 - 11904: 0xC671,
	38015 - 11904: 0xC677,
	38016 - 11904: 0xF9C0,
	38017 - 11904: 0xF9C1,
	38018 - 11904: 0xF9BF,
	38019 - 11904: 0xF9C9,
	38021 - 11904: 0x8BE9,
	38047 - 11904: 0x9CAF,
	38050 - 11904: 0x8BFD,
	38081 - 11904: 0x9ABC,
	38083 - 11904: 0x9AB8,
	38108 - 11904: 0x9AAE,
	38134 - 11904: 0x9AA7,
	38189 - 11904: 0x9A53,
	38215 - 11904: 0x9D74,
	38263 - 11904: 0xAAF8,
	38264 - 11904: 0x8BEA,
	38266 - 11904: 0xD844,
	38267 - 11904: 0xDC78,
	38268 - 11904: 0xE8A5,
	38269 - 11904: 0xF376,
	38271 - 11904: 0x8BEB,
	38272 - 11904: 0xAAF9,
	38274 - 11904: 0xADAC,
	38275 - 11904: 0xB07B,
	38277 - 11904: 0x90B2,
	38278 - 11904: 0xD845,
	38280 - 11904: 0xD846,
	38281 - 11904: 0xB3AC,
	38283 - 11904: 0xB67D,
	38284 - 11904: 0xDC7A,
	38285 - 11904: 0xDC79,
	38286 - 11904: 0xB6A3,
	38287 - 11904: 0xB67C,
	38288 - 11904: 0xDC7B,
	38289 - 11904: 0xB67E,
	38290 - 11904: 0xB6A2,
	38291 - 11904: 0xB6A1,
	38292 - 11904: 0xB67B,
	38294 - 11904: 0x95E9,
	38295 - 11904: 0x95E8,
	38296 - 11904: 0xB968,
	38297 - 11904: 0x95E6,
	38299 - 11904: 0xE0D0,
	38300 - 11904: 0xE0CE,
	38302 - 11904: 0xE0CF,
	38303 - 11904: 0xE0CD,
	38304 - 11904: 0x90B5,
	38305 - 11904: 0xBBD2,
	38306 - 11904: 0x9A54,
	38307 - 11904: 0xBBD5,
	38308 - 11904: 0xBBD7,
	38309 - 11904: 0xBBD6,
	38310 - 11904: 0x90B3,
	38311 - 11904: 0x95E7,
	38312 - 11904: 0xBBD3,
	38313 - 11904: 0xBBD4,
	38314 - 11904: 0x8B50,
	38315 - 11904: 0xE8A7,
	38316 - 11904: 0xE8A6,
	38317 - 11904: 0xBE5B,
	38318 - 11904: 0xE8A8,
	38320 - 11904: 0xE8A9,
	38321 - 11904: 0xBE5C,
	38325 - 11904: 0xEC4D,
	38326 - 11904: 0xEC4B,
	38327 - 11904: 0xEEF3,
	38329 - 11904: 0xEC49,
	38330 - 11904: 0xEC4A,
	38331 - 11904: 0xC046,
	38332 - 11904: 0xEC46,
	38333 - 11904: 0xEC4E,
	38334 - 11904: 0xEC48,
	38335 - 11904: 0xEC4C,
	38336 - 11904: 0xEEEF,
	38339 - 11904: 0xEEF1,
	38341 - 11904: 0xEEF2,
	38342 - 11904: 0xC1F3,
	38343 - 11904: 0xEEEE,
	38344 - 11904: 0xC1F2,
	38345 - 11904: 0xEEF0,
	38346 - 11904: 0xC1EF,
	38347 - 11904: 0xC1F0,
	38348 - 11904: 0xC1F1,
	38349 - 11904: 0xEC47,
	38352 - 11904: 0xC2F5,
	38353 - 11904: 0xF16E,
	38354 - 11904: 0xF16C,
	38355 - 11904: 0xF16D,
	38356 - 11904: 0xC2F3,
	38357 - 11904: 0xC2F6,
	38358 - 11904: 0xC2F4,
	38362 - 11904: 0xF377,
	38363 - 11904: 0xF378,
	38364 - 11904: 0xC3F6,
	38366 - 11904: 0xF545,
	38367 - 11904: 0xF547,
	38368 - 11904: 0xF546,
	38369 - 11904: 0xC4C4,
	38370 - 11904: 0xC550,
	38371 - 11904: 0xF66D,
	38372 - 11904: 0xF66C,
	38373 - 11904: 0xF66B,
	38376 - 11904: 0x8BEC,
	38388 - 11904: 0x9A56,
	38428 - 11904: 0xAAFA,
	38429 - 11904: 0x8BFB,
	38430 - 11904: 0xC9AA,
	38432 - 11904: 0xCA58,
	38433 - 11904: 0xA6E9,
	38434 - 11904: 0xCA56,
	38435 - 11904: 0xCA59,
	38436 - 11904: 0xCA57,
	38440 - 11904: 0xCBAE,
	38442 - 11904: 0xA8C1,
	38444 - 11904: 0xA8C2,
	38445 - 11904: 0xCBB0,
	38446 - 11904: 0xA8BF,
	38447 - 11904: 0xCBAF,
	38448 - 11904: 0xCBAD,
	38449 - 11904: 0xA8C0,
	38450 - 11904: 0xA8BE,
	38451 - 11904: 0x9A57,
	38456 - 11904: 0xA0AA,
	38457 - 11904: 0xCDD8,
	38458 - 11904: 0xCDDB,
	38459 - 11904: 0xAAFD,
	38460 - 11904: 0xCDDA,
	38461 - 11904: 0xCDD9,
	38463 - 11904: 0xAAFC,
	38464 - 11904: 0xAAFB,
	38465 - 11904: 0x9FA6,
	38466 - 11904: 0xAB40,
	38467 - 11904: 0xCDDC,
	38468 - 11904: 0xAAFE,
	38469 - 11904: 0x99CC,
	38474 - 11904: 0xD0C6,
	38475 - 11904: 0xADAE,
	38476 - 11904: 0xADAF,
	38477 - 11904: 0xADB0,
	38478 - 11904: 0xD0C7,
	38479 - 11904: 0xD0C3,
	38480 - 11904: 0xADAD,
	38481 - 11904: 0xD0C4,
	38483 - 11904: 0xD0C5,
	38484 - 11904: 0xD0C2,
	38486 - 11904: 0x9C59,
	38488 - 11904: 0xB0A4,
	38491 - 11904: 0xB0A1,
	38492 - 11904: 0xD445,
	38493 - 11904: 0xB0A2,
	38494 - 11904: 0xB0A5,
	38495 - 11904: 0xD446,
	38497 - 11904: 0xB07E,
	38498 - 11904: 0xB07C,
	38499 - 11904: 0xB07D,
	38500 - 11904: 0xB0A3,
	38505 - 11904: 0x99B5,
	38506 - 11904: 0xB3AD,
	38507 - 11904: 0xD849,
	38508 - 11904: 0xB3B5,
	38509 - 11904: 0xD848,
	38511 - 11904: 0xD84B,
	38512 - 11904: 0xB3B1,
	38513 - 11904: 0xD84A,
	38514 - 11904: 0xB6AB,
	38515 - 11904: 0xB3AF,
	38516 - 11904: 0xB3B2,
	38517 - 11904: 0xB3AE,
	38518 - 11904: 0xB3B3,
	38519 - 11904: 0xB3B4,
	38520 - 11904: 0xB3B0,
	38523 - 11904: 0x90BE,
	38524 - 11904: 0xD847,
	38525 - 11904: 0xB6A7,
	38526 - 11904: 0xDC7D,
	38528 - 11904: 0xDCA3,
	38529 - 11904: 0x9FAF,
	38531 - 11904: 0xDCA2,
	38532 - 11904: 0xB6AC,
	38533 - 11904: 0xB6A8,
	38534 - 11904: 0xB6A9,
	38535 - 11904: 0xDC7C,
	38536 - 11904: 0xDC7E,
	38537 - 11904: 0xDCA1,
	38538 - 11904: 0xB6A4,
	38539 - 11904: 0xB6A6,
	38541 - 11904: 0xB6AA,
	38542 - 11904: 0xB6A5,
	38543 - 11904: 0x95F2,
	38545 - 11904: 0xE0D3,
	38546 - 11904: 0xE0D1,
	38547 - 11904: 0xE0D2,
	38548 - 11904: 0xB96A,
	38549 - 11904: 0xB96B,
	38550 - 11904: 0x90BF,
	38551 - 11904: 0xE0D4,
	38552 - 11904: 0xB969,
	38553 - 11904: 0xBBD8,
	38555 - 11904: 0xBBDA,
	38556 - 11904: 0xBBD9,
	38558 - 11904: 0xE4BB,
	38561 - 11904: 0xE4BC,
	38562 - 11904: 0xE8AB,
	38563 - 11904: 0x90C1,
	38564 - 11904: 0xE8AA,
	38565 - 11904: 0xFEE4,
	38567 - 11904: 0xC047,
	38568 - 11904: 0xC048,
	38569 - 11904: 0xEC4F,
	38570 - 11904: 0xC049,
	38572 - 11904: 0xEEF6,
	38574 - 11904: 0xEEF4,
	38576 - 11904: 0xEEF5,
	38577 - 11904: 0xC1F4,
	38579 - 11904: 0xF16F,
	38580 - 11904: 0xC3F7,
	38582 - 11904: 0xC6D7,
	38584 - 11904: 0xC1F5,
	38585 - 11904: 0xAB41,
	38587 - 11904: 0xB0A6,
	38588 - 11904: 0xD447,
	38589 - 11904: 0x90C7,
	38591 - 11904: 0xD84C,
	38592 - 11904: 0xB3B6,
	38593 - 11904: 0xB6AD,
	38594 - 11904: 0xDCA4,
	38595 - 11904: 0xDCA6,
	38596 - 11904: 0xB6AF,
	38597 - 11904: 0xB6AE,
	38598 - 11904: 0xB6B0,
	38599 - 11904: 0xB6B1,
	38600 - 11904: 0xDCA5,
	38601 - 11904: 0xB96E,
	38602 - 11904: 0xB96F,
	38603 - 11904: 0xB96D,
	38604 - 11904: 0xBBDB,
	38605 - 11904: 0xB96C,
	38606 - 11904: 0xE0D5,
	38610 - 11904: 0xBBDC,
	38611 - 11904: 0xE8AC,
	38612 - 11904: 0xEC50,
	38613 - 11904: 0xC04A,
	38614 - 11904: 0xC1F6,
	38615 - 11904: 0xF170,
	38616 - 11904: 0xF174,
	38617 - 11904: 0xC2F9,
	38618 - 11904: 0xF171,
	38619 - 11904: 0xC2FA,
	38620 - 11904: 0xC2F8,
	38621 - 11904: 0xF175,
	38622 - 11904: 0xC2FB,
	38623 - 11904: 0xF173,
	38625 - 11904: 0xF379,
	38626 - 11904: 0xC2F7,
	38627 - 11904: 0xC3F8,
	38629 - 11904: 0xF8CD,
	38632 - 11904: 0xAB42,
	38633 - 11904: 0xB3B8,
	38634 - 11904: 0xB3B7,
	38639 - 11904: 0xB6B2,
	38640 - 11904: 0xDCA8,
	38641 - 11904: 0xDCA7,
	38642 - 11904: 0xB6B3,
	38644 - 11904: 0x92E4,
	38645 - 11904: 0xE0D9,
	38646 - 11904: 0xB973,
	38647 - 11904: 0xB970,
	38648 - 11904: 0xE0D8,
	38649 - 11904: 0xB972,
	38650 - 11904: 0xE0D6,
	38651 - 11904: 0xB971,
	38653 - 11904: 0xE0D7,
	38655 - 11904: 0xE4BD,
	38656 - 11904: 0xBBDD,
	38658 - 11904: 0xE8AF,
	38659 - 11904: 0x9F52,
	38660 - 11904: 0xBE5D,
	38661 - 11904: 0xE8AD,
	38662 - 11904: 0xBE5E,
	38663 - 11904: 0xBE5F,
	38664 - 11904: 0xE8AE,
	38665 - 11904: 0xBE60,
	38667 - 11904: 0xEC51,
	38669 - 11904: 0xC04E,
	38670 - 11904: 0xC04B,
	38671 - 11904: 0xC050,
	38672 - 11904: 0xEC53,
	38673 - 11904: 0xC04C,
	38674 - 11904: 0xEC52,
	38675 - 11904: 0xC04F,
	38678 - 11904: 0xC04D,
	38680 - 11904: 0xEEF9,
	38681 - 11904: 0xEEFB,
	38683 - 11904: 0x90DB,
	38684 - 11904: 0xC1F7,
	38685 - 11904: 0xEEFA,
	38686 - 11904: 0xC1F8,
	38687 - 11904: 0xEEF8,
	38688 - 11904: 0xEEF7,
	38689 - 11904: 0xA066,
	38690 - 11904: 0xF177,
	38691 - 11904: 0xF176,
	38692 - 11904: 0xC2FC,
	38693 - 11904: 0xF178,
	38694 - 11904: 0xF37E,
	38695 - 11904: 0xC3FA,
	38696 - 11904: 0xF37D,
	38697 - 11904: 0xF37A,
	38698 - 11904: 0xC3F9,
	38699 - 11904: 0xF37B,
	38700 - 11904: 0xF37C,
	38702 - 11904: 0xF548,
	38703 - 11904: 0xF549,
	38704 - 11904: 0xC4C5,
	38705 - 11904: 0x90D2,
	38706 - 11904: 0xC553,
	38708 - 11904: 0x876B,
	38709 - 11904: 0xF66E,
	38710 - 11904: 0x90D4,
	38712 - 11904: 0xC551,
	38713 - 11904: 0xC552,
	38714 - 11904: 0xF66F,
	38717 - 11904: 0xC5B4,
	38718 - 11904: 0xC5B5,
	38719 - 11904: 0xF771,
	38720 - 11904: 0x9A5B,
	38721 - 11904: 0x95FD,
	38722 - 11904: 0xC645,
	38723 - 11904: 0xF8CF,
	38724 - 11904: 0xC647,
	38726 - 11904: 0xF8CE,
	38727 - 11904: 0xF8D0,
	38728 - 11904: 0xC646,
	38729 - 11904: 0xF957,
	38730 - 11904: 0x87B1,
	38731 - 11904: 0xF9AD,
	38737 - 11904: 0x8BC4,
	38738 - 11904: 0xAB43,
	38741 - 11904: 0x8C66,
	38742 - 11904: 0xB974,
	38743 - 11904: 0x90DE,
	38744 - 11904: 0xE4BE,
	38746 - 11904: 0xE8B0,
	38747 - 11904: 0xC051,
	38748 - 11904: 0xC052,
	38749 - 11904: 0x9CE4,
	38750 - 11904: 0xAB44,
	38751 - 11904: 0x90E1,
	38752 - 11904: 0xBE61,
	38753 - 11904: 0xC3FB,
	38754 - 11904: 0xADB1,
	38758 - 11904: 0xC053,
	38760 - 11904: 0xC5E2,
	38761 - 11904: 0xADB2,
	38762 - 11904: 0xD84D,
	38764 - 11904: 0xDCA9,
	38765 - 11904: 0x9E46,
	38766 - 11904: 0xDCAB,
	38768 - 11904: 0xDCAA,
	38769 - 11904: 0x9651,
	38770 - 11904: 0xE0DD,
	38771 - 11904: 0xE0DA,
	38772 - 11904: 0xB975,
	38774 - 11904: 0xB976,
	38775 - 11904: 0xE0DB,
	38776 - 11904: 0xE0DC,
	38778 - 11904: 0xE4C0,
	38779 - 11904: 0xE4C5,
	38780 - 11904: 0xBBDE,
	38781 - 11904: 0xE4BF,
	38782 - 11904: 0xE4C1,
	38783 - 11904: 0xE4C8,
	38784 - 11904: 0xE4C3,
	38785 - 11904: 0xE4C7,
	38786 - 11904: 0xE4C4,
	38787 - 11904: 0xE4C2,
	38788 - 11904: 0xE4C6,
	38789 - 11904: 0xBBDF,
	38791 - 11904: 0xFB58,
	38792 - 11904: 0xE8B3,
	38793 - 11904: 0x90E6,
	38794 - 11904: 0xE8B1,
	38795 - 11904: 0xBE63,
	38797 - 11904: 0xBE62,
	38798 - 11904: 0xE8B2,
	38799 - 11904: 0xBE64,
	38804 - 11904: 0xEC56,
	38807 - 11904: 0xEC55,
	38808 - 11904: 0xC054,
	38809 - 11904: 0xEC54,
	38810 - 11904: 0xEEFC,
	38811 - 11904: 0x9650,
	38812 - 11904: 0xEEFE,
	38813 - 11904: 0xEF41,
	38814 - 11904: 0xEF40,
	38815 - 11904: 0x90E7,
	38816 - 11904: 0xC1F9,
	38817 - 11904: 0xEEFD,
	38818 - 11904: 0xF1A1,
	38819 - 11904: 0xC2FD,
	38820 - 11904: 0xF17D,
	38821 - 11904: 0xF1A2,
	38822 - 11904: 0xC2FE,
	38824 - 11904: 0xF17B,
	38826 - 11904: 0xF17E,
	38827 - 11904: 0xF17C,
	38828 - 11904: 0xF179,
	38829 - 11904: 0xC340,
	38830 - 11904: 0xF17A,
	38833 - 11904: 0x90E8,
	38834 - 11904: 0x9A5D,
	38835 - 11904: 0xF3A1,
	38836 - 11904: 0x9F7A,
	38838 - 11904: 0xF3A3,
	38839 - 11904: 0xF3A2,
	38840 - 11904: 0x9B5C,
	38841 - 11904: 0xF54A,
	38842 - 11904: 0x9F7C,
	38843 - 11904: 0xF54B,
	38845 - 11904: 0xFC52,
	38846 - 11904: 0x90E9,
	38847 - 11904: 0xF670,
	38848 - 11904: 0x90EA,
	38849 - 11904: 0xC5B7,
	38850 - 11904: 0x9A5E,
	38851 - 11904: 0xC5B6,
	38852 - 11904: 0xF84F,
	38853 - 11904: 0xF850,
	38854 - 11904: 0xC648,
	38855 - 11904: 0xF8D1,
	38856 - 11904: 0x9F76,
	38857 - 11904: 0xC669,
	38859 - 11904: 0xADB3,
	38860 - 11904: 0xB6B4,
	38861 - 11904: 0xE4CA,
	38862 - 11904: 0xE4C9,
	38863 - 11904: 0xE8B5,
	38864 - 11904: 0xE8B4,
	38866 - 11904: 0x90EB,
	38867 - 11904: 0xC1FA,
	38868 - 11904: 0xEF43,
	38869 - 11904: 0xEF42,
	38870 - 11904: 0xF1A5,
	38871 - 11904: 0xF1A3,
	38872 - 11904: 0xF1A6,
	38873 - 11904: 0xF1A4,
	38876 - 11904: 0xC3FC,
	38877 - 11904: 0xF3A4,
	38878 - 11904: 0xF3A5,
	38879 - 11904: 0xF3A6,
	38880 - 11904: 0x90EC,
	38881 - 11904: 0xF671,
	38883 - 11904: 0xF772,
	38885 - 11904: 0xF8D2,
	38886 - 11904: 0x8BEE,
	38893 - 11904: 0xADB4,
	38894 - 11904: 0x90EE,
	38896 - 11904: 0xEC57,
	38897 - 11904: 0xEF44,
	38898 - 11904: 0x91C6,
	38899 - 11904: 0xADB5,
	38901 - 11904: 0x90F2,
	38902 - 11904: 0xBBE0,
	38904 - 11904: 0xEC58,
	38905 - 11904: 0xC341,
	38906 - 11904: 0xF1A7,
	38907 - 11904: 0xC3FD,
	38909 - 11904: 0xF54C,
	38910 - 11904: 0xF54D,
	38911 - 11904: 0xC554,
	38912 - 11904: 0xF851,
	38913 - 11904: 0xADB6,
	38914 - 11904: 0xB3BB,
	38915 - 11904: 0xB3BC,
	38916 - 11904: 0xD84E,
	38917 - 11904: 0xB6B5,
	38918 - 11904: 0xB6B6,
	38919 - 11904: 0xDCAC,
	38920 - 11904: 0xB6B7,
	38922 - 11904: 0xB97A,
	38924 - 11904: 0xB97C,
	38925 - 11904: 0xE0DF,
	38926 - 11904: 0xE0E0,
	38927 - 11904: 0xE0DE,
	38928 - 11904: 0xB977,
	38929 - 11904: 0xB978,
	38930 - 11904: 0xB97B,
	38931 - 11904: 0xB979,
	38932 - 11904: 0xFCBC,
	38933 - 11904: 0x8A74,
	38934 - 11904: 0xE4CB,
	38935 - 11904: 0xBBE1,
	38936 - 11904: 0xBBE2,
	38939 - 11904: 0xE8BC,
	38940 - 11904: 0xBE67,
	38941 - 11904: 0xE8B7,
	38942 - 11904: 0xE8B6,
	38943 - 11904: 0x9657,
	38944 - 11904: 0xE8BB,
	38945 - 11904: 0xBE65,
	38947 - 11904: 0x9CEF,
	38948 - 11904: 0xC05B,
	38950 - 11904: 0xE8B8,
	38951 - 11904: 0xE8BD,
	38952 - 11904: 0xE8BA,
	38953 - 11904: 0xE8B9,
	38955 - 11904: 0xBE66,
	38957 - 11904: 0xC059,
	38958 - 11904: 0x9FDF,
	38959 - 11904: 0xEC5A,
	38960 - 11904: 0xC055,
	38962 - 11904: 0xEC5B,
	38963 - 11904: 0x90F7,
	38964 - 11904: 0x90F6,
	38965 - 11904: 0xEC59,
	38967 - 11904: 0xC058,
	38968 - 11904: 0xC056,
	38969 - 11904: 0xC05A,
	38971 - 11904: 0xC057,
	38977 - 11904: 0xEF45,
	38979 - 11904: 0xEF4A,
	38980 - 11904: 0xEF46,
	38981 - 11904: 0xEF49,
	38982 - 11904: 0xC1FB,
	38983 - 11904: 0x9B5E,
	38984 - 11904: 0xEDD4,
	38985 - 11904: 0xEF48,
	38986 - 11904: 0xEF47,
	38987 - 11904: 0x90F8,
	38988 - 11904: 0xC344,
	38989 - 11904: 0xC342,
	38990 - 11904: 0xC345,
	38991 - 11904: 0xC343,
	38992 - 11904: 0xF1A8,
	38993 - 11904: 0xF1A9,
	38994 - 11904: 0xF1AA,
	38995 - 11904: 0xC346,
	38998 - 11904: 0x8CFC,
	38999 - 11904: 0xF3AA,
	39000 - 11904: 0xC440,
	39001 - 11904: 0xF3A8,
	39003 - 11904: 0xC441,
	39004 - 11904: 0xF3A7,
	39005 - 11904: 0xF3A9,
	39006 - 11904: 0xC3FE,
	39007 - 11904: 0xF551,
	39008 - 11904: 0xF54E,
	39010 - 11904: 0xF54F,
	39011 - 11904: 0xF550,
	39012 - 11904: 0xF672,
	39013 - 11904: 0xC556,
	39014 - 11904: 0x90F9,
	39015 - 11904: 0xC555,
	39016 - 11904: 0x8CC9,
	39017 - 11904: 0xF774,
	39018 - 11904: 0xF773,
	39019 - 11904: 0xC5B8,
	39020 - 11904: 0xFA6A,
	39023 - 11904: 0xC5E3,
	39024 - 11904: 0xC649,
	39025 - 11904: 0xC660,
	39026 - 11904: 0xF958,
	39027 - 11904: 0xF9AE,
	39028 - 11904: 0xF9AF,
	39029 - 11904: 0x8BEF,
	39080 - 11904: 0xADB7,
	39081 - 11904: 0xDCAD,
	39084 - 11904: 0xE0E1,
	39085 - 11904: 0xE4CC,
	39086 - 11904: 0xE4CD,
	39087 - 11904: 0xBBE3,
	39089 - 11904: 0xBBE4,
	39090 - 11904: 0xE8BE,
	39091 - 11904: 0xBE68,
	39092 - 11904: 0x9FE0,
	39094 - 11904: 0xC1FC,
	39095 - 11904: 0x9142,
	39096 - 11904: 0xF1AB,
	39097 - 11904: 0x9A62,
	39098 - 11904: 0xC347,
	39099 - 11904: 0xF3AD,
	39100 - 11904: 0xC442,
	39101 - 11904: 0xF3AC,
	39102 - 11904: 0xF3AE,
	39103 - 11904: 0xF3AB,
	39104 - 11904: 0xF675,
	39105 - 11904: 0xF552,
	39106 - 11904: 0xF553,
	39107 - 11904: 0x9569,
	39108 - 11904: 0xC4C6,
	39110 - 11904: 0xF674,
	39111 - 11904: 0x9144,
	39112 - 11904: 0x9143,
	39113 - 11904: 0xF673,
	39114 - 11904: 0x9141,
	39115 - 11904: 0xF775,
	39116 - 11904: 0xF9B0,
	39118 - 11904: 0x8BF0,
	39131 - 11904: 0xADB8,
	39132 - 11904: 0x9660,
	39134 - 11904: 0x8BF1,
	39135 - 11904: 0xADB9,
	39136 - 11904: 0x99F6,
	39137 - 11904: 0x9149,
	39138 - 11904: 0xB0A7,
	39139 - 11904: 0xD448,
	39141 - 11904: 0xD84F,
	39142 - 11904: 0x914A,
	39143 - 11904: 0xB6B8,
	39145 - 11904: 0xB6BB,
	39146 - 11904: 0xB6B9,
	39147 - 11904: 0xDCAE,
	39148 - 11904: 0x914B,
	39149 - 11904: 0xB6BD,
	39151 - 11904: 0xB6BA,
	39153 - 11904: 0x9A64,
	39154 - 11904: 0xB6BC,
	39156 - 11904: 0xB97E,
	39157 - 11904: 0x8ABF,
	39158 - 11904: 0xE0E2,
	39161 - 11904: 0xE0E3,
	39162 - 11904: 0xE8C0,
	39164 - 11904: 0xB97D,
	39165 - 11904: 0xB9A1,
	39166 - 11904: 0xB9A2,
	39168 - 11904: 0xE4CF,
	39170 - 11904: 0xE4CE,
	39171 - 11904: 0xBBE5,
	39173 - 11904: 0xBBE6,
	39175 - 11904: 0xE4D0,
	39176 - 11904: 0xE8BF,
	39177 - 11904: 0xBBE8,
	39178 - 11904: 0xBE69,
	39180 - 11904: 0xBBE7,
	39182 - 11904: 0x9A66,
	39184 - 11904: 0xC05C,
	39185 - 11904: 0xE8C1,
	39186 - 11904: 0xBE6B,
	39187 - 11904: 0xBE6A,
	39188 - 11904: 0xE8C2,
	39189 - 11904: 0xE8C5,
	39190 - 11904: 0xE8C3,
	39191 - 11904: 0xE8C4,
	39192 - 11904: 0xBE6C,
	39193 - 11904: 0x9A67,
	39194 - 11904: 0xC061,
	39195 - 11904: 0xC05F,
	39196 - 11904: 0x9A69,
	39198 - 11904: 0xC05E,
	39199 - 11904: 0xEC5D,
	39201 - 11904: 0xC060,
	39204 - 11904: 0xEC5C,
	39205 - 11904: 0xEF4B,
	39207 - 11904: 0xEC5E,
	39208 - 11904: 0xC05D,
	39209 - 11904: 0xEC5F,
	39210 - 11904: 0xEF4E,
	39211 - 11904: 0xEF4C,
	39212 - 11904: 0xEF4D,
	39213 - 11904: 0xEF52,
	39214 - 11904: 0xC34B,
	39215 - 11904: 0xEF51,
	39216 - 11904: 0xEF54,
	39217 - 11904: 0xEF53,
	39218 - 11904: 0xEF50,
	39219 - 11904: 0xEF4F,
	39221 - 11904: 0xC1FD,
	39223 - 11904: 0x9A6A,
	39224 - 11904: 0x9652,
	39225 - 11904: 0x914D,
	39226 - 11904: 0xF1AE,
	39227 - 11904: 0x9666,
	39228 - 11904: 0xF1AD,
	39229 - 11904: 0xC34A,
	39230 - 11904: 0xC348,
	39231 - 11904: 0xC349,
	39232 - 11904: 0x9F7B,
	39233 - 11904: 0xF1AC,
	39234 - 11904: 0x9A6B,
	39235 - 11904: 0xF3B1,
	39237 - 11904: 0xC443,
	39239 - 11904: 0xF3B0,
	39240 - 11904: 0xF3AF,
	39241 - 11904: 0xC444,
	39242 - 11904: 0xA06C,
	39243 - 11904: 0xF558,
	39244 - 11904: 0xF557,
	39245 - 11904: 0x9667,
	39246 - 11904: 0xF555,
	39248 - 11904: 0xF554,
	39249 - 11904: 0xC4C8,
	39250 - 11904: 0xC4C7,
	39251 - 11904: 0xF559,
	39252 - 11904: 0xF776,
	39253 - 11904: 0xC5B9,
	39254 - 11904: 0xF677,
	39255 - 11904: 0xC557,
	39256 - 11904: 0xF676,
	39257 - 11904: 0xF556,
	39259 - 11904: 0xF777,
	39260 - 11904: 0xC5E4,
	39261 - 11904: 0x9A6C,
	39262 - 11904: 0xC661,
	39263 - 11904: 0xF959,
	39265 - 11904: 0xF9B1,
	39266 - 11904: 0x9A6D,
	39267 - 11904: 0x8BF2,
	39318 - 11904: 0xADBA,
	39319 - 11904: 0xD850,
	39320 - 11904: 0xEF55,
	39321 - 11904: 0xADBB,
	39323 - 11904: 0x966A,
	39324 - 11904: 0xE4D2,
	39325 - 11904: 0xE4D1,
	39326 - 11904: 0xEC60,
	39329 - 11904: 0xEF57,
	39331 - 11904: 0xEF56,
	39332 - 11904: 0xFCEA,
	39333 - 11904: 0xC34C,
	39334 - 11904: 0xF3B2,
	39335 - 11904: 0xF3B3,
	39336 - 11904: 0xC4C9,
	39338 - 11904: 0x966C,
	39339 - 11904: 0xF9B2,
	39340 - 11904: 0xB0A8,
	39341 - 11904: 0xB6BF,
	39342 - 11904: 0xB6BE,
	39343 - 11904: 0xE0E4,
	39344 - 11904: 0xE0E6,
	39345 - 11904: 0xB9A4,
	39346 - 11904: 0xE0E5,
	39347 - 11904: 0xB9A3,
	39348 - 11904: 0xB9A5,
	39349 - 11904: 0xE0E7,
	39352 - 11904: 0x91C4,
	39353 - 11904: 0xE4D4,
	39354 - 11904: 0xE4D6,
	39355 - 11904: 0xE4D5,
	39356 - 11904: 0x9677,
	39357 - 11904: 0xE4D8,
	39361 - 11904: 0xBBE9,
	39362 - 11904: 0xE4D7,
	39363 - 11904: 0xE4D3,
	39364 - 11904: 0x99F4,
	39365 - 11904: 0x9A6F,
	39367 - 11904: 0xE4D9,
	39369 - 11904: 0xE8CC,
	39371 - 11904: 0xE8CF,
	39372 - 11904: 0xE8D1,
	39373 - 11904: 0xE8C7,
	39374 - 11904: 0xE8CB,
	39375 - 11904: 0xE8C8,
	39376 - 11904: 0xBE6E,
	39377 - 11904: 0xBE71,
	39378 - 11904: 0xBE73,
	39379 - 11904: 0xE8C9,
	39380 - 11904: 0xE8CA,
	39381 - 11904: 0xBE72,
	39382 - 11904: 0xE8CD,
	39383 - 11904: 0xE8D0,
	39384 - 11904: 0xE8CE,
	39385 - 11904: 0xBE74,
	39386 - 11904: 0x9FAB,
	39387 - 11904: 0xBE70,
	39388 - 11904: 0xE8C6,
	39389 - 11904: 0xBE6D,
	39391 - 11904: 0xBE6F,
	39392 - 11904: 0x8CBE,
	39393 - 11904: 0x8EC1,
	39394 - 11904: 0xC063,
	39395 - 11904: 0xEC66,
	39396 - 11904: 0xEC64,
	39397 - 11904: 0xEC63,
	39398 - 11904: 0x9555,
	39399 - 11904: 0xEC69,
	39401 - 11904: 0xEC68,
	39402 - 11904: 0xEC67,
	39404 - 11904: 0xEC62,
	39405 - 11904: 0xC062,
	39406 - 11904: 0xEC61,
	39408 - 11904: 0xEC65,
	39409 - 11904: 0xC064,
	39412 - 11904: 0xEF5A,
	39413 - 11904: 0x9152,
	39414 - 11904: 0xEF5E,
	39415 - 11904: 0xEF5B,
	39416 - 11904: 0xEF5D,
	39417 - 11904: 0xEF5C,
	39418 - 11904: 0xEF59,
	39419 - 11904: 0xEF5F,
	39420 - 11904: 0xEF62,
	39421 - 11904: 0xEF60,
	39422 - 11904: 0xEF61,
	39423 - 11904: 0xC240,
	39425 - 11904: 0xC1FE,
	39426 - 11904: 0xEF58,
	39427 - 11904: 0xEF63,
	39428 - 11904: 0xF1B3,
	39429 - 11904: 0xF1B6,
	39430 - 11904: 0xF1B8,
	39431 - 11904: 0xF1B7,
	39433 - 11904: 0xF1B1,
	39434 - 11904: 0xF1B5,
	39435 - 11904: 0xF1B0,
	39436 - 11904: 0x9153,
	39437 - 11904: 0xF1B2,
	39438 - 11904: 0xC34D,
	39439 - 11904: 0xF1AF,
	39440 - 11904: 0x9155,
	39441 - 11904: 0xF1B4,
	39444 - 11904: 0xF3C0,
	39445 - 11904: 0xF3B5,
	39446 - 11904: 0xC445,
	39449 - 11904: 0xC446,
	39450 - 11904: 0xF3B4,
	39451 - 11904: 0xF3B9,
	39452 - 11904: 0xF3BF,
	39453 - 11904: 0xF3B7,
	39454 - 11904: 0xF3BE,
	39455 - 11904: 0x955D,
	39456 - 11904: 0xF3BB,
	39457 - 11904: 0x9671,
	39458 - 11904: 0xF3BA,
	39459 - 11904: 0xF3BD,
	39460 - 11904: 0xF3B8,
	39461 - 11904: 0xF3B6,
	39462 - 11904: 0x9C6D,
	39463 - 11904: 0xF3BC,
	39465 - 11904: 0xF560,
	39466 - 11904: 0xF55E,
	39467 - 11904: 0xC4CA,
	39468 - 11904: 0xF55D,
	39469 - 11904: 0xF563,
	39470 - 11904: 0xF561,
	39471 - 11904: 0x9673,
	39472 - 11904: 0xC4CB,
	39473 - 11904: 0xF55C,
	39474 - 11904: 0xF55A,
	39476 - 11904: 0xF55B,
	39477 - 11904: 0xC4CD,
	39478 - 11904: 0xF55F,
	39479 - 11904: 0xC4CC,
	39480 - 11904: 0xF562,
	39481 - 11904: 0xF678,
	39482 - 11904: 0xF67E,
	39483 - 11904: 0x9154,
	39484 - 11904: 0x9A71,
	39485 - 11904: 0xF679,
	39486 - 11904: 0xC55B,
	39487 - 11904: 0xF6A1,
	39488 - 11904: 0xC55A,
	39489 - 11904: 0xF67D,
	39490 - 11904: 0xF67C,
	39491 - 11904: 0xC559,
	39492 - 11904: 0xF67B,
	39493 - 11904: 0xC558,
	39494 - 11904: 0xF67A,
	39496 - 11904: 0xF77D,
	39497 - 11904: 0xF7A1,
	39498 - 11904: 0xF77E,
	39500 - 11904: 0xF77B,
	39501 - 11904: 0xC5BB,
	39502 - 11904: 0xF778,
	39503 - 11904: 0xF77C,
	39504 - 11904: 0xF7A3,
	39506 - 11904: 0xF7A2,
	39507 - 11904: 0xF779,
	39508 - 11904: 0xF77A,
	39509 - 11904: 0xC5BA,
	39510 - 11904: 0xF852,
	39511 - 11904: 0xC5E7,
	39512 - 11904: 0x9156,
	39513 - 11904: 0xF853,
	39514 - 11904: 0xC5E5,
	39515 - 11904: 0xC5E6,
	39516 - 11904: 0x966D,
	39518 - 11904: 0xF8D3,
	39519 - 11904: 0xC64A,
	39520 - 11904: 0xF976,
	39522 - 11904: 0xC66A,
	39523 - 11904: 0x9557,
	39524 - 11904: 0xF9B3,
	39525 - 11904: 0xC66B,
	39526 - 11904: 0xF9B4,
	39527 - 11904: 0xF9B5,
	39528 - 11904: 0xF9C3,
	39529 - 11904: 0xF9C2,
	39530 - 11904: 0xC67A,
	39531 - 11904: 0xF9CD,
	39532 - 11904: 0x89C6,
	39567 - 11904: 0x89C7,
	39592 - 11904: 0xB0A9,
	39595 - 11904: 0xE0E9,
	39597 - 11904: 0xE0E8,
	39599 - 11904: 0xBBEA,
	39600 - 11904: 0xBBEB,
	39601 - 11904: 0xE4DA,
	39602 - 11904: 0x8A6A,
	39603 - 11904: 0xE8D2,
	39604 - 11904: 0xEC6C,
	39606 - 11904: 0x8B57,
	39607 - 11904: 0xBE75,
	39608 - 11904: 0xC065,
	39609 - 11904: 0xEC6A,
	39610 - 11904: 0x9FE1,
	39611 - 11904: 0xEC6D,
	39612 - 11904: 0xC066,
	39613 - 11904: 0x9B5F,
	39614 - 11904: 0xEF64,
	39615 - 11904: 0xEC6B,
	39616 - 11904: 0xF1B9,
	39617 - 11904: 0xC34E,
	39618 - 11904: 0xF3C1,
	39622 - 11904: 0xF566,
	39623 - 11904: 0xF564,
	39626 - 11904: 0xF565,
	39629 - 11904: 0xF6A2,
	39631 - 11904: 0xC55C,
	39632 - 11904: 0xF7A4,
	39633 - 11904: 0xC5EA,
	39634 - 11904: 0xC5BC,
	39635 - 11904: 0xC5E8,
	39636 - 11904: 0xC5E9,
	39637 - 11904: 0xF8D4,
	39638 - 11904: 0xC662,
	39639 - 11904: 0xA05D,
	39640 - 11904: 0xB0AA,
	39644 - 11904: 0xF1BA,
	39647 - 11904: 0xD449,
	39648 - 11904: 0x915B,
	39649 - 11904: 0xB9A6,
	39650 - 11904: 0x915C,
	39651 - 11904: 0xE4DB,
	39654 - 11904: 0xBBEC,
	39655 - 11904: 0xE4DC,
	39659 - 11904: 0xE8D4,
	39660 - 11904: 0xE8D3,
	39661 - 11904: 0xC068,
	39662 - 11904: 0xBE76,
	39663 - 11904: 0xBE77,
	39665 - 11904: 0xE8D7,
	39666 - 11904: 0xE8D6,
	39667 - 11904: 0xE8D5,
	39668 - 11904: 0x915E,
	39670 - 11904: 0xEC6E,
	39671 - 11904: 0xEC71,
	39673 - 11904: 0xEC70,
	39674 - 11904: 0xEC6F,
	39675 - 11904: 0xC067,
	39676 - 11904: 0xEF68,
	39677 - 11904: 0xEF66,
	39678 - 11904: 0xEF65,
	39679 - 11904: 0x9F5C,
	39681 - 11904: 0xEF67,
	39682 - 11904: 0x9F57,
	39683 - 11904: 0xC34F,
	39684 - 11904: 0xF1BC,
	39685 - 11904: 0xF1BD,
	39686 - 11904: 0xC350,
	39688 - 11904: 0xF1BB,
	39689 - 11904: 0x9F65,
	39690 - 11904: 0xF3C3,
	39691 - 11904: 0xF3C2,
	39692 - 11904: 0xF3C5,
	39693 - 11904: 0xC447,
	39694 - 11904: 0xF3C4,
	39695 - 11904: 0x9A72,
	39696 - 11904: 0xF567,
	39697 - 11904: 0xF569,
	39698 - 11904: 0xF568,
	39700 - 11904: 0x9160,
	39701 - 11904: 0xF6A3,
	39702 - 11904: 0xF6A6,
	39703 - 11904: 0xF6A4,
	39704 - 11904: 0xF6A5,
	39705 - 11904: 0xF7A5,
	39706 - 11904: 0xC5BD,
	39710 - 11904: 0xF854,
	39711 - 11904: 0xF855,
	39712 - 11904: 0xF856,
	39714 - 11904: 0xC64B,
	39715 - 11904: 0xC663,
	39716 - 11904: 0xF9B6,
	39717 - 11904: 0xB0AB,
	39719 - 11904: 0xBE78,
	39720 - 11904: 0xC069,
	39721 - 11904: 0xF1BE,
	39722 - 11904: 0x9F5E,
	39723 - 11904: 0xF7A6,
	39725 - 11904: 0x9161,
	39726 - 11904: 0xF9C4,
	39727 - 11904: 0xD44A,
	39729 - 11904: 0xC67B,
	39730 - 11904: 0xB0AC,
	39731 - 11904: 0xEC72,
	39732 - 11904: 0x9164,
	39733 - 11904: 0xF1BF,
	39735 - 11904: 0xF3C6,
	39737 - 11904: 0x9F41,
	39738 - 11904: 0xF6A7,
	39739 - 11904: 0xF7A7,
	39740 - 11904: 0xB0AD,
	39742 - 11904: 0xE4DD,
	39743 - 11904: 0xE4DE,
	39744 - 11904: 0x9169,
	39745 - 11904: 0xBBED,
	39746 - 11904: 0xBBEE,
	39747 - 11904: 0xE8D9,
	39748 - 11904: 0xBE7A,
	39749 - 11904: 0xBE79,
	39750 - 11904: 0xE8D8,
	39752 - 11904: 0xEF69,
	39754 - 11904: 0xF1C0,
	39755 - 11904: 0xF1C2,
	39756 - 11904: 0xF1C1,
	39757 - 11904: 0xC353,
	39758 - 11904: 0xC352,
	39759 - 11904: 0xC351,
	39760 - 11904: 0x9168,
	39761 - 11904: 0xC55E,
	39762 - 11904: 0xF6A8,
	39764 - 11904: 0xC55D,
	39765 - 11904: 0xF7A9,
	39766 - 11904: 0xF7A8,
	39768 - 11904: 0xC64C,
	39769 - 11904: 0xF8D5,
	39770 - 11904: 0xB3BD,
	39771 - 11904: 0xE0EA,
	39775 - 11904: 0xE4E1,
	39776 - 11904: 0xE4DF,
	39777 - 11904: 0xE4E0,
	39780 - 11904: 0xE8E2,
	39782 - 11904: 0xE8DD,
	39783 - 11904: 0xE8DA,
	39784 - 11904: 0xE8E1,
	39785 - 11904: 0x9A74,
	39788 - 11904: 0xE8E3,
	39791 - 11904: 0xBE7C,
	39792 - 11904: 0xE8E0,
	39793 - 11904: 0xE8DC,
	39796 - 11904: 0xE8DB,
	39797 - 11904: 0xE8DF,
	39798 - 11904: 0xE8DE,
	39799 - 11904: 0xBE7B,
	39802 - 11904: 0xEC7D,
	39803 - 11904: 0xEC78,
	39804 - 11904: 0xEC76,
	39805 - 11904: 0xECA1,
	39806 - 11904: 0xEC77,
	39807 - 11904: 0x96B2,
	39808 - 11904: 0xEC73,
	39809 - 11904: 0x9A75,
	39810 - 11904: 0xEC79,
	39811 - 11904: 0xFDA5,
	39813 - 11904: 0xEC74,
	39814 - 11904: 0xEF72,
	39815 - 11904: 0xEC75,
	39816 - 11904: 0xECA2,
	39819 - 11904: 0x9EE9,
	39821 - 11904: 0x8BBA,
	39822 - 11904: 0x916D,
	39823 - 11904: 0xA060,
	39824 - 11904: 0xEC7C,
	39825 - 11904: 0xC06A,
	39826 - 11904: 0xEC7B,
	39827 - 11904: 0xEC7A,
	39829 - 11904: 0xEC7E,
	39831 - 11904: 0x9FDE,
	39834 - 11904: 0xEF6A,
	39835 - 11904: 0xEF6D,
	39837 - 11904: 0x9FC3,
	39838 - 11904: 0xEF6C,
	39839 - 11904: 0x96B5,
	39840 - 11904: 0xEF74,
	39841 - 11904: 0xEF6F,
	39842 - 11904: 0xEF73,
	39844 - 11904: 0xEF71,
	39845 - 11904: 0xEF70,
	39846 - 11904: 0xEF6E,
	39848 - 11904: 0xEF6B,
	39850 - 11904: 0xC243,
	39851 - 11904: 0xC242,
	39853 - 11904: 0xC244,
	39854 - 11904: 0xC241,
	39855 - 11904: 0xEF75,
	39856 - 11904: 0xA067,
	39861 - 11904: 0xF1C8,
	39862 - 11904: 0xF1CB,
	39864 - 11904: 0xF1C9,
	39865 - 11904: 0xF1CD,
	39869 - 11904: 0xF1CE,
	39871 - 11904: 0xF1C6,
	39872 - 11904: 0xC358,
	39873 - 11904: 0xF1C7,
	39875 - 11904: 0xF1C5,
	39876 - 11904: 0xF1CC,
	39878 - 11904: 0xF1C4,
	39879 - 11904: 0xF1C3,
	39880 - 11904: 0xC357,
	39881 - 11904: 0xC355,
	39882 - 11904: 0xC354,
	39887 - 11904: 0x96B3,
	39891 - 11904: 0xF1CA,
	39892 - 11904: 0xF3CF,
	39893 - 11904: 0xF3D5,
	39894 - 11904: 0xC44A,
	39895 - 11904: 0xF3D0,
	39897 - 11904: 0xF3D3,
	39898 - 11904: 0xF3D7,
	39899 - 11904: 0xC44B,
	39900 - 11904: 0xF3D2,
	39901 - 11904: 0x9A76,
	39902 - 11904: 0xF3CA,
	39904 - 11904: 0xF3C9,
	39905 - 11904: 0xF3D6,
	39906 - 11904: 0xF3CD,
	39908 - 11904: 0xF3CB,
	39909 - 11904: 0xF3D4,
	39910 - 11904: 0xF3CC,
	39911 - 11904: 0xC449,
	39912 - 11904: 0xC448,
	39913 - 11904: 0x95D5,
	39914 - 11904: 0xF3C7,
	39915 - 11904: 0xF3C8,
	39916 - 11904: 0xF3D1,
	39917 - 11904: 0x9ECA,
	39920 - 11904: 0xF3CE,
	39921 - 11904: 0x9A77,
	39924 - 11904: 0x9A78,
	39927 - 11904: 0xF56C,
	39928 - 11904: 0xF56F,
	39933 - 11904: 0xC356,
	39935 - 11904: 0x9170,
	39938 - 11904: 0x916F,
	39941 - 11904: 0xF56D,
	39942 - 11904: 0xF573,
	39943 - 11904: 0xF571,
	39944 - 11904: 0xF56B,
	39945 - 11904: 0xF576,
	39946 - 11904: 0x9FA3,
	39947 - 11904: 0xF56A,
	39948 - 11904: 0x9171,
	39949 - 11904: 0xC4CF,
	39950 - 11904: 0xF572,
	39952 - 11904: 0x96B1,
	39954 - 11904: 0xF56E,
	39955 - 11904: 0xC4CE,
	39956 - 11904: 0xF575,
	39957 - 11904: 0x9F63,
	39959 - 11904: 0xF574,
	39963 - 11904: 0x9F67,
	39964 - 11904: 0xF6AB,
	39965 - 11904: 0xF6AA,
	39967 - 11904: 0x8BB9,
	39968 - 11904: 0x9A7A,
	39969 - 11904: 0xF6B1,
	39971 - 11904: 0xF6AD,
	39972 - 11904: 0xF6B0,
	39973 - 11904: 0xC560,
	39974 - 11904: 0x8B56,
	39976 - 11904: 0xF6AE,
	39977 - 11904: 0xF6AF,
	39979 - 11904: 0xF6A9,
	39980 - 11904: 0xF6AC,
	39981 - 11904: 0xC55F,
	39983 - 11904: 0x9ADA,
	39985 - 11904: 0xC5BF,
	39986 - 11904: 0xF7B4,
	39987 - 11904: 0xF7AF,
	39988 - 11904: 0xF7B3,
	39989 - 11904: 0x96B0,
	39990 - 11904: 0xF7B6,
	39991 - 11904: 0xF7B2,
	39993 - 11904: 0xF7AE,
	39994 - 11904: 0x9A7E,
	39995 - 11904: 0xC5C1,
	39996 - 11904: 0xF7B1,
	39997 - 11904: 0xF7B5,
	39998 - 11904: 0xC5C0,
	39999 - 11904: 0xF7AC,
	40000 - 11904: 0xF570,
	40001 - 11904: 0xF7B0,
	40004 - 11904: 0xF7AD,
	40005 - 11904: 0x9DDE,
	40006 - 11904: 0xF7AA,
	40008 - 11904: 0xF7AB,
	40009 - 11904: 0xC5BE,
	40010 - 11904: 0xF85A,
	40011 - 11904: 0xF85C,
	40012 - 11904: 0xF85F,
	40013 - 11904: 0xF85B,
	40014 - 11904: 0xF860,
	40015 - 11904: 0x96AD,
	40016 - 11904: 0xF859,
	40018 - 11904: 0xF857,
	40019 - 11904: 0x96AE,
	40020 - 11904: 0xC5EB,
	40021 - 11904: 0xF85D,
	40022 - 11904: 0xC5ED,
	40023 - 11904: 0xC5EC,
	40024 - 11904: 0xF858,
	40025 - 11904: 0xF85E,
	40029 - 11904: 0x9EA1,
	40030 - 11904: 0xF8DA,
	40031 - 11904: 0xC64D,
	40032 - 11904: 0xF8DB,
	40034 - 11904: 0xF8D9,
	40035 - 11904: 0xF8D6,
	40038 - 11904: 0xF8D8,
	40039 - 11904: 0xF8D7,
	40040 - 11904: 0xF95A,
	40045 - 11904: 0xF95C,
	40046 - 11904: 0xF95B,
	40049 - 11904: 0xF979,
	40050 - 11904: 0x9E50,
	40051 - 11904: 0xF978,
	40052 - 11904: 0xF977,
	40053 - 11904: 0xF97A,
	40055 - 11904: 0xC673,
	40056 - 11904: 0xC674,
	40057 - 11904: 0xF9CA,
	40058 - 11904: 0xF9CE,
	40059 - 11904: 0x96AF,
	40060 - 11904: 0x8BF4,
	40165 - 11904: 0xB3BE,
	40166 - 11904: 0xDCAF,
	40167 - 11904: 0xE0ED,
	40169 - 11904: 0xB9A7,
	40170 - 11904: 0xE0EB,
	40173 - 11904: 0xE0EC,
	40177 - 11904: 0xE4E2,
	40178 - 11904: 0xE4E3,
	40179 - 11904: 0xBBF1,
	40180 - 11904: 0xBBEF,
	40181 - 11904: 0xE4E4,
	40182 - 11904: 0xBBF0,
	40183 - 11904: 0xE8E8,
	40185 - 11904: 0xE8EB,
	40186 - 11904: 0xE8E5,
	40187 - 11904: 0xE8EC,
	40188 - 11904: 0xE8E4,
	40189 - 11904: 0xE8E6,
	40191 - 11904: 0xE8E7,
	40192 - 11904: 0xE8EA,
	40194 - 11904: 0x9FA4,
	40195 - 11904: 0xBEA1,
	40196 - 11904: 0xE8EF,
	40197 - 11904: 0xE8EE,
	40198 - 11904: 0xBE7D,
	40199 - 11904: 0xE8E9,
	40200 - 11904: 0xE8ED,
	40201 - 11904: 0xBE7E,
	40204 - 11904: 0x96BD,
	40208 - 11904: 0xECAC,
	40210 - 11904: 0xC06F,
	40212 - 11904: 0xECA7,
	40213 - 11904: 0xC06B,
	40214 - 11904: 0x96F4,
	40215 - 11904: 0xECA4,
	40216 - 11904: 0xECAA,
	40217 - 11904: 0xECAD,
	40219 - 11904: 0xC070,
	40221 - 11904: 0xECA9,
	40222 - 11904: 0xECA6,
	40223 - 11904: 0xECAE,
	40224 - 11904: 0xECA5,
	40225 - 11904: 0x96B8,
	40226 - 11904: 0xECAB,
	40227 - 11904: 0xC06C,
	40229 - 11904: 0xECA3,
	40230 - 11904: 0xC06D,
	40232 - 11904: 0xC06E,
	40233 - 11904: 0xECA8,
	40237 - 11904: 0xEFA9,
	40238 - 11904: 0xEF7A,
	40239 - 11904: 0xEF7B,
	40240 - 11904: 0xEF7E,
	40241 - 11904: 0xEF7C,
	40243 - 11904: 0xEF76,
	40244 - 11904: 0xFAA1,
	40246 - 11904: 0xEF79,
	40247 - 11904: 0xEFA5,
	40248 - 11904: 0xEF7D,
	40249 - 11904: 0x91A7,
	40251 - 11904: 0xC245,
	40253 - 11904: 0xEFA7,
	40254 - 11904: 0xEFA4,
	40255 - 11904: 0xC246,
	40256 - 11904: 0xEFA6,
	40257 - 11904: 0xEF77,
	40258 - 11904: 0xEFA2,
	40259 - 11904: 0xEFA3,
	40260 - 11904: 0xA05E,
	40261 - 11904: 0xEFA1,
	40265 - 11904: 0x9A7D,
	40266 - 11904: 0xF1D2,
	40267 - 11904: 0xF1D4,
	40268 - 11904: 0xF1D7,
	40270 - 11904: 0x8948,
	40271 - 11904: 0xF1D1,
	40272 - 11904: 0x9EB1,
	40273 - 11904: 0xC359,
	40274 - 11904: 0xF1D9,
	40275 - 11904: 0xF1D0,
	40276 - 11904: 0xF1DA,
	40278 - 11904: 0xF1D6,
	40279 - 11904: 0xF1D8,
	40280 - 11904: 0xF1DC,
	40281 - 11904: 0xF1D5,
	40282 - 11904: 0xF1DD,
	40283 - 11904: 0xF1D3,
	40284 - 11904: 0xF1CF,
	40285 - 11904: 0xC35A,
	40286 - 11904: 0x9DDB,
	40287 - 11904: 0xF1DB,
	40288 - 11904: 0xC35B,
	40289 - 11904: 0xC44D,
	40295 - 11904: 0xEF78,
	40296 - 11904: 0xF3F1,
	40297 - 11904: 0xF3E8,
	40298 - 11904: 0xC44F,
	40299 - 11904: 0xF3E4,
	40300 - 11904: 0xC450,
	40301 - 11904: 0x95BF,
	40302 - 11904: 0x8A73,
	40303 - 11904: 0xF3ED,
	40304 - 11904: 0xF3E7,
	40305 - 11904: 0xF3DD,
	40306 - 11904: 0xC44E,
	40307 - 11904: 0xF3EA,
	40308 - 11904: 0xF3E5,
	40309 - 11904: 0xF3E6,
	40311 - 11904: 0xF3D8,
	40312 - 11904: 0xF3DF,
	40313 - 11904: 0xF3EE,
	40315 - 11904: 0xF3EB,
	40316 - 11904: 0x9EFE,
	40317 - 11904: 0xF3E3,
	40318 - 11904: 0x917A,
	40319 - 11904: 0xF3EF,
	40320 - 11904: 0xF3DE,
	40321 - 11904: 0xF3D9,
	40322 - 11904: 0xF3EC,
	40323 - 11904: 0x917B,
	40324 - 11904: 0xF3DB,
	40325 - 11904: 0xF3E9,
	40326 - 11904: 0xF3E0,
	40327 - 11904: 0xF3F0,
	40328 - 11904: 0xF3DC,
	40329 - 11904: 0xC44C,
	40330 - 11904: 0xF3DA,
	40331 - 11904: 0xF3E1,
	40332 - 11904: 0xF3E2,
	40336 - 11904: 0xF57D,
	40338 - 11904: 0xF57B,
	40339 - 11904: 0x9AA3,
	40340 - 11904: 0xF5A2,
	40342 - 11904: 0xF5AE,
	40343 - 11904: 0xF5A5,
	40344 - 11904: 0xF57C,
	40345 - 11904: 0xF578,
	40346 - 11904: 0xF5A7,
	40347 - 11904: 0xF57E,
	40348 - 11904: 0xF5A3,
	40349 - 11904: 0xF57A,
	40350 - 11904: 0xF5AA,
	40351 - 11904: 0xF577,
	40352 - 11904: 0xF5A1,
	40353 - 11904: 0xF5A6,
	40354 - 11904: 0xF5A8,
	40355 - 11904: 0xF5AB,
	40356 - 11904: 0xF579,
	40357 - 11904: 0x96C2,
	40358 - 11904: 0xF5AF,
	40359 - 11904: 0xF5B0,
	40360 - 11904: 0xF5A9,
	40361 - 11904: 0xF5AD,
	40362 - 11904: 0xF5A4,
	40363 - 11904: 0x9F77,
	40364 - 11904: 0xF6C1,
	40365 - 11904: 0xF6C4,
	40367 - 11904: 0xC561,
	40369 - 11904: 0xF6C3,
	40370 - 11904: 0xF6C8,
	40371 - 11904: 0xF6C6,
	40372 - 11904: 0xC562,
	40373 - 11904: 0xF6BD,
	40374 - 11904: 0xF6B3,
	40375 - 11904: 0xF6B2,
	40376 - 11904: 0xC564,
	40377 - 11904: 0xF6BF,
	40378 - 11904: 0xF6C0,
	40379 - 11904: 0xF6BC,
	40380 - 11904: 0xF6B4,
	40381 - 11904: 0x9AA4,
	40382 - 11904: 0xF6B9,
	40383 - 11904: 0xF5AC,
	40384 - 11904: 0x9AA5,
	40385 - 11904: 0xF6B5,
	40386 - 11904: 0xC563,
	40387 - 11904: 0xF6BB,
	40388 - 11904: 0x91A1,
	40389 - 11904: 0xF6BA,
	40391 - 11904: 0xF6B6,
	40392 - 11904: 0xF6C2,
	40393 - 11904: 0x89B8,
	40394 - 11904: 0xF6B7,
	40395 - 11904: 0xF7BB,
	40396 - 11904: 0xF6C5,
	40397 - 11904: 0xF6C7,
	40398 - 11904: 0xF6BE,
	40399 - 11904: 0xF6B8,
	40400 - 11904: 0xF7BC,
	40401 - 11904: 0xF7BE,
	40402 - 11904: 0xF7B8,
	40403 - 11904: 0xC5C2,
	40404 - 11904: 0x9173,
	40405 - 11904: 0xF7C5,
	40406 - 11904: 0xF7C3,
	40407 - 11904: 0xC5C3,
	40408 - 11904: 0xF7C2,
	40409 - 11904: 0xF7C1,
	40410 - 11904: 0xF7BA,
	40411 - 11904: 0xF7B7,
	40412 - 11904: 0xF7BD,
	40413 - 11904: 0xF7C6,
	40414 - 11904: 0xF7B9,
	40415 - 11904: 0xF7BF,
	40417 - 11904: 0xF869,
	40418 - 11904: 0xF86E,
	40419 - 11904: 0xF864,
	40420 - 11904: 0xF867,
	40421 - 11904: 0xC5EE,
	40422 - 11904: 0xF86B,
	40424 - 11904: 0xF872,
	40425 - 11904: 0xF7C0,
	40427 - 11904: 0xF865,
	40428 - 11904: 0xF86F,
	40429 - 11904: 0xF873,
	40430 - 11904: 0xF86A,
	40431 - 11904: 0xF863,
	40432 - 11904: 0xF86D,
	40434 - 11904: 0xF86C,
	40435 - 11904: 0xF871,
	40436 - 11904: 0xF870,
	40437 - 11904: 0xF7C4,
	40438 - 11904: 0xF868,
	40439 - 11904: 0xF862,
	40440 - 11904: 0xF866,
	40441 - 11904: 0xC64E,
	40442 - 11904: 0xC64F,
	40443 - 11904: 0xF861,
	40444 - 11904: 0x9AA6,
	40445 - 11904: 0xF8E6,
	40446 - 11904: 0xF8DD,
	40447 - 11904: 0xF8E5,
	40448 - 11904: 0xF8E2,
	40449 - 11904: 0xF8E3,
	40450 - 11904: 0xF8DC,
	40451 - 11904: 0xF8DF,
	40452 - 11904: 0xF8E7,
	40453 - 11904: 0xF8E1,
	40454 - 11904: 0xF8E0,
	40455 - 11904: 0xF8DE,
	40457 - 11904: 0xF8E4,
	40458 - 11904: 0x89BD,
	40459 - 11904: 0xF95D,
	40460 - 11904: 0x89B9,
	40461 - 11904: 0xF95E,
	40462 - 11904: 0x917D,
	40463 - 11904: 0xF960,
	40464 - 11904: 0xF95F,
	40465 - 11904: 0xF962,
	40466 - 11904: 0xF961,
	40467 - 11904: 0xF97C,
	40468 - 11904: 0xF97B,
	40469 - 11904: 0xF9B7,
	40471 - 11904: 0xF9B8,
	40472 - 11904: 0x96BB,
	40473 - 11904: 0xF9C5,
	40474 - 11904: 0xC678,
	40475 - 11904: 0xC67C,
	40476 - 11904: 0x9FF2,
	40477 - 11904: 0xF9CF,
	40478 - 11904: 0xC67D,
	40479 - 11904: 0x8BF5,
	40565 - 11904: 0xB3BF,
	40569 - 11904: 0xC4D0,
	40570 - 11904: 0xF6C9,
	40571 - 11904: 0x9AA9,
	40572 - 11904: 0xC650,
	40573 - 11904: 0xC651,
	40575 - 11904: 0xB3C0,
	40576 - 11904: 0xE0EE,
	40577 - 11904: 0x9F54,
	40578 - 11904: 0xB9A8,
	40579 - 11904: 0xE8F0,
	40580 - 11904: 0x9FE3,
	40581 - 11904: 0x9EED,
	40582 - 11904: 0xECB0,
	40583 - 11904: 0xECB1,
	40584 - 11904: 0xECAF,
	40585 - 11904: 0xEFAB,
	40586 - 11904: 0xEFAA,
	40587 - 11904: 0xC247,
	40588 - 11904: 0xF1DF,
	40589 - 11904: 0xEFAC,
	40590 - 11904: 0xF1DE,
	40592 - 11904: 0x91AA,
	40593 - 11904: 0xF3F3,
	40594 - 11904: 0xC451,
	40595 - 11904: 0xC453,
	40596 - 11904: 0xF3F2,
	40597 - 11904: 0x91AB,
	40598 - 11904: 0xA070,
	40599 - 11904: 0xC452,
	40600 - 11904: 0x9F6D,
	40601 - 11904: 0xF5B1,
	40602 - 11904: 0xF5B3,
	40603 - 11904: 0xF5B2,
	40604 - 11904: 0xF6CA,
	40605 - 11904: 0xC565,
	40606 - 11904: 0x91AC,
	40607 - 11904: 0xC5EF,
	40608 - 11904: 0xF8E8,
	40609 - 11904: 0xF963,
	40610 - 11904: 0x91AD,
	40612 - 11904: 0xF9D2,
	40613 - 11904: 0xB3C1,
	40614 - 11904: 0xA0FD,
	40615 - 11904: 0xE4E5,
	40616 - 11904: 0x9FE2,
	40617 - 11904: 0xBEA2,
	40618 - 11904: 0x91AF,
	40619 - 11904: 0x9E41,
	40620 - 11904: 0x9AAA,
	40621 - 11904: 0xECB3,
	40622 - 11904: 0xECB2,
	40623 - 11904: 0x91B0,
	40624 - 11904: 0xEFAD,
	40625 - 11904: 0x9AAB,
	40628 - 11904: 0xC454,
	40629 - 11904: 0xC4D1,
	40630 - 11904: 0xF7C7,
	40631 - 11904: 0xF9CB,
	40635 - 11904: 0xB3C2,
	40636 - 11904: 0xBBF2,
	40637 - 11904: 0x9AAC,
	40638 - 11904: 0xBEA3,
	40639 - 11904: 0x9A4A,
	40640 - 11904: 0xF3F4,
	40641 - 11904: 0x91B2,
	40642 - 11904: 0xF874,
	40643 - 11904: 0xB6C0,
	40644 - 11904: 0x8BF6,
	40646 - 11904: 0x9AAD,
	40647 - 11904: 0x89B6,
	40648 - 11904: 0xEFAE,
	40652 - 11904: 0xC664,
	40653 - 11904: 0xB6C1,
	40654 - 11904: 0xBEA4,
	40655 - 11904: 0xC248,
	40656 - 11904: 0xF875,
	40657 - 11904: 0xB6C2,
	40659 - 11904: 0xE8F1,
	40660 - 11904: 0xC072,
	40661 - 11904: 0xECB4,
	40662 - 11904: 0xECB5,
	40664 - 11904: 0xC071,
	40666 - 11904: 0xEFAF,
	40667 - 11904: 0xC24C,
	40668 - 11904: 0xC24A,
	40669 - 11904: 0xC24B,
	40670 - 11904: 0xC249,
	40671 - 11904: 0xF1E0,
	40672 - 11904: 0xC35C,
	40674 - 11904: 0x9AAF,
	40676 - 11904: 0xF5B5,
	40677 - 11904: 0xF5B4,
	40678 - 11904: 0xF5B7,
	40679 - 11904: 0xF5B6,
	40680 - 11904: 0xC4D2,
	40683 - 11904: 0xF6CB,
	40685 - 11904: 0xF6CD,
	40686 - 11904: 0xF6CC,
	40687 - 11904: 0xC566,
	40688 - 11904: 0xF7C8,
	40689 - 11904: 0x9AB0,
	40690 - 11904: 0xF876,
	40691 - 11904: 0xF877,
	40692 - 11904: 0xC5F0,
	40693 - 11904: 0xF964,
	40694 - 11904: 0xF97D,
	40695 - 11904: 0xC675,
	40696 - 11904: 0x9AB1,
	40697 - 11904: 0xDCB0,
	40698 - 11904: 0xECB6,
	40699 - 11904: 0xEFB0,
	40700 - 11904: 0xF3F5,
	40701 - 11904: 0xE0EF,
	40702 - 11904: 0x9AA1,
	40703 - 11904: 0xEFB1,
	40704 - 11904: 0xF1E2,
	40705 - 11904: 0xF1E1,
	40706 - 11904: 0x91B9,
	40710 - 11904: 0xF878,
	40711 - 11904: 0xC652,
	40712 - 11904: 0x91BA,
	40713 - 11904: 0xF965,
	40714 - 11904: 0xF97E,
	40718 - 11904: 0xB9A9,
	40719 - 11904: 0xE8F2,
	40720 - 11904: 0xE8F3,
	40722 - 11904: 0xECB7,
	40723 - 11904: 0xB9AA,
	40725 - 11904: 0xC35D,
	40726 - 11904: 0xF1E3,
	40727 - 11904: 0x9F66,
	40728 - 11904: 0xF6CF,
	40729 - 11904: 0xC567,
	40730 - 11904: 0xF6D0,
	40731 - 11904: 0xF6CE,
	40732 - 11904: 0xF879,
	40734 - 11904: 0xF8E9,
	40736 - 11904: 0xB9AB,
	40738 - 11904: 0xEFB4,
	40739 - 11904: 0xEFB3,
	40740 - 11904: 0xEFB2,
	40741 - 11904: 0xF1E4,
	40742 - 11904: 0xA041,
	40743 - 11904: 0x8BB7,
	40744 - 11904: 0xF1E8,
	40745 - 11904: 0xF1E7,
	40746 - 11904: 0xF1E6,
	40747 - 11904: 0xF1E5,
	40748 - 11904: 0xC35E,
	40749 - 11904: 0xF3F6,
	40750 - 11904: 0xF5B9,
	40751 - 11904: 0xC4D3,
	40752 - 11904: 0xF5B8,
	40753 - 11904: 0xF6D1,
	40754 - 11904: 0xF7CB,
	40755 - 11904: 0xF7CA,
	40756 - 11904: 0xC5C4,
	40757 - 11904: 0xF7C9,
	40758 - 11904: 0xF87C,
	40759 - 11904: 0xF87B,
	40760 - 11904: 0xF87A,
	40761 - 11904: 0x91C0,
	40763 - 11904: 0xBBF3,
	40765 - 11904: 0xECB8,
	40766 - 11904: 0xC24D,
	40768 - 11904: 0xF3F7,
	40769 - 11904: 0xF3F8,
	40770 - 11904: 0xF7CC,
	40771 - 11904: 0xF87D,
	40772 - 11904: 0x9AB3,
	40773 - 11904: 0x91C3,
	40774 - 11904: 0xF8EA,
	40775 - 11904: 0xF966,
	40776 - 11904: 0xF9B9,
	40777 - 11904: 0xF9D4,
	40778 - 11904: 0xBBF4,
	40779 - 11904: 0xC24E,
	40780 - 11904: 0xF1E9,
	40781 - 11904: 0xF3F9,
	40782 - 11904: 0xF6D2,
	40783 - 11904: 0xF87E,
	40784 - 11904: 0xA0FC,
	40786 - 11904: 0xBEA6,
	40787 - 11904: 0x9FEE,
	40788 - 11904: 0xEFB5,
	40789 - 11904: 0xF1EA,
	40790 - 11904: 0xF3FA,
	40791 - 11904: 0xF3FB,
	40792 - 11904: 0xF3FC,
	40793 - 11904: 0xF5BE,
	40794 - 11904: 0x9F69,
	40795 - 11904: 0xF5BA,
	40796 - 11904: 0xC568,
	40797 - 11904: 0xF5BD,
	40798 - 11904: 0xF5BC,
	40799 - 11904: 0xC4D4,
	40800 - 11904: 0xF5BB,
	40801 - 11904: 0xC4D6,
	40802 - 11904: 0x91C8,
	40803 - 11904: 0xC4D5,
	40804 - 11904: 0xF6D4,
	40805 - 11904: 0xF6D3,
	40806 - 11904: 0xC569,
	40807 - 11904: 0xC56A,
	40809 - 11904: 0x91C9,
	40810 - 11904: 0xC5C6,
	40811 - 11904: 0xF7CD,
	40812 - 11904: 0xC5C5,
	40814 - 11904: 0xF8A3,
	40815 - 11904: 0xF8A4,
	40816 - 11904: 0xF8A2,
	40817 - 11904: 0xF8A1,
	40818 - 11904: 0xC654,
	40820 - 11904: 0xF8EB,
	40821 - 11904: 0xF8EC,
	40822 - 11904: 0xF8ED,
	40823 - 11904: 0xC653,
	40824 - 11904: 0xF967,
	40825 - 11904: 0xF96A,
	40826 - 11904: 0xF969,
	40827 - 11904: 0xF968,
	40830 - 11904: 0xF9D3,
	40831 - 11904: 0x8DE6,
	40845 - 11904: 0xC073,
	40846 - 11904: 0x91CB,
	40848 - 11904: 0xC365,
	40849 - 11904: 0xF5BF,
	40850 - 11904: 0xF6D5,
	40852 - 11904: 0xC5C7,
	40853 - 11904: 0xF7CE,
	40854 - 11904: 0x87AC,
	40855 - 11904: 0x87A4,
	40856 - 11904: 0xF9D5,
	40857 - 11904: 0x89C8,
	40860 - 11904: 0xC074,
	40863 - 11904: 0x8DAA,
	40864 - 11904: 0xEFB6,
	40866 - 11904: 0xF7CF,
	40868 - 11904: 0xF9A1,
	40869 - 11904: 0x9FDD,
	40870 - 11904: 0x8C43,
	40871 - 11904: 0x8C6D,
	40872 - 11904: 0x8C74,
	40873 - 11904: 0x8CB7,
	40874 - 11904: 0x8CB9,
	40875 - 11904: 0x8CBB,
	40876 - 11904: 0x8CC0,
	40877 - 11904: 0x8CD7,
	40878 - 11904: 0x8CD8,
	40879 - 11904: 0x8CDA,
	40880 - 11904: 0xC8A1,
	40881 - 11904: 0xC8A3,
	40882 - 11904: 0x8CED,
	40883 - 11904: 0x8D48,
	40903 - 11904: 0x87C2,
	40904 - 11904: 0x87D2,
	40905 - 11904: 0x87D6,
	40906 - 11904: 0x87DA,
	40907 - 11904: 0x87DF,
}

const encode2Low, encode2High = 7870, 10046

var encode2 = [...]uint16{
	7870 - 7870:  0x8863,
	7871 - 7870:  0x88A4,
	7872 - 7870:  0x8865,
	7873 - 7870:  0x88A6,
	8211 - 7870:  0xA156,
	8212 - 7870:  0xA158,
	8216 - 7870:  0xA1A5,
	8217 - 7870:  0xA1A6,
	8220 - 7870:  0xA1A7,
	8221 - 7870:  0xA1A8,
	8229 - 7870:  0xA14C,
	8230 - 7870:  0xA14B,
	8231 - 7870:  0xA145,
	8242 - 7870:  0xA1AC,
	8245 - 7870:  0xA1AB,
	8251 - 7870:  0xA1B0,
	8364 - 7870:  0xA3E1,
	8451 - 7870:  0xA24A,
	8453 - 7870:  0xA1C1,
	8457 - 7870:  0xA24B,
	8470 - 7870:  0xC8D2,
	8481 - 7870:  0xC8D3,
	8544 - 7870:  0xA2B9,
	8545 - 7870:  0xA2BA,
	8546 - 7870:  0xA2BB,
	8547 - 7870:  0xA2BC,
	8548 - 7870:  0xA2BD,
	8549 - 7870:  0xA2BE,
	8550 - 7870:  0xA2BF,
	8551 - 7870:  0xA2C0,
	8552 - 7870:  0xA2C1,
	8553 - 7870:  0xA2C2,
	8560 - 7870:  0xC6B5,
	8561 - 7870:  0xC6B6,
	8562 - 7870:  0xC6B7,
	8563 - 7870:  0xC6B8,
	8564 - 7870:  0xC6B9,
	8565 - 7870:  0xC6BA,
	8566 - 7870:  0xC6BB,
	8567 - 7870:  0xC6BC,
	8568 - 7870:  0xC6BD,
	8569 - 7870:  0xC6BE,
	8592 - 7870:  0xA1F6,
	8593 - 7870:  0xA1F4,
	8594 - 7870:  0xA1F7,
	8595 - 7870:  0xA1F5,
	8598 - 7870:  0xA1F8,
	8599 - 7870:  0xA1F9,
	8600 - 7870:  0xA1FB,
	8601 - 7870:  0xA1FA,
	8632 - 7870:  0xC877,
	8633 - 7870:  0xC878,
	8679 - 7870:  0xC876,
	8725 - 7870:  0xA241,
	8730 - 7870:  0xA1D4,
	8734 - 7870:  0xA1DB,
	8735 - 7870:  0xA1E8,
	8736 - 7870:  0xA1E7,
	8739 - 7870:  0xA1FD,
	8741 - 7870:  0xA1FC,
	8745 - 7870:  0xA1E4,
	8746 - 7870:  0xA1E5,
	8747 - 7870:  0xA1EC,
	8750 - 7870:  0xA1ED,
	8756 - 7870:  0xA1EF,
	8757 - 7870:  0xA1EE,
	8786 - 7870:  0xA1DC,
	8800 - 7870:  0xA1DA,
	8801 - 7870:  0xA1DD,
	8806 - 7870:  0xA1D8,
	8807 - 7870:  0xA1D9,
	8853 - 7870:  0xA1F2,
	8857 - 7870:  0xA1F3,
	8869 - 7870:  0xA1E6,
	8895 - 7870:  0xA1E9,
	9178 - 7870:  0x88A9,
	9179 - 7870:  0x88AA,
	9216 - 7870:  0xA3C0,
	9217 - 7870:  0xA3C1,
	9218 - 7870:  0xA3C2,
	9219 - 7870:  0xA3C3,
	9220 - 7870:  0xA3C4,
	9221 - 7870:  0xA3C5,
	9222 - 7870:  0xA3C6,
	9223 - 7870:  0xA3C7,
	9224 - 7870:  0xA3C8,
	9225 - 7870:  0xA3C9,
	9226 - 7870:  0xA3CA,
	9227 - 7870:  0xA3CB,
	9228 - 7870:  0xA3CC,
	9229 - 7870:  0xA3CD,
	9230 - 7870:  0xA3CE,
	9231 - 7870:  0xA3CF,
	9232 - 7870:  0xA3D0,
	9233 - 7870:  0xA3D1,
	9234 - 7870:  0xA3D2,
	9235 - 7870:  0xA3D3,
	9236 - 7870:  0xA3D4,
	9237 - 7870:  0xA3D5,
	9238 - 7870:  0xA3D6,
	9239 - 7870:  0xA3D7,
	9240 - 7870:  0xA3D8,
	9241 - 7870:  0xA3D9,
	9242 - 7870:  0xA3DA,
	9243 - 7870:  0xA3DB,
	9244 - 7870:  0xA3DC,
	9245 - 7870:  0xA3DD,
	9246 - 7870:  0xA3DE,
	9247 - 7870:  0xA3DF,
	9249 - 7870:  0xA3E0,
	9312 - 7870:  0xC6A1,
	9313 - 7870:  0xC6A2,
	9314 - 7870:  0xC6A3,
	9315 - 7870:  0xC6A4,
	9316 - 7870:  0xC6A5,
	9317 - 7870:  0xC6A6,
	9318 - 7870:  0xC6A7,
	9319 - 7870:  0xC6A8,
	9320 - 7870:  0xC6A9,
	9321 - 7870:  0xC6AA,
	9332 - 7870:  0xC6AB,
	9333 - 7870:  0xC6AC,
	9334 - 7870:  0xC6AD,
	9335 - 7870:  0xC6AE,
	9336 - 7870:  0xC6AF,
	9337 - 7870:  0xC6B0,
	9338 - 7870:  0xC6B1,
	9339 - 7870:  0xC6B2,
	9340 - 7870:  0xC6B3,
	9341 - 7870:  0xC6B4,
	9472 - 7870:  0xA277,
	9474 - 7870:  0xA278,
	9484 - 7870:  0xA27A,
	9488 - 7870:  0xA27B,
	9492 - 7870:  0xA27C,
	9496 - 7870:  0xA27D,
	9500 - 7870:  0xA275,
	9508 - 7870:  0xA274,
	9516 - 7870:  0xA273,
	9524 - 7870:  0xA272,
	9532 - 7870:  0xA271,
	9552 - 7870:  0xF9F9,
	9553 - 7870:  0xF9F8,
	9554 - 7870:  0xF9E6,
	9555 - 7870:  0xF9EF,
	9556 - 7870:  0xF9DD,
	9557 - 7870:  0xF9E8,
	9558 - 7870:  0xF9F1,
	9559 - 7870:  0xF9DF,
	9560 - 7870:  0xF9EC,
	9561 - 7870:  0xF9F5,
	9562 - 7870:  0xF9E3,
	9563 - 7870:  0xF9EE,
	9564 - 7870:  0xF9F7,
	9565 - 7870:  0xF9E5,
	9566 - 7870:  0xF9E9,
	9567 - 7870:  0xF9F2,
	9568 - 7870:  0xF9E0,
	9569 - 7870:  0xF9EB,
	9570 - 7870:  0xF9F4,
	9571 - 7870:  0xF9E2,
	9572 - 7870:  0xF9E7,
	9573 - 7870:  0xF9F0,
	9574 - 7870:  0xF9DE,
	9575 - 7870:  0xF9ED,
	9576 - 7870:  0xF9F6,
	9577 - 7870:  0xF9E4,
	9578 - 7870:  0xF9EA,
	9579 - 7870:  0xF9F3,
	9580 - 7870:  0xF9E1,
	9581 - 7870:  0xF9FA,
	9582 - 7870:  0xF9FB,
	9583 - 7870:  0xF9FD,
	9584 - 7870:  0xF9FC,
	9585 - 7870:  0xA2AC,
	9586 - 7870:  0xA2AD,
	9587 - 7870:  0xA2AE,
	9588 - 7870:  0xA15A,
	9601 - 7870:  0xA262,
	9602 - 7870:  0xA263,
	9603 - 7870:  0xA264,
	9604 - 7870:  0xA265,
	9605 - 7870:  0xA266,
	9606 - 7870:  0xA267,
	9607 - 7870:  0xA268,
	9608 - 7870:  0xA269,
	9609 - 7870:  0xA270,
	9610 - 7870:  0xA26F,
	9611 - 7870:  0xA26E,
	9612 - 7870:  0xA26D,
	9613 - 7870:  0xA26C,
	9614 - 7870:  0xA26B,
	9615 - 7870:  0xA26A,
	9620 - 7870:  0xA276,
	9621 - 7870:  0xA279,
	9632 - 7870:  0xA1BD,
	9633 - 7870:  0xA1BC,
	9650 - 7870:  0xA1B6,
	9651 - 7870:  0xA1B5,
	9660 - 7870:  0xA1BF,
	9661 - 7870:  0xA1BE,
	9670 - 7870:  0xA1BB,
	9671 - 7870:  0xA1BA,
	9675 - 7870:  0xA1B3,
	9678 - 7870:  0xA1B7,
	9679 - 7870:  0xA1B4,
	9698 - 7870:  0xA2A8,
	9699 - 7870:  0xA2A9,
	9700 - 7870:  0xA2AB,
	9701 - 7870:  0xA2AA,
	9733 - 7870:  0xA1B9,
	9734 - 7870:  0xA1B8,
	9792 - 7870:  0xA1F0,
	9794 - 7870:  0xA1F1,
	10045 - 7870: 0xC6E6,
}

const encode3Low, encode3High = 167, 1106

var encode3 = [...]uint16{
	167 - 167:  0xA1B1,
	168 - 167:  0xC6D8,
	175 - 167:  0xA1C2,
	176 - 167:  0xA258,
	177 - 167:  0xA1D3,
	183 - 167:  0xA150,
	192 - 167:  0x8859,
	193 - 167:  0x8857,
	200 - 167:  0x885D,
	201 - 167:  0x885B,
	202 - 167:  0x8866,
	210 - 167:  0x8861,
	211 - 167:  0x885F,
	215 - 167:  0xA1D1,
	224 - 167:  0x886A,
	225 - 167:  0x8868,
	232 - 167:  0x886F,
	233 - 167:  0x886D,
	234 - 167:  0x88A7,
	236 - 167:  0x8873,
	237 - 167:  0x8871,
	242 - 167:  0x8877,
	243 - 167:  0x8875,
	247 - 167:  0xA1D2,
	248 - 167:  0xC8FB,
	249 - 167:  0x887B,
	250 - 167:  0x8879,
	252 - 167:  0x88A2,
	256 - 167:  0x8856,
	257 - 167:  0x8867,
	274 - 167:  0x885A,
	275 - 167:  0x886C,
	282 - 167:  0x885C,
	283 - 167:  0x886E,
	299 - 167:  0x8870,
	331 - 167:  0xC8FC,
	332 - 167:  0x885E,
	333 - 167:  0x8874,
	339 - 167:  0xC8FA,
	363 - 167:  0x8878,
	461 - 167:  0x8858,
	462 - 167:  0x8869,
	464 - 167:  0x8872,
	465 - 167:  0x8860,
	466 - 167:  0x8876,
	468 - 167:  0x887A,
	470 - 167:  0x887C,
	472 - 167:  0x887D,
	474 - 167:  0x887E,
	476 - 167:  0x88A1,
	592 - 167:  0xC8F6,
	593 - 167:  0x886B,
	596 - 167:  0xC8F8,
	603 - 167:  0xC8F7,
	609 - 167:  0x88A8,
	618 - 167:  0xC8FE,
	629 - 167:  0xC8F9,
	643 - 167:  0xC8F5,
	650 - 167:  0xC8FD,
	710 - 167:  0xC6D9,
	711 - 167:  0xA3BE,
	713 - 167:  0xA3BC,
	714 - 167:  0xA3BD,
	715 - 167:  0xA3BF,
	717 - 167:  0xA1C5,
	729 - 167:  0xA3BB,
	913 - 167:  0xA344,
	914 - 167:  0xA345,
	915 - 167:  0xA346,
	916 - 167:  0xA347,
	917 - 167:  0xA348,
	918 - 167:  0xA349,
	919 - 167:  0xA34A,
	920 - 167:  0xA34B,
	921 - 167:  0xA34C,
	922 - 167:  0xA34D,
	923 - 167:  0xA34E,
	924 - 167:  0xA34F,
	925 - 167:  0xA350,
	926 - 167:  0xA351,
	927 - 167:  0xA352,
	928 - 167:  0xA353,
	929 - 167:  0xA354,
	931 - 167:  0xA355,
	932 - 167:  0xA356,
	933 - 167:  0xA357,
	934 - 167:  0xA358,
	935 - 167:  0xA359,
	936 - 167:  0xA35A,
	937 - 167:  0xA35B,
	945 - 167:  0xA35C,
	946 - 167:  0xA35D,
	947 - 167:  0xA35E,
	948 - 167:  0xA35F,
	949 - 167:  0xA360,
	950 - 167:  0xA361,
	951 - 167:  0xA362,
	952 - 167:  0xA363,
	953 - 167:  0xA364,
	954 - 167:  0xA365,
	955 - 167:  0xA366,
	956 - 167:  0xA367,
	957 - 167:  0xA368,
	958 - 167:  0xA369,
	959 - 167:  0xA36A,
	960 - 167:  0xA36B,
	961 - 167:  0xA36C,
	963 - 167:  0xA36D,
	964 - 167:  0xA36E,
	965 - 167:  0xA36F,
	966 - 167:  0xA370,
	967 - 167:  0xA371,
	968 - 167:  0xA372,
	969 - 167:  0xA373,
	1025 - 167: 0xC7F9,
	1040 - 167: 0xC7F3,
	1041 - 167: 0xC7F4,
	1042 - 167: 0xC7F5,
	1043 - 167: 0xC7F6,
	1044 - 167: 0xC7F7,
	1045 - 167: 0xC7F8,
	1046 - 167: 0xC7FA,
	1047 - 167: 0xC7FB,
	1048 - 167: 0xC7FC,
	1049 - 167: 0xC7FD,
	1050 - 167: 0xC7FE,
	1051 - 167: 0xC840,
	1052 - 167: 0xC841,
	1053 - 167: 0xC842,
	1054 - 167: 0xC843,
	1055 - 167: 0xC844,
	1056 - 167: 0xC845,
	1057 - 167: 0xC846,
	1058 - 167: 0xC847,
	1059 - 167: 0xC848,
	1060 - 167: 0xC849,
	1061 - 167: 0xC84A,
	1062 - 167: 0xC84B,
	1063 - 167: 0xC84C,
	1064 - 167: 0xC84D,
	1065 - 167: 0xC84E,
	1066 - 167: 0xC84F,
	1067 - 167: 0xC850,
	1068 - 167: 0xC851,
	1069 - 167: 0xC852,
	1070 - 167: 0xC853,
	1071 - 167: 0xC854,
	1072 - 167: 0xC855,
	1073 - 167: 0xC856,
	1074 - 167: 0xC857,
	1075 - 167: 0xC858,
	1076 - 167: 0xC859,
	1077 - 167: 0xC85A,
	1078 - 167: 0xC85C,
	1079 - 167: 0xC85D,
	1080 - 167: 0xC85E,
	1081 - 167: 0xC85F,
	1082 - 167: 0xC860,
	1083 - 167: 0xC861,
	1084 - 167: 0xC862,
	1085 - 167: 0xC863,
	1086 - 167: 0xC864,
	1087 - 167: 0xC865,
	1088 - 167: 0xC866,
	1089 - 167: 0xC867,
	1090 - 167: 0xC868,
	1091 - 167: 0xC869,
	1092 - 167: 0xC86A,
	1093 - 167: 0xC86B,
	1094 - 167: 0xC86C,
	1095 - 167: 0xC86D,
	1096 - 167: 0xC86E,
	1097 - 167: 0xC86F,
	1098 - 167: 0xC870,
	1099 - 167: 0xC871,
	1100 - 167: 0xC872,
	1101 - 167: 0xC873,
	1102 - 167: 0xC874,
	1103 - 167: 0xC875,
	1105 - 167: 0xC85B,
}

const encode4Low, encode4High = 65072, 65518

var encode4 = [...]uint16{
	65072 - 65072: 0xA14A,
	65073 - 65072: 0xA157,
	65075 - 65072: 0xA159,
	65076 - 65072: 0xA15B,
	65077 - 65072: 0xA15F,
	65078 - 65072: 0xA160,
	65079 - 65072: 0xA163,
	65080 - 65072: 0xA164,
	65081 - 65072: 0xA167,
	65082 - 65072: 0xA168,
	65083 - 65072: 0xA16B,
	65084 - 65072: 0xA16C,
	65085 - 65072: 0xA16F,
	65086 - 65072: 0xA170,
	65087 - 65072: 0xA173,
	65088 - 65072: 0xA174,
	65089 - 65072: 0xA177,
	65090 - 65072: 0xA178,
	65091 - 65072: 0xA17B,
	65092 - 65072: 0xA17C,
	65097 - 65072: 0xA1C6,
	65098 - 65072: 0xA1C7,
	65099 - 65072: 0xA1CA,
	65100 - 65072: 0xA1CB,
	65101 - 65072: 0xA1C8,
	65102 - 65072: 0xA1C9,
	65103 - 65072: 0xA15C,
	65104 - 65072: 0xA14D,
	65105 - 65072: 0xA14E,
	65106 - 65072: 0xA14F,
	65108 - 65072: 0xA151,
	65109 - 65072: 0xA152,
	65110 - 65072: 0xA153,
	65111 - 65072: 0xA154,
	65113 - 65072: 0xA17D,
	65114 - 65072: 0xA17E,
	65115 - 65072: 0xA1A1,
	65116 - 65072: 0xA1A2,
	65117 - 65072: 0xA1A3,
	65118 - 65072: 0xA1A4,
	65119 - 65072: 0xA1CC,
	65120 - 65072: 0xA1CD,
	65121 - 65072: 0xA1CE,
	65122 - 65072: 0xA1DE,
	65123 - 65072: 0xA1DF,
	65124 - 65072: 0xA1E0,
	65125 - 65072: 0xA1E1,
	65126 - 65072: 0xA1E2,
	65128 - 65072: 0xA242,
	65129 - 65072: 0xA24C,
	65130 - 65072: 0xA24D,
	65131 - 65072: 0xA24E,
	65281 - 65072: 0xA149,
	65282 - 65072: 0xC8D0,
	65283 - 65072: 0xA1AD,
	65284 - 65072: 0xA243,
	65285 - 65072: 0xA248,
	65286 - 65072: 0xA1AE,
	65287 - 65072: 0xC8CF,
	65288 - 65072: 0xA15D,
	65289 - 65072: 0xA15E,
	65290 - 65072: 0xA1AF,
	65291 - 65072: 0xA1CF,
	65292 - 65072: 0xA141,
	65293 - 65072: 0xA1D0,
	65294 - 65072: 0xA144,
	65295 - 65072: 0xA1FE,
	65296 - 65072: 0xA2AF,
	65297 - 65072: 0xA2B0,
	65298 - 65072: 0xA2B1,
	65299 - 65072: 0xA2B2,
	65300 - 65072: 0xA2B3,
	65301 - 65072: 0xA2B4,
	65302 - 65072: 0xA2B5,
	65303 - 65072: 0xA2B6,
	65304 - 65072: 0xA2B7,
	65305 - 65072: 0xA2B8,
	65306 - 65072: 0xA147,
	65307 - 65072: 0xA146,
	65308 - 65072: 0xA1D5,
	65309 - 65072: 0xA1D7,
	65310 - 65072: 0xA1D6,
	65311 - 65072: 0xA148,
	65312 - 65072: 0xA249,
	65313 - 65072: 0xA2CF,
	65314 - 65072: 0xA2D0,
	65315 - 65072: 0xA2D1,
	65316 - 65072: 0xA2D2,
	65317 - 65072: 0xA2D3,
	65318 - 65072: 0xA2D4,
	65319 - 65072: 0xA2D5,
	65320 - 65072: 0xA2D6,
	65321 - 65072: 0xA2D7,
	65322 - 65072: 0xA2D8,
	65323 - 65072: 0xA2D9,
	65324 - 65072: 0xA2DA,
	65325 - 65072: 0xA2DB,
	65326 - 65072: 0xA2DC,
	65327 - 65072: 0xA2DD,
	65328 - 65072: 0xA2DE,
	65329 - 65072: 0xA2DF,
	65330 - 65072: 0xA2E0,
	65331 - 65072: 0xA2E1,
	65332 - 65072: 0xA2E2,
	65333 - 65072: 0xA2E3,
	65334 - 65072: 0xA2E4,
	65335 - 65072: 0xA2E5,
	65336 - 65072: 0xA2E6,
	65337 - 65072: 0xA2E7,
	65338 - 65072: 0xA2E8,
	65339 - 65072: 0xC6E4,
	65340 - 65072: 0xA240,
	65341 - 65072: 0xC6E5,
	65343 - 65072: 0xA1C4,
	65345 - 65072: 0xA2E9,
	65346 - 65072: 0xA2EA,
	65347 - 65072: 0xA2EB,
	65348 - 65072: 0xA2EC,
	65349 - 65072: 0xA2ED,
	65350 - 65072: 0xA2EE,
	65351 - 65072: 0xA2EF,
	65352 - 65072: 0xA2F0,
	65353 - 65072: 0xA2F1,
	65354 - 65072: 0xA2F2,
	65355 - 65072: 0xA2F3,
	65356 - 65072: 0xA2F4,
	65357 - 65072: 0xA2F5,
	65358 - 65072: 0xA2F6,
	65359 - 65072: 0xA2F7,
	65360 - 65072: 0xA2F8,
	65361 - 65072: 0xA2F9,
	65362 - 65072: 0xA2FA,
	65363 - 65072: 0xA2FB,
	65364 - 65072: 0xA2FC,
	65365 - 65072: 0xA2FD,
	65366 - 65072: 0xA2FE,
	65367 - 65072: 0xA340,
	65368 - 65072: 0xA341,
	65369 - 65072: 0xA342,
	65370 - 65072: 0xA343,
	65371 - 65072: 0xA161,
	65372 - 65072: 0xA155,
	65373 - 65072: 0xA162,
	65374 - 65072: 0xA1E3,
	65504 - 65072: 0xA246,
	65505 - 65072: 0xA247,
	65506 - 65072: 0xC8CD,
	65507 - 65072: 0xA1C3,
	65508 - 65072: 0xC8CE,
	65509 - 65072: 0xA244,
	65517 - 65072: 0xF9FE,
}

const encode5Low, encode5High = 194597, 195029

var encode5 = [...]uint16{
	194597 - 194597: 0x9874,
	194619 - 194597: 0x9AC8,
	194624 - 194597: 0xA047,
	194680 - 194597: 0x8BC3,
	194708 - 194597: 0xFC48,
	194726 - 194597: 0xFC77,
	194765 - 194597: 0x9C52,
	194964 - 194597: 0x8EFD,
	194994 - 194597: 0x8FA8,
	195004 - 194597: 0x957A,
	195028 - 194597: 0x8FF0,
}

const encode6Low, encode6High = 63751, 64014

var encode6 = [...]uint16{
	63751 - 63751: 0x8BF8,
	64012 - 63751: 0xC94A,
	64013 - 63751: 0xDDFC,
}

const encode7Low, encode7High = 175615, 175616

var encode7 = [...]uint16{
	175615 - 175615: 0x87DC,
}
