# This code is part of Qiskit.
#
# (C) Copyright IBM 2024.
#
# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.

"""Coupling maps for fake backend generation and transpiler testing."""

# 5 qubits
# bidirectional
BOGOTA_CMAP = [[0, 1], [1, 0], [1, 2], [2, 1], [2, 3], [3, 2], [3, 4], [4, 3]]
LIMA_CMAP = [[0, 1], [1, 0], [1, 2], [1, 3], [2, 1], [3, 1], [3, 4], [4, 3]]
YORKTOWN_CMAP = [
    [0, 1],
    [0, 2],
    [1, 0],
    [1, 2],
    [2, 0],
    [2, 1],
    [2, 3],
    [2, 4],
    [3, 2],
    [3, 4],
    [4, 2],
    [4, 3],
]
# directional
TENERIFE_CMAP = [[1, 0], [2, 0], [2, 1], [3, 2], [3, 4], [4, 2]]

# 7 qubits
LAGOS_CMAP = [
    [0, 1],
    [1, 0],
    [1, 2],
    [1, 3],
    [2, 1],
    [3, 1],
    [3, 5],
    [4, 5],
    [5, 3],
    [5, 4],
    [5, 6],
    [6, 5],
]

# 16 qubits
RUESCHLIKON_CMAP = [
    [1, 0],
    [1, 2],
    [2, 3],
    [3, 4],
    [3, 14],
    [5, 4],
    [6, 5],
    [6, 7],
    [6, 11],
    [7, 10],
    [8, 7],
    [9, 8],
    [9, 10],
    [11, 10],
    [12, 5],
    [12, 11],
    [12, 13],
    [13, 4],
    [13, 14],
    [15, 0],
    [15, 2],
    [15, 14],
]

MELBOURNE_CMAP = [
    [1, 0],
    [1, 2],
    [2, 3],
    [4, 3],
    [4, 10],
    [5, 4],
    [5, 6],
    [5, 9],
    [6, 8],
    [7, 8],
    [9, 8],
    [9, 10],
    [11, 3],
    [11, 10],
    [11, 12],
    [12, 2],
    [13, 1],
    [13, 12],
]

# 20 qubits
ALMADEN_CMAP = [
    [0, 1],
    [1, 0],
    [1, 2],
    [1, 6],
    [2, 1],
    [2, 3],
    [3, 2],
    [3, 4],
    [3, 8],
    [4, 3],
    [5, 6],
    [5, 10],
    [6, 1],
    [6, 5],
    [6, 7],
    [7, 6],
    [7, 8],
    [7, 12],
    [8, 3],
    [8, 7],
    [8, 9],
    [9, 8],
    [9, 14],
    [10, 5],
    [10, 11],
    [11, 10],
    [11, 12],
    [11, 16],
    [12, 7],
    [12, 11],
    [12, 13],
    [13, 12],
    [13, 14],
    [13, 18],
    [14, 9],
    [14, 13],
    [15, 16],
    [16, 11],
    [16, 15],
    [16, 17],
    [17, 16],
    [17, 18],
    [18, 13],
    [18, 17],
    [18, 19],
    [19, 18],
]

TOKYO_CMAP = [
    [0, 1],
    [0, 5],
    [1, 0],
    [1, 2],
    [1, 6],
    [1, 7],
    [2, 1],
    [2, 6],
    [3, 8],
    [4, 8],
    [4, 9],
    [5, 0],
    [5, 6],
    [5, 10],
    [5, 11],
    [6, 1],
    [6, 2],
    [6, 5],
    [6, 7],
    [6, 10],
    [6, 11],
    [7, 1],
    [7, 6],
    [7, 8],
    [7, 12],
    [8, 3],
    [8, 4],
    [8, 7],
    [8, 9],
    [8, 12],
    [8, 13],
    [9, 4],
    [9, 8],
    [10, 5],
    [10, 6],
    [10, 11],
    [10, 15],
    [11, 5],
    [11, 6],
    [11, 10],
    [11, 12],
    [11, 16],
    [11, 17],
    [12, 7],
    [12, 8],
    [12, 11],
    [12, 13],
    [12, 16],
    [13, 8],
    [13, 12],
    [13, 14],
    [13, 18],
    [13, 19],
    [14, 13],
    [14, 18],
    [14, 19],
    [15, 10],
    [15, 16],
    [16, 11],
    [16, 12],
    [16, 15],
    [16, 17],
    [17, 11],
    [17, 16],
    [17, 18],
    [18, 13],
    [18, 14],
    [18, 17],
    [19, 13],
    [19, 14],
]

# 27 qubits
MUMBAI_CMAP = [
    [0, 1],
    [1, 0],
    [1, 2],
    [1, 4],
    [2, 1],
    [2, 3],
    [3, 2],
    [3, 5],
    [4, 1],
    [4, 7],
    [5, 3],
    [5, 8],
    [6, 7],
    [7, 4],
    [7, 6],
    [7, 10],
    [8, 5],
    [8, 9],
    [8, 11],
    [9, 8],
    [10, 7],
    [10, 12],
    [11, 8],
    [11, 14],
    [12, 10],
    [12, 13],
    [12, 15],
    [13, 12],
    [13, 14],
    [14, 11],
    [14, 13],
    [14, 16],
    [15, 12],
    [15, 18],
    [16, 14],
    [16, 19],
    [17, 18],
    [18, 15],
    [18, 17],
    [18, 21],
    [19, 16],
    [19, 20],
    [19, 22],
    [20, 19],
    [21, 18],
    [21, 23],
    [22, 19],
    [22, 25],
    [23, 21],
    [23, 24],
    [24, 23],
    [24, 25],
    [25, 22],
    [25, 24],
    [25, 26],
    [26, 25],
]

# 65 qubits
MANHATTAN_CMAP = [
    [0, 1],
    [0, 10],
    [1, 0],
    [1, 2],
    [2, 1],
    [2, 3],
    [3, 2],
    [3, 4],
    [4, 3],
    [4, 5],
    [4, 11],
    [5, 4],
    [5, 6],
    [6, 5],
    [6, 7],
    [7, 6],
    [7, 8],
    [8, 7],
    [8, 9],
    [8, 12],
    [9, 8],
    [10, 0],
    [10, 13],
    [11, 4],
    [11, 17],
    [12, 8],
    [12, 21],
    [13, 10],
    [13, 14],
    [14, 13],
    [14, 15],
    [15, 14],
    [15, 16],
    [15, 24],
    [16, 15],
    [16, 17],
    [17, 11],
    [17, 16],
    [17, 18],
    [18, 17],
    [18, 19],
    [19, 18],
    [19, 20],
    [19, 25],
    [20, 19],
    [20, 21],
    [21, 12],
    [21, 20],
    [21, 22],
    [22, 21],
    [22, 23],
    [23, 22],
    [23, 26],
    [24, 15],
    [24, 29],
    [25, 19],
    [25, 33],
    [26, 23],
    [26, 37],
    [27, 28],
    [27, 38],
    [28, 27],
    [28, 29],
    [29, 24],
    [29, 28],
    [29, 30],
    [30, 29],
    [30, 31],
    [31, 30],
    [31, 32],
    [31, 39],
    [32, 31],
    [32, 33],
    [33, 25],
    [33, 32],
    [33, 34],
    [34, 33],
    [34, 35],
    [35, 34],
    [35, 36],
    [35, 40],
    [36, 35],
    [36, 37],
    [37, 26],
    [37, 36],
    [38, 27],
    [38, 41],
    [39, 31],
    [39, 45],
    [40, 35],
    [40, 49],
    [41, 38],
    [41, 42],
    [42, 41],
    [42, 43],
    [43, 42],
    [43, 44],
    [43, 52],
    [44, 43],
    [44, 45],
    [45, 39],
    [45, 44],
    [45, 46],
    [46, 45],
    [46, 47],
    [47, 46],
    [47, 48],
    [47, 53],
    [48, 47],
    [48, 49],
    [49, 40],
    [49, 48],
    [49, 50],
    [50, 49],
    [50, 51],
    [51, 50],
    [51, 54],
    [52, 43],
    [52, 56],
    [53, 47],
    [53, 60],
    [54, 51],
    [54, 64],
    [55, 56],
    [56, 52],
    [56, 55],
    [56, 57],
    [57, 56],
    [57, 58],
    [58, 57],
    [58, 59],
    [59, 58],
    [59, 60],
    [60, 53],
    [60, 59],
    [60, 61],
    [61, 60],
    [61, 62],
    [62, 61],
    [62, 63],
    [63, 62],
    [63, 64],
    [64, 54],
    [64, 63],
]

# 127 qubits
KYOTO_CMAP = [
    [0, 14],
    [1, 0],
    [1, 2],
    [3, 2],
    [4, 3],
    [4, 5],
    [6, 5],
    [7, 6],
    [8, 7],
    [8, 9],
    [8, 16],
    [9, 10],
    [11, 10],
    [11, 12],
    [12, 13],
    [15, 4],
    [16, 26],
    [17, 12],
    [17, 30],
    [18, 14],
    [18, 19],
    [19, 20],
    [21, 20],
    [22, 15],
    [22, 21],
    [22, 23],
    [23, 24],
    [25, 24],
    [25, 26],
    [27, 26],
    [27, 28],
    [28, 29],
    [28, 35],
    [30, 29],
    [30, 31],
    [31, 32],
    [32, 36],
    [33, 20],
    [33, 39],
    [34, 24],
    [34, 43],
    [37, 38],
    [38, 39],
    [39, 40],
    [40, 41],
    [42, 41],
    [43, 42],
    [44, 43],
    [44, 45],
    [46, 45],
    [47, 35],
    [47, 46],
    [48, 47],
    [49, 48],
    [49, 55],
    [50, 49],
    [50, 51],
    [51, 36],
    [52, 37],
    [53, 41],
    [53, 60],
    [54, 45],
    [54, 64],
    [55, 68],
    [56, 52],
    [57, 56],
    [57, 58],
    [59, 58],
    [59, 60],
    [61, 60],
    [62, 61],
    [62, 63],
    [63, 64],
    [64, 65],
    [65, 66],
    [67, 66],
    [67, 68],
    [68, 69],
    [70, 69],
    [71, 58],
    [72, 62],
    [73, 66],
    [73, 85],
    [74, 70],
    [75, 90],
    [76, 75],
    [76, 77],
    [77, 71],
    [77, 78],
    [79, 78],
    [79, 91],
    [80, 79],
    [81, 72],
    [81, 80],
    [82, 81],
    [82, 83],
    [83, 92],
    [84, 83],
    [84, 85],
    [86, 85],
    [87, 86],
    [87, 93],
    [88, 87],
    [89, 74],
    [89, 88],
    [93, 106],
    [94, 90],
    [94, 95],
    [96, 95],
    [96, 97],
    [96, 109],
    [97, 98],
    [98, 91],
    [98, 99],
    [99, 100],
    [101, 100],
    [101, 102],
    [102, 92],
    [102, 103],
    [104, 103],
    [104, 111],
    [105, 104],
    [105, 106],
    [106, 107],
    [107, 108],
    [109, 114],
    [110, 100],
    [112, 108],
    [113, 114],
    [115, 114],
    [116, 115],
    [117, 116],
    [118, 110],
    [118, 117],
    [119, 118],
    [120, 119],
    [121, 120],
    [122, 111],
    [122, 121],
    [122, 123],
    [124, 123],
    [125, 124],
    [125, 126],
    [126, 112],
]
