// Copyright 2018 The go-libvirt Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// WARNING: This file has automatically been generated
// Code generated by https://git.io/c-for-go. DO NOT EDIT.

package libvirt

const (
	// Deprecated as defined in libvirt/libvirt-common.h:40
	Deprecated = 0x5f8b60
	// ExportVar as defined in libvirt/libvirt-common.h:57
	ExportVar = 0x5f8b60
	// TypedParamFieldLength as defined in libvirt/libvirt-common.h:170
	TypedParamFieldLength = 80
	// DomainSchedulerCPUShares as defined in libvirt/libvirt-domain.h:316
	DomainSchedulerCPUShares = "cpu_shares"
	// DomainSchedulerGlobalPeriod as defined in libvirt/libvirt-domain.h:324
	DomainSchedulerGlobalPeriod = "global_period"
	// DomainSchedulerGlobalQuota as defined in libvirt/libvirt-domain.h:332
	DomainSchedulerGlobalQuota = "global_quota"
	// DomainSchedulerVCPUPeriod as defined in libvirt/libvirt-domain.h:340
	DomainSchedulerVCPUPeriod = "vcpu_period"
	// DomainSchedulerVCPUQuota as defined in libvirt/libvirt-domain.h:348
	DomainSchedulerVCPUQuota = "vcpu_quota"
	// DomainSchedulerEmulatorPeriod as defined in libvirt/libvirt-domain.h:357
	DomainSchedulerEmulatorPeriod = "emulator_period"
	// DomainSchedulerEmulatorQuota as defined in libvirt/libvirt-domain.h:366
	DomainSchedulerEmulatorQuota = "emulator_quota"
	// DomainSchedulerIothreadPeriod as defined in libvirt/libvirt-domain.h:374
	DomainSchedulerIothreadPeriod = "iothread_period"
	// DomainSchedulerIothreadQuota as defined in libvirt/libvirt-domain.h:382
	DomainSchedulerIothreadQuota = "iothread_quota"
	// DomainSchedulerWeight as defined in libvirt/libvirt-domain.h:390
	DomainSchedulerWeight = "weight"
	// DomainSchedulerCap as defined in libvirt/libvirt-domain.h:398
	DomainSchedulerCap = "cap"
	// DomainSchedulerReservation as defined in libvirt/libvirt-domain.h:406
	DomainSchedulerReservation = "reservation"
	// DomainSchedulerLimit as defined in libvirt/libvirt-domain.h:414
	DomainSchedulerLimit = "limit"
	// DomainSchedulerShares as defined in libvirt/libvirt-domain.h:422
	DomainSchedulerShares = "shares"
	// DomainBlockStatsFieldLength as defined in libvirt/libvirt-domain.h:480
	DomainBlockStatsFieldLength = TypedParamFieldLength
	// DomainBlockStatsReadBytes as defined in libvirt/libvirt-domain.h:488
	DomainBlockStatsReadBytes = "rd_bytes"
	// DomainBlockStatsReadReq as defined in libvirt/libvirt-domain.h:496
	DomainBlockStatsReadReq = "rd_operations"
	// DomainBlockStatsReadTotalTimes as defined in libvirt/libvirt-domain.h:504
	DomainBlockStatsReadTotalTimes = "rd_total_times"
	// DomainBlockStatsWriteBytes as defined in libvirt/libvirt-domain.h:512
	DomainBlockStatsWriteBytes = "wr_bytes"
	// DomainBlockStatsWriteReq as defined in libvirt/libvirt-domain.h:520
	DomainBlockStatsWriteReq = "wr_operations"
	// DomainBlockStatsWriteTotalTimes as defined in libvirt/libvirt-domain.h:528
	DomainBlockStatsWriteTotalTimes = "wr_total_times"
	// DomainBlockStatsFlushReq as defined in libvirt/libvirt-domain.h:536
	DomainBlockStatsFlushReq = "flush_operations"
	// DomainBlockStatsFlushTotalTimes as defined in libvirt/libvirt-domain.h:544
	DomainBlockStatsFlushTotalTimes = "flush_total_times"
	// DomainBlockStatsErrs as defined in libvirt/libvirt-domain.h:551
	DomainBlockStatsErrs = "errs"
	// MigrateParamURI as defined in libvirt/libvirt-domain.h:879
	MigrateParamURI = "migrate_uri"
	// MigrateParamDestName as defined in libvirt/libvirt-domain.h:889
	MigrateParamDestName = "destination_name"
	// MigrateParamDestXML as defined in libvirt/libvirt-domain.h:908
	MigrateParamDestXML = "destination_xml"
	// MigrateParamPersistXML as defined in libvirt/libvirt-domain.h:923
	MigrateParamPersistXML = "persistent_xml"
	// MigrateParamBandwidth as defined in libvirt/libvirt-domain.h:933
	MigrateParamBandwidth = "bandwidth"
	// MigrateParamBandwidthPostcopy as defined in libvirt/libvirt-domain.h:942
	MigrateParamBandwidthPostcopy = "bandwidth.postcopy"
	// MigrateParamGraphicsURI as defined in libvirt/libvirt-domain.h:963
	MigrateParamGraphicsURI = "graphics_uri"
	// MigrateParamListenAddress as defined in libvirt/libvirt-domain.h:974
	MigrateParamListenAddress = "listen_address"
	// MigrateParamMigrateDisks as defined in libvirt/libvirt-domain.h:983
	MigrateParamMigrateDisks = "migrate_disks"
	// MigrateParamDisksPort as defined in libvirt/libvirt-domain.h:993
	MigrateParamDisksPort = "disks_port"
	// MigrateParamDisksURI as defined in libvirt/libvirt-domain.h:1006
	MigrateParamDisksURI = "disks_uri"
	// MigrateParamCompression as defined in libvirt/libvirt-domain.h:1016
	MigrateParamCompression = "compression"
	// MigrateParamCompressionMtLevel as defined in libvirt/libvirt-domain.h:1025
	MigrateParamCompressionMtLevel = "compression.mt.level"
	// MigrateParamCompressionMtThreads as defined in libvirt/libvirt-domain.h:1033
	MigrateParamCompressionMtThreads = "compression.mt.threads"
	// MigrateParamCompressionMtDthreads as defined in libvirt/libvirt-domain.h:1041
	MigrateParamCompressionMtDthreads = "compression.mt.dthreads"
	// MigrateParamCompressionXbzrleCache as defined in libvirt/libvirt-domain.h:1049
	MigrateParamCompressionXbzrleCache = "compression.xbzrle.cache"
	// MigrateParamAutoConvergeInitial as defined in libvirt/libvirt-domain.h:1058
	MigrateParamAutoConvergeInitial = "auto_converge.initial"
	// MigrateParamAutoConvergeIncrement as defined in libvirt/libvirt-domain.h:1068
	MigrateParamAutoConvergeIncrement = "auto_converge.increment"
	// MigrateParamParallelConnections as defined in libvirt/libvirt-domain.h:1076
	MigrateParamParallelConnections = "parallel.connections"
	// MigrateParamTLSDestination as defined in libvirt/libvirt-domain.h:1090
	MigrateParamTLSDestination = "tls.destination"
	// DomainCPUStatsCputime as defined in libvirt/libvirt-domain.h:1350
	DomainCPUStatsCputime = "cpu_time"
	// DomainCPUStatsUsertime as defined in libvirt/libvirt-domain.h:1356
	DomainCPUStatsUsertime = "user_time"
	// DomainCPUStatsSystemtime as defined in libvirt/libvirt-domain.h:1362
	DomainCPUStatsSystemtime = "system_time"
	// DomainCPUStatsVcputime as defined in libvirt/libvirt-domain.h:1369
	DomainCPUStatsVcputime = "vcpu_time"
	// DomainBlkioWeight as defined in libvirt/libvirt-domain.h:1398
	DomainBlkioWeight = "weight"
	// DomainBlkioDeviceWeight as defined in libvirt/libvirt-domain.h:1408
	DomainBlkioDeviceWeight = "device_weight"
	// DomainBlkioDeviceReadIops as defined in libvirt/libvirt-domain.h:1419
	DomainBlkioDeviceReadIops = "device_read_iops_sec"
	// DomainBlkioDeviceWriteIops as defined in libvirt/libvirt-domain.h:1430
	DomainBlkioDeviceWriteIops = "device_write_iops_sec"
	// DomainBlkioDeviceReadBps as defined in libvirt/libvirt-domain.h:1441
	DomainBlkioDeviceReadBps = "device_read_bytes_sec"
	// DomainBlkioDeviceWriteBps as defined in libvirt/libvirt-domain.h:1452
	DomainBlkioDeviceWriteBps = "device_write_bytes_sec"
	// DomainMemoryParamUnlimited as defined in libvirt/libvirt-domain.h:1471
	DomainMemoryParamUnlimited = int64(9007199254740991)
	// DomainMemoryHardLimit as defined in libvirt/libvirt-domain.h:1480
	DomainMemoryHardLimit = "hard_limit"
	// DomainMemorySoftLimit as defined in libvirt/libvirt-domain.h:1489
	DomainMemorySoftLimit = "soft_limit"
	// DomainMemoryMinGuarantee as defined in libvirt/libvirt-domain.h:1498
	DomainMemoryMinGuarantee = "min_guarantee"
	// DomainMemorySwapHardLimit as defined in libvirt/libvirt-domain.h:1508
	DomainMemorySwapHardLimit = "swap_hard_limit"
	// DomainNumaNodeset as defined in libvirt/libvirt-domain.h:1554
	DomainNumaNodeset = "numa_nodeset"
	// DomainNumaMode as defined in libvirt/libvirt-domain.h:1562
	DomainNumaMode = "numa_mode"
	// DomainBandwidthInAverage as defined in libvirt/libvirt-domain.h:1684
	DomainBandwidthInAverage = "inbound.average"
	// DomainBandwidthInPeak as defined in libvirt/libvirt-domain.h:1691
	DomainBandwidthInPeak = "inbound.peak"
	// DomainBandwidthInBurst as defined in libvirt/libvirt-domain.h:1698
	DomainBandwidthInBurst = "inbound.burst"
	// DomainBandwidthInFloor as defined in libvirt/libvirt-domain.h:1705
	DomainBandwidthInFloor = "inbound.floor"
	// DomainBandwidthOutAverage as defined in libvirt/libvirt-domain.h:1712
	DomainBandwidthOutAverage = "outbound.average"
	// DomainBandwidthOutPeak as defined in libvirt/libvirt-domain.h:1719
	DomainBandwidthOutPeak = "outbound.peak"
	// DomainBandwidthOutBurst as defined in libvirt/libvirt-domain.h:1726
	DomainBandwidthOutBurst = "outbound.burst"
	// DomainIothreadPollMaxNs as defined in libvirt/libvirt-domain.h:2031
	DomainIothreadPollMaxNs = "poll_max_ns"
	// DomainIothreadPollGrow as defined in libvirt/libvirt-domain.h:2041
	DomainIothreadPollGrow = "poll_grow"
	// DomainIothreadPollShrink as defined in libvirt/libvirt-domain.h:2052
	DomainIothreadPollShrink = "poll_shrink"
	// PerfParamCmt as defined in libvirt/libvirt-domain.h:2245
	PerfParamCmt = "cmt"
	// PerfParamMbmt as defined in libvirt/libvirt-domain.h:2256
	PerfParamMbmt = "mbmt"
	// PerfParamMbml as defined in libvirt/libvirt-domain.h:2266
	PerfParamMbml = "mbml"
	// PerfParamCacheMisses as defined in libvirt/libvirt-domain.h:2276
	PerfParamCacheMisses = "cache_misses"
	// PerfParamCacheReferences as defined in libvirt/libvirt-domain.h:2286
	PerfParamCacheReferences = "cache_references"
	// PerfParamInstructions as defined in libvirt/libvirt-domain.h:2296
	PerfParamInstructions = "instructions"
	// PerfParamCPUCycles as defined in libvirt/libvirt-domain.h:2306
	PerfParamCPUCycles = "cpu_cycles"
	// PerfParamBranchInstructions as defined in libvirt/libvirt-domain.h:2316
	PerfParamBranchInstructions = "branch_instructions"
	// PerfParamBranchMisses as defined in libvirt/libvirt-domain.h:2326
	PerfParamBranchMisses = "branch_misses"
	// PerfParamBusCycles as defined in libvirt/libvirt-domain.h:2336
	PerfParamBusCycles = "bus_cycles"
	// PerfParamStalledCyclesFrontend as defined in libvirt/libvirt-domain.h:2347
	PerfParamStalledCyclesFrontend = "stalled_cycles_frontend"
	// PerfParamStalledCyclesBackend as defined in libvirt/libvirt-domain.h:2358
	PerfParamStalledCyclesBackend = "stalled_cycles_backend"
	// PerfParamRefCPUCycles as defined in libvirt/libvirt-domain.h:2369
	PerfParamRefCPUCycles = "ref_cpu_cycles"
	// PerfParamCPUClock as defined in libvirt/libvirt-domain.h:2380
	PerfParamCPUClock = "cpu_clock"
	// PerfParamTaskClock as defined in libvirt/libvirt-domain.h:2391
	PerfParamTaskClock = "task_clock"
	// PerfParamPageFaults as defined in libvirt/libvirt-domain.h:2401
	PerfParamPageFaults = "page_faults"
	// PerfParamContextSwitches as defined in libvirt/libvirt-domain.h:2411
	PerfParamContextSwitches = "context_switches"
	// PerfParamCPUMigrations as defined in libvirt/libvirt-domain.h:2421
	PerfParamCPUMigrations = "cpu_migrations"
	// PerfParamPageFaultsMin as defined in libvirt/libvirt-domain.h:2431
	PerfParamPageFaultsMin = "page_faults_min"
	// PerfParamPageFaultsMaj as defined in libvirt/libvirt-domain.h:2441
	PerfParamPageFaultsMaj = "page_faults_maj"
	// PerfParamAlignmentFaults as defined in libvirt/libvirt-domain.h:2451
	PerfParamAlignmentFaults = "alignment_faults"
	// PerfParamEmulationFaults as defined in libvirt/libvirt-domain.h:2461
	PerfParamEmulationFaults = "emulation_faults"
	// DomainBlockCopyBandwidth as defined in libvirt/libvirt-domain.h:2634
	DomainBlockCopyBandwidth = "bandwidth"
	// DomainBlockCopyGranularity as defined in libvirt/libvirt-domain.h:2645
	DomainBlockCopyGranularity = "granularity"
	// DomainBlockCopyBufSize as defined in libvirt/libvirt-domain.h:2654
	DomainBlockCopyBufSize = "buf-size"
	// DomainBlockIotuneTotalBytesSec as defined in libvirt/libvirt-domain.h:2695
	DomainBlockIotuneTotalBytesSec = "total_bytes_sec"
	// DomainBlockIotuneReadBytesSec as defined in libvirt/libvirt-domain.h:2703
	DomainBlockIotuneReadBytesSec = "read_bytes_sec"
	// DomainBlockIotuneWriteBytesSec as defined in libvirt/libvirt-domain.h:2711
	DomainBlockIotuneWriteBytesSec = "write_bytes_sec"
	// DomainBlockIotuneTotalIopsSec as defined in libvirt/libvirt-domain.h:2719
	DomainBlockIotuneTotalIopsSec = "total_iops_sec"
	// DomainBlockIotuneReadIopsSec as defined in libvirt/libvirt-domain.h:2727
	DomainBlockIotuneReadIopsSec = "read_iops_sec"
	// DomainBlockIotuneWriteIopsSec as defined in libvirt/libvirt-domain.h:2734
	DomainBlockIotuneWriteIopsSec = "write_iops_sec"
	// DomainBlockIotuneTotalBytesSecMax as defined in libvirt/libvirt-domain.h:2742
	DomainBlockIotuneTotalBytesSecMax = "total_bytes_sec_max"
	// DomainBlockIotuneReadBytesSecMax as defined in libvirt/libvirt-domain.h:2750
	DomainBlockIotuneReadBytesSecMax = "read_bytes_sec_max"
	// DomainBlockIotuneWriteBytesSecMax as defined in libvirt/libvirt-domain.h:2758
	DomainBlockIotuneWriteBytesSecMax = "write_bytes_sec_max"
	// DomainBlockIotuneTotalIopsSecMax as defined in libvirt/libvirt-domain.h:2766
	DomainBlockIotuneTotalIopsSecMax = "total_iops_sec_max"
	// DomainBlockIotuneReadIopsSecMax as defined in libvirt/libvirt-domain.h:2774
	DomainBlockIotuneReadIopsSecMax = "read_iops_sec_max"
	// DomainBlockIotuneWriteIopsSecMax as defined in libvirt/libvirt-domain.h:2781
	DomainBlockIotuneWriteIopsSecMax = "write_iops_sec_max"
	// DomainBlockIotuneTotalBytesSecMaxLength as defined in libvirt/libvirt-domain.h:2789
	DomainBlockIotuneTotalBytesSecMaxLength = "total_bytes_sec_max_length"
	// DomainBlockIotuneReadBytesSecMaxLength as defined in libvirt/libvirt-domain.h:2797
	DomainBlockIotuneReadBytesSecMaxLength = "read_bytes_sec_max_length"
	// DomainBlockIotuneWriteBytesSecMaxLength as defined in libvirt/libvirt-domain.h:2805
	DomainBlockIotuneWriteBytesSecMaxLength = "write_bytes_sec_max_length"
	// DomainBlockIotuneTotalIopsSecMaxLength as defined in libvirt/libvirt-domain.h:2813
	DomainBlockIotuneTotalIopsSecMaxLength = "total_iops_sec_max_length"
	// DomainBlockIotuneReadIopsSecMaxLength as defined in libvirt/libvirt-domain.h:2821
	DomainBlockIotuneReadIopsSecMaxLength = "read_iops_sec_max_length"
	// DomainBlockIotuneWriteIopsSecMaxLength as defined in libvirt/libvirt-domain.h:2829
	DomainBlockIotuneWriteIopsSecMaxLength = "write_iops_sec_max_length"
	// DomainBlockIotuneSizeIopsSec as defined in libvirt/libvirt-domain.h:2836
	DomainBlockIotuneSizeIopsSec = "size_iops_sec"
	// DomainBlockIotuneGroupName as defined in libvirt/libvirt-domain.h:2843
	DomainBlockIotuneGroupName = "group_name"
	// KeycodeSetRfb as defined in libvirt/libvirt-domain.h:2924
	KeycodeSetRfb = 0x5f8b60
	// DomainSendKeyMaxKeys as defined in libvirt/libvirt-domain.h:2931
	DomainSendKeyMaxKeys = 16
	// DomainJobOperationStr as defined in libvirt/libvirt-domain.h:3405
	DomainJobOperationStr = "operation"
	// DomainJobTimeElapsed as defined in libvirt/libvirt-domain.h:3415
	DomainJobTimeElapsed = "time_elapsed"
	// DomainJobTimeElapsedNet as defined in libvirt/libvirt-domain.h:3425
	DomainJobTimeElapsedNet = "time_elapsed_net"
	// DomainJobTimeRemaining as defined in libvirt/libvirt-domain.h:3435
	DomainJobTimeRemaining = "time_remaining"
	// DomainJobDowntime as defined in libvirt/libvirt-domain.h:3445
	DomainJobDowntime = "downtime"
	// DomainJobDowntimeNet as defined in libvirt/libvirt-domain.h:3454
	DomainJobDowntimeNet = "downtime_net"
	// DomainJobSetupTime as defined in libvirt/libvirt-domain.h:3463
	DomainJobSetupTime = "setup_time"
	// DomainJobDataTotal as defined in libvirt/libvirt-domain.h:3478
	DomainJobDataTotal = "data_total"
	// DomainJobDataProcessed as defined in libvirt/libvirt-domain.h:3488
	DomainJobDataProcessed = "data_processed"
	// DomainJobDataRemaining as defined in libvirt/libvirt-domain.h:3498
	DomainJobDataRemaining = "data_remaining"
	// DomainJobMemoryTotal as defined in libvirt/libvirt-domain.h:3508
	DomainJobMemoryTotal = "memory_total"
	// DomainJobMemoryProcessed as defined in libvirt/libvirt-domain.h:3518
	DomainJobMemoryProcessed = "memory_processed"
	// DomainJobMemoryRemaining as defined in libvirt/libvirt-domain.h:3528
	DomainJobMemoryRemaining = "memory_remaining"
	// DomainJobMemoryConstant as defined in libvirt/libvirt-domain.h:3540
	DomainJobMemoryConstant = "memory_constant"
	// DomainJobMemoryNormal as defined in libvirt/libvirt-domain.h:3550
	DomainJobMemoryNormal = "memory_normal"
	// DomainJobMemoryNormalBytes as defined in libvirt/libvirt-domain.h:3560
	DomainJobMemoryNormalBytes = "memory_normal_bytes"
	// DomainJobMemoryBps as defined in libvirt/libvirt-domain.h:3568
	DomainJobMemoryBps = "memory_bps"
	// DomainJobMemoryDirtyRate as defined in libvirt/libvirt-domain.h:3576
	DomainJobMemoryDirtyRate = "memory_dirty_rate"
	// DomainJobMemoryPageSize as defined in libvirt/libvirt-domain.h:3587
	DomainJobMemoryPageSize = "memory_page_size"
	// DomainJobMemoryIteration as defined in libvirt/libvirt-domain.h:3598
	DomainJobMemoryIteration = "memory_iteration"
	// DomainJobMemoryPostcopyReqs as defined in libvirt/libvirt-domain.h:3608
	DomainJobMemoryPostcopyReqs = "memory_postcopy_requests"
	// DomainJobDiskTotal as defined in libvirt/libvirt-domain.h:3618
	DomainJobDiskTotal = "disk_total"
	// DomainJobDiskProcessed as defined in libvirt/libvirt-domain.h:3628
	DomainJobDiskProcessed = "disk_processed"
	// DomainJobDiskRemaining as defined in libvirt/libvirt-domain.h:3638
	DomainJobDiskRemaining = "disk_remaining"
	// DomainJobDiskBps as defined in libvirt/libvirt-domain.h:3646
	DomainJobDiskBps = "disk_bps"
	// DomainJobCompressionCache as defined in libvirt/libvirt-domain.h:3655
	DomainJobCompressionCache = "compression_cache"
	// DomainJobCompressionBytes as defined in libvirt/libvirt-domain.h:3663
	DomainJobCompressionBytes = "compression_bytes"
	// DomainJobCompressionPages as defined in libvirt/libvirt-domain.h:3671
	DomainJobCompressionPages = "compression_pages"
	// DomainJobCompressionCacheMisses as defined in libvirt/libvirt-domain.h:3680
	DomainJobCompressionCacheMisses = "compression_cache_misses"
	// DomainJobCompressionOverflow as defined in libvirt/libvirt-domain.h:3690
	DomainJobCompressionOverflow = "compression_overflow"
	// DomainJobAutoConvergeThrottle as defined in libvirt/libvirt-domain.h:3699
	DomainJobAutoConvergeThrottle = "auto_converge_throttle"
	// DomainJobSuccess as defined in libvirt/libvirt-domain.h:3707
	DomainJobSuccess = "success"
	// DomainJobErrmsg as defined in libvirt/libvirt-domain.h:3715
	DomainJobErrmsg = "errmsg"
	// DomainJobDiskTempUsed as defined in libvirt/libvirt-domain.h:3723
	DomainJobDiskTempUsed = "disk_temp_used"
	// DomainJobDiskTempTotal as defined in libvirt/libvirt-domain.h:3730
	DomainJobDiskTempTotal = "disk_temp_total"
	// DomainTunableCPUVcpupin as defined in libvirt/libvirt-domain.h:4285
	DomainTunableCPUVcpupin = "cputune.vcpupin%u"
	// DomainTunableCPUEmulatorpin as defined in libvirt/libvirt-domain.h:4293
	DomainTunableCPUEmulatorpin = "cputune.emulatorpin"
	// DomainTunableCPUIothreadspin as defined in libvirt/libvirt-domain.h:4302
	DomainTunableCPUIothreadspin = "cputune.iothreadpin%u"
	// DomainTunableCPUCpuShares as defined in libvirt/libvirt-domain.h:4310
	DomainTunableCPUCpuShares = "cputune.cpu_shares"
	// DomainTunableCPUGlobalPeriod as defined in libvirt/libvirt-domain.h:4318
	DomainTunableCPUGlobalPeriod = "cputune.global_period"
	// DomainTunableCPUGlobalQuota as defined in libvirt/libvirt-domain.h:4326
	DomainTunableCPUGlobalQuota = "cputune.global_quota"
	// DomainTunableCPUVCPUPeriod as defined in libvirt/libvirt-domain.h:4334
	DomainTunableCPUVCPUPeriod = "cputune.vcpu_period"
	// DomainTunableCPUVCPUQuota as defined in libvirt/libvirt-domain.h:4342
	DomainTunableCPUVCPUQuota = "cputune.vcpu_quota"
	// DomainTunableCPUEmulatorPeriod as defined in libvirt/libvirt-domain.h:4351
	DomainTunableCPUEmulatorPeriod = "cputune.emulator_period"
	// DomainTunableCPUEmulatorQuota as defined in libvirt/libvirt-domain.h:4360
	DomainTunableCPUEmulatorQuota = "cputune.emulator_quota"
	// DomainTunableCPUIothreadPeriod as defined in libvirt/libvirt-domain.h:4368
	DomainTunableCPUIothreadPeriod = "cputune.iothread_period"
	// DomainTunableCPUIothreadQuota as defined in libvirt/libvirt-domain.h:4376
	DomainTunableCPUIothreadQuota = "cputune.iothread_quota"
	// DomainTunableBlkdevDisk as defined in libvirt/libvirt-domain.h:4384
	DomainTunableBlkdevDisk = "blkdeviotune.disk"
	// DomainTunableBlkdevTotalBytesSec as defined in libvirt/libvirt-domain.h:4392
	DomainTunableBlkdevTotalBytesSec = "blkdeviotune.total_bytes_sec"
	// DomainTunableBlkdevReadBytesSec as defined in libvirt/libvirt-domain.h:4400
	DomainTunableBlkdevReadBytesSec = "blkdeviotune.read_bytes_sec"
	// DomainTunableBlkdevWriteBytesSec as defined in libvirt/libvirt-domain.h:4408
	DomainTunableBlkdevWriteBytesSec = "blkdeviotune.write_bytes_sec"
	// DomainTunableBlkdevTotalIopsSec as defined in libvirt/libvirt-domain.h:4416
	DomainTunableBlkdevTotalIopsSec = "blkdeviotune.total_iops_sec"
	// DomainTunableBlkdevReadIopsSec as defined in libvirt/libvirt-domain.h:4424
	DomainTunableBlkdevReadIopsSec = "blkdeviotune.read_iops_sec"
	// DomainTunableBlkdevWriteIopsSec as defined in libvirt/libvirt-domain.h:4432
	DomainTunableBlkdevWriteIopsSec = "blkdeviotune.write_iops_sec"
	// DomainTunableBlkdevTotalBytesSecMax as defined in libvirt/libvirt-domain.h:4440
	DomainTunableBlkdevTotalBytesSecMax = "blkdeviotune.total_bytes_sec_max"
	// DomainTunableBlkdevReadBytesSecMax as defined in libvirt/libvirt-domain.h:4448
	DomainTunableBlkdevReadBytesSecMax = "blkdeviotune.read_bytes_sec_max"
	// DomainTunableBlkdevWriteBytesSecMax as defined in libvirt/libvirt-domain.h:4456
	DomainTunableBlkdevWriteBytesSecMax = "blkdeviotune.write_bytes_sec_max"
	// DomainTunableBlkdevTotalIopsSecMax as defined in libvirt/libvirt-domain.h:4464
	DomainTunableBlkdevTotalIopsSecMax = "blkdeviotune.total_iops_sec_max"
	// DomainTunableBlkdevReadIopsSecMax as defined in libvirt/libvirt-domain.h:4472
	DomainTunableBlkdevReadIopsSecMax = "blkdeviotune.read_iops_sec_max"
	// DomainTunableBlkdevWriteIopsSecMax as defined in libvirt/libvirt-domain.h:4480
	DomainTunableBlkdevWriteIopsSecMax = "blkdeviotune.write_iops_sec_max"
	// DomainTunableBlkdevSizeIopsSec as defined in libvirt/libvirt-domain.h:4488
	DomainTunableBlkdevSizeIopsSec = "blkdeviotune.size_iops_sec"
	// DomainTunableBlkdevGroupName as defined in libvirt/libvirt-domain.h:4496
	DomainTunableBlkdevGroupName = "blkdeviotune.group_name"
	// DomainTunableBlkdevTotalBytesSecMaxLength as defined in libvirt/libvirt-domain.h:4505
	DomainTunableBlkdevTotalBytesSecMaxLength = "blkdeviotune.total_bytes_sec_max_length"
	// DomainTunableBlkdevReadBytesSecMaxLength as defined in libvirt/libvirt-domain.h:4514
	DomainTunableBlkdevReadBytesSecMaxLength = "blkdeviotune.read_bytes_sec_max_length"
	// DomainTunableBlkdevWriteBytesSecMaxLength as defined in libvirt/libvirt-domain.h:4523
	DomainTunableBlkdevWriteBytesSecMaxLength = "blkdeviotune.write_bytes_sec_max_length"
	// DomainTunableBlkdevTotalIopsSecMaxLength as defined in libvirt/libvirt-domain.h:4532
	DomainTunableBlkdevTotalIopsSecMaxLength = "blkdeviotune.total_iops_sec_max_length"
	// DomainTunableBlkdevReadIopsSecMaxLength as defined in libvirt/libvirt-domain.h:4541
	DomainTunableBlkdevReadIopsSecMaxLength = "blkdeviotune.read_iops_sec_max_length"
	// DomainTunableBlkdevWriteIopsSecMaxLength as defined in libvirt/libvirt-domain.h:4550
	DomainTunableBlkdevWriteIopsSecMaxLength = "blkdeviotune.write_iops_sec_max_length"
	// DomainSchedFieldLength as defined in libvirt/libvirt-domain.h:4888
	DomainSchedFieldLength = TypedParamFieldLength
	// DomainBlkioFieldLength as defined in libvirt/libvirt-domain.h:4932
	DomainBlkioFieldLength = TypedParamFieldLength
	// DomainMemoryFieldLength as defined in libvirt/libvirt-domain.h:4976
	DomainMemoryFieldLength = TypedParamFieldLength
	// DomainLaunchSecuritySevMeasurement as defined in libvirt/libvirt-domain.h:5102
	DomainLaunchSecuritySevMeasurement = "sev-measurement"
	// DomainLaunchSecuritySevAPIMajor as defined in libvirt/libvirt-domain.h:5111
	DomainLaunchSecuritySevAPIMajor = "sev-api-major"
	// DomainLaunchSecuritySevAPIMinor as defined in libvirt/libvirt-domain.h:5119
	DomainLaunchSecuritySevAPIMinor = "sev-api-minor"
	// DomainLaunchSecuritySevBuildID as defined in libvirt/libvirt-domain.h:5127
	DomainLaunchSecuritySevBuildID = "sev-build-id"
	// DomainLaunchSecuritySevPolicy as defined in libvirt/libvirt-domain.h:5135
	DomainLaunchSecuritySevPolicy = "sev-policy"
	// DomainLaunchSecuritySevSecretHeader as defined in libvirt/libvirt-domain.h:5146
	DomainLaunchSecuritySevSecretHeader = "sev-secret-header"
	// DomainLaunchSecuritySevSecret as defined in libvirt/libvirt-domain.h:5156
	DomainLaunchSecuritySevSecret = "sev-secret"
	// DomainLaunchSecuritySevSecretSetAddress as defined in libvirt/libvirt-domain.h:5165
	DomainLaunchSecuritySevSecretSetAddress = "sev-secret-set-address"
	// SecurityLabelBuflen as defined in libvirt/libvirt-host.h:84
	SecurityLabelBuflen = (4096 + 1)
	// SecurityModelBuflen as defined in libvirt/libvirt-host.h:112
	SecurityModelBuflen = (256 + 1)
	// SecurityDoiBuflen as defined in libvirt/libvirt-host.h:119
	SecurityDoiBuflen = (256 + 1)
	// NodeCPUStatsFieldLength as defined in libvirt/libvirt-host.h:180
	NodeCPUStatsFieldLength = 80
	// NodeCPUStatsKernel as defined in libvirt/libvirt-host.h:197
	NodeCPUStatsKernel = "kernel"
	// NodeCPUStatsUser as defined in libvirt/libvirt-host.h:205
	NodeCPUStatsUser = "user"
	// NodeCPUStatsIdle as defined in libvirt/libvirt-host.h:213
	NodeCPUStatsIdle = "idle"
	// NodeCPUStatsIowait as defined in libvirt/libvirt-host.h:221
	NodeCPUStatsIowait = "iowait"
	// NodeCPUStatsIntr as defined in libvirt/libvirt-host.h:229
	NodeCPUStatsIntr = "intr"
	// NodeCPUStatsUtilization as defined in libvirt/libvirt-host.h:238
	NodeCPUStatsUtilization = "utilization"
	// NodeMemoryStatsFieldLength as defined in libvirt/libvirt-host.h:258
	NodeMemoryStatsFieldLength = 80
	// NodeMemoryStatsTotal as defined in libvirt/libvirt-host.h:275
	NodeMemoryStatsTotal = "total"
	// NodeMemoryStatsFree as defined in libvirt/libvirt-host.h:284
	NodeMemoryStatsFree = "free"
	// NodeMemoryStatsBuffers as defined in libvirt/libvirt-host.h:292
	NodeMemoryStatsBuffers = "buffers"
	// NodeMemoryStatsCached as defined in libvirt/libvirt-host.h:300
	NodeMemoryStatsCached = "cached"
	// NodeMemorySharedPagesToScan as defined in libvirt/libvirt-host.h:321
	NodeMemorySharedPagesToScan = "shm_pages_to_scan"
	// NodeMemorySharedSleepMillisecs as defined in libvirt/libvirt-host.h:329
	NodeMemorySharedSleepMillisecs = "shm_sleep_millisecs"
	// NodeMemorySharedPagesShared as defined in libvirt/libvirt-host.h:337
	NodeMemorySharedPagesShared = "shm_pages_shared"
	// NodeMemorySharedPagesSharing as defined in libvirt/libvirt-host.h:345
	NodeMemorySharedPagesSharing = "shm_pages_sharing"
	// NodeMemorySharedPagesUnshared as defined in libvirt/libvirt-host.h:353
	NodeMemorySharedPagesUnshared = "shm_pages_unshared"
	// NodeMemorySharedPagesVolatile as defined in libvirt/libvirt-host.h:361
	NodeMemorySharedPagesVolatile = "shm_pages_volatile"
	// NodeMemorySharedFullScans as defined in libvirt/libvirt-host.h:369
	NodeMemorySharedFullScans = "shm_full_scans"
	// NodeMemorySharedMergeAcrossNodes as defined in libvirt/libvirt-host.h:381
	NodeMemorySharedMergeAcrossNodes = "shm_merge_across_nodes"
	// NodeSevPdh as defined in libvirt/libvirt-host.h:449
	NodeSevPdh = "pdh"
	// NodeSevCertChain as defined in libvirt/libvirt-host.h:458
	NodeSevCertChain = "cert-chain"
	// NodeSevCbitpos as defined in libvirt/libvirt-host.h:465
	NodeSevCbitpos = "cbitpos"
	// NodeSevReducedPhysBits as defined in libvirt/libvirt-host.h:473
	NodeSevReducedPhysBits = "reduced-phys-bits"
	// NodeSevMaxGuests as defined in libvirt/libvirt-host.h:481
	NodeSevMaxGuests = "max-guests"
	// NodeSevMaxEsGuests as defined in libvirt/libvirt-host.h:489
	NodeSevMaxEsGuests = "max-es-guests"
	// UUIDBuflen as defined in libvirt/libvirt-host.h:574
	UUIDBuflen = (16)
	// UUIDStringBuflen as defined in libvirt/libvirt-host.h:583
	UUIDStringBuflen = (36 + 1)
	// ConnectIdentityUserName as defined in libvirt/libvirt-host.h:608
	ConnectIdentityUserName = "user-name"
	// ConnectIdentityUnixUserID as defined in libvirt/libvirt-host.h:615
	ConnectIdentityUnixUserID = "unix-user-id"
	// ConnectIdentityGroupName as defined in libvirt/libvirt-host.h:622
	ConnectIdentityGroupName = "group-name"
	// ConnectIdentityUnixGroupID as defined in libvirt/libvirt-host.h:629
	ConnectIdentityUnixGroupID = "unix-group-id"
	// ConnectIdentityProcessID as defined in libvirt/libvirt-host.h:636
	ConnectIdentityProcessID = "process-id"
	// ConnectIdentityProcessTime as defined in libvirt/libvirt-host.h:647
	ConnectIdentityProcessTime = "process-time"
	// ConnectIdentitySaslUserName as defined in libvirt/libvirt-host.h:654
	ConnectIdentitySaslUserName = "sasl-user-name"
	// ConnectIdentityX509DistinguishedName as defined in libvirt/libvirt-host.h:661
	ConnectIdentityX509DistinguishedName = "x509-distinguished-name"
	// ConnectIdentitySelinuxContext as defined in libvirt/libvirt-host.h:668
	ConnectIdentitySelinuxContext = "selinux-context"
	// NetworkPortBandwidthInAverage as defined in libvirt/libvirt-network.h:406
	NetworkPortBandwidthInAverage = "inbound.average"
	// NetworkPortBandwidthInPeak as defined in libvirt/libvirt-network.h:413
	NetworkPortBandwidthInPeak = "inbound.peak"
	// NetworkPortBandwidthInBurst as defined in libvirt/libvirt-network.h:420
	NetworkPortBandwidthInBurst = "inbound.burst"
	// NetworkPortBandwidthInFloor as defined in libvirt/libvirt-network.h:427
	NetworkPortBandwidthInFloor = "inbound.floor"
	// NetworkPortBandwidthOutAverage as defined in libvirt/libvirt-network.h:434
	NetworkPortBandwidthOutAverage = "outbound.average"
	// NetworkPortBandwidthOutPeak as defined in libvirt/libvirt-network.h:441
	NetworkPortBandwidthOutPeak = "outbound.peak"
	// NetworkPortBandwidthOutBurst as defined in libvirt/libvirt-network.h:448
	NetworkPortBandwidthOutBurst = "outbound.burst"
)

// ConnectCloseReason as declared in libvirt/libvirt-common.h:119
type ConnectCloseReason int32

// ConnectCloseReason enumeration from libvirt/libvirt-common.h:119
const (
	ConnectCloseReasonError     ConnectCloseReason = iota
	ConnectCloseReasonEOF       ConnectCloseReason = 1
	ConnectCloseReasonKeepalive ConnectCloseReason = 2
	ConnectCloseReasonClient    ConnectCloseReason = 3
)

// TypedParameterType as declared in libvirt/libvirt-common.h:138
type TypedParameterType int32

// TypedParameterType enumeration from libvirt/libvirt-common.h:138
const (
	TypedParamInt     TypedParameterType = 1
	TypedParamUint    TypedParameterType = 2
	TypedParamLlong   TypedParameterType = 3
	TypedParamUllong  TypedParameterType = 4
	TypedParamDouble  TypedParameterType = 5
	TypedParamBoolean TypedParameterType = 6
	TypedParamString  TypedParameterType = 7
)

// TypedParameterFlags as declared in libvirt/libvirt-common.h:163
type TypedParameterFlags int32

// TypedParameterFlags enumeration from libvirt/libvirt-common.h:163
const (
	TypedParamStringOkay TypedParameterFlags = 4
)

// DomainCheckpointCreateFlags as declared in libvirt/libvirt-domain-checkpoint.h:62
type DomainCheckpointCreateFlags int32

// DomainCheckpointCreateFlags enumeration from libvirt/libvirt-domain-checkpoint.h:62
const (
	DomainCheckpointCreateRedefine         DomainCheckpointCreateFlags = 1
	DomainCheckpointCreateQuiesce          DomainCheckpointCreateFlags = 2
	DomainCheckpointCreateRedefineValidate DomainCheckpointCreateFlags = 4
)

// DomainCheckpointXMLFlags as declared in libvirt/libvirt-domain-checkpoint.h:75
type DomainCheckpointXMLFlags int32

// DomainCheckpointXMLFlags enumeration from libvirt/libvirt-domain-checkpoint.h:75
const (
	DomainCheckpointXMLSecure   DomainCheckpointXMLFlags = 1
	DomainCheckpointXMLNoDomain DomainCheckpointXMLFlags = 2
	DomainCheckpointXMLSize     DomainCheckpointXMLFlags = 4
)

// DomainCheckpointListFlags as declared in libvirt/libvirt-domain-checkpoint.h:105
type DomainCheckpointListFlags int32

// DomainCheckpointListFlags enumeration from libvirt/libvirt-domain-checkpoint.h:105
const (
	DomainCheckpointListRoots       DomainCheckpointListFlags = 1
	DomainCheckpointListDescendants DomainCheckpointListFlags = 1
	DomainCheckpointListTopological DomainCheckpointListFlags = 2
	DomainCheckpointListLeaves      DomainCheckpointListFlags = 4
	DomainCheckpointListNoLeaves    DomainCheckpointListFlags = 8
)

// DomainCheckpointDeleteFlags as declared in libvirt/libvirt-domain-checkpoint.h:131
type DomainCheckpointDeleteFlags int32

// DomainCheckpointDeleteFlags enumeration from libvirt/libvirt-domain-checkpoint.h:131
const (
	DomainCheckpointDeleteChildren     DomainCheckpointDeleteFlags = 1
	DomainCheckpointDeleteMetadataOnly DomainCheckpointDeleteFlags = 2
	DomainCheckpointDeleteChildrenOnly DomainCheckpointDeleteFlags = 4
)

// DomainSnapshotCreateFlags as declared in libvirt/libvirt-domain-snapshot.h:76
type DomainSnapshotCreateFlags int32

// DomainSnapshotCreateFlags enumeration from libvirt/libvirt-domain-snapshot.h:76
const (
	DomainSnapshotCreateRedefine   DomainSnapshotCreateFlags = 1
	DomainSnapshotCreateCurrent    DomainSnapshotCreateFlags = 2
	DomainSnapshotCreateNoMetadata DomainSnapshotCreateFlags = 4
	DomainSnapshotCreateHalt       DomainSnapshotCreateFlags = 8
	DomainSnapshotCreateDiskOnly   DomainSnapshotCreateFlags = 16
	DomainSnapshotCreateReuseExt   DomainSnapshotCreateFlags = 32
	DomainSnapshotCreateQuiesce    DomainSnapshotCreateFlags = 64
	DomainSnapshotCreateAtomic     DomainSnapshotCreateFlags = 128
	DomainSnapshotCreateLive       DomainSnapshotCreateFlags = 256
	DomainSnapshotCreateValidate   DomainSnapshotCreateFlags = 512
)

// DomainSnapshotXMLFlags as declared in libvirt/libvirt-domain-snapshot.h:85
type DomainSnapshotXMLFlags int32

// DomainSnapshotXMLFlags enumeration from libvirt/libvirt-domain-snapshot.h:85
const (
	DomainSnapshotXMLSecure DomainSnapshotXMLFlags = 1
)

// DomainSnapshotListFlags as declared in libvirt/libvirt-domain-snapshot.h:144
type DomainSnapshotListFlags int32

// DomainSnapshotListFlags enumeration from libvirt/libvirt-domain-snapshot.h:144
const (
	DomainSnapshotListRoots       DomainSnapshotListFlags = 1
	DomainSnapshotListDescendants DomainSnapshotListFlags = 1
	DomainSnapshotListLeaves      DomainSnapshotListFlags = 4
	DomainSnapshotListNoLeaves    DomainSnapshotListFlags = 8
	DomainSnapshotListMetadata    DomainSnapshotListFlags = 2
	DomainSnapshotListNoMetadata  DomainSnapshotListFlags = 16
	DomainSnapshotListInactive    DomainSnapshotListFlags = 32
	DomainSnapshotListActive      DomainSnapshotListFlags = 64
	DomainSnapshotListDiskOnly    DomainSnapshotListFlags = 128
	DomainSnapshotListInternal    DomainSnapshotListFlags = 256
	DomainSnapshotListExternal    DomainSnapshotListFlags = 512
	DomainSnapshotListTopological DomainSnapshotListFlags = 1024
)

// DomainSnapshotRevertFlags as declared in libvirt/libvirt-domain-snapshot.h:201
type DomainSnapshotRevertFlags int32

// DomainSnapshotRevertFlags enumeration from libvirt/libvirt-domain-snapshot.h:201
const (
	DomainSnapshotRevertRunning DomainSnapshotRevertFlags = 1
	DomainSnapshotRevertPaused  DomainSnapshotRevertFlags = 2
	DomainSnapshotRevertForce   DomainSnapshotRevertFlags = 4
)

// DomainSnapshotDeleteFlags as declared in libvirt/libvirt-domain-snapshot.h:215
type DomainSnapshotDeleteFlags int32

// DomainSnapshotDeleteFlags enumeration from libvirt/libvirt-domain-snapshot.h:215
const (
	DomainSnapshotDeleteChildren     DomainSnapshotDeleteFlags = 1
	DomainSnapshotDeleteMetadataOnly DomainSnapshotDeleteFlags = 2
	DomainSnapshotDeleteChildrenOnly DomainSnapshotDeleteFlags = 4
)

// DomainState as declared in libvirt/libvirt-domain.h:70
type DomainState int32

// DomainState enumeration from libvirt/libvirt-domain.h:70
const (
	DomainNostate     DomainState = iota
	DomainRunning     DomainState = 1
	DomainBlocked     DomainState = 2
	DomainPaused      DomainState = 3
	DomainShutdown    DomainState = 4
	DomainShutoff     DomainState = 5
	DomainCrashed     DomainState = 6
	DomainPmsuspended DomainState = 7
)

// DomainNostateReason as declared in libvirt/libvirt-domain.h:78
type DomainNostateReason int32

// DomainNostateReason enumeration from libvirt/libvirt-domain.h:78
const (
	DomainNostateUnknown DomainNostateReason = iota
)

// DomainRunningReason as declared in libvirt/libvirt-domain.h:97
type DomainRunningReason int32

// DomainRunningReason enumeration from libvirt/libvirt-domain.h:97
const (
	DomainRunningUnknown           DomainRunningReason = iota
	DomainRunningBooted            DomainRunningReason = 1
	DomainRunningMigrated          DomainRunningReason = 2
	DomainRunningRestored          DomainRunningReason = 3
	DomainRunningFromSnapshot      DomainRunningReason = 4
	DomainRunningUnpaused          DomainRunningReason = 5
	DomainRunningMigrationCanceled DomainRunningReason = 6
	DomainRunningSaveCanceled      DomainRunningReason = 7
	DomainRunningWakeup            DomainRunningReason = 8
	DomainRunningCrashed           DomainRunningReason = 9
	DomainRunningPostcopy          DomainRunningReason = 10
)

// DomainBlockedReason as declared in libvirt/libvirt-domain.h:105
type DomainBlockedReason int32

// DomainBlockedReason enumeration from libvirt/libvirt-domain.h:105
const (
	DomainBlockedUnknown DomainBlockedReason = iota
)

// DomainPausedReason as declared in libvirt/libvirt-domain.h:126
type DomainPausedReason int32

// DomainPausedReason enumeration from libvirt/libvirt-domain.h:126
const (
	DomainPausedUnknown        DomainPausedReason = iota
	DomainPausedUser           DomainPausedReason = 1
	DomainPausedMigration      DomainPausedReason = 2
	DomainPausedSave           DomainPausedReason = 3
	DomainPausedDump           DomainPausedReason = 4
	DomainPausedIoerror        DomainPausedReason = 5
	DomainPausedWatchdog       DomainPausedReason = 6
	DomainPausedFromSnapshot   DomainPausedReason = 7
	DomainPausedShuttingDown   DomainPausedReason = 8
	DomainPausedSnapshot       DomainPausedReason = 9
	DomainPausedCrashed        DomainPausedReason = 10
	DomainPausedStartingUp     DomainPausedReason = 11
	DomainPausedPostcopy       DomainPausedReason = 12
	DomainPausedPostcopyFailed DomainPausedReason = 13
)

// DomainShutdownReason as declared in libvirt/libvirt-domain.h:135
type DomainShutdownReason int32

// DomainShutdownReason enumeration from libvirt/libvirt-domain.h:135
const (
	DomainShutdownUnknown DomainShutdownReason = iota
	DomainShutdownUser    DomainShutdownReason = 1
)

// DomainShutoffReason as declared in libvirt/libvirt-domain.h:152
type DomainShutoffReason int32

// DomainShutoffReason enumeration from libvirt/libvirt-domain.h:152
const (
	DomainShutoffUnknown      DomainShutoffReason = iota
	DomainShutoffShutdown     DomainShutoffReason = 1
	DomainShutoffDestroyed    DomainShutoffReason = 2
	DomainShutoffCrashed      DomainShutoffReason = 3
	DomainShutoffMigrated     DomainShutoffReason = 4
	DomainShutoffSaved        DomainShutoffReason = 5
	DomainShutoffFailed       DomainShutoffReason = 6
	DomainShutoffFromSnapshot DomainShutoffReason = 7
	DomainShutoffDaemon       DomainShutoffReason = 8
)

// DomainCrashedReason as declared in libvirt/libvirt-domain.h:161
type DomainCrashedReason int32

// DomainCrashedReason enumeration from libvirt/libvirt-domain.h:161
const (
	DomainCrashedUnknown  DomainCrashedReason = iota
	DomainCrashedPanicked DomainCrashedReason = 1
)

// DomainPMSuspendedReason as declared in libvirt/libvirt-domain.h:169
type DomainPMSuspendedReason int32

// DomainPMSuspendedReason enumeration from libvirt/libvirt-domain.h:169
const (
	DomainPmsuspendedUnknown DomainPMSuspendedReason = iota
)

// DomainPMSuspendedDiskReason as declared in libvirt/libvirt-domain.h:177
type DomainPMSuspendedDiskReason int32

// DomainPMSuspendedDiskReason enumeration from libvirt/libvirt-domain.h:177
const (
	DomainPmsuspendedDiskUnknown DomainPMSuspendedDiskReason = iota
)

// DomainControlState as declared in libvirt/libvirt-domain.h:197
type DomainControlState int32

// DomainControlState enumeration from libvirt/libvirt-domain.h:197
const (
	DomainControlOk       DomainControlState = iota
	DomainControlJob      DomainControlState = 1
	DomainControlOccupied DomainControlState = 2
	DomainControlError    DomainControlState = 3
)

// DomainControlErrorReason as declared in libvirt/libvirt-domain.h:217
type DomainControlErrorReason int32

// DomainControlErrorReason enumeration from libvirt/libvirt-domain.h:217
const (
	DomainControlErrorReasonNone     DomainControlErrorReason = iota
	DomainControlErrorReasonUnknown  DomainControlErrorReason = 1
	DomainControlErrorReasonMonitor  DomainControlErrorReason = 2
	DomainControlErrorReasonInternal DomainControlErrorReason = 3
)

// DomainModificationImpact as declared in libvirt/libvirt-domain.h:265
type DomainModificationImpact int32

// DomainModificationImpact enumeration from libvirt/libvirt-domain.h:265
const (
	DomainAffectCurrent DomainModificationImpact = iota
	DomainAffectLive    DomainModificationImpact = 1
	DomainAffectConfig  DomainModificationImpact = 2
)

// DomainCreateFlags as declared in libvirt/libvirt-domain.h:305
type DomainCreateFlags int32

// DomainCreateFlags enumeration from libvirt/libvirt-domain.h:305
const (
	DomainNone             DomainCreateFlags = iota
	DomainStartPaused      DomainCreateFlags = 1
	DomainStartAutodestroy DomainCreateFlags = 2
	DomainStartBypassCache DomainCreateFlags = 4
	DomainStartForceBoot   DomainCreateFlags = 8
	DomainStartValidate    DomainCreateFlags = 16
)

// DomainMemoryStatTags as declared in libvirt/libvirt-domain.h:660
type DomainMemoryStatTags int32

// DomainMemoryStatTags enumeration from libvirt/libvirt-domain.h:660
const (
	DomainMemoryStatSwapIn         DomainMemoryStatTags = iota
	DomainMemoryStatSwapOut        DomainMemoryStatTags = 1
	DomainMemoryStatMajorFault     DomainMemoryStatTags = 2
	DomainMemoryStatMinorFault     DomainMemoryStatTags = 3
	DomainMemoryStatUnused         DomainMemoryStatTags = 4
	DomainMemoryStatAvailable      DomainMemoryStatTags = 5
	DomainMemoryStatActualBalloon  DomainMemoryStatTags = 6
	DomainMemoryStatRss            DomainMemoryStatTags = 7
	DomainMemoryStatUsable         DomainMemoryStatTags = 8
	DomainMemoryStatLastUpdate     DomainMemoryStatTags = 9
	DomainMemoryStatDiskCaches     DomainMemoryStatTags = 10
	DomainMemoryStatHugetlbPgalloc DomainMemoryStatTags = 11
	DomainMemoryStatHugetlbPgfail  DomainMemoryStatTags = 12
	DomainMemoryStatNr             DomainMemoryStatTags = 13
)

// DomainCoreDumpFlags as declared in libvirt/libvirt-domain.h:679
type DomainCoreDumpFlags int32

// DomainCoreDumpFlags enumeration from libvirt/libvirt-domain.h:679
const (
	DumpCrash       DomainCoreDumpFlags = 1
	DumpLive        DomainCoreDumpFlags = 2
	DumpBypassCache DomainCoreDumpFlags = 4
	DumpReset       DomainCoreDumpFlags = 8
	DumpMemoryOnly  DomainCoreDumpFlags = 16
)

// DomainCoreDumpFormat as declared in libvirt/libvirt-domain.h:703
type DomainCoreDumpFormat int32

// DomainCoreDumpFormat enumeration from libvirt/libvirt-domain.h:703
const (
	DomainCoreDumpFormatRaw         DomainCoreDumpFormat = iota
	DomainCoreDumpFormatKdumpZlib   DomainCoreDumpFormat = 1
	DomainCoreDumpFormatKdumpLzo    DomainCoreDumpFormat = 2
	DomainCoreDumpFormatKdumpSnappy DomainCoreDumpFormat = 3
	DomainCoreDumpFormatWinDmp      DomainCoreDumpFormat = 4
)

// DomainMigrateFlags as declared in libvirt/libvirt-domain.h:863
type DomainMigrateFlags int32

// DomainMigrateFlags enumeration from libvirt/libvirt-domain.h:863
const (
	MigrateLive                       DomainMigrateFlags = 1
	MigratePeer2peer                  DomainMigrateFlags = 2
	MigrateTunnelled                  DomainMigrateFlags = 4
	MigratePersistDest                DomainMigrateFlags = 8
	MigrateUndefineSource             DomainMigrateFlags = 16
	MigratePaused                     DomainMigrateFlags = 32
	MigrateNonSharedDisk              DomainMigrateFlags = 64
	MigrateNonSharedInc               DomainMigrateFlags = 128
	MigrateChangeProtection           DomainMigrateFlags = 256
	MigrateUnsafe                     DomainMigrateFlags = 512
	MigrateOffline                    DomainMigrateFlags = 1024
	MigrateCompressed                 DomainMigrateFlags = 2048
	MigrateAbortOnError               DomainMigrateFlags = 4096
	MigrateAutoConverge               DomainMigrateFlags = 8192
	MigrateRdmaPinAll                 DomainMigrateFlags = 16384
	MigratePostcopy                   DomainMigrateFlags = 32768
	MigrateTLS                        DomainMigrateFlags = 65536
	MigrateParallel                   DomainMigrateFlags = 131072
	MigrateNonSharedSynchronousWrites DomainMigrateFlags = 262144
)

// DomainMigrateMaxSpeedFlags as declared in libvirt/libvirt-domain.h:1142
type DomainMigrateMaxSpeedFlags int32

// DomainMigrateMaxSpeedFlags enumeration from libvirt/libvirt-domain.h:1142
const (
	DomainMigrateMaxSpeedPostcopy DomainMigrateMaxSpeedFlags = 1
)

// DomainShutdownFlagValues as declared in libvirt/libvirt-domain.h:1208
type DomainShutdownFlagValues int32

// DomainShutdownFlagValues enumeration from libvirt/libvirt-domain.h:1208
const (
	DomainShutdownDefault      DomainShutdownFlagValues = iota
	DomainShutdownAcpiPowerBtn DomainShutdownFlagValues = 1
	DomainShutdownGuestAgent   DomainShutdownFlagValues = 2
	DomainShutdownInitctl      DomainShutdownFlagValues = 4
	DomainShutdownSignal       DomainShutdownFlagValues = 8
	DomainShutdownParavirt     DomainShutdownFlagValues = 16
)

// DomainRebootFlagValues as declared in libvirt/libvirt-domain.h:1221
type DomainRebootFlagValues int32

// DomainRebootFlagValues enumeration from libvirt/libvirt-domain.h:1221
const (
	DomainRebootDefault      DomainRebootFlagValues = iota
	DomainRebootAcpiPowerBtn DomainRebootFlagValues = 1
	DomainRebootGuestAgent   DomainRebootFlagValues = 2
	DomainRebootInitctl      DomainRebootFlagValues = 4
	DomainRebootSignal       DomainRebootFlagValues = 8
	DomainRebootParavirt     DomainRebootFlagValues = 16
)

// DomainDestroyFlagsValues as declared in libvirt/libvirt-domain.h:1239
type DomainDestroyFlagsValues int32

// DomainDestroyFlagsValues enumeration from libvirt/libvirt-domain.h:1239
const (
	DomainDestroyDefault  DomainDestroyFlagsValues = iota
	DomainDestroyGraceful DomainDestroyFlagsValues = 1
)

// DomainSaveRestoreFlags as declared in libvirt/libvirt-domain.h:1271
type DomainSaveRestoreFlags int32

// DomainSaveRestoreFlags enumeration from libvirt/libvirt-domain.h:1271
const (
	DomainSaveBypassCache DomainSaveRestoreFlags = 1
	DomainSaveRunning     DomainSaveRestoreFlags = 2
	DomainSavePaused      DomainSaveRestoreFlags = 4
)

// DomainMemoryModFlags as declared in libvirt/libvirt-domain.h:1527
type DomainMemoryModFlags int32

// DomainMemoryModFlags enumeration from libvirt/libvirt-domain.h:1527
const (
	DomainMemCurrent DomainMemoryModFlags = iota
	DomainMemLive    DomainMemoryModFlags = 1
	DomainMemConfig  DomainMemoryModFlags = 2
	DomainMemMaximum DomainMemoryModFlags = 4
)

// DomainNumatuneMemMode as declared in libvirt/libvirt-domain.h:1546
type DomainNumatuneMemMode int32

// DomainNumatuneMemMode enumeration from libvirt/libvirt-domain.h:1546
const (
	DomainNumatuneMemStrict      DomainNumatuneMemMode = iota
	DomainNumatuneMemPreferred   DomainNumatuneMemMode = 1
	DomainNumatuneMemInterleave  DomainNumatuneMemMode = 2
	DomainNumatuneMemRestrictive DomainNumatuneMemMode = 3
)

// DomainGetHostnameFlags as declared in libvirt/libvirt-domain.h:1599
type DomainGetHostnameFlags int32

// DomainGetHostnameFlags enumeration from libvirt/libvirt-domain.h:1599
const (
	DomainGetHostnameLease DomainGetHostnameFlags = 1
	DomainGetHostnameAgent DomainGetHostnameFlags = 2
)

// DomainMetadataType as declared in libvirt/libvirt-domain.h:1614
type DomainMetadataType int32

// DomainMetadataType enumeration from libvirt/libvirt-domain.h:1614
const (
	DomainMetadataDescription DomainMetadataType = iota
	DomainMetadataTitle       DomainMetadataType = 1
	DomainMetadataElement     DomainMetadataType = 2
)

// DomainXMLFlags as declared in libvirt/libvirt-domain.h:1644
type DomainXMLFlags int32

// DomainXMLFlags enumeration from libvirt/libvirt-domain.h:1644
const (
	DomainXMLSecure     DomainXMLFlags = 1
	DomainXMLInactive   DomainXMLFlags = 2
	DomainXMLUpdateCPU  DomainXMLFlags = 4
	DomainXMLMigratable DomainXMLFlags = 8
)

// DomainSaveImageXMLFlags as declared in libvirt/libvirt-domain.h:1648
type DomainSaveImageXMLFlags int32

// DomainSaveImageXMLFlags enumeration from libvirt/libvirt-domain.h:1648
const (
	DomainSaveImageXMLSecure DomainSaveImageXMLFlags = 1
)

// DomainBlockResizeFlags as declared in libvirt/libvirt-domain.h:1753
type DomainBlockResizeFlags int32

// DomainBlockResizeFlags enumeration from libvirt/libvirt-domain.h:1753
const (
	DomainBlockResizeBytes DomainBlockResizeFlags = 1
)

// DomainMemoryFlags as declared in libvirt/libvirt-domain.h:1816
type DomainMemoryFlags int32

// DomainMemoryFlags enumeration from libvirt/libvirt-domain.h:1816
const (
	MemoryVirtual  DomainMemoryFlags = 1
	MemoryPhysical DomainMemoryFlags = 2
)

// DomainDefineFlags as declared in libvirt/libvirt-domain.h:1826
type DomainDefineFlags int32

// DomainDefineFlags enumeration from libvirt/libvirt-domain.h:1826
const (
	DomainDefineValidate DomainDefineFlags = 1
)

// DomainUndefineFlagsValues as declared in libvirt/libvirt-domain.h:1853
type DomainUndefineFlagsValues int32

// DomainUndefineFlagsValues enumeration from libvirt/libvirt-domain.h:1853
const (
	DomainUndefineManagedSave         DomainUndefineFlagsValues = 1
	DomainUndefineSnapshotsMetadata   DomainUndefineFlagsValues = 2
	DomainUndefineNvram               DomainUndefineFlagsValues = 4
	DomainUndefineKeepNvram           DomainUndefineFlagsValues = 8
	DomainUndefineCheckpointsMetadata DomainUndefineFlagsValues = 16
)

// ConnectListAllDomainsFlags as declared in libvirt/libvirt-domain.h:1892
type ConnectListAllDomainsFlags int32

// ConnectListAllDomainsFlags enumeration from libvirt/libvirt-domain.h:1892
const (
	ConnectListDomainsActive        ConnectListAllDomainsFlags = 1
	ConnectListDomainsInactive      ConnectListAllDomainsFlags = 2
	ConnectListDomainsPersistent    ConnectListAllDomainsFlags = 4
	ConnectListDomainsTransient     ConnectListAllDomainsFlags = 8
	ConnectListDomainsRunning       ConnectListAllDomainsFlags = 16
	ConnectListDomainsPaused        ConnectListAllDomainsFlags = 32
	ConnectListDomainsShutoff       ConnectListAllDomainsFlags = 64
	ConnectListDomainsOther         ConnectListAllDomainsFlags = 128
	ConnectListDomainsManagedsave   ConnectListAllDomainsFlags = 256
	ConnectListDomainsNoManagedsave ConnectListAllDomainsFlags = 512
	ConnectListDomainsAutostart     ConnectListAllDomainsFlags = 1024
	ConnectListDomainsNoAutostart   ConnectListAllDomainsFlags = 2048
	ConnectListDomainsHasSnapshot   ConnectListAllDomainsFlags = 4096
	ConnectListDomainsNoSnapshot    ConnectListAllDomainsFlags = 8192
	ConnectListDomainsHasCheckpoint ConnectListAllDomainsFlags = 16384
	ConnectListDomainsNoCheckpoint  ConnectListAllDomainsFlags = 32768
)

// VCPUState as declared in libvirt/libvirt-domain.h:1923
type VCPUState int32

// VCPUState enumeration from libvirt/libvirt-domain.h:1923
const (
	VCPUOffline VCPUState = iota
	VCPURunning VCPUState = 1
	VCPUBlocked VCPUState = 2
)

// VCPUHostCPUState as declared in libvirt/libvirt-domain.h:1928
type VCPUHostCPUState int32

// VCPUHostCPUState enumeration from libvirt/libvirt-domain.h:1928
const (
	VCPUInfoCPUOffline     VCPUHostCPUState = -1
	VCPUInfoCPUUnavailable VCPUHostCPUState = -2
)

// DomainVCPUFlags as declared in libvirt/libvirt-domain.h:1950
type DomainVCPUFlags int32

// DomainVCPUFlags enumeration from libvirt/libvirt-domain.h:1950
const (
	DomainVCPUCurrent      DomainVCPUFlags = iota
	DomainVCPULive         DomainVCPUFlags = 1
	DomainVCPUConfig       DomainVCPUFlags = 2
	DomainVCPUMaximum      DomainVCPUFlags = 4
	DomainVCPUGuest        DomainVCPUFlags = 8
	DomainVCPUHotpluggable DomainVCPUFlags = 16
)

// DomainDeviceModifyFlags as declared in libvirt/libvirt-domain.h:2167
type DomainDeviceModifyFlags int32

// DomainDeviceModifyFlags enumeration from libvirt/libvirt-domain.h:2167
const (
	DomainDeviceModifyCurrent DomainDeviceModifyFlags = iota
	DomainDeviceModifyLive    DomainDeviceModifyFlags = 1
	DomainDeviceModifyConfig  DomainDeviceModifyFlags = 2
	DomainDeviceModifyForce   DomainDeviceModifyFlags = 4
)

// DomainStatsTypes as declared in libvirt/libvirt-domain.h:2201
type DomainStatsTypes int32

// DomainStatsTypes enumeration from libvirt/libvirt-domain.h:2201
const (
	DomainStatsState     DomainStatsTypes = 1
	DomainStatsCPUTotal  DomainStatsTypes = 2
	DomainStatsBalloon   DomainStatsTypes = 4
	DomainStatsVCPU      DomainStatsTypes = 8
	DomainStatsInterface DomainStatsTypes = 16
	DomainStatsBlock     DomainStatsTypes = 32
	DomainStatsPerf      DomainStatsTypes = 64
	DomainStatsIothread  DomainStatsTypes = 128
	DomainStatsMemory    DomainStatsTypes = 256
	DomainStatsDirtyrate DomainStatsTypes = 512
)

// ConnectGetAllDomainStatsFlags as declared in libvirt/libvirt-domain.h:2219
type ConnectGetAllDomainStatsFlags uint32

// ConnectGetAllDomainStatsFlags enumeration from libvirt/libvirt-domain.h:2219
const (
	ConnectGetAllDomainsStatsActive       ConnectGetAllDomainStatsFlags = 1
	ConnectGetAllDomainsStatsInactive     ConnectGetAllDomainStatsFlags = 2
	ConnectGetAllDomainsStatsPersistent   ConnectGetAllDomainStatsFlags = 4
	ConnectGetAllDomainsStatsTransient    ConnectGetAllDomainStatsFlags = 8
	ConnectGetAllDomainsStatsRunning      ConnectGetAllDomainStatsFlags = 16
	ConnectGetAllDomainsStatsPaused       ConnectGetAllDomainStatsFlags = 32
	ConnectGetAllDomainsStatsShutoff      ConnectGetAllDomainStatsFlags = 64
	ConnectGetAllDomainsStatsOther        ConnectGetAllDomainStatsFlags = 128
	ConnectGetAllDomainsStatsNowait       ConnectGetAllDomainStatsFlags = 536870912
	ConnectGetAllDomainsStatsBacking      ConnectGetAllDomainStatsFlags = 1073741824
	ConnectGetAllDomainsStatsEnforceStats ConnectGetAllDomainStatsFlags = 2147483648
)

// DomainBlockJobType as declared in libvirt/libvirt-domain.h:2507
type DomainBlockJobType int32

// DomainBlockJobType enumeration from libvirt/libvirt-domain.h:2507
const (
	DomainBlockJobTypeUnknown      DomainBlockJobType = iota
	DomainBlockJobTypePull         DomainBlockJobType = 1
	DomainBlockJobTypeCopy         DomainBlockJobType = 2
	DomainBlockJobTypeCommit       DomainBlockJobType = 3
	DomainBlockJobTypeActiveCommit DomainBlockJobType = 4
	DomainBlockJobTypeBackup       DomainBlockJobType = 5
)

// DomainBlockJobAbortFlags as declared in libvirt/libvirt-domain.h:2519
type DomainBlockJobAbortFlags int32

// DomainBlockJobAbortFlags enumeration from libvirt/libvirt-domain.h:2519
const (
	DomainBlockJobAbortAsync DomainBlockJobAbortFlags = 1
	DomainBlockJobAbortPivot DomainBlockJobAbortFlags = 2
)

// DomainBlockJobInfoFlags as declared in libvirt/libvirt-domain.h:2528
type DomainBlockJobInfoFlags int32

// DomainBlockJobInfoFlags enumeration from libvirt/libvirt-domain.h:2528
const (
	DomainBlockJobInfoBandwidthBytes DomainBlockJobInfoFlags = 1
)

// DomainBlockJobSetSpeedFlags as declared in libvirt/libvirt-domain.h:2557
type DomainBlockJobSetSpeedFlags int32

// DomainBlockJobSetSpeedFlags enumeration from libvirt/libvirt-domain.h:2557
const (
	DomainBlockJobSpeedBandwidthBytes DomainBlockJobSetSpeedFlags = 1
)

// DomainBlockPullFlags as declared in libvirt/libvirt-domain.h:2567
type DomainBlockPullFlags int32

// DomainBlockPullFlags enumeration from libvirt/libvirt-domain.h:2567
const (
	DomainBlockPullBandwidthBytes DomainBlockPullFlags = 64
)

// DomainBlockRebaseFlags as declared in libvirt/libvirt-domain.h:2591
type DomainBlockRebaseFlags int32

// DomainBlockRebaseFlags enumeration from libvirt/libvirt-domain.h:2591
const (
	DomainBlockRebaseShallow        DomainBlockRebaseFlags = 1
	DomainBlockRebaseReuseExt       DomainBlockRebaseFlags = 2
	DomainBlockRebaseCopyRaw        DomainBlockRebaseFlags = 4
	DomainBlockRebaseCopy           DomainBlockRebaseFlags = 8
	DomainBlockRebaseRelative       DomainBlockRebaseFlags = 16
	DomainBlockRebaseCopyDev        DomainBlockRebaseFlags = 32
	DomainBlockRebaseBandwidthBytes DomainBlockRebaseFlags = 64
)

// DomainBlockCopyFlags as declared in libvirt/libvirt-domain.h:2615
type DomainBlockCopyFlags int32

// DomainBlockCopyFlags enumeration from libvirt/libvirt-domain.h:2615
const (
	DomainBlockCopyShallow           DomainBlockCopyFlags = 1
	DomainBlockCopyReuseExt          DomainBlockCopyFlags = 2
	DomainBlockCopyTransientJob      DomainBlockCopyFlags = 4
	DomainBlockCopySynchronousWrites DomainBlockCopyFlags = 8
)

// DomainBlockCommitFlags as declared in libvirt/libvirt-domain.h:2680
type DomainBlockCommitFlags int32

// DomainBlockCommitFlags enumeration from libvirt/libvirt-domain.h:2680
const (
	DomainBlockCommitShallow        DomainBlockCommitFlags = 1
	DomainBlockCommitDelete         DomainBlockCommitFlags = 2
	DomainBlockCommitActive         DomainBlockCommitFlags = 4
	DomainBlockCommitRelative       DomainBlockCommitFlags = 8
	DomainBlockCommitBandwidthBytes DomainBlockCommitFlags = 16
)

// DomainDiskErrorCode as declared in libvirt/libvirt-domain.h:2871
type DomainDiskErrorCode int32

// DomainDiskErrorCode enumeration from libvirt/libvirt-domain.h:2871
const (
	DomainDiskErrorNone    DomainDiskErrorCode = iota
	DomainDiskErrorUnspec  DomainDiskErrorCode = 1
	DomainDiskErrorNoSpace DomainDiskErrorCode = 2
)

// KeycodeSet as declared in libvirt/libvirt-domain.h:2917
type KeycodeSet int32

// KeycodeSet enumeration from libvirt/libvirt-domain.h:2917
const (
	KeycodeSetLinux  KeycodeSet = iota
	KeycodeSetXt     KeycodeSet = 1
	KeycodeSetAtset1 KeycodeSet = 2
	KeycodeSetAtset2 KeycodeSet = 3
	KeycodeSetAtset3 KeycodeSet = 4
	KeycodeSetOsx    KeycodeSet = 5
	KeycodeSetXtKbd  KeycodeSet = 6
	KeycodeSetUsb    KeycodeSet = 7
	KeycodeSetWin32  KeycodeSet = 8
	KeycodeSetQnum   KeycodeSet = 9
)

// DomainProcessSignal as declared in libvirt/libvirt-domain.h:3026
type DomainProcessSignal int32

// DomainProcessSignal enumeration from libvirt/libvirt-domain.h:3026
const (
	DomainProcessSignalNop    DomainProcessSignal = iota
	DomainProcessSignalHup    DomainProcessSignal = 1
	DomainProcessSignalInt    DomainProcessSignal = 2
	DomainProcessSignalQuit   DomainProcessSignal = 3
	DomainProcessSignalIll    DomainProcessSignal = 4
	DomainProcessSignalTrap   DomainProcessSignal = 5
	DomainProcessSignalAbrt   DomainProcessSignal = 6
	DomainProcessSignalBus    DomainProcessSignal = 7
	DomainProcessSignalFpe    DomainProcessSignal = 8
	DomainProcessSignalKill   DomainProcessSignal = 9
	DomainProcessSignalUsr1   DomainProcessSignal = 10
	DomainProcessSignalSegv   DomainProcessSignal = 11
	DomainProcessSignalUsr2   DomainProcessSignal = 12
	DomainProcessSignalPipe   DomainProcessSignal = 13
	DomainProcessSignalAlrm   DomainProcessSignal = 14
	DomainProcessSignalTerm   DomainProcessSignal = 15
	DomainProcessSignalStkflt DomainProcessSignal = 16
	DomainProcessSignalChld   DomainProcessSignal = 17
	DomainProcessSignalCont   DomainProcessSignal = 18
	DomainProcessSignalStop   DomainProcessSignal = 19
	DomainProcessSignalTstp   DomainProcessSignal = 20
	DomainProcessSignalTtin   DomainProcessSignal = 21
	DomainProcessSignalTtou   DomainProcessSignal = 22
	DomainProcessSignalUrg    DomainProcessSignal = 23
	DomainProcessSignalXcpu   DomainProcessSignal = 24
	DomainProcessSignalXfsz   DomainProcessSignal = 25
	DomainProcessSignalVtalrm DomainProcessSignal = 26
	DomainProcessSignalProf   DomainProcessSignal = 27
	DomainProcessSignalWinch  DomainProcessSignal = 28
	DomainProcessSignalPoll   DomainProcessSignal = 29
	DomainProcessSignalPwr    DomainProcessSignal = 30
	DomainProcessSignalSys    DomainProcessSignal = 31
	DomainProcessSignalRt0    DomainProcessSignal = 32
	DomainProcessSignalRt1    DomainProcessSignal = 33
	DomainProcessSignalRt2    DomainProcessSignal = 34
	DomainProcessSignalRt3    DomainProcessSignal = 35
	DomainProcessSignalRt4    DomainProcessSignal = 36
	DomainProcessSignalRt5    DomainProcessSignal = 37
	DomainProcessSignalRt6    DomainProcessSignal = 38
	DomainProcessSignalRt7    DomainProcessSignal = 39
	DomainProcessSignalRt8    DomainProcessSignal = 40
	DomainProcessSignalRt9    DomainProcessSignal = 41
	DomainProcessSignalRt10   DomainProcessSignal = 42
	DomainProcessSignalRt11   DomainProcessSignal = 43
	DomainProcessSignalRt12   DomainProcessSignal = 44
	DomainProcessSignalRt13   DomainProcessSignal = 45
	DomainProcessSignalRt14   DomainProcessSignal = 46
	DomainProcessSignalRt15   DomainProcessSignal = 47
	DomainProcessSignalRt16   DomainProcessSignal = 48
	DomainProcessSignalRt17   DomainProcessSignal = 49
	DomainProcessSignalRt18   DomainProcessSignal = 50
	DomainProcessSignalRt19   DomainProcessSignal = 51
	DomainProcessSignalRt20   DomainProcessSignal = 52
	DomainProcessSignalRt21   DomainProcessSignal = 53
	DomainProcessSignalRt22   DomainProcessSignal = 54
	DomainProcessSignalRt23   DomainProcessSignal = 55
	DomainProcessSignalRt24   DomainProcessSignal = 56
	DomainProcessSignalRt25   DomainProcessSignal = 57
	DomainProcessSignalRt26   DomainProcessSignal = 58
	DomainProcessSignalRt27   DomainProcessSignal = 59
	DomainProcessSignalRt28   DomainProcessSignal = 60
	DomainProcessSignalRt29   DomainProcessSignal = 61
	DomainProcessSignalRt30   DomainProcessSignal = 62
	DomainProcessSignalRt31   DomainProcessSignal = 63
	DomainProcessSignalRt32   DomainProcessSignal = 64
)

// DomainEventType as declared in libvirt/libvirt-domain.h:3064
type DomainEventType int32

// DomainEventType enumeration from libvirt/libvirt-domain.h:3064
const (
	DomainEventDefined     DomainEventType = iota
	DomainEventUndefined   DomainEventType = 1
	DomainEventStarted     DomainEventType = 2
	DomainEventSuspended   DomainEventType = 3
	DomainEventResumed     DomainEventType = 4
	DomainEventStopped     DomainEventType = 5
	DomainEventShutdown    DomainEventType = 6
	DomainEventPmsuspended DomainEventType = 7
	DomainEventCrashed     DomainEventType = 8
)

// DomainEventDefinedDetailType as declared in libvirt/libvirt-domain.h:3080
type DomainEventDefinedDetailType int32

// DomainEventDefinedDetailType enumeration from libvirt/libvirt-domain.h:3080
const (
	DomainEventDefinedAdded        DomainEventDefinedDetailType = iota
	DomainEventDefinedUpdated      DomainEventDefinedDetailType = 1
	DomainEventDefinedRenamed      DomainEventDefinedDetailType = 2
	DomainEventDefinedFromSnapshot DomainEventDefinedDetailType = 3
)

// DomainEventUndefinedDetailType as declared in libvirt/libvirt-domain.h:3094
type DomainEventUndefinedDetailType int32

// DomainEventUndefinedDetailType enumeration from libvirt/libvirt-domain.h:3094
const (
	DomainEventUndefinedRemoved DomainEventUndefinedDetailType = iota
	DomainEventUndefinedRenamed DomainEventUndefinedDetailType = 1
)

// DomainEventStartedDetailType as declared in libvirt/libvirt-domain.h:3111
type DomainEventStartedDetailType int32

// DomainEventStartedDetailType enumeration from libvirt/libvirt-domain.h:3111
const (
	DomainEventStartedBooted       DomainEventStartedDetailType = iota
	DomainEventStartedMigrated     DomainEventStartedDetailType = 1
	DomainEventStartedRestored     DomainEventStartedDetailType = 2
	DomainEventStartedFromSnapshot DomainEventStartedDetailType = 3
	DomainEventStartedWakeup       DomainEventStartedDetailType = 4
)

// DomainEventSuspendedDetailType as declared in libvirt/libvirt-domain.h:3132
type DomainEventSuspendedDetailType int32

// DomainEventSuspendedDetailType enumeration from libvirt/libvirt-domain.h:3132
const (
	DomainEventSuspendedPaused         DomainEventSuspendedDetailType = iota
	DomainEventSuspendedMigrated       DomainEventSuspendedDetailType = 1
	DomainEventSuspendedIoerror        DomainEventSuspendedDetailType = 2
	DomainEventSuspendedWatchdog       DomainEventSuspendedDetailType = 3
	DomainEventSuspendedRestored       DomainEventSuspendedDetailType = 4
	DomainEventSuspendedFromSnapshot   DomainEventSuspendedDetailType = 5
	DomainEventSuspendedAPIError       DomainEventSuspendedDetailType = 6
	DomainEventSuspendedPostcopy       DomainEventSuspendedDetailType = 7
	DomainEventSuspendedPostcopyFailed DomainEventSuspendedDetailType = 8
)

// DomainEventResumedDetailType as declared in libvirt/libvirt-domain.h:3149
type DomainEventResumedDetailType int32

// DomainEventResumedDetailType enumeration from libvirt/libvirt-domain.h:3149
const (
	DomainEventResumedUnpaused     DomainEventResumedDetailType = iota
	DomainEventResumedMigrated     DomainEventResumedDetailType = 1
	DomainEventResumedFromSnapshot DomainEventResumedDetailType = 2
	DomainEventResumedPostcopy     DomainEventResumedDetailType = 3
)

// DomainEventStoppedDetailType as declared in libvirt/libvirt-domain.h:3168
type DomainEventStoppedDetailType int32

// DomainEventStoppedDetailType enumeration from libvirt/libvirt-domain.h:3168
const (
	DomainEventStoppedShutdown     DomainEventStoppedDetailType = iota
	DomainEventStoppedDestroyed    DomainEventStoppedDetailType = 1
	DomainEventStoppedCrashed      DomainEventStoppedDetailType = 2
	DomainEventStoppedMigrated     DomainEventStoppedDetailType = 3
	DomainEventStoppedSaved        DomainEventStoppedDetailType = 4
	DomainEventStoppedFailed       DomainEventStoppedDetailType = 5
	DomainEventStoppedFromSnapshot DomainEventStoppedDetailType = 6
)

// DomainEventShutdownDetailType as declared in libvirt/libvirt-domain.h:3191
type DomainEventShutdownDetailType int32

// DomainEventShutdownDetailType enumeration from libvirt/libvirt-domain.h:3191
const (
	DomainEventShutdownFinished DomainEventShutdownDetailType = iota
	DomainEventShutdownGuest    DomainEventShutdownDetailType = 1
	DomainEventShutdownHost     DomainEventShutdownDetailType = 2
)

// DomainEventPMSuspendedDetailType as declared in libvirt/libvirt-domain.h:3205
type DomainEventPMSuspendedDetailType int32

// DomainEventPMSuspendedDetailType enumeration from libvirt/libvirt-domain.h:3205
const (
	DomainEventPmsuspendedMemory DomainEventPMSuspendedDetailType = iota
	DomainEventPmsuspendedDisk   DomainEventPMSuspendedDetailType = 1
)

// DomainEventCrashedDetailType as declared in libvirt/libvirt-domain.h:3219
type DomainEventCrashedDetailType int32

// DomainEventCrashedDetailType enumeration from libvirt/libvirt-domain.h:3219
const (
	DomainEventCrashedPanicked    DomainEventCrashedDetailType = iota
	DomainEventCrashedCrashloaded DomainEventCrashedDetailType = 1
)

// DomainMemoryFailureRecipientType as declared in libvirt/libvirt-domain.h:3236
type DomainMemoryFailureRecipientType int32

// DomainMemoryFailureRecipientType enumeration from libvirt/libvirt-domain.h:3236
const (
	DomainEventMemoryFailureRecipientHypervisor DomainMemoryFailureRecipientType = iota
	DomainEventMemoryFailureRecipientGuest      DomainMemoryFailureRecipientType = 1
)

// DomainMemoryFailureActionType as declared in libvirt/libvirt-domain.h:3265
type DomainMemoryFailureActionType int32

// DomainMemoryFailureActionType enumeration from libvirt/libvirt-domain.h:3265
const (
	DomainEventMemoryFailureActionIgnore DomainMemoryFailureActionType = iota
	DomainEventMemoryFailureActionInject DomainMemoryFailureActionType = 1
	DomainEventMemoryFailureActionFatal  DomainMemoryFailureActionType = 2
	DomainEventMemoryFailureActionReset  DomainMemoryFailureActionType = 3
)

// DomainMemoryFailureFlags as declared in libvirt/libvirt-domain.h:3276
type DomainMemoryFailureFlags int32

// DomainMemoryFailureFlags enumeration from libvirt/libvirt-domain.h:3276
const (
	DomainMemoryFailureActionRequired DomainMemoryFailureFlags = 1
	DomainMemoryFailureRecursive      DomainMemoryFailureFlags = 2
)

// DomainJobType as declared in libvirt/libvirt-domain.h:3321
type DomainJobType int32

// DomainJobType enumeration from libvirt/libvirt-domain.h:3321
const (
	DomainJobNone      DomainJobType = iota
	DomainJobBounded   DomainJobType = 1
	DomainJobUnbounded DomainJobType = 2
	DomainJobCompleted DomainJobType = 3
	DomainJobFailed    DomainJobType = 4
	DomainJobCancelled DomainJobType = 5
)

// DomainGetJobStatsFlags as declared in libvirt/libvirt-domain.h:3370
type DomainGetJobStatsFlags int32

// DomainGetJobStatsFlags enumeration from libvirt/libvirt-domain.h:3370
const (
	DomainJobStatsCompleted     DomainGetJobStatsFlags = 1
	DomainJobStatsKeepCompleted DomainGetJobStatsFlags = 2
)

// DomainJobOperation as declared in libvirt/libvirt-domain.h:3396
type DomainJobOperation int32

// DomainJobOperation enumeration from libvirt/libvirt-domain.h:3396
const (
	DomainJobOperationStrUnknown        DomainJobOperation = iota
	DomainJobOperationStrStart          DomainJobOperation = 1
	DomainJobOperationStrSave           DomainJobOperation = 2
	DomainJobOperationStrRestore        DomainJobOperation = 3
	DomainJobOperationStrMigrationIn    DomainJobOperation = 4
	DomainJobOperationStrMigrationOut   DomainJobOperation = 5
	DomainJobOperationStrSnapshot       DomainJobOperation = 6
	DomainJobOperationStrSnapshotRevert DomainJobOperation = 7
	DomainJobOperationStrDump           DomainJobOperation = 8
	DomainJobOperationStrBackup         DomainJobOperation = 9
)

// DomainEventWatchdogAction as declared in libvirt/libvirt-domain.h:3780
type DomainEventWatchdogAction int32

// DomainEventWatchdogAction enumeration from libvirt/libvirt-domain.h:3780
const (
	DomainEventWatchdogNone      DomainEventWatchdogAction = iota
	DomainEventWatchdogPause     DomainEventWatchdogAction = 1
	DomainEventWatchdogReset     DomainEventWatchdogAction = 2
	DomainEventWatchdogPoweroff  DomainEventWatchdogAction = 3
	DomainEventWatchdogShutdown  DomainEventWatchdogAction = 4
	DomainEventWatchdogDebug     DomainEventWatchdogAction = 5
	DomainEventWatchdogInjectnmi DomainEventWatchdogAction = 6
)

// DomainEventIOErrorAction as declared in libvirt/libvirt-domain.h:3811
type DomainEventIOErrorAction int32

// DomainEventIOErrorAction enumeration from libvirt/libvirt-domain.h:3811
const (
	DomainEventIoErrorNone   DomainEventIOErrorAction = iota
	DomainEventIoErrorPause  DomainEventIOErrorAction = 1
	DomainEventIoErrorReport DomainEventIOErrorAction = 2
)

// DomainEventGraphicsPhase as declared in libvirt/libvirt-domain.h:3874
type DomainEventGraphicsPhase int32

// DomainEventGraphicsPhase enumeration from libvirt/libvirt-domain.h:3874
const (
	DomainEventGraphicsConnect    DomainEventGraphicsPhase = iota
	DomainEventGraphicsInitialize DomainEventGraphicsPhase = 1
	DomainEventGraphicsDisconnect DomainEventGraphicsPhase = 2
)

// DomainEventGraphicsAddressType as declared in libvirt/libvirt-domain.h:3889
type DomainEventGraphicsAddressType int32

// DomainEventGraphicsAddressType enumeration from libvirt/libvirt-domain.h:3889
const (
	DomainEventGraphicsAddressIpv4 DomainEventGraphicsAddressType = iota
	DomainEventGraphicsAddressIpv6 DomainEventGraphicsAddressType = 1
	DomainEventGraphicsAddressUnix DomainEventGraphicsAddressType = 2
)

// ConnectDomainEventBlockJobStatus as declared in libvirt/libvirt-domain.h:3977
type ConnectDomainEventBlockJobStatus int32

// ConnectDomainEventBlockJobStatus enumeration from libvirt/libvirt-domain.h:3977
const (
	DomainBlockJobCompleted ConnectDomainEventBlockJobStatus = iota
	DomainBlockJobFailed    ConnectDomainEventBlockJobStatus = 1
	DomainBlockJobCanceled  ConnectDomainEventBlockJobStatus = 2
	DomainBlockJobReady     ConnectDomainEventBlockJobStatus = 3
)

// ConnectDomainEventDiskChangeReason as declared in libvirt/libvirt-domain.h:4027
type ConnectDomainEventDiskChangeReason int32

// ConnectDomainEventDiskChangeReason enumeration from libvirt/libvirt-domain.h:4027
const (
	DomainEventDiskChangeMissingOnStart ConnectDomainEventDiskChangeReason = iota
	DomainEventDiskDropMissingOnStart   ConnectDomainEventDiskChangeReason = 1
)

// DomainEventTrayChangeReason as declared in libvirt/libvirt-domain.h:4068
type DomainEventTrayChangeReason int32

// DomainEventTrayChangeReason enumeration from libvirt/libvirt-domain.h:4068
const (
	DomainEventTrayChangeOpen  DomainEventTrayChangeReason = iota
	DomainEventTrayChangeClose DomainEventTrayChangeReason = 1
)

// ConnectDomainEventAgentLifecycleState as declared in libvirt/libvirt-domain.h:4585
type ConnectDomainEventAgentLifecycleState int32

// ConnectDomainEventAgentLifecycleState enumeration from libvirt/libvirt-domain.h:4585
const (
	ConnectDomainEventAgentLifecycleStateConnected    ConnectDomainEventAgentLifecycleState = 1
	ConnectDomainEventAgentLifecycleStateDisconnected ConnectDomainEventAgentLifecycleState = 2
)

// ConnectDomainEventAgentLifecycleReason as declared in libvirt/libvirt-domain.h:4595
type ConnectDomainEventAgentLifecycleReason int32

// ConnectDomainEventAgentLifecycleReason enumeration from libvirt/libvirt-domain.h:4595
const (
	ConnectDomainEventAgentLifecycleReasonUnknown       ConnectDomainEventAgentLifecycleReason = iota
	ConnectDomainEventAgentLifecycleReasonDomainStarted ConnectDomainEventAgentLifecycleReason = 1
	ConnectDomainEventAgentLifecycleReasonChannel       ConnectDomainEventAgentLifecycleReason = 2
)

// DomainEventID as declared in libvirt/libvirt-domain.h:4749
type DomainEventID int32

// DomainEventID enumeration from libvirt/libvirt-domain.h:4749
const (
	DomainEventIDLifecycle              DomainEventID = iota
	DomainEventIDReboot                 DomainEventID = 1
	DomainEventIDRtcChange              DomainEventID = 2
	DomainEventIDWatchdog               DomainEventID = 3
	DomainEventIDIoError                DomainEventID = 4
	DomainEventIDGraphics               DomainEventID = 5
	DomainEventIDIoErrorReason          DomainEventID = 6
	DomainEventIDControlError           DomainEventID = 7
	DomainEventIDBlockJob               DomainEventID = 8
	DomainEventIDDiskChange             DomainEventID = 9
	DomainEventIDTrayChange             DomainEventID = 10
	DomainEventIDPmwakeup               DomainEventID = 11
	DomainEventIDPmsuspend              DomainEventID = 12
	DomainEventIDBalloonChange          DomainEventID = 13
	DomainEventIDPmsuspendDisk          DomainEventID = 14
	DomainEventIDDeviceRemoved          DomainEventID = 15
	DomainEventIDBlockJob2              DomainEventID = 16
	DomainEventIDTunable                DomainEventID = 17
	DomainEventIDAgentLifecycle         DomainEventID = 18
	DomainEventIDDeviceAdded            DomainEventID = 19
	DomainEventIDMigrationIteration     DomainEventID = 20
	DomainEventIDJobCompleted           DomainEventID = 21
	DomainEventIDDeviceRemovalFailed    DomainEventID = 22
	DomainEventIDMetadataChange         DomainEventID = 23
	DomainEventIDBlockThreshold         DomainEventID = 24
	DomainEventIDMemoryFailure          DomainEventID = 25
	DomainEventIDMemoryDeviceSizeChange DomainEventID = 26
)

// DomainConsoleFlags as declared in libvirt/libvirt-domain.h:4776
type DomainConsoleFlags int32

// DomainConsoleFlags enumeration from libvirt/libvirt-domain.h:4776
const (
	DomainConsoleForce DomainConsoleFlags = 1
	DomainConsoleSafe  DomainConsoleFlags = 2
)

// DomainChannelFlags as declared in libvirt/libvirt-domain.h:4792
type DomainChannelFlags int32

// DomainChannelFlags enumeration from libvirt/libvirt-domain.h:4792
const (
	DomainChannelForce DomainChannelFlags = 1
)

// DomainOpenGraphicsFlags as declared in libvirt/libvirt-domain.h:4801
type DomainOpenGraphicsFlags int32

// DomainOpenGraphicsFlags enumeration from libvirt/libvirt-domain.h:4801
const (
	DomainOpenGraphicsSkipauth DomainOpenGraphicsFlags = 1
)

// DomainSetTimeFlags as declared in libvirt/libvirt-domain.h:4858
type DomainSetTimeFlags int32

// DomainSetTimeFlags enumeration from libvirt/libvirt-domain.h:4858
const (
	DomainTimeSync DomainSetTimeFlags = 1
)

// SchedParameterType as declared in libvirt/libvirt-domain.h:4879
type SchedParameterType int32

// SchedParameterType enumeration from libvirt/libvirt-domain.h:4879
const (
	DomainSchedFieldInt     SchedParameterType = 1
	DomainSchedFieldUint    SchedParameterType = 2
	DomainSchedFieldLlong   SchedParameterType = 3
	DomainSchedFieldUllong  SchedParameterType = 4
	DomainSchedFieldDouble  SchedParameterType = 5
	DomainSchedFieldBoolean SchedParameterType = 6
)

// BlkioParameterType as declared in libvirt/libvirt-domain.h:4923
type BlkioParameterType int32

// BlkioParameterType enumeration from libvirt/libvirt-domain.h:4923
const (
	DomainBlkioParamInt     BlkioParameterType = 1
	DomainBlkioParamUint    BlkioParameterType = 2
	DomainBlkioParamLlong   BlkioParameterType = 3
	DomainBlkioParamUllong  BlkioParameterType = 4
	DomainBlkioParamDouble  BlkioParameterType = 5
	DomainBlkioParamBoolean BlkioParameterType = 6
)

// MemoryParameterType as declared in libvirt/libvirt-domain.h:4967
type MemoryParameterType int32

// MemoryParameterType enumeration from libvirt/libvirt-domain.h:4967
const (
	DomainMemoryParamInt     MemoryParameterType = 1
	DomainMemoryParamUint    MemoryParameterType = 2
	DomainMemoryParamLlong   MemoryParameterType = 3
	DomainMemoryParamUllong  MemoryParameterType = 4
	DomainMemoryParamDouble  MemoryParameterType = 5
	DomainMemoryParamBoolean MemoryParameterType = 6
)

// DomainInterfaceAddressesSource as declared in libvirt/libvirt-domain.h:5005
type DomainInterfaceAddressesSource int32

// DomainInterfaceAddressesSource enumeration from libvirt/libvirt-domain.h:5005
const (
	DomainInterfaceAddressesSrcLease DomainInterfaceAddressesSource = iota
	DomainInterfaceAddressesSrcAgent DomainInterfaceAddressesSource = 1
	DomainInterfaceAddressesSrcArp   DomainInterfaceAddressesSource = 2
)

// DomainSetUserPasswordFlags as declared in libvirt/libvirt-domain.h:5033
type DomainSetUserPasswordFlags int32

// DomainSetUserPasswordFlags enumeration from libvirt/libvirt-domain.h:5033
const (
	DomainPasswordEncrypted DomainSetUserPasswordFlags = 1
)

// DomainLifecycle as declared in libvirt/libvirt-domain.h:5072
type DomainLifecycle int32

// DomainLifecycle enumeration from libvirt/libvirt-domain.h:5072
const (
	DomainLifecyclePoweroff DomainLifecycle = iota
	DomainLifecycleReboot   DomainLifecycle = 1
	DomainLifecycleCrash    DomainLifecycle = 2
)

// DomainLifecycleAction as declared in libvirt/libvirt-domain.h:5085
type DomainLifecycleAction int32

// DomainLifecycleAction enumeration from libvirt/libvirt-domain.h:5085
const (
	DomainLifecycleActionDestroy         DomainLifecycleAction = iota
	DomainLifecycleActionRestart         DomainLifecycleAction = 1
	DomainLifecycleActionRestartRename   DomainLifecycleAction = 2
	DomainLifecycleActionPreserve        DomainLifecycleAction = 3
	DomainLifecycleActionCoredumpDestroy DomainLifecycleAction = 4
	DomainLifecycleActionCoredumpRestart DomainLifecycleAction = 5
)

// DomainGuestInfoTypes as declared in libvirt/libvirt-domain.h:5185
type DomainGuestInfoTypes int32

// DomainGuestInfoTypes enumeration from libvirt/libvirt-domain.h:5185
const (
	DomainGuestInfoUsers      DomainGuestInfoTypes = 1
	DomainGuestInfoOs         DomainGuestInfoTypes = 2
	DomainGuestInfoTimezone   DomainGuestInfoTypes = 4
	DomainGuestInfoHostname   DomainGuestInfoTypes = 8
	DomainGuestInfoFilesystem DomainGuestInfoTypes = 16
	DomainGuestInfoDisks      DomainGuestInfoTypes = 32
	DomainGuestInfoInterfaces DomainGuestInfoTypes = 64
)

// DomainAgentResponseTimeoutValues as declared in libvirt/libvirt-domain.h:5197
type DomainAgentResponseTimeoutValues int32

// DomainAgentResponseTimeoutValues enumeration from libvirt/libvirt-domain.h:5197
const (
	DomainAgentResponseTimeoutBlock   DomainAgentResponseTimeoutValues = -2
	DomainAgentResponseTimeoutDefault DomainAgentResponseTimeoutValues = -1
	DomainAgentResponseTimeoutNowait  DomainAgentResponseTimeoutValues = 0
)

// DomainBackupBeginFlags as declared in libvirt/libvirt-domain.h:5206
type DomainBackupBeginFlags int32

// DomainBackupBeginFlags enumeration from libvirt/libvirt-domain.h:5206
const (
	DomainBackupBeginReuseExternal DomainBackupBeginFlags = 1
)

// DomainAuthorizedSSHKeysSetFlags as declared in libvirt/libvirt-domain.h:5225
type DomainAuthorizedSSHKeysSetFlags int32

// DomainAuthorizedSSHKeysSetFlags enumeration from libvirt/libvirt-domain.h:5225
const (
	DomainAuthorizedSSHKeysSetAppend DomainAuthorizedSSHKeysSetFlags = 1
	DomainAuthorizedSSHKeysSetRemove DomainAuthorizedSSHKeysSetFlags = 2
)

// DomainMessageType as declared in libvirt/libvirt-domain.h:5236
type DomainMessageType int32

// DomainMessageType enumeration from libvirt/libvirt-domain.h:5236
const (
	DomainMessageDeprecation DomainMessageType = 1
	DomainMessageTainting    DomainMessageType = 2
)

// DomainDirtyRateStatus as declared in libvirt/libvirt-domain.h:5258
type DomainDirtyRateStatus int32

// DomainDirtyRateStatus enumeration from libvirt/libvirt-domain.h:5258
const (
	DomainDirtyrateUnstarted DomainDirtyRateStatus = iota
	DomainDirtyrateMeasuring DomainDirtyRateStatus = 1
	DomainDirtyrateMeasured  DomainDirtyRateStatus = 2
)

// EventHandleType as declared in libvirt/libvirt-event.h:43
type EventHandleType int32

// EventHandleType enumeration from libvirt/libvirt-event.h:43
const (
	EventHandleReadable EventHandleType = 1
	EventHandleWritable EventHandleType = 2
	EventHandleError    EventHandleType = 4
	EventHandleHangup   EventHandleType = 8
)

// NodeSuspendTarget as declared in libvirt/libvirt-host.h:61
type NodeSuspendTarget int32

// NodeSuspendTarget enumeration from libvirt/libvirt-host.h:61
const (
	NodeSuspendTargetMem    NodeSuspendTarget = iota
	NodeSuspendTargetDisk   NodeSuspendTarget = 1
	NodeSuspendTargetHybrid NodeSuspendTarget = 2
)

// NodeGetCPUStatsAllCPUs as declared in libvirt/libvirt-host.h:189
type NodeGetCPUStatsAllCPUs int32

// NodeGetCPUStatsAllCPUs enumeration from libvirt/libvirt-host.h:189
const (
	NodeCPUStatsAllCpus NodeGetCPUStatsAllCPUs = -1
)

// NodeGetMemoryStatsAllCells as declared in libvirt/libvirt-host.h:267
type NodeGetMemoryStatsAllCells int32

// NodeGetMemoryStatsAllCells enumeration from libvirt/libvirt-host.h:267
const (
	NodeMemoryStatsAllCells NodeGetMemoryStatsAllCells = -1
)

// ConnectFlags as declared in libvirt/libvirt-host.h:504
type ConnectFlags int32

// ConnectFlags enumeration from libvirt/libvirt-host.h:504
const (
	ConnectRo        ConnectFlags = 1
	ConnectNoAliases ConnectFlags = 2
)

// ConnectCredentialType as declared in libvirt/libvirt-host.h:521
type ConnectCredentialType int32

// ConnectCredentialType enumeration from libvirt/libvirt-host.h:521
const (
	CredUsername     ConnectCredentialType = 1
	CredAuthname     ConnectCredentialType = 2
	CredLanguage     ConnectCredentialType = 3
	CredCnonce       ConnectCredentialType = 4
	CredPassphrase   ConnectCredentialType = 5
	CredEchoprompt   ConnectCredentialType = 6
	CredNoechoprompt ConnectCredentialType = 7
	CredRealm        ConnectCredentialType = 8
	CredExternal     ConnectCredentialType = 9
)

// CPUCompareResult as declared in libvirt/libvirt-host.h:768
type CPUCompareResult int32

// CPUCompareResult enumeration from libvirt/libvirt-host.h:768
const (
	CPUCompareError        CPUCompareResult = -1
	CPUCompareIncompatible CPUCompareResult = 0
	CPUCompareIdentical    CPUCompareResult = 1
	CPUCompareSuperset     CPUCompareResult = 2
)

// ConnectCompareCPUFlags as declared in libvirt/libvirt-host.h:775
type ConnectCompareCPUFlags int32

// ConnectCompareCPUFlags enumeration from libvirt/libvirt-host.h:775
const (
	ConnectCompareCPUFailIncompatible ConnectCompareCPUFlags = 1
	ConnectCompareCPUValidateXML      ConnectCompareCPUFlags = 2
)

// ConnectBaselineCPUFlags as declared in libvirt/libvirt-host.h:801
type ConnectBaselineCPUFlags int32

// ConnectBaselineCPUFlags enumeration from libvirt/libvirt-host.h:801
const (
	ConnectBaselineCPUExpandFeatures ConnectBaselineCPUFlags = 1
	ConnectBaselineCPUMigratable     ConnectBaselineCPUFlags = 2
)

// NodeAllocPagesFlags as declared in libvirt/libvirt-host.h:831
type NodeAllocPagesFlags int32

// NodeAllocPagesFlags enumeration from libvirt/libvirt-host.h:831
const (
	NodeAllocPagesAdd NodeAllocPagesFlags = iota
	NodeAllocPagesSet NodeAllocPagesFlags = 1
)

// ConnectListAllInterfacesFlags as declared in libvirt/libvirt-interface.h:64
type ConnectListAllInterfacesFlags int32

// ConnectListAllInterfacesFlags enumeration from libvirt/libvirt-interface.h:64
const (
	ConnectListInterfacesInactive ConnectListAllInterfacesFlags = 1
	ConnectListInterfacesActive   ConnectListAllInterfacesFlags = 2
)

// InterfaceXMLFlags as declared in libvirt/libvirt-interface.h:80
type InterfaceXMLFlags int32

// InterfaceXMLFlags enumeration from libvirt/libvirt-interface.h:80
const (
	InterfaceXMLInactive InterfaceXMLFlags = 1
)

// InterfaceDefineFlags as declared in libvirt/libvirt-interface.h:84
type InterfaceDefineFlags int32

// InterfaceDefineFlags enumeration from libvirt/libvirt-interface.h:84
const (
	InterfaceDefineValidate InterfaceDefineFlags = 1
)

// NetworkXMLFlags as declared in libvirt/libvirt-network.h:32
type NetworkXMLFlags int32

// NetworkXMLFlags enumeration from libvirt/libvirt-network.h:32
const (
	NetworkXMLInactive NetworkXMLFlags = 1
)

// ConnectListAllNetworksFlags as declared in libvirt/libvirt-network.h:100
type ConnectListAllNetworksFlags int32

// ConnectListAllNetworksFlags enumeration from libvirt/libvirt-network.h:100
const (
	ConnectListNetworksInactive    ConnectListAllNetworksFlags = 1
	ConnectListNetworksActive      ConnectListAllNetworksFlags = 2
	ConnectListNetworksPersistent  ConnectListAllNetworksFlags = 4
	ConnectListNetworksTransient   ConnectListAllNetworksFlags = 8
	ConnectListNetworksAutostart   ConnectListAllNetworksFlags = 16
	ConnectListNetworksNoAutostart ConnectListAllNetworksFlags = 32
)

// NetworkCreateFlags as declared in libvirt/libvirt-network.h:118
type NetworkCreateFlags int32

// NetworkCreateFlags enumeration from libvirt/libvirt-network.h:118
const (
	NetworkCreateValidate NetworkCreateFlags = 1
)

// NetworkDefineFlags as declared in libvirt/libvirt-network.h:131
type NetworkDefineFlags int32

// NetworkDefineFlags enumeration from libvirt/libvirt-network.h:131
const (
	NetworkDefineValidate NetworkDefineFlags = 1
)

// NetworkUpdateCommand as declared in libvirt/libvirt-network.h:163
type NetworkUpdateCommand int32

// NetworkUpdateCommand enumeration from libvirt/libvirt-network.h:163
const (
	NetworkUpdateCommandNone     NetworkUpdateCommand = iota
	NetworkUpdateCommandModify   NetworkUpdateCommand = 1
	NetworkUpdateCommandDelete   NetworkUpdateCommand = 2
	NetworkUpdateCommandAddLast  NetworkUpdateCommand = 3
	NetworkUpdateCommandAddFirst NetworkUpdateCommand = 4
)

// NetworkUpdateSection as declared in libvirt/libvirt-network.h:189
type NetworkUpdateSection int32

// NetworkUpdateSection enumeration from libvirt/libvirt-network.h:189
const (
	NetworkSectionNone             NetworkUpdateSection = iota
	NetworkSectionBridge           NetworkUpdateSection = 1
	NetworkSectionDomain           NetworkUpdateSection = 2
	NetworkSectionIP               NetworkUpdateSection = 3
	NetworkSectionIPDhcpHost       NetworkUpdateSection = 4
	NetworkSectionIPDhcpRange      NetworkUpdateSection = 5
	NetworkSectionForward          NetworkUpdateSection = 6
	NetworkSectionForwardInterface NetworkUpdateSection = 7
	NetworkSectionForwardPf        NetworkUpdateSection = 8
	NetworkSectionPortgroup        NetworkUpdateSection = 9
	NetworkSectionDNSHost          NetworkUpdateSection = 10
	NetworkSectionDNSTxt           NetworkUpdateSection = 11
	NetworkSectionDNSSrv           NetworkUpdateSection = 12
)

// NetworkUpdateFlags as declared in libvirt/libvirt-network.h:201
type NetworkUpdateFlags int32

// NetworkUpdateFlags enumeration from libvirt/libvirt-network.h:201
const (
	NetworkUpdateAffectCurrent NetworkUpdateFlags = iota
	NetworkUpdateAffectLive    NetworkUpdateFlags = 1
	NetworkUpdateAffectConfig  NetworkUpdateFlags = 2
)

// NetworkEventLifecycleType as declared in libvirt/libvirt-network.h:259
type NetworkEventLifecycleType int32

// NetworkEventLifecycleType enumeration from libvirt/libvirt-network.h:259
const (
	NetworkEventDefined   NetworkEventLifecycleType = iota
	NetworkEventUndefined NetworkEventLifecycleType = 1
	NetworkEventStarted   NetworkEventLifecycleType = 2
	NetworkEventStopped   NetworkEventLifecycleType = 3
)

// NetworkEventID as declared in libvirt/libvirt-network.h:307
type NetworkEventID int32

// NetworkEventID enumeration from libvirt/libvirt-network.h:307
const (
	NetworkEventIDLifecycle NetworkEventID = iota
)

// IPAddrType as declared in libvirt/libvirt-network.h:316
type IPAddrType int32

// IPAddrType enumeration from libvirt/libvirt-network.h:316
const (
	IPAddrTypeIpv4 IPAddrType = iota
	IPAddrTypeIpv6 IPAddrType = 1
)

// NetworkPortCreateFlags as declared in libvirt/libvirt-network.h:378
type NetworkPortCreateFlags int32

// NetworkPortCreateFlags enumeration from libvirt/libvirt-network.h:378
const (
	NetworkPortCreateReclaim  NetworkPortCreateFlags = 1
	NetworkPortCreateValidate NetworkPortCreateFlags = 2
)

// ConnectListAllNodeDeviceFlags as declared in libvirt/libvirt-nodedev.h:92
type ConnectListAllNodeDeviceFlags uint32

// ConnectListAllNodeDeviceFlags enumeration from libvirt/libvirt-nodedev.h:92
const (
	ConnectListNodeDevicesCapSystem       ConnectListAllNodeDeviceFlags = 1
	ConnectListNodeDevicesCapPciDev       ConnectListAllNodeDeviceFlags = 2
	ConnectListNodeDevicesCapUsbDev       ConnectListAllNodeDeviceFlags = 4
	ConnectListNodeDevicesCapUsbInterface ConnectListAllNodeDeviceFlags = 8
	ConnectListNodeDevicesCapNet          ConnectListAllNodeDeviceFlags = 16
	ConnectListNodeDevicesCapScsiHost     ConnectListAllNodeDeviceFlags = 32
	ConnectListNodeDevicesCapScsiTarget   ConnectListAllNodeDeviceFlags = 64
	ConnectListNodeDevicesCapScsi         ConnectListAllNodeDeviceFlags = 128
	ConnectListNodeDevicesCapStorage      ConnectListAllNodeDeviceFlags = 256
	ConnectListNodeDevicesCapFcHost       ConnectListAllNodeDeviceFlags = 512
	ConnectListNodeDevicesCapVports       ConnectListAllNodeDeviceFlags = 1024
	ConnectListNodeDevicesCapScsiGeneric  ConnectListAllNodeDeviceFlags = 2048
	ConnectListNodeDevicesCapDrm          ConnectListAllNodeDeviceFlags = 4096
	ConnectListNodeDevicesCapMdevTypes    ConnectListAllNodeDeviceFlags = 8192
	ConnectListNodeDevicesCapMdev         ConnectListAllNodeDeviceFlags = 16384
	ConnectListNodeDevicesCapCcwDev       ConnectListAllNodeDeviceFlags = 32768
	ConnectListNodeDevicesCapCssDev       ConnectListAllNodeDeviceFlags = 65536
	ConnectListNodeDevicesCapVdpa         ConnectListAllNodeDeviceFlags = 131072
	ConnectListNodeDevicesCapApCard       ConnectListAllNodeDeviceFlags = 262144
	ConnectListNodeDevicesCapApQueue      ConnectListAllNodeDeviceFlags = 524288
	ConnectListNodeDevicesCapApMatrix     ConnectListAllNodeDeviceFlags = 1048576
	ConnectListNodeDevicesCapVpd          ConnectListAllNodeDeviceFlags = 2097152
	ConnectListNodeDevicesInactive        ConnectListAllNodeDeviceFlags = 1073741824
	ConnectListNodeDevicesActive          ConnectListAllNodeDeviceFlags = 2147483648
)

// NodeDeviceEventID as declared in libvirt/libvirt-nodedev.h:182
type NodeDeviceEventID int32

// NodeDeviceEventID enumeration from libvirt/libvirt-nodedev.h:182
const (
	NodeDeviceEventIDLifecycle NodeDeviceEventID = iota
	NodeDeviceEventIDUpdate    NodeDeviceEventID = 1
)

// NodeDeviceEventLifecycleType as declared in libvirt/libvirt-nodedev.h:226
type NodeDeviceEventLifecycleType int32

// NodeDeviceEventLifecycleType enumeration from libvirt/libvirt-nodedev.h:226
const (
	NodeDeviceEventCreated   NodeDeviceEventLifecycleType = iota
	NodeDeviceEventDeleted   NodeDeviceEventLifecycleType = 1
	NodeDeviceEventDefined   NodeDeviceEventLifecycleType = 2
	NodeDeviceEventUndefined NodeDeviceEventLifecycleType = 3
)

// NWFilterDefineFlags as declared in libvirt/libvirt-nwfilter.h:85
type NWFilterDefineFlags int32

// NWFilterDefineFlags enumeration from libvirt/libvirt-nwfilter.h:85
const (
	NwfilterDefineValidate NWFilterDefineFlags = 1
)

// NWFilterBindingCreateFlags as declared in libvirt/libvirt-nwfilter.h:113
type NWFilterBindingCreateFlags int32

// NWFilterBindingCreateFlags enumeration from libvirt/libvirt-nwfilter.h:113
const (
	NwfilterBindingCreateValidate NWFilterBindingCreateFlags = 1
)

// SecretUsageType as declared in libvirt/libvirt-secret.h:56
type SecretUsageType int32

// SecretUsageType enumeration from libvirt/libvirt-secret.h:56
const (
	SecretUsageTypeNone   SecretUsageType = iota
	SecretUsageTypeVolume SecretUsageType = 1
	SecretUsageTypeCeph   SecretUsageType = 2
	SecretUsageTypeIscsi  SecretUsageType = 3
	SecretUsageTypeTLS    SecretUsageType = 4
	SecretUsageTypeVtpm   SecretUsageType = 5
)

// ConnectListAllSecretsFlags as declared in libvirt/libvirt-secret.h:79
type ConnectListAllSecretsFlags int32

// ConnectListAllSecretsFlags enumeration from libvirt/libvirt-secret.h:79
const (
	ConnectListSecretsEphemeral   ConnectListAllSecretsFlags = 1
	ConnectListSecretsNoEphemeral ConnectListAllSecretsFlags = 2
	ConnectListSecretsPrivate     ConnectListAllSecretsFlags = 4
	ConnectListSecretsNoPrivate   ConnectListAllSecretsFlags = 8
)

// SecretDefineFlags as declared in libvirt/libvirt-secret.h:94
type SecretDefineFlags int32

// SecretDefineFlags enumeration from libvirt/libvirt-secret.h:94
const (
	SecretDefineValidate SecretDefineFlags = 1
)

// SecretEventID as declared in libvirt/libvirt-secret.h:145
type SecretEventID int32

// SecretEventID enumeration from libvirt/libvirt-secret.h:145
const (
	SecretEventIDLifecycle    SecretEventID = iota
	SecretEventIDValueChanged SecretEventID = 1
)

// SecretEventLifecycleType as declared in libvirt/libvirt-secret.h:187
type SecretEventLifecycleType int32

// SecretEventLifecycleType enumeration from libvirt/libvirt-secret.h:187
const (
	SecretEventDefined   SecretEventLifecycleType = iota
	SecretEventUndefined SecretEventLifecycleType = 1
)

// StoragePoolState as declared in libvirt/libvirt-storage.h:57
type StoragePoolState int32

// StoragePoolState enumeration from libvirt/libvirt-storage.h:57
const (
	StoragePoolInactive     StoragePoolState = iota
	StoragePoolBuilding     StoragePoolState = 1
	StoragePoolRunning      StoragePoolState = 2
	StoragePoolDegraded     StoragePoolState = 3
	StoragePoolInaccessible StoragePoolState = 4
)

// StoragePoolBuildFlags as declared in libvirt/libvirt-storage.h:65
type StoragePoolBuildFlags int32

// StoragePoolBuildFlags enumeration from libvirt/libvirt-storage.h:65
const (
	StoragePoolBuildNew         StoragePoolBuildFlags = iota
	StoragePoolBuildRepair      StoragePoolBuildFlags = 1
	StoragePoolBuildResize      StoragePoolBuildFlags = 2
	StoragePoolBuildNoOverwrite StoragePoolBuildFlags = 4
	StoragePoolBuildOverwrite   StoragePoolBuildFlags = 8
)

// StoragePoolDeleteFlags as declared in libvirt/libvirt-storage.h:70
type StoragePoolDeleteFlags int32

// StoragePoolDeleteFlags enumeration from libvirt/libvirt-storage.h:70
const (
	StoragePoolDeleteNormal StoragePoolDeleteFlags = iota
	StoragePoolDeleteZeroed StoragePoolDeleteFlags = 1
)

// StoragePoolCreateFlags as declared in libvirt/libvirt-storage.h:88
type StoragePoolCreateFlags int32

// StoragePoolCreateFlags enumeration from libvirt/libvirt-storage.h:88
const (
	StoragePoolCreateNormal               StoragePoolCreateFlags = iota
	StoragePoolCreateWithBuild            StoragePoolCreateFlags = 1
	StoragePoolCreateWithBuildOverwrite   StoragePoolCreateFlags = 2
	StoragePoolCreateWithBuildNoOverwrite StoragePoolCreateFlags = 4
)

// StorageVolType as declared in libvirt/libvirt-storage.h:130
type StorageVolType int32

// StorageVolType enumeration from libvirt/libvirt-storage.h:130
const (
	StorageVolFile    StorageVolType = iota
	StorageVolBlock   StorageVolType = 1
	StorageVolDir     StorageVolType = 2
	StorageVolNetwork StorageVolType = 3
	StorageVolNetdir  StorageVolType = 4
	StorageVolPloop   StorageVolType = 5
)

// StorageVolDeleteFlags as declared in libvirt/libvirt-storage.h:136
type StorageVolDeleteFlags int32

// StorageVolDeleteFlags enumeration from libvirt/libvirt-storage.h:136
const (
	StorageVolDeleteNormal        StorageVolDeleteFlags = iota
	StorageVolDeleteZeroed        StorageVolDeleteFlags = 1
	StorageVolDeleteWithSnapshots StorageVolDeleteFlags = 2
)

// StorageVolWipeAlgorithm as declared in libvirt/libvirt-storage.h:168
type StorageVolWipeAlgorithm int32

// StorageVolWipeAlgorithm enumeration from libvirt/libvirt-storage.h:168
const (
	StorageVolWipeAlgZero       StorageVolWipeAlgorithm = iota
	StorageVolWipeAlgNnsa       StorageVolWipeAlgorithm = 1
	StorageVolWipeAlgDod        StorageVolWipeAlgorithm = 2
	StorageVolWipeAlgBsi        StorageVolWipeAlgorithm = 3
	StorageVolWipeAlgGutmann    StorageVolWipeAlgorithm = 4
	StorageVolWipeAlgSchneier   StorageVolWipeAlgorithm = 5
	StorageVolWipeAlgPfitzner7  StorageVolWipeAlgorithm = 6
	StorageVolWipeAlgPfitzner33 StorageVolWipeAlgorithm = 7
	StorageVolWipeAlgRandom     StorageVolWipeAlgorithm = 8
	StorageVolWipeAlgTrim       StorageVolWipeAlgorithm = 9
)

// StorageVolInfoFlags as declared in libvirt/libvirt-storage.h:176
type StorageVolInfoFlags int32

// StorageVolInfoFlags enumeration from libvirt/libvirt-storage.h:176
const (
	StorageVolUseAllocation StorageVolInfoFlags = iota
	StorageVolGetPhysical   StorageVolInfoFlags = 1
)

// StorageXMLFlags as declared in libvirt/libvirt-storage.h:190
type StorageXMLFlags int32

// StorageXMLFlags enumeration from libvirt/libvirt-storage.h:190
const (
	StorageXMLInactive StorageXMLFlags = 1
)

// ConnectListAllStoragePoolsFlags as declared in libvirt/libvirt-storage.h:249
type ConnectListAllStoragePoolsFlags int32

// ConnectListAllStoragePoolsFlags enumeration from libvirt/libvirt-storage.h:249
const (
	ConnectListStoragePoolsInactive    ConnectListAllStoragePoolsFlags = 1
	ConnectListStoragePoolsActive      ConnectListAllStoragePoolsFlags = 2
	ConnectListStoragePoolsPersistent  ConnectListAllStoragePoolsFlags = 4
	ConnectListStoragePoolsTransient   ConnectListAllStoragePoolsFlags = 8
	ConnectListStoragePoolsAutostart   ConnectListAllStoragePoolsFlags = 16
	ConnectListStoragePoolsNoAutostart ConnectListAllStoragePoolsFlags = 32
	ConnectListStoragePoolsDir         ConnectListAllStoragePoolsFlags = 64
	ConnectListStoragePoolsFs          ConnectListAllStoragePoolsFlags = 128
	ConnectListStoragePoolsNetfs       ConnectListAllStoragePoolsFlags = 256
	ConnectListStoragePoolsLogical     ConnectListAllStoragePoolsFlags = 512
	ConnectListStoragePoolsDisk        ConnectListAllStoragePoolsFlags = 1024
	ConnectListStoragePoolsIscsi       ConnectListAllStoragePoolsFlags = 2048
	ConnectListStoragePoolsScsi        ConnectListAllStoragePoolsFlags = 4096
	ConnectListStoragePoolsMpath       ConnectListAllStoragePoolsFlags = 8192
	ConnectListStoragePoolsRbd         ConnectListAllStoragePoolsFlags = 16384
	ConnectListStoragePoolsSheepdog    ConnectListAllStoragePoolsFlags = 32768
	ConnectListStoragePoolsGluster     ConnectListAllStoragePoolsFlags = 65536
	ConnectListStoragePoolsZfs         ConnectListAllStoragePoolsFlags = 131072
	ConnectListStoragePoolsVstorage    ConnectListAllStoragePoolsFlags = 262144
	ConnectListStoragePoolsIscsiDirect ConnectListAllStoragePoolsFlags = 524288
)

// StoragePoolDefineFlags as declared in libvirt/libvirt-storage.h:277
type StoragePoolDefineFlags int32

// StoragePoolDefineFlags enumeration from libvirt/libvirt-storage.h:277
const (
	StoragePoolDefineValidate StoragePoolDefineFlags = 1
)

// StorageVolCreateFlags as declared in libvirt/libvirt-storage.h:351
type StorageVolCreateFlags int32

// StorageVolCreateFlags enumeration from libvirt/libvirt-storage.h:351
const (
	StorageVolCreatePreallocMetadata StorageVolCreateFlags = 1
	StorageVolCreateReflink          StorageVolCreateFlags = 2
)

// StorageVolDownloadFlags as declared in libvirt/libvirt-storage.h:363
type StorageVolDownloadFlags int32

// StorageVolDownloadFlags enumeration from libvirt/libvirt-storage.h:363
const (
	StorageVolDownloadSparseStream StorageVolDownloadFlags = 1
)

// StorageVolUploadFlags as declared in libvirt/libvirt-storage.h:372
type StorageVolUploadFlags int32

// StorageVolUploadFlags enumeration from libvirt/libvirt-storage.h:372
const (
	StorageVolUploadSparseStream StorageVolUploadFlags = 1
)

// StorageVolResizeFlags as declared in libvirt/libvirt-storage.h:403
type StorageVolResizeFlags int32

// StorageVolResizeFlags enumeration from libvirt/libvirt-storage.h:403
const (
	StorageVolResizeAllocate StorageVolResizeFlags = 1
	StorageVolResizeDelta    StorageVolResizeFlags = 2
	StorageVolResizeShrink   StorageVolResizeFlags = 4
)

// StoragePoolEventID as declared in libvirt/libvirt-storage.h:439
type StoragePoolEventID int32

// StoragePoolEventID enumeration from libvirt/libvirt-storage.h:439
const (
	StoragePoolEventIDLifecycle StoragePoolEventID = iota
	StoragePoolEventIDRefresh   StoragePoolEventID = 1
)

// StoragePoolEventLifecycleType as declared in libvirt/libvirt-storage.h:485
type StoragePoolEventLifecycleType int32

// StoragePoolEventLifecycleType enumeration from libvirt/libvirt-storage.h:485
const (
	StoragePoolEventDefined   StoragePoolEventLifecycleType = iota
	StoragePoolEventUndefined StoragePoolEventLifecycleType = 1
	StoragePoolEventStarted   StoragePoolEventLifecycleType = 2
	StoragePoolEventStopped   StoragePoolEventLifecycleType = 3
	StoragePoolEventCreated   StoragePoolEventLifecycleType = 4
	StoragePoolEventDeleted   StoragePoolEventLifecycleType = 5
)

// StreamFlags as declared in libvirt/libvirt-stream.h:33
type StreamFlags int32

// StreamFlags enumeration from libvirt/libvirt-stream.h:33
const (
	StreamNonblock StreamFlags = 1
)

// StreamRecvFlagsValues as declared in libvirt/libvirt-stream.h:49
type StreamRecvFlagsValues int32

// StreamRecvFlagsValues enumeration from libvirt/libvirt-stream.h:49
const (
	StreamRecvStopAtHole StreamRecvFlagsValues = 1
)

// StreamEventType as declared in libvirt/libvirt-stream.h:237
type StreamEventType int32

// StreamEventType enumeration from libvirt/libvirt-stream.h:237
const (
	StreamEventReadable StreamEventType = 1
	StreamEventWritable StreamEventType = 2
	StreamEventError    StreamEventType = 4
	StreamEventHangup   StreamEventType = 8
)

// ErrorLevel as declared in libvirt/virterror.h:42
type ErrorLevel int32

// ErrorLevel enumeration from libvirt/virterror.h:42
const (
	ErrNone    ErrorLevel = iota
	ErrWarning ErrorLevel = 1
	ErrError   ErrorLevel = 2
)

// ErrorDomain as declared in libvirt/virterror.h:144
type ErrorDomain int32

// ErrorDomain enumeration from libvirt/virterror.h:144
const (
	fromNone             ErrorDomain = iota
	fromXen              ErrorDomain = 1
	fromXend             ErrorDomain = 2
	fromXenstore         ErrorDomain = 3
	fromSexpr            ErrorDomain = 4
	fromXML              ErrorDomain = 5
	fromDom              ErrorDomain = 6
	fromRPC              ErrorDomain = 7
	fromProxy            ErrorDomain = 8
	fromConf             ErrorDomain = 9
	fromQemu             ErrorDomain = 10
	fromNet              ErrorDomain = 11
	fromTest             ErrorDomain = 12
	fromRemote           ErrorDomain = 13
	fromOpenvz           ErrorDomain = 14
	fromXenxm            ErrorDomain = 15
	fromStatsLinux       ErrorDomain = 16
	fromLxc              ErrorDomain = 17
	fromStorage          ErrorDomain = 18
	fromNetwork          ErrorDomain = 19
	fromDomain           ErrorDomain = 20
	fromUml              ErrorDomain = 21
	fromNodedev          ErrorDomain = 22
	fromXenInotify       ErrorDomain = 23
	fromSecurity         ErrorDomain = 24
	fromVbox             ErrorDomain = 25
	fromInterface        ErrorDomain = 26
	fromOne              ErrorDomain = 27
	fromEsx              ErrorDomain = 28
	fromPhyp             ErrorDomain = 29
	fromSecret           ErrorDomain = 30
	fromCPU              ErrorDomain = 31
	fromXenapi           ErrorDomain = 32
	fromNwfilter         ErrorDomain = 33
	fromHook             ErrorDomain = 34
	fromDomainSnapshot   ErrorDomain = 35
	fromAudit            ErrorDomain = 36
	fromSysinfo          ErrorDomain = 37
	fromStreams          ErrorDomain = 38
	fromVmware           ErrorDomain = 39
	fromEvent            ErrorDomain = 40
	fromLibxl            ErrorDomain = 41
	fromLocking          ErrorDomain = 42
	fromHyperv           ErrorDomain = 43
	fromCapabilities     ErrorDomain = 44
	fromURI              ErrorDomain = 45
	fromAuth             ErrorDomain = 46
	fromDbus             ErrorDomain = 47
	fromParallels        ErrorDomain = 48
	fromDevice           ErrorDomain = 49
	fromSSH              ErrorDomain = 50
	fromLockspace        ErrorDomain = 51
	fromInitctl          ErrorDomain = 52
	fromIdentity         ErrorDomain = 53
	fromCgroup           ErrorDomain = 54
	fromAccess           ErrorDomain = 55
	fromSystemd          ErrorDomain = 56
	fromBhyve            ErrorDomain = 57
	fromCrypto           ErrorDomain = 58
	fromFirewall         ErrorDomain = 59
	fromPolkit           ErrorDomain = 60
	fromThread           ErrorDomain = 61
	fromAdmin            ErrorDomain = 62
	fromLogging          ErrorDomain = 63
	fromXenxl            ErrorDomain = 64
	fromPerf             ErrorDomain = 65
	fromLibssh           ErrorDomain = 66
	fromResctrl          ErrorDomain = 67
	fromFirewalld        ErrorDomain = 68
	fromDomainCheckpoint ErrorDomain = 69
	fromTpm              ErrorDomain = 70
	fromBpf              ErrorDomain = 71
	fromCh               ErrorDomain = 72
)

// ErrorNumber as declared in libvirt/virterror.h:342
type ErrorNumber int32

// ErrorNumber enumeration from libvirt/virterror.h:342
const (
	ErrOk                      ErrorNumber = iota
	ErrInternalError           ErrorNumber = 1
	ErrNoMemory                ErrorNumber = 2
	ErrNoSupport               ErrorNumber = 3
	ErrUnknownHost             ErrorNumber = 4
	ErrNoConnect               ErrorNumber = 5
	ErrInvalidConn             ErrorNumber = 6
	ErrInvalidDomain           ErrorNumber = 7
	ErrInvalidArg              ErrorNumber = 8
	ErrOperationFailed         ErrorNumber = 9
	ErrGetFailed               ErrorNumber = 10
	ErrPostFailed              ErrorNumber = 11
	ErrHTTPError               ErrorNumber = 12
	ErrSexprSerial             ErrorNumber = 13
	ErrNoXen                   ErrorNumber = 14
	ErrXenCall                 ErrorNumber = 15
	ErrOsType                  ErrorNumber = 16
	ErrNoKernel                ErrorNumber = 17
	ErrNoRoot                  ErrorNumber = 18
	ErrNoSource                ErrorNumber = 19
	ErrNoTarget                ErrorNumber = 20
	ErrNoName                  ErrorNumber = 21
	ErrNoOs                    ErrorNumber = 22
	ErrNoDevice                ErrorNumber = 23
	ErrNoXenstore              ErrorNumber = 24
	ErrDriverFull              ErrorNumber = 25
	ErrCallFailed              ErrorNumber = 26
	ErrXMLError                ErrorNumber = 27
	ErrDomExist                ErrorNumber = 28
	ErrOperationDenied         ErrorNumber = 29
	ErrOpenFailed              ErrorNumber = 30
	ErrReadFailed              ErrorNumber = 31
	ErrParseFailed             ErrorNumber = 32
	ErrConfSyntax              ErrorNumber = 33
	ErrWriteFailed             ErrorNumber = 34
	ErrXMLDetail               ErrorNumber = 35
	ErrInvalidNetwork          ErrorNumber = 36
	ErrNetworkExist            ErrorNumber = 37
	ErrSystemError             ErrorNumber = 38
	ErrRPC                     ErrorNumber = 39
	ErrGnutlsError             ErrorNumber = 40
	WarNoNetwork               ErrorNumber = 41
	ErrNoDomain                ErrorNumber = 42
	ErrNoNetwork               ErrorNumber = 43
	ErrInvalidMac              ErrorNumber = 44
	ErrAuthFailed              ErrorNumber = 45
	ErrInvalidStoragePool      ErrorNumber = 46
	ErrInvalidStorageVol       ErrorNumber = 47
	WarNoStorage               ErrorNumber = 48
	ErrNoStoragePool           ErrorNumber = 49
	ErrNoStorageVol            ErrorNumber = 50
	WarNoNode                  ErrorNumber = 51
	ErrInvalidNodeDevice       ErrorNumber = 52
	ErrNoNodeDevice            ErrorNumber = 53
	ErrNoSecurityModel         ErrorNumber = 54
	ErrOperationInvalid        ErrorNumber = 55
	WarNoInterface             ErrorNumber = 56
	ErrNoInterface             ErrorNumber = 57
	ErrInvalidInterface        ErrorNumber = 58
	ErrMultipleInterfaces      ErrorNumber = 59
	WarNoNwfilter              ErrorNumber = 60
	ErrInvalidNwfilter         ErrorNumber = 61
	ErrNoNwfilter              ErrorNumber = 62
	ErrBuildFirewall           ErrorNumber = 63
	WarNoSecret                ErrorNumber = 64
	ErrInvalidSecret           ErrorNumber = 65
	ErrNoSecret                ErrorNumber = 66
	ErrConfigUnsupported       ErrorNumber = 67
	ErrOperationTimeout        ErrorNumber = 68
	ErrMigratePersistFailed    ErrorNumber = 69
	ErrHookScriptFailed        ErrorNumber = 70
	ErrInvalidDomainSnapshot   ErrorNumber = 71
	ErrNoDomainSnapshot        ErrorNumber = 72
	ErrInvalidStream           ErrorNumber = 73
	ErrArgumentUnsupported     ErrorNumber = 74
	ErrStorageProbeFailed      ErrorNumber = 75
	ErrStoragePoolBuilt        ErrorNumber = 76
	ErrSnapshotRevertRisky     ErrorNumber = 77
	ErrOperationAborted        ErrorNumber = 78
	ErrAuthCancelled           ErrorNumber = 79
	ErrNoDomainMetadata        ErrorNumber = 80
	ErrMigrateUnsafe           ErrorNumber = 81
	ErrOverflow                ErrorNumber = 82
	ErrBlockCopyActive         ErrorNumber = 83
	ErrOperationUnsupported    ErrorNumber = 84
	ErrSSH                     ErrorNumber = 85
	ErrAgentUnresponsive       ErrorNumber = 86
	ErrResourceBusy            ErrorNumber = 87
	ErrAccessDenied            ErrorNumber = 88
	ErrDbusService             ErrorNumber = 89
	ErrStorageVolExist         ErrorNumber = 90
	ErrCPUIncompatible         ErrorNumber = 91
	ErrXMLInvalidSchema        ErrorNumber = 92
	ErrMigrateFinishOk         ErrorNumber = 93
	ErrAuthUnavailable         ErrorNumber = 94
	ErrNoServer                ErrorNumber = 95
	ErrNoClient                ErrorNumber = 96
	ErrAgentUnsynced           ErrorNumber = 97
	ErrLibssh                  ErrorNumber = 98
	ErrDeviceMissing           ErrorNumber = 99
	ErrInvalidNwfilterBinding  ErrorNumber = 100
	ErrNoNwfilterBinding       ErrorNumber = 101
	ErrInvalidDomainCheckpoint ErrorNumber = 102
	ErrNoDomainCheckpoint      ErrorNumber = 103
	ErrNoDomainBackup          ErrorNumber = 104
	ErrInvalidNetworkPort      ErrorNumber = 105
	ErrNetworkPortExist        ErrorNumber = 106
	ErrNoNetworkPort           ErrorNumber = 107
	ErrNoHostname              ErrorNumber = 108
	ErrCheckpointInconsistent  ErrorNumber = 109
	ErrMultipleDomains         ErrorNumber = 110
)
