"use strict";
// Copyright 2021-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSchema = void 0;
const protobuf_1 = require("@bufbuild/protobuf");
const generated_file_js_1 = require("./generated-file.js");
const runtime_imports_js_1 = require("./runtime-imports.js");
const import_symbol_js_1 = require("./import-symbol.js");
const import_path_js_1 = require("./import-path.js");
const file_preamble_js_1 = require("./file-preamble.js");
function createSchema(request, parameter, pluginName, pluginVersion, featureSetDefaults) {
    const descriptorSet = (0, protobuf_1.createDescriptorSet)(request.protoFile, {
        featureSetDefaults,
    });
    const filesToGenerate = findFilesToGenerate(descriptorSet, request);
    const runtime = (0, runtime_imports_js_1.createRuntimeImports)(parameter.bootstrapWkt);
    const createTypeImport = (desc) => {
        const name = protobuf_1.codegenInfo.localName(desc);
        const from = (0, import_path_js_1.makeImportPath)(desc.file, parameter.bootstrapWkt, filesToGenerate);
        return (0, import_symbol_js_1.createImportSymbol)(name, from);
    };
    const createPreamble = (descFile) => (0, file_preamble_js_1.makeFilePreamble)(descFile, pluginName, pluginVersion, parameter.sanitizedParameter, parameter.tsNocheck);
    let target;
    const generatedFiles = [];
    return {
        targets: parameter.targets,
        runtime,
        proto: request,
        files: filesToGenerate,
        allFiles: descriptorSet.files,
        generateFile(name) {
            if (target === undefined) {
                throw new Error("prepareGenerate() must be called before generateFile()");
            }
            const genFile = (0, generated_file_js_1.createGeneratedFile)(name, (0, import_path_js_1.deriveImportPath)(name), target === "js" ? parameter.jsImportStyle : "module", // ts and dts always use import/export, only js may use commonjs
            (importPath) => (0, import_path_js_1.rewriteImportPath)(importPath, parameter.rewriteImports, parameter.importExtension), createTypeImport, runtime, createPreamble);
            generatedFiles.push(genFile);
            return genFile;
        },
        getFileInfo() {
            return generatedFiles
                .map((f) => f.getFileInfo())
                .filter((fi) => parameter.keepEmptyFiles || fi.content.length > 0);
        },
        prepareGenerate(newTarget) {
            target = newTarget;
        },
    };
}
exports.createSchema = createSchema;
function findFilesToGenerate(descriptorSet, request) {
    const missing = request.fileToGenerate.filter((fileToGenerate) => descriptorSet.files.every((file) => fileToGenerate !== file.name + ".proto"));
    if (missing.length) {
        throw `files_to_generate missing in the request: ${missing.join(", ")}`;
    }
    return descriptorSet.files.filter((file) => request.fileToGenerate.includes(file.name + ".proto"));
}
