/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryEval;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class BinaryOpValueExp
extends QueryEval
implements ValueExp {
    private static final long serialVersionUID = 1216286847881456786L;
    private int op;
    private ValueExp exp1;
    private ValueExp exp2;

    public BinaryOpValueExp() {
    }

    public BinaryOpValueExp(int n, ValueExp valueExp, ValueExp valueExp2) {
        this.op = n;
        this.exp1 = valueExp;
        this.exp2 = valueExp2;
    }

    public int getOperator() {
        return this.op;
    }

    public ValueExp getLeftValue() {
        return this.exp1;
    }

    public ValueExp getRightValue() {
        return this.exp2;
    }

    @Override
    public ValueExp apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp valueExp = this.exp1.apply(objectName);
        ValueExp valueExp2 = this.exp2.apply(objectName);
        boolean bl = valueExp instanceof NumericValueExp;
        if (bl) {
            if (((NumericValueExp)valueExp).isLong()) {
                long l = ((NumericValueExp)valueExp).longValue();
                long l2 = ((NumericValueExp)valueExp2).longValue();
                switch (this.op) {
                    case 0: {
                        return Query.value(l + l2);
                    }
                    case 2: {
                        return Query.value(l * l2);
                    }
                    case 1: {
                        return Query.value(l - l2);
                    }
                    case 3: {
                        return Query.value(l / l2);
                    }
                }
            } else {
                double d = ((NumericValueExp)valueExp).doubleValue();
                double d2 = ((NumericValueExp)valueExp2).doubleValue();
                switch (this.op) {
                    case 0: {
                        return Query.value(d + d2);
                    }
                    case 2: {
                        return Query.value(d * d2);
                    }
                    case 1: {
                        return Query.value(d - d2);
                    }
                    case 3: {
                        return Query.value(d / d2);
                    }
                }
            }
        } else {
            String string = ((StringValueExp)valueExp).getValue();
            String string2 = ((StringValueExp)valueExp2).getValue();
            switch (this.op) {
                case 0: {
                    return new StringValueExp(string + string2);
                }
            }
            throw new BadStringOperationException(this.opString());
        }
        throw new BadBinaryOpValueExpException(this);
    }

    public String toString() {
        try {
            return this.parens(this.exp1, true) + " " + this.opString() + " " + this.parens(this.exp2, false);
        }
        catch (BadBinaryOpValueExpException badBinaryOpValueExpException) {
            return "invalid expression";
        }
    }

    private String parens(ValueExp valueExp, boolean bl) throws BadBinaryOpValueExpException {
        boolean bl2;
        if (valueExp instanceof BinaryOpValueExp) {
            int n = ((BinaryOpValueExp)valueExp).op;
            bl2 = bl ? this.precedence(n) >= this.precedence(this.op) : this.precedence(n) > this.precedence(this.op);
        } else {
            bl2 = true;
        }
        if (bl2) {
            return valueExp.toString();
        }
        return "(" + valueExp + ")";
    }

    private int precedence(int n) throws BadBinaryOpValueExpException {
        switch (n) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        throw new BadBinaryOpValueExpException(this);
    }

    private String opString() throws BadBinaryOpValueExpException {
        switch (this.op) {
            case 0: {
                return "+";
            }
            case 2: {
                return "*";
            }
            case 1: {
                return "-";
            }
            case 3: {
                return "/";
            }
        }
        throw new BadBinaryOpValueExpException(this);
    }

    @Override
    @Deprecated
    public void setMBeanServer(MBeanServer mBeanServer) {
        super.setMBeanServer(mBeanServer);
    }
}

