// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-boundary-service/stable/2021-12-21/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// BoundaryServiceGetReader is a Reader for the BoundaryServiceGet structure.
type BoundaryServiceGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BoundaryServiceGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBoundaryServiceGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBoundaryServiceGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBoundaryServiceGetOK creates a BoundaryServiceGetOK with default headers values
func NewBoundaryServiceGetOK() *BoundaryServiceGetOK {
	return &BoundaryServiceGetOK{}
}

/*
BoundaryServiceGetOK describes a response with status code 200, with default header values.

A successful response.
*/
type BoundaryServiceGetOK struct {
	Payload *models.HashicorpCloudBoundary20211221GetResponse
}

// IsSuccess returns true when this boundary service get o k response has a 2xx status code
func (o *BoundaryServiceGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this boundary service get o k response has a 3xx status code
func (o *BoundaryServiceGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this boundary service get o k response has a 4xx status code
func (o *BoundaryServiceGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this boundary service get o k response has a 5xx status code
func (o *BoundaryServiceGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this boundary service get o k response a status code equal to that given
func (o *BoundaryServiceGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the boundary service get o k response
func (o *BoundaryServiceGetOK) Code() int {
	return 200
}

func (o *BoundaryServiceGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}][%d] boundaryServiceGetOK %s", 200, payload)
}

func (o *BoundaryServiceGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}][%d] boundaryServiceGetOK %s", 200, payload)
}

func (o *BoundaryServiceGetOK) GetPayload() *models.HashicorpCloudBoundary20211221GetResponse {
	return o.Payload
}

func (o *BoundaryServiceGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudBoundary20211221GetResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBoundaryServiceGetDefault creates a BoundaryServiceGetDefault with default headers values
func NewBoundaryServiceGetDefault(code int) *BoundaryServiceGetDefault {
	return &BoundaryServiceGetDefault{
		_statusCode: code,
	}
}

/*
BoundaryServiceGetDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type BoundaryServiceGetDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this boundary service get default response has a 2xx status code
func (o *BoundaryServiceGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this boundary service get default response has a 3xx status code
func (o *BoundaryServiceGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this boundary service get default response has a 4xx status code
func (o *BoundaryServiceGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this boundary service get default response has a 5xx status code
func (o *BoundaryServiceGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this boundary service get default response a status code equal to that given
func (o *BoundaryServiceGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the boundary service get default response
func (o *BoundaryServiceGetDefault) Code() int {
	return o._statusCode
}

func (o *BoundaryServiceGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}][%d] BoundaryService_Get default %s", o._statusCode, payload)
}

func (o *BoundaryServiceGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}][%d] BoundaryService_Get default %s", o._statusCode, payload)
}

func (o *BoundaryServiceGetDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *BoundaryServiceGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
