// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudGlobalNetworkManager20220215Trial hashicorp cloud global network manager 20220215 trial
//
// swagger:model hashicorp.cloud.global_network_manager_20220215.Trial
type HashicorpCloudGlobalNetworkManager20220215Trial struct {

	// end_date indicates the end date of the trial period
	// Format: date-time
	EndDate strfmt.DateTime `json:"end_date,omitempty"`

	// organization id
	OrganizationID string `json:"organization_id,omitempty"`

	// start_date indicates the start date of the trial, if this is NULL, then the trial has not started
	// Format: date-time
	StartDate strfmt.DateTime `json:"start_date,omitempty"`

	// trial_status indicates the current state of the HCP Consul trial for this organization
	TrialStatus *HashicorpCloudGlobalNetworkManager20220215TrialStatus `json:"trial_status,omitempty"`
}

// Validate validates this hashicorp cloud global network manager 20220215 trial
func (m *HashicorpCloudGlobalNetworkManager20220215Trial) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEndDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTrialStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215Trial) validateEndDate(formats strfmt.Registry) error {
	if swag.IsZero(m.EndDate) { // not required
		return nil
	}

	if err := validate.FormatOf("end_date", "body", "date-time", m.EndDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215Trial) validateStartDate(formats strfmt.Registry) error {
	if swag.IsZero(m.StartDate) { // not required
		return nil
	}

	if err := validate.FormatOf("start_date", "body", "date-time", m.StartDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215Trial) validateTrialStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.TrialStatus) { // not required
		return nil
	}

	if m.TrialStatus != nil {
		if err := m.TrialStatus.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("trial_status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("trial_status")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud global network manager 20220215 trial based on the context it is used
func (m *HashicorpCloudGlobalNetworkManager20220215Trial) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateTrialStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215Trial) contextValidateTrialStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.TrialStatus != nil {

		if swag.IsZero(m.TrialStatus) { // not required
			return nil
		}

		if err := m.TrialStatus.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("trial_status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("trial_status")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215Trial) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215Trial) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudGlobalNetworkManager20220215Trial
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
