// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new packer service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new packer service API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new packer service API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for packer service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	PackerServiceCreateBucket(params *PackerServiceCreateBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateBucketOK, error)

	PackerServiceCreateBuild(params *PackerServiceCreateBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateBuildOK, error)

	PackerServiceCreateChannel(params *PackerServiceCreateChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateChannelOK, error)

	PackerServiceCreateRegistry(params *PackerServiceCreateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateRegistryOK, error)

	PackerServiceCreateVersion(params *PackerServiceCreateVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateVersionOK, error)

	PackerServiceDeleteBucket(params *PackerServiceDeleteBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteBucketOK, error)

	PackerServiceDeleteBuild(params *PackerServiceDeleteBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteBuildOK, error)

	PackerServiceDeleteChannel(params *PackerServiceDeleteChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteChannelOK, error)

	PackerServiceDeleteRegistry(params *PackerServiceDeleteRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteRegistryOK, error)

	PackerServiceDeleteVersion(params *PackerServiceDeleteVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteVersionOK, error)

	PackerServiceGetBucket(params *PackerServiceGetBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetBucketOK, error)

	PackerServiceGetBuild(params *PackerServiceGetBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetBuildOK, error)

	PackerServiceGetChannel(params *PackerServiceGetChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetChannelOK, error)

	PackerServiceGetRegistry(params *PackerServiceGetRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetRegistryOK, error)

	PackerServiceGetRegistryTFCRunTaskAPI(params *PackerServiceGetRegistryTFCRunTaskAPIParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetRegistryTFCRunTaskAPIOK, error)

	PackerServiceGetSbom(params *PackerServiceGetSbomParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetSbomOK, error)

	PackerServiceGetVersion(params *PackerServiceGetVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetVersionOK, error)

	PackerServiceListBucketAncestry(params *PackerServiceListBucketAncestryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListBucketAncestryOK, error)

	PackerServiceListBuckets(params *PackerServiceListBucketsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListBucketsOK, error)

	PackerServiceListBuilds(params *PackerServiceListBuildsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListBuildsOK, error)

	PackerServiceListChannelAssignmentHistory(params *PackerServiceListChannelAssignmentHistoryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListChannelAssignmentHistoryOK, error)

	PackerServiceListChannels(params *PackerServiceListChannelsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListChannelsOK, error)

	PackerServiceListSboms(params *PackerServiceListSbomsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListSbomsOK, error)

	PackerServiceListVersions(params *PackerServiceListVersionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListVersionsOK, error)

	PackerServiceRegenerateTFCRunTaskHmacKey(params *PackerServiceRegenerateTFCRunTaskHmacKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceRegenerateTFCRunTaskHmacKeyOK, error)

	PackerServiceUpdateBucket(params *PackerServiceUpdateBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateBucketOK, error)

	PackerServiceUpdateBuild(params *PackerServiceUpdateBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateBuildOK, error)

	PackerServiceUpdateChannel(params *PackerServiceUpdateChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateChannelOK, error)

	PackerServiceUpdateRegistry(params *PackerServiceUpdateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateRegistryOK, error)

	PackerServiceUpdateVersion(params *PackerServiceUpdateVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateVersionOK, error)

	PackerServiceUploadSbom(params *PackerServiceUploadSbomParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUploadSbomOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
PackerServiceCreateBucket creates a bucket in the h c p packer registry
*/
func (a *Client) PackerServiceCreateBucket(params *PackerServiceCreateBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateBucketOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceCreateBucketParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_CreateBucket",
		Method:             "PUT",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceCreateBucketReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceCreateBucketOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceCreateBucketDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceCreateBuild creates a build in the provided version it is called once for each build source in a packer build run the request will error if the build for a given platform already exists
*/
func (a *Client) PackerServiceCreateBuild(params *PackerServiceCreateBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateBuildOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceCreateBuildParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_CreateBuild",
		Method:             "POST",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceCreateBuildReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceCreateBuildOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceCreateBuildDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceCreateChannel creates a channel either empty or assigned to a version
*/
func (a *Client) PackerServiceCreateChannel(params *PackerServiceCreateChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateChannelOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceCreateChannelParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_CreateChannel",
		Method:             "POST",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceCreateChannelReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceCreateChannelOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceCreateChannelDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceCreateRegistry creates the h c p packer registry and starts billing for it
*/
func (a *Client) PackerServiceCreateRegistry(params *PackerServiceCreateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceCreateRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_CreateRegistry",
		Method:             "PUT",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/registry",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceCreateRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceCreateRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceCreateRegistryDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceCreateVersion creates an empty version to be written to this API is called at the beginning of a new packer build and does not create individual builds for the version
*/
func (a *Client) PackerServiceCreateVersion(params *PackerServiceCreateVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceCreateVersionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceCreateVersionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_CreateVersion",
		Method:             "POST",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceCreateVersionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceCreateVersionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceCreateVersionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceDeleteBucket deletes the bucket and all its information such as versions builds and artifacts
*/
func (a *Client) PackerServiceDeleteBucket(params *PackerServiceDeleteBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteBucketOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceDeleteBucketParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_DeleteBucket",
		Method:             "DELETE",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceDeleteBucketReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceDeleteBucketOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceDeleteBucketDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceDeleteBuild deletes a build in the provided version
*/
func (a *Client) PackerServiceDeleteBuild(params *PackerServiceDeleteBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteBuildOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceDeleteBuildParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_DeleteBuild",
		Method:             "DELETE",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceDeleteBuildReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceDeleteBuildOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceDeleteBuildDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceDeleteChannel deletes a channel
*/
func (a *Client) PackerServiceDeleteChannel(params *PackerServiceDeleteChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteChannelOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceDeleteChannelParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_DeleteChannel",
		Method:             "DELETE",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceDeleteChannelReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceDeleteChannelOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceDeleteChannelDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceDeleteRegistry deletes the h c p packer registry and any associated resources from the database
*/
func (a *Client) PackerServiceDeleteRegistry(params *PackerServiceDeleteRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceDeleteRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_DeleteRegistry",
		Method:             "DELETE",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/registry",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceDeleteRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceDeleteRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceDeleteRegistryDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceDeleteVersion deletes the version and all its information such as its builds and artifacts
*/
func (a *Client) PackerServiceDeleteVersion(params *PackerServiceDeleteVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceDeleteVersionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceDeleteVersionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_DeleteVersion",
		Method:             "DELETE",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceDeleteVersionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceDeleteVersionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceDeleteVersionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetBucket retrieves an existing bucket
*/
func (a *Client) PackerServiceGetBucket(params *PackerServiceGetBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetBucketOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetBucketParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetBucket",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetBucketReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetBucketOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetBucketDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetBuild retrieves a build with its list of artifacts
*/
func (a *Client) PackerServiceGetBuild(params *PackerServiceGetBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetBuildOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetBuildParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetBuild",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetBuildReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetBuildOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetBuildDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetChannel retrieves a channel with the version that it is currently assigned if any
*/
func (a *Client) PackerServiceGetChannel(params *PackerServiceGetChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetChannelOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetChannelParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetChannel",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetChannelReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetChannelOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetChannelDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetRegistry retrieves the h c p packer registry
*/
func (a *Client) PackerServiceGetRegistry(params *PackerServiceGetRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetRegistry",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/registry",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetRegistryDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetRegistryTFCRunTaskAPI gets the h c p packer registry API URL and h m a c key to integrate with terraform cloud as a run task
*/
func (a *Client) PackerServiceGetRegistryTFCRunTaskAPI(params *PackerServiceGetRegistryTFCRunTaskAPIParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetRegistryTFCRunTaskAPIOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetRegistryTFCRunTaskAPIParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetRegistryTFCRunTaskAPI",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/runtasks/{task_type}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetRegistryTFCRunTaskAPIReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetRegistryTFCRunTaskAPIOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetRegistryTFCRunTaskAPIDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetSbom retrieves the stored s b o m generating a presigned URL with a w s s3 to retrieve the file
*/
func (a *Client) PackerServiceGetSbom(params *PackerServiceGetSbomParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetSbomOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetSbomParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetSbom",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms/{sbom_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetSbomReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetSbomOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetSbomDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceGetVersion retrieves the version using the version fingerprint
*/
func (a *Client) PackerServiceGetVersion(params *PackerServiceGetVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceGetVersionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceGetVersionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_GetVersion",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceGetVersionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceGetVersionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceGetVersionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceListBucketAncestry lists the ancestry relationships for the bucket this includes direct source bucket parents and downstream artifacts built directly from the bucket children
*/
func (a *Client) PackerServiceListBucketAncestry(params *PackerServiceListBucketAncestryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListBucketAncestryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceListBucketAncestryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_ListBucketAncestry",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/ancestry",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceListBucketAncestryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceListBucketAncestryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceListBucketAncestryDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceListBuckets lists all existing buckets in the h c p packer registry
*/
func (a *Client) PackerServiceListBuckets(params *PackerServiceListBucketsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListBucketsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceListBucketsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_ListBuckets",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceListBucketsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceListBucketsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceListBucketsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceListBuilds lists every existing build and its artifacts for a version
*/
func (a *Client) PackerServiceListBuilds(params *PackerServiceListBuildsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListBuildsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceListBuildsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_ListBuilds",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceListBuildsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceListBuildsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceListBuildsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceListChannelAssignmentHistory lists a channel assignement history
*/
func (a *Client) PackerServiceListChannelAssignmentHistory(params *PackerServiceListChannelAssignmentHistoryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListChannelAssignmentHistoryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceListChannelAssignmentHistoryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_ListChannelAssignmentHistory",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}/history",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceListChannelAssignmentHistoryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceListChannelAssignmentHistoryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceListChannelAssignmentHistoryDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceListChannels lists all channels of a given bucket
*/
func (a *Client) PackerServiceListChannels(params *PackerServiceListChannelsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListChannelsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceListChannelsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_ListChannels",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceListChannelsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceListChannelsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceListChannelsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceListSboms lists every existing sbom for a build
*/
func (a *Client) PackerServiceListSboms(params *PackerServiceListSbomsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListSbomsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceListSbomsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_ListSboms",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceListSbomsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceListSbomsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceListSbomsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceListVersions lists every existing version of a bucket
*/
func (a *Client) PackerServiceListVersions(params *PackerServiceListVersionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceListVersionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceListVersionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_ListVersions",
		Method:             "GET",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceListVersionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceListVersionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceListVersionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceRegenerateTFCRunTaskHmacKey regenerates the h m a c key used to sign requests from terraform cloud to h c p packer run tasks
*/
func (a *Client) PackerServiceRegenerateTFCRunTaskHmacKey(params *PackerServiceRegenerateTFCRunTaskHmacKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceRegenerateTFCRunTaskHmacKeyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceRegenerateTFCRunTaskHmacKeyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_RegenerateTFCRunTaskHmacKey",
		Method:             "PATCH",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/runtasks/hmac",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceRegenerateTFCRunTaskHmacKeyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceRegenerateTFCRunTaskHmacKeyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceRegenerateTFCRunTaskHmacKeyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceUpdateBucket updates the bucket s information
*/
func (a *Client) PackerServiceUpdateBucket(params *PackerServiceUpdateBucketParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateBucketOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceUpdateBucketParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_UpdateBucket",
		Method:             "PATCH",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceUpdateBucketReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceUpdateBucketOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceUpdateBucketDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceUpdateBuild updates the build this may be most often used for modifying the status of a currently running build
*/
func (a *Client) PackerServiceUpdateBuild(params *PackerServiceUpdateBuildParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateBuildOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceUpdateBuildParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_UpdateBuild",
		Method:             "PATCH",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceUpdateBuildReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceUpdateBuildOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceUpdateBuildDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceUpdateChannel updates the channel assignment and or restriction
*/
func (a *Client) PackerServiceUpdateChannel(params *PackerServiceUpdateChannelParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateChannelOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceUpdateChannelParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_UpdateChannel",
		Method:             "PATCH",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceUpdateChannelReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceUpdateChannelOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceUpdateChannelDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceUpdateRegistry updates the feature tier o r activates deactivates the h c p packer registry deactivating a registry will stop any additional billing for the resource
*/
func (a *Client) PackerServiceUpdateRegistry(params *PackerServiceUpdateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceUpdateRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_UpdateRegistry",
		Method:             "PATCH",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/registry",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceUpdateRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceUpdateRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceUpdateRegistryDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceUpdateVersion this API can be used to revoke restore or complete a version when a version is revoked all its descendants will automatically get revoked unless skip descendants revocation is set descendants will get revoked asynchronously to the request revoked versions cannot be updated unless restored
*/
func (a *Client) PackerServiceUpdateVersion(params *PackerServiceUpdateVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUpdateVersionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceUpdateVersionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_UpdateVersion",
		Method:             "PATCH",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceUpdateVersionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceUpdateVersionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceUpdateVersionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PackerServiceUploadSbom stores a zstd compressed s b o m and associates it with a build
*/
func (a *Client) PackerServiceUploadSbom(params *PackerServiceUploadSbomParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PackerServiceUploadSbomOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPackerServiceUploadSbomParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PackerService_UploadSbom",
		Method:             "PUT",
		PathPattern:        "/packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PackerServiceUploadSbomReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PackerServiceUploadSbomOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PackerServiceUploadSbomDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
