// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceListActionRunsReader is a Reader for the WaypointServiceListActionRuns structure.
type WaypointServiceListActionRunsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceListActionRunsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceListActionRunsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceListActionRunsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceListActionRunsOK creates a WaypointServiceListActionRunsOK with default headers values
func NewWaypointServiceListActionRunsOK() *WaypointServiceListActionRunsOK {
	return &WaypointServiceListActionRunsOK{}
}

/*
WaypointServiceListActionRunsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceListActionRunsOK struct {
	Payload *models.HashicorpCloudWaypointListActionRunsResponse
}

// IsSuccess returns true when this waypoint service list action runs o k response has a 2xx status code
func (o *WaypointServiceListActionRunsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service list action runs o k response has a 3xx status code
func (o *WaypointServiceListActionRunsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service list action runs o k response has a 4xx status code
func (o *WaypointServiceListActionRunsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service list action runs o k response has a 5xx status code
func (o *WaypointServiceListActionRunsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service list action runs o k response a status code equal to that given
func (o *WaypointServiceListActionRunsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service list action runs o k response
func (o *WaypointServiceListActionRunsOK) Code() int {
	return 200
}

func (o *WaypointServiceListActionRunsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/action/{action_id}/runs][%d] waypointServiceListActionRunsOK %s", 200, payload)
}

func (o *WaypointServiceListActionRunsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/action/{action_id}/runs][%d] waypointServiceListActionRunsOK %s", 200, payload)
}

func (o *WaypointServiceListActionRunsOK) GetPayload() *models.HashicorpCloudWaypointListActionRunsResponse {
	return o.Payload
}

func (o *WaypointServiceListActionRunsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointListActionRunsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceListActionRunsDefault creates a WaypointServiceListActionRunsDefault with default headers values
func NewWaypointServiceListActionRunsDefault(code int) *WaypointServiceListActionRunsDefault {
	return &WaypointServiceListActionRunsDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceListActionRunsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceListActionRunsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service list action runs default response has a 2xx status code
func (o *WaypointServiceListActionRunsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service list action runs default response has a 3xx status code
func (o *WaypointServiceListActionRunsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service list action runs default response has a 4xx status code
func (o *WaypointServiceListActionRunsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service list action runs default response has a 5xx status code
func (o *WaypointServiceListActionRunsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service list action runs default response a status code equal to that given
func (o *WaypointServiceListActionRunsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service list action runs default response
func (o *WaypointServiceListActionRunsDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceListActionRunsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/action/{action_id}/runs][%d] WaypointService_ListActionRuns default %s", o._statusCode, payload)
}

func (o *WaypointServiceListActionRunsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/action/{action_id}/runs][%d] WaypointService_ListActionRuns default %s", o._statusCode, payload)
}

func (o *WaypointServiceListActionRunsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceListActionRunsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
