// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceUpdateChannelReader is a Reader for the PackerServiceUpdateChannel structure.
type PackerServiceUpdateChannelReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceUpdateChannelReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceUpdateChannelOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceUpdateChannelDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceUpdateChannelOK creates a PackerServiceUpdateChannelOK with default headers values
func NewPackerServiceUpdateChannelOK() *PackerServiceUpdateChannelOK {
	return &PackerServiceUpdateChannelOK{}
}

/*
PackerServiceUpdateChannelOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceUpdateChannelOK struct {
	Payload *models.HashicorpCloudPacker20230101UpdateChannelResponse
}

// IsSuccess returns true when this packer service update channel o k response has a 2xx status code
func (o *PackerServiceUpdateChannelOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service update channel o k response has a 3xx status code
func (o *PackerServiceUpdateChannelOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service update channel o k response has a 4xx status code
func (o *PackerServiceUpdateChannelOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service update channel o k response has a 5xx status code
func (o *PackerServiceUpdateChannelOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service update channel o k response a status code equal to that given
func (o *PackerServiceUpdateChannelOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service update channel o k response
func (o *PackerServiceUpdateChannelOK) Code() int {
	return 200
}

func (o *PackerServiceUpdateChannelOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}][%d] packerServiceUpdateChannelOK %s", 200, payload)
}

func (o *PackerServiceUpdateChannelOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}][%d] packerServiceUpdateChannelOK %s", 200, payload)
}

func (o *PackerServiceUpdateChannelOK) GetPayload() *models.HashicorpCloudPacker20230101UpdateChannelResponse {
	return o.Payload
}

func (o *PackerServiceUpdateChannelOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101UpdateChannelResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceUpdateChannelDefault creates a PackerServiceUpdateChannelDefault with default headers values
func NewPackerServiceUpdateChannelDefault(code int) *PackerServiceUpdateChannelDefault {
	return &PackerServiceUpdateChannelDefault{
		_statusCode: code,
	}
}

/*
PackerServiceUpdateChannelDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceUpdateChannelDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service update channel default response has a 2xx status code
func (o *PackerServiceUpdateChannelDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service update channel default response has a 3xx status code
func (o *PackerServiceUpdateChannelDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service update channel default response has a 4xx status code
func (o *PackerServiceUpdateChannelDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service update channel default response has a 5xx status code
func (o *PackerServiceUpdateChannelDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service update channel default response a status code equal to that given
func (o *PackerServiceUpdateChannelDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service update channel default response
func (o *PackerServiceUpdateChannelDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceUpdateChannelDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}][%d] PackerService_UpdateChannel default %s", o._statusCode, payload)
}

func (o *PackerServiceUpdateChannelDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}][%d] PackerService_UpdateChannel default %s", o._statusCode, payload)
}

func (o *PackerServiceUpdateChannelDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceUpdateChannelDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
