// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// UpdateSyncInstallationReader is a Reader for the UpdateSyncInstallation structure.
type UpdateSyncInstallationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateSyncInstallationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateSyncInstallationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdateSyncInstallationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateSyncInstallationOK creates a UpdateSyncInstallationOK with default headers values
func NewUpdateSyncInstallationOK() *UpdateSyncInstallationOK {
	return &UpdateSyncInstallationOK{}
}

/*
UpdateSyncInstallationOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdateSyncInstallationOK struct {
	Payload *models.Secrets20230613UpdateSyncInstallationResponse
}

// IsSuccess returns true when this update sync installation o k response has a 2xx status code
func (o *UpdateSyncInstallationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update sync installation o k response has a 3xx status code
func (o *UpdateSyncInstallationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update sync installation o k response has a 4xx status code
func (o *UpdateSyncInstallationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update sync installation o k response has a 5xx status code
func (o *UpdateSyncInstallationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update sync installation o k response a status code equal to that given
func (o *UpdateSyncInstallationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update sync installation o k response
func (o *UpdateSyncInstallationOK) Code() int {
	return 200
}

func (o *UpdateSyncInstallationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/installations/{name}][%d] updateSyncInstallationOK %s", 200, payload)
}

func (o *UpdateSyncInstallationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/installations/{name}][%d] updateSyncInstallationOK %s", 200, payload)
}

func (o *UpdateSyncInstallationOK) GetPayload() *models.Secrets20230613UpdateSyncInstallationResponse {
	return o.Payload
}

func (o *UpdateSyncInstallationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20230613UpdateSyncInstallationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateSyncInstallationDefault creates a UpdateSyncInstallationDefault with default headers values
func NewUpdateSyncInstallationDefault(code int) *UpdateSyncInstallationDefault {
	return &UpdateSyncInstallationDefault{
		_statusCode: code,
	}
}

/*
UpdateSyncInstallationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdateSyncInstallationDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this update sync installation default response has a 2xx status code
func (o *UpdateSyncInstallationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update sync installation default response has a 3xx status code
func (o *UpdateSyncInstallationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update sync installation default response has a 4xx status code
func (o *UpdateSyncInstallationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update sync installation default response has a 5xx status code
func (o *UpdateSyncInstallationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update sync installation default response a status code equal to that given
func (o *UpdateSyncInstallationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the update sync installation default response
func (o *UpdateSyncInstallationDefault) Code() int {
	return o._statusCode
}

func (o *UpdateSyncInstallationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/installations/{name}][%d] UpdateSyncInstallation default %s", o._statusCode, payload)
}

func (o *UpdateSyncInstallationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/installations/{name}][%d] UpdateSyncInstallation default %s", o._statusCode, payload)
}

func (o *UpdateSyncInstallationDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *UpdateSyncInstallationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
UpdateSyncInstallationBody update sync installation body
swagger:model UpdateSyncInstallationBody
*/
type UpdateSyncInstallationBody struct {

	// hcp terraform update installation request
	HcpTerraformUpdateInstallationRequest *models.Secrets20230613HcpTerraformUpdateInstallationRequest `json:"hcp_terraform_update_installation_request,omitempty"`

	// location
	Location *UpdateSyncInstallationParamsBodyLocation `json:"location,omitempty"`
}

// Validate validates this update sync installation body
func (o *UpdateSyncInstallationBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateHcpTerraformUpdateInstallationRequest(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateSyncInstallationBody) validateHcpTerraformUpdateInstallationRequest(formats strfmt.Registry) error {
	if swag.IsZero(o.HcpTerraformUpdateInstallationRequest) { // not required
		return nil
	}

	if o.HcpTerraformUpdateInstallationRequest != nil {
		if err := o.HcpTerraformUpdateInstallationRequest.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "hcp_terraform_update_installation_request")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "hcp_terraform_update_installation_request")
			}
			return err
		}
	}

	return nil
}

func (o *UpdateSyncInstallationBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this update sync installation body based on the context it is used
func (o *UpdateSyncInstallationBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateHcpTerraformUpdateInstallationRequest(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateSyncInstallationBody) contextValidateHcpTerraformUpdateInstallationRequest(ctx context.Context, formats strfmt.Registry) error {

	if o.HcpTerraformUpdateInstallationRequest != nil {

		if swag.IsZero(o.HcpTerraformUpdateInstallationRequest) { // not required
			return nil
		}

		if err := o.HcpTerraformUpdateInstallationRequest.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "hcp_terraform_update_installation_request")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "hcp_terraform_update_installation_request")
			}
			return err
		}
	}

	return nil
}

func (o *UpdateSyncInstallationBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UpdateSyncInstallationBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UpdateSyncInstallationBody) UnmarshalBinary(b []byte) error {
	var res UpdateSyncInstallationBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
UpdateSyncInstallationParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model UpdateSyncInstallationParamsBodyLocation
*/
type UpdateSyncInstallationParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this update sync installation params body location
func (o *UpdateSyncInstallationParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateSyncInstallationParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this update sync installation params body location based on the context it is used
func (o *UpdateSyncInstallationParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateSyncInstallationParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UpdateSyncInstallationParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UpdateSyncInstallationParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res UpdateSyncInstallationParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
