// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteSyncParams creates a new DeleteSyncParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteSyncParams() *DeleteSyncParams {
	return &DeleteSyncParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteSyncParamsWithTimeout creates a new DeleteSyncParams object
// with the ability to set a timeout on a request.
func NewDeleteSyncParamsWithTimeout(timeout time.Duration) *DeleteSyncParams {
	return &DeleteSyncParams{
		timeout: timeout,
	}
}

// NewDeleteSyncParamsWithContext creates a new DeleteSyncParams object
// with the ability to set a context for a request.
func NewDeleteSyncParamsWithContext(ctx context.Context) *DeleteSyncParams {
	return &DeleteSyncParams{
		Context: ctx,
	}
}

// NewDeleteSyncParamsWithHTTPClient creates a new DeleteSyncParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteSyncParamsWithHTTPClient(client *http.Client) *DeleteSyncParams {
	return &DeleteSyncParams{
		HTTPClient: client,
	}
}

/*
DeleteSyncParams contains all the parameters to send to the API endpoint

	for the delete sync operation.

	Typically these are written to a http.Request.
*/
type DeleteSyncParams struct {

	// CascadeDelete.
	CascadeDelete *bool

	// Name.
	Name string

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	// PurgeSyncedSecrets.
	PurgeSyncedSecrets *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete sync params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteSyncParams) WithDefaults() *DeleteSyncParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete sync params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteSyncParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete sync params
func (o *DeleteSyncParams) WithTimeout(timeout time.Duration) *DeleteSyncParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete sync params
func (o *DeleteSyncParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete sync params
func (o *DeleteSyncParams) WithContext(ctx context.Context) *DeleteSyncParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete sync params
func (o *DeleteSyncParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete sync params
func (o *DeleteSyncParams) WithHTTPClient(client *http.Client) *DeleteSyncParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete sync params
func (o *DeleteSyncParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCascadeDelete adds the cascadeDelete to the delete sync params
func (o *DeleteSyncParams) WithCascadeDelete(cascadeDelete *bool) *DeleteSyncParams {
	o.SetCascadeDelete(cascadeDelete)
	return o
}

// SetCascadeDelete adds the cascadeDelete to the delete sync params
func (o *DeleteSyncParams) SetCascadeDelete(cascadeDelete *bool) {
	o.CascadeDelete = cascadeDelete
}

// WithName adds the name to the delete sync params
func (o *DeleteSyncParams) WithName(name string) *DeleteSyncParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the delete sync params
func (o *DeleteSyncParams) SetName(name string) {
	o.Name = name
}

// WithOrganizationID adds the organizationID to the delete sync params
func (o *DeleteSyncParams) WithOrganizationID(organizationID string) *DeleteSyncParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the delete sync params
func (o *DeleteSyncParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the delete sync params
func (o *DeleteSyncParams) WithProjectID(projectID string) *DeleteSyncParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the delete sync params
func (o *DeleteSyncParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WithPurgeSyncedSecrets adds the purgeSyncedSecrets to the delete sync params
func (o *DeleteSyncParams) WithPurgeSyncedSecrets(purgeSyncedSecrets *bool) *DeleteSyncParams {
	o.SetPurgeSyncedSecrets(purgeSyncedSecrets)
	return o
}

// SetPurgeSyncedSecrets adds the purgeSyncedSecrets to the delete sync params
func (o *DeleteSyncParams) SetPurgeSyncedSecrets(purgeSyncedSecrets *bool) {
	o.PurgeSyncedSecrets = purgeSyncedSecrets
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteSyncParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CascadeDelete != nil {

		// query param cascade_delete
		var qrCascadeDelete bool

		if o.CascadeDelete != nil {
			qrCascadeDelete = *o.CascadeDelete
		}
		qCascadeDelete := swag.FormatBool(qrCascadeDelete)
		if qCascadeDelete != "" {

			if err := r.SetQueryParam("cascade_delete", qCascadeDelete); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if o.PurgeSyncedSecrets != nil {

		// query param purge_synced_secrets
		var qrPurgeSyncedSecrets bool

		if o.PurgeSyncedSecrets != nil {
			qrPurgeSyncedSecrets = *o.PurgeSyncedSecrets
		}
		qPurgeSyncedSecrets := swag.FormatBool(qrPurgeSyncedSecrets)
		if qPurgeSyncedSecrets != "" {

			if err := r.SetQueryParam("purge_synced_secrets", qPurgeSyncedSecrets); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
