// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// UpdateAppRotatingSecretReader is a Reader for the UpdateAppRotatingSecret structure.
type UpdateAppRotatingSecretReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateAppRotatingSecretReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateAppRotatingSecretOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdateAppRotatingSecretDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateAppRotatingSecretOK creates a UpdateAppRotatingSecretOK with default headers values
func NewUpdateAppRotatingSecretOK() *UpdateAppRotatingSecretOK {
	return &UpdateAppRotatingSecretOK{}
}

/*
UpdateAppRotatingSecretOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdateAppRotatingSecretOK struct {
	Payload *models.Secrets20231128UpdateAppRotatingSecretResponse
}

// IsSuccess returns true when this update app rotating secret o k response has a 2xx status code
func (o *UpdateAppRotatingSecretOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update app rotating secret o k response has a 3xx status code
func (o *UpdateAppRotatingSecretOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update app rotating secret o k response has a 4xx status code
func (o *UpdateAppRotatingSecretOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update app rotating secret o k response has a 5xx status code
func (o *UpdateAppRotatingSecretOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update app rotating secret o k response a status code equal to that given
func (o *UpdateAppRotatingSecretOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update app rotating secret o k response
func (o *UpdateAppRotatingSecretOK) Code() int {
	return 200
}

func (o *UpdateAppRotatingSecretOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating/{name}][%d] updateAppRotatingSecretOK %s", 200, payload)
}

func (o *UpdateAppRotatingSecretOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating/{name}][%d] updateAppRotatingSecretOK %s", 200, payload)
}

func (o *UpdateAppRotatingSecretOK) GetPayload() *models.Secrets20231128UpdateAppRotatingSecretResponse {
	return o.Payload
}

func (o *UpdateAppRotatingSecretOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128UpdateAppRotatingSecretResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAppRotatingSecretDefault creates a UpdateAppRotatingSecretDefault with default headers values
func NewUpdateAppRotatingSecretDefault(code int) *UpdateAppRotatingSecretDefault {
	return &UpdateAppRotatingSecretDefault{
		_statusCode: code,
	}
}

/*
UpdateAppRotatingSecretDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdateAppRotatingSecretDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this update app rotating secret default response has a 2xx status code
func (o *UpdateAppRotatingSecretDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update app rotating secret default response has a 3xx status code
func (o *UpdateAppRotatingSecretDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update app rotating secret default response has a 4xx status code
func (o *UpdateAppRotatingSecretDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update app rotating secret default response has a 5xx status code
func (o *UpdateAppRotatingSecretDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update app rotating secret default response a status code equal to that given
func (o *UpdateAppRotatingSecretDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the update app rotating secret default response
func (o *UpdateAppRotatingSecretDefault) Code() int {
	return o._statusCode
}

func (o *UpdateAppRotatingSecretDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating/{name}][%d] UpdateAppRotatingSecret default %s", o._statusCode, payload)
}

func (o *UpdateAppRotatingSecretDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating/{name}][%d] UpdateAppRotatingSecret default %s", o._statusCode, payload)
}

func (o *UpdateAppRotatingSecretDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *UpdateAppRotatingSecretDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
