﻿// Copyright (c) 2014 AlphaSierraPapa for the SharpDevelop Team
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy of this
// software and associated documentation files (the "Software"), to deal in the Software
// without restriction, including without limitation the rights to use, copy, modify, merge,
// publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
// to whom the Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all copies or
// substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
// FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

using System;
using AvaloniaEdit.Utils;

namespace AvaloniaEdit.Rendering
{
    /// <summary>
    /// Contains weak event managers for the TextView events.
    /// </summary>
    public static class TextViewWeakEventManager
    {
        /// <summary>
        /// Weak event manager for the <see cref="TextView.DocumentChanged"/> event.
        /// </summary>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible")]
        public sealed class DocumentChanged : WeakEventManagerBase<DocumentChanged, TextView, EventHandler, EventArgs>
        {
            protected override void StartListening(TextView source) => source.DocumentChanged += DeliverEvent;

            protected override void StopListening(TextView source) => source.DocumentChanged -= DeliverEvent;
        }

        /// <summary>
        /// Weak event manager for the <see cref="TextView.VisualLinesChanged"/> event.
        /// </summary>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible")]
        public sealed class VisualLinesChanged : WeakEventManagerBase<VisualLinesChanged, TextView, EventHandler, EventArgs>
        {
            protected override void StartListening(TextView source) => source.VisualLinesChanged += DeliverEvent;

            protected override void StopListening(TextView source) => source.VisualLinesChanged -= DeliverEvent;
        }

        /// <summary>
        /// Weak event manager for the <see cref="TextView.ScrollOffsetChanged"/> event.
        /// </summary>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible")]
        public sealed class ScrollOffsetChanged : WeakEventManagerBase<ScrollOffsetChanged, TextView, EventHandler, EventArgs>
        {
            protected override void StartListening(TextView source) => source.ScrollOffsetChanged += DeliverEvent;

            protected override void StopListening(TextView source) => source.ScrollOffsetChanged -= DeliverEvent;
        }
    }
}
