/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleImmutableList;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleLists;
import it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.DoubleConsumer;
import java.util.stream.DoubleStream;

public class DoubleImmutableList
extends DoubleLists.ImmutableListBase
implements DoubleList,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    static final DoubleImmutableList EMPTY = new DoubleImmutableList(DoubleArrays.EMPTY_ARRAY);
    private final double[] a;

    public DoubleImmutableList(double[] a) {
        this.a = a;
    }

    public DoubleImmutableList(Collection<? extends Double> c) {
        this(c.isEmpty() ? DoubleArrays.EMPTY_ARRAY : DoubleIterators.unwrap(DoubleIterators.asDoubleIterator(c.iterator())));
    }

    public DoubleImmutableList(DoubleCollection c) {
        this(c.isEmpty() ? DoubleArrays.EMPTY_ARRAY : DoubleIterators.unwrap(c.iterator()));
    }

    public DoubleImmutableList(DoubleList l) {
        this(l.isEmpty() ? DoubleArrays.EMPTY_ARRAY : new double[l.size()]);
        l.getElements(0, this.a, 0, l.size());
    }

    public DoubleImmutableList(double[] a, int offset, int length) {
        this(length == 0 ? DoubleArrays.EMPTY_ARRAY : new double[length]);
        System.arraycopy(a, offset, this.a, 0, length);
    }

    public DoubleImmutableList(DoubleIterator i) {
        this(i.hasNext() ? DoubleIterators.unwrap(i) : DoubleArrays.EMPTY_ARRAY);
    }

    public static DoubleImmutableList of() {
        return EMPTY;
    }

    public static DoubleImmutableList of(double ... init) {
        return init.length == 0 ? DoubleImmutableList.of() : new DoubleImmutableList(init);
    }

    private static DoubleImmutableList convertTrustedToImmutableList(DoubleArrayList arrayList) {
        if (arrayList.isEmpty()) {
            return DoubleImmutableList.of();
        }
        double[] backingArray = arrayList.elements();
        if (arrayList.size() != backingArray.length) {
            backingArray = Arrays.copyOf(backingArray, arrayList.size());
        }
        return new DoubleImmutableList(backingArray);
    }

    public static DoubleImmutableList toList(DoubleStream stream) {
        return DoubleImmutableList.convertTrustedToImmutableList(DoubleArrayList.toList(stream));
    }

    public static DoubleImmutableList toListWithExpectedSize(DoubleStream stream, int expectedSize) {
        return DoubleImmutableList.convertTrustedToImmutableList(DoubleArrayList.toListWithExpectedSize(stream, expectedSize));
    }

    @Override
    public double getDouble(int index) {
        if (index >= this.a.length) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.a.length + ")");
        }
        return this.a[index];
    }

    @Override
    public int indexOf(double k) {
        double[] a = this.a;
        int size = a.length;
        for (int i = 0; i < size; ++i) {
            if (Double.doubleToLongBits(k) != Double.doubleToLongBits(a[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(double k) {
        double[] a = this.a;
        int i = a.length;
        while (i-- != 0) {
            if (Double.doubleToLongBits(k) != Double.doubleToLongBits(a[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.a.length;
    }

    @Override
    public boolean isEmpty() {
        return this.a.length == 0;
    }

    @Override
    public void getElements(int from, double[] a, int offset, int length) {
        DoubleArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    @Override
    public void forEach(DoubleConsumer action) {
        double[] a = this.a;
        for (int i = 0; i < a.length; ++i) {
            action.accept(a[i]);
        }
    }

    @Override
    public double[] toDoubleArray() {
        if (this.a.length == 0) {
            return DoubleArrays.EMPTY_ARRAY;
        }
        return (double[])this.a.clone();
    }

    @Override
    public double[] toArray(double[] a) {
        if (a == null || a.length < this.size()) {
            a = new double[this.a.length];
        }
        System.arraycopy(this.a, 0, a, 0, a.length);
        return a;
    }

    @Override
    public DoubleListIterator listIterator(int index) {
        this.ensureIndex(index);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public DoubleSpliterator spliterator() {
        return new Spliterator(this);
    }

    @Override
    public DoubleList subList(int from, int to) {
        if (from == 0 && to == this.size()) {
            return this;
        }
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from == to) {
            return EMPTY;
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new ImmutableSubList(this, from, to);
    }

    public DoubleImmutableList clone() {
        return this;
    }

    public boolean equals(DoubleImmutableList l) {
        if (l == this) {
            return true;
        }
        if (this.a == l.a) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        double[] a1 = this.a;
        double[] a2 = l.a;
        return Arrays.equals(a1, a2);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (o instanceof DoubleImmutableList) {
            return this.equals((DoubleImmutableList)o);
        }
        if (o instanceof ImmutableSubList) {
            return ((ImmutableSubList)o).equals((Object)this);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(DoubleImmutableList l) {
        int i;
        if (this.a == l.a) {
            return 0;
        }
        int s1 = this.size();
        int s2 = l.size();
        double[] a1 = this.a;
        double[] a2 = l.a;
        for (i = 0; i < s1 && i < s2; ++i) {
            double e1 = a1[i];
            double e2 = a2[i];
            int r = Double.compare(e1, e2);
            if (r == 0) continue;
            return r;
        }
        return i < s2 ? -1 : (i < s1 ? 1 : 0);
    }

    @Override
    public int compareTo(List<? extends Double> l) {
        if (l instanceof DoubleImmutableList) {
            return this.compareTo((DoubleImmutableList)l);
        }
        if (l instanceof ImmutableSubList) {
            ImmutableSubList other = (ImmutableSubList)l;
            return -other.compareTo((List)this);
        }
        return super.compareTo(l);
    }

    static /* synthetic */ double[] access$000(DoubleImmutableList x0) {
        return x0.a;
    }
}

