# Welcome to Puma 6: Sunflower.

![Image by Todd Trapani, Unsplash](https://user-images.githubusercontent.com/845662/192706685-774d3d0d-f4a9-4b93-b27b-5a3b7f44ff31.jpg)

Puma 6 brings performance improvements for most applications, experimental Rack 3 support, support for Sidekiq 7 Capsules, and more.

Here's what you should do:

1. Review the Upgrade section below to look for breaking changes that could affect you.
2. Upgrade to version 6.0 in your Gemfile and deploy.
3. Open up a new bug issue if you find any problems.
4. Join us in building Puma! We welcome first-timers. See [CONTRIBUTING.md](./CONTRIBUTING.md).

For a complete list of changes, see [History.md](./History.md).

## What's New

Puma 6 is mostly about a few nice-to-have performance changes, and then a few breaking API changes we've been putting off for a while.

### Improved Performance

We've improved throughput and latency in Puma 6 in a few areas.

1. **Large chunked response body throughput 3-10x higher** Chunked response bodies >100kb should be 3 to 10 times faster than in Puma 5. String response bodies should be ~10% faster.
2. **File response throughput is 3x higher.** File responses (e.g. assets) should be about 3x faster.
3. **wait_for_less_busy_worker is now default, meaning lower latencies for high-utilization servers** `wait_for_less_busy_worker` was an experimental feature in Puma 5 and it's now the default in Puma 6. This feature makes each Puma child worker in cluster mode wait before listening on the socket, and that wait time is proportional to N * `number_of_threads_responding_to_requests`. This means that it's more likely that a request is picked up by the least-loaded Puma child worker listening on the socket. Many users reported back that this option was stable and decreased average latency, particularly in environments with high load and utilization.

### Experimental Rack 3 Support

[Rack 3 is now out](https://github.com/rack/rack/blob/main/UPGRADE-GUIDE.md) and we've started on Rack 3 support. Please open a bug if you find any incompatibilites.

### Sidekiq 7 Capsules

Sidekiq 7 (releasing soon) introduces Capsules, which allows you to run a Sidekiq server inside your Puma server (or any other Ruby process for that matter). We've added support by allowing you to pass data into `run_hooks`, see [issue #2915](https://github.com/puma/puma/issues/2915).

## Upgrade

Check the following list to see if you're depending on any of these behaviors:

1. Configuration constants like `DefaultRackup` removed, see [#2928](https://github.com/puma/puma/pull/2928/files#diff-2dc4e3e83be7fd97cebc482ae07d6a8216944003de82458783fb00b5ae9524c8) for the full list.
1. We have changed the names of the following environment variables: `DISABLE_SSL` is now `PUMA_DISABLE_SSL`, `MAKE_WARNINGS_INTO_ERRORS` is now `PUMA_MAKE_WARNINGS_INTO_ERRORS`, and `WAIT_FOR_LESS_BUSY_WORKERS` is now `PUMA_WAIT_FOR_LESS_BUSY_WORKERS`.
1. Nakayoshi GC (`nakayoshi_fork` option in config) has been removed without replacement.
1. `wait_for_less_busy_worker` is now on by default. If you don't want to use this feature, you must add `wait_for_less_busy_worker false` in your config.
1. We've removed the following public methods on Puma::Server: `Puma::Server#min_threads`, `Puma::Server#max_threads`. Instead, you can pass in configuration as an option to Puma::Server#new. This might make certain gems break (`capybara` for example).
1. We've removed the following constants: `Puma::StateFile::FIELDS`, `Puma::CLI::KEYS_NOT_TO_PERSIST_IN_STATE` and `Puma::Launcher::KEYS_NOT_TO_PERSIST_IN_STATE`, and `Puma::ControlCLI::COMMANDS`.
1. We no longer support Ruby 2.2, 2.3, or JRuby on Java 1.7 or below.
1. The behavior of `remote_addr` has changed. When using the set_remote_address header: "header_name" functionality, if the header is not passed, REMOTE_ADDR is now set to the physical peeraddr instead of always being set to 127.0.0.1. When an error occurs preventing the physical peeraddr from being fetched, REMOTE_ADDR is now set to the unspecified source address ('0.0.0.0') instead of to '127.0.0.1'
1. Previously, Puma supported anything as an HTTP method and passed it to the app. We now only accept the following 8 HTTP methods, based on [RFC 9110, section 9.1](https://www.rfc-editor.org/rfc/rfc9110.html#section-9.1).  The [IANA HTTP Method Registry](https://www.iana.org/assignments/http-methods/http-methods.xhtml) contains a full list of HTTP methods.
   ```
   HEAD GET POST PUT DELETE OPTIONS TRACE PATCH
   ```
   As of Puma 6.2, these can be overridden by `supported_http_methods` in your config file, see `Puma::DSL#supported_http_methods`.

Then, update your Gemfile:

`gem 'puma', '< 7'`
