---
title: Overview For Getting Started
---

# Overview for getting started
This page serves as a checklist or overview for the getting started part of Hydrus. It is recommended to read at least all of the getting started pages, but if you want to head to some specific section directly go ahead and do so.

## The client
Have a look at [getting started with files](getting_started_files.md) to get an overview of the Hydrus client.

## Local files
If you already have many local files, either downloaded by hand or by some other downloader tool, head to the [getting started importing](getting_started_importing.md) section to begin importing them.

## Downloading
If you want to download with Hydrus, check out [getting started with downloading](getting_started_downloading.md). If you want to add the ability to download from sites not already available in Hydrus by default, check out [adding new downloaders](adding_new_downloaders.md) for how and a link to a user-maintained archive of downloaders.

## Tags and ratings
If you have imported and/or downloaded some files and want to get started searching and tagging see [searching and sorting](getting_started_searching.md) and [getting started with ratings](getting_started_ratings.md).

It is also worth having a look at [siblings](advanced_siblings.md) for when you want to consolidate different tags that all mean the same thing, common misspellings, or preferential differences into one tag.  

[Parents](advanced_parents.md) are for when you want a tag to always add another tag. Commonly used for characters since you would usually want to add the series they're from too.

## Duplicates
Have a lot of very similar looking pictures because of one reason or another? Have a look at [duplicates](duplicates.md), Hydrus' duplicates finder and filtering tool.

## API
Hydrus has an API that lets external tools connect to it. See [API](client_api.md) for how to turn it on and a list of some of these tools.
