/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.GroupSendingNotAllowedException;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.SendMessageResults;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.util.CommandUtil;
import org.asamk.signal.util.SendMessageResultUtils;

public class RemoteDeleteCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "remoteDelete";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Remotely delete a previously sent message.");
        subparser.addArgument(new String[]{"-t", "--target-timestamp"}).required(true).type(Long.TYPE).help("Specify the timestamp of the message to delete.");
        subparser.addArgument(new String[]{"-g", "--group-id", "--group"}).help("Specify the recipient group ID.").nargs("*");
        subparser.addArgument(new String[]{"recipient"}).help("Specify the recipients' phone number.").nargs("*");
        subparser.addArgument(new String[]{"-u", "--username"}).help("Specify the recipient username or username link.").nargs("*");
        subparser.addArgument(new String[]{"--note-to-self"}).action((ArgumentAction)Arguments.storeTrue());
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        boolean isNoteToSelf = Boolean.TRUE.equals(ns.getBoolean("note-to-self"));
        List recipientStrings = ns.getList("recipient");
        List usernameStrings = ns.getList("username");
        List groupIdStrings = ns.getList("group-id");
        Set<RecipientIdentifier> recipientIdentifiers = CommandUtil.getRecipientIdentifiers(m, isNoteToSelf, recipientStrings, groupIdStrings, usernameStrings);
        long targetTimestamp = ns.getLong("target-timestamp");
        try {
            SendMessageResults results = m.sendRemoteDeleteMessage(targetTimestamp, recipientIdentifiers);
            SendMessageResultUtils.outputResult(outputWriter, results);
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new UserErrorException(e.getMessage());
        }
        catch (IOException e) {
            throw new UnexpectedErrorException("Failed to send message: " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")", e);
        }
    }
}

