/* This file is part of the KDE project
   SPDX-FileCopyrightText: 2020 Mario Aichinger <aichingm@gmail.com>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#pragma once

#include <KFileItem>
#include <QMenu>

/*
    The KateFileBrowserOpenWithMenu extends a QMenu with a KFileItem property, used to
    pass data of the selected file to the creation of the submenu.
*/

class KateFileBrowserOpenWithMenu : public QMenu
{
    Q_OBJECT
    Q_PROPERTY(KFileItem item READ item WRITE setItem)

public:
    explicit KateFileBrowserOpenWithMenu(const QString &title, QWidget *parent = nullptr);
    ~KateFileBrowserOpenWithMenu() override;

    void setItem(KFileItem item)
    {
        m_item = item;
    }

    KFileItem item()
    {
        return m_item;
    }

public Q_SLOTS:

private Q_SLOTS:

protected:
private:
    KFileItem m_item;
};
