//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1

import (
	unsafe "unsafe"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	configv1 "k8s.io/kubelet/config/v1"
	config "k8s.io/kubernetes/pkg/kubelet/apis/config"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*configv1.CredentialProvider)(nil), (*config.CredentialProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CredentialProvider_To_config_CredentialProvider(a.(*configv1.CredentialProvider), b.(*config.CredentialProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.CredentialProvider)(nil), (*configv1.CredentialProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_CredentialProvider_To_v1_CredentialProvider(a.(*config.CredentialProvider), b.(*configv1.CredentialProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*configv1.CredentialProviderConfig)(nil), (*config.CredentialProviderConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CredentialProviderConfig_To_config_CredentialProviderConfig(a.(*configv1.CredentialProviderConfig), b.(*config.CredentialProviderConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.CredentialProviderConfig)(nil), (*configv1.CredentialProviderConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_CredentialProviderConfig_To_v1_CredentialProviderConfig(a.(*config.CredentialProviderConfig), b.(*configv1.CredentialProviderConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*configv1.ExecEnvVar)(nil), (*config.ExecEnvVar)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ExecEnvVar_To_config_ExecEnvVar(a.(*configv1.ExecEnvVar), b.(*config.ExecEnvVar), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ExecEnvVar)(nil), (*configv1.ExecEnvVar)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ExecEnvVar_To_v1_ExecEnvVar(a.(*config.ExecEnvVar), b.(*configv1.ExecEnvVar), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*configv1.ServiceAccountTokenAttributes)(nil), (*config.ServiceAccountTokenAttributes)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ServiceAccountTokenAttributes_To_config_ServiceAccountTokenAttributes(a.(*configv1.ServiceAccountTokenAttributes), b.(*config.ServiceAccountTokenAttributes), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ServiceAccountTokenAttributes)(nil), (*configv1.ServiceAccountTokenAttributes)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ServiceAccountTokenAttributes_To_v1_ServiceAccountTokenAttributes(a.(*config.ServiceAccountTokenAttributes), b.(*configv1.ServiceAccountTokenAttributes), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_CredentialProvider_To_config_CredentialProvider(in *configv1.CredentialProvider, out *config.CredentialProvider, s conversion.Scope) error {
	out.Name = in.Name
	out.MatchImages = *(*[]string)(unsafe.Pointer(&in.MatchImages))
	out.DefaultCacheDuration = (*metav1.Duration)(unsafe.Pointer(in.DefaultCacheDuration))
	out.APIVersion = in.APIVersion
	out.Args = *(*[]string)(unsafe.Pointer(&in.Args))
	out.Env = *(*[]config.ExecEnvVar)(unsafe.Pointer(&in.Env))
	out.TokenAttributes = (*config.ServiceAccountTokenAttributes)(unsafe.Pointer(in.TokenAttributes))
	return nil
}

// Convert_v1_CredentialProvider_To_config_CredentialProvider is an autogenerated conversion function.
func Convert_v1_CredentialProvider_To_config_CredentialProvider(in *configv1.CredentialProvider, out *config.CredentialProvider, s conversion.Scope) error {
	return autoConvert_v1_CredentialProvider_To_config_CredentialProvider(in, out, s)
}

func autoConvert_config_CredentialProvider_To_v1_CredentialProvider(in *config.CredentialProvider, out *configv1.CredentialProvider, s conversion.Scope) error {
	out.Name = in.Name
	out.MatchImages = *(*[]string)(unsafe.Pointer(&in.MatchImages))
	out.DefaultCacheDuration = (*metav1.Duration)(unsafe.Pointer(in.DefaultCacheDuration))
	out.APIVersion = in.APIVersion
	out.Args = *(*[]string)(unsafe.Pointer(&in.Args))
	out.Env = *(*[]configv1.ExecEnvVar)(unsafe.Pointer(&in.Env))
	out.TokenAttributes = (*configv1.ServiceAccountTokenAttributes)(unsafe.Pointer(in.TokenAttributes))
	return nil
}

// Convert_config_CredentialProvider_To_v1_CredentialProvider is an autogenerated conversion function.
func Convert_config_CredentialProvider_To_v1_CredentialProvider(in *config.CredentialProvider, out *configv1.CredentialProvider, s conversion.Scope) error {
	return autoConvert_config_CredentialProvider_To_v1_CredentialProvider(in, out, s)
}

func autoConvert_v1_CredentialProviderConfig_To_config_CredentialProviderConfig(in *configv1.CredentialProviderConfig, out *config.CredentialProviderConfig, s conversion.Scope) error {
	out.Providers = *(*[]config.CredentialProvider)(unsafe.Pointer(&in.Providers))
	return nil
}

// Convert_v1_CredentialProviderConfig_To_config_CredentialProviderConfig is an autogenerated conversion function.
func Convert_v1_CredentialProviderConfig_To_config_CredentialProviderConfig(in *configv1.CredentialProviderConfig, out *config.CredentialProviderConfig, s conversion.Scope) error {
	return autoConvert_v1_CredentialProviderConfig_To_config_CredentialProviderConfig(in, out, s)
}

func autoConvert_config_CredentialProviderConfig_To_v1_CredentialProviderConfig(in *config.CredentialProviderConfig, out *configv1.CredentialProviderConfig, s conversion.Scope) error {
	out.Providers = *(*[]configv1.CredentialProvider)(unsafe.Pointer(&in.Providers))
	return nil
}

// Convert_config_CredentialProviderConfig_To_v1_CredentialProviderConfig is an autogenerated conversion function.
func Convert_config_CredentialProviderConfig_To_v1_CredentialProviderConfig(in *config.CredentialProviderConfig, out *configv1.CredentialProviderConfig, s conversion.Scope) error {
	return autoConvert_config_CredentialProviderConfig_To_v1_CredentialProviderConfig(in, out, s)
}

func autoConvert_v1_ExecEnvVar_To_config_ExecEnvVar(in *configv1.ExecEnvVar, out *config.ExecEnvVar, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

// Convert_v1_ExecEnvVar_To_config_ExecEnvVar is an autogenerated conversion function.
func Convert_v1_ExecEnvVar_To_config_ExecEnvVar(in *configv1.ExecEnvVar, out *config.ExecEnvVar, s conversion.Scope) error {
	return autoConvert_v1_ExecEnvVar_To_config_ExecEnvVar(in, out, s)
}

func autoConvert_config_ExecEnvVar_To_v1_ExecEnvVar(in *config.ExecEnvVar, out *configv1.ExecEnvVar, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

// Convert_config_ExecEnvVar_To_v1_ExecEnvVar is an autogenerated conversion function.
func Convert_config_ExecEnvVar_To_v1_ExecEnvVar(in *config.ExecEnvVar, out *configv1.ExecEnvVar, s conversion.Scope) error {
	return autoConvert_config_ExecEnvVar_To_v1_ExecEnvVar(in, out, s)
}

func autoConvert_v1_ServiceAccountTokenAttributes_To_config_ServiceAccountTokenAttributes(in *configv1.ServiceAccountTokenAttributes, out *config.ServiceAccountTokenAttributes, s conversion.Scope) error {
	out.ServiceAccountTokenAudience = in.ServiceAccountTokenAudience
	out.RequireServiceAccount = (*bool)(unsafe.Pointer(in.RequireServiceAccount))
	out.RequiredServiceAccountAnnotationKeys = *(*[]string)(unsafe.Pointer(&in.RequiredServiceAccountAnnotationKeys))
	out.OptionalServiceAccountAnnotationKeys = *(*[]string)(unsafe.Pointer(&in.OptionalServiceAccountAnnotationKeys))
	return nil
}

// Convert_v1_ServiceAccountTokenAttributes_To_config_ServiceAccountTokenAttributes is an autogenerated conversion function.
func Convert_v1_ServiceAccountTokenAttributes_To_config_ServiceAccountTokenAttributes(in *configv1.ServiceAccountTokenAttributes, out *config.ServiceAccountTokenAttributes, s conversion.Scope) error {
	return autoConvert_v1_ServiceAccountTokenAttributes_To_config_ServiceAccountTokenAttributes(in, out, s)
}

func autoConvert_config_ServiceAccountTokenAttributes_To_v1_ServiceAccountTokenAttributes(in *config.ServiceAccountTokenAttributes, out *configv1.ServiceAccountTokenAttributes, s conversion.Scope) error {
	out.ServiceAccountTokenAudience = in.ServiceAccountTokenAudience
	out.RequireServiceAccount = (*bool)(unsafe.Pointer(in.RequireServiceAccount))
	out.RequiredServiceAccountAnnotationKeys = *(*[]string)(unsafe.Pointer(&in.RequiredServiceAccountAnnotationKeys))
	out.OptionalServiceAccountAnnotationKeys = *(*[]string)(unsafe.Pointer(&in.OptionalServiceAccountAnnotationKeys))
	return nil
}

// Convert_config_ServiceAccountTokenAttributes_To_v1_ServiceAccountTokenAttributes is an autogenerated conversion function.
func Convert_config_ServiceAccountTokenAttributes_To_v1_ServiceAccountTokenAttributes(in *config.ServiceAccountTokenAttributes, out *configv1.ServiceAccountTokenAttributes, s conversion.Scope) error {
	return autoConvert_config_ServiceAccountTokenAttributes_To_v1_ServiceAccountTokenAttributes(in, out, s)
}
