/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

//
//Copyright 2025 The Kubernetes Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// To regenerate api.pb.go run `hack/update-codegen.sh protobindings`

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v4.23.4
// source: staging/src/k8s.io/externaljwt/apis/v1/api.proto

package v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SignJWTRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// URL-safe base64 wrapped payload to be signed.
	// Exactly as it appears in the second segment of the JWT
	Claims        string `protobuf:"bytes,1,opt,name=claims,proto3" json:"claims,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SignJWTRequest) Reset() {
	*x = SignJWTRequest{}
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SignJWTRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignJWTRequest) ProtoMessage() {}

func (x *SignJWTRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignJWTRequest.ProtoReflect.Descriptor instead.
func (*SignJWTRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescGZIP(), []int{0}
}

func (x *SignJWTRequest) GetClaims() string {
	if x != nil {
		return x.Claims
	}
	return ""
}

type SignJWTResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// header must contain only alg, kid, typ claims.
	// typ must be “JWT”.
	// kid must be non-empty, <=1024 characters, and its corresponding public key should not be excluded from OIDC discovery.
	// alg must be one of the algorithms supported by kube-apiserver (currently RS256, ES256, ES384, ES512).
	// header cannot have any additional data that kube-apiserver does not recognize.
	// Already wrapped in URL-safe base64, exactly as it appears in the first segment of the JWT.
	Header string `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// The signature for the JWT.
	// Already wrapped in URL-safe base64, exactly as it appears in the final segment of the JWT.
	Signature     string `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SignJWTResponse) Reset() {
	*x = SignJWTResponse{}
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SignJWTResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignJWTResponse) ProtoMessage() {}

func (x *SignJWTResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignJWTResponse.ProtoReflect.Descriptor instead.
func (*SignJWTResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescGZIP(), []int{1}
}

func (x *SignJWTResponse) GetHeader() string {
	if x != nil {
		return x.Header
	}
	return ""
}

func (x *SignJWTResponse) GetSignature() string {
	if x != nil {
		return x.Signature
	}
	return ""
}

type FetchKeysRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FetchKeysRequest) Reset() {
	*x = FetchKeysRequest{}
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchKeysRequest) ProtoMessage() {}

func (x *FetchKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchKeysRequest.ProtoReflect.Descriptor instead.
func (*FetchKeysRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescGZIP(), []int{2}
}

type FetchKeysResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Keys  []*Key                 `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// The timestamp when this data was pulled from the authoritative source of
	// truth for verification keys.
	// kube-apiserver can export this from metrics, to enable end-to-end SLOs.
	DataTimestamp *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=data_timestamp,json=dataTimestamp,proto3" json:"data_timestamp,omitempty"`
	// refresh interval for verification keys to pick changes if any.
	// any value <= 0 is considered a misconfiguration.
	RefreshHintSeconds int64 `protobuf:"varint,3,opt,name=refresh_hint_seconds,json=refreshHintSeconds,proto3" json:"refresh_hint_seconds,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *FetchKeysResponse) Reset() {
	*x = FetchKeysResponse{}
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchKeysResponse) ProtoMessage() {}

func (x *FetchKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchKeysResponse.ProtoReflect.Descriptor instead.
func (*FetchKeysResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescGZIP(), []int{3}
}

func (x *FetchKeysResponse) GetKeys() []*Key {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *FetchKeysResponse) GetDataTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.DataTimestamp
	}
	return nil
}

func (x *FetchKeysResponse) GetRefreshHintSeconds() int64 {
	if x != nil {
		return x.RefreshHintSeconds
	}
	return 0
}

type Key struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A unique identifier for this key.
	// Length must be <=1024.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// The public key, PKIX-serialized.
	// must be a public key supported by kube-apiserver (currently RSA 256 or ECDSA 256/384/521)
	Key []byte `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// Set only for keys that are not used to sign bound tokens.
	// eg: supported keys for legacy tokens.
	// If set, key is used for verification but excluded from OIDC discovery docs.
	// if set, external signer should not use this key to sign a JWT.
	ExcludeFromOidcDiscovery bool `protobuf:"varint,3,opt,name=exclude_from_oidc_discovery,json=excludeFromOidcDiscovery,proto3" json:"exclude_from_oidc_discovery,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *Key) Reset() {
	*x = Key{}
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Key) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Key) ProtoMessage() {}

func (x *Key) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Key.ProtoReflect.Descriptor instead.
func (*Key) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescGZIP(), []int{4}
}

func (x *Key) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

func (x *Key) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *Key) GetExcludeFromOidcDiscovery() bool {
	if x != nil {
		return x.ExcludeFromOidcDiscovery
	}
	return false
}

type MetadataRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MetadataRequest) Reset() {
	*x = MetadataRequest{}
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataRequest) ProtoMessage() {}

func (x *MetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataRequest.ProtoReflect.Descriptor instead.
func (*MetadataRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescGZIP(), []int{5}
}

type MetadataResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// used by kube-apiserver for defaulting/validation of JWT lifetime while accounting for configuration flag values:
	// 1. `--service-account-max-token-expiration`
	// 2. `--service-account-extend-token-expiration`
	//
	// * If `--service-account-max-token-expiration` is greater than `max_token_expiration_seconds`, kube-apiserver treats that as misconfiguration and exits.
	// * If `--service-account-max-token-expiration` is not explicitly set, kube-apiserver defaults to `max_token_expiration_seconds`.
	// * If `--service-account-extend-token-expiration` is true, the extended expiration is `min(1 year, max_token_expiration_seconds)`.
	//
	// `max_token_expiration_seconds` must be at least 600s.
	MaxTokenExpirationSeconds int64 `protobuf:"varint,1,opt,name=max_token_expiration_seconds,json=maxTokenExpirationSeconds,proto3" json:"max_token_expiration_seconds,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *MetadataResponse) Reset() {
	*x = MetadataResponse{}
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataResponse) ProtoMessage() {}

func (x *MetadataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataResponse.ProtoReflect.Descriptor instead.
func (*MetadataResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescGZIP(), []int{6}
}

func (x *MetadataResponse) GetMaxTokenExpirationSeconds() int64 {
	if x != nil {
		return x.MaxTokenExpirationSeconds
	}
	return 0
}

var File_staging_src_k8s_io_externaljwt_apis_v1_api_proto protoreflect.FileDescriptor

var file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDesc = string([]byte{
	0x0a, 0x30, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x73, 0x72, 0x63, 0x2f, 0x6b, 0x38,
	0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x6a, 0x77, 0x74,
	0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x02, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x28, 0x0a, 0x0e, 0x53, 0x69, 0x67, 0x6e, 0x4a,
	0x57, 0x54, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6c, 0x61,
	0x69, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6c, 0x61, 0x69, 0x6d,
	0x73, 0x22, 0x47, 0x0a, 0x0f, 0x53, 0x69, 0x67, 0x6e, 0x4a, 0x57, 0x54, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x12, 0x0a, 0x10, 0x46, 0x65,
	0x74, 0x63, 0x68, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xa5,
	0x01, 0x0a, 0x11, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x07, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b, 0x65, 0x79,
	0x73, 0x12, 0x41, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x12, 0x30, 0x0a, 0x14, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x5f,
	0x68, 0x69, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x12, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x48, 0x69, 0x6e, 0x74, 0x53,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22, 0x6d, 0x0a, 0x03, 0x4b, 0x65, 0x79, 0x12, 0x15, 0x0a,
	0x06, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6b,
	0x65, 0x79, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x1b, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x4f, 0x69, 0x64, 0x63, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x22, 0x11, 0x0a, 0x0f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x53, 0x0a, 0x10, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x1c,
	0x6d, 0x61, 0x78, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x19, 0x6d, 0x61, 0x78, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x78, 0x70, 0x69,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x32, 0xbb, 0x01,
	0x0a, 0x11, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4a, 0x57, 0x54, 0x53, 0x69, 0x67,
	0x6e, 0x65, 0x72, 0x12, 0x31, 0x0a, 0x04, 0x53, 0x69, 0x67, 0x6e, 0x12, 0x12, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x69, 0x67, 0x6e, 0x4a, 0x57, 0x54, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x13, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x4a, 0x57, 0x54, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x3a, 0x0a, 0x09, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4b,
	0x65, 0x79, 0x73, 0x12, 0x14, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4b, 0x65,
	0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x65, 0x74, 0x63, 0x68, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x37, 0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x13,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x14, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x1c, 0x5a, 0x1a, 0x6b,
	0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x6a, 0x77,
	0x74, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
})

var (
	file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescOnce sync.Once
	file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescData []byte
)

func file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescGZIP() []byte {
	file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescOnce.Do(func() {
		file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDesc), len(file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDesc)))
	})
	return file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDescData
}

var file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_goTypes = []any{
	(*SignJWTRequest)(nil),        // 0: v1.SignJWTRequest
	(*SignJWTResponse)(nil),       // 1: v1.SignJWTResponse
	(*FetchKeysRequest)(nil),      // 2: v1.FetchKeysRequest
	(*FetchKeysResponse)(nil),     // 3: v1.FetchKeysResponse
	(*Key)(nil),                   // 4: v1.Key
	(*MetadataRequest)(nil),       // 5: v1.MetadataRequest
	(*MetadataResponse)(nil),      // 6: v1.MetadataResponse
	(*timestamppb.Timestamp)(nil), // 7: google.protobuf.Timestamp
}
var file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_depIdxs = []int32{
	4, // 0: v1.FetchKeysResponse.keys:type_name -> v1.Key
	7, // 1: v1.FetchKeysResponse.data_timestamp:type_name -> google.protobuf.Timestamp
	0, // 2: v1.ExternalJWTSigner.Sign:input_type -> v1.SignJWTRequest
	2, // 3: v1.ExternalJWTSigner.FetchKeys:input_type -> v1.FetchKeysRequest
	5, // 4: v1.ExternalJWTSigner.Metadata:input_type -> v1.MetadataRequest
	1, // 5: v1.ExternalJWTSigner.Sign:output_type -> v1.SignJWTResponse
	3, // 6: v1.ExternalJWTSigner.FetchKeys:output_type -> v1.FetchKeysResponse
	6, // 7: v1.ExternalJWTSigner.Metadata:output_type -> v1.MetadataResponse
	5, // [5:8] is the sub-list for method output_type
	2, // [2:5] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_init() }
func file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_init() {
	if File_staging_src_k8s_io_externaljwt_apis_v1_api_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDesc), len(file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_goTypes,
		DependencyIndexes: file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_depIdxs,
		MessageInfos:      file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_msgTypes,
	}.Build()
	File_staging_src_k8s_io_externaljwt_apis_v1_api_proto = out.File
	file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_goTypes = nil
	file_staging_src_k8s_io_externaljwt_apis_v1_api_proto_depIdxs = nil
}
