/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoadingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoadingUtil.class);

    private ClassLoadingUtil() {
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className, true, ClassLoadingUtil.getClassloader());
        }
        catch (Exception e) {
            LOG.warn("Could not load class with current threads context classloader. Using default. Reason: {}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return Class.forName(className);
        }
    }

    public static ClassLoader getClassloader() {
        return ClassLoadingUtil.class.getClassLoader();
    }
}

