/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.interpreter;

import com.google.inject.Inject;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.impl.XbaseInterpreter;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.model.script.engine.ScriptError;
import org.openhab.core.model.script.engine.ScriptExecutionException;
import org.openhab.core.model.script.lib.NumberExtensions;
import org.openhab.core.model.script.scoping.StateAndCommandProvider;
import org.openhab.core.model.script.script.QuantityLiteral;
import org.openhab.core.types.Type;

public class ScriptInterpreter
extends XbaseInterpreter {
    @Inject
    private ItemRegistry itemRegistry;
    @Inject
    private StateAndCommandProvider stateAndCommandProvider;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    @Extension
    private IJvmModelAssociations _iJvmModelAssociations;

    protected Object _invokeFeature(JvmField jvmField, XAbstractFeatureCall featureCall, Object receiver, IEvaluationContext context, CancelIndicator indicator) {
        Object _xblockexpression = null;
        EObject sourceElement = (EObject)IterableExtensions.head((Iterable)this._iJvmModelAssociations.getSourceElements((EObject)jvmField));
        Object _xifexpression = null;
        if (sourceElement != null) {
            Object _xblockexpression_1 = null;
            Object value = context.getValue(QualifiedName.create((String)jvmField.getSimpleName()));
            Object _elvis = null;
            if (value != null) {
                _elvis = value;
            } else {
                Type _xblockexpression_2 = null;
                String fieldName = jvmField.getSimpleName();
                Type _elvis_1 = null;
                Type _stateOrCommand = this.getStateOrCommand(fieldName);
                if (_stateOrCommand != null) {
                    _elvis_1 = _stateOrCommand;
                } else {
                    Item _item = this.getItem(fieldName);
                    _elvis_1 = _item;
                }
                _xblockexpression_2 = _elvis_1;
                _elvis = _xblockexpression_2;
            }
            _xifexpression = _xblockexpression_1 = _elvis;
        } else {
            _xifexpression = super._invokeFeature(jvmField, featureCall, receiver, context, indicator);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected Object invokeFeature(JvmIdentifiableElement feature, XAbstractFeatureCall featureCall, Object receiverObj, IEvaluationContext context, CancelIndicator indicator) {
        try {
            Object _xblockexpression = null;
            if (feature != null && feature.eIsProxy()) {
                if (featureCall instanceof XMemberFeatureCall) {
                    XExpression expression = ((XMemberFeatureCall)featureCall).getMemberCallTarget();
                    IResolvedTypes _resolveTypes = this.typeResolver.resolveTypes((EObject)expression);
                    LightweightTypeReference _actualType = null;
                    if (_resolveTypes != null) {
                        _actualType = _resolveTypes.getActualType(expression);
                    }
                    String _identifier = null;
                    if (_actualType != null) {
                        _identifier = _actualType.getIdentifier();
                    }
                    String type = _identifier;
                    String _concreteSyntaxFeatureName = ((XMemberFeatureCall)featureCall).getConcreteSyntaxFeatureName();
                    String _plus = "'" + _concreteSyntaxFeatureName;
                    String _plus_1 = _plus + "' is not a member of '";
                    String _plus_2 = _plus_1 + type;
                    String _plus_3 = _plus_2 + "'";
                    ScriptError _scriptError = new ScriptError(_plus_3, (EObject)featureCall);
                    throw new ScriptExecutionException(_scriptError);
                }
                if (featureCall instanceof XFeatureCall) {
                    String _concreteSyntaxFeatureName_1 = ((XFeatureCall)featureCall).getConcreteSyntaxFeatureName();
                    String _plus_4 = "The name '" + _concreteSyntaxFeatureName_1;
                    String _plus_5 = _plus_4 + "' cannot be resolved to an item or type";
                    ScriptError _scriptError_1 = new ScriptError(_plus_5, (EObject)featureCall);
                    throw new ScriptExecutionException(_scriptError_1);
                }
                String _concreteSyntaxFeatureName_2 = featureCall.getConcreteSyntaxFeatureName();
                String _plus_6 = "Unknown variable or command '" + _concreteSyntaxFeatureName_2;
                String _plus_7 = _plus_6 + "'";
                ScriptError _scriptError_2 = new ScriptError(_plus_7, (EObject)featureCall);
                throw new ScriptExecutionException(_scriptError_2);
            }
            _xblockexpression = super.invokeFeature(feature, featureCall, receiverObj, context, indicator);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Type getStateOrCommand(String name) {
        Iterable<Type> _allTypes = this.stateAndCommandProvider.getAllTypes();
        for (Type type : _allTypes) {
            String _string = type.toString();
            boolean _equals = Objects.equals(_string, name);
            if (!_equals) continue;
            return type;
        }
        return null;
    }

    protected Item getItem(String name) {
        try {
            return this.itemRegistry.getItem(name);
        }
        catch (Throwable _t) {
            if (_t instanceof ItemNotFoundException) {
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected boolean eq(Object a, Object b) {
        if (a instanceof Type && b instanceof Number) {
            return NumberExtensions.operator_equals((Type)a, (Number)b);
        }
        if (a instanceof Number && b instanceof Type) {
            return NumberExtensions.operator_equals((Type)b, (Number)a);
        }
        return super.eq(a, b);
    }

    public Object _assignValueTo(JvmField jvmField, XAbstractFeatureCall assignment, Object value, IEvaluationContext context, CancelIndicator indicator) {
        Object _xblockexpression = null;
        EObject sourceElement = (EObject)IterableExtensions.head((Iterable)this._iJvmModelAssociations.getSourceElements((EObject)jvmField));
        Object _xifexpression = null;
        if (sourceElement != null) {
            Object _xblockexpression_1 = null;
            context.assignValue(QualifiedName.create((String)jvmField.getSimpleName()), value);
            _xifexpression = _xblockexpression_1 = value;
        } else {
            _xifexpression = super._assignValueTo(jvmField, assignment, value, context, indicator);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected Object doEvaluate(XExpression expression, IEvaluationContext context, CancelIndicator indicator) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof QuantityLiteral) {
            return this.doEvaluate((QuantityLiteral)expression, context, indicator);
        }
        return super.doEvaluate(expression, context, indicator);
    }

    protected Object doEvaluate(QuantityLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        String _value = literal.getValue();
        String _plus = _value + " ";
        String _value_1 = literal.getUnit().getValue();
        String _plus_1 = _plus + _value_1;
        return QuantityType.valueOf((String)_plus_1);
    }

    public Object _doEvaluate(XCastedExpression castedExpression, IEvaluationContext context, CancelIndicator indicator) {
        try {
            return super._doEvaluate(castedExpression, context, indicator);
        }
        catch (Throwable _t) {
            try {
                if (_t instanceof RuntimeException) {
                    RuntimeException e = (RuntimeException)_t;
                    Throwable _cause = e.getCause();
                    if (_cause instanceof ClassCastException) {
                        Object result = this.internalEvaluate(castedExpression.getTarget(), context, indicator);
                        String _qualifiedName = castedExpression.getType().getType().getQualifiedName();
                        String _plus = "Could not cast " + String.valueOf(result) + " to " + _qualifiedName;
                        ScriptError _scriptError = new ScriptError(_plus, (EObject)castedExpression);
                        throw new ScriptExecutionException(_scriptError);
                    }
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }
}

