/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.utils.IStringPoolParticipant;
import org.eclipse.core.internal.utils.StringPool;

public class MarkerAttributeMap
implements IStringPoolParticipant {
    private final AtomicReference<Map<String, Object>> mapRef;
    protected static final int DEFAULT_SIZE = 9;

    public MarkerAttributeMap() {
        this(9);
    }

    public MarkerAttributeMap(int initialCapacity) {
        this.mapRef = new AtomicReference(Map.of());
    }

    public MarkerAttributeMap(MarkerAttributeMap m) {
        this.mapRef = new AtomicReference<Map<String, Object>>(this.copy(m.getMap()));
    }

    public MarkerAttributeMap(Map<String, ? extends Object> map, boolean validate) {
        this.mapRef = new AtomicReference<Map<String, Object>>(this.copy(map, validate));
    }

    public void setAttributes(Map<String, ? extends Object> map, boolean validate) {
        this.mapRef.set(this.copy(map, validate));
    }

    private Map<String, Object> copy(Map<String, ? extends Object> map, boolean validate) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        this.putAll(target, map, validate);
        return target;
    }

    public void putAll(Map<String, ? extends Object> map, boolean validate) {
        this.mapRef.getAndUpdate(old -> {
            Map<String, Object> copy = this.copy((Map<String, ? extends Object>)old);
            this.putAll(copy, map, validate);
            return copy;
        });
    }

    private void putAll(Map<String, Object> target, Map<String, ? extends Object> source, boolean validate) {
        if (source == null) {
            return;
        }
        for (Map.Entry<String, ? extends Object> e : source.entrySet()) {
            String key = e.getKey();
            Objects.requireNonNull(key, "insert of null key not allowed");
            Object value = e.getValue();
            if (validate) {
                value = MarkerInfo.checkValidAttribute(value);
            }
            if (value == null) continue;
            target.put(e.getKey().intern(), value);
        }
    }

    private Map<String, Object> copy(Map<String, ? extends Object> map) {
        return new HashMap<String, Object>(map);
    }

    private Map<String, Object> getMap() {
        return this.mapRef.get();
    }

    public Map<String, Object> toMap() {
        return this.copy(this.getMap());
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.getMap().entrySet();
    }

    public void put(String k, Object value) {
        Objects.requireNonNull(k, "insert of null key not allowed");
        Objects.requireNonNull(value, "insert of null value not allowed");
        this.mapRef.getAndUpdate(map -> {
            Map<String, Object> m = this.copy((Map<String, ? extends Object>)map);
            m.put(k.intern(), value);
            return m;
        });
    }

    @Override
    public void shareStrings(StringPool set) {
        for (Map.Entry<String, Object> e : this.getMap().entrySet()) {
            Object o = e.getValue();
            if (o instanceof String) {
                e.setValue(set.add((String)o));
                continue;
            }
            if (!(o instanceof IStringPoolParticipant)) continue;
            ((IStringPoolParticipant)o).shareStrings(set);
        }
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public Object remove(Object key) {
        return this.getMap().remove(key);
    }

    public Object get(Object key) {
        return this.getMap().get(key);
    }

    public int size() {
        return this.getMap().size();
    }
}

