/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.ext.vertica.model.VerticaTable;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class VerticaSystemTable
extends VerticaTable {
    private boolean isSuperUserOnly;
    private boolean isMonitorable;
    private boolean isAccessibleDuringLockdown;
    private String description;

    public VerticaSystemTable(VerticaSchema container, String tableName, String tableType, JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
        if (dbResult != null) {
            this.isSuperUserOnly = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_superuser_only");
            this.isMonitorable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_monitorable");
            this.isAccessibleDuringLockdown = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_accessible_during_lockdown");
            this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"remarks");
        }
    }

    @Property(viewable=true, order=5)
    public boolean isSuperUserOnly() {
        return this.isSuperUserOnly;
    }

    @Property(viewable=true, order=6)
    public boolean isMonitorable() {
        return this.isMonitorable;
    }

    @Property(viewable=true, order=7)
    public boolean isAccessibleDuringLockdown() {
        return this.isAccessibleDuringLockdown;
    }

    @Override
    public String getPartitionExpression() {
        return super.getPartitionExpression();
    }

    @Override
    public Date getCreateTime() {
        return super.getCreateTime();
    }

    @Override
    public boolean isTempTable() {
        return super.isTempTable();
    }

    @Override
    public boolean isHasAggregateProjection() {
        return super.isHasAggregateProjection();
    }

    @Override
    @Property(viewable=true, editable=false, updatable=false, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getDescription(DBRProgressMonitor monitor) throws DBException {
        return this.description;
    }

    @Override
    public boolean isSystem() {
        return true;
    }
}

