/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHSessionControllerDescriptor;

public class SSHSessionControllerRegistry {
    private static SSHSessionControllerRegistry instance = null;
    private final List<SSHSessionControllerDescriptor> descriptors = new ArrayList<SSHSessionControllerDescriptor>();

    public static synchronized SSHSessionControllerRegistry getInstance() {
        if (instance == null) {
            instance = new SSHSessionControllerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SSHSessionControllerRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.net.ssh");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            SSHSessionControllerDescriptor descriptor = new SSHSessionControllerDescriptor(ext);
            this.descriptors.add(descriptor);
            ++n2;
        }
    }

    public List<SSHSessionControllerDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public SSHSessionControllerDescriptor getDescriptor(String id) {
        for (SSHSessionControllerDescriptor desc : this.descriptors) {
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }
}

