/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.ui.controls;

import java.sql.SQLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.cubrid.ui.internal.CubridMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.utils.CommonUtils;

public class CubridInfoPanel
implements IResultSetPanel {
    private static final Log log = Log.getLog(CubridInfoPanel.class);
    private Table table;
    private Composite control;
    private Text plainText;
    private Text statisticInfo;
    private IResultSetPresentation presentation;

    public void contributeActions(IContributionManager manager) {
    }

    public Control createContents(IResultSetPresentation presentation, Composite parent) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.presentation = presentation;
        this.control = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.control.setLayoutData((Object)new GridData(1808));
        CustomSashForm planPanel = new CustomSashForm(this.control, 512);
        planPanel.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        planPanel.setLayout((Layout)gl);
        if (!CommonUtils.isEmpty((String)store.getString("statistic"))) {
            this.table = new Table((Composite)planPanel, 65538);
            this.table.setLinesVisible(!UIStyles.isDarkTheme());
            this.table.setHeaderVisible(true);
            this.table.setLayoutData((Object)new GridData(1808));
            UIUtils.createTableColumn((Table)this.table, (int)16384, (String)"Name");
            UIUtils.createTableColumn((Table)this.table, (int)16384, (String)"Value");
        } else {
            this.statisticInfo = new Text((Composite)planPanel, 2634);
            this.statisticInfo.setText(String.format(CubridMessages.statistic_instruction_message, CubridMessages.statistic_info + "|" + CubridMessages.statistic_all_info));
        }
        this.plainText = new Text((Composite)planPanel, 2634);
        this.plainText.setText(String.format(CubridMessages.statistic_instruction_message, CubridMessages.statistic_trace_info));
        return this.control;
    }

    public boolean isDirty() {
        return false;
    }

    public void activatePanel() {
        this.refreshResult();
    }

    public void deactivatePanel() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.dispose();
        }
    }

    public void setFocus() {
        this.control.setFocus();
    }

    public void refresh(boolean force) {
        this.refreshResult();
    }

    @Nullable
    private String getStatisticQuery() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        if (store.getString("statistic").equals("statistic_info")) {
            return "show exec statistics;";
        }
        if (store.getString("statistic").equals("statistic_all_info")) {
            return "show exec statistics all;";
        }
        return null;
    }

    private void showStatistic(JDBCStatement stm, String queryInfo) throws SQLException {
        this.table.removeAll();
        stm.execute(this.presentation.getController().getContainer().toString());
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCResultSet resultSet = stm.executeQuery(queryInfo);){
            while (resultSet.next()) {
                TableItem item = new TableItem(this.table, 16384);
                item.setText(0, resultSet.getString("variable"));
                item.setText(1, resultSet.getString("value"));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        UIUtils.packColumns((Table)this.table);
    }

    private void refreshResult() {
        final DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        new AbstractJob("Read Statistic"){

            protected IStatus run(DBRProgressMonitor monitor) {
                UIUtils.syncExec(() -> {
                    block31: {
                        try {
                            Throwable throwable = null;
                            Object var4_6 = null;
                            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)CubridInfoPanel.this.presentation.getController().getDataContainer().getDataSource(), (String)"Read Statistic");){
                                Throwable throwable2 = null;
                                Object var7_11 = null;
                                try (JDBCStatement stm = session.createStatement();){
                                    String statisticQuery = CubridInfoPanel.this.getStatisticQuery();
                                    if (CommonUtils.isNotEmpty((String)statisticQuery)) {
                                        CubridInfoPanel.this.showStatistic(stm, statisticQuery);
                                    }
                                    if (!store.getBoolean("statistic_trace")) break block31;
                                    stm.execute(CubridInfoPanel.this.presentation.getController().getContainer().toString());
                                    Throwable throwable3 = null;
                                    Object var11_17 = null;
                                    try (JDBCResultSet resultSet = stm.executeQuery("show trace;");){
                                        if (resultSet.next()) {
                                            String st = resultSet.getString("trace");
                                            CubridInfoPanel.this.plainText.setText(st);
                                        }
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable3 == null) {
                                            throwable3 = throwable4;
                                        } else if (throwable3 != throwable4) {
                                            throwable3.addSuppressed(throwable4);
                                        }
                                        throw throwable3;
                                    }
                                }
                                catch (Throwable throwable5) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable5;
                                    } else if (throwable2 != throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                    throw throwable2;
                                }
                            }
                            catch (Throwable throwable6) {
                                if (throwable == null) {
                                    throwable = throwable6;
                                } else if (throwable != throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                throw throwable;
                            }
                        }
                        catch (SQLException | DBCException e) {
                            log.error((Object)"could not read statistic", e);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

