/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.transformers.ComplexTypeAttributeTransformer;
import org.jkiss.dbeaver.model.impl.data.transformers.MapAttributeTransformer;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;

public class ArrayAttributeTransformer
implements DBDAttributeTransformer {
    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        DBSDataType componentType;
        if (!session.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.transform.complex.type")) {
            return;
        }
        DBSDataType collectionType = attribute.getAttribute() instanceof DBSTypedObjectEx ? ((DBSTypedObjectEx)((Object)attribute.getAttribute())).getDataType() : DBUtils.resolveDataType(session.getProgressMonitor(), session.getDataSource(), attribute.getTypeName());
        if (collectionType != null && (componentType = collectionType.getComponentType(session.getProgressMonitor())) instanceof DBSEntity) {
            ComplexTypeAttributeTransformer.createNestedTypeBindings(session, attribute, rows, componentType);
            return;
        }
        MapAttributeTransformer.resolveMapsFromData(session, attribute, rows);
    }
}

