/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinPluginAction;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public abstract class AbstractUIPlugin
extends Plugin {
    private volatile ScopedPreferenceStore preferenceStore;
    private ImageRegistry imageRegistry;
    private BundleListener bundleListener;

    protected ImageRegistry createImageRegistry() {
        if (PlatformUI.isWorkbenchRunning()) {
            return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        throw new SWTError(22);
    }

    public IDialogSettings getDialogSettings() {
        return PlatformUI.getDialogSettingsProvider(this.getBundle()).getDialogSettings();
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = this.createImageRegistry();
            this.initializeImageRegistry(this.imageRegistry);
        }
        return this.imageRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPreferenceStore getPreferenceStore() {
        ScopedPreferenceStore result = this.preferenceStore;
        if (result == null) {
            AbstractUIPlugin abstractUIPlugin = this;
            synchronized (abstractUIPlugin) {
                result = this.preferenceStore;
                if (result == null) {
                    this.preferenceStore = result = new ScopedPreferenceStore(InstanceScope.INSTANCE, this.getBundle().getSymbolicName());
                }
            }
        }
        return result;
    }

    @Deprecated(forRemoval=true, since="2025-03")
    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    @Deprecated(forRemoval=true, since="2025-03")
    protected void initializeDefaultPreferences(IPreferenceStore store) {
    }

    @Deprecated(forRemoval=true, since="2025-03")
    protected void initializeDefaultPluginPreferences() {
        this.loadPreferenceStore();
        this.initializeDefaultPreferences(this.getPreferenceStore());
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
    }

    @Deprecated(forRemoval=true, since="2025-03")
    protected void loadDialogSettings() {
        PlatformUI.getDialogSettingsProvider(this.getBundle()).loadDialogSettings();
    }

    @Deprecated(forRemoval=true, since="2025-03")
    protected void loadPreferenceStore() {
    }

    protected void refreshPluginActions() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        Display.getDefault().asyncExec(WWinPluginAction::refreshActionList);
    }

    @Deprecated(forRemoval=true, since="2025-03")
    protected void saveDialogSettings() {
        PlatformUI.getDialogSettingsProvider(this.getBundle()).saveDialogSettings();
    }

    @Deprecated(forRemoval=true, since="2025-03")
    protected void savePreferenceStore() {
        this.savePluginPreferences();
    }

    @Deprecated(forRemoval=true, since="2025-03")
    public void startup() throws CoreException {
        super.startup();
    }

    @Deprecated(forRemoval=true, since="2025-03")
    public void shutdown() throws CoreException {
        super.shutdown();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        final BundleContext fc = context;
        this.bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == AbstractUIPlugin.this.getBundle() && event.getType() == 2) {
                    if (AbstractUIPlugin.this.getBundle().getState() == 32) {
                        AbstractUIPlugin.this.refreshPluginActions();
                    }
                    try {
                        fc.removeBundleListener((BundleListener)this);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
        };
        context.addBundleListener(this.bundleListener);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.bundleListener != null) {
                context.removeBundleListener(this.bundleListener);
            }
            this.savePreferenceStore();
            this.preferenceStore = null;
            if (this.imageRegistry != null) {
                this.imageRegistry.dispose();
            }
            this.imageRegistry = null;
        }
        finally {
            super.stop(context);
        }
    }

    public static ImageDescriptor imageDescriptorFromPlugin(String pluginId, String imageFilePath) {
        ImageDescriptor imageDescriptor;
        if (pluginId == null || imageFilePath == null) {
            throw new IllegalArgumentException();
        }
        IWorkbench workbench = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench() : null;
        ImageDescriptor imageDescriptor2 = imageDescriptor = workbench == null ? null : workbench.getSharedImages().getImageDescriptor(imageFilePath);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (!BundleUtility.isReady(bundle)) {
            return null;
        }
        return ResourceLocator.imageDescriptorFromBundle((String)pluginId, (String)imageFilePath).orElse(null);
    }
}

