/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class FileSystemExporter {
    public void createFolder(IPath destinationPath) {
        new File(destinationPath.toOSString()).mkdir();
    }

    public void write(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }

    protected void writeChildren(IContainer folder, IPath destinationPath) throws CoreException, IOException {
        if (folder.isAccessible()) {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                this.writeResource(child, destinationPath.append(child.getName()));
                ++n2;
            }
        }
    }

    protected void writeFile(IFile file, IPath destinationPath) throws CoreException, IOException {
        IPath sourceLocation = file.getLocation();
        if (sourceLocation != null) {
            Files.copy(sourceLocation.toFile().toPath(), destinationPath.toFile().toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
        } else {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedInputStream is = new BufferedInputStream(file.getContents(false));){
                Throwable throwable2 = null;
                Object var8_11 = null;
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destinationPath.toOSString()));){
                    ((InputStream)is).transferTo(os);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    protected void writeResource(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.createFolder(destinationPath);
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }
}

