/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionDummyContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.utils.Pair;

public class SQLQuerySemanticUtils {
    private static final Log log = Log.getLog(SQLQuerySemanticUtils.class);
    private static final Set<DBSObjectType> knownObjectTypes = Set.of(RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_SCHEMA, RelationalObjectType.TYPE_CATALOG, RelationalObjectType.TYPE_VIEW, RelationalObjectType.TYPE_TABLE_COLUMN, RelationalObjectType.TYPE_INDEX, RelationalObjectType.TYPE_CONSTRAINT, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_SEQUENCE, RelationalObjectType.TYPE_TRIGGER, RelationalObjectType.TYPE_DATA_TYPE, RelationalObjectType.TYPE_PACKAGE, RelationalObjectType.TYPE_SYNONYM);

    private SQLQuerySemanticUtils() {
    }

    public static void performPartialResolution(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics, @NotNull SQLQueryComplexName name, @NotNull SQLQuerySymbolOrigin origin, @NotNull Set<DBSObjectType> objectTypes, @NotNull SQLQuerySymbolClass entityNameClass) {
        if (!statistics.useRealMetadata() || context.getConnectionInfo().isDummy()) {
            return;
        }
        int namePartsCount = name.invalidPartsCount == 0 ? name.parts.size() : name.parts.indexOf(null);
        DBSObject object = null;
        List<String> fragmentStrings = null;
        int len = namePartsCount;
        while (len > 0 && object == null) {
            fragmentStrings = name.stringParts.subList(0, len);
            List<DBSObject> objs = context.getConnectionInfo().findRealObjects(statistics.getMonitor(), RelationalObjectType.TYPE_UNKNOWN, fragmentStrings).stream().filter(o -> objectTypes.stream().anyMatch(t -> t.getTypeClass().isAssignableFrom(o.getClass()))).toList();
            if (objs.size() == 1) {
                object = objs.getFirst();
            } else if (objs.size() > 1) {
                SQLQuerySymbolEntry ambiguousEntry = name.parts.get(len - 1);
                ambiguousEntry.getSymbol().setSymbolClass(SQLQuerySymbolClass.ERROR);
                Set names = objs.stream().map(SQLQuerySemanticUtils::getObjectUniqueName).collect(Collectors.toSet());
                statistics.appendWarning(ambiguousEntry, "Ambiguous identifier: " + String.join((CharSequence)" vs ", names));
            }
            --len;
        }
        if (object != null && !fragmentStrings.isEmpty()) {
            List<SQLQuerySymbolEntry> nameFragment = name.parts.subList(0, fragmentStrings.size());
            SQLQuerySemanticUtils.setNamePartsDefinition(nameFragment, object, SQLQuerySemanticUtils.inferSymbolClass(object), origin);
            if (name.parts.size() > nameFragment.size()) {
                SQLQuerySymbolEntry part = name.parts.get(nameFragment.size());
                SQLQuerySymbolOrigin.DbObjectFromDbObject lastPartOrigin = new SQLQuerySymbolOrigin.DbObjectFromDbObject(object, objectTypes);
                if (part != null) {
                    part.setOrigin(lastPartOrigin);
                } else if (name.parts.size() == nameFragment.size() + 1 && name.endingPeriodNode != null) {
                    name.endingPeriodNode.setOrigin(lastPartOrigin);
                }
            }
        } else if (!name.parts.isEmpty()) {
            name.parts.getFirst().setOrigin(origin);
        }
        if (name.parts.getLast() != null && name.parts.getLast().isNotClassified()) {
            name.parts.getLast().getSymbol().setSymbolClass(entityNameClass);
        }
    }

    public static void setNamePartsDefinition(@NotNull SQLQueryComplexName name, @NotNull DBSObject realObject, @NotNull SQLQuerySymbolOrigin origin) {
        SQLQuerySymbolClass entityNameClass = SQLQuerySemanticUtils.inferSymbolClass(realObject);
        SQLQuerySemanticUtils.setNamePartsDefinition(name, realObject, entityNameClass, origin);
    }

    public static void setNamePartsDefinition(@NotNull SQLQueryComplexName name, @NotNull DBSObject realObject, @NotNull SQLQuerySymbolClass entityNameClass, @NotNull SQLQuerySymbolOrigin origin) {
        SQLQuerySemanticUtils.setNamePartsDefinition(name.parts, realObject, entityNameClass, origin);
    }

    private static void setNamePartsDefinition(@NotNull List<SQLQuerySymbolEntry> parts, @NotNull DBSObject realObject, @NotNull SQLQuerySymbolClass entityNameClass, @NotNull SQLQuerySymbolOrigin origin) {
        if (!parts.isEmpty()) {
            SQLQuerySymbolEntry lastPart = parts.getLast();
            lastPart.setDefinition(new SQLQuerySymbolByDbObjectDefinition(realObject, entityNameClass));
            DBSObject object = realObject.getParentObject();
            int scopeNameIndex = parts.size() - 2;
            while (object != null && scopeNameIndex >= 0) {
                SQLQuerySymbolEntry nameEntry = parts.get(scopeNameIndex);
                String objectName = SQLUtils.identifierToCanonicalForm((SQLDialect)object.getDataSource().getSQLDialect(), (String)DBUtils.getQuotedIdentifier((DBSObject)object), (boolean)false, (boolean)true);
                if (objectName.equalsIgnoreCase(nameEntry.getName())) {
                    SQLQuerySymbolClass objectNameClass = SQLQuerySemanticUtils.inferSymbolClass(object);
                    nameEntry.setDefinition(new SQLQuerySymbolByDbObjectDefinition(object, objectNameClass));
                    lastPart.setOrigin(new SQLQuerySymbolOrigin.DbObjectFromDbObject(object, RelationalObjectType.TYPE_UNKNOWN));
                    lastPart = nameEntry;
                    --scopeNameIndex;
                }
                object = object.getParentObject();
            }
            lastPart.setOrigin(origin);
        }
    }

    @NotNull
    public static SQLQuerySymbolClass inferSymbolClass(@NotNull DBSObject object) {
        SQLQuerySymbolClass objectNameClass = object instanceof DBSTable || object instanceof DBSView ? SQLQuerySymbolClass.TABLE : (object instanceof DBSSchema ? SQLQuerySymbolClass.SCHEMA : (object instanceof DBSCatalog ? SQLQuerySymbolClass.CATALOG : SQLQuerySymbolClass.UNKNOWN));
        return objectNameClass;
    }

    @NotNull
    private static SQLQuerySymbol prepareColumnSymbol(@NotNull SQLDialect dialect, @NotNull DBSEntityAttribute attr) {
        String name = SQLUtils.identifierToCanonicalForm((SQLDialect)dialect, (String)attr.getName(), (boolean)false, (boolean)true);
        SQLQuerySymbol symbol = new SQLQuerySymbol(name);
        symbol.setDefinition(new SQLQuerySymbolByDbObjectDefinition((DBSObject)attr, SQLQuerySymbolClass.COLUMN));
        return symbol;
    }

    @NotNull
    public static Pair<List<SQLQueryResultColumn>, List<SQLQueryResultPseudoColumn>> prepareResultColumnsList(@NotNull STMTreeNode cause, @NotNull SQLQueryRowsSourceModel rowsSourceModel, @Nullable DBSEntity table, @NotNull SQLDialect dialect, @NotNull SQLQueryRecognitionContext statistics, @NotNull List<? extends DBSEntityAttribute> attributes) {
        ArrayList<SQLQueryResultColumn> columns = new ArrayList<SQLQueryResultColumn>(attributes.size());
        ArrayList<SQLQueryResultPseudoColumn> pseudoColumns = new ArrayList<SQLQueryResultPseudoColumn>(attributes.size());
        for (DBSEntityAttribute dBSEntityAttribute : attributes) {
            if (DBUtils.isHiddenObject((Object)dBSEntityAttribute)) {
                pseudoColumns.add(new SQLQueryResultPseudoColumn(SQLQuerySemanticUtils.prepareColumnSymbol(dialect, dBSEntityAttribute), rowsSourceModel, table, SQLQuerySemanticUtils.obtainColumnType(cause, statistics, (DBSAttributeBase)dBSEntityAttribute), DBDPseudoAttribute.PropagationPolicy.TABLE_LOCAL, dBSEntityAttribute.getDescription()));
                continue;
            }
            columns.add(new SQLQueryResultColumn(columns.size(), SQLQuerySemanticUtils.prepareColumnSymbol(dialect, dBSEntityAttribute), rowsSourceModel, table, dBSEntityAttribute, SQLQuerySemanticUtils.obtainColumnType(cause, statistics, (DBSAttributeBase)dBSEntityAttribute)));
        }
        return Pair.of(columns, pseudoColumns);
    }

    @NotNull
    private static SQLQueryExprType obtainColumnType(@NotNull STMTreeNode reason, @NotNull SQLQueryRecognitionContext statistics, @NotNull DBSAttributeBase attr) {
        SQLQueryExprType type;
        try {
            type = SQLQueryExprType.forTypedObject(statistics.getMonitor(), (DBSTypedObject)attr, SQLQuerySymbolClass.COLUMN);
        }
        catch (DBException e) {
            log.debug((Object)e);
            statistics.appendError(reason, "Failed to resolve column type for column " + attr.getName(), e);
            type = SQLQueryExprType.UNKNOWN;
        }
        return type;
    }

    public static List<SQLQueryResultPseudoColumn> prepareResultPseudoColumnsList(@NotNull SQLDialect dialect, @Nullable SQLQueryRowsSourceModel source, @Nullable DBSEntity table, @NotNull Stream<DBDPseudoAttribute> pseudoAttributes) {
        return pseudoAttributes.map(a -> new SQLQueryResultPseudoColumn(new SQLQuerySymbol(SQLUtils.identifierToCanonicalForm((SQLDialect)dialect, (String)a.getName(), (boolean)false, (boolean)false)), source, table, SQLQueryExprType.UNKNOWN, a.getPropagationPolicy(), a.getDescription())).collect(Collectors.toList());
    }

    public static void setNamePartsDefinition(@NotNull SQLQueryComplexName name, @NotNull SourceResolutionResult rr, @NotNull SQLQuerySymbolOrigin origin) {
        name.parts.getFirst().setOrigin(origin);
        if (rr.aliasOrNull != null && name.parts.size() == 1) {
            name.parts.getFirst().setDefinition(rr.aliasOrNull.getDefinition());
        } else if (rr.source instanceof SQLQueryRowsTableDataModel) {
            SQLQueryRowsTableDataModel tableModel = (SQLQueryRowsTableDataModel)rr.source;
            SQLQueryComplexName tableName = tableModel.getName();
            if (tableName != null) {
                SQLQuerySymbolEntry part;
                SQLQuerySymbolEntry lastDefSymbolEntry = tableName.parts.getLast();
                int i = name.parts.size() - 1;
                int j = tableName.parts.size() - 1;
                while (i >= 0 && j >= 0) {
                    part = name.parts.get(i);
                    lastDefSymbolEntry = tableName.parts.get(j);
                    part.setDefinition(lastDefSymbolEntry);
                    if (part.getOrigin() == null) {
                        part.setOrigin(lastDefSymbolEntry.getOrigin());
                    }
                    --i;
                    --j;
                }
                while (i >= 0) {
                    part = name.parts.get(i);
                    if (part.getOrigin() == null) {
                        part.setDefinition(lastDefSymbolEntry);
                    }
                    --i;
                }
            }
        } else {
            throw new IllegalStateException("Failed to propagate entity reference definition for " + name.getNameString());
        }
    }

    public static void propagateColumnDefinition(@NotNull SQLQuerySymbolEntry columnName, @Nullable SQLQueryResultColumn resultColumn, @NotNull SQLQueryRecognitionContext statistics, @Nullable SQLQuerySymbolOrigin columnNameOrigin) {
        if (resultColumn != null) {
            columnName.setDefinition(resultColumn.symbol.getDefinition());
        } else {
            columnName.getSymbol().setSymbolClass(SQLQuerySymbolClass.ERROR);
            statistics.appendError(columnName, "Column " + columnName.getName() + " not found");
        }
        columnName.setOrigin(columnNameOrigin);
    }

    @Nullable
    public static SQLQueryExprType tryResolveMemberReference(@NotNull SQLQueryRecognitionContext statistics, @NotNull SQLQueryExprType valueType, @NotNull SQLQuerySymbolEntry identifier, @NotNull SQLQuerySymbolOrigin memberOrigin) {
        SQLQueryExprType type;
        identifier.setOrigin(memberOrigin);
        try {
            type = valueType.findNamedMemberType(statistics.getMonitor(), identifier.getName());
            if (type != null) {
                identifier.setDefinition(type.getDeclaratorDefinition());
            } else {
                identifier.getSymbol().setSymbolClass(SQLQuerySymbolClass.ERROR);
                statistics.appendError(identifier, "Failed to resolve member reference " + identifier.getName() + " for " + valueType.getDisplayName());
            }
        }
        catch (DBException e) {
            log.debug((Object)e);
            statistics.appendError(identifier, "Failed to resolve member reference " + identifier.getName() + " for " + valueType.getDisplayName(), e);
            type = null;
        }
        return type;
    }

    @Nullable
    public static SQLQuerySymbolClass getIdentifierSymbolClass(@Nullable SQLQuerySymbol symbol) {
        return symbol == null ? null : symbol.getSymbolClass();
    }

    @Nullable
    public static SQLQuerySymbolClass getIdentifierSymbolClass(@Nullable SQLQuerySymbolEntry entry) {
        return entry == null ? null : entry.getSymbolClass();
    }

    @Nullable
    public static SQLQuerySymbolClass getIdentifierSymbolClass(@Nullable SQLQueryComplexName name) {
        if (name == null) {
            return null;
        }
        if (name.parts.isEmpty()) {
            return null;
        }
        if (name.parts.size() == 1) {
            SQLQuerySymbolEntry part = name.parts.getFirst();
            return part == null ? null : part.getSymbolClass();
        }
        int i = name.parts.size() - 1;
        while (i >= 0) {
            SQLQuerySymbolEntry part = name.parts.get(i);
            if (part != null) {
                return part.getSymbolClass();
            }
            --i;
        }
        return null;
    }

    @Nullable
    private static String inferObjectTypeName(@NotNull DBSObject object) {
        return knownObjectTypes.stream().filter(t -> t.getTypeClass().isAssignableFrom(object.getClass())).findFirst().map(DBSObjectType::getTypeName).orElse(null);
    }

    @Nullable
    public static String getObjectTypeName(@NotNull DBSObject object) {
        String typeName;
        if (SQLQueryConnectionDummyContext.isDummyObject(object)) {
            typeName = SQLQuerySemanticUtils.inferObjectTypeName(object);
        } else {
            typeName = DBUtils.getObjectTypeName((DBSObject)object);
            if (typeName.equalsIgnoreCase("Object")) {
                typeName = SQLQuerySemanticUtils.inferObjectTypeName(object);
            }
        }
        return typeName;
    }

    @NotNull
    public static String getObjectUniqueName(@NotNull DBSObject o) {
        String string;
        if (o instanceof DBPUniqueObject) {
            DBPUniqueObject uo = (DBPUniqueObject)o;
            string = uo.getUniqueName();
        } else {
            string = o.getName();
        }
        return string;
    }
}

