/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.data.IHexEditorService;
import org.jkiss.dbeaver.ui.editors.binary.BinaryContent;
import org.jkiss.dbeaver.ui.editors.binary.HexEditControl;

public class HexEditorService
implements IHexEditorService {
    private static final Log log = Log.getLog(HexEditorService.class);

    public Control createHexControl(Composite parent, boolean readOnly) {
        HexEditControl hexEditControl = new HexEditControl(parent, readOnly ? 8 : 0, 6, 8);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.minimumWidth = hexEditControl.computeSize((int)-1, (int)-1).x;
        hexEditControl.setLayoutData(gd);
        return hexEditControl;
    }

    public byte[] getHexContent(Control control) {
        HexEditControl hexEditControl = (HexEditControl)control;
        BinaryContent content = hexEditControl.getContent();
        ByteBuffer buffer = ByteBuffer.allocate((int)content.length());
        try {
            content.get(buffer, 0L);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return buffer.array();
    }

    public void setHexContent(Control control, byte[] bytes, String charset) {
        HexEditControl hexEditControl = (HexEditControl)control;
        hexEditControl.setContent(bytes, charset);
    }
}

