/*
 * Decompiled with CFR 0.152.
 */
package org.cts.crs;

import org.cts.IdentifiableComponent;
import org.cts.Identifier;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.cs.CoordinateSystem;
import org.cts.datum.GeodeticDatum;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationException;
import org.cts.op.projection.Projection;

public abstract class GeodeticCRS
extends IdentifiableComponent
implements CoordinateReferenceSystem {
    private GeodeticDatum geodeticDatum;
    protected CoordinateSystem coordinateSystem;

    @Override
    public Projection getProjection() {
        return null;
    }

    protected GeodeticCRS(Identifier identifier, GeodeticDatum datum, CoordinateSystem coordinateSystem) {
        super(identifier);
        this.geodeticDatum = datum;
        this.coordinateSystem = coordinateSystem;
    }

    @Override
    public abstract CoordinateReferenceSystem.Type getType();

    @Override
    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    @Override
    public GeodeticDatum getDatum() {
        return this.geodeticDatum;
    }

    public abstract CoordinateOperation toGeographicCoordinateConverter() throws CoordinateOperationException;

    public abstract CoordinateOperation fromGeographicCoordinateConverter() throws CoordinateOperationException;

    @Override
    public abstract String toWKT();

    @Override
    public String toString() {
        return "[" + this.getAuthorityName() + ":" + this.getAuthorityKey() + "] " + this.getName();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GeodeticCRS) {
            GeodeticCRS crs = (GeodeticCRS)o;
            if (!this.getType().equals((Object)crs.getType())) {
                return false;
            }
            if (this.getIdentifier().equals(crs.getIdentifier())) {
                return true;
            }
            return this.getDatum().equals(crs.getDatum()) && this.getCoordinateSystem().equals(crs.getCoordinateSystem());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.geodeticDatum != null ? this.geodeticDatum.hashCode() : 0);
        hash = 29 * hash + (this.coordinateSystem != null ? this.coordinateSystem.hashCode() : 0);
        return hash;
    }
}

