/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.api;

import java.util.Objects;
import org.jkiss.code.NotNull;

public final class DriverReference {
    public static final DriverReference UNKNOWN = new DriverReference("", "");
    @NotNull
    private final String providerId;
    @NotNull
    private final String driverId;

    public DriverReference(@NotNull String providerId, @NotNull String driverId) {
        this.providerId = providerId;
        this.driverId = driverId;
    }

    @NotNull
    public static DriverReference of(@NotNull String shortId) {
        String[] parts = shortId.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid driver reference: " + shortId + ", must be in a form of provider-id:driver-id");
        }
        return new DriverReference(parts[0], parts[1]);
    }

    @NotNull
    public String shortId() {
        return this.providerId + ":" + this.driverId;
    }

    public String toString() {
        return this.shortId();
    }

    @NotNull
    public String providerId() {
        return this.providerId;
    }

    @NotNull
    public String driverId() {
        return this.driverId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DriverReference that = (DriverReference)obj;
        return Objects.equals(this.providerId, that.providerId) && Objects.equals(this.driverId, that.driverId);
    }

    public int hashCode() {
        return Objects.hash(this.providerId, this.driverId);
    }
}

