/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class DriverLibraryBundle
extends DriverLibraryAbstract {
    public static final String PATH_PREFIX = "bundle:/";
    private static final Log log = Log.getLog(DriverLibraryBundle.class);
    private Bundle bundle;

    public DriverLibraryBundle(DriverDescriptor driver, String path) {
        super(driver, DBPDriverLibrary.FileType.jar, path);
    }

    public DriverLibraryBundle(DriverDescriptor driver, IConfigurationElement config) {
        super(driver, config);
    }

    public DriverLibraryBundle(DriverDescriptor driverDescriptor, DriverLibraryBundle copyFrom) {
        super(driverDescriptor, copyFrom);
    }

    @Override
    @NotNull
    public DBPDriverLibrary copyLibrary(@NotNull DriverDescriptor driverDescriptor) {
        return new DriverLibraryBundle(driverDescriptor, this);
    }

    @Override
    @NotNull
    public DBPDriverLibrary.FileType getType() {
        return DBPDriverLibrary.FileType.jar;
    }

    public boolean isDownloadable() {
        return false;
    }

    public boolean isSecureDownload(@NotNull DBRProgressMonitor monitor) {
        return true;
    }

    @Nullable
    public String getExternalURL(DBRProgressMonitor monitor) {
        return null;
    }

    @Nullable
    public Path getLocalFile() {
        if (this.bundle == null) {
            this.bundle = this.findBundle();
        }
        if (this.bundle == null) {
            return null;
        }
        try {
            String location = this.bundle.getLocation();
            int divPos = location.indexOf("file:");
            if (divPos != -1) {
                String installPath = location.substring(divPos + 5);
                Path localFilePath = RuntimeUtils.getLocalPathFromURL((URL)Platform.getInstallLocation().getURL()).resolve(installPath);
                if (Files.isRegularFile(localFilePath, new LinkOption[0])) {
                    return localFilePath;
                }
                if (Files.isDirectory(localFilePath, new LinkOption[0])) {
                    Path compiledClassesDir = localFilePath.resolve("target").resolve("classes");
                    Path libraryDir = localFilePath.resolve("lib");
                    if (Platform.inDevelopmentMode() && Files.exists(compiledClassesDir, new LinkOption[0])) {
                        return compiledClassesDir;
                    }
                    if (Files.exists(libraryDir, new LinkOption[0])) {
                        return libraryDir;
                    }
                    log.error((Object)("Target path doesn't exist: " + String.valueOf(localFilePath)));
                }
                log.error((Object)("Bundle file not found: " + String.valueOf(localFilePath)));
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        return null;
    }

    private Bundle findBundle() {
        Bundle curBundle = FrameworkUtil.getBundle(this.getClass());
        if (curBundle == null) {
            return null;
        }
        String bundleId = this.getPath().substring(PATH_PREFIX.length());
        BundleContext context = curBundle.getBundleContext();
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equals(bundleId)) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    public Collection<? extends DBPDriverLibrary> getDependencies(@NotNull DBRProgressMonitor monitor) throws IOException {
        return null;
    }

    @NotNull
    public String getDisplayName() {
        return this.path;
    }

    @NotNull
    public String getId() {
        return this.path;
    }

    @NotNull
    public DBIcon getIcon() {
        return DBIcon.JAR;
    }
}

