/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.references;

import java.util.List;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ui.DataEditorFeatures;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ResultSetPanelRefresher;
import org.jkiss.dbeaver.ui.controls.resultset.panel.references.ReferencesResultsContainer;
import org.jkiss.utils.CommonUtils;

public class ReferencesPanel
implements IResultSetPanel {
    private static final String PANEL_ID = "results-references";
    private static final String SETTINGS_SECTION_GROUPING = "panel-results-references";
    private IResultSetPresentation presentation;
    private IDialogSettings panelSettings;
    private Composite referencesPlaceholder;
    private ReferencesResultsContainer resultsContainer;

    @Override
    public Control createContents(final IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        this.panelSettings = ResultSetUtils.getViewerSettings(SETTINGS_SECTION_GROUPING);
        this.loadSettings();
        this.referencesPlaceholder = new Composite(parent, 0);
        this.referencesPlaceholder.setLayout((Layout)new FillLayout());
        ResultSetPanelRefresher.installOn(this, presentation);
        if (presentation instanceof ISelectionProvider) {
            ISelectionChangedListener selectionListener = new ISelectionChangedListener(){
                private List<ResultSetRow> prevSelection;

                public void selectionChanged(SelectionChangedEvent event) {
                    if (presentation.getController().getVisiblePanel() != ReferencesPanel.this) {
                        return;
                    }
                    if (!(event.getSelection() instanceof IResultSetSelection)) {
                        return;
                    }
                    List<ResultSetRow> selectedItems = ((IResultSetSelection)event.getSelection()).getSelectedRows();
                    if (CommonUtils.equalObjects(this.prevSelection, selectedItems)) {
                        return;
                    }
                    this.prevSelection = selectedItems;
                    ReferencesPanel.this.getResultsContainer().refreshReferences(false);
                }
            };
            ((ISelectionProvider)presentation).addSelectionChangedListener(selectionListener);
            presentation.getControl().addDisposeListener(e -> ((ISelectionProvider)presentation).removeSelectionChangedListener(selectionListener));
        }
        DataEditorFeatures.RESULT_SET_PANEL_REFS.use();
        return this.referencesPlaceholder;
    }

    private ReferencesResultsContainer getResultsContainer() {
        if (this.resultsContainer == null) {
            this.resultsContainer = new ReferencesResultsContainer(this.referencesPlaceholder, this.presentation.getController());
            this.referencesPlaceholder.layout(true, true);
        }
        return this.resultsContainer;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    private void updateControls() {
        this.presentation.getController().updatePanelActions();
    }

    private void loadSettings() {
        this.panelSettings.getSection("references");
    }

    private void saveSettings() {
        UIUtils.getSettingsSection((IDialogSettings)this.panelSettings, (String)"references");
    }

    @Override
    public void activatePanel() {
        this.refresh(false);
    }

    @Override
    public void deactivatePanel() {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void refresh(boolean force) {
        if (this.presentation.getController().getVisiblePanel() == this) {
            this.getResultsContainer().refreshReferences(force);
        }
    }

    public void contributeActions(IContributionManager manager) {
    }
}

