/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.internal.ui.palette.editparts.ColumnsLayout;
import org.eclipse.gef.internal.ui.palette.editparts.PaletteContainerFlowLayout;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;

public class GroupEditPart
extends PaletteEditPart {
    private static final Border SCROLL_PANE_BORDER = new MarginBorder(2, 2, 2, 2);
    private static final Border SCROLL_PANE_LIST_BORDER = new MarginBorder(2, 0, 2, 0);
    private int cachedLayout = -1;

    public GroupEditPart(PaletteContainer group) {
        super(group);
    }

    @Override
    public IFigure createFigure() {
        Figure figure = new Figure();
        figure.setOpaque(true);
        figure.setBackgroundColor(this.getColorProvider().getListBackground());
        return figure;
    }

    @Override
    protected void refreshVisuals() {
        PaletteContainerFlowLayout manager;
        int layout = this.getLayoutSetting();
        if (this.cachedLayout == layout) {
            return;
        }
        this.cachedLayout = layout;
        if (layout == 1) {
            manager = new ColumnsLayout();
            this.getContentPane().setBorder(SCROLL_PANE_BORDER);
        } else if (layout == 2) {
            PaletteContainerFlowLayout flow = new PaletteContainerFlowLayout();
            flow.setMajorSpacing(0);
            flow.setMinorSpacing(0);
            manager = flow;
            this.getContentPane().setBorder(SCROLL_PANE_BORDER);
        } else {
            manager = new ToolbarLayout();
            this.getContentPane().setBorder(SCROLL_PANE_LIST_BORDER);
        }
        this.getContentPane().setLayoutManager((LayoutManager)manager);
    }
}

