/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class AbstractTrackingJob
extends AbstractJob {
    private DBRProgressMonitor ownerMonitor;
    protected Throwable connectError;

    protected AbstractTrackingJob(String name) {
        super(name);
        this.setUser(false);
        this.setSystem(true);
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        if (this.ownerMonitor != null) {
            monitor = this.ownerMonitor;
        }
        try {
            this.execute(monitor);
        }
        catch (Throwable e) {
            this.connectError = e;
        }
        return Status.OK_STATUS;
    }

    public void setOwnerMonitor(@Nullable DBRProgressMonitor ownerMonitor) {
        this.ownerMonitor = ownerMonitor;
    }

    @Nullable
    public Throwable getConnectError() {
        return this.connectError;
    }

    protected abstract void execute(@NotNull DBRProgressMonitor var1) throws Throwable;

    public static void executeInProgressMonitor(AbstractTrackingJob job) throws InvocationTargetException {
        UIUtils.runInProgressDialog(monitor -> {
            job.setOwnerMonitor(monitor);
            job.schedule();
            while (job.getState() == 2 || job.getState() == 4) {
                if (monitor.isCanceled()) {
                    job.cancel();
                    throw new InvocationTargetException(null);
                }
                RuntimeUtils.pause((int)50);
            }
            if (job.getConnectError() != null) {
                throw new InvocationTargetException(job.getConnectError());
            }
        });
    }
}

