/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.EditorPart;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;

public class ProgressEditorPart
extends EditorPart {
    private final IDatabaseEditor ownerEditor;
    private Composite parentControl;
    private Composite progressCanvas;
    private volatile LoadingJob<IDatabaseEditorInput> pendingJob;

    public ProgressEditorPart(IDatabaseEditor ownerEditor) {
        this.ownerEditor = ownerEditor;
    }

    public DatabaseLazyEditorInput getEditorInput() {
        return (DatabaseLazyEditorInput)super.getEditorInput();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void createPartControl(Composite parent) {
        this.parentControl = parent;
        this.createProgressPane(parent);
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.parentControl.setFocus();
    }

    public void setPartName(String newName) {
        super.setPartName(newName);
    }

    public void dispose() {
        super.dispose();
        this.parentControl = null;
    }

    private void createProgressPane(Composite parent) {
        DatabaseLazyEditorInput input = this.getEditorInput();
        this.progressCanvas = new Composite(parent, 0);
        if (input.canLoadImmediately()) {
            this.scheduleEditorLoad();
        } else {
            this.createInitializerPlaceholder();
        }
    }

    public synchronized boolean scheduleEditorLoad() {
        if (this.pendingJob != null) {
            return false;
        }
        InitNodeService loadingService = new InitNodeService();
        this.pendingJob = LoadingJob.createService((ILoadService)loadingService, (ILoadVisualizer)new InitNodeVisualizer(loadingService));
        UIExecutionQueue.queueExec(() -> this.pendingJob.schedule());
        return true;
    }

    private void createInitializerPlaceholder() {
        Button button = new Button(this.progressCanvas, 8);
        button.setText(EditorsMessages.progress_editor_uninitialized_text);
        button.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_CONNECT));
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Control[] controlArray = this.progressCanvas.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
            this.scheduleEditorLoad();
        }));
        Point buttonSize = button.computeSize(-1, -1);
        ControlEditor progressOverlay = new ControlEditor(this.progressCanvas);
        progressOverlay.minimumWidth = buttonSize.x;
        progressOverlay.minimumHeight = buttonSize.y;
        progressOverlay.setEditor((Control)button);
    }

    private void initEntityEditor(IDatabaseEditorInput result) {
        if (result == null) {
            return;
        }
        try {
            this.ownerEditor.init(this.ownerEditor.getEditorSite(), result);
            this.ownerEditor.recreateEditorControl();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Editor init", "Can't initialize editor", (Throwable)e);
        }
    }

    public Composite destroyAndReturnParent() {
        Composite parent = this.progressCanvas.getParent();
        this.progressCanvas.dispose();
        return parent;
    }

    private class InitNodeService
    extends AbstractLoadService<IDatabaseEditorInput> {
        protected InitNodeService() {
            super("Initialize entity editor");
        }

        public IDatabaseEditorInput evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                IDatabaseEditorInput iDatabaseEditorInput = ProgressEditorPart.this.getEditorInput().initializeRealInput(monitor);
                return iDatabaseEditorInput;
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
            finally {
                ProgressEditorPart.this.pendingJob = null;
            }
        }

        public Object getFamily() {
            return null;
        }
    }

    private class InitNodeVisualizer
    extends ProgressLoaderVisualizer<IDatabaseEditorInput>
    implements PaintListener {
        public InitNodeVisualizer(InitNodeService loadingService) {
            super((ILoadService)loadingService, ProgressEditorPart.this.progressCanvas);
            ProgressEditorPart.this.progressCanvas.addPaintListener((PaintListener)this);
        }

        public void completeLoading(IDatabaseEditorInput result) {
            super.completeLoading((Object)result);
            super.visualizeLoading();
            if (!ProgressEditorPart.this.progressCanvas.isDisposed()) {
                ProgressEditorPart.this.progressCanvas.removePaintListener((PaintListener)this);
            }
            ProgressEditorPart.this.initEntityEditor(result);
            if (result == null) {
                UIUtils.asyncExec(() -> {
                    IWorkbenchPage activePage;
                    IWorkbenchWindow workbenchWindow = ProgressEditorPart.this.ownerEditor.getSite().getWorkbenchWindow();
                    if (workbenchWindow != null && (activePage = workbenchWindow.getActivePage()) != null) {
                        activePage.closeEditor((IEditorPart)ProgressEditorPart.this.ownerEditor, false);
                    }
                });
            } else {
                UIUtils.asyncExec(() -> EditorUtils.refreshPartContexts((IWorkbenchPart)ProgressEditorPart.this.ownerEditor));
            }
            ActionUtils.evaluatePropertyState((String)"org.jkiss.dbeaver.ui.editors.entity.hasSource");
        }

        public void paintControl(PaintEvent e) {
            e.gc.drawText(NLS.bind((String)EditorsMessages.progress_editor_initializing_text, (Object)ProgressEditorPart.this.getEditorInput().getName()), 5, 5, true);
        }
    }
}

