/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.file;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.editors.file.FileTypeHandlerDescriptor;

public class FileTypeHandlerRegistry {
    private static FileTypeHandlerRegistry instance = null;
    private final List<FileTypeHandlerDescriptor> handlers = new ArrayList<FileTypeHandlerDescriptor>();
    private final Map<String, FileTypeHandlerDescriptor> handlerByExtension = new HashMap<String, FileTypeHandlerDescriptor>();

    public static synchronized FileTypeHandlerRegistry getInstance() {
        if (instance == null) {
            instance = new FileTypeHandlerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private FileTypeHandlerRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.ui.fileTypeHandler");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            FileTypeHandlerDescriptor formatterDescriptor = new FileTypeHandlerDescriptor(ext);
            this.handlers.add(formatterDescriptor);
            String[] stringArray = formatterDescriptor.getExtensions();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String fileExt = stringArray[n4];
                this.handlerByExtension.put(fileExt, formatterDescriptor);
                ++n4;
            }
            ++n2;
        }
        this.handlers.sort(Comparator.comparingInt(FileTypeHandlerDescriptor::getOrder));
    }

    @NotNull
    public List<FileTypeHandlerDescriptor> getHandlers() {
        return this.handlers;
    }

    @Nullable
    public FileTypeHandlerDescriptor findHandler(String fileExtension) {
        return this.handlerByExtension.get(fileExtension);
    }
}

