/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import com.google.gson.annotations.SerializedName;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIBaseProperties;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class OpenAIProperties
implements OpenAIBaseProperties {
    @SecureProperty
    @SerializedName(value="gpt.token")
    private String token;
    @SerializedName(value="gpt.model")
    private String model;
    @SerializedName(value="gpt.model.temperature")
    private double temperature;
    @SerializedName(value="gpt.log.query")
    private boolean loggingEnabled;

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getModel() {
        if (this.fallbackToPrefStore()) {
            return DBWorkbench.getPlatform().getPreferenceStore().getString("gpt.model");
        }
        return this.model;
    }

    @Override
    public double getTemperature() {
        if (this.fallbackToPrefStore()) {
            return DBWorkbench.getPlatform().getPreferenceStore().getDouble("gpt.model.temperature");
        }
        return this.temperature;
    }

    @Override
    public boolean isLoggingEnabled() {
        if (this.fallbackToPrefStore()) {
            return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("gpt.log.query");
        }
        return this.loggingEnabled;
    }

    @Override
    public void resolveSecrets() throws DBException {
        this.token = AIUtils.getSecretValueOrDefault("gpt.token", this.token);
    }

    @Override
    public void saveSecrets() throws DBException {
        if (this.token != null) {
            DBSSecretController.getGlobalSecretController().setPrivateSecretValue("gpt.token", this.token);
        }
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    private boolean fallbackToPrefStore() {
        return this.model == null;
    }
}

